
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_20_LATIN_SUP != 0    /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 20 px Font in U+00a0 ( ) .. U+00ff (ÿ)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_20_latin_sup_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_20_LATIN_SUP == 1
    /*Unicode: U+00a0 ( ) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00a1 (¡) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..


    /*Unicode: U+00a2 (¢) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x04,  //.....@..
    0x04,  //.....@..
    0x04,  //.....@..
    0x1e,  //..+%@@@+
    0x7f,  //.%@@@@@@
    0x65,  //+@@+.@.%
    0xc4,  //@@+..@..
    0xc4,  //@@...@..
    0xc4,  //@@...@..
    0xc4,  //@@+..@..
    0x65,  //+@@+.@.%
    0x7f,  //.%@@@@@@
    0x1e,  //..+%@@@+
    0x04,  //.....@..
    0x04,  //.....@..
    0x04,  //.....@..
    0x00,  //........


    /*Unicode: U+00a3 (£) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x0f, 0x00,  //...+%@@%.
    0x1f, 0x80,  //...@@@@@@
    0x38, 0x80,  //..%@%...%
    0x30, 0x00,  //..@@.....
    0x30, 0x00,  //..@@.....
    0x30, 0x00,  //..@@.....
    0xfe, 0x00,  //@@@@@@@..
    0xfe, 0x00,  //@@@@@@@..
    0x30, 0x00,  //..@@.....
    0x30, 0x00,  //..@@.....
    0x30, 0x00,  //..@@.....
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+00a4 (¤) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x80, 0x80,  //%+.....+%
    0x6b, 0x00,  //+@%+@+%@+
    0x7f, 0x00,  //.%@@@@@%.
    0x22, 0x00,  //.+@+.+@+.
    0x63, 0x00,  //.@@...@@.
    0x22, 0x00,  //.+@+.+@+.
    0x7f, 0x00,  //.%@@@@@%.
    0x6b, 0x00,  //+@%+@+%@+
    0x80, 0x80,  //%+.....+%
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+00a5 (¥) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //%@+....+@%
    0x61, 0x80,  //.@@....@@.
    0x61, 0x80,  //.%@+..+@%.
    0x33, 0x00,  //..@@..@@..
    0x33, 0x00,  //..%@++@%..
    0xff, 0xc0,  //@@@@%%@@@@
    0x1e, 0x00,  //...%@@%...
    0x0c, 0x00,  //....@@....
    0xff, 0xc0,  //@@@@@@@@@@
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00a6 (¦) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..


    /*Unicode: U+00a7 (§) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x3c,  //..%@@@.
    0x7c,  //.%@@@@.
    0x60,  //.@@+...
    0x60,  //.%@....
    0x30,  //..@%...
    0x78,  //+@%%@+.
    0xcc,  //@@..%@+
    0xc6,  //@@...@@
    0x66,  //+@%..@@
    0x3c,  //..@%@@.
    0x18,  //...%@..
    0x0c,  //....@@.
    0x0c,  //...+@@.
    0x7c,  //.@@@@%.
    0x78,  //.@@@%..
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00a8 (¨) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0xcc,  //@@..@@
    0xcc,  //@@..@@
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00a9 (©) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@%....
    0x30, 0x60,  //..%@+...+@%..
    0x60, 0x30,  //.%%.......%%.
    0x47, 0x90,  //.@..+@@@@..@.
    0x88, 0x08,  //%+.+@......+%
    0x90, 0x08,  //@..@........@
    0x90, 0x08,  //@..@........@
    0x90, 0x08,  //@..@........@
    0x88, 0x88,  //%+.+@+..%..+%
    0x47, 0x10,  //.@..+@@@+..@.
    0x60, 0x30,  //.%%.......%%.
    0x30, 0x60,  //..%@+...+@%..
    0x0f, 0x80,  //....%@@@%....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00aa (ª) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x7c,  //.@@@@%..
    0x02,  //.....+@.
    0x7e,  //.%@@@@@.
    0xc2,  //%%....@.
    0x82,  //@....+@.
    0xc6,  //@%..+@@.
    0x7a,  //.%@@@+@.
    0x00,  //........
    0xfe,  //%@@@@@@.
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00ab («) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x11,  //...%...%
    0x33,  //..%@..%@
    0x66,  //.%%..%%.
    0xcc,  //@%..@%..
    0xcc,  //@%..@%..
    0x66,  //.%%..%%.
    0x33,  //..%@..%@
    0x11,  //...%...%
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00ac (¬) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x00, 0x60,  //.........@@
    0x00, 0x60,  //.........@@
    0x00, 0x60,  //.........@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+00ad (­) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf8,  //@@@@@
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00ae (®) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x0f, 0x80,  //....%@@@%....
    0x30, 0x60,  //..%@+...+@%..
    0x60, 0x30,  //.%%.......%%.
    0x4f, 0x10,  //.@..@@@@+..@.
    0x88, 0x88,  //%+..@..+@..+%
    0x88, 0x88,  //@...@..+@...@
    0x8f, 0x08,  //@...@@@@+...@
    0x89, 0x08,  //@...@.+@....@
    0x88, 0x88,  //%+..@..+@..+%
    0x48, 0xd0,  //.@..@...@%.@.
    0x60, 0x30,  //.%%.......%%.
    0x30, 0x60,  //..%@+...+@%..
    0x0f, 0x80,  //....%@@@%....
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00af (¯) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf8,  //@@@@@
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00b0 (°) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x78,  //.%@@%.
    0xcc,  //%%..%%
    0x84,  //@....@
    0x84,  //@....@
    0xcc,  //%%..%%
    0x78,  //.%@@%.
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00b1 (±) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00b2 (²) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x70,  //+@@@.
    0x88,  //%..+@
    0x08,  //....@
    0x10,  //...@.
    0x20,  //..@+.
    0x40,  //+@+..
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00b3 (³) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf0,  //@@@@+
    0x08,  //...+@
    0x70,  //.@@@+
    0x18,  //...%@
    0x08,  //....@
    0x18,  //...+@
    0xf0,  //@@@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00b4 (´) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x30,  //..@%
    0x60,  //.@%.
    0xc0,  //%%..
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00b5 (µ) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc3, 0x00,  //@@....@@.
    0xc3, 0x00,  //@@....@@.
    0xc3, 0x00,  //@@....@@.
    0xc3, 0x00,  //@@....@@.
    0xc3, 0x00,  //@@....@@.
    0xc3, 0x00,  //@@....@@.
    0xc3, 0x00,  //@@....@@.
    0xe7, 0x00,  //@@%..%@@.
    0xff, 0x80,  //@@@@@@@@@
    0xd9, 0x80,  //@@.@@.+@%
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......


    /*Unicode: U+00b6 (¶) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x3f,  //..%@@@@@
    0x79,  //+@@@@..@
    0xf9,  //@@@@@..@
    0xf9,  //@@@@@..@
    0xf9,  //@@@@@..@
    0xf9,  //%@@@@..@
    0x79,  //.%@@@..@
    0x09,  //...+@..@
    0x09,  //....@..@
    0x09,  //....@..@
    0x09,  //....@..@
    0x09,  //....@..@
    0x09,  //....@..@
    0x09,  //....@..@
    0x09,  //....@..@
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00b7 (·) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b8 (¸) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x20,  //..@+
    0x30,  //..@@
    0xf0,  //@@@+
    0x00,  //....


    /*Unicode: U+00b9 (¹) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xe0,  //@@@..
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00ba (º) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x38,  //.+@@@+.
    0x44,  //+@...@+
    0x82,  //@.....@
    0x82,  //@.....@
    0x82,  //@.....@
    0x44,  //+@...@+
    0x38,  //.+@@@+.
    0x00,  //.......
    0xfe,  //%@@@@@%
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00bb (») , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x88,  //%...%...
    0xcc,  //@%..@%..
    0x66,  //.%%..%%.
    0x33,  //..%@..%@
    0x33,  //..%@..%@
    0x66,  //.%%..%%.
    0xcc,  //@%..@%..
    0x88,  //%...%...
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00bc (¼) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xe0, 0x18,  //@@@........%%...
    0x20, 0x10,  //..@........@....
    0x20, 0x20,  //..@.......@+....
    0x20, 0x60,  //..@......%%.....
    0x20, 0x40,  //..@......@......
    0x20, 0x80,  //..@.....@+......
    0xf9, 0x86,  //@@@@@..%%....@@.
    0x01, 0x0a,  //......+@....%+@.
    0x02, 0x12,  //......@....%+.@.
    0x06, 0x22,  //.....%%...%+..@.
    0x04, 0x3f,  //....+@....@@@@@@
    0x08, 0x02,  //....@.........@.
    0x18, 0x02,  //...%%.........@.
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00bd (½) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0xe0, 0x18,  //@@@........%%..
    0x20, 0x10,  //..@........@...
    0x20, 0x20,  //..@.......@+...
    0x20, 0x60,  //..@......%%....
    0x20, 0x40,  //..@......@.....
    0x20, 0x80,  //..@.....@+.....
    0xf9, 0x9c,  //@@@@@..%%.+@@@.
    0x01, 0x22,  //......+@..%..+@
    0x02, 0x02,  //......@.......@
    0x06, 0x04,  //.....%%......@.
    0x04, 0x08,  //....+@......@+.
    0x08, 0x10,  //....@.....+@+..
    0x18, 0x3e,  //...%%.....@@@@@
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00be (¾) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xf0, 0x18,  //@@@@+......%%...
    0x08, 0x10,  //...+@......@....
    0x70, 0x20,  //.@@@+.....@+....
    0x18, 0x60,  //...%@....%%.....
    0x08, 0x40,  //....@....@......
    0x18, 0x80,  //...+@...@+......
    0xf1, 0x86,  //@@@%...%%....@@.
    0x01, 0x0a,  //......+@....%+@.
    0x02, 0x12,  //......@....%+.@.
    0x06, 0x22,  //.....%%...%+..@.
    0x04, 0x3f,  //....+@....@@@@@@
    0x08, 0x02,  //....@.........@.
    0x18, 0x02,  //...%%.........@.
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00bf (¿) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x18,  //...@@..
    0x18,  //...@@..
    0x00,  //.......
    0x18,  //...@@..
    0x18,  //...@@..
    0x18,  //...@@..
    0x30,  //..%@+..
    0x30,  //.+@%...
    0x60,  //.@%....
    0xc0,  //@@.....
    0xc0,  //@@.....
    0xe2,  //@@%..+@
    0x7e,  //+@@@@@@
    0x3c,  //.+@@@%.


    /*Unicode: U+00c0 (À) , Width: 12 */
    0x06, 0x00,  //....+@@.....
    0x03, 0x00,  //.....+@@....
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@@+....
    0x0f, 0x00,  //....@@@@....
    0x0f, 0x00,  //....@@@@....
    0x19, 0x80,  //...%@++@%...
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //..+@%..%@+..
    0x30, 0xc0,  //..@@....@@..
    0x3f, 0xc0,  //..@@@@@@@@..
    0x7f, 0xe0,  //.%@@@@@@@@%.
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //+@%......%@+
    0xc0, 0x30,  //@@+......+@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00c1 (Á) , Width: 12 */
    0x03, 0x00,  //......%@....
    0x06, 0x00,  //.....%@.....
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@@+....
    0x0f, 0x00,  //....@@@@....
    0x0f, 0x00,  //....@@@@....
    0x19, 0x80,  //...%@++@%...
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //..+@%..%@+..
    0x30, 0xc0,  //..@@....@@..
    0x3f, 0xc0,  //..@@@@@@@@..
    0x7f, 0xe0,  //.%@@@@@@@@%.
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //+@%......%@+
    0xc0, 0x30,  //@@+......+@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00c2 (Â) , Width: 12 */
    0x06, 0x00,  //.....@@.....
    0x09, 0x00,  //....%++%....
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@@+....
    0x0f, 0x00,  //....@@@@....
    0x0f, 0x00,  //....@@@@....
    0x19, 0x80,  //...%@++@%...
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //..+@%..%@+..
    0x30, 0xc0,  //..@@....@@..
    0x3f, 0xc0,  //..@@@@@@@@..
    0x7f, 0xe0,  //.%@@@@@@@@%.
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //+@%......%@+
    0xc0, 0x30,  //@@+......+@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00c3 (Ã) , Width: 12 */
    0x0c, 0x80,  //...+@@+.@...
    0x13, 0x00,  //...@.+@@+...
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@@+....
    0x0f, 0x00,  //....@@@@....
    0x0f, 0x00,  //....@@@@....
    0x19, 0x80,  //...%@++@%...
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //..+@%..%@+..
    0x30, 0xc0,  //..@@....@@..
    0x3f, 0xc0,  //..@@@@@@@@..
    0x7f, 0xe0,  //.%@@@@@@@@%.
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //+@%......%@+
    0xc0, 0x30,  //@@+......+@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00c4 (Ä) , Width: 12 */
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //...@@..@@...
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@@+....
    0x0f, 0x00,  //....@@@@....
    0x0f, 0x00,  //....@@@@....
    0x19, 0x80,  //...%@++@%...
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //..+@%..%@+..
    0x30, 0xc0,  //..@@....@@..
    0x3f, 0xc0,  //..@@@@@@@@..
    0x7f, 0xe0,  //.%@@@@@@@@%.
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //+@%......%@+
    0xc0, 0x30,  //@@+......+@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00c5 (Å) , Width: 12 */
    0x09, 0x00,  //....@++@....
    0x09, 0x00,  //....@..@....
    0x09, 0x00,  //....@++@....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@@+....
    0x0f, 0x00,  //....%@@%....
    0x0f, 0x00,  //....@@@@....
    0x19, 0x80,  //...%@++@%...
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //..+@%..%@+..
    0x30, 0xc0,  //..@@+..+@@..
    0x3f, 0xc0,  //..@@@@@@@@..
    0x7f, 0xe0,  //.%@@@@@@@@%.
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //@@+......+@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00c6 (Æ) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x07, 0xff,  //.....%@@@@@@@@@@
    0x07, 0xff,  //.....@@@@@@@@@@@
    0x06, 0xc0,  //....+@%.@@......
    0x0c, 0xc0,  //....@@..@@......
    0x0c, 0xc0,  //...+@%..@@......
    0x18, 0xff,  //...@@...@@@@@@@@
    0x18, 0xff,  //...@@...@@@@@@@@
    0x30, 0xc0,  //..%@+...@@......
    0x3f, 0xc0,  //..@@@@@@@@......
    0x3f, 0xc0,  //.+@@@@@@@@......
    0x60, 0xc0,  //.@@.....@@......
    0x60, 0xff,  //+@@.....@@@@@@@@
    0xc0, 0xff,  //@@+.....@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+00c7 (Ç) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x0f, 0xc0,  //...+%@@@@%.
    0x3f, 0xe0,  //..@@@@@@@@@
    0x70, 0x20,  //.@@@+....+@
    0x60, 0x00,  //+@@........
    0xc0, 0x00,  //%@+........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //%@+........
    0x60, 0x00,  //+@@........
    0x70, 0x20,  //.@@@+....+@
    0x3f, 0xe0,  //..@@@@@@@@@
    0x0f, 0xc0,  //...+%@@@@%.
    0x01, 0x00,  //.......@+..
    0x01, 0x80,  //.......@@..
    0x07, 0x80,  //.....@@@+..
    0x00, 0x00,  //...........


    /*Unicode: U+00c8 (È) , Width: 8 */
    0x30,  //.+@@....
    0x18,  //..+@@...
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00c9 (É) , Width: 8 */
    0x18,  //...%@...
    0x30,  //..%@....
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00ca (Ê) , Width: 8 */
    0x38,  //..%@%...
    0x6c,  //.%%.%%..
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00cb (Ë) , Width: 8 */
    0x66,  //.@@..@@.
    0x66,  //.@@..@@.
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00cc (Ì) , Width: 5 */
    0x60,  //+@@..
    0x30,  //.+@@.
    0x00,  //.....
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x30,  //..@@.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00cd (Í) , Width: 4 */
    0x60,  //.%@.
    0xc0,  //%@..
    0x00,  //....
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ce (Î) , Width: 6 */
    0x30,  //.+@@+.
    0x48,  //+@..@+
    0x00,  //......
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00cf (Ï) , Width: 6 */
    0xcc,  //@@..@@
    0xcc,  //@@..@@
    0x00,  //......
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00d0 (Ð) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x3f, 0x80,  //..@@@@@@%+...
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x30, 0x70,  //..@@....+@@@.
    0x30, 0x38,  //..@@......@@+
    0x30, 0x18,  //..@@......+@@
    0xfe, 0x18,  //@@@@@@@....@@
    0xfe, 0x18,  //@@@@@@@....@@
    0x30, 0x18,  //..@@.......@@
    0x30, 0x18,  //..@@......+@@
    0x30, 0x30,  //..@@......@@+
    0x30, 0x70,  //..@@....+@@@.
    0x3f, 0xe0,  //..@@@@@@@@@..
    0x3f, 0x80,  //..@@@@@@%+...
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+00d1 (Ñ) , Width: 10 */
    0x19, 0x00,  //..+@@+.@..
    0x26, 0x00,  //..@.+@@+..
    0x00, 0x00,  //..........
    0xe0, 0xc0,  //@@%.....@@
    0xe0, 0xc0,  //@@@.....@@
    0xf0, 0xc0,  //@@@%....@@
    0xf0, 0xc0,  //@@%@+...@@
    0xd8, 0xc0,  //@@.@@...@@
    0xd8, 0xc0,  //@@.%@+..@@
    0xcc, 0xc0,  //@@..@@..@@
    0xc6, 0xc0,  //@@..+@%.@@
    0xc6, 0xc0,  //@@...@@.@@
    0xc3, 0xc0,  //@@...+@@@@
    0xc3, 0xc0,  //@@....%@@@
    0xc1, 0xc0,  //@@.....@@@
    0xc1, 0xc0,  //@@.....%@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00d2 (Ò) , Width: 12 */
    0x06, 0x00,  //....+@@.....
    0x03, 0x00,  //.....+@@....
    0x00, 0x00,  //............
    0x0f, 0x80,  //...+@@@@+...
    0x3f, 0xc0,  //..@@@@@@@@..
    0x70, 0xe0,  //.@@@+..+@@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //%@+......+@%
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //%@+......+@%
    0x60, 0x60,  //+@@......@@+
    0x70, 0xe0,  //.@@@+..+@@@.
    0x3f, 0xc0,  //..@@@@@@@@..
    0x1f, 0x80,  //...+@@@@+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00d3 (Ó) , Width: 12 */
    0x03, 0x00,  //......%@....
    0x06, 0x00,  //.....%@.....
    0x00, 0x00,  //............
    0x0f, 0x80,  //...+@@@@+...
    0x3f, 0xc0,  //..@@@@@@@@..
    0x70, 0xe0,  //.@@@+..+@@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //%@+......+@%
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //%@+......+@%
    0x60, 0x60,  //+@@......@@+
    0x70, 0xe0,  //.@@@+..+@@@.
    0x3f, 0xc0,  //..@@@@@@@@..
    0x1f, 0x80,  //...+@@@@+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00d4 (Ô) , Width: 12 */
    0x06, 0x00,  //.....@@.....
    0x09, 0x00,  //....%++%....
    0x00, 0x00,  //............
    0x0f, 0x80,  //...+@@@@+...
    0x3f, 0xc0,  //..@@@@@@@@..
    0x70, 0xe0,  //.@@@+..+@@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //%@+......+@%
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //%@+......+@%
    0x60, 0x60,  //+@@......@@+
    0x70, 0xe0,  //.@@@+..+@@@.
    0x3f, 0xc0,  //..@@@@@@@@..
    0x1f, 0x80,  //...+@@@@+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00d5 (Õ) , Width: 12 */
    0x0c, 0x80,  //...+@@+.@...
    0x13, 0x00,  //...@.+@@+...
    0x00, 0x00,  //............
    0x0f, 0x80,  //...+@@@@+...
    0x3f, 0xc0,  //..@@@@@@@@..
    0x70, 0xe0,  //.@@@+..+@@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //%@+......+@%
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //%@+......+@%
    0x60, 0x60,  //+@@......@@+
    0x70, 0xe0,  //.@@@+..+@@@.
    0x3f, 0xc0,  //..@@@@@@@@..
    0x1f, 0x80,  //...+@@@@+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00d6 (Ö) , Width: 12 */
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //...@@..@@...
    0x00, 0x00,  //............
    0x0f, 0x80,  //...+@@@@+...
    0x3f, 0xc0,  //..@@@@@@@@..
    0x70, 0xe0,  //.@@@+..+@@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //%@+......+@%
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //%@+......+@%
    0x60, 0x60,  //+@@......@@+
    0x70, 0xe0,  //.@@@+..+@@@.
    0x3f, 0xc0,  //..@@@@@@@@..
    0x1f, 0x80,  //...+@@@@+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00d7 (×) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x40, 0x80,  //.@+....+@.
    0xe1, 0xc0,  //%@@+..+@@%
    0x73, 0x80,  //.%@@++@@%.
    0x3f, 0x00,  //..%@@@@%..
    0x1e, 0x00,  //...%@@%...
    0x1e, 0x00,  //...%@@%...
    0x3f, 0x00,  //..%@@@@%..
    0x73, 0x80,  //.%@@++@@%.
    0xe1, 0xc0,  //%@@+..+@@%
    0x40, 0x80,  //.@+....+@.
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00d8 (Ø) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x0f, 0x88,  //....%@@@%..+@.
    0x1f, 0xd0,  //...@@@@@@@+@+.
    0x38, 0x70,  //..@@@+..+@@%..
    0x70, 0x70,  //.%@@.....@@@..
    0x60, 0xd8,  //.@@+....@%+@%.
    0x61, 0x98,  //.@@....%%..@@.
    0x63, 0x18,  //.@@...%%...@@.
    0x66, 0x18,  //.@@..%%....@@.
    0x6c, 0x18,  //.%@+%@....+@@.
    0x38, 0x38,  //..@@@.....@@%.
    0x38, 0x70,  //..%@@+..+@@@..
    0x2f, 0xe0,  //.+@+@@@@@@@...
    0x47, 0xc0,  //.@+..%@@@%....
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+00d9 (Ù) , Width: 10 */
    0x18, 0x00,  //..+@@.....
    0x0c, 0x00,  //...+@@....
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.@@@@@@@@.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00da (Ú) , Width: 10 */
    0x0c, 0x00,  //....%@....
    0x18, 0x00,  //...%@.....
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.@@@@@@@@.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00db (Û) , Width: 10 */
    0x0c, 0x00,  //....@@....
    0x12, 0x00,  //...%++%...
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.@@@@@@@@.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00dc (Ü) , Width: 10 */
    0x33, 0x00,  //..@@..@@..
    0x33, 0x00,  //..@@..@@..
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.@@@@@@@@.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00dd (Ý) , Width: 12 */
    0x06, 0x00,  //.....%@.....
    0x0c, 0x00,  //....%@......
    0x00, 0x00,  //............
    0xe0, 0x70,  //%@@......@@%
    0x60, 0x60,  //.@@+....+@@.
    0x30, 0xc0,  //..@@....@@..
    0x19, 0x80,  //..+@%..%@+..
    0x19, 0x80,  //...%@++@%...
    0x0f, 0x00,  //....@@@@....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00de (Þ) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xc0,  //@@......
    0xc0,  //@@......
    0xfc,  //@@@@@%+.
    0xfe,  //@@@@@@@+
    0xc7,  //@@...%@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc7,  //@@...%@@
    0xfe,  //@@@@@@@+
    0xfc,  //@@@@@@+.
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00df (ß) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x3c, 0x00,  //.+%@@@+..
    0x7e, 0x00,  //+@@@@@@..
    0xe7, 0x00,  //@@%..%@%.
    0xc3, 0x00,  //@@....@@.
    0xc6, 0x00,  //@@..+@@+.
    0xcc, 0x00,  //@@..@@...
    0xcc, 0x00,  //@@..@@...
    0xc6, 0x00,  //@@...@%..
    0xc3, 0x00,  //@@....@@.
    0xc1, 0x80,  //@@.....@%
    0xc1, 0x80,  //@@.....@@
    0xd1, 0x80,  //@@.%..+@@
    0xdf, 0x00,  //@@.@@@@@+
    0xce, 0x00,  //@@.+@@@+.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+00e0 (à) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x30,  //..%@....
    0x18,  //...%@...
    0x0c,  //....%%..
    0x00,  //........
    0x3c,  //.+%@@@+.
    0x7e,  //.@@@@@@.
    0x47,  //.%...%@%
    0x03,  //......@@
    0x3f,  //.+@@@@@@
    0xff,  //%@@@@@@@
    0xc3,  //@@+...@@
    0xc7,  //@@+..%@@
    0xff,  //%@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00e1 (á) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x06,  //.....@%.
    0x0c,  //....@%..
    0x18,  //...%%...
    0x00,  //........
    0x3c,  //.+%@@@+.
    0x7e,  //.@@@@@@.
    0x47,  //.%...%@%
    0x03,  //......@@
    0x3f,  //.+@@@@@@
    0xff,  //%@@@@@@@
    0xc3,  //@@+...@@
    0xc7,  //@@+..%@@
    0xff,  //%@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00e2 (â) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x18,  //...@@...
    0x3c,  //..@%%@..
    0x66,  //.%%..%%.
    0x00,  //........
    0x3c,  //.+%@@@+.
    0x7e,  //.@@@@@@.
    0x47,  //.%...%@%
    0x03,  //......@@
    0x3f,  //.+@@@@@@
    0xff,  //%@@@@@@@
    0xc3,  //@@+...@@
    0xc7,  //@@+..%@@
    0xff,  //%@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00e3 (ã) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x32,  //.+@@..@.
    0x4c,  //.@..@@+.
    0x00,  //........
    0x00,  //........
    0x3c,  //.+%@@@+.
    0x7e,  //.@@@@@@.
    0x47,  //.%...%@%
    0x03,  //......@@
    0x3f,  //.+@@@@@@
    0xff,  //%@@@@@@@
    0xc3,  //@@+...@@
    0xc7,  //@@+..%@@
    0xff,  //%@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00e4 (ä) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x66,  //.@@..@@.
    0x66,  //.@@..@@.
    0x00,  //........
    0x00,  //........
    0x3c,  //.+%@@@+.
    0x7e,  //.@@@@@@.
    0x47,  //.%...%@%
    0x03,  //......@@
    0x3f,  //.+@@@@@@
    0xff,  //%@@@@@@@
    0xc3,  //@@+...@@
    0xc7,  //@@+..%@@
    0xff,  //%@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00e5 (å) , Width: 8 */
    0x1c,  //...%@%..
    0x22,  //..%+.+%.
    0x22,  //..@...@.
    0x22,  //..%+.+%.
    0x1c,  //...%@%..
    0x00,  //........
    0x3c,  //.+%@@@+.
    0x7e,  //.@@@@@@.
    0x47,  //.%...%@%
    0x03,  //......@@
    0x3f,  //.+@@@@@@
    0xff,  //%@@@@@@@
    0xc3,  //@@+...@@
    0xc7,  //@@+..%@@
    0xff,  //%@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00e6 (æ) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x3c, 0x78,  //.+%@@%...%@@%..
    0x7e, 0xfc,  //.@@@@@@+@@@@@@.
    0x47, 0x8e,  //.%...%@@@...%@%
    0x03, 0x06,  //......@@.....@@
    0x3f, 0xfe,  //.+@@@@@@@@@@@@@
    0xff, 0xfe,  //%@@@@@@@@@@@@@@
    0xc3, 0x00,  //@@+...@@.......
    0xc7, 0x82,  //@@+..%@@@+...+%
    0xfd, 0xfe,  //%@@@@@+%@@@@@@@
    0x78, 0x7c,  //.%@@@+..+@@@@%.
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+00e7 (ç) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x1e,  //..+@@@%+
    0x7f,  //.%@@@@@@
    0x61,  //+@@+...%
    0xc0,  //@@+.....
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@+.....
    0x61,  //+@@+...%
    0x7f,  //.%@@@@@@
    0x1e,  //..+@@@%+
    0x04,  //.....@+.
    0x06,  //.....@@.
    0x1e,  //...@@@+.
    0x00,  //........


    /*Unicode: U+00e8 (è) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x30, 0x00,  //..%@......
    0x18, 0x00,  //...%@.....
    0x0c, 0x00,  //....%%....
    0x00, 0x00,  //..........
    0x1f, 0x00,  //..+%@@@%..
    0x7f, 0x80,  //.%@@@@@@@.
    0x61, 0xc0,  //+@@+...@@%
    0xc0, 0xc0,  //@@......@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0x00,  //@@........
    0x60, 0x40,  //+@@+....+@
    0x7f, 0xc0,  //.%@@@@@@@@
    0x1f, 0x80,  //..+%@@@@%.
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00e9 (é) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x06, 0x00,  //.....@%...
    0x0c, 0x00,  //....@%....
    0x18, 0x00,  //...%%.....
    0x00, 0x00,  //..........
    0x1f, 0x00,  //..+%@@@%..
    0x7f, 0x80,  //.%@@@@@@@.
    0x61, 0xc0,  //+@@+...@@%
    0xc0, 0xc0,  //@@......@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0x00,  //@@........
    0x60, 0x40,  //+@@+....+@
    0x7f, 0xc0,  //.%@@@@@@@@
    0x1f, 0x80,  //..+%@@@@%.
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00ea (ê) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x0c, 0x00,  //....@@....
    0x1e, 0x00,  //...@%%@...
    0x33, 0x00,  //..%%..%%..
    0x00, 0x00,  //..........
    0x1f, 0x00,  //..+%@@@%..
    0x7f, 0x80,  //.%@@@@@@@.
    0x61, 0xc0,  //+@@+...@@%
    0xc0, 0xc0,  //@@......@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0x00,  //@@........
    0x60, 0x40,  //+@@+....+@
    0x7f, 0xc0,  //.%@@@@@@@@
    0x1f, 0x80,  //..+%@@@@%.
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00eb (ë) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x33, 0x00,  //..@@..@@..
    0x33, 0x00,  //..@@..@@..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1f, 0x00,  //..+%@@@%..
    0x7f, 0x80,  //.%@@@@@@@.
    0x61, 0xc0,  //+@@+...@@%
    0xc0, 0xc0,  //@@......@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0x00,  //@@........
    0x60, 0x40,  //+@@+....+@
    0x7f, 0xc0,  //.%@@@@@@@@
    0x1f, 0x80,  //..+%@@@@%.
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00ec (ì) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xc0,  //%@..
    0x60,  //.%@.
    0x30,  //..%%
    0x00,  //....
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ed (í) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x30,  //..@%
    0x60,  //.@%.
    0xc0,  //%%..
    0x00,  //....
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x60,  //.@@.
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ee (î) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x30,  //..@@..
    0x78,  //.@%%@.
    0xcc,  //%%..%%
    0x00,  //......
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00ef (ï) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0xcc,  //@@..@@
    0xcc,  //@@..@@
    0x00,  //......
    0x00,  //......
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x30,  //..@@..
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00f0 (ð) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x10, 0x00,  //..+@...++.
    0x1f, 0x00,  //...%@@@%..
    0x7c, 0x00,  //.%@@%@....
    0x06, 0x00,  //.+...%%...
    0x1f, 0x00,  //..+@@@@%..
    0x7f, 0x80,  //.%@@@@@@@.
    0x61, 0xc0,  //+@@+...@@%
    0xc0, 0xc0,  //@@+.....@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.%@@@@@@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00f1 (ñ) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x32,  //.+@@..@.
    0x4c,  //.@..@@+.
    0x00,  //........
    0x00,  //........
    0xde,  //@@.%@@%.
    0xfe,  //@@%@@@@+
    0xe7,  //@@@..%@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00f2 (ò) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x30, 0x00,  //..%@......
    0x18, 0x00,  //...%@.....
    0x0c, 0x00,  //....%%....
    0x00, 0x00,  //..........
    0x1e, 0x00,  //..+@@@@+..
    0x7f, 0x80,  //.%@@@@@@%.
    0x61, 0x80,  //+@@+..+@@+
    0xc0, 0xc0,  //@@+....+@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.%@@@@@@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00f3 (ó) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x06, 0x00,  //.....@%...
    0x0c, 0x00,  //....@%....
    0x18, 0x00,  //...%%.....
    0x00, 0x00,  //..........
    0x1e, 0x00,  //..+@@@@+..
    0x7f, 0x80,  //.%@@@@@@%.
    0x61, 0x80,  //+@@+..+@@+
    0xc0, 0xc0,  //@@+....+@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.%@@@@@@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00f4 (ô) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x0c, 0x00,  //....@@....
    0x1e, 0x00,  //...@%%@...
    0x33, 0x00,  //..%%..%%..
    0x00, 0x00,  //..........
    0x1e, 0x00,  //..+@@@@+..
    0x7f, 0x80,  //.%@@@@@@%.
    0x61, 0x80,  //+@@+..+@@+
    0xc0, 0xc0,  //@@+....+@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.%@@@@@@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00f5 (õ) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x19, 0x00,  //..+@@..@..
    0x26, 0x00,  //..@..@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1e, 0x00,  //..+@@@@+..
    0x7f, 0x80,  //.%@@@@@@%.
    0x61, 0x80,  //+@@+..+@@+
    0xc0, 0xc0,  //@@+....+@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.%@@@@@@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00f6 (ö) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x33, 0x00,  //..@@..@@..
    0x33, 0x00,  //..@@..@@..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1e, 0x00,  //..+@@@@+..
    0x7f, 0x80,  //.%@@@@@@%.
    0x61, 0x80,  //+@@+..+@@+
    0xc0, 0xc0,  //@@+....+@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.%@@@@@@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+00f7 (÷) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00f8 (ø) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //..........+.
    0x0f, 0x20,  //...+%@@%.+@.
    0x1f, 0xc0,  //..+@@@@@@@+.
    0x30, 0xc0,  //.+@@+..+@@..
    0x61, 0xe0,  //.@@+...@%@%.
    0x62, 0x60,  //.@@...@+.@@.
    0x64, 0x60,  //.@@.+@...@@.
    0x78, 0x60,  //.%@%@...+@@.
    0x30, 0xc0,  //..@@+..+@@+.
    0x3f, 0xc0,  //.+@@@@@@@%..
    0x4f, 0x00,  //.@+.%@@@+...
    0x00, 0x00,  //.+..........
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+00f9 (ù) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x60,  //.%@.....
    0x30,  //..%@....
    0x18,  //...%%...
    0x00,  //........
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xe7,  //@@%..@@@
    0x7f,  //+@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00fa (ú) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x0c,  //....@%..
    0x18,  //...@%...
    0x30,  //..%%....
    0x00,  //........
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xe7,  //@@%..@@@
    0x7f,  //+@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00fb (û) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x18,  //...@@...
    0x3c,  //..@%%@..
    0x66,  //.%%..%%.
    0x00,  //........
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xe7,  //@@%..@@@
    0x7f,  //+@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00fc (ü) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x66,  //.@@..@@.
    0x66,  //.@@..@@.
    0x00,  //........
    0x00,  //........
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xe7,  //@@%..@@@
    0x7f,  //+@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00fd (ý) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x03, 0x00,  //......@%....
    0x06, 0x00,  //.....@%.....
    0x0c, 0x00,  //....%%......
    0x00, 0x00,  //............
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //.%@+....+@%.
    0x30, 0xc0,  //..@@....@@..
    0x30, 0xc0,  //..%@+..+@@..
    0x19, 0x80,  //...@@..@@+..
    0x19, 0x80,  //...@@+.@@...
    0x0f, 0x00,  //...+@%%@+...
    0x0f, 0x00,  //....@@@@....
    0x06, 0x00,  //....+@@+....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@%.....
    0x0c, 0x00,  //....%@......
    0x3c, 0x00,  //..@@@%......
    0x38, 0x00,  //..@@%.......


    /*Unicode: U+00fe (þ) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xde, 0x00,  //@@.%@@%..
    0xff, 0x00,  //@@%@@@@@.
    0xe3, 0x80,  //@@@...@@%
    0xc1, 0x80,  //@@+...+@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@+...+@@
    0xe3, 0x80,  //@@@...@@%
    0xff, 0x00,  //@@%@@@@@.
    0xde, 0x00,  //@@.%@@%..
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......


    /*Unicode: U+00ff (ÿ) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1b, 0x00,  //...@@.@@....
    0x1b, 0x00,  //...@@.@@....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //.%@+....+@%.
    0x30, 0xc0,  //..@@....@@..
    0x30, 0xc0,  //..%@+..+@@..
    0x19, 0x80,  //...@@..@@+..
    0x19, 0x80,  //...@@+.@@...
    0x0f, 0x00,  //...+@%%@+...
    0x0f, 0x00,  //....@@@@....
    0x06, 0x00,  //....+@@+....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@%.....
    0x0c, 0x00,  //....%@......
    0x3c, 0x00,  //..@@@%......
    0x38, 0x00,  //..@@%.......



#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 2
    /*Unicode: U+00a0 ( ) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00a1 (¡) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..


    /*Unicode: U+00a2 (¢) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x30,  //.....@..
    0x00, 0x30,  //.....@..
    0x00, 0x30,  //.....@..
    0x06, 0xfd,  //..+%@@@+
    0x2f, 0xff,  //.%@@@@@@
    0x7d, 0x32,  //+@@+.@.%
    0xf4, 0x30,  //@@+..@..
    0xf0, 0x30,  //@@...@..
    0xf0, 0x30,  //@@...@..
    0xf4, 0x30,  //@@+..@..
    0x7d, 0x32,  //+@@+.@.%
    0x2f, 0xff,  //.%@@@@@@
    0x06, 0xfd,  //..+%@@@+
    0x00, 0x30,  //.....@..
    0x00, 0x30,  //.....@..
    0x00, 0x30,  //.....@..
    0x00, 0x00,  //........


    /*Unicode: U+00a3 (£) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x01, 0xbe, 0x00,  //...+%@@%.
    0x07, 0xff, 0xc0,  //...@@@@@@
    0x0b, 0x80, 0x80,  //..%@%...%
    0x0f, 0x00, 0x00,  //..@@.....
    0x0f, 0x00, 0x00,  //..@@.....
    0x0f, 0x00, 0x00,  //..@@.....
    0xff, 0xfc, 0x00,  //@@@@@@@..
    0xff, 0xfc, 0x00,  //@@@@@@@..
    0x0f, 0x00, 0x00,  //..@@.....
    0x0f, 0x00, 0x00,  //..@@.....
    0x0f, 0x00, 0x00,  //..@@.....
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a4 (¤) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x90, 0x01, 0x80,  //%+.....+%
    0x79, 0xdb, 0x40,  //+@%+@+%@+
    0x2f, 0xfe, 0x00,  //.%@@@@@%.
    0x1d, 0x1d, 0x00,  //.+@+.+@+.
    0x3c, 0x0f, 0x00,  //.@@...@@.
    0x1d, 0x1d, 0x00,  //.+@+.+@+.
    0x2f, 0xfe, 0x00,  //.%@@@@@%.
    0x79, 0xdb, 0x40,  //+@%+@+%@+
    0x90, 0x01, 0x80,  //%+.....+%
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a5 (¥) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xb4, 0x01, 0xe0,  //%@+....+@%
    0x3c, 0x03, 0xc0,  //.@@....@@.
    0x2d, 0x07, 0x80,  //.%@+..+@%.
    0x0f, 0x0f, 0x00,  //..@@..@@..
    0x0b, 0x5e, 0x00,  //..%@++@%..
    0xff, 0xaf, 0xf0,  //@@@@%%@@@@
    0x02, 0xf8, 0x00,  //...%@@%...
    0x00, 0xf0, 0x00,  //....@@....
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00a6 (¦) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..


    /*Unicode: U+00a7 (§) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x0b, 0xf0,  //..%@@@.
    0x2f, 0xf0,  //.%@@@@.
    0x3d, 0x00,  //.@@+...
    0x2c, 0x00,  //.%@....
    0x0e, 0x00,  //..@%...
    0x7a, 0xd0,  //+@%%@+.
    0xf0, 0xb4,  //@@..%@+
    0xf0, 0x3c,  //@@...@@
    0x78, 0x3c,  //+@%..@@
    0x0e, 0xf0,  //..@%@@.
    0x02, 0xc0,  //...%@..
    0x00, 0xf0,  //....@@.
    0x01, 0xf0,  //...+@@.
    0x3f, 0xe0,  //.@@@@%.
    0x3f, 0x80,  //.@@@%..
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00a8 (¨) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xf0, 0xf0,  //@@..@@
    0xf0, 0xf0,  //@@..@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00a9 (©) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0x80, 0x00,  //....%@@@%....
    0x0b, 0x40, 0x78, 0x00,  //..%@+...+@%..
    0x28, 0x00, 0x0a, 0x00,  //.%%.......%%.
    0x30, 0x7f, 0xc3, 0x00,  //.@..+@@@@..@.
    0x91, 0xc0, 0x01, 0x80,  //%+.+@......+%
    0xc3, 0x00, 0x00, 0xc0,  //@..@........@
    0xc3, 0x00, 0x00, 0xc0,  //@..@........@
    0xc3, 0x00, 0x00, 0xc0,  //@..@........@
    0x91, 0xd0, 0x81, 0x80,  //%+.+@+..%..+%
    0x30, 0x7f, 0x43, 0x00,  //.@..+@@@+..@.
    0x28, 0x00, 0x0a, 0x00,  //.%%.......%%.
    0x0b, 0x40, 0x78, 0x00,  //..%@+...+@%..
    0x00, 0xbf, 0x80, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00aa (ª) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x3f, 0xe0,  //.@@@@%..
    0x00, 0x1c,  //.....+@.
    0x2f, 0xfc,  //.%@@@@@.
    0xa0, 0x0c,  //%%....@.
    0xc0, 0x1c,  //@....+@.
    0xe0, 0x7c,  //@%..+@@.
    0x2f, 0xdc,  //.%@@@+@.
    0x00, 0x00,  //........
    0xbf, 0xfc,  //%@@@@@@.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00ab («) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x02, 0x02,  //...%...%
    0x0b, 0x0b,  //..%@..%@
    0x28, 0x28,  //.%%..%%.
    0xe0, 0xe0,  //@%..@%..
    0xe0, 0xe0,  //@%..@%..
    0x28, 0x28,  //.%%..%%.
    0x0b, 0x0b,  //..%@..%@
    0x02, 0x02,  //...%...%
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00ac (¬) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x00, 0x00, 0x3c,  //.........@@
    0x00, 0x00, 0x3c,  //.........@@
    0x00, 0x00, 0x3c,  //.........@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00ad (­) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00ae (®) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xbf, 0x80, 0x00,  //....%@@@%....
    0x0b, 0x40, 0x78, 0x00,  //..%@+...+@%..
    0x28, 0x00, 0x0a, 0x00,  //.%%.......%%.
    0x30, 0xff, 0x43, 0x00,  //.@..@@@@+..@.
    0x90, 0xc1, 0xc1, 0x80,  //%+..@..+@..+%
    0xc0, 0xc1, 0xc0, 0xc0,  //@...@..+@...@
    0xc0, 0xff, 0x40, 0xc0,  //@...@@@@+...@
    0xc0, 0xc7, 0x00, 0xc0,  //@...@.+@....@
    0x90, 0xc1, 0xc1, 0x80,  //%+..@..+@..+%
    0x30, 0xc0, 0xe3, 0x00,  //.@..@...@%.@.
    0x28, 0x00, 0x0a, 0x00,  //.%%.......%%.
    0x0b, 0x40, 0x78, 0x00,  //..%@+...+@%..
    0x00, 0xbf, 0x80, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00af (¯) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00b0 (°) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x2f, 0x80,  //.%@@%.
    0xa0, 0xa0,  //%%..%%
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xa0, 0xa0,  //%%..%%
    0x2f, 0x80,  //.%@@%.
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00b1 (±) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00b2 (²) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x7f, 0x00,  //+@@@.
    0x81, 0xc0,  //%..+@
    0x00, 0xc0,  //....@
    0x03, 0x00,  //...@.
    0x0d, 0x00,  //..@+.
    0x74, 0x00,  //+@+..
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00b3 (³) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0x40,  //@@@@+
    0x01, 0xc0,  //...+@
    0x3f, 0x40,  //.@@@+
    0x02, 0xc0,  //...%@
    0x00, 0xc0,  //....@
    0x02, 0xc0,  //...+@
    0xfe, 0x00,  //@@@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00b4 (´) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x0e,  //..@%
    0x38,  //.@%.
    0xa0,  //%%..
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00b5 (µ) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf8, 0x2f, 0x00,  //@@%..%@@.
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xf3, 0xc7, 0x80,  //@@.@@.+@%
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......


    /*Unicode: U+00b6 (¶) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x0b, 0xff,  //..%@@@@@
    0x7f, 0xc3,  //+@@@@..@
    0xff, 0xc3,  //@@@@@..@
    0xff, 0xc3,  //@@@@@..@
    0xff, 0xc3,  //@@@@@..@
    0xbf, 0xc3,  //%@@@@..@
    0x2f, 0xc3,  //.%@@@..@
    0x01, 0xc3,  //...+@..@
    0x00, 0xc3,  //....@..@
    0x00, 0xc3,  //....@..@
    0x00, 0xc3,  //....@..@
    0x00, 0xc3,  //....@..@
    0x00, 0xc3,  //....@..@
    0x00, 0xc3,  //....@..@
    0x00, 0xc3,  //....@..@
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00b7 (·) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b8 (¸) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x0d,  //..@+
    0x0f,  //..@@
    0xfe,  //@@@+
    0x00,  //....


    /*Unicode: U+00b9 (¹) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xfc, 0x00,  //@@@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00ba (º) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x1f, 0xd0,  //.+@@@+.
    0x70, 0x34,  //+@...@+
    0xc0, 0x0c,  //@.....@
    0xc0, 0x0c,  //@.....@
    0xc0, 0x0c,  //@.....@
    0x70, 0x34,  //+@...@+
    0x1f, 0xd0,  //.+@@@+.
    0x00, 0x00,  //.......
    0xbf, 0xf8,  //%@@@@@%
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00bb (») , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x80, 0x80,  //%...%...
    0xe0, 0xe0,  //@%..@%..
    0x28, 0x28,  //.%%..%%.
    0x0b, 0x0b,  //..%@..%@
    0x0b, 0x0b,  //..%@..%@
    0x28, 0x28,  //.%%..%%.
    0xe0, 0xe0,  //@%..@%..
    0x80, 0x80,  //%...%...
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00bc (¼) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xfc, 0x00, 0x02, 0x80,  //@@@........%%...
    0x0c, 0x00, 0x03, 0x00,  //..@........@....
    0x0c, 0x00, 0x0d, 0x00,  //..@.......@+....
    0x0c, 0x00, 0x28, 0x00,  //..@......%%.....
    0x0c, 0x00, 0x70, 0x00,  //..@......@......
    0x0c, 0x00, 0xd0, 0x00,  //..@.....@+......
    0xff, 0xc2, 0x80, 0x3c,  //@@@@@..%%....@@.
    0x00, 0x07, 0x00, 0xdc,  //......+@....%+@.
    0x00, 0x0c, 0x02, 0x4c,  //......@....%+.@.
    0x00, 0x28, 0x09, 0x0c,  //.....%%...%+..@.
    0x00, 0x70, 0x0f, 0xff,  //....+@....@@@@@@
    0x00, 0xc0, 0x00, 0x0c,  //....@.........@.
    0x02, 0x80, 0x00, 0x0c,  //...%%.........@.
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00bd (½) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0xfc, 0x00, 0x02, 0x80,  //@@@........%%..
    0x0c, 0x00, 0x03, 0x00,  //..@........@...
    0x0c, 0x00, 0x0d, 0x00,  //..@.......@+...
    0x0c, 0x00, 0x28, 0x00,  //..@......%%....
    0x0c, 0x00, 0x70, 0x00,  //..@......@.....
    0x0c, 0x00, 0xd0, 0x00,  //..@.....@+.....
    0xff, 0xc2, 0x87, 0xf0,  //@@@@@..%%.+@@@.
    0x00, 0x07, 0x08, 0x1c,  //......+@..%..+@
    0x00, 0x0c, 0x00, 0x0c,  //......@.......@
    0x00, 0x28, 0x00, 0x30,  //.....%%......@.
    0x00, 0x70, 0x00, 0xd0,  //....+@......@+.
    0x00, 0xc0, 0x07, 0x40,  //....@.....+@+..
    0x02, 0x80, 0x0f, 0xfc,  //...%%.....@@@@@
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00be (¾) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0x40, 0x02, 0x80,  //@@@@+......%%...
    0x01, 0xc0, 0x03, 0x00,  //...+@......@....
    0x3f, 0x40, 0x0d, 0x00,  //.@@@+.....@+....
    0x02, 0xc0, 0x28, 0x00,  //...%@....%%.....
    0x00, 0xc0, 0x70, 0x00,  //....@....@......
    0x02, 0xc0, 0xd0, 0x00,  //...+@...@+......
    0xfe, 0x02, 0x80, 0x3c,  //@@@%...%%....@@.
    0x00, 0x07, 0x00, 0xdc,  //......+@....%+@.
    0x00, 0x0c, 0x02, 0x4c,  //......@....%+.@.
    0x00, 0x28, 0x09, 0x0c,  //.....%%...%+..@.
    0x00, 0x70, 0x0f, 0xff,  //....+@....@@@@@@
    0x00, 0xc0, 0x00, 0x0c,  //....@.........@.
    0x02, 0x80, 0x00, 0x0c,  //...%%.........@.
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00bf (¿) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x03, 0xc0,  //...@@..
    0x03, 0xc0,  //...@@..
    0x00, 0x00,  //.......
    0x03, 0xc0,  //...@@..
    0x03, 0xc0,  //...@@..
    0x03, 0xc0,  //...@@..
    0x0b, 0x40,  //..%@+..
    0x1e, 0x00,  //.+@%...
    0x38, 0x00,  //.@%....
    0xf0, 0x00,  //@@.....
    0xf0, 0x00,  //@@.....
    0xf8, 0x1c,  //@@%..+@
    0x7f, 0xfc,  //+@@@@@@
    0x1f, 0xe4,  //.+@@@%.


    /*Unicode: U+00c0 (À) , Width: 12 */
    0x00, 0x7c, 0x00,  //....+@@.....
    0x00, 0x1f, 0x00,  //.....+@@....
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0xff, 0x00,  //....@@@@....
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x2f, 0xff, 0xf8,  //.%@@@@@@@@%.
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x78, 0x00, 0x2d,  //+@%......%@+
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c1 (Á) , Width: 12 */
    0x00, 0x0b, 0x00,  //......%@....
    0x00, 0x2c, 0x00,  //.....%@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0xff, 0x00,  //....@@@@....
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x2f, 0xff, 0xf8,  //.%@@@@@@@@%.
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x78, 0x00, 0x2d,  //+@%......%@+
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c2 (Â) , Width: 12 */
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x96, 0x00,  //....%++%....
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0xff, 0x00,  //....@@@@....
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x2f, 0xff, 0xf8,  //.%@@@@@@@@%.
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x78, 0x00, 0x2d,  //+@%......%@+
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c3 (Ã) , Width: 12 */
    0x01, 0xf4, 0xc0,  //...+@@+.@...
    0x03, 0x1f, 0x40,  //...@.+@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0xff, 0x00,  //....@@@@....
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x2f, 0xff, 0xf8,  //.%@@@@@@@@%.
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x78, 0x00, 0x2d,  //+@%......%@+
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c4 (Ä) , Width: 12 */
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0xff, 0x00,  //....@@@@....
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x2f, 0xff, 0xf8,  //.%@@@@@@@@%.
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x78, 0x00, 0x2d,  //+@%......%@+
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c5 (Å) , Width: 12 */
    0x00, 0xd7, 0x00,  //....@++@....
    0x00, 0xc3, 0x00,  //....@..@....
    0x00, 0xd7, 0x00,  //....@++@....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0xbe, 0x00,  //....%@@%....
    0x00, 0xff, 0x00,  //....@@@@....
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x0f, 0x41, 0xf0,  //..@@+..+@@..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x2f, 0xff, 0xf8,  //.%@@@@@@@@%.
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c6 (Æ) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x2f, 0xff, 0xff,  //.....%@@@@@@@@@@
    0x00, 0x3f, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x78, 0xf0, 0x00,  //....+@%.@@......
    0x00, 0xf0, 0xf0, 0x00,  //....@@..@@......
    0x01, 0xe0, 0xf0, 0x00,  //...+@%..@@......
    0x03, 0xd0, 0xff, 0xff,  //...@@...@@@@@@@@
    0x03, 0xc0, 0xff, 0xff,  //...@@...@@@@@@@@
    0x0b, 0x40, 0xf0, 0x00,  //..%@+...@@......
    0x0f, 0xff, 0xf0, 0x00,  //..@@@@@@@@......
    0x1f, 0xff, 0xf0, 0x00,  //.+@@@@@@@@......
    0x3d, 0x00, 0xf0, 0x00,  //.@@.....@@......
    0x7c, 0x00, 0xff, 0xff,  //+@@.....@@@@@@@@
    0xf4, 0x00, 0xff, 0xff,  //@@+.....@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00c7 (Ç) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x3f, 0x40, 0x1c,  //.@@@+....+@
    0x7c, 0x00, 0x00,  //+@@........
    0xb4, 0x00, 0x00,  //%@+........
    0xf0, 0x00, 0x00,  //@@.........
    0xf0, 0x00, 0x00,  //@@.........
    0xf0, 0x00, 0x00,  //@@.........
    0xb4, 0x00, 0x00,  //%@+........
    0x7c, 0x00, 0x00,  //+@@........
    0x3f, 0x40, 0x1c,  //.@@@+....+@
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x00, 0x03, 0x40,  //.......@+..
    0x00, 0x03, 0xc0,  //.......@@..
    0x00, 0x3f, 0x80,  //.....@@@+..
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00c8 (È) , Width: 8 */
    0x1f, 0x00,  //.+@@....
    0x07, 0xc0,  //..+@@...
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00c9 (É) , Width: 8 */
    0x02, 0xc0,  //...%@...
    0x0b, 0x00,  //..%@....
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00ca (Ê) , Width: 8 */
    0x0b, 0x80,  //..%@%...
    0x28, 0xa0,  //.%%.%%..
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00cb (Ë) , Width: 8 */
    0x3c, 0x3c,  //.@@..@@.
    0x3c, 0x3c,  //.@@..@@.
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00cc (Ì) , Width: 5 */
    0x7c, 0x00,  //+@@..
    0x1f, 0x00,  //.+@@.
    0x00, 0x00,  //.....
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x0f, 0x00,  //..@@.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00cd (Í) , Width: 4 */
    0x2c,  //.%@.
    0xb0,  //%@..
    0x00,  //....
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ce (Î) , Width: 6 */
    0x1f, 0x40,  //.+@@+.
    0x70, 0xd0,  //+@..@+
    0x00, 0x00,  //......
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00cf (Ï) , Width: 6 */
    0xf0, 0xf0,  //@@..@@
    0xf0, 0xf0,  //@@..@@
    0x00, 0x00,  //......
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00d0 (Ð) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x0f, 0xff, 0x90, 0x00,  //..@@@@@@%+...
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x0f, 0x00, 0x7f, 0x00,  //..@@....+@@@.
    0x0f, 0x00, 0x0f, 0x80,  //..@@......@@+
    0x0f, 0x00, 0x07, 0xc0,  //..@@......+@@
    0xff, 0xfc, 0x03, 0xc0,  //@@@@@@@....@@
    0xff, 0xfc, 0x03, 0xc0,  //@@@@@@@....@@
    0x0f, 0x00, 0x03, 0xc0,  //..@@.......@@
    0x0f, 0x00, 0x07, 0xc0,  //..@@......+@@
    0x0f, 0x00, 0x0f, 0x40,  //..@@......@@+
    0x0f, 0x00, 0x7f, 0x00,  //..@@....+@@@.
    0x0f, 0xff, 0xfc, 0x00,  //..@@@@@@@@@..
    0x0f, 0xff, 0x90, 0x00,  //..@@@@@@%+...
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00d1 (Ñ) , Width: 10 */
    0x07, 0xd3, 0x00,  //..+@@+.@..
    0x0c, 0x7d, 0x00,  //..@.+@@+..
    0x00, 0x00, 0x00,  //..........
    0xf8, 0x00, 0xf0,  //@@%.....@@
    0xfc, 0x00, 0xf0,  //@@@.....@@
    0xfe, 0x00, 0xf0,  //@@@%....@@
    0xfb, 0x40, 0xf0,  //@@%@+...@@
    0xf3, 0xc0, 0xf0,  //@@.@@...@@
    0xf2, 0xd0, 0xf0,  //@@.%@+..@@
    0xf0, 0xf0, 0xf0,  //@@..@@..@@
    0xf0, 0x78, 0xf0,  //@@..+@%.@@
    0xf0, 0x3d, 0xf0,  //@@...@@.@@
    0xf0, 0x1f, 0xf0,  //@@...+@@@@
    0xf0, 0x0b, 0xf0,  //@@....%@@@
    0xf0, 0x03, 0xf0,  //@@.....@@@
    0xf0, 0x02, 0xf0,  //@@.....%@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00d2 (Ò) , Width: 12 */
    0x00, 0x7c, 0x00,  //....+@@.....
    0x00, 0x1f, 0x00,  //.....+@@....
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0x80,  //...+@@@@+...
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x02, 0xff, 0x80,  //...+@@@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d3 (Ó) , Width: 12 */
    0x00, 0x0b, 0x00,  //......%@....
    0x00, 0x2c, 0x00,  //.....%@.....
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0x80,  //...+@@@@+...
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x02, 0xff, 0x80,  //...+@@@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d4 (Ô) , Width: 12 */
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x96, 0x00,  //....%++%....
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0x80,  //...+@@@@+...
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x02, 0xff, 0x80,  //...+@@@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d5 (Õ) , Width: 12 */
    0x01, 0xf4, 0xc0,  //...+@@+.@...
    0x03, 0x1f, 0x40,  //...@.+@@+...
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0x80,  //...+@@@@+...
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x02, 0xff, 0x80,  //...+@@@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d6 (Ö) , Width: 12 */
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0x80,  //...+@@@@+...
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x02, 0xff, 0x80,  //...+@@@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d7 (×) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x34, 0x01, 0xc0,  //.@+....+@.
    0xbd, 0x07, 0xe0,  //%@@+..+@@%
    0x2f, 0x5f, 0x80,  //.%@@++@@%.
    0x0b, 0xfe, 0x00,  //..%@@@@%..
    0x02, 0xf8, 0x00,  //...%@@%...
    0x02, 0xf8, 0x00,  //...%@@%...
    0x0b, 0xfe, 0x00,  //..%@@@@%..
    0x2f, 0x5f, 0x80,  //.%@@++@@%.
    0xbd, 0x07, 0xe0,  //%@@+..+@@%
    0x34, 0x01, 0xc0,  //.@+....+@.
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00d8 (Ø) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0xbf, 0x81, 0xc0,  //....%@@@%..+@.
    0x03, 0xff, 0xf7, 0x40,  //...@@@@@@@+@+.
    0x0f, 0xd0, 0x7e, 0x00,  //..@@@+..+@@%..
    0x2f, 0x00, 0x3f, 0x00,  //.%@@.....@@@..
    0x3d, 0x00, 0xe7, 0x80,  //.@@+....@%+@%.
    0x3c, 0x02, 0x83, 0xc0,  //.@@....%%..@@.
    0x3c, 0x0a, 0x03, 0xc0,  //.@@...%%...@@.
    0x3c, 0x28, 0x03, 0xc0,  //.@@..%%....@@.
    0x2d, 0xb0, 0x07, 0xc0,  //.%@+%@....+@@.
    0x0f, 0xc0, 0x0f, 0x80,  //..@@@.....@@%.
    0x0b, 0xd0, 0x7f, 0x00,  //..%@@+..+@@@..
    0x1d, 0xff, 0xfc, 0x00,  //.+@+@@@@@@@...
    0x34, 0x2f, 0xe0, 0x00,  //.@+..%@@@%....
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00d9 (Ù) , Width: 10 */
    0x07, 0xc0, 0x00,  //..+@@.....
    0x01, 0xf0, 0x00,  //...+@@....
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0xc0,  //.@@@@@@@@.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00da (Ú) , Width: 10 */
    0x00, 0xb0, 0x00,  //....%@....
    0x02, 0xc0, 0x00,  //...%@.....
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0xc0,  //.@@@@@@@@.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00db (Û) , Width: 10 */
    0x00, 0xf0, 0x00,  //....@@....
    0x02, 0x58, 0x00,  //...%++%...
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0xc0,  //.@@@@@@@@.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00dc (Ü) , Width: 10 */
    0x0f, 0x0f, 0x00,  //..@@..@@..
    0x0f, 0x0f, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0xc0,  //.@@@@@@@@.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00dd (Ý) , Width: 12 */
    0x00, 0x2c, 0x00,  //.....%@.....
    0x00, 0xb0, 0x00,  //....%@......
    0x00, 0x00, 0x00,  //............
    0xbc, 0x00, 0x3e,  //%@@......@@%
    0x3d, 0x00, 0x7c,  //.@@+....+@@.
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00de (Þ) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xf4,  //@@@@@%+.
    0xff, 0xfd,  //@@@@@@@+
    0xf0, 0x2f,  //@@...%@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x2f,  //@@...%@@
    0xff, 0xfd,  //@@@@@@@+
    0xff, 0xf4,  //@@@@@@+.
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00df (ß) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x1b, 0xf4, 0x00,  //.+%@@@+..
    0x7f, 0xfc, 0x00,  //+@@@@@@..
    0xf8, 0x2e, 0x00,  //@@%..%@%.
    0xf0, 0x1f, 0x00,  //@@....@@.
    0xf0, 0x7d, 0x00,  //@@..+@@+.
    0xf0, 0xf0, 0x00,  //@@..@@...
    0xf0, 0xf0, 0x00,  //@@..@@...
    0xf0, 0x38, 0x00,  //@@...@%..
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x03, 0x80,  //@@.....@%
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf2, 0x07, 0xc0,  //@@.%..+@@
    0xf3, 0xff, 0x40,  //@@.@@@@@+
    0xf1, 0xfd, 0x00,  //@@.+@@@+.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00e0 (à) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x0b, 0x00,  //..%@....
    0x02, 0xc0,  //...%@...
    0x00, 0xa0,  //....%%..
    0x00, 0x00,  //........
    0x1b, 0xf4,  //.+%@@@+.
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x2e,  //.%...%@%
    0x00, 0x0f,  //......@@
    0x1f, 0xff,  //.+@@@@@@
    0xbf, 0xff,  //%@@@@@@@
    0xf4, 0x0f,  //@@+...@@
    0xf4, 0x2f,  //@@+..%@@
    0xbf, 0xef,  //%@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00e1 (á) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x38,  //.....@%.
    0x00, 0xe0,  //....@%..
    0x02, 0x80,  //...%%...
    0x00, 0x00,  //........
    0x1b, 0xf4,  //.+%@@@+.
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x2e,  //.%...%@%
    0x00, 0x0f,  //......@@
    0x1f, 0xff,  //.+@@@@@@
    0xbf, 0xff,  //%@@@@@@@
    0xf4, 0x0f,  //@@+...@@
    0xf4, 0x2f,  //@@+..%@@
    0xbf, 0xef,  //%@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00e2 (â) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x03, 0xc0,  //...@@...
    0x0e, 0xb0,  //..@%%@..
    0x28, 0x28,  //.%%..%%.
    0x00, 0x00,  //........
    0x1b, 0xf4,  //.+%@@@+.
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x2e,  //.%...%@%
    0x00, 0x0f,  //......@@
    0x1f, 0xff,  //.+@@@@@@
    0xbf, 0xff,  //%@@@@@@@
    0xf4, 0x0f,  //@@+...@@
    0xf4, 0x2f,  //@@+..%@@
    0xbf, 0xef,  //%@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00e3 (ã) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1f, 0x0c,  //.+@@..@.
    0x30, 0xf4,  //.@..@@+.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1b, 0xf4,  //.+%@@@+.
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x2e,  //.%...%@%
    0x00, 0x0f,  //......@@
    0x1f, 0xff,  //.+@@@@@@
    0xbf, 0xff,  //%@@@@@@@
    0xf4, 0x0f,  //@@+...@@
    0xf4, 0x2f,  //@@+..%@@
    0xbf, 0xef,  //%@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00e4 (ä) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x3c, 0x3c,  //.@@..@@.
    0x3c, 0x3c,  //.@@..@@.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1b, 0xf4,  //.+%@@@+.
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x2e,  //.%...%@%
    0x00, 0x0f,  //......@@
    0x1f, 0xff,  //.+@@@@@@
    0xbf, 0xff,  //%@@@@@@@
    0xf4, 0x0f,  //@@+...@@
    0xf4, 0x2f,  //@@+..%@@
    0xbf, 0xef,  //%@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00e5 (å) , Width: 8 */
    0x02, 0xe0,  //...%@%..
    0x09, 0x18,  //..%+.+%.
    0x0c, 0x0c,  //..@...@.
    0x09, 0x18,  //..%+.+%.
    0x02, 0xe0,  //...%@%..
    0x00, 0x00,  //........
    0x1b, 0xf4,  //.+%@@@+.
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x2e,  //.%...%@%
    0x00, 0x0f,  //......@@
    0x1f, 0xff,  //.+@@@@@@
    0xbf, 0xff,  //%@@@@@@@
    0xf4, 0x0f,  //@@+...@@
    0xf4, 0x2f,  //@@+..%@@
    0xbf, 0xef,  //%@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00e6 (æ) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x1b, 0xe0, 0x7f, 0x80,  //.+%@@%...%@@%..
    0x3f, 0xfd, 0xff, 0xf0,  //.@@@@@@+@@@@@@.
    0x20, 0x2f, 0xc0, 0xb8,  //.%...%@@@...%@%
    0x00, 0x0f, 0x00, 0x3c,  //......@@.....@@
    0x1f, 0xff, 0xff, 0xfc,  //.+@@@@@@@@@@@@@
    0xbf, 0xff, 0xff, 0xfc,  //%@@@@@@@@@@@@@@
    0xf4, 0x0f, 0x00, 0x00,  //@@+...@@.......
    0xf4, 0x2f, 0xd0, 0x18,  //@@+..%@@@+...+%
    0xbf, 0xf6, 0xff, 0xfc,  //%@@@@@+%@@@@@@@
    0x2f, 0xd0, 0x7f, 0xe0,  //.%@@@+..+@@@@%.
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00e7 (ç) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x07, 0xf9,  //..+@@@%+
    0x2f, 0xff,  //.%@@@@@@
    0x7d, 0x02,  //+@@+...%
    0xf4, 0x00,  //@@+.....
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf4, 0x00,  //@@+.....
    0x7d, 0x02,  //+@@+...%
    0x2f, 0xff,  //.%@@@@@@
    0x07, 0xf9,  //..+@@@%+
    0x00, 0x34,  //.....@+.
    0x00, 0x3c,  //.....@@.
    0x03, 0xf8,  //...@@@+.
    0x00, 0x00,  //........


    /*Unicode: U+00e8 (è) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x0b, 0x00, 0x00,  //..%@......
    0x02, 0xc0, 0x00,  //...%@.....
    0x00, 0xa0, 0x00,  //....%%....
    0x00, 0x00, 0x00,  //..........
    0x06, 0xfe, 0x00,  //..+%@@@%..
    0x2f, 0xff, 0xc0,  //.%@@@@@@@.
    0x7d, 0x03, 0xe0,  //+@@+...@@%
    0xf0, 0x00, 0xf0,  //@@......@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0x00,  //@@........
    0x7d, 0x00, 0x70,  //+@@+....+@
    0x2f, 0xff, 0xf0,  //.%@@@@@@@@
    0x06, 0xff, 0x80,  //..+%@@@@%.
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00e9 (é) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x38, 0x00,  //.....@%...
    0x00, 0xe0, 0x00,  //....@%....
    0x02, 0x80, 0x00,  //...%%.....
    0x00, 0x00, 0x00,  //..........
    0x06, 0xfe, 0x00,  //..+%@@@%..
    0x2f, 0xff, 0xc0,  //.%@@@@@@@.
    0x7d, 0x03, 0xe0,  //+@@+...@@%
    0xf0, 0x00, 0xf0,  //@@......@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0x00,  //@@........
    0x7d, 0x00, 0x70,  //+@@+....+@
    0x2f, 0xff, 0xf0,  //.%@@@@@@@@
    0x06, 0xff, 0x80,  //..+%@@@@%.
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00ea (ê) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0xf0, 0x00,  //....@@....
    0x03, 0xac, 0x00,  //...@%%@...
    0x0a, 0x0a, 0x00,  //..%%..%%..
    0x00, 0x00, 0x00,  //..........
    0x06, 0xfe, 0x00,  //..+%@@@%..
    0x2f, 0xff, 0xc0,  //.%@@@@@@@.
    0x7d, 0x03, 0xe0,  //+@@+...@@%
    0xf0, 0x00, 0xf0,  //@@......@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0x00,  //@@........
    0x7d, 0x00, 0x70,  //+@@+....+@
    0x2f, 0xff, 0xf0,  //.%@@@@@@@@
    0x06, 0xff, 0x80,  //..+%@@@@%.
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00eb (ë) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x0f, 0x0f, 0x00,  //..@@..@@..
    0x0f, 0x0f, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x06, 0xfe, 0x00,  //..+%@@@%..
    0x2f, 0xff, 0xc0,  //.%@@@@@@@.
    0x7d, 0x03, 0xe0,  //+@@+...@@%
    0xf0, 0x00, 0xf0,  //@@......@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0x00,  //@@........
    0x7d, 0x00, 0x70,  //+@@+....+@
    0x2f, 0xff, 0xf0,  //.%@@@@@@@@
    0x06, 0xff, 0x80,  //..+%@@@@%.
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00ec (ì) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xb0,  //%@..
    0x2c,  //.%@.
    0x0a,  //..%%
    0x00,  //....
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ed (í) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x0e,  //..@%
    0x38,  //.@%.
    0xa0,  //%%..
    0x00,  //....
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ee (î) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x0f, 0x00,  //..@@..
    0x3a, 0xc0,  //.@%%@.
    0xa0, 0xa0,  //%%..%%
    0x00, 0x00,  //......
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00ef (ï) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xf0, 0xf0,  //@@..@@
    0xf0, 0xf0,  //@@..@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x00,  //..@@..
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00f0 (ð) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x07, 0x01, 0x40,  //..+@...++.
    0x02, 0xfe, 0x00,  //...%@@@%..
    0x2f, 0xb0, 0x00,  //.%@@%@....
    0x10, 0x28, 0x00,  //.+...%%...
    0x07, 0xff, 0x00,  //..+@@@@%..
    0x2f, 0xff, 0xc0,  //.%@@@@@@@.
    0x7d, 0x03, 0xe0,  //+@@+...@@%
    0xf4, 0x00, 0xf0,  //@@+.....@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x2f, 0xff, 0x80,  //.%@@@@@@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f1 (ñ) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1f, 0x0c,  //.+@@..@.
    0x30, 0xf4,  //.@..@@+.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf2, 0xf8,  //@@.%@@%.
    0xfb, 0xfd,  //@@%@@@@+
    0xfc, 0x2f,  //@@@..%@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00f2 (ò) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x0b, 0x00, 0x00,  //..%@......
    0x02, 0xc0, 0x00,  //...%@.....
    0x00, 0xa0, 0x00,  //....%%....
    0x00, 0x00, 0x00,  //..........
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f3 (ó) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x38, 0x00,  //.....@%...
    0x00, 0xe0, 0x00,  //....@%....
    0x02, 0x80, 0x00,  //...%%.....
    0x00, 0x00, 0x00,  //..........
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f4 (ô) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0xf0, 0x00,  //....@@....
    0x03, 0xac, 0x00,  //...@%%@...
    0x0a, 0x0a, 0x00,  //..%%..%%..
    0x00, 0x00, 0x00,  //..........
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f5 (õ) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x07, 0xc3, 0x00,  //..+@@..@..
    0x0c, 0x3d, 0x00,  //..@..@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f6 (ö) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x0f, 0x0f, 0x00,  //..@@..@@..
    0x0f, 0x0f, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f7 (÷) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f8 (ø) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x04,  //..........+.
    0x01, 0xbe, 0x1c,  //...+%@@%.+@.
    0x07, 0xff, 0xf4,  //..+@@@@@@@+.
    0x1f, 0x41, 0xf0,  //.+@@+..+@@..
    0x3d, 0x03, 0xb8,  //.@@+...@%@%.
    0x3c, 0x1d, 0x3c,  //.@@...@+.@@.
    0x3c, 0x70, 0x3c,  //.@@.+@...@@.
    0x2e, 0xc0, 0x7c,  //.%@%@...+@@.
    0x0f, 0x41, 0xf4,  //..@@+..+@@+.
    0x1f, 0xff, 0xe0,  //.+@@@@@@@%..
    0x34, 0xbf, 0x40,  //.@+.%@@@+...
    0x10, 0x00, 0x00,  //.+..........
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f9 (ù) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x2c, 0x00,  //.%@.....
    0x0b, 0x00,  //..%@....
    0x02, 0x80,  //...%%...
    0x00, 0x00,  //........
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf8, 0x3f,  //@@%..@@@
    0x7f, 0xef,  //+@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00fa (ú) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0xe0,  //....@%..
    0x03, 0x80,  //...@%...
    0x0a, 0x00,  //..%%....
    0x00, 0x00,  //........
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf8, 0x3f,  //@@%..@@@
    0x7f, 0xef,  //+@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00fb (û) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x03, 0xc0,  //...@@...
    0x0e, 0xb0,  //..@%%@..
    0x28, 0x28,  //.%%..%%.
    0x00, 0x00,  //........
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf8, 0x3f,  //@@%..@@@
    0x7f, 0xef,  //+@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00fc (ü) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x3c, 0x3c,  //.@@..@@.
    0x3c, 0x3c,  //.@@..@@.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf8, 0x3f,  //@@%..@@@
    0x7f, 0xef,  //+@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00fd (ý) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x0e, 0x00,  //......@%....
    0x00, 0x38, 0x00,  //.....@%.....
    0x00, 0xa0, 0x00,  //....%%......
    0x00, 0x00, 0x00,  //............
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x2d, 0x00, 0x78,  //.%@+....+@%.
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0b, 0x41, 0xf0,  //..%@+..+@@..
    0x03, 0xc3, 0xd0,  //...@@..@@+..
    0x03, 0xd3, 0xc0,  //...@@+.@@...
    0x01, 0xeb, 0x40,  //...+@%%@+...
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x78, 0x00,  //....+@%.....
    0x00, 0xb0, 0x00,  //....%@......
    0x0f, 0xe0, 0x00,  //..@@@%......
    0x0f, 0x80, 0x00,  //..@@%.......


    /*Unicode: U+00fe (þ) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xfc, 0x0f, 0x80,  //@@@...@@%
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xfc, 0x0f, 0x80,  //@@@...@@%
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......


    /*Unicode: U+00ff (ÿ) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x03, 0xcf, 0x00,  //...@@.@@....
    0x03, 0xcf, 0x00,  //...@@.@@....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x2d, 0x00, 0x78,  //.%@+....+@%.
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0b, 0x41, 0xf0,  //..%@+..+@@..
    0x03, 0xc3, 0xd0,  //...@@..@@+..
    0x03, 0xd3, 0xc0,  //...@@+.@@...
    0x01, 0xeb, 0x40,  //...+@%%@+...
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x78, 0x00,  //....+@%.....
    0x00, 0xb0, 0x00,  //....%@......
    0x0f, 0xe0, 0x00,  //..@@@%......
    0x0f, 0x80, 0x00,  //..@@%.......



#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 4
    /*Unicode: U+00a0 ( ) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00a1 (¡) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0xdd,  //@@
    0xee,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..


    /*Unicode: U+00a2 (¢) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x0f, 0x00,  //.....@..
    0x00, 0x00, 0x0f, 0x00,  //.....@..
    0x00, 0x00, 0x0f, 0x00,  //.....@..
    0x00, 0x5b, 0xef, 0xd5,  //..+%@@@+
    0x0a, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x6f, 0xf7, 0x2f, 0x29,  //+@@+.@.%
    0xcf, 0x60, 0x0f, 0x00,  //@@+..@..
    0xff, 0x10, 0x0f, 0x00,  //@@...@..
    0xff, 0x10, 0x0f, 0x00,  //@@...@..
    0xcf, 0x60, 0x0f, 0x00,  //@@+..@..
    0x6f, 0xf7, 0x2f, 0x2a,  //+@@+.@.%
    0x0a, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x5b, 0xef, 0xd5,  //..+%@@@+
    0x00, 0x00, 0x0f, 0x00,  //.....@..
    0x00, 0x00, 0x0f, 0x00,  //.....@..
    0x00, 0x00, 0x0f, 0x00,  //.....@..
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00a3 (£) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x04, 0xbf, 0xfb, 0x30,  //...+%@@%.
    0x00, 0x4f, 0xff, 0xff, 0xf0,  //...@@@@@@
    0x00, 0xbf, 0xb2, 0x03, 0xa0,  //..%@%...%
    0x00, 0xef, 0x20, 0x00, 0x00,  //..@@.....
    0x00, 0xff, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0xff, 0x00, 0x00, 0x00,  //..@@.....
    0xff, 0xff, 0xff, 0xf0, 0x00,  //@@@@@@@..
    0xff, 0xff, 0xff, 0xf0, 0x00,  //@@@@@@@..
    0x00, 0xff, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0xff, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0xff, 0x00, 0x00, 0x00,  //..@@.....
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a4 (¤) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x97, 0x00, 0x00, 0x07, 0xa0,  //%+.....+%
    0x7f, 0x96, 0xe7, 0xaf, 0x70,  //+@%+@+%@+
    0x09, 0xff, 0xff, 0xf9, 0x00,  //.%@@@@@%.
    0x06, 0xf7, 0x07, 0xf6, 0x00,  //.+@+.+@+.
    0x0e, 0xf0, 0x00, 0xfe, 0x00,  //.@@...@@.
    0x06, 0xf7, 0x07, 0xf6, 0x00,  //.+@+.+@+.
    0x09, 0xff, 0xff, 0xf9, 0x00,  //.%@@@@@%.
    0x7f, 0x96, 0xe6, 0x9f, 0x70,  //+@%+@+%@+
    0x97, 0x00, 0x00, 0x07, 0x90,  //%+.....+%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a5 (¥) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xbf, 0x70, 0x00, 0x07, 0xfb,  //%@+....+@%
    0x3f, 0xe0, 0x00, 0x0e, 0xf3,  //.@@....@@.
    0x0b, 0xf6, 0x00, 0x6f, 0xb0,  //.%@+..+@%.
    0x03, 0xfd, 0x00, 0xdf, 0x30,  //..@@..@@..
    0x00, 0xbf, 0x44, 0xfb, 0x00,  //..%@++@%..
    0xff, 0xff, 0xbb, 0xff, 0xff,  //@@@@%%@@@@
    0x00, 0x08, 0xff, 0x80, 0x00,  //...%@@%...
    0x00, 0x01, 0xff, 0x00, 0x00,  //....@@....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00a6 (¦) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..


    /*Unicode: U+00a7 (§) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x02, 0xbf, 0xff, 0x00,  //..%@@@.
    0x0b, 0xff, 0xff, 0x00,  //.%@@@@.
    0x0f, 0xf4, 0x00, 0x00,  //.@@+...
    0x0b, 0xf1, 0x00, 0x00,  //.%@....
    0x03, 0xfa, 0x00, 0x00,  //..@%...
    0x5f, 0xa8, 0xe5, 0x00,  //+@%%@+.
    0xef, 0x00, 0xaf, 0x70,  //@@..%@+
    0xef, 0x20, 0x1f, 0xe0,  //@@...@@
    0x5f, 0xb0, 0x1f, 0xd0,  //+@%..@@
    0x03, 0xcb, 0xce, 0x30,  //..@%@@.
    0x00, 0x09, 0xf2, 0x00,  //...%@..
    0x00, 0x01, 0xfc, 0x00,  //....@@.
    0x00, 0x04, 0xff, 0x00,  //...+@@.
    0x0f, 0xff, 0xfb, 0x00,  //.@@@@%.
    0x0f, 0xff, 0xb1, 0x00,  //.@@@%..
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00a8 (¨) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xff, 0x00, 0xff,  //@@..@@
    0xff, 0x00, 0xff,  //@@..@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00a9 (©) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xae, 0xfe, 0xa3, 0x00, 0x00,  //....%@@@%....
    0x00, 0x9d, 0x61, 0x01, 0x6d, 0x90, 0x00,  //..%@+...+@%..
    0x09, 0xb0, 0x00, 0x00, 0x00, 0xb9, 0x00,  //.%%.......%%.
    0x3d, 0x00, 0x5c, 0xff, 0xf0, 0x0d, 0x30,  //.@..+@@@@..@.
    0xa6, 0x06, 0xd3, 0x00, 0x00, 0x06, 0xa0,  //%+.+@......+%
    0xe1, 0x0d, 0x30, 0x00, 0x00, 0x01, 0xe0,  //@..@........@
    0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xf0,  //@..@........@
    0xe1, 0x0d, 0x30, 0x00, 0x00, 0x01, 0xe0,  //@..@........@
    0xa6, 0x06, 0xd4, 0x02, 0x90, 0x06, 0xa0,  //%+.+@+..%..+%
    0x3e, 0x00, 0x5c, 0xfd, 0x60, 0x0d, 0x30,  //.@..+@@@+..@.
    0x09, 0xb0, 0x00, 0x00, 0x00, 0xb9, 0x00,  //.%%.......%%.
    0x00, 0x9d, 0x61, 0x01, 0x6d, 0x90, 0x00,  //..%@+...+@%..
    0x00, 0x03, 0xae, 0xfe, 0xa3, 0x00, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00aa (ª) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x0f, 0xff, 0xea, 0x20,  //.@@@@%..
    0x00, 0x00, 0x05, 0xc0,  //.....+@.
    0x08, 0xdf, 0xff, 0xf0,  //.%@@@@@.
    0xa9, 0x20, 0x00, 0xf0,  //%%....@.
    0xf0, 0x00, 0x04, 0xf0,  //@....+@.
    0xc8, 0x10, 0x5e, 0xf0,  //@%..+@@.
    0x1b, 0xef, 0xc4, 0xf0,  //.%@@@+@.
    0x00, 0x00, 0x00, 0x00,  //........
    0x9f, 0xff, 0xff, 0xf0,  //%@@@@@@.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ab («) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x08, 0x00, 0x08,  //...%...%
    0x00, 0xac, 0x00, 0xac,  //..%@..%@
    0x0b, 0xb0, 0x0b, 0xb0,  //.%%..%%.
    0xc9, 0x00, 0xc9, 0x00,  //@%..@%..
    0xc9, 0x00, 0xc9, 0x00,  //@%..@%..
    0x0b, 0xb0, 0x0b, 0xb0,  //.%%..%%.
    0x00, 0xac, 0x00, 0xac,  //..%@..%@
    0x00, 0x08, 0x00, 0x08,  //...%...%
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ac (¬) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00ad (­) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ae (®) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x03, 0xae, 0xfe, 0xa3, 0x00, 0x00,  //....%@@@%....
    0x00, 0x9d, 0x61, 0x01, 0x6d, 0x90, 0x00,  //..%@+...+@%..
    0x09, 0xb0, 0x00, 0x00, 0x00, 0xb9, 0x00,  //.%%.......%%.
    0x3d, 0x00, 0xff, 0xfd, 0x40, 0x0d, 0x30,  //.@..@@@@+..@.
    0xa6, 0x00, 0xf0, 0x04, 0xe0, 0x06, 0xa0,  //%+..@..+@..+%
    0xe1, 0x00, 0xf0, 0x04, 0xe0, 0x01, 0xe0,  //@...@..+@...@
    0xf0, 0x00, 0xff, 0xfe, 0x40, 0x00, 0xf0,  //@...@@@@+...@
    0xe1, 0x00, 0xf0, 0x5f, 0x30, 0x01, 0xe0,  //@...@.+@....@
    0xa6, 0x00, 0xf0, 0x07, 0xd0, 0x06, 0xa0,  //%+..@..+@..+%
    0x3e, 0x00, 0xf0, 0x00, 0xd9, 0x0d, 0x30,  //.@..@...@%.@.
    0x09, 0xb0, 0x00, 0x00, 0x00, 0xb9, 0x00,  //.%%.......%%.
    0x00, 0x9d, 0x61, 0x01, 0x6d, 0x90, 0x00,  //..%@+...+@%..
    0x00, 0x03, 0xae, 0xfe, 0xa3, 0x00, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00af (¯) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b0 (°) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x08, 0xee, 0x80,  //.%@@%.
    0x8b, 0x11, 0xb8,  //%%..%%
    0xe1, 0x00, 0x1e,  //@....@
    0xe1, 0x00, 0x1e,  //@....@
    0x9b, 0x11, 0xb8,  //%%..%%
    0x09, 0xee, 0x80,  //.%@@%.
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00b1 (±) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00b2 (²) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x5d, 0xfc, 0x30,  //+@@@.
    0xa2, 0x06, 0xe0,  //%..+@
    0x00, 0x02, 0xd0,  //....@
    0x00, 0x1d, 0x30,  //...@.
    0x03, 0xd5, 0x00,  //..@+.
    0x5e, 0x40, 0x00,  //+@+..
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b3 (³) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xfd, 0x60,  //@@@@+
    0x00, 0x05, 0xe0,  //...+@
    0x0f, 0xff, 0x40,  //.@@@+
    0x00, 0x18, 0xc0,  //...%@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x08, 0xc0,  //...+@
    0xff, 0xeb, 0x20,  //@@@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b4 (´) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x01, 0xe8,  //..@%
    0x0c, 0xa0,  //.@%.
    0x9b, 0x00,  //%%..
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00b5 (µ) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@....@@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@....@@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@....@@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@....@@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@....@@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@....@@.
    0xff, 0x10, 0x02, 0xff, 0x00,  //@@....@@.
    0xff, 0x91, 0x1b, 0xff, 0x10,  //@@%..%@@.
    0xff, 0xcf, 0xfd, 0xcf, 0xf0,  //@@@@@@@@@
    0xff, 0x3d, 0xe3, 0x5f, 0xb0,  //@@.@@.+@%
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......


    /*Unicode: U+00b6 (¶) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x03, 0xbf, 0xff, 0xff,  //..%@@@@@
    0x4f, 0xff, 0xf0, 0x0f,  //+@@@@..@
    0xcf, 0xff, 0xf0, 0x0f,  //@@@@@..@
    0xff, 0xff, 0xf0, 0x0f,  //@@@@@..@
    0xef, 0xff, 0xf0, 0x0f,  //@@@@@..@
    0x8f, 0xff, 0xf0, 0x0f,  //%@@@@..@
    0x09, 0xff, 0xf0, 0x0f,  //.%@@@..@
    0x00, 0x15, 0xf0, 0x0f,  //...+@..@
    0x00, 0x00, 0xf0, 0x0f,  //....@..@
    0x00, 0x00, 0xf0, 0x0f,  //....@..@
    0x00, 0x00, 0xf0, 0x0f,  //....@..@
    0x00, 0x00, 0xf0, 0x0f,  //....@..@
    0x00, 0x00, 0xf0, 0x0f,  //....@..@
    0x00, 0x00, 0xf0, 0x0f,  //....@..@
    0x00, 0x00, 0xf0, 0x0f,  //....@..@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b7 (·) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b8 (¸) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0xf7,  //..@+
    0x02, 0xfe,  //..@@
    0xef, 0xe8,  //@@@+
    0x00, 0x00,  //....


    /*Unicode: U+00b9 (¹) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xf0, 0x00,  //@@@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ba (º) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x06, 0xdf, 0xd6, 0x00,  //.+@@@+.
    0x6d, 0x30, 0x3d, 0x60,  //+@...@+
    0xd3, 0x00, 0x03, 0xd0,  //@.....@
    0xf0, 0x00, 0x00, 0xf0,  //@.....@
    0xd3, 0x00, 0x03, 0xd0,  //@.....@
    0x6d, 0x30, 0x3d, 0x60,  //+@...@+
    0x06, 0xdf, 0xd6, 0x00,  //.+@@@+.
    0x00, 0x00, 0x00, 0x00,  //.......
    0xbf, 0xff, 0xff, 0xb0,  //%@@@@@%
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00bb (») , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x80, 0x00, 0x80, 0x00,  //%...%...
    0xc9, 0x00, 0xc9, 0x00,  //@%..@%..
    0x0b, 0xb0, 0x0b, 0xb0,  //.%%..%%.
    0x00, 0x9c, 0x00, 0x9c,  //..%@..%@
    0x00, 0x9c, 0x00, 0x9c,  //..%@..%@
    0x0b, 0xb0, 0x0b, 0xb0,  //.%%..%%.
    0xca, 0x00, 0xca, 0x00,  //@%..@%..
    0x80, 0x00, 0x80, 0x00,  //%...%...
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00bc (¼) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x08, 0xa0, 0x00,  //@@@........%%...
    0x00, 0xf0, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x00,  //..@........@....
    0x00, 0xf0, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00,  //..@.......@+....
    0x00, 0xf0, 0x00, 0x00, 0x09, 0x90, 0x00, 0x00,  //..@......%%.....
    0x00, 0xf0, 0x00, 0x00, 0x4e, 0x00, 0x00, 0x00,  //..@......@......
    0x00, 0xf0, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00,  //..@.....@+......
    0xff, 0xff, 0xf0, 0x09, 0x90, 0x00, 0x1d, 0xf0,  //@@@@@..%%....@@.
    0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0xc6, 0xf0,  //......+@....%+@.
    0x00, 0x00, 0x00, 0xe3, 0x00, 0x0a, 0x70, 0xf0,  //......@....%+.@.
    0x00, 0x00, 0x0a, 0x80, 0x00, 0x87, 0x00, 0xf0,  //.....%%...%+..@.
    0x00, 0x00, 0x4d, 0x00, 0x00, 0xff, 0xff, 0xff,  //....+@....@@@@@@
    0x00, 0x01, 0xe3, 0x00, 0x00, 0x00, 0x00, 0xf0,  //....@.........@.
    0x00, 0x0a, 0x80, 0x00, 0x00, 0x00, 0x00, 0xf0,  //...%%.........@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00bd (½) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xf0, 0x00, 0x00, 0x00, 0x08, 0xa0, 0x00,  //@@@........%%..
    0x00, 0xf0, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x00,  //..@........@...
    0x00, 0xf0, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00,  //..@.......@+...
    0x00, 0xf0, 0x00, 0x00, 0x09, 0x90, 0x00, 0x00,  //..@......%%....
    0x00, 0xf0, 0x00, 0x00, 0x4e, 0x00, 0x00, 0x00,  //..@......@.....
    0x00, 0xf0, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00,  //..@.....@+.....
    0xff, 0xff, 0xf0, 0x09, 0x90, 0x5d, 0xfc, 0x30,  //@@@@@..%%.+@@@.
    0x00, 0x00, 0x00, 0x4d, 0x00, 0xa2, 0x06, 0xe0,  //......+@..%..+@
    0x00, 0x00, 0x00, 0xe3, 0x00, 0x00, 0x02, 0xd0,  //......@.......@
    0x00, 0x00, 0x0a, 0x80, 0x00, 0x00, 0x1d, 0x30,  //.....%%......@.
    0x00, 0x00, 0x4d, 0x00, 0x00, 0x03, 0xd5, 0x00,  //....+@......@+.
    0x00, 0x01, 0xe3, 0x00, 0x00, 0x5e, 0x40, 0x00,  //....@.....+@+..
    0x00, 0x0a, 0x80, 0x00, 0x00, 0xff, 0xff, 0xf0,  //...%%.....@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00be (¾) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xfd, 0x60, 0x00, 0x00, 0x08, 0xa0, 0x00,  //@@@@+......%%...
    0x00, 0x05, 0xe0, 0x00, 0x00, 0x3e, 0x10, 0x00,  //...+@......@....
    0x0f, 0xff, 0x40, 0x00, 0x00, 0xd4, 0x00, 0x00,  //.@@@+.....@+....
    0x00, 0x18, 0xc0, 0x00, 0x09, 0x90, 0x00, 0x00,  //...%@....%%.....
    0x00, 0x00, 0xf0, 0x00, 0x4e, 0x00, 0x00, 0x00,  //....@....@......
    0x00, 0x08, 0xc0, 0x00, 0xd4, 0x00, 0x00, 0x00,  //...+@...@+......
    0xff, 0xeb, 0x20, 0x09, 0x90, 0x00, 0x1d, 0xf0,  //@@@%...%%....@@.
    0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0xc6, 0xf0,  //......+@....%+@.
    0x00, 0x00, 0x00, 0xe3, 0x00, 0x0a, 0x70, 0xf0,  //......@....%+.@.
    0x00, 0x00, 0x0a, 0x80, 0x00, 0x87, 0x00, 0xf0,  //.....%%...%+..@.
    0x00, 0x00, 0x4d, 0x00, 0x00, 0xff, 0xff, 0xff,  //....+@....@@@@@@
    0x00, 0x01, 0xe3, 0x00, 0x00, 0x00, 0x00, 0xf0,  //....@.........@.
    0x00, 0x0a, 0x80, 0x00, 0x00, 0x00, 0x00, 0xf0,  //...%%.........@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00bf (¿) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x0f, 0xf0, 0x00,  //...@@..
    0x00, 0x0f, 0xf0, 0x00,  //...@@..
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x0f, 0xf0, 0x00,  //...@@..
    0x00, 0x0f, 0xf0, 0x00,  //...@@..
    0x00, 0x1f, 0xe0, 0x00,  //...@@..
    0x00, 0x8f, 0x70, 0x00,  //..%@+..
    0x05, 0xf9, 0x00, 0x00,  //.+@%...
    0x3f, 0xb0, 0x00, 0x00,  //.@%....
    0xcf, 0x20, 0x00, 0x00,  //@@.....
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0xdf, 0x91, 0x04, 0xc0,  //@@%..+@
    0x6f, 0xff, 0xff, 0xf0,  //+@@@@@@
    0x05, 0xdf, 0xea, 0x40,  //.+@@@%.


    /*Unicode: U+00c0 (À) , Width: 12 */
    0x00, 0x00, 0x7f, 0xe2, 0x00, 0x00,  //....+@@.....
    0x00, 0x00, 0x07, 0xfd, 0x10, 0x00,  //.....+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x5f, 0xf5, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //....@@@@....
    0x00, 0x02, 0xfc, 0xcf, 0x20, 0x00,  //....@@@@....
    0x00, 0x09, 0xf6, 0x5f, 0x90, 0x00,  //...%@++@%...
    0x00, 0x0e, 0xf0, 0x0e, 0xe0, 0x00,  //...@@..@@...
    0x00, 0x5f, 0xa0, 0x08, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0xcf, 0x30, 0x02, 0xfc, 0x00,  //..@@....@@..
    0x02, 0xff, 0xff, 0xff, 0xff, 0x20,  //..@@@@@@@@..
    0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //.%@@@@@@@@%.
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@.
    0x6f, 0xb0, 0x00, 0x00, 0x0b, 0xf6,  //+@%......%@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c1 (Á) , Width: 12 */
    0x00, 0x00, 0x00, 0xbc, 0x00, 0x00,  //......%@....
    0x00, 0x00, 0x09, 0xc0, 0x00, 0x00,  //.....%@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x5f, 0xf5, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //....@@@@....
    0x00, 0x02, 0xfc, 0xcf, 0x20, 0x00,  //....@@@@....
    0x00, 0x09, 0xf6, 0x5f, 0x90, 0x00,  //...%@++@%...
    0x00, 0x0e, 0xf0, 0x0e, 0xe0, 0x00,  //...@@..@@...
    0x00, 0x5f, 0xa0, 0x08, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0xcf, 0x30, 0x02, 0xfc, 0x00,  //..@@....@@..
    0x02, 0xff, 0xff, 0xff, 0xff, 0x20,  //..@@@@@@@@..
    0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //.%@@@@@@@@%.
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@.
    0x6f, 0xb0, 0x00, 0x00, 0x0b, 0xf6,  //+@%......%@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c2 (Â) , Width: 12 */
    0x00, 0x00, 0x1d, 0xd1, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0xa5, 0x5a, 0x00, 0x00,  //....%++%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x5f, 0xf5, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //....@@@@....
    0x00, 0x02, 0xfc, 0xcf, 0x20, 0x00,  //....@@@@....
    0x00, 0x09, 0xf6, 0x5f, 0x90, 0x00,  //...%@++@%...
    0x00, 0x0e, 0xf0, 0x0e, 0xe0, 0x00,  //...@@..@@...
    0x00, 0x5f, 0xa0, 0x08, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0xcf, 0x30, 0x02, 0xfc, 0x00,  //..@@....@@..
    0x02, 0xff, 0xff, 0xff, 0xff, 0x20,  //..@@@@@@@@..
    0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //.%@@@@@@@@%.
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@.
    0x6f, 0xb0, 0x00, 0x00, 0x0b, 0xf6,  //+@%......%@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c3 (Ã) , Width: 12 */
    0x00, 0x06, 0xfc, 0x42, 0xe0, 0x00,  //...+@@+.@...
    0x00, 0x0e, 0x24, 0xcf, 0x60, 0x00,  //...@.+@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x5f, 0xf5, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //....@@@@....
    0x00, 0x02, 0xfc, 0xcf, 0x20, 0x00,  //....@@@@....
    0x00, 0x09, 0xf6, 0x5f, 0x90, 0x00,  //...%@++@%...
    0x00, 0x0e, 0xf0, 0x0e, 0xe0, 0x00,  //...@@..@@...
    0x00, 0x5f, 0xa0, 0x08, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0xcf, 0x30, 0x02, 0xfc, 0x00,  //..@@....@@..
    0x02, 0xff, 0xff, 0xff, 0xff, 0x20,  //..@@@@@@@@..
    0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //.%@@@@@@@@%.
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@.
    0x6f, 0xb0, 0x00, 0x00, 0x0b, 0xf6,  //+@%......%@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c4 (Ä) , Width: 12 */
    0x00, 0x0f, 0xf0, 0x0f, 0xf0, 0x00,  //...@@..@@...
    0x00, 0x0f, 0xf0, 0x0f, 0xf0, 0x00,  //...@@..@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x5f, 0xf5, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //....@@@@....
    0x00, 0x02, 0xfc, 0xcf, 0x20, 0x00,  //....@@@@....
    0x00, 0x09, 0xf6, 0x5f, 0x90, 0x00,  //...%@++@%...
    0x00, 0x0e, 0xf0, 0x0e, 0xe0, 0x00,  //...@@..@@...
    0x00, 0x5f, 0xa0, 0x08, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0xcf, 0x30, 0x02, 0xfc, 0x00,  //..@@....@@..
    0x02, 0xff, 0xff, 0xff, 0xff, 0x20,  //..@@@@@@@@..
    0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //.%@@@@@@@@%.
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@.
    0x6f, 0xb0, 0x00, 0x00, 0x0b, 0xf6,  //+@%......%@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c5 (Å) , Width: 12 */
    0x00, 0x00, 0xc5, 0x5c, 0x00, 0x00,  //....@++@....
    0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00,  //....@..@....
    0x00, 0x00, 0xd5, 0x5c, 0x00, 0x00,  //....@++@....
    0x00, 0x00, 0x3f, 0xf3, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x5f, 0xf5, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0xbf, 0xfb, 0x00, 0x00,  //....%@@%....
    0x00, 0x02, 0xfd, 0xdf, 0x20, 0x00,  //....@@@@....
    0x00, 0x08, 0xf7, 0x7f, 0x80, 0x00,  //...%@++@%...
    0x00, 0x0e, 0xf1, 0x1f, 0xe0, 0x00,  //...@@..@@...
    0x00, 0x5f, 0xb0, 0x0b, 0xf5, 0x00,  //..+@%..%@+..
    0x00, 0xcf, 0x50, 0x05, 0xfc, 0x00,  //..@@+..+@@..
    0x02, 0xff, 0xff, 0xff, 0xff, 0x20,  //..@@@@@@@@..
    0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //.%@@@@@@@@%.
    0x0f, 0xf2, 0x00, 0x00, 0x2f, 0xe0,  //.@@......@@.
    0x6f, 0xc0, 0x00, 0x00, 0x0c, 0xf6,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c6 (Æ) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....%@@@@@@@@@@
    0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x00, 0x7f, 0xa0, 0xff, 0x00, 0x00, 0x00,  //....+@%.@@......
    0x00, 0x00, 0xef, 0x30, 0xff, 0x00, 0x00, 0x00,  //....@@..@@......
    0x00, 0x05, 0xfb, 0x00, 0xff, 0x00, 0x00, 0x00,  //...+@%..@@......
    0x00, 0x0c, 0xf4, 0x00, 0xff, 0xff, 0xff, 0xff,  //...@@...@@@@@@@@
    0x00, 0x3f, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff,  //...@@...@@@@@@@@
    0x00, 0xaf, 0x40, 0x00, 0xff, 0x00, 0x00, 0x00,  //..%@+...@@......
    0x01, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@@@@@@@......
    0x07, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //.+@@@@@@@@......
    0x0e, 0xf4, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //.@@.....@@......
    0x5f, 0xd0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,  //+@@.....@@@@@@@@
    0xcf, 0x60, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,  //@@+.....@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00c7 (Ç) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x05, 0xbe, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x0c, 0xfe, 0x61, 0x00, 0x26, 0xc0,  //.@@@+....+@
    0x6f, 0xd1, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0xbf, 0x50, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0xef, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xef, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xbf, 0x50, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0x6f, 0xd1, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0x0c, 0xfe, 0x61, 0x00, 0x26, 0xc0,  //.@@@+....+@
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x00, 0x06, 0xbe, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x0f, 0x70, 0x00,  //.......@+..
    0x00, 0x00, 0x00, 0x2f, 0xe0, 0x00,  //.......@@..
    0x00, 0x00, 0x0e, 0xfe, 0x80, 0x00,  //.....@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00c8 (È) , Width: 8 */
    0x07, 0xfe, 0x20, 0x00,  //.+@@....
    0x00, 0x7f, 0xd1, 0x00,  //..+@@...
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00c9 (É) , Width: 8 */
    0x00, 0x0b, 0xc0, 0x00,  //...%@...
    0x00, 0x9c, 0x00, 0x00,  //..%@....
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ca (Ê) , Width: 8 */
    0x00, 0xae, 0xa0, 0x00,  //..%@%...
    0x09, 0xa0, 0xa9, 0x00,  //.%%.%%..
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00cb (Ë) , Width: 8 */
    0x0f, 0xf0, 0x0f, 0xf0,  //.@@..@@.
    0x0f, 0xf0, 0x0f, 0xf0,  //.@@..@@.
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00cc (Ì) , Width: 5 */
    0x7f, 0xe2, 0x00,  //+@@..
    0x07, 0xfd, 0x10,  //.+@@.
    0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00cd (Í) , Width: 4 */
    0x0b, 0xc0,  //.%@.
    0x9c, 0x00,  //%@..
    0x00, 0x00,  //....
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00ce (Î) , Width: 6 */
    0x07, 0xee, 0x70,  //.+@@+.
    0x7d, 0x22, 0xd7,  //+@..@+
    0x00, 0x00, 0x00,  //......
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00cf (Ï) , Width: 6 */
    0xff, 0x00, 0xff,  //@@..@@
    0xff, 0x00, 0xff,  //@@..@@
    0x00, 0x00, 0x00,  //......
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00d0 (Ð) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0xff, 0xff, 0xfe, 0xb6, 0x00, 0x00,  //..@@@@@@%+...
    0x00, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..@@@@@@@@@..
    0x00, 0xff, 0x00, 0x01, 0x5d, 0xfe, 0x10,  //..@@....+@@@.
    0x00, 0xff, 0x00, 0x00, 0x00, 0xcf, 0x80,  //..@@......@@+
    0x00, 0xff, 0x00, 0x00, 0x00, 0x4f, 0xc0,  //..@@......+@@
    0xff, 0xff, 0xff, 0xf0, 0x00, 0x1f, 0xe0,  //@@@@@@@....@@
    0xff, 0xff, 0xff, 0xf0, 0x00, 0x0f, 0xf0,  //@@@@@@@....@@
    0x00, 0xff, 0x00, 0x00, 0x00, 0x1f, 0xe0,  //..@@.......@@
    0x00, 0xff, 0x00, 0x00, 0x00, 0x5f, 0xc0,  //..@@......+@@
    0x00, 0xff, 0x00, 0x00, 0x00, 0xcf, 0x70,  //..@@......@@+
    0x00, 0xff, 0x00, 0x01, 0x5d, 0xfe, 0x10,  //..@@....+@@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //..@@@@@@@@@..
    0x00, 0xff, 0xff, 0xfe, 0xb6, 0x00, 0x00,  //..@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00d1 (Ñ) , Width: 10 */
    0x00, 0x6f, 0xc4, 0x2e, 0x00,  //..+@@+.@..
    0x00, 0xe2, 0x4c, 0xf6, 0x00,  //..@.+@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x80, 0x00, 0x00, 0xff,  //@@%.....@@
    0xff, 0xf2, 0x00, 0x00, 0xff,  //@@@.....@@
    0xff, 0xfb, 0x00, 0x00, 0xff,  //@@@%....@@
    0xff, 0xbf, 0x40, 0x00, 0xff,  //@@%@+...@@
    0xff, 0x2f, 0xd0, 0x00, 0xff,  //@@.@@...@@
    0xff, 0x08, 0xf7, 0x00, 0xff,  //@@.%@+..@@
    0xff, 0x01, 0xef, 0x10, 0xff,  //@@..@@..@@
    0xff, 0x00, 0x6f, 0xa0, 0xff,  //@@..+@%.@@
    0xff, 0x00, 0x0d, 0xf4, 0xff,  //@@...@@.@@
    0xff, 0x00, 0x04, 0xfd, 0xff,  //@@...+@@@@
    0xff, 0x00, 0x00, 0xaf, 0xff,  //@@....%@@@
    0xff, 0x00, 0x00, 0x2f, 0xff,  //@@.....@@@
    0xff, 0x00, 0x00, 0x08, 0xff,  //@@.....%@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00d2 (Ò) , Width: 12 */
    0x00, 0x00, 0x7f, 0xe2, 0x00, 0x00,  //....+@@.....
    0x00, 0x00, 0x07, 0xfd, 0x10, 0x00,  //.....+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x07, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x00, 0x08, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d3 (Ó) , Width: 12 */
    0x00, 0x00, 0x00, 0xbc, 0x00, 0x00,  //......%@....
    0x00, 0x00, 0x09, 0xc0, 0x00, 0x00,  //.....%@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x07, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x00, 0x08, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d4 (Ô) , Width: 12 */
    0x00, 0x00, 0x1d, 0xd1, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0xa5, 0x5a, 0x00, 0x00,  //....%++%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x07, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x00, 0x08, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d5 (Õ) , Width: 12 */
    0x00, 0x06, 0xfc, 0x42, 0xe0, 0x00,  //...+@@+.@...
    0x00, 0x0e, 0x24, 0xcf, 0x60, 0x00,  //...@.+@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x07, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x00, 0x08, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d6 (Ö) , Width: 12 */
    0x00, 0x0f, 0xf0, 0x0f, 0xf0, 0x00,  //...@@..@@...
    0x00, 0x0f, 0xf0, 0x0f, 0xf0, 0x00,  //...@@..@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x07, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x00, 0x08, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d7 (×) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x3c, 0x40, 0x00, 0x04, 0xc3,  //.@+....+@.
    0x8f, 0xf4, 0x00, 0x4f, 0xf8,  //%@@+..+@@%
    0x08, 0xff, 0x44, 0xff, 0x80,  //.%@@++@@%.
    0x00, 0x8f, 0xff, 0xf8, 0x00,  //..%@@@@%..
    0x00, 0x08, 0xff, 0x80, 0x00,  //...%@@%...
    0x00, 0x08, 0xff, 0x80, 0x00,  //...%@@%...
    0x00, 0x8f, 0xff, 0xf8, 0x00,  //..%@@@@%..
    0x08, 0xff, 0x55, 0xff, 0x80,  //.%@@++@@%.
    0x8f, 0xf5, 0x00, 0x5f, 0xf8,  //%@@+..+@@%
    0x3c, 0x50, 0x00, 0x04, 0xc3,  //.@+....+@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00d8 (Ø) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,  //..............
    0x00, 0x01, 0x8d, 0xfe, 0xb3, 0x06, 0xd0,  //....%@@@%..+@.
    0x00, 0x3e, 0xff, 0xff, 0xff, 0x7f, 0x60,  //...@@@@@@@+@+.
    0x01, 0xef, 0xc4, 0x00, 0x4d, 0xfb, 0x00,  //..@@@+..+@@%..
    0x08, 0xfd, 0x00, 0x00, 0x0c, 0xff, 0x20,  //.%@@.....@@@..
    0x0c, 0xf5, 0x00, 0x00, 0xca, 0x6f, 0x90,  //.@@+....@%+@%.
    0x0f, 0xf1, 0x00, 0x0b, 0xa0, 0x1f, 0xd0,  //.@@....%%..@@.
    0x0f, 0xf0, 0x00, 0xbb, 0x00, 0x0f, 0xf0,  //.@@...%%...@@.
    0x0d, 0xf1, 0x0a, 0xb0, 0x00, 0x1f, 0xf0,  //.@@..%%....@@.
    0x09, 0xf5, 0xac, 0x00, 0x00, 0x5f, 0xc0,  //.%@+%@....+@@.
    0x02, 0xff, 0xc0, 0x00, 0x00, 0xdf, 0x80,  //..@@@.....@@%.
    0x00, 0xbf, 0xd4, 0x00, 0x4c, 0xfe, 0x10,  //..%@@+..+@@@..
    0x04, 0xf7, 0xff, 0xff, 0xff, 0xe3, 0x00,  //.+@+@@@@@@@...
    0x0d, 0x60, 0x3b, 0xef, 0xd8, 0x10, 0x00,  //.@+..%@@@%....
    0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00d9 (Ù) , Width: 10 */
    0x00, 0x7f, 0xe2, 0x00, 0x00,  //..+@@.....
    0x00, 0x07, 0xfd, 0x10, 0x00,  //...+@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xef, 0x10, 0x00, 0x01, 0xfe,  //@@......@@
    0xcf, 0x50, 0x00, 0x05, 0xfc,  //@@+....+@@
    0x6f, 0xe5, 0x11, 0x5e, 0xf6,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00da (Ú) , Width: 10 */
    0x00, 0x00, 0xbc, 0x00, 0x00,  //....%@....
    0x00, 0x09, 0xc0, 0x00, 0x00,  //...%@.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xef, 0x10, 0x00, 0x01, 0xfe,  //@@......@@
    0xcf, 0x50, 0x00, 0x05, 0xfc,  //@@+....+@@
    0x6f, 0xe5, 0x11, 0x5e, 0xf6,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00db (Û) , Width: 10 */
    0x00, 0x01, 0xdd, 0x10, 0x00,  //....@@....
    0x00, 0x0a, 0x55, 0xa0, 0x00,  //...%++%...
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xef, 0x10, 0x00, 0x01, 0xfe,  //@@......@@
    0xcf, 0x50, 0x00, 0x05, 0xfc,  //@@+....+@@
    0x6f, 0xe5, 0x11, 0x5e, 0xf6,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00dc (Ü) , Width: 10 */
    0x00, 0xff, 0x00, 0xff, 0x00,  //..@@..@@..
    0x00, 0xff, 0x00, 0xff, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xef, 0x10, 0x00, 0x01, 0xfe,  //@@......@@
    0xcf, 0x50, 0x00, 0x05, 0xfc,  //@@+....+@@
    0x6f, 0xe5, 0x11, 0x5e, 0xf6,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00dd (Ý) , Width: 12 */
    0x00, 0x00, 0x0b, 0xc0, 0x00, 0x00,  //.....%@.....
    0x00, 0x00, 0x9c, 0x00, 0x00, 0x00,  //....%@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xaf, 0xc0, 0x00, 0x00, 0x0c, 0xfa,  //%@@......@@%
    0x0d, 0xf7, 0x00, 0x00, 0x7f, 0xd0,  //.@@+....+@@.
    0x03, 0xff, 0x20, 0x02, 0xff, 0x30,  //..@@....@@..
    0x00, 0x6f, 0xb0, 0x0b, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0x0b, 0xf6, 0x6f, 0xb0, 0x00,  //...%@++@%...
    0x00, 0x01, 0xef, 0xfe, 0x10, 0x00,  //....@@@@....
    0x00, 0x00, 0x3f, 0xf3, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00de (Þ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xfc, 0x40,  //@@@@@%+.
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@+
    0xff, 0x00, 0x1a, 0xfc,  //@@...%@@
    0xff, 0x00, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x1a, 0xfc,  //@@...%@@
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@+
    0xff, 0xff, 0xfc, 0x40,  //@@@@@@+.
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00df (ß) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x04, 0xbf, 0xfc, 0x40, 0x00,  //.+%@@@+..
    0x4f, 0xff, 0xff, 0xf3, 0x00,  //+@@@@@@..
    0xcf, 0x91, 0x19, 0xfb, 0x00,  //@@%..%@%.
    0xff, 0x10, 0x04, 0xfe, 0x00,  //@@....@@.
    0xff, 0x00, 0x7f, 0xc5, 0x00,  //@@..+@@+.
    0xff, 0x00, 0xef, 0x10, 0x00,  //@@..@@...
    0xff, 0x00, 0xef, 0x00, 0x00,  //@@..@@...
    0xff, 0x00, 0x3d, 0x80, 0x00,  //@@...@%..
    0xff, 0x00, 0x00, 0xed, 0x10,  //@@....@@.
    0xff, 0x00, 0x00, 0x3f, 0xb0,  //@@.....@%
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x0a, 0x20, 0x7f, 0xd0,  //@@.%..+@@
    0xff, 0x0f, 0xff, 0xff, 0x70,  //@@.@@@@@+
    0xff, 0x05, 0xdf, 0xd7, 0x00,  //@@.+@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00e0 (à) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x8e, 0x10, 0x00,  //..%@....
    0x00, 0x0a, 0xc0, 0x00,  //...%@...
    0x00, 0x00, 0xb9, 0x00,  //....%%..
    0x00, 0x00, 0x00, 0x00,  //........
    0x04, 0xbe, 0xfc, 0x40,  //.+%@@@+.
    0x0f, 0xff, 0xff, 0xf3,  //.@@@@@@.
    0x0a, 0x30, 0x2a, 0xfa,  //.%...%@%
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x07, 0xcf, 0xff, 0xff,  //.+@@@@@@
    0x8f, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xef, 0x51, 0x01, 0xff,  //@@+...@@
    0xef, 0x40, 0x2a, 0xff,  //@@+..%@@
    0xaf, 0xff, 0xfa, 0xff,  //%@@@@%@@
    0x1a, 0xee, 0x90, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e1 (á) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x1e, 0x80,  //.....@%.
    0x00, 0x00, 0xca, 0x00,  //....@%..
    0x00, 0x09, 0xb0, 0x00,  //...%%...
    0x00, 0x00, 0x00, 0x00,  //........
    0x04, 0xbe, 0xfc, 0x40,  //.+%@@@+.
    0x0f, 0xff, 0xff, 0xf3,  //.@@@@@@.
    0x0a, 0x30, 0x2a, 0xfa,  //.%...%@%
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x07, 0xcf, 0xff, 0xff,  //.+@@@@@@
    0x8f, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xef, 0x51, 0x01, 0xff,  //@@+...@@
    0xef, 0x40, 0x2a, 0xff,  //@@+..%@@
    0xaf, 0xff, 0xfa, 0xff,  //%@@@@%@@
    0x1a, 0xee, 0x90, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e2 (â) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x2f, 0xf2, 0x00,  //...@@...
    0x00, 0xc9, 0x9c, 0x00,  //..@%%@..
    0x09, 0xb0, 0x0b, 0x90,  //.%%..%%.
    0x00, 0x00, 0x00, 0x00,  //........
    0x04, 0xbe, 0xfc, 0x40,  //.+%@@@+.
    0x0f, 0xff, 0xff, 0xf3,  //.@@@@@@.
    0x0a, 0x30, 0x2a, 0xfa,  //.%...%@%
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x07, 0xcf, 0xff, 0xff,  //.+@@@@@@
    0x8f, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xef, 0x51, 0x01, 0xff,  //@@+...@@
    0xef, 0x40, 0x2a, 0xff,  //@@+..%@@
    0xaf, 0xff, 0xfa, 0xff,  //%@@@@%@@
    0x1a, 0xee, 0x90, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e3 (ã) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x06, 0xfc, 0x32, 0xe0,  //.+@@..@.
    0x0e, 0x23, 0xcf, 0x60,  //.@..@@+.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x04, 0xbe, 0xfc, 0x40,  //.+%@@@+.
    0x0f, 0xff, 0xff, 0xf3,  //.@@@@@@.
    0x0a, 0x30, 0x2a, 0xfa,  //.%...%@%
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x07, 0xcf, 0xff, 0xff,  //.+@@@@@@
    0x8f, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xef, 0x51, 0x01, 0xff,  //@@+...@@
    0xef, 0x40, 0x2a, 0xff,  //@@+..%@@
    0xaf, 0xff, 0xfa, 0xff,  //%@@@@%@@
    0x1a, 0xee, 0x90, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e4 (ä) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x0f, 0xf0, 0x0f, 0xf0,  //.@@..@@.
    0x0f, 0xf0, 0x0f, 0xf0,  //.@@..@@.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x04, 0xbe, 0xfc, 0x40,  //.+%@@@+.
    0x0f, 0xff, 0xff, 0xf3,  //.@@@@@@.
    0x0a, 0x30, 0x2a, 0xfa,  //.%...%@%
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x07, 0xcf, 0xff, 0xff,  //.+@@@@@@
    0x8f, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xef, 0x51, 0x01, 0xff,  //@@+...@@
    0xef, 0x40, 0x2a, 0xff,  //@@+..%@@
    0xaf, 0xff, 0xfa, 0xff,  //%@@@@%@@
    0x1a, 0xee, 0x90, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e5 (å) , Width: 8 */
    0x00, 0x1b, 0xfb, 0x10,  //...%@%..
    0x00, 0xb7, 0x07, 0xb0,  //..%+.+%.
    0x00, 0xf0, 0x00, 0xf0,  //..@...@.
    0x00, 0xb7, 0x07, 0xb0,  //..%+.+%.
    0x00, 0x2b, 0xfb, 0x10,  //...%@%..
    0x00, 0x00, 0x00, 0x00,  //........
    0x04, 0xbe, 0xfc, 0x40,  //.+%@@@+.
    0x0f, 0xff, 0xff, 0xf3,  //.@@@@@@.
    0x0a, 0x30, 0x2a, 0xfa,  //.%...%@%
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x07, 0xcf, 0xff, 0xff,  //.+@@@@@@
    0x8f, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xef, 0x51, 0x01, 0xff,  //@@+...@@
    0xef, 0x40, 0x2a, 0xff,  //@@+..%@@
    0xaf, 0xff, 0xfa, 0xff,  //%@@@@%@@
    0x1a, 0xee, 0x90, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e6 (æ) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x04, 0xbf, 0xea, 0x20, 0x4c, 0xfe, 0xa1, 0x00,  //.+%@@%...%@@%..
    0x0f, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xfd, 0x00,  //.@@@@@@+@@@@@@.
    0x0a, 0x30, 0x2a, 0xff, 0xd3, 0x02, 0xbf, 0x80,  //.%...%@@@...%@%
    0x00, 0x00, 0x01, 0xff, 0x30, 0x00, 0x1f, 0xd0,  //......@@.....@@
    0x07, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //.+@@@@@@@@@@@@@
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //%@@@@@@@@@@@@@@
    0xef, 0x51, 0x01, 0xff, 0x20, 0x00, 0x00, 0x00,  //@@+...@@.......
    0xef, 0x40, 0x2b, 0xff, 0xd5, 0x10, 0x15, 0xb0,  //@@+..%@@@+...+%
    0xaf, 0xff, 0xff, 0x6b, 0xff, 0xff, 0xff, 0xf0,  //%@@@@@+%@@@@@@@
    0x09, 0xef, 0xc5, 0x00, 0x6c, 0xef, 0xd9, 0x30,  //.%@@@+..+@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00e7 (ç) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x6c, 0xff, 0xb4,  //..+@@@%+
    0x0b, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x7f, 0xf6, 0x10, 0x3a,  //+@@+...%
    0xcf, 0x60, 0x00, 0x00,  //@@+.....
    0xff, 0x10, 0x00, 0x00,  //@@......
    0xff, 0x10, 0x00, 0x00,  //@@......
    0xcf, 0x60, 0x00, 0x00,  //@@+.....
    0x7f, 0xf6, 0x10, 0x3a,  //+@@+...%
    0x0b, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x7d, 0xff, 0xb4,  //..+@@@%+
    0x00, 0x00, 0x0f, 0x70,  //.....@+.
    0x00, 0x00, 0x2f, 0xe0,  //.....@@.
    0x00, 0x0e, 0xfe, 0x80,  //...@@@+.
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e8 (è) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x8e, 0x10, 0x00, 0x00,  //..%@......
    0x00, 0x0a, 0xc0, 0x00, 0x00,  //...%@.....
    0x00, 0x00, 0xb9, 0x00, 0x00,  //....%%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x5b, 0xef, 0xd8, 0x00,  //..+%@@@%..
    0x0a, 0xff, 0xff, 0xff, 0xd0,  //.%@@@@@@@.
    0x6f, 0xe5, 0x10, 0x3c, 0xf8,  //+@@+...@@%
    0xcf, 0x30, 0x00, 0x02, 0xfd,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xcf, 0x30, 0x00, 0x00, 0x00,  //@@........
    0x6f, 0xe6, 0x10, 0x02, 0x6c,  //+@@+....+@
    0x09, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x4a, 0xef, 0xfd, 0x82,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00e9 (é) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x1e, 0x80, 0x00,  //.....@%...
    0x00, 0x00, 0xca, 0x00, 0x00,  //....@%....
    0x00, 0x09, 0xb0, 0x00, 0x00,  //...%%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x5b, 0xef, 0xd8, 0x00,  //..+%@@@%..
    0x0a, 0xff, 0xff, 0xff, 0xd0,  //.%@@@@@@@.
    0x6f, 0xe5, 0x10, 0x3c, 0xf8,  //+@@+...@@%
    0xcf, 0x30, 0x00, 0x02, 0xfd,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xcf, 0x30, 0x00, 0x00, 0x00,  //@@........
    0x6f, 0xe6, 0x10, 0x02, 0x6c,  //+@@+....+@
    0x09, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x4a, 0xef, 0xfd, 0x82,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00ea (ê) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x01, 0xef, 0x20, 0x00,  //....@@....
    0x00, 0x0c, 0xa9, 0xd0, 0x00,  //...@%%@...
    0x00, 0x9b, 0x00, 0xb9, 0x00,  //..%%..%%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x5b, 0xef, 0xd8, 0x00,  //..+%@@@%..
    0x0a, 0xff, 0xff, 0xff, 0xd0,  //.%@@@@@@@.
    0x6f, 0xe5, 0x10, 0x3c, 0xf8,  //+@@+...@@%
    0xcf, 0x30, 0x00, 0x02, 0xfd,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xcf, 0x30, 0x00, 0x00, 0x00,  //@@........
    0x6f, 0xe6, 0x10, 0x02, 0x6c,  //+@@+....+@
    0x09, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x4a, 0xef, 0xfd, 0x82,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00eb (ë) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0xff, 0x00, 0xff, 0x00,  //..@@..@@..
    0x00, 0xff, 0x00, 0xff, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x5b, 0xef, 0xd8, 0x00,  //..+%@@@%..
    0x0a, 0xff, 0xff, 0xff, 0xd0,  //.%@@@@@@@.
    0x6f, 0xe5, 0x10, 0x3c, 0xf8,  //+@@+...@@%
    0xcf, 0x30, 0x00, 0x02, 0xfd,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xcf, 0x30, 0x00, 0x00, 0x00,  //@@........
    0x6f, 0xe6, 0x10, 0x02, 0x6c,  //+@@+....+@
    0x09, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x4a, 0xef, 0xfd, 0x82,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00ec (ì) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x8e, 0x10,  //%@..
    0x0a, 0xc0,  //.%@.
    0x00, 0xb9,  //..%%
    0x00, 0x00,  //....
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00ed (í) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x01, 0xe8,  //..@%
    0x0c, 0xa0,  //.@%.
    0x9b, 0x00,  //%%..
    0x00, 0x00,  //....
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x0f, 0xf0,  //.@@.
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00ee (î) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x02, 0xff, 0x20,  //..@@..
    0x0c, 0x99, 0xc0,  //.@%%@.
    0x9b, 0x00, 0xb9,  //%%..%%
    0x00, 0x00, 0x00,  //......
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00ef (ï) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xff, 0x00, 0xff,  //@@..@@
    0xff, 0x00, 0xff,  //@@..@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00f0 (ð) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0x00, 0x37, 0x70,  //..+@...++.
    0x00, 0x0b, 0xde, 0xd8, 0x30,  //...%@@@%..
    0x09, 0xec, 0xbc, 0x00, 0x00,  //.%@@%@....
    0x04, 0x10, 0x0a, 0xa0, 0x00,  //.+...%%...
    0x00, 0x7d, 0xfe, 0xfc, 0x10,  //..+@@@@%..
    0x0b, 0xff, 0xff, 0xff, 0xe1,  //.%@@@@@@@.
    0x6f, 0xf6, 0x10, 0x2c, 0xf8,  //+@@+...@@%
    0xcf, 0x60, 0x00, 0x03, 0xfd,  //@@+.....@@
    0xff, 0x10, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xcf, 0x60, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x6f, 0xf6, 0x11, 0x6f, 0xf6,  //+@@+..+@@+
    0x0a, 0xff, 0xff, 0xff, 0xa0,  //.%@@@@@@%.
    0x00, 0x6c, 0xff, 0xc6, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f1 (ñ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x06, 0xfc, 0x32, 0xe0,  //.+@@..@.
    0x0e, 0x23, 0xcf, 0x60,  //.@..@@+.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x09, 0xfe, 0x80,  //@@.%@@%.
    0xff, 0xaf, 0xff, 0xf6,  //@@%@@@@+
    0xff, 0xc2, 0x09, 0xfc,  //@@@..%@@
    0xff, 0x30, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00f2 (ò) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x8e, 0x10, 0x00, 0x00,  //..%@......
    0x00, 0x0a, 0xc0, 0x00, 0x00,  //...%@.....
    0x00, 0x00, 0xb9, 0x00, 0x00,  //....%%....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0xff, 0xc7, 0x00,  //..+@@@@+..
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x7f, 0xe6, 0x11, 0x6f, 0xf7,  //+@@+..+@@+
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x7f, 0xe5, 0x11, 0x5e, 0xf7,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f3 (ó) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x1e, 0x80, 0x00,  //.....@%...
    0x00, 0x00, 0xca, 0x00, 0x00,  //....@%....
    0x00, 0x09, 0xb0, 0x00, 0x00,  //...%%.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0xff, 0xc7, 0x00,  //..+@@@@+..
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x7f, 0xe6, 0x11, 0x6f, 0xf7,  //+@@+..+@@+
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x7f, 0xe5, 0x11, 0x5e, 0xf7,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f4 (ô) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x02, 0xff, 0x20, 0x00,  //....@@....
    0x00, 0x0c, 0x99, 0xc0, 0x00,  //...@%%@...
    0x00, 0x9b, 0x00, 0xb9, 0x00,  //..%%..%%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0xff, 0xc7, 0x00,  //..+@@@@+..
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x7f, 0xe6, 0x11, 0x6f, 0xf7,  //+@@+..+@@+
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x7f, 0xe5, 0x11, 0x5e, 0xf7,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f5 (õ) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x6f, 0xc3, 0x2e, 0x00,  //..+@@..@..
    0x00, 0xe2, 0x3c, 0xf6, 0x00,  //..@..@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0xff, 0xc7, 0x00,  //..+@@@@+..
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x7f, 0xe6, 0x11, 0x6f, 0xf7,  //+@@+..+@@+
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x7f, 0xe5, 0x11, 0x5e, 0xf7,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f6 (ö) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0xff, 0x00, 0xff, 0x00,  //..@@..@@..
    0x00, 0xff, 0x00, 0xff, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0xff, 0xc7, 0x00,  //..+@@@@+..
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x7f, 0xe6, 0x11, 0x6f, 0xf7,  //+@@+..+@@+
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x7f, 0xe5, 0x11, 0x5e, 0xf7,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f7 (÷) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f8 (ø) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x50,  //..........+.
    0x00, 0x04, 0xbf, 0xea, 0x26, 0xf1,  //...+%@@%.+@.
    0x00, 0x7f, 0xff, 0xff, 0xef, 0x60,  //..+@@@@@@@+.
    0x05, 0xff, 0x61, 0x17, 0xff, 0x20,  //.+@@+..+@@..
    0x0c, 0xf6, 0x00, 0x2e, 0xaf, 0xa0,  //.@@+...@%@%.
    0x0f, 0xf1, 0x04, 0xe5, 0x0f, 0xe0,  //.@@...@+.@@.
    0x0e, 0xf0, 0x5e, 0x30, 0x1f, 0xf0,  //.@@.+@...@@.
    0x0a, 0xfa, 0xe2, 0x00, 0x6f, 0xc0,  //.%@%@...+@@.
    0x02, 0xff, 0x70, 0x15, 0xef, 0x50,  //..@@+..+@@+.
    0x06, 0xfe, 0xff, 0xff, 0xf8, 0x00,  //.+@@@@@@@%..
    0x1e, 0x52, 0xbf, 0xfc, 0x40, 0x00,  //.@+.%@@@+...
    0x05, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f9 (ù) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x08, 0xe1, 0x00, 0x00,  //.%@.....
    0x00, 0xac, 0x00, 0x00,  //..%@....
    0x00, 0x0b, 0x90, 0x00,  //...%%...
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xef, 0x10, 0x03, 0xff,  //@@....@@
    0xcf, 0x90, 0x2c, 0xff,  //@@%..@@@
    0x6f, 0xff, 0xfa, 0xff,  //+@@@@%@@
    0x08, 0xef, 0xa0, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00fa (ú) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x01, 0xe8, 0x00,  //....@%..
    0x00, 0x0c, 0xa0, 0x00,  //...@%...
    0x00, 0x9b, 0x00, 0x00,  //..%%....
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xef, 0x10, 0x03, 0xff,  //@@....@@
    0xcf, 0x90, 0x2c, 0xff,  //@@%..@@@
    0x6f, 0xff, 0xfa, 0xff,  //+@@@@%@@
    0x08, 0xef, 0xa0, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00fb (û) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x2f, 0xf2, 0x00,  //...@@...
    0x00, 0xc9, 0x9c, 0x00,  //..@%%@..
    0x09, 0xb0, 0x0b, 0x90,  //.%%..%%.
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xef, 0x10, 0x03, 0xff,  //@@....@@
    0xcf, 0x90, 0x2c, 0xff,  //@@%..@@@
    0x6f, 0xff, 0xfa, 0xff,  //+@@@@%@@
    0x08, 0xef, 0xa0, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00fc (ü) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x0f, 0xf0, 0x0f, 0xf0,  //.@@..@@.
    0x0f, 0xf0, 0x0f, 0xf0,  //.@@..@@.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xef, 0x10, 0x03, 0xff,  //@@....@@
    0xcf, 0x90, 0x2c, 0xff,  //@@%..@@@
    0x6f, 0xff, 0xfa, 0xff,  //+@@@@%@@
    0x08, 0xef, 0xa0, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00fd (ý) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x01, 0xe8, 0x00, 0x00,  //......@%....
    0x00, 0x00, 0x0c, 0xa0, 0x00, 0x00,  //.....@%.....
    0x00, 0x00, 0x9b, 0x00, 0x00, 0x00,  //....%%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x2f, 0xf1, 0x00, 0x00, 0x0f, 0xf2,  //.@@......@@.
    0x0a, 0xf7, 0x00, 0x00, 0x7f, 0xa0,  //.%@+....+@%.
    0x03, 0xfe, 0x00, 0x00, 0xef, 0x30,  //..@@....@@..
    0x00, 0xbf, 0x50, 0x05, 0xfc, 0x00,  //..%@+..+@@..
    0x00, 0x3f, 0xd0, 0x0c, 0xf4, 0x00,  //...@@..@@+..
    0x00, 0x0c, 0xf4, 0x3f, 0xd0, 0x00,  //...@@+.@@...
    0x00, 0x04, 0xfb, 0xaf, 0x60, 0x00,  //...+@%%@+...
    0x00, 0x00, 0xdf, 0xfe, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x5f, 0xf7, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x6f, 0x80, 0x00, 0x00,  //....+@%.....
    0x00, 0x01, 0xbf, 0x20, 0x00, 0x00,  //....%@......
    0x00, 0xff, 0xfb, 0x00, 0x00, 0x00,  //..@@@%......
    0x00, 0xff, 0xb1, 0x00, 0x00, 0x00,  //..@@%.......


    /*Unicode: U+00fe (þ) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x09, 0xef, 0xa1, 0x00,  //@@.%@@%..
    0xff, 0xaf, 0xff, 0xfe, 0x10,  //@@%@@@@@.
    0xff, 0xd3, 0x03, 0xef, 0x80,  //@@@...@@%
    0xff, 0x40, 0x00, 0x4f, 0xd0,  //@@+...+@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x40, 0x00, 0x4f, 0xd0,  //@@+...+@@
    0xff, 0xd3, 0x03, 0xef, 0x80,  //@@@...@@%
    0xff, 0xaf, 0xff, 0xfe, 0x10,  //@@%@@@@@.
    0xff, 0x09, 0xef, 0xa2, 0x00,  //@@.%@@%..
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......


    /*Unicode: U+00ff (ÿ) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x0f, 0xf0, 0xff, 0x00, 0x00,  //...@@.@@....
    0x00, 0x0f, 0xf0, 0xff, 0x00, 0x00,  //...@@.@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x2f, 0xf1, 0x00, 0x00, 0x0f, 0xf2,  //.@@......@@.
    0x0a, 0xf7, 0x00, 0x00, 0x7f, 0xa0,  //.%@+....+@%.
    0x03, 0xfe, 0x00, 0x00, 0xef, 0x30,  //..@@....@@..
    0x00, 0xbf, 0x50, 0x05, 0xfc, 0x00,  //..%@+..+@@..
    0x00, 0x3f, 0xd0, 0x0c, 0xf4, 0x00,  //...@@..@@+..
    0x00, 0x0c, 0xf4, 0x3f, 0xd0, 0x00,  //...@@+.@@...
    0x00, 0x04, 0xfb, 0xaf, 0x60, 0x00,  //...+@%%@+...
    0x00, 0x00, 0xdf, 0xfe, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x5f, 0xf7, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x6f, 0x80, 0x00, 0x00,  //....+@%.....
    0x00, 0x01, 0xbf, 0x20, 0x00, 0x00,  //....%@......
    0x00, 0xff, 0xfb, 0x00, 0x00, 0x00,  //..@@@%......
    0x00, 0xff, 0xb1, 0x00, 0x00, 0x00,  //..@@%.......



#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 8
    /*Unicode: U+00a0 ( ) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00a1 (¡) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xd2, 0xd2,  //@@
    0xe4, 0xe2,  //@@
    0xf4, 0xf2,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..


    /*Unicode: U+00a2 (¢) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //.....@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //.....@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //.....@..
    0x00, 0x00, 0x52, 0xb6, 0xec, 0xff, 0xd6, 0x58,  //..+%@@@+
    0x00, 0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x64, 0xff, 0xf8, 0x7e, 0x28, 0xff, 0x24, 0x9e,  //+@@+.@.%
    0xca, 0xff, 0x6c, 0x00, 0x00, 0xff, 0x00, 0x00,  //@@+..@..
    0xf4, 0xff, 0x14, 0x00, 0x00, 0xff, 0x00, 0x00,  //@@...@..
    0xf4, 0xff, 0x14, 0x00, 0x00, 0xff, 0x00, 0x00,  //@@...@..
    0xca, 0xff, 0x6a, 0x00, 0x00, 0xff, 0x00, 0x00,  //@@+..@..
    0x66, 0xff, 0xf6, 0x7c, 0x26, 0xff, 0x24, 0xa6,  //+@@+.@.%
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x00, 0x56, 0xb8, 0xec, 0xff, 0xdc, 0x58,  //..+%@@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //.....@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //.....@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,  //.....@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00a3 (£) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x44, 0xbe, 0xf0, 0xf4, 0xb6, 0x3e,  //...+%@@%.
    0x00, 0x00, 0x40, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@
    0x00, 0x00, 0xb4, 0xff, 0xb0, 0x22, 0x06, 0x34, 0xae,  //..%@%...%
    0x00, 0x00, 0xea, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0x00, 0xfc, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //@@@@@@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a4 (¤) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x98, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xa0,  //%+.....+%
    0x76, 0xff, 0x9a, 0x6e, 0xe8, 0x70, 0xa0, 0xff, 0x72,  //+@%+@+%@+
    0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a, 0x00,  //.%@@@@@%.
    0x00, 0x6a, 0xff, 0x76, 0x0a, 0x76, 0xff, 0x6e, 0x00,  //.+@+.+@+.
    0x00, 0xe8, 0xff, 0x0a, 0x00, 0x0a, 0xff, 0xec, 0x00,  //.@@...@@.
    0x00, 0x6a, 0xff, 0x78, 0x0a, 0x78, 0xff, 0x68, 0x00,  //.+@+.+@+.
    0x00, 0x9c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@@@%.
    0x78, 0xff, 0x9c, 0x6a, 0xe8, 0x6a, 0x96, 0xff, 0x70,  //+@%+@+%@+
    0x9e, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x92,  //%+.....+%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00a5 (¥) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xbe, 0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xbc,  //%@+....+@%
    0x3c, 0xff, 0xe6, 0x06, 0x00, 0x00, 0x06, 0xe6, 0xff, 0x38,  //.@@....@@.
    0x00, 0xba, 0xff, 0x60, 0x00, 0x00, 0x62, 0xff, 0xb6, 0x00,  //.%@+..+@%.
    0x00, 0x3a, 0xff, 0xd2, 0x00, 0x00, 0xd4, 0xff, 0x34, 0x00,  //..@@..@@..
    0x00, 0x00, 0xb8, 0xff, 0x46, 0x48, 0xff, 0xb0, 0x00, 0x00,  //..%@++@%..
    0xff, 0xff, 0xff, 0xff, 0xba, 0xba, 0xff, 0xff, 0xff, 0xff,  //@@@@%%@@@@
    0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0x84, 0x00, 0x00, 0x00,  //...%@@%...
    0x00, 0x00, 0x00, 0x10, 0xff, 0xfc, 0x0e, 0x00, 0x00, 0x00,  //....@@....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00a6 (¦) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..


    /*Unicode: U+00a7 (§) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x20, 0xb6, 0xf2, 0xff, 0xff, 0x00,  //..%@@@.
    0x00, 0xbe, 0xff, 0xff, 0xff, 0xff, 0x00,  //.%@@@@.
    0x00, 0xf4, 0xff, 0x42, 0x00, 0x00, 0x00,  //.@@+...
    0x00, 0xba, 0xff, 0x1e, 0x00, 0x00, 0x00,  //.%@....
    0x00, 0x32, 0xf4, 0xae, 0x0c, 0x00, 0x00,  //..@%...
    0x50, 0xf6, 0xa8, 0x8c, 0xe8, 0x5c, 0x00,  //+@%%@+.
    0xe4, 0xff, 0x0e, 0x00, 0xa2, 0xff, 0x78,  //@@..%@+
    0xe4, 0xff, 0x26, 0x00, 0x1c, 0xff, 0xec,  //@@...@@
    0x5c, 0xfc, 0xbc, 0x04, 0x1c, 0xff, 0xd4,  //+@%..@@
    0x00, 0x38, 0xcc, 0xb0, 0xc8, 0xe0, 0x30,  //..@%@@.
    0x00, 0x00, 0x00, 0x92, 0xf2, 0x28, 0x00,  //...%@..
    0x00, 0x00, 0x00, 0x16, 0xff, 0xc8, 0x00,  //....@@.
    0x00, 0x00, 0x00, 0x46, 0xff, 0xf2, 0x00,  //...+@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x00,  //.@@@@%.
    0x00, 0xff, 0xff, 0xf4, 0xb6, 0x1c, 0x00,  //.@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00a8 (¨) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00a9 (©) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3a, 0xa8, 0xe4, 0xf8, 0xe4, 0xa8, 0x3a, 0x00, 0x00, 0x00,  //....%@@@%....
    0x00, 0x02, 0x90, 0xde, 0x64, 0x1c, 0x04, 0x1a, 0x62, 0xdc, 0x90, 0x02, 0x00,  //..%@+...+@%..
    0x00, 0x92, 0xbc, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xb4, 0x90, 0x00,  //.%%.......%%.
    0x3c, 0xde, 0x0e, 0x00, 0x56, 0xca, 0xf2, 0xff, 0xff, 0x00, 0x0a, 0xdc, 0x3a,  //.@..+@@@@..@.
    0xaa, 0x64, 0x00, 0x6a, 0xd6, 0x3e, 0x08, 0x00, 0x00, 0x00, 0x00, 0x62, 0xa6,  //%+.+@......+%
    0xe6, 0x1a, 0x00, 0xdc, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xe4,  //@..@........@
    0xf8, 0x04, 0x00, 0xfa, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xf8,  //@..@........@
    0xe6, 0x1a, 0x00, 0xdc, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xe4,  //@..@........@
    0xaa, 0x64, 0x00, 0x6a, 0xd6, 0x42, 0x0a, 0x24, 0x9e, 0x00, 0x00, 0x62, 0xa8,  //%+.+@+..%..+%
    0x3e, 0xe0, 0x0e, 0x00, 0x56, 0xca, 0xf2, 0xd8, 0x60, 0x00, 0x0a, 0xda, 0x3a,  //.@..+@@@+..@.
    0x00, 0x92, 0xbe, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xb6, 0x90, 0x00,  //.%%.......%%.
    0x00, 0x02, 0x90, 0xde, 0x64, 0x1a, 0x04, 0x1a, 0x62, 0xdc, 0x90, 0x02, 0x00,  //..%@+...+@%..
    0x00, 0x00, 0x00, 0x3a, 0xa8, 0xe4, 0xf8, 0xe4, 0xa8, 0x3a, 0x00, 0x00, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00aa (ª) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xff, 0xff, 0xfc, 0xe8, 0xac, 0x20, 0x00,  //.@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x5c, 0xc4, 0x00,  //.....+@.
    0x0e, 0x8e, 0xdc, 0xf6, 0xff, 0xff, 0xf8, 0x00,  //.%@@@@@.
    0xae, 0x96, 0x26, 0x08, 0x00, 0x0a, 0xff, 0x00,  //%%....@.
    0xf0, 0x0e, 0x00, 0x00, 0x00, 0x4e, 0xff, 0x00,  //@....+@.
    0xc4, 0x8e, 0x16, 0x0c, 0x52, 0xe4, 0xff, 0x00,  //@%..+@@.
    0x1e, 0xb0, 0xee, 0xf4, 0xc4, 0x48, 0xff, 0x00,  //.%@@@+@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,  //%@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ab («) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x8a,  //...%...%
    0x00, 0x02, 0xa0, 0xc4, 0x00, 0x02, 0xa0, 0xc4,  //..%@..%@
    0x08, 0xb4, 0xb0, 0x08, 0x08, 0xb4, 0xb0, 0x08,  //.%%..%%.
    0xc4, 0x98, 0x02, 0x00, 0xc4, 0x98, 0x02, 0x00,  //@%..@%..
    0xc4, 0x9e, 0x02, 0x00, 0xc4, 0x9e, 0x02, 0x00,  //@%..@%..
    0x08, 0xb4, 0xb2, 0x08, 0x08, 0xb4, 0xb2, 0x08,  //.%%..%%.
    0x00, 0x02, 0xa0, 0xc4, 0x00, 0x02, 0xa0, 0xc4,  //..%@..%@
    0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x8a,  //...%...%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ac (¬) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00ad (­) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ae (®) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x3a, 0xa8, 0xe4, 0xf8, 0xe4, 0xa8, 0x3a, 0x00, 0x00, 0x00,  //....%@@@%....
    0x00, 0x02, 0x90, 0xde, 0x64, 0x1c, 0x04, 0x1a, 0x62, 0xdc, 0x90, 0x02, 0x00,  //..%@+...+@%..
    0x00, 0x92, 0xbc, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xb4, 0x90, 0x00,  //.%%.......%%.
    0x3c, 0xde, 0x0e, 0x00, 0xff, 0xff, 0xf6, 0xd0, 0x46, 0x00, 0x0a, 0xdc, 0x3a,  //.@..@@@@+..@.
    0xaa, 0x64, 0x00, 0x00, 0xff, 0x00, 0x04, 0x48, 0xe4, 0x00, 0x00, 0x62, 0xa6,  //%+..@..+@..+%
    0xe6, 0x1a, 0x00, 0x00, 0xff, 0x00, 0x04, 0x44, 0xe4, 0x00, 0x00, 0x1a, 0xe4,  //@...@..+@...@
    0xf8, 0x04, 0x00, 0x00, 0xff, 0xff, 0xff, 0xe8, 0x44, 0x00, 0x00, 0x04, 0xf8,  //@...@@@@+...@
    0xe6, 0x1a, 0x00, 0x00, 0xff, 0x02, 0x50, 0xf6, 0x3a, 0x00, 0x00, 0x1a, 0xe4,  //@...@.+@....@
    0xaa, 0x64, 0x00, 0x00, 0xff, 0x00, 0x00, 0x78, 0xd4, 0x08, 0x00, 0x62, 0xa8,  //%+..@..+@..+%
    0x3e, 0xe0, 0x0e, 0x00, 0xff, 0x00, 0x00, 0x02, 0xd0, 0x9e, 0x0a, 0xda, 0x3a,  //.@..@...@%.@.
    0x00, 0x92, 0xbe, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xb6, 0x90, 0x00,  //.%%.......%%.
    0x00, 0x02, 0x90, 0xde, 0x64, 0x1a, 0x04, 0x1a, 0x62, 0xdc, 0x90, 0x02, 0x00,  //..%@+...+@%..
    0x00, 0x00, 0x00, 0x3a, 0xa8, 0xe4, 0xf8, 0xe4, 0xa8, 0x3a, 0x00, 0x00, 0x00,  //....%@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00af (¯) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b0 (°) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x06, 0x8a, 0xe6, 0xe4, 0x84, 0x04,  //.%@@%.
    0x8a, 0xb4, 0x1a, 0x1a, 0xb6, 0x84,  //%%..%%
    0xe6, 0x1a, 0x00, 0x00, 0x1c, 0xe4,  //@....@
    0xe8, 0x18, 0x00, 0x00, 0x18, 0xe6,  //@....@
    0x92, 0xb2, 0x18, 0x18, 0xb2, 0x8c,  //%%..%%
    0x08, 0x92, 0xe8, 0xe6, 0x8c, 0x06,  //.%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00b1 (±) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00b2 (²) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x54, 0xd4, 0xf4, 0xc6, 0x36,  //+@@@.
    0xa8, 0x28, 0x08, 0x66, 0xe0,  //%..+@
    0x00, 0x00, 0x00, 0x2a, 0xd2,  //....@
    0x00, 0x00, 0x1c, 0xd4, 0x3e,  //...@.
    0x00, 0x30, 0xde, 0x5c, 0x00,  //..@+.
    0x5c, 0xe6, 0x4e, 0x00, 0x00,  //+@+..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b3 (³) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf8, 0xd8, 0x6a,  //@@@@+
    0x00, 0x00, 0x06, 0x54, 0xe8,  //...+@
    0x00, 0xff, 0xff, 0xf8, 0x4c,  //.@@@+
    0x00, 0x00, 0x10, 0x82, 0xca,  //...%@
    0x00, 0x00, 0x00, 0x0c, 0xf4,  //....@
    0x00, 0x00, 0x0c, 0x80, 0xc2,  //...+@
    0xff, 0xff, 0xee, 0xb6, 0x24,  //@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b4 (´) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x1e, 0xea, 0x8a,  //..@%
    0x06, 0xca, 0xa0, 0x00,  //.@%.
    0x9a, 0xb6, 0x02, 0x00,  //%%..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00b5 (µ) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0xff, 0xff, 0x00,  //@@....@@.
    0xff, 0xff, 0x16, 0x00, 0x00, 0x26, 0xff, 0xff, 0x00,  //@@....@@.
    0xff, 0xff, 0x9c, 0x10, 0x1a, 0xb4, 0xff, 0xff, 0x16,  //@@%..%@@.
    0xff, 0xff, 0xce, 0xff, 0xff, 0xde, 0xca, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0x36, 0xde, 0xe2, 0x3c, 0x50, 0xf0, 0xb6,  //@@.@@.+@%
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......


    /*Unicode: U+00b6 (¶) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x3a, 0xb8, 0xf0, 0xff, 0xff, 0xff, 0xff,  //..%@@@@@
    0x44, 0xfa, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff,  //+@@@@..@
    0xca, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff,  //@@@@@..@
    0xf8, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff,  //@@@@@..@
    0xe8, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff,  //@@@@@..@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff,  //%@@@@..@
    0x06, 0x94, 0xfc, 0xff, 0xff, 0x00, 0x00, 0xff,  //.%@@@..@
    0x00, 0x00, 0x1a, 0x54, 0xff, 0x00, 0x00, 0xff,  //...+@..@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //....@..@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //....@..@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //....@..@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //....@..@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //....@..@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //....@..@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //....@..@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00b7 (·) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00b8 (¸) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0xff, 0x70,  //..@+
    0x00, 0x24, 0xff, 0xee,  //..@@
    0xe4, 0xfa, 0xea, 0x80,  //@@@+
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00b9 (¹) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0x00, 0x00,  //@@@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ba (º) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x68, 0xd4, 0xf4, 0xd4, 0x6a, 0x00,  //.+@@@+.
    0x6a, 0xd2, 0x36, 0x0a, 0x36, 0xd4, 0x68,  //+@...@+
    0xd4, 0x36, 0x00, 0x00, 0x00, 0x36, 0xd4,  //@.....@
    0xf4, 0x08, 0x00, 0x00, 0x00, 0x08, 0xf4,  //@.....@
    0xd6, 0x36, 0x00, 0x00, 0x00, 0x36, 0xd6,  //@.....@
    0x6a, 0xd2, 0x36, 0x08, 0x36, 0xd2, 0x6c,  //+@...@+
    0x00, 0x6a, 0xd4, 0xf4, 0xd6, 0x6e, 0x00,  //.+@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xb6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba,  //%@@@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00bb (») , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x8a, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00,  //%...%...
    0xc4, 0x9e, 0x02, 0x00, 0xc4, 0x9e, 0x02, 0x00,  //@%..@%..
    0x08, 0xb0, 0xb2, 0x08, 0x08, 0xb0, 0xb2, 0x08,  //.%%..%%.
    0x00, 0x02, 0x9a, 0xc4, 0x00, 0x02, 0x9a, 0xc4,  //..%@..%@
    0x00, 0x02, 0x9e, 0xc4, 0x00, 0x02, 0x9e, 0xc4,  //..%@..%@
    0x08, 0xb2, 0xb2, 0x08, 0x08, 0xb2, 0xb2, 0x08,  //.%%..%%.
    0xc4, 0xa0, 0x02, 0x00, 0xc4, 0xa0, 0x02, 0x00,  //@%..@%..
    0x8a, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00,  //%...%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00bc (¼) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xa8, 0x00, 0x00, 0x00,  //@@@........%%...
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xe4, 0x12, 0x00, 0x00, 0x00,  //..@........@....
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd8, 0x4c, 0x00, 0x00, 0x00, 0x00,  //..@.......@+....
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@......%%.....
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xe0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@......@......
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xde, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@.....@+......
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x98, 0x96, 0x00, 0x00, 0x00, 0x10, 0xd6, 0xff, 0x00,  //@@@@@..%%....@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xdc, 0x0a, 0x00, 0x00, 0x06, 0xc0, 0x68, 0xff, 0x00,  //......+@....%+@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0x3c, 0x00, 0x00, 0x00, 0xa4, 0x72, 0x00, 0xff, 0x00,  //......@....%+.@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x8e, 0x00, 0x00, 0x00, 0x82, 0x7c, 0x00, 0x00, 0xff, 0x00,  //.....%%...%+..@.
    0x00, 0x00, 0x00, 0x00, 0x4e, 0xd6, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....+@....@@@@@@
    0x00, 0x00, 0x00, 0x12, 0xe2, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //....@.........@.
    0x00, 0x00, 0x00, 0xa8, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //...%%.........@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00bd (½) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xa8, 0x00, 0x00,  //@@@........%%..
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xe4, 0x12, 0x00, 0x00,  //..@........@...
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd8, 0x4c, 0x00, 0x00, 0x00,  //..@.......@+...
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x9e, 0x00, 0x00, 0x00, 0x00,  //..@......%%....
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xe0, 0x0e, 0x00, 0x00, 0x00, 0x00,  //..@......@.....
    0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xde, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@.....@+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x98, 0x96, 0x00, 0x54, 0xd4, 0xf4, 0xc6, 0x36,  //@@@@@..%%.+@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xdc, 0x0a, 0x00, 0xa8, 0x28, 0x08, 0x66, 0xe0,  //......+@..%..+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xd2,  //......@.......@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xd4, 0x3e,  //.....%%......@.
    0x00, 0x00, 0x00, 0x00, 0x4e, 0xd6, 0x08, 0x00, 0x00, 0x00, 0x00, 0x30, 0xde, 0x5c, 0x00,  //....+@......@+.
    0x00, 0x00, 0x00, 0x12, 0xe2, 0x36, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xe6, 0x4e, 0x00, 0x00,  //....@.....+@+..
    0x00, 0x00, 0x00, 0xa8, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,  //...%%.....@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00be (¾) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0xf8, 0xd8, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xa8, 0x00, 0x00, 0x00,  //@@@@+......%%...
    0x00, 0x00, 0x06, 0x54, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xe4, 0x12, 0x00, 0x00, 0x00,  //...+@......@....
    0x00, 0xff, 0xff, 0xf8, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x08, 0xd8, 0x4c, 0x00, 0x00, 0x00, 0x00,  //.@@@+.....@+....
    0x00, 0x00, 0x10, 0x82, 0xca, 0x00, 0x00, 0x00, 0x00, 0x90, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00,  //...%@....%%.....
    0x00, 0x00, 0x00, 0x0c, 0xf4, 0x00, 0x00, 0x00, 0x40, 0xe0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@....@......
    0x00, 0x00, 0x0c, 0x80, 0xc2, 0x00, 0x00, 0x0c, 0xde, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@...@+......
    0xff, 0xff, 0xee, 0xb6, 0x24, 0x00, 0x00, 0x98, 0x96, 0x00, 0x00, 0x00, 0x10, 0xd6, 0xff, 0x00,  //@@@%...%%....@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xdc, 0x0a, 0x00, 0x00, 0x06, 0xc0, 0x68, 0xff, 0x00,  //......+@....%+@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xe0, 0x3c, 0x00, 0x00, 0x00, 0xa4, 0x72, 0x00, 0xff, 0x00,  //......@....%+.@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x8e, 0x00, 0x00, 0x00, 0x82, 0x7c, 0x00, 0x00, 0xff, 0x00,  //.....%%...%+..@.
    0x00, 0x00, 0x00, 0x00, 0x4e, 0xd6, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //....+@....@@@@@@
    0x00, 0x00, 0x00, 0x12, 0xe2, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //....@.........@.
    0x00, 0x00, 0x00, 0xa8, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,  //...%%.........@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00bf (¿) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@..
    0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00,  //...@@..
    0x00, 0x00, 0x18, 0xff, 0xe0, 0x00, 0x00,  //...@@..
    0x00, 0x00, 0x8c, 0xff, 0x74, 0x00, 0x00,  //..%@+..
    0x00, 0x58, 0xfc, 0x98, 0x00, 0x00, 0x00,  //.+@%...
    0x3a, 0xf8, 0xba, 0x02, 0x00, 0x00, 0x00,  //.@%....
    0xc8, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xf4, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xd2, 0xff, 0x9a, 0x14, 0x0c, 0x4c, 0xc2,  //@@%..+@
    0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@@@@
    0x00, 0x5e, 0xd0, 0xf6, 0xe8, 0xac, 0x40,  //.+@@@%.


    /*Unicode: U+00c0 (À) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xec, 0x26, 0x00, 0x00, 0x00, 0x00,  //....+@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xde, 0x18, 0x00, 0x00, 0x00,  //.....+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x06, 0xea, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x28, 0xff, 0xc6, 0xc4, 0xff, 0x2a, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x90, 0xff, 0x64, 0x5c, 0xff, 0x92, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x08, 0xee, 0xf4, 0x0c, 0x06, 0xea, 0xee, 0x08, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x5e, 0xff, 0xa0, 0x00, 0x00, 0x8c, 0xff, 0x60, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0xc6, 0xff, 0x3e, 0x00, 0x00, 0x24, 0xfc, 0xc6, 0x00, 0x00,  //..@@....@@..
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00,  //..@@@@@@@@..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@@@@@@%.
    0x0a, 0xf0, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xf0, 0x0a,  //.@@......@@.
    0x64, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x62,  //+@%......%@+
    0xca, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xca,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c1 (Á) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xc6, 0x0e, 0x00, 0x00, 0x00,  //......%@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xc6, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....%@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x06, 0xea, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x28, 0xff, 0xc6, 0xc4, 0xff, 0x2a, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x90, 0xff, 0x64, 0x5c, 0xff, 0x92, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x08, 0xee, 0xf4, 0x0c, 0x06, 0xea, 0xee, 0x08, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x5e, 0xff, 0xa0, 0x00, 0x00, 0x8c, 0xff, 0x60, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0xc6, 0xff, 0x3e, 0x00, 0x00, 0x24, 0xfc, 0xc6, 0x00, 0x00,  //..@@....@@..
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00,  //..@@@@@@@@..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@@@@@@%.
    0x0a, 0xf0, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xf0, 0x0a,  //.@@......@@.
    0x64, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x62,  //+@%......%@+
    0xca, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xca,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c2 (Â) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x10, 0xd6, 0xd6, 0x10, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0xa4, 0x50, 0x50, 0xa4, 0x00, 0x00, 0x00, 0x00,  //....%++%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x06, 0xea, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x28, 0xff, 0xc6, 0xc4, 0xff, 0x2a, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x90, 0xff, 0x64, 0x5c, 0xff, 0x92, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x08, 0xee, 0xf4, 0x0c, 0x06, 0xea, 0xee, 0x08, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x5e, 0xff, 0xa0, 0x00, 0x00, 0x8c, 0xff, 0x60, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0xc6, 0xff, 0x3e, 0x00, 0x00, 0x24, 0xfc, 0xc6, 0x00, 0x00,  //..@@....@@..
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00,  //..@@@@@@@@..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@@@@@@%.
    0x0a, 0xf0, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xf0, 0x0a,  //.@@......@@.
    0x64, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x62,  //+@%......%@+
    0xca, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xca,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c3 (Ã) , Width: 12 */
    0x00, 0x00, 0x00, 0x66, 0xf0, 0xce, 0x4c, 0x2a, 0xe8, 0x00, 0x00, 0x00,  //...+@@+.@...
    0x00, 0x00, 0x00, 0xea, 0x28, 0x4e, 0xce, 0xf0, 0x62, 0x00, 0x00, 0x00,  //...@.+@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x06, 0xea, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x28, 0xff, 0xc6, 0xc4, 0xff, 0x2a, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x90, 0xff, 0x64, 0x5c, 0xff, 0x92, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x08, 0xee, 0xf4, 0x0c, 0x06, 0xea, 0xee, 0x08, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x5e, 0xff, 0xa0, 0x00, 0x00, 0x8c, 0xff, 0x60, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0xc6, 0xff, 0x3e, 0x00, 0x00, 0x24, 0xfc, 0xc6, 0x00, 0x00,  //..@@....@@..
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00,  //..@@@@@@@@..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@@@@@@%.
    0x0a, 0xf0, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xf0, 0x0a,  //.@@......@@.
    0x64, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x62,  //+@%......%@+
    0xca, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xca,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c4 (Ä) , Width: 12 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x06, 0xea, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x28, 0xff, 0xc6, 0xc4, 0xff, 0x2a, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x90, 0xff, 0x64, 0x5c, 0xff, 0x92, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x08, 0xee, 0xf4, 0x0c, 0x06, 0xea, 0xee, 0x08, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x5e, 0xff, 0xa0, 0x00, 0x00, 0x8c, 0xff, 0x60, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0xc6, 0xff, 0x3e, 0x00, 0x00, 0x24, 0xfc, 0xc6, 0x00, 0x00,  //..@@....@@..
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00,  //..@@@@@@@@..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@@@@@@%.
    0x0a, 0xf0, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xf0, 0x0a,  //.@@......@@.
    0x64, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x62,  //+@%......%@+
    0xca, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xca,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c5 (Å) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0xc6, 0x50, 0x54, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@++@....
    0x00, 0x00, 0x00, 0x00, 0xf6, 0x06, 0x06, 0xf6, 0x00, 0x00, 0x00, 0x00,  //....@..@....
    0x00, 0x00, 0x00, 0x00, 0xd0, 0x52, 0x54, 0xcc, 0x00, 0x00, 0x00, 0x00,  //....@++@....
    0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xbc, 0x00, 0x00, 0x00, 0x00,  //....%@@%....
    0x00, 0x00, 0x00, 0x24, 0xff, 0xd2, 0xd2, 0xfc, 0x24, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x8c, 0xff, 0x74, 0x76, 0xff, 0x8c, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x06, 0xec, 0xfc, 0x1a, 0x1a, 0xfc, 0xea, 0x06, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x5c, 0xff, 0xba, 0x00, 0x00, 0xba, 0xff, 0x5c, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0xc4, 0xff, 0x5c, 0x00, 0x00, 0x5e, 0xff, 0xc2, 0x00, 0x00,  //..@@+..+@@..
    0x00, 0x2c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2a, 0x00,  //..@@@@@@@@..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0x00,  //.%@@@@@@@@%.
    0x0a, 0xf0, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xee, 0x0a,  //.@@......@@.
    0x64, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0xff, 0x62,  //+@@......@@+
    0xca, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xca,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00c6 (Æ) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....%@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x14, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.....@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xaa, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@%.@@......
    0x00, 0x00, 0x00, 0x02, 0xe2, 0xff, 0x30, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //....@@..@@......
    0x00, 0x00, 0x00, 0x56, 0xff, 0xb8, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...+@%..@@......
    0x00, 0x00, 0x00, 0xc4, 0xff, 0x40, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@...@@@@@@@@
    0x00, 0x00, 0x32, 0xff, 0xc6, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@...@@@@@@@@
    0x00, 0x00, 0xa2, 0xff, 0x4e, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@+...@@......
    0x00, 0x16, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@@@@@@......
    0x00, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@@@@@@@......
    0x04, 0xe4, 0xff, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@.....@@......
    0x5a, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@.....@@@@@@@@
    0xc8, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@+.....@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+00c7 (Ç) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x02, 0x5e, 0xb6, 0xe6, 0xf8, 0xf2, 0xd2, 0x96, 0x36,  //...+%@@@@%.
    0x00, 0x18, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@
    0x04, 0xca, 0xff, 0xe2, 0x66, 0x1e, 0x04, 0x08, 0x28, 0x64, 0xc4,  //.@@@+....+@
    0x64, 0xff, 0xde, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0xbc, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0xea, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xea, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xbc, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0x64, 0xff, 0xdc, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0x04, 0xcc, 0xff, 0xe0, 0x64, 0x1e, 0x04, 0x08, 0x26, 0x64, 0xc4,  //.@@@+....+@
    0x00, 0x1a, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@
    0x00, 0x00, 0x04, 0x60, 0xb8, 0xe8, 0xfa, 0xf2, 0xd2, 0x94, 0x36,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x70, 0x00, 0x00,  //.......@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xee, 0x00, 0x00,  //.......@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0xfa, 0xea, 0x80, 0x00, 0x00,  //.....@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+00c8 (È) , Width: 8 */
    0x00, 0x7e, 0xff, 0xec, 0x26, 0x00, 0x00, 0x00,  //.+@@....
    0x00, 0x00, 0x7c, 0xff, 0xde, 0x18, 0x00, 0x00,  //..+@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00c9 (É) , Width: 8 */
    0x00, 0x00, 0x00, 0xb0, 0xc6, 0x0e, 0x00, 0x00,  //...%@...
    0x00, 0x00, 0x90, 0xc6, 0x0e, 0x00, 0x00, 0x00,  //..%@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00ca (Ê) , Width: 8 */
    0x00, 0x00, 0xae, 0xe0, 0xae, 0x00, 0x00, 0x00,  //..%@%...
    0x00, 0x90, 0xa0, 0x04, 0xa0, 0x90, 0x00, 0x00,  //.%%.%%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00cb (Ë) , Width: 8 */
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,  //.@@..@@.
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,  //.@@..@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00cc (Ì) , Width: 5 */
    0x7e, 0xff, 0xec, 0x26, 0x00,  //+@@..
    0x00, 0x7c, 0xff, 0xde, 0x18,  //.+@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0xff, 0xff, 0x00,  //..@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00cd (Í) , Width: 4 */
    0x00, 0xb0, 0xc6, 0x0e,  //.%@.
    0x90, 0xc6, 0x0e, 0x00,  //%@..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ce (Î) , Width: 6 */
    0x00, 0x70, 0xea, 0xec, 0x70, 0x00,  //.+@@+.
    0x7a, 0xd4, 0x22, 0x22, 0xd4, 0x7a,  //+@..@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00cf (Ï) , Width: 6 */
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00d0 (Ð) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xe2, 0xb6, 0x6c, 0x0e, 0x00, 0x00,  //..@@@@@@%+...
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x36, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x04, 0x1a, 0x58, 0xd0, 0xff, 0xea, 0x14,  //..@@....+@@@.
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xcc, 0xff, 0x80,  //..@@......@@+
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xc8,  //..@@......+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x12, 0xff, 0xec,  //@@@@@@@....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0xff, 0xfa,  //@@@@@@@....@@
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xec,  //..@@.......@@
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xc6,  //..@@......+@@
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xcc, 0xff, 0x7e,  //..@@......@@+
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x02, 0x1a, 0x56, 0xd0, 0xff, 0xea, 0x14,  //..@@....+@@@.
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x36, 0x00,  //..@@@@@@@@@..
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xe4, 0xb8, 0x6e, 0x0e, 0x00, 0x00,  //..@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+00d1 (Ñ) , Width: 10 */
    0x00, 0x00, 0x66, 0xf0, 0xce, 0x4c, 0x2a, 0xe8, 0x00, 0x00,  //..+@@+.@..
    0x00, 0x00, 0xea, 0x28, 0x4e, 0xce, 0xf0, 0x62, 0x00, 0x00,  //..@.+@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%.....@@
    0xff, 0xff, 0xf8, 0x26, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@.....@@
    0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@%....@@
    0xff, 0xff, 0xb4, 0xff, 0x4e, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%@+...@@
    0xff, 0xff, 0x26, 0xfa, 0xdc, 0x06, 0x00, 0x00, 0xff, 0xff,  //@@.@@...@@
    0xff, 0xff, 0x00, 0x8e, 0xff, 0x7c, 0x00, 0x00, 0xff, 0xff,  //@@.%@+..@@
    0xff, 0xff, 0x00, 0x10, 0xea, 0xf4, 0x1c, 0x00, 0xff, 0xff,  //@@..@@..@@
    0xff, 0xff, 0x00, 0x00, 0x68, 0xff, 0xaa, 0x00, 0xff, 0xff,  //@@..+@%.@@
    0xff, 0xff, 0x00, 0x00, 0x02, 0xd2, 0xff, 0x40, 0xff, 0xff,  //@@...@@.@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x42, 0xff, 0xd4, 0xff, 0xff,  //@@...+@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff,  //@@....%@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf8, 0xff, 0xff,  //@@.....@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff,  //@@.....%@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00d2 (Ò) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xec, 0x26, 0x00, 0x00, 0x00, 0x00,  //....+@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0xde, 0x18, 0x00, 0x00, 0x00,  //.....+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0x7e, 0xd0, 0xf2, 0xf2, 0xd0, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x08, 0xd8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x44, 0xce, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd6, 0xff, 0x6c,  //+@@......@@+
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa,  //@@........@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //+@@......@@+
    0x0a, 0xda, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x00, 0x00, 0x0e, 0x80, 0xd0, 0xf4, 0xf4, 0xd2, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d3 (Ó) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xc6, 0x0e, 0x00, 0x00, 0x00,  //......%@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xc6, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....%@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0x7e, 0xd0, 0xf2, 0xf2, 0xd0, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x08, 0xd8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x44, 0xce, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd6, 0xff, 0x6c,  //+@@......@@+
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa,  //@@........@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //+@@......@@+
    0x0a, 0xda, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x00, 0x00, 0x0e, 0x80, 0xd0, 0xf4, 0xf4, 0xd2, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d4 (Ô) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x10, 0xd6, 0xd6, 0x10, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0xa4, 0x50, 0x50, 0xa4, 0x00, 0x00, 0x00, 0x00,  //....%++%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0x7e, 0xd0, 0xf2, 0xf2, 0xd0, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x08, 0xd8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x44, 0xce, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd6, 0xff, 0x6c,  //+@@......@@+
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa,  //@@........@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //+@@......@@+
    0x0a, 0xda, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x00, 0x00, 0x0e, 0x80, 0xd0, 0xf4, 0xf4, 0xd2, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d5 (Õ) , Width: 12 */
    0x00, 0x00, 0x00, 0x66, 0xf0, 0xce, 0x4c, 0x2a, 0xe8, 0x00, 0x00, 0x00,  //...+@@+.@...
    0x00, 0x00, 0x00, 0xea, 0x28, 0x4e, 0xce, 0xf0, 0x62, 0x00, 0x00, 0x00,  //...@.+@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0x7e, 0xd0, 0xf2, 0xf2, 0xd0, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x08, 0xd8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x44, 0xce, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd6, 0xff, 0x6c,  //+@@......@@+
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa,  //@@........@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //+@@......@@+
    0x0a, 0xda, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x00, 0x00, 0x0e, 0x80, 0xd0, 0xf4, 0xf4, 0xd2, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d6 (Ö) , Width: 12 */
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0x7e, 0xd0, 0xf2, 0xf2, 0xd0, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x08, 0xd8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x44, 0xce, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd6, 0xff, 0x6c,  //+@@......@@+
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa,  //@@........@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //+@@......@@+
    0x0a, 0xda, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x00, 0x00, 0x0e, 0x80, 0xd0, 0xf4, 0xf4, 0xd2, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00d7 (×) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x3e, 0xca, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xca, 0x3e,  //.@+....+@.
    0x8a, 0xff, 0xf8, 0x48, 0x00, 0x00, 0x4a, 0xf8, 0xff, 0x8a,  //%@@+..+@@%
    0x00, 0x8c, 0xff, 0xf6, 0x46, 0x48, 0xf6, 0xff, 0x8a, 0x00,  //.%@@++@@%.
    0x00, 0x00, 0x8c, 0xff, 0xf6, 0xf6, 0xff, 0x8c, 0x00, 0x00,  //..%@@@@%..
    0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00,  //...%@@%...
    0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00,  //...%@@%...
    0x00, 0x00, 0x88, 0xff, 0xfa, 0xfa, 0xff, 0x86, 0x00, 0x00,  //..%@@@@%..
    0x00, 0x88, 0xff, 0xfa, 0x52, 0x52, 0xfa, 0xff, 0x88, 0x00,  //.%@@++@@%.
    0x8a, 0xff, 0xfa, 0x50, 0x00, 0x00, 0x50, 0xf8, 0xff, 0x88,  //%@@+..+@@%
    0x3e, 0xca, 0x50, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xca, 0x3e,  //.@+....+@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00d8 (Ø) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00,  //..............
    0x00, 0x00, 0x00, 0x16, 0x8a, 0xd6, 0xf4, 0xee, 0xb0, 0x32, 0x00, 0x68, 0xd8, 0x02,  //....%@@@%..+@.
    0x00, 0x00, 0x38, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x70, 0xf2, 0x66, 0x00,  //...@@@@@@@+@+.
    0x00, 0x14, 0xe8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x4c, 0xd8, 0xff, 0xb6, 0x00, 0x00,  //..@@@+..+@@%..
    0x00, 0x82, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0xca, 0xf6, 0xf6, 0x24, 0x00,  //.%@@.....@@@..
    0x00, 0xce, 0xff, 0x56, 0x00, 0x00, 0x00, 0x0a, 0xc4, 0xa6, 0x60, 0xff, 0x96, 0x00,  //.@@+....@%+@%.
    0x00, 0xf2, 0xff, 0x14, 0x00, 0x00, 0x06, 0xbc, 0xae, 0x02, 0x1c, 0xff, 0xda, 0x00,  //.@@....%%..@@.
    0x00, 0xf8, 0xff, 0x04, 0x00, 0x04, 0xb4, 0xb6, 0x04, 0x00, 0x04, 0xff, 0xf6, 0x00,  //.@@...%%...@@.
    0x00, 0xde, 0xff, 0x18, 0x02, 0xac, 0xbc, 0x06, 0x00, 0x00, 0x16, 0xff, 0xf0, 0x00,  //.@@..%%....@@.
    0x00, 0x9c, 0xff, 0x5a, 0xa4, 0xc4, 0x0a, 0x00, 0x00, 0x00, 0x56, 0xff, 0xce, 0x00,  //.%@+%@....+@@.
    0x00, 0x2a, 0xf8, 0xf6, 0xca, 0x0e, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x82, 0x00,  //..@@@.....@@%.
    0x00, 0x00, 0xb6, 0xff, 0xd8, 0x4c, 0x0a, 0x0a, 0x44, 0xcc, 0xff, 0xe8, 0x14, 0x00,  //..%@@+..+@@@..
    0x00, 0x48, 0xf4, 0x78, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0x3a, 0x00, 0x00,  //.+@+@@@@@@@...
    0x02, 0xdc, 0x6c, 0x00, 0x34, 0xb2, 0xee, 0xf6, 0xd8, 0x8c, 0x18, 0x00, 0x00, 0x00,  //.@+..%@@@%....
    0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+00d9 (Ù) , Width: 10 */
    0x00, 0x00, 0x7e, 0xff, 0xec, 0x26, 0x00, 0x00, 0x00, 0x00,  //..+@@.....
    0x00, 0x00, 0x00, 0x7c, 0xff, 0xde, 0x18, 0x00, 0x00, 0x00,  //...+@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc,  //@@......@@
    0xee, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xee,  //@@......@@
    0xc4, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xc4,  //@@+....+@@
    0x6e, 0xff, 0xe8, 0x54, 0x12, 0x12, 0x56, 0xea, 0xff, 0x6c,  //+@@+..+@@+
    0x04, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x04,  //.@@@@@@@@.
    0x00, 0x08, 0x7a, 0xd2, 0xf6, 0xf4, 0xd2, 0x7a, 0x08, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00da (Ú) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0xb0, 0xc6, 0x0e, 0x00, 0x00, 0x00,  //....%@....
    0x00, 0x00, 0x00, 0x90, 0xc6, 0x0e, 0x00, 0x00, 0x00, 0x00,  //...%@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc,  //@@......@@
    0xee, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xee,  //@@......@@
    0xc4, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xc4,  //@@+....+@@
    0x6e, 0xff, 0xe8, 0x54, 0x12, 0x12, 0x56, 0xea, 0xff, 0x6c,  //+@@+..+@@+
    0x04, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x04,  //.@@@@@@@@.
    0x00, 0x08, 0x7a, 0xd2, 0xf6, 0xf4, 0xd2, 0x7a, 0x08, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00db (Û) , Width: 10 */
    0x00, 0x00, 0x00, 0x10, 0xd6, 0xd6, 0x10, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0xa4, 0x50, 0x50, 0xa4, 0x00, 0x00, 0x00,  //...%++%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc,  //@@......@@
    0xee, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xee,  //@@......@@
    0xc4, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xc4,  //@@+....+@@
    0x6e, 0xff, 0xe8, 0x54, 0x12, 0x12, 0x56, 0xea, 0xff, 0x6c,  //+@@+..+@@+
    0x04, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x04,  //.@@@@@@@@.
    0x00, 0x08, 0x7a, 0xd2, 0xf6, 0xf4, 0xd2, 0x7a, 0x08, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00dc (Ü) , Width: 10 */
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc,  //@@......@@
    0xee, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xee,  //@@......@@
    0xc4, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xc4,  //@@+....+@@
    0x6e, 0xff, 0xe8, 0x54, 0x12, 0x12, 0x56, 0xea, 0xff, 0x6c,  //+@@+..+@@+
    0x04, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x04,  //.@@@@@@@@.
    0x00, 0x08, 0x7a, 0xd2, 0xf6, 0xf4, 0xd2, 0x7a, 0x08, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00dd (Ý) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xc6, 0x0e, 0x00, 0x00, 0x00, 0x00,  //.....%@.....
    0x00, 0x00, 0x00, 0x00, 0x90, 0xc6, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xa0, 0xff, 0xca, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0xca, 0xff, 0xa0,  //%@@......@@%
    0x0a, 0xd8, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xd8, 0x0a,  //.@@+....+@@.
    0x00, 0x30, 0xf8, 0xf4, 0x22, 0x00, 0x00, 0x22, 0xf4, 0xf6, 0x30, 0x00,  //..@@....@@..
    0x00, 0x00, 0x6e, 0xff, 0xbc, 0x00, 0x00, 0xbe, 0xff, 0x6c, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0x00, 0xb0, 0xff, 0x64, 0x66, 0xff, 0xb0, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x00, 0x12, 0xe2, 0xf0, 0xf0, 0xe2, 0x10, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00de (Þ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xc0, 0x4a, 0x00,  //@@@@@%+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e,  //@@@@@@@+
    0xff, 0xff, 0x00, 0x00, 0x1a, 0xa6, 0xff, 0xc6,  //@@...%@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x18, 0xa6, 0xff, 0xc6,  //@@...%@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e,  //@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xc2, 0x4a, 0x00,  //@@@@@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00df (ß) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x42, 0xbe, 0xf2, 0xf6, 0xca, 0x4c, 0x00, 0x00,  //.+%@@@+..
    0x46, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x38, 0x00,  //+@@@@@@..
    0xc4, 0xff, 0x9e, 0x14, 0x10, 0x92, 0xff, 0xb4, 0x00,  //@@%..%@%.
    0xf4, 0xff, 0x12, 0x00, 0x00, 0x40, 0xff, 0xe2, 0x00,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x70, 0xff, 0xc4, 0x52, 0x00,  //@@..+@@+.
    0xff, 0xff, 0x00, 0x00, 0xea, 0xff, 0x14, 0x00, 0x00,  //@@..@@...
    0xff, 0xff, 0x00, 0x00, 0xe0, 0xff, 0x00, 0x00, 0x00,  //@@..@@...
    0xff, 0xff, 0x00, 0x00, 0x36, 0xd8, 0x8a, 0x08, 0x00,  //@@...@%..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0xe0, 0xd4, 0x1c,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xb8,  //@@.....@%
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf4,  //@@.....@@
    0xff, 0xff, 0x00, 0xa0, 0x26, 0x0a, 0x7e, 0xff, 0xda,  //@@.%..+@@
    0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x78,  //@@.@@@@@+
    0xff, 0xff, 0x00, 0x50, 0xd6, 0xf4, 0xd4, 0x70, 0x02,  //@@.+@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+00e0 (à) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x8a, 0xe8, 0x1c, 0x00, 0x00, 0x00,  //..%@....
    0x00, 0x00, 0x00, 0xa0, 0xc8, 0x06, 0x00, 0x00,  //...%@...
    0x00, 0x00, 0x00, 0x02, 0xb6, 0x9a, 0x00, 0x00,  //....%%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x44, 0xb2, 0xee, 0xf4, 0xc4, 0x42, 0x00,  //.+%@@@+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x32,  //.@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xa6,  //.%...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xe0,  //......@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x10, 0xff, 0xff,  //@@+...@@
    0xec, 0xff, 0x4e, 0x06, 0x20, 0xaa, 0xff, 0xff,  //@@+..%@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff,  //%@@@@%@@
    0x10, 0xa2, 0xec, 0xee, 0x9c, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e1 (á) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xea, 0x8a, 0x00,  //.....@%.
    0x00, 0x00, 0x00, 0x06, 0xca, 0xa0, 0x00, 0x00,  //....@%..
    0x00, 0x00, 0x00, 0x9a, 0xb6, 0x02, 0x00, 0x00,  //...%%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x44, 0xb2, 0xee, 0xf4, 0xc4, 0x42, 0x00,  //.+%@@@+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x32,  //.@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xa6,  //.%...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xe0,  //......@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x10, 0xff, 0xff,  //@@+...@@
    0xec, 0xff, 0x4e, 0x06, 0x20, 0xaa, 0xff, 0xff,  //@@+..%@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff,  //%@@@@%@@
    0x10, 0xa2, 0xec, 0xee, 0x9c, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e2 (â) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x22, 0xf0, 0xf0, 0x22, 0x00, 0x00,  //...@@...
    0x00, 0x08, 0xce, 0x9a, 0x9a, 0xce, 0x08, 0x00,  //..@%%@..
    0x00, 0x9c, 0xb8, 0x02, 0x02, 0xb8, 0x9c, 0x00,  //.%%..%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x44, 0xb2, 0xee, 0xf4, 0xc4, 0x42, 0x00,  //.+%@@@+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x32,  //.@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xa6,  //.%...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xe0,  //......@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x10, 0xff, 0xff,  //@@+...@@
    0xec, 0xff, 0x4e, 0x06, 0x20, 0xaa, 0xff, 0xff,  //@@+..%@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff,  //%@@@@%@@
    0x10, 0xa2, 0xec, 0xee, 0x9c, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e3 (ã) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x66, 0xf0, 0xca, 0x34, 0x28, 0xea, 0x00,  //.+@@..@.
    0x00, 0xea, 0x28, 0x34, 0xca, 0xf0, 0x66, 0x00,  //.@..@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x44, 0xb2, 0xee, 0xf4, 0xc4, 0x42, 0x00,  //.+%@@@+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x32,  //.@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xa6,  //.%...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xe0,  //......@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x10, 0xff, 0xff,  //@@+...@@
    0xec, 0xff, 0x4e, 0x06, 0x20, 0xaa, 0xff, 0xff,  //@@+..%@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff,  //%@@@@%@@
    0x10, 0xa2, 0xec, 0xee, 0x9c, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e4 (ä) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,  //.@@..@@.
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,  //.@@..@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x44, 0xb2, 0xee, 0xf4, 0xc4, 0x42, 0x00,  //.+%@@@+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x32,  //.@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xa6,  //.%...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xe0,  //......@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x10, 0xff, 0xff,  //@@+...@@
    0xec, 0xff, 0x4e, 0x06, 0x20, 0xaa, 0xff, 0xff,  //@@+..%@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff,  //%@@@@%@@
    0x10, 0xa2, 0xec, 0xee, 0x9c, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e5 (å) , Width: 8 */
    0x00, 0x00, 0x1e, 0xbc, 0xf2, 0xba, 0x1c, 0x00,  //...%@%..
    0x00, 0x00, 0xbc, 0x74, 0x0a, 0x76, 0xba, 0x00,  //..%+.+%.
    0x00, 0x00, 0xf2, 0x0a, 0x00, 0x0a, 0xf2, 0x00,  //..@...@.
    0x00, 0x00, 0xbe, 0x72, 0x0a, 0x76, 0xbc, 0x00,  //..%+.+%.
    0x00, 0x00, 0x20, 0xbe, 0xf2, 0xbc, 0x1e, 0x00,  //...%@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x44, 0xb2, 0xee, 0xf4, 0xc4, 0x42, 0x00,  //.+%@@@+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x32,  //.@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xa6,  //.%...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xe0,  //......@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x10, 0xff, 0xff,  //@@+...@@
    0xec, 0xff, 0x4e, 0x06, 0x20, 0xaa, 0xff, 0xff,  //@@+..%@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff,  //%@@@@%@@
    0x10, 0xa2, 0xec, 0xee, 0x9c, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e6 (æ) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x44, 0xb4, 0xf0, 0xee, 0xae, 0x20, 0x00, 0x40, 0xc0, 0xf2, 0xec, 0xa2, 0x1a, 0x00,  //.+%@@%...%@@%..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x60, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x0e,  //.@@@@@@+@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xff, 0xd2, 0x3a, 0x08, 0x22, 0xb6, 0xff, 0x82,  //.%...%@@@...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xff, 0x32, 0x00, 0x00, 0x00, 0x18, 0xff, 0xd2,  //......@@.....@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //.+@@@@@@@@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x1a, 0xff, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+...@@.......
    0xec, 0xff, 0x4e, 0x06, 0x24, 0xb8, 0xff, 0xff, 0xda, 0x50, 0x14, 0x02, 0x18, 0x56, 0xbe,  //@@+..%@@@+...+%
    0xa0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@+%@@@@@@@
    0x0c, 0x96, 0xe4, 0xf6, 0xcc, 0x54, 0x00, 0x00, 0x66, 0xc4, 0xee, 0xf8, 0xde, 0x9a, 0x32,  //.%@@@+..+@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+00e7 (ç) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x02, 0x6e, 0xca, 0xf2, 0xf4, 0xbe, 0x4c,  //..+@@@%+
    0x04, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x72, 0xff, 0xf2, 0x6c, 0x1a, 0x06, 0x38, 0xae,  //+@@+...%
    0xce, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+.....
    0xf4, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xf4, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xce, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+.....
    0x70, 0xff, 0xf0, 0x6a, 0x1a, 0x06, 0x36, 0xae,  //+@@+...%
    0x04, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x04, 0x72, 0xd0, 0xf6, 0xf2, 0xbe, 0x4c,  //..+@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x70, 0x00,  //.....@+.
    0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xee, 0x00,  //.....@@.
    0x00, 0x00, 0x00, 0xe4, 0xfa, 0xea, 0x80, 0x00,  //...@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00e8 (è) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x8a, 0xe8, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@......
    0x00, 0x00, 0x00, 0xa0, 0xc8, 0x06, 0x00, 0x00, 0x00, 0x00,  //...%@.....
    0x00, 0x00, 0x00, 0x02, 0xb6, 0x9a, 0x00, 0x00, 0x00, 0x00,  //....%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x5a, 0xbe, 0xee, 0xf8, 0xda, 0x88, 0x0e, 0x00,  //..+%@@@%..
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0c,  //.%@@@@@@@.
    0x62, 0xff, 0xe2, 0x54, 0x12, 0x08, 0x38, 0xc8, 0xff, 0x86,  //+@@+...@@%
    0xc6, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xd8,  //@@......@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xca, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@........
    0x60, 0xff, 0xe6, 0x62, 0x1e, 0x08, 0x06, 0x24, 0x64, 0xc4,  //+@@+....+@
    0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x00, 0x42, 0xaa, 0xe2, 0xf8, 0xf4, 0xd2, 0x8c, 0x2e,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00e9 (é) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xea, 0x8a, 0x00, 0x00, 0x00,  //.....@%...
    0x00, 0x00, 0x00, 0x06, 0xca, 0xa0, 0x00, 0x00, 0x00, 0x00,  //....@%....
    0x00, 0x00, 0x00, 0x9a, 0xb6, 0x02, 0x00, 0x00, 0x00, 0x00,  //...%%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x5a, 0xbe, 0xee, 0xf8, 0xda, 0x88, 0x0e, 0x00,  //..+%@@@%..
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0c,  //.%@@@@@@@.
    0x62, 0xff, 0xe2, 0x54, 0x12, 0x08, 0x38, 0xc8, 0xff, 0x86,  //+@@+...@@%
    0xc6, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xd8,  //@@......@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xca, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@........
    0x60, 0xff, 0xe6, 0x62, 0x1e, 0x08, 0x06, 0x24, 0x64, 0xc4,  //+@@+....+@
    0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x00, 0x42, 0xaa, 0xe2, 0xf8, 0xf4, 0xd2, 0x8c, 0x2e,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00ea (ê) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x1e, 0xec, 0xf0, 0x24, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x04, 0xc8, 0xa2, 0x94, 0xd0, 0x08, 0x00, 0x00,  //...@%%@...
    0x00, 0x00, 0x92, 0xbe, 0x04, 0x02, 0xb4, 0x9c, 0x00, 0x00,  //..%%..%%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x5a, 0xbe, 0xee, 0xf8, 0xda, 0x88, 0x0e, 0x00,  //..+%@@@%..
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0c,  //.%@@@@@@@.
    0x62, 0xff, 0xe2, 0x54, 0x12, 0x08, 0x38, 0xc8, 0xff, 0x86,  //+@@+...@@%
    0xc6, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xd8,  //@@......@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xca, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@........
    0x60, 0xff, 0xe6, 0x62, 0x1e, 0x08, 0x06, 0x24, 0x64, 0xc4,  //+@@+....+@
    0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x00, 0x42, 0xaa, 0xe2, 0xf8, 0xf4, 0xd2, 0x8c, 0x2e,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00eb (ë) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x5a, 0xbe, 0xee, 0xf8, 0xda, 0x88, 0x0e, 0x00,  //..+%@@@%..
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0c,  //.%@@@@@@@.
    0x62, 0xff, 0xe2, 0x54, 0x12, 0x08, 0x38, 0xc8, 0xff, 0x86,  //+@@+...@@%
    0xc6, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xd8,  //@@......@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xca, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@........
    0x60, 0xff, 0xe6, 0x62, 0x1e, 0x08, 0x06, 0x24, 0x64, 0xc4,  //+@@+....+@
    0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x00, 0x42, 0xaa, 0xe2, 0xf8, 0xf4, 0xd2, 0x8c, 0x2e,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00ec (ì) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x8a, 0xe8, 0x1c, 0x00,  //%@..
    0x00, 0xa0, 0xc8, 0x06,  //.%@.
    0x00, 0x02, 0xb6, 0x9a,  //..%%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ed (í) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x1e, 0xea, 0x8a,  //..@%
    0x06, 0xca, 0xa0, 0x00,  //.@%.
    0x9a, 0xb6, 0x02, 0x00,  //%%..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ee (î) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x22, 0xf0, 0xf0, 0x22, 0x00,  //..@@..
    0x08, 0xce, 0x9a, 0x9a, 0xce, 0x08,  //.@%%@.
    0x9c, 0xb8, 0x02, 0x02, 0xb8, 0x9c,  //%%..%%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00ef (ï) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00f0 (ð) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x7c, 0xcc, 0x0c, 0x00, 0x30, 0x7c, 0x7c, 0x00,  //..+@...++.
    0x00, 0x00, 0x02, 0xb4, 0xd4, 0xe2, 0xdc, 0x8e, 0x3a, 0x00,  //...%@@@%..
    0x00, 0x96, 0xea, 0xca, 0xb6, 0xc6, 0x02, 0x00, 0x00, 0x00,  //.%@@%@....
    0x00, 0x44, 0x18, 0x00, 0x02, 0xac, 0xa2, 0x00, 0x00, 0x00,  //.+...%%...
    0x00, 0x02, 0x72, 0xd0, 0xf6, 0xee, 0xff, 0xc0, 0x1e, 0x00,  //..+@@@@%..
    0x02, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x14,  //.%@@@@@@@.
    0x6c, 0xff, 0xf2, 0x6e, 0x1c, 0x06, 0x22, 0xc6, 0xff, 0x84,  //+@@+...@@%
    0xcc, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xd0,  //@@+.....@@
    0xf4, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x08, 0xff, 0xf2,  //@@......@@
    0xf4, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf2,  //@@......@@
    0xca, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xc8,  //@@+....+@@
    0x68, 0xff, 0xf0, 0x62, 0x14, 0x14, 0x62, 0xf0, 0xff, 0x66,  //+@@+..+@@+
    0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00,  //.%@@@@@@%.
    0x00, 0x00, 0x68, 0xca, 0xf4, 0xf4, 0xca, 0x66, 0x00, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f1 (ñ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x66, 0xf0, 0xca, 0x34, 0x28, 0xea, 0x00,  //.+@@..@.
    0x00, 0xea, 0x28, 0x34, 0xca, 0xf0, 0x66, 0x00,  //.@..@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x08, 0x9c, 0xf0, 0xea, 0x86, 0x00,  //@@.%@@%.
    0xff, 0xff, 0xaa, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@%@@@@+
    0xff, 0xff, 0xcc, 0x2a, 0x0e, 0x98, 0xff, 0xca,  //@@@..%@@
    0xff, 0xff, 0x36, 0x00, 0x00, 0x18, 0xff, 0xf2,  //@@....@@
    0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00f2 (ò) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x8a, 0xe8, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@......
    0x00, 0x00, 0x00, 0xa0, 0xc8, 0x06, 0x00, 0x00, 0x00, 0x00,  //...%@.....
    0x00, 0x00, 0x00, 0x02, 0xb6, 0x9a, 0x00, 0x00, 0x00, 0x00,  //....%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x04, 0x76, 0xce, 0xf4, 0xf4, 0xce, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x04,  //.%@@@@@@%.
    0x76, 0xff, 0xee, 0x60, 0x14, 0x14, 0x60, 0xf0, 0xff, 0x74,  //+@@+..+@@+
    0xd0, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xce,  //@@+....+@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xd0, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xce,  //@@+....+@@
    0x76, 0xff, 0xec, 0x5c, 0x12, 0x12, 0x5e, 0xee, 0xff, 0x74,  //+@@+..+@@+
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //.%@@@@@@%.
    0x00, 0x06, 0x76, 0xd0, 0xf6, 0xf4, 0xd0, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f3 (ó) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x1e, 0xea, 0x8a, 0x00, 0x00, 0x00,  //.....@%...
    0x00, 0x00, 0x00, 0x06, 0xca, 0xa0, 0x00, 0x00, 0x00, 0x00,  //....@%....
    0x00, 0x00, 0x00, 0x9a, 0xb6, 0x02, 0x00, 0x00, 0x00, 0x00,  //...%%.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x04, 0x76, 0xce, 0xf4, 0xf4, 0xce, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x04,  //.%@@@@@@%.
    0x76, 0xff, 0xee, 0x60, 0x14, 0x14, 0x60, 0xf0, 0xff, 0x74,  //+@@+..+@@+
    0xd0, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xce,  //@@+....+@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xd0, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xce,  //@@+....+@@
    0x76, 0xff, 0xec, 0x5c, 0x12, 0x12, 0x5e, 0xee, 0xff, 0x74,  //+@@+..+@@+
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //.%@@@@@@%.
    0x00, 0x06, 0x76, 0xd0, 0xf6, 0xf4, 0xd0, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f4 (ô) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x22, 0xf0, 0xf0, 0x22, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x08, 0xce, 0x9a, 0x9a, 0xce, 0x08, 0x00, 0x00,  //...@%%@...
    0x00, 0x00, 0x9c, 0xb8, 0x02, 0x02, 0xb8, 0x9c, 0x00, 0x00,  //..%%..%%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x04, 0x76, 0xce, 0xf4, 0xf4, 0xce, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x04,  //.%@@@@@@%.
    0x76, 0xff, 0xee, 0x60, 0x14, 0x14, 0x60, 0xf0, 0xff, 0x74,  //+@@+..+@@+
    0xd0, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xce,  //@@+....+@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xd0, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xce,  //@@+....+@@
    0x76, 0xff, 0xec, 0x5c, 0x12, 0x12, 0x5e, 0xee, 0xff, 0x74,  //+@@+..+@@+
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //.%@@@@@@%.
    0x00, 0x06, 0x76, 0xd0, 0xf6, 0xf4, 0xd0, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f5 (õ) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x66, 0xf0, 0xca, 0x34, 0x28, 0xea, 0x00, 0x00,  //..+@@..@..
    0x00, 0x00, 0xea, 0x28, 0x34, 0xca, 0xf0, 0x66, 0x00, 0x00,  //..@..@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x04, 0x76, 0xce, 0xf4, 0xf4, 0xce, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x04,  //.%@@@@@@%.
    0x76, 0xff, 0xee, 0x60, 0x14, 0x14, 0x60, 0xf0, 0xff, 0x74,  //+@@+..+@@+
    0xd0, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xce,  //@@+....+@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xd0, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xce,  //@@+....+@@
    0x76, 0xff, 0xec, 0x5c, 0x12, 0x12, 0x5e, 0xee, 0xff, 0x74,  //+@@+..+@@+
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //.%@@@@@@%.
    0x00, 0x06, 0x76, 0xd0, 0xf6, 0xf4, 0xd0, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f6 (ö) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..@@..
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@..@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x04, 0x76, 0xce, 0xf4, 0xf4, 0xce, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x04,  //.%@@@@@@%.
    0x76, 0xff, 0xee, 0x60, 0x14, 0x14, 0x60, 0xf0, 0xff, 0x74,  //+@@+..+@@+
    0xd0, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xce,  //@@+....+@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xd0, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xce,  //@@+....+@@
    0x76, 0xff, 0xec, 0x5c, 0x12, 0x12, 0x5e, 0xee, 0xff, 0x74,  //+@@+..+@@+
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //.%@@@@@@%.
    0x00, 0x06, 0x76, 0xd0, 0xf6, 0xf4, 0xd0, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+00f7 (÷) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f8 (ø) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00,  //..........+.
    0x00, 0x00, 0x00, 0x42, 0xba, 0xf2, 0xee, 0xac, 0x26, 0x60, 0xf4, 0x1e,  //...+%@@%.+@.
    0x00, 0x00, 0x7a, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xee, 0xf4, 0x6a, 0x00,  //..+@@@@@@@+.
    0x00, 0x54, 0xff, 0xf0, 0x60, 0x14, 0x10, 0x76, 0xff, 0xfa, 0x22, 0x00,  //.+@@+..+@@..
    0x00, 0xcc, 0xff, 0x62, 0x00, 0x00, 0x2e, 0xe2, 0xa6, 0xff, 0xa2, 0x00,  //.@@+...@%@%.
    0x00, 0xf6, 0xff, 0x16, 0x00, 0x40, 0xe8, 0x52, 0x0a, 0xff, 0xe8, 0x00,  //.@@...@+.@@.
    0x00, 0xe8, 0xff, 0x08, 0x56, 0xe8, 0x3e, 0x00, 0x14, 0xff, 0xf6, 0x00,  //.@@.+@...@@.
    0x00, 0xa2, 0xff, 0xa4, 0xe2, 0x2c, 0x00, 0x00, 0x60, 0xff, 0xce, 0x00,  //.%@%@...+@@.
    0x00, 0x20, 0xfa, 0xff, 0x76, 0x0e, 0x12, 0x5e, 0xee, 0xff, 0x5a, 0x00,  //..@@+..+@@+.
    0x00, 0x62, 0xf4, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0x88, 0x00, 0x00,  //.+@@@@@@@%..
    0x18, 0xee, 0x5e, 0x26, 0xb0, 0xf0, 0xf4, 0xc2, 0x4e, 0x00, 0x00, 0x00,  //.@+.%@@@+...
    0x08, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+00f9 (ù) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x8a, 0xe8, 0x1c, 0x00, 0x00, 0x00, 0x00,  //.%@.....
    0x00, 0x00, 0xa0, 0xc8, 0x06, 0x00, 0x00, 0x00,  //..%@....
    0x00, 0x00, 0x02, 0xb6, 0x9a, 0x00, 0x00, 0x00,  //...%%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff,  //@@....@@
    0xea, 0xff, 0x1a, 0x00, 0x00, 0x36, 0xff, 0xff,  //@@....@@
    0xc4, 0xff, 0x96, 0x0c, 0x2a, 0xcc, 0xff, 0xff,  //@@%..@@@
    0x60, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xff, 0xff,  //+@@@@%@@
    0x00, 0x86, 0xea, 0xf0, 0xa0, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00fa (ú) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x1e, 0xea, 0x8a, 0x00, 0x00,  //....@%..
    0x00, 0x00, 0x06, 0xca, 0xa0, 0x00, 0x00, 0x00,  //...@%...
    0x00, 0x00, 0x9a, 0xb6, 0x02, 0x00, 0x00, 0x00,  //..%%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff,  //@@....@@
    0xea, 0xff, 0x1a, 0x00, 0x00, 0x36, 0xff, 0xff,  //@@....@@
    0xc4, 0xff, 0x96, 0x0c, 0x2a, 0xcc, 0xff, 0xff,  //@@%..@@@
    0x60, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xff, 0xff,  //+@@@@%@@
    0x00, 0x86, 0xea, 0xf0, 0xa0, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00fb (û) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x22, 0xf0, 0xf0, 0x22, 0x00, 0x00,  //...@@...
    0x00, 0x08, 0xce, 0x9a, 0x9a, 0xce, 0x08, 0x00,  //..@%%@..
    0x00, 0x9c, 0xb8, 0x02, 0x02, 0xb8, 0x9c, 0x00,  //.%%..%%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff,  //@@....@@
    0xea, 0xff, 0x1a, 0x00, 0x00, 0x36, 0xff, 0xff,  //@@....@@
    0xc4, 0xff, 0x96, 0x0c, 0x2a, 0xcc, 0xff, 0xff,  //@@%..@@@
    0x60, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xff, 0xff,  //+@@@@%@@
    0x00, 0x86, 0xea, 0xf0, 0xa0, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00fc (ü) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,  //.@@..@@.
    0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,  //.@@..@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff,  //@@....@@
    0xea, 0xff, 0x1a, 0x00, 0x00, 0x36, 0xff, 0xff,  //@@....@@
    0xc4, 0xff, 0x96, 0x0c, 0x2a, 0xcc, 0xff, 0xff,  //@@%..@@@
    0x60, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xff, 0xff,  //+@@@@%@@
    0x00, 0x86, 0xea, 0xf0, 0xa0, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00fd (ý) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xea, 0x8a, 0x00, 0x00, 0x00, 0x00,  //......@%....
    0x00, 0x00, 0x00, 0x00, 0x06, 0xca, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@%.....
    0x00, 0x00, 0x00, 0x00, 0x9a, 0xb6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%%......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x24, 0xfc, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2, 0xfc, 0x26,  //.@@......@@.
    0x00, 0xa8, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xae, 0x00,  //.%@+....+@%.
    0x00, 0x30, 0xff, 0xe4, 0x04, 0x00, 0x00, 0x02, 0xe0, 0xff, 0x38, 0x00,  //..@@....@@..
    0x00, 0x00, 0xb6, 0xff, 0x5e, 0x00, 0x00, 0x56, 0xff, 0xc2, 0x00, 0x00,  //..%@+..+@@..
    0x00, 0x00, 0x3e, 0xff, 0xd0, 0x00, 0x00, 0xc6, 0xff, 0x4c, 0x00, 0x00,  //...@@..@@+..
    0x00, 0x00, 0x00, 0xc4, 0xff, 0x42, 0x36, 0xff, 0xd4, 0x00, 0x00, 0x00,  //...@@+.@@...
    0x00, 0x00, 0x00, 0x4a, 0xff, 0xb6, 0xa8, 0xff, 0x60, 0x00, 0x00, 0x00,  //...+@%%@+...
    0x00, 0x00, 0x00, 0x00, 0xd0, 0xfc, 0xfa, 0xe2, 0x04, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xee, 0x0c, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@%.....
    0x00, 0x00, 0x00, 0x10, 0xba, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@......
    0x00, 0x00, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%......
    0x00, 0x00, 0xff, 0xf6, 0xb6, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@%.......


    /*Unicode: U+00fe (þ) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x08, 0x98, 0xea, 0xf2, 0xae, 0x1e, 0x00,  //@@.%@@%..
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10,  //@@%@@@@@.
    0xff, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x88,  //@@@...@@%
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd4,  //@@+...+@@
    0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd4,  //@@+...+@@
    0xff, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x88,  //@@@...@@%
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10,  //@@%@@@@@.
    0xff, 0xff, 0x0a, 0x9a, 0xec, 0xf2, 0xae, 0x20, 0x00,  //@@.%@@%..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......


    /*Unicode: U+00ff (ÿ) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@.@@....
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //...@@.@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x24, 0xfc, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2, 0xfc, 0x26,  //.@@......@@.
    0x00, 0xa8, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xae, 0x00,  //.%@+....+@%.
    0x00, 0x30, 0xff, 0xe4, 0x04, 0x00, 0x00, 0x02, 0xe0, 0xff, 0x38, 0x00,  //..@@....@@..
    0x00, 0x00, 0xb6, 0xff, 0x5e, 0x00, 0x00, 0x56, 0xff, 0xc2, 0x00, 0x00,  //..%@+..+@@..
    0x00, 0x00, 0x3e, 0xff, 0xd0, 0x00, 0x00, 0xc6, 0xff, 0x4c, 0x00, 0x00,  //...@@..@@+..
    0x00, 0x00, 0x00, 0xc4, 0xff, 0x42, 0x36, 0xff, 0xd4, 0x00, 0x00, 0x00,  //...@@+.@@...
    0x00, 0x00, 0x00, 0x4a, 0xff, 0xb6, 0xa8, 0xff, 0x60, 0x00, 0x00, 0x00,  //...+@%%@+...
    0x00, 0x00, 0x00, 0x00, 0xd0, 0xfc, 0xfa, 0xe2, 0x04, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xee, 0x0c, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@%.....
    0x00, 0x00, 0x00, 0x10, 0xba, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@......
    0x00, 0x00, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%......
    0x00, 0x00, 0xff, 0xf6, 0xb6, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@%.......



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_20_latin_sup_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_20_LATIN_SUP == 1
    {.w_px = 6,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 2,   .glyph_index = 20}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 8,   .glyph_index = 40}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 9,   .glyph_index = 60}, /*Unicode: U+00a3 (£)*/
    {.w_px = 9,   .glyph_index = 100},    /*Unicode: U+00a4 (¤)*/
    {.w_px = 10,  .glyph_index = 140},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 2,   .glyph_index = 180},    /*Unicode: U+00a6 (¦)*/
    {.w_px = 7,   .glyph_index = 200},    /*Unicode: U+00a7 (§)*/
    {.w_px = 6,   .glyph_index = 220},    /*Unicode: U+00a8 (¨)*/
    {.w_px = 13,  .glyph_index = 240},    /*Unicode: U+00a9 (©)*/
    {.w_px = 8,   .glyph_index = 280},    /*Unicode: U+00aa (ª)*/
    {.w_px = 8,   .glyph_index = 300},    /*Unicode: U+00ab («)*/
    {.w_px = 11,  .glyph_index = 320},    /*Unicode: U+00ac (¬)*/
    {.w_px = 5,   .glyph_index = 360},    /*Unicode: U+00ad (­)*/
    {.w_px = 13,  .glyph_index = 380},    /*Unicode: U+00ae (®)*/
    {.w_px = 5,   .glyph_index = 420},    /*Unicode: U+00af (¯)*/
    {.w_px = 6,   .glyph_index = 440},    /*Unicode: U+00b0 (°)*/
    {.w_px = 12,  .glyph_index = 460},    /*Unicode: U+00b1 (±)*/
    {.w_px = 5,   .glyph_index = 500},    /*Unicode: U+00b2 (²)*/
    {.w_px = 5,   .glyph_index = 520},    /*Unicode: U+00b3 (³)*/
    {.w_px = 4,   .glyph_index = 540},    /*Unicode: U+00b4 (´)*/
    {.w_px = 9,   .glyph_index = 560},    /*Unicode: U+00b5 (µ)*/
    {.w_px = 8,   .glyph_index = 600},    /*Unicode: U+00b6 (¶)*/
    {.w_px = 2,   .glyph_index = 620},    /*Unicode: U+00b7 (·)*/
    {.w_px = 4,   .glyph_index = 640},    /*Unicode: U+00b8 (¸)*/
    {.w_px = 5,   .glyph_index = 660},    /*Unicode: U+00b9 (¹)*/
    {.w_px = 7,   .glyph_index = 680},    /*Unicode: U+00ba (º)*/
    {.w_px = 8,   .glyph_index = 700},    /*Unicode: U+00bb (»)*/
    {.w_px = 16,  .glyph_index = 720},    /*Unicode: U+00bc (¼)*/
    {.w_px = 15,  .glyph_index = 760},    /*Unicode: U+00bd (½)*/
    {.w_px = 16,  .glyph_index = 800},    /*Unicode: U+00be (¾)*/
    {.w_px = 7,   .glyph_index = 840},    /*Unicode: U+00bf (¿)*/
    {.w_px = 12,  .glyph_index = 860},    /*Unicode: U+00c0 (À)*/
    {.w_px = 12,  .glyph_index = 900},    /*Unicode: U+00c1 (Á)*/
    {.w_px = 12,  .glyph_index = 940},    /*Unicode: U+00c2 (Â)*/
    {.w_px = 12,  .glyph_index = 980},    /*Unicode: U+00c3 (Ã)*/
    {.w_px = 12,  .glyph_index = 1020},   /*Unicode: U+00c4 (Ä)*/
    {.w_px = 12,  .glyph_index = 1060},   /*Unicode: U+00c5 (Å)*/
    {.w_px = 16,  .glyph_index = 1100},   /*Unicode: U+00c6 (Æ)*/
    {.w_px = 11,  .glyph_index = 1140},   /*Unicode: U+00c7 (Ç)*/
    {.w_px = 8,   .glyph_index = 1180},   /*Unicode: U+00c8 (È)*/
    {.w_px = 8,   .glyph_index = 1200},   /*Unicode: U+00c9 (É)*/
    {.w_px = 8,   .glyph_index = 1220},   /*Unicode: U+00ca (Ê)*/
    {.w_px = 8,   .glyph_index = 1240},   /*Unicode: U+00cb (Ë)*/
    {.w_px = 5,   .glyph_index = 1260},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 4,   .glyph_index = 1280},   /*Unicode: U+00cd (Í)*/
    {.w_px = 6,   .glyph_index = 1300},   /*Unicode: U+00ce (Î)*/
    {.w_px = 6,   .glyph_index = 1320},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 13,  .glyph_index = 1340},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 10,  .glyph_index = 1380},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 12,  .glyph_index = 1420},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 12,  .glyph_index = 1460},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 12,  .glyph_index = 1500},   /*Unicode: U+00d4 (Ô)*/
    {.w_px = 12,  .glyph_index = 1540},   /*Unicode: U+00d5 (Õ)*/
    {.w_px = 12,  .glyph_index = 1580},   /*Unicode: U+00d6 (Ö)*/
    {.w_px = 10,  .glyph_index = 1620},   /*Unicode: U+00d7 (×)*/
    {.w_px = 14,  .glyph_index = 1660},   /*Unicode: U+00d8 (Ø)*/
    {.w_px = 10,  .glyph_index = 1700},   /*Unicode: U+00d9 (Ù)*/
    {.w_px = 10,  .glyph_index = 1740},   /*Unicode: U+00da (Ú)*/
    {.w_px = 10,  .glyph_index = 1780},   /*Unicode: U+00db (Û)*/
    {.w_px = 10,  .glyph_index = 1820},   /*Unicode: U+00dc (Ü)*/
    {.w_px = 12,  .glyph_index = 1860},   /*Unicode: U+00dd (Ý)*/
    {.w_px = 8,   .glyph_index = 1900},   /*Unicode: U+00de (Þ)*/
    {.w_px = 9,   .glyph_index = 1920},   /*Unicode: U+00df (ß)*/
    {.w_px = 8,   .glyph_index = 1960},   /*Unicode: U+00e0 (à)*/
    {.w_px = 8,   .glyph_index = 1980},   /*Unicode: U+00e1 (á)*/
    {.w_px = 8,   .glyph_index = 2000},   /*Unicode: U+00e2 (â)*/
    {.w_px = 8,   .glyph_index = 2020},   /*Unicode: U+00e3 (ã)*/
    {.w_px = 8,   .glyph_index = 2040},   /*Unicode: U+00e4 (ä)*/
    {.w_px = 8,   .glyph_index = 2060},   /*Unicode: U+00e5 (å)*/
    {.w_px = 15,  .glyph_index = 2080},   /*Unicode: U+00e6 (æ)*/
    {.w_px = 8,   .glyph_index = 2120},   /*Unicode: U+00e7 (ç)*/
    {.w_px = 10,  .glyph_index = 2140},   /*Unicode: U+00e8 (è)*/
    {.w_px = 10,  .glyph_index = 2180},   /*Unicode: U+00e9 (é)*/
    {.w_px = 10,  .glyph_index = 2220},   /*Unicode: U+00ea (ê)*/
    {.w_px = 10,  .glyph_index = 2260},   /*Unicode: U+00eb (ë)*/
    {.w_px = 4,   .glyph_index = 2300},   /*Unicode: U+00ec (ì)*/
    {.w_px = 4,   .glyph_index = 2320},   /*Unicode: U+00ed (í)*/
    {.w_px = 6,   .glyph_index = 2340},   /*Unicode: U+00ee (î)*/
    {.w_px = 6,   .glyph_index = 2360},   /*Unicode: U+00ef (ï)*/
    {.w_px = 10,  .glyph_index = 2380},   /*Unicode: U+00f0 (ð)*/
    {.w_px = 8,   .glyph_index = 2420},   /*Unicode: U+00f1 (ñ)*/
    {.w_px = 10,  .glyph_index = 2440},   /*Unicode: U+00f2 (ò)*/
    {.w_px = 10,  .glyph_index = 2480},   /*Unicode: U+00f3 (ó)*/
    {.w_px = 10,  .glyph_index = 2520},   /*Unicode: U+00f4 (ô)*/
    {.w_px = 10,  .glyph_index = 2560},   /*Unicode: U+00f5 (õ)*/
    {.w_px = 10,  .glyph_index = 2600},   /*Unicode: U+00f6 (ö)*/
    {.w_px = 12,  .glyph_index = 2640},   /*Unicode: U+00f7 (÷)*/
    {.w_px = 12,  .glyph_index = 2680},   /*Unicode: U+00f8 (ø)*/
    {.w_px = 8,   .glyph_index = 2720},   /*Unicode: U+00f9 (ù)*/
    {.w_px = 8,   .glyph_index = 2740},   /*Unicode: U+00fa (ú)*/
    {.w_px = 8,   .glyph_index = 2760},   /*Unicode: U+00fb (û)*/
    {.w_px = 8,   .glyph_index = 2780},   /*Unicode: U+00fc (ü)*/
    {.w_px = 12,  .glyph_index = 2800},   /*Unicode: U+00fd (ý)*/
    {.w_px = 9,   .glyph_index = 2840},   /*Unicode: U+00fe (þ)*/
    {.w_px = 12,  .glyph_index = 2880},   /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 2
    {.w_px = 6,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 2,   .glyph_index = 40}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 8,   .glyph_index = 60}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 9,   .glyph_index = 100},    /*Unicode: U+00a3 (£)*/
    {.w_px = 9,   .glyph_index = 160},    /*Unicode: U+00a4 (¤)*/
    {.w_px = 10,  .glyph_index = 220},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 2,   .glyph_index = 280},    /*Unicode: U+00a6 (¦)*/
    {.w_px = 7,   .glyph_index = 300},    /*Unicode: U+00a7 (§)*/
    {.w_px = 6,   .glyph_index = 340},    /*Unicode: U+00a8 (¨)*/
    {.w_px = 13,  .glyph_index = 380},    /*Unicode: U+00a9 (©)*/
    {.w_px = 8,   .glyph_index = 460},    /*Unicode: U+00aa (ª)*/
    {.w_px = 8,   .glyph_index = 500},    /*Unicode: U+00ab («)*/
    {.w_px = 11,  .glyph_index = 540},    /*Unicode: U+00ac (¬)*/
    {.w_px = 5,   .glyph_index = 600},    /*Unicode: U+00ad (­)*/
    {.w_px = 13,  .glyph_index = 640},    /*Unicode: U+00ae (®)*/
    {.w_px = 5,   .glyph_index = 720},    /*Unicode: U+00af (¯)*/
    {.w_px = 6,   .glyph_index = 760},    /*Unicode: U+00b0 (°)*/
    {.w_px = 12,  .glyph_index = 800},    /*Unicode: U+00b1 (±)*/
    {.w_px = 5,   .glyph_index = 860},    /*Unicode: U+00b2 (²)*/
    {.w_px = 5,   .glyph_index = 900},    /*Unicode: U+00b3 (³)*/
    {.w_px = 4,   .glyph_index = 940},    /*Unicode: U+00b4 (´)*/
    {.w_px = 9,   .glyph_index = 960},    /*Unicode: U+00b5 (µ)*/
    {.w_px = 8,   .glyph_index = 1020},   /*Unicode: U+00b6 (¶)*/
    {.w_px = 2,   .glyph_index = 1060},   /*Unicode: U+00b7 (·)*/
    {.w_px = 4,   .glyph_index = 1080},   /*Unicode: U+00b8 (¸)*/
    {.w_px = 5,   .glyph_index = 1100},   /*Unicode: U+00b9 (¹)*/
    {.w_px = 7,   .glyph_index = 1140},   /*Unicode: U+00ba (º)*/
    {.w_px = 8,   .glyph_index = 1180},   /*Unicode: U+00bb (»)*/
    {.w_px = 16,  .glyph_index = 1220},   /*Unicode: U+00bc (¼)*/
    {.w_px = 15,  .glyph_index = 1300},   /*Unicode: U+00bd (½)*/
    {.w_px = 16,  .glyph_index = 1380},   /*Unicode: U+00be (¾)*/
    {.w_px = 7,   .glyph_index = 1460},   /*Unicode: U+00bf (¿)*/
    {.w_px = 12,  .glyph_index = 1500},   /*Unicode: U+00c0 (À)*/
    {.w_px = 12,  .glyph_index = 1560},   /*Unicode: U+00c1 (Á)*/
    {.w_px = 12,  .glyph_index = 1620},   /*Unicode: U+00c2 (Â)*/
    {.w_px = 12,  .glyph_index = 1680},   /*Unicode: U+00c3 (Ã)*/
    {.w_px = 12,  .glyph_index = 1740},   /*Unicode: U+00c4 (Ä)*/
    {.w_px = 12,  .glyph_index = 1800},   /*Unicode: U+00c5 (Å)*/
    {.w_px = 16,  .glyph_index = 1860},   /*Unicode: U+00c6 (Æ)*/
    {.w_px = 11,  .glyph_index = 1940},   /*Unicode: U+00c7 (Ç)*/
    {.w_px = 8,   .glyph_index = 2000},   /*Unicode: U+00c8 (È)*/
    {.w_px = 8,   .glyph_index = 2040},   /*Unicode: U+00c9 (É)*/
    {.w_px = 8,   .glyph_index = 2080},   /*Unicode: U+00ca (Ê)*/
    {.w_px = 8,   .glyph_index = 2120},   /*Unicode: U+00cb (Ë)*/
    {.w_px = 5,   .glyph_index = 2160},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 4,   .glyph_index = 2200},   /*Unicode: U+00cd (Í)*/
    {.w_px = 6,   .glyph_index = 2220},   /*Unicode: U+00ce (Î)*/
    {.w_px = 6,   .glyph_index = 2260},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 13,  .glyph_index = 2300},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 10,  .glyph_index = 2380},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 12,  .glyph_index = 2440},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 12,  .glyph_index = 2500},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 12,  .glyph_index = 2560},   /*Unicode: U+00d4 (Ô)*/
    {.w_px = 12,  .glyph_index = 2620},   /*Unicode: U+00d5 (Õ)*/
    {.w_px = 12,  .glyph_index = 2680},   /*Unicode: U+00d6 (Ö)*/
    {.w_px = 10,  .glyph_index = 2740},   /*Unicode: U+00d7 (×)*/
    {.w_px = 14,  .glyph_index = 2800},   /*Unicode: U+00d8 (Ø)*/
    {.w_px = 10,  .glyph_index = 2880},   /*Unicode: U+00d9 (Ù)*/
    {.w_px = 10,  .glyph_index = 2940},   /*Unicode: U+00da (Ú)*/
    {.w_px = 10,  .glyph_index = 3000},   /*Unicode: U+00db (Û)*/
    {.w_px = 10,  .glyph_index = 3060},   /*Unicode: U+00dc (Ü)*/
    {.w_px = 12,  .glyph_index = 3120},   /*Unicode: U+00dd (Ý)*/
    {.w_px = 8,   .glyph_index = 3180},   /*Unicode: U+00de (Þ)*/
    {.w_px = 9,   .glyph_index = 3220},   /*Unicode: U+00df (ß)*/
    {.w_px = 8,   .glyph_index = 3280},   /*Unicode: U+00e0 (à)*/
    {.w_px = 8,   .glyph_index = 3320},   /*Unicode: U+00e1 (á)*/
    {.w_px = 8,   .glyph_index = 3360},   /*Unicode: U+00e2 (â)*/
    {.w_px = 8,   .glyph_index = 3400},   /*Unicode: U+00e3 (ã)*/
    {.w_px = 8,   .glyph_index = 3440},   /*Unicode: U+00e4 (ä)*/
    {.w_px = 8,   .glyph_index = 3480},   /*Unicode: U+00e5 (å)*/
    {.w_px = 15,  .glyph_index = 3520},   /*Unicode: U+00e6 (æ)*/
    {.w_px = 8,   .glyph_index = 3600},   /*Unicode: U+00e7 (ç)*/
    {.w_px = 10,  .glyph_index = 3640},   /*Unicode: U+00e8 (è)*/
    {.w_px = 10,  .glyph_index = 3700},   /*Unicode: U+00e9 (é)*/
    {.w_px = 10,  .glyph_index = 3760},   /*Unicode: U+00ea (ê)*/
    {.w_px = 10,  .glyph_index = 3820},   /*Unicode: U+00eb (ë)*/
    {.w_px = 4,   .glyph_index = 3880},   /*Unicode: U+00ec (ì)*/
    {.w_px = 4,   .glyph_index = 3900},   /*Unicode: U+00ed (í)*/
    {.w_px = 6,   .glyph_index = 3920},   /*Unicode: U+00ee (î)*/
    {.w_px = 6,   .glyph_index = 3960},   /*Unicode: U+00ef (ï)*/
    {.w_px = 10,  .glyph_index = 4000},   /*Unicode: U+00f0 (ð)*/
    {.w_px = 8,   .glyph_index = 4060},   /*Unicode: U+00f1 (ñ)*/
    {.w_px = 10,  .glyph_index = 4100},   /*Unicode: U+00f2 (ò)*/
    {.w_px = 10,  .glyph_index = 4160},   /*Unicode: U+00f3 (ó)*/
    {.w_px = 10,  .glyph_index = 4220},   /*Unicode: U+00f4 (ô)*/
    {.w_px = 10,  .glyph_index = 4280},   /*Unicode: U+00f5 (õ)*/
    {.w_px = 10,  .glyph_index = 4340},   /*Unicode: U+00f6 (ö)*/
    {.w_px = 12,  .glyph_index = 4400},   /*Unicode: U+00f7 (÷)*/
    {.w_px = 12,  .glyph_index = 4460},   /*Unicode: U+00f8 (ø)*/
    {.w_px = 8,   .glyph_index = 4520},   /*Unicode: U+00f9 (ù)*/
    {.w_px = 8,   .glyph_index = 4560},   /*Unicode: U+00fa (ú)*/
    {.w_px = 8,   .glyph_index = 4600},   /*Unicode: U+00fb (û)*/
    {.w_px = 8,   .glyph_index = 4640},   /*Unicode: U+00fc (ü)*/
    {.w_px = 12,  .glyph_index = 4680},   /*Unicode: U+00fd (ý)*/
    {.w_px = 9,   .glyph_index = 4740},   /*Unicode: U+00fe (þ)*/
    {.w_px = 12,  .glyph_index = 4800},   /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 4
    {.w_px = 6,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 2,   .glyph_index = 60}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 8,   .glyph_index = 80}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 9,   .glyph_index = 160},    /*Unicode: U+00a3 (£)*/
    {.w_px = 9,   .glyph_index = 260},    /*Unicode: U+00a4 (¤)*/
    {.w_px = 10,  .glyph_index = 360},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 2,   .glyph_index = 460},    /*Unicode: U+00a6 (¦)*/
    {.w_px = 7,   .glyph_index = 480},    /*Unicode: U+00a7 (§)*/
    {.w_px = 6,   .glyph_index = 560},    /*Unicode: U+00a8 (¨)*/
    {.w_px = 13,  .glyph_index = 620},    /*Unicode: U+00a9 (©)*/
    {.w_px = 8,   .glyph_index = 760},    /*Unicode: U+00aa (ª)*/
    {.w_px = 8,   .glyph_index = 840},    /*Unicode: U+00ab («)*/
    {.w_px = 11,  .glyph_index = 920},    /*Unicode: U+00ac (¬)*/
    {.w_px = 5,   .glyph_index = 1040},   /*Unicode: U+00ad (­)*/
    {.w_px = 13,  .glyph_index = 1100},   /*Unicode: U+00ae (®)*/
    {.w_px = 5,   .glyph_index = 1240},   /*Unicode: U+00af (¯)*/
    {.w_px = 6,   .glyph_index = 1300},   /*Unicode: U+00b0 (°)*/
    {.w_px = 12,  .glyph_index = 1360},   /*Unicode: U+00b1 (±)*/
    {.w_px = 5,   .glyph_index = 1480},   /*Unicode: U+00b2 (²)*/
    {.w_px = 5,   .glyph_index = 1540},   /*Unicode: U+00b3 (³)*/
    {.w_px = 4,   .glyph_index = 1600},   /*Unicode: U+00b4 (´)*/
    {.w_px = 9,   .glyph_index = 1640},   /*Unicode: U+00b5 (µ)*/
    {.w_px = 8,   .glyph_index = 1740},   /*Unicode: U+00b6 (¶)*/
    {.w_px = 2,   .glyph_index = 1820},   /*Unicode: U+00b7 (·)*/
    {.w_px = 4,   .glyph_index = 1840},   /*Unicode: U+00b8 (¸)*/
    {.w_px = 5,   .glyph_index = 1880},   /*Unicode: U+00b9 (¹)*/
    {.w_px = 7,   .glyph_index = 1940},   /*Unicode: U+00ba (º)*/
    {.w_px = 8,   .glyph_index = 2020},   /*Unicode: U+00bb (»)*/
    {.w_px = 16,  .glyph_index = 2100},   /*Unicode: U+00bc (¼)*/
    {.w_px = 15,  .glyph_index = 2260},   /*Unicode: U+00bd (½)*/
    {.w_px = 16,  .glyph_index = 2420},   /*Unicode: U+00be (¾)*/
    {.w_px = 7,   .glyph_index = 2580},   /*Unicode: U+00bf (¿)*/
    {.w_px = 12,  .glyph_index = 2660},   /*Unicode: U+00c0 (À)*/
    {.w_px = 12,  .glyph_index = 2780},   /*Unicode: U+00c1 (Á)*/
    {.w_px = 12,  .glyph_index = 2900},   /*Unicode: U+00c2 (Â)*/
    {.w_px = 12,  .glyph_index = 3020},   /*Unicode: U+00c3 (Ã)*/
    {.w_px = 12,  .glyph_index = 3140},   /*Unicode: U+00c4 (Ä)*/
    {.w_px = 12,  .glyph_index = 3260},   /*Unicode: U+00c5 (Å)*/
    {.w_px = 16,  .glyph_index = 3380},   /*Unicode: U+00c6 (Æ)*/
    {.w_px = 11,  .glyph_index = 3540},   /*Unicode: U+00c7 (Ç)*/
    {.w_px = 8,   .glyph_index = 3660},   /*Unicode: U+00c8 (È)*/
    {.w_px = 8,   .glyph_index = 3740},   /*Unicode: U+00c9 (É)*/
    {.w_px = 8,   .glyph_index = 3820},   /*Unicode: U+00ca (Ê)*/
    {.w_px = 8,   .glyph_index = 3900},   /*Unicode: U+00cb (Ë)*/
    {.w_px = 5,   .glyph_index = 3980},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 4,   .glyph_index = 4040},   /*Unicode: U+00cd (Í)*/
    {.w_px = 6,   .glyph_index = 4080},   /*Unicode: U+00ce (Î)*/
    {.w_px = 6,   .glyph_index = 4140},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 13,  .glyph_index = 4200},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 10,  .glyph_index = 4340},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 12,  .glyph_index = 4440},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 12,  .glyph_index = 4560},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 12,  .glyph_index = 4680},   /*Unicode: U+00d4 (Ô)*/
    {.w_px = 12,  .glyph_index = 4800},   /*Unicode: U+00d5 (Õ)*/
    {.w_px = 12,  .glyph_index = 4920},   /*Unicode: U+00d6 (Ö)*/
    {.w_px = 10,  .glyph_index = 5040},   /*Unicode: U+00d7 (×)*/
    {.w_px = 14,  .glyph_index = 5140},   /*Unicode: U+00d8 (Ø)*/
    {.w_px = 10,  .glyph_index = 5280},   /*Unicode: U+00d9 (Ù)*/
    {.w_px = 10,  .glyph_index = 5380},   /*Unicode: U+00da (Ú)*/
    {.w_px = 10,  .glyph_index = 5480},   /*Unicode: U+00db (Û)*/
    {.w_px = 10,  .glyph_index = 5580},   /*Unicode: U+00dc (Ü)*/
    {.w_px = 12,  .glyph_index = 5680},   /*Unicode: U+00dd (Ý)*/
    {.w_px = 8,   .glyph_index = 5800},   /*Unicode: U+00de (Þ)*/
    {.w_px = 9,   .glyph_index = 5880},   /*Unicode: U+00df (ß)*/
    {.w_px = 8,   .glyph_index = 5980},   /*Unicode: U+00e0 (à)*/
    {.w_px = 8,   .glyph_index = 6060},   /*Unicode: U+00e1 (á)*/
    {.w_px = 8,   .glyph_index = 6140},   /*Unicode: U+00e2 (â)*/
    {.w_px = 8,   .glyph_index = 6220},   /*Unicode: U+00e3 (ã)*/
    {.w_px = 8,   .glyph_index = 6300},   /*Unicode: U+00e4 (ä)*/
    {.w_px = 8,   .glyph_index = 6380},   /*Unicode: U+00e5 (å)*/
    {.w_px = 15,  .glyph_index = 6460},   /*Unicode: U+00e6 (æ)*/
    {.w_px = 8,   .glyph_index = 6620},   /*Unicode: U+00e7 (ç)*/
    {.w_px = 10,  .glyph_index = 6700},   /*Unicode: U+00e8 (è)*/
    {.w_px = 10,  .glyph_index = 6800},   /*Unicode: U+00e9 (é)*/
    {.w_px = 10,  .glyph_index = 6900},   /*Unicode: U+00ea (ê)*/
    {.w_px = 10,  .glyph_index = 7000},   /*Unicode: U+00eb (ë)*/
    {.w_px = 4,   .glyph_index = 7100},   /*Unicode: U+00ec (ì)*/
    {.w_px = 4,   .glyph_index = 7140},   /*Unicode: U+00ed (í)*/
    {.w_px = 6,   .glyph_index = 7180},   /*Unicode: U+00ee (î)*/
    {.w_px = 6,   .glyph_index = 7240},   /*Unicode: U+00ef (ï)*/
    {.w_px = 10,  .glyph_index = 7300},   /*Unicode: U+00f0 (ð)*/
    {.w_px = 8,   .glyph_index = 7400},   /*Unicode: U+00f1 (ñ)*/
    {.w_px = 10,  .glyph_index = 7480},   /*Unicode: U+00f2 (ò)*/
    {.w_px = 10,  .glyph_index = 7580},   /*Unicode: U+00f3 (ó)*/
    {.w_px = 10,  .glyph_index = 7680},   /*Unicode: U+00f4 (ô)*/
    {.w_px = 10,  .glyph_index = 7780},   /*Unicode: U+00f5 (õ)*/
    {.w_px = 10,  .glyph_index = 7880},   /*Unicode: U+00f6 (ö)*/
    {.w_px = 12,  .glyph_index = 7980},   /*Unicode: U+00f7 (÷)*/
    {.w_px = 12,  .glyph_index = 8100},   /*Unicode: U+00f8 (ø)*/
    {.w_px = 8,   .glyph_index = 8220},   /*Unicode: U+00f9 (ù)*/
    {.w_px = 8,   .glyph_index = 8300},   /*Unicode: U+00fa (ú)*/
    {.w_px = 8,   .glyph_index = 8380},   /*Unicode: U+00fb (û)*/
    {.w_px = 8,   .glyph_index = 8460},   /*Unicode: U+00fc (ü)*/
    {.w_px = 12,  .glyph_index = 8540},   /*Unicode: U+00fd (ý)*/
    {.w_px = 9,   .glyph_index = 8660},   /*Unicode: U+00fe (þ)*/
    {.w_px = 12,  .glyph_index = 8760},   /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 8
    {.w_px = 6,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 2,   .glyph_index = 120},    /*Unicode: U+00a1 (¡)*/
    {.w_px = 8,   .glyph_index = 160},    /*Unicode: U+00a2 (¢)*/
    {.w_px = 9,   .glyph_index = 320},    /*Unicode: U+00a3 (£)*/
    {.w_px = 9,   .glyph_index = 500},    /*Unicode: U+00a4 (¤)*/
    {.w_px = 10,  .glyph_index = 680},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 2,   .glyph_index = 880},    /*Unicode: U+00a6 (¦)*/
    {.w_px = 7,   .glyph_index = 920},    /*Unicode: U+00a7 (§)*/
    {.w_px = 6,   .glyph_index = 1060},   /*Unicode: U+00a8 (¨)*/
    {.w_px = 13,  .glyph_index = 1180},   /*Unicode: U+00a9 (©)*/
    {.w_px = 8,   .glyph_index = 1440},   /*Unicode: U+00aa (ª)*/
    {.w_px = 8,   .glyph_index = 1600},   /*Unicode: U+00ab («)*/
    {.w_px = 11,  .glyph_index = 1760},   /*Unicode: U+00ac (¬)*/
    {.w_px = 5,   .glyph_index = 1980},   /*Unicode: U+00ad (­)*/
    {.w_px = 13,  .glyph_index = 2080},   /*Unicode: U+00ae (®)*/
    {.w_px = 5,   .glyph_index = 2340},   /*Unicode: U+00af (¯)*/
    {.w_px = 6,   .glyph_index = 2440},   /*Unicode: U+00b0 (°)*/
    {.w_px = 12,  .glyph_index = 2560},   /*Unicode: U+00b1 (±)*/
    {.w_px = 5,   .glyph_index = 2800},   /*Unicode: U+00b2 (²)*/
    {.w_px = 5,   .glyph_index = 2900},   /*Unicode: U+00b3 (³)*/
    {.w_px = 4,   .glyph_index = 3000},   /*Unicode: U+00b4 (´)*/
    {.w_px = 9,   .glyph_index = 3080},   /*Unicode: U+00b5 (µ)*/
    {.w_px = 8,   .glyph_index = 3260},   /*Unicode: U+00b6 (¶)*/
    {.w_px = 2,   .glyph_index = 3420},   /*Unicode: U+00b7 (·)*/
    {.w_px = 4,   .glyph_index = 3460},   /*Unicode: U+00b8 (¸)*/
    {.w_px = 5,   .glyph_index = 3540},   /*Unicode: U+00b9 (¹)*/
    {.w_px = 7,   .glyph_index = 3640},   /*Unicode: U+00ba (º)*/
    {.w_px = 8,   .glyph_index = 3780},   /*Unicode: U+00bb (»)*/
    {.w_px = 16,  .glyph_index = 3940},   /*Unicode: U+00bc (¼)*/
    {.w_px = 15,  .glyph_index = 4260},   /*Unicode: U+00bd (½)*/
    {.w_px = 16,  .glyph_index = 4560},   /*Unicode: U+00be (¾)*/
    {.w_px = 7,   .glyph_index = 4880},   /*Unicode: U+00bf (¿)*/
    {.w_px = 12,  .glyph_index = 5020},   /*Unicode: U+00c0 (À)*/
    {.w_px = 12,  .glyph_index = 5260},   /*Unicode: U+00c1 (Á)*/
    {.w_px = 12,  .glyph_index = 5500},   /*Unicode: U+00c2 (Â)*/
    {.w_px = 12,  .glyph_index = 5740},   /*Unicode: U+00c3 (Ã)*/
    {.w_px = 12,  .glyph_index = 5980},   /*Unicode: U+00c4 (Ä)*/
    {.w_px = 12,  .glyph_index = 6220},   /*Unicode: U+00c5 (Å)*/
    {.w_px = 16,  .glyph_index = 6460},   /*Unicode: U+00c6 (Æ)*/
    {.w_px = 11,  .glyph_index = 6780},   /*Unicode: U+00c7 (Ç)*/
    {.w_px = 8,   .glyph_index = 7000},   /*Unicode: U+00c8 (È)*/
    {.w_px = 8,   .glyph_index = 7160},   /*Unicode: U+00c9 (É)*/
    {.w_px = 8,   .glyph_index = 7320},   /*Unicode: U+00ca (Ê)*/
    {.w_px = 8,   .glyph_index = 7480},   /*Unicode: U+00cb (Ë)*/
    {.w_px = 5,   .glyph_index = 7640},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 4,   .glyph_index = 7740},   /*Unicode: U+00cd (Í)*/
    {.w_px = 6,   .glyph_index = 7820},   /*Unicode: U+00ce (Î)*/
    {.w_px = 6,   .glyph_index = 7940},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 13,  .glyph_index = 8060},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 10,  .glyph_index = 8320},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 12,  .glyph_index = 8520},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 12,  .glyph_index = 8760},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 12,  .glyph_index = 9000},   /*Unicode: U+00d4 (Ô)*/
    {.w_px = 12,  .glyph_index = 9240},   /*Unicode: U+00d5 (Õ)*/
    {.w_px = 12,  .glyph_index = 9480},   /*Unicode: U+00d6 (Ö)*/
    {.w_px = 10,  .glyph_index = 9720},   /*Unicode: U+00d7 (×)*/
    {.w_px = 14,  .glyph_index = 9920},   /*Unicode: U+00d8 (Ø)*/
    {.w_px = 10,  .glyph_index = 10200},  /*Unicode: U+00d9 (Ù)*/
    {.w_px = 10,  .glyph_index = 10400},  /*Unicode: U+00da (Ú)*/
    {.w_px = 10,  .glyph_index = 10600},  /*Unicode: U+00db (Û)*/
    {.w_px = 10,  .glyph_index = 10800},  /*Unicode: U+00dc (Ü)*/
    {.w_px = 12,  .glyph_index = 11000},  /*Unicode: U+00dd (Ý)*/
    {.w_px = 8,   .glyph_index = 11240},  /*Unicode: U+00de (Þ)*/
    {.w_px = 9,   .glyph_index = 11400},  /*Unicode: U+00df (ß)*/
    {.w_px = 8,   .glyph_index = 11580},  /*Unicode: U+00e0 (à)*/
    {.w_px = 8,   .glyph_index = 11740},  /*Unicode: U+00e1 (á)*/
    {.w_px = 8,   .glyph_index = 11900},  /*Unicode: U+00e2 (â)*/
    {.w_px = 8,   .glyph_index = 12060},  /*Unicode: U+00e3 (ã)*/
    {.w_px = 8,   .glyph_index = 12220},  /*Unicode: U+00e4 (ä)*/
    {.w_px = 8,   .glyph_index = 12380},  /*Unicode: U+00e5 (å)*/
    {.w_px = 15,  .glyph_index = 12540},  /*Unicode: U+00e6 (æ)*/
    {.w_px = 8,   .glyph_index = 12840},  /*Unicode: U+00e7 (ç)*/
    {.w_px = 10,  .glyph_index = 13000},  /*Unicode: U+00e8 (è)*/
    {.w_px = 10,  .glyph_index = 13200},  /*Unicode: U+00e9 (é)*/
    {.w_px = 10,  .glyph_index = 13400},  /*Unicode: U+00ea (ê)*/
    {.w_px = 10,  .glyph_index = 13600},  /*Unicode: U+00eb (ë)*/
    {.w_px = 4,   .glyph_index = 13800},  /*Unicode: U+00ec (ì)*/
    {.w_px = 4,   .glyph_index = 13880},  /*Unicode: U+00ed (í)*/
    {.w_px = 6,   .glyph_index = 13960},  /*Unicode: U+00ee (î)*/
    {.w_px = 6,   .glyph_index = 14080},  /*Unicode: U+00ef (ï)*/
    {.w_px = 10,  .glyph_index = 14200},  /*Unicode: U+00f0 (ð)*/
    {.w_px = 8,   .glyph_index = 14400},  /*Unicode: U+00f1 (ñ)*/
    {.w_px = 10,  .glyph_index = 14560},  /*Unicode: U+00f2 (ò)*/
    {.w_px = 10,  .glyph_index = 14760},  /*Unicode: U+00f3 (ó)*/
    {.w_px = 10,  .glyph_index = 14960},  /*Unicode: U+00f4 (ô)*/
    {.w_px = 10,  .glyph_index = 15160},  /*Unicode: U+00f5 (õ)*/
    {.w_px = 10,  .glyph_index = 15360},  /*Unicode: U+00f6 (ö)*/
    {.w_px = 12,  .glyph_index = 15560},  /*Unicode: U+00f7 (÷)*/
    {.w_px = 12,  .glyph_index = 15800},  /*Unicode: U+00f8 (ø)*/
    {.w_px = 8,   .glyph_index = 16040},  /*Unicode: U+00f9 (ù)*/
    {.w_px = 8,   .glyph_index = 16200},  /*Unicode: U+00fa (ú)*/
    {.w_px = 8,   .glyph_index = 16360},  /*Unicode: U+00fb (û)*/
    {.w_px = 8,   .glyph_index = 16520},  /*Unicode: U+00fc (ü)*/
    {.w_px = 12,  .glyph_index = 16680},  /*Unicode: U+00fd (ý)*/
    {.w_px = 9,   .glyph_index = 16920},  /*Unicode: U+00fe (þ)*/
    {.w_px = 12,  .glyph_index = 17100},  /*Unicode: U+00ff (ÿ)*/

#endif
};

lv_font_t lv_font_dejavu_20_latin_sup = {
    .unicode_first = 160,   /*First Unicode letter in this font*/
    .unicode_last = 255,    /*Last Unicode letter in this font*/
    .h_px = 20,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_20_latin_sup_glyph_bitmap,   /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_20_latin_sup_glyph_dsc,     /*Description of glyphs*/
    .glyph_cnt = 96,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_20_LATIN_SUP == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20_LATIN_SUP == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_20_LATIN_SUP*/
