
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_20_CYRILLIC != 0 /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 20 px Font in U+0410 (А) .. U+044f (я)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_20_cyrillic_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_20_CYRILLIC == 1
    /*Unicode: U+0410 (А) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@@+....
    0x0f, 0x00,  //....@@@@....
    0x0f, 0x00,  //....@@@@....
    0x19, 0x80,  //...%@++@%...
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //..+@%..%@+..
    0x30, 0xc0,  //..@@....@@..
    0x3f, 0xc0,  //..@@@@@@@@..
    0x7f, 0xe0,  //.%@@@@@@@@%.
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //+@%......%@+
    0xc0, 0x30,  //@@+......+@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0411 (Б) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xff, 0x00,  //@@@@@@@@.
    0xff, 0x00,  //@@@@@@@@.
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xfe, 0x00,  //@@@@@@%..
    0xff, 0x00,  //@@@@@@@@+
    0xc3, 0x80,  //@@....%@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc3, 0x80,  //@@....%@@
    0xff, 0x00,  //@@@@@@@@+
    0xfe, 0x00,  //@@@@@@%+.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0412 (В) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xfc, 0x00,  //@@@@@@+..
    0xff, 0x00,  //@@@@@@@%.
    0xc3, 0x00,  //@@...+@@.
    0xc3, 0x00,  //@@....@@.
    0xc3, 0x00,  //@@...+@%.
    0xfe, 0x00,  //@@@@@@%..
    0xfe, 0x00,  //@@@@@@@+.
    0xc3, 0x00,  //@@....%@+
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc3, 0x80,  //@@....%@@
    0xff, 0x00,  //@@@@@@@@+
    0xfe, 0x00,  //@@@@@@%..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0413 (Г) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0414 (Д) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x1f, 0xc0,  //...@@@@@@@..
    0x1f, 0xc0,  //...@@@@@@@..
    0x18, 0xc0,  //...@@...@@..
    0x18, 0xc0,  //...@@...@@..
    0x18, 0xc0,  //...@@...@@..
    0x18, 0xc0,  //...@@...@@..
    0x18, 0xc0,  //...@@...@@..
    0x18, 0xc0,  //..+@%...@@..
    0x30, 0xc0,  //..%@+...@@..
    0x30, 0xc0,  //..@@....@@..
    0x70, 0xc0,  //.%@@....@@..
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0x00, 0x00,  //............


    /*Unicode: U+0415 (Е) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0416 (Ж) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xe0, 0xc1, 0xc0,  //%@@.....@@.....@@%
    0x70, 0xc3, 0x80,  //.%@@....@@....@@%.
    0x38, 0xc7, 0x00,  //..%@@...@@...@@%..
    0x1c, 0xce, 0x00,  //...%@@..@@..@@%...
    0x0e, 0xdc, 0x00,  //....@@@.@@.@@@....
    0x0f, 0xfc, 0x00,  //....%@@%@@%@@%....
    0x0f, 0xfc, 0x00,  //....@@@@@@@@@@....
    0x1d, 0xee, 0x00,  //...%@%.@@@@.%@%...
    0x18, 0xc6, 0x00,  //..+@@...@@...@@+..
    0x30, 0xc3, 0x00,  //..@@+...@@...+@@..
    0x70, 0xc3, 0x80,  //.+@@....@@....@@+.
    0x60, 0xc1, 0x80,  //.@@.....@@.....@@.
    0xe0, 0xc1, 0xc0,  //%@%.....@@.....%@%
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0417 (З) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x7e, 0x00,  //.%@@@@%..
    0xff, 0x00,  //@@@@@@@@+
    0x83, 0x80,  //%+....%@@
    0x01, 0x80,  //.......@@
    0x03, 0x80,  //......%@%
    0x3f, 0x00,  //..@@@@@%.
    0x3f, 0x00,  //..@@@@@%.
    0x03, 0x80,  //......@@%
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x83, 0x80,  //%+...+@@%
    0xff, 0x00,  //@@@@@@@@.
    0x7c, 0x00,  //.%@@@@+..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0418 (И) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xc1, 0xc0,  //@@.....%@@
    0xc1, 0xc0,  //@@.....@@@
    0xc3, 0xc0,  //@@....%@@@
    0xc3, 0xc0,  //@@...+@%@@
    0xc6, 0xc0,  //@@...@@.@@
    0xc6, 0xc0,  //@@..+@%.@@
    0xcc, 0xc0,  //@@..@@..@@
    0xd8, 0xc0,  //@@.%@+..@@
    0xd8, 0xc0,  //@@+@@...@@
    0xf0, 0xc0,  //@@@@....@@
    0xf0, 0xc0,  //@@@%....@@
    0xe0, 0xc0,  //@@@.....@@
    0xe0, 0xc0,  //@@%.....@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0419 (Й) , Width: 10 */
    0x21, 0x00,  //..@+..+@..
    0x1e, 0x00,  //...%@@%...
    0x00, 0x00,  //..........
    0xc1, 0xc0,  //@@.....%@@
    0xc1, 0xc0,  //@@.....@@@
    0xc3, 0xc0,  //@@....%@@@
    0xc3, 0xc0,  //@@...+@%@@
    0xc6, 0xc0,  //@@...@@.@@
    0xc6, 0xc0,  //@@..+@%.@@
    0xcc, 0xc0,  //@@..@@..@@
    0xd8, 0xc0,  //@@.%@+..@@
    0xd8, 0xc0,  //@@+@@...@@
    0xf0, 0xc0,  //@@@@....@@
    0xf0, 0xc0,  //@@@%....@@
    0xe0, 0xc0,  //@@@.....@@
    0xe0, 0xc0,  //@@%.....@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+041a (К) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xc0, 0xc0,  //@@.....+@@+
    0xc1, 0x80,  //@@....+@@+.
    0xc3, 0x00,  //@@...+@@+..
    0xc6, 0x00,  //@@..+@@+...
    0xdc, 0x00,  //@@.%@@+....
    0xfc, 0x00,  //@@%@@@.....
    0xfe, 0x00,  //@@@@@@%....
    0xe6, 0x00,  //@@@+.@@+...
    0xc3, 0x00,  //@@+..+@@...
    0xc3, 0x80,  //@@....@@%..
    0xc1, 0x80,  //@@.....@@+.
    0xc0, 0xc0,  //@@.....+@@.
    0xc0, 0xe0,  //@@......%@%
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+041b (Л) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x1f, 0xe0,  //...@@@@@@@@
    0x1f, 0xe0,  //...@@@@@@@@
    0x18, 0x60,  //...@@....@@
    0x18, 0x60,  //...@@....@@
    0x18, 0x60,  //...@@....@@
    0x18, 0x60,  //...@@....@@
    0x18, 0x60,  //...@@....@@
    0x18, 0x60,  //..+@@....@@
    0x38, 0x60,  //..%@%....@@
    0x30, 0x60,  //..@@+....@@
    0x70, 0x60,  //.%@@.....@@
    0xe0, 0x60,  //@@@+.....@@
    0xc0, 0x60,  //@%.......@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+041c (М) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //@@@+....+@@@
    0xf0, 0xf0,  //@@@%....%@@@
    0xf0, 0xf0,  //@@%@....@%@@
    0xd8, 0xb0,  //@@.@+..+@.@@
    0xd9, 0xb0,  //@@.@@..@@.@@
    0xd9, 0xb0,  //@@.%@..@+.@@
    0xcf, 0x30,  //@@..@%%@..@@
    0xcf, 0x30,  //@@..@@@@..@@
    0xc6, 0x30,  //@@..+@@+..@@
    0xc6, 0x30,  //@@...@@...@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+041d (Н) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+041e (О) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x0f, 0x80,  //...+@@@@+...
    0x3f, 0xc0,  //..@@@@@@@@..
    0x70, 0xe0,  //.@@@+..+@@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //%@+......+@%
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //%@+......+@%
    0x60, 0x60,  //+@@......@@+
    0x70, 0xe0,  //.@@@+..+@@@.
    0x3f, 0xc0,  //..@@@@@@@@..
    0x1f, 0x80,  //...+@@@@+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+041f (П) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0420 (Р) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xfc,  //@@@@@%+.
    0xfe,  //@@@@@@@+
    0xc7,  //@@...%@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc7,  //@@...%@@
    0xfe,  //@@@@@@@+
    0xfc,  //@@@@@@+.
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0421 (С) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x0f, 0xc0,  //...+%@@@@%.
    0x3f, 0xe0,  //..@@@@@@@@@
    0x70, 0x20,  //.@@@+....+@
    0x60, 0x00,  //+@@........
    0xc0, 0x00,  //%@+........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //%@+........
    0x60, 0x00,  //+@@........
    0x70, 0x20,  //.@@@+....+@
    0x3f, 0xe0,  //..@@@@@@@@@
    0x0f, 0xc0,  //...+%@@@@%.
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0422 (Т) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0423 (У) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@%....@@+
    0x61, 0x80,  //.@@...+@@.
    0x73, 0x00,  //.%@%..%@+.
    0x33, 0x00,  //..@@..@@..
    0x37, 0x00,  //..@@+%@%..
    0x1e, 0x00,  //..+@@@@...
    0x1e, 0x00,  //...@@@%...
    0x1c, 0x00,  //...%@@+...
    0x0c, 0x00,  //...+@@....
    0x18, 0x00,  //...@@+....
    0x78, 0x00,  //.@@@@.....
    0x70, 0x00,  //.@@@......
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0424 (Ф) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x03, 0x00,  //......@@......
    0x1f, 0xe0,  //...%@@@@@@%...
    0x3f, 0xf0,  //.+@@@@@@@@@@+.
    0x73, 0x38,  //+@@%+.@@.+%@@+
    0xc3, 0x0c,  //@@+...@@...+@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@+...@@...+@@
    0x73, 0x18,  //+@@+..@@..+@@+
    0x3f, 0xf0,  //.+@@@@@@@@@@+.
    0x1f, 0xe0,  //...%@@@@@@%...
    0x03, 0x00,  //......@@......
    0x03, 0x00,  //......@@......
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0425 (Х) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x70, 0xe0,  //.%@%....%@%
    0x30, 0xc0,  //..@@+..+@@.
    0x39, 0x80,  //..%@@..@@+.
    0x1b, 0x80,  //...@@+%@%..
    0x0f, 0x00,  //...+@@@@...
    0x0e, 0x00,  //....%@@+...
    0x0e, 0x00,  //....%@@....
    0x0f, 0x00,  //...+@@@@...
    0x1b, 0x00,  //...@@+@@+..
    0x39, 0x80,  //..%@%.+@@..
    0x31, 0xc0,  //.+@@...@@%.
    0x60, 0xc0,  //.@@+....@@.
    0xe0, 0xe0,  //%@@.....%@%
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0426 (Ц) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xc0, 0xc0,  //@@......@@..
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x30,  //..........@@
    0x00, 0x30,  //..........@@
    0x00, 0x30,  //..........@@
    0x00, 0x00,  //............


    /*Unicode: U+0427 (Ч) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xe1, 0x80,  //@@%....@@
    0x7f, 0x80,  //+@@@@@@@@
    0x3f, 0x80,  //.+@@@@@@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0428 (Ш) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xc1, 0x83,  //@@.....@@.....@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+0429 (Щ) , Width: 18 */
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00,  //..................
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xc1, 0x83, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0xc0,  //................@@
    0x00, 0x00, 0xc0,  //................@@
    0x00, 0x00, 0xc0,  //................@@
    0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042a (Ъ) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xf8, 0x00,  //@@@@@.......
    0xf8, 0x00,  //@@@@@.......
    0x18, 0x00,  //...@@.......
    0x18, 0x00,  //...@@.......
    0x18, 0x00,  //...@@.......
    0x1f, 0xc0,  //...@@@@@@%..
    0x1f, 0xe0,  //...@@@@@@@@+
    0x18, 0x70,  //...@@....%@@
    0x18, 0x30,  //...@@.....@@
    0x18, 0x30,  //...@@.....@@
    0x18, 0x70,  //...@@....%@@
    0x1f, 0xe0,  //...@@@@@@@@+
    0x1f, 0xc0,  //...@@@@@@%..
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+042b (Ы) , Width: 13 */
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0xc0, 0x18,  //@@.........@@
    0xc0, 0x18,  //@@.........@@
    0xc0, 0x18,  //@@.........@@
    0xc0, 0x18,  //@@.........@@
    0xc0, 0x18,  //@@.........@@
    0xfe, 0x18,  //@@@@@@%....@@
    0xff, 0x18,  //@@@@@@@@+..@@
    0xc3, 0x98,  //@@....%@@..@@
    0xc1, 0x98,  //@@.....@@..@@
    0xc1, 0x98,  //@@.....@@..@@
    0xc3, 0x98,  //@@....%@@..@@
    0xff, 0x18,  //@@@@@@@@+..@@
    0xfe, 0x18,  //@@@@@@%....@@
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............
    0x00, 0x00,  //.............


    /*Unicode: U+042c (Ь) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xfe, 0x00,  //@@@@@@%..
    0xff, 0x00,  //@@@@@@@@+
    0xc3, 0x80,  //@@....%@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc3, 0x80,  //@@....%@@
    0xff, 0x00,  //@@@@@@@@+
    0xfe, 0x00,  //@@@@@@%..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+042d (Э) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x7e, 0x00,  //.%@@@@%+...
    0xff, 0x80,  //@@@@@@@@@..
    0x81, 0xc0,  //@+....+%@@.
    0x00, 0xc0,  //........%@+
    0x00, 0x60,  //.........@%
    0x3f, 0xe0,  //..@@@@@@@@@
    0x3f, 0xe0,  //..@@@@@@@@@
    0x00, 0x60,  //.........@@
    0x00, 0x60,  //........+@%
    0x00, 0xc0,  //........@@+
    0x81, 0xc0,  //@+....+@@@.
    0xff, 0x80,  //@@@@@@@@@..
    0x7e, 0x00,  //.%@@@@%+...
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+042e (Ю) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0xc0, 0xf8,  //@@.....+@@@@+...
    0xc3, 0xfc,  //@@....@@@@@@@@..
    0xc7, 0x0e,  //@@...@@@+..+@@@.
    0xc6, 0x06,  //@@..+@@......@@+
    0xcc, 0x03,  //@@..%@+......+@%
    0xcc, 0x03,  //@@..@@........@@
    0xfc, 0x03,  //@@@@@@........@@
    0xfc, 0x03,  //@@@@@@........@@
    0xcc, 0x03,  //@@..@@+......+@%
    0xce, 0x06,  //@@..%@@......@@+
    0xc7, 0x0e,  //@@...@@@+..+@@@.
    0xc3, 0xfc,  //@@...+@@@@@@@@..
    0xc1, 0xf8,  //@@.....%@@@@+...
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................


    /*Unicode: U+042f (Я) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x3f, 0x80,  //.+%@@@@@@
    0x7f, 0x80,  //+@@@@@@@@
    0xe1, 0x80,  //@@%....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xe1, 0x80,  //%@%....@@
    0x7f, 0x80,  //.%@@@@@@@
    0x1f, 0x80,  //...@@@@@@
    0x39, 0x80,  //..%@%..@@
    0x31, 0x80,  //..@@...@@
    0x71, 0x80,  //.%@%...@@
    0x61, 0x80,  //.@@....@@
    0xe1, 0x80,  //%@%....@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0430 (а) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x3c,  //.+%@@@+.
    0x7e,  //.@@@@@@.
    0x47,  //.%...%@%
    0x03,  //......@@
    0x3f,  //.+@@@@@@
    0xff,  //%@@@@@@@
    0xc3,  //@@+...@@
    0xc7,  //@@+..%@@
    0xff,  //%@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0431 (б) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x07, 0xc0,  //....+%@@@@.
    0x1f, 0xc0,  //...@@@@@@@.
    0x38, 0x00,  //..@@@+.....
    0x70, 0x00,  //.%@%.......
    0x6f, 0x00,  //.@@+@@@@+..
    0x7f, 0xc0,  //.@@@@@@@@@.
    0x70, 0xc0,  //.@@@+..+@@+
    0x60, 0x60,  //.@@+....+@@
    0x60, 0x60,  //.@@......@@
    0x60, 0x60,  //.@@......@@
    0x60, 0x60,  //.@@+....+@@
    0x30, 0xc0,  //.+@@+..+@@+
    0x3f, 0xc0,  //..@@@@@@@%.
    0x0f, 0x00,  //...+@@@@+..
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0432 (в) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xfe,  //@@@@@@%.
    0xff,  //@@@@@@@%
    0xc3,  //@@...+@@
    0xc3,  //@@...+@%
    0xfe,  //@@@@@@%.
    0xff,  //@@@@@@@%
    0xc3,  //@@...+@@
    0xc3,  //@@...+@@
    0xff,  //@@@@@@@%
    0xfc,  //@@@@@@+.
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0433 (г) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0xc0,  //@@.....
    0xc0,  //@@.....
    0xc0,  //@@.....
    0xc0,  //@@.....
    0xc0,  //@@.....
    0xc0,  //@@.....
    0xc0,  //@@.....
    0xc0,  //@@.....
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0434 (д) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x1f, 0x80,  //...@@@@@@..
    0x1f, 0x80,  //...@@@@@@..
    0x19, 0x80,  //...@@..@@..
    0x19, 0x80,  //...@@..@@..
    0x19, 0x80,  //...@@..@@..
    0x19, 0x80,  //..+@%..@@..
    0x31, 0x80,  //..@@+..@@..
    0x71, 0x80,  //.%@@...@@..
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@.......@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0435 (е) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1f, 0x00,  //..+%@@@%..
    0x7f, 0x80,  //.%@@@@@@@.
    0x61, 0xc0,  //+@@+...@@%
    0xc0, 0xc0,  //@@......@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0x00,  //@@........
    0x60, 0x40,  //+@@+....+@
    0x7f, 0xc0,  //.%@@@@@@@@
    0x1f, 0x80,  //..+%@@@@%.
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0436 (ж) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x73, 0x38,  //.%@@..@@..@@%.
    0x3b, 0x70,  //..@@%.@@.%@@..
    0x1b, 0x60,  //...@@+@@+@@...
    0x0f, 0xc0,  //...+@@@@@@+...
    0x1f, 0xe0,  //...%@@@@@@%...
    0x1f, 0xe0,  //...@@@@@@@@...
    0x3b, 0x70,  //..@@%.@@.%@@..
    0x33, 0x30,  //.+@@..@@..@@+.
    0x63, 0x18,  //.@@+..@@..+@@.
    0xe3, 0x1c,  //%@%...@@...%@%
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+0437 (з) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x7c,  //.%@@@%.
    0xfe,  //@@@@@@%
    0x86,  //%+..+@@
    0x06,  //....+@%
    0x3c,  //..@@@%.
    0x3c,  //..@@@@+
    0x06,  //....+@@
    0x86,  //%...+@@
    0xfe,  //@@@@@@%
    0x78,  //+%@@@+.
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0438 (и) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xc7,  //@@...%@@
    0xc7,  //@@..+@@@
    0xcf,  //@@..@@@@
    0xdf,  //@@.+@@@@
    0xdb,  //@@.@@+@@
    0xfb,  //@@%@@.@@
    0xf3,  //@@@@..@@
    0xf3,  //@@@%..@@
    0xe3,  //@@@...@@
    0xe3,  //@@%...@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0439 (й) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x42,  //.@+..+@.
    0x3c,  //..%@@%..
    0x00,  //........
    0x00,  //........
    0xc7,  //@@...%@@
    0xc7,  //@@..+@@@
    0xcf,  //@@..@@@@
    0xdf,  //@@.+@@@@
    0xdb,  //@@.@@+@@
    0xfb,  //@@%@@.@@
    0xf3,  //@@@@..@@
    0xf3,  //@@@%..@@
    0xe3,  //@@@...@@
    0xe3,  //@@%...@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+043a (к) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc3, 0x00,  //@@...+@@+
    0xc6, 0x00,  //@@..+@@+.
    0xcc, 0x00,  //@@.+@@+..
    0xf8, 0x00,  //@@%@@+...
    0xf8, 0x00,  //@@@@@+...
    0xfc, 0x00,  //@@@%@@...
    0xce, 0x00,  //@@+.%@%..
    0xc6, 0x00,  //@@...@@+.
    0xc3, 0x00,  //@@...+@@.
    0xc3, 0x80,  //@@....%@%
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+043b (л) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1f, 0xc0,  //...@@@@@@@
    0x1f, 0xc0,  //...@@@@@@@
    0x18, 0xc0,  //...@@...@@
    0x18, 0xc0,  //...@@...@@
    0x18, 0xc0,  //...@@...@@
    0x18, 0xc0,  //..+@@...@@
    0x38, 0xc0,  //..%@%...@@
    0x30, 0xc0,  //.+@@+...@@
    0xf0, 0xc0,  //@@@%....@@
    0xc0, 0xc0,  //@%+.....@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+043c (м) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xf3, 0xc0,  //@@@%..%@@@
    0xf3, 0xc0,  //@@@@..@@@@
    0xf3, 0xc0,  //@@%@++@%@@
    0xde, 0xc0,  //@@+@@@@+@@
    0xde, 0xc0,  //@@.@@@@.@@
    0xde, 0xc0,  //@@.%@@%.@@
    0xcc, 0xc0,  //@@..@@..@@
    0xcc, 0xc0,  //@@..@@..@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+043d (н) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+043e (о) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1e, 0x00,  //..+@@@@+..
    0x7f, 0x80,  //.%@@@@@@%.
    0x61, 0x80,  //+@@+..+@@+
    0xc0, 0xc0,  //@@+....+@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.%@@@@@@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+043f (п) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0440 (р) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xde, 0x00,  //@@.%@@%..
    0xff, 0x00,  //@@%@@@@@.
    0xe3, 0x80,  //@@@...@@%
    0xc1, 0x80,  //@@+...+@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@+...+@@
    0xe3, 0x80,  //@@@...@@%
    0xff, 0x00,  //@@%@@@@@.
    0xde, 0x00,  //@@.%@@%..
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......


    /*Unicode: U+0441 (с) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x1e,  //..+@@@%+
    0x7f,  //.%@@@@@@
    0x61,  //+@@+...%
    0xc0,  //@@+.....
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@+.....
    0x61,  //+@@+...%
    0x7f,  //.%@@@@@@
    0x1e,  //..+@@@%+
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0442 (т) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x0c, 0x00,  //....@@....
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0443 (у) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //.%@+....+@%.
    0x30, 0xc0,  //..@@....@@..
    0x30, 0xc0,  //..%@+..+@@..
    0x19, 0x80,  //...@@..@@+..
    0x19, 0x80,  //...@@+.@@...
    0x0f, 0x00,  //...+@%%@+...
    0x0f, 0x00,  //....@@@@....
    0x06, 0x00,  //....+@@+....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@%.....
    0x0c, 0x00,  //....%@......
    0x3c, 0x00,  //..@@@%......
    0x38, 0x00,  //..@@%.......


    /*Unicode: U+0444 (ф) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x03, 0x00,  //......@@......
    0x03, 0x00,  //......@@......
    0x03, 0x00,  //......@@......
    0x03, 0x00,  //......@@......
    0x3b, 0x70,  //..@@@.@@.@@@..
    0x7f, 0xf8,  //.@@@@@@@@@@@@.
    0xe7, 0x9c,  //%@@..%@@%..@@%
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xe7, 0x9c,  //%@@..%@@%..@@%
    0x7f, 0xf8,  //.@@@@@@@@@@@@.
    0x3b, 0x70,  //..@@@.@@.@@@..
    0x03, 0x00,  //......@@......
    0x03, 0x00,  //......@@......
    0x03, 0x00,  //......@@......
    0x03, 0x00,  //......@@......


    /*Unicode: U+0445 (х) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xe1, 0xc0,  //%@@....@@%
    0x61, 0x80,  //.@@+..+@@.
    0x33, 0x00,  //.+@@..@@..
    0x33, 0x00,  //..%@++@%..
    0x1e, 0x00,  //...@@@@...
    0x1e, 0x00,  //...@@@@...
    0x33, 0x00,  //..%@++@%..
    0x33, 0x00,  //.+@@..@@+.
    0x61, 0x80,  //.@@+..+@@.
    0xe1, 0xc0,  //%@@....@@%
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0446 (ц) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xc1, 0x80,  //@@.....@@..
    0xc1, 0x80,  //@@.....@@..
    0xc1, 0x80,  //@@.....@@..
    0xc1, 0x80,  //@@.....@@..
    0xc1, 0x80,  //@@.....@@..
    0xc1, 0x80,  //@@.....@@..
    0xc1, 0x80,  //@@.....@@..
    0xc1, 0x80,  //@@.....@@..
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x00, 0x60,  //.........@@
    0x00, 0x60,  //.........@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0447 (ч) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xe3,  //@@%...@@
    0x7f,  //+@@@@@@@
    0x7f,  //.%@@@@@@
    0x03,  //......@@
    0x03,  //......@@
    0x03,  //......@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0448 (ш) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xc6, 0x30,  //@@...@@...@@
    0xc6, 0x30,  //@@...@@...@@
    0xc6, 0x30,  //@@...@@...@@
    0xc6, 0x30,  //@@...@@...@@
    0xc6, 0x30,  //@@...@@...@@
    0xc6, 0x30,  //@@...@@...@@
    0xc6, 0x30,  //@@...@@...@@
    0xc6, 0x30,  //@@...@@...@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0449 (щ) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xc6, 0x30,  //@@...@@...@@..
    0xc6, 0x30,  //@@...@@...@@..
    0xc6, 0x30,  //@@...@@...@@..
    0xc6, 0x30,  //@@...@@...@@..
    0xc6, 0x30,  //@@...@@...@@..
    0xc6, 0x30,  //@@...@@...@@..
    0xc6, 0x30,  //@@...@@...@@..
    0xc6, 0x30,  //@@...@@...@@..
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0xff, 0xfc,  //@@@@@@@@@@@@@@
    0x00, 0x0c,  //............@@
    0x00, 0x0c,  //............@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+044a (ъ) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xf8, 0x00,  //@@@@@......
    0xf8, 0x00,  //@@@@@......
    0x18, 0x00,  //...@@......
    0x18, 0x00,  //...@@......
    0x1f, 0xc0,  //...@@@@@@%.
    0x1f, 0xe0,  //...@@@@@@@%
    0x18, 0x60,  //...@@...+@@
    0x18, 0x60,  //...@@...+@@
    0x1f, 0xe0,  //...@@@@@@@%
    0x1f, 0x80,  //...@@@@@@+.
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+044b (ы) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@.......@@
    0xfe, 0x60,  //@@@@@@%..@@
    0xff, 0x60,  //@@@@@@@%.@@
    0xc3, 0x60,  //@@...+@@.@@
    0xc3, 0x60,  //@@...+@@.@@
    0xff, 0x60,  //@@@@@@@%.@@
    0xfc, 0x60,  //@@@@@@+..@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+044c (ь) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xfe,  //@@@@@@%.
    0xff,  //@@@@@@@%
    0xc3,  //@@...+@@
    0xc3,  //@@...+@@
    0xff,  //@@@@@@@%
    0xfc,  //@@@@@@+.
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+044d (э) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x78,  //.%@@@+..
    0xfe,  //@@@@@@%.
    0x86,  //%...+@@+
    0x03,  //......@@
    0x7f,  //.@@@@@@@
    0x7f,  //.@@@@@@@
    0x03,  //......@@
    0x86,  //%...+@@+
    0xfe,  //@@@@@@%.
    0x78,  //+%@@@+..
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+044e (ю) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xc7, 0xc0,  //@@...%@@@%..
    0xcf, 0xe0,  //@@..@@@@@@@.
    0xdc, 0x70,  //@@.%@@...@@%
    0xd8, 0x30,  //@@.@@+...+@@
    0xf8, 0x30,  //@@@@@.....@@
    0xf8, 0x30,  //@@@@@.....@@
    0xd8, 0x30,  //@@.@@+...+@@
    0xdc, 0x70,  //@@.%@@...@@%
    0xcf, 0xe0,  //@@..@@@@@@@.
    0xc7, 0xc0,  //@@...%@@@%..
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+044f (я) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x1f, 0x80,  //..+@@@@@@
    0x7f, 0x80,  //.%@@@@@@@
    0x71, 0x80,  //.@@+...@@
    0x61, 0x80,  //.@@....@@
    0x31, 0x80,  //.+@+...@@
    0x1f, 0x80,  //..+@@@@@@
    0x1f, 0x80,  //..+@@@@@@
    0x31, 0x80,  //..@@+..@@
    0x71, 0x80,  //.@@%...@@
    0xe1, 0x80,  //%@@....@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........



#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 2
    /*Unicode: U+0410 (А) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0xff, 0x00,  //....@@@@....
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x2f, 0xff, 0xf8,  //.%@@@@@@@@%.
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x78, 0x00, 0x2d,  //+@%......%@+
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0411 (Б) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xff, 0xf8, 0x00,  //@@@@@@%..
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xf0, 0x0b, 0xc0,  //@@....%@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x0b, 0xc0,  //@@....%@@
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xf9, 0x00,  //@@@@@@%+.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0412 (В) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xff, 0xf4, 0x00,  //@@@@@@+..
    0xff, 0xfe, 0x00,  //@@@@@@@%.
    0xf0, 0x1f, 0x00,  //@@...+@@.
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x1e, 0x00,  //@@...+@%.
    0xff, 0xf8, 0x00,  //@@@@@@%..
    0xff, 0xfd, 0x00,  //@@@@@@@+.
    0xf0, 0x0b, 0x40,  //@@....%@+
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x0b, 0xc0,  //@@....%@@
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xf8, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0413 (Г) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0414 (Д) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x03, 0xff, 0xf0,  //...@@@@@@@..
    0x03, 0xff, 0xf0,  //...@@@@@@@..
    0x03, 0xc0, 0xf0,  //...@@...@@..
    0x03, 0xc0, 0xf0,  //...@@...@@..
    0x03, 0xc0, 0xf0,  //...@@...@@..
    0x03, 0xc0, 0xf0,  //...@@...@@..
    0x03, 0xc0, 0xf0,  //...@@...@@..
    0x07, 0x80, 0xf0,  //..+@%...@@..
    0x0b, 0x40, 0xf0,  //..%@+...@@..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x2f, 0x00, 0xf0,  //.%@@....@@..
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0415 (Е) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0416 (Ж) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xbc, 0x00, 0xf0, 0x03, 0xe0,  //%@@.....@@.....@@%
    0x2f, 0x00, 0xf0, 0x0f, 0x80,  //.%@@....@@....@@%.
    0x0b, 0xc0, 0xf0, 0x3e, 0x00,  //..%@@...@@...@@%..
    0x03, 0xf0, 0xf0, 0xfc, 0x00,  //...%@@..@@..@@%...
    0x00, 0xfc, 0xf3, 0xf0, 0x00,  //....@@@.@@.@@@....
    0x00, 0xbe, 0xfb, 0xe0, 0x00,  //....%@@%@@%@@%....
    0x00, 0xff, 0xff, 0xf0, 0x00,  //....@@@@@@@@@@....
    0x02, 0xe3, 0xfc, 0xb8, 0x00,  //...%@%.@@@@.%@%...
    0x07, 0xc0, 0xf0, 0x3d, 0x00,  //..+@@...@@...@@+..
    0x0f, 0x40, 0xf0, 0x1f, 0x00,  //..@@+...@@...+@@..
    0x2f, 0x00, 0xf0, 0x0f, 0x80,  //.+@@....@@....@@+.
    0x3c, 0x00, 0xf0, 0x03, 0xc0,  //.@@.....@@.....@@.
    0xb8, 0x00, 0xf0, 0x02, 0xe0,  //%@%.....@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0417 (З) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x2f, 0xf8, 0x00,  //.%@@@@%..
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0x90, 0x0b, 0xc0,  //%+....%@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x0b, 0x80,  //......%@%
    0x0f, 0xfe, 0x00,  //..@@@@@%.
    0x0f, 0xfe, 0x00,  //..@@@@@%.
    0x00, 0x0f, 0x80,  //......@@%
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0xd0, 0x1f, 0x80,  //%+...+@@%
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0x2f, 0xf4, 0x00,  //.%@@@@+..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0418 (И) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x02, 0xf0,  //@@.....%@@
    0xf0, 0x03, 0xf0,  //@@.....@@@
    0xf0, 0x0b, 0xf0,  //@@....%@@@
    0xf0, 0x1e, 0xf0,  //@@...+@%@@
    0xf0, 0x3c, 0xf0,  //@@...@@.@@
    0xf0, 0x78, 0xf0,  //@@..+@%.@@
    0xf0, 0xf0, 0xf0,  //@@..@@..@@
    0xf2, 0xd0, 0xf0,  //@@.%@+..@@
    0xf7, 0xc0, 0xf0,  //@@+@@...@@
    0xff, 0x40, 0xf0,  //@@@@....@@
    0xfe, 0x00, 0xf0,  //@@@%....@@
    0xfc, 0x00, 0xf0,  //@@@.....@@
    0xf8, 0x00, 0xf0,  //@@%.....@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0419 (Й) , Width: 10 */
    0x0d, 0x07, 0x00,  //..@+..+@..
    0x03, 0xfc, 0x00,  //...%@@%...
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x02, 0xf0,  //@@.....%@@
    0xf0, 0x03, 0xf0,  //@@.....@@@
    0xf0, 0x0b, 0xf0,  //@@....%@@@
    0xf0, 0x1e, 0xf0,  //@@...+@%@@
    0xf0, 0x3c, 0xf0,  //@@...@@.@@
    0xf0, 0x78, 0xf0,  //@@..+@%.@@
    0xf0, 0xf0, 0xf0,  //@@..@@..@@
    0xf2, 0xd0, 0xf0,  //@@.%@+..@@
    0xf7, 0xc0, 0xf0,  //@@+@@...@@
    0xff, 0x40, 0xf0,  //@@@@....@@
    0xfe, 0x00, 0xf0,  //@@@%....@@
    0xfc, 0x00, 0xf0,  //@@@.....@@
    0xf8, 0x00, 0xf0,  //@@%.....@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+041a (К) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xf0, 0x01, 0xf4,  //@@.....+@@+
    0xf0, 0x07, 0xd0,  //@@....+@@+.
    0xf0, 0x1f, 0x40,  //@@...+@@+..
    0xf0, 0x7d, 0x00,  //@@..+@@+...
    0xf2, 0xf4, 0x00,  //@@.%@@+....
    0xfb, 0xf0, 0x00,  //@@%@@@.....
    0xff, 0xf8, 0x00,  //@@@@@@%....
    0xfd, 0x3d, 0x00,  //@@@+.@@+...
    0xf4, 0x1f, 0x00,  //@@+..+@@...
    0xf0, 0x0f, 0x80,  //@@....@@%..
    0xf0, 0x03, 0xd0,  //@@.....@@+.
    0xf0, 0x01, 0xf0,  //@@.....+@@.
    0xf0, 0x00, 0xb8,  //@@......%@%
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+041b (Л) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x03, 0xff, 0xfc,  //...@@@@@@@@
    0x03, 0xff, 0xfc,  //...@@@@@@@@
    0x03, 0xc0, 0x3c,  //...@@....@@
    0x03, 0xc0, 0x3c,  //...@@....@@
    0x03, 0xc0, 0x3c,  //...@@....@@
    0x03, 0xc0, 0x3c,  //...@@....@@
    0x03, 0xc0, 0x3c,  //...@@....@@
    0x07, 0xc0, 0x3c,  //..+@@....@@
    0x0b, 0x80, 0x3c,  //..%@%....@@
    0x0f, 0x40, 0x3c,  //..@@+....@@
    0x2f, 0x00, 0x3c,  //.%@@.....@@
    0xfd, 0x00, 0x3c,  //@@@+.....@@
    0xe0, 0x00, 0x3c,  //@%.......@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+041c (М) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfd, 0x00, 0x7f,  //@@@+....+@@@
    0xff, 0x00, 0xbf,  //@@@%....%@@@
    0xfb, 0x00, 0xef,  //@@%@....@%@@
    0xf7, 0x81, 0xdf,  //@@.@+..+@.@@
    0xf3, 0xc3, 0xcf,  //@@.@@..@@.@@
    0xf2, 0xc3, 0x8f,  //@@.%@..@+.@@
    0xf0, 0xeb, 0x0f,  //@@..@%%@..@@
    0xf0, 0xff, 0x0f,  //@@..@@@@..@@
    0xf0, 0x7d, 0x0f,  //@@..+@@+..@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+041d (Н) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+041e (О) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0x80,  //...+@@@@+...
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x02, 0xff, 0x80,  //...+@@@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+041f (П) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0420 (Р) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xf4,  //@@@@@%+.
    0xff, 0xfd,  //@@@@@@@+
    0xf0, 0x2f,  //@@...%@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x2f,  //@@...%@@
    0xff, 0xfd,  //@@@@@@@+
    0xff, 0xf4,  //@@@@@@+.
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0421 (С) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x3f, 0x40, 0x1c,  //.@@@+....+@
    0x7c, 0x00, 0x00,  //+@@........
    0xb4, 0x00, 0x00,  //%@+........
    0xf0, 0x00, 0x00,  //@@.........
    0xf0, 0x00, 0x00,  //@@.........
    0xf0, 0x00, 0x00,  //@@.........
    0xb4, 0x00, 0x00,  //%@+........
    0x7c, 0x00, 0x00,  //+@@........
    0x3f, 0x40, 0x1c,  //.@@@+....+@
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0422 (Т) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0423 (У) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7c, 0x03, 0xd0,  //+@%....@@+
    0x3c, 0x07, 0xc0,  //.@@...+@@.
    0x2e, 0x0b, 0x40,  //.%@%..%@+.
    0x0f, 0x0f, 0x00,  //..@@..@@..
    0x0f, 0x6e, 0x00,  //..@@+%@%..
    0x07, 0xfc, 0x00,  //..+@@@@...
    0x03, 0xfc, 0x00,  //...@@@%...
    0x02, 0xf4, 0x00,  //...%@@+...
    0x01, 0xf0, 0x00,  //...+@@....
    0x03, 0xd0, 0x00,  //...@@+....
    0x3f, 0xc0, 0x00,  //.@@@@.....
    0x3f, 0x40, 0x00,  //.@@@......
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0424 (Ф) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x02, 0xff, 0xf8, 0x00,  //...%@@@@@@%...
    0x1f, 0xff, 0xff, 0x40,  //.+@@@@@@@@@@+.
    0x7e, 0x4f, 0x1b, 0xd0,  //+@@%+.@@.+%@@+
    0xf4, 0x0f, 0x01, 0xf0,  //@@+...@@...+@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf4, 0x0f, 0x01, 0xf0,  //@@+...@@...+@@
    0x7e, 0x0f, 0x07, 0xd0,  //+@@+..@@..+@@+
    0x1f, 0xff, 0xff, 0x40,  //.+@@@@@@@@@@+.
    0x02, 0xff, 0xf8, 0x00,  //...%@@@@@@%...
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0425 (Х) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x2e, 0x00, 0xb8,  //.%@%....%@%
    0x0f, 0x41, 0xf0,  //..@@+..+@@.
    0x0b, 0xc3, 0xd0,  //..%@@..@@+.
    0x03, 0xdb, 0x80,  //...@@+%@%..
    0x01, 0xff, 0x00,  //...+@@@@...
    0x00, 0xfd, 0x00,  //....%@@+...
    0x00, 0xbc, 0x00,  //....%@@....
    0x01, 0xff, 0x00,  //...+@@@@...
    0x03, 0xdf, 0x40,  //...@@+@@+..
    0x0b, 0x87, 0xc0,  //..%@%.+@@..
    0x1f, 0x03, 0xe0,  //.+@@...@@%.
    0x3d, 0x00, 0xf0,  //.@@+....@@.
    0xbc, 0x00, 0xb8,  //%@@.....%@%
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0426 (Ц) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xf0, 0x00, 0xf0,  //@@......@@..
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x0f,  //..........@@
    0x00, 0x00, 0x0f,  //..........@@
    0x00, 0x00, 0x0f,  //..........@@
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0427 (Ч) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf8, 0x03, 0xc0,  //@@%....@@
    0x7f, 0xff, 0xc0,  //+@@@@@@@@
    0x1f, 0xff, 0xc0,  //.+@@@@@@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0428 (Ш) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xf0, 0x03, 0xc0, 0x0f,  //@@.....@@.....@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0429 (Щ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xf0, 0x03, 0xc0, 0x0f, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xf0,  //................@@
    0x00, 0x00, 0x00, 0x00, 0xf0,  //................@@
    0x00, 0x00, 0x00, 0x00, 0xf0,  //................@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042a (Ъ) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xc0, 0x00,  //@@@@@.......
    0xff, 0xc0, 0x00,  //@@@@@.......
    0x03, 0xc0, 0x00,  //...@@.......
    0x03, 0xc0, 0x00,  //...@@.......
    0x03, 0xc0, 0x00,  //...@@.......
    0x03, 0xff, 0xe0,  //...@@@@@@%..
    0x03, 0xff, 0xfd,  //...@@@@@@@@+
    0x03, 0xc0, 0x2f,  //...@@....%@@
    0x03, 0xc0, 0x0f,  //...@@.....@@
    0x03, 0xc0, 0x0f,  //...@@.....@@
    0x03, 0xc0, 0x2f,  //...@@....%@@
    0x03, 0xff, 0xfd,  //...@@@@@@@@+
    0x03, 0xff, 0xe0,  //...@@@@@@%..
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+042b (Ы) , Width: 13 */
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0xf0, 0x00, 0x03, 0xc0,  //@@.........@@
    0xf0, 0x00, 0x03, 0xc0,  //@@.........@@
    0xf0, 0x00, 0x03, 0xc0,  //@@.........@@
    0xf0, 0x00, 0x03, 0xc0,  //@@.........@@
    0xf0, 0x00, 0x03, 0xc0,  //@@.........@@
    0xff, 0xf8, 0x03, 0xc0,  //@@@@@@%....@@
    0xff, 0xff, 0x43, 0xc0,  //@@@@@@@@+..@@
    0xf0, 0x0b, 0xc3, 0xc0,  //@@....%@@..@@
    0xf0, 0x03, 0xc3, 0xc0,  //@@.....@@..@@
    0xf0, 0x03, 0xc3, 0xc0,  //@@.....@@..@@
    0xf0, 0x0b, 0xc3, 0xc0,  //@@....%@@..@@
    0xff, 0xff, 0x43, 0xc0,  //@@@@@@@@+..@@
    0xff, 0xf8, 0x03, 0xc0,  //@@@@@@%....@@
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+042c (Ь) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xff, 0xf8, 0x00,  //@@@@@@%..
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xf0, 0x0b, 0xc0,  //@@....%@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x0b, 0xc0,  //@@....%@@
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xf8, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+042d (Э) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x2f, 0xf9, 0x00,  //.%@@@@%+...
    0xff, 0xff, 0xc0,  //@@@@@@@@@..
    0xd0, 0x06, 0xf0,  //@+....+%@@.
    0x00, 0x00, 0xb4,  //........%@+
    0x00, 0x00, 0x38,  //.........@%
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x00, 0x00, 0x3c,  //.........@@
    0x00, 0x00, 0x78,  //........+@%
    0x00, 0x00, 0xf4,  //........@@+
    0xd0, 0x07, 0xf0,  //@+....+@@@.
    0xff, 0xff, 0xc0,  //@@@@@@@@@..
    0x2f, 0xf9, 0x00,  //.%@@@@%+...
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+042e (Ю) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0xf0, 0x01, 0xff, 0x80,  //@@.....+@@@@+...
    0xf0, 0x0f, 0xff, 0xf0,  //@@....@@@@@@@@..
    0xf0, 0x3f, 0x41, 0xfc,  //@@...@@@+..+@@@.
    0xf0, 0x7c, 0x00, 0x3d,  //@@..+@@......@@+
    0xf0, 0xb4, 0x00, 0x1e,  //@@..%@+......+@%
    0xf0, 0xf0, 0x00, 0x0f,  //@@..@@........@@
    0xff, 0xf0, 0x00, 0x0f,  //@@@@@@........@@
    0xff, 0xf0, 0x00, 0x0f,  //@@@@@@........@@
    0xf0, 0xf4, 0x00, 0x1e,  //@@..@@+......+@%
    0xf0, 0xbc, 0x00, 0x3d,  //@@..%@@......@@+
    0xf0, 0x3f, 0x41, 0xfc,  //@@...@@@+..+@@@.
    0xf0, 0x1f, 0xff, 0xf0,  //@@...+@@@@@@@@..
    0xf0, 0x02, 0xff, 0x80,  //@@.....%@@@@+...
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+042f (Я) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x1b, 0xff, 0xc0,  //.+%@@@@@@
    0x7f, 0xff, 0xc0,  //+@@@@@@@@
    0xf8, 0x03, 0xc0,  //@@%....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xb8, 0x03, 0xc0,  //%@%....@@
    0x2f, 0xff, 0xc0,  //.%@@@@@@@
    0x03, 0xff, 0xc0,  //...@@@@@@
    0x0b, 0xc3, 0xc0,  //..%@%..@@
    0x0f, 0x03, 0xc0,  //..@@...@@
    0x2e, 0x03, 0xc0,  //.%@%...@@
    0x3c, 0x03, 0xc0,  //.@@....@@
    0xb8, 0x03, 0xc0,  //%@%....@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0430 (а) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1b, 0xf4,  //.+%@@@+.
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x2e,  //.%...%@%
    0x00, 0x0f,  //......@@
    0x1f, 0xff,  //.+@@@@@@
    0xbf, 0xff,  //%@@@@@@@
    0xf4, 0x0f,  //@@+...@@
    0xf4, 0x2f,  //@@+..%@@
    0xbf, 0xef,  //%@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0431 (б) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x6f, 0xf0,  //....+%@@@@.
    0x03, 0xff, 0xf0,  //...@@@@@@@.
    0x0f, 0xd0, 0x00,  //..@@@+.....
    0x2e, 0x00, 0x00,  //.%@%.......
    0x3d, 0xff, 0x40,  //.@@+@@@@+..
    0x3f, 0xff, 0xf0,  //.@@@@@@@@@.
    0x3f, 0x41, 0xf4,  //.@@@+..+@@+
    0x3d, 0x00, 0x7c,  //.@@+....+@@
    0x3c, 0x00, 0x3c,  //.@@......@@
    0x3c, 0x00, 0x3c,  //.@@......@@
    0x3d, 0x00, 0x7c,  //.@@+....+@@
    0x1f, 0x41, 0xf4,  //.+@@+..+@@+
    0x0f, 0xff, 0xe0,  //..@@@@@@@%.
    0x01, 0xff, 0x40,  //...+@@@@+..
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0432 (в) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xf8,  //@@@@@@%.
    0xff, 0xfe,  //@@@@@@@%
    0xf0, 0x1f,  //@@...+@@
    0xf0, 0x1e,  //@@...+@%
    0xff, 0xf8,  //@@@@@@%.
    0xff, 0xfe,  //@@@@@@@%
    0xf0, 0x1f,  //@@...+@@
    0xf0, 0x1f,  //@@...+@@
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xf4,  //@@@@@@+.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0433 (г) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0xf0, 0x00,  //@@.....
    0xf0, 0x00,  //@@.....
    0xf0, 0x00,  //@@.....
    0xf0, 0x00,  //@@.....
    0xf0, 0x00,  //@@.....
    0xf0, 0x00,  //@@.....
    0xf0, 0x00,  //@@.....
    0xf0, 0x00,  //@@.....
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0434 (д) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x03, 0xff, 0xc0,  //...@@@@@@..
    0x03, 0xff, 0xc0,  //...@@@@@@..
    0x03, 0xc3, 0xc0,  //...@@..@@..
    0x03, 0xc3, 0xc0,  //...@@..@@..
    0x03, 0xc3, 0xc0,  //...@@..@@..
    0x07, 0xc3, 0xc0,  //..+@%..@@..
    0x0f, 0x43, 0xc0,  //..@@+..@@..
    0x2f, 0x03, 0xc0,  //.%@@...@@..
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0435 (е) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x06, 0xfe, 0x00,  //..+%@@@%..
    0x2f, 0xff, 0xc0,  //.%@@@@@@@.
    0x7d, 0x03, 0xe0,  //+@@+...@@%
    0xf0, 0x00, 0xf0,  //@@......@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0x00,  //@@........
    0x7d, 0x00, 0x70,  //+@@+....+@
    0x2f, 0xff, 0xf0,  //.%@@@@@@@@
    0x06, 0xff, 0x80,  //..+%@@@@%.
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0436 (ж) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x2f, 0x0f, 0x0f, 0x80,  //.%@@..@@..@@%.
    0x0f, 0x8f, 0x2f, 0x00,  //..@@%.@@.%@@..
    0x03, 0xdf, 0x7c, 0x00,  //...@@+@@+@@...
    0x01, 0xff, 0xf4, 0x00,  //...+@@@@@@+...
    0x02, 0xff, 0xf8, 0x00,  //...%@@@@@@%...
    0x03, 0xff, 0xfc, 0x00,  //...@@@@@@@@...
    0x0f, 0x8f, 0x2f, 0x00,  //..@@%.@@.%@@..
    0x1f, 0x0f, 0x0f, 0x40,  //.+@@..@@..@@+.
    0x3d, 0x0f, 0x07, 0xc0,  //.@@+..@@..+@@.
    0xb8, 0x0f, 0x02, 0xe0,  //%@%...@@...%@%
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0437 (з) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x2f, 0xe0,  //.%@@@%.
    0xff, 0xf8,  //@@@@@@%
    0x90, 0x7c,  //%+..+@@
    0x00, 0x78,  //....+@%
    0x0f, 0xe0,  //..@@@%.
    0x0f, 0xf4,  //..@@@@+
    0x00, 0x7c,  //....+@@
    0x80, 0x7c,  //%...+@@
    0xff, 0xf8,  //@@@@@@%
    0x6f, 0xd0,  //+%@@@+.
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0438 (и) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x2f,  //@@...%@@
    0xf0, 0x7f,  //@@..+@@@
    0xf0, 0xff,  //@@..@@@@
    0xf2, 0xff,  //@@.+@@@@
    0xf3, 0xdf,  //@@.@@+@@
    0xfb, 0xcf,  //@@%@@.@@
    0xff, 0x0f,  //@@@@..@@
    0xfe, 0x0f,  //@@@%..@@
    0xfc, 0x0f,  //@@@...@@
    0xf8, 0x0f,  //@@%...@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0439 (й) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x34, 0x1c,  //.@+..+@.
    0x0f, 0xf0,  //..%@@%..
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x2f,  //@@...%@@
    0xf0, 0x7f,  //@@..+@@@
    0xf0, 0xff,  //@@..@@@@
    0xf2, 0xff,  //@@.+@@@@
    0xf3, 0xdf,  //@@.@@+@@
    0xfb, 0xcf,  //@@%@@.@@
    0xff, 0x0f,  //@@@@..@@
    0xfe, 0x0f,  //@@@%..@@
    0xfc, 0x0f,  //@@@...@@
    0xf8, 0x0f,  //@@%...@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+043a (к) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf0, 0x1f, 0x40,  //@@...+@@+
    0xf0, 0x7d, 0x00,  //@@..+@@+.
    0xf1, 0xf4, 0x00,  //@@.+@@+..
    0xfb, 0xd0, 0x00,  //@@%@@+...
    0xff, 0xd0, 0x00,  //@@@@@+...
    0xfe, 0xf0, 0x00,  //@@@%@@...
    0xf4, 0xb8, 0x00,  //@@+.%@%..
    0xf0, 0x3d, 0x00,  //@@...@@+.
    0xf0, 0x1f, 0x00,  //@@...+@@.
    0xf0, 0x0b, 0x80,  //@@....%@%
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+043b (л) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x03, 0xff, 0xf0,  //...@@@@@@@
    0x03, 0xff, 0xf0,  //...@@@@@@@
    0x03, 0xc0, 0xf0,  //...@@...@@
    0x03, 0xc0, 0xf0,  //...@@...@@
    0x03, 0xc0, 0xf0,  //...@@...@@
    0x07, 0xc0, 0xf0,  //..+@@...@@
    0x0b, 0x80, 0xf0,  //..%@%...@@
    0x1f, 0x40, 0xf0,  //.+@@+...@@
    0xfe, 0x00, 0xf0,  //@@@%....@@
    0xe4, 0x00, 0xf0,  //@%+.....@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043c (м) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xfe, 0x0b, 0xf0,  //@@@%..%@@@
    0xff, 0x0f, 0xf0,  //@@@@..@@@@
    0xfb, 0x5e, 0xf0,  //@@%@++@%@@
    0xf7, 0xfd, 0xf0,  //@@+@@@@+@@
    0xf3, 0xfc, 0xf0,  //@@.@@@@.@@
    0xf2, 0xf8, 0xf0,  //@@.%@@%.@@
    0xf0, 0xf0, 0xf0,  //@@..@@..@@
    0xf0, 0xf0, 0xf0,  //@@..@@..@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043d (н) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+043e (о) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043f (п) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0440 (р) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xfc, 0x0f, 0x80,  //@@@...@@%
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xfc, 0x0f, 0x80,  //@@@...@@%
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......


    /*Unicode: U+0441 (с) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x07, 0xf9,  //..+@@@%+
    0x2f, 0xff,  //.%@@@@@@
    0x7d, 0x02,  //+@@+...%
    0xf4, 0x00,  //@@+.....
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf4, 0x00,  //@@+.....
    0x7d, 0x02,  //+@@+...%
    0x2f, 0xff,  //.%@@@@@@
    0x07, 0xf9,  //..+@@@%+
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0442 (т) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0xf0, 0x00,  //....@@....
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0443 (у) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x2d, 0x00, 0x78,  //.%@+....+@%.
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0b, 0x41, 0xf0,  //..%@+..+@@..
    0x03, 0xc3, 0xd0,  //...@@..@@+..
    0x03, 0xd3, 0xc0,  //...@@+.@@...
    0x01, 0xeb, 0x40,  //...+@%%@+...
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x78, 0x00,  //....+@%.....
    0x00, 0xb0, 0x00,  //....%@......
    0x0f, 0xe0, 0x00,  //..@@@%......
    0x0f, 0x80, 0x00,  //..@@%.......


    /*Unicode: U+0444 (ф) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x0f, 0xcf, 0x3f, 0x00,  //..@@@.@@.@@@..
    0x3f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@.
    0xbc, 0x2f, 0x83, 0xe0,  //%@@..%@@%..@@%
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xbc, 0x2f, 0x83, 0xe0,  //%@@..%@@%..@@%
    0x3f, 0xff, 0xff, 0xc0,  //.@@@@@@@@@@@@.
    0x0f, 0xcf, 0x3f, 0x00,  //..@@@.@@.@@@..
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x0f, 0x00, 0x00,  //......@@......
    0x00, 0x0f, 0x00, 0x00,  //......@@......


    /*Unicode: U+0445 (х) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xbc, 0x03, 0xe0,  //%@@....@@%
    0x3d, 0x07, 0xc0,  //.@@+..+@@.
    0x1f, 0x0f, 0x00,  //.+@@..@@..
    0x0b, 0x5e, 0x00,  //..%@++@%..
    0x03, 0xfc, 0x00,  //...@@@@...
    0x03, 0xfc, 0x00,  //...@@@@...
    0x0b, 0x5e, 0x00,  //..%@++@%..
    0x1f, 0x0f, 0x40,  //.+@@..@@+.
    0x3d, 0x07, 0xc0,  //.@@+..+@@.
    0xbc, 0x03, 0xe0,  //%@@....@@%
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0446 (ц) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xf0, 0x03, 0xc0,  //@@.....@@..
    0xf0, 0x03, 0xc0,  //@@.....@@..
    0xf0, 0x03, 0xc0,  //@@.....@@..
    0xf0, 0x03, 0xc0,  //@@.....@@..
    0xf0, 0x03, 0xc0,  //@@.....@@..
    0xf0, 0x03, 0xc0,  //@@.....@@..
    0xf0, 0x03, 0xc0,  //@@.....@@..
    0xf0, 0x03, 0xc0,  //@@.....@@..
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x00, 0x00, 0x3c,  //.........@@
    0x00, 0x00, 0x3c,  //.........@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0447 (ч) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf8, 0x0f,  //@@%...@@
    0x7f, 0xff,  //+@@@@@@@
    0x2f, 0xff,  //.%@@@@@@
    0x00, 0x0f,  //......@@
    0x00, 0x0f,  //......@@
    0x00, 0x0f,  //......@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0448 (ш) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0449 (щ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xf0, 0x3c, 0x0f, 0x00,  //@@...@@...@@..
    0xf0, 0x3c, 0x0f, 0x00,  //@@...@@...@@..
    0xf0, 0x3c, 0x0f, 0x00,  //@@...@@...@@..
    0xf0, 0x3c, 0x0f, 0x00,  //@@...@@...@@..
    0xf0, 0x3c, 0x0f, 0x00,  //@@...@@...@@..
    0xf0, 0x3c, 0x0f, 0x00,  //@@...@@...@@..
    0xf0, 0x3c, 0x0f, 0x00,  //@@...@@...@@..
    0xf0, 0x3c, 0x0f, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0xf0,  //............@@
    0x00, 0x00, 0x00, 0xf0,  //............@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+044a (ъ) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xc0, 0x00,  //@@@@@......
    0xff, 0xc0, 0x00,  //@@@@@......
    0x03, 0xc0, 0x00,  //...@@......
    0x03, 0xc0, 0x00,  //...@@......
    0x03, 0xff, 0xe0,  //...@@@@@@%.
    0x03, 0xff, 0xf8,  //...@@@@@@@%
    0x03, 0xc0, 0x7c,  //...@@...+@@
    0x03, 0xc0, 0x7c,  //...@@...+@@
    0x03, 0xff, 0xf8,  //...@@@@@@@%
    0x03, 0xff, 0xd0,  //...@@@@@@+.
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044b (ы) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xff, 0xf8, 0x3c,  //@@@@@@%..@@
    0xff, 0xfe, 0x3c,  //@@@@@@@%.@@
    0xf0, 0x1f, 0x3c,  //@@...+@@.@@
    0xf0, 0x1f, 0x3c,  //@@...+@@.@@
    0xff, 0xfe, 0x3c,  //@@@@@@@%.@@
    0xff, 0xf4, 0x3c,  //@@@@@@+..@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044c (ь) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xf8,  //@@@@@@%.
    0xff, 0xfe,  //@@@@@@@%
    0xf0, 0x1f,  //@@...+@@
    0xf0, 0x1f,  //@@...+@@
    0xff, 0xfe,  //@@@@@@@%
    0xff, 0xf4,  //@@@@@@+.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+044d (э) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x6f, 0xd0,  //.%@@@+..
    0xff, 0xf8,  //@@@@@@%.
    0x90, 0x7d,  //%...+@@+
    0x00, 0x0f,  //......@@
    0x3f, 0xff,  //.@@@@@@@
    0x3f, 0xff,  //.@@@@@@@
    0x00, 0x0f,  //......@@
    0x80, 0x7d,  //%...+@@+
    0xff, 0xf8,  //@@@@@@%.
    0x6f, 0xd0,  //+%@@@+..
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+044e (ю) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xf0, 0x2f, 0xe0,  //@@...%@@@%..
    0xf0, 0xff, 0xfc,  //@@..@@@@@@@.
    0xf2, 0xf4, 0x7e,  //@@.%@@...@@%
    0xf3, 0xd0, 0x1f,  //@@.@@+...+@@
    0xff, 0xc0, 0x0f,  //@@@@@.....@@
    0xff, 0xc0, 0x0f,  //@@@@@.....@@
    0xf3, 0xd0, 0x1f,  //@@.@@+...+@@
    0xf2, 0xf0, 0x3e,  //@@.%@@...@@%
    0xf0, 0xff, 0xfc,  //@@..@@@@@@@.
    0xf0, 0x2f, 0xe0,  //@@...%@@@%..
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+044f (я) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x07, 0xff, 0xc0,  //..+@@@@@@
    0x2f, 0xff, 0xc0,  //.%@@@@@@@
    0x3e, 0x03, 0xc0,  //.@@+...@@
    0x3c, 0x03, 0xc0,  //.@@....@@
    0x1e, 0x03, 0xc0,  //.+@+...@@
    0x07, 0xff, 0xc0,  //..+@@@@@@
    0x07, 0xff, 0xc0,  //..+@@@@@@
    0x0f, 0x43, 0xc0,  //..@@+..@@
    0x3e, 0x03, 0xc0,  //.@@%...@@
    0xbc, 0x03, 0xc0,  //%@@....@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........



#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 4
    /*Unicode: U+0410 (А) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x5f, 0xf5, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //....@@@@....
    0x00, 0x02, 0xfc, 0xcf, 0x20, 0x00,  //....@@@@....
    0x00, 0x09, 0xf6, 0x5f, 0x90, 0x00,  //...%@++@%...
    0x00, 0x0e, 0xf0, 0x0e, 0xe0, 0x00,  //...@@..@@...
    0x00, 0x5f, 0xa0, 0x08, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0xcf, 0x30, 0x02, 0xfc, 0x00,  //..@@....@@..
    0x02, 0xff, 0xff, 0xff, 0xff, 0x20,  //..@@@@@@@@..
    0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //.%@@@@@@@@%.
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@.
    0x6f, 0xb0, 0x00, 0x00, 0x0b, 0xf6,  //+@%......%@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0411 (Б) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0xfe, 0xb3, 0x00,  //@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0x00, 0x02, 0xaf, 0xc0,  //@@....%@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x02, 0xaf, 0xc0,  //@@....%@@
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0xfe, 0xb4, 0x00,  //@@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0412 (В) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xfc, 0x60, 0x00,  //@@@@@@+..
    0xff, 0xff, 0xff, 0xf8, 0x00,  //@@@@@@@%.
    0xff, 0x00, 0x07, 0xfe, 0x00,  //@@...+@@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@....@@.
    0xff, 0x00, 0x07, 0xfa, 0x00,  //@@...+@%.
    0xff, 0xff, 0xff, 0x91, 0x00,  //@@@@@@%..
    0xff, 0xff, 0xff, 0xd6, 0x00,  //@@@@@@@+.
    0xff, 0x00, 0x02, 0xbf, 0x60,  //@@....%@+
    0xff, 0x00, 0x00, 0x1f, 0xd0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x02, 0xbf, 0xc0,  //@@....%@@
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0xfe, 0xa3, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0413 (Г) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0414 (Д) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@..
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x00,  //...@@@@@@@..
    0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //...@@...@@..
    0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //...@@...@@..
    0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //...@@...@@..
    0x00, 0x2f, 0xe0, 0x00, 0xff, 0x00,  //...@@...@@..
    0x00, 0x3f, 0xd0, 0x00, 0xff, 0x00,  //...@@...@@..
    0x00, 0x6f, 0xb0, 0x00, 0xff, 0x00,  //..+@%...@@..
    0x00, 0x9f, 0x70, 0x00, 0xff, 0x00,  //..%@+...@@..
    0x00, 0xef, 0x30, 0x00, 0xff, 0x00,  //..@@....@@..
    0x0a, 0xfc, 0x00, 0x00, 0xff, 0x00,  //.%@@....@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0415 (Е) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0416 (Ж) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x8f, 0xf3, 0x00, 0x00, 0xff, 0x00, 0x00, 0x3f, 0xf8,  //%@@.....@@.....@@%
    0x09, 0xfe, 0x20, 0x00, 0xff, 0x00, 0x02, 0xef, 0x90,  //.%@@....@@....@@%.
    0x00, 0xbf, 0xe1, 0x00, 0xff, 0x00, 0x1e, 0xfa, 0x00,  //..%@@...@@...@@%..
    0x00, 0x0c, 0xfd, 0x10, 0xff, 0x01, 0xdf, 0xc0, 0x00,  //...%@@..@@..@@%...
    0x00, 0x00, 0xcf, 0xc0, 0xff, 0x0c, 0xfc, 0x00, 0x00,  //....@@@.@@.@@@....
    0x00, 0x00, 0x8f, 0xfb, 0xff, 0xbf, 0xf8, 0x00, 0x00,  //....%@@%@@%@@%....
    0x00, 0x02, 0xff, 0xef, 0xff, 0xfe, 0xff, 0x20, 0x00,  //....@@@@@@@@@@....
    0x00, 0x0b, 0xf9, 0x3f, 0xff, 0xf3, 0x9f, 0xb0, 0x00,  //...%@%.@@@@.%@%...
    0x00, 0x4f, 0xe1, 0x03, 0xff, 0x30, 0x1e, 0xf4, 0x00,  //..+@@...@@...@@+..
    0x00, 0xdf, 0x60, 0x00, 0xff, 0x00, 0x06, 0xfd, 0x00,  //..@@+...@@...+@@..
    0x08, 0xfc, 0x00, 0x00, 0xff, 0x00, 0x00, 0xcf, 0x80,  //.+@@....@@....@@+.
    0x2f, 0xf3, 0x00, 0x00, 0xff, 0x00, 0x00, 0x3f, 0xf2,  //.@@.....@@.....@@.
    0xbf, 0x90, 0x00, 0x00, 0xff, 0x00, 0x00, 0x0a, 0xfb,  //%@%.....@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0417 (З) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x28, 0xdf, 0xfd, 0x92, 0x00,  //.%@@@@%..
    0xdf, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@+
    0xb6, 0x10, 0x02, 0x9f, 0xd0,  //%+....%@@
    0x00, 0x00, 0x00, 0x1f, 0xf0,  //.......@@
    0x00, 0x00, 0x02, 0x9f, 0xa0,  //......%@%
    0x00, 0xff, 0xff, 0xf9, 0x00,  //..@@@@@%.
    0x00, 0xff, 0xff, 0xfa, 0x00,  //..@@@@@%.
    0x00, 0x00, 0x13, 0xcf, 0x90,  //......@@%
    0x00, 0x00, 0x00, 0x1f, 0xe0,  //.......@@
    0x00, 0x00, 0x00, 0x2f, 0xf0,  //.......@@
    0xc5, 0x10, 0x14, 0xcf, 0xb0,  //%+...+@@%
    0xff, 0xff, 0xff, 0xfe, 0x20,  //@@@@@@@@.
    0x39, 0xdf, 0xec, 0x70, 0x00,  //.%@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0418 (И) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x08, 0xff,  //@@.....%@@
    0xff, 0x00, 0x00, 0x2f, 0xff,  //@@.....@@@
    0xff, 0x00, 0x00, 0xbf, 0xff,  //@@....%@@@
    0xff, 0x00, 0x04, 0xfb, 0xff,  //@@...+@%@@
    0xff, 0x00, 0x0d, 0xf2, 0xff,  //@@...@@.@@
    0xff, 0x00, 0x7f, 0x80, 0xff,  //@@..+@%.@@
    0xff, 0x01, 0xfe, 0x00, 0xff,  //@@..@@..@@
    0xff, 0x0a, 0xf6, 0x00, 0xff,  //@@.%@+..@@
    0xff, 0x4f, 0xd0, 0x00, 0xff,  //@@+@@...@@
    0xff, 0xdf, 0x40, 0x00, 0xff,  //@@@@....@@
    0xff, 0xfa, 0x00, 0x00, 0xff,  //@@@%....@@
    0xff, 0xf2, 0x00, 0x00, 0xff,  //@@@.....@@
    0xff, 0x80, 0x00, 0x00, 0xff,  //@@%.....@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0419 (Й) , Width: 10 */
    0x00, 0xd6, 0x00, 0x6d, 0x00,  //..@+..+@..
    0x00, 0x3c, 0xff, 0xc3, 0x00,  //...%@@%...
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x08, 0xff,  //@@.....%@@
    0xff, 0x00, 0x00, 0x2f, 0xff,  //@@.....@@@
    0xff, 0x00, 0x00, 0xbf, 0xff,  //@@....%@@@
    0xff, 0x00, 0x04, 0xfb, 0xff,  //@@...+@%@@
    0xff, 0x00, 0x0d, 0xf2, 0xff,  //@@...@@.@@
    0xff, 0x00, 0x7f, 0x80, 0xff,  //@@..+@%.@@
    0xff, 0x01, 0xfe, 0x00, 0xff,  //@@..@@..@@
    0xff, 0x0a, 0xf6, 0x00, 0xff,  //@@.%@+..@@
    0xff, 0x4f, 0xd0, 0x00, 0xff,  //@@+@@...@@
    0xff, 0xdf, 0x40, 0x00, 0xff,  //@@@@....@@
    0xff, 0xfa, 0x00, 0x00, 0xff,  //@@@%....@@
    0xff, 0xf2, 0x00, 0x00, 0xff,  //@@@.....@@
    0xff, 0x80, 0x00, 0x00, 0xff,  //@@%.....@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+041a (К) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0x00, 0x00, 0x06, 0xff, 0x70,  //@@.....+@@+
    0xff, 0x00, 0x00, 0x6f, 0xf7, 0x00,  //@@....+@@+.
    0xff, 0x00, 0x07, 0xff, 0x60, 0x00,  //@@...+@@+..
    0xff, 0x00, 0x7f, 0xf6, 0x00, 0x00,  //@@..+@@+...
    0xff, 0x08, 0xff, 0x50, 0x00, 0x00,  //@@.%@@+....
    0xff, 0x8f, 0xfe, 0x00, 0x00, 0x00,  //@@%@@@.....
    0xff, 0xff, 0xdf, 0x90, 0x00, 0x00,  //@@@@@@%....
    0xff, 0xf4, 0x2f, 0xf4, 0x00, 0x00,  //@@@+.@@+...
    0xff, 0x40, 0x07, 0xfe, 0x10, 0x00,  //@@+..+@@...
    0xff, 0x00, 0x00, 0xcf, 0xa0, 0x00,  //@@....@@%..
    0xff, 0x00, 0x00, 0x2f, 0xf4, 0x00,  //@@.....@@+.
    0xff, 0x00, 0x00, 0x06, 0xfe, 0x10,  //@@.....+@@.
    0xff, 0x00, 0x00, 0x00, 0xbf, 0xa0,  //@@......%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+041b (Л) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xf0,  //...@@@@@@@@
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xf0,  //...@@@@@@@@
    0x00, 0x0f, 0xf0, 0x00, 0x0f, 0xf0,  //...@@....@@
    0x00, 0x0f, 0xf0, 0x00, 0x0f, 0xf0,  //...@@....@@
    0x00, 0x0f, 0xf0, 0x00, 0x0f, 0xf0,  //...@@....@@
    0x00, 0x1f, 0xf0, 0x00, 0x0f, 0xf0,  //...@@....@@
    0x00, 0x3f, 0xd0, 0x00, 0x0f, 0xf0,  //...@@....@@
    0x00, 0x5f, 0xc0, 0x00, 0x0f, 0xf0,  //..+@@....@@
    0x00, 0x8f, 0x90, 0x00, 0x0f, 0xf0,  //..%@%....@@
    0x00, 0xdf, 0x60, 0x00, 0x0f, 0xf0,  //..@@+....@@
    0x2b, 0xff, 0x10, 0x00, 0x0f, 0xf0,  //.%@@.....@@
    0xff, 0xf5, 0x00, 0x00, 0x0f, 0xf0,  //@@@+.....@@
    0xe9, 0x20, 0x00, 0x00, 0x0f, 0xf0,  //@%.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+041c (М) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf6, 0x00, 0x00, 0x4f, 0xff,  //@@@+....+@@@
    0xff, 0xfc, 0x00, 0x00, 0xaf, 0xff,  //@@@%....%@@@
    0xff, 0xaf, 0x20, 0x01, 0xfa, 0xff,  //@@%@....@%@@
    0xff, 0x4f, 0x80, 0x07, 0xf4, 0xff,  //@@.@+..+@.@@
    0xff, 0x0e, 0xd0, 0x0d, 0xd0, 0xff,  //@@.@@..@@.@@
    0xff, 0x08, 0xf3, 0x3f, 0x80, 0xff,  //@@.%@..@+.@@
    0xff, 0x02, 0xf9, 0x9f, 0x20, 0xff,  //@@..@%%@..@@
    0xff, 0x00, 0xcf, 0xfc, 0x00, 0xff,  //@@..@@@@..@@
    0xff, 0x00, 0x6f, 0xf6, 0x00, 0xff,  //@@..+@@+..@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+041d (Н) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+041e (О) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x07, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x00, 0x08, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+041f (П) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0420 (Р) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xfc, 0x40,  //@@@@@%+.
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@+
    0xff, 0x00, 0x1a, 0xfc,  //@@...%@@
    0xff, 0x00, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x1a, 0xfc,  //@@...%@@
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@+
    0xff, 0xff, 0xfc, 0x40,  //@@@@@@+.
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0421 (С) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x05, 0xbe, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x0c, 0xfe, 0x61, 0x00, 0x26, 0xc0,  //.@@@+....+@
    0x6f, 0xd1, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0xbf, 0x50, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0xef, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xef, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xbf, 0x50, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0x6f, 0xd1, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0x0c, 0xfe, 0x61, 0x00, 0x26, 0xc0,  //.@@@+....+@
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x00, 0x06, 0xbe, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0422 (Т) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0423 (У) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xcf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x6f, 0xc0, 0x00, 0x0d, 0xf5,  //+@%....@@+
    0x0f, 0xf2, 0x00, 0x4f, 0xe0,  //.@@...+@@.
    0x09, 0xf8, 0x00, 0xbf, 0x70,  //.%@%..%@+.
    0x02, 0xfe, 0x02, 0xff, 0x10,  //..@@..@@..
    0x00, 0xcf, 0x58, 0xf9, 0x00,  //..@@+%@%..
    0x00, 0x5f, 0xce, 0xf2, 0x00,  //..+@@@@...
    0x00, 0x0e, 0xff, 0xc0, 0x00,  //...@@@%...
    0x00, 0x09, 0xff, 0x50, 0x00,  //...%@@+...
    0x00, 0x04, 0xfe, 0x00, 0x00,  //...+@@....
    0x00, 0x1c, 0xf7, 0x00, 0x00,  //...@@+....
    0x0f, 0xff, 0xe1, 0x00, 0x00,  //.@@@@.....
    0x0f, 0xfc, 0x40, 0x00, 0x00,  //.@@@......
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0424 (Ф) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x18, 0xce, 0xff, 0xec, 0x82, 0x00,  //...%@@@@@@%...
    0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,  //.+@@@@@@@@@@+.
    0x4f, 0xfa, 0x41, 0xff, 0x14, 0xaf, 0xf4,  //+@@%+.@@.+%@@+
    0xcf, 0x70, 0x00, 0xff, 0x00, 0x07, 0xfc,  //@@+...@@...+@@
    0xff, 0x10, 0x00, 0xff, 0x00, 0x01, 0xff,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0xcf, 0x60, 0x00, 0xff, 0x00, 0x05, 0xfc,  //@@+...@@...+@@
    0x5f, 0xf8, 0x10, 0xff, 0x01, 0x7f, 0xf5,  //+@@+..@@..+@@+
    0x06, 0xff, 0xfe, 0xff, 0xef, 0xff, 0x60,  //.+@@@@@@@@@@+.
    0x00, 0x28, 0xce, 0xff, 0xec, 0x82, 0x00,  //...%@@@@@@%...
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0425 (Х) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x0b, 0xfb, 0x00, 0x00, 0xbf, 0xa0,  //.%@%....%@%
    0x02, 0xff, 0x40, 0x06, 0xfe, 0x10,  //..@@+..+@@.
    0x00, 0x8f, 0xd0, 0x1f, 0xf5, 0x00,  //..%@@..@@+.
    0x00, 0x0e, 0xf7, 0xbf, 0xb0, 0x00,  //...@@+%@%..
    0x00, 0x05, 0xff, 0xfe, 0x10, 0x00,  //...+@@@@...
    0x00, 0x00, 0xcf, 0xf6, 0x00, 0x00,  //....%@@+...
    0x00, 0x00, 0xbf, 0xf3, 0x00, 0x00,  //....%@@....
    0x00, 0x05, 0xff, 0xfc, 0x00, 0x00,  //...+@@@@...
    0x00, 0x1e, 0xf7, 0xef, 0x50, 0x00,  //...@@+@@+..
    0x00, 0xaf, 0xb0, 0x6f, 0xe0, 0x00,  //..%@%.+@@..
    0x05, 0xff, 0x20, 0x0d, 0xf8, 0x00,  //.+@@...@@%.
    0x1e, 0xf7, 0x00, 0x03, 0xff, 0x20,  //.@@+....@@.
    0xaf, 0xc0, 0x00, 0x00, 0xaf, 0xb0,  //%@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0426 (Ц) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0x00, 0x00, 0x00, 0xff, 0x00,  //@@......@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //..........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0427 (Ч) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x20, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xcf, 0xb1, 0x00, 0x0f, 0xf0,  //@@%....@@
    0x5f, 0xff, 0xff, 0xff, 0xf0,  //+@@@@@@@@
    0x06, 0xdf, 0xff, 0xff, 0xf0,  //.+@@@@@@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0428 (Ш) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0429 (Щ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0xff, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042a (Ъ) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //@@@@@.......
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //@@@@@.......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //...@@.......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //...@@.......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //...@@.......
    0x00, 0x0f, 0xff, 0xff, 0xeb, 0x30,  //...@@@@@@%..
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xf4,  //...@@@@@@@@+
    0x00, 0x0f, 0xf0, 0x00, 0x19, 0xfc,  //...@@....%@@
    0x00, 0x0f, 0xf0, 0x00, 0x01, 0xff,  //...@@.....@@
    0x00, 0x0f, 0xf0, 0x00, 0x01, 0xff,  //...@@.....@@
    0x00, 0x0f, 0xf0, 0x00, 0x2a, 0xfc,  //...@@....%@@
    0x00, 0x0f, 0xff, 0xff, 0xff, 0xf4,  //...@@@@@@@@+
    0x00, 0x0f, 0xff, 0xff, 0xea, 0x30,  //...@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+042b (Ы) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.........@@
    0xff, 0xff, 0xfe, 0xb3, 0x00, 0x0f, 0xf0,  //@@@@@@%....@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0f, 0xf0,  //@@@@@@@@+..@@
    0xff, 0x00, 0x02, 0xaf, 0xc0, 0x0f, 0xf0,  //@@....%@@..@@
    0xff, 0x00, 0x00, 0x1f, 0xf0, 0x0f, 0xf0,  //@@.....@@..@@
    0xff, 0x00, 0x00, 0x1f, 0xf0, 0x0f, 0xf0,  //@@.....@@..@@
    0xff, 0x00, 0x02, 0xaf, 0xc0, 0x0f, 0xf0,  //@@....%@@..@@
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0f, 0xf0,  //@@@@@@@@+..@@
    0xff, 0xff, 0xfe, 0xa3, 0x00, 0x0f, 0xf0,  //@@@@@@%....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+042c (Ь) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0xfe, 0xb3, 0x00,  //@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0x00, 0x02, 0xaf, 0xc0,  //@@....%@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x02, 0xaf, 0xc0,  //@@....%@@
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0xfe, 0xa3, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+042d (Э) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x28, 0xce, 0xfe, 0xb5, 0x00, 0x00,  //.%@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xc1, 0x00,  //@@@@@@@@@..
    0xc7, 0x31, 0x01, 0x4b, 0xfc, 0x00,  //@+....+%@@.
    0x00, 0x00, 0x00, 0x00, 0xaf, 0x60,  //........%@+
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xb0,  //.........@%
    0x00, 0xff, 0xff, 0xff, 0xff, 0xe0,  //..@@@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x2f, 0xe0,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x6f, 0xb0,  //........+@%
    0x00, 0x00, 0x00, 0x01, 0xef, 0x60,  //........@@+
    0xc6, 0x31, 0x01, 0x5d, 0xfc, 0x00,  //@+....+@@@.
    0xff, 0xff, 0xff, 0xff, 0xc1, 0x00,  //@@@@@@@@@..
    0x28, 0xce, 0xfe, 0xb6, 0x00, 0x00,  //.%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+042e (Ю) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0x00, 0x00, 0x07, 0xdf, 0xfd, 0x80, 0x00,  //@@.....+@@@@+...
    0xff, 0x00, 0x02, 0xdf, 0xff, 0xff, 0xfe, 0x20,  //@@....@@@@@@@@..
    0xff, 0x00, 0x0c, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //@@...@@@+..+@@@.
    0xff, 0x00, 0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //@@..+@@......@@+
    0xff, 0x00, 0xbf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //@@..%@+......+@%
    0xff, 0x00, 0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@..@@........@@
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@@@@@........@@
    0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@@@@@........@@
    0xff, 0x00, 0xef, 0x50, 0x00, 0x00, 0x05, 0xfb,  //@@..@@+......+@%
    0xff, 0x00, 0xaf, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //@@..%@@......@@+
    0xff, 0x00, 0x2f, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //@@...@@@+..+@@@.
    0xff, 0x00, 0x05, 0xff, 0xff, 0xff, 0xfe, 0x20,  //@@...+@@@@@@@@..
    0xff, 0x00, 0x00, 0x29, 0xdf, 0xfd, 0x80, 0x00,  //@@.....%@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+042f (Я) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x04, 0xbe, 0xff, 0xff, 0xf0,  //.+%@@@@@@
    0x4f, 0xff, 0xff, 0xff, 0xf0,  //+@@@@@@@@
    0xcf, 0xa2, 0x00, 0x0f, 0xf0,  //@@%....@@
    0xff, 0x10, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xef, 0x10, 0x00, 0x0f, 0xf0,  //@@.....@@
    0x9f, 0xa2, 0x00, 0x0f, 0xf0,  //%@%....@@
    0x09, 0xff, 0xff, 0xff, 0xf0,  //.%@@@@@@@
    0x00, 0x2f, 0xff, 0xff, 0xf0,  //...@@@@@@
    0x00, 0x8f, 0xc0, 0x0f, 0xf0,  //..%@%..@@
    0x01, 0xff, 0x30, 0x0f, 0xf0,  //..@@...@@
    0x0a, 0xfa, 0x00, 0x0f, 0xf0,  //.%@%...@@
    0x2f, 0xf2, 0x00, 0x0f, 0xf0,  //.@@....@@
    0xbf, 0x80, 0x00, 0x0f, 0xf0,  //%@%....@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0430 (а) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x04, 0xbe, 0xfc, 0x40,  //.+%@@@+.
    0x0f, 0xff, 0xff, 0xf3,  //.@@@@@@.
    0x0a, 0x30, 0x2a, 0xfa,  //.%...%@%
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x07, 0xcf, 0xff, 0xff,  //.+@@@@@@
    0x8f, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xef, 0x51, 0x01, 0xff,  //@@+...@@
    0xef, 0x40, 0x2a, 0xff,  //@@+..%@@
    0xaf, 0xff, 0xfa, 0xff,  //%@@@@%@@
    0x1a, 0xee, 0x90, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0431 (б) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00,  //...........
    0x00, 0x00, 0x7b, 0xef, 0xff, 0x00,  //....+%@@@@.
    0x00, 0x3e, 0xff, 0xff, 0xfe, 0x00,  //...@@@@@@@.
    0x01, 0xef, 0xc5, 0x21, 0x00, 0x00,  //..@@@+.....
    0x0a, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.%@%.......
    0x0f, 0xe6, 0xcf, 0xfd, 0x70, 0x00,  //.@@+@@@@+..
    0x1f, 0xff, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@@@.
    0x1f, 0xfe, 0x61, 0x16, 0xff, 0x70,  //.@@@+..+@@+
    0x0f, 0xf5, 0x00, 0x00, 0x6f, 0xd0,  //.@@+....+@@
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@
    0x0d, 0xf5, 0x00, 0x00, 0x6f, 0xc0,  //.@@+....+@@
    0x07, 0xfe, 0x51, 0x15, 0xef, 0x70,  //.+@@+..+@@+
    0x00, 0xcf, 0xff, 0xff, 0xfb, 0x00,  //..@@@@@@@%.
    0x00, 0x07, 0xdf, 0xfd, 0x70, 0x00,  //...+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0432 (в) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xfd, 0x80,  //@@@@@@%.
    0xff, 0xff, 0xff, 0xfb,  //@@@@@@@%
    0xff, 0x00, 0x05, 0xff,  //@@...+@@
    0xff, 0x00, 0x05, 0xfb,  //@@...+@%
    0xff, 0xff, 0xff, 0xb1,  //@@@@@@%.
    0xff, 0xff, 0xff, 0xf8,  //@@@@@@@%
    0xff, 0x00, 0x05, 0xfe,  //@@...+@@
    0xff, 0x00, 0x05, 0xff,  //@@...+@@
    0xff, 0xff, 0xff, 0xfa,  //@@@@@@@%
    0xff, 0xff, 0xfd, 0x70,  //@@@@@@+.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0433 (г) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0x00, 0x00, 0x00,  //@@.....
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0434 (д) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x0f, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@..
    0x00, 0x0f, 0xff, 0xff, 0xf0, 0x00,  //...@@@@@@..
    0x00, 0x0f, 0xf0, 0x0f, 0xf0, 0x00,  //...@@..@@..
    0x00, 0x1f, 0xf0, 0x0f, 0xf0, 0x00,  //...@@..@@..
    0x00, 0x3f, 0xe0, 0x0f, 0xf0, 0x00,  //...@@..@@..
    0x00, 0x6f, 0xc0, 0x0f, 0xf0, 0x00,  //..+@%..@@..
    0x00, 0xcf, 0x70, 0x0f, 0xf0, 0x00,  //..@@+..@@..
    0x08, 0xfe, 0x10, 0x0f, 0xf0, 0x00,  //.%@@...@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0435 (е) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x5b, 0xef, 0xd8, 0x00,  //..+%@@@%..
    0x0a, 0xff, 0xff, 0xff, 0xd0,  //.%@@@@@@@.
    0x6f, 0xe5, 0x10, 0x3c, 0xf8,  //+@@+...@@%
    0xcf, 0x30, 0x00, 0x02, 0xfd,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xcf, 0x30, 0x00, 0x00, 0x00,  //@@........
    0x6f, 0xe6, 0x10, 0x02, 0x6c,  //+@@+....+@
    0x09, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x4a, 0xef, 0xfd, 0x82,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0436 (ж) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x0a, 0xfd, 0x00, 0xff, 0x00, 0xdf, 0x90,  //.%@@..@@..@@%.
    0x00, 0xdf, 0x90, 0xff, 0x09, 0xfd, 0x00,  //..@@%.@@.%@@..
    0x00, 0x2f, 0xf5, 0xff, 0x5f, 0xf2, 0x00,  //...@@+@@+@@...
    0x00, 0x06, 0xff, 0xff, 0xff, 0x60, 0x00,  //...+@@@@@@+...
    0x00, 0x08, 0xff, 0xff, 0xff, 0x80, 0x00,  //...%@@@@@@%...
    0x00, 0x3f, 0xfe, 0xff, 0xef, 0xf3, 0x00,  //...@@@@@@@@...
    0x00, 0xcf, 0x83, 0xff, 0x38, 0xfc, 0x00,  //..@@%.@@.%@@..
    0x06, 0xfd, 0x00, 0xff, 0x00, 0xef, 0x60,  //.+@@..@@..@@+.
    0x1f, 0xf4, 0x00, 0xff, 0x00, 0x4f, 0xf1,  //.@@+..@@..+@@.
    0xaf, 0xa0, 0x00, 0xff, 0x00, 0x0a, 0xfa,  //%@%...@@...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0437 (з) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x3a, 0xef, 0xd8, 0x00,  //.%@@@%.
    0xff, 0xff, 0xff, 0xb0,  //@@@@@@%
    0xb4, 0x01, 0x6f, 0xf0,  //%+..+@@
    0x00, 0x00, 0x5f, 0xa0,  //....+@%
    0x00, 0xff, 0xfa, 0x00,  //..@@@%.
    0x00, 0xff, 0xff, 0x70,  //..@@@@+
    0x00, 0x00, 0x5f, 0xe0,  //....+@@
    0xa2, 0x01, 0x6f, 0xe0,  //%...+@@
    0xff, 0xff, 0xff, 0x80,  //@@@@@@%
    0x4b, 0xfe, 0xc6, 0x00,  //+%@@@+.
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0438 (и) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x0a, 0xff,  //@@...%@@
    0xff, 0x00, 0x4f, 0xff,  //@@..+@@@
    0xff, 0x00, 0xdf, 0xff,  //@@..@@@@
    0xff, 0x08, 0xfd, 0xff,  //@@.+@@@@
    0xff, 0x2f, 0xf5, 0xff,  //@@.@@+@@
    0xff, 0xbf, 0xc0, 0xff,  //@@%@@.@@
    0xff, 0xff, 0x30, 0xff,  //@@@@..@@
    0xff, 0xfb, 0x00, 0xff,  //@@@%..@@
    0xff, 0xf2, 0x00, 0xff,  //@@@...@@
    0xff, 0xa0, 0x00, 0xff,  //@@%...@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0439 (й) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x0d, 0x60, 0x06, 0xd0,  //.@+..+@.
    0x03, 0xcf, 0xfc, 0x30,  //..%@@%..
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x0a, 0xff,  //@@...%@@
    0xff, 0x00, 0x4f, 0xff,  //@@..+@@@
    0xff, 0x00, 0xdf, 0xff,  //@@..@@@@
    0xff, 0x08, 0xfd, 0xff,  //@@.+@@@@
    0xff, 0x2f, 0xf5, 0xff,  //@@.@@+@@
    0xff, 0xbf, 0xc0, 0xff,  //@@%@@.@@
    0xff, 0xff, 0x30, 0xff,  //@@@@..@@
    0xff, 0xfb, 0x00, 0xff,  //@@@%..@@
    0xff, 0xf2, 0x00, 0xff,  //@@@...@@
    0xff, 0xa0, 0x00, 0xff,  //@@%...@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+043a (к) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x00, 0x06, 0xff, 0x70,  //@@...+@@+
    0xff, 0x00, 0x7f, 0xf6, 0x00,  //@@..+@@+.
    0xff, 0x07, 0xff, 0x60, 0x00,  //@@.+@@+..
    0xff, 0x8f, 0xf5, 0x00, 0x00,  //@@%@@+...
    0xff, 0xff, 0xf6, 0x00, 0x00,  //@@@@@+...
    0xff, 0xf9, 0xff, 0x10, 0x00,  //@@@%@@...
    0xff, 0x40, 0xaf, 0xb0, 0x00,  //@@+.%@%..
    0xff, 0x00, 0x1e, 0xf5, 0x00,  //@@...@@+.
    0xff, 0x00, 0x05, 0xfe, 0x10,  //@@...+@@.
    0xff, 0x00, 0x00, 0xbf, 0xa0,  //@@....%@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+043b (л) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x0f, 0xff, 0xff, 0xff,  //...@@@@@@@
    0x00, 0x0f, 0xff, 0xff, 0xff,  //...@@@@@@@
    0x00, 0x0f, 0xf0, 0x00, 0xff,  //...@@...@@
    0x00, 0x1f, 0xf0, 0x00, 0xff,  //...@@...@@
    0x00, 0x2f, 0xe0, 0x00, 0xff,  //...@@...@@
    0x00, 0x5f, 0xd0, 0x00, 0xff,  //..+@@...@@
    0x00, 0x9f, 0xa0, 0x00, 0xff,  //..%@%...@@
    0x17, 0xff, 0x50, 0x00, 0xff,  //.+@@+...@@
    0xff, 0xfb, 0x00, 0x00, 0xff,  //@@@%....@@
    0xeb, 0x60, 0x00, 0x00, 0xff,  //@%+.....@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043c (м) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xfb, 0x00, 0xbf, 0xff,  //@@@%..%@@@
    0xff, 0xff, 0x11, 0xff, 0xff,  //@@@@..@@@@
    0xff, 0xaf, 0x77, 0xfa, 0xff,  //@@%@++@%@@
    0xff, 0x4f, 0xdd, 0xf4, 0xff,  //@@+@@@@+@@
    0xff, 0x0e, 0xff, 0xe0, 0xff,  //@@.@@@@.@@
    0xff, 0x09, 0xff, 0x90, 0xff,  //@@.%@@%.@@
    0xff, 0x03, 0xff, 0x30, 0xff,  //@@..@@..@@
    0xff, 0x00, 0xdd, 0x00, 0xff,  //@@..@@..@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043d (н) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+043e (о) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0xff, 0xc7, 0x00,  //..+@@@@+..
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x7f, 0xe6, 0x11, 0x6f, 0xf7,  //+@@+..+@@+
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x7f, 0xe5, 0x11, 0x5e, 0xf7,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043f (п) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0440 (р) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x09, 0xef, 0xa1, 0x00,  //@@.%@@%..
    0xff, 0xaf, 0xff, 0xfe, 0x10,  //@@%@@@@@.
    0xff, 0xd3, 0x03, 0xef, 0x80,  //@@@...@@%
    0xff, 0x40, 0x00, 0x4f, 0xd0,  //@@+...+@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x40, 0x00, 0x4f, 0xd0,  //@@+...+@@
    0xff, 0xd3, 0x03, 0xef, 0x80,  //@@@...@@%
    0xff, 0xaf, 0xff, 0xfe, 0x10,  //@@%@@@@@.
    0xff, 0x09, 0xef, 0xa2, 0x00,  //@@.%@@%..
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......


    /*Unicode: U+0441 (с) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x6c, 0xff, 0xb4,  //..+@@@%+
    0x0b, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x7f, 0xf6, 0x10, 0x3a,  //+@@+...%
    0xcf, 0x60, 0x00, 0x00,  //@@+.....
    0xff, 0x10, 0x00, 0x00,  //@@......
    0xff, 0x10, 0x00, 0x00,  //@@......
    0xcf, 0x60, 0x00, 0x00,  //@@+.....
    0x7f, 0xf6, 0x10, 0x3a,  //+@@+...%
    0x0b, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x7d, 0xff, 0xb4,  //..+@@@%+
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0442 (т) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0xff, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0443 (у) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x2f, 0xf1, 0x00, 0x00, 0x0f, 0xf2,  //.@@......@@.
    0x0a, 0xf7, 0x00, 0x00, 0x7f, 0xa0,  //.%@+....+@%.
    0x03, 0xfe, 0x00, 0x00, 0xef, 0x30,  //..@@....@@..
    0x00, 0xbf, 0x50, 0x05, 0xfc, 0x00,  //..%@+..+@@..
    0x00, 0x3f, 0xd0, 0x0c, 0xf4, 0x00,  //...@@..@@+..
    0x00, 0x0c, 0xf4, 0x3f, 0xd0, 0x00,  //...@@+.@@...
    0x00, 0x04, 0xfb, 0xaf, 0x60, 0x00,  //...+@%%@+...
    0x00, 0x00, 0xdf, 0xfe, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x5f, 0xf7, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x6f, 0x80, 0x00, 0x00,  //....+@%.....
    0x00, 0x01, 0xbf, 0x20, 0x00, 0x00,  //....%@......
    0x00, 0xff, 0xfb, 0x00, 0x00, 0x00,  //..@@@%......
    0x00, 0xff, 0xb1, 0x00, 0x00, 0x00,  //..@@%.......


    /*Unicode: U+0444 (ф) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x02, 0xcf, 0xc3, 0xff, 0x3c, 0xfc, 0x20,  //..@@@.@@.@@@..
    0x1e, 0xff, 0xfe, 0xff, 0xef, 0xff, 0xe1,  //.@@@@@@@@@@@@.
    0x9f, 0xc2, 0x1a, 0xff, 0xa1, 0x2c, 0xf8,  //%@@..%@@%..@@%
    0xdf, 0x30, 0x00, 0xff, 0x00, 0x03, 0xfd,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0xdf, 0x30, 0x00, 0xff, 0x00, 0x03, 0xfd,  //@@....@@....@@
    0x9f, 0xc2, 0x1a, 0xff, 0xa1, 0x2c, 0xf9,  //%@@..%@@%..@@%
    0x1f, 0xff, 0xfe, 0xff, 0xef, 0xff, 0xe1,  //.@@@@@@@@@@@@.
    0x03, 0xcf, 0xc3, 0xff, 0x3c, 0xfc, 0x30,  //..@@@.@@.@@@..
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //......@@......


    /*Unicode: U+0445 (х) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xaf, 0xd0, 0x00, 0x0d, 0xfa,  //%@@....@@%
    0x1e, 0xf5, 0x00, 0x5f, 0xd0,  //.@@+..+@@.
    0x04, 0xfd, 0x00, 0xdf, 0x30,  //.+@@..@@..
    0x00, 0x9f, 0x55, 0xf8, 0x00,  //..%@++@%..
    0x00, 0x0d, 0xdd, 0xc0, 0x00,  //...@@@@...
    0x00, 0x1e, 0xef, 0xe1, 0x00,  //...@@@@...
    0x00, 0xaf, 0x57, 0xfa, 0x00,  //..%@++@%..
    0x05, 0xfd, 0x00, 0xef, 0x50,  //.+@@..@@+.
    0x1e, 0xf4, 0x00, 0x5f, 0xe1,  //.@@+..+@@.
    0xaf, 0xc0, 0x00, 0x0c, 0xfa,  //%@@....@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0446 (ц) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //@@.....@@..
    0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00,  //@@.....@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0447 (ч) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x10, 0x00, 0xff,  //@@....@@
    0xdf, 0x90, 0x00, 0xff,  //@@%...@@
    0x7f, 0xff, 0xff, 0xff,  //+@@@@@@@
    0x08, 0xef, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x00, 0x00, 0xff,  //......@@
    0x00, 0x00, 0x00, 0xff,  //......@@
    0x00, 0x00, 0x00, 0xff,  //......@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0448 (ш) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0449 (щ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //@@...@@...@@..
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //@@...@@...@@..
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //@@...@@...@@..
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //@@...@@...@@..
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //@@...@@...@@..
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //@@...@@...@@..
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //@@...@@...@@..
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+044a (ъ) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //@@@@@......
    0xff, 0xff, 0xf0, 0x00, 0x00, 0x00,  //@@@@@......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //...@@......
    0x00, 0x0f, 0xf0, 0x00, 0x00, 0x00,  //...@@......
    0x00, 0x0f, 0xff, 0xff, 0xd8, 0x00,  //...@@@@@@%.
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x90,  //...@@@@@@@%
    0x00, 0x0f, 0xf0, 0x00, 0x5f, 0xe0,  //...@@...+@@
    0x00, 0x0f, 0xf0, 0x00, 0x5f, 0xf0,  //...@@...+@@
    0x00, 0x0f, 0xff, 0xff, 0xff, 0x90,  //...@@@@@@@%
    0x00, 0x0f, 0xff, 0xff, 0xd7, 0x00,  //...@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044b (ы) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0xff, 0xff, 0xfd, 0x80, 0x0f, 0xf0,  //@@@@@@%..@@
    0xff, 0xff, 0xff, 0xf9, 0x0f, 0xf0,  //@@@@@@@%.@@
    0xff, 0x00, 0x05, 0xfe, 0x0f, 0xf0,  //@@...+@@.@@
    0xff, 0x00, 0x05, 0xff, 0x0f, 0xf0,  //@@...+@@.@@
    0xff, 0xff, 0xff, 0xf9, 0x0f, 0xf0,  //@@@@@@@%.@@
    0xff, 0xff, 0xfd, 0x70, 0x0f, 0xf0,  //@@@@@@+..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044c (ь) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xfd, 0x80,  //@@@@@@%.
    0xff, 0xff, 0xff, 0xf9,  //@@@@@@@%
    0xff, 0x00, 0x05, 0xfe,  //@@...+@@
    0xff, 0x00, 0x05, 0xff,  //@@...+@@
    0xff, 0xff, 0xff, 0xf9,  //@@@@@@@%
    0xff, 0xff, 0xfd, 0x70,  //@@@@@@+.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+044d (э) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x4b, 0xef, 0xc6, 0x00,  //.%@@@+..
    0xff, 0xff, 0xff, 0xb0,  //@@@@@@%.
    0xb4, 0x00, 0x4e, 0xf6,  //%...+@@+
    0x00, 0x00, 0x03, 0xfc,  //......@@
    0x0f, 0xff, 0xff, 0xff,  //.@@@@@@@
    0x0f, 0xff, 0xff, 0xff,  //.@@@@@@@
    0x00, 0x00, 0x02, 0xfc,  //......@@
    0xb3, 0x01, 0x4d, 0xf7,  //%...+@@+
    0xff, 0xff, 0xff, 0xb0,  //@@@@@@%.
    0x4b, 0xef, 0xd7, 0x00,  //+%@@@+..
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+044e (ю) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0x00, 0x19, 0xef, 0xe9, 0x10,  //@@...%@@@%..
    0xff, 0x00, 0xdf, 0xff, 0xff, 0xd0,  //@@..@@@@@@@.
    0xff, 0x08, 0xfe, 0x40, 0x4e, 0xf8,  //@@.%@@...@@%
    0xff, 0x0d, 0xf4, 0x00, 0x05, 0xfd,  //@@.@@+...+@@
    0xff, 0xff, 0xf1, 0x00, 0x01, 0xff,  //@@@@@.....@@
    0xff, 0xff, 0xf1, 0x00, 0x01, 0xff,  //@@@@@.....@@
    0xff, 0x0e, 0xf4, 0x00, 0x04, 0xfd,  //@@.@@+...+@@
    0xff, 0x0a, 0xfe, 0x30, 0x3e, 0xf8,  //@@.%@@...@@%
    0xff, 0x02, 0xef, 0xff, 0xff, 0xd0,  //@@..@@@@@@@.
    0xff, 0x00, 0x2a, 0xef, 0xe9, 0x10,  //@@...%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+044f (я) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x7d, 0xff, 0xff, 0xf0,  //..+@@@@@@
    0x09, 0xff, 0xff, 0xff, 0xf0,  //.%@@@@@@@
    0x0e, 0xf8, 0x00, 0x0f, 0xf0,  //.@@+...@@
    0x0e, 0xf0, 0x00, 0x0f, 0xf0,  //.@@....@@
    0x07, 0xf8, 0x00, 0x0f, 0xf0,  //.+@+...@@
    0x00, 0x4e, 0xff, 0xff, 0xf0,  //..+@@@@@@
    0x00, 0x4f, 0xff, 0xff, 0xf0,  //..+@@@@@@
    0x02, 0xef, 0x70, 0x0f, 0xf0,  //..@@+..@@
    0x0c, 0xfa, 0x00, 0x0f, 0xf0,  //.@@%...@@
    0x9f, 0xd0, 0x00, 0x0f, 0xf0,  //%@@....@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........



#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 8
    /*Unicode: U+0410 (А) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x06, 0xea, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x28, 0xff, 0xc6, 0xc4, 0xff, 0x2a, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x90, 0xff, 0x64, 0x5c, 0xff, 0x92, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x08, 0xee, 0xf4, 0x0c, 0x06, 0xea, 0xee, 0x08, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x5e, 0xff, 0xa0, 0x00, 0x00, 0x8c, 0xff, 0x60, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0xc6, 0xff, 0x3e, 0x00, 0x00, 0x24, 0xfc, 0xc6, 0x00, 0x00,  //..@@....@@..
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00,  //..@@@@@@@@..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@@@@@@%.
    0x0a, 0xf0, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xf0, 0x0a,  //.@@......@@.
    0x64, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x62,  //+@%......%@+
    0xca, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xca,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0411 (Б) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xe2, 0xb4, 0x36, 0x00,  //@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x4a,  //@@@@@@@@+
    0xff, 0xff, 0x00, 0x00, 0x02, 0x22, 0xac, 0xff, 0xc6,  //@@....%@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xf4,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x02, 0x20, 0xa8, 0xff, 0xc6,  //@@....%@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x4a,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xee, 0xb8, 0x44, 0x00,  //@@@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0412 (В) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xce, 0x68, 0x00, 0x00,  //@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x88, 0x00,  //@@@@@@@%.
    0xff, 0xff, 0x00, 0x00, 0x0c, 0x7a, 0xff, 0xea, 0x00,  //@@...+@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf0, 0x00,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x0c, 0x76, 0xff, 0xac, 0x00,  //@@...+@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x98, 0x10, 0x00,  //@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0x00,  //@@@@@@@+.
    0xff, 0xff, 0x00, 0x00, 0x06, 0x2c, 0xb4, 0xff, 0x66,  //@@....%@+
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xda,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x06, 0x2c, 0xb4, 0xff, 0xcc,  //@@....%@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x46,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xe4, 0xaa, 0x36, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0413 (Г) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0414 (Д) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@@@@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@@@@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@...@@..
    0x00, 0x00, 0x06, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@...@@..
    0x00, 0x00, 0x0e, 0xff, 0xf6, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@...@@..
    0x00, 0x00, 0x22, 0xff, 0xec, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@...@@..
    0x00, 0x00, 0x3a, 0xff, 0xd2, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@...@@..
    0x00, 0x00, 0x62, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..+@%...@@..
    0x00, 0x00, 0x96, 0xff, 0x7c, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..%@+...@@..
    0x00, 0x04, 0xe0, 0xff, 0x36, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@....@@..
    0x0a, 0xa0, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.%@@....@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0415 (Е) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0416 (Ж) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x8a, 0xff, 0xf2, 0x34, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x34, 0xf2, 0xff, 0x88,  //%@@.....@@.....@@%
    0x00, 0x9e, 0xff, 0xea, 0x26, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x26, 0xea, 0xff, 0x9c, 0x00,  //.%@@....@@....@@%.
    0x00, 0x02, 0xb0, 0xff, 0xe0, 0x1a, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x1a, 0xe0, 0xff, 0xae, 0x02, 0x00,  //..%@@...@@...@@%..
    0x00, 0x00, 0x06, 0xc0, 0xff, 0xd4, 0x10, 0x00, 0xff, 0xff, 0x00, 0x12, 0xd4, 0xff, 0xc0, 0x06, 0x00, 0x00,  //...%@@..@@..@@%...
    0x00, 0x00, 0x00, 0x0e, 0xce, 0xff, 0xc6, 0x08, 0xff, 0xff, 0x0a, 0xc6, 0xff, 0xce, 0x0e, 0x00, 0x00, 0x00,  //....@@@.@@.@@@....
    0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0xff, 0xb6, 0xff, 0xff, 0xb6, 0xff, 0xff, 0x86, 0x00, 0x00, 0x00, 0x00,  //....%@@%@@%@@%....
    0x00, 0x00, 0x00, 0x24, 0xf8, 0xfc, 0xec, 0xff, 0xff, 0xff, 0xff, 0xec, 0xfc, 0xf6, 0x22, 0x00, 0x00, 0x00,  //....@@@@@@@@@@....
    0x00, 0x00, 0x00, 0xb6, 0xff, 0x9e, 0x30, 0xf0, 0xff, 0xff, 0xf0, 0x30, 0x9e, 0xff, 0xb4, 0x00, 0x00, 0x00,  //...%@%.@@@@.%@%...
    0x00, 0x00, 0x4e, 0xff, 0xee, 0x14, 0x00, 0x3e, 0xff, 0xff, 0x3e, 0x00, 0x14, 0xee, 0xff, 0x4e, 0x00, 0x00,  //..+@@...@@...@@+..
    0x00, 0x08, 0xde, 0xff, 0x6a, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xde, 0x08, 0x00,  //..@@+...@@...+@@..
    0x00, 0x80, 0xff, 0xce, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x02, 0xce, 0xff, 0x80, 0x00,  //.+@@....@@....@@+.
    0x22, 0xf6, 0xfc, 0x38, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x3a, 0xfc, 0xf6, 0x20,  //.@@.....@@.....@@.
    0xb2, 0xff, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xb2,  //%@%.....@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+0417 (З) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x2a, 0x8e, 0xd0, 0xf4, 0xf0, 0xd4, 0x92, 0x28, 0x00,  //.%@@@@%..
    0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x50,  //@@@@@@@@+
    0xb4, 0x6c, 0x18, 0x02, 0x06, 0x24, 0x9a, 0xff, 0xda,  //%+....%@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x08, 0x26, 0x98, 0xff, 0xa8,  //......%@%
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x9e, 0x0c,  //..@@@@@%.
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xa2, 0x0c,  //..@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x10, 0x3e, 0xc6, 0xff, 0x9e,  //......@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0xea,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0xf2,  //.......@@
    0xc0, 0x50, 0x12, 0x02, 0x10, 0x44, 0xcc, 0xff, 0xb6,  //%+...+@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x26,  //@@@@@@@@.
    0x3e, 0x9c, 0xd8, 0xf6, 0xec, 0xc8, 0x74, 0x0e, 0x00,  //.%@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0418 (И) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff,  //@@.....%@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x26, 0xf8, 0xff, 0xff,  //@@.....@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff,  //@@....%@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xb4, 0xff, 0xff,  //@@...+@%@@
    0xff, 0xff, 0x00, 0x00, 0x06, 0xdc, 0xf8, 0x26, 0xff, 0xff,  //@@...@@.@@
    0xff, 0xff, 0x00, 0x00, 0x7c, 0xff, 0x8e, 0x00, 0xff, 0xff,  //@@..+@%.@@
    0xff, 0xff, 0x00, 0x1e, 0xf4, 0xea, 0x0e, 0x00, 0xff, 0xff,  //@@..@@..@@
    0xff, 0xff, 0x00, 0xaa, 0xff, 0x68, 0x00, 0x00, 0xff, 0xff,  //@@.%@+..@@
    0xff, 0xff, 0x42, 0xff, 0xd0, 0x02, 0x00, 0x00, 0xff, 0xff,  //@@+@@...@@
    0xff, 0xff, 0xd4, 0xff, 0x40, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@@....@@
    0xff, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@%....@@
    0xff, 0xff, 0xf8, 0x22, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@.....@@
    0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%.....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0419 (Й) , Width: 10 */
    0x00, 0x00, 0xd6, 0x6a, 0x0a, 0x0a, 0x6a, 0xd6, 0x00, 0x00,  //..@+..+@..
    0x00, 0x00, 0x30, 0xc0, 0xf2, 0xf2, 0xc0, 0x30, 0x00, 0x00,  //...%@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff,  //@@.....%@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x26, 0xf8, 0xff, 0xff,  //@@.....@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xb8, 0xff, 0xff, 0xff,  //@@....%@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xb4, 0xff, 0xff,  //@@...+@%@@
    0xff, 0xff, 0x00, 0x00, 0x06, 0xdc, 0xf8, 0x26, 0xff, 0xff,  //@@...@@.@@
    0xff, 0xff, 0x00, 0x00, 0x7c, 0xff, 0x8e, 0x00, 0xff, 0xff,  //@@..+@%.@@
    0xff, 0xff, 0x00, 0x1e, 0xf4, 0xea, 0x0e, 0x00, 0xff, 0xff,  //@@..@@..@@
    0xff, 0xff, 0x00, 0xaa, 0xff, 0x68, 0x00, 0x00, 0xff, 0xff,  //@@.%@+..@@
    0xff, 0xff, 0x42, 0xff, 0xd0, 0x02, 0x00, 0x00, 0xff, 0xff,  //@@+@@...@@
    0xff, 0xff, 0xd4, 0xff, 0x40, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@@....@@
    0xff, 0xff, 0xff, 0xae, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@%....@@
    0xff, 0xff, 0xf8, 0x22, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@.....@@
    0xff, 0xff, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%.....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+041a (К) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xfc, 0xff, 0x7a,  //@@.....+@@+
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfc, 0xff, 0x72, 0x00,  //@@....+@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x74, 0xff, 0xfc, 0x6c, 0x00, 0x00,  //@@...+@@+..
    0xff, 0xff, 0x00, 0x00, 0x7a, 0xff, 0xfc, 0x64, 0x00, 0x00, 0x00,  //@@..+@@+...
    0xff, 0xff, 0x00, 0x82, 0xff, 0xfc, 0x5e, 0x00, 0x00, 0x00, 0x00,  //@@.%@@+....
    0xff, 0xff, 0x8a, 0xff, 0xff, 0xe6, 0x0e, 0x00, 0x00, 0x00, 0x00,  //@@%@@@.....
    0xff, 0xff, 0xff, 0xf8, 0xda, 0xff, 0x9c, 0x00, 0x00, 0x00, 0x00,  //@@@@@@%....
    0xff, 0xff, 0xf6, 0x4c, 0x26, 0xf6, 0xff, 0x48, 0x00, 0x00, 0x00,  //@@@+.@@+...
    0xff, 0xff, 0x46, 0x00, 0x00, 0x70, 0xff, 0xe4, 0x10, 0x00, 0x00,  //@@+..+@@...
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xa2, 0x00, 0x00,  //@@....@@%..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf2, 0xff, 0x4e, 0x00,  //@@.....@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xe6, 0x12,  //@@.....+@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0xff, 0xa8,  //@@......%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+041b (Л) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@....@@
    0x00, 0x00, 0x06, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@....@@
    0x00, 0x00, 0x0c, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@....@@
    0x00, 0x00, 0x1e, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@....@@
    0x00, 0x00, 0x32, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@....@@
    0x00, 0x00, 0x54, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..+@@....@@
    0x00, 0x00, 0x88, 0xff, 0x9a, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..%@%....@@
    0x00, 0x02, 0xd8, 0xff, 0x60, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..@@+....@@
    0x28, 0xb2, 0xff, 0xf0, 0x12, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.%@@.....@@
    0xff, 0xff, 0xfa, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@+.....@@
    0xe2, 0x9e, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@%.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+041c (М) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff,  //@@@+....+@@@
    0xff, 0xff, 0xf2, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xf2, 0xff, 0xff,  //@@@%....%@@@
    0xff, 0xff, 0xa0, 0xfc, 0x20, 0x00, 0x00, 0x12, 0xf8, 0xa0, 0xff, 0xff,  //@@%@....@%@@
    0xff, 0xff, 0x40, 0xff, 0x80, 0x00, 0x00, 0x70, 0xff, 0x40, 0xff, 0xff,  //@@.@+..+@.@@
    0xff, 0xff, 0x00, 0xe0, 0xde, 0x00, 0x00, 0xd2, 0xde, 0x00, 0xff, 0xff,  //@@.@@..@@.@@
    0xff, 0xff, 0x00, 0x82, 0xff, 0x3e, 0x38, 0xff, 0x80, 0x00, 0xff, 0xff,  //@@.%@..@+.@@
    0xff, 0xff, 0x00, 0x22, 0xff, 0x9e, 0x9c, 0xff, 0x22, 0x00, 0xff, 0xff,  //@@..@%%@..@@
    0xff, 0xff, 0x00, 0x00, 0xc2, 0xf2, 0xf2, 0xc2, 0x00, 0x00, 0xff, 0xff,  //@@..@@@@..@@
    0xff, 0xff, 0x00, 0x00, 0x62, 0xff, 0xff, 0x62, 0x00, 0x00, 0xff, 0xff,  //@@..+@@+..@@
    0xff, 0xff, 0x00, 0x00, 0x0c, 0xf4, 0xf4, 0x0c, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+041d (Н) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+041e (О) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0x7e, 0xd0, 0xf2, 0xf2, 0xd0, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x08, 0xd8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x44, 0xce, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd6, 0xff, 0x6c,  //+@@......@@+
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa,  //@@........@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //+@@......@@+
    0x0a, 0xda, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x00, 0x00, 0x0e, 0x80, 0xd0, 0xf4, 0xf4, 0xd2, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+041f (П) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0420 (Р) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xc0, 0x4a, 0x00,  //@@@@@%+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c,  //@@@@@@@+
    0xff, 0xff, 0x00, 0x00, 0x1a, 0xa8, 0xff, 0xc6,  //@@...%@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x18, 0xa6, 0xff, 0xc6,  //@@...%@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e,  //@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xc2, 0x4a, 0x00,  //@@@@@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0421 (С) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x02, 0x5e, 0xb6, 0xe6, 0xf8, 0xf2, 0xd2, 0x96, 0x36,  //...+%@@@@%.
    0x00, 0x18, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@
    0x04, 0xca, 0xff, 0xe2, 0x66, 0x1e, 0x04, 0x08, 0x28, 0x64, 0xc4,  //.@@@+....+@
    0x64, 0xff, 0xde, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0xbc, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0xea, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xea, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xbc, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0x64, 0xff, 0xdc, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0x04, 0xcc, 0xff, 0xe0, 0x64, 0x1e, 0x04, 0x08, 0x26, 0x64, 0xc4,  //.@@@+....+@
    0x00, 0x1a, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@
    0x00, 0x00, 0x04, 0x60, 0xb8, 0xe8, 0xfa, 0xf2, 0xd2, 0x94, 0x36,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0422 (Т) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0423 (У) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xca, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x66, 0xff, 0xc6,  //@@+....+@@
    0x64, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xff, 0x58,  //+@%....@@+
    0x0a, 0xf0, 0xff, 0x28, 0x00, 0x00, 0x42, 0xff, 0xe4, 0x04,  //.@@...+@@.
    0x00, 0x94, 0xff, 0x8e, 0x00, 0x00, 0xb0, 0xff, 0x7a, 0x00,  //.%@%..%@+.
    0x00, 0x2e, 0xff, 0xec, 0x08, 0x22, 0xfc, 0xf6, 0x14, 0x00,  //..@@..@@..
    0x00, 0x00, 0xc6, 0xff, 0x5e, 0x8e, 0xff, 0x9e, 0x00, 0x00,  //..@@+%@%..
    0x00, 0x00, 0x5e, 0xff, 0xcc, 0xee, 0xff, 0x2e, 0x00, 0x00,  //..+@@@@...
    0x00, 0x00, 0x08, 0xee, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...@@@%...
    0x00, 0x00, 0x00, 0x90, 0xff, 0xff, 0x52, 0x00, 0x00, 0x00,  //...%@@+...
    0x00, 0x00, 0x00, 0x4e, 0xff, 0xe0, 0x02, 0x00, 0x00, 0x00,  //...+@@....
    0x00, 0x00, 0x16, 0xc2, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00,  //...@@+....
    0x00, 0xff, 0xff, 0xff, 0xec, 0x10, 0x00, 0x00, 0x00, 0x00,  //.@@@@.....
    0x00, 0xff, 0xf2, 0xc4, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0424 (Ф) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x1e, 0x84, 0xc6, 0xee, 0xff, 0xff, 0xee, 0xc8, 0x84, 0x20, 0x00, 0x00,  //...%@@@@@@%...
    0x00, 0x6a, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x6c, 0x00,  //.+@@@@@@@@@@+.
    0x4c, 0xff, 0xff, 0xaa, 0x44, 0x14, 0xff, 0xff, 0x14, 0x42, 0xa8, 0xff, 0xff, 0x4e,  //+@@%+.@@.+%@@+
    0xc2, 0xff, 0x7a, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xc2,  //@@+...@@...+@@
    0xf2, 0xff, 0x10, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x12, 0xff, 0xf2,  //@@....@@....@@
    0xf2, 0xff, 0x0a, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf2,  //@@....@@....@@
    0xc4, 0xff, 0x60, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x5e, 0xff, 0xc4,  //@@+...@@...+@@
    0x50, 0xff, 0xf6, 0x80, 0x1a, 0x00, 0xff, 0xff, 0x00, 0x16, 0x7c, 0xf6, 0xff, 0x50,  //+@@+..@@..+@@+
    0x00, 0x6e, 0xf8, 0xff, 0xff, 0xea, 0xff, 0xff, 0xe8, 0xff, 0xff, 0xf8, 0x6e, 0x00,  //.+@@@@@@@@@@+.
    0x00, 0x00, 0x20, 0x84, 0xc8, 0xee, 0xff, 0xff, 0xee, 0xc8, 0x86, 0x20, 0x00, 0x00,  //...%@@@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0425 (Х) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0xb4, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xaa,  //.%@%....%@%
    0x00, 0x24, 0xf8, 0xff, 0x46, 0x00, 0x00, 0x64, 0xff, 0xec, 0x16,  //..@@+..+@@.
    0x00, 0x00, 0x86, 0xff, 0xd6, 0x04, 0x1a, 0xf0, 0xff, 0x5a, 0x00,  //..%@@..@@+.
    0x00, 0x00, 0x0a, 0xe4, 0xff, 0x72, 0xb4, 0xff, 0xb2, 0x00, 0x00,  //...@@+%@%..
    0x00, 0x00, 0x00, 0x58, 0xff, 0xfa, 0xff, 0xee, 0x1a, 0x00, 0x00,  //...+@@@@...
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00,  //....%@@+...
    0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00,  //....%@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00,  //...+@@@@...
    0x00, 0x00, 0x16, 0xec, 0xff, 0x7a, 0xec, 0xff, 0x5c, 0x00, 0x00,  //...@@+@@+..
    0x00, 0x00, 0xae, 0xff, 0xbe, 0x00, 0x6a, 0xff, 0xe4, 0x0c, 0x00,  //..%@%.+@@..
    0x00, 0x58, 0xff, 0xf4, 0x22, 0x00, 0x02, 0xd0, 0xff, 0x88, 0x00,  //.+@@...@@%.
    0x14, 0xea, 0xff, 0x70, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xf8, 0x24,  //.@@+....@@.
    0xaa, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xb4,  //%@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0426 (Ц) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@......@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //..........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0427 (Ч) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xf2, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xc4, 0xff, 0xb2, 0x16, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%....@@
    0x58, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@@@@@@
    0x00, 0x66, 0xdc, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,  //.+@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0428 (Ш) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@.....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0429 (Щ) , Width: 18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@.....@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //................@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..................


    /*Unicode: U+042a (Ъ) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@.......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xe2, 0xb4, 0x36, 0x00,  //...@@@@@@%..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x4a,  //...@@@@@@@@+
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x18, 0x98, 0xff, 0xc6,  //...@@....%@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4,  //...@@.....@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xf4,  //...@@.....@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x02, 0x22, 0xac, 0xff, 0xc4,  //...@@....%@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x46,  //...@@@@@@@@+
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xe0, 0xae, 0x32, 0x00,  //...@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+042b (Ы) , Width: 13 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.........@@
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xe2, 0xb4, 0x36, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@@@@%....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x4a, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@+..@@
    0xff, 0xff, 0x00, 0x00, 0x02, 0x20, 0xa8, 0xff, 0xc6, 0x00, 0x00, 0xff, 0xff,  //@@....%@@..@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4, 0x00, 0x00, 0xff, 0xff,  //@@.....@@..@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xf4, 0x00, 0x00, 0xff, 0xff,  //@@.....@@..@@
    0xff, 0xff, 0x00, 0x00, 0x02, 0x22, 0xaa, 0xff, 0xc4, 0x00, 0x00, 0xff, 0xff,  //@@....%@@..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x46, 0x00, 0x00, 0xff, 0xff,  //@@@@@@@@+..@@
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xe0, 0xae, 0x32, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@@@@%....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.............


    /*Unicode: U+042c (Ь) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xe2, 0xb4, 0x36, 0x00,  //@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x4a,  //@@@@@@@@+
    0xff, 0xff, 0x00, 0x00, 0x02, 0x20, 0xa8, 0xff, 0xc6,  //@@....%@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xf4,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x02, 0x22, 0xaa, 0xff, 0xc4,  //@@....%@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x46,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xe0, 0xae, 0x32, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+042d (Э) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x2c, 0x8a, 0xca, 0xe6, 0xf8, 0xe8, 0xb6, 0x5e, 0x02, 0x00, 0x00,  //.%@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x18, 0x00,  //@@@@@@@@@..
    0xce, 0x70, 0x30, 0x14, 0x02, 0x14, 0x44, 0xb2, 0xff, 0xca, 0x04,  //@+....+%@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0x64,  //........%@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0xba,  //.........@%
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea,  //..@@@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //..@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xea,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0xff, 0xba,  //........+@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xe8, 0xff, 0x64,  //........@@+
    0xce, 0x6e, 0x30, 0x12, 0x02, 0x1a, 0x5a, 0xda, 0xff, 0xcc, 0x04,  //@+....+@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x18, 0x00,  //@@@@@@@@@..
    0x2e, 0x8a, 0xca, 0xe6, 0xf8, 0xe8, 0xb8, 0x60, 0x04, 0x00, 0x00,  //.%@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+042e (Ю) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x7e, 0xd0, 0xf2, 0xf2, 0xd0, 0x80, 0x0e, 0x00, 0x00,  //@@.....+@@@@+...
    0xff, 0xff, 0x00, 0x00, 0x00, 0x20, 0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //@@....@@@@@@@@..
    0xff, 0xff, 0x00, 0x00, 0x04, 0xce, 0xff, 0xcc, 0x46, 0x0a, 0x0a, 0x44, 0xcc, 0xff, 0xd8, 0x08,  //@@...@@@+..+@@@.
    0xff, 0xff, 0x00, 0x00, 0x62, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //@@..+@@......@@+
    0xff, 0xff, 0x00, 0x00, 0xbe, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //@@..%@+......+@%
    0xff, 0xff, 0x00, 0x00, 0xee, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@..@@........@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa,  //@@@@@@........@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@@@@@........@@
    0xff, 0xff, 0x00, 0x00, 0xea, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //@@..@@+......+@%
    0xff, 0xff, 0x00, 0x00, 0xa6, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //@@..%@@......@@+
    0xff, 0xff, 0x00, 0x00, 0x2a, 0xf6, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xd8, 0x08,  //@@...@@@+..+@@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x50, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //@@...+@@@@@@@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x22, 0x94, 0xd8, 0xf6, 0xf4, 0xd2, 0x80, 0x0e, 0x00, 0x00,  //@@.....%@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+042f (Я) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x42, 0xb6, 0xea, 0xfc, 0xff, 0xff, 0xff, 0xff,  //.+%@@@@@@
    0x4e, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@@@@@@
    0xce, 0xff, 0xaa, 0x20, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%....@@
    0xf8, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xea, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0x98, 0xff, 0xaa, 0x20, 0x00, 0x00, 0x00, 0xff, 0xff,  //%@%....@@
    0x06, 0x90, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@
    0x00, 0x00, 0x26, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@
    0x00, 0x00, 0x86, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff,  //..%@%..@@
    0x00, 0x1c, 0xf6, 0xfc, 0x34, 0x00, 0x00, 0xff, 0xff,  //..@@...@@
    0x00, 0xa0, 0xff, 0xa6, 0x00, 0x00, 0x00, 0xff, 0xff,  //.%@%...@@
    0x2e, 0xfc, 0xf8, 0x20, 0x00, 0x00, 0x00, 0xff, 0xff,  //.@@....@@
    0xb8, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //%@%....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0430 (а) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x44, 0xb2, 0xee, 0xf4, 0xc4, 0x42, 0x00,  //.+%@@@+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x32,  //.@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xa6,  //.%...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xe0,  //......@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x10, 0xff, 0xff,  //@@+...@@
    0xec, 0xff, 0x4e, 0x06, 0x20, 0xaa, 0xff, 0xff,  //@@+..%@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff,  //%@@@@%@@
    0x10, 0xa2, 0xec, 0xee, 0x9c, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0431 (б) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00,  //...........
    0x00, 0x00, 0x00, 0x0e, 0x72, 0xb8, 0xe2, 0xf6, 0xff, 0xff, 0x00,  //....+%@@@@.
    0x00, 0x00, 0x3c, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x00,  //...@@@@@@@.
    0x00, 0x1e, 0xec, 0xff, 0xc4, 0x58, 0x28, 0x16, 0x08, 0x00, 0x00,  //..@@@+.....
    0x00, 0xa8, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@%.......
    0x00, 0xf4, 0xee, 0x64, 0xc6, 0xf2, 0xf6, 0xd2, 0x7a, 0x06, 0x00,  //.@@+@@@@+..
    0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x06,  //.@@@@@@@@@.
    0x10, 0xff, 0xff, 0xee, 0x60, 0x14, 0x14, 0x60, 0xf0, 0xff, 0x78,  //.@@@+..+@@+
    0x08, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xd0,  //.@@+....+@@
    0x02, 0xff, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //.@@......@@
    0x00, 0xf4, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //.@@......@@
    0x00, 0xd0, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xce,  //.@@+....+@@
    0x00, 0x7a, 0xff, 0xec, 0x5c, 0x12, 0x12, 0x5e, 0xee, 0xff, 0x74,  //.+@@+..+@@+
    0x00, 0x08, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //..@@@@@@@%.
    0x00, 0x00, 0x08, 0x7c, 0xd2, 0xf6, 0xf4, 0xd0, 0x74, 0x04, 0x00,  //...+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0432 (в) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xf4, 0xda, 0x8c, 0x0e,  //@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb2,  //@@@@@@@%
    0xff, 0xff, 0x00, 0x00, 0x0a, 0x5e, 0xff, 0xf2,  //@@...+@@
    0xff, 0xff, 0x00, 0x00, 0x0a, 0x5e, 0xff, 0xbc,  //@@...+@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x12,  //@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x86,  //@@@@@@@%
    0xff, 0xff, 0x00, 0x00, 0x08, 0x58, 0xff, 0xe8,  //@@...+@@
    0xff, 0xff, 0x00, 0x00, 0x08, 0x56, 0xff, 0xf4,  //@@...+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xd2, 0x78, 0x06,  //@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0433 (г) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0434 (д) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@@@@..
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,  //...@@@@@@..
    0x00, 0x00, 0x06, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@..@@..
    0x00, 0x00, 0x14, 0xff, 0xf8, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@..@@..
    0x00, 0x00, 0x34, 0xff, 0xe8, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //...@@..@@..
    0x00, 0x00, 0x6c, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..+@%..@@..
    0x00, 0x00, 0xc6, 0xff, 0x78, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@@+..@@..
    0x04, 0x82, 0xff, 0xee, 0x12, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.%@@...@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0435 (е) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x5a, 0xbe, 0xee, 0xf8, 0xda, 0x88, 0x0e, 0x00,  //..+%@@@%..
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0c,  //.%@@@@@@@.
    0x62, 0xff, 0xe2, 0x54, 0x12, 0x08, 0x38, 0xc8, 0xff, 0x86,  //+@@+...@@%
    0xc6, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xd8,  //@@......@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xca, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@........
    0x60, 0xff, 0xe6, 0x62, 0x1e, 0x08, 0x06, 0x24, 0x64, 0xc4,  //+@@+....+@
    0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x00, 0x42, 0xaa, 0xe2, 0xf8, 0xf4, 0xd2, 0x8c, 0x2e,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0436 (ж) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0xa0, 0xff, 0xd0, 0x08, 0x00, 0xff, 0xff, 0x00, 0x08, 0xd0, 0xff, 0x9e, 0x00,  //.%@@..@@..@@%.
    0x00, 0x0a, 0xd6, 0xff, 0x9a, 0x00, 0xff, 0xff, 0x00, 0x9a, 0xff, 0xd4, 0x0a, 0x00,  //..@@%.@@.%@@..
    0x00, 0x00, 0x2c, 0xf4, 0xff, 0x58, 0xff, 0xff, 0x5a, 0xff, 0xf4, 0x2c, 0x00, 0x00,  //...@@+@@+@@...
    0x00, 0x00, 0x00, 0x68, 0xff, 0xf2, 0xff, 0xff, 0xf2, 0xff, 0x68, 0x00, 0x00, 0x00,  //...+@@@@@@+...
    0x00, 0x00, 0x00, 0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x00, 0x00, 0x00,  //...%@@@@@@%...
    0x00, 0x00, 0x30, 0xfa, 0xfa, 0xe2, 0xff, 0xff, 0xe2, 0xfa, 0xfa, 0x30, 0x00, 0x00,  //...@@@@@@@@...
    0x00, 0x00, 0xca, 0xff, 0x8a, 0x32, 0xff, 0xff, 0x32, 0x8c, 0xff, 0xca, 0x00, 0x00,  //..@@%.@@.%@@..
    0x00, 0x6e, 0xff, 0xde, 0x0a, 0x00, 0xff, 0xff, 0x00, 0x0a, 0xe0, 0xff, 0x6c, 0x00,  //.+@@..@@..@@+.
    0x1a, 0xf2, 0xff, 0x4a, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x4c, 0xff, 0xf0, 0x1a,  //.@@+..@@..+@@.
    0xae, 0xff, 0xaa, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xae,  //%@%...@@...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+0437 (з) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x3e, 0xaa, 0xec, 0xf4, 0xd6, 0x82, 0x0c,  //.%@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4,  //@@@@@@%
    0xb6, 0x44, 0x0e, 0x10, 0x68, 0xff, 0xf4,  //%+..+@@
    0x00, 0x00, 0x00, 0x06, 0x5c, 0xff, 0xae,  //....+@%
    0x00, 0x00, 0xff, 0xff, 0xff, 0xa0, 0x06,  //..@@@%.
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x76,  //..@@@@+
    0x00, 0x00, 0x00, 0x08, 0x5a, 0xff, 0xec,  //....+@@
    0xa2, 0x28, 0x02, 0x14, 0x6c, 0xff, 0xee,  //%...+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8e,  //@@@@@@%
    0x48, 0xbe, 0xf4, 0xec, 0xca, 0x6a, 0x02,  //+%@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0438 (и) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff,  //@@...%@@
    0xff, 0xff, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff,  //@@..+@@@
    0xff, 0xff, 0x00, 0x06, 0xda, 0xff, 0xff, 0xff,  //@@..@@@@
    0xff, 0xff, 0x00, 0x80, 0xff, 0xd8, 0xff, 0xff,  //@@.+@@@@
    0xff, 0xff, 0x24, 0xf6, 0xff, 0x52, 0xff, 0xff,  //@@.@@+@@
    0xff, 0xff, 0xba, 0xff, 0xc6, 0x00, 0xff, 0xff,  //@@%@@.@@
    0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0xff, 0xff,  //@@@@..@@
    0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0xff, 0xff,  //@@@%..@@
    0xff, 0xff, 0xfc, 0x2c, 0x00, 0x00, 0xff, 0xff,  //@@@...@@
    0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0439 (й) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xd8, 0x64, 0x0a, 0x0a, 0x68, 0xd6, 0x00,  //.@+..+@.
    0x00, 0x32, 0xc0, 0xf2, 0xf2, 0xc0, 0x30, 0x00,  //..%@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0xa8, 0xff, 0xff,  //@@...%@@
    0xff, 0xff, 0x00, 0x00, 0x46, 0xff, 0xff, 0xff,  //@@..+@@@
    0xff, 0xff, 0x00, 0x06, 0xda, 0xff, 0xff, 0xff,  //@@..@@@@
    0xff, 0xff, 0x00, 0x80, 0xff, 0xd8, 0xff, 0xff,  //@@.+@@@@
    0xff, 0xff, 0x24, 0xf6, 0xff, 0x52, 0xff, 0xff,  //@@.@@+@@
    0xff, 0xff, 0xba, 0xff, 0xc6, 0x00, 0xff, 0xff,  //@@%@@.@@
    0xff, 0xff, 0xff, 0xff, 0x3e, 0x00, 0xff, 0xff,  //@@@@..@@
    0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0xff, 0xff,  //@@@%..@@
    0xff, 0xff, 0xfc, 0x2c, 0x00, 0x00, 0xff, 0xff,  //@@@...@@
    0xff, 0xff, 0xa0, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%...@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+043a (к) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x68, 0xfc, 0xff, 0x7a,  //@@...+@@+
    0xff, 0xff, 0x00, 0x00, 0x70, 0xff, 0xff, 0x6e, 0x00,  //@@..+@@+.
    0xff, 0xff, 0x00, 0x7a, 0xff, 0xfc, 0x66, 0x00, 0x00,  //@@.+@@+..
    0xff, 0xff, 0x82, 0xff, 0xff, 0x5e, 0x00, 0x00, 0x00,  //@@%@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0x64, 0x00, 0x00, 0x00,  //@@@@@+...
    0xff, 0xff, 0xf6, 0x90, 0xff, 0xf0, 0x1a, 0x00, 0x00,  //@@@%@@...
    0xff, 0xff, 0x46, 0x00, 0xac, 0xff, 0xb4, 0x00, 0x00,  //@@+.%@%..
    0xff, 0xff, 0x00, 0x00, 0x16, 0xec, 0xff, 0x5c, 0x00,  //@@...@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xec, 0x16,  //@@...+@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xaa,  //@@....%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+043b (л) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //...@@@@@@@
    0x00, 0x00, 0x06, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@...@@
    0x00, 0x00, 0x10, 0xff, 0xf8, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@...@@
    0x00, 0x00, 0x26, 0xff, 0xee, 0x00, 0x00, 0x00, 0xff, 0xff,  //...@@...@@
    0x00, 0x00, 0x50, 0xff, 0xd4, 0x00, 0x00, 0x00, 0xff, 0xff,  //..+@@...@@
    0x00, 0x00, 0x9c, 0xff, 0xa4, 0x00, 0x00, 0x00, 0xff, 0xff,  //..%@%...@@
    0x1a, 0x7c, 0xfc, 0xff, 0x56, 0x00, 0x00, 0x00, 0xff, 0xff,  //.+@@+...@@
    0xff, 0xff, 0xff, 0xb8, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@%....@@
    0xec, 0xbe, 0x66, 0x02, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@%+.....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043c (м) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xff, 0xbc, 0x00, 0x00, 0xbc, 0xff, 0xff, 0xff,  //@@@%..%@@@
    0xff, 0xff, 0xf6, 0xfc, 0x1a, 0x1a, 0xfc, 0xf6, 0xff, 0xff,  //@@@@..@@@@
    0xff, 0xff, 0xaa, 0xff, 0x74, 0x74, 0xff, 0xa8, 0xff, 0xff,  //@@%@++@%@@
    0xff, 0xff, 0x4e, 0xff, 0xd0, 0xd0, 0xff, 0x4c, 0xff, 0xff,  //@@+@@@@+@@
    0xff, 0xff, 0x04, 0xec, 0xff, 0xff, 0xea, 0x04, 0xff, 0xff,  //@@.@@@@.@@
    0xff, 0xff, 0x00, 0x96, 0xff, 0xff, 0x94, 0x00, 0xff, 0xff,  //@@.%@@%.@@
    0xff, 0xff, 0x00, 0x3a, 0xff, 0xff, 0x38, 0x00, 0xff, 0xff,  //@@..@@..@@
    0xff, 0xff, 0x00, 0x00, 0xdc, 0xdc, 0x00, 0x00, 0xff, 0xff,  //@@..@@..@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043d (н) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+043e (о) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x04, 0x76, 0xce, 0xf4, 0xf4, 0xce, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x04,  //.%@@@@@@%.
    0x76, 0xff, 0xee, 0x60, 0x14, 0x14, 0x60, 0xf0, 0xff, 0x74,  //+@@+..+@@+
    0xd0, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xce,  //@@+....+@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xd0, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xce,  //@@+....+@@
    0x76, 0xff, 0xec, 0x5c, 0x12, 0x12, 0x5e, 0xee, 0xff, 0x74,  //+@@+..+@@+
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //.%@@@@@@%.
    0x00, 0x06, 0x76, 0xd0, 0xf6, 0xf4, 0xd0, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+043f (п) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0440 (р) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x08, 0x98, 0xea, 0xf2, 0xae, 0x1e, 0x00,  //@@.%@@%..
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10,  //@@%@@@@@.
    0xff, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x88,  //@@@...@@%
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd4,  //@@+...+@@
    0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd4,  //@@+...+@@
    0xff, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x88,  //@@@...@@%
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10,  //@@%@@@@@.
    0xff, 0xff, 0x0a, 0x9a, 0xec, 0xf2, 0xae, 0x20, 0x00,  //@@.%@@%..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......


    /*Unicode: U+0441 (с) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x02, 0x6e, 0xca, 0xf2, 0xf4, 0xbe, 0x4c,  //..+@@@%+
    0x04, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x72, 0xff, 0xf2, 0x6c, 0x1a, 0x06, 0x38, 0xae,  //+@@+...%
    0xce, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+.....
    0xf4, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xf4, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xce, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+.....
    0x70, 0xff, 0xf0, 0x6a, 0x1a, 0x06, 0x36, 0xae,  //+@@+...%
    0x04, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x04, 0x72, 0xd0, 0xf6, 0xf2, 0xbe, 0x4c,  //..+@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0442 (т) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0443 (у) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x24, 0xfc, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2, 0xfc, 0x26,  //.@@......@@.
    0x00, 0xa8, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xae, 0x00,  //.%@+....+@%.
    0x00, 0x30, 0xff, 0xe4, 0x04, 0x00, 0x00, 0x02, 0xe0, 0xff, 0x38, 0x00,  //..@@....@@..
    0x00, 0x00, 0xb6, 0xff, 0x5e, 0x00, 0x00, 0x56, 0xff, 0xc2, 0x00, 0x00,  //..%@+..+@@..
    0x00, 0x00, 0x3e, 0xff, 0xd0, 0x00, 0x00, 0xc6, 0xff, 0x4c, 0x00, 0x00,  //...@@..@@+..
    0x00, 0x00, 0x00, 0xc4, 0xff, 0x42, 0x36, 0xff, 0xd4, 0x00, 0x00, 0x00,  //...@@+.@@...
    0x00, 0x00, 0x00, 0x4a, 0xff, 0xb6, 0xa8, 0xff, 0x60, 0x00, 0x00, 0x00,  //...+@%%@+...
    0x00, 0x00, 0x00, 0x00, 0xd0, 0xfc, 0xfa, 0xe2, 0x04, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xee, 0x0c, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@%.....
    0x00, 0x00, 0x00, 0x10, 0xba, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@......
    0x00, 0x00, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%......
    0x00, 0x00, 0xff, 0xf6, 0xb6, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@%.......


    /*Unicode: U+0444 (ф) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x2e, 0xc2, 0xf6, 0xcc, 0x30, 0xff, 0xff, 0x32, 0xce, 0xf6, 0xc2, 0x2c, 0x00,  //..@@@.@@.@@@..
    0x1a, 0xec, 0xff, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xff, 0xea, 0x18,  //.@@@@@@@@@@@@.
    0x90, 0xff, 0xc8, 0x28, 0x12, 0xa4, 0xff, 0xff, 0xa2, 0x12, 0x28, 0xca, 0xff, 0x8e,  //%@@..%@@%..@@%
    0xd8, 0xff, 0x38, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xd6,  //@@....@@....@@
    0xf8, 0xff, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xf6,  //@@....@@....@@
    0xf8, 0xff, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xf6,  //@@....@@....@@
    0xdc, 0xff, 0x38, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xda,  //@@....@@....@@
    0x96, 0xff, 0xc8, 0x28, 0x12, 0xa2, 0xff, 0xff, 0xa2, 0x12, 0x28, 0xca, 0xff, 0x94,  //%@@..%@@%..@@%
    0x1e, 0xf0, 0xff, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xe6, 0xff, 0xff, 0xff, 0xee, 0x1c,  //.@@@@@@@@@@@@.
    0x00, 0x32, 0xc6, 0xf6, 0xcc, 0x30, 0xff, 0xff, 0x30, 0xce, 0xf6, 0xc4, 0x30, 0x00,  //..@@@.@@.@@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......@@......


    /*Unicode: U+0445 (х) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xa6, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xa4,  //%@@....@@%
    0x10, 0xe4, 0xff, 0x56, 0x00, 0x00, 0x56, 0xff, 0xde, 0x0e,  //.@@+..+@@.
    0x00, 0x46, 0xff, 0xd6, 0x00, 0x02, 0xd6, 0xfc, 0x3c, 0x00,  //.+@@..@@..
    0x00, 0x00, 0x94, 0xff, 0x5c, 0x5c, 0xff, 0x84, 0x00, 0x00,  //..%@++@%..
    0x00, 0x00, 0x08, 0xda, 0xda, 0xda, 0xce, 0x04, 0x00, 0x00,  //...@@@@...
    0x00, 0x00, 0x16, 0xec, 0xe0, 0xf0, 0xe8, 0x12, 0x00, 0x00,  //...@@@@...
    0x00, 0x00, 0xae, 0xff, 0x5c, 0x76, 0xff, 0xa6, 0x00, 0x00,  //..%@++@%..
    0x00, 0x58, 0xff, 0xd2, 0x00, 0x06, 0xe0, 0xff, 0x52, 0x00,  //.+@@..@@+.
    0x14, 0xea, 0xff, 0x4a, 0x00, 0x00, 0x58, 0xff, 0xe8, 0x12,  //.@@+..+@@.
    0xaa, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xa8,  //%@@....@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0446 (ц) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@.....@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0447 (ч) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xf8, 0xff, 0x18, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xd8, 0xff, 0x92, 0x0a, 0x00, 0x00, 0xff, 0xff,  //@@%...@@
    0x7a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //+@@@@@@@
    0x02, 0x8a, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0448 (ш) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0449 (щ) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //@@...@@...@@..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //............@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+044a (ъ) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...@@......
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xd8, 0x82, 0x08,  //...@@@@@@%.
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x96,  //...@@@@@@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x08, 0x58, 0xff, 0xe6,  //...@@...+@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x08, 0x54, 0xff, 0xf0,  //...@@...+@@
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a,  //...@@@@@@@%
    0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xd2, 0x78, 0x06,  //...@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044b (ы) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.......@@
    0xff, 0xff, 0xff, 0xff, 0xf6, 0xd8, 0x82, 0x08, 0x00, 0xff, 0xff,  //@@@@@@%..@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x96, 0x00, 0xff, 0xff,  //@@@@@@@%.@@
    0xff, 0xff, 0x00, 0x00, 0x08, 0x58, 0xff, 0xe6, 0x00, 0xff, 0xff,  //@@...+@@.@@
    0xff, 0xff, 0x00, 0x00, 0x08, 0x56, 0xff, 0xf0, 0x00, 0xff, 0xff,  //@@...+@@.@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a, 0x00, 0xff, 0xff,  //@@@@@@@%.@@
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xd2, 0x78, 0x06, 0x00, 0xff, 0xff,  //@@@@@@+..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+044c (ь) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xf6, 0xd8, 0x82, 0x08,  //@@@@@@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x96,  //@@@@@@@%
    0xff, 0xff, 0x00, 0x00, 0x08, 0x58, 0xff, 0xe6,  //@@...+@@
    0xff, 0xff, 0x00, 0x00, 0x08, 0x56, 0xff, 0xf0,  //@@...+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9a,  //@@@@@@@%
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xd2, 0x78, 0x06,  //@@@@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+044d (э) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x40, 0xb8, 0xec, 0xf2, 0xca, 0x6c, 0x02, 0x00,  //.%@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x02,  //@@@@@@%.
    0xba, 0x40, 0x0c, 0x0c, 0x48, 0xe2, 0xff, 0x6e,  //%...+@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xcc,  //......@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //.@@@@@@@
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,  //.@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xce,  //......@@
    0xb8, 0x3e, 0x0c, 0x10, 0x48, 0xd4, 0xff, 0x72,  //%...+@@+
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //@@@@@@%.
    0x42, 0xb8, 0xea, 0xf6, 0xd0, 0x76, 0x04, 0x00,  //+%@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+044e (ю) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0x00, 0x00, 0x18, 0x9c, 0xe4, 0xf8, 0xe0, 0x92, 0x12, 0x00,  //@@...%@@@%..
    0xff, 0xff, 0x00, 0x0c, 0xdc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x0c,  //@@..@@@@@@@.
    0xff, 0xff, 0x00, 0x8a, 0xff, 0xe2, 0x40, 0x0c, 0x40, 0xe2, 0xff, 0x82,  //@@.%@@...@@%
    0xff, 0xff, 0x00, 0xdc, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x50, 0xff, 0xd2,  //@@.@@+...+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4,  //@@@@@.....@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf4,  //@@@@@.....@@
    0xff, 0xff, 0x00, 0xee, 0xff, 0x4e, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd2,  //@@.@@+...+@@
    0xff, 0xff, 0x00, 0xac, 0xff, 0xe0, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x82,  //@@.%@@...@@%
    0xff, 0xff, 0x00, 0x26, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x0c,  //@@..@@@@@@@.
    0xff, 0xff, 0x00, 0x00, 0x26, 0xa6, 0xe8, 0xfa, 0xe2, 0x92, 0x12, 0x00,  //@@...%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+044f (я) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x08, 0x7e, 0xd4, 0xf2, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@
    0x00, 0x9a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@
    0x00, 0xea, 0xff, 0x80, 0x0e, 0x00, 0x00, 0xff, 0xff,  //.@@+...@@
    0x00, 0xe6, 0xff, 0x0a, 0x00, 0x00, 0x00, 0xff, 0xff,  //.@@....@@
    0x00, 0x7c, 0xff, 0x80, 0x0e, 0x00, 0x00, 0xff, 0xff,  //.+@+...@@
    0x00, 0x00, 0x46, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@
    0x00, 0x00, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..+@@@@@@
    0x00, 0x22, 0xee, 0xff, 0x70, 0x00, 0x00, 0xff, 0xff,  //..@@+..@@
    0x08, 0xce, 0xff, 0xaa, 0x00, 0x00, 0x00, 0xff, 0xff,  //.@@%...@@
    0x9c, 0xff, 0xd8, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff,  //%@@....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_20_cyrillic_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_20_CYRILLIC == 1
    {.w_px = 12,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 9,   .glyph_index = 40}, /*Unicode: U+0411 (Б)*/
    {.w_px = 9,   .glyph_index = 80}, /*Unicode: U+0412 (В)*/
    {.w_px = 8,   .glyph_index = 120},    /*Unicode: U+0413 (Г)*/
    {.w_px = 12,  .glyph_index = 140},    /*Unicode: U+0414 (Д)*/
    {.w_px = 8,   .glyph_index = 180},    /*Unicode: U+0415 (Е)*/
    {.w_px = 18,  .glyph_index = 200},    /*Unicode: U+0416 (Ж)*/
    {.w_px = 9,   .glyph_index = 260},    /*Unicode: U+0417 (З)*/
    {.w_px = 10,  .glyph_index = 300},    /*Unicode: U+0418 (И)*/
    {.w_px = 10,  .glyph_index = 340},    /*Unicode: U+0419 (Й)*/
    {.w_px = 11,  .glyph_index = 380},    /*Unicode: U+041a (К)*/
    {.w_px = 11,  .glyph_index = 420},    /*Unicode: U+041b (Л)*/
    {.w_px = 12,  .glyph_index = 460},    /*Unicode: U+041c (М)*/
    {.w_px = 10,  .glyph_index = 500},    /*Unicode: U+041d (Н)*/
    {.w_px = 12,  .glyph_index = 540},    /*Unicode: U+041e (О)*/
    {.w_px = 10,  .glyph_index = 580},    /*Unicode: U+041f (П)*/
    {.w_px = 8,   .glyph_index = 620},    /*Unicode: U+0420 (Р)*/
    {.w_px = 11,  .glyph_index = 640},    /*Unicode: U+0421 (С)*/
    {.w_px = 12,  .glyph_index = 680},    /*Unicode: U+0422 (Т)*/
    {.w_px = 10,  .glyph_index = 720},    /*Unicode: U+0423 (У)*/
    {.w_px = 14,  .glyph_index = 760},    /*Unicode: U+0424 (Ф)*/
    {.w_px = 11,  .glyph_index = 800},    /*Unicode: U+0425 (Х)*/
    {.w_px = 12,  .glyph_index = 840},    /*Unicode: U+0426 (Ц)*/
    {.w_px = 9,   .glyph_index = 880},    /*Unicode: U+0427 (Ч)*/
    {.w_px = 16,  .glyph_index = 920},    /*Unicode: U+0428 (Ш)*/
    {.w_px = 18,  .glyph_index = 960},    /*Unicode: U+0429 (Щ)*/
    {.w_px = 12,  .glyph_index = 1020},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 13,  .glyph_index = 1060},   /*Unicode: U+042b (Ы)*/
    {.w_px = 9,   .glyph_index = 1100},   /*Unicode: U+042c (Ь)*/
    {.w_px = 11,  .glyph_index = 1140},   /*Unicode: U+042d (Э)*/
    {.w_px = 16,  .glyph_index = 1180},   /*Unicode: U+042e (Ю)*/
    {.w_px = 9,   .glyph_index = 1220},   /*Unicode: U+042f (Я)*/
    {.w_px = 8,   .glyph_index = 1260},   /*Unicode: U+0430 (а)*/
    {.w_px = 11,  .glyph_index = 1280},   /*Unicode: U+0431 (б)*/
    {.w_px = 8,   .glyph_index = 1320},   /*Unicode: U+0432 (в)*/
    {.w_px = 7,   .glyph_index = 1340},   /*Unicode: U+0433 (г)*/
    {.w_px = 11,  .glyph_index = 1360},   /*Unicode: U+0434 (д)*/
    {.w_px = 10,  .glyph_index = 1400},   /*Unicode: U+0435 (е)*/
    {.w_px = 14,  .glyph_index = 1440},   /*Unicode: U+0436 (ж)*/
    {.w_px = 7,   .glyph_index = 1480},   /*Unicode: U+0437 (з)*/
    {.w_px = 8,   .glyph_index = 1500},   /*Unicode: U+0438 (и)*/
    {.w_px = 8,   .glyph_index = 1520},   /*Unicode: U+0439 (й)*/
    {.w_px = 9,   .glyph_index = 1540},   /*Unicode: U+043a (к)*/
    {.w_px = 10,  .glyph_index = 1580},   /*Unicode: U+043b (л)*/
    {.w_px = 10,  .glyph_index = 1620},   /*Unicode: U+043c (м)*/
    {.w_px = 9,   .glyph_index = 1660},   /*Unicode: U+043d (н)*/
    {.w_px = 10,  .glyph_index = 1700},   /*Unicode: U+043e (о)*/
    {.w_px = 9,   .glyph_index = 1740},   /*Unicode: U+043f (п)*/
    {.w_px = 9,   .glyph_index = 1780},   /*Unicode: U+0440 (р)*/
    {.w_px = 8,   .glyph_index = 1820},   /*Unicode: U+0441 (с)*/
    {.w_px = 10,  .glyph_index = 1840},   /*Unicode: U+0442 (т)*/
    {.w_px = 12,  .glyph_index = 1880},   /*Unicode: U+0443 (у)*/
    {.w_px = 14,  .glyph_index = 1920},   /*Unicode: U+0444 (ф)*/
    {.w_px = 10,  .glyph_index = 1960},   /*Unicode: U+0445 (х)*/
    {.w_px = 11,  .glyph_index = 2000},   /*Unicode: U+0446 (ц)*/
    {.w_px = 8,   .glyph_index = 2040},   /*Unicode: U+0447 (ч)*/
    {.w_px = 12,  .glyph_index = 2060},   /*Unicode: U+0448 (ш)*/
    {.w_px = 14,  .glyph_index = 2100},   /*Unicode: U+0449 (щ)*/
    {.w_px = 11,  .glyph_index = 2140},   /*Unicode: U+044a (ъ)*/
    {.w_px = 11,  .glyph_index = 2180},   /*Unicode: U+044b (ы)*/
    {.w_px = 8,   .glyph_index = 2220},   /*Unicode: U+044c (ь)*/
    {.w_px = 8,   .glyph_index = 2240},   /*Unicode: U+044d (э)*/
    {.w_px = 12,  .glyph_index = 2260},   /*Unicode: U+044e (ю)*/
    {.w_px = 9,   .glyph_index = 2300},   /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 2
    {.w_px = 12,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 9,   .glyph_index = 60}, /*Unicode: U+0411 (Б)*/
    {.w_px = 9,   .glyph_index = 120},    /*Unicode: U+0412 (В)*/
    {.w_px = 8,   .glyph_index = 180},    /*Unicode: U+0413 (Г)*/
    {.w_px = 12,  .glyph_index = 220},    /*Unicode: U+0414 (Д)*/
    {.w_px = 8,   .glyph_index = 280},    /*Unicode: U+0415 (Е)*/
    {.w_px = 18,  .glyph_index = 320},    /*Unicode: U+0416 (Ж)*/
    {.w_px = 9,   .glyph_index = 420},    /*Unicode: U+0417 (З)*/
    {.w_px = 10,  .glyph_index = 480},    /*Unicode: U+0418 (И)*/
    {.w_px = 10,  .glyph_index = 540},    /*Unicode: U+0419 (Й)*/
    {.w_px = 11,  .glyph_index = 600},    /*Unicode: U+041a (К)*/
    {.w_px = 11,  .glyph_index = 660},    /*Unicode: U+041b (Л)*/
    {.w_px = 12,  .glyph_index = 720},    /*Unicode: U+041c (М)*/
    {.w_px = 10,  .glyph_index = 780},    /*Unicode: U+041d (Н)*/
    {.w_px = 12,  .glyph_index = 840},    /*Unicode: U+041e (О)*/
    {.w_px = 10,  .glyph_index = 900},    /*Unicode: U+041f (П)*/
    {.w_px = 8,   .glyph_index = 960},    /*Unicode: U+0420 (Р)*/
    {.w_px = 11,  .glyph_index = 1000},   /*Unicode: U+0421 (С)*/
    {.w_px = 12,  .glyph_index = 1060},   /*Unicode: U+0422 (Т)*/
    {.w_px = 10,  .glyph_index = 1120},   /*Unicode: U+0423 (У)*/
    {.w_px = 14,  .glyph_index = 1180},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 11,  .glyph_index = 1260},   /*Unicode: U+0425 (Х)*/
    {.w_px = 12,  .glyph_index = 1320},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 9,   .glyph_index = 1380},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 16,  .glyph_index = 1440},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 18,  .glyph_index = 1520},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 12,  .glyph_index = 1620},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 13,  .glyph_index = 1680},   /*Unicode: U+042b (Ы)*/
    {.w_px = 9,   .glyph_index = 1760},   /*Unicode: U+042c (Ь)*/
    {.w_px = 11,  .glyph_index = 1820},   /*Unicode: U+042d (Э)*/
    {.w_px = 16,  .glyph_index = 1880},   /*Unicode: U+042e (Ю)*/
    {.w_px = 9,   .glyph_index = 1960},   /*Unicode: U+042f (Я)*/
    {.w_px = 8,   .glyph_index = 2020},   /*Unicode: U+0430 (а)*/
    {.w_px = 11,  .glyph_index = 2060},   /*Unicode: U+0431 (б)*/
    {.w_px = 8,   .glyph_index = 2120},   /*Unicode: U+0432 (в)*/
    {.w_px = 7,   .glyph_index = 2160},   /*Unicode: U+0433 (г)*/
    {.w_px = 11,  .glyph_index = 2200},   /*Unicode: U+0434 (д)*/
    {.w_px = 10,  .glyph_index = 2260},   /*Unicode: U+0435 (е)*/
    {.w_px = 14,  .glyph_index = 2320},   /*Unicode: U+0436 (ж)*/
    {.w_px = 7,   .glyph_index = 2400},   /*Unicode: U+0437 (з)*/
    {.w_px = 8,   .glyph_index = 2440},   /*Unicode: U+0438 (и)*/
    {.w_px = 8,   .glyph_index = 2480},   /*Unicode: U+0439 (й)*/
    {.w_px = 9,   .glyph_index = 2520},   /*Unicode: U+043a (к)*/
    {.w_px = 10,  .glyph_index = 2580},   /*Unicode: U+043b (л)*/
    {.w_px = 10,  .glyph_index = 2640},   /*Unicode: U+043c (м)*/
    {.w_px = 9,   .glyph_index = 2700},   /*Unicode: U+043d (н)*/
    {.w_px = 10,  .glyph_index = 2760},   /*Unicode: U+043e (о)*/
    {.w_px = 9,   .glyph_index = 2820},   /*Unicode: U+043f (п)*/
    {.w_px = 9,   .glyph_index = 2880},   /*Unicode: U+0440 (р)*/
    {.w_px = 8,   .glyph_index = 2940},   /*Unicode: U+0441 (с)*/
    {.w_px = 10,  .glyph_index = 2980},   /*Unicode: U+0442 (т)*/
    {.w_px = 12,  .glyph_index = 3040},   /*Unicode: U+0443 (у)*/
    {.w_px = 14,  .glyph_index = 3100},   /*Unicode: U+0444 (ф)*/
    {.w_px = 10,  .glyph_index = 3180},   /*Unicode: U+0445 (х)*/
    {.w_px = 11,  .glyph_index = 3240},   /*Unicode: U+0446 (ц)*/
    {.w_px = 8,   .glyph_index = 3300},   /*Unicode: U+0447 (ч)*/
    {.w_px = 12,  .glyph_index = 3340},   /*Unicode: U+0448 (ш)*/
    {.w_px = 14,  .glyph_index = 3400},   /*Unicode: U+0449 (щ)*/
    {.w_px = 11,  .glyph_index = 3480},   /*Unicode: U+044a (ъ)*/
    {.w_px = 11,  .glyph_index = 3540},   /*Unicode: U+044b (ы)*/
    {.w_px = 8,   .glyph_index = 3600},   /*Unicode: U+044c (ь)*/
    {.w_px = 8,   .glyph_index = 3640},   /*Unicode: U+044d (э)*/
    {.w_px = 12,  .glyph_index = 3680},   /*Unicode: U+044e (ю)*/
    {.w_px = 9,   .glyph_index = 3740},   /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 4
    {.w_px = 12,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 9,   .glyph_index = 120},    /*Unicode: U+0411 (Б)*/
    {.w_px = 9,   .glyph_index = 220},    /*Unicode: U+0412 (В)*/
    {.w_px = 8,   .glyph_index = 320},    /*Unicode: U+0413 (Г)*/
    {.w_px = 12,  .glyph_index = 400},    /*Unicode: U+0414 (Д)*/
    {.w_px = 8,   .glyph_index = 520},    /*Unicode: U+0415 (Е)*/
    {.w_px = 18,  .glyph_index = 600},    /*Unicode: U+0416 (Ж)*/
    {.w_px = 9,   .glyph_index = 780},    /*Unicode: U+0417 (З)*/
    {.w_px = 10,  .glyph_index = 880},    /*Unicode: U+0418 (И)*/
    {.w_px = 10,  .glyph_index = 980},    /*Unicode: U+0419 (Й)*/
    {.w_px = 11,  .glyph_index = 1080},   /*Unicode: U+041a (К)*/
    {.w_px = 11,  .glyph_index = 1200},   /*Unicode: U+041b (Л)*/
    {.w_px = 12,  .glyph_index = 1320},   /*Unicode: U+041c (М)*/
    {.w_px = 10,  .glyph_index = 1440},   /*Unicode: U+041d (Н)*/
    {.w_px = 12,  .glyph_index = 1540},   /*Unicode: U+041e (О)*/
    {.w_px = 10,  .glyph_index = 1660},   /*Unicode: U+041f (П)*/
    {.w_px = 8,   .glyph_index = 1760},   /*Unicode: U+0420 (Р)*/
    {.w_px = 11,  .glyph_index = 1840},   /*Unicode: U+0421 (С)*/
    {.w_px = 12,  .glyph_index = 1960},   /*Unicode: U+0422 (Т)*/
    {.w_px = 10,  .glyph_index = 2080},   /*Unicode: U+0423 (У)*/
    {.w_px = 14,  .glyph_index = 2180},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 11,  .glyph_index = 2320},   /*Unicode: U+0425 (Х)*/
    {.w_px = 12,  .glyph_index = 2440},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 9,   .glyph_index = 2560},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 16,  .glyph_index = 2660},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 18,  .glyph_index = 2820},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 12,  .glyph_index = 3000},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 13,  .glyph_index = 3120},   /*Unicode: U+042b (Ы)*/
    {.w_px = 9,   .glyph_index = 3260},   /*Unicode: U+042c (Ь)*/
    {.w_px = 11,  .glyph_index = 3360},   /*Unicode: U+042d (Э)*/
    {.w_px = 16,  .glyph_index = 3480},   /*Unicode: U+042e (Ю)*/
    {.w_px = 9,   .glyph_index = 3640},   /*Unicode: U+042f (Я)*/
    {.w_px = 8,   .glyph_index = 3740},   /*Unicode: U+0430 (а)*/
    {.w_px = 11,  .glyph_index = 3820},   /*Unicode: U+0431 (б)*/
    {.w_px = 8,   .glyph_index = 3940},   /*Unicode: U+0432 (в)*/
    {.w_px = 7,   .glyph_index = 4020},   /*Unicode: U+0433 (г)*/
    {.w_px = 11,  .glyph_index = 4100},   /*Unicode: U+0434 (д)*/
    {.w_px = 10,  .glyph_index = 4220},   /*Unicode: U+0435 (е)*/
    {.w_px = 14,  .glyph_index = 4320},   /*Unicode: U+0436 (ж)*/
    {.w_px = 7,   .glyph_index = 4460},   /*Unicode: U+0437 (з)*/
    {.w_px = 8,   .glyph_index = 4540},   /*Unicode: U+0438 (и)*/
    {.w_px = 8,   .glyph_index = 4620},   /*Unicode: U+0439 (й)*/
    {.w_px = 9,   .glyph_index = 4700},   /*Unicode: U+043a (к)*/
    {.w_px = 10,  .glyph_index = 4800},   /*Unicode: U+043b (л)*/
    {.w_px = 10,  .glyph_index = 4900},   /*Unicode: U+043c (м)*/
    {.w_px = 9,   .glyph_index = 5000},   /*Unicode: U+043d (н)*/
    {.w_px = 10,  .glyph_index = 5100},   /*Unicode: U+043e (о)*/
    {.w_px = 9,   .glyph_index = 5200},   /*Unicode: U+043f (п)*/
    {.w_px = 9,   .glyph_index = 5300},   /*Unicode: U+0440 (р)*/
    {.w_px = 8,   .glyph_index = 5400},   /*Unicode: U+0441 (с)*/
    {.w_px = 10,  .glyph_index = 5480},   /*Unicode: U+0442 (т)*/
    {.w_px = 12,  .glyph_index = 5580},   /*Unicode: U+0443 (у)*/
    {.w_px = 14,  .glyph_index = 5700},   /*Unicode: U+0444 (ф)*/
    {.w_px = 10,  .glyph_index = 5840},   /*Unicode: U+0445 (х)*/
    {.w_px = 11,  .glyph_index = 5940},   /*Unicode: U+0446 (ц)*/
    {.w_px = 8,   .glyph_index = 6060},   /*Unicode: U+0447 (ч)*/
    {.w_px = 12,  .glyph_index = 6140},   /*Unicode: U+0448 (ш)*/
    {.w_px = 14,  .glyph_index = 6260},   /*Unicode: U+0449 (щ)*/
    {.w_px = 11,  .glyph_index = 6400},   /*Unicode: U+044a (ъ)*/
    {.w_px = 11,  .glyph_index = 6520},   /*Unicode: U+044b (ы)*/
    {.w_px = 8,   .glyph_index = 6640},   /*Unicode: U+044c (ь)*/
    {.w_px = 8,   .glyph_index = 6720},   /*Unicode: U+044d (э)*/
    {.w_px = 12,  .glyph_index = 6800},   /*Unicode: U+044e (ю)*/
    {.w_px = 9,   .glyph_index = 6920},   /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 8
    {.w_px = 12,  .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 9,   .glyph_index = 240},    /*Unicode: U+0411 (Б)*/
    {.w_px = 9,   .glyph_index = 420},    /*Unicode: U+0412 (В)*/
    {.w_px = 8,   .glyph_index = 600},    /*Unicode: U+0413 (Г)*/
    {.w_px = 12,  .glyph_index = 760},    /*Unicode: U+0414 (Д)*/
    {.w_px = 8,   .glyph_index = 1000},   /*Unicode: U+0415 (Е)*/
    {.w_px = 18,  .glyph_index = 1160},   /*Unicode: U+0416 (Ж)*/
    {.w_px = 9,   .glyph_index = 1520},   /*Unicode: U+0417 (З)*/
    {.w_px = 10,  .glyph_index = 1700},   /*Unicode: U+0418 (И)*/
    {.w_px = 10,  .glyph_index = 1900},   /*Unicode: U+0419 (Й)*/
    {.w_px = 11,  .glyph_index = 2100},   /*Unicode: U+041a (К)*/
    {.w_px = 11,  .glyph_index = 2320},   /*Unicode: U+041b (Л)*/
    {.w_px = 12,  .glyph_index = 2540},   /*Unicode: U+041c (М)*/
    {.w_px = 10,  .glyph_index = 2780},   /*Unicode: U+041d (Н)*/
    {.w_px = 12,  .glyph_index = 2980},   /*Unicode: U+041e (О)*/
    {.w_px = 10,  .glyph_index = 3220},   /*Unicode: U+041f (П)*/
    {.w_px = 8,   .glyph_index = 3420},   /*Unicode: U+0420 (Р)*/
    {.w_px = 11,  .glyph_index = 3580},   /*Unicode: U+0421 (С)*/
    {.w_px = 12,  .glyph_index = 3800},   /*Unicode: U+0422 (Т)*/
    {.w_px = 10,  .glyph_index = 4040},   /*Unicode: U+0423 (У)*/
    {.w_px = 14,  .glyph_index = 4240},   /*Unicode: U+0424 (Ф)*/
    {.w_px = 11,  .glyph_index = 4520},   /*Unicode: U+0425 (Х)*/
    {.w_px = 12,  .glyph_index = 4740},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 9,   .glyph_index = 4980},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 16,  .glyph_index = 5160},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 18,  .glyph_index = 5480},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 12,  .glyph_index = 5840},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 13,  .glyph_index = 6080},   /*Unicode: U+042b (Ы)*/
    {.w_px = 9,   .glyph_index = 6340},   /*Unicode: U+042c (Ь)*/
    {.w_px = 11,  .glyph_index = 6520},   /*Unicode: U+042d (Э)*/
    {.w_px = 16,  .glyph_index = 6740},   /*Unicode: U+042e (Ю)*/
    {.w_px = 9,   .glyph_index = 7060},   /*Unicode: U+042f (Я)*/
    {.w_px = 8,   .glyph_index = 7240},   /*Unicode: U+0430 (а)*/
    {.w_px = 11,  .glyph_index = 7400},   /*Unicode: U+0431 (б)*/
    {.w_px = 8,   .glyph_index = 7620},   /*Unicode: U+0432 (в)*/
    {.w_px = 7,   .glyph_index = 7780},   /*Unicode: U+0433 (г)*/
    {.w_px = 11,  .glyph_index = 7920},   /*Unicode: U+0434 (д)*/
    {.w_px = 10,  .glyph_index = 8140},   /*Unicode: U+0435 (е)*/
    {.w_px = 14,  .glyph_index = 8340},   /*Unicode: U+0436 (ж)*/
    {.w_px = 7,   .glyph_index = 8620},   /*Unicode: U+0437 (з)*/
    {.w_px = 8,   .glyph_index = 8760},   /*Unicode: U+0438 (и)*/
    {.w_px = 8,   .glyph_index = 8920},   /*Unicode: U+0439 (й)*/
    {.w_px = 9,   .glyph_index = 9080},   /*Unicode: U+043a (к)*/
    {.w_px = 10,  .glyph_index = 9260},   /*Unicode: U+043b (л)*/
    {.w_px = 10,  .glyph_index = 9460},   /*Unicode: U+043c (м)*/
    {.w_px = 9,   .glyph_index = 9660},   /*Unicode: U+043d (н)*/
    {.w_px = 10,  .glyph_index = 9840},   /*Unicode: U+043e (о)*/
    {.w_px = 9,   .glyph_index = 10040},  /*Unicode: U+043f (п)*/
    {.w_px = 9,   .glyph_index = 10220},  /*Unicode: U+0440 (р)*/
    {.w_px = 8,   .glyph_index = 10400},  /*Unicode: U+0441 (с)*/
    {.w_px = 10,  .glyph_index = 10560},  /*Unicode: U+0442 (т)*/
    {.w_px = 12,  .glyph_index = 10760},  /*Unicode: U+0443 (у)*/
    {.w_px = 14,  .glyph_index = 11000},  /*Unicode: U+0444 (ф)*/
    {.w_px = 10,  .glyph_index = 11280},  /*Unicode: U+0445 (х)*/
    {.w_px = 11,  .glyph_index = 11480},  /*Unicode: U+0446 (ц)*/
    {.w_px = 8,   .glyph_index = 11700},  /*Unicode: U+0447 (ч)*/
    {.w_px = 12,  .glyph_index = 11860},  /*Unicode: U+0448 (ш)*/
    {.w_px = 14,  .glyph_index = 12100},  /*Unicode: U+0449 (щ)*/
    {.w_px = 11,  .glyph_index = 12380},  /*Unicode: U+044a (ъ)*/
    {.w_px = 11,  .glyph_index = 12600},  /*Unicode: U+044b (ы)*/
    {.w_px = 8,   .glyph_index = 12820},  /*Unicode: U+044c (ь)*/
    {.w_px = 8,   .glyph_index = 12980},  /*Unicode: U+044d (э)*/
    {.w_px = 12,  .glyph_index = 13140},  /*Unicode: U+044e (ю)*/
    {.w_px = 9,   .glyph_index = 13380},  /*Unicode: U+044f (я)*/

#endif
};

lv_font_t lv_font_dejavu_20_cyrillic = {
    .unicode_first = 1040,  /*First Unicode letter in this font*/
    .unicode_last = 1103,   /*Last Unicode letter in this font*/
    .h_px = 20,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_20_cyrillic_glyph_bitmap,    /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_20_cyrillic_glyph_dsc,      /*Description of glyphs*/
    .glyph_cnt = 64,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_20_CYRILLIC == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20_CYRILLIC == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_20_CYRILLIC*/
