
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_20 != 0  /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 20 px Font in U+0020 ( ) .. U+007e (~)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_20_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_20 == 1
    /*Unicode: U+0020 ( ) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+0021 (!) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0022 (") , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xcc,  //@@..@@
    0xcc,  //@@..@@
    0xcc,  //@@..@@
    0xcc,  //@@..@@
    0xcc,  //@@..@@
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+0023 (#) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x04, 0x40,  //.....@..+@..
    0x04, 0x40,  //....+@..+@..
    0x0c, 0xc0,  //....%@..%%..
    0x0c, 0x80,  //....@%..@+..
    0x7f, 0xf0,  //.@@@@@@@@@@@
    0x7f, 0xf0,  //.@@@@@@@@@@@
    0x09, 0x80,  //...+@..%@...
    0x19, 0x00,  //...@%..@+...
    0xff, 0xe0,  //@@@@@@@@@@@.
    0xff, 0xe0,  //@@@@@@@@@@@.
    0x13, 0x00,  //..+@..%@....
    0x33, 0x00,  //..%%..%%....
    0x32, 0x00,  //..@%..@+....
    0x22, 0x00,  //..@+..@.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0024 ($) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x08, 0x00,  //....@....
    0x08, 0x00,  //....@....
    0x3e, 0x00,  //.+%@@@%..
    0x7f, 0x00,  //+@@@@@@@.
    0xe9, 0x00,  //@@%.@.+@.
    0xc8, 0x00,  //@@..@....
    0xf8, 0x00,  //%@@%@....
    0x7e, 0x00,  //.@@@@@@+.
    0x0f, 0x00,  //...+@@@@+
    0x09, 0x80,  //....@.+@@
    0x09, 0x80,  //....@..@@
    0x8b, 0x80,  //@+..@.%@@
    0xff, 0x00,  //@@@@@@@@+
    0x7e, 0x00,  //.%@@@@%+.
    0x08, 0x00,  //....@....
    0x08, 0x00,  //....@....
    0x08, 0x00,  //....@....
    0x00, 0x00,  //.........


    /*Unicode: U+0025 (%) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x78, 0x10,  //.%@@%.....+@...
    0x48, 0x20,  //+@++@+....@....
    0xcc, 0x60,  //@@..@@...%%....
    0xcc, 0x40,  //@@..@@...@.....
    0xcc, 0x80,  //@@..@@..@+.....
    0xc8, 0x80,  //+@++@+.+%......
    0x79, 0x3c,  //.%@@%..@..%@@%.
    0x02, 0x24,  //......%+.+@++@+
    0x02, 0x66,  //.....+@..@@..@@
    0x04, 0x66,  //.....@...@@..@@
    0x0c, 0x66,  //....%%...@@..@@
    0x08, 0x24,  //....@....+@++@+
    0x10, 0x3c,  //...@+.....%@@%.
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0026 (&) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x0f, 0x00,  //...+@@@%+...
    0x1f, 0x80,  //..+@@@@@@...
    0x30, 0x80,  //..@@+..+%...
    0x30, 0x00,  //..@@........
    0x38, 0x00,  //..%@%.......
    0x3c, 0x00,  //..%@@%......
    0x7e, 0x60,  //.%@%@@%..@@.
    0xc7, 0x60,  //%@+.+@@%+@%.
    0xc3, 0xc0,  //@@...+@@@@..
    0xc1, 0x80,  //@@+...+@@+..
    0xe1, 0xc0,  //%@@+..+@@%..
    0x7f, 0xe0,  //.@@@@@@@@@%.
    0x3e, 0x70,  //..%@@@%.+@@%
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0027 (') , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0028 (() , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x30,  //..%@
    0x20,  //..@+
    0x60,  //.%@.
    0x60,  //.@%.
    0x40,  //+@+.
    0xc0,  //%@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //%@..
    0x40,  //+@+.
    0x60,  //.@%.
    0x60,  //.%@.
    0x20,  //..@+
    0x30,  //..%@
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0029 ()) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xc0,  //@%..
    0x40,  //+@..
    0x60,  //.@%.
    0x60,  //.%@.
    0x20,  //.+@+
    0x30,  //..@%
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@%
    0x20,  //.+@+
    0x60,  //.%@.
    0x60,  //.@%.
    0x40,  //+@..
    0xc0,  //@%..
    0x00,  //....
    0x00,  //....


    /*Unicode: U+002a (*) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x10,  //...@...
    0x92,  //%..@..%
    0x54,  //+@+@+@+
    0x38,  //..@@@..
    0x38,  //..@@@..
    0x54,  //+@+@+@+
    0x92,  //%..@..%
    0x10,  //...@...
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+002b (+) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+002c (,) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x60,  //.@@
    0x60,  //.@@
    0x40,  //+@.
    0x80,  //@+.
    0x00,  //...
    0x00,  //...


    /*Unicode: U+002d (-) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf8,  //@@@@@
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+002e (.) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002f (/) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x0c,  //....@@
    0x0c,  //...+@%
    0x18,  //...%@+
    0x18,  //...@@.
    0x18,  //...@@.
    0x38,  //..+@%.
    0x30,  //..@@+.
    0x30,  //..@@..
    0x30,  //.+@@..
    0x70,  //.%@%..
    0x60,  //.@@+..
    0x60,  //.@@...
    0x60,  //+@%...
    0xc0,  //%@+...
    0xc0,  //@@....
    0x00,  //......
    0x00,  //......


    /*Unicode: U+0030 (0) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x1c, 0x00,  //..+@@@+..
    0x7f, 0x00,  //.%@@@@@%.
    0x63, 0x00,  //+@@+.+@@+
    0xc1, 0x80,  //%@+...+@%
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //%@+...+@%
    0x63, 0x00,  //+@@+.+@@+
    0x7f, 0x00,  //.%@@@@@%.
    0x3e, 0x00,  //..+@@@+..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0031 (1) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x38,  //.+@@@...
    0xf8,  //@@@@@...
    0x98,  //@+.@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0032 (2) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x7c, 0x00,  //.%@@@%...
    0xfe, 0x00,  //@@@@@@@+.
    0x87, 0x00,  //@+...@@@.
    0x03, 0x00,  //......@@.
    0x03, 0x00,  //......@@.
    0x06, 0x00,  //.....%@+.
    0x06, 0x00,  //....+@@..
    0x0c, 0x00,  //...+@@...
    0x18, 0x00,  //..+@@+...
    0x30, 0x00,  //.+@@+....
    0x60, 0x00,  //+@@+.....
    0xff, 0x00,  //@@@@@@@@.
    0xff, 0x00,  //@@@@@@@@.
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0033 (3) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x7e, 0x00,  //.%@@@@%..
    0xff, 0x00,  //@@@@@@@@+
    0x83, 0x80,  //@+....%@@
    0x01, 0x80,  //.......@@
    0x03, 0x80,  //......%@%
    0x3e, 0x00,  //..@@@@@+.
    0x3f, 0x00,  //..@@@@@%.
    0x03, 0x80,  //.....+@@%
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x83, 0x80,  //%+...+@@%
    0xff, 0x00,  //@@@@@@@@.
    0x7e, 0x00,  //.%@@@@%..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0034 (4) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x07, 0x00,  //.....%@@..
    0x07, 0x00,  //....+@@@..
    0x0b, 0x00,  //....@+@@..
    0x1b, 0x00,  //...%@.@@..
    0x13, 0x00,  //..+@..@@..
    0x23, 0x00,  //..@+..@@..
    0x63, 0x00,  //.@@...@@..
    0x43, 0x00,  //+@....@@..
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0x03, 0x00,  //......@@..
    0x03, 0x00,  //......@@..
    0x03, 0x00,  //......@@..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0035 (5) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x7e,  //.@@@@@@.
    0x7e,  //.@@@@@@.
    0x60,  //.@@.....
    0x60,  //.@@.....
    0x7c,  //.@@@@@..
    0x7e,  //.@@@@@@.
    0x47,  //.%...@@%
    0x03,  //......@@
    0x03,  //......@@
    0x03,  //......@@
    0x87,  //%...+@@%
    0xfe,  //@@@@@@@.
    0x7c,  //.%@@@%..
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0036 (6) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x1e, 0x00,  //...%@@@+.
    0x3f, 0x00,  //.+@@@@@@.
    0x71, 0x00,  //.@@%...%.
    0xe0, 0x00,  //+@@......
    0xc0, 0x00,  //@@+......
    0xde, 0x00,  //@@.%@@%..
    0xff, 0x00,  //@@%@@@@@.
    0xe3, 0x80,  //@@%...%@%
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //%@.....@@
    0x63, 0x80,  //+@%...%@%
    0x7f, 0x00,  //.%@@@@@@.
    0x1e, 0x00,  //..+@@@%..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0037 (7) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x06,  //.....%@+
    0x06,  //.....@@.
    0x06,  //....+@@.
    0x0c,  //....%@+.
    0x0c,  //....@@..
    0x0c,  //....@@..
    0x1c,  //...%@%..
    0x18,  //...@@...
    0x18,  //...@@...
    0x38,  //..%@%...
    0x30,  //..@@+...
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0038 (8) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x3e, 0x00,  //.+%@@@%+.
    0x7f, 0x00,  //+@@@@@@@+
    0xe3, 0x80,  //@@%...%@@
    0xc1, 0x80,  //@@.....@@
    0xe3, 0x80,  //%@%...%@%
    0x3e, 0x00,  //.+@@@@@+.
    0x7f, 0x00,  //.%@@@@@%.
    0xe3, 0x80,  //%@%...%@%
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xe3, 0x80,  //@@%...%@@
    0x7f, 0x00,  //+@@@@@@@+
    0x3e, 0x00,  //..%@@@%..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0039 (9) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x3c, 0x00,  //..%@@@+..
    0x7f, 0x00,  //.@@@@@@%.
    0xe3, 0x00,  //%@%...%@.
    0xc1, 0x80,  //@@.....@%
    0xc1, 0x80,  //@@.....@@
    0xe3, 0x80,  //%@%...%@@
    0x7f, 0x80,  //.@@@@@%@@
    0x3d, 0x80,  //..%@@%.@@
    0x01, 0x80,  //......+@@
    0x03, 0x00,  //......@@+
    0x47, 0x00,  //.%...%@@.
    0x7e, 0x00,  //.@@@@@@+.
    0x3c, 0x00,  //.+@@@%...
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+003a (:) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+003b (;) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x60,  //.@@
    0x60,  //.@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x60,  //.@@
    0x60,  //.@@
    0x40,  //+@.
    0x80,  //@+.
    0x00,  //...
    0x00,  //...


    /*Unicode: U+003c (<) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x20,  //.........+@
    0x01, 0xe0,  //.......%@@@
    0x07, 0xc0,  //....+@@@@%+
    0x3e, 0x00,  //.+%@@@@+...
    0xf8, 0x00,  //@@@@%+.....
    0xf8, 0x00,  //@@@@%+.....
    0x3e, 0x00,  //.+%@@@@+...
    0x07, 0xc0,  //....+@@@@%+
    0x01, 0xe0,  //......+%@@@
    0x00, 0x20,  //.........+@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+003d (=) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+003e (>) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x80, 0x00,  //@+.........
    0xf0, 0x00,  //@@@%.......
    0x7c, 0x00,  //+%@@@@+....
    0x0f, 0x80,  //...+@@@@%+.
    0x03, 0xe0,  //.....+%@@@@
    0x03, 0xe0,  //.....+%@@@@
    0x0f, 0x80,  //...+@@@@%+.
    0x7c, 0x00,  //+%@@@@+....
    0xf0, 0x00,  //@@@%+......
    0x80, 0x00,  //@+.........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+003f (?) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x78,  //.%@@@+.
    0xfc,  //@@@@@@+
    0x8e,  //@+..%@@
    0x06,  //.....@@
    0x06,  //....+@%
    0x0c,  //....@@.
    0x18,  //...@@..
    0x30,  //..@@...
    0x30,  //..@@...
    0x30,  //..@@...
    0x00,  //.......
    0x30,  //..@@...
    0x30,  //..@@...
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0040 (@) , Width: 16 */
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x00, 0x00,  //................
    0x07, 0xe0,  //.....%@@@@%+....
    0x1f, 0xf8,  //...%@@@@@@@@@+..
    0x3c, 0x1c,  //..%@@%....+%@@+.
    0x70, 0x06,  //.%@@........+@@.
    0x60, 0x03,  //.@@..........+@%
    0xe3, 0x63,  //%@%...@@.@@...@@
    0xc7, 0xe3,  //@@...%@@@@@...@@
    0xc6, 0x63,  //@@...@@..@@..+@@
    0xc6, 0x66,  //@@...@@..@@.+@@+
    0xc7, 0xfc,  //@@...%@@@@@@@@+.
    0xe3, 0x70,  //%@%...@@.@@%+...
    0x60, 0x00,  //.@@.............
    0x70, 0x00,  //.%@@............
    0x3c, 0x30,  //..@@@+....+@....
    0x1f, 0xf0,  //...%@@@@@@@@....
    0x07, 0xc0,  //....+%@@@%+.....
    0x00, 0x00,  //................


    /*Unicode: U+0041 (A) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@@+....
    0x0f, 0x00,  //....@@@@....
    0x0f, 0x00,  //....@@@@....
    0x19, 0x80,  //...%@++@%...
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //..+@%..%@+..
    0x30, 0xc0,  //..@@....@@..
    0x3f, 0xc0,  //..@@@@@@@@..
    0x7f, 0xe0,  //.%@@@@@@@@%.
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //+@%......%@+
    0xc0, 0x30,  //@@+......+@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0042 (B) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xfc, 0x00,  //@@@@@@+..
    0xff, 0x00,  //@@@@@@@%.
    0xc3, 0x00,  //@@...+@@.
    0xc3, 0x00,  //@@....@@.
    0xc3, 0x00,  //@@...+@%.
    0xfe, 0x00,  //@@@@@@%..
    0xfe, 0x00,  //@@@@@@@+.
    0xc3, 0x00,  //@@....%@+
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc3, 0x80,  //@@....%@@
    0xff, 0x00,  //@@@@@@@@+
    0xfe, 0x00,  //@@@@@@%..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0043 (C) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x0f, 0xc0,  //...+%@@@@%.
    0x3f, 0xe0,  //..@@@@@@@@@
    0x70, 0x20,  //.@@@+....+@
    0x60, 0x00,  //+@@........
    0xc0, 0x00,  //%@+........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //@@.........
    0xc0, 0x00,  //%@+........
    0x60, 0x00,  //+@@........
    0x70, 0x20,  //.@@@+....+@
    0x3f, 0xe0,  //..@@@@@@@@@
    0x0f, 0xc0,  //...+%@@@@%.
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0044 (D) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xfe, 0x00,  //@@@@@@%+...
    0xff, 0x80,  //@@@@@@@@@..
    0xc1, 0xc0,  //@@....+@@@.
    0xc0, 0xc0,  //@@......@@+
    0xc0, 0x60,  //@@......+@@
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@......+@@
    0xc0, 0xc0,  //@@......@@+
    0xc1, 0xc0,  //@@....+@@@.
    0xff, 0x80,  //@@@@@@@@@..
    0xfe, 0x00,  //@@@@@@%+...
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0045 (E) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0046 (F) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xfe,  //@@@@@@@.
    0xfe,  //@@@@@@@.
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0047 (G) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x0f, 0xc0,  //...+%@@@@%.
    0x3f, 0xe0,  //..@@@@@@@@@
    0x70, 0x20,  //.@@@+....+@
    0x60, 0x00,  //+@@........
    0xc0, 0x00,  //%@+........
    0xc3, 0xe0,  //@@....@@@@@
    0xc3, 0xe0,  //@@....@@@@@
    0xc0, 0x60,  //@@.......@@
    0xc0, 0x60,  //@@+......@@
    0x60, 0x60,  //+@@......@@
    0x70, 0x60,  //.@@@+...+@@
    0x3f, 0xc0,  //..@@@@@@@@+
    0x0f, 0x80,  //...+@@@@%..
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0048 (H) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0049 (I) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+004a (J) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x70,  //.%@%
    0xe0,  //@@@.
    0xc0,  //@%..


    /*Unicode: U+004b (K) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xc1, 0x80,  //@@.....@@+.
    0xc3, 0x00,  //@@....@@+..
    0xc6, 0x00,  //@@...@@+...
    0xcc, 0x00,  //@@..@@+....
    0xd8, 0x00,  //@@.@@+.....
    0xf0, 0x00,  //@@@@+......
    0xf0, 0x00,  //@@@@.......
    0xd8, 0x00,  //@@+@@......
    0xcc, 0x00,  //@@.+@@.....
    0xc6, 0x00,  //@@..+@@....
    0xc3, 0x00,  //@@...+@@...
    0xc1, 0x80,  //@@....+@@..
    0xc0, 0xc0,  //@@.....+@@+
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+004c (L) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+004d (M) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //@@@+....+@@@
    0xf0, 0xf0,  //@@@%....%@@@
    0xf0, 0xf0,  //@@%@....@%@@
    0xd8, 0xb0,  //@@.@+..+@.@@
    0xd9, 0xb0,  //@@.@@..@@.@@
    0xd9, 0xb0,  //@@.%@..@+.@@
    0xcf, 0x30,  //@@..@%%@..@@
    0xcf, 0x30,  //@@..@@@@..@@
    0xc6, 0x30,  //@@..+@@+..@@
    0xc6, 0x30,  //@@...@@...@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+004e (N) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xe0, 0xc0,  //@@%.....@@
    0xe0, 0xc0,  //@@@.....@@
    0xf0, 0xc0,  //@@@%....@@
    0xf0, 0xc0,  //@@%@+...@@
    0xd8, 0xc0,  //@@.@@...@@
    0xd8, 0xc0,  //@@.%@+..@@
    0xcc, 0xc0,  //@@..@@..@@
    0xc6, 0xc0,  //@@..+@%.@@
    0xc6, 0xc0,  //@@...@@.@@
    0xc3, 0xc0,  //@@...+@@@@
    0xc3, 0xc0,  //@@....%@@@
    0xc1, 0xc0,  //@@.....@@@
    0xc1, 0xc0,  //@@.....%@@
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+004f (O) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x0f, 0x80,  //...+@@@@+...
    0x3f, 0xc0,  //..@@@@@@@@..
    0x70, 0xe0,  //.@@@+..+@@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //%@+......+@%
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //%@+......+@%
    0x60, 0x60,  //+@@......@@+
    0x70, 0xe0,  //.@@@+..+@@@.
    0x3f, 0xc0,  //..@@@@@@@@..
    0x1f, 0x80,  //...+@@@@+...
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0050 (P) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xfc,  //@@@@@%+.
    0xfe,  //@@@@@@@+
    0xc7,  //@@...%@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc7,  //@@...%@@
    0xfe,  //@@@@@@@+
    0xfc,  //@@@@@@+.
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0051 (Q) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x0f, 0x80,  //...+@@@@%...
    0x3f, 0xc0,  //..@@@@@@@@..
    0x70, 0xe0,  //.@@@+..+@@@.
    0x60, 0x60,  //+@@......@@+
    0xc0, 0x30,  //%@+......+@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //@@........@@
    0xc0, 0x30,  //%@+......+@%
    0x60, 0x60,  //+@@......@@+
    0x70, 0xe0,  //.@@@+..+@@%.
    0x3f, 0xc0,  //..@@@@@@@%..
    0x1f, 0x80,  //...%@@@@%...
    0x01, 0x80,  //......+@@+..
    0x00, 0xc0,  //.......+@@+.
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0052 (R) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xfc, 0x00,  //@@@@@@+...
    0xfe, 0x00,  //@@@@@@@+..
    0xc7, 0x00,  //@@...%@@..
    0xc3, 0x00,  //@@....@@..
    0xc3, 0x00,  //@@....@@..
    0xc7, 0x00,  //@@...%@%..
    0xfe, 0x00,  //@@@@@@@...
    0xfc, 0x00,  //@@@@@@+...
    0xc6, 0x00,  //@@..+@@...
    0xc3, 0x00,  //@@...+@@..
    0xc3, 0x00,  //@@....@@+.
    0xc1, 0x80,  //@@....+@@.
    0xc1, 0xc0,  //@@.....%@%
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0053 (S) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x3e, 0x00,  //..%@@@%..
    0x7f, 0x00,  //+@@@@@@@.
    0xe1, 0x00,  //@@%...+%.
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@+......
    0x7c, 0x00,  //+@@@@%+..
    0x3f, 0x00,  //..%@@@@@.
    0x03, 0x80,  //.....+@@%
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x83, 0x80,  //@+....%@@
    0xff, 0x00,  //@@@@@@@@+
    0x7e, 0x00,  //.%@@@@%..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0054 (T) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xff, 0xf0,  //@@@@@@@@@@@@
    0xff, 0xf0,  //@@@@@@@@@@@@
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0055 (U) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.@@@@@@@@.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0056 (V) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xc0, 0x30,  //@@+......+@@
    0x60, 0x60,  //+@%......%@+
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //.%@+....+@%.
    0x30, 0xc0,  //..@@....@@..
    0x30, 0xc0,  //..@@....@@..
    0x19, 0x80,  //..+@%..%@+..
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //...%@++@%...
    0x0f, 0x00,  //....@@@@+...
    0x0f, 0x00,  //....@@@@....
    0x06, 0x00,  //....+@@+....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0057 (W) , Width: 17 */
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0xc1, 0xc1, 0x80,  //@@.....@@@.....@@
    0xc1, 0xc1, 0x80,  //%@+...+@@@+...+@%
    0x63, 0xe3, 0x00,  //+@%...%@%@%...%@+
    0x63, 0x63, 0x00,  //.@@...@@.@@...@@.
    0x63, 0x63, 0x00,  //.@@...@@.@@...@@.
    0x63, 0x63, 0x00,  //.%@+.+@%.%@+.+@%.
    0x36, 0x36, 0x00,  //.+@%.%@+.+@%.%@+.
    0x36, 0x36, 0x00,  //..@@.@@...@@.@@..
    0x36, 0x36, 0x00,  //..@@+@@...@@+@@..
    0x3e, 0x3e, 0x00,  //..%@@@%...%@@@%..
    0x1c, 0x1c, 0x00,  //..+@@@+...+@@@+..
    0x1c, 0x1c, 0x00,  //...@@@.....@@@...
    0x1c, 0x1c, 0x00,  //...@@@.....@@%...
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0058 (X) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x70, 0xe0,  //.%@%....%@%
    0x30, 0xc0,  //..@@+..+@@.
    0x39, 0x80,  //..%@@..@@+.
    0x1b, 0x80,  //...@@+%@%..
    0x0f, 0x00,  //...+@@@@...
    0x0e, 0x00,  //....%@@+...
    0x0e, 0x00,  //....%@@....
    0x0f, 0x00,  //...+@@@@...
    0x1b, 0x00,  //...@@+@@+..
    0x39, 0x80,  //..%@%.+@@..
    0x31, 0xc0,  //.+@@...@@%.
    0x60, 0xc0,  //.@@+....@@.
    0xe0, 0xe0,  //%@@.....%@%
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+0059 (Y) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0xe0, 0x70,  //%@@......@@%
    0x60, 0x60,  //.@@+....+@@.
    0x30, 0xc0,  //..@@....@@..
    0x19, 0x80,  //..+@%..%@+..
    0x19, 0x80,  //...%@++@%...
    0x0f, 0x00,  //....@@@@....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //.....@@.....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+005a (Z) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x01, 0xc0,  //.......%@@.
    0x03, 0x80,  //......%@@..
    0x03, 0x00,  //.....+@@+..
    0x07, 0x00,  //.....@@%...
    0x0e, 0x00,  //....@@%....
    0x1c, 0x00,  //...%@@.....
    0x18, 0x00,  //..+@@......
    0x30, 0x00,  //.+@@+......
    0x70, 0x00,  //.@@%.......
    0xff, 0xe0,  //@@@@@@@@@@@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+005b ([) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xf0,  //@@@@
    0xf0,  //@@@@
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xc0,  //@@..
    0xf0,  //@@@@
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....


    /*Unicode: U+005c (\) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xc0,  //@@....
    0xc0,  //%@+...
    0x60,  //+@%...
    0x60,  //.@@...
    0x60,  //.@@+..
    0x70,  //.%@%..
    0x30,  //.+@@..
    0x30,  //..@@..
    0x30,  //..@@+.
    0x38,  //..+@%.
    0x18,  //...@@.
    0x18,  //...@@.
    0x18,  //...%@+
    0x0c,  //...+@%
    0x0c,  //....@@
    0x00,  //......
    0x00,  //......


    /*Unicode: U+005d (]) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xf0,  //@@@@
    0xf0,  //@@@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0xf0,  //@@@@
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....


    /*Unicode: U+005e (^) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x0e, 0x00,  //....@@@....
    0x1f, 0x00,  //...%@%@%...
    0x31, 0x80,  //..%@+.+@%..
    0x60, 0xc0,  //.%@+...+@%.
    0xc0, 0x60,  //%@+.....+@%
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........


    /*Unicode: U+005f (_) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xff, 0x80,  //@@@@@@@@@
    0xff, 0x80,  //@@@@@@@@@


    /*Unicode: U+0060 (`) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xc0,  //%@..
    0x60,  //.%@.
    0x30,  //..%%
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0061 (a) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x3c,  //.+%@@@+.
    0x7e,  //.@@@@@@.
    0x47,  //.%...%@%
    0x03,  //......@@
    0x3f,  //.+@@@@@@
    0xff,  //%@@@@@@@
    0xc3,  //@@+...@@
    0xc7,  //@@+..%@@
    0xff,  //%@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0062 (b) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xde, 0x00,  //@@.%@@%..
    0xff, 0x00,  //@@%@@@@@.
    0xe3, 0x80,  //@@@...@@%
    0xc1, 0x80,  //@@+...+@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@+...+@@
    0xe3, 0x80,  //@@@...@@%
    0xff, 0x00,  //@@%@@@@@.
    0xde, 0x00,  //@@.%@@%..
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0063 (c) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x1e,  //..+@@@%+
    0x7f,  //.%@@@@@@
    0x61,  //+@@+...%
    0xc0,  //@@+.....
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@+.....
    0x61,  //+@@+...%
    0x7f,  //.%@@@@@@
    0x1e,  //..+@@@%+
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0064 (d) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x3d, 0x80,  //..%@@%.@@
    0x7f, 0x80,  //.@@@@@%@@
    0xe3, 0x80,  //%@@...@@@
    0xc1, 0x80,  //@@+...+@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@+...+@@
    0xe3, 0x80,  //%@@...@@@
    0x7f, 0x80,  //.@@@@@%@@
    0x3d, 0x80,  //..%@@%.@@
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0065 (e) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1f, 0x00,  //..+%@@@%..
    0x7f, 0x80,  //.%@@@@@@@.
    0x61, 0xc0,  //+@@+...@@%
    0xc0, 0xc0,  //@@......@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xff, 0xc0,  //@@@@@@@@@@
    0xc0, 0x00,  //@@........
    0x60, 0x40,  //+@@+....+@
    0x7f, 0xc0,  //.%@@@@@@@@
    0x1f, 0x80,  //..+%@@@@%.
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0066 (f) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x1e,  //...%@@@
    0x3e,  //..%@@@@
    0x30,  //..@@+..
    0x30,  //..@@...
    0xfe,  //@@@@@@@
    0xfe,  //@@@@@@@
    0x30,  //..@@...
    0x30,  //..@@...
    0x30,  //..@@...
    0x30,  //..@@...
    0x30,  //..@@...
    0x30,  //..@@...
    0x30,  //..@@...
    0x30,  //..@@...
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0067 (g) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x3d, 0x80,  //..%@@%.@@
    0x7f, 0x80,  //.@@@@@%@@
    0xe3, 0x80,  //%@@...@@@
    0xc1, 0x80,  //@@+...+@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@+...+@@
    0xe3, 0x80,  //%@@...@@@
    0x7f, 0x80,  //.@@@@@%@@
    0x3d, 0x80,  //..%@@%.@@
    0x01, 0x80,  //......+@%
    0x43, 0x00,  //.%...+@@+
    0x7f, 0x00,  //.@@@@@@@.
    0x3e, 0x00,  //.+%@@@%..


    /*Unicode: U+0068 (h) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xc0,  //@@......
    0xde,  //@@.%@@%.
    0xfe,  //@@%@@@@+
    0xe7,  //@@@..%@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0069 (i) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+006a (j) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x30,  //..@@
    0x30,  //..@@
    0x00,  //....
    0x00,  //....
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //..@@
    0x30,  //.+@@
    0xe0,  //@@@+
    0xc0,  //@@+.


    /*Unicode: U+006b (k) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc3, 0x00,  //@@....@@+
    0xc6, 0x00,  //@@..+@@+.
    0xcc, 0x00,  //@@.+@@+..
    0xd8, 0x00,  //@@+@@+...
    0xf0, 0x00,  //@@@@.....
    0xf0, 0x00,  //@@@@+....
    0xd8, 0x00,  //@@+@@+...
    0xcc, 0x00,  //@@.+@@+..
    0xc6, 0x00,  //@@..+@@+.
    0xc3, 0x00,  //@@...+@@+
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+006c (l) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+006d (m) , Width: 14 */
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0xdc, 0x78,  //@@.%@@+..%@@%.
    0xfe, 0xf8,  //@@%@@@@+@@@@@+
    0xe7, 0x9c,  //@@@..%@@@..%@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0xc3, 0x0c,  //@@....@@....@@
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............
    0x00, 0x00,  //..............


    /*Unicode: U+006e (n) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xde,  //@@.%@@%.
    0xfe,  //@@%@@@@+
    0xe7,  //@@@..%@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+006f (o) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x1e, 0x00,  //..+@@@@+..
    0x7f, 0x80,  //.%@@@@@@%.
    0x61, 0x80,  //+@@+..+@@+
    0xc0, 0xc0,  //@@+....+@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@......@@
    0xc0, 0xc0,  //@@+....+@@
    0x61, 0x80,  //+@@+..+@@+
    0x7f, 0x80,  //.%@@@@@@%.
    0x1e, 0x00,  //..+@@@@+..
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0070 (p) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0xde, 0x00,  //@@.%@@%..
    0xff, 0x00,  //@@%@@@@@.
    0xe3, 0x80,  //@@@...@@%
    0xc1, 0x80,  //@@+...+@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@+...+@@
    0xe3, 0x80,  //@@@...@@%
    0xff, 0x00,  //@@%@@@@@.
    0xde, 0x00,  //@@.%@@%..
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......
    0xc0, 0x00,  //@@.......


    /*Unicode: U+0071 (q) , Width: 9 */
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x3d, 0x80,  //..%@@%.@@
    0x7f, 0x80,  //.@@@@@%@@
    0xe3, 0x80,  //%@@...@@@
    0xc1, 0x80,  //@@+...+@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@.....@@
    0xc1, 0x80,  //@@+...+@@
    0xe3, 0x80,  //%@@...@@@
    0x7f, 0x80,  //.@@@@@%@@
    0x3d, 0x80,  //..%@@%.@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@
    0x01, 0x80,  //.......@@


    /*Unicode: U+0072 (r) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xdc,  //@@.%@@
    0xfc,  //@@%@@@
    0xe0,  //@@@+..
    0xc0,  //@@+...
    0xc0,  //@@....
    0xc0,  //@@....
    0xc0,  //@@....
    0xc0,  //@@....
    0xc0,  //@@....
    0xc0,  //@@....
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+0073 (s) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x7c,  //.+@@@%+
    0xfe,  //%@@@@@@
    0xc2,  //@@+...%
    0xe0,  //@@%+...
    0x7c,  //+@@@@@.
    0x1e,  //..+%@@%
    0x06,  //.....@@
    0x86,  //%+..+@@
    0xfe,  //@@@@@@%
    0x78,  //.%@@@+.
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0074 (t) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x60,  //.@@...
    0x60,  //.@@...
    0x60,  //.@@...
    0xfc,  //@@@@@@
    0xfc,  //@@@@@@
    0x60,  //.@@...
    0x60,  //.@@...
    0x60,  //.@@...
    0x60,  //.@@...
    0x60,  //.@@...
    0x60,  //.@@+..
    0x7c,  //.%@@@@
    0x3c,  //..%@@@
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+0075 (u) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xc3,  //@@....@@
    0xe7,  //@@%..@@@
    0x7f,  //+@@@@%@@
    0x7b,  //.%@@%.@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+0076 (v) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //.%@+....+@%.
    0x30, 0xc0,  //..@@....@@..
    0x30, 0xc0,  //..@@....@@..
    0x19, 0x80,  //..+@%..%@+..
    0x19, 0x80,  //...@@..@@...
    0x19, 0x80,  //...%@.+@%...
    0x0f, 0x00,  //...+@%@@....
    0x0f, 0x00,  //....@@@@....
    0x06, 0x00,  //....+@@+....
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............


    /*Unicode: U+0077 (w) , Width: 15 */
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x63, 0x8c,  //.@@...@@@...@@.
    0x63, 0x8c,  //.@@...@@@...@@.
    0x63, 0x8c,  //.%@+.+@@@+.+@%.
    0x36, 0xd8,  //.+@%.%@+@%.%@+.
    0x36, 0xd8,  //..@@.@@.@@.@@..
    0x36, 0xd8,  //..@@.@%.%@.@@..
    0x3c, 0x78,  //..%@%@+.+@%@%..
    0x1c, 0x70,  //..+@@@...@@@+..
    0x1c, 0x70,  //...@@@...@@@...
    0x1c, 0x70,  //...@@%...%@@...
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............
    0x00, 0x00,  //...............


    /*Unicode: U+0078 (x) , Width: 10 */
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0xe1, 0xc0,  //%@@....@@%
    0x61, 0x80,  //.@@+..+@@.
    0x33, 0x00,  //.+@@..@@..
    0x33, 0x00,  //..%@++@%..
    0x1e, 0x00,  //...@@@@...
    0x1e, 0x00,  //...@@@@...
    0x33, 0x00,  //..%@++@%..
    0x33, 0x00,  //.+@@..@@+.
    0x61, 0x80,  //.@@+..+@@.
    0xe1, 0xc0,  //%@@....@@%
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........
    0x00, 0x00,  //..........


    /*Unicode: U+0079 (y) , Width: 12 */
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x00, 0x00,  //............
    0x60, 0x60,  //.@@......@@.
    0x60, 0x60,  //.%@+....+@%.
    0x30, 0xc0,  //..@@....@@..
    0x30, 0xc0,  //..%@+..+@@..
    0x19, 0x80,  //...@@..@@+..
    0x19, 0x80,  //...@@+.@@...
    0x0f, 0x00,  //...+@%%@+...
    0x0f, 0x00,  //....@@@@....
    0x06, 0x00,  //....+@@+....
    0x06, 0x00,  //.....@@.....
    0x06, 0x00,  //....+@%.....
    0x0c, 0x00,  //....%@......
    0x3c, 0x00,  //..@@@%......
    0x38, 0x00,  //..@@%.......


    /*Unicode: U+007a (z) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x06,  //....+@@.
    0x0c,  //....@@+.
    0x1c,  //...@@@..
    0x38,  //..%@@...
    0x30,  //.+@@+...
    0x70,  //.@@%....
    0xff,  //@@@@@@@@
    0xff,  //@@@@@@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+007b ({) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0x0f,  //....%@@@
    0x1f,  //...%@@@@
    0x18,  //...@@+..
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x38,  //..%@@...
    0xf0,  //@@@@....
    0xf0,  //@@@@....
    0x38,  //..%@%...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@+..
    0x1f,  //...%@@@@
    0x0f,  //....%@@@
    0x00,  //........


    /*Unicode: U+007c (|) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@
    0xc0,  //@@


    /*Unicode: U+007d (}) , Width: 8 */
    0x00,  //........
    0x00,  //........
    0xf0,  //@@@%....
    0xf8,  //@@@@%...
    0x18,  //..+@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x1c,  //...@@%..
    0x0f,  //....@@@@
    0x0f,  //....@@@@
    0x1c,  //...%@%..
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //...@@...
    0x18,  //..+@@...
    0xf8,  //@@@@%...
    0xf0,  //@@@%....
    0x00,  //........


    /*Unicode: U+007e (~) , Width: 11 */
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x7c, 0x20,  //.%@@@%...+@
    0xff, 0xe0,  //@@@@@@@@@@@
    0x87, 0xc0,  //@+...%@@@%.
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........
    0x00, 0x00,  //...........



#elif USE_LV_FONT_DEJAVU_20 == 2
    /*Unicode: U+0020 ( ) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+0021 (!) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0022 (") , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xf0, 0xf0,  //@@..@@
    0xf0, 0xf0,  //@@..@@
    0xf0, 0xf0,  //@@..@@
    0xf0, 0xf0,  //@@..@@
    0xf0, 0xf0,  //@@..@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+0023 (#) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x30, 0x70,  //.....@..+@..
    0x00, 0x70, 0x70,  //....+@..+@..
    0x00, 0xb0, 0xa0,  //....%@..%%..
    0x00, 0xe0, 0xd0,  //....@%..@+..
    0x3f, 0xff, 0xff,  //.@@@@@@@@@@@
    0x3f, 0xff, 0xff,  //.@@@@@@@@@@@
    0x01, 0xc2, 0xc0,  //...+@..%@...
    0x03, 0x83, 0x40,  //...@%..@+...
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@.
    0x07, 0x0b, 0x00,  //..+@..%@....
    0x0a, 0x0a, 0x00,  //..%%..%%....
    0x0e, 0x0d, 0x00,  //..@%..@+....
    0x0d, 0x0c, 0x00,  //..@+..@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0024 ($) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0xc0, 0x00,  //....@....
    0x00, 0xc0, 0x00,  //....@....
    0x1b, 0xf8, 0x00,  //.+%@@@%..
    0x7f, 0xff, 0x00,  //+@@@@@@@.
    0xf8, 0xc7, 0x00,  //@@%.@.+@.
    0xf0, 0xc0, 0x00,  //@@..@....
    0xbe, 0xc0, 0x00,  //%@@%@....
    0x3f, 0xfd, 0x00,  //.@@@@@@+.
    0x01, 0xff, 0x40,  //...+@@@@+
    0x00, 0xc7, 0xc0,  //....@.+@@
    0x00, 0xc3, 0xc0,  //....@..@@
    0xd0, 0xcb, 0xc0,  //@+..@.%@@
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0x2f, 0xf9, 0x00,  //.%@@@@%+.
    0x00, 0xc0, 0x00,  //....@....
    0x00, 0xc0, 0x00,  //....@....
    0x00, 0xc0, 0x00,  //....@....
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0025 (%) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x2f, 0x80, 0x07, 0x00,  //.%@@%.....+@...
    0x75, 0xd0, 0x0c, 0x00,  //+@++@+....@....
    0xf0, 0xf0, 0x28, 0x00,  //@@..@@...%%....
    0xf0, 0xf0, 0x30, 0x00,  //@@..@@...@.....
    0xf0, 0xf0, 0xd0, 0x00,  //@@..@@..@+.....
    0xb5, 0xd1, 0x80, 0x00,  //+@++@+.+%......
    0x2f, 0x83, 0x0b, 0xe0,  //.%@@%..@..%@@%.
    0x00, 0x09, 0x1d, 0x74,  //......%+.+@++@+
    0x00, 0x1c, 0x3c, 0x3c,  //.....+@..@@..@@
    0x00, 0x30, 0x3c, 0x3c,  //.....@...@@..@@
    0x00, 0xa0, 0x3c, 0x3c,  //....%%...@@..@@
    0x00, 0xc0, 0x1d, 0x74,  //....@....+@++@+
    0x03, 0x40, 0x0b, 0xe0,  //...@+.....%@@%.
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0026 (&) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x01, 0xfe, 0x40,  //...+@@@%+...
    0x07, 0xff, 0xc0,  //..+@@@@@@...
    0x0f, 0x41, 0xc0,  //..@@+..+%...
    0x0f, 0x00, 0x00,  //..@@........
    0x0b, 0x80, 0x00,  //..%@%.......
    0x0b, 0xe0, 0x00,  //..%@@%......
    0x2e, 0xf8, 0x3c,  //.%@%@@%..@@.
    0xb4, 0x7e, 0x78,  //%@+.+@@%+@%.
    0xf0, 0x1f, 0xf0,  //@@...+@@@@..
    0xf4, 0x07, 0xd0,  //@@+...+@@+..
    0xbd, 0x07, 0xe0,  //%@@+..+@@%..
    0x3f, 0xff, 0xf8,  //.@@@@@@@@@%.
    0x0b, 0xf8, 0x7e,  //..%@@@%.+@@%
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0027 (') , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0028 (() , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x0b,  //..%@
    0x0d,  //..@+
    0x2c,  //.%@.
    0x38,  //.@%.
    0x74,  //+@+.
    0xb0,  //%@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xb0,  //%@..
    0x74,  //+@+.
    0x38,  //.@%.
    0x2c,  //.%@.
    0x0d,  //..@+
    0x0b,  //..%@
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0029 ()) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xe0,  //@%..
    0x70,  //+@..
    0x38,  //.@%.
    0x2c,  //.%@.
    0x1d,  //.+@+
    0x0e,  //..@%
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0e,  //..@%
    0x1d,  //.+@+
    0x2c,  //.%@.
    0x38,  //.@%.
    0x70,  //+@..
    0xe0,  //@%..
    0x00,  //....
    0x00,  //....


    /*Unicode: U+002a (*) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x03, 0x00,  //...@...
    0x83, 0x08,  //%..@..%
    0x77, 0x74,  //+@+@+@+
    0x0f, 0xc0,  //..@@@..
    0x0f, 0xc0,  //..@@@..
    0x77, 0x74,  //+@+@+@+
    0x83, 0x08,  //%..@..%
    0x03, 0x00,  //...@...
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+002b (+) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+002c (,) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x3c,  //.@@
    0x3c,  //.@@
    0x70,  //+@.
    0xd0,  //@+.
    0x00,  //...
    0x00,  //...


    /*Unicode: U+002d (-) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+002e (.) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002f (/) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0xf0,  //....@@
    0x01, 0xe0,  //...+@%
    0x02, 0xd0,  //...%@+
    0x03, 0xc0,  //...@@.
    0x03, 0xc0,  //...@@.
    0x0b, 0x80,  //..+@%.
    0x0f, 0x40,  //..@@+.
    0x0f, 0x00,  //..@@..
    0x1f, 0x00,  //.+@@..
    0x2e, 0x00,  //.%@%..
    0x3d, 0x00,  //.@@+..
    0x3c, 0x00,  //.@@...
    0x78, 0x00,  //+@%...
    0xb4, 0x00,  //%@+...
    0xf0, 0x00,  //@@....
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+0030 (0) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x07, 0xf4, 0x00,  //..+@@@+..
    0x2f, 0xfe, 0x00,  //.%@@@@@%.
    0x7d, 0x1f, 0x40,  //+@@+.+@@+
    0xb4, 0x07, 0x80,  //%@+...+@%
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xb4, 0x07, 0x80,  //%@+...+@%
    0x7d, 0x1f, 0x40,  //+@@+.+@@+
    0x2f, 0xfe, 0x00,  //.%@@@@@%.
    0x0b, 0xf8, 0x00,  //..+@@@+..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0031 (1) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1f, 0xc0,  //.+@@@...
    0xff, 0xc0,  //@@@@@...
    0xd3, 0xc0,  //@+.@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0032 (2) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x2f, 0xe0, 0x00,  //.%@@@%...
    0xff, 0xfd, 0x00,  //@@@@@@@+.
    0xd0, 0x3f, 0x00,  //@+...@@@.
    0x00, 0x0f, 0x00,  //......@@.
    0x00, 0x0f, 0x00,  //......@@.
    0x00, 0x2d, 0x00,  //.....%@+.
    0x00, 0x7c, 0x00,  //....+@@..
    0x01, 0xf0, 0x00,  //...+@@...
    0x07, 0xd0, 0x00,  //..+@@+...
    0x1f, 0x40, 0x00,  //.+@@+....
    0x7d, 0x00, 0x00,  //+@@+.....
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0033 (3) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x2f, 0xf8, 0x00,  //.%@@@@%..
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xd0, 0x0b, 0xc0,  //@+....%@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x0b, 0x80,  //......%@%
    0x0f, 0xfd, 0x00,  //..@@@@@+.
    0x0f, 0xfe, 0x00,  //..@@@@@%.
    0x00, 0x1f, 0x80,  //.....+@@%
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x90, 0x1f, 0x80,  //%+...+@@%
    0xff, 0xff, 0x00,  //@@@@@@@@.
    0x2f, 0xf8, 0x00,  //.%@@@@%..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0034 (4) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x2f, 0x00,  //.....%@@..
    0x00, 0x7f, 0x00,  //....+@@@..
    0x00, 0xdf, 0x00,  //....@+@@..
    0x02, 0xcf, 0x00,  //...%@.@@..
    0x07, 0x0f, 0x00,  //..+@..@@..
    0x0d, 0x0f, 0x00,  //..@+..@@..
    0x3c, 0x0f, 0x00,  //.@@...@@..
    0x70, 0x0f, 0x00,  //+@....@@..
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0x00, 0x0f, 0x00,  //......@@..
    0x00, 0x0f, 0x00,  //......@@..
    0x00, 0x0f, 0x00,  //......@@..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0035 (5) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x3f, 0xfc,  //.@@@@@@.
    0x3f, 0xfc,  //.@@@@@@.
    0x3c, 0x00,  //.@@.....
    0x3c, 0x00,  //.@@.....
    0x3f, 0xf0,  //.@@@@@..
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x3e,  //.%...@@%
    0x00, 0x0f,  //......@@
    0x00, 0x0f,  //......@@
    0x00, 0x0f,  //......@@
    0x90, 0x7e,  //%...+@@%
    0xff, 0xfc,  //@@@@@@@.
    0x6f, 0xe0,  //.%@@@%..
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0036 (6) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x02, 0xfd, 0x00,  //...%@@@+.
    0x1f, 0xff, 0x00,  //.+@@@@@@.
    0x3e, 0x02, 0x00,  //.@@%...%.
    0xbc, 0x00, 0x00,  //+@@......
    0xf4, 0x00, 0x00,  //@@+......
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xf8, 0x0b, 0x80,  //@@%...%@%
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xb0, 0x03, 0xc0,  //%@.....@@
    0x78, 0x0b, 0x80,  //+@%...%@%
    0x2f, 0xff, 0x00,  //.%@@@@@@.
    0x07, 0xf8, 0x00,  //..+@@@%..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0037 (7) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x2d,  //.....%@+
    0x00, 0x3c,  //.....@@.
    0x00, 0x7c,  //....+@@.
    0x00, 0xb4,  //....%@+.
    0x00, 0xf0,  //....@@..
    0x00, 0xf0,  //....@@..
    0x02, 0xe0,  //...%@%..
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x0b, 0x80,  //..%@%...
    0x0f, 0x40,  //..@@+...
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0038 (8) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x1b, 0xf9, 0x00,  //.+%@@@%+.
    0x7f, 0xff, 0x40,  //+@@@@@@@+
    0xf8, 0x0b, 0xc0,  //@@%...%@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xb8, 0x0b, 0x80,  //%@%...%@%
    0x1f, 0xfd, 0x00,  //.+@@@@@+.
    0x2f, 0xfe, 0x00,  //.%@@@@@%.
    0xb8, 0x0b, 0x80,  //%@%...%@%
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf8, 0x0b, 0xc0,  //@@%...%@@
    0x7f, 0xff, 0x40,  //+@@@@@@@+
    0x0b, 0xf8, 0x00,  //..%@@@%..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0039 (9) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x0b, 0xf4, 0x00,  //..%@@@+..
    0x3f, 0xfe, 0x00,  //.@@@@@@%.
    0xb8, 0x0b, 0x00,  //%@%...%@.
    0xf0, 0x03, 0x80,  //@@.....@%
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf8, 0x0b, 0xc0,  //%@%...%@@
    0x7f, 0xfb, 0xc0,  //.@@@@@%@@
    0x0b, 0xe3, 0xc0,  //..%@@%.@@
    0x00, 0x07, 0xc0,  //......+@@
    0x00, 0x0f, 0x40,  //......@@+
    0x20, 0x2f, 0x00,  //.%...%@@.
    0x3f, 0xfd, 0x00,  //.@@@@@@+.
    0x1f, 0xe0, 0x00,  //.+@@@%...
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+003a (:) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+003b (;) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x3c,  //.@@
    0x3c,  //.@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x3c,  //.@@
    0x3c,  //.@@
    0x70,  //+@.
    0xd0,  //@+.
    0x00,  //...
    0x00,  //...


    /*Unicode: U+003c (<) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x1c,  //.........+@
    0x00, 0x06, 0xfc,  //.......%@@@
    0x00, 0x7f, 0xe4,  //....+@@@@%+
    0x1b, 0xfd, 0x00,  //.+%@@@@+...
    0xff, 0x90, 0x00,  //@@@@%+.....
    0xff, 0x90, 0x00,  //@@@@%+.....
    0x1b, 0xfd, 0x00,  //.+%@@@@+...
    0x00, 0x7f, 0xe4,  //....+@@@@%+
    0x00, 0x06, 0xfc,  //......+%@@@
    0x00, 0x00, 0x1c,  //.........+@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003d (=) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003e (>) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xd0, 0x00, 0x00,  //@+.........
    0xfe, 0x40, 0x00,  //@@@%.......
    0x6f, 0xf4, 0x00,  //+%@@@@+....
    0x01, 0xff, 0x90,  //...+@@@@%+.
    0x00, 0x1b, 0xfc,  //.....+%@@@@
    0x00, 0x1b, 0xfc,  //.....+%@@@@
    0x01, 0xff, 0x90,  //...+@@@@%+.
    0x6f, 0xf4, 0x00,  //+%@@@@+....
    0xfe, 0x40, 0x00,  //@@@%+......
    0xd0, 0x00, 0x00,  //@+.........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003f (?) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x6f, 0xd0,  //.%@@@+.
    0xff, 0xf4,  //@@@@@@+
    0xd0, 0xbc,  //@+..%@@
    0x00, 0x3c,  //.....@@
    0x00, 0x78,  //....+@%
    0x00, 0xf0,  //....@@.
    0x03, 0xc0,  //...@@..
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x00, 0x00,  //.......
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0040 (@) , Width: 16 */
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x2f, 0xf9, 0x00,  //.....%@@@@%+....
    0x02, 0xff, 0xff, 0xd0,  //...%@@@@@@@@@+..
    0x0b, 0xe0, 0x06, 0xf4,  //..%@@%....+%@@+.
    0x2f, 0x00, 0x00, 0x7c,  //.%@@........+@@.
    0x3c, 0x00, 0x00, 0x1e,  //.@@..........+@%
    0xb8, 0x0f, 0x3c, 0x0f,  //%@%...@@.@@...@@
    0xf0, 0x2f, 0xfc, 0x0f,  //@@...%@@@@@...@@
    0xf0, 0x3c, 0x3c, 0x1f,  //@@...@@..@@..+@@
    0xf0, 0x3c, 0x3c, 0x7d,  //@@...@@..@@.+@@+
    0xf0, 0x2f, 0xff, 0xf4,  //@@...%@@@@@@@@+.
    0xb8, 0x0f, 0x3e, 0x40,  //%@%...@@.@@%+...
    0x7c, 0x00, 0x00, 0x00,  //.@@.............
    0x2f, 0x00, 0x00, 0x00,  //.%@@............
    0x0f, 0xe0, 0x0b, 0x00,  //..@@@+....+@....
    0x02, 0xff, 0xff, 0x00,  //...%@@@@@@@@....
    0x00, 0x6f, 0xe4, 0x00,  //....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0041 (A) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0xff, 0x00,  //....@@@@....
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x2f, 0xff, 0xf8,  //.%@@@@@@@@%.
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x78, 0x00, 0x2d,  //+@%......%@+
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0042 (B) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xff, 0xf4, 0x00,  //@@@@@@+..
    0xff, 0xfe, 0x00,  //@@@@@@@%.
    0xf0, 0x1f, 0x00,  //@@...+@@.
    0xf0, 0x0f, 0x00,  //@@....@@.
    0xf0, 0x1e, 0x00,  //@@...+@%.
    0xff, 0xf8, 0x00,  //@@@@@@%..
    0xff, 0xfd, 0x00,  //@@@@@@@+.
    0xf0, 0x0b, 0x40,  //@@....%@+
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x0b, 0xc0,  //@@....%@@
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xf8, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0043 (C) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x3f, 0x40, 0x1c,  //.@@@+....+@
    0x7c, 0x00, 0x00,  //+@@........
    0xb4, 0x00, 0x00,  //%@+........
    0xf0, 0x00, 0x00,  //@@.........
    0xf0, 0x00, 0x00,  //@@.........
    0xf0, 0x00, 0x00,  //@@.........
    0xb4, 0x00, 0x00,  //%@+........
    0x7c, 0x00, 0x00,  //+@@........
    0x3f, 0x40, 0x1c,  //.@@@+....+@
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0044 (D) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xf9, 0x00,  //@@@@@@%+...
    0xff, 0xff, 0xc0,  //@@@@@@@@@..
    0xf0, 0x07, 0xf0,  //@@....+@@@.
    0xf0, 0x00, 0xf4,  //@@......@@+
    0xf0, 0x00, 0x7c,  //@@......+@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf0, 0x00, 0x7c,  //@@......+@@
    0xf0, 0x00, 0xf4,  //@@......@@+
    0xf0, 0x07, 0xf0,  //@@....+@@@.
    0xff, 0xff, 0xc0,  //@@@@@@@@@..
    0xff, 0xf9, 0x00,  //@@@@@@%+...
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0045 (E) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0046 (F) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xfc,  //@@@@@@@.
    0xff, 0xfc,  //@@@@@@@.
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0047 (G) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x01, 0xbf, 0xe0,  //...+%@@@@%.
    0x0f, 0xff, 0xfc,  //..@@@@@@@@@
    0x3f, 0x40, 0x1c,  //.@@@+....+@
    0x7c, 0x00, 0x00,  //+@@........
    0xf4, 0x00, 0x00,  //%@+........
    0xf0, 0x0f, 0xfc,  //@@....@@@@@
    0xf0, 0x0f, 0xfc,  //@@....@@@@@
    0xf0, 0x00, 0x3c,  //@@.......@@
    0xf4, 0x00, 0x3c,  //@@+......@@
    0x7c, 0x00, 0x3c,  //+@@......@@
    0x3f, 0x40, 0x7c,  //.@@@+...+@@
    0x0f, 0xff, 0xf4,  //..@@@@@@@@+
    0x01, 0xff, 0x80,  //...+@@@@%..
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0048 (H) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0049 (I) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+004a (J) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x2e,  //.%@%
    0xfc,  //@@@.
    0xe0,  //@%..


    /*Unicode: U+004b (K) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xf0, 0x03, 0xd0,  //@@.....@@+.
    0xf0, 0x0f, 0x40,  //@@....@@+..
    0xf0, 0x3d, 0x00,  //@@...@@+...
    0xf0, 0xf4, 0x00,  //@@..@@+....
    0xf3, 0xd0, 0x00,  //@@.@@+.....
    0xff, 0x40, 0x00,  //@@@@+......
    0xff, 0x00, 0x00,  //@@@@.......
    0xf7, 0xc0, 0x00,  //@@+@@......
    0xf1, 0xf0, 0x00,  //@@.+@@.....
    0xf0, 0x7c, 0x00,  //@@..+@@....
    0xf0, 0x1f, 0x00,  //@@...+@@...
    0xf0, 0x07, 0xd0,  //@@....+@@..
    0xf0, 0x01, 0xf4,  //@@.....+@@+
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+004c (L) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+004d (M) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xfd, 0x00, 0x7f,  //@@@+....+@@@
    0xff, 0x00, 0xbf,  //@@@%....%@@@
    0xfb, 0x00, 0xef,  //@@%@....@%@@
    0xf7, 0x81, 0xdf,  //@@.@+..+@.@@
    0xf3, 0xc3, 0xcf,  //@@.@@..@@.@@
    0xf2, 0xc3, 0x8f,  //@@.%@..@+.@@
    0xf0, 0xeb, 0x0f,  //@@..@%%@..@@
    0xf0, 0xff, 0x0f,  //@@..@@@@..@@
    0xf0, 0x7d, 0x0f,  //@@..+@@+..@@
    0xf0, 0x3c, 0x0f,  //@@...@@...@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+004e (N) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xf8, 0x00, 0xf0,  //@@%.....@@
    0xfc, 0x00, 0xf0,  //@@@.....@@
    0xfe, 0x00, 0xf0,  //@@@%....@@
    0xfb, 0x40, 0xf0,  //@@%@+...@@
    0xf3, 0xc0, 0xf0,  //@@.@@...@@
    0xf2, 0xd0, 0xf0,  //@@.%@+..@@
    0xf0, 0xf0, 0xf0,  //@@..@@..@@
    0xf0, 0x78, 0xf0,  //@@..+@%.@@
    0xf0, 0x3d, 0xf0,  //@@...@@.@@
    0xf0, 0x1f, 0xf0,  //@@...+@@@@
    0xf0, 0x0b, 0xf0,  //@@....%@@@
    0xf0, 0x03, 0xf0,  //@@.....@@@
    0xf0, 0x02, 0xf0,  //@@.....%@@
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+004f (O) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0x80,  //...+@@@@+...
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x02, 0xff, 0x80,  //...+@@@@+...
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0050 (P) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xf4,  //@@@@@%+.
    0xff, 0xfd,  //@@@@@@@+
    0xf0, 0x2f,  //@@...%@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x2f,  //@@...%@@
    0xff, 0xfd,  //@@@@@@@+
    0xff, 0xf4,  //@@@@@@+.
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0051 (Q) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x01, 0xff, 0x80,  //...+@@@@%...
    0x0f, 0xff, 0xf0,  //..@@@@@@@@..
    0x3f, 0x41, 0xfc,  //.@@@+..+@@@.
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0xf4, 0x00, 0x1f,  //%@+......+@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf0, 0x00, 0x0f,  //@@........@@
    0xf4, 0x00, 0x1e,  //%@+......+@%
    0x7c, 0x00, 0x3d,  //+@@......@@+
    0x3f, 0x41, 0xf8,  //.@@@+..+@@%.
    0x0f, 0xff, 0xe0,  //..@@@@@@@%..
    0x02, 0xff, 0x80,  //...%@@@@%...
    0x00, 0x07, 0xd0,  //......+@@+..
    0x00, 0x01, 0xf4,  //.......+@@+.
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0052 (R) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xff, 0xf4, 0x00,  //@@@@@@+...
    0xff, 0xfd, 0x00,  //@@@@@@@+..
    0xf0, 0x2f, 0x00,  //@@...%@@..
    0xf0, 0x0f, 0x00,  //@@....@@..
    0xf0, 0x0f, 0x00,  //@@....@@..
    0xf0, 0x2e, 0x00,  //@@...%@%..
    0xff, 0xfc, 0x00,  //@@@@@@@...
    0xff, 0xf4, 0x00,  //@@@@@@+...
    0xf0, 0x7c, 0x00,  //@@..+@@...
    0xf0, 0x1f, 0x00,  //@@...+@@..
    0xf0, 0x0f, 0x40,  //@@....@@+.
    0xf0, 0x07, 0xc0,  //@@....+@@.
    0xf0, 0x02, 0xe0,  //@@.....%@%
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0053 (S) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x0b, 0xf8, 0x00,  //..%@@@%..
    0x7f, 0xff, 0x00,  //+@@@@@@@.
    0xf8, 0x06, 0x00,  //@@%...+%.
    0xf0, 0x00, 0x00,  //@@.......
    0xf4, 0x00, 0x00,  //@@+......
    0x7f, 0xe4, 0x00,  //+@@@@%+..
    0x1b, 0xff, 0x00,  //..%@@@@@.
    0x00, 0x1f, 0x80,  //.....+@@%
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0xd0, 0x0f, 0xc0,  //@+....%@@
    0xff, 0xff, 0x40,  //@@@@@@@@+
    0x2f, 0xf8, 0x00,  //.%@@@@%..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0054 (T) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0055 (U) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0xc0,  //.@@@@@@@@.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0056 (V) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xf4, 0x00, 0x1f,  //@@+......+@@
    0x78, 0x00, 0x2d,  //+@%......%@+
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x2d, 0x00, 0x78,  //.%@+....+@%.
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0x01, 0xf0,  //..@@....@@..
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x01, 0xff, 0x40,  //....@@@@+...
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0057 (W) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xf0, 0x03, 0xf0, 0x03, 0xc0,  //@@.....@@@.....@@
    0xb4, 0x07, 0xf4, 0x07, 0x80,  //%@+...+@@@+...+@%
    0x78, 0x0b, 0xb8, 0x0b, 0x40,  //+@%...%@%@%...%@+
    0x3c, 0x0f, 0x3c, 0x0f, 0x00,  //.@@...@@.@@...@@.
    0x3c, 0x0f, 0x3c, 0x0f, 0x00,  //.@@...@@.@@...@@.
    0x2d, 0x1e, 0x2d, 0x1e, 0x00,  //.%@+.+@%.%@+.+@%.
    0x1e, 0x2d, 0x1e, 0x2d, 0x00,  //.+@%.%@+.+@%.%@+.
    0x0f, 0x3c, 0x0f, 0x3c, 0x00,  //..@@.@@...@@.@@..
    0x0f, 0x7c, 0x0f, 0x7c, 0x00,  //..@@+@@...@@+@@..
    0x0b, 0xf8, 0x0b, 0xf8, 0x00,  //..%@@@%...%@@@%..
    0x07, 0xf4, 0x07, 0xf4, 0x00,  //..+@@@+...+@@@+..
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@@...
    0x03, 0xf0, 0x03, 0xf0, 0x00,  //...@@@.....@@%...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0058 (X) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x2e, 0x00, 0xb8,  //.%@%....%@%
    0x0f, 0x41, 0xf0,  //..@@+..+@@.
    0x0b, 0xc3, 0xd0,  //..%@@..@@+.
    0x03, 0xdb, 0x80,  //...@@+%@%..
    0x01, 0xff, 0x00,  //...+@@@@...
    0x00, 0xfd, 0x00,  //....%@@+...
    0x00, 0xbc, 0x00,  //....%@@....
    0x01, 0xff, 0x00,  //...+@@@@...
    0x03, 0xdf, 0x40,  //...@@+@@+..
    0x0b, 0x87, 0xc0,  //..%@%.+@@..
    0x1f, 0x03, 0xe0,  //.+@@...@@%.
    0x3d, 0x00, 0xf0,  //.@@+....@@.
    0xbc, 0x00, 0xb8,  //%@@.....%@%
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0059 (Y) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0xbc, 0x00, 0x3e,  //%@@......@@%
    0x3d, 0x00, 0x7c,  //.@@+....+@@.
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x02, 0xd7, 0x80,  //...%@++@%...
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+005a (Z) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x00, 0x02, 0xf0,  //.......%@@.
    0x00, 0x0b, 0xc0,  //......%@@..
    0x00, 0x1f, 0x40,  //.....+@@+..
    0x00, 0x3e, 0x00,  //.....@@%...
    0x00, 0xf8, 0x00,  //....@@%....
    0x02, 0xf0, 0x00,  //...%@@.....
    0x07, 0xc0, 0x00,  //..+@@......
    0x1f, 0x40, 0x00,  //.+@@+......
    0x3e, 0x00, 0x00,  //.@@%.......
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005b ([) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xff,  //@@@@
    0xff,  //@@@@
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xf0,  //@@..
    0xff,  //@@@@
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....


    /*Unicode: U+005c (\) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xf0, 0x00,  //@@....
    0xb4, 0x00,  //%@+...
    0x78, 0x00,  //+@%...
    0x3c, 0x00,  //.@@...
    0x3d, 0x00,  //.@@+..
    0x2e, 0x00,  //.%@%..
    0x1f, 0x00,  //.+@@..
    0x0f, 0x00,  //..@@..
    0x0f, 0x40,  //..@@+.
    0x0b, 0x80,  //..+@%.
    0x03, 0xc0,  //...@@.
    0x03, 0xc0,  //...@@.
    0x02, 0xd0,  //...%@+
    0x01, 0xe0,  //...+@%
    0x00, 0xf0,  //....@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+005d (]) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xff,  //@@@@
    0xff,  //@@@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0xff,  //@@@@
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....


    /*Unicode: U+005e (^) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0xfc, 0x00,  //....@@@....
    0x02, 0xee, 0x00,  //...%@%@%...
    0x0b, 0x47, 0x80,  //..%@+.+@%..
    0x2d, 0x01, 0xe0,  //.%@+...+@%.
    0xb4, 0x00, 0x78,  //%@+.....+@%
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005f (_) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xc0,  //@@@@@@@@@
    0xff, 0xff, 0xc0,  //@@@@@@@@@


    /*Unicode: U+0060 (`) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0xb0,  //%@..
    0x2c,  //.%@.
    0x0a,  //..%%
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0061 (a) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x1b, 0xf4,  //.+%@@@+.
    0x3f, 0xfc,  //.@@@@@@.
    0x20, 0x2e,  //.%...%@%
    0x00, 0x0f,  //......@@
    0x1f, 0xff,  //.+@@@@@@
    0xbf, 0xff,  //%@@@@@@@
    0xf4, 0x0f,  //@@+...@@
    0xf4, 0x2f,  //@@+..%@@
    0xbf, 0xef,  //%@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0062 (b) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xfc, 0x0f, 0x80,  //@@@...@@%
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xfc, 0x0f, 0x80,  //@@@...@@%
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0063 (c) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x07, 0xf9,  //..+@@@%+
    0x2f, 0xff,  //.%@@@@@@
    0x7d, 0x02,  //+@@+...%
    0xf4, 0x00,  //@@+.....
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf4, 0x00,  //@@+.....
    0x7d, 0x02,  //+@@+...%
    0x2f, 0xff,  //.%@@@@@@
    0x07, 0xf9,  //..+@@@%+
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0064 (d) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x0b, 0xe3, 0xc0,  //..%@@%.@@
    0x3f, 0xfb, 0xc0,  //.@@@@@%@@
    0xbc, 0x0f, 0xc0,  //%@@...@@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xbc, 0x0f, 0xc0,  //%@@...@@@
    0x3f, 0xfb, 0xc0,  //.@@@@@%@@
    0x0b, 0xe3, 0xc0,  //..%@@%.@@
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0065 (e) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x06, 0xfe, 0x00,  //..+%@@@%..
    0x2f, 0xff, 0xc0,  //.%@@@@@@@.
    0x7d, 0x03, 0xe0,  //+@@+...@@%
    0xf0, 0x00, 0xf0,  //@@......@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xff, 0xff, 0xf0,  //@@@@@@@@@@
    0xf0, 0x00, 0x00,  //@@........
    0x7d, 0x00, 0x70,  //+@@+....+@
    0x2f, 0xff, 0xf0,  //.%@@@@@@@@
    0x06, 0xff, 0x80,  //..+%@@@@%.
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0066 (f) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x02, 0xfc,  //...%@@@
    0x0b, 0xfc,  //..%@@@@
    0x0f, 0x40,  //..@@+..
    0x0f, 0x00,  //..@@...
    0xff, 0xfc,  //@@@@@@@
    0xff, 0xfc,  //@@@@@@@
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x0f, 0x00,  //..@@...
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0067 (g) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x0b, 0xe3, 0xc0,  //..%@@%.@@
    0x3f, 0xfb, 0xc0,  //.@@@@@%@@
    0xbc, 0x0f, 0xc0,  //%@@...@@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xbc, 0x0f, 0xc0,  //%@@...@@@
    0x3f, 0xfb, 0xc0,  //.@@@@@%@@
    0x0b, 0xe3, 0xc0,  //..%@@%.@@
    0x00, 0x07, 0x80,  //......+@%
    0x20, 0x1f, 0x40,  //.%...+@@+
    0x3f, 0xff, 0x00,  //.@@@@@@@.
    0x1b, 0xf8, 0x00,  //.+%@@@%..


    /*Unicode: U+0068 (h) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf0, 0x00,  //@@......
    0xf2, 0xf8,  //@@.%@@%.
    0xfb, 0xfd,  //@@%@@@@+
    0xfc, 0x2f,  //@@@..%@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0069 (i) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+006a (j) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x0f,  //..@@
    0x0f,  //..@@
    0x00,  //....
    0x00,  //....
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x0f,  //..@@
    0x1f,  //.+@@
    0xfd,  //@@@+
    0xf4,  //@@+.


    /*Unicode: U+006b (k) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x0f, 0x40,  //@@....@@+
    0xf0, 0x7d, 0x00,  //@@..+@@+.
    0xf1, 0xf4, 0x00,  //@@.+@@+..
    0xf7, 0xd0, 0x00,  //@@+@@+...
    0xff, 0x00, 0x00,  //@@@@.....
    0xff, 0x40, 0x00,  //@@@@+....
    0xf7, 0xd0, 0x00,  //@@+@@+...
    0xf1, 0xf4, 0x00,  //@@.+@@+..
    0xf0, 0x7d, 0x00,  //@@..+@@+.
    0xf0, 0x1f, 0x40,  //@@...+@@+
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+006c (l) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+006d (m) , Width: 14 */
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0xf2, 0xf4, 0x2f, 0x80,  //@@.%@@+..%@@%.
    0xfb, 0xfd, 0xff, 0xd0,  //@@%@@@@+@@@@@+
    0xfc, 0x2f, 0xc2, 0xf0,  //@@@..%@@@..%@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0xf0, 0x0f, 0x00, 0xf0,  //@@....@@....@@
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+006e (n) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf2, 0xf8,  //@@.%@@%.
    0xfb, 0xfd,  //@@%@@@@+
    0xfc, 0x2f,  //@@@..%@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+006f (o) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf0, 0x00, 0xf0,  //@@......@@
    0xf4, 0x01, 0xf0,  //@@+....+@@
    0x7d, 0x07, 0xd0,  //+@@+..+@@+
    0x3f, 0xff, 0x80,  //.%@@@@@@%.
    0x07, 0xfd, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0070 (p) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xfc, 0x0f, 0x80,  //@@@...@@%
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xfc, 0x0f, 0x80,  //@@@...@@%
    0xfb, 0xff, 0x00,  //@@%@@@@@.
    0xf2, 0xf8, 0x00,  //@@.%@@%..
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......
    0xf0, 0x00, 0x00,  //@@.......


    /*Unicode: U+0071 (q) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x0b, 0xe3, 0xc0,  //..%@@%.@@
    0x3f, 0xfb, 0xc0,  //.@@@@@%@@
    0xbc, 0x0f, 0xc0,  //%@@...@@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf0, 0x03, 0xc0,  //@@.....@@
    0xf4, 0x07, 0xc0,  //@@+...+@@
    0xbc, 0x0f, 0xc0,  //%@@...@@@
    0x3f, 0xfb, 0xc0,  //.@@@@@%@@
    0x0b, 0xe3, 0xc0,  //..%@@%.@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@
    0x00, 0x03, 0xc0,  //.......@@


    /*Unicode: U+0072 (r) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xf2, 0xf0,  //@@.%@@
    0xfb, 0xf0,  //@@%@@@
    0xfd, 0x00,  //@@@+..
    0xf4, 0x00,  //@@+...
    0xf0, 0x00,  //@@....
    0xf0, 0x00,  //@@....
    0xf0, 0x00,  //@@....
    0xf0, 0x00,  //@@....
    0xf0, 0x00,  //@@....
    0xf0, 0x00,  //@@....
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+0073 (s) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x2f, 0xe4,  //.+@@@%+
    0xbf, 0xfc,  //%@@@@@@
    0xf4, 0x08,  //@@+...%
    0xf9, 0x00,  //@@%+...
    0x7f, 0xf0,  //+@@@@@.
    0x06, 0xfc,  //..+%@@%
    0x00, 0x3c,  //.....@@
    0x90, 0x7c,  //%+..+@@
    0xff, 0xf8,  //@@@@@@%
    0x2f, 0xd0,  //.%@@@+.
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0074 (t) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x3c, 0x00,  //.@@...
    0x3c, 0x00,  //.@@...
    0x3c, 0x00,  //.@@...
    0xff, 0xf0,  //@@@@@@
    0xff, 0xf0,  //@@@@@@
    0x3c, 0x00,  //.@@...
    0x3c, 0x00,  //.@@...
    0x3c, 0x00,  //.@@...
    0x3c, 0x00,  //.@@...
    0x3c, 0x00,  //.@@...
    0x3d, 0x00,  //.@@+..
    0x2f, 0xf0,  //.%@@@@
    0x0b, 0xf0,  //..%@@@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+0075 (u) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf0, 0x0f,  //@@....@@
    0xf8, 0x3f,  //@@%..@@@
    0x7f, 0xef,  //+@@@@%@@
    0x2f, 0x8f,  //.%@@%.@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+0076 (v) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x2d, 0x00, 0x78,  //.%@+....+@%.
    0x1f, 0x00, 0xf0,  //..@@....@@..
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x07, 0x82, 0xd0,  //..+@%..%@+..
    0x03, 0xc3, 0xc0,  //...@@..@@...
    0x02, 0xc7, 0x80,  //...%@.+@%...
    0x01, 0xef, 0x00,  //...+@%@@....
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............


    /*Unicode: U+0077 (w) , Width: 15 */
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x3c, 0x0f, 0xc0, 0xf0,  //.@@...@@@...@@.
    0x3c, 0x0f, 0xc0, 0xf0,  //.@@...@@@...@@.
    0x2d, 0x1f, 0xd1, 0xe0,  //.%@+.+@@@+.+@%.
    0x1e, 0x2d, 0xe2, 0xd0,  //.+@%.%@+@%.%@+.
    0x0f, 0x3c, 0xf3, 0xc0,  //..@@.@@.@@.@@..
    0x0f, 0x38, 0xb3, 0xc0,  //..@@.@%.%@.@@..
    0x0b, 0xb4, 0x7b, 0x80,  //..%@%@+.+@%@%..
    0x07, 0xf0, 0x3f, 0x40,  //..+@@@...@@@+..
    0x03, 0xf0, 0x3f, 0x00,  //...@@@...@@@...
    0x03, 0xe0, 0x2f, 0x00,  //...@@%...%@@...
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0078 (x) , Width: 10 */
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0xbc, 0x03, 0xe0,  //%@@....@@%
    0x3d, 0x07, 0xc0,  //.@@+..+@@.
    0x1f, 0x0f, 0x00,  //.+@@..@@..
    0x0b, 0x5e, 0x00,  //..%@++@%..
    0x03, 0xfc, 0x00,  //...@@@@...
    0x03, 0xfc, 0x00,  //...@@@@...
    0x0b, 0x5e, 0x00,  //..%@++@%..
    0x1f, 0x0f, 0x40,  //.+@@..@@+.
    0x3d, 0x07, 0xc0,  //.@@+..+@@.
    0xbc, 0x03, 0xe0,  //%@@....@@%
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0079 (y) , Width: 12 */
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00,  //............
    0x3c, 0x00, 0x3c,  //.@@......@@.
    0x2d, 0x00, 0x78,  //.%@+....+@%.
    0x0f, 0x00, 0xf0,  //..@@....@@..
    0x0b, 0x41, 0xf0,  //..%@+..+@@..
    0x03, 0xc3, 0xd0,  //...@@..@@+..
    0x03, 0xd3, 0xc0,  //...@@+.@@...
    0x01, 0xeb, 0x40,  //...+@%%@+...
    0x00, 0xff, 0x00,  //....@@@@....
    0x00, 0x7d, 0x00,  //....+@@+....
    0x00, 0x3c, 0x00,  //.....@@.....
    0x00, 0x78, 0x00,  //....+@%.....
    0x00, 0xb0, 0x00,  //....%@......
    0x0f, 0xe0, 0x00,  //..@@@%......
    0x0f, 0x80, 0x00,  //..@@%.......


    /*Unicode: U+007a (z) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x7c,  //....+@@.
    0x00, 0xf4,  //....@@+.
    0x03, 0xf0,  //...@@@..
    0x0b, 0xc0,  //..%@@...
    0x1f, 0x40,  //.+@@+...
    0x3e, 0x00,  //.@@%....
    0xff, 0xff,  //@@@@@@@@
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+007b ({) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0xbf,  //....%@@@
    0x02, 0xff,  //...%@@@@
    0x03, 0xd0,  //...@@+..
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x0b, 0xc0,  //..%@@...
    0xff, 0x00,  //@@@@....
    0xff, 0x00,  //@@@@....
    0x0b, 0x80,  //..%@%...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xd0,  //...@@+..
    0x02, 0xff,  //...%@@@@
    0x00, 0xbf,  //....%@@@
    0x00, 0x00,  //........


    /*Unicode: U+007c (|) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@
    0xf0,  //@@


    /*Unicode: U+007d (}) , Width: 8 */
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0xfe, 0x00,  //@@@%....
    0xff, 0x80,  //@@@@%...
    0x07, 0xc0,  //..+@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xe0,  //...@@%..
    0x00, 0xff,  //....@@@@
    0x00, 0xff,  //....@@@@
    0x02, 0xe0,  //...%@%..
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x03, 0xc0,  //...@@...
    0x07, 0xc0,  //..+@@...
    0xff, 0x80,  //@@@@%...
    0xfe, 0x00,  //@@@%....
    0x00, 0x00,  //........


    /*Unicode: U+007e (~) , Width: 11 */
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x2f, 0xe0, 0x1c,  //.%@@@%...+@
    0xff, 0xff, 0xfc,  //@@@@@@@@@@@
    0xd0, 0x6f, 0xe0,  //@+...%@@@%.
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00,  //...........



#elif USE_LV_FONT_DEJAVU_20 == 4
    /*Unicode: U+0020 ( ) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0021 (!) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xee,  //@@
    0xdd,  //@@
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0022 (") , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xff, 0x00, 0xff,  //@@..@@
    0xff, 0x00, 0xff,  //@@..@@
    0xff, 0x00, 0xff,  //@@..@@
    0xff, 0x00, 0xff,  //@@..@@
    0xff, 0x00, 0xff,  //@@..@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0023 (#) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x2f, 0x30, 0x4f, 0x10,  //.....@..+@..
    0x00, 0x00, 0x6f, 0x00, 0x7d, 0x00,  //....+@..+@..
    0x00, 0x00, 0x9c, 0x00, 0xba, 0x00,  //....%@..%%..
    0x00, 0x00, 0xd8, 0x00, 0xe6, 0x00,  //....@%..@+..
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@
    0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@
    0x00, 0x07, 0xe0, 0x09, 0xd0, 0x00,  //...+@..%@...
    0x00, 0x0c, 0x90, 0x0e, 0x70, 0x00,  //...@%..@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@.
    0x00, 0x6f, 0x00, 0x8d, 0x00, 0x00,  //..+@..%@....
    0x00, 0xab, 0x00, 0xb9, 0x00, 0x00,  //..%%..%%....
    0x00, 0xd8, 0x00, 0xf6, 0x00, 0x00,  //..@%..@+....
    0x01, 0xf4, 0x02, 0xf2, 0x00, 0x00,  //..@+..@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0024 ($) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0xf0, 0x00, 0x00,  //....@....
    0x00, 0x00, 0xf0, 0x00, 0x00,  //....@....
    0x04, 0xbe, 0xfe, 0xa3, 0x00,  //.+%@@@%..
    0x6f, 0xff, 0xff, 0xff, 0x00,  //+@@@@@@@.
    0xef, 0x91, 0xf1, 0x5c, 0x00,  //@@%.@.+@.
    0xff, 0x10, 0xf0, 0x00, 0x00,  //@@..@....
    0xbf, 0xd8, 0xf2, 0x00, 0x00,  //%@@%@....
    0x1c, 0xff, 0xff, 0xd6, 0x00,  //.@@@@@@+.
    0x00, 0x37, 0xfe, 0xff, 0x60,  //...+@@@@+
    0x00, 0x00, 0xf0, 0x6f, 0xd0,  //....@.+@@
    0x00, 0x00, 0xf0, 0x0f, 0xf0,  //....@..@@
    0xc6, 0x10, 0xf1, 0x9f, 0xe0,  //@+..@.%@@
    0xff, 0xff, 0xff, 0xff, 0x60,  //@@@@@@@@+
    0x28, 0xce, 0xfe, 0xb4, 0x00,  //.%@@@@%+.
    0x00, 0x00, 0xf0, 0x00, 0x00,  //....@....
    0x00, 0x00, 0xf0, 0x00, 0x00,  //....@....
    0x00, 0x00, 0xf0, 0x00, 0x00,  //....@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0025 (%) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x08, 0xee, 0x80, 0x00, 0x00, 0x4d, 0x00, 0x00,  //.%@@%.....+@...
    0x7f, 0x66, 0xf7, 0x00, 0x00, 0xe3, 0x00, 0x00,  //+@++@+....@....
    0xdf, 0x11, 0xfd, 0x00, 0x09, 0x90, 0x00, 0x00,  //@@..@@...%%....
    0xff, 0x00, 0xff, 0x00, 0x3e, 0x00, 0x00, 0x00,  //@@..@@...@.....
    0xdf, 0x11, 0xfd, 0x00, 0xc5, 0x00, 0x00, 0x00,  //@@..@@..@+.....
    0x8f, 0x66, 0xf7, 0x07, 0xb0, 0x00, 0x00, 0x00,  //+@++@+.+%......
    0x08, 0xee, 0x80, 0x1e, 0x10, 0x8e, 0xe8, 0x00,  //.%@@%..@..%@@%.
    0x00, 0x00, 0x00, 0xb7, 0x07, 0xf6, 0x6f, 0x70,  //......%+.+@++@+
    0x00, 0x00, 0x05, 0xc0, 0x0d, 0xf1, 0x1f, 0xd0,  //.....+@..@@..@@
    0x00, 0x00, 0x0e, 0x30, 0x0f, 0xf0, 0x0f, 0xf0,  //.....@...@@..@@
    0x00, 0x00, 0x99, 0x00, 0x0d, 0xf1, 0x1f, 0xd0,  //....%%...@@..@@
    0x00, 0x03, 0xe0, 0x00, 0x07, 0xf6, 0x6f, 0x70,  //....@....+@++@+
    0x00, 0x0d, 0x40, 0x00, 0x00, 0x8e, 0xe8, 0x00,  //...@+.....%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0026 (&) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x04, 0xcf, 0xeb, 0x40, 0x00,  //...+@@@%+...
    0x00, 0x5f, 0xff, 0xff, 0xf0, 0x00,  //..+@@@@@@...
    0x00, 0xdf, 0x70, 0x04, 0xc0, 0x00,  //..@@+..+%...
    0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //..@@........
    0x00, 0xbf, 0x80, 0x00, 0x00, 0x00,  //..%@%.......
    0x00, 0x9f, 0xf9, 0x00, 0x00, 0x00,  //..%@@%......
    0x0b, 0xf8, 0xff, 0x90, 0x1f, 0xe0,  //.%@%@@%..@@.
    0x8f, 0x50, 0x5f, 0xf9, 0x5f, 0x90,  //%@+.+@@%+@%.
    0xef, 0x00, 0x04, 0xff, 0xef, 0x10,  //@@...+@@@@..
    0xff, 0x40, 0x00, 0x6f, 0xf5, 0x00,  //@@+...+@@+..
    0xaf, 0xe5, 0x10, 0x6f, 0xf9, 0x00,  //%@@+..+@@%..
    0x1e, 0xff, 0xff, 0xfc, 0xff, 0x80,  //.@@@@@@@@@%.
    0x01, 0x8d, 0xfe, 0x90, 0x5f, 0xf8,  //..%@@@%.+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0027 (') , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0028 (() , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x8c,  //..%@
    0x02, 0xf5,  //..@+
    0x0a, 0xe0,  //.%@.
    0x1f, 0xa0,  //.@%.
    0x6f, 0x60,  //+@+.
    0xbf, 0x30,  //%@..
    0xdf, 0x10,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xdf, 0x10,  //@@..
    0xbf, 0x30,  //%@..
    0x6f, 0x60,  //+@+.
    0x1f, 0xa0,  //.@%.
    0x0a, 0xf0,  //.%@.
    0x02, 0xf5,  //..@+
    0x00, 0x8c,  //..%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0029 ()) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xc8, 0x00,  //@%..
    0x5f, 0x20,  //+@..
    0x0f, 0xa0,  //.@%.
    0x0a, 0xf1,  //.%@.
    0x06, 0xf6,  //.+@+
    0x03, 0xfa,  //..@%
    0x01, 0xfd,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x01, 0xfd,  //..@@
    0x03, 0xfa,  //..@%
    0x06, 0xf6,  //.+@+
    0x0a, 0xf1,  //.%@.
    0x0f, 0xa0,  //.@%.
    0x5f, 0x20,  //+@..
    0xc8, 0x00,  //@%..
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+002a (*) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x0f, 0x00, 0x00,  //...@...
    0xa2, 0x0f, 0x02, 0xa0,  //%..@..%
    0x5e, 0x5f, 0x5e, 0x50,  //+@+@+@+
    0x02, 0xcf, 0xc2, 0x00,  //..@@@..
    0x02, 0xcf, 0xc2, 0x00,  //..@@@..
    0x5e, 0x5f, 0x5e, 0x50,  //+@+@+@+
    0xa2, 0x0f, 0x02, 0xa0,  //%..@..%
    0x00, 0x0f, 0x00, 0x00,  //...@...
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+002b (+) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+002c (,) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x0f, 0xf0,  //.@@
    0x1f, 0xd0,  //.@@
    0x6f, 0x20,  //+@.
    0xc6, 0x00,  //@+.
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+002d (-) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002e (.) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002f (/) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x03, 0xfd,  //....@@
    0x00, 0x07, 0xf9,  //...+@%
    0x00, 0x0b, 0xf5,  //...%@+
    0x00, 0x0f, 0xf1,  //...@@.
    0x00, 0x3f, 0xd0,  //...@@.
    0x00, 0x8f, 0x90,  //..+@%.
    0x00, 0xcf, 0x40,  //..@@+.
    0x00, 0xff, 0x00,  //..@@..
    0x04, 0xfc, 0x00,  //.+@@..
    0x08, 0xf8, 0x00,  //.%@%..
    0x0d, 0xf4, 0x00,  //.@@+..
    0x1f, 0xf0, 0x00,  //.@@...
    0x5f, 0xb0, 0x00,  //+@%...
    0x9f, 0x70, 0x00,  //%@+...
    0xdf, 0x30, 0x00,  //@@....
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0030 (0) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x7d, 0xfd, 0x70, 0x00,  //..+@@@+..
    0x0a, 0xff, 0xff, 0xfa, 0x00,  //.%@@@@@%.
    0x4f, 0xf4, 0x04, 0xff, 0x40,  //+@@+.+@@+
    0xaf, 0x70, 0x00, 0x7f, 0xa0,  //%@+...+@%
    0xdf, 0x20, 0x00, 0x2f, 0xd0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x0f, 0xf0,  //@@.....@@
    0xdf, 0x20, 0x00, 0x2f, 0xd0,  //@@.....@@
    0xaf, 0x70, 0x00, 0x7f, 0xa0,  //%@+...+@%
    0x4f, 0xf4, 0x04, 0xff, 0x40,  //+@@+.+@@+
    0x0a, 0xff, 0xff, 0xfa, 0x00,  //.%@@@@@%.
    0x00, 0x8d, 0xfd, 0x80, 0x00,  //..+@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0031 (1) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x27, 0xcf, 0xf0, 0x00,  //.+@@@...
    0xff, 0xff, 0xf0, 0x00,  //@@@@@...
    0xd7, 0x2f, 0xf0, 0x00,  //@+.@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0032 (2) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x39, 0xdf, 0xea, 0x30, 0x00,  //.%@@@%...
    0xff, 0xff, 0xff, 0xf5, 0x00,  //@@@@@@@+.
    0xc5, 0x10, 0x2c, 0xfd, 0x00,  //@+...@@@.
    0x00, 0x00, 0x02, 0xff, 0x00,  //......@@.
    0x00, 0x00, 0x01, 0xfd, 0x00,  //......@@.
    0x00, 0x00, 0x08, 0xf7, 0x00,  //.....%@+.
    0x00, 0x00, 0x5f, 0xd0, 0x00,  //....+@@..
    0x00, 0x05, 0xff, 0x20, 0x00,  //...+@@...
    0x00, 0x6f, 0xf4, 0x00, 0x00,  //..+@@+...
    0x06, 0xff, 0x60, 0x00, 0x00,  //.+@@+....
    0x7f, 0xf6, 0x00, 0x00, 0x00,  //+@@+.....
    0xff, 0xff, 0xff, 0xff, 0x10,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0x10,  //@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0033 (3) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x38, 0xdf, 0xfd, 0x92, 0x00,  //.%@@@@%..
    0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@+
    0xc6, 0x20, 0x03, 0xaf, 0xd0,  //@+....%@@
    0x00, 0x00, 0x00, 0x1f, 0xe0,  //.......@@
    0x00, 0x00, 0x02, 0xaf, 0x90,  //......%@%
    0x00, 0xff, 0xff, 0xd7, 0x00,  //..@@@@@+.
    0x00, 0xff, 0xff, 0xf8, 0x00,  //..@@@@@%.
    0x00, 0x00, 0x14, 0xcf, 0x80,  //.....+@@%
    0x00, 0x00, 0x00, 0x1f, 0xe0,  //.......@@
    0x00, 0x00, 0x00, 0x2f, 0xf0,  //.......@@
    0xb4, 0x10, 0x14, 0xdf, 0xb0,  //%+...+@@%
    0xff, 0xff, 0xff, 0xfe, 0x20,  //@@@@@@@@.
    0x39, 0xdf, 0xfd, 0x81, 0x00,  //.%@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0034 (4) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x0a, 0xff, 0x00,  //.....%@@..
    0x00, 0x00, 0x5f, 0xff, 0x00,  //....+@@@..
    0x00, 0x01, 0xe7, 0xff, 0x00,  //....@+@@..
    0x00, 0x0b, 0xc0, 0xff, 0x00,  //...%@.@@..
    0x00, 0x6f, 0x20, 0xff, 0x00,  //..+@..@@..
    0x02, 0xf7, 0x00, 0xff, 0x00,  //..@+..@@..
    0x0c, 0xc0, 0x00, 0xff, 0x00,  //.@@...@@..
    0x7f, 0x20, 0x00, 0xff, 0x00,  //+@....@@..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0x00, 0xff, 0x00,  //......@@..
    0x00, 0x00, 0x00, 0xff, 0x00,  //......@@..
    0x00, 0x00, 0x00, 0xff, 0x00,  //......@@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0035 (5) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x0f, 0xff, 0xff, 0xf0,  //.@@@@@@.
    0x0f, 0xff, 0xff, 0xf0,  //.@@@@@@.
    0x0f, 0xf0, 0x00, 0x00,  //.@@.....
    0x0f, 0xf0, 0x00, 0x00,  //.@@.....
    0x0f, 0xfd, 0xfc, 0x30,  //.@@@@@..
    0x0f, 0xff, 0xff, 0xf2,  //.@@@@@@.
    0x0a, 0x20, 0x3d, 0xfa,  //.%...@@%
    0x00, 0x00, 0x03, 0xfe,  //......@@
    0x00, 0x00, 0x00, 0xff,  //......@@
    0x00, 0x00, 0x03, 0xfe,  //......@@
    0xb4, 0x00, 0x4e, 0xf9,  //%...+@@%
    0xff, 0xff, 0xff, 0xe1,  //@@@@@@@.
    0x4a, 0xef, 0xd9, 0x10,  //.%@@@%..
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0036 (6) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x3a, 0xef, 0xc4, 0x00,  //...%@@@+.
    0x04, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@.
    0x1e, 0xfb, 0x20, 0x3b, 0x00,  //.@@%...%.
    0x8f, 0xd0, 0x00, 0x00, 0x00,  //+@@......
    0xcf, 0x60, 0x00, 0x00, 0x00,  //@@+......
    0xef, 0x39, 0xef, 0xb3, 0x00,  //@@.%@@%..
    0xff, 0xaf, 0xff, 0xff, 0x30,  //@@%@@@@@.
    0xff, 0xb2, 0x02, 0xbf, 0xb0,  //@@%...%@%
    0xdf, 0x10, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xaf, 0x10, 0x00, 0x1f, 0xf0,  //%@.....@@
    0x4f, 0xb2, 0x02, 0xbf, 0xb0,  //+@%...%@%
    0x0a, 0xff, 0xff, 0xff, 0x30,  //.%@@@@@@.
    0x00, 0x7d, 0xfe, 0xa2, 0x00,  //..+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0037 (7) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@
    0x00, 0x00, 0x0a, 0xf7,  //.....%@+
    0x00, 0x00, 0x0f, 0xf2,  //.....@@.
    0x00, 0x00, 0x4f, 0xd0,  //....+@@.
    0x00, 0x00, 0x9f, 0x70,  //....%@+.
    0x00, 0x00, 0xef, 0x20,  //....@@..
    0x00, 0x03, 0xfd, 0x00,  //....@@..
    0x00, 0x09, 0xf8, 0x00,  //...%@%..
    0x00, 0x0e, 0xf3, 0x00,  //...@@...
    0x00, 0x3f, 0xe0, 0x00,  //...@@...
    0x00, 0x8f, 0x90, 0x00,  //..%@%...
    0x00, 0xdf, 0x40, 0x00,  //..@@+...
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0038 (8) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x04, 0xbe, 0xfe, 0xb4, 0x00,  //.+%@@@%+.
    0x6f, 0xff, 0xff, 0xff, 0x60,  //+@@@@@@@+
    0xef, 0x91, 0x01, 0x9f, 0xe0,  //@@%...%@@
    0xef, 0x00, 0x00, 0x1f, 0xe0,  //@@.....@@
    0x9f, 0x91, 0x01, 0x9f, 0x90,  //%@%...%@%
    0x07, 0xef, 0xff, 0xe7, 0x00,  //.+@@@@@+.
    0x08, 0xff, 0xff, 0xf8, 0x00,  //.%@@@@@%.
    0x8f, 0xb2, 0x02, 0xbf, 0x80,  //%@%...%@%
    0xef, 0x10, 0x00, 0x1f, 0xe0,  //@@.....@@
    0xff, 0x10, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xcf, 0xb2, 0x02, 0xbf, 0xc0,  //@@%...%@@
    0x4f, 0xff, 0xff, 0xff, 0x40,  //+@@@@@@@+
    0x02, 0xad, 0xfe, 0xb3, 0x00,  //..%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0039 (9) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x02, 0xae, 0xfd, 0x70, 0x00,  //..%@@@+..
    0x3f, 0xff, 0xff, 0xf9, 0x00,  //.@@@@@@%.
    0xbf, 0xb2, 0x02, 0xbf, 0x30,  //%@%...%@.
    0xff, 0x10, 0x00, 0x1f, 0x90,  //@@.....@%
    0xff, 0x10, 0x00, 0x1f, 0xd0,  //@@.....@@
    0xcf, 0xb2, 0x02, 0xbf, 0xf0,  //%@%...%@@
    0x4f, 0xff, 0xff, 0xaf, 0xf0,  //.@@@@@%@@
    0x03, 0xbf, 0xe9, 0x3f, 0xe0,  //..%@@%.@@
    0x00, 0x00, 0x00, 0x6f, 0xc0,  //......+@@
    0x00, 0x00, 0x00, 0xdf, 0x70,  //......@@+
    0x0b, 0x30, 0x2b, 0xfe, 0x10,  //.%...%@@.
    0x0f, 0xff, 0xff, 0xf4, 0x00,  //.@@@@@@+.
    0x04, 0xcf, 0xea, 0x30, 0x00,  //.+@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+003a (:) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+003b (;) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x0f, 0xf0,  //.@@
    0x0f, 0xf0,  //.@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x0f, 0xf0,  //.@@
    0x1f, 0xd0,  //.@@
    0x6f, 0x20,  //+@.
    0xc6, 0x00,  //@+.
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+003c (<) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x16, 0xc0,  //.........+@
    0x00, 0x00, 0x00, 0x4a, 0xff, 0xf0,  //.......%@@@
    0x00, 0x01, 0x7d, 0xff, 0xfb, 0x50,  //....+@@@@%+
    0x05, 0xbf, 0xff, 0xd7, 0x10, 0x00,  //.+%@@@@+...
    0xef, 0xff, 0xa4, 0x00, 0x00, 0x00,  //@@@@%+.....
    0xef, 0xff, 0xa4, 0x00, 0x00, 0x00,  //@@@@%+.....
    0x05, 0xbf, 0xff, 0xd7, 0x10, 0x00,  //.+%@@@@+...
    0x00, 0x01, 0x7d, 0xff, 0xfb, 0x50,  //....+@@@@%+
    0x00, 0x00, 0x00, 0x4a, 0xff, 0xf0,  //......+%@@@
    0x00, 0x00, 0x00, 0x00, 0x16, 0xc0,  //.........+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003d (=) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003e (>) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.........
    0xff, 0xfa, 0x40, 0x00, 0x00, 0x00,  //@@@%.......
    0x5b, 0xff, 0xfd, 0x71, 0x00, 0x00,  //+%@@@@+....
    0x00, 0x17, 0xdf, 0xff, 0xb5, 0x00,  //...+@@@@%+.
    0x00, 0x00, 0x04, 0xaf, 0xff, 0xe0,  //.....+%@@@@
    0x00, 0x00, 0x04, 0xaf, 0xff, 0xe0,  //.....+%@@@@
    0x00, 0x17, 0xdf, 0xff, 0xb5, 0x00,  //...+@@@@%+.
    0x5b, 0xff, 0xfd, 0x71, 0x00, 0x00,  //+%@@@@+....
    0xff, 0xfa, 0x40, 0x00, 0x00, 0x00,  //@@@%+......
    0xc6, 0x10, 0x00, 0x00, 0x00, 0x00,  //@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003f (?) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x4a, 0xef, 0xd6, 0x00,  //.%@@@+.
    0xff, 0xff, 0xff, 0x70,  //@@@@@@+
    0xc4, 0x01, 0x9f, 0xd0,  //@+..%@@
    0x00, 0x00, 0x0f, 0xf0,  //.....@@
    0x00, 0x00, 0x4f, 0xa0,  //....+@%
    0x00, 0x02, 0xed, 0x10,  //....@@.
    0x00, 0x2e, 0xd1, 0x00,  //...@@..
    0x00, 0xcf, 0x30, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0040 (@) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x18, 0xce, 0xfe, 0xb6, 0x00, 0x00,  //.....%@@@@%+....
    0x00, 0x08, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x00,  //...%@@@@@@@@@+..
    0x00, 0xbf, 0xf9, 0x30, 0x01, 0x5b, 0xff, 0x60,  //..%@@%....+%@@+.
    0x09, 0xfe, 0x30, 0x00, 0x00, 0x00, 0x6f, 0xf2,  //.%@@........+@@.
    0x2f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfa,  //.@@..........+@%
    0x9f, 0x90, 0x02, 0xce, 0x3f, 0xf0, 0x01, 0xfe,  //%@%...@@.@@...@@
    0xdf, 0x30, 0x0b, 0xff, 0xcf, 0xf0, 0x00, 0xff,  //@@...%@@@@@...@@
    0xff, 0x00, 0x0e, 0xf3, 0x3f, 0xf0, 0x05, 0xfc,  //@@...@@..@@..+@@
    0xff, 0x00, 0x0e, 0xf3, 0x3f, 0xf1, 0x7f, 0xf5,  //@@...@@..@@.+@@+
    0xdf, 0x20, 0x0b, 0xff, 0xcf, 0xff, 0xff, 0x60,  //@@...%@@@@@@@@+.
    0x9f, 0x80, 0x02, 0xce, 0x3f, 0xeb, 0x71, 0x00,  //%@%...@@.@@%+...
    0x4f, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@.............
    0x0b, 0xfd, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@............
    0x01, 0xdf, 0xf8, 0x20, 0x02, 0x8d, 0x20, 0x00,  //..@@@+....+@....
    0x00, 0x1b, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x00,  //...%@@@@@@@@....
    0x00, 0x00, 0x4a, 0xef, 0xeb, 0x50, 0x00, 0x00,  //....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0041 (A) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x5f, 0xf5, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x00,  //....@@@@....
    0x00, 0x02, 0xfc, 0xcf, 0x20, 0x00,  //....@@@@....
    0x00, 0x09, 0xf6, 0x5f, 0x90, 0x00,  //...%@++@%...
    0x00, 0x0e, 0xf0, 0x0e, 0xe0, 0x00,  //...@@..@@...
    0x00, 0x5f, 0xa0, 0x08, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0xcf, 0x30, 0x02, 0xfc, 0x00,  //..@@....@@..
    0x02, 0xff, 0xff, 0xff, 0xff, 0x20,  //..@@@@@@@@..
    0x09, 0xff, 0xff, 0xff, 0xff, 0x90,  //.%@@@@@@@@%.
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@.
    0x6f, 0xb0, 0x00, 0x00, 0x0b, 0xf6,  //+@%......%@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0042 (B) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xfc, 0x60, 0x00,  //@@@@@@+..
    0xff, 0xff, 0xff, 0xf8, 0x00,  //@@@@@@@%.
    0xff, 0x00, 0x07, 0xfe, 0x00,  //@@...+@@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@@....@@.
    0xff, 0x00, 0x07, 0xfa, 0x00,  //@@...+@%.
    0xff, 0xff, 0xff, 0x91, 0x00,  //@@@@@@%..
    0xff, 0xff, 0xff, 0xd6, 0x00,  //@@@@@@@+.
    0xff, 0x00, 0x02, 0xbf, 0x60,  //@@....%@+
    0xff, 0x00, 0x00, 0x1f, 0xd0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x02, 0xbf, 0xc0,  //@@....%@@
    0xff, 0xff, 0xff, 0xff, 0x40,  //@@@@@@@@+
    0xff, 0xff, 0xfe, 0xa3, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0043 (C) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x05, 0xbe, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x0c, 0xfe, 0x61, 0x00, 0x26, 0xc0,  //.@@@+....+@
    0x6f, 0xd1, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0xbf, 0x50, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0xef, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xef, 0x10, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xbf, 0x50, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0x6f, 0xd1, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0x0c, 0xfe, 0x61, 0x00, 0x26, 0xc0,  //.@@@+....+@
    0x01, 0xcf, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x00, 0x06, 0xbe, 0xff, 0xd9, 0x30,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0044 (D) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xfe, 0xb6, 0x00, 0x00,  //@@@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //@@@@@@@@@..
    0xff, 0x00, 0x01, 0x5d, 0xfe, 0x10,  //@@....+@@@.
    0xff, 0x00, 0x00, 0x00, 0xdf, 0x70,  //@@......@@+
    0xff, 0x00, 0x00, 0x00, 0x5f, 0xc0,  //@@......+@@
    0xff, 0x00, 0x00, 0x00, 0x1f, 0xe0,  //@@.......@@
    0xff, 0x00, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0xff, 0x00, 0x00, 0x00, 0x1f, 0xe0,  //@@.......@@
    0xff, 0x00, 0x00, 0x00, 0x5f, 0xc0,  //@@......+@@
    0xff, 0x00, 0x00, 0x00, 0xdf, 0x70,  //@@......@@+
    0xff, 0x00, 0x01, 0x5d, 0xfe, 0x10,  //@@....+@@@.
    0xff, 0xff, 0xff, 0xff, 0xe3, 0x00,  //@@@@@@@@@..
    0xff, 0xff, 0xfe, 0xb6, 0x00, 0x00,  //@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0045 (E) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0046 (F) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@.
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@.
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0047 (G) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x06, 0xbe, 0xff, 0xc9, 0x30,  //...+%@@@@%.
    0x02, 0xdf, 0xff, 0xff, 0xff, 0xf0,  //..@@@@@@@@@
    0x0d, 0xfd, 0x51, 0x00, 0x26, 0xc0,  //.@@@+....+@
    0x6f, 0xd0, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0xcf, 0x50, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0xef, 0x10, 0x00, 0xff, 0xff, 0xf0,  //@@....@@@@@
    0xff, 0x00, 0x00, 0xff, 0xff, 0xf0,  //@@....@@@@@
    0xef, 0x10, 0x00, 0x00, 0x0f, 0xf0,  //@@.......@@
    0xcf, 0x40, 0x00, 0x00, 0x0f, 0xf0,  //@@+......@@
    0x7f, 0xc0, 0x00, 0x00, 0x0f, 0xf0,  //+@@......@@
    0x0d, 0xfc, 0x40, 0x01, 0x6f, 0xf0,  //.@@@+...+@@
    0x02, 0xef, 0xff, 0xff, 0xff, 0x60,  //..@@@@@@@@+
    0x00, 0x07, 0xcf, 0xfd, 0x92, 0x00,  //...+@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0048 (H) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0049 (I) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+004a (J) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x02, 0xfe,  //..@@
    0x2b, 0xfa,  //.%@%
    0xff, 0xf3,  //@@@.
    0xfb, 0x30,  //@%..


    /*Unicode: U+004b (K) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0x00, 0x00, 0x2e, 0xf7, 0x00,  //@@.....@@+.
    0xff, 0x00, 0x02, 0xef, 0x60, 0x00,  //@@....@@+..
    0xff, 0x00, 0x2e, 0xf6, 0x00, 0x00,  //@@...@@+...
    0xff, 0x02, 0xef, 0x50, 0x00, 0x00,  //@@..@@+....
    0xff, 0x3e, 0xf4, 0x00, 0x00, 0x00,  //@@.@@+.....
    0xff, 0xef, 0x40, 0x00, 0x00, 0x00,  //@@@@+......
    0xff, 0xfe, 0x20, 0x00, 0x00, 0x00,  //@@@@.......
    0xff, 0x4f, 0xe2, 0x00, 0x00, 0x00,  //@@+@@......
    0xff, 0x05, 0xfe, 0x30, 0x00, 0x00,  //@@.+@@.....
    0xff, 0x00, 0x5f, 0xe3, 0x00, 0x00,  //@@..+@@....
    0xff, 0x00, 0x06, 0xff, 0x30, 0x00,  //@@...+@@...
    0xff, 0x00, 0x00, 0x6f, 0xf4, 0x00,  //@@....+@@..
    0xff, 0x00, 0x00, 0x07, 0xff, 0x40,  //@@.....+@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+004c (L) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+004d (M) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xf6, 0x00, 0x00, 0x4f, 0xff,  //@@@+....+@@@
    0xff, 0xfc, 0x00, 0x00, 0xaf, 0xff,  //@@@%....%@@@
    0xff, 0xaf, 0x20, 0x01, 0xfa, 0xff,  //@@%@....@%@@
    0xff, 0x4f, 0x80, 0x07, 0xf4, 0xff,  //@@.@+..+@.@@
    0xff, 0x0e, 0xd0, 0x0d, 0xd0, 0xff,  //@@.@@..@@.@@
    0xff, 0x08, 0xf3, 0x3f, 0x80, 0xff,  //@@.%@..@+.@@
    0xff, 0x02, 0xf9, 0x9f, 0x20, 0xff,  //@@..@%%@..@@
    0xff, 0x00, 0xcf, 0xfc, 0x00, 0xff,  //@@..@@@@..@@
    0xff, 0x00, 0x6f, 0xf6, 0x00, 0xff,  //@@..+@@+..@@
    0xff, 0x00, 0x0f, 0xf0, 0x00, 0xff,  //@@...@@...@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+004e (N) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x80, 0x00, 0x00, 0xff,  //@@%.....@@
    0xff, 0xf2, 0x00, 0x00, 0xff,  //@@@.....@@
    0xff, 0xfb, 0x00, 0x00, 0xff,  //@@@%....@@
    0xff, 0xbf, 0x40, 0x00, 0xff,  //@@%@+...@@
    0xff, 0x2f, 0xd0, 0x00, 0xff,  //@@.@@...@@
    0xff, 0x08, 0xf7, 0x00, 0xff,  //@@.%@+..@@
    0xff, 0x01, 0xef, 0x10, 0xff,  //@@..@@..@@
    0xff, 0x00, 0x6f, 0xa0, 0xff,  //@@..+@%.@@
    0xff, 0x00, 0x0d, 0xf4, 0xff,  //@@...@@.@@
    0xff, 0x00, 0x04, 0xfd, 0xff,  //@@...+@@@@
    0xff, 0x00, 0x00, 0xaf, 0xff,  //@@....%@@@
    0xff, 0x00, 0x00, 0x2f, 0xff,  //@@.....@@@
    0xff, 0x00, 0x00, 0x08, 0xff,  //@@.....%@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+004f (O) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x07, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf6,  //+@@......@@+
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x00, 0x08, 0xdf, 0xfd, 0x80, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0050 (P) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xfc, 0x40,  //@@@@@%+.
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@+
    0xff, 0x00, 0x1a, 0xfc,  //@@...%@@
    0xff, 0x00, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x1a, 0xfc,  //@@...%@@
    0xff, 0xff, 0xff, 0xf4,  //@@@@@@@+
    0xff, 0xff, 0xfc, 0x40,  //@@@@@@+.
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0051 (Q) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x07, 0xdf, 0xfd, 0x81, 0x00,  //...+@@@@%...
    0x02, 0xef, 0xff, 0xff, 0xfe, 0x20,  //..@@@@@@@@..
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xd0,  //.@@@+..+@@@.
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf7,  //+@@......@@+
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //%@+......+@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfe,  //@@........@@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@@........@@
    0xef, 0x10, 0x00, 0x00, 0x01, 0xfd,  //@@........@@
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfb,  //%@+......+@%
    0x6f, 0xd0, 0x00, 0x00, 0x0d, 0xf4,  //+@@......@@+
    0x0d, 0xfc, 0x40, 0x04, 0xcf, 0xa0,  //.@@@+..+@@%.
    0x02, 0xef, 0xff, 0xff, 0xfa, 0x00,  //..@@@@@@@%..
    0x00, 0x18, 0xdf, 0xff, 0xa0, 0x00,  //...%@@@@%...
    0x00, 0x00, 0x00, 0x4f, 0xf6, 0x00,  //......+@@+..
    0x00, 0x00, 0x00, 0x06, 0xff, 0x40,  //.......+@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0052 (R) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xfc, 0x50, 0x00,  //@@@@@@+...
    0xff, 0xff, 0xff, 0xf5, 0x00,  //@@@@@@@+..
    0xff, 0x00, 0x1a, 0xfc, 0x00,  //@@...%@@..
    0xff, 0x00, 0x01, 0xff, 0x00,  //@@....@@..
    0xff, 0x00, 0x01, 0xfe, 0x00,  //@@....@@..
    0xff, 0x00, 0x1a, 0xfa, 0x00,  //@@...%@%..
    0xff, 0xff, 0xff, 0xc1, 0x00,  //@@@@@@@...
    0xff, 0xff, 0xff, 0x40, 0x00,  //@@@@@@+...
    0xff, 0x00, 0x5f, 0xf3, 0x00,  //@@..+@@...
    0xff, 0x00, 0x07, 0xfc, 0x00,  //@@...+@@..
    0xff, 0x00, 0x00, 0xdf, 0x60,  //@@....@@+.
    0xff, 0x00, 0x00, 0x4f, 0xe1,  //@@....+@@.
    0xff, 0x00, 0x00, 0x0a, 0xfa,  //@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0053 (S) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x03, 0xbe, 0xfd, 0x93, 0x00,  //..%@@@%..
    0x5f, 0xff, 0xff, 0xff, 0x00,  //+@@@@@@@.
    0xdf, 0xb2, 0x01, 0x5b, 0x00,  //@@%...+%.
    0xff, 0x10, 0x00, 0x00, 0x00,  //@@.......
    0xdf, 0x71, 0x00, 0x00, 0x00,  //@@+......
    0x5f, 0xff, 0xda, 0x50, 0x00,  //+@@@@%+..
    0x04, 0xbf, 0xff, 0xfc, 0x10,  //..%@@@@@.
    0x00, 0x00, 0x26, 0xdf, 0x90,  //.....+@@%
    0x00, 0x00, 0x00, 0x2f, 0xe0,  //.......@@
    0x00, 0x00, 0x00, 0x1f, 0xf0,  //.......@@
    0xc6, 0x20, 0x03, 0xcf, 0xd0,  //@+....%@@
    0xff, 0xff, 0xff, 0xff, 0x50,  //@@@@@@@@+
    0x38, 0xdf, 0xfe, 0xa3, 0x00,  //.%@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0054 (T) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0055 (U) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@@......@@
    0xef, 0x10, 0x00, 0x01, 0xfe,  //@@......@@
    0xcf, 0x50, 0x00, 0x05, 0xfc,  //@@+....+@@
    0x6f, 0xe5, 0x11, 0x5e, 0xf6,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xc0,  //.@@@@@@@@.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0056 (V) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xcf, 0x50, 0x00, 0x00, 0x05, 0xfc,  //@@+......+@@
    0x6f, 0xb0, 0x00, 0x00, 0x0b, 0xf6,  //+@%......%@+
    0x0f, 0xf1, 0x00, 0x00, 0x1f, 0xf0,  //.@@......@@.
    0x09, 0xf7, 0x00, 0x00, 0x7f, 0x90,  //.%@+....+@%.
    0x03, 0xfd, 0x00, 0x00, 0xdf, 0x30,  //..@@....@@..
    0x00, 0xdf, 0x30, 0x04, 0xfd, 0x00,  //..@@....@@..
    0x00, 0x6f, 0xa0, 0x0a, 0xf7, 0x00,  //..+@%..%@+..
    0x00, 0x1f, 0xf0, 0x0f, 0xf1, 0x00,  //...@@..@@...
    0x00, 0x0a, 0xf6, 0x6f, 0xa0, 0x00,  //...%@++@%...
    0x00, 0x04, 0xfc, 0xcf, 0x40, 0x00,  //....@@@@+...
    0x00, 0x00, 0xdf, 0xfd, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x7f, 0xf7, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x1f, 0xf1, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0057 (W) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xdf, 0x20, 0x00, 0x3f, 0xff, 0x20, 0x00, 0x2f, 0xd0,  //@@.....@@@.....@@
    0x9f, 0x60, 0x00, 0x7f, 0xff, 0x60, 0x00, 0x6f, 0x90,  //%@+...+@@@+...+@%
    0x5f, 0xb0, 0x00, 0xbf, 0x9f, 0xa0, 0x00, 0xaf, 0x50,  //+@%...%@%@%...%@+
    0x1f, 0xe0, 0x00, 0xff, 0x1f, 0xe0, 0x00, 0xef, 0x10,  //.@@...@@.@@...@@.
    0x0d, 0xf3, 0x03, 0xfc, 0x0c, 0xf2, 0x02, 0xfd, 0x00,  //.@@...@@.@@...@@.
    0x09, 0xf7, 0x07, 0xf8, 0x08, 0xf6, 0x06, 0xf9, 0x00,  //.%@+.+@%.%@+.+@%.
    0x05, 0xfb, 0x0b, 0xf4, 0x04, 0xfa, 0x0a, 0xf4, 0x00,  //.+@%.%@+.+@%.%@+.
    0x01, 0xfe, 0x0f, 0xf0, 0x00, 0xfe, 0x0e, 0xf0, 0x00,  //..@@.@@...@@.@@..
    0x00, 0xcf, 0x6f, 0xc0, 0x00, 0xcf, 0x5f, 0xc0, 0x00,  //..@@+@@...@@+@@..
    0x00, 0x8f, 0xef, 0x80, 0x00, 0x8f, 0xdf, 0x80, 0x00,  //..%@@@%...%@@@%..
    0x00, 0x4f, 0xff, 0x40, 0x00, 0x4f, 0xff, 0x40, 0x00,  //..+@@@+...+@@@+..
    0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x0c, 0xfc, 0x00, 0x00, 0x0c, 0xfc, 0x00, 0x00,  //...@@@.....@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0058 (X) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x0b, 0xfb, 0x00, 0x00, 0xbf, 0xa0,  //.%@%....%@%
    0x02, 0xff, 0x40, 0x06, 0xfe, 0x10,  //..@@+..+@@.
    0x00, 0x8f, 0xd0, 0x1f, 0xf5, 0x00,  //..%@@..@@+.
    0x00, 0x0e, 0xf7, 0xbf, 0xb0, 0x00,  //...@@+%@%..
    0x00, 0x05, 0xff, 0xfe, 0x10, 0x00,  //...+@@@@...
    0x00, 0x00, 0xcf, 0xf6, 0x00, 0x00,  //....%@@+...
    0x00, 0x00, 0xbf, 0xf3, 0x00, 0x00,  //....%@@....
    0x00, 0x05, 0xff, 0xfc, 0x00, 0x00,  //...+@@@@...
    0x00, 0x1e, 0xf7, 0xef, 0x50, 0x00,  //...@@+@@+..
    0x00, 0xaf, 0xb0, 0x6f, 0xe0, 0x00,  //..%@%.+@@..
    0x05, 0xff, 0x20, 0x0d, 0xf8, 0x00,  //.+@@...@@%.
    0x1e, 0xf7, 0x00, 0x03, 0xff, 0x20,  //.@@+....@@.
    0xaf, 0xc0, 0x00, 0x00, 0xaf, 0xb0,  //%@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0059 (Y) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xaf, 0xc0, 0x00, 0x00, 0x0c, 0xfa,  //%@@......@@%
    0x0d, 0xf7, 0x00, 0x00, 0x7f, 0xd0,  //.@@+....+@@.
    0x03, 0xff, 0x20, 0x02, 0xff, 0x30,  //..@@....@@..
    0x00, 0x6f, 0xb0, 0x0b, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0x0b, 0xf6, 0x6f, 0xb0, 0x00,  //...%@++@%...
    0x00, 0x01, 0xef, 0xfe, 0x10, 0x00,  //....@@@@....
    0x00, 0x00, 0x3f, 0xf3, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+005a (Z) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x0b, 0xfe, 0x10,  //.......%@@.
    0x00, 0x00, 0x00, 0x8f, 0xf3, 0x00,  //......%@@..
    0x00, 0x00, 0x05, 0xff, 0x60, 0x00,  //.....+@@+..
    0x00, 0x00, 0x2f, 0xf9, 0x00, 0x00,  //.....@@%...
    0x00, 0x00, 0xdf, 0xb0, 0x00, 0x00,  //....@@%....
    0x00, 0x0a, 0xfd, 0x10, 0x00, 0x00,  //...%@@.....
    0x00, 0x7f, 0xf2, 0x00, 0x00, 0x00,  //..+@@......
    0x04, 0xff, 0x50, 0x00, 0x00, 0x00,  //.+@@+......
    0x1e, 0xf8, 0x00, 0x00, 0x00, 0x00,  //.@@%.......
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005b ([) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xff, 0xff,  //@@@@
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0x00,  //@@..
    0xff, 0xff,  //@@@@
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+005c (\) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xdf, 0x30, 0x00,  //@@....
    0x9f, 0x70, 0x00,  //%@+...
    0x5f, 0xb0, 0x00,  //+@%...
    0x1f, 0xf0, 0x00,  //.@@...
    0x0d, 0xf4, 0x00,  //.@@+..
    0x08, 0xf8, 0x00,  //.%@%..
    0x04, 0xfc, 0x00,  //.+@@..
    0x00, 0xff, 0x00,  //..@@..
    0x00, 0xcf, 0x40,  //..@@+.
    0x00, 0x8f, 0x90,  //..+@%.
    0x00, 0x3f, 0xd0,  //...@@.
    0x00, 0x0f, 0xf1,  //...@@.
    0x00, 0x0b, 0xf5,  //...%@+
    0x00, 0x07, 0xf9,  //...+@%
    0x00, 0x03, 0xfd,  //....@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+005d (]) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xff, 0xff,  //@@@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0xff, 0xff,  //@@@@
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+005e (^) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0xcf, 0xc0, 0x00, 0x00,  //....@@@....
    0x00, 0x0b, 0xfa, 0xfb, 0x00, 0x00,  //...%@%@%...
    0x00, 0xaf, 0x60, 0x6f, 0xa0, 0x00,  //..%@+.+@%..
    0x09, 0xf5, 0x00, 0x05, 0xf9, 0x00,  //.%@+...+@%.
    0x8f, 0x40, 0x00, 0x00, 0x4f, 0x80,  //%@+.....+@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005f (_) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xf0,  //@@@@@@@@@


    /*Unicode: U+0060 (`) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x8e, 0x10,  //%@..
    0x0a, 0xc0,  //.%@.
    0x00, 0xb9,  //..%%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0061 (a) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x04, 0xbe, 0xfc, 0x40,  //.+%@@@+.
    0x0f, 0xff, 0xff, 0xf3,  //.@@@@@@.
    0x0a, 0x30, 0x2a, 0xfa,  //.%...%@%
    0x00, 0x00, 0x01, 0xfe,  //......@@
    0x07, 0xcf, 0xff, 0xff,  //.+@@@@@@
    0x8f, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xef, 0x51, 0x01, 0xff,  //@@+...@@
    0xef, 0x40, 0x2a, 0xff,  //@@+..%@@
    0xaf, 0xff, 0xfa, 0xff,  //%@@@@%@@
    0x1a, 0xee, 0x90, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0062 (b) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x09, 0xef, 0xa1, 0x00,  //@@.%@@%..
    0xff, 0xaf, 0xff, 0xfe, 0x10,  //@@%@@@@@.
    0xff, 0xd3, 0x03, 0xef, 0x80,  //@@@...@@%
    0xff, 0x40, 0x00, 0x4f, 0xd0,  //@@+...+@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x40, 0x00, 0x4f, 0xd0,  //@@+...+@@
    0xff, 0xd3, 0x03, 0xef, 0x80,  //@@@...@@%
    0xff, 0xaf, 0xff, 0xfe, 0x10,  //@@%@@@@@.
    0xff, 0x09, 0xef, 0xa2, 0x00,  //@@.%@@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0063 (c) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x6c, 0xff, 0xb4,  //..+@@@%+
    0x0b, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x7f, 0xf6, 0x10, 0x3a,  //+@@+...%
    0xcf, 0x60, 0x00, 0x00,  //@@+.....
    0xff, 0x10, 0x00, 0x00,  //@@......
    0xff, 0x10, 0x00, 0x00,  //@@......
    0xcf, 0x60, 0x00, 0x00,  //@@+.....
    0x7f, 0xf6, 0x10, 0x3a,  //+@@+...%
    0x0b, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x7d, 0xff, 0xb4,  //..+@@@%+
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0064 (d) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x02, 0xaf, 0xe9, 0x0f, 0xf0,  //..%@@%.@@
    0x1e, 0xff, 0xff, 0xaf, 0xf0,  //.@@@@@%@@
    0x8f, 0xd3, 0x03, 0xef, 0xf0,  //%@@...@@@
    0xdf, 0x40, 0x00, 0x4f, 0xf0,  //@@+...+@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xdf, 0x40, 0x00, 0x4f, 0xf0,  //@@+...+@@
    0x8f, 0xd3, 0x03, 0xef, 0xf0,  //%@@...@@@
    0x1e, 0xff, 0xff, 0xaf, 0xf0,  //.@@@@@%@@
    0x02, 0xbf, 0xe9, 0x0f, 0xf0,  //..%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0065 (e) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x5b, 0xef, 0xd8, 0x00,  //..+%@@@%..
    0x0a, 0xff, 0xff, 0xff, 0xd0,  //.%@@@@@@@.
    0x6f, 0xe5, 0x10, 0x3c, 0xf8,  //+@@+...@@%
    0xcf, 0x30, 0x00, 0x02, 0xfd,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xcf, 0x30, 0x00, 0x00, 0x00,  //@@........
    0x6f, 0xe6, 0x10, 0x02, 0x6c,  //+@@+....+@
    0x09, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x4a, 0xef, 0xfd, 0x82,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0066 (f) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x08, 0xdf, 0xf0,  //...%@@@
    0x00, 0x8f, 0xff, 0xf0,  //..%@@@@
    0x00, 0xdf, 0x50, 0x00,  //..@@+..
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0xff, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0067 (g) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x02, 0xbf, 0xe9, 0x0f, 0xf0,  //..%@@%.@@
    0x1e, 0xff, 0xff, 0xaf, 0xf0,  //.@@@@@%@@
    0x8f, 0xd3, 0x03, 0xdf, 0xf0,  //%@@...@@@
    0xdf, 0x40, 0x00, 0x4f, 0xf0,  //@@+...+@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xdf, 0x40, 0x00, 0x4f, 0xf0,  //@@+...+@@
    0x8f, 0xd3, 0x03, 0xdf, 0xf0,  //%@@...@@@
    0x1e, 0xff, 0xff, 0xaf, 0xf0,  //.@@@@@%@@
    0x02, 0xbf, 0xe9, 0x2f, 0xe0,  //..%@@%.@@
    0x00, 0x00, 0x00, 0x6f, 0xb0,  //......+@%
    0x0a, 0x30, 0x16, 0xff, 0x60,  //.%...+@@+
    0x0f, 0xff, 0xff, 0xfc, 0x00,  //.@@@@@@@.
    0x04, 0xbe, 0xfd, 0x80, 0x00,  //.+%@@@%..


    /*Unicode: U+0068 (h) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x00, 0x00, 0x00,  //@@......
    0xff, 0x09, 0xfe, 0x80,  //@@.%@@%.
    0xff, 0xaf, 0xff, 0xf6,  //@@%@@@@+
    0xff, 0xc2, 0x09, 0xfc,  //@@@..%@@
    0xff, 0x30, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0069 (i) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+006a (j) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x00, 0xff,  //..@@
    0x07, 0xfd,  //.+@@
    0xff, 0xf7,  //@@@+
    0xfd, 0x70,  //@@+.


    /*Unicode: U+006b (k) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x03, 0xef, 0x70,  //@@....@@+
    0xff, 0x00, 0x4f, 0xf6, 0x00,  //@@..+@@+.
    0xff, 0x04, 0xff, 0x50, 0x00,  //@@.+@@+..
    0xff, 0x5f, 0xf4, 0x00, 0x00,  //@@+@@+...
    0xff, 0xfe, 0x30, 0x00, 0x00,  //@@@@.....
    0xff, 0xff, 0x50, 0x00, 0x00,  //@@@@+....
    0xff, 0x6f, 0xf5, 0x00, 0x00,  //@@+@@+...
    0xff, 0x06, 0xff, 0x60, 0x00,  //@@.+@@+..
    0xff, 0x00, 0x7f, 0xf6, 0x00,  //@@..+@@+.
    0xff, 0x00, 0x07, 0xff, 0x70,  //@@...+@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+006c (l) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+006d (m) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0x09, 0xfe, 0x60, 0x1a, 0xee, 0x80,  //@@.%@@+..%@@%.
    0xff, 0xaf, 0xff, 0xf4, 0xcf, 0xff, 0xf5,  //@@%@@@@+@@@@@+
    0xff, 0xc2, 0x09, 0xfe, 0xc2, 0x09, 0xfc,  //@@@..%@@@..%@@
    0xff, 0x30, 0x01, 0xff, 0x30, 0x01, 0xfe,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@@....@@....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+006e (n) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x09, 0xfe, 0x80,  //@@.%@@%.
    0xff, 0xaf, 0xff, 0xf6,  //@@%@@@@+
    0xff, 0xc2, 0x09, 0xfc,  //@@@..%@@
    0xff, 0x30, 0x01, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+006f (o) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x7c, 0xff, 0xc7, 0x00,  //..+@@@@+..
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x7f, 0xe6, 0x11, 0x6f, 0xf7,  //+@@+..+@@+
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xff, 0x10, 0x00, 0x01, 0xff,  //@@......@@
    0xdf, 0x50, 0x00, 0x06, 0xfc,  //@@+....+@@
    0x7f, 0xe5, 0x11, 0x5e, 0xf7,  //+@@+..+@@+
    0x0c, 0xff, 0xff, 0xff, 0xb0,  //.%@@@@@@%.
    0x00, 0x7d, 0xff, 0xd7, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0070 (p) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0x09, 0xef, 0xa1, 0x00,  //@@.%@@%..
    0xff, 0xaf, 0xff, 0xfe, 0x10,  //@@%@@@@@.
    0xff, 0xd3, 0x03, 0xef, 0x80,  //@@@...@@%
    0xff, 0x40, 0x00, 0x4f, 0xd0,  //@@+...+@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x40, 0x00, 0x4f, 0xd0,  //@@+...+@@
    0xff, 0xd3, 0x03, 0xef, 0x80,  //@@@...@@%
    0xff, 0xaf, 0xff, 0xfe, 0x10,  //@@%@@@@@.
    0xff, 0x09, 0xef, 0xa2, 0x00,  //@@.%@@%..
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0x00, 0x00, 0x00, 0x00,  //@@.......


    /*Unicode: U+0071 (q) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x02, 0xaf, 0xe9, 0x0f, 0xf0,  //..%@@%.@@
    0x1e, 0xff, 0xff, 0xaf, 0xf0,  //.@@@@@%@@
    0x8f, 0xd3, 0x03, 0xef, 0xf0,  //%@@...@@@
    0xdf, 0x40, 0x00, 0x4f, 0xf0,  //@@+...+@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xff, 0x00, 0x00, 0x1f, 0xf0,  //@@.....@@
    0xdf, 0x40, 0x00, 0x4f, 0xf0,  //@@+...+@@
    0x8f, 0xd3, 0x03, 0xef, 0xf0,  //%@@...@@@
    0x1e, 0xff, 0xff, 0xaf, 0xf0,  //.@@@@@%@@
    0x02, 0xbf, 0xe9, 0x0f, 0xf0,  //..%@@%.@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@
    0x00, 0x00, 0x00, 0x0f, 0xf0,  //.......@@


    /*Unicode: U+0072 (r) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xff, 0x09, 0xef,  //@@.%@@
    0xff, 0xaf, 0xff,  //@@%@@@
    0xff, 0xe4, 0x00,  //@@@+..
    0xff, 0x50, 0x00,  //@@+...
    0xff, 0x10, 0x00,  //@@....
    0xff, 0x00, 0x00,  //@@....
    0xff, 0x00, 0x00,  //@@....
    0xff, 0x00, 0x00,  //@@....
    0xff, 0x00, 0x00,  //@@....
    0xff, 0x00, 0x00,  //@@....
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0073 (s) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x08, 0xdf, 0xfb, 0x40,  //.+@@@%+
    0x9f, 0xff, 0xff, 0xf0,  //%@@@@@@
    0xef, 0x71, 0x03, 0xa0,  //@@+...%
    0xdf, 0xb7, 0x30, 0x00,  //@@%+...
    0x4e, 0xff, 0xfd, 0x20,  //+@@@@@.
    0x00, 0x48, 0xef, 0xc0,  //..+%@@%
    0x00, 0x00, 0x1f, 0xf0,  //.....@@
    0xb4, 0x00, 0x6f, 0xf0,  //%+..+@@
    0xff, 0xff, 0xff, 0xa0,  //@@@@@@%
    0x3a, 0xef, 0xd7, 0x00,  //.%@@@+.
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0074 (t) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x0f, 0xf0, 0x00,  //.@@...
    0x0f, 0xf0, 0x00,  //.@@...
    0x0f, 0xf0, 0x00,  //.@@...
    0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff,  //@@@@@@
    0x0f, 0xf0, 0x00,  //.@@...
    0x0f, 0xf0, 0x00,  //.@@...
    0x0f, 0xf0, 0x00,  //.@@...
    0x0f, 0xf0, 0x00,  //.@@...
    0x0f, 0xf0, 0x00,  //.@@...
    0x0e, 0xf4, 0x00,  //.@@+..
    0x0a, 0xff, 0xff,  //.%@@@@
    0x01, 0xae, 0xff,  //..%@@@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0075 (u) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xff, 0x00, 0x00, 0xff,  //@@....@@
    0xef, 0x10, 0x03, 0xff,  //@@....@@
    0xcf, 0x90, 0x2c, 0xff,  //@@%..@@@
    0x6f, 0xff, 0xfa, 0xff,  //+@@@@%@@
    0x08, 0xef, 0xa0, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0076 (v) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x1f, 0xf1, 0x00, 0x00, 0x0e, 0xe0,  //.@@......@@.
    0x0a, 0xf7, 0x00, 0x00, 0x6f, 0x80,  //.%@+....+@%.
    0x04, 0xfc, 0x00, 0x00, 0xcf, 0x20,  //..@@....@@..
    0x00, 0xdf, 0x20, 0x03, 0xfc, 0x00,  //..@@....@@..
    0x00, 0x7f, 0x80, 0x09, 0xf6, 0x00,  //..+@%..%@+..
    0x00, 0x1f, 0xd0, 0x0f, 0xf0, 0x00,  //...@@..@@...
    0x00, 0x0a, 0xf3, 0x6f, 0x90, 0x00,  //...%@.+@%...
    0x00, 0x04, 0xf9, 0xcf, 0x30, 0x00,  //...+@%@@....
    0x00, 0x00, 0xdf, 0xfd, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x7f, 0xf7, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0077 (w) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x0f, 0xf0, 0x00, 0xcf, 0xc0, 0x00, 0xff, 0x00,  //.@@...@@@...@@.
    0x0c, 0xf3, 0x01, 0xff, 0xf0, 0x03, 0xfc, 0x00,  //.@@...@@@...@@.
    0x08, 0xf7, 0x04, 0xfd, 0xf4, 0x07, 0xf8, 0x00,  //.%@+.+@@@+.+@%.
    0x04, 0xfa, 0x08, 0xf5, 0xf8, 0x0a, 0xf4, 0x00,  //.+@%.%@+@%.%@+.
    0x00, 0xfd, 0x0c, 0xe0, 0xec, 0x0d, 0xf0, 0x00,  //..@@.@@.@@.@@..
    0x00, 0xcf, 0x2f, 0x90, 0xaf, 0x1f, 0xc0, 0x00,  //..@@.@%.%@.@@..
    0x00, 0x8f, 0x9f, 0x50, 0x5f, 0x8f, 0x80, 0x00,  //..%@%@+.+@%@%..
    0x00, 0x5f, 0xff, 0x10, 0x1f, 0xef, 0x50, 0x00,  //..+@@@...@@@+..
    0x00, 0x1f, 0xfc, 0x00, 0x0d, 0xff, 0x10, 0x00,  //...@@@...@@@...
    0x00, 0x0d, 0xf8, 0x00, 0x08, 0xfd, 0x00, 0x00,  //...@@%...%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0078 (x) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xaf, 0xd0, 0x00, 0x0d, 0xfa,  //%@@....@@%
    0x1e, 0xf5, 0x00, 0x5f, 0xd0,  //.@@+..+@@.
    0x04, 0xfd, 0x00, 0xdf, 0x30,  //.+@@..@@..
    0x00, 0x9f, 0x55, 0xf8, 0x00,  //..%@++@%..
    0x00, 0x0d, 0xdd, 0xc0, 0x00,  //...@@@@...
    0x00, 0x1e, 0xef, 0xe1, 0x00,  //...@@@@...
    0x00, 0xaf, 0x57, 0xfa, 0x00,  //..%@++@%..
    0x05, 0xfd, 0x00, 0xef, 0x50,  //.+@@..@@+.
    0x1e, 0xf4, 0x00, 0x5f, 0xe1,  //.@@+..+@@.
    0xaf, 0xc0, 0x00, 0x0c, 0xfa,  //%@@....@@%
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0079 (y) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x2f, 0xf1, 0x00, 0x00, 0x0f, 0xf2,  //.@@......@@.
    0x0a, 0xf7, 0x00, 0x00, 0x7f, 0xa0,  //.%@+....+@%.
    0x03, 0xfe, 0x00, 0x00, 0xef, 0x30,  //..@@....@@..
    0x00, 0xbf, 0x50, 0x05, 0xfc, 0x00,  //..%@+..+@@..
    0x00, 0x3f, 0xd0, 0x0c, 0xf4, 0x00,  //...@@..@@+..
    0x00, 0x0c, 0xf4, 0x3f, 0xd0, 0x00,  //...@@+.@@...
    0x00, 0x04, 0xfb, 0xaf, 0x60, 0x00,  //...+@%%@+...
    0x00, 0x00, 0xdf, 0xfe, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x5f, 0xf7, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x2f, 0xe0, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x6f, 0x80, 0x00, 0x00,  //....+@%.....
    0x00, 0x01, 0xbf, 0x20, 0x00, 0x00,  //....%@......
    0x00, 0xff, 0xfb, 0x00, 0x00, 0x00,  //..@@@%......
    0x00, 0xff, 0xb1, 0x00, 0x00, 0x00,  //..@@%.......


    /*Unicode: U+007a (z) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xfd,  //@@@@@@@@
    0x00, 0x00, 0x4f, 0xf3,  //....+@@.
    0x00, 0x01, 0xef, 0x70,  //....@@+.
    0x00, 0x0c, 0xfc, 0x00,  //...@@@..
    0x00, 0x9f, 0xe1, 0x00,  //..%@@...
    0x05, 0xff, 0x50, 0x00,  //.+@@+...
    0x2f, 0xfa, 0x00, 0x00,  //.@@%....
    0xdf, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+007b ({) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x01, 0x9d, 0xff,  //....%@@@
    0x00, 0x0a, 0xff, 0xff,  //...%@@@@
    0x00, 0x0e, 0xf6, 0x00,  //...@@+..
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x01, 0x8f, 0xc0, 0x00,  //..%@@...
    0xff, 0xfc, 0x30, 0x00,  //@@@@....
    0xff, 0xfc, 0x20, 0x00,  //@@@@....
    0x01, 0xaf, 0xb0, 0x00,  //..%@%...
    0x00, 0x1f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0e, 0xf7, 0x00,  //...@@+..
    0x00, 0x09, 0xff, 0xff,  //...%@@@@
    0x00, 0x00, 0x9d, 0xff,  //....%@@@
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+007c (|) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@
    0xff,  //@@


    /*Unicode: U+007d (}) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xd9, 0x10, 0x00,  //@@@%....
    0xff, 0xff, 0xa0, 0x00,  //@@@@%...
    0x00, 0x6f, 0xe0, 0x00,  //..+@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0c, 0xf8, 0x10,  //...@@%..
    0x00, 0x03, 0xcf, 0xff,  //....@@@@
    0x00, 0x02, 0xcf, 0xff,  //....@@@@
    0x00, 0x0b, 0xfa, 0x10,  //...%@%..
    0x00, 0x0f, 0xf1, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x0f, 0xf0, 0x00,  //...@@...
    0x00, 0x7f, 0xe0, 0x00,  //..+@@...
    0xff, 0xff, 0x90, 0x00,  //@@@@%...
    0xff, 0xd9, 0x00, 0x00,  //@@@%....
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+007e (~) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x18, 0xef, 0xd8, 0x30, 0x05, 0xd0,  //.%@@@%...+@
    0xef, 0xff, 0xff, 0xff, 0xff, 0xe0,  //@@@@@@@@@@@
    0xe6, 0x10, 0x48, 0xdf, 0xe9, 0x10,  //@+...%@@@%.
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........



#elif USE_LV_FONT_DEJAVU_20 == 8
    /*Unicode: U+0020 ( ) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0021 (!) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xf4, 0xf2,  //@@
    0xe4, 0xe2,  //@@
    0xd2, 0xd2,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+0022 (") , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0xff, 0xff, 0x00, 0x00, 0xff, 0xff,  //@@..@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0023 (#) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0x36, 0x00, 0x44, 0xff, 0x16, 0x00,  //.....@..+@..
    0x00, 0x00, 0x00, 0x00, 0x62, 0xf6, 0x04, 0x00, 0x7e, 0xde, 0x00, 0x00,  //....+@..+@..
    0x00, 0x00, 0x00, 0x00, 0x9a, 0xc4, 0x00, 0x00, 0xb8, 0xa6, 0x00, 0x00,  //....%@..%%..
    0x00, 0x00, 0x00, 0x00, 0xd2, 0x8a, 0x00, 0x00, 0xee, 0x6e, 0x00, 0x00,  //....@%..@+..
    0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@
    0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x70, 0xea, 0x04, 0x00, 0x90, 0xd2, 0x00, 0x00, 0x00,  //...+@..%@...
    0x00, 0x00, 0x00, 0xcc, 0x94, 0x00, 0x02, 0xe6, 0x78, 0x00, 0x00, 0x00,  //...@%..@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,  //@@@@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02,  //@@@@@@@@@@@.
    0x00, 0x00, 0x66, 0xf0, 0x00, 0x00, 0x86, 0xd6, 0x00, 0x00, 0x00, 0x00,  //..+@..%@....
    0x00, 0x00, 0xa0, 0xba, 0x00, 0x00, 0xbe, 0x9c, 0x00, 0x00, 0x00, 0x00,  //..%%..%%....
    0x00, 0x00, 0xd8, 0x82, 0x00, 0x02, 0xf2, 0x64, 0x00, 0x00, 0x00, 0x00,  //..@%..@+....
    0x00, 0x12, 0xff, 0x4a, 0x00, 0x2e, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00,  //..@+..@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0024 ($) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@....
    0x00, 0x42, 0xb4, 0xe6, 0xff, 0xea, 0xac, 0x3c, 0x00,  //.+%@@@%..
    0x66, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //+@@@@@@@.
    0xe0, 0xff, 0x9c, 0x18, 0xff, 0x18, 0x50, 0xc2, 0x00,  //@@%.@.+@.
    0xf2, 0xff, 0x12, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@..@....
    0xb6, 0xff, 0xd4, 0x86, 0xff, 0x28, 0x00, 0x00, 0x00,  //%@@%@....
    0x1c, 0xce, 0xff, 0xff, 0xff, 0xff, 0xde, 0x64, 0x00,  //.@@@@@@+.
    0x00, 0x00, 0x3c, 0x7c, 0xff, 0xe0, 0xff, 0xff, 0x64,  //...+@@@@+
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x68, 0xff, 0xd6,  //....@.+@@
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x0c, 0xff, 0xf6,  //....@..@@
    0xca, 0x62, 0x16, 0x00, 0xff, 0x1c, 0x9c, 0xff, 0xe0,  //@+..@.%@@
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0x66,  //@@@@@@@@+
    0x2e, 0x8c, 0xcc, 0xee, 0xff, 0xe4, 0xb2, 0x42, 0x00,  //.%@@@@%+.
    0x00, 0x00, 0x00, 0x02, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@....
    0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,  //....@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0025 (%) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x04, 0x8a, 0xe6, 0xe4, 0x88, 0x04, 0x00, 0x00, 0x00, 0x00, 0x4e, 0xd4, 0x04, 0x00, 0x00,  //.%@@%.....+@...
    0x7c, 0xff, 0x6a, 0x6c, 0xff, 0x78, 0x00, 0x00, 0x00, 0x0c, 0xe0, 0x3a, 0x00, 0x00, 0x00,  //+@++@+....@....
    0xda, 0xff, 0x14, 0x16, 0xff, 0xd8, 0x00, 0x00, 0x00, 0x90, 0x98, 0x00, 0x00, 0x00, 0x00,  //@@..@@...%%....
    0xf6, 0xff, 0x02, 0x02, 0xff, 0xf4, 0x00, 0x00, 0x34, 0xe4, 0x0e, 0x00, 0x00, 0x00, 0x00,  //@@..@@...@.....
    0xda, 0xff, 0x14, 0x14, 0xff, 0xda, 0x00, 0x02, 0xce, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@..@@..@+.....
    0x80, 0xff, 0x68, 0x68, 0xff, 0x7c, 0x00, 0x74, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@++@+.+%......
    0x06, 0x8e, 0xe6, 0xe6, 0x8c, 0x04, 0x1e, 0xe8, 0x1e, 0x04, 0x8a, 0xe4, 0xe6, 0x8a, 0x04,  //.%@@%..@..%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0x72, 0x00, 0x7c, 0xff, 0x6a, 0x6a, 0xff, 0x7a,  //......%+.+@++@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xce, 0x02, 0x00, 0xda, 0xff, 0x14, 0x14, 0xff, 0xda,  //.....+@..@@..@@
    0x00, 0x00, 0x00, 0x00, 0x0e, 0xe4, 0x34, 0x00, 0x00, 0xf6, 0xff, 0x02, 0x02, 0xff, 0xf4,  //.....@...@@..@@
    0x00, 0x00, 0x00, 0x00, 0x98, 0x90, 0x00, 0x00, 0x00, 0xda, 0xff, 0x14, 0x14, 0xff, 0xda,  //....%%...@@..@@
    0x00, 0x00, 0x00, 0x3a, 0xe0, 0x0c, 0x00, 0x00, 0x00, 0x7e, 0xff, 0x68, 0x68, 0xff, 0x7c,  //....@....+@++@+
    0x00, 0x00, 0x04, 0xd4, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x04, 0x8c, 0xe6, 0xe6, 0x8c, 0x04,  //...@+.....%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0026 (&) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x4a, 0xc8, 0xf6, 0xee, 0xb0, 0x42, 0x00, 0x00, 0x00,  //...+@@@%+...
    0x00, 0x00, 0x54, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //..+@@@@@@...
    0x00, 0x00, 0xde, 0xff, 0x72, 0x0e, 0x08, 0x4a, 0xc0, 0x00, 0x00, 0x00,  //..@@+..+%...
    0x00, 0x00, 0xfa, 0xff, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@........
    0x00, 0x00, 0xb0, 0xff, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@%.......
    0x00, 0x04, 0x9a, 0xff, 0xff, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..%@@%......
    0x08, 0xbc, 0xf0, 0x8e, 0xfc, 0xff, 0x96, 0x00, 0x1c, 0xff, 0xe2, 0x00,  //.%@%@@%..@@.
    0x8c, 0xff, 0x58, 0x00, 0x54, 0xf8, 0xff, 0x9a, 0x54, 0xff, 0x92, 0x00,  //%@+.+@@%+@%.
    0xe8, 0xff, 0x0e, 0x00, 0x00, 0x46, 0xf4, 0xff, 0xe6, 0xf0, 0x18, 0x00,  //@@...+@@@@..
    0xf0, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x66, 0xff, 0xff, 0x50, 0x00, 0x00,  //@@+...+@@+..
    0xaa, 0xff, 0xe8, 0x5a, 0x14, 0x08, 0x6e, 0xff, 0xff, 0x98, 0x00, 0x00,  //%@@+..+@@%..
    0x1c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0xff, 0xff, 0x8e, 0x00,  //.@@@@@@@@@%.
    0x00, 0x10, 0x88, 0xd8, 0xf8, 0xec, 0x92, 0x02, 0x56, 0xf2, 0xff, 0x84,  //..%@@@%.+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0027 (') , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+0028 (() , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x84, 0xc6,  //..%@
    0x00, 0x24, 0xf8, 0x54,  //..@+
    0x00, 0xa4, 0xee, 0x04,  //.%@.
    0x18, 0xf8, 0xa2, 0x00,  //.@%.
    0x6c, 0xff, 0x62, 0x00,  //+@+.
    0xb0, 0xff, 0x34, 0x00,  //%@..
    0xdc, 0xff, 0x14, 0x00,  //@@..
    0xf4, 0xff, 0x06, 0x00,  //@@..
    0xf4, 0xff, 0x06, 0x00,  //@@..
    0xdc, 0xff, 0x16, 0x00,  //@@..
    0xb0, 0xff, 0x36, 0x00,  //%@..
    0x6c, 0xff, 0x66, 0x00,  //+@+.
    0x18, 0xf8, 0xa6, 0x00,  //.@%.
    0x00, 0xa2, 0xf0, 0x04,  //.%@.
    0x00, 0x22, 0xf6, 0x56,  //..@+
    0x00, 0x00, 0x82, 0xc6,  //..%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0029 ()) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xc6, 0x82, 0x00, 0x00,  //@%..
    0x58, 0xf6, 0x22, 0x00,  //+@..
    0x04, 0xf0, 0xa0, 0x00,  //.@%.
    0x00, 0xa6, 0xf6, 0x14,  //.%@.
    0x00, 0x66, 0xff, 0x68,  //.+@+
    0x00, 0x36, 0xff, 0xae,  //..@%
    0x00, 0x16, 0xff, 0xdc,  //..@@
    0x00, 0x06, 0xff, 0xf2,  //..@@
    0x00, 0x08, 0xff, 0xf2,  //..@@
    0x00, 0x16, 0xff, 0xdc,  //..@@
    0x00, 0x36, 0xff, 0xac,  //..@%
    0x00, 0x66, 0xff, 0x68,  //.+@+
    0x00, 0xa6, 0xf6, 0x14,  //.%@.
    0x04, 0xf0, 0xa0, 0x00,  //.@%.
    0x58, 0xf6, 0x22, 0x00,  //+@..
    0xc6, 0x82, 0x00, 0x00,  //@%..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+002a (*) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //...@...
    0xa4, 0x2c, 0x00, 0xff, 0x00, 0x2c, 0xa4,  //%..@..%
    0x5e, 0xe6, 0x52, 0xff, 0x52, 0xe6, 0x5e,  //+@+@+@+
    0x00, 0x24, 0xcc, 0xff, 0xcc, 0x24, 0x00,  //..@@@..
    0x00, 0x24, 0xca, 0xff, 0xca, 0x24, 0x00,  //..@@@..
    0x5c, 0xe6, 0x52, 0xff, 0x54, 0xe6, 0x5c,  //+@+@+@+
    0xa6, 0x2c, 0x00, 0xff, 0x00, 0x2e, 0xa6,  //%..@..%
    0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,  //...@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+002b (+) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+002c (,) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0xff,  //.@@
    0x10, 0xff, 0xda,  //.@@
    0x6c, 0xf4, 0x2e,  //+@.
    0xce, 0x60, 0x00,  //@+.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+002d (-) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002e (.) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+002f (/) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x30, 0xff, 0xdc,  //....@@
    0x00, 0x00, 0x00, 0x74, 0xff, 0x9a,  //...+@%
    0x00, 0x00, 0x00, 0xb6, 0xff, 0x58,  //...%@+
    0x00, 0x00, 0x04, 0xf4, 0xff, 0x16,  //...@@.
    0x00, 0x00, 0x3c, 0xff, 0xd2, 0x00,  //...@@.
    0x00, 0x00, 0x80, 0xff, 0x90, 0x00,  //..+@%.
    0x00, 0x00, 0xc4, 0xff, 0x4c, 0x00,  //..@@+.
    0x00, 0x0c, 0xfa, 0xfa, 0x0e, 0x00,  //..@@..
    0x00, 0x4a, 0xff, 0xc8, 0x00, 0x00,  //.+@@..
    0x00, 0x8c, 0xff, 0x84, 0x00, 0x00,  //.%@%..
    0x00, 0xd0, 0xff, 0x42, 0x00, 0x00,  //.@@+..
    0x14, 0xfc, 0xf6, 0x06, 0x00, 0x00,  //.@@...
    0x56, 0xff, 0xbc, 0x00, 0x00, 0x00,  //+@%...
    0x9a, 0xff, 0x7a, 0x00, 0x00, 0x00,  //%@+...
    0xdc, 0xff, 0x38, 0x00, 0x00, 0x00,  //@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0030 (0) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x06, 0x7e, 0xdc, 0xf8, 0xdc, 0x7e, 0x04, 0x00,  //..+@@@+..
    0x00, 0xac, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0x00,  //.%@@@@@%.
    0x46, 0xff, 0xf0, 0x46, 0x06, 0x46, 0xf0, 0xff, 0x44,  //+@@+.+@@+
    0xa2, 0xff, 0x76, 0x00, 0x00, 0x00, 0x76, 0xff, 0xa0,  //%@+...+@%
    0xd6, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xd6,  //@@.....@@
    0xf2, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf0,  //@@.....@@
    0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfa,  //@@.....@@
    0xf2, 0xff, 0x0a, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf0,  //@@.....@@
    0xd6, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x2c, 0xff, 0xd6,  //@@.....@@
    0xa2, 0xff, 0x76, 0x00, 0x00, 0x00, 0x76, 0xff, 0xa2,  //%@+...+@%
    0x48, 0xff, 0xf0, 0x44, 0x06, 0x44, 0xf0, 0xff, 0x46,  //+@@+.+@@+
    0x00, 0xae, 0xff, 0xff, 0xff, 0xff, 0xff, 0xac, 0x00,  //.%@@@@@%.
    0x00, 0x06, 0x80, 0xde, 0xf8, 0xde, 0x80, 0x06, 0x00,  //..+@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0031 (1) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x26, 0x76, 0xc6, 0xfc, 0xff, 0x00, 0x00, 0x00,  //.+@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@@@...
    0xd4, 0x7e, 0x2a, 0xff, 0xff, 0x00, 0x00, 0x00,  //@+.@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0032 (2) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x36, 0x98, 0xdc, 0xf8, 0xe0, 0xae, 0x34, 0x00, 0x00,  //.%@@@%...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x50, 0x00,  //@@@@@@@+.
    0xc4, 0x5e, 0x1c, 0x06, 0x2e, 0xc4, 0xff, 0xd6, 0x00,  //@+...@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xf6, 0x00,  //......@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xd2, 0x00,  //......@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x86, 0xff, 0x7a, 0x00,  //.....%@+.
    0x00, 0x00, 0x00, 0x00, 0x58, 0xfc, 0xd8, 0x08, 0x00,  //....+@@..
    0x00, 0x00, 0x00, 0x58, 0xfa, 0xf2, 0x2c, 0x00, 0x00,  //...+@@...
    0x00, 0x00, 0x64, 0xfc, 0xfa, 0x4e, 0x00, 0x00, 0x00,  //..+@@+...
    0x00, 0x6e, 0xff, 0xfc, 0x60, 0x00, 0x00, 0x00, 0x00,  //.+@@+....
    0x7a, 0xff, 0xfc, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@+.....
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12,  //@@@@@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0033 (3) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x30, 0x8c, 0xd0, 0xf4, 0xf0, 0xd6, 0x9a, 0x2c, 0x00,  //.%@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x56,  //@@@@@@@@+
    0xc8, 0x6a, 0x26, 0x04, 0x0c, 0x32, 0xa8, 0xff, 0xde,  //@+....%@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0xff, 0xee,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x0a, 0x2c, 0xa2, 0xff, 0x92,  //......%@%
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x74, 0x02,  //..@@@@@+.
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x8e, 0x04,  //..@@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x10, 0x44, 0xcc, 0xff, 0x8c,  //.....+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0xff, 0xe6,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xf2,  //.......@@
    0xb8, 0x4e, 0x14, 0x02, 0x14, 0x4a, 0xd2, 0xff, 0xb6,  //%+...+@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xea, 0x28,  //@@@@@@@@.
    0x38, 0x9e, 0xde, 0xfa, 0xf2, 0xd0, 0x8a, 0x18, 0x00,  //.%@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0034 (4) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xff, 0x00, 0x00,  //.....%@@..
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xf8, 0xff, 0xff, 0x00, 0x00,  //....+@@@..
    0x00, 0x00, 0x00, 0x1a, 0xee, 0x7a, 0xff, 0xff, 0x00, 0x00,  //....@+@@..
    0x00, 0x00, 0x00, 0xb6, 0xcc, 0x02, 0xff, 0xff, 0x00, 0x00,  //...%@.@@..
    0x00, 0x00, 0x66, 0xf8, 0x2c, 0x00, 0xff, 0xff, 0x00, 0x00,  //..+@..@@..
    0x00, 0x22, 0xf2, 0x7a, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //..@+..@@..
    0x00, 0xc2, 0xca, 0x02, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //.@@...@@..
    0x74, 0xf8, 0x2a, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //+@....@@..
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //......@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //......@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,  //......@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0035 (5) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.@@@@@@.
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@.....
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@.....
    0x00, 0xff, 0xff, 0xd4, 0xf6, 0xc4, 0x3c, 0x00,  //.@@@@@..
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x2e,  //.@@@@@@.
    0x00, 0xa2, 0x26, 0x08, 0x3e, 0xd8, 0xff, 0xaa,  //.%...@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xff, 0xe8,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xfa,  //......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xe4,  //......@@
    0xb2, 0x40, 0x0a, 0x0e, 0x4c, 0xe0, 0xff, 0x9c,  //%...+@@%
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x1a,  //@@@@@@@.
    0x40, 0xac, 0xea, 0xf8, 0xde, 0x96, 0x18, 0x00,  //.%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0036 (6) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x30, 0xac, 0xea, 0xf6, 0xc2, 0x4c, 0x00,  //...%@@@+.
    0x00, 0x4c, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //.+@@@@@@.
    0x16, 0xee, 0xff, 0xb6, 0x2a, 0x06, 0x32, 0xb4, 0x00,  //.@@%...%.
    0x80, 0xff, 0xd8, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@......
    0xc8, 0xff, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+......
    0xee, 0xff, 0x34, 0x90, 0xee, 0xf2, 0xba, 0x3a, 0x00,  //@@.%@@%..
    0xfa, 0xff, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3a,  //@@%@@@@@.
    0xf2, 0xff, 0xb8, 0x2a, 0x06, 0x2a, 0xba, 0xff, 0xbe,  //@@%...%@%
    0xd6, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xf4,  //@@.....@@
    0xa0, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xf2,  //%@.....@@
    0x42, 0xff, 0xba, 0x28, 0x06, 0x28, 0xba, 0xff, 0xb8,  //+@%...%@%
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x30,  //.%@@@@@@.
    0x00, 0x02, 0x76, 0xd8, 0xf8, 0xec, 0xaa, 0x2a, 0x00,  //..+@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0037 (7) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xff, 0x70,  //.....%@+
    0x00, 0x00, 0x00, 0x00, 0x06, 0xf0, 0xff, 0x20,  //.....@@.
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xd0, 0x00,  //....+@@.
    0x00, 0x00, 0x00, 0x00, 0x9c, 0xff, 0x7e, 0x00,  //....%@+.
    0x00, 0x00, 0x00, 0x02, 0xea, 0xff, 0x2e, 0x00,  //....@@..
    0x00, 0x00, 0x00, 0x3e, 0xff, 0xdc, 0x00, 0x00,  //....@@..
    0x00, 0x00, 0x00, 0x90, 0xff, 0x8c, 0x00, 0x00,  //...%@%..
    0x00, 0x00, 0x00, 0xe0, 0xff, 0x3c, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x34, 0xff, 0xe8, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x84, 0xff, 0x9a, 0x00, 0x00, 0x00,  //..%@%...
    0x00, 0x00, 0xd6, 0xff, 0x4a, 0x00, 0x00, 0x00,  //..@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0038 (8) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x42, 0xb2, 0xe0, 0xf6, 0xe0, 0xb2, 0x42, 0x00,  //.+%@@@%+.
    0x6a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6a,  //+@@@@@@@+
    0xe4, 0xff, 0x96, 0x1e, 0x04, 0x1e, 0x98, 0xff, 0xe4,  //@@%...%@@
    0xee, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xec,  //@@.....@@
    0x92, 0xff, 0x94, 0x1c, 0x04, 0x1e, 0x96, 0xff, 0x92,  //%@%...%@%
    0x02, 0x76, 0xe0, 0xff, 0xff, 0xff, 0xe0, 0x76, 0x02,  //.+@@@@@+.
    0x02, 0x8c, 0xf2, 0xff, 0xff, 0xff, 0xf2, 0x8c, 0x02,  //.%@@@@@%.
    0x86, 0xff, 0xb8, 0x28, 0x06, 0x2a, 0xba, 0xff, 0x86,  //%@%...%@%
    0xe4, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xe4,  //@@.....@@
    0xf6, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xf6,  //@@.....@@
    0xc8, 0xff, 0xb8, 0x28, 0x06, 0x28, 0xba, 0xff, 0xc6,  //@@%...%@@
    0x46, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x44,  //+@@@@@@@+
    0x00, 0x2e, 0xaa, 0xde, 0xf8, 0xea, 0xb2, 0x38, 0x00,  //..%@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0039 (9) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x2a, 0xaa, 0xea, 0xf8, 0xd6, 0x72, 0x02, 0x00,  //..%@@@+..
    0x30, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9c, 0x00,  //.@@@@@@%.
    0xb8, 0xff, 0xbc, 0x2a, 0x06, 0x2a, 0xbc, 0xff, 0x3e,  //%@%...%@.
    0xf2, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x1a, 0xff, 0x9c,  //@@.....@%
    0xf4, 0xff, 0x1a, 0x00, 0x00, 0x00, 0x1a, 0xff, 0xd4,  //@@.....@@
    0xc0, 0xff, 0xba, 0x28, 0x06, 0x28, 0xb8, 0xff, 0xf0,  //%@%...%@@
    0x40, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xff, 0xfa,  //.@@@@@%@@
    0x00, 0x3e, 0xbc, 0xf2, 0xee, 0x90, 0x34, 0xff, 0xee,  //..%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xff, 0xc6,  //......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xd6, 0xff, 0x7e,  //......@@+
    0x00, 0xb2, 0x30, 0x04, 0x28, 0xb4, 0xff, 0xee, 0x16,  //.%...%@@.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x4c, 0x00,  //.@@@@@@+.
    0x00, 0x4c, 0xc2, 0xf6, 0xea, 0xac, 0x30, 0x00, 0x00,  //.+@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+003a (:) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+003b (;) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0xff,  //.@@
    0x00, 0xff, 0xff,  //.@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0xff,  //.@@
    0x10, 0xff, 0xda,  //.@@
    0x6c, 0xf4, 0x2e,  //+@.
    0xce, 0x60, 0x00,  //@+.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+003c (<) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x6a, 0xcc,  //.........+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xa4, 0xf6, 0xff, 0xff,  //.......%@@@
    0x00, 0x00, 0x00, 0x1a, 0x7a, 0xdc, 0xff, 0xff, 0xfc, 0xb6, 0x54,  //....+@@@@%+
    0x04, 0x52, 0xb4, 0xfc, 0xff, 0xff, 0xde, 0x7c, 0x1c, 0x00, 0x00,  //.+%@@@@+...
    0xea, 0xff, 0xff, 0xf6, 0xa4, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@%+.....
    0xea, 0xff, 0xff, 0xf6, 0xa4, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@%+.....
    0x04, 0x54, 0xb6, 0xfc, 0xff, 0xff, 0xdc, 0x7c, 0x1c, 0x00, 0x00,  //.+%@@@@+...
    0x00, 0x00, 0x00, 0x1c, 0x7c, 0xdc, 0xff, 0xff, 0xfc, 0xb6, 0x54,  //....+@@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xa4, 0xf6, 0xff, 0xff,  //......+%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x6a, 0xce,  //.........+@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003d (=) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003e (>) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xcc, 0x6a, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.........
    0xff, 0xff, 0xf6, 0xa4, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%.......
    0x54, 0xb8, 0xfc, 0xff, 0xff, 0xdc, 0x7a, 0x1a, 0x00, 0x00, 0x00,  //+%@@@@+....
    0x00, 0x00, 0x1c, 0x7e, 0xde, 0xff, 0xff, 0xfc, 0xb4, 0x52, 0x04,  //...+@@@@%+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xa6, 0xf6, 0xff, 0xff, 0xea,  //.....+%@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xa6, 0xf6, 0xff, 0xff, 0xea,  //.....+%@@@@
    0x00, 0x00, 0x1c, 0x7c, 0xde, 0xff, 0xff, 0xfc, 0xb6, 0x52, 0x04,  //...+@@@@%+.
    0x54, 0xb6, 0xfc, 0xff, 0xff, 0xdc, 0x7c, 0x1a, 0x00, 0x00, 0x00,  //+%@@@@+....
    0xff, 0xff, 0xf6, 0xa4, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@%+......
    0xce, 0x6a, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@+.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+003f (?) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x40, 0xac, 0xe8, 0xf6, 0xd2, 0x68, 0x00,  //.%@@@+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,  //@@@@@@+
    0xc2, 0x4e, 0x0c, 0x12, 0x94, 0xff, 0xda,  //@+..%@@
    0x00, 0x00, 0x00, 0x00, 0x0c, 0xff, 0xf2,  //.....@@
    0x00, 0x00, 0x00, 0x00, 0x46, 0xff, 0xa4,  //....+@%
    0x00, 0x00, 0x00, 0x20, 0xe4, 0xd0, 0x10,  //....@@.
    0x00, 0x00, 0x26, 0xe2, 0xd6, 0x14, 0x00,  //...@@..
    0x00, 0x00, 0xc4, 0xff, 0x38, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xf8, 0xff, 0x02, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0040 (@) , Width: 16 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................
    0x00, 0x00, 0x00, 0x00, 0x1e, 0x82, 0xca, 0xec, 0xf6, 0xe0, 0xb4, 0x66, 0x08, 0x00, 0x00, 0x00,  //.....%@@@@%+....
    0x00, 0x00, 0x02, 0x8a, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x4c, 0x00, 0x00,  //...%@@@@@@@@@+..
    0x00, 0x04, 0xb8, 0xff, 0xfa, 0x9a, 0x3e, 0x0e, 0x04, 0x1a, 0x56, 0xbc, 0xff, 0xfc, 0x60, 0x00,  //..%@@%....+%@@+.
    0x00, 0x94, 0xff, 0xe6, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xfa, 0xf8, 0x2a,  //.%@@........+@@.
    0x2c, 0xfc, 0xf8, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xff, 0xa2,  //.@@..........+@%
    0x90, 0xff, 0x94, 0x00, 0x00, 0x20, 0xca, 0xe6, 0x34, 0xff, 0xff, 0x00, 0x00, 0x1a, 0xff, 0xe6,  //%@%...@@.@@...@@
    0xd4, 0xff, 0x36, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xc8, 0xff, 0xff, 0x00, 0x00, 0x0e, 0xff, 0xf6,  //@@...%@@@@@...@@
    0xf2, 0xff, 0x0e, 0x00, 0x00, 0xee, 0xff, 0x32, 0x36, 0xff, 0xff, 0x00, 0x00, 0x5e, 0xff, 0xce,  //@@...@@..@@..+@@
    0xf4, 0xff, 0x0a, 0x00, 0x00, 0xee, 0xff, 0x32, 0x32, 0xff, 0xff, 0x1c, 0x72, 0xf2, 0xff, 0x56,  //@@...@@..@@.+@@+
    0xda, 0xff, 0x2e, 0x00, 0x00, 0xb2, 0xff, 0xff, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x6a, 0x00,  //@@...%@@@@@@@@+.
    0x9e, 0xff, 0x84, 0x00, 0x00, 0x22, 0xcc, 0xe6, 0x36, 0xf6, 0xe2, 0xba, 0x76, 0x18, 0x00, 0x00,  //%@%...@@.@@%+...
    0x40, 0xff, 0xf2, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@.............
    0x00, 0xb4, 0xff, 0xd6, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.%@@............
    0x00, 0x12, 0xd8, 0xff, 0xf0, 0x80, 0x2c, 0x08, 0x08, 0x2c, 0x80, 0xd6, 0x2a, 0x00, 0x00, 0x00,  //..@@@+....+@....
    0x00, 0x00, 0x12, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x1c, 0x00, 0x00, 0x00,  //...%@@@@@@@@....
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xa8, 0xe2, 0xf8, 0xe8, 0xb4, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+%@@@%+.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //................


    /*Unicode: U+0041 (A) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x06, 0xea, 0xec, 0x06, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xff, 0xff, 0xc4, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x28, 0xff, 0xc6, 0xc4, 0xff, 0x2a, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x90, 0xff, 0x64, 0x5c, 0xff, 0x92, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x08, 0xee, 0xf4, 0x0c, 0x06, 0xea, 0xee, 0x08, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x5e, 0xff, 0xa0, 0x00, 0x00, 0x8c, 0xff, 0x60, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0xc6, 0xff, 0x3e, 0x00, 0x00, 0x24, 0xfc, 0xc6, 0x00, 0x00,  //..@@....@@..
    0x00, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0x00,  //..@@@@@@@@..
    0x00, 0x94, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x94, 0x00,  //.%@@@@@@@@%.
    0x0a, 0xf0, 0xfc, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xf0, 0x0a,  //.@@......@@.
    0x64, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x62,  //+@%......%@+
    0xca, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xca,  //@@+......+@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0042 (B) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xce, 0x68, 0x00, 0x00,  //@@@@@@+..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x88, 0x00,  //@@@@@@@%.
    0xff, 0xff, 0x00, 0x00, 0x0c, 0x7a, 0xff, 0xea, 0x00,  //@@...+@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xf0, 0x00,  //@@....@@.
    0xff, 0xff, 0x00, 0x00, 0x0c, 0x76, 0xff, 0xac, 0x00,  //@@...+@%.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x98, 0x10, 0x00,  //@@@@@@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0x00,  //@@@@@@@+.
    0xff, 0xff, 0x00, 0x00, 0x06, 0x2c, 0xb4, 0xff, 0x66,  //@@....%@+
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xda,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x00, 0x00, 0x06, 0x2c, 0xb4, 0xff, 0xcc,  //@@....%@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x46,  //@@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xfa, 0xe4, 0xaa, 0x36, 0x00,  //@@@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0043 (C) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x02, 0x5e, 0xb6, 0xe6, 0xf8, 0xf2, 0xd2, 0x96, 0x36,  //...+%@@@@%.
    0x00, 0x18, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@
    0x04, 0xca, 0xff, 0xe2, 0x66, 0x1e, 0x04, 0x08, 0x28, 0x64, 0xc4,  //.@@@+....+@
    0x64, 0xff, 0xde, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0xbc, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0xea, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xea, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.........
    0xbc, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0x64, 0xff, 0xdc, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0x04, 0xcc, 0xff, 0xe0, 0x64, 0x1e, 0x04, 0x08, 0x26, 0x64, 0xc4,  //.@@@+....+@
    0x00, 0x1a, 0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@
    0x00, 0x00, 0x04, 0x60, 0xb8, 0xe8, 0xfa, 0xf2, 0xd2, 0x94, 0x36,  //...+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0044 (D) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xe0, 0xb2, 0x68, 0x0a, 0x00, 0x00,  //@@@@@@%+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x32, 0x00,  //@@@@@@@@@..
    0xff, 0xff, 0x00, 0x00, 0x06, 0x1e, 0x5e, 0xd6, 0xff, 0xe8, 0x12,  //@@....+@@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd0, 0xff, 0x7e,  //@@......@@+
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0xc6,  //@@......+@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xec,  //@@.......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xfa,  //@@.......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xec,  //@@.......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xc6,  //@@......+@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd0, 0xff, 0x7c,  //@@......@@+
    0xff, 0xff, 0x00, 0x00, 0x04, 0x1e, 0x5c, 0xd6, 0xff, 0xe8, 0x12,  //@@....+@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x32, 0x00,  //@@@@@@@@@..
    0xff, 0xff, 0xff, 0xff, 0xf4, 0xe2, 0xb4, 0x68, 0x0a, 0x00, 0x00,  //@@@@@@%+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0045 (E) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0046 (F) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //@@@@@@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0047 (G) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x08, 0x6c, 0xbe, 0xea, 0xfa, 0xf0, 0xce, 0x92, 0x36,  //...+%@@@@%.
    0x00, 0x22, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //..@@@@@@@@@
    0x08, 0xd6, 0xff, 0xd8, 0x5c, 0x1a, 0x04, 0x0a, 0x2a, 0x68, 0xc6,  //.@@@+....+@
    0x6c, 0xff, 0xd4, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //+@@........
    0xc0, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //%@+........
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@....@@@@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@....@@@@@
    0xec, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@.......@@
    0xc2, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@+......@@
    0x72, 0xff, 0xc8, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //+@@......@@
    0x0c, 0xde, 0xff, 0xc4, 0x46, 0x0e, 0x04, 0x1e, 0x6e, 0xff, 0xff,  //.@@@+...+@@
    0x00, 0x2c, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x66,  //..@@@@@@@@+
    0x00, 0x00, 0x0e, 0x7a, 0xca, 0xf0, 0xf8, 0xdc, 0x96, 0x24, 0x00,  //...+@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0048 (H) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0049 (I) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+004a (J) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x04, 0xff, 0xf8,  //..@@
    0x00, 0x2a, 0xff, 0xe0,  //..@@
    0x24, 0xb8, 0xff, 0xa6,  //.%@%
    0xff, 0xff, 0xf8, 0x32,  //@@@.
    0xf0, 0xbc, 0x3e, 0x00,  //@%..


    /*Unicode: U+004b (K) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x22, 0xe0, 0xff, 0x78, 0x00,  //@@.....@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x26, 0xe4, 0xfc, 0x6c, 0x00, 0x00,  //@@....@@+..
    0xff, 0xff, 0x00, 0x00, 0x28, 0xe6, 0xfc, 0x60, 0x00, 0x00, 0x00,  //@@...@@+...
    0xff, 0xff, 0x00, 0x2c, 0xe8, 0xf8, 0x54, 0x00, 0x00, 0x00, 0x00,  //@@..@@+....
    0xff, 0xff, 0x30, 0xea, 0xf6, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.@@+.....
    0xff, 0xff, 0xee, 0xf2, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@+......
    0xff, 0xff, 0xf6, 0xe6, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@@@.......
    0xff, 0xff, 0x4c, 0xf8, 0xe8, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+@@......
    0xff, 0xff, 0x00, 0x52, 0xfa, 0xec, 0x30, 0x00, 0x00, 0x00, 0x00,  //@@.+@@.....
    0xff, 0xff, 0x00, 0x00, 0x5a, 0xfc, 0xee, 0x36, 0x00, 0x00, 0x00,  //@@..+@@....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x62, 0xfc, 0xf0, 0x3a, 0x00, 0x00,  //@@...+@@...
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xf2, 0x40, 0x00,  //@@....+@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0xff, 0xf4, 0x44,  //@@.....+@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+004c (L) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+004d (M) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff, 0xff, 0xff,  //@@@+....+@@@
    0xff, 0xff, 0xf2, 0xc0, 0x00, 0x00, 0x00, 0x00, 0xa8, 0xf2, 0xff, 0xff,  //@@@%....%@@@
    0xff, 0xff, 0xa0, 0xfc, 0x20, 0x00, 0x00, 0x12, 0xf8, 0xa0, 0xff, 0xff,  //@@%@....@%@@
    0xff, 0xff, 0x40, 0xff, 0x80, 0x00, 0x00, 0x70, 0xff, 0x40, 0xff, 0xff,  //@@.@+..+@.@@
    0xff, 0xff, 0x00, 0xe0, 0xde, 0x00, 0x00, 0xd2, 0xde, 0x00, 0xff, 0xff,  //@@.@@..@@.@@
    0xff, 0xff, 0x00, 0x82, 0xff, 0x3e, 0x38, 0xff, 0x80, 0x00, 0xff, 0xff,  //@@.%@..@+.@@
    0xff, 0xff, 0x00, 0x22, 0xff, 0x9e, 0x9c, 0xff, 0x22, 0x00, 0xff, 0xff,  //@@..@%%@..@@
    0xff, 0xff, 0x00, 0x00, 0xc2, 0xf2, 0xf2, 0xc2, 0x00, 0x00, 0xff, 0xff,  //@@..@@@@..@@
    0xff, 0xff, 0x00, 0x00, 0x62, 0xff, 0xff, 0x62, 0x00, 0x00, 0xff, 0xff,  //@@..+@@+..@@
    0xff, 0xff, 0x00, 0x00, 0x0c, 0xf4, 0xf4, 0x0c, 0x00, 0x00, 0xff, 0xff,  //@@...@@...@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@........@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+004e (N) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%.....@@
    0xff, 0xff, 0xf8, 0x26, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@.....@@
    0xff, 0xff, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@@%....@@
    0xff, 0xff, 0xb4, 0xff, 0x4e, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@%@+...@@
    0xff, 0xff, 0x26, 0xfa, 0xdc, 0x06, 0x00, 0x00, 0xff, 0xff,  //@@.@@...@@
    0xff, 0xff, 0x00, 0x8e, 0xff, 0x7c, 0x00, 0x00, 0xff, 0xff,  //@@.%@+..@@
    0xff, 0xff, 0x00, 0x10, 0xea, 0xf4, 0x1c, 0x00, 0xff, 0xff,  //@@..@@..@@
    0xff, 0xff, 0x00, 0x00, 0x68, 0xff, 0xaa, 0x00, 0xff, 0xff,  //@@..+@%.@@
    0xff, 0xff, 0x00, 0x00, 0x02, 0xd2, 0xff, 0x40, 0xff, 0xff,  //@@...@@.@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x42, 0xff, 0xd4, 0xff, 0xff,  //@@...+@@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xae, 0xff, 0xff, 0xff,  //@@....%@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x22, 0xf8, 0xff, 0xff,  //@@.....@@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xff,  //@@.....%@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+004f (O) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0x7e, 0xd0, 0xf2, 0xf2, 0xd0, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x08, 0xd8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x44, 0xce, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd6, 0xff, 0x6c,  //+@@......@@+
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xfa,  //@@........@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xea,  //@@........@@
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xbe,  //%@+......+@%
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x6c,  //+@@......@@+
    0x0a, 0xda, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xd8, 0x08,  //.@@@+..+@@@.
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x28, 0x00,  //..@@@@@@@@..
    0x00, 0x00, 0x0e, 0x80, 0xd0, 0xf4, 0xf4, 0xd2, 0x80, 0x0e, 0x00, 0x00,  //...+@@@@+...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0050 (P) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xc0, 0x4a, 0x00,  //@@@@@%+.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c,  //@@@@@@@+
    0xff, 0xff, 0x00, 0x00, 0x1a, 0xa8, 0xff, 0xc6,  //@@...%@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x18, 0xa6, 0xff, 0xc6,  //@@...%@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4e,  //@@@@@@@+
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xc2, 0x4a, 0x00,  //@@@@@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0051 (Q) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x0e, 0x7e, 0xd0, 0xf2, 0xf4, 0xd2, 0x82, 0x10, 0x00, 0x00,  //...+@@@@%...
    0x00, 0x28, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x2c, 0x00,  //..@@@@@@@@..
    0x08, 0xd8, 0xff, 0xce, 0x46, 0x0a, 0x0a, 0x44, 0xce, 0xff, 0xde, 0x0c,  //.@@@+..+@@@.
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd6, 0xff, 0x74,  //+@@......@@+
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xc2,  //%@+......+@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xec,  //@@........@@
    0xfa, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xf6,  //@@........@@
    0xec, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xdc,  //@@........@@
    0xc0, 0xff, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xff, 0xb0,  //%@+......+@%
    0x6e, 0xff, 0xd4, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xd4, 0xff, 0x4a,  //+@@......@@+
    0x0a, 0xdc, 0xff, 0xcc, 0x44, 0x0a, 0x08, 0x42, 0xcc, 0xff, 0xac, 0x00,  //.@@@+..+@@%.
    0x00, 0x2a, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x08, 0x00,  //..@@@@@@@%..
    0x00, 0x00, 0x10, 0x82, 0xd2, 0xf4, 0xff, 0xff, 0xa6, 0x00, 0x00, 0x00,  //...%@@@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xfa, 0xff, 0x62, 0x00, 0x00,  //......+@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0xff, 0xf8, 0x42, 0x00,  //.......+@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0052 (R) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xc6, 0x58, 0x00, 0x00, 0x00,  //@@@@@@+...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x00,  //@@@@@@@+..
    0xff, 0xff, 0x00, 0x00, 0x18, 0xa0, 0xff, 0xce, 0x00, 0x00,  //@@...%@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf6, 0x00, 0x00,  //@@....@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0xea, 0x00, 0x00,  //@@....@@..
    0xff, 0xff, 0x00, 0x00, 0x16, 0xa0, 0xff, 0xa4, 0x00, 0x00,  //@@...%@%..
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x14, 0x00, 0x00,  //@@@@@@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x48, 0x00, 0x00, 0x00,  //@@@@@@+...
    0xff, 0xff, 0x00, 0x06, 0x58, 0xf6, 0xf8, 0x30, 0x00, 0x00,  //@@..+@@...
    0xff, 0xff, 0x00, 0x00, 0x00, 0x74, 0xff, 0xc6, 0x00, 0x00,  //@@...+@@..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x04, 0xd4, 0xff, 0x66, 0x00,  //@@....@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0xee, 0x18,  //@@....+@@.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xff, 0xac,  //@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0053 (S) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x34, 0xb0, 0xe0, 0xf8, 0xde, 0x9e, 0x3a, 0x00,  //..%@@@%..
    0x50, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,  //+@@@@@@@.
    0xd2, 0xff, 0xb6, 0x2e, 0x06, 0x14, 0x54, 0xbe, 0x00,  //@@%...+%.
    0xf6, 0xff, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xd4, 0xff, 0x7c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+......
    0x56, 0xff, 0xff, 0xff, 0xda, 0xa6, 0x5a, 0x04, 0x00,  //+@@@@%+..
    0x00, 0x40, 0xb0, 0xf2, 0xff, 0xff, 0xff, 0xce, 0x12,  //..%@@@@@.
    0x00, 0x00, 0x00, 0x02, 0x28, 0x68, 0xde, 0xff, 0x96,  //.....+@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0xff, 0xe0,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xf8,  //.......@@
    0xc8, 0x68, 0x26, 0x06, 0x0a, 0x38, 0xc0, 0xff, 0xd4,  //@+....%@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x52,  //@@@@@@@@+
    0x32, 0x8e, 0xd0, 0xf4, 0xf8, 0xe2, 0xaa, 0x3a, 0x00,  //.%@@@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0054 (T) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0055 (U) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@......@@
    0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfc,  //@@......@@
    0xee, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x16, 0xff, 0xee,  //@@......@@
    0xc4, 0xff, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x5c, 0xff, 0xc4,  //@@+....+@@
    0x6e, 0xff, 0xe8, 0x54, 0x12, 0x12, 0x56, 0xea, 0xff, 0x6c,  //+@@+..+@@+
    0x04, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc2, 0x04,  //.@@@@@@@@.
    0x00, 0x08, 0x7a, 0xd2, 0xf6, 0xf4, 0xd2, 0x7a, 0x08, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0056 (V) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xcc, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0xff, 0xcc,  //@@+......+@@
    0x68, 0xff, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x66,  //+@%......%@+
    0x0e, 0xf4, 0xfc, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xfc, 0xf4, 0x0c,  //.@@......@@.
    0x00, 0x9e, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff, 0x9e, 0x00,  //.%@+....+@%.
    0x00, 0x38, 0xff, 0xda, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0x38, 0x00,  //..@@....@@..
    0x00, 0x00, 0xd4, 0xff, 0x3e, 0x00, 0x00, 0x40, 0xff, 0xd4, 0x00, 0x00,  //..@@....@@..
    0x00, 0x00, 0x6e, 0xff, 0xa2, 0x00, 0x00, 0xa2, 0xff, 0x70, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0x12, 0xf6, 0xf4, 0x0c, 0x0e, 0xf4, 0xf8, 0x12, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x00, 0xa4, 0xff, 0x66, 0x66, 0xff, 0xa6, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x00, 0x40, 0xff, 0xc8, 0xca, 0xff, 0x42, 0x00, 0x00, 0x00,  //....@@@@+...
    0x00, 0x00, 0x00, 0x00, 0xda, 0xff, 0xff, 0xdc, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0x78, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0x16, 0xf8, 0xfa, 0x18, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0057 (W) , Width: 17 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0xde, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x3a, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x2e, 0xff, 0xdc,  //@@.....@@@.....@@
    0x9c, 0xff, 0x6e, 0x00, 0x00, 0x00, 0x7a, 0xff, 0xf8, 0xff, 0x64, 0x00, 0x00, 0x00, 0x6e, 0xff, 0x9a,  //%@+...+@@@+...+@%
    0x5a, 0xff, 0xb0, 0x00, 0x00, 0x00, 0xba, 0xff, 0x98, 0xff, 0xa4, 0x00, 0x00, 0x00, 0xae, 0xff, 0x58,  //+@%...%@%@%...%@+
    0x18, 0xff, 0xec, 0x00, 0x00, 0x04, 0xf4, 0xfc, 0x1e, 0xfa, 0xe4, 0x00, 0x00, 0x00, 0xec, 0xff, 0x16,  //.@@...@@.@@...@@.
    0x00, 0xd6, 0xff, 0x30, 0x00, 0x38, 0xff, 0xce, 0x00, 0xc8, 0xff, 0x28, 0x00, 0x2e, 0xff, 0xd2, 0x00,  //.@@...@@.@@...@@.
    0x00, 0x94, 0xff, 0x72, 0x00, 0x78, 0xff, 0x8c, 0x00, 0x88, 0xff, 0x68, 0x00, 0x6e, 0xff, 0x90, 0x00,  //.%@+.+@%.%@+.+@%.
    0x00, 0x50, 0xff, 0xb2, 0x00, 0xb6, 0xff, 0x4c, 0x00, 0x48, 0xff, 0xaa, 0x00, 0xae, 0xff, 0x4e, 0x00,  //.+@%.%@+.+@%.%@+.
    0x00, 0x10, 0xfc, 0xee, 0x06, 0xf2, 0xfa, 0x0e, 0x00, 0x0c, 0xfa, 0xea, 0x02, 0xec, 0xfa, 0x0e, 0x00,  //..@@.@@...@@.@@..
    0x00, 0x00, 0xcc, 0xff, 0x6a, 0xff, 0xca, 0x00, 0x00, 0x00, 0xc8, 0xff, 0x5c, 0xff, 0xc8, 0x00, 0x00,  //..@@+@@...@@+@@..
    0x00, 0x00, 0x8a, 0xff, 0xe2, 0xff, 0x88, 0x00, 0x00, 0x00, 0x88, 0xff, 0xda, 0xff, 0x86, 0x00, 0x00,  //..%@@@%...%@@@%..
    0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0x44, 0x00, 0x00,  //..+@@@+...+@@@+..
    0x00, 0x00, 0x0a, 0xfa, 0xff, 0xfa, 0x0a, 0x00, 0x00, 0x00, 0x0c, 0xfa, 0xff, 0xf8, 0x08, 0x00, 0x00,  //...@@@.....@@@...
    0x00, 0x00, 0x00, 0xc4, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xff, 0xc0, 0x00, 0x00, 0x00,  //...@@@.....@@%...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.................


    /*Unicode: U+0058 (X) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0xb4, 0xff, 0xb0, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0xaa,  //.%@%....%@%
    0x00, 0x24, 0xf8, 0xff, 0x46, 0x00, 0x00, 0x64, 0xff, 0xec, 0x16,  //..@@+..+@@.
    0x00, 0x00, 0x86, 0xff, 0xd6, 0x04, 0x1a, 0xf0, 0xff, 0x5a, 0x00,  //..%@@..@@+.
    0x00, 0x00, 0x0a, 0xe4, 0xff, 0x72, 0xb4, 0xff, 0xb2, 0x00, 0x00,  //...@@+%@%..
    0x00, 0x00, 0x00, 0x58, 0xff, 0xfa, 0xff, 0xee, 0x1a, 0x00, 0x00,  //...+@@@@...
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x62, 0x00, 0x00, 0x00,  //....%@@+...
    0x00, 0x00, 0x00, 0x00, 0xb2, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00,  //....%@@....
    0x00, 0x00, 0x00, 0x5c, 0xff, 0xff, 0xff, 0xc6, 0x00, 0x00, 0x00,  //...+@@@@...
    0x00, 0x00, 0x16, 0xec, 0xff, 0x7a, 0xec, 0xff, 0x5c, 0x00, 0x00,  //...@@+@@+..
    0x00, 0x00, 0xae, 0xff, 0xbe, 0x00, 0x6a, 0xff, 0xe4, 0x0c, 0x00,  //..%@%.+@@..
    0x00, 0x58, 0xff, 0xf4, 0x22, 0x00, 0x02, 0xd0, 0xff, 0x88, 0x00,  //.+@@...@@%.
    0x14, 0xea, 0xff, 0x70, 0x00, 0x00, 0x00, 0x3e, 0xff, 0xf8, 0x24,  //.@@+....@@.
    0xaa, 0xff, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0xb4,  //%@@.....%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+0059 (Y) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0xa0, 0xff, 0xca, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02, 0xca, 0xff, 0xa0,  //%@@......@@%
    0x0a, 0xd8, 0xff, 0x72, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xd8, 0x0a,  //.@@+....+@@.
    0x00, 0x30, 0xf8, 0xf4, 0x22, 0x00, 0x00, 0x22, 0xf4, 0xf6, 0x30, 0x00,  //..@@....@@..
    0x00, 0x00, 0x6e, 0xff, 0xbc, 0x00, 0x00, 0xbe, 0xff, 0x6c, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0x00, 0xb0, 0xff, 0x64, 0x66, 0xff, 0xb0, 0x00, 0x00, 0x00,  //...%@++@%...
    0x00, 0x00, 0x00, 0x12, 0xe2, 0xf0, 0xf0, 0xe2, 0x10, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x3c, 0xff, 0xff, 0x3c, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+005a (Z) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xbc, 0xff, 0xe6, 0x1a,  //.......%@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xff, 0xf8, 0x38, 0x00,  //......%@@..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x52, 0xff, 0xff, 0x60, 0x00, 0x00,  //.....+@@+..
    0x00, 0x00, 0x00, 0x00, 0x28, 0xf2, 0xff, 0x92, 0x00, 0x00, 0x00,  //.....@@%...
    0x00, 0x00, 0x00, 0x0c, 0xd6, 0xff, 0xbc, 0x02, 0x00, 0x00, 0x00,  //....@@%....
    0x00, 0x00, 0x00, 0xac, 0xff, 0xde, 0x12, 0x00, 0x00, 0x00, 0x00,  //...%@@.....
    0x00, 0x00, 0x76, 0xff, 0xf2, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,  //..+@@......
    0x00, 0x42, 0xfa, 0xfc, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.+@@+......
    0x1e, 0xea, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.@@%.......
    0xca, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005b ([) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0x00, 0x00,  //@@..
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+005c (\) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xdc, 0xff, 0x38, 0x00, 0x00, 0x00,  //@@....
    0x9a, 0xff, 0x7a, 0x00, 0x00, 0x00,  //%@+...
    0x56, 0xff, 0xbc, 0x00, 0x00, 0x00,  //+@%...
    0x14, 0xfc, 0xf6, 0x06, 0x00, 0x00,  //.@@...
    0x00, 0xd0, 0xff, 0x42, 0x00, 0x00,  //.@@+..
    0x00, 0x8c, 0xff, 0x84, 0x00, 0x00,  //.%@%..
    0x00, 0x4a, 0xff, 0xc8, 0x00, 0x00,  //.+@@..
    0x00, 0x0c, 0xfa, 0xfa, 0x0e, 0x00,  //..@@..
    0x00, 0x00, 0xc4, 0xff, 0x4c, 0x00,  //..@@+.
    0x00, 0x00, 0x80, 0xff, 0x90, 0x00,  //..+@%.
    0x00, 0x00, 0x3c, 0xff, 0xd2, 0x00,  //...@@.
    0x00, 0x00, 0x04, 0xf4, 0xff, 0x16,  //...@@.
    0x00, 0x00, 0x00, 0xb6, 0xff, 0x58,  //...%@+
    0x00, 0x00, 0x00, 0x74, 0xff, 0x9a,  //...+@%
    0x00, 0x00, 0x00, 0x30, 0xff, 0xdc,  //....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+005d (]) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+005e (^) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x08, 0xc2, 0xff, 0xc2, 0x08, 0x00, 0x00, 0x00,  //....@@@....
    0x00, 0x00, 0x04, 0xb6, 0xff, 0xae, 0xff, 0xb4, 0x04, 0x00, 0x00,  //...%@%@%...
    0x00, 0x00, 0xa8, 0xfc, 0x62, 0x00, 0x64, 0xfc, 0xa6, 0x00, 0x00,  //..%@+.+@%..
    0x00, 0x98, 0xf8, 0x54, 0x00, 0x00, 0x00, 0x56, 0xf8, 0x98, 0x00,  //.%@+...+@%.
    0x88, 0xf4, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf4, 0x86,  //%@+.....+@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........


    /*Unicode: U+005f (_) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@


    /*Unicode: U+0060 (`) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x8a, 0xe8, 0x1c, 0x00,  //%@..
    0x00, 0xa0, 0xc8, 0x06,  //.%@.
    0x00, 0x02, 0xb6, 0x9a,  //..%%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0061 (a) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x44, 0xb2, 0xee, 0xf4, 0xc4, 0x42, 0x00,  //.+%@@@+.
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x32,  //.@@@@@@.
    0x00, 0xaa, 0x30, 0x06, 0x20, 0xac, 0xff, 0xa6,  //.%...%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xe0,  //......@@
    0x02, 0x72, 0xce, 0xf4, 0xff, 0xff, 0xff, 0xf8,  //.+@@@@@@
    0x8c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@@
    0xec, 0xff, 0x5c, 0x10, 0x02, 0x10, 0xff, 0xff,  //@@+...@@
    0xec, 0xff, 0x4e, 0x06, 0x20, 0xaa, 0xff, 0xff,  //@@+..%@@
    0xa4, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff,  //%@@@@%@@
    0x10, 0xa2, 0xec, 0xee, 0x9c, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0062 (b) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x08, 0x98, 0xea, 0xf2, 0xae, 0x1e, 0x00,  //@@.%@@%..
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10,  //@@%@@@@@.
    0xff, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x88,  //@@@...@@%
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd4,  //@@+...+@@
    0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd4,  //@@+...+@@
    0xff, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x88,  //@@@...@@%
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10,  //@@%@@@@@.
    0xff, 0xff, 0x0a, 0x9a, 0xec, 0xf2, 0xae, 0x20, 0x00,  //@@.%@@%..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0063 (c) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x02, 0x6e, 0xca, 0xf2, 0xf4, 0xbe, 0x4c,  //..+@@@%+
    0x04, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x72, 0xff, 0xf2, 0x6c, 0x1a, 0x06, 0x38, 0xae,  //+@@+...%
    0xce, 0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+.....
    0xf4, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xf4, 0xff, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xce, 0xff, 0x62, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@+.....
    0x70, 0xff, 0xf0, 0x6a, 0x1a, 0x06, 0x36, 0xae,  //+@@+...%
    0x04, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@
    0x00, 0x04, 0x72, 0xd0, 0xf6, 0xf2, 0xbe, 0x4c,  //..+@@@%+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0064 (d) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x20, 0xae, 0xf2, 0xea, 0x96, 0x08, 0xff, 0xff,  //..%@@%.@@
    0x12, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xac, 0xff, 0xff,  //.@@@@@%@@
    0x88, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0xff,  //%@@...@@@
    0xd6, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff,  //@@+...+@@
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff,  //@@.....@@
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff,  //@@.....@@
    0xd6, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff,  //@@+...+@@
    0x88, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0xff,  //%@@...@@@
    0x12, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xac, 0xff, 0xff,  //.@@@@@%@@
    0x00, 0x20, 0xb0, 0xf2, 0xec, 0x98, 0x08, 0xff, 0xff,  //..%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0065 (e) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x5a, 0xbe, 0xee, 0xf8, 0xda, 0x88, 0x0e, 0x00,  //..+%@@@%..
    0x00, 0xa4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd2, 0x0c,  //.%@@@@@@@.
    0x62, 0xff, 0xe2, 0x54, 0x12, 0x08, 0x38, 0xc8, 0xff, 0x86,  //+@@+...@@%
    0xc6, 0xff, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x20, 0xff, 0xd8,  //@@......@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,  //@@@@@@@@@@
    0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@@@
    0xca, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@........
    0x60, 0xff, 0xe6, 0x62, 0x1e, 0x08, 0x06, 0x24, 0x64, 0xc4,  //+@@+....+@
    0x00, 0x90, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //.%@@@@@@@@
    0x00, 0x00, 0x42, 0xaa, 0xe2, 0xf8, 0xf4, 0xd2, 0x8c, 0x2e,  //..+%@@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0066 (f) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x06, 0x88, 0xde, 0xfa, 0xff,  //...%@@@
    0x00, 0x00, 0x82, 0xff, 0xff, 0xff, 0xff,  //..%@@@@
    0x00, 0x00, 0xdc, 0xff, 0x50, 0x04, 0x00,  //..@@+..
    0x00, 0x00, 0xfa, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //..@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0067 (g) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x22, 0xb0, 0xf2, 0xea, 0x96, 0x08, 0xff, 0xff,  //..%@@%.@@
    0x12, 0xe4, 0xff, 0xff, 0xff, 0xff, 0xac, 0xff, 0xff,  //.@@@@@%@@
    0x8a, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xde, 0xff, 0xff,  //%@@...@@@
    0xd6, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x4c, 0xff, 0xff,  //@@+...+@@
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff,  //@@.....@@
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff,  //@@.....@@
    0xd6, 0xff, 0x4a, 0x00, 0x00, 0x00, 0x4a, 0xff, 0xff,  //@@+...+@@
    0x8a, 0xff, 0xdc, 0x3c, 0x0a, 0x3c, 0xdc, 0xff, 0xff,  //%@@...@@@
    0x14, 0xe6, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xfa,  //.@@@@@%@@
    0x00, 0x24, 0xb2, 0xf4, 0xec, 0x98, 0x28, 0xff, 0xe8,  //..%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xff, 0xbe,  //......+@%
    0x00, 0xae, 0x3c, 0x0c, 0x18, 0x64, 0xf0, 0xff, 0x6a,  //.%...+@@+
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xca, 0x04,  //.@@@@@@@.
    0x00, 0x48, 0xb6, 0xe4, 0xf8, 0xda, 0x88, 0x0c, 0x00,  //.+%@@@%..


    /*Unicode: U+0068 (h) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@......
    0xff, 0xff, 0x08, 0x9c, 0xf0, 0xea, 0x86, 0x00,  //@@.%@@%.
    0xff, 0xff, 0xaa, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@%@@@@+
    0xff, 0xff, 0xcc, 0x2a, 0x0e, 0x98, 0xff, 0xca,  //@@@..%@@
    0xff, 0xff, 0x36, 0x00, 0x00, 0x18, 0xff, 0xf2,  //@@....@@
    0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0069 (i) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+006a (j) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x00, 0xff, 0xff,  //..@@
    0x00, 0x0e, 0xff, 0xf6,  //..@@
    0x08, 0x76, 0xff, 0xd2,  //.+@@
    0xff, 0xff, 0xff, 0x7a,  //@@@+
    0xfa, 0xda, 0x7e, 0x02,  //@@+.


    /*Unicode: U+006b (k) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x3a, 0xee, 0xff, 0x76,  //@@....@@+
    0xff, 0xff, 0x00, 0x00, 0x44, 0xf4, 0xfc, 0x62, 0x00,  //@@..+@@+.
    0xff, 0xff, 0x00, 0x4e, 0xf6, 0xf8, 0x54, 0x00, 0x00,  //@@.+@@+..
    0xff, 0xff, 0x5a, 0xfa, 0xf2, 0x44, 0x00, 0x00, 0x00,  //@@+@@+...
    0xff, 0xff, 0xfc, 0xee, 0x38, 0x00, 0x00, 0x00, 0x00,  //@@@@.....
    0xff, 0xff, 0xff, 0xf8, 0x52, 0x00, 0x00, 0x00, 0x00,  //@@@@+....
    0xff, 0xff, 0x6c, 0xff, 0xfa, 0x5a, 0x00, 0x00, 0x00,  //@@+@@+...
    0xff, 0xff, 0x00, 0x6e, 0xff, 0xfc, 0x64, 0x00, 0x00,  //@@.+@@+..
    0xff, 0xff, 0x00, 0x00, 0x70, 0xff, 0xfc, 0x6e, 0x00,  //@@..+@@+.
    0xff, 0xff, 0x00, 0x00, 0x00, 0x72, 0xff, 0xff, 0x78,  //@@...+@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+006c (l) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+006d (m) , Width: 14 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0xff, 0xff, 0x0a, 0x9e, 0xf0, 0xe6, 0x6e, 0x00, 0x10, 0xa2, 0xee, 0xea, 0x84, 0x00,  //@@.%@@+..%@@%.
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0x4c, 0xc8, 0xff, 0xff, 0xff, 0xff, 0x5c,  //@@%@@@@+@@@@@+
    0xff, 0xff, 0xce, 0x2c, 0x0c, 0x94, 0xff, 0xee, 0xce, 0x2c, 0x0c, 0x94, 0xff, 0xc2,  //@@@..%@@@..%@@
    0xff, 0xff, 0x36, 0x00, 0x00, 0x18, 0xff, 0xff, 0x36, 0x00, 0x00, 0x18, 0xff, 0xe8,  //@@....@@....@@
    0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0xff, 0xfc,  //@@....@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..............


    /*Unicode: U+006e (n) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x08, 0x9c, 0xf0, 0xea, 0x86, 0x00,  //@@.%@@%.
    0xff, 0xff, 0xaa, 0xff, 0xff, 0xff, 0xff, 0x6a,  //@@%@@@@+
    0xff, 0xff, 0xcc, 0x2a, 0x0e, 0x98, 0xff, 0xca,  //@@@..%@@
    0xff, 0xff, 0x36, 0x00, 0x00, 0x18, 0xff, 0xf2,  //@@....@@
    0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+006f (o) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x04, 0x76, 0xce, 0xf4, 0xf4, 0xce, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0x04,  //.%@@@@@@%.
    0x76, 0xff, 0xee, 0x60, 0x14, 0x14, 0x60, 0xf0, 0xff, 0x74,  //+@@+..+@@+
    0xd0, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0xce,  //@@+....+@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xf6, 0xff, 0x12, 0x00, 0x00, 0x00, 0x00, 0x14, 0xff, 0xf4,  //@@......@@
    0xd0, 0xff, 0x5c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xff, 0xce,  //@@+....+@@
    0x76, 0xff, 0xec, 0x5c, 0x12, 0x12, 0x5e, 0xee, 0xff, 0x74,  //+@@+..+@@+
    0x06, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0x04,  //.%@@@@@@%.
    0x00, 0x06, 0x76, 0xd0, 0xf6, 0xf4, 0xd0, 0x74, 0x04, 0x00,  //..+@@@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0070 (p) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0xff, 0xff, 0x08, 0x98, 0xea, 0xf2, 0xae, 0x1e, 0x00,  //@@.%@@%..
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10,  //@@%@@@@@.
    0xff, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x88,  //@@@...@@%
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd4,  //@@+...+@@
    0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xf6,  //@@.....@@
    0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xd4,  //@@+...+@@
    0xff, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0x88,  //@@@...@@%
    0xff, 0xff, 0xac, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x10,  //@@%@@@@@.
    0xff, 0xff, 0x0a, 0x9a, 0xec, 0xf2, 0xae, 0x20, 0x00,  //@@.%@@%..
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //@@.......


    /*Unicode: U+0071 (q) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x20, 0xae, 0xf2, 0xea, 0x96, 0x08, 0xff, 0xff,  //..%@@%.@@
    0x12, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xac, 0xff, 0xff,  //.@@@@@%@@
    0x88, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0xff,  //%@@...@@@
    0xd6, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff,  //@@+...+@@
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff,  //@@.....@@
    0xf6, 0xff, 0x0e, 0x00, 0x00, 0x00, 0x10, 0xff, 0xff,  //@@.....@@
    0xd6, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x4e, 0xff, 0xff,  //@@+...+@@
    0x88, 0xff, 0xde, 0x3e, 0x0a, 0x3e, 0xe0, 0xff, 0xff,  //%@@...@@@
    0x12, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xac, 0xff, 0xff,  //.@@@@@%@@
    0x00, 0x20, 0xb0, 0xf2, 0xec, 0x98, 0x08, 0xff, 0xff,  //..%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //.......@@


    /*Unicode: U+0072 (r) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0x08, 0x92, 0xe8, 0xfa,  //@@.%@@
    0xff, 0xff, 0xaa, 0xff, 0xff, 0xff,  //@@%@@@
    0xff, 0xff, 0xe2, 0x48, 0x0a, 0x00,  //@@@+..
    0xff, 0xff, 0x50, 0x00, 0x00, 0x00,  //@@+...
    0xff, 0xff, 0x10, 0x00, 0x00, 0x00,  //@@....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@....
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00,  //@@....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0073 (s) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x08, 0x80, 0xd6, 0xf4, 0xf0, 0xba, 0x4a,  //.+@@@%+
    0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //%@@@@@@
    0xee, 0xff, 0x70, 0x10, 0x04, 0x34, 0xac,  //@@+...%
    0xd8, 0xff, 0xb2, 0x7e, 0x3c, 0x00, 0x00,  //@@%+...
    0x42, 0xe8, 0xff, 0xff, 0xff, 0xda, 0x2e,  //+@@@@@.
    0x00, 0x08, 0x48, 0x8e, 0xe4, 0xff, 0xc0,  //..+%@@%
    0x00, 0x00, 0x00, 0x00, 0x18, 0xff, 0xf4,  //.....@@
    0xb6, 0x44, 0x0a, 0x0a, 0x68, 0xff, 0xf6,  //%+..+@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4,  //@@@@@@%
    0x3e, 0xaa, 0xea, 0xf4, 0xd6, 0x7c, 0x08,  //.%@@@+.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0074 (t) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //.@@...
    0x00, 0xfc, 0xff, 0x02, 0x00, 0x00,  //.@@...
    0x00, 0xea, 0xff, 0x46, 0x00, 0x00,  //.@@+..
    0x00, 0xaa, 0xff, 0xff, 0xff, 0xff,  //.%@@@@
    0x00, 0x18, 0xaa, 0xec, 0xfc, 0xff,  //..%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0075 (u) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,  //@@....@@
    0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0xff, 0xff,  //@@....@@
    0xea, 0xff, 0x1a, 0x00, 0x00, 0x36, 0xff, 0xff,  //@@....@@
    0xc4, 0xff, 0x96, 0x0c, 0x2a, 0xcc, 0xff, 0xff,  //@@%..@@@
    0x60, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xff, 0xff,  //+@@@@%@@
    0x00, 0x86, 0xea, 0xf0, 0xa0, 0x0a, 0xff, 0xff,  //.%@@%.@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+0076 (v) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x12, 0xf6, 0xfa, 0x16, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xee, 0xe8, 0x04,  //.@@......@@.
    0x00, 0xa6, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0x8a, 0x00,  //.%@+....+@%.
    0x00, 0x40, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x00, 0xca, 0xff, 0x26, 0x00,  //..@@....@@..
    0x00, 0x00, 0xd8, 0xff, 0x28, 0x00, 0x00, 0x30, 0xff, 0xc4, 0x00, 0x00,  //..@@....@@..
    0x00, 0x00, 0x74, 0xff, 0x82, 0x00, 0x00, 0x98, 0xff, 0x62, 0x00, 0x00,  //..+@%..%@+..
    0x00, 0x00, 0x14, 0xf8, 0xdc, 0x00, 0x0c, 0xf2, 0xf2, 0x0a, 0x00, 0x00,  //...@@..@@...
    0x00, 0x00, 0x00, 0xa8, 0xff, 0x3a, 0x66, 0xff, 0x9c, 0x00, 0x00, 0x00,  //...%@.+@%...
    0x00, 0x00, 0x00, 0x42, 0xff, 0x96, 0xce, 0xff, 0x38, 0x00, 0x00, 0x00,  //...+@%@@....
    0x00, 0x00, 0x00, 0x00, 0xda, 0xf6, 0xff, 0xd6, 0x00, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x76, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............


    /*Unicode: U+0077 (w) , Width: 15 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x06, 0xf8, 0xfc, 0x0a, 0x00, 0x00, 0xce, 0xff, 0xce, 0x00, 0x00, 0x0a, 0xfc, 0xf6, 0x06,  //.@@...@@@...@@.
    0x00, 0xc2, 0xff, 0x3e, 0x00, 0x10, 0xfc, 0xff, 0xfc, 0x0e, 0x00, 0x3e, 0xff, 0xc2, 0x00,  //.@@...@@@...@@.
    0x00, 0x84, 0xff, 0x74, 0x00, 0x4c, 0xff, 0xdc, 0xff, 0x4a, 0x00, 0x72, 0xff, 0x84, 0x00,  //.%@+.+@@@+.+@%.
    0x00, 0x48, 0xff, 0xaa, 0x00, 0x8c, 0xff, 0x58, 0xff, 0x88, 0x00, 0xa8, 0xff, 0x46, 0x00,  //.+@%.%@+@%.%@+.
    0x00, 0x0c, 0xfa, 0xde, 0x00, 0xcc, 0xe4, 0x00, 0xe4, 0xc6, 0x00, 0xdc, 0xfa, 0x0c, 0x00,  //..@@.@@.@@.@@..
    0x00, 0x00, 0xcc, 0xff, 0x24, 0xfc, 0x9e, 0x00, 0xa0, 0xf8, 0x1c, 0xff, 0xcc, 0x00, 0x00,  //..@@.@%.%@.@@..
    0x00, 0x00, 0x8e, 0xff, 0x96, 0xff, 0x5a, 0x00, 0x5a, 0xff, 0x8a, 0xff, 0x8e, 0x00, 0x00,  //..%@%@+.+@%@%..
    0x00, 0x00, 0x50, 0xff, 0xf6, 0xfc, 0x14, 0x00, 0x16, 0xfc, 0xee, 0xff, 0x50, 0x00, 0x00,  //..+@@@...@@@+..
    0x00, 0x00, 0x14, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0x14, 0x00, 0x00,  //...@@@...@@@...
    0x00, 0x00, 0x00, 0xd6, 0xff, 0x88, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xd4, 0x00, 0x00, 0x00,  //...@@%...%@@...
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...............


    /*Unicode: U+0078 (x) , Width: 10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0xa6, 0xff, 0xd2, 0x00, 0x00, 0x00, 0x00, 0xd2, 0xff, 0xa4,  //%@@....@@%
    0x10, 0xe4, 0xff, 0x56, 0x00, 0x00, 0x56, 0xff, 0xde, 0x0e,  //.@@+..+@@.
    0x00, 0x46, 0xff, 0xd6, 0x00, 0x02, 0xd6, 0xfc, 0x3c, 0x00,  //.+@@..@@..
    0x00, 0x00, 0x94, 0xff, 0x5c, 0x5c, 0xff, 0x84, 0x00, 0x00,  //..%@++@%..
    0x00, 0x00, 0x08, 0xda, 0xda, 0xda, 0xce, 0x04, 0x00, 0x00,  //...@@@@...
    0x00, 0x00, 0x16, 0xec, 0xe0, 0xf0, 0xe8, 0x12, 0x00, 0x00,  //...@@@@...
    0x00, 0x00, 0xae, 0xff, 0x5c, 0x76, 0xff, 0xa6, 0x00, 0x00,  //..%@++@%..
    0x00, 0x58, 0xff, 0xd2, 0x00, 0x06, 0xe0, 0xff, 0x52, 0x00,  //.+@@..@@+.
    0x14, 0xea, 0xff, 0x4a, 0x00, 0x00, 0x58, 0xff, 0xe8, 0x12,  //.@@+..+@@.
    0xaa, 0xff, 0xc2, 0x00, 0x00, 0x00, 0x00, 0xc8, 0xff, 0xa8,  //%@@....@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..........


    /*Unicode: U+0079 (y) , Width: 12 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //............
    0x24, 0xfc, 0xf4, 0x12, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xf2, 0xfc, 0x26,  //.@@......@@.
    0x00, 0xa8, 0xff, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x74, 0xff, 0xae, 0x00,  //.%@+....+@%.
    0x00, 0x30, 0xff, 0xe4, 0x04, 0x00, 0x00, 0x02, 0xe0, 0xff, 0x38, 0x00,  //..@@....@@..
    0x00, 0x00, 0xb6, 0xff, 0x5e, 0x00, 0x00, 0x56, 0xff, 0xc2, 0x00, 0x00,  //..%@+..+@@..
    0x00, 0x00, 0x3e, 0xff, 0xd0, 0x00, 0x00, 0xc6, 0xff, 0x4c, 0x00, 0x00,  //...@@..@@+..
    0x00, 0x00, 0x00, 0xc4, 0xff, 0x42, 0x36, 0xff, 0xd4, 0x00, 0x00, 0x00,  //...@@+.@@...
    0x00, 0x00, 0x00, 0x4a, 0xff, 0xb6, 0xa8, 0xff, 0x60, 0x00, 0x00, 0x00,  //...+@%%@+...
    0x00, 0x00, 0x00, 0x00, 0xd0, 0xfc, 0xfa, 0xe2, 0x04, 0x00, 0x00, 0x00,  //....@@@@....
    0x00, 0x00, 0x00, 0x00, 0x58, 0xff, 0xff, 0x74, 0x00, 0x00, 0x00, 0x00,  //....+@@+....
    0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0xee, 0x0c, 0x00, 0x00, 0x00, 0x00,  //.....@@.....
    0x00, 0x00, 0x00, 0x00, 0x62, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00,  //....+@%.....
    0x00, 0x00, 0x00, 0x10, 0xba, 0xff, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,  //....%@......
    0x00, 0x00, 0xff, 0xff, 0xff, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@@%......
    0x00, 0x00, 0xff, 0xf6, 0xb6, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //..@@%.......


    /*Unicode: U+007a (z) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x4a, 0xfc, 0xfa, 0x36,  //....+@@.
    0x00, 0x00, 0x00, 0x1e, 0xec, 0xff, 0x7a, 0x00,  //....@@+.
    0x00, 0x00, 0x06, 0xca, 0xff, 0xc2, 0x02, 0x00,  //...@@@..
    0x00, 0x00, 0x98, 0xff, 0xee, 0x1e, 0x00, 0x00,  //..%@@...
    0x00, 0x5c, 0xff, 0xff, 0x58, 0x00, 0x00, 0x00,  //.+@@+...
    0x2a, 0xf4, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00,  //.@@%....
    0xd8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+007b ({) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x10, 0x96, 0xda, 0xf4, 0xff,  //....%@@@
    0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xff, 0xff,  //...%@@@@
    0x00, 0x00, 0x00, 0xe8, 0xff, 0x66, 0x0c, 0x00,  //...@@+..
    0x00, 0x00, 0x00, 0xfc, 0xff, 0x04, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x0c, 0xff, 0xf6, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x14, 0x86, 0xff, 0xcc, 0x00, 0x00, 0x00,  //..%@@...
    0xff, 0xff, 0xff, 0xca, 0x32, 0x00, 0x00, 0x00,  //@@@@....
    0xff, 0xff, 0xfc, 0xc2, 0x26, 0x00, 0x00, 0x00,  //@@@@....
    0x00, 0x1e, 0xaa, 0xff, 0xbe, 0x00, 0x00, 0x00,  //..%@%...
    0x00, 0x00, 0x1e, 0xff, 0xf0, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x02, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xfa, 0xff, 0x08, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xe2, 0xff, 0x74, 0x0e, 0x00,  //...@@+..
    0x00, 0x00, 0x00, 0x96, 0xff, 0xff, 0xff, 0xff,  //...%@@@@
    0x00, 0x00, 0x00, 0x0c, 0x90, 0xd8, 0xf6, 0xff,  //....%@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+007c (|) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@
    0xff, 0xff,  //@@


    /*Unicode: U+007d (}) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xf4, 0xda, 0x96, 0x10, 0x00, 0x00, 0x00,  //@@@%....
    0xff, 0xff, 0xff, 0xff, 0xa4, 0x00, 0x00, 0x00,  //@@@@%...
    0x00, 0x0c, 0x64, 0xff, 0xe8, 0x00, 0x00, 0x00,  //..+@@...
    0x00, 0x00, 0x04, 0xff, 0xfc, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xf8, 0xff, 0x0a, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xcc, 0xff, 0x86, 0x14, 0x00,  //...@@%..
    0x00, 0x00, 0x00, 0x32, 0xca, 0xff, 0xff, 0xff,  //....@@@@
    0x00, 0x00, 0x00, 0x26, 0xc2, 0xfc, 0xff, 0xff,  //....@@@@
    0x00, 0x00, 0x00, 0xbe, 0xff, 0xa8, 0x1e, 0x00,  //...%@%..
    0x00, 0x00, 0x00, 0xf0, 0xff, 0x1e, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x02, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x00, 0x0a, 0xff, 0xf8, 0x00, 0x00, 0x00,  //...@@...
    0x00, 0x0c, 0x70, 0xff, 0xe0, 0x00, 0x00, 0x00,  //..+@@...
    0xff, 0xff, 0xff, 0xff, 0x96, 0x00, 0x00, 0x00,  //@@@@%...
    0xff, 0xf6, 0xd8, 0x90, 0x0c, 0x00, 0x00, 0x00,  //@@@%....
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+007e (~) , Width: 11 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,  //...........
    0x10, 0x8e, 0xe4, 0xf6, 0xd0, 0x8a, 0x3e, 0x0a, 0x0e, 0x58, 0xda,  //.%@@@%...+@
    0xe2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,  //@@@@@@@@@@@
    0xea, 0x68, 0x12, 0x0c, 0x40, 0x8a, 0xd2, 0xf6, 0xe4, 0x90, 0x10,  //@+...%@@@%.
    0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //...........



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_20_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_20 == 1
    {.w_px = 6,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 2,   .glyph_index = 20}, /*Unicode: U+0021 (!)*/
    {.w_px = 6,   .glyph_index = 40}, /*Unicode: U+0022 (")*/
    {.w_px = 12,  .glyph_index = 60}, /*Unicode: U+0023 (#)*/
    {.w_px = 9,   .glyph_index = 100},    /*Unicode: U+0024 ($)*/
    {.w_px = 15,  .glyph_index = 140},    /*Unicode: U+0025 (%)*/
    {.w_px = 12,  .glyph_index = 180},    /*Unicode: U+0026 (&)*/
    {.w_px = 2,   .glyph_index = 220},    /*Unicode: U+0027 (')*/
    {.w_px = 4,   .glyph_index = 240},    /*Unicode: U+0028 (()*/
    {.w_px = 4,   .glyph_index = 260},    /*Unicode: U+0029 ())*/
    {.w_px = 7,   .glyph_index = 280},    /*Unicode: U+002a (*)*/
    {.w_px = 12,  .glyph_index = 300},    /*Unicode: U+002b (+)*/
    {.w_px = 3,   .glyph_index = 340},    /*Unicode: U+002c (,)*/
    {.w_px = 5,   .glyph_index = 360},    /*Unicode: U+002d (-)*/
    {.w_px = 2,   .glyph_index = 380},    /*Unicode: U+002e (.)*/
    {.w_px = 6,   .glyph_index = 400},    /*Unicode: U+002f (/)*/
    {.w_px = 9,   .glyph_index = 420},    /*Unicode: U+0030 (0)*/
    {.w_px = 8,   .glyph_index = 460},    /*Unicode: U+0031 (1)*/
    {.w_px = 9,   .glyph_index = 480},    /*Unicode: U+0032 (2)*/
    {.w_px = 9,   .glyph_index = 520},    /*Unicode: U+0033 (3)*/
    {.w_px = 10,  .glyph_index = 560},    /*Unicode: U+0034 (4)*/
    {.w_px = 8,   .glyph_index = 600},    /*Unicode: U+0035 (5)*/
    {.w_px = 9,   .glyph_index = 620},    /*Unicode: U+0036 (6)*/
    {.w_px = 8,   .glyph_index = 660},    /*Unicode: U+0037 (7)*/
    {.w_px = 9,   .glyph_index = 680},    /*Unicode: U+0038 (8)*/
    {.w_px = 9,   .glyph_index = 720},    /*Unicode: U+0039 (9)*/
    {.w_px = 2,   .glyph_index = 760},    /*Unicode: U+003a (:)*/
    {.w_px = 3,   .glyph_index = 780},    /*Unicode: U+003b (;)*/
    {.w_px = 11,  .glyph_index = 800},    /*Unicode: U+003c (<)*/
    {.w_px = 11,  .glyph_index = 840},    /*Unicode: U+003d (=)*/
    {.w_px = 11,  .glyph_index = 880},    /*Unicode: U+003e (>)*/
    {.w_px = 7,   .glyph_index = 920},    /*Unicode: U+003f (?)*/
    {.w_px = 16,  .glyph_index = 940},    /*Unicode: U+0040 (@)*/
    {.w_px = 12,  .glyph_index = 980},    /*Unicode: U+0041 (A)*/
    {.w_px = 9,   .glyph_index = 1020},   /*Unicode: U+0042 (B)*/
    {.w_px = 11,  .glyph_index = 1060},   /*Unicode: U+0043 (C)*/
    {.w_px = 11,  .glyph_index = 1100},   /*Unicode: U+0044 (D)*/
    {.w_px = 8,   .glyph_index = 1140},   /*Unicode: U+0045 (E)*/
    {.w_px = 8,   .glyph_index = 1160},   /*Unicode: U+0046 (F)*/
    {.w_px = 11,  .glyph_index = 1180},   /*Unicode: U+0047 (G)*/
    {.w_px = 10,  .glyph_index = 1220},   /*Unicode: U+0048 (H)*/
    {.w_px = 2,   .glyph_index = 1260},   /*Unicode: U+0049 (I)*/
    {.w_px = 4,   .glyph_index = 1280},   /*Unicode: U+004a (J)*/
    {.w_px = 11,  .glyph_index = 1300},   /*Unicode: U+004b (K)*/
    {.w_px = 8,   .glyph_index = 1340},   /*Unicode: U+004c (L)*/
    {.w_px = 12,  .glyph_index = 1360},   /*Unicode: U+004d (M)*/
    {.w_px = 10,  .glyph_index = 1400},   /*Unicode: U+004e (N)*/
    {.w_px = 12,  .glyph_index = 1440},   /*Unicode: U+004f (O)*/
    {.w_px = 8,   .glyph_index = 1480},   /*Unicode: U+0050 (P)*/
    {.w_px = 12,  .glyph_index = 1500},   /*Unicode: U+0051 (Q)*/
    {.w_px = 10,  .glyph_index = 1540},   /*Unicode: U+0052 (R)*/
    {.w_px = 9,   .glyph_index = 1580},   /*Unicode: U+0053 (S)*/
    {.w_px = 12,  .glyph_index = 1620},   /*Unicode: U+0054 (T)*/
    {.w_px = 10,  .glyph_index = 1660},   /*Unicode: U+0055 (U)*/
    {.w_px = 12,  .glyph_index = 1700},   /*Unicode: U+0056 (V)*/
    {.w_px = 17,  .glyph_index = 1740},   /*Unicode: U+0057 (W)*/
    {.w_px = 11,  .glyph_index = 1800},   /*Unicode: U+0058 (X)*/
    {.w_px = 12,  .glyph_index = 1840},   /*Unicode: U+0059 (Y)*/
    {.w_px = 11,  .glyph_index = 1880},   /*Unicode: U+005a (Z)*/
    {.w_px = 4,   .glyph_index = 1920},   /*Unicode: U+005b ([)*/
    {.w_px = 6,   .glyph_index = 1940},   /*Unicode: U+005c (\)*/
    {.w_px = 4,   .glyph_index = 1960},   /*Unicode: U+005d (])*/
    {.w_px = 11,  .glyph_index = 1980},   /*Unicode: U+005e (^)*/
    {.w_px = 9,   .glyph_index = 2020},   /*Unicode: U+005f (_)*/
    {.w_px = 4,   .glyph_index = 2060},   /*Unicode: U+0060 (`)*/
    {.w_px = 8,   .glyph_index = 2080},   /*Unicode: U+0061 (a)*/
    {.w_px = 9,   .glyph_index = 2100},   /*Unicode: U+0062 (b)*/
    {.w_px = 8,   .glyph_index = 2140},   /*Unicode: U+0063 (c)*/
    {.w_px = 9,   .glyph_index = 2160},   /*Unicode: U+0064 (d)*/
    {.w_px = 10,  .glyph_index = 2200},   /*Unicode: U+0065 (e)*/
    {.w_px = 7,   .glyph_index = 2240},   /*Unicode: U+0066 (f)*/
    {.w_px = 9,   .glyph_index = 2260},   /*Unicode: U+0067 (g)*/
    {.w_px = 8,   .glyph_index = 2300},   /*Unicode: U+0068 (h)*/
    {.w_px = 2,   .glyph_index = 2320},   /*Unicode: U+0069 (i)*/
    {.w_px = 4,   .glyph_index = 2340},   /*Unicode: U+006a (j)*/
    {.w_px = 9,   .glyph_index = 2360},   /*Unicode: U+006b (k)*/
    {.w_px = 2,   .glyph_index = 2400},   /*Unicode: U+006c (l)*/
    {.w_px = 14,  .glyph_index = 2420},   /*Unicode: U+006d (m)*/
    {.w_px = 8,   .glyph_index = 2460},   /*Unicode: U+006e (n)*/
    {.w_px = 10,  .glyph_index = 2480},   /*Unicode: U+006f (o)*/
    {.w_px = 9,   .glyph_index = 2520},   /*Unicode: U+0070 (p)*/
    {.w_px = 9,   .glyph_index = 2560},   /*Unicode: U+0071 (q)*/
    {.w_px = 6,   .glyph_index = 2600},   /*Unicode: U+0072 (r)*/
    {.w_px = 7,   .glyph_index = 2620},   /*Unicode: U+0073 (s)*/
    {.w_px = 6,   .glyph_index = 2640},   /*Unicode: U+0074 (t)*/
    {.w_px = 8,   .glyph_index = 2660},   /*Unicode: U+0075 (u)*/
    {.w_px = 12,  .glyph_index = 2680},   /*Unicode: U+0076 (v)*/
    {.w_px = 15,  .glyph_index = 2720},   /*Unicode: U+0077 (w)*/
    {.w_px = 10,  .glyph_index = 2760},   /*Unicode: U+0078 (x)*/
    {.w_px = 12,  .glyph_index = 2800},   /*Unicode: U+0079 (y)*/
    {.w_px = 8,   .glyph_index = 2840},   /*Unicode: U+007a (z)*/
    {.w_px = 8,   .glyph_index = 2860},   /*Unicode: U+007b ({)*/
    {.w_px = 2,   .glyph_index = 2880},   /*Unicode: U+007c (|)*/
    {.w_px = 8,   .glyph_index = 2900},   /*Unicode: U+007d (})*/
    {.w_px = 11,  .glyph_index = 2920},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_20 == 2
    {.w_px = 6,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 2,   .glyph_index = 40}, /*Unicode: U+0021 (!)*/
    {.w_px = 6,   .glyph_index = 60}, /*Unicode: U+0022 (")*/
    {.w_px = 12,  .glyph_index = 100},    /*Unicode: U+0023 (#)*/
    {.w_px = 9,   .glyph_index = 160},    /*Unicode: U+0024 ($)*/
    {.w_px = 15,  .glyph_index = 220},    /*Unicode: U+0025 (%)*/
    {.w_px = 12,  .glyph_index = 300},    /*Unicode: U+0026 (&)*/
    {.w_px = 2,   .glyph_index = 360},    /*Unicode: U+0027 (')*/
    {.w_px = 4,   .glyph_index = 380},    /*Unicode: U+0028 (()*/
    {.w_px = 4,   .glyph_index = 400},    /*Unicode: U+0029 ())*/
    {.w_px = 7,   .glyph_index = 420},    /*Unicode: U+002a (*)*/
    {.w_px = 12,  .glyph_index = 460},    /*Unicode: U+002b (+)*/
    {.w_px = 3,   .glyph_index = 520},    /*Unicode: U+002c (,)*/
    {.w_px = 5,   .glyph_index = 540},    /*Unicode: U+002d (-)*/
    {.w_px = 2,   .glyph_index = 580},    /*Unicode: U+002e (.)*/
    {.w_px = 6,   .glyph_index = 600},    /*Unicode: U+002f (/)*/
    {.w_px = 9,   .glyph_index = 640},    /*Unicode: U+0030 (0)*/
    {.w_px = 8,   .glyph_index = 700},    /*Unicode: U+0031 (1)*/
    {.w_px = 9,   .glyph_index = 740},    /*Unicode: U+0032 (2)*/
    {.w_px = 9,   .glyph_index = 800},    /*Unicode: U+0033 (3)*/
    {.w_px = 10,  .glyph_index = 860},    /*Unicode: U+0034 (4)*/
    {.w_px = 8,   .glyph_index = 920},    /*Unicode: U+0035 (5)*/
    {.w_px = 9,   .glyph_index = 960},    /*Unicode: U+0036 (6)*/
    {.w_px = 8,   .glyph_index = 1020},   /*Unicode: U+0037 (7)*/
    {.w_px = 9,   .glyph_index = 1060},   /*Unicode: U+0038 (8)*/
    {.w_px = 9,   .glyph_index = 1120},   /*Unicode: U+0039 (9)*/
    {.w_px = 2,   .glyph_index = 1180},   /*Unicode: U+003a (:)*/
    {.w_px = 3,   .glyph_index = 1200},   /*Unicode: U+003b (;)*/
    {.w_px = 11,  .glyph_index = 1220},   /*Unicode: U+003c (<)*/
    {.w_px = 11,  .glyph_index = 1280},   /*Unicode: U+003d (=)*/
    {.w_px = 11,  .glyph_index = 1340},   /*Unicode: U+003e (>)*/
    {.w_px = 7,   .glyph_index = 1400},   /*Unicode: U+003f (?)*/
    {.w_px = 16,  .glyph_index = 1440},   /*Unicode: U+0040 (@)*/
    {.w_px = 12,  .glyph_index = 1520},   /*Unicode: U+0041 (A)*/
    {.w_px = 9,   .glyph_index = 1580},   /*Unicode: U+0042 (B)*/
    {.w_px = 11,  .glyph_index = 1640},   /*Unicode: U+0043 (C)*/
    {.w_px = 11,  .glyph_index = 1700},   /*Unicode: U+0044 (D)*/
    {.w_px = 8,   .glyph_index = 1760},   /*Unicode: U+0045 (E)*/
    {.w_px = 8,   .glyph_index = 1800},   /*Unicode: U+0046 (F)*/
    {.w_px = 11,  .glyph_index = 1840},   /*Unicode: U+0047 (G)*/
    {.w_px = 10,  .glyph_index = 1900},   /*Unicode: U+0048 (H)*/
    {.w_px = 2,   .glyph_index = 1960},   /*Unicode: U+0049 (I)*/
    {.w_px = 4,   .glyph_index = 1980},   /*Unicode: U+004a (J)*/
    {.w_px = 11,  .glyph_index = 2000},   /*Unicode: U+004b (K)*/
    {.w_px = 8,   .glyph_index = 2060},   /*Unicode: U+004c (L)*/
    {.w_px = 12,  .glyph_index = 2100},   /*Unicode: U+004d (M)*/
    {.w_px = 10,  .glyph_index = 2160},   /*Unicode: U+004e (N)*/
    {.w_px = 12,  .glyph_index = 2220},   /*Unicode: U+004f (O)*/
    {.w_px = 8,   .glyph_index = 2280},   /*Unicode: U+0050 (P)*/
    {.w_px = 12,  .glyph_index = 2320},   /*Unicode: U+0051 (Q)*/
    {.w_px = 10,  .glyph_index = 2380},   /*Unicode: U+0052 (R)*/
    {.w_px = 9,   .glyph_index = 2440},   /*Unicode: U+0053 (S)*/
    {.w_px = 12,  .glyph_index = 2500},   /*Unicode: U+0054 (T)*/
    {.w_px = 10,  .glyph_index = 2560},   /*Unicode: U+0055 (U)*/
    {.w_px = 12,  .glyph_index = 2620},   /*Unicode: U+0056 (V)*/
    {.w_px = 17,  .glyph_index = 2680},   /*Unicode: U+0057 (W)*/
    {.w_px = 11,  .glyph_index = 2780},   /*Unicode: U+0058 (X)*/
    {.w_px = 12,  .glyph_index = 2840},   /*Unicode: U+0059 (Y)*/
    {.w_px = 11,  .glyph_index = 2900},   /*Unicode: U+005a (Z)*/
    {.w_px = 4,   .glyph_index = 2960},   /*Unicode: U+005b ([)*/
    {.w_px = 6,   .glyph_index = 2980},   /*Unicode: U+005c (\)*/
    {.w_px = 4,   .glyph_index = 3020},   /*Unicode: U+005d (])*/
    {.w_px = 11,  .glyph_index = 3040},   /*Unicode: U+005e (^)*/
    {.w_px = 9,   .glyph_index = 3100},   /*Unicode: U+005f (_)*/
    {.w_px = 4,   .glyph_index = 3160},   /*Unicode: U+0060 (`)*/
    {.w_px = 8,   .glyph_index = 3180},   /*Unicode: U+0061 (a)*/
    {.w_px = 9,   .glyph_index = 3220},   /*Unicode: U+0062 (b)*/
    {.w_px = 8,   .glyph_index = 3280},   /*Unicode: U+0063 (c)*/
    {.w_px = 9,   .glyph_index = 3320},   /*Unicode: U+0064 (d)*/
    {.w_px = 10,  .glyph_index = 3380},   /*Unicode: U+0065 (e)*/
    {.w_px = 7,   .glyph_index = 3440},   /*Unicode: U+0066 (f)*/
    {.w_px = 9,   .glyph_index = 3480},   /*Unicode: U+0067 (g)*/
    {.w_px = 8,   .glyph_index = 3540},   /*Unicode: U+0068 (h)*/
    {.w_px = 2,   .glyph_index = 3580},   /*Unicode: U+0069 (i)*/
    {.w_px = 4,   .glyph_index = 3600},   /*Unicode: U+006a (j)*/
    {.w_px = 9,   .glyph_index = 3620},   /*Unicode: U+006b (k)*/
    {.w_px = 2,   .glyph_index = 3680},   /*Unicode: U+006c (l)*/
    {.w_px = 14,  .glyph_index = 3700},   /*Unicode: U+006d (m)*/
    {.w_px = 8,   .glyph_index = 3780},   /*Unicode: U+006e (n)*/
    {.w_px = 10,  .glyph_index = 3820},   /*Unicode: U+006f (o)*/
    {.w_px = 9,   .glyph_index = 3880},   /*Unicode: U+0070 (p)*/
    {.w_px = 9,   .glyph_index = 3940},   /*Unicode: U+0071 (q)*/
    {.w_px = 6,   .glyph_index = 4000},   /*Unicode: U+0072 (r)*/
    {.w_px = 7,   .glyph_index = 4040},   /*Unicode: U+0073 (s)*/
    {.w_px = 6,   .glyph_index = 4080},   /*Unicode: U+0074 (t)*/
    {.w_px = 8,   .glyph_index = 4120},   /*Unicode: U+0075 (u)*/
    {.w_px = 12,  .glyph_index = 4160},   /*Unicode: U+0076 (v)*/
    {.w_px = 15,  .glyph_index = 4220},   /*Unicode: U+0077 (w)*/
    {.w_px = 10,  .glyph_index = 4300},   /*Unicode: U+0078 (x)*/
    {.w_px = 12,  .glyph_index = 4360},   /*Unicode: U+0079 (y)*/
    {.w_px = 8,   .glyph_index = 4420},   /*Unicode: U+007a (z)*/
    {.w_px = 8,   .glyph_index = 4460},   /*Unicode: U+007b ({)*/
    {.w_px = 2,   .glyph_index = 4500},   /*Unicode: U+007c (|)*/
    {.w_px = 8,   .glyph_index = 4520},   /*Unicode: U+007d (})*/
    {.w_px = 11,  .glyph_index = 4560},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_20 == 4
    {.w_px = 6,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 2,   .glyph_index = 60}, /*Unicode: U+0021 (!)*/
    {.w_px = 6,   .glyph_index = 80}, /*Unicode: U+0022 (")*/
    {.w_px = 12,  .glyph_index = 140},    /*Unicode: U+0023 (#)*/
    {.w_px = 9,   .glyph_index = 260},    /*Unicode: U+0024 ($)*/
    {.w_px = 15,  .glyph_index = 360},    /*Unicode: U+0025 (%)*/
    {.w_px = 12,  .glyph_index = 520},    /*Unicode: U+0026 (&)*/
    {.w_px = 2,   .glyph_index = 640},    /*Unicode: U+0027 (')*/
    {.w_px = 4,   .glyph_index = 660},    /*Unicode: U+0028 (()*/
    {.w_px = 4,   .glyph_index = 700},    /*Unicode: U+0029 ())*/
    {.w_px = 7,   .glyph_index = 740},    /*Unicode: U+002a (*)*/
    {.w_px = 12,  .glyph_index = 820},    /*Unicode: U+002b (+)*/
    {.w_px = 3,   .glyph_index = 940},    /*Unicode: U+002c (,)*/
    {.w_px = 5,   .glyph_index = 980},    /*Unicode: U+002d (-)*/
    {.w_px = 2,   .glyph_index = 1040},   /*Unicode: U+002e (.)*/
    {.w_px = 6,   .glyph_index = 1060},   /*Unicode: U+002f (/)*/
    {.w_px = 9,   .glyph_index = 1120},   /*Unicode: U+0030 (0)*/
    {.w_px = 8,   .glyph_index = 1220},   /*Unicode: U+0031 (1)*/
    {.w_px = 9,   .glyph_index = 1300},   /*Unicode: U+0032 (2)*/
    {.w_px = 9,   .glyph_index = 1400},   /*Unicode: U+0033 (3)*/
    {.w_px = 10,  .glyph_index = 1500},   /*Unicode: U+0034 (4)*/
    {.w_px = 8,   .glyph_index = 1600},   /*Unicode: U+0035 (5)*/
    {.w_px = 9,   .glyph_index = 1680},   /*Unicode: U+0036 (6)*/
    {.w_px = 8,   .glyph_index = 1780},   /*Unicode: U+0037 (7)*/
    {.w_px = 9,   .glyph_index = 1860},   /*Unicode: U+0038 (8)*/
    {.w_px = 9,   .glyph_index = 1960},   /*Unicode: U+0039 (9)*/
    {.w_px = 2,   .glyph_index = 2060},   /*Unicode: U+003a (:)*/
    {.w_px = 3,   .glyph_index = 2080},   /*Unicode: U+003b (;)*/
    {.w_px = 11,  .glyph_index = 2120},   /*Unicode: U+003c (<)*/
    {.w_px = 11,  .glyph_index = 2240},   /*Unicode: U+003d (=)*/
    {.w_px = 11,  .glyph_index = 2360},   /*Unicode: U+003e (>)*/
    {.w_px = 7,   .glyph_index = 2480},   /*Unicode: U+003f (?)*/
    {.w_px = 16,  .glyph_index = 2560},   /*Unicode: U+0040 (@)*/
    {.w_px = 12,  .glyph_index = 2720},   /*Unicode: U+0041 (A)*/
    {.w_px = 9,   .glyph_index = 2840},   /*Unicode: U+0042 (B)*/
    {.w_px = 11,  .glyph_index = 2940},   /*Unicode: U+0043 (C)*/
    {.w_px = 11,  .glyph_index = 3060},   /*Unicode: U+0044 (D)*/
    {.w_px = 8,   .glyph_index = 3180},   /*Unicode: U+0045 (E)*/
    {.w_px = 8,   .glyph_index = 3260},   /*Unicode: U+0046 (F)*/
    {.w_px = 11,  .glyph_index = 3340},   /*Unicode: U+0047 (G)*/
    {.w_px = 10,  .glyph_index = 3460},   /*Unicode: U+0048 (H)*/
    {.w_px = 2,   .glyph_index = 3560},   /*Unicode: U+0049 (I)*/
    {.w_px = 4,   .glyph_index = 3580},   /*Unicode: U+004a (J)*/
    {.w_px = 11,  .glyph_index = 3620},   /*Unicode: U+004b (K)*/
    {.w_px = 8,   .glyph_index = 3740},   /*Unicode: U+004c (L)*/
    {.w_px = 12,  .glyph_index = 3820},   /*Unicode: U+004d (M)*/
    {.w_px = 10,  .glyph_index = 3940},   /*Unicode: U+004e (N)*/
    {.w_px = 12,  .glyph_index = 4040},   /*Unicode: U+004f (O)*/
    {.w_px = 8,   .glyph_index = 4160},   /*Unicode: U+0050 (P)*/
    {.w_px = 12,  .glyph_index = 4240},   /*Unicode: U+0051 (Q)*/
    {.w_px = 10,  .glyph_index = 4360},   /*Unicode: U+0052 (R)*/
    {.w_px = 9,   .glyph_index = 4460},   /*Unicode: U+0053 (S)*/
    {.w_px = 12,  .glyph_index = 4560},   /*Unicode: U+0054 (T)*/
    {.w_px = 10,  .glyph_index = 4680},   /*Unicode: U+0055 (U)*/
    {.w_px = 12,  .glyph_index = 4780},   /*Unicode: U+0056 (V)*/
    {.w_px = 17,  .glyph_index = 4900},   /*Unicode: U+0057 (W)*/
    {.w_px = 11,  .glyph_index = 5080},   /*Unicode: U+0058 (X)*/
    {.w_px = 12,  .glyph_index = 5200},   /*Unicode: U+0059 (Y)*/
    {.w_px = 11,  .glyph_index = 5320},   /*Unicode: U+005a (Z)*/
    {.w_px = 4,   .glyph_index = 5440},   /*Unicode: U+005b ([)*/
    {.w_px = 6,   .glyph_index = 5480},   /*Unicode: U+005c (\)*/
    {.w_px = 4,   .glyph_index = 5540},   /*Unicode: U+005d (])*/
    {.w_px = 11,  .glyph_index = 5580},   /*Unicode: U+005e (^)*/
    {.w_px = 9,   .glyph_index = 5700},   /*Unicode: U+005f (_)*/
    {.w_px = 4,   .glyph_index = 5800},   /*Unicode: U+0060 (`)*/
    {.w_px = 8,   .glyph_index = 5840},   /*Unicode: U+0061 (a)*/
    {.w_px = 9,   .glyph_index = 5920},   /*Unicode: U+0062 (b)*/
    {.w_px = 8,   .glyph_index = 6020},   /*Unicode: U+0063 (c)*/
    {.w_px = 9,   .glyph_index = 6100},   /*Unicode: U+0064 (d)*/
    {.w_px = 10,  .glyph_index = 6200},   /*Unicode: U+0065 (e)*/
    {.w_px = 7,   .glyph_index = 6300},   /*Unicode: U+0066 (f)*/
    {.w_px = 9,   .glyph_index = 6380},   /*Unicode: U+0067 (g)*/
    {.w_px = 8,   .glyph_index = 6480},   /*Unicode: U+0068 (h)*/
    {.w_px = 2,   .glyph_index = 6560},   /*Unicode: U+0069 (i)*/
    {.w_px = 4,   .glyph_index = 6580},   /*Unicode: U+006a (j)*/
    {.w_px = 9,   .glyph_index = 6620},   /*Unicode: U+006b (k)*/
    {.w_px = 2,   .glyph_index = 6720},   /*Unicode: U+006c (l)*/
    {.w_px = 14,  .glyph_index = 6740},   /*Unicode: U+006d (m)*/
    {.w_px = 8,   .glyph_index = 6880},   /*Unicode: U+006e (n)*/
    {.w_px = 10,  .glyph_index = 6960},   /*Unicode: U+006f (o)*/
    {.w_px = 9,   .glyph_index = 7060},   /*Unicode: U+0070 (p)*/
    {.w_px = 9,   .glyph_index = 7160},   /*Unicode: U+0071 (q)*/
    {.w_px = 6,   .glyph_index = 7260},   /*Unicode: U+0072 (r)*/
    {.w_px = 7,   .glyph_index = 7320},   /*Unicode: U+0073 (s)*/
    {.w_px = 6,   .glyph_index = 7400},   /*Unicode: U+0074 (t)*/
    {.w_px = 8,   .glyph_index = 7460},   /*Unicode: U+0075 (u)*/
    {.w_px = 12,  .glyph_index = 7540},   /*Unicode: U+0076 (v)*/
    {.w_px = 15,  .glyph_index = 7660},   /*Unicode: U+0077 (w)*/
    {.w_px = 10,  .glyph_index = 7820},   /*Unicode: U+0078 (x)*/
    {.w_px = 12,  .glyph_index = 7920},   /*Unicode: U+0079 (y)*/
    {.w_px = 8,   .glyph_index = 8040},   /*Unicode: U+007a (z)*/
    {.w_px = 8,   .glyph_index = 8120},   /*Unicode: U+007b ({)*/
    {.w_px = 2,   .glyph_index = 8200},   /*Unicode: U+007c (|)*/
    {.w_px = 8,   .glyph_index = 8220},   /*Unicode: U+007d (})*/
    {.w_px = 11,  .glyph_index = 8300},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_20 == 8
    {.w_px = 6,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 2,   .glyph_index = 120},    /*Unicode: U+0021 (!)*/
    {.w_px = 6,   .glyph_index = 160},    /*Unicode: U+0022 (")*/
    {.w_px = 12,  .glyph_index = 280},    /*Unicode: U+0023 (#)*/
    {.w_px = 9,   .glyph_index = 520},    /*Unicode: U+0024 ($)*/
    {.w_px = 15,  .glyph_index = 700},    /*Unicode: U+0025 (%)*/
    {.w_px = 12,  .glyph_index = 1000},   /*Unicode: U+0026 (&)*/
    {.w_px = 2,   .glyph_index = 1240},   /*Unicode: U+0027 (')*/
    {.w_px = 4,   .glyph_index = 1280},   /*Unicode: U+0028 (()*/
    {.w_px = 4,   .glyph_index = 1360},   /*Unicode: U+0029 ())*/
    {.w_px = 7,   .glyph_index = 1440},   /*Unicode: U+002a (*)*/
    {.w_px = 12,  .glyph_index = 1580},   /*Unicode: U+002b (+)*/
    {.w_px = 3,   .glyph_index = 1820},   /*Unicode: U+002c (,)*/
    {.w_px = 5,   .glyph_index = 1880},   /*Unicode: U+002d (-)*/
    {.w_px = 2,   .glyph_index = 1980},   /*Unicode: U+002e (.)*/
    {.w_px = 6,   .glyph_index = 2020},   /*Unicode: U+002f (/)*/
    {.w_px = 9,   .glyph_index = 2140},   /*Unicode: U+0030 (0)*/
    {.w_px = 8,   .glyph_index = 2320},   /*Unicode: U+0031 (1)*/
    {.w_px = 9,   .glyph_index = 2480},   /*Unicode: U+0032 (2)*/
    {.w_px = 9,   .glyph_index = 2660},   /*Unicode: U+0033 (3)*/
    {.w_px = 10,  .glyph_index = 2840},   /*Unicode: U+0034 (4)*/
    {.w_px = 8,   .glyph_index = 3040},   /*Unicode: U+0035 (5)*/
    {.w_px = 9,   .glyph_index = 3200},   /*Unicode: U+0036 (6)*/
    {.w_px = 8,   .glyph_index = 3380},   /*Unicode: U+0037 (7)*/
    {.w_px = 9,   .glyph_index = 3540},   /*Unicode: U+0038 (8)*/
    {.w_px = 9,   .glyph_index = 3720},   /*Unicode: U+0039 (9)*/
    {.w_px = 2,   .glyph_index = 3900},   /*Unicode: U+003a (:)*/
    {.w_px = 3,   .glyph_index = 3940},   /*Unicode: U+003b (;)*/
    {.w_px = 11,  .glyph_index = 4000},   /*Unicode: U+003c (<)*/
    {.w_px = 11,  .glyph_index = 4220},   /*Unicode: U+003d (=)*/
    {.w_px = 11,  .glyph_index = 4440},   /*Unicode: U+003e (>)*/
    {.w_px = 7,   .glyph_index = 4660},   /*Unicode: U+003f (?)*/
    {.w_px = 16,  .glyph_index = 4800},   /*Unicode: U+0040 (@)*/
    {.w_px = 12,  .glyph_index = 5120},   /*Unicode: U+0041 (A)*/
    {.w_px = 9,   .glyph_index = 5360},   /*Unicode: U+0042 (B)*/
    {.w_px = 11,  .glyph_index = 5540},   /*Unicode: U+0043 (C)*/
    {.w_px = 11,  .glyph_index = 5760},   /*Unicode: U+0044 (D)*/
    {.w_px = 8,   .glyph_index = 5980},   /*Unicode: U+0045 (E)*/
    {.w_px = 8,   .glyph_index = 6140},   /*Unicode: U+0046 (F)*/
    {.w_px = 11,  .glyph_index = 6300},   /*Unicode: U+0047 (G)*/
    {.w_px = 10,  .glyph_index = 6520},   /*Unicode: U+0048 (H)*/
    {.w_px = 2,   .glyph_index = 6720},   /*Unicode: U+0049 (I)*/
    {.w_px = 4,   .glyph_index = 6760},   /*Unicode: U+004a (J)*/
    {.w_px = 11,  .glyph_index = 6840},   /*Unicode: U+004b (K)*/
    {.w_px = 8,   .glyph_index = 7060},   /*Unicode: U+004c (L)*/
    {.w_px = 12,  .glyph_index = 7220},   /*Unicode: U+004d (M)*/
    {.w_px = 10,  .glyph_index = 7460},   /*Unicode: U+004e (N)*/
    {.w_px = 12,  .glyph_index = 7660},   /*Unicode: U+004f (O)*/
    {.w_px = 8,   .glyph_index = 7900},   /*Unicode: U+0050 (P)*/
    {.w_px = 12,  .glyph_index = 8060},   /*Unicode: U+0051 (Q)*/
    {.w_px = 10,  .glyph_index = 8300},   /*Unicode: U+0052 (R)*/
    {.w_px = 9,   .glyph_index = 8500},   /*Unicode: U+0053 (S)*/
    {.w_px = 12,  .glyph_index = 8680},   /*Unicode: U+0054 (T)*/
    {.w_px = 10,  .glyph_index = 8920},   /*Unicode: U+0055 (U)*/
    {.w_px = 12,  .glyph_index = 9120},   /*Unicode: U+0056 (V)*/
    {.w_px = 17,  .glyph_index = 9360},   /*Unicode: U+0057 (W)*/
    {.w_px = 11,  .glyph_index = 9700},   /*Unicode: U+0058 (X)*/
    {.w_px = 12,  .glyph_index = 9920},   /*Unicode: U+0059 (Y)*/
    {.w_px = 11,  .glyph_index = 10160},  /*Unicode: U+005a (Z)*/
    {.w_px = 4,   .glyph_index = 10380},  /*Unicode: U+005b ([)*/
    {.w_px = 6,   .glyph_index = 10460},  /*Unicode: U+005c (\)*/
    {.w_px = 4,   .glyph_index = 10580},  /*Unicode: U+005d (])*/
    {.w_px = 11,  .glyph_index = 10660},  /*Unicode: U+005e (^)*/
    {.w_px = 9,   .glyph_index = 10880},  /*Unicode: U+005f (_)*/
    {.w_px = 4,   .glyph_index = 11060},  /*Unicode: U+0060 (`)*/
    {.w_px = 8,   .glyph_index = 11140},  /*Unicode: U+0061 (a)*/
    {.w_px = 9,   .glyph_index = 11300},  /*Unicode: U+0062 (b)*/
    {.w_px = 8,   .glyph_index = 11480},  /*Unicode: U+0063 (c)*/
    {.w_px = 9,   .glyph_index = 11640},  /*Unicode: U+0064 (d)*/
    {.w_px = 10,  .glyph_index = 11820},  /*Unicode: U+0065 (e)*/
    {.w_px = 7,   .glyph_index = 12020},  /*Unicode: U+0066 (f)*/
    {.w_px = 9,   .glyph_index = 12160},  /*Unicode: U+0067 (g)*/
    {.w_px = 8,   .glyph_index = 12340},  /*Unicode: U+0068 (h)*/
    {.w_px = 2,   .glyph_index = 12500},  /*Unicode: U+0069 (i)*/
    {.w_px = 4,   .glyph_index = 12540},  /*Unicode: U+006a (j)*/
    {.w_px = 9,   .glyph_index = 12620},  /*Unicode: U+006b (k)*/
    {.w_px = 2,   .glyph_index = 12800},  /*Unicode: U+006c (l)*/
    {.w_px = 14,  .glyph_index = 12840},  /*Unicode: U+006d (m)*/
    {.w_px = 8,   .glyph_index = 13120},  /*Unicode: U+006e (n)*/
    {.w_px = 10,  .glyph_index = 13280},  /*Unicode: U+006f (o)*/
    {.w_px = 9,   .glyph_index = 13480},  /*Unicode: U+0070 (p)*/
    {.w_px = 9,   .glyph_index = 13660},  /*Unicode: U+0071 (q)*/
    {.w_px = 6,   .glyph_index = 13840},  /*Unicode: U+0072 (r)*/
    {.w_px = 7,   .glyph_index = 13960},  /*Unicode: U+0073 (s)*/
    {.w_px = 6,   .glyph_index = 14100},  /*Unicode: U+0074 (t)*/
    {.w_px = 8,   .glyph_index = 14220},  /*Unicode: U+0075 (u)*/
    {.w_px = 12,  .glyph_index = 14380},  /*Unicode: U+0076 (v)*/
    {.w_px = 15,  .glyph_index = 14620},  /*Unicode: U+0077 (w)*/
    {.w_px = 10,  .glyph_index = 14920},  /*Unicode: U+0078 (x)*/
    {.w_px = 12,  .glyph_index = 15120},  /*Unicode: U+0079 (y)*/
    {.w_px = 8,   .glyph_index = 15360},  /*Unicode: U+007a (z)*/
    {.w_px = 8,   .glyph_index = 15520},  /*Unicode: U+007b ({)*/
    {.w_px = 2,   .glyph_index = 15680},  /*Unicode: U+007c (|)*/
    {.w_px = 8,   .glyph_index = 15720},  /*Unicode: U+007d (})*/
    {.w_px = 11,  .glyph_index = 15880},  /*Unicode: U+007e (~)*/

#endif
};

lv_font_t lv_font_dejavu_20 = {
    .unicode_first = 32,    /*First Unicode letter in this font*/
    .unicode_last = 126,    /*Last Unicode letter in this font*/
    .h_px = 20,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_20_glyph_bitmap, /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_20_glyph_dsc,       /*Description of glyphs*/
    .glyph_cnt = 95,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_20 == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20 == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20 == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_20 == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_20*/
