
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_10_LATIN_SUP != 0    /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 10 px Font in U+00a0 ( ) .. U+00ff (ÿ)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_10_latin_sup_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_10_LATIN_SUP == 1
    /*Unicode: U+00a0 ( ) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a1 (¡) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x80,  //@
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x00,  //.


    /*Unicode: U+00a2 (¢) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x40,  //.@.
    0xe0,  //%@@
    0xc0,  //@@.
    0xc0,  //@@.
    0xe0,  //%@@
    0x40,  //.@.
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a3 (£) , Width: 4 */
    0x00,  //....
    0x30,  //.+@@
    0x40,  //.@..
    0x40,  //.@..
    0xf0,  //@@@@
    0x40,  //.@..
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00a4 (¤) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x88,  //%+.+%
    0x70,  //+@@@+
    0x50,  //.@+@.
    0x70,  //+@@@+
    0x88,  //%+.+%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00a5 (¥) , Width: 5 */
    0x00,  //.....
    0x88,  //%+.+%
    0x50,  //.@.@.
    0xf8,  //@@@@@
    0x20,  //..@..
    0xf8,  //@@@@@
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00a6 (¦) , Width: 1 */
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+00a7 (§) , Width: 3 */
    0x00,  //...
    0xe0,  //%@@
    0x80,  //@..
    0xc0,  //%%+
    0xa0,  //@.@
    0x40,  //.%+
    0x20,  //..@
    0xe0,  //@@%
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a8 (¨) , Width: 3 */
    0x00,  //...
    0xa0,  //@.@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a9 (©) , Width: 6 */
    0x00,  //......
    0x78,  //.%@@%.
    0xcc,  //%%..%%
    0xb4,  //@.%@.@
    0xb4,  //@.%@.@
    0xcc,  //%%..%%
    0x78,  //.%@@%.
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00aa (ª) , Width: 4 */
    0x00,  //....
    0x60,  //.@%.
    0xe0,  //%@@.
    0xe0,  //@%@.
    0x00,  //....
    0xe0,  //%@@.
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ab («) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x50,  //.%.%
    0xf0,  //%@%@
    0xf0,  //%@%@
    0x50,  //.%.%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ac (¬) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf8,  //@@@@@
    0x08,  //....@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00ad (­) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ae (®) , Width: 6 */
    0x00,  //......
    0x78,  //.%@@%.
    0xcc,  //%%..%%
    0xb4,  //@.@@.@
    0xb4,  //@.@%.@
    0xcc,  //%%..%%
    0x78,  //.%@@%.
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00af (¯) , Width: 2 */
    0x00,  //..
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b0 (°) , Width: 2 */
    0x00,  //..
    0xc0,  //@%
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b1 (±) , Width: 5 */
    0x00,  //.....
    0x20,  //..@..
    0x20,  //..@..
    0xf8,  //@@@@@
    0x20,  //..@..
    0x20,  //..@..
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00b2 (²) , Width: 3 */
    0x00,  //...
    0xc0,  //@@.
    0x40,  //+@.
    0xc0,  //@@.
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00b3 (³) , Width: 2 */
    0x00,  //..
    0xc0,  //@@
    0x40,  //.%
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b4 (´) , Width: 2 */
    0x00,  //..
    0x00,  //++
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b5 (µ) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x90,  //@..@.
    0x90,  //@..@.
    0x90,  //@..@.
    0xf8,  //@%%%@
    0x80,  //@....
    0x80,  //@....
    0x00,  //.....


    /*Unicode: U+00b6 (¶) , Width: 4 */
    0x00,  //....
    0xf0,  //%@@@
    0xd0,  //@@.@
    0xd0,  //@@.@
    0x50,  //+@.@
    0x50,  //.@.@
    0x50,  //.@.@
    0x50,  //.@.@
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00b7 (·) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+00b8 (¸) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x40,  //.@
    0xc0,  //@@
    0x00,  //..


    /*Unicode: U+00b9 (¹) , Width: 3 */
    0x00,  //...
    0xc0,  //@@.
    0x40,  //.@.
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00ba (º) , Width: 3 */
    0x00,  //...
    0xe0,  //%@%
    0xa0,  //@+@
    0xe0,  //%@%
    0x00,  //...
    0xe0,  //%@%
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00bb (») , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xa0,  //%.%.
    0xf0,  //@%@%
    0xf0,  //@%@%
    0xa0,  //%.%.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00bc (¼) , Width: 8 */
    0x00,  //........
    0xc8,  //@@.+@...
    0x50,  //.@.@+...
    0xf0,  //@@@@....
    0x22,  //..@+..@.
    0x22,  //.+@...@.
    0x47,  //.%+..@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00bd (½) , Width: 8 */
    0x00,  //........
    0xc8,  //@@.+@...
    0x50,  //.@.@+...
    0xf0,  //@@@@....
    0x26,  //..@+.@@.
    0x22,  //.+@..+@.
    0x46,  //.%+..@@.
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00be (¾) , Width: 8 */
    0x00,  //........
    0xc8,  //@@.+@...
    0x50,  //.%.@+...
    0xd0,  //@@+@....
    0x22,  //..@+..@.
    0x22,  //.+@...@.
    0x47,  //.%+..@@@
    0x00,  //........
    0x00,  //........
    0x00,  //........


    /*Unicode: U+00bf (¿) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x40,  //.@.
    0x00,  //...
    0x40,  //.@.
    0x40,  //.+.
    0x80,  //@..
    0xe0,  //%@@
    0x00,  //...


    /*Unicode: U+00c0 (À) , Width: 5 */
    0x30,  //..%@.
    0x20,  //..@..
    0x20,  //.+@+.
    0x70,  //.@%@.
    0x50,  //.@.@.
    0x70,  //+@@@+
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00c1 (Á) , Width: 5 */
    0x30,  //..%%.
    0x20,  //..@..
    0x20,  //.+@+.
    0x70,  //.@%@.
    0x50,  //.@.@.
    0x70,  //+@@@+
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00c2 (Â) , Width: 5 */
    0x00,  //..+..
    0x20,  //..@..
    0x20,  //.+@+.
    0x70,  //.@%@.
    0x50,  //.@.@.
    0x70,  //+@@@+
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00c3 (Ã) , Width: 5 */
    0x70,  //.@@@.
    0x20,  //..@..
    0x20,  //.+@+.
    0x70,  //.@%@.
    0x50,  //.@.@.
    0x70,  //+@@@+
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00c4 (Ä) , Width: 5 */
    0x50,  //.@.@.
    0x20,  //..@..
    0x20,  //.+@+.
    0x70,  //.@%@.
    0x50,  //.@.@.
    0x70,  //+@@@+
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00c5 (Å) , Width: 5 */
    0x20,  //..@..
    0x20,  //..%..
    0x00,  //.....
    0x20,  //..@..
    0x70,  //.%@%.
    0x70,  //.@@@.
    0x88,  //%+.+%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00c6 (Æ) , Width: 7 */
    0x00,  //.......
    0x3e,  //..@@@@@
    0x30,  //.+%@...
    0x50,  //.@+@...
    0x5e,  //.@.@@@@
    0x70,  //+@@@...
    0x9e,  //@..@@@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00c7 (Ç) , Width: 5 */
    0x00,  //.....
    0x70,  //.%@@+
    0xc8,  //%%..%
    0x80,  //@....
    0x80,  //@....
    0xc8,  //%%..%
    0x70,  //.%@@+
    0x20,  //..@..
    0x60,  //.@@..
    0x00,  //.....


    /*Unicode: U+00c8 (È) , Width: 4 */
    0x60,  //.%@.
    0xf0,  //@@@@
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@@
    0x80,  //@...
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00c9 (É) , Width: 4 */
    0x60,  //.%%.
    0xf0,  //@@@@
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@@
    0x80,  //@...
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ca (Ê) , Width: 4 */
    0x00,  //.++.
    0xf0,  //@@@@
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@@
    0x80,  //@...
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00cb (Ë) , Width: 4 */
    0x50,  //.@.@
    0xf0,  //@@@@
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@@
    0x80,  //@...
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00cc (Ì) , Width: 3 */
    0xc0,  //%@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00cd (Í) , Width: 2 */
    0xc0,  //%%
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ce (Î) , Width: 3 */
    0x40,  //+%+
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00cf (Ï) , Width: 3 */
    0xa0,  //@.@
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00d0 (Ð) , Width: 6 */
    0x00,  //......
    0x78,  //.@@@%.
    0x4c,  //.@..%%
    0x44,  //.@...@
    0xe4,  //@@@..@
    0x4c,  //.@..%%
    0x78,  //.@@@%.
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00d1 (Ñ) , Width: 4 */
    0x60,  //.@@.
    0x90,  //@+.@
    0xd0,  //@@.@
    0xd0,  //@%+@
    0xb0,  //@+@@
    0xb0,  //@.@@
    0x90,  //@.+@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00d2 (Ò) , Width: 5 */
    0x60,  //.%@..
    0x70,  //.%@%.
    0xd8,  //%%.%%
    0x88,  //@...@
    0x88,  //@...@
    0xd8,  //%%.%%
    0x70,  //.%@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00d3 (Ó) , Width: 5 */
    0x60,  //.%%..
    0x70,  //.%@%.
    0xd8,  //%%.%%
    0x88,  //@...@
    0x88,  //@...@
    0xd8,  //%%.%%
    0x70,  //.%@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00d4 (Ô) , Width: 5 */
    0x00,  //..+..
    0x70,  //.%@%.
    0xd8,  //%%.%%
    0x88,  //@...@
    0x88,  //@...@
    0xd8,  //%%.%%
    0x70,  //.%@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00d5 (Õ) , Width: 5 */
    0x70,  //.@@@.
    0x70,  //.%@%.
    0xd8,  //%%.%%
    0x88,  //@...@
    0x88,  //@...@
    0xd8,  //%%.%%
    0x70,  //.%@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00d6 (Ö) , Width: 5 */
    0x50,  //.@.@.
    0x70,  //.%@%.
    0xd8,  //%%.%%
    0x88,  //@...@
    0x88,  //@...@
    0xd8,  //%%.%%
    0x70,  //.%@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00d7 (×) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x88,  //%+.+%
    0x70,  //.@%@.
    0x20,  //.+@+.
    0x70,  //.@%@.
    0x88,  //%+.+%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00d8 (Ø) , Width: 5 */
    0x00,  //.....
    0x68,  //.@@+%
    0xd0,  //%%.%+
    0x88,  //@.++@
    0x88,  //@++.@
    0x58,  //+%.%%
    0xb0,  //%+@@.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00d9 (Ù) , Width: 4 */
    0x60,  //.%@.
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@++@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00da (Ú) , Width: 4 */
    0x60,  //.%%.
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@++@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00db (Û) , Width: 4 */
    0x00,  //.++.
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@++@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00dc (Ü) , Width: 4 */
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@++@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00dd (Ý) , Width: 5 */
    0x60,  //.%%..
    0xd8,  //%+.+%
    0x50,  //.@+@.
    0x20,  //.+@+.
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00de (Þ) , Width: 4 */
    0x00,  //....
    0x80,  //@...
    0xe0,  //@@@+
    0x90,  //@..@
    0xe0,  //@@@+
    0x80,  //@...
    0x80,  //@...
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00df (ß) , Width: 4 */
    0x60,  //+@@+
    0x90,  //@..@
    0xa0,  //@.%+
    0xa0,  //@.@.
    0x90,  //@..%
    0x90,  //@..@
    0xb0,  //@.@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e0 (à) , Width: 4 */
    0x00,  //....
    0x00,  //++..
    0x00,  //....
    0x70,  //.@@%
    0x70,  //+@@@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e1 (á) , Width: 4 */
    0x00,  //....
    0x00,  //++..
    0x00,  //....
    0x70,  //.@@%
    0x70,  //+@@@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e2 (â) , Width: 4 */
    0x00,  //....
    0x00,  //.++.
    0x00,  //....
    0x70,  //.@@%
    0x70,  //+@@@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e3 (ã) , Width: 4 */
    0x00,  //....
    0x60,  //.%%.
    0x60,  //.%%.
    0x70,  //.@@%
    0x70,  //+@@@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e4 (ä) , Width: 4 */
    0x00,  //....
    0x60,  //.@@.
    0x00,  //....
    0x70,  //.@@%
    0x70,  //+@@@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e5 (å) , Width: 4 */
    0x60,  //.@@.
    0x60,  //.@@.
    0x00,  //....
    0x70,  //.@@%
    0x70,  //+@@@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e6 (æ) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x6c,  //.@@+@@+
    0x7e,  //+@@@@@@
    0x90,  //@..@+..
    0xee,  //%@@+@@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+00e7 (ç) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x60,  //+@@
    0x80,  //@..
    0x80,  //@..
    0x60,  //+@@
    0x20,  //..@
    0x60,  //.@@
    0x00,  //...


    /*Unicode: U+00e8 (è) , Width: 4 */
    0x00,  //....
    0x00,  //.++.
    0x00,  //....
    0x70,  //+@@%
    0xf0,  //@@@@
    0x80,  //@+..
    0x70,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e9 (é) , Width: 4 */
    0x00,  //....
    0x00,  //.++.
    0x00,  //....
    0x70,  //+@@%
    0xf0,  //@@@@
    0x80,  //@+..
    0x70,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ea (ê) , Width: 4 */
    0x00,  //....
    0x60,  //+%%+
    0x00,  //....
    0x70,  //+@@%
    0xf0,  //@@@@
    0x80,  //@+..
    0x70,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00eb (ë) , Width: 4 */
    0x00,  //....
    0x50,  //.@.@
    0x00,  //....
    0x70,  //+@@%
    0xf0,  //@@@@
    0x80,  //@+..
    0x70,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ec (ì) , Width: 2 */
    0x00,  //..
    0x00,  //++
    0x00,  //..
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ed (í) , Width: 2 */
    0x00,  //..
    0x00,  //++
    0x00,  //..
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ee (î) , Width: 3 */
    0x00,  //...
    0x40,  //+%+
    0x00,  //...
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00ef (ï) , Width: 3 */
    0x00,  //...
    0xa0,  //@.@
    0x00,  //...
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00f0 (ð) , Width: 4 */
    0x00,  //....
    0x60,  //.@@.
    0x20,  //++@.
    0x70,  //+@@%
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f1 (ñ) , Width: 4 */
    0x00,  //....
    0xa0,  //%+@.
    0xa0,  //@+%.
    0xf0,  //@%@%
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f2 (ò) , Width: 4 */
    0x00,  //....
    0x00,  //++..
    0x00,  //....
    0x60,  //+@@+
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f3 (ó) , Width: 4 */
    0x00,  //....
    0x00,  //++..
    0x00,  //....
    0x60,  //+@@+
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f4 (ô) , Width: 4 */
    0x00,  //....
    0x00,  //.++.
    0x00,  //....
    0x60,  //+@@+
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f5 (õ) , Width: 4 */
    0x00,  //....
    0x60,  //.%%.
    0x60,  //.%%.
    0x60,  //+@@+
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f6 (ö) , Width: 4 */
    0x00,  //....
    0x90,  //@..@
    0x00,  //....
    0x60,  //+@@+
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f7 (÷) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x20,  //..@..
    0x00,  //.....
    0xf8,  //@@@@@
    0x00,  //.....
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+00f8 (ø) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0x38,  //.+@%%.
    0x48,  //.@.+%.
    0x48,  //.%+.@.
    0x70,  //.%%@+.
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+00f9 (ù) , Width: 4 */
    0x00,  //....
    0x00,  //++..
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00fa (ú) , Width: 4 */
    0x00,  //....
    0x00,  //++..
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00fb (û) , Width: 4 */
    0x00,  //....
    0x00,  //.++.
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00fc (ü) , Width: 4 */
    0x00,  //....
    0x60,  //.@@.
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00fd (ý) , Width: 4 */
    0x00,  //....
    0x00,  //++..
    0x00,  //....
    0x90,  //@.+@
    0x60,  //+%@+
    0x60,  //.@@.
    0x40,  //.@+.
    0x40,  //.@..
    0x80,  //@+..
    0x00,  //....


    /*Unicode: U+00fe (þ) , Width: 4 */
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0xe0,  //@%@+
    0x90,  //@..@
    0x90,  //@..@
    0xe0,  //@%@+
    0x80,  //@...
    0x80,  //@...
    0x00,  //....


    /*Unicode: U+00ff (ÿ) , Width: 4 */
    0x00,  //....
    0xa0,  //@.@.
    0x00,  //....
    0x90,  //@.+@
    0x60,  //+%@+
    0x60,  //.@@.
    0x40,  //.@+.
    0x40,  //.@..
    0x80,  //@+..
    0x00,  //....



#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 2
    /*Unicode: U+00a0 ( ) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a1 (¡) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.


    /*Unicode: U+00a2 (¢) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x30,  //.@.
    0xbc,  //%@@
    0xf0,  //@@.
    0xf0,  //@@.
    0xbc,  //%@@
    0x30,  //.@.
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a3 (£) , Width: 4 */
    0x00,  //....
    0x1f,  //.+@@
    0x30,  //.@..
    0x30,  //.@..
    0xff,  //@@@@
    0x30,  //.@..
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00a4 (¤) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x91, 0x80,  //%+.+%
    0x7f, 0x40,  //+@@@+
    0x37, 0x00,  //.@+@.
    0x7f, 0x40,  //+@@@+
    0x91, 0x80,  //%+.+%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00a5 (¥) , Width: 5 */
    0x00, 0x00,  //.....
    0x91, 0x80,  //%+.+%
    0x33, 0x00,  //.@.@.
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00a6 (¦) , Width: 1 */
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+00a7 (§) , Width: 3 */
    0x00,  //...
    0xbc,  //%@@
    0xc0,  //@..
    0xa4,  //%%+
    0xcc,  //@.@
    0x24,  //.%+
    0x0c,  //..@
    0xf8,  //@@%
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a8 (¨) , Width: 3 */
    0x00,  //...
    0xcc,  //@.@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00a9 (©) , Width: 6 */
    0x00, 0x00,  //......
    0x2f, 0x80,  //.%@@%.
    0xa0, 0xa0,  //%%..%%
    0xcb, 0x30,  //@.%@.@
    0xcb, 0x30,  //@.%@.@
    0xa0, 0xa0,  //%%..%%
    0x2f, 0x80,  //.%@@%.
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00aa (ª) , Width: 4 */
    0x00,  //....
    0x38,  //.@%.
    0xbc,  //%@@.
    0xec,  //@%@.
    0x00,  //....
    0xbc,  //%@@.
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ab («) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x22,  //.%.%
    0xbb,  //%@%@
    0xbb,  //%@%@
    0x22,  //.%.%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ac (¬) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x00, 0xc0,  //....@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00ad (­) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ae (®) , Width: 6 */
    0x00, 0x00,  //......
    0x2f, 0x80,  //.%@@%.
    0xa0, 0xa0,  //%%..%%
    0xcf, 0x30,  //@.@@.@
    0xce, 0x30,  //@.@%.@
    0xa0, 0xa0,  //%%..%%
    0x2f, 0x80,  //.%@@%.
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00af (¯) , Width: 2 */
    0x00,  //..
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b0 (°) , Width: 2 */
    0x00,  //..
    0xf0,  //@%
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b1 (±) , Width: 5 */
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00b2 (²) , Width: 3 */
    0x00,  //...
    0xf0,  //@@.
    0x70,  //+@.
    0xf0,  //@@.
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00b3 (³) , Width: 2 */
    0x00,  //..
    0xf0,  //@@
    0x20,  //.%
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b4 (´) , Width: 2 */
    0x00,  //..
    0x50,  //++
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b5 (µ) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xc3, 0x00,  //@..@.
    0xc3, 0x00,  //@..@.
    0xc3, 0x00,  //@..@.
    0xea, 0xc0,  //@%%%@
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0x00, 0x00,  //.....


    /*Unicode: U+00b6 (¶) , Width: 4 */
    0x00,  //....
    0xbf,  //%@@@
    0xf3,  //@@.@
    0xf3,  //@@.@
    0x73,  //+@.@
    0x33,  //.@.@
    0x33,  //.@.@
    0x33,  //.@.@
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00b7 (·) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+00b8 (¸) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x30,  //.@
    0xf0,  //@@
    0x00,  //..


    /*Unicode: U+00b9 (¹) , Width: 3 */
    0x00,  //...
    0xf0,  //@@.
    0x30,  //.@.
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00ba (º) , Width: 3 */
    0x00,  //...
    0xb8,  //%@%
    0xdc,  //@+@
    0xb8,  //%@%
    0x00,  //...
    0xb8,  //%@%
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00bb (») , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x88,  //%.%.
    0xee,  //@%@%
    0xee,  //@%@%
    0x88,  //%.%.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00bc (¼) , Width: 8 */
    0x00, 0x00,  //........
    0xf1, 0xc0,  //@@.+@...
    0x33, 0x40,  //.@.@+...
    0xff, 0x00,  //@@@@....
    0x0d, 0x0c,  //..@+..@.
    0x1c, 0x0c,  //.+@...@.
    0x34, 0x3f,  //.%+..@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00bd (½) , Width: 8 */
    0x00, 0x00,  //........
    0xf1, 0xc0,  //@@.+@...
    0x33, 0x40,  //.@.@+...
    0xff, 0x00,  //@@@@....
    0x0d, 0x3c,  //..@+.@@.
    0x1c, 0x1c,  //.+@..+@.
    0x34, 0x3c,  //.%+..@@.
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00be (¾) , Width: 8 */
    0x00, 0x00,  //........
    0xf1, 0xc0,  //@@.+@...
    0x23, 0x40,  //.%.@+...
    0xf7, 0x00,  //@@+@....
    0x0d, 0x0c,  //..@+..@.
    0x1c, 0x0c,  //.+@...@.
    0x34, 0x3f,  //.%+..@@@
    0x00, 0x00,  //........
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+00bf (¿) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x30,  //.@.
    0x00,  //...
    0x30,  //.@.
    0x20,  //.+.
    0xc0,  //@..
    0xbc,  //%@@
    0x00,  //...


    /*Unicode: U+00c0 (À) , Width: 5 */
    0x0b, 0x00,  //..%@.
    0x0c, 0x00,  //..@..
    0x1d, 0x00,  //.+@+.
    0x3b, 0x00,  //.@%@.
    0x33, 0x00,  //.@.@.
    0x7f, 0x40,  //+@@@+
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00c1 (Á) , Width: 5 */
    0x0a, 0x00,  //..%%.
    0x0c, 0x00,  //..@..
    0x1d, 0x00,  //.+@+.
    0x3b, 0x00,  //.@%@.
    0x33, 0x00,  //.@.@.
    0x7f, 0x40,  //+@@@+
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00c2 (Â) , Width: 5 */
    0x04, 0x00,  //..+..
    0x0c, 0x00,  //..@..
    0x1d, 0x00,  //.+@+.
    0x3b, 0x00,  //.@%@.
    0x33, 0x00,  //.@.@.
    0x7f, 0x40,  //+@@@+
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00c3 (Ã) , Width: 5 */
    0x3f, 0x00,  //.@@@.
    0x0c, 0x00,  //..@..
    0x1d, 0x00,  //.+@+.
    0x3b, 0x00,  //.@%@.
    0x33, 0x00,  //.@.@.
    0x7f, 0x40,  //+@@@+
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00c4 (Ä) , Width: 5 */
    0x33, 0x00,  //.@.@.
    0x0c, 0x00,  //..@..
    0x1d, 0x00,  //.+@+.
    0x3b, 0x00,  //.@%@.
    0x33, 0x00,  //.@.@.
    0x7f, 0x40,  //+@@@+
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00c5 (Å) , Width: 5 */
    0x0c, 0x00,  //..@..
    0x08, 0x00,  //..%..
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x2e, 0x00,  //.%@%.
    0x3f, 0x00,  //.@@@.
    0x91, 0x80,  //%+.+%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00c6 (Æ) , Width: 7 */
    0x00, 0x00,  //.......
    0x0f, 0xfc,  //..@@@@@
    0x1b, 0x00,  //.+%@...
    0x37, 0x00,  //.@+@...
    0x33, 0xfc,  //.@.@@@@
    0x7f, 0x00,  //+@@@...
    0xc3, 0xfc,  //@..@@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00c7 (Ç) , Width: 5 */
    0x00, 0x00,  //.....
    0x2f, 0x40,  //.%@@+
    0xa0, 0x80,  //%%..%
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0xa0, 0x80,  //%%..%
    0x2f, 0x40,  //.%@@+
    0x0c, 0x00,  //..@..
    0x3c, 0x00,  //.@@..
    0x00, 0x00,  //.....


    /*Unicode: U+00c8 (È) , Width: 4 */
    0x2c,  //.%@.
    0xff,  //@@@@
    0xc0,  //@...
    0xc0,  //@...
    0xff,  //@@@@
    0xc0,  //@...
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00c9 (É) , Width: 4 */
    0x28,  //.%%.
    0xff,  //@@@@
    0xc0,  //@...
    0xc0,  //@...
    0xff,  //@@@@
    0xc0,  //@...
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ca (Ê) , Width: 4 */
    0x14,  //.++.
    0xff,  //@@@@
    0xc0,  //@...
    0xc0,  //@...
    0xff,  //@@@@
    0xc0,  //@...
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00cb (Ë) , Width: 4 */
    0x33,  //.@.@
    0xff,  //@@@@
    0xc0,  //@...
    0xc0,  //@...
    0xff,  //@@@@
    0xc0,  //@...
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00cc (Ì) , Width: 3 */
    0xb0,  //%@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00cd (Í) , Width: 2 */
    0xa0,  //%%
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ce (Î) , Width: 3 */
    0x64,  //+%+
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00cf (Ï) , Width: 3 */
    0xcc,  //@.@
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00d0 (Ð) , Width: 6 */
    0x00, 0x00,  //......
    0x3f, 0x80,  //.@@@%.
    0x30, 0xa0,  //.@..%%
    0x30, 0x30,  //.@...@
    0xfc, 0x30,  //@@@..@
    0x30, 0xa0,  //.@..%%
    0x3f, 0x80,  //.@@@%.
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00d1 (Ñ) , Width: 4 */
    0x3c,  //.@@.
    0xd3,  //@+.@
    0xf3,  //@@.@
    0xe7,  //@%+@
    0xdf,  //@+@@
    0xcf,  //@.@@
    0xc7,  //@.+@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00d2 (Ò) , Width: 5 */
    0x2c, 0x00,  //.%@..
    0x2e, 0x00,  //.%@%.
    0xa2, 0x80,  //%%.%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xa2, 0x80,  //%%.%%
    0x2e, 0x00,  //.%@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00d3 (Ó) , Width: 5 */
    0x28, 0x00,  //.%%..
    0x2e, 0x00,  //.%@%.
    0xa2, 0x80,  //%%.%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xa2, 0x80,  //%%.%%
    0x2e, 0x00,  //.%@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00d4 (Ô) , Width: 5 */
    0x04, 0x00,  //..+..
    0x2e, 0x00,  //.%@%.
    0xa2, 0x80,  //%%.%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xa2, 0x80,  //%%.%%
    0x2e, 0x00,  //.%@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00d5 (Õ) , Width: 5 */
    0x3f, 0x00,  //.@@@.
    0x2e, 0x00,  //.%@%.
    0xa2, 0x80,  //%%.%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xa2, 0x80,  //%%.%%
    0x2e, 0x00,  //.%@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00d6 (Ö) , Width: 5 */
    0x33, 0x00,  //.@.@.
    0x2e, 0x00,  //.%@%.
    0xa2, 0x80,  //%%.%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xa2, 0x80,  //%%.%%
    0x2e, 0x00,  //.%@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00d7 (×) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x91, 0x80,  //%+.+%
    0x3b, 0x00,  //.@%@.
    0x1d, 0x00,  //.+@+.
    0x3b, 0x00,  //.@%@.
    0x91, 0x80,  //%+.+%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00d8 (Ø) , Width: 5 */
    0x00, 0x00,  //.....
    0x3d, 0x80,  //.@@+%
    0xa2, 0x40,  //%%.%+
    0xc5, 0xc0,  //@.++@
    0xd4, 0xc0,  //@++.@
    0x62, 0x80,  //+%.%%
    0x9f, 0x00,  //%+@@.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00d9 (Ù) , Width: 4 */
    0x2c,  //.%@.
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xd7,  //@++@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00da (Ú) , Width: 4 */
    0x28,  //.%%.
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xd7,  //@++@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00db (Û) , Width: 4 */
    0x14,  //.++.
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xd7,  //@++@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00dc (Ü) , Width: 4 */
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xd7,  //@++@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00dd (Ý) , Width: 5 */
    0x28, 0x00,  //.%%..
    0xa2, 0x80,  //%+.+%
    0x37, 0x00,  //.@+@.
    0x1d, 0x00,  //.+@+.
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00de (Þ) , Width: 4 */
    0x00,  //....
    0xc0,  //@...
    0xfd,  //@@@+
    0xc3,  //@..@
    0xfd,  //@@@+
    0xc0,  //@...
    0xc0,  //@...
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00df (ß) , Width: 4 */
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc9,  //@.%+
    0xcc,  //@.@.
    0xc2,  //@..%
    0xc3,  //@..@
    0xce,  //@.@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e0 (à) , Width: 4 */
    0x00,  //....
    0x50,  //++..
    0x00,  //....
    0x3e,  //.@@%
    0x7f,  //+@@@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e1 (á) , Width: 4 */
    0x00,  //....
    0x50,  //++..
    0x00,  //....
    0x3e,  //.@@%
    0x7f,  //+@@@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e2 (â) , Width: 4 */
    0x00,  //....
    0x14,  //.++.
    0x00,  //....
    0x3e,  //.@@%
    0x7f,  //+@@@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e3 (ã) , Width: 4 */
    0x00,  //....
    0x28,  //.%%.
    0x28,  //.%%.
    0x3e,  //.@@%
    0x7f,  //+@@@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e4 (ä) , Width: 4 */
    0x00,  //....
    0x3c,  //.@@.
    0x00,  //....
    0x3e,  //.@@%
    0x7f,  //+@@@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e5 (å) , Width: 4 */
    0x3c,  //.@@.
    0x3c,  //.@@.
    0x00,  //....
    0x3e,  //.@@%
    0x7f,  //+@@@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e6 (æ) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x3d, 0xf4,  //.@@+@@+
    0x7f, 0xfc,  //+@@@@@@
    0xc3, 0x40,  //@..@+..
    0xbd, 0xfc,  //%@@+@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+00e7 (ç) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x7c,  //+@@
    0xc0,  //@..
    0xc0,  //@..
    0x7c,  //+@@
    0x0c,  //..@
    0x3c,  //.@@
    0x00,  //...


    /*Unicode: U+00e8 (è) , Width: 4 */
    0x00,  //....
    0x14,  //.++.
    0x00,  //....
    0x7e,  //+@@%
    0xff,  //@@@@
    0xd0,  //@+..
    0x7f,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00e9 (é) , Width: 4 */
    0x00,  //....
    0x14,  //.++.
    0x00,  //....
    0x7e,  //+@@%
    0xff,  //@@@@
    0xd0,  //@+..
    0x7f,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ea (ê) , Width: 4 */
    0x00,  //....
    0x69,  //+%%+
    0x00,  //....
    0x7e,  //+@@%
    0xff,  //@@@@
    0xd0,  //@+..
    0x7f,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00eb (ë) , Width: 4 */
    0x00,  //....
    0x33,  //.@.@
    0x00,  //....
    0x7e,  //+@@%
    0xff,  //@@@@
    0xd0,  //@+..
    0x7f,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00ec (ì) , Width: 2 */
    0x00,  //..
    0x50,  //++
    0x00,  //..
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ed (í) , Width: 2 */
    0x00,  //..
    0x50,  //++
    0x00,  //..
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ee (î) , Width: 3 */
    0x00,  //...
    0x64,  //+%+
    0x00,  //...
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00ef (ï) , Width: 3 */
    0x00,  //...
    0xcc,  //@.@
    0x00,  //...
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+00f0 (ð) , Width: 4 */
    0x00,  //....
    0x3c,  //.@@.
    0x5c,  //++@.
    0x7e,  //+@@%
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f1 (ñ) , Width: 4 */
    0x00,  //....
    0x9c,  //%+@.
    0xd8,  //@+%.
    0xee,  //@%@%
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f2 (ò) , Width: 4 */
    0x00,  //....
    0x50,  //++..
    0x00,  //....
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f3 (ó) , Width: 4 */
    0x00,  //....
    0x50,  //++..
    0x00,  //....
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f4 (ô) , Width: 4 */
    0x00,  //....
    0x14,  //.++.
    0x00,  //....
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f5 (õ) , Width: 4 */
    0x00,  //....
    0x28,  //.%%.
    0x28,  //.%%.
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f6 (ö) , Width: 4 */
    0x00,  //....
    0xc3,  //@..@
    0x00,  //....
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00f7 (÷) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+00f8 (ø) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x1e, 0x80,  //.+@%%.
    0x31, 0x80,  //.@.+%.
    0x24, 0xc0,  //.%+.@.
    0x2b, 0x40,  //.%%@+.
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+00f9 (ù) , Width: 4 */
    0x00,  //....
    0x50,  //++..
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00fa (ú) , Width: 4 */
    0x00,  //....
    0x50,  //++..
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00fb (û) , Width: 4 */
    0x00,  //....
    0x14,  //.++.
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00fc (ü) , Width: 4 */
    0x00,  //....
    0x3c,  //.@@.
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+00fd (ý) , Width: 4 */
    0x00,  //....
    0x50,  //++..
    0x00,  //....
    0xc7,  //@.+@
    0x6d,  //+%@+
    0x3c,  //.@@.
    0x34,  //.@+.
    0x30,  //.@..
    0xd0,  //@+..
    0x00,  //....


    /*Unicode: U+00fe (þ) , Width: 4 */
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xed,  //@%@+
    0xc3,  //@..@
    0xc3,  //@..@
    0xed,  //@%@+
    0xc0,  //@...
    0xc0,  //@...
    0x00,  //....


    /*Unicode: U+00ff (ÿ) , Width: 4 */
    0x00,  //....
    0xcc,  //@.@.
    0x00,  //....
    0xc7,  //@.+@
    0x6d,  //+%@+
    0x3c,  //.@@.
    0x34,  //.@+.
    0x30,  //.@..
    0xd0,  //@+..
    0x00,  //....



#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 4
    /*Unicode: U+00a0 ( ) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00a1 (¡) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0xd0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0x00,  //.


    /*Unicode: U+00a2 (¢) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x0f, 0x00,  //.@.
    0x9f, 0xf0,  //%@@
    0xff, 0x00,  //@@.
    0xff, 0x00,  //@@.
    0x9f, 0xf0,  //%@@
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00a3 (£) , Width: 4 */
    0x00, 0x00,  //....
    0x07, 0xff,  //.+@@
    0x0e, 0x20,  //.@..
    0x0f, 0x00,  //.@..
    0xff, 0xff,  //@@@@
    0x0f, 0x00,  //.@..
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00a4 (¤) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x94, 0x04, 0x90,  //%+.+%
    0x4d, 0xcd, 0x40,  //+@@@+
    0x0c, 0x4c, 0x00,  //.@+@.
    0x4d, 0xcd, 0x40,  //+@@@+
    0x94, 0x04, 0x90,  //%+.+%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00a5 (¥) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xa6, 0x06, 0xa0,  //%+.+%
    0x1d, 0x1d, 0x10,  //.@.@.
    0xff, 0xdf, 0xf0,  //@@@@@
    0x02, 0xf2, 0x00,  //..@..
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00a6 (¦) , Width: 1 */
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+00a7 (§) , Width: 3 */
    0x00, 0x00,  //...
    0x9f, 0xf0,  //%@@
    0xd3, 0x00,  //@..
    0x8b, 0x40,  //%%+
    0xe3, 0xe0,  //@.@
    0x3b, 0x70,  //.%+
    0x02, 0xd0,  //..@
    0xff, 0x90,  //@@%
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00a8 (¨) , Width: 3 */
    0x00, 0x00,  //...
    0xf0, 0xf0,  //@.@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00a9 (©) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x08, 0xee, 0x80,  //.%@@%.
    0x8b, 0x11, 0xb8,  //%%..%%
    0xe1, 0xbf, 0x1e,  //@.%@.@
    0xe1, 0xbf, 0x1e,  //@.%@.@
    0x8b, 0x11, 0xb8,  //%%..%%
    0x08, 0xee, 0x80,  //.%@@%.
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00aa (ª) , Width: 4 */
    0x00, 0x00,  //....
    0x0f, 0xb0,  //.@%.
    0xbf, 0xf0,  //%@@.
    0xca, 0xf0,  //@%@.
    0x00, 0x00,  //....
    0x9f, 0xf0,  //%@@.
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00ab («) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x08, 0x08,  //.%.%
    0x9c, 0x9c,  //%@%@
    0x9c, 0x9c,  //%@%@
    0x08, 0x08,  //.%.%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00ac (¬) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ad (­) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ae (®) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x08, 0xee, 0x80,  //.%@@%.
    0x8b, 0x11, 0xb8,  //%%..%%
    0xe1, 0xfd, 0x1e,  //@.@@.@
    0xe1, 0xf9, 0x1e,  //@.@%.@
    0x8b, 0x11, 0xb8,  //%%..%%
    0x08, 0xee, 0x80,  //.%@@%.
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00af (¯) , Width: 2 */
    0x00,  //..
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b0 (°) , Width: 2 */
    0x00,  //..
    0xcc,  //@%
    0xcc,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b1 (±) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b2 (²) , Width: 3 */
    0x00, 0x00,  //...
    0xfd, 0x00,  //@@.
    0x5e, 0x10,  //+@.
    0xff, 0x00,  //@@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00b3 (³) , Width: 2 */
    0x00,  //..
    0xfc,  //@@
    0x09,  //.%
    0xfc,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b4 (´) , Width: 2 */
    0x00,  //..
    0x55,  //++
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00b5 (µ) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x0f, 0x00,  //@..@.
    0xf0, 0x0f, 0x00,  //@..@.
    0xf3, 0x2f, 0x00,  //@..@.
    0xfb, 0xbb, 0xe0,  //@%%%@
    0xf0, 0x00, 0x00,  //@....
    0xf0, 0x00, 0x00,  //@....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b6 (¶) , Width: 4 */
    0x00, 0x00,  //....
    0x9f, 0xff,  //%@@@
    0xff, 0x0f,  //@@.@
    0xef, 0x0f,  //@@.@
    0x6f, 0x0f,  //+@.@
    0x0f, 0x0f,  //.@.@
    0x0f, 0x0f,  //.@.@
    0x0f, 0x0f,  //.@.@
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00b7 (·) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+00b8 (¸) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x0f,  //.@
    0xec,  //@@
    0x00,  //..


    /*Unicode: U+00b9 (¹) , Width: 3 */
    0x00, 0x00,  //...
    0xff, 0x00,  //@@.
    0x0f, 0x00,  //.@.
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00ba (º) , Width: 3 */
    0x00, 0x00,  //...
    0x9f, 0x90,  //%@%
    0xf4, 0xf0,  //@+@
    0x9f, 0x90,  //%@%
    0x00, 0x00,  //...
    0xbf, 0xb0,  //%@%
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00bb (») , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x80, 0x80,  //%.%.
    0xc9, 0xc9,  //@%@%
    0xc9, 0xc9,  //@%@%
    0x80, 0x80,  //%.%.
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00bc (¼) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x05, 0xc0, 0x00,  //@@.+@...
    0x0f, 0x0d, 0x40, 0x00,  //.@.@+...
    0xff, 0xfc, 0x00, 0x00,  //@@@@....
    0x00, 0xc5, 0x00, 0xd0,  //..@+..@.
    0x04, 0xd0, 0x00, 0xf0,  //.+@...@.
    0x0c, 0x60, 0x0f, 0xff,  //.%+..@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00bd (½) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x05, 0xc0, 0x00,  //@@.+@...
    0x0f, 0x0d, 0x40, 0x00,  //.@.@+...
    0xff, 0xfc, 0x00, 0x00,  //@@@@....
    0x00, 0xc5, 0x0f, 0xd0,  //..@+.@@.
    0x04, 0xd0, 0x05, 0xe1,  //.+@..+@.
    0x0c, 0x60, 0x0f, 0xf0,  //.%+..@@.
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00be (¾) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0xfc, 0x05, 0xc0, 0x00,  //@@.+@...
    0x09, 0x0d, 0x40, 0x00,  //.%.@+...
    0xfc, 0x4c, 0x00, 0x00,  //@@+@....
    0x00, 0xc5, 0x00, 0xd0,  //..@+..@.
    0x04, 0xd0, 0x00, 0xf0,  //.+@...@.
    0x0c, 0x60, 0x0f, 0xff,  //.%+..@@@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00bf (¿) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x0f, 0x00,  //.@.
    0x28, 0x00,  //.+.
    0xd1, 0x00,  //@..
    0x9f, 0xf0,  //%@@
    0x00, 0x00,  //...


    /*Unicode: U+00c0 (À) , Width: 5 */
    0x00, 0x8c, 0x00,  //..%@.
    0x01, 0xf1, 0x00,  //..@..
    0x07, 0xf6, 0x00,  //.+@+.
    0x0c, 0x8c, 0x00,  //.@%@.
    0x2e, 0x0e, 0x20,  //.@.@.
    0x7f, 0xff, 0x70,  //+@@@+
    0xd3, 0x03, 0xd0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c1 (Á) , Width: 5 */
    0x00, 0x9a, 0x00,  //..%%.
    0x01, 0xf1, 0x00,  //..@..
    0x07, 0xf6, 0x00,  //.+@+.
    0x0c, 0x8c, 0x00,  //.@%@.
    0x2e, 0x0e, 0x20,  //.@.@.
    0x7f, 0xff, 0x70,  //+@@@+
    0xd3, 0x03, 0xd0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c2 (Â) , Width: 5 */
    0x00, 0x70, 0x00,  //..+..
    0x01, 0xf1, 0x00,  //..@..
    0x07, 0xf6, 0x00,  //.+@+.
    0x0c, 0x8c, 0x00,  //.@%@.
    0x2e, 0x0e, 0x20,  //.@.@.
    0x7f, 0xff, 0x70,  //+@@@+
    0xd3, 0x03, 0xd0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c3 (Ã) , Width: 5 */
    0x0c, 0xfc, 0x00,  //.@@@.
    0x01, 0xf1, 0x00,  //..@..
    0x07, 0xf6, 0x00,  //.+@+.
    0x0c, 0x8c, 0x00,  //.@%@.
    0x2e, 0x0e, 0x20,  //.@.@.
    0x7f, 0xff, 0x70,  //+@@@+
    0xd3, 0x03, 0xd0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c4 (Ä) , Width: 5 */
    0x0f, 0x0f, 0x00,  //.@.@.
    0x01, 0xf1, 0x00,  //..@..
    0x07, 0xf6, 0x00,  //.+@+.
    0x0c, 0x8c, 0x00,  //.@%@.
    0x2e, 0x0e, 0x20,  //.@.@.
    0x7f, 0xff, 0x70,  //+@@@+
    0xd3, 0x03, 0xd0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c5 (Å) , Width: 5 */
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x80, 0x00,  //..%..
    0x00, 0x30, 0x00,  //.....
    0x02, 0xf2, 0x00,  //..@..
    0x0a, 0xca, 0x00,  //.%@%.
    0x3f, 0xff, 0x30,  //.@@@.
    0xb6, 0x06, 0xb0,  //%+.+%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c6 (Æ) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x01, 0xff, 0xff, 0xf0,  //..@@@@@
    0x06, 0xaf, 0x00, 0x00,  //.+%@...
    0x0c, 0x4f, 0x00, 0x00,  //.@+@...
    0x2e, 0x0f, 0xff, 0xf0,  //.@.@@@@
    0x7f, 0xff, 0x00, 0x00,  //+@@@...
    0xd3, 0x0f, 0xff, 0xf0,  //@..@@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00c7 (Ç) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x09, 0xee, 0x60,  //.%@@+
    0x9a, 0x10, 0x80,  //%%..%
    0xe1, 0x00, 0x00,  //@....
    0xe1, 0x00, 0x00,  //@....
    0x9a, 0x10, 0x80,  //%%..%
    0x09, 0xee, 0x60,  //.%@@+
    0x00, 0xf0, 0x00,  //..@..
    0x0e, 0xc0, 0x00,  //.@@..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c8 (È) , Width: 4 */
    0x08, 0xc0,  //.%@.
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00c9 (É) , Width: 4 */
    0x09, 0xa0,  //.%%.
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00ca (Ê) , Width: 4 */
    0x07, 0x70,  //.++.
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00cb (Ë) , Width: 4 */
    0x0f, 0x0f,  //.@.@
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00cc (Ì) , Width: 3 */
    0x8c, 0x00,  //%@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00cd (Í) , Width: 2 */
    0x9a,  //%%
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ce (Î) , Width: 3 */
    0x78, 0x60,  //+%+
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00cf (Ï) , Width: 3 */
    0xf0, 0xf0,  //@.@
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00d0 (Ð) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x0f, 0xfe, 0x91,  //.@@@%.
    0x0f, 0x01, 0x9a,  //.@..%%
    0x0f, 0x00, 0x1e,  //.@...@
    0xff, 0xf0, 0x1e,  //@@@..@
    0x0f, 0x01, 0x9a,  //.@..%%
    0x0f, 0xfe, 0xa1,  //.@@@%.
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00d1 (Ñ) , Width: 4 */
    0x0d, 0xd0,  //.@@.
    0xf7, 0x0f,  //@+.@
    0xfe, 0x0f,  //@@.@
    0xfb, 0x7f,  //@%+@
    0xf4, 0xef,  //@+@@
    0xf0, 0xdf,  //@.@@
    0xf0, 0x6f,  //@.+@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00d2 (Ò) , Width: 5 */
    0x08, 0xc0, 0x00,  //.%@..
    0x1b, 0xfb, 0x10,  //.%@%.
    0xa8, 0x08, 0xa0,  //%%.%%
    0xe1, 0x01, 0xe0,  //@...@
    0xe0, 0x01, 0xe0,  //@...@
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1b, 0xfb, 0x10,  //.%@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d3 (Ó) , Width: 5 */
    0x09, 0xa0, 0x00,  //.%%..
    0x1b, 0xfb, 0x10,  //.%@%.
    0xa8, 0x08, 0xa0,  //%%.%%
    0xe1, 0x01, 0xe0,  //@...@
    0xe0, 0x01, 0xe0,  //@...@
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1b, 0xfb, 0x10,  //.%@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d4 (Ô) , Width: 5 */
    0x00, 0x70, 0x00,  //..+..
    0x1b, 0xfb, 0x10,  //.%@%.
    0xa8, 0x08, 0xa0,  //%%.%%
    0xe1, 0x01, 0xe0,  //@...@
    0xe0, 0x01, 0xe0,  //@...@
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1b, 0xfb, 0x10,  //.%@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d5 (Õ) , Width: 5 */
    0x0c, 0xfc, 0x00,  //.@@@.
    0x1b, 0xfb, 0x10,  //.%@%.
    0xa8, 0x08, 0xa0,  //%%.%%
    0xe1, 0x01, 0xe0,  //@...@
    0xe0, 0x01, 0xe0,  //@...@
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1b, 0xfb, 0x10,  //.%@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d6 (Ö) , Width: 5 */
    0x0f, 0x0f, 0x00,  //.@.@.
    0x1b, 0xfb, 0x10,  //.%@%.
    0xa8, 0x08, 0xa0,  //%%.%%
    0xe1, 0x01, 0xe0,  //@...@
    0xe0, 0x01, 0xe0,  //@...@
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1b, 0xfb, 0x10,  //.%@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d7 (×) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xa6, 0x06, 0xa0,  //%+.+%
    0x2e, 0xad, 0x20,  //.@%@.
    0x04, 0xf4, 0x00,  //.+@+.
    0x2e, 0xad, 0x20,  //.@%@.
    0xa6, 0x06, 0xa0,  //%+.+%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d8 (Ø) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x2c, 0xe7, 0xa0,  //.@@+%
    0xb8, 0x0b, 0x70,  //%%.%+
    0xf1, 0x54, 0xd0,  //@.++@
    0xd4, 0x51, 0xf0,  //@++.@
    0x7b, 0x08, 0xb0,  //+%.%%
    0xa7, 0xec, 0x20,  //%+@@.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d9 (Ù) , Width: 4 */
    0x08, 0xc0,  //.%@.
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xd4, 0x4d,  //@++@
    0x4e, 0xe4,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00da (Ú) , Width: 4 */
    0x09, 0xa0,  //.%%.
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xd4, 0x4d,  //@++@
    0x4e, 0xe4,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00db (Û) , Width: 4 */
    0x07, 0x70,  //.++.
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xd4, 0x4d,  //@++@
    0x4e, 0xe4,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00dc (Ü) , Width: 4 */
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xd4, 0x4d,  //@++@
    0x4e, 0xe4,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00dd (Ý) , Width: 5 */
    0x09, 0xa0, 0x00,  //.%%..
    0xa8, 0x08, 0xa0,  //%+.+%
    0x1e, 0x5e, 0x10,  //.@+@.
    0x06, 0xf6, 0x00,  //.+@+.
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00de (Þ) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x00,  //@...
    0xff, 0xe7,  //@@@+
    0xf0, 0x3f,  //@..@
    0xff, 0xe7,  //@@@+
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00df (ß) , Width: 4 */
    0x5e, 0xe5,  //+@@+
    0xe3, 0x3e,  //@..@
    0xf0, 0xb7,  //@.%+
    0xf0, 0xe0,  //@.@.
    0xf0, 0x28,  //@..%
    0xf0, 0x1f,  //@..@
    0xf0, 0xfa,  //@.@%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00e0 (à) , Width: 4 */
    0x00, 0x00,  //....
    0x55, 0x00,  //++..
    0x00, 0x00,  //....
    0x0f, 0xf9,  //.@@%
    0x7e, 0xff,  //+@@@
    0xf3, 0x3f,  //@..@
    0x9f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00e1 (á) , Width: 4 */
    0x00, 0x00,  //....
    0x55, 0x00,  //++..
    0x00, 0x00,  //....
    0x0f, 0xf9,  //.@@%
    0x7e, 0xff,  //+@@@
    0xf3, 0x3f,  //@..@
    0x9f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00e2 (â) , Width: 4 */
    0x00, 0x00,  //....
    0x06, 0x60,  //.++.
    0x00, 0x00,  //....
    0x0f, 0xf9,  //.@@%
    0x7e, 0xff,  //+@@@
    0xf3, 0x3f,  //@..@
    0x9f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00e3 (ã) , Width: 4 */
    0x00, 0x00,  //....
    0x0b, 0xb0,  //.%%.
    0x0b, 0xb0,  //.%%.
    0x0f, 0xf9,  //.@@%
    0x7e, 0xff,  //+@@@
    0xf3, 0x3f,  //@..@
    0x9f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00e4 (ä) , Width: 4 */
    0x00, 0x00,  //....
    0x0f, 0xf0,  //.@@.
    0x00, 0x00,  //....
    0x0f, 0xf9,  //.@@%
    0x7e, 0xff,  //+@@@
    0xf3, 0x3f,  //@..@
    0x9f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00e5 (å) , Width: 4 */
    0x0c, 0xc0,  //.@@.
    0x0c, 0xc0,  //.@@.
    0x00, 0x00,  //....
    0x0f, 0xf9,  //.@@%
    0x7e, 0xff,  //+@@@
    0xf3, 0x3f,  //@..@
    0x9f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00e6 (æ) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x0f, 0xf5, 0xcf, 0x70,  //.@@+@@+
    0x7e, 0xff, 0xff, 0xf0,  //+@@@@@@
    0xf3, 0x3f, 0x40, 0x00,  //@..@+..
    0x9f, 0xc4, 0xdf, 0xf0,  //%@@+@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00e7 (ç) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x6e, 0xf0,  //+@@
    0xe3, 0x00,  //@..
    0xe3, 0x00,  //@..
    0x6e, 0xf0,  //+@@
    0x00, 0xf0,  //..@
    0x0e, 0xc0,  //.@@
    0x00, 0x00,  //...


    /*Unicode: U+00e8 (è) , Width: 4 */
    0x00, 0x00,  //....
    0x05, 0x50,  //.++.
    0x00, 0x00,  //....
    0x5e, 0xf8,  //+@@%
    0xef, 0xff,  //@@@@
    0xe4, 0x00,  //@+..
    0x4d, 0xff,  //+@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00e9 (é) , Width: 4 */
    0x00, 0x00,  //....
    0x05, 0x50,  //.++.
    0x00, 0x00,  //....
    0x5e, 0xf8,  //+@@%
    0xef, 0xff,  //@@@@
    0xe4, 0x00,  //@+..
    0x4d, 0xff,  //+@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00ea (ê) , Width: 4 */
    0x00, 0x00,  //....
    0x48, 0x85,  //+%%+
    0x00, 0x00,  //....
    0x5e, 0xf8,  //+@@%
    0xef, 0xff,  //@@@@
    0xe4, 0x00,  //@+..
    0x4d, 0xff,  //+@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00eb (ë) , Width: 4 */
    0x00, 0x00,  //....
    0x0f, 0x0f,  //.@.@
    0x00, 0x00,  //....
    0x5e, 0xf8,  //+@@%
    0xef, 0xff,  //@@@@
    0xe4, 0x00,  //@+..
    0x4d, 0xff,  //+@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00ec (ì) , Width: 2 */
    0x00,  //..
    0x55,  //++
    0x00,  //..
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ed (í) , Width: 2 */
    0x00,  //..
    0x55,  //++
    0x00,  //..
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+00ee (î) , Width: 3 */
    0x00, 0x00,  //...
    0x68, 0x60,  //+%+
    0x00, 0x00,  //...
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00ef (ï) , Width: 3 */
    0x00, 0x00,  //...
    0xf0, 0xf0,  //@.@
    0x00, 0x00,  //...
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+00f0 (ð) , Width: 4 */
    0x00, 0x20,  //....
    0x3e, 0xf3,  //.@@.
    0x56, 0xe2,  //++@.
    0x5e, 0xf9,  //+@@%
    0xe3, 0x2e,  //@..@
    0xe3, 0x3e,  //@..@
    0x5e, 0xe5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00f1 (ñ) , Width: 4 */
    0x00, 0x00,  //....
    0xa7, 0xf0,  //%+@.
    0xf7, 0xa0,  //@+%.
    0xf9, 0xf8,  //@%@%
    0xf3, 0x3f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00f2 (ò) , Width: 4 */
    0x00, 0x00,  //....
    0x55, 0x00,  //++..
    0x00, 0x00,  //....
    0x5e, 0xe5,  //+@@+
    0xe3, 0x3e,  //@..@
    0xe3, 0x3e,  //@..@
    0x5e, 0xe5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00f3 (ó) , Width: 4 */
    0x00, 0x00,  //....
    0x55, 0x00,  //++..
    0x00, 0x00,  //....
    0x5e, 0xe5,  //+@@+
    0xe3, 0x3e,  //@..@
    0xe3, 0x3e,  //@..@
    0x5e, 0xe5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00f4 (ô) , Width: 4 */
    0x00, 0x00,  //....
    0x06, 0x60,  //.++.
    0x00, 0x00,  //....
    0x5e, 0xe5,  //+@@+
    0xe3, 0x3e,  //@..@
    0xe3, 0x3e,  //@..@
    0x5e, 0xe5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00f5 (õ) , Width: 4 */
    0x00, 0x00,  //....
    0x0b, 0xb0,  //.%%.
    0x0b, 0xb0,  //.%%.
    0x5e, 0xe5,  //+@@+
    0xe3, 0x3e,  //@..@
    0xe3, 0x3e,  //@..@
    0x5e, 0xe5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00f6 (ö) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x5e, 0xe5,  //+@@+
    0xe3, 0x3e,  //@..@
    0xe3, 0x3e,  //@..@
    0x5e, 0xe5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00f7 (÷) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00f8 (ø) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x07, 0xeb, 0xa0,  //.+@%%.
    0x0f, 0x37, 0xb0,  //.@.+%.
    0x0b, 0x73, 0xf0,  //.%+.@.
    0x1a, 0xbf, 0x60,  //.%%@+.
    0x01, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+00f9 (ù) , Width: 4 */
    0x00, 0x00,  //....
    0x55, 0x00,  //++..
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf3, 0x3f,  //@..@
    0x8f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00fa (ú) , Width: 4 */
    0x00, 0x00,  //....
    0x55, 0x00,  //++..
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf3, 0x3f,  //@..@
    0x8f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00fb (û) , Width: 4 */
    0x00, 0x00,  //....
    0x06, 0x60,  //.++.
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf3, 0x3f,  //@..@
    0x8f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00fc (ü) , Width: 4 */
    0x00, 0x00,  //....
    0x0f, 0xf0,  //.@@.
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf3, 0x3f,  //@..@
    0x8f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+00fd (ý) , Width: 4 */
    0x00, 0x00,  //....
    0x55, 0x00,  //++..
    0x00, 0x00,  //....
    0xd3, 0x5c,  //@.+@
    0x79, 0xc5,  //+%@+
    0x1f, 0xd0,  //.@@.
    0x0d, 0x60,  //.@+.
    0x0e, 0x00,  //.@..
    0xf7, 0x00,  //@+..
    0x00, 0x00,  //....


    /*Unicode: U+00fe (þ) , Width: 4 */
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xfa, 0xf6,  //@%@+
    0xf3, 0x3e,  //@..@
    0xf3, 0x3e,  //@..@
    0xfa, 0xf6,  //@%@+
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0x00, 0x00,  //....


    /*Unicode: U+00ff (ÿ) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0xf0,  //@.@.
    0x00, 0x00,  //....
    0xd3, 0x5c,  //@.+@
    0x79, 0xc5,  //+%@+
    0x1f, 0xd0,  //.@@.
    0x0d, 0x60,  //.@+.
    0x0e, 0x00,  //.@..
    0xf7, 0x00,  //@+..
    0x00, 0x00,  //....



#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 8
    /*Unicode: U+00a0 ( ) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00a1 (¡) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0xdc,  //@
    0xfa,  //@
    0xff,  //@
    0xff,  //@
    0x00,  //.


    /*Unicode: U+00a2 (¢) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0x00,  //.@.
    0x96, 0xff, 0xff,  //%@@
    0xf2, 0xff, 0x00,  //@@.
    0xf2, 0xff, 0x00,  //@@.
    0x98, 0xff, 0xff,  //%@@
    0x00, 0xff, 0x02,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00a3 (£) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x72, 0xf2, 0xff,  //.+@@
    0x00, 0xec, 0x2c, 0x00,  //.@..
    0x00, 0xff, 0x00, 0x00,  //.@..
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0xff, 0x00, 0x00,  //.@..
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00a4 (¤) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x96, 0x46, 0x00, 0x48, 0x9c,  //%+.+%
    0x46, 0xdc, 0xc8, 0xdc, 0x42,  //+@@@+
    0x00, 0xc8, 0x48, 0xc8, 0x00,  //.@+@.
    0x46, 0xde, 0xc8, 0xda, 0x44,  //+@@@+
    0x9a, 0x44, 0x00, 0x42, 0x90,  //%+.+%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00a5 (¥) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xae, 0x66, 0x00, 0x68, 0xac,  //%+.+%
    0x1a, 0xd6, 0x14, 0xd6, 0x18,  //.@.@.
    0xff, 0xff, 0xd6, 0xff, 0xff,  //@@@@@
    0x00, 0x26, 0xfc, 0x22, 0x00,  //..@..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00a6 (¦) , Width: 1 */
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+00a7 (§) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x9a, 0xf8, 0xff,  //%@@
    0xd2, 0x30, 0x00,  //@..
    0x8a, 0xb0, 0x42,  //%%+
    0xe6, 0x3a, 0xee,  //@.@
    0x38, 0xb2, 0x7e,  //.%+
    0x00, 0x2c, 0xda,  //..@
    0xff, 0xf8, 0x96,  //@@%
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00a8 (¨) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xff, 0x00, 0xff,  //@.@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00a9 (©) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x04, 0x88, 0xe6, 0xe6, 0x86, 0x04,  //.%@@%.
    0x86, 0xb6, 0x1c, 0x1c, 0xb6, 0x86,  //%%..%%
    0xe6, 0x1a, 0xbe, 0xfc, 0x1c, 0xe6,  //@.%@.@
    0xe6, 0x1a, 0xbe, 0xfc, 0x1c, 0xe6,  //@.%@.@
    0x88, 0xb6, 0x1a, 0x1a, 0xb4, 0x88,  //%%..%%
    0x04, 0x88, 0xe6, 0xe6, 0x86, 0x04,  //.%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00aa (ª) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xb2, 0x00,  //.@%.
    0xb2, 0xfa, 0xfa, 0x00,  //%@@.
    0xcc, 0xae, 0xff, 0x00,  //@%@.
    0x00, 0x00, 0x00, 0x00,  //....
    0x9a, 0xff, 0xff, 0x02,  //%@@.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ab («) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x8a, 0x00, 0x8a,  //.%.%
    0x9e, 0xc4, 0x9e, 0xc4,  //%@%@
    0x9e, 0xc4, 0x9e, 0xc4,  //%@%@
    0x00, 0x8a, 0x00, 0x8a,  //.%.%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ac (¬) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00ad (­) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00ae (®) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x04, 0x88, 0xe6, 0xe6, 0x86, 0x04,  //.%@@%.
    0x86, 0xb6, 0x1c, 0x1c, 0xb6, 0x86,  //%%..%%
    0xe6, 0x1a, 0xff, 0xd2, 0x1c, 0xe6,  //@.@@.@
    0xe6, 0x1a, 0xff, 0x98, 0x1c, 0xe6,  //@.@%.@
    0x88, 0xb6, 0x1a, 0x1a, 0xb4, 0x88,  //%%..%%
    0x04, 0x88, 0xe6, 0xe6, 0x86, 0x04,  //.%@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00af (¯) , Width: 2 */
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00b0 (°) , Width: 2 */
    0x00, 0x00,  //..
    0xc4, 0xc0,  //@%
    0xc6, 0xc4,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00b1 (±) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b2 (²) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xff, 0xd0, 0x00,  //@@.
    0x58, 0xe8, 0x18,  //+@.
    0xff, 0xff, 0x00,  //@@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00b3 (³) , Width: 2 */
    0x00, 0x00,  //..
    0xff, 0xc6,  //@@
    0x00, 0x9c,  //.%
    0xff, 0xca,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00b4 (´) , Width: 2 */
    0x00, 0x00,  //..
    0x5e, 0x5a,  //++
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00b5 (µ) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x30, 0x2e, 0xff, 0x06,  //@..@.
    0xff, 0xb0, 0xb8, 0xb0, 0xe4,  //@%%%@
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0xff, 0x00, 0x00, 0x00, 0x00,  //@....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00b6 (¶) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x94, 0xfc, 0xff, 0xff,  //%@@@
    0xf4, 0xff, 0x00, 0xff,  //@@.@
    0xec, 0xff, 0x00, 0xff,  //@@.@
    0x6a, 0xff, 0x00, 0xff,  //+@.@
    0x00, 0xff, 0x00, 0xff,  //.@.@
    0x00, 0xff, 0x00, 0xff,  //.@.@
    0x00, 0xff, 0x00, 0xff,  //.@.@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00b7 (·) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+00b8 (¸) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x08, 0xff,  //.@
    0xee, 0xcc,  //@@
    0x00, 0x00,  //..


    /*Unicode: U+00b9 (¹) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0x00,  //@@.
    0x00, 0xff, 0x00,  //.@.
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00ba (º) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x90, 0xf4, 0x90,  //%@%
    0xf4, 0x44, 0xf4,  //@+@
    0x92, 0xf4, 0x94,  //%@%
    0x00, 0x00, 0x00,  //...
    0xb6, 0xff, 0xba,  //%@%
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00bb (») , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x88, 0x00, 0x88, 0x00,  //%.%.
    0xc4, 0x9e, 0xc4, 0x9e,  //@%@%
    0xc4, 0x9e, 0xc4, 0x9e,  //@%@%
    0x8a, 0x00, 0x8a, 0x00,  //%.%.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00bc (¼) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x58, 0xc2, 0x00, 0x00, 0x00,  //@@.+@...
    0x00, 0xff, 0x00, 0xd2, 0x48, 0x00, 0x00, 0x00,  //.@.@+...
    0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00,  //@@@@....
    0x00, 0x00, 0xca, 0x56, 0x00, 0x0c, 0xda, 0x00,  //..@+..@.
    0x00, 0x46, 0xd8, 0x00, 0x00, 0x0a, 0xff, 0x00,  //.+@...@.
    0x00, 0xc0, 0x62, 0x00, 0x00, 0xf0, 0xff, 0xff,  //.%+..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00bd (½) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xff, 0x00, 0x58, 0xc2, 0x00, 0x00, 0x00,  //@@.+@...
    0x00, 0xff, 0x00, 0xd2, 0x48, 0x00, 0x00, 0x00,  //.@.@+...
    0xff, 0xff, 0xff, 0xce, 0x00, 0x00, 0x00, 0x00,  //@@@@....
    0x00, 0x00, 0xca, 0x56, 0x00, 0xff, 0xd0, 0x00,  //..@+.@@.
    0x00, 0x46, 0xd8, 0x00, 0x00, 0x58, 0xe8, 0x18,  //.+@..+@.
    0x00, 0xc0, 0x62, 0x00, 0x00, 0xff, 0xff, 0x00,  //.%+..@@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00be (¾) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0xc6, 0x00, 0x58, 0xc2, 0x00, 0x00, 0x00,  //@@.+@...
    0x00, 0x9c, 0x00, 0xd2, 0x48, 0x00, 0x00, 0x00,  //.%.@+...
    0xff, 0xca, 0x4e, 0xce, 0x00, 0x00, 0x00, 0x00,  //@@+@....
    0x00, 0x00, 0xca, 0x56, 0x00, 0x0c, 0xda, 0x00,  //..@+..@.
    0x00, 0x46, 0xd8, 0x00, 0x00, 0x0a, 0xff, 0x00,  //.+@...@.
    0x00, 0xc0, 0x62, 0x00, 0x00, 0xf0, 0xff, 0xff,  //.%+..@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+00bf (¿) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0xf8, 0x00,  //.@.
    0x22, 0x80, 0x00,  //.+.
    0xde, 0x18, 0x00,  //@..
    0x9e, 0xfa, 0xff,  //%@@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00c0 (À) , Width: 5 */
    0x00, 0x00, 0x8a, 0xc2, 0x08,  //..%@.
    0x00, 0x18, 0xfa, 0x18, 0x00,  //..@..
    0x00, 0x70, 0xfc, 0x6e, 0x00,  //.+@+.
    0x00, 0xc8, 0x8a, 0xc8, 0x00,  //.@%@.
    0x22, 0xe6, 0x06, 0xe6, 0x20,  //.@.@.
    0x7a, 0xff, 0xff, 0xff, 0x78,  //+@@@+
    0xd2, 0x38, 0x00, 0x38, 0xd2,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c1 (Á) , Width: 5 */
    0x00, 0x00, 0x9c, 0xa2, 0x00,  //..%%.
    0x00, 0x18, 0xfa, 0x18, 0x00,  //..@..
    0x00, 0x70, 0xfc, 0x6e, 0x00,  //.+@+.
    0x00, 0xc8, 0x8a, 0xc8, 0x00,  //.@%@.
    0x22, 0xe6, 0x06, 0xe6, 0x20,  //.@.@.
    0x7a, 0xff, 0xff, 0xff, 0x78,  //+@@@+
    0xd2, 0x38, 0x00, 0x38, 0xd2,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c2 (Â) , Width: 5 */
    0x00, 0x00, 0x76, 0x00, 0x00,  //..+..
    0x00, 0x18, 0xfa, 0x18, 0x00,  //..@..
    0x00, 0x70, 0xfc, 0x6e, 0x00,  //.+@+.
    0x00, 0xc8, 0x8a, 0xc8, 0x00,  //.@%@.
    0x22, 0xe6, 0x06, 0xe6, 0x20,  //.@.@.
    0x7a, 0xff, 0xff, 0xff, 0x78,  //+@@@+
    0xd2, 0x38, 0x00, 0x38, 0xd2,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c3 (Ã) , Width: 5 */
    0x00, 0xca, 0xff, 0xca, 0x00,  //.@@@.
    0x00, 0x18, 0xfa, 0x18, 0x00,  //..@..
    0x00, 0x70, 0xfc, 0x6e, 0x00,  //.+@+.
    0x00, 0xc8, 0x8a, 0xc8, 0x00,  //.@%@.
    0x22, 0xe6, 0x06, 0xe6, 0x20,  //.@.@.
    0x7a, 0xff, 0xff, 0xff, 0x78,  //+@@@+
    0xd2, 0x38, 0x00, 0x38, 0xd2,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c4 (Ä) , Width: 5 */
    0x00, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0x00, 0x18, 0xfa, 0x18, 0x00,  //..@..
    0x00, 0x70, 0xfc, 0x6e, 0x00,  //.+@+.
    0x00, 0xc8, 0x8a, 0xc8, 0x00,  //.@%@.
    0x22, 0xe6, 0x06, 0xe6, 0x20,  //.@.@.
    0x7a, 0xff, 0xff, 0xff, 0x78,  //+@@@+
    0xd2, 0x38, 0x00, 0x38, 0xd2,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c5 (Å) , Width: 5 */
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x8e, 0x00, 0x00,  //..%..
    0x00, 0x00, 0x38, 0x00, 0x00,  //.....
    0x00, 0x26, 0xf6, 0x26, 0x00,  //..@..
    0x00, 0xac, 0xce, 0xaa, 0x00,  //.%@%.
    0x34, 0xff, 0xff, 0xff, 0x32,  //.@@@.
    0xba, 0x66, 0x00, 0x66, 0xba,  //%+.+%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c6 (Æ) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x16, 0xfa, 0xff, 0xff, 0xff, 0xff,  //..@@@@@
    0x00, 0x6c, 0xa0, 0xff, 0x00, 0x00, 0x00,  //.+%@...
    0x00, 0xc6, 0x46, 0xff, 0x00, 0x00, 0x00,  //.@+@...
    0x20, 0xe6, 0x02, 0xff, 0xff, 0xff, 0xff,  //.@.@@@@
    0x78, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //+@@@...
    0xd2, 0x38, 0x00, 0xff, 0xff, 0xff, 0xff,  //@..@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00c7 (Ç) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x0c, 0x9a, 0xe8, 0xea, 0x6e,  //.%@@+
    0x9c, 0xa4, 0x18, 0x0e, 0x88,  //%%..%
    0xea, 0x14, 0x00, 0x00, 0x00,  //@....
    0xea, 0x14, 0x00, 0x00, 0x00,  //@....
    0x9e, 0xa2, 0x16, 0x0e, 0x88,  //%%..%
    0x0e, 0x9c, 0xea, 0xea, 0x6e,  //.%@@+
    0x00, 0x08, 0xff, 0x00, 0x00,  //..@..
    0x00, 0xee, 0xcc, 0x00, 0x00,  //.@@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00c8 (È) , Width: 4 */
    0x00, 0x8a, 0xc2, 0x08,  //.%@.
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00c9 (É) , Width: 4 */
    0x00, 0x9c, 0xa2, 0x00,  //.%%.
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ca (Ê) , Width: 4 */
    0x00, 0x76, 0x76, 0x00,  //.++.
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00cb (Ë) , Width: 4 */
    0x00, 0xff, 0x00, 0xff,  //.@.@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00cc (Ì) , Width: 3 */
    0x8a, 0xc2, 0x08,  //%@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00cd (Í) , Width: 2 */
    0x9c, 0xa2,  //%%
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00ce (Î) , Width: 3 */
    0x70, 0x86, 0x6e,  //+%+
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00cf (Ï) , Width: 3 */
    0xff, 0x00, 0xff,  //@.@
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00d0 (Ð) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0xff, 0xfc, 0xe2, 0x9e, 0x12,  //.@@@%.
    0x00, 0xff, 0x00, 0x1a, 0x9e, 0xa8,  //.@..%%
    0x00, 0xff, 0x00, 0x00, 0x12, 0xea,  //.@...@
    0xff, 0xff, 0xff, 0x00, 0x12, 0xea,  //@@@..@
    0x00, 0xff, 0x00, 0x18, 0x9e, 0xa8,  //.@..%%
    0x00, 0xff, 0xfc, 0xe4, 0xa0, 0x14,  //.@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00d1 (Ñ) , Width: 4 */
    0x00, 0xda, 0xda, 0x00,  //.@@.
    0xff, 0x72, 0x00, 0xff,  //@+.@
    0xff, 0xe6, 0x08, 0xff,  //@@.@
    0xff, 0xb4, 0x74, 0xff,  //@%+@
    0xff, 0x46, 0xe8, 0xff,  //@+@@
    0xff, 0x00, 0xd6, 0xff,  //@.@@
    0xff, 0x00, 0x6a, 0xff,  //@.+@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00d2 (Ò) , Width: 5 */
    0x00, 0x8a, 0xc2, 0x08, 0x00,  //.%@..
    0x1a, 0xba, 0xf2, 0xba, 0x18,  //.%@%.
    0xac, 0x86, 0x0c, 0x86, 0xaa,  //%%.%%
    0xee, 0x10, 0x00, 0x10, 0xec,  //@...@
    0xee, 0x0e, 0x00, 0x10, 0xec,  //@...@
    0xac, 0x84, 0x0c, 0x84, 0xaa,  //%%.%%
    0x1a, 0xbc, 0xf2, 0xba, 0x1a,  //.%@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d3 (Ó) , Width: 5 */
    0x00, 0x9c, 0xa2, 0x00, 0x00,  //.%%..
    0x1a, 0xba, 0xf2, 0xba, 0x18,  //.%@%.
    0xac, 0x86, 0x0c, 0x86, 0xaa,  //%%.%%
    0xee, 0x10, 0x00, 0x10, 0xec,  //@...@
    0xee, 0x0e, 0x00, 0x10, 0xec,  //@...@
    0xac, 0x84, 0x0c, 0x84, 0xaa,  //%%.%%
    0x1a, 0xbc, 0xf2, 0xba, 0x1a,  //.%@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d4 (Ô) , Width: 5 */
    0x00, 0x00, 0x76, 0x00, 0x00,  //..+..
    0x1a, 0xba, 0xf2, 0xba, 0x18,  //.%@%.
    0xac, 0x86, 0x0c, 0x86, 0xaa,  //%%.%%
    0xee, 0x10, 0x00, 0x10, 0xec,  //@...@
    0xee, 0x0e, 0x00, 0x10, 0xec,  //@...@
    0xac, 0x84, 0x0c, 0x84, 0xaa,  //%%.%%
    0x1a, 0xbc, 0xf2, 0xba, 0x1a,  //.%@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d5 (Õ) , Width: 5 */
    0x00, 0xca, 0xff, 0xca, 0x00,  //.@@@.
    0x1a, 0xba, 0xf2, 0xba, 0x18,  //.%@%.
    0xac, 0x86, 0x0c, 0x86, 0xaa,  //%%.%%
    0xee, 0x10, 0x00, 0x10, 0xec,  //@...@
    0xee, 0x0e, 0x00, 0x10, 0xec,  //@...@
    0xac, 0x84, 0x0c, 0x84, 0xaa,  //%%.%%
    0x1a, 0xbc, 0xf2, 0xba, 0x1a,  //.%@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d6 (Ö) , Width: 5 */
    0x00, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0x1a, 0xba, 0xf2, 0xba, 0x18,  //.%@%.
    0xac, 0x86, 0x0c, 0x86, 0xaa,  //%%.%%
    0xee, 0x10, 0x00, 0x10, 0xec,  //@...@
    0xee, 0x0e, 0x00, 0x10, 0xec,  //@...@
    0xac, 0x84, 0x0c, 0x84, 0xaa,  //%%.%%
    0x1a, 0xbc, 0xf2, 0xba, 0x1a,  //.%@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d7 (×) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xa4, 0x64, 0x00, 0x64, 0xa4,  //%+.+%
    0x22, 0xe0, 0xa2, 0xde, 0x20,  //.@%@.
    0x00, 0x46, 0xff, 0x42, 0x00,  //.+@+.
    0x20, 0xe0, 0xa2, 0xde, 0x20,  //.@%@.
    0xa4, 0x64, 0x00, 0x64, 0xa4,  //%+.+%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d8 (Ø) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x04,  //.....
    0x24, 0xc6, 0xec, 0x74, 0xa0,  //.@@+%
    0xba, 0x86, 0x0c, 0xba, 0x74,  //%%.%+
    0xf2, 0x10, 0x56, 0x44, 0xde,  //@.++@
    0xde, 0x44, 0x54, 0x10, 0xf0,  //@++.@
    0x74, 0xba, 0x0a, 0x84, 0xb8,  //+%.%%
    0xa0, 0x76, 0xec, 0xc6, 0x22,  //%+@@.
    0x06, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00d9 (Ù) , Width: 4 */
    0x00, 0x8a, 0xc2, 0x08,  //.%@.
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xfa, 0x02, 0x02, 0xfa,  //@..@
    0xd6, 0x42, 0x44, 0xd6,  //@++@
    0x4c, 0xe6, 0xe4, 0x4a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00da (Ú) , Width: 4 */
    0x00, 0x9c, 0xa2, 0x00,  //.%%.
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xfa, 0x02, 0x02, 0xfa,  //@..@
    0xd6, 0x42, 0x44, 0xd6,  //@++@
    0x4c, 0xe6, 0xe4, 0x4a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00db (Û) , Width: 4 */
    0x00, 0x76, 0x76, 0x00,  //.++.
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xfa, 0x02, 0x02, 0xfa,  //@..@
    0xd6, 0x42, 0x44, 0xd6,  //@++@
    0x4c, 0xe6, 0xe4, 0x4a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00dc (Ü) , Width: 4 */
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xfa, 0x02, 0x02, 0xfa,  //@..@
    0xd6, 0x42, 0x44, 0xd6,  //@++@
    0x4c, 0xe6, 0xe4, 0x4a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00dd (Ý) , Width: 5 */
    0x00, 0x9c, 0xa2, 0x00, 0x00,  //.%%..
    0xac, 0x80, 0x00, 0x80, 0xac,  //%+.+%
    0x18, 0xe8, 0x52, 0xe8, 0x18,  //.@+@.
    0x00, 0x66, 0xff, 0x66, 0x00,  //.+@+.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00de (Þ) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xec, 0x7e,  //@@@+
    0xff, 0x00, 0x3e, 0xf0,  //@..@
    0xff, 0xff, 0xee, 0x7e,  //@@@+
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00df (ß) , Width: 4 */
    0x56, 0xe6, 0xea, 0x56,  //+@@+
    0xe6, 0x38, 0x3e, 0xe0,  //@..@
    0xff, 0x00, 0xba, 0x76,  //@.%+
    0xff, 0x00, 0xe0, 0x00,  //@.@.
    0xff, 0x00, 0x20, 0x8c,  //@..%
    0xff, 0x00, 0x12, 0xf2,  //@..@
    0xff, 0x00, 0xfc, 0xa4,  //@.@%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00e0 (à) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0x5e, 0x00, 0x00,  //++..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xf6, 0x92,  //.@@%
    0x7a, 0xec, 0xff, 0xfa,  //+@@@
    0xf2, 0x38, 0x3e, 0xff,  //@..@
    0x96, 0xf0, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00e1 (á) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x5e, 0x5a, 0x00, 0x00,  //++..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xf6, 0x92,  //.@@%
    0x7a, 0xec, 0xff, 0xfa,  //+@@@
    0xf2, 0x38, 0x3e, 0xff,  //@..@
    0x96, 0xf0, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00e2 (â) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x6c, 0x6c, 0x00,  //.++.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xf6, 0x92,  //.@@%
    0x7a, 0xec, 0xff, 0xfa,  //+@@@
    0xf2, 0x38, 0x3e, 0xff,  //@..@
    0x96, 0xf0, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00e3 (ã) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xb6, 0xb2, 0x00,  //.%%.
    0x00, 0xb4, 0xb4, 0x00,  //.%%.
    0x00, 0xff, 0xf6, 0x92,  //.@@%
    0x7a, 0xec, 0xff, 0xfa,  //+@@@
    0xf2, 0x38, 0x3e, 0xff,  //@..@
    0x96, 0xf0, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00e4 (ä) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xf6, 0x92,  //.@@%
    0x7a, 0xec, 0xff, 0xfa,  //+@@@
    0xf2, 0x38, 0x3e, 0xff,  //@..@
    0x96, 0xf0, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00e5 (å) , Width: 4 */
    0x00, 0xc4, 0xc2, 0x00,  //.@@.
    0x00, 0xc6, 0xc4, 0x00,  //.@@.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xf6, 0x92,  //.@@%
    0x7a, 0xec, 0xff, 0xfa,  //+@@@
    0xf2, 0x38, 0x3e, 0xff,  //@..@
    0x96, 0xf0, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00e6 (æ) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0xff, 0xf0, 0x56, 0xc6, 0xf2, 0x7a,  //.@@+@@+
    0x7a, 0xec, 0xff, 0xff, 0xff, 0xff, 0xf6,  //+@@@@@@
    0xf2, 0x36, 0x3e, 0xff, 0x4a, 0x00, 0x00,  //@..@+..
    0x92, 0xf6, 0xc8, 0x4e, 0xd4, 0xfc, 0xff,  //%@@+@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+00e7 (ç) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x60, 0xec, 0xff,  //+@@
    0xea, 0x36, 0x00,  //@..
    0xea, 0x36, 0x00,  //@..
    0x60, 0xec, 0xff,  //+@@
    0x00, 0x08, 0xff,  //..@
    0x00, 0xee, 0xcc,  //.@@
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00e8 (è) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x5a, 0x5e, 0x00,  //.++.
    0x00, 0x00, 0x00, 0x00,  //....
    0x50, 0xe2, 0xf0, 0x84,  //+@@%
    0xe6, 0xff, 0xff, 0xfa,  //@@@@
    0xe6, 0x4a, 0x02, 0x00,  //@+..
    0x4a, 0xda, 0xfc, 0xff,  //+@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00e9 (é) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x5e, 0x5a, 0x00,  //.++.
    0x00, 0x00, 0x00, 0x00,  //....
    0x50, 0xe2, 0xf0, 0x84,  //+@@%
    0xe6, 0xff, 0xff, 0xfa,  //@@@@
    0xe6, 0x4a, 0x02, 0x00,  //@+..
    0x4a, 0xda, 0xfc, 0xff,  //+@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ea (ê) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x4e, 0x8a, 0x88, 0x50,  //+%%+
    0x00, 0x00, 0x00, 0x00,  //....
    0x50, 0xe2, 0xf0, 0x84,  //+@@%
    0xe6, 0xff, 0xff, 0xfa,  //@@@@
    0xe6, 0x4a, 0x02, 0x00,  //@+..
    0x4a, 0xda, 0xfc, 0xff,  //+@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00eb (ë) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0x00, 0xff,  //.@.@
    0x00, 0x00, 0x00, 0x00,  //....
    0x50, 0xe2, 0xf0, 0x84,  //+@@%
    0xe6, 0xff, 0xff, 0xfa,  //@@@@
    0xe6, 0x4a, 0x02, 0x00,  //@+..
    0x4a, 0xda, 0xfc, 0xff,  //+@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ec (ì) , Width: 2 */
    0x00, 0x00,  //..
    0x5a, 0x5e,  //++
    0x00, 0x00,  //..
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00ed (í) , Width: 2 */
    0x00, 0x00,  //..
    0x5e, 0x5a,  //++
    0x00, 0x00,  //..
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+00ee (î) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x60, 0x82, 0x60,  //+%+
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00ef (ï) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xff, 0x00, 0xff,  //@.@
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+00f0 (ð) , Width: 4 */
    0x00, 0x00, 0x22, 0x0a,  //....
    0x3a, 0xec, 0xf2, 0x36,  //.@@.
    0x50, 0x68, 0xea, 0x20,  //++@.
    0x58, 0xea, 0xfc, 0x90,  //+@@%
    0xe8, 0x36, 0x26, 0xea,  //@..@
    0xe6, 0x32, 0x34, 0xe4,  //@..@
    0x54, 0xe6, 0xe6, 0x52,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00f1 (ñ) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xac, 0x7c, 0xf2, 0x00,  //%+@.
    0xf4, 0x7e, 0xaa, 0x00,  //@+%.
    0xff, 0x94, 0xf4, 0x84,  //@%@%
    0xff, 0x38, 0x30, 0xf2,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00f2 (ò) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0x5e, 0x00, 0x00,  //++..
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0xe8, 0x32, 0x34, 0xe8,  //@..@
    0xe8, 0x32, 0x32, 0xe8,  //@..@
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00f3 (ó) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x5e, 0x5a, 0x00, 0x00,  //++..
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0xe8, 0x32, 0x34, 0xe8,  //@..@
    0xe8, 0x32, 0x32, 0xe8,  //@..@
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00f4 (ô) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x6c, 0x6c, 0x00,  //.++.
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0xe8, 0x32, 0x34, 0xe8,  //@..@
    0xe8, 0x32, 0x32, 0xe8,  //@..@
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00f5 (õ) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xb6, 0xb2, 0x00,  //.%%.
    0x00, 0xb4, 0xb4, 0x00,  //.%%.
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0xe8, 0x32, 0x34, 0xe8,  //@..@
    0xe8, 0x32, 0x32, 0xe8,  //@..@
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00f6 (ö) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0xe8, 0x32, 0x34, 0xe8,  //@..@
    0xe8, 0x32, 0x32, 0xe8,  //@..@
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00f7 (÷) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+00f8 (ø) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x00,  //......
    0x00, 0x70, 0xee, 0xb8, 0xa8, 0x04,  //.+@%%.
    0x00, 0xf0, 0x3c, 0x7e, 0xba, 0x00,  //.@.+%.
    0x00, 0xba, 0x7e, 0x3a, 0xf0, 0x00,  //.%+.@.
    0x12, 0xae, 0xbc, 0xf0, 0x6e, 0x00,  //.%%@+.
    0x04, 0x12, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+00f9 (ù) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0x5e, 0x00, 0x00,  //++..
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xf2, 0x30, 0x3a, 0xff,  //@..@
    0x84, 0xf4, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00fa (ú) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x5e, 0x5a, 0x00, 0x00,  //++..
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xf2, 0x30, 0x3a, 0xff,  //@..@
    0x84, 0xf4, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00fb (û) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x6c, 0x6c, 0x00,  //.++.
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xf2, 0x30, 0x3a, 0xff,  //@..@
    0x84, 0xf4, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00fc (ü) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0x00,  //.@@.
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xf2, 0x30, 0x3a, 0xff,  //@..@
    0x84, 0xf4, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00fd (ý) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x5e, 0x5a, 0x00, 0x00,  //++..
    0x00, 0x00, 0x00, 0x00,  //....
    0xd0, 0x3c, 0x50, 0xc4,  //@.+@
    0x76, 0x96, 0xc4, 0x50,  //+%@+
    0x1c, 0xf4, 0xda, 0x00,  //.@@.
    0x00, 0xd0, 0x68, 0x00,  //.@+.
    0x04, 0xe4, 0x08, 0x00,  //.@..
    0xfa, 0x78, 0x00, 0x00,  //@+..
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00fe (þ) , Width: 4 */
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xa0, 0xf0, 0x64,  //@%@+
    0xff, 0x32, 0x32, 0xea,  //@..@
    0xff, 0x32, 0x32, 0xea,  //@..@
    0xff, 0xa0, 0xf0, 0x66,  //@%@+
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+00ff (ÿ) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0xff, 0x00,  //@.@.
    0x00, 0x00, 0x00, 0x00,  //....
    0xd0, 0x3c, 0x50, 0xc4,  //@.+@
    0x76, 0x96, 0xc4, 0x50,  //+%@+
    0x1c, 0xf4, 0xda, 0x00,  //.@@.
    0x00, 0xd0, 0x68, 0x00,  //.@+.
    0x04, 0xe4, 0x08, 0x00,  //.@..
    0xfa, 0x78, 0x00, 0x00,  //@+..
    0x00, 0x00, 0x00, 0x00,  //....



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_10_latin_sup_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_10_LATIN_SUP == 1
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 1,   .glyph_index = 10}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 3,   .glyph_index = 20}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 4,   .glyph_index = 30}, /*Unicode: U+00a3 (£)*/
    {.w_px = 5,   .glyph_index = 40}, /*Unicode: U+00a4 (¤)*/
    {.w_px = 5,   .glyph_index = 50}, /*Unicode: U+00a5 (¥)*/
    {.w_px = 1,   .glyph_index = 60}, /*Unicode: U+00a6 (¦)*/
    {.w_px = 3,   .glyph_index = 70}, /*Unicode: U+00a7 (§)*/
    {.w_px = 3,   .glyph_index = 80}, /*Unicode: U+00a8 (¨)*/
    {.w_px = 6,   .glyph_index = 90}, /*Unicode: U+00a9 (©)*/
    {.w_px = 4,   .glyph_index = 100},    /*Unicode: U+00aa (ª)*/
    {.w_px = 4,   .glyph_index = 110},    /*Unicode: U+00ab («)*/
    {.w_px = 5,   .glyph_index = 120},    /*Unicode: U+00ac (¬)*/
    {.w_px = 2,   .glyph_index = 130},    /*Unicode: U+00ad (­)*/
    {.w_px = 6,   .glyph_index = 140},    /*Unicode: U+00ae (®)*/
    {.w_px = 2,   .glyph_index = 150},    /*Unicode: U+00af (¯)*/
    {.w_px = 2,   .glyph_index = 160},    /*Unicode: U+00b0 (°)*/
    {.w_px = 5,   .glyph_index = 170},    /*Unicode: U+00b1 (±)*/
    {.w_px = 3,   .glyph_index = 180},    /*Unicode: U+00b2 (²)*/
    {.w_px = 2,   .glyph_index = 190},    /*Unicode: U+00b3 (³)*/
    {.w_px = 2,   .glyph_index = 200},    /*Unicode: U+00b4 (´)*/
    {.w_px = 5,   .glyph_index = 210},    /*Unicode: U+00b5 (µ)*/
    {.w_px = 4,   .glyph_index = 220},    /*Unicode: U+00b6 (¶)*/
    {.w_px = 1,   .glyph_index = 230},    /*Unicode: U+00b7 (·)*/
    {.w_px = 2,   .glyph_index = 240},    /*Unicode: U+00b8 (¸)*/
    {.w_px = 3,   .glyph_index = 250},    /*Unicode: U+00b9 (¹)*/
    {.w_px = 3,   .glyph_index = 260},    /*Unicode: U+00ba (º)*/
    {.w_px = 4,   .glyph_index = 270},    /*Unicode: U+00bb (»)*/
    {.w_px = 8,   .glyph_index = 280},    /*Unicode: U+00bc (¼)*/
    {.w_px = 8,   .glyph_index = 290},    /*Unicode: U+00bd (½)*/
    {.w_px = 8,   .glyph_index = 300},    /*Unicode: U+00be (¾)*/
    {.w_px = 3,   .glyph_index = 310},    /*Unicode: U+00bf (¿)*/
    {.w_px = 5,   .glyph_index = 320},    /*Unicode: U+00c0 (À)*/
    {.w_px = 5,   .glyph_index = 330},    /*Unicode: U+00c1 (Á)*/
    {.w_px = 5,   .glyph_index = 340},    /*Unicode: U+00c2 (Â)*/
    {.w_px = 5,   .glyph_index = 350},    /*Unicode: U+00c3 (Ã)*/
    {.w_px = 5,   .glyph_index = 360},    /*Unicode: U+00c4 (Ä)*/
    {.w_px = 5,   .glyph_index = 370},    /*Unicode: U+00c5 (Å)*/
    {.w_px = 7,   .glyph_index = 380},    /*Unicode: U+00c6 (Æ)*/
    {.w_px = 5,   .glyph_index = 390},    /*Unicode: U+00c7 (Ç)*/
    {.w_px = 4,   .glyph_index = 400},    /*Unicode: U+00c8 (È)*/
    {.w_px = 4,   .glyph_index = 410},    /*Unicode: U+00c9 (É)*/
    {.w_px = 4,   .glyph_index = 420},    /*Unicode: U+00ca (Ê)*/
    {.w_px = 4,   .glyph_index = 430},    /*Unicode: U+00cb (Ë)*/
    {.w_px = 3,   .glyph_index = 440},    /*Unicode: U+00cc (Ì)*/
    {.w_px = 2,   .glyph_index = 450},    /*Unicode: U+00cd (Í)*/
    {.w_px = 3,   .glyph_index = 460},    /*Unicode: U+00ce (Î)*/
    {.w_px = 3,   .glyph_index = 470},    /*Unicode: U+00cf (Ï)*/
    {.w_px = 6,   .glyph_index = 480},    /*Unicode: U+00d0 (Ð)*/
    {.w_px = 4,   .glyph_index = 490},    /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 5,   .glyph_index = 500},    /*Unicode: U+00d2 (Ò)*/
    {.w_px = 5,   .glyph_index = 510},    /*Unicode: U+00d3 (Ó)*/
    {.w_px = 5,   .glyph_index = 520},    /*Unicode: U+00d4 (Ô)*/
    {.w_px = 5,   .glyph_index = 530},    /*Unicode: U+00d5 (Õ)*/
    {.w_px = 5,   .glyph_index = 540},    /*Unicode: U+00d6 (Ö)*/
    {.w_px = 5,   .glyph_index = 550},    /*Unicode: U+00d7 (×)*/
    {.w_px = 5,   .glyph_index = 560},    /*Unicode: U+00d8 (Ø)*/
    {.w_px = 4,   .glyph_index = 570},    /*Unicode: U+00d9 (Ù)*/
    {.w_px = 4,   .glyph_index = 580},    /*Unicode: U+00da (Ú)*/
    {.w_px = 4,   .glyph_index = 590},    /*Unicode: U+00db (Û)*/
    {.w_px = 4,   .glyph_index = 600},    /*Unicode: U+00dc (Ü)*/
    {.w_px = 5,   .glyph_index = 610},    /*Unicode: U+00dd (Ý)*/
    {.w_px = 4,   .glyph_index = 620},    /*Unicode: U+00de (Þ)*/
    {.w_px = 4,   .glyph_index = 630},    /*Unicode: U+00df (ß)*/
    {.w_px = 4,   .glyph_index = 640},    /*Unicode: U+00e0 (à)*/
    {.w_px = 4,   .glyph_index = 650},    /*Unicode: U+00e1 (á)*/
    {.w_px = 4,   .glyph_index = 660},    /*Unicode: U+00e2 (â)*/
    {.w_px = 4,   .glyph_index = 670},    /*Unicode: U+00e3 (ã)*/
    {.w_px = 4,   .glyph_index = 680},    /*Unicode: U+00e4 (ä)*/
    {.w_px = 4,   .glyph_index = 690},    /*Unicode: U+00e5 (å)*/
    {.w_px = 7,   .glyph_index = 700},    /*Unicode: U+00e6 (æ)*/
    {.w_px = 3,   .glyph_index = 710},    /*Unicode: U+00e7 (ç)*/
    {.w_px = 4,   .glyph_index = 720},    /*Unicode: U+00e8 (è)*/
    {.w_px = 4,   .glyph_index = 730},    /*Unicode: U+00e9 (é)*/
    {.w_px = 4,   .glyph_index = 740},    /*Unicode: U+00ea (ê)*/
    {.w_px = 4,   .glyph_index = 750},    /*Unicode: U+00eb (ë)*/
    {.w_px = 2,   .glyph_index = 760},    /*Unicode: U+00ec (ì)*/
    {.w_px = 2,   .glyph_index = 770},    /*Unicode: U+00ed (í)*/
    {.w_px = 3,   .glyph_index = 780},    /*Unicode: U+00ee (î)*/
    {.w_px = 3,   .glyph_index = 790},    /*Unicode: U+00ef (ï)*/
    {.w_px = 4,   .glyph_index = 800},    /*Unicode: U+00f0 (ð)*/
    {.w_px = 4,   .glyph_index = 810},    /*Unicode: U+00f1 (ñ)*/
    {.w_px = 4,   .glyph_index = 820},    /*Unicode: U+00f2 (ò)*/
    {.w_px = 4,   .glyph_index = 830},    /*Unicode: U+00f3 (ó)*/
    {.w_px = 4,   .glyph_index = 840},    /*Unicode: U+00f4 (ô)*/
    {.w_px = 4,   .glyph_index = 850},    /*Unicode: U+00f5 (õ)*/
    {.w_px = 4,   .glyph_index = 860},    /*Unicode: U+00f6 (ö)*/
    {.w_px = 5,   .glyph_index = 870},    /*Unicode: U+00f7 (÷)*/
    {.w_px = 6,   .glyph_index = 880},    /*Unicode: U+00f8 (ø)*/
    {.w_px = 4,   .glyph_index = 890},    /*Unicode: U+00f9 (ù)*/
    {.w_px = 4,   .glyph_index = 900},    /*Unicode: U+00fa (ú)*/
    {.w_px = 4,   .glyph_index = 910},    /*Unicode: U+00fb (û)*/
    {.w_px = 4,   .glyph_index = 920},    /*Unicode: U+00fc (ü)*/
    {.w_px = 4,   .glyph_index = 930},    /*Unicode: U+00fd (ý)*/
    {.w_px = 4,   .glyph_index = 940},    /*Unicode: U+00fe (þ)*/
    {.w_px = 4,   .glyph_index = 950},    /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 2
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 1,   .glyph_index = 10}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 3,   .glyph_index = 20}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 4,   .glyph_index = 30}, /*Unicode: U+00a3 (£)*/
    {.w_px = 5,   .glyph_index = 40}, /*Unicode: U+00a4 (¤)*/
    {.w_px = 5,   .glyph_index = 60}, /*Unicode: U+00a5 (¥)*/
    {.w_px = 1,   .glyph_index = 80}, /*Unicode: U+00a6 (¦)*/
    {.w_px = 3,   .glyph_index = 90}, /*Unicode: U+00a7 (§)*/
    {.w_px = 3,   .glyph_index = 100},    /*Unicode: U+00a8 (¨)*/
    {.w_px = 6,   .glyph_index = 110},    /*Unicode: U+00a9 (©)*/
    {.w_px = 4,   .glyph_index = 130},    /*Unicode: U+00aa (ª)*/
    {.w_px = 4,   .glyph_index = 140},    /*Unicode: U+00ab («)*/
    {.w_px = 5,   .glyph_index = 150},    /*Unicode: U+00ac (¬)*/
    {.w_px = 2,   .glyph_index = 170},    /*Unicode: U+00ad (­)*/
    {.w_px = 6,   .glyph_index = 180},    /*Unicode: U+00ae (®)*/
    {.w_px = 2,   .glyph_index = 200},    /*Unicode: U+00af (¯)*/
    {.w_px = 2,   .glyph_index = 210},    /*Unicode: U+00b0 (°)*/
    {.w_px = 5,   .glyph_index = 220},    /*Unicode: U+00b1 (±)*/
    {.w_px = 3,   .glyph_index = 240},    /*Unicode: U+00b2 (²)*/
    {.w_px = 2,   .glyph_index = 250},    /*Unicode: U+00b3 (³)*/
    {.w_px = 2,   .glyph_index = 260},    /*Unicode: U+00b4 (´)*/
    {.w_px = 5,   .glyph_index = 270},    /*Unicode: U+00b5 (µ)*/
    {.w_px = 4,   .glyph_index = 290},    /*Unicode: U+00b6 (¶)*/
    {.w_px = 1,   .glyph_index = 300},    /*Unicode: U+00b7 (·)*/
    {.w_px = 2,   .glyph_index = 310},    /*Unicode: U+00b8 (¸)*/
    {.w_px = 3,   .glyph_index = 320},    /*Unicode: U+00b9 (¹)*/
    {.w_px = 3,   .glyph_index = 330},    /*Unicode: U+00ba (º)*/
    {.w_px = 4,   .glyph_index = 340},    /*Unicode: U+00bb (»)*/
    {.w_px = 8,   .glyph_index = 350},    /*Unicode: U+00bc (¼)*/
    {.w_px = 8,   .glyph_index = 370},    /*Unicode: U+00bd (½)*/
    {.w_px = 8,   .glyph_index = 390},    /*Unicode: U+00be (¾)*/
    {.w_px = 3,   .glyph_index = 410},    /*Unicode: U+00bf (¿)*/
    {.w_px = 5,   .glyph_index = 420},    /*Unicode: U+00c0 (À)*/
    {.w_px = 5,   .glyph_index = 440},    /*Unicode: U+00c1 (Á)*/
    {.w_px = 5,   .glyph_index = 460},    /*Unicode: U+00c2 (Â)*/
    {.w_px = 5,   .glyph_index = 480},    /*Unicode: U+00c3 (Ã)*/
    {.w_px = 5,   .glyph_index = 500},    /*Unicode: U+00c4 (Ä)*/
    {.w_px = 5,   .glyph_index = 520},    /*Unicode: U+00c5 (Å)*/
    {.w_px = 7,   .glyph_index = 540},    /*Unicode: U+00c6 (Æ)*/
    {.w_px = 5,   .glyph_index = 560},    /*Unicode: U+00c7 (Ç)*/
    {.w_px = 4,   .glyph_index = 580},    /*Unicode: U+00c8 (È)*/
    {.w_px = 4,   .glyph_index = 590},    /*Unicode: U+00c9 (É)*/
    {.w_px = 4,   .glyph_index = 600},    /*Unicode: U+00ca (Ê)*/
    {.w_px = 4,   .glyph_index = 610},    /*Unicode: U+00cb (Ë)*/
    {.w_px = 3,   .glyph_index = 620},    /*Unicode: U+00cc (Ì)*/
    {.w_px = 2,   .glyph_index = 630},    /*Unicode: U+00cd (Í)*/
    {.w_px = 3,   .glyph_index = 640},    /*Unicode: U+00ce (Î)*/
    {.w_px = 3,   .glyph_index = 650},    /*Unicode: U+00cf (Ï)*/
    {.w_px = 6,   .glyph_index = 660},    /*Unicode: U+00d0 (Ð)*/
    {.w_px = 4,   .glyph_index = 680},    /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 5,   .glyph_index = 690},    /*Unicode: U+00d2 (Ò)*/
    {.w_px = 5,   .glyph_index = 710},    /*Unicode: U+00d3 (Ó)*/
    {.w_px = 5,   .glyph_index = 730},    /*Unicode: U+00d4 (Ô)*/
    {.w_px = 5,   .glyph_index = 750},    /*Unicode: U+00d5 (Õ)*/
    {.w_px = 5,   .glyph_index = 770},    /*Unicode: U+00d6 (Ö)*/
    {.w_px = 5,   .glyph_index = 790},    /*Unicode: U+00d7 (×)*/
    {.w_px = 5,   .glyph_index = 810},    /*Unicode: U+00d8 (Ø)*/
    {.w_px = 4,   .glyph_index = 830},    /*Unicode: U+00d9 (Ù)*/
    {.w_px = 4,   .glyph_index = 840},    /*Unicode: U+00da (Ú)*/
    {.w_px = 4,   .glyph_index = 850},    /*Unicode: U+00db (Û)*/
    {.w_px = 4,   .glyph_index = 860},    /*Unicode: U+00dc (Ü)*/
    {.w_px = 5,   .glyph_index = 870},    /*Unicode: U+00dd (Ý)*/
    {.w_px = 4,   .glyph_index = 890},    /*Unicode: U+00de (Þ)*/
    {.w_px = 4,   .glyph_index = 900},    /*Unicode: U+00df (ß)*/
    {.w_px = 4,   .glyph_index = 910},    /*Unicode: U+00e0 (à)*/
    {.w_px = 4,   .glyph_index = 920},    /*Unicode: U+00e1 (á)*/
    {.w_px = 4,   .glyph_index = 930},    /*Unicode: U+00e2 (â)*/
    {.w_px = 4,   .glyph_index = 940},    /*Unicode: U+00e3 (ã)*/
    {.w_px = 4,   .glyph_index = 950},    /*Unicode: U+00e4 (ä)*/
    {.w_px = 4,   .glyph_index = 960},    /*Unicode: U+00e5 (å)*/
    {.w_px = 7,   .glyph_index = 970},    /*Unicode: U+00e6 (æ)*/
    {.w_px = 3,   .glyph_index = 990},    /*Unicode: U+00e7 (ç)*/
    {.w_px = 4,   .glyph_index = 1000},   /*Unicode: U+00e8 (è)*/
    {.w_px = 4,   .glyph_index = 1010},   /*Unicode: U+00e9 (é)*/
    {.w_px = 4,   .glyph_index = 1020},   /*Unicode: U+00ea (ê)*/
    {.w_px = 4,   .glyph_index = 1030},   /*Unicode: U+00eb (ë)*/
    {.w_px = 2,   .glyph_index = 1040},   /*Unicode: U+00ec (ì)*/
    {.w_px = 2,   .glyph_index = 1050},   /*Unicode: U+00ed (í)*/
    {.w_px = 3,   .glyph_index = 1060},   /*Unicode: U+00ee (î)*/
    {.w_px = 3,   .glyph_index = 1070},   /*Unicode: U+00ef (ï)*/
    {.w_px = 4,   .glyph_index = 1080},   /*Unicode: U+00f0 (ð)*/
    {.w_px = 4,   .glyph_index = 1090},   /*Unicode: U+00f1 (ñ)*/
    {.w_px = 4,   .glyph_index = 1100},   /*Unicode: U+00f2 (ò)*/
    {.w_px = 4,   .glyph_index = 1110},   /*Unicode: U+00f3 (ó)*/
    {.w_px = 4,   .glyph_index = 1120},   /*Unicode: U+00f4 (ô)*/
    {.w_px = 4,   .glyph_index = 1130},   /*Unicode: U+00f5 (õ)*/
    {.w_px = 4,   .glyph_index = 1140},   /*Unicode: U+00f6 (ö)*/
    {.w_px = 5,   .glyph_index = 1150},   /*Unicode: U+00f7 (÷)*/
    {.w_px = 6,   .glyph_index = 1170},   /*Unicode: U+00f8 (ø)*/
    {.w_px = 4,   .glyph_index = 1190},   /*Unicode: U+00f9 (ù)*/
    {.w_px = 4,   .glyph_index = 1200},   /*Unicode: U+00fa (ú)*/
    {.w_px = 4,   .glyph_index = 1210},   /*Unicode: U+00fb (û)*/
    {.w_px = 4,   .glyph_index = 1220},   /*Unicode: U+00fc (ü)*/
    {.w_px = 4,   .glyph_index = 1230},   /*Unicode: U+00fd (ý)*/
    {.w_px = 4,   .glyph_index = 1240},   /*Unicode: U+00fe (þ)*/
    {.w_px = 4,   .glyph_index = 1250},   /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 4
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 1,   .glyph_index = 20}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 3,   .glyph_index = 30}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 4,   .glyph_index = 50}, /*Unicode: U+00a3 (£)*/
    {.w_px = 5,   .glyph_index = 70}, /*Unicode: U+00a4 (¤)*/
    {.w_px = 5,   .glyph_index = 100},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 1,   .glyph_index = 130},    /*Unicode: U+00a6 (¦)*/
    {.w_px = 3,   .glyph_index = 140},    /*Unicode: U+00a7 (§)*/
    {.w_px = 3,   .glyph_index = 160},    /*Unicode: U+00a8 (¨)*/
    {.w_px = 6,   .glyph_index = 180},    /*Unicode: U+00a9 (©)*/
    {.w_px = 4,   .glyph_index = 210},    /*Unicode: U+00aa (ª)*/
    {.w_px = 4,   .glyph_index = 230},    /*Unicode: U+00ab («)*/
    {.w_px = 5,   .glyph_index = 250},    /*Unicode: U+00ac (¬)*/
    {.w_px = 2,   .glyph_index = 280},    /*Unicode: U+00ad (­)*/
    {.w_px = 6,   .glyph_index = 290},    /*Unicode: U+00ae (®)*/
    {.w_px = 2,   .glyph_index = 320},    /*Unicode: U+00af (¯)*/
    {.w_px = 2,   .glyph_index = 330},    /*Unicode: U+00b0 (°)*/
    {.w_px = 5,   .glyph_index = 340},    /*Unicode: U+00b1 (±)*/
    {.w_px = 3,   .glyph_index = 370},    /*Unicode: U+00b2 (²)*/
    {.w_px = 2,   .glyph_index = 390},    /*Unicode: U+00b3 (³)*/
    {.w_px = 2,   .glyph_index = 400},    /*Unicode: U+00b4 (´)*/
    {.w_px = 5,   .glyph_index = 410},    /*Unicode: U+00b5 (µ)*/
    {.w_px = 4,   .glyph_index = 440},    /*Unicode: U+00b6 (¶)*/
    {.w_px = 1,   .glyph_index = 460},    /*Unicode: U+00b7 (·)*/
    {.w_px = 2,   .glyph_index = 470},    /*Unicode: U+00b8 (¸)*/
    {.w_px = 3,   .glyph_index = 480},    /*Unicode: U+00b9 (¹)*/
    {.w_px = 3,   .glyph_index = 500},    /*Unicode: U+00ba (º)*/
    {.w_px = 4,   .glyph_index = 520},    /*Unicode: U+00bb (»)*/
    {.w_px = 8,   .glyph_index = 540},    /*Unicode: U+00bc (¼)*/
    {.w_px = 8,   .glyph_index = 580},    /*Unicode: U+00bd (½)*/
    {.w_px = 8,   .glyph_index = 620},    /*Unicode: U+00be (¾)*/
    {.w_px = 3,   .glyph_index = 660},    /*Unicode: U+00bf (¿)*/
    {.w_px = 5,   .glyph_index = 680},    /*Unicode: U+00c0 (À)*/
    {.w_px = 5,   .glyph_index = 710},    /*Unicode: U+00c1 (Á)*/
    {.w_px = 5,   .glyph_index = 740},    /*Unicode: U+00c2 (Â)*/
    {.w_px = 5,   .glyph_index = 770},    /*Unicode: U+00c3 (Ã)*/
    {.w_px = 5,   .glyph_index = 800},    /*Unicode: U+00c4 (Ä)*/
    {.w_px = 5,   .glyph_index = 830},    /*Unicode: U+00c5 (Å)*/
    {.w_px = 7,   .glyph_index = 860},    /*Unicode: U+00c6 (Æ)*/
    {.w_px = 5,   .glyph_index = 900},    /*Unicode: U+00c7 (Ç)*/
    {.w_px = 4,   .glyph_index = 930},    /*Unicode: U+00c8 (È)*/
    {.w_px = 4,   .glyph_index = 950},    /*Unicode: U+00c9 (É)*/
    {.w_px = 4,   .glyph_index = 970},    /*Unicode: U+00ca (Ê)*/
    {.w_px = 4,   .glyph_index = 990},    /*Unicode: U+00cb (Ë)*/
    {.w_px = 3,   .glyph_index = 1010},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 2,   .glyph_index = 1030},   /*Unicode: U+00cd (Í)*/
    {.w_px = 3,   .glyph_index = 1040},   /*Unicode: U+00ce (Î)*/
    {.w_px = 3,   .glyph_index = 1060},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 6,   .glyph_index = 1080},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 4,   .glyph_index = 1110},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 5,   .glyph_index = 1130},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 5,   .glyph_index = 1160},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 5,   .glyph_index = 1190},   /*Unicode: U+00d4 (Ô)*/
    {.w_px = 5,   .glyph_index = 1220},   /*Unicode: U+00d5 (Õ)*/
    {.w_px = 5,   .glyph_index = 1250},   /*Unicode: U+00d6 (Ö)*/
    {.w_px = 5,   .glyph_index = 1280},   /*Unicode: U+00d7 (×)*/
    {.w_px = 5,   .glyph_index = 1310},   /*Unicode: U+00d8 (Ø)*/
    {.w_px = 4,   .glyph_index = 1340},   /*Unicode: U+00d9 (Ù)*/
    {.w_px = 4,   .glyph_index = 1360},   /*Unicode: U+00da (Ú)*/
    {.w_px = 4,   .glyph_index = 1380},   /*Unicode: U+00db (Û)*/
    {.w_px = 4,   .glyph_index = 1400},   /*Unicode: U+00dc (Ü)*/
    {.w_px = 5,   .glyph_index = 1420},   /*Unicode: U+00dd (Ý)*/
    {.w_px = 4,   .glyph_index = 1450},   /*Unicode: U+00de (Þ)*/
    {.w_px = 4,   .glyph_index = 1470},   /*Unicode: U+00df (ß)*/
    {.w_px = 4,   .glyph_index = 1490},   /*Unicode: U+00e0 (à)*/
    {.w_px = 4,   .glyph_index = 1510},   /*Unicode: U+00e1 (á)*/
    {.w_px = 4,   .glyph_index = 1530},   /*Unicode: U+00e2 (â)*/
    {.w_px = 4,   .glyph_index = 1550},   /*Unicode: U+00e3 (ã)*/
    {.w_px = 4,   .glyph_index = 1570},   /*Unicode: U+00e4 (ä)*/
    {.w_px = 4,   .glyph_index = 1590},   /*Unicode: U+00e5 (å)*/
    {.w_px = 7,   .glyph_index = 1610},   /*Unicode: U+00e6 (æ)*/
    {.w_px = 3,   .glyph_index = 1650},   /*Unicode: U+00e7 (ç)*/
    {.w_px = 4,   .glyph_index = 1670},   /*Unicode: U+00e8 (è)*/
    {.w_px = 4,   .glyph_index = 1690},   /*Unicode: U+00e9 (é)*/
    {.w_px = 4,   .glyph_index = 1710},   /*Unicode: U+00ea (ê)*/
    {.w_px = 4,   .glyph_index = 1730},   /*Unicode: U+00eb (ë)*/
    {.w_px = 2,   .glyph_index = 1750},   /*Unicode: U+00ec (ì)*/
    {.w_px = 2,   .glyph_index = 1760},   /*Unicode: U+00ed (í)*/
    {.w_px = 3,   .glyph_index = 1770},   /*Unicode: U+00ee (î)*/
    {.w_px = 3,   .glyph_index = 1790},   /*Unicode: U+00ef (ï)*/
    {.w_px = 4,   .glyph_index = 1810},   /*Unicode: U+00f0 (ð)*/
    {.w_px = 4,   .glyph_index = 1830},   /*Unicode: U+00f1 (ñ)*/
    {.w_px = 4,   .glyph_index = 1850},   /*Unicode: U+00f2 (ò)*/
    {.w_px = 4,   .glyph_index = 1870},   /*Unicode: U+00f3 (ó)*/
    {.w_px = 4,   .glyph_index = 1890},   /*Unicode: U+00f4 (ô)*/
    {.w_px = 4,   .glyph_index = 1910},   /*Unicode: U+00f5 (õ)*/
    {.w_px = 4,   .glyph_index = 1930},   /*Unicode: U+00f6 (ö)*/
    {.w_px = 5,   .glyph_index = 1950},   /*Unicode: U+00f7 (÷)*/
    {.w_px = 6,   .glyph_index = 1980},   /*Unicode: U+00f8 (ø)*/
    {.w_px = 4,   .glyph_index = 2010},   /*Unicode: U+00f9 (ù)*/
    {.w_px = 4,   .glyph_index = 2030},   /*Unicode: U+00fa (ú)*/
    {.w_px = 4,   .glyph_index = 2050},   /*Unicode: U+00fb (û)*/
    {.w_px = 4,   .glyph_index = 2070},   /*Unicode: U+00fc (ü)*/
    {.w_px = 4,   .glyph_index = 2090},   /*Unicode: U+00fd (ý)*/
    {.w_px = 4,   .glyph_index = 2110},   /*Unicode: U+00fe (þ)*/
    {.w_px = 4,   .glyph_index = 2130},   /*Unicode: U+00ff (ÿ)*/

#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 8
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+00a0 ( )*/
    {.w_px = 1,   .glyph_index = 30}, /*Unicode: U+00a1 (¡)*/
    {.w_px = 3,   .glyph_index = 40}, /*Unicode: U+00a2 (¢)*/
    {.w_px = 4,   .glyph_index = 70}, /*Unicode: U+00a3 (£)*/
    {.w_px = 5,   .glyph_index = 110},    /*Unicode: U+00a4 (¤)*/
    {.w_px = 5,   .glyph_index = 160},    /*Unicode: U+00a5 (¥)*/
    {.w_px = 1,   .glyph_index = 210},    /*Unicode: U+00a6 (¦)*/
    {.w_px = 3,   .glyph_index = 220},    /*Unicode: U+00a7 (§)*/
    {.w_px = 3,   .glyph_index = 250},    /*Unicode: U+00a8 (¨)*/
    {.w_px = 6,   .glyph_index = 280},    /*Unicode: U+00a9 (©)*/
    {.w_px = 4,   .glyph_index = 340},    /*Unicode: U+00aa (ª)*/
    {.w_px = 4,   .glyph_index = 380},    /*Unicode: U+00ab («)*/
    {.w_px = 5,   .glyph_index = 420},    /*Unicode: U+00ac (¬)*/
    {.w_px = 2,   .glyph_index = 470},    /*Unicode: U+00ad (­)*/
    {.w_px = 6,   .glyph_index = 490},    /*Unicode: U+00ae (®)*/
    {.w_px = 2,   .glyph_index = 550},    /*Unicode: U+00af (¯)*/
    {.w_px = 2,   .glyph_index = 570},    /*Unicode: U+00b0 (°)*/
    {.w_px = 5,   .glyph_index = 590},    /*Unicode: U+00b1 (±)*/
    {.w_px = 3,   .glyph_index = 640},    /*Unicode: U+00b2 (²)*/
    {.w_px = 2,   .glyph_index = 670},    /*Unicode: U+00b3 (³)*/
    {.w_px = 2,   .glyph_index = 690},    /*Unicode: U+00b4 (´)*/
    {.w_px = 5,   .glyph_index = 710},    /*Unicode: U+00b5 (µ)*/
    {.w_px = 4,   .glyph_index = 760},    /*Unicode: U+00b6 (¶)*/
    {.w_px = 1,   .glyph_index = 800},    /*Unicode: U+00b7 (·)*/
    {.w_px = 2,   .glyph_index = 810},    /*Unicode: U+00b8 (¸)*/
    {.w_px = 3,   .glyph_index = 830},    /*Unicode: U+00b9 (¹)*/
    {.w_px = 3,   .glyph_index = 860},    /*Unicode: U+00ba (º)*/
    {.w_px = 4,   .glyph_index = 890},    /*Unicode: U+00bb (»)*/
    {.w_px = 8,   .glyph_index = 930},    /*Unicode: U+00bc (¼)*/
    {.w_px = 8,   .glyph_index = 1010},   /*Unicode: U+00bd (½)*/
    {.w_px = 8,   .glyph_index = 1090},   /*Unicode: U+00be (¾)*/
    {.w_px = 3,   .glyph_index = 1170},   /*Unicode: U+00bf (¿)*/
    {.w_px = 5,   .glyph_index = 1200},   /*Unicode: U+00c0 (À)*/
    {.w_px = 5,   .glyph_index = 1250},   /*Unicode: U+00c1 (Á)*/
    {.w_px = 5,   .glyph_index = 1300},   /*Unicode: U+00c2 (Â)*/
    {.w_px = 5,   .glyph_index = 1350},   /*Unicode: U+00c3 (Ã)*/
    {.w_px = 5,   .glyph_index = 1400},   /*Unicode: U+00c4 (Ä)*/
    {.w_px = 5,   .glyph_index = 1450},   /*Unicode: U+00c5 (Å)*/
    {.w_px = 7,   .glyph_index = 1500},   /*Unicode: U+00c6 (Æ)*/
    {.w_px = 5,   .glyph_index = 1570},   /*Unicode: U+00c7 (Ç)*/
    {.w_px = 4,   .glyph_index = 1620},   /*Unicode: U+00c8 (È)*/
    {.w_px = 4,   .glyph_index = 1660},   /*Unicode: U+00c9 (É)*/
    {.w_px = 4,   .glyph_index = 1700},   /*Unicode: U+00ca (Ê)*/
    {.w_px = 4,   .glyph_index = 1740},   /*Unicode: U+00cb (Ë)*/
    {.w_px = 3,   .glyph_index = 1780},   /*Unicode: U+00cc (Ì)*/
    {.w_px = 2,   .glyph_index = 1810},   /*Unicode: U+00cd (Í)*/
    {.w_px = 3,   .glyph_index = 1830},   /*Unicode: U+00ce (Î)*/
    {.w_px = 3,   .glyph_index = 1860},   /*Unicode: U+00cf (Ï)*/
    {.w_px = 6,   .glyph_index = 1890},   /*Unicode: U+00d0 (Ð)*/
    {.w_px = 4,   .glyph_index = 1950},   /*Unicode: U+00d1 (Ñ)*/
    {.w_px = 5,   .glyph_index = 1990},   /*Unicode: U+00d2 (Ò)*/
    {.w_px = 5,   .glyph_index = 2040},   /*Unicode: U+00d3 (Ó)*/
    {.w_px = 5,   .glyph_index = 2090},   /*Unicode: U+00d4 (Ô)*/
    {.w_px = 5,   .glyph_index = 2140},   /*Unicode: U+00d5 (Õ)*/
    {.w_px = 5,   .glyph_index = 2190},   /*Unicode: U+00d6 (Ö)*/
    {.w_px = 5,   .glyph_index = 2240},   /*Unicode: U+00d7 (×)*/
    {.w_px = 5,   .glyph_index = 2290},   /*Unicode: U+00d8 (Ø)*/
    {.w_px = 4,   .glyph_index = 2340},   /*Unicode: U+00d9 (Ù)*/
    {.w_px = 4,   .glyph_index = 2380},   /*Unicode: U+00da (Ú)*/
    {.w_px = 4,   .glyph_index = 2420},   /*Unicode: U+00db (Û)*/
    {.w_px = 4,   .glyph_index = 2460},   /*Unicode: U+00dc (Ü)*/
    {.w_px = 5,   .glyph_index = 2500},   /*Unicode: U+00dd (Ý)*/
    {.w_px = 4,   .glyph_index = 2550},   /*Unicode: U+00de (Þ)*/
    {.w_px = 4,   .glyph_index = 2590},   /*Unicode: U+00df (ß)*/
    {.w_px = 4,   .glyph_index = 2630},   /*Unicode: U+00e0 (à)*/
    {.w_px = 4,   .glyph_index = 2670},   /*Unicode: U+00e1 (á)*/
    {.w_px = 4,   .glyph_index = 2710},   /*Unicode: U+00e2 (â)*/
    {.w_px = 4,   .glyph_index = 2750},   /*Unicode: U+00e3 (ã)*/
    {.w_px = 4,   .glyph_index = 2790},   /*Unicode: U+00e4 (ä)*/
    {.w_px = 4,   .glyph_index = 2830},   /*Unicode: U+00e5 (å)*/
    {.w_px = 7,   .glyph_index = 2870},   /*Unicode: U+00e6 (æ)*/
    {.w_px = 3,   .glyph_index = 2940},   /*Unicode: U+00e7 (ç)*/
    {.w_px = 4,   .glyph_index = 2970},   /*Unicode: U+00e8 (è)*/
    {.w_px = 4,   .glyph_index = 3010},   /*Unicode: U+00e9 (é)*/
    {.w_px = 4,   .glyph_index = 3050},   /*Unicode: U+00ea (ê)*/
    {.w_px = 4,   .glyph_index = 3090},   /*Unicode: U+00eb (ë)*/
    {.w_px = 2,   .glyph_index = 3130},   /*Unicode: U+00ec (ì)*/
    {.w_px = 2,   .glyph_index = 3150},   /*Unicode: U+00ed (í)*/
    {.w_px = 3,   .glyph_index = 3170},   /*Unicode: U+00ee (î)*/
    {.w_px = 3,   .glyph_index = 3200},   /*Unicode: U+00ef (ï)*/
    {.w_px = 4,   .glyph_index = 3230},   /*Unicode: U+00f0 (ð)*/
    {.w_px = 4,   .glyph_index = 3270},   /*Unicode: U+00f1 (ñ)*/
    {.w_px = 4,   .glyph_index = 3310},   /*Unicode: U+00f2 (ò)*/
    {.w_px = 4,   .glyph_index = 3350},   /*Unicode: U+00f3 (ó)*/
    {.w_px = 4,   .glyph_index = 3390},   /*Unicode: U+00f4 (ô)*/
    {.w_px = 4,   .glyph_index = 3430},   /*Unicode: U+00f5 (õ)*/
    {.w_px = 4,   .glyph_index = 3470},   /*Unicode: U+00f6 (ö)*/
    {.w_px = 5,   .glyph_index = 3510},   /*Unicode: U+00f7 (÷)*/
    {.w_px = 6,   .glyph_index = 3560},   /*Unicode: U+00f8 (ø)*/
    {.w_px = 4,   .glyph_index = 3620},   /*Unicode: U+00f9 (ù)*/
    {.w_px = 4,   .glyph_index = 3660},   /*Unicode: U+00fa (ú)*/
    {.w_px = 4,   .glyph_index = 3700},   /*Unicode: U+00fb (û)*/
    {.w_px = 4,   .glyph_index = 3740},   /*Unicode: U+00fc (ü)*/
    {.w_px = 4,   .glyph_index = 3780},   /*Unicode: U+00fd (ý)*/
    {.w_px = 4,   .glyph_index = 3820},   /*Unicode: U+00fe (þ)*/
    {.w_px = 4,   .glyph_index = 3860},   /*Unicode: U+00ff (ÿ)*/

#endif
};

lv_font_t lv_font_dejavu_10_latin_sup = {
    .unicode_first = 160,   /*First Unicode letter in this font*/
    .unicode_last = 255,    /*Last Unicode letter in this font*/
    .h_px = 10,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_10_latin_sup_glyph_bitmap,   /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_10_latin_sup_glyph_dsc,     /*Description of glyphs*/
    .glyph_cnt = 96,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_10_LATIN_SUP == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10_LATIN_SUP == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_10_LATIN_SUP*/
