
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_10_CYRILLIC != 0 /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 10 px Font in U+0410 (А) .. U+044f (я)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_10_cyrillic_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_10_CYRILLIC == 1
    /*Unicode: U+0410 (А) , Width: 5 */
    0x00,  //.....
    0x20,  //..@..
    0x20,  //.+@+.
    0x70,  //.@%@.
    0x50,  //.@.@.
    0x70,  //+@@@+
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0411 (Б) , Width: 4 */
    0x00,  //....
    0xf0,  //@@@@
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@%
    0x90,  //@..@
    0xf0,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0412 (В) , Width: 4 */
    0x00,  //....
    0xe0,  //@@@+
    0x90,  //@..@
    0x90,  //@..@
    0xe0,  //@@@+
    0x90,  //@..@
    0xf0,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0413 (Г) , Width: 4 */
    0x00,  //....
    0xf0,  //@@@@
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0414 (Д) , Width: 5 */
    0x00,  //.....
    0x70,  //.@@@.
    0x50,  //.@.@.
    0x50,  //.@.@.
    0x50,  //.@.@.
    0x50,  //+%.@.
    0xf8,  //@@@@@
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0415 (Е) , Width: 4 */
    0x00,  //....
    0xf0,  //@@@@
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@@
    0x80,  //@...
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0416 (Ж) , Width: 9 */
    0x00, 0x00,  //.........
    0xc9, 0x80,  //+@..@..@+
    0x6b, 0x00,  //.%@.@.@%.
    0x3e, 0x00,  //..@@@@@..
    0x3e, 0x00,  //.+@%@%@+.
    0x49, 0x00,  //.@..@..@.
    0xc9, 0x80,  //%%..@..%%
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........
    0x00, 0x00,  //.........


    /*Unicode: U+0417 (З) , Width: 4 */
    0x00,  //....
    0x60,  //+@@+
    0x90,  //%..@
    0x60,  //.@@+
    0x10,  //...@
    0x10,  //+.+@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0418 (И) , Width: 4 */
    0x00,  //....
    0x90,  //@.+@
    0xb0,  //@.@@
    0xb0,  //@+%@
    0xd0,  //@@+@
    0xd0,  //@@.@
    0x90,  //@+.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0419 (Й) , Width: 4 */
    0x60,  //.%%.
    0x90,  //@.+@
    0xb0,  //@.@@
    0xb0,  //@+%@
    0xd0,  //@@+@
    0xd0,  //@@.@
    0x90,  //@+.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+041a (К) , Width: 5 */
    0x00,  //.....
    0x90,  //@..@+
    0xb0,  //@.@+.
    0xe0,  //@@@..
    0xe0,  //@%@+.
    0x90,  //@..@.
    0x98,  //@..%%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+041b (Л) , Width: 4 */
    0x00,  //....
    0x70,  //.@@@
    0x50,  //.@.@
    0x50,  //.@.@
    0x50,  //.@.@
    0x50,  //+%.@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+041c (М) , Width: 5 */
    0x00,  //.....
    0xd8,  //@@.@@
    0xd8,  //@@+@@
    0xf8,  //@%@+@
    0xa8,  //@.@.@
    0xa8,  //@.@.@
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+041d (Н) , Width: 4 */
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0xf0,  //@@@@
    0x90,  //@..@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+041e (О) , Width: 5 */
    0x00,  //.....
    0x70,  //.%@%.
    0xd8,  //%%.%%
    0x88,  //@...@
    0x88,  //@...@
    0xd8,  //%%.%%
    0x70,  //.%@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+041f (П) , Width: 4 */
    0x00,  //....
    0xf0,  //@@@@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0420 (Р) , Width: 4 */
    0x00,  //....
    0xe0,  //@@@+
    0x90,  //@..@
    0xe0,  //@@@+
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0421 (С) , Width: 5 */
    0x00,  //.....
    0x70,  //.%@@+
    0xc8,  //%%..%
    0x80,  //@....
    0x80,  //@....
    0xc8,  //%%..%
    0x70,  //.%@@+
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0422 (Т) , Width: 5 */
    0x00,  //.....
    0xf8,  //@@@@@
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0423 (У) , Width: 5 */
    0x00,  //.....
    0x88,  //%+.+@
    0x50,  //.@.%+
    0x70,  //.%%@.
    0x30,  //..@%.
    0x20,  //..@..
    0x60,  //.@%..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0424 (Ф) , Width: 5 */
    0x00,  //.....
    0x20,  //..@..
    0x70,  //+@@@+
    0xa8,  //@.@.@
    0xa8,  //@.@.@
    0x70,  //+@@@+
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0425 (Х) , Width: 5 */
    0x00,  //.....
    0xd8,  //%%.%%
    0x50,  //.@+@.
    0x20,  //.+@+.
    0x20,  //.+@+.
    0x50,  //.@+@.
    0x88,  //%+.+%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0426 (Ц) , Width: 5 */
    0x00,  //.....
    0x90,  //@..@.
    0x90,  //@..@.
    0x90,  //@..@.
    0x90,  //@..@.
    0x90,  //@..@.
    0xf8,  //@@@@@
    0x08,  //....@
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0427 (Ч) , Width: 4 */
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x70,  //+@@@
    0x10,  //...@
    0x10,  //...@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0428 (Ш) , Width: 7 */
    0x00,  //.......
    0x92,  //@..@..@
    0x92,  //@..@..@
    0x92,  //@..@..@
    0x92,  //@..@..@
    0x92,  //@..@..@
    0xfe,  //@@@@@@@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0429 (Щ) , Width: 8 */
    0x00,  //........
    0x92,  //@..@..@.
    0x92,  //@..@..@.
    0x92,  //@..@..@.
    0x92,  //@..@..@.
    0x92,  //@..@..@.
    0xff,  //@@@@@@@@
    0x01,  //.......@
    0x00,  //........
    0x00,  //........


    /*Unicode: U+042a (Ъ) , Width: 5 */
    0x00,  //.....
    0xc0,  //@@...
    0x40,  //.@...
    0x40,  //.@...
    0x78,  //.@@@%
    0x48,  //.@..@
    0x78,  //.@@@+
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+042b (Ы) , Width: 6 */
    0x00,  //......
    0x84,  //@....@
    0x84,  //@....@
    0x84,  //@....@
    0xf4,  //@@@%.@
    0x94,  //@..@.@
    0xf4,  //@@@+.@
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+042c (Ь) , Width: 4 */
    0x00,  //....
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@%
    0x90,  //@..@
    0xf0,  //@@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+042d (Э) , Width: 5 */
    0x00,  //.....
    0x70,  //+@@%.
    0x88,  //%..+%
    0x78,  //.@@@@
    0x08,  //....@
    0x98,  //%..%%
    0x70,  //+@@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+042e (Ю) , Width: 7 */
    0x00,  //.......
    0x9c,  //@..%@%.
    0xb6,  //@.%%.%%
    0xa2,  //@.@...@
    0xe2,  //@@@...@
    0xb6,  //@.@%.%%
    0x9c,  //@..@@%.
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+042f (Я) , Width: 4 */
    0x00,  //....
    0x70,  //+@@@
    0x90,  //@..@
    0x90,  //@..@
    0x70,  //.@@@
    0x50,  //.@.@
    0x90,  //%+.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0430 (а) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@%
    0x70,  //+@@@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0431 (б) , Width: 5 */
    0x38,  //..%@@
    0x60,  //.%%..
    0x40,  //.@...
    0x70,  //.@@@+
    0x48,  //.@..@
    0x48,  //.@..@
    0x30,  //.+@@+
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0432 (в) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xf0,  //@@@%
    0xf0,  //@@@%
    0x90,  //@..@
    0xf0,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0433 (г) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@@
    0x80,  //@..
    0x80,  //@..
    0x80,  //@..
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0434 (д) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x70,  //.@@@.
    0x50,  //.@.@.
    0x50,  //+%.@.
    0xf8,  //@@@@@
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0435 (е) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //+@@%
    0xf0,  //@@@@
    0x80,  //@+..
    0x70,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0436 (ж) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0x54,  //+@.@.@+
    0x7c,  //.%@@@%.
    0x7c,  //.@%@%@.
    0xd6,  //%%.@.%%
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0437 (з) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@@%
    0x60,  //.@%
    0x20,  //..@
    0xe0,  //@@%
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0438 (и) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xb0,  //@.%@
    0xb0,  //@+@@
    0xd0,  //@@.@
    0xd0,  //@%.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0439 (й) , Width: 4 */
    0x00,  //....
    0x60,  //.@@.
    0x60,  //.%%.
    0xb0,  //@.%@
    0xb0,  //@+@@
    0xd0,  //@@.@
    0xd0,  //@%.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043a (к) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xa0,  //@.@+
    0xe0,  //@@%.
    0xe0,  //@%@.
    0xb0,  //@.%%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043b (л) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@@
    0x50,  //.@.@
    0x50,  //+@.@
    0x90,  //@+.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043c (м) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xd8,  //@@.@@
    0xf8,  //@%@%@
    0xa8,  //@.@.@
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+043d (н) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x90,  //@..@
    0xf0,  //@@@@
    0x90,  //@..@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043e (о) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x60,  //+@@+
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043f (п) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xf0,  //@@@@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0440 (р) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xe0,  //@%@+
    0x90,  //@..@
    0x90,  //@..@
    0xe0,  //@%@+
    0x80,  //@...
    0x80,  //@...
    0x00,  //....


    /*Unicode: U+0441 (с) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x60,  //+@@
    0x80,  //@..
    0x80,  //@..
    0x60,  //+@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0442 (т) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf8,  //@@@@@
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0443 (у) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x90,  //@.+@
    0x60,  //+%@+
    0x60,  //.@@.
    0x40,  //.@+.
    0x40,  //.@..
    0x80,  //@+..
    0x00,  //....


    /*Unicode: U+0444 (ф) , Width: 5 */
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0xf8,  //%@@@%
    0xa8,  //@.@.@
    0xa8,  //@.@.@
    0xf8,  //%@@@%
    0x20,  //..@..
    0x20,  //..@..
    0x00,  //.....


    /*Unicode: U+0445 (х) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xf0,  //%%%%
    0x60,  //.@@.
    0x60,  //.@@.
    0xf0,  //%%%%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0446 (ц) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x90,  //@..@.
    0x90,  //@..@.
    0x90,  //@..@.
    0xf8,  //@@@@@
    0x08,  //....@
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0447 (ч) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xa0,  //@.@
    0xa0,  //@.@
    0xe0,  //%@@
    0x20,  //..@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0448 (ш) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xa8,  //@.@.@
    0xa8,  //@.@.@
    0xa8,  //@.@.@
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0449 (щ) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xa8,  //@.@.@.
    0xa8,  //@.@.@.
    0xa8,  //@.@.@.
    0xfc,  //@@@@@@
    0x04,  //.....@
    0x00,  //......
    0x00,  //......


    /*Unicode: U+044a (ъ) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xe0,  //@@@...
    0x3c,  //..@@@%
    0x24,  //..@..@
    0x3c,  //..@@@%
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+044b (ы) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x88,  //@...@
    0xf8,  //@@@%@
    0x98,  //@..@@
    0xf8,  //@@@%@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+044c (ь) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x80,  //@...
    0xf0,  //@@@%
    0x90,  //@..@
    0xf0,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+044d (э) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xc0,  //@@+
    0x60,  //.@@
    0x20,  //..@
    0xc0,  //@@+
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+044e (ю) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xb8,  //@.%@@+
    0xe4,  //@@@..@
    0xa4,  //@.@..@
    0x98,  //@.+@@+
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+044f (я) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //%@@
    0xa0,  //@.@
    0x60,  //.@@
    0xa0,  //%+@
    0x00,  //...
    0x00,  //...
    0x00,  //...



#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 2
    /*Unicode: U+0410 (А) , Width: 5 */
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x1d, 0x00,  //.+@+.
    0x3b, 0x00,  //.@%@.
    0x33, 0x00,  //.@.@.
    0x7f, 0x40,  //+@@@+
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0411 (Б) , Width: 4 */
    0x00,  //....
    0xff,  //@@@@
    0xc0,  //@...
    0xc0,  //@...
    0xfe,  //@@@%
    0xc3,  //@..@
    0xfe,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0412 (В) , Width: 4 */
    0x00,  //....
    0xfd,  //@@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0xfd,  //@@@+
    0xc3,  //@..@
    0xfe,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0413 (Г) , Width: 4 */
    0x00,  //....
    0xff,  //@@@@
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0414 (Д) , Width: 5 */
    0x00, 0x00,  //.....
    0x3f, 0x00,  //.@@@.
    0x33, 0x00,  //.@.@.
    0x33, 0x00,  //.@.@.
    0x33, 0x00,  //.@.@.
    0x63, 0x00,  //+%.@.
    0xff, 0xc0,  //@@@@@
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0415 (Е) , Width: 4 */
    0x00,  //....
    0xff,  //@@@@
    0xc0,  //@...
    0xc0,  //@...
    0xff,  //@@@@
    0xc0,  //@...
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0416 (Ж) , Width: 9 */
    0x00, 0x00, 0x00,  //.........
    0xb0, 0xc3, 0x80,  //+@..@..@+
    0x2c, 0xce, 0x00,  //.%@.@.@%.
    0x0f, 0xfc, 0x00,  //..@@@@@..
    0x1e, 0xed, 0x00,  //.+@%@%@+.
    0x30, 0xc3, 0x00,  //.@..@..@.
    0xa0, 0xc2, 0x80,  //%%..@..%%
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0417 (З) , Width: 4 */
    0x00,  //....
    0x7d,  //+@@+
    0x83,  //%..@
    0x3d,  //.@@+
    0x03,  //...@
    0x47,  //+.+@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0418 (И) , Width: 4 */
    0x00,  //....
    0xc7,  //@.+@
    0xcf,  //@.@@
    0xdb,  //@+%@
    0xf7,  //@@+@
    0xf3,  //@@.@
    0xd3,  //@+.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0419 (Й) , Width: 4 */
    0x28,  //.%%.
    0xc7,  //@.+@
    0xcf,  //@.@@
    0xdb,  //@+%@
    0xf7,  //@@+@
    0xf3,  //@@.@
    0xd3,  //@+.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+041a (К) , Width: 5 */
    0x00, 0x00,  //.....
    0xc3, 0x40,  //@..@+
    0xce, 0x00,  //@.@+.
    0xfc, 0x00,  //@@@..
    0xed, 0x00,  //@%@+.
    0xc3, 0x00,  //@..@.
    0xc2, 0x80,  //@..%%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+041b (Л) , Width: 4 */
    0x00,  //....
    0x3f,  //.@@@
    0x33,  //.@.@
    0x33,  //.@.@
    0x33,  //.@.@
    0x63,  //+%.@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+041c (М) , Width: 5 */
    0x00, 0x00,  //.....
    0xf3, 0xc0,  //@@.@@
    0xf7, 0xc0,  //@@+@@
    0xee, 0xc0,  //@%@+@
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+041d (Н) , Width: 4 */
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xff,  //@@@@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+041e (О) , Width: 5 */
    0x00, 0x00,  //.....
    0x2e, 0x00,  //.%@%.
    0xa2, 0x80,  //%%.%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xa2, 0x80,  //%%.%%
    0x2e, 0x00,  //.%@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+041f (П) , Width: 4 */
    0x00,  //....
    0xff,  //@@@@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0420 (Р) , Width: 4 */
    0x00,  //....
    0xfd,  //@@@+
    0xc3,  //@..@
    0xfd,  //@@@+
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0421 (С) , Width: 5 */
    0x00, 0x00,  //.....
    0x2f, 0x40,  //.%@@+
    0xa0, 0x80,  //%%..%
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0xa0, 0x80,  //%%..%
    0x2f, 0x40,  //.%@@+
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0422 (Т) , Width: 5 */
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0423 (У) , Width: 5 */
    0x00, 0x00,  //.....
    0x91, 0xc0,  //%+.+@
    0x32, 0x40,  //.@.%+
    0x2b, 0x00,  //.%%@.
    0x0e, 0x00,  //..@%.
    0x0c, 0x00,  //..@..
    0x38, 0x00,  //.@%..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0424 (Ф) , Width: 5 */
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x7f, 0x40,  //+@@@+
    0xcd, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0x7f, 0x40,  //+@@@+
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0425 (Х) , Width: 5 */
    0x00, 0x00,  //.....
    0xa2, 0x80,  //%%.%%
    0x37, 0x00,  //.@+@.
    0x1d, 0x00,  //.+@+.
    0x1d, 0x00,  //.+@+.
    0x37, 0x00,  //.@+@.
    0x91, 0x80,  //%+.+%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0426 (Ц) , Width: 5 */
    0x00, 0x00,  //.....
    0xc3, 0x00,  //@..@.
    0xc3, 0x00,  //@..@.
    0xc3, 0x00,  //@..@.
    0xc3, 0x00,  //@..@.
    0xc3, 0x00,  //@..@.
    0xff, 0xc0,  //@@@@@
    0x00, 0xc0,  //....@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0427 (Ч) , Width: 4 */
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0x7f,  //+@@@
    0x03,  //...@
    0x03,  //...@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0428 (Ш) , Width: 7 */
    0x00, 0x00,  //.......
    0xc3, 0x0c,  //@..@..@
    0xc3, 0x0c,  //@..@..@
    0xc3, 0x0c,  //@..@..@
    0xc3, 0x0c,  //@..@..@
    0xc3, 0x0c,  //@..@..@
    0xff, 0xfc,  //@@@@@@@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0429 (Щ) , Width: 8 */
    0x00, 0x00,  //........
    0xc3, 0x0c,  //@..@..@.
    0xc3, 0x0c,  //@..@..@.
    0xc3, 0x0c,  //@..@..@.
    0xc3, 0x0c,  //@..@..@.
    0xc3, 0x0c,  //@..@..@.
    0xff, 0xff,  //@@@@@@@@
    0x00, 0x03,  //.......@
    0x00, 0x00,  //........
    0x00, 0x00,  //........


    /*Unicode: U+042a (Ъ) , Width: 5 */
    0x00, 0x00,  //.....
    0xf0, 0x00,  //@@...
    0x30, 0x00,  //.@...
    0x30, 0x00,  //.@...
    0x3f, 0x80,  //.@@@%
    0x30, 0xc0,  //.@..@
    0x3f, 0x80,  //.@@@+
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+042b (Ы) , Width: 6 */
    0x00, 0x00,  //......
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xc0, 0x30,  //@....@
    0xfe, 0x30,  //@@@%.@
    0xc3, 0x30,  //@..@.@
    0xfe, 0x30,  //@@@+.@
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+042c (Ь) , Width: 4 */
    0x00,  //....
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xfe,  //@@@%
    0xc3,  //@..@
    0xfe,  //@@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+042d (Э) , Width: 5 */
    0x00, 0x00,  //.....
    0x7e, 0x00,  //+@@%.
    0x81, 0x80,  //%..+%
    0x3f, 0xc0,  //.@@@@
    0x00, 0xc0,  //....@
    0x82, 0x80,  //%..%%
    0x7e, 0x00,  //+@@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+042e (Ю) , Width: 7 */
    0x00, 0x00,  //.......
    0xc2, 0xe0,  //@..%@%.
    0xca, 0x28,  //@.%%.%%
    0xcc, 0x0c,  //@.@...@
    0xfc, 0x0c,  //@@@...@
    0xce, 0x28,  //@.@%.%%
    0xc3, 0xe0,  //@..@@%.
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+042f (Я) , Width: 4 */
    0x00,  //....
    0x7f,  //+@@@
    0xc3,  //@..@
    0xc3,  //@..@
    0x3f,  //.@@@
    0x33,  //.@.@
    0x93,  //%+.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0430 (а) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3e,  //.@@%
    0x7f,  //+@@@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0431 (б) , Width: 5 */
    0x0b, 0xc0,  //..%@@
    0x2c, 0x00,  //.%%..
    0x30, 0x00,  //.@...
    0x3f, 0x40,  //.@@@+
    0x30, 0xc0,  //.@..@
    0x30, 0xc0,  //.@..@
    0x1f, 0x40,  //.+@@+
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0432 (в) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xfe,  //@@@%
    0xfe,  //@@@%
    0xc3,  //@..@
    0xfe,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0433 (г) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xfc,  //@@@
    0xc0,  //@..
    0xc0,  //@..
    0xc0,  //@..
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0434 (д) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x3f, 0x00,  //.@@@.
    0x33, 0x00,  //.@.@.
    0x63, 0x00,  //+%.@.
    0xff, 0xc0,  //@@@@@
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0435 (е) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x7e,  //+@@%
    0xff,  //@@@@
    0xd0,  //@+..
    0x7f,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0436 (ж) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x73, 0x34,  //+@.@.@+
    0x2f, 0xe0,  //.%@@@%.
    0x3b, 0xb0,  //.@%@%@.
    0xa3, 0x28,  //%%.@.%%
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0437 (з) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xf8,  //@@%
    0x38,  //.@%
    0x0c,  //..@
    0xf8,  //@@%
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0438 (и) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xcb,  //@.%@
    0xdf,  //@+@@
    0xf3,  //@@.@
    0xe3,  //@%.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0439 (й) , Width: 4 */
    0x00,  //....
    0x3c,  //.@@.
    0x28,  //.%%.
    0xcb,  //@.%@
    0xdf,  //@+@@
    0xf3,  //@@.@
    0xe3,  //@%.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043a (к) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xcd,  //@.@+
    0xf8,  //@@%.
    0xec,  //@%@.
    0xca,  //@.%%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043b (л) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3f,  //.@@@
    0x33,  //.@.@
    0x73,  //+@.@
    0xd3,  //@+.@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043c (м) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xf3, 0xc0,  //@@.@@
    0xee, 0xc0,  //@%@%@
    0xcc, 0xc0,  //@.@.@
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+043d (н) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xc3,  //@..@
    0xff,  //@@@@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043e (о) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+043f (п) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xff,  //@@@@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0440 (р) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xed,  //@%@+
    0xc3,  //@..@
    0xc3,  //@..@
    0xed,  //@%@+
    0xc0,  //@...
    0xc0,  //@...
    0x00,  //....


    /*Unicode: U+0441 (с) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x7c,  //+@@
    0xc0,  //@..
    0xc0,  //@..
    0x7c,  //+@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0442 (т) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0443 (у) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xc7,  //@.+@
    0x6d,  //+%@+
    0x3c,  //.@@.
    0x34,  //.@+.
    0x30,  //.@..
    0xd0,  //@+..
    0x00,  //....


    /*Unicode: U+0444 (ф) , Width: 5 */
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0xbf, 0x80,  //%@@@%
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0xbf, 0x80,  //%@@@%
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....


    /*Unicode: U+0445 (х) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xaa,  //%%%%
    0x3c,  //.@@.
    0x3c,  //.@@.
    0xaa,  //%%%%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0446 (ц) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xc3, 0x00,  //@..@.
    0xc3, 0x00,  //@..@.
    0xc3, 0x00,  //@..@.
    0xff, 0xc0,  //@@@@@
    0x00, 0xc0,  //....@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0447 (ч) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xcc,  //@.@
    0xcc,  //@.@
    0xbc,  //%@@
    0x0c,  //..@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0448 (ш) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0449 (щ) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xcc, 0xc0,  //@.@.@.
    0xcc, 0xc0,  //@.@.@.
    0xcc, 0xc0,  //@.@.@.
    0xff, 0xf0,  //@@@@@@
    0x00, 0x30,  //.....@
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+044a (ъ) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xfc, 0x00,  //@@@...
    0x0f, 0xe0,  //..@@@%
    0x0c, 0x30,  //..@..@
    0x0f, 0xe0,  //..@@@%
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+044b (ы) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xc0, 0xc0,  //@...@
    0xfe, 0xc0,  //@@@%@
    0xc3, 0xc0,  //@..@@
    0xfe, 0xc0,  //@@@%@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+044c (ь) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xc0,  //@...
    0xfe,  //@@@%
    0xc3,  //@..@
    0xfe,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+044d (э) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xf4,  //@@+
    0x3c,  //.@@
    0x0c,  //..@
    0xf4,  //@@+
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+044e (ю) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xcb, 0xd0,  //@.%@@+
    0xfc, 0x30,  //@@@..@
    0xcc, 0x30,  //@.@..@
    0xc7, 0xd0,  //@.+@@+
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+044f (я) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xbc,  //%@@
    0xcc,  //@.@
    0x3c,  //.@@
    0x9c,  //%+@
    0x00,  //...
    0x00,  //...
    0x00,  //...



#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 4
    /*Unicode: U+0410 (А) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x01, 0xf1, 0x00,  //..@..
    0x07, 0xf6, 0x00,  //.+@+.
    0x0c, 0x8c, 0x00,  //.@%@.
    0x2e, 0x0e, 0x20,  //.@.@.
    0x7f, 0xff, 0x70,  //+@@@+
    0xd3, 0x03, 0xd0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0411 (Б) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xf8,  //@@@%
    0xf0, 0x2f,  //@..@
    0xff, 0xf8,  //@@@%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0412 (В) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xe6,  //@@@+
    0xf0, 0x2e,  //@..@
    0xf0, 0x2d,  //@..@
    0xff, 0xf6,  //@@@+
    0xf0, 0x3e,  //@..@
    0xff, 0xf8,  //@@@%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0413 (Г) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0414 (Д) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0x00,  //.@@@.
    0x0f, 0x0f, 0x00,  //.@.@.
    0x0f, 0x0f, 0x00,  //.@.@.
    0x2d, 0x0f, 0x00,  //.@.@.
    0x68, 0x0f, 0x00,  //+%.@.
    0xff, 0xff, 0xf0,  //@@@@@
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0415 (Е) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0416 (Ж) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x8d, 0x10, 0xf0, 0x1d, 0x80,  //+@..@..@+
    0x08, 0xd1, 0xf1, 0xd8, 0x00,  //.%@.@.@%.
    0x00, 0xdc, 0xfd, 0xd0, 0x00,  //..@@@@@..
    0x06, 0xc8, 0xf8, 0xc6, 0x00,  //.+@%@%@+.
    0x1e, 0x20, 0xf0, 0x2e, 0x10,  //.@..@..@.
    0xa8, 0x00, 0xf0, 0x08, 0xa0,  //%%..@..%%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0417 (З) , Width: 4 */
    0x00, 0x00,  //....
    0x6e, 0xe6,  //+@@+
    0x80, 0x3f,  //%..@
    0x0f, 0xf7,  //.@@+
    0x00, 0x3c,  //...@
    0x70, 0x4e,  //+.+@
    0x7e, 0xd5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0418 (И) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x7f,  //@.+@
    0xf0, 0xef,  //@.@@
    0xf7, 0xbf,  //@+%@
    0xfe, 0x4f,  //@@+@
    0xfd, 0x0f,  //@@.@
    0xf6, 0x0f,  //@+.@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0419 (Й) , Width: 4 */
    0x0a, 0x90,  //.%%.
    0xf0, 0x7f,  //@.+@
    0xf0, 0xef,  //@.@@
    0xf7, 0xbf,  //@+%@
    0xfe, 0x4f,  //@@+@
    0xfd, 0x0f,  //@@.@
    0xf6, 0x0f,  //@+.@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+041a (К) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x1d, 0x70,  //@..@+
    0xf1, 0xd8, 0x00,  //@.@+.
    0xfd, 0xd0, 0x00,  //@@@..
    0xf8, 0xc5, 0x00,  //@%@+.
    0xf0, 0x2e, 0x10,  //@..@.
    0xf0, 0x08, 0xa0,  //@..%%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+041b (Л) , Width: 4 */
    0x00, 0x00,  //....
    0x0f, 0xff,  //.@@@
    0x0f, 0x0f,  //.@.@
    0x0f, 0x0f,  //.@.@
    0x1e, 0x0f,  //.@.@
    0x7b, 0x0f,  //+%.@
    0xc2, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+041c (М) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xfe, 0x0e, 0xf0,  //@@.@@
    0xfc, 0x7c, 0xf0,  //@@+@@
    0xf8, 0xf8, 0xf0,  //@%@+@
    0xf3, 0xf3, 0xf0,  //@.@.@
    0xf0, 0xd0, 0xf0,  //@.@.@
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+041d (Н) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xff, 0xff,  //@@@@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+041e (О) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x1b, 0xfb, 0x10,  //.%@%.
    0xa8, 0x08, 0xa0,  //%%.%%
    0xe1, 0x01, 0xe0,  //@...@
    0xe0, 0x01, 0xe0,  //@...@
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1b, 0xfb, 0x10,  //.%@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+041f (П) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0420 (Р) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xe7,  //@@@+
    0xf0, 0x3f,  //@..@
    0xff, 0xe7,  //@@@+
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0421 (С) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x09, 0xee, 0x60,  //.%@@+
    0x9a, 0x10, 0x80,  //%%..%
    0xe1, 0x00, 0x00,  //@....
    0xe1, 0x00, 0x00,  //@....
    0x9a, 0x10, 0x80,  //%%..%
    0x09, 0xee, 0x60,  //.%@@+
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0422 (Т) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0423 (У) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xb6, 0x04, 0xc0,  //%+.+@
    0x3e, 0x0b, 0x50,  //.@.%+
    0x0a, 0x9e, 0x00,  //.%%@.
    0x02, 0xf8, 0x00,  //..@%.
    0x00, 0xe2, 0x00,  //..@..
    0x0f, 0x90, 0x00,  //.@%..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0424 (Ф) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0xf0, 0x00,  //..@..
    0x5e, 0xfe, 0x50,  //+@@@+
    0xe3, 0xf4, 0xe0,  //@.@.@
    0xe3, 0xf2, 0xe0,  //@.@.@
    0x5e, 0xfe, 0x50,  //+@@@+
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0425 (Х) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1e, 0x5e, 0x10,  //.@+@.
    0x06, 0xf6, 0x00,  //.+@+.
    0x06, 0xf6, 0x00,  //.+@+.
    0x1e, 0x4e, 0x10,  //.@+@.
    0xa7, 0x07, 0xa0,  //%+.+%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0426 (Ц) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x0f, 0x00,  //@..@.
    0xf0, 0x0f, 0x00,  //@..@.
    0xf0, 0x0f, 0x00,  //@..@.
    0xf0, 0x0f, 0x00,  //@..@.
    0xf0, 0x0f, 0x00,  //@..@.
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0427 (Ч) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xe2, 0x0f,  //@..@
    0x7f, 0xff,  //+@@@
    0x00, 0x0f,  //...@
    0x00, 0x0f,  //...@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0428 (Ш) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@
    0xff, 0xff, 0xff, 0xf0,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0429 (Щ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00,  //........
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@.
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@.
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@.
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@.
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@.
    0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x0f,  //.......@
    0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+042a (Ъ) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00,  //@@...
    0x0f, 0x00, 0x00,  //.@...
    0x0f, 0x00, 0x00,  //.@...
    0x0f, 0xff, 0x80,  //.@@@%
    0x0f, 0x01, 0xf0,  //.@..@
    0x0f, 0xff, 0x80,  //.@@@+
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+042b (Ы) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xf0, 0x00, 0x0f,  //@....@
    0xff, 0xf8, 0x0f,  //@@@%.@
    0xf0, 0x2f, 0x0f,  //@..@.@
    0xff, 0xf8, 0x0f,  //@@@+.@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+042c (Ь) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xf8,  //@@@%
    0xf0, 0x2f,  //@..@
    0xff, 0xf8,  //@@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+042d (Э) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x6e, 0xe9, 0x00,  //+@@%.
    0x91, 0x06, 0x90,  //%..+%
    0x0f, 0xff, 0xe0,  //.@@@@
    0x00, 0x01, 0xe0,  //....@
    0x91, 0x1a, 0x90,  //%..%%
    0x6e, 0xe9, 0x00,  //+@@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+042e (Ю) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0xf0, 0x1b, 0xfb, 0x10,  //@..%@%.
    0xf0, 0x98, 0x08, 0xa0,  //@.%%.%%
    0xf0, 0xe0, 0x01, 0xe0,  //@.@...@
    0xff, 0xf0, 0x01, 0xe0,  //@@@...@
    0xf0, 0xd8, 0x08, 0xa0,  //@.@%.%%
    0xf0, 0x3c, 0xfb, 0x10,  //@..@@%.
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+042f (Я) , Width: 4 */
    0x00, 0x00,  //....
    0x7e, 0xff,  //+@@@
    0xf2, 0x0f,  //@..@
    0xc3, 0x0f,  //@..@
    0x0d, 0xff,  //.@@@
    0x3e, 0x0f,  //.@.@
    0xb6, 0x0f,  //%+.@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0430 (а) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xf9,  //.@@%
    0x7e, 0xff,  //+@@@
    0xf3, 0x3f,  //@..@
    0x9f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0431 (б) , Width: 5 */
    0x00, 0xae, 0xf0,  //..%@@
    0x0a, 0xc2, 0x00,  //.%%..
    0x0f, 0x20, 0x00,  //.@...
    0x0f, 0xde, 0x60,  //.@@@+
    0x0f, 0x33, 0xe0,  //.@..@
    0x0e, 0x33, 0xe0,  //.@..@
    0x05, 0xee, 0x50,  //.+@@+
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0432 (в) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xff, 0xfa,  //@@@%
    0xff, 0xfb,  //@@@%
    0xf0, 0x2e,  //@..@
    0xff, 0xf9,  //@@@%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0433 (г) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0434 (д) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x0f, 0xff, 0x00,  //.@@@.
    0x0f, 0x0f, 0x00,  //.@.@.
    0x5b, 0x0f, 0x00,  //+%.@.
    0xff, 0xff, 0xf0,  //@@@@@
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0435 (е) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x5e, 0xf8,  //+@@%
    0xef, 0xff,  //@@@@
    0xe4, 0x00,  //@+..
    0x4d, 0xff,  //+@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0436 (ж) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x7d, 0x2f, 0x2d, 0x70,  //+@.@.@+
    0x08, 0xef, 0xe8, 0x00,  //.%@@@%.
    0x0e, 0x8f, 0x8e, 0x00,  //.@%@%@.
    0xa9, 0x0f, 0x09, 0xa0,  //%%.@.%%
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0437 (з) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xff, 0xa0,  //@@%
    0x0f, 0xa0,  //.@%
    0x03, 0xd0,  //..@
    0xff, 0x90,  //@@%
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0438 (и) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xf0, 0x9f,  //@.%@
    0xf6, 0xdf,  //@+@@
    0xff, 0x3f,  //@@.@
    0xf8, 0x0f,  //@%.@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0439 (й) , Width: 4 */
    0x00, 0x00,  //....
    0x0f, 0xf0,  //.@@.
    0x0a, 0xa0,  //.%%.
    0xf0, 0x9f,  //@.%@
    0xf6, 0xdf,  //@+@@
    0xff, 0x3f,  //@@.@
    0xf8, 0x0f,  //@%.@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+043a (к) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xf2, 0xd7,  //@.@+
    0xfe, 0x80,  //@@%.
    0xf8, 0xe0,  //@%@.
    0xf0, 0x9a,  //@.%%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+043b (л) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xff,  //.@@@
    0x0f, 0x0f,  //.@.@
    0x5d, 0x0f,  //+@.@
    0xe5, 0x0f,  //@+.@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+043c (м) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xfe, 0x2e, 0xf0,  //@@.@@
    0xf9, 0xe9, 0xf0,  //@%@%@
    0xf1, 0xf1, 0xf0,  //@.@.@
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+043d (н) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xff, 0xff,  //@@@@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+043e (о) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x5e, 0xe5,  //+@@+
    0xe3, 0x3e,  //@..@
    0xe3, 0x3e,  //@..@
    0x5e, 0xe5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+043f (п) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0440 (р) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xfa, 0xf6,  //@%@+
    0xf3, 0x3e,  //@..@
    0xf3, 0x3e,  //@..@
    0xfa, 0xf6,  //@%@+
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0x00, 0x00,  //....


    /*Unicode: U+0441 (с) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x6e, 0xf0,  //+@@
    0xe3, 0x00,  //@..
    0xe3, 0x00,  //@..
    0x6e, 0xf0,  //+@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0442 (т) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0443 (у) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xd3, 0x5c,  //@.+@
    0x79, 0xc5,  //+%@+
    0x1f, 0xd0,  //.@@.
    0x0d, 0x60,  //.@+.
    0x0e, 0x00,  //.@..
    0xf7, 0x00,  //@+..
    0x00, 0x00,  //....


    /*Unicode: U+0444 (ф) , Width: 5 */
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x8c, 0xfc, 0x80,  //%@@@%
    0xf2, 0xf2, 0xe0,  //@.@.@
    0xf2, 0xf2, 0xf0,  //@.@.@
    0x8c, 0xfd, 0x80,  //%@@@%
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0445 (х) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x9a, 0xa9,  //%%%%
    0x0c, 0xc0,  //.@@.
    0x0d, 0xc0,  //.@@.
    0xa9, 0xa9,  //%%%%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0446 (ц) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x0f, 0x00,  //@..@.
    0xf0, 0x0f, 0x00,  //@..@.
    0xf0, 0x0f, 0x00,  //@..@.
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0xf0,  //....@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0447 (ч) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xf0, 0xf0,  //@.@
    0xf1, 0xf0,  //@.@
    0xaf, 0xf0,  //%@@
    0x00, 0xf0,  //..@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0448 (ш) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xf0, 0xf0, 0xf0,  //@.@.@
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0449 (щ) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xf0, 0xf0, 0xf0,  //@.@.@.
    0xf0, 0xf0, 0xf0,  //@.@.@.
    0xf0, 0xf0, 0xf0,  //@.@.@.
    0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x0f,  //.....@
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+044a (ъ) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xff, 0xf0, 0x00,  //@@@...
    0x00, 0xff, 0xf8,  //..@@@%
    0x00, 0xf0, 0x3f,  //..@..@
    0x00, 0xff, 0xf8,  //..@@@%
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+044b (ы) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x00, 0xf0,  //@...@
    0xff, 0xf8, 0xf0,  //@@@%@
    0xf0, 0x3f, 0xf0,  //@..@@
    0xff, 0xf8, 0xf0,  //@@@%@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+044c (ь) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xf0, 0x00,  //@...
    0xff, 0xf8,  //@@@%
    0xf0, 0x3f,  //@..@
    0xff, 0xf8,  //@@@%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+044d (э) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xfe, 0x50,  //@@+
    0x0f, 0xe0,  //.@@
    0x03, 0xe0,  //..@
    0xfe, 0x60,  //@@+
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+044e (ю) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xf0, 0x9f, 0xe5,  //@.%@@+
    0xff, 0xf3, 0x3e,  //@@@..@
    0xf0, 0xe3, 0x3e,  //@.@..@
    0xf0, 0x5e, 0xe5,  //@.+@@+
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+044f (я) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xbf, 0xf0,  //%@@
    0xe2, 0xf0,  //@.@
    0x2f, 0xf0,  //.@@
    0xb7, 0xf0,  //%+@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...



#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 8
    /*Unicode: U+0410 (А) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x18, 0xfa, 0x18, 0x00,  //..@..
    0x00, 0x70, 0xfc, 0x6e, 0x00,  //.+@+.
    0x00, 0xc8, 0x8a, 0xc8, 0x00,  //.@%@.
    0x22, 0xe6, 0x06, 0xe6, 0x20,  //.@.@.
    0x7a, 0xff, 0xff, 0xff, 0x78,  //+@@@+
    0xd2, 0x38, 0x00, 0x38, 0xd2,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0411 (Б) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xf4, 0x86,  //@@@%
    0xff, 0x00, 0x2e, 0xf2,  //@..@
    0xff, 0xff, 0xf0, 0x82,  //@@@%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0412 (В) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xec, 0x6a,  //@@@+
    0xff, 0x00, 0x2e, 0xee,  //@..@
    0xff, 0x00, 0x2e, 0xdc,  //@..@
    0xff, 0xff, 0xfc, 0x64,  //@@@+
    0xff, 0x00, 0x30, 0xee,  //@..@
    0xff, 0xff, 0xf4, 0x8e,  //@@@%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0413 (Г) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0414 (Д) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x02, 0xff, 0x00, 0xff, 0x00,  //.@.@.
    0x0c, 0xf0, 0x00, 0xff, 0x00,  //.@.@.
    0x28, 0xd4, 0x00, 0xff, 0x00,  //.@.@.
    0x68, 0x8e, 0x00, 0xff, 0x00,  //+%.@.
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0415 (Е) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0416 (Ж) , Width: 9 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x80, 0xd2, 0x14, 0x00, 0xff, 0x00, 0x14, 0xd2, 0x80,  //+@..@..@+
    0x00, 0x84, 0xd0, 0x12, 0xff, 0x12, 0xd0, 0x82, 0x00,  //.%@.@.@%.
    0x00, 0x00, 0xd8, 0xce, 0xff, 0xd0, 0xd8, 0x00, 0x00,  //..@@@@@..
    0x00, 0x60, 0xca, 0x86, 0xff, 0x86, 0xca, 0x60, 0x00,  //.+@%@%@+.
    0x16, 0xe8, 0x2c, 0x00, 0xff, 0x00, 0x2e, 0xe8, 0x16,  //.@..@..@.
    0xac, 0x82, 0x00, 0x00, 0xff, 0x00, 0x00, 0x82, 0xac,  //%%..@..%%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.........


    /*Unicode: U+0417 (З) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x66, 0xe6, 0xe4, 0x6a,  //+@@+
    0x82, 0x06, 0x3a, 0xf0,  //%..@
    0x00, 0xff, 0xff, 0x72,  //.@@+
    0x00, 0x00, 0x3e, 0xce,  //...@
    0x7a, 0x0a, 0x42, 0xec,  //+.+@
    0x76, 0xee, 0xdc, 0x52,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0418 (И) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x72, 0xff,  //@.+@
    0xff, 0x0a, 0xe6, 0xff,  //@.@@
    0xff, 0x74, 0xb2, 0xff,  //@+%@
    0xff, 0xe8, 0x44, 0xff,  //@@+@
    0xff, 0xd4, 0x00, 0xff,  //@@.@
    0xff, 0x68, 0x00, 0xff,  //@+.@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0419 (Й) , Width: 4 */
    0x00, 0xa0, 0x9e, 0x00,  //.%%.
    0xff, 0x00, 0x72, 0xff,  //@.+@
    0xff, 0x0a, 0xe6, 0xff,  //@.@@
    0xff, 0x74, 0xb2, 0xff,  //@+%@
    0xff, 0xe8, 0x44, 0xff,  //@@+@
    0xff, 0xd4, 0x00, 0xff,  //@@.@
    0xff, 0x68, 0x00, 0xff,  //@+.@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+041a (К) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x14, 0xd2, 0x7e,  //@..@+
    0xff, 0x12, 0xd0, 0x80, 0x00,  //@.@+.
    0xff, 0xd0, 0xd4, 0x00, 0x00,  //@@@..
    0xff, 0x86, 0xca, 0x5e, 0x00,  //@%@+.
    0xff, 0x00, 0x2e, 0xe6, 0x16,  //@..@.
    0xff, 0x00, 0x00, 0x82, 0xaa,  //@..%%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+041b (Л) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x00, 0xff, 0x00, 0xff,  //.@.@
    0x08, 0xf8, 0x00, 0xff,  //.@.@
    0x1e, 0xe6, 0x00, 0xff,  //.@.@
    0x72, 0xb6, 0x00, 0xff,  //+%.@
    0xce, 0x2a, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+041c (М) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xee, 0x08, 0xee, 0xff,  //@@.@@
    0xff, 0xca, 0x7c, 0xc8, 0xff,  //@@+@@
    0xff, 0x82, 0xf2, 0x80, 0xff,  //@%@+@
    0xff, 0x3a, 0xff, 0x3a, 0xff,  //@.@.@
    0xff, 0x02, 0xde, 0x02, 0xff,  //@.@.@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+041d (Н) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+041e (О) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x1a, 0xba, 0xf2, 0xba, 0x18,  //.%@%.
    0xac, 0x86, 0x0c, 0x86, 0xaa,  //%%.%%
    0xee, 0x10, 0x00, 0x10, 0xec,  //@...@
    0xee, 0x0e, 0x00, 0x10, 0xec,  //@...@
    0xac, 0x84, 0x0c, 0x84, 0xaa,  //%%.%%
    0x1a, 0xbc, 0xf2, 0xba, 0x1a,  //.%@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+041f (П) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0420 (Р) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xec, 0x7a,  //@@@+
    0xff, 0x00, 0x3e, 0xf0,  //@..@
    0xff, 0xff, 0xee, 0x7e,  //@@@+
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0421 (С) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x0c, 0x9a, 0xe8, 0xea, 0x6e,  //.%@@+
    0x9c, 0xa4, 0x18, 0x0e, 0x88,  //%%..%
    0xea, 0x14, 0x00, 0x00, 0x00,  //@....
    0xea, 0x14, 0x00, 0x00, 0x00,  //@....
    0x9e, 0xa2, 0x16, 0x0e, 0x88,  //%%..%
    0x0e, 0x9c, 0xea, 0xea, 0x6e,  //.%@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0422 (Т) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0423 (У) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xbc, 0x64, 0x00, 0x4c, 0xc8,  //%+.+@
    0x36, 0xe0, 0x06, 0xb4, 0x5e,  //.@.%+
    0x00, 0xae, 0x90, 0xe8, 0x06,  //.%%@.
    0x00, 0x2a, 0xfc, 0x8a, 0x00,  //..@%.
    0x00, 0x08, 0xe0, 0x20, 0x00,  //..@..
    0x00, 0xf6, 0x94, 0x00, 0x00,  //.@%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0424 (Ф) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x50, 0xe0, 0xff, 0xe0, 0x52,  //+@@@+
    0xe6, 0x3e, 0xff, 0x40, 0xe8,  //@.@.@
    0xe8, 0x30, 0xff, 0x2c, 0xe8,  //@.@.@
    0x54, 0xe0, 0xff, 0xe0, 0x54,  //+@@@+
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0425 (Х) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xac, 0x84, 0x00, 0x84, 0xac,  //%%.%%
    0x18, 0xea, 0x58, 0xe8, 0x18,  //.@+@.
    0x00, 0x66, 0xff, 0x64, 0x00,  //.+@+.
    0x00, 0x6a, 0xfc, 0x6c, 0x00,  //.+@+.
    0x1a, 0xe6, 0x4c, 0xea, 0x1a,  //.@+@.
    0xae, 0x74, 0x00, 0x7c, 0xae,  //%+.+%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0426 (Ц) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0427 (Ч) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xea, 0x2e, 0x00, 0xff,  //@..@
    0x78, 0xf8, 0xff, 0xff,  //+@@@
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0428 (Ш) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@..@..@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@..@..@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@..@..@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@..@..@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@..@..@
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0429 (Щ) , Width: 8 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //@..@..@.
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //@..@..@.
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //@..@..@.
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //@..@..@.
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00,  //@..@..@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //.......@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //........


    /*Unicode: U+042a (Ъ) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0x00, 0x00, 0x00,  //@@...
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0x00, 0xff, 0x00, 0x00, 0x00,  //.@...
    0x00, 0xff, 0xff, 0xf4, 0x86,  //.@@@%
    0x00, 0xff, 0x00, 0x1c, 0xf2,  //.@..@
    0x00, 0xff, 0xff, 0xf0, 0x80,  //.@@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+042b (Ы) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0x00, 0x00, 0x00, 0x00, 0xff,  //@....@
    0xff, 0xff, 0xf4, 0x86, 0x00, 0xff,  //@@@%.@
    0xff, 0x00, 0x2e, 0xf2, 0x00, 0xff,  //@..@.@
    0xff, 0xff, 0xf0, 0x80, 0x00, 0xff,  //@@@+.@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+042c (Ь) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xf4, 0x86,  //@@@%
    0xff, 0x00, 0x2e, 0xf2,  //@..@
    0xff, 0xff, 0xf0, 0x80,  //@@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+042d (Э) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x66, 0xe0, 0xe8, 0x9a, 0x0c,  //+@@%.
    0x94, 0x18, 0x0c, 0x68, 0x9c,  //%..+%
    0x00, 0xff, 0xff, 0xff, 0xea,  //.@@@@
    0x00, 0x00, 0x00, 0x1e, 0xea,  //....@
    0x94, 0x18, 0x18, 0xae, 0x9c,  //%..%%
    0x64, 0xe0, 0xea, 0x9c, 0x0e,  //+@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+042e (Ю) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0x00, 0x10, 0xb4, 0xf0, 0xba, 0x18,  //@..%@%.
    0xff, 0x00, 0x9a, 0x84, 0x0c, 0x84, 0xaa,  //@.%%.%%
    0xff, 0x00, 0xe8, 0x0e, 0x00, 0x10, 0xec,  //@.@...@
    0xff, 0xff, 0xff, 0x0e, 0x00, 0x10, 0xec,  //@@@...@
    0xff, 0x00, 0xd8, 0x84, 0x0c, 0x84, 0xaa,  //@.@%.%%
    0xff, 0x00, 0x34, 0xcc, 0xf4, 0xba, 0x1a,  //@..@@%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+042f (Я) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x70, 0xec, 0xff, 0xff,  //+@@@
    0xf0, 0x2c, 0x00, 0xff,  //@..@
    0xc6, 0x34, 0x00, 0xff,  //@..@
    0x08, 0xd0, 0xff, 0xff,  //.@@@
    0x34, 0xe2, 0x06, 0xff,  //.@.@
    0xba, 0x66, 0x00, 0xff,  //%+.@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0430 (а) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xf6, 0x92,  //.@@%
    0x7a, 0xec, 0xff, 0xfa,  //+@@@
    0xf2, 0x38, 0x3e, 0xff,  //@..@
    0x96, 0xf0, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0431 (б) , Width: 5 */
    0x00, 0x0c, 0xa0, 0xec, 0xf6,  //..%@@
    0x00, 0xa2, 0xc0, 0x2c, 0x04,  //.%%..
    0x00, 0xf6, 0x20, 0x00, 0x00,  //.@...
    0x08, 0xf8, 0xd8, 0xee, 0x60,  //.@@@+
    0x02, 0xff, 0x32, 0x34, 0xea,  //.@..@
    0x00, 0xe8, 0x32, 0x32, 0xe8,  //.@..@
    0x00, 0x5c, 0xea, 0xe8, 0x5a,  //.+@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0432 (в) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xf4, 0xa6,  //@@@%
    0xff, 0xff, 0xff, 0xb2,  //@@@%
    0xff, 0x00, 0x2e, 0xe0,  //@..@
    0xff, 0xff, 0xf4, 0x9a,  //@@@%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0433 (г) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0434 (д) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0xff, 0xff, 0xff, 0x00,  //.@@@.
    0x0e, 0xf6, 0x00, 0xff, 0x00,  //.@.@.
    0x5a, 0xb6, 0x00, 0xff, 0x00,  //+%.@.
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0435 (е) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x50, 0xe2, 0xf0, 0x84,  //+@@%
    0xe6, 0xff, 0xff, 0xfa,  //@@@@
    0xe6, 0x4a, 0x02, 0x00,  //@+..
    0x4a, 0xda, 0xfc, 0xff,  //+@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0436 (ж) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x72, 0xde, 0x28, 0xff, 0x28, 0xde, 0x72,  //+@.@.@+
    0x00, 0x84, 0xec, 0xff, 0xec, 0x82, 0x00,  //.%@@@%.
    0x0e, 0xe0, 0x82, 0xff, 0x82, 0xe0, 0x0e,  //.@%@%@.
    0xa4, 0x94, 0x00, 0xff, 0x00, 0x94, 0xa4,  //%%.@.%%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0437 (з) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xf8, 0xac,  //@@%
    0x00, 0xff, 0xa8,  //.@%
    0x00, 0x34, 0xdc,  //..@
    0xff, 0xf6, 0x9a,  //@@%
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0438 (и) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x94, 0xff,  //@.%@
    0xff, 0x60, 0xda, 0xff,  //@+@@
    0xff, 0xf2, 0x38, 0xff,  //@@.@
    0xff, 0x84, 0x00, 0xff,  //@%.@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0439 (й) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xf2, 0xf2, 0x00,  //.@@.
    0x00, 0xa2, 0xa2, 0x00,  //.%%.
    0xff, 0x00, 0x94, 0xff,  //@.%@
    0xff, 0x60, 0xda, 0xff,  //@+@@
    0xff, 0xf2, 0x38, 0xff,  //@@.@
    0xff, 0x84, 0x00, 0xff,  //@%.@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+043a (к) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x28, 0xde, 0x72,  //@.@+
    0xff, 0xec, 0x82, 0x00,  //@@%.
    0xff, 0x82, 0xe0, 0x0e,  //@%@.
    0xff, 0x00, 0x94, 0xa4,  //@.%%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+043b (л) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xff, 0xff,  //.@@@
    0x0a, 0xfa, 0x00, 0xff,  //.@.@
    0x52, 0xde, 0x00, 0xff,  //+@.@
    0xe2, 0x58, 0x00, 0xff,  //@+.@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+043c (м) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xec, 0x2e, 0xec, 0xff,  //@@.@@
    0xff, 0x90, 0xea, 0x90, 0xff,  //@%@%@
    0xff, 0x1a, 0xf2, 0x1a, 0xff,  //@.@.@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+043d (н) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+043e (о) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0xe8, 0x32, 0x34, 0xe8,  //@..@
    0xe8, 0x32, 0x32, 0xe8,  //@..@
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+043f (п) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0440 (р) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xa0, 0xf0, 0x64,  //@%@+
    0xff, 0x32, 0x32, 0xea,  //@..@
    0xff, 0x32, 0x32, 0xea,  //@..@
    0xff, 0xa0, 0xf0, 0x66,  //@%@+
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0441 (с) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x60, 0xec, 0xff,  //+@@
    0xea, 0x36, 0x00,  //@..
    0xea, 0x36, 0x00,  //@..
    0x60, 0xec, 0xff,  //+@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0442 (т) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0443 (у) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xd0, 0x3c, 0x50, 0xc4,  //@.+@
    0x76, 0x96, 0xc4, 0x50,  //+%@+
    0x1c, 0xf4, 0xda, 0x00,  //.@@.
    0x00, 0xd0, 0x68, 0x00,  //.@+.
    0x04, 0xe4, 0x08, 0x00,  //.@..
    0xfa, 0x78, 0x00, 0x00,  //@+..
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0444 (ф) , Width: 5 */
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x88, 0xcc, 0xff, 0xce, 0x88,  //%@@@%
    0xf0, 0x2c, 0xff, 0x2e, 0xee,  //@.@.@
    0xf0, 0x2c, 0xff, 0x2e, 0xf0,  //@.@.@
    0x8c, 0xce, 0xff, 0xd0, 0x8c,  //%@@@%
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0445 (х) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x96, 0xac, 0xac, 0x96,  //%%%%
    0x04, 0xc2, 0xc2, 0x04,  //.@@.
    0x0a, 0xd6, 0xcc, 0x06,  //.@@.
    0xa0, 0x9e, 0xa4, 0x9c,  //%%%%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0446 (ц) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0x00, 0x00, 0xff, 0x00,  //@..@.
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0xff,  //....@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0447 (ч) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0x00, 0xff,  //@.@
    0xf8, 0x18, 0xff,  //@.@
    0xac, 0xff, 0xff,  //%@@
    0x00, 0x00, 0xff,  //..@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0448 (ш) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0x00, 0xff, 0x00, 0xff,  //@.@.@
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0449 (щ) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00,  //@.@.@.
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00,  //@.@.@.
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00,  //@.@.@.
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff,  //.....@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+044a (ъ) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00,  //@@@...
    0x00, 0x00, 0xff, 0xff, 0xf2, 0x86,  //..@@@%
    0x00, 0x00, 0xff, 0x00, 0x36, 0xf2,  //..@..@
    0x00, 0x00, 0xff, 0xff, 0xf0, 0x84,  //..@@@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+044b (ы) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0xff, 0xff, 0xf2, 0x86, 0xff,  //@@@%@
    0xff, 0x00, 0x36, 0xf2, 0xff,  //@..@@
    0xff, 0xff, 0xf0, 0x84, 0xff,  //@@@%@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+044c (ь) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xf2, 0x86,  //@@@%
    0xff, 0x00, 0x36, 0xf2,  //@..@
    0xff, 0xff, 0xf0, 0x84,  //@@@%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+044d (э) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0xec, 0x5a,  //@@+
    0x00, 0xff, 0xe8,  //.@@
    0x00, 0x3e, 0xe8,  //..@
    0xff, 0xee, 0x60,  //@@+
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+044e (ю) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xff, 0x00, 0x94, 0xf2, 0xe6, 0x56,  //@.%@@+
    0xff, 0xff, 0xff, 0x32, 0x34, 0xe8,  //@@@..@
    0xff, 0x00, 0xe4, 0x32, 0x32, 0xe8,  //@.@..@
    0xff, 0x00, 0x54, 0xe8, 0xe8, 0x5a,  //@.+@@+
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+044f (я) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xb0, 0xfa, 0xff,  //%@@
    0xe2, 0x20, 0xff,  //@.@
    0x2e, 0xfc, 0xff,  //.@@
    0xb0, 0x78, 0xff,  //%+@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_10_cyrillic_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_10_CYRILLIC == 1
    {.w_px = 5,   .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 4,   .glyph_index = 10}, /*Unicode: U+0411 (Б)*/
    {.w_px = 4,   .glyph_index = 20}, /*Unicode: U+0412 (В)*/
    {.w_px = 4,   .glyph_index = 30}, /*Unicode: U+0413 (Г)*/
    {.w_px = 5,   .glyph_index = 40}, /*Unicode: U+0414 (Д)*/
    {.w_px = 4,   .glyph_index = 50}, /*Unicode: U+0415 (Е)*/
    {.w_px = 9,   .glyph_index = 60}, /*Unicode: U+0416 (Ж)*/
    {.w_px = 4,   .glyph_index = 80}, /*Unicode: U+0417 (З)*/
    {.w_px = 4,   .glyph_index = 90}, /*Unicode: U+0418 (И)*/
    {.w_px = 4,   .glyph_index = 100},    /*Unicode: U+0419 (Й)*/
    {.w_px = 5,   .glyph_index = 110},    /*Unicode: U+041a (К)*/
    {.w_px = 4,   .glyph_index = 120},    /*Unicode: U+041b (Л)*/
    {.w_px = 5,   .glyph_index = 130},    /*Unicode: U+041c (М)*/
    {.w_px = 4,   .glyph_index = 140},    /*Unicode: U+041d (Н)*/
    {.w_px = 5,   .glyph_index = 150},    /*Unicode: U+041e (О)*/
    {.w_px = 4,   .glyph_index = 160},    /*Unicode: U+041f (П)*/
    {.w_px = 4,   .glyph_index = 170},    /*Unicode: U+0420 (Р)*/
    {.w_px = 5,   .glyph_index = 180},    /*Unicode: U+0421 (С)*/
    {.w_px = 5,   .glyph_index = 190},    /*Unicode: U+0422 (Т)*/
    {.w_px = 5,   .glyph_index = 200},    /*Unicode: U+0423 (У)*/
    {.w_px = 5,   .glyph_index = 210},    /*Unicode: U+0424 (Ф)*/
    {.w_px = 5,   .glyph_index = 220},    /*Unicode: U+0425 (Х)*/
    {.w_px = 5,   .glyph_index = 230},    /*Unicode: U+0426 (Ц)*/
    {.w_px = 4,   .glyph_index = 240},    /*Unicode: U+0427 (Ч)*/
    {.w_px = 7,   .glyph_index = 250},    /*Unicode: U+0428 (Ш)*/
    {.w_px = 8,   .glyph_index = 260},    /*Unicode: U+0429 (Щ)*/
    {.w_px = 5,   .glyph_index = 270},    /*Unicode: U+042a (Ъ)*/
    {.w_px = 6,   .glyph_index = 280},    /*Unicode: U+042b (Ы)*/
    {.w_px = 4,   .glyph_index = 290},    /*Unicode: U+042c (Ь)*/
    {.w_px = 5,   .glyph_index = 300},    /*Unicode: U+042d (Э)*/
    {.w_px = 7,   .glyph_index = 310},    /*Unicode: U+042e (Ю)*/
    {.w_px = 4,   .glyph_index = 320},    /*Unicode: U+042f (Я)*/
    {.w_px = 4,   .glyph_index = 330},    /*Unicode: U+0430 (а)*/
    {.w_px = 5,   .glyph_index = 340},    /*Unicode: U+0431 (б)*/
    {.w_px = 4,   .glyph_index = 350},    /*Unicode: U+0432 (в)*/
    {.w_px = 3,   .glyph_index = 360},    /*Unicode: U+0433 (г)*/
    {.w_px = 5,   .glyph_index = 370},    /*Unicode: U+0434 (д)*/
    {.w_px = 4,   .glyph_index = 380},    /*Unicode: U+0435 (е)*/
    {.w_px = 7,   .glyph_index = 390},    /*Unicode: U+0436 (ж)*/
    {.w_px = 3,   .glyph_index = 400},    /*Unicode: U+0437 (з)*/
    {.w_px = 4,   .glyph_index = 410},    /*Unicode: U+0438 (и)*/
    {.w_px = 4,   .glyph_index = 420},    /*Unicode: U+0439 (й)*/
    {.w_px = 4,   .glyph_index = 430},    /*Unicode: U+043a (к)*/
    {.w_px = 4,   .glyph_index = 440},    /*Unicode: U+043b (л)*/
    {.w_px = 5,   .glyph_index = 450},    /*Unicode: U+043c (м)*/
    {.w_px = 4,   .glyph_index = 460},    /*Unicode: U+043d (н)*/
    {.w_px = 4,   .glyph_index = 470},    /*Unicode: U+043e (о)*/
    {.w_px = 4,   .glyph_index = 480},    /*Unicode: U+043f (п)*/
    {.w_px = 4,   .glyph_index = 490},    /*Unicode: U+0440 (р)*/
    {.w_px = 3,   .glyph_index = 500},    /*Unicode: U+0441 (с)*/
    {.w_px = 5,   .glyph_index = 510},    /*Unicode: U+0442 (т)*/
    {.w_px = 4,   .glyph_index = 520},    /*Unicode: U+0443 (у)*/
    {.w_px = 5,   .glyph_index = 530},    /*Unicode: U+0444 (ф)*/
    {.w_px = 4,   .glyph_index = 540},    /*Unicode: U+0445 (х)*/
    {.w_px = 5,   .glyph_index = 550},    /*Unicode: U+0446 (ц)*/
    {.w_px = 3,   .glyph_index = 560},    /*Unicode: U+0447 (ч)*/
    {.w_px = 5,   .glyph_index = 570},    /*Unicode: U+0448 (ш)*/
    {.w_px = 6,   .glyph_index = 580},    /*Unicode: U+0449 (щ)*/
    {.w_px = 6,   .glyph_index = 590},    /*Unicode: U+044a (ъ)*/
    {.w_px = 5,   .glyph_index = 600},    /*Unicode: U+044b (ы)*/
    {.w_px = 4,   .glyph_index = 610},    /*Unicode: U+044c (ь)*/
    {.w_px = 3,   .glyph_index = 620},    /*Unicode: U+044d (э)*/
    {.w_px = 6,   .glyph_index = 630},    /*Unicode: U+044e (ю)*/
    {.w_px = 3,   .glyph_index = 640},    /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 2
    {.w_px = 5,   .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 4,   .glyph_index = 20}, /*Unicode: U+0411 (Б)*/
    {.w_px = 4,   .glyph_index = 30}, /*Unicode: U+0412 (В)*/
    {.w_px = 4,   .glyph_index = 40}, /*Unicode: U+0413 (Г)*/
    {.w_px = 5,   .glyph_index = 50}, /*Unicode: U+0414 (Д)*/
    {.w_px = 4,   .glyph_index = 70}, /*Unicode: U+0415 (Е)*/
    {.w_px = 9,   .glyph_index = 80}, /*Unicode: U+0416 (Ж)*/
    {.w_px = 4,   .glyph_index = 110},    /*Unicode: U+0417 (З)*/
    {.w_px = 4,   .glyph_index = 120},    /*Unicode: U+0418 (И)*/
    {.w_px = 4,   .glyph_index = 130},    /*Unicode: U+0419 (Й)*/
    {.w_px = 5,   .glyph_index = 140},    /*Unicode: U+041a (К)*/
    {.w_px = 4,   .glyph_index = 160},    /*Unicode: U+041b (Л)*/
    {.w_px = 5,   .glyph_index = 170},    /*Unicode: U+041c (М)*/
    {.w_px = 4,   .glyph_index = 190},    /*Unicode: U+041d (Н)*/
    {.w_px = 5,   .glyph_index = 200},    /*Unicode: U+041e (О)*/
    {.w_px = 4,   .glyph_index = 220},    /*Unicode: U+041f (П)*/
    {.w_px = 4,   .glyph_index = 230},    /*Unicode: U+0420 (Р)*/
    {.w_px = 5,   .glyph_index = 240},    /*Unicode: U+0421 (С)*/
    {.w_px = 5,   .glyph_index = 260},    /*Unicode: U+0422 (Т)*/
    {.w_px = 5,   .glyph_index = 280},    /*Unicode: U+0423 (У)*/
    {.w_px = 5,   .glyph_index = 300},    /*Unicode: U+0424 (Ф)*/
    {.w_px = 5,   .glyph_index = 320},    /*Unicode: U+0425 (Х)*/
    {.w_px = 5,   .glyph_index = 340},    /*Unicode: U+0426 (Ц)*/
    {.w_px = 4,   .glyph_index = 360},    /*Unicode: U+0427 (Ч)*/
    {.w_px = 7,   .glyph_index = 370},    /*Unicode: U+0428 (Ш)*/
    {.w_px = 8,   .glyph_index = 390},    /*Unicode: U+0429 (Щ)*/
    {.w_px = 5,   .glyph_index = 410},    /*Unicode: U+042a (Ъ)*/
    {.w_px = 6,   .glyph_index = 430},    /*Unicode: U+042b (Ы)*/
    {.w_px = 4,   .glyph_index = 450},    /*Unicode: U+042c (Ь)*/
    {.w_px = 5,   .glyph_index = 460},    /*Unicode: U+042d (Э)*/
    {.w_px = 7,   .glyph_index = 480},    /*Unicode: U+042e (Ю)*/
    {.w_px = 4,   .glyph_index = 500},    /*Unicode: U+042f (Я)*/
    {.w_px = 4,   .glyph_index = 510},    /*Unicode: U+0430 (а)*/
    {.w_px = 5,   .glyph_index = 520},    /*Unicode: U+0431 (б)*/
    {.w_px = 4,   .glyph_index = 540},    /*Unicode: U+0432 (в)*/
    {.w_px = 3,   .glyph_index = 550},    /*Unicode: U+0433 (г)*/
    {.w_px = 5,   .glyph_index = 560},    /*Unicode: U+0434 (д)*/
    {.w_px = 4,   .glyph_index = 580},    /*Unicode: U+0435 (е)*/
    {.w_px = 7,   .glyph_index = 590},    /*Unicode: U+0436 (ж)*/
    {.w_px = 3,   .glyph_index = 610},    /*Unicode: U+0437 (з)*/
    {.w_px = 4,   .glyph_index = 620},    /*Unicode: U+0438 (и)*/
    {.w_px = 4,   .glyph_index = 630},    /*Unicode: U+0439 (й)*/
    {.w_px = 4,   .glyph_index = 640},    /*Unicode: U+043a (к)*/
    {.w_px = 4,   .glyph_index = 650},    /*Unicode: U+043b (л)*/
    {.w_px = 5,   .glyph_index = 660},    /*Unicode: U+043c (м)*/
    {.w_px = 4,   .glyph_index = 680},    /*Unicode: U+043d (н)*/
    {.w_px = 4,   .glyph_index = 690},    /*Unicode: U+043e (о)*/
    {.w_px = 4,   .glyph_index = 700},    /*Unicode: U+043f (п)*/
    {.w_px = 4,   .glyph_index = 710},    /*Unicode: U+0440 (р)*/
    {.w_px = 3,   .glyph_index = 720},    /*Unicode: U+0441 (с)*/
    {.w_px = 5,   .glyph_index = 730},    /*Unicode: U+0442 (т)*/
    {.w_px = 4,   .glyph_index = 750},    /*Unicode: U+0443 (у)*/
    {.w_px = 5,   .glyph_index = 760},    /*Unicode: U+0444 (ф)*/
    {.w_px = 4,   .glyph_index = 780},    /*Unicode: U+0445 (х)*/
    {.w_px = 5,   .glyph_index = 790},    /*Unicode: U+0446 (ц)*/
    {.w_px = 3,   .glyph_index = 810},    /*Unicode: U+0447 (ч)*/
    {.w_px = 5,   .glyph_index = 820},    /*Unicode: U+0448 (ш)*/
    {.w_px = 6,   .glyph_index = 840},    /*Unicode: U+0449 (щ)*/
    {.w_px = 6,   .glyph_index = 860},    /*Unicode: U+044a (ъ)*/
    {.w_px = 5,   .glyph_index = 880},    /*Unicode: U+044b (ы)*/
    {.w_px = 4,   .glyph_index = 900},    /*Unicode: U+044c (ь)*/
    {.w_px = 3,   .glyph_index = 910},    /*Unicode: U+044d (э)*/
    {.w_px = 6,   .glyph_index = 920},    /*Unicode: U+044e (ю)*/
    {.w_px = 3,   .glyph_index = 940},    /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 4
    {.w_px = 5,   .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 4,   .glyph_index = 30}, /*Unicode: U+0411 (Б)*/
    {.w_px = 4,   .glyph_index = 50}, /*Unicode: U+0412 (В)*/
    {.w_px = 4,   .glyph_index = 70}, /*Unicode: U+0413 (Г)*/
    {.w_px = 5,   .glyph_index = 90}, /*Unicode: U+0414 (Д)*/
    {.w_px = 4,   .glyph_index = 120},    /*Unicode: U+0415 (Е)*/
    {.w_px = 9,   .glyph_index = 140},    /*Unicode: U+0416 (Ж)*/
    {.w_px = 4,   .glyph_index = 190},    /*Unicode: U+0417 (З)*/
    {.w_px = 4,   .glyph_index = 210},    /*Unicode: U+0418 (И)*/
    {.w_px = 4,   .glyph_index = 230},    /*Unicode: U+0419 (Й)*/
    {.w_px = 5,   .glyph_index = 250},    /*Unicode: U+041a (К)*/
    {.w_px = 4,   .glyph_index = 280},    /*Unicode: U+041b (Л)*/
    {.w_px = 5,   .glyph_index = 300},    /*Unicode: U+041c (М)*/
    {.w_px = 4,   .glyph_index = 330},    /*Unicode: U+041d (Н)*/
    {.w_px = 5,   .glyph_index = 350},    /*Unicode: U+041e (О)*/
    {.w_px = 4,   .glyph_index = 380},    /*Unicode: U+041f (П)*/
    {.w_px = 4,   .glyph_index = 400},    /*Unicode: U+0420 (Р)*/
    {.w_px = 5,   .glyph_index = 420},    /*Unicode: U+0421 (С)*/
    {.w_px = 5,   .glyph_index = 450},    /*Unicode: U+0422 (Т)*/
    {.w_px = 5,   .glyph_index = 480},    /*Unicode: U+0423 (У)*/
    {.w_px = 5,   .glyph_index = 510},    /*Unicode: U+0424 (Ф)*/
    {.w_px = 5,   .glyph_index = 540},    /*Unicode: U+0425 (Х)*/
    {.w_px = 5,   .glyph_index = 570},    /*Unicode: U+0426 (Ц)*/
    {.w_px = 4,   .glyph_index = 600},    /*Unicode: U+0427 (Ч)*/
    {.w_px = 7,   .glyph_index = 620},    /*Unicode: U+0428 (Ш)*/
    {.w_px = 8,   .glyph_index = 660},    /*Unicode: U+0429 (Щ)*/
    {.w_px = 5,   .glyph_index = 700},    /*Unicode: U+042a (Ъ)*/
    {.w_px = 6,   .glyph_index = 730},    /*Unicode: U+042b (Ы)*/
    {.w_px = 4,   .glyph_index = 760},    /*Unicode: U+042c (Ь)*/
    {.w_px = 5,   .glyph_index = 780},    /*Unicode: U+042d (Э)*/
    {.w_px = 7,   .glyph_index = 810},    /*Unicode: U+042e (Ю)*/
    {.w_px = 4,   .glyph_index = 850},    /*Unicode: U+042f (Я)*/
    {.w_px = 4,   .glyph_index = 870},    /*Unicode: U+0430 (а)*/
    {.w_px = 5,   .glyph_index = 890},    /*Unicode: U+0431 (б)*/
    {.w_px = 4,   .glyph_index = 920},    /*Unicode: U+0432 (в)*/
    {.w_px = 3,   .glyph_index = 940},    /*Unicode: U+0433 (г)*/
    {.w_px = 5,   .glyph_index = 960},    /*Unicode: U+0434 (д)*/
    {.w_px = 4,   .glyph_index = 990},    /*Unicode: U+0435 (е)*/
    {.w_px = 7,   .glyph_index = 1010},   /*Unicode: U+0436 (ж)*/
    {.w_px = 3,   .glyph_index = 1050},   /*Unicode: U+0437 (з)*/
    {.w_px = 4,   .glyph_index = 1070},   /*Unicode: U+0438 (и)*/
    {.w_px = 4,   .glyph_index = 1090},   /*Unicode: U+0439 (й)*/
    {.w_px = 4,   .glyph_index = 1110},   /*Unicode: U+043a (к)*/
    {.w_px = 4,   .glyph_index = 1130},   /*Unicode: U+043b (л)*/
    {.w_px = 5,   .glyph_index = 1150},   /*Unicode: U+043c (м)*/
    {.w_px = 4,   .glyph_index = 1180},   /*Unicode: U+043d (н)*/
    {.w_px = 4,   .glyph_index = 1200},   /*Unicode: U+043e (о)*/
    {.w_px = 4,   .glyph_index = 1220},   /*Unicode: U+043f (п)*/
    {.w_px = 4,   .glyph_index = 1240},   /*Unicode: U+0440 (р)*/
    {.w_px = 3,   .glyph_index = 1260},   /*Unicode: U+0441 (с)*/
    {.w_px = 5,   .glyph_index = 1280},   /*Unicode: U+0442 (т)*/
    {.w_px = 4,   .glyph_index = 1310},   /*Unicode: U+0443 (у)*/
    {.w_px = 5,   .glyph_index = 1330},   /*Unicode: U+0444 (ф)*/
    {.w_px = 4,   .glyph_index = 1360},   /*Unicode: U+0445 (х)*/
    {.w_px = 5,   .glyph_index = 1380},   /*Unicode: U+0446 (ц)*/
    {.w_px = 3,   .glyph_index = 1410},   /*Unicode: U+0447 (ч)*/
    {.w_px = 5,   .glyph_index = 1430},   /*Unicode: U+0448 (ш)*/
    {.w_px = 6,   .glyph_index = 1460},   /*Unicode: U+0449 (щ)*/
    {.w_px = 6,   .glyph_index = 1490},   /*Unicode: U+044a (ъ)*/
    {.w_px = 5,   .glyph_index = 1520},   /*Unicode: U+044b (ы)*/
    {.w_px = 4,   .glyph_index = 1550},   /*Unicode: U+044c (ь)*/
    {.w_px = 3,   .glyph_index = 1570},   /*Unicode: U+044d (э)*/
    {.w_px = 6,   .glyph_index = 1590},   /*Unicode: U+044e (ю)*/
    {.w_px = 3,   .glyph_index = 1620},   /*Unicode: U+044f (я)*/

#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 8
    {.w_px = 5,   .glyph_index = 0},  /*Unicode: U+0410 (А)*/
    {.w_px = 4,   .glyph_index = 50}, /*Unicode: U+0411 (Б)*/
    {.w_px = 4,   .glyph_index = 90}, /*Unicode: U+0412 (В)*/
    {.w_px = 4,   .glyph_index = 130},    /*Unicode: U+0413 (Г)*/
    {.w_px = 5,   .glyph_index = 170},    /*Unicode: U+0414 (Д)*/
    {.w_px = 4,   .glyph_index = 220},    /*Unicode: U+0415 (Е)*/
    {.w_px = 9,   .glyph_index = 260},    /*Unicode: U+0416 (Ж)*/
    {.w_px = 4,   .glyph_index = 350},    /*Unicode: U+0417 (З)*/
    {.w_px = 4,   .glyph_index = 390},    /*Unicode: U+0418 (И)*/
    {.w_px = 4,   .glyph_index = 430},    /*Unicode: U+0419 (Й)*/
    {.w_px = 5,   .glyph_index = 470},    /*Unicode: U+041a (К)*/
    {.w_px = 4,   .glyph_index = 520},    /*Unicode: U+041b (Л)*/
    {.w_px = 5,   .glyph_index = 560},    /*Unicode: U+041c (М)*/
    {.w_px = 4,   .glyph_index = 610},    /*Unicode: U+041d (Н)*/
    {.w_px = 5,   .glyph_index = 650},    /*Unicode: U+041e (О)*/
    {.w_px = 4,   .glyph_index = 700},    /*Unicode: U+041f (П)*/
    {.w_px = 4,   .glyph_index = 740},    /*Unicode: U+0420 (Р)*/
    {.w_px = 5,   .glyph_index = 780},    /*Unicode: U+0421 (С)*/
    {.w_px = 5,   .glyph_index = 830},    /*Unicode: U+0422 (Т)*/
    {.w_px = 5,   .glyph_index = 880},    /*Unicode: U+0423 (У)*/
    {.w_px = 5,   .glyph_index = 930},    /*Unicode: U+0424 (Ф)*/
    {.w_px = 5,   .glyph_index = 980},    /*Unicode: U+0425 (Х)*/
    {.w_px = 5,   .glyph_index = 1030},   /*Unicode: U+0426 (Ц)*/
    {.w_px = 4,   .glyph_index = 1080},   /*Unicode: U+0427 (Ч)*/
    {.w_px = 7,   .glyph_index = 1120},   /*Unicode: U+0428 (Ш)*/
    {.w_px = 8,   .glyph_index = 1190},   /*Unicode: U+0429 (Щ)*/
    {.w_px = 5,   .glyph_index = 1270},   /*Unicode: U+042a (Ъ)*/
    {.w_px = 6,   .glyph_index = 1320},   /*Unicode: U+042b (Ы)*/
    {.w_px = 4,   .glyph_index = 1380},   /*Unicode: U+042c (Ь)*/
    {.w_px = 5,   .glyph_index = 1420},   /*Unicode: U+042d (Э)*/
    {.w_px = 7,   .glyph_index = 1470},   /*Unicode: U+042e (Ю)*/
    {.w_px = 4,   .glyph_index = 1540},   /*Unicode: U+042f (Я)*/
    {.w_px = 4,   .glyph_index = 1580},   /*Unicode: U+0430 (а)*/
    {.w_px = 5,   .glyph_index = 1620},   /*Unicode: U+0431 (б)*/
    {.w_px = 4,   .glyph_index = 1670},   /*Unicode: U+0432 (в)*/
    {.w_px = 3,   .glyph_index = 1710},   /*Unicode: U+0433 (г)*/
    {.w_px = 5,   .glyph_index = 1740},   /*Unicode: U+0434 (д)*/
    {.w_px = 4,   .glyph_index = 1790},   /*Unicode: U+0435 (е)*/
    {.w_px = 7,   .glyph_index = 1830},   /*Unicode: U+0436 (ж)*/
    {.w_px = 3,   .glyph_index = 1900},   /*Unicode: U+0437 (з)*/
    {.w_px = 4,   .glyph_index = 1930},   /*Unicode: U+0438 (и)*/
    {.w_px = 4,   .glyph_index = 1970},   /*Unicode: U+0439 (й)*/
    {.w_px = 4,   .glyph_index = 2010},   /*Unicode: U+043a (к)*/
    {.w_px = 4,   .glyph_index = 2050},   /*Unicode: U+043b (л)*/
    {.w_px = 5,   .glyph_index = 2090},   /*Unicode: U+043c (м)*/
    {.w_px = 4,   .glyph_index = 2140},   /*Unicode: U+043d (н)*/
    {.w_px = 4,   .glyph_index = 2180},   /*Unicode: U+043e (о)*/
    {.w_px = 4,   .glyph_index = 2220},   /*Unicode: U+043f (п)*/
    {.w_px = 4,   .glyph_index = 2260},   /*Unicode: U+0440 (р)*/
    {.w_px = 3,   .glyph_index = 2300},   /*Unicode: U+0441 (с)*/
    {.w_px = 5,   .glyph_index = 2330},   /*Unicode: U+0442 (т)*/
    {.w_px = 4,   .glyph_index = 2380},   /*Unicode: U+0443 (у)*/
    {.w_px = 5,   .glyph_index = 2420},   /*Unicode: U+0444 (ф)*/
    {.w_px = 4,   .glyph_index = 2470},   /*Unicode: U+0445 (х)*/
    {.w_px = 5,   .glyph_index = 2510},   /*Unicode: U+0446 (ц)*/
    {.w_px = 3,   .glyph_index = 2560},   /*Unicode: U+0447 (ч)*/
    {.w_px = 5,   .glyph_index = 2590},   /*Unicode: U+0448 (ш)*/
    {.w_px = 6,   .glyph_index = 2640},   /*Unicode: U+0449 (щ)*/
    {.w_px = 6,   .glyph_index = 2700},   /*Unicode: U+044a (ъ)*/
    {.w_px = 5,   .glyph_index = 2760},   /*Unicode: U+044b (ы)*/
    {.w_px = 4,   .glyph_index = 2810},   /*Unicode: U+044c (ь)*/
    {.w_px = 3,   .glyph_index = 2850},   /*Unicode: U+044d (э)*/
    {.w_px = 6,   .glyph_index = 2880},   /*Unicode: U+044e (ю)*/
    {.w_px = 3,   .glyph_index = 2940},   /*Unicode: U+044f (я)*/

#endif
};

lv_font_t lv_font_dejavu_10_cyrillic = {
    .unicode_first = 1040,  /*First Unicode letter in this font*/
    .unicode_last = 1103,   /*Last Unicode letter in this font*/
    .h_px = 10,             /*Font height in pixels*/
    .glyph_bitmap = lv_font_dejavu_10_cyrillic_glyph_bitmap,    /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_10_cyrillic_glyph_dsc,      /*Description of glyphs*/
    .glyph_cnt = 64,            /*Number of glyphs in the font*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_10_CYRILLIC == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10_CYRILLIC == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_10_CYRILLIC*/
