
#include "../lv_misc/lv_font.h"

#if USE_LV_FONT_DEJAVU_10 != 0  /*Can be enabled in lv_conf.h*/

/***********************************************************************************
 * DejaVuSans.ttf 10 px Font in U+0020 ( ) .. U+007e (~)  range with 1 bpp
***********************************************************************************/

/*Store the image of the letters (glyph)*/
static const uint8_t lv_font_dejavu_10_glyph_bitmap[] = {
#if USE_LV_FONT_DEJAVU_10 == 1
    /*Unicode: U+0020 ( ) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0021 (!) , Width: 1 */
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+0022 (") , Width: 3 */
    0x00,  //...
    0xa0,  //@.@
    0xa0,  //@.@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0023 (#) , Width: 5 */
    0x20,  //..%+.
    0x10,  //..+%.
    0xf8,  //%@@@@
    0x50,  //.%.%.
    0xf8,  //@@@@%
    0x40,  //.%+..
    0x20,  //.+%..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0024 ($) , Width: 5 */
    0x00,  //.....
    0x20,  //..@..
    0x78,  //+@@@@
    0xa0,  //@+@..
    0x70,  //+%@@+
    0x28,  //..@.@
    0xf0,  //@@@@+
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0025 (%) , Width: 7 */
    0x00,  //.......
    0xe8,  //%@%.@+.
    0xa8,  //@+@+@..
    0xf0,  //%@%@+..
    0x1e,  //..+@%@%
    0x2a,  //..@+@+@
    0x2e,  //.+@.%@%
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0026 (&) , Width: 5 */
    0x00,  //.....
    0x70,  //.%@@.
    0x40,  //.@...
    0x60,  //.@%..
    0xf8,  //%%@%@
    0xb0,  //@+@@.
    0x78,  //+@%%%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0027 (') , Width: 1 */
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+0028 (() , Width: 2 */
    0x40,  //.%
    0x80,  //%+
    0x80,  //@.
    0x80,  //@.
    0x80,  //@.
    0x80,  //%+
    0x40,  //.%
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0029 ()) , Width: 2 */
    0x80,  //%.
    0x40,  //+%
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //+%
    0x80,  //%.
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002a (*) , Width: 5 */
    0x00,  //.....
    0xa8,  //%.@.%
    0x70,  //.%@%.
    0x70,  //.%@%.
    0xa8,  //%.@.%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+002b (+) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x20,  //..@..
    0x20,  //..@..
    0xf8,  //@@@@@
    0x20,  //..@..
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+002c (,) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+002d (-) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xc0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002e (.) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+002f (/) , Width: 3 */
    0x00,  //...
    0x20,  //..@
    0x20,  //.+%
    0x40,  //.%+
    0x40,  //.@.
    0x40,  //+%.
    0x80,  //%+.
    0x80,  //@..
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0030 (0) , Width: 4 */
    0x00,  //....
    0x60,  //.@@.
    0x90,  //@++@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@++@
    0x60,  //.@@.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0031 (1) , Width: 3 */
    0x00,  //...
    0xc0,  //@@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0xe0,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0032 (2) , Width: 5 */
    0x00,  //.....
    0xe0,  //@@@+.
    0x10,  //...@.
    0x10,  //..+%.
    0x20,  //.+@..
    0x40,  //+@...
    0xf0,  //@@@@.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0033 (3) , Width: 4 */
    0x00,  //....
    0xe0,  //@@@+
    0x10,  //...@
    0x10,  //...@
    0x60,  //.@@+
    0x10,  //..+@
    0xe0,  //@@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0034 (4) , Width: 4 */
    0x00,  //....
    0x20,  //..@.
    0x60,  //.%@.
    0x60,  //.@@.
    0xa0,  //%+@.
    0xf0,  //@@@@
    0x20,  //..@.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0035 (5) , Width: 4 */
    0x00,  //....
    0xf0,  //@@@@
    0x80,  //@...
    0xe0,  //@@@+
    0x10,  //..+@
    0x10,  //..+@
    0xe0,  //@@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0036 (6) , Width: 4 */
    0x00,  //....
    0x70,  //.%@@
    0xc0,  //%%..
    0x80,  //@...
    0xf0,  //@%@%
    0x90,  //@..@
    0x60,  //.@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0037 (7) , Width: 4 */
    0x00,  //....
    0xf0,  //@@@@
    0x10,  //..+%
    0x20,  //..@+
    0x20,  //..@.
    0x20,  //.+%.
    0x40,  //.@..
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0038 (8) , Width: 4 */
    0x00,  //....
    0x60,  //+@@+
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x90,  //@..@
    0xf0,  //%@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0039 (9) , Width: 4 */
    0x00,  //....
    0x60,  //+@@.
    0x90,  //@..@
    0xf0,  //%@%@
    0x10,  //...@
    0x30,  //..%%
    0xe0,  //@@%.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+003a (:) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003b (;) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003c (<) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x08,  //...+@
    0x70,  //+@@%.
    0x70,  //+@@%.
    0x08,  //...+@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+003d (=) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xf8,  //@@@@@
    0x00,  //.....
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+003e (>) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x80,  //@+...
    0x70,  //.%@@+
    0x70,  //.%@@+
    0x80,  //@+...
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+003f (?) , Width: 3 */
    0x00,  //...
    0xe0,  //@@%
    0x20,  //..@
    0x40,  //.%.
    0x40,  //.@.
    0x00,  //...
    0x40,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0040 (@) , Width: 7 */
    0x00,  //.......
    0x38,  //.+@@@+.
    0x46,  //+@+..%%
    0xba,  //@.%%@.@
    0xaa,  //@.@+@+@
    0xbc,  //@.%%@%.
    0x40,  //+@+.+..
    0x30,  //.+@@+..
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0041 (A) , Width: 5 */
    0x00,  //.....
    0x20,  //..@..
    0x20,  //.+@+.
    0x70,  //.@%@.
    0x50,  //.@.@.
    0x70,  //+@@@+
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0042 (B) , Width: 4 */
    0x00,  //....
    0xe0,  //@@@+
    0x90,  //@..@
    0x90,  //@..@
    0xe0,  //@@@+
    0x90,  //@..@
    0xf0,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0043 (C) , Width: 5 */
    0x00,  //.....
    0x70,  //.%@@+
    0xc8,  //%%..%
    0x80,  //@....
    0x80,  //@....
    0xc8,  //%%..%
    0x70,  //.%@@+
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0044 (D) , Width: 5 */
    0x00,  //.....
    0xf0,  //@@@%.
    0x98,  //@..%%
    0x88,  //@...@
    0x88,  //@...@
    0x98,  //@..%%
    0xf0,  //@@@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0045 (E) , Width: 4 */
    0x00,  //....
    0xf0,  //@@@@
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@@
    0x80,  //@...
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0046 (F) , Width: 3 */
    0x00,  //...
    0xe0,  //@@@
    0x80,  //@..
    0x80,  //@..
    0xe0,  //@@@
    0x80,  //@..
    0x80,  //@..
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0047 (G) , Width: 5 */
    0x00,  //.....
    0x70,  //.%@@+
    0xc8,  //%%..%
    0x98,  //@..@@
    0x88,  //@...@
    0xc8,  //%%..@
    0x70,  //.%@@+
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0048 (H) , Width: 4 */
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0xf0,  //@@@@
    0x90,  //@..@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0049 (I) , Width: 1 */
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+004a (J) , Width: 2 */
    0x00,  //..
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x80,  //@+
    0x00,  //..


    /*Unicode: U+004b (K) , Width: 5 */
    0x00,  //.....
    0x90,  //@..@+
    0xa0,  //@+@+.
    0xc0,  //@@...
    0xe0,  //@@+..
    0xb0,  //@.@+.
    0x90,  //@..@+
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+004c (L) , Width: 4 */
    0x00,  //....
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+004d (M) , Width: 5 */
    0x00,  //.....
    0xd8,  //@@.@@
    0xd8,  //@@+@@
    0xf8,  //@%@+@
    0xa8,  //@.@.@
    0xa8,  //@.@.@
    0x88,  //@...@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+004e (N) , Width: 4 */
    0x00,  //....
    0x90,  //@+.@
    0xd0,  //@@.@
    0xd0,  //@%+@
    0xb0,  //@+@@
    0xb0,  //@.@@
    0x90,  //@.+@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+004f (O) , Width: 5 */
    0x00,  //.....
    0x70,  //.%@%.
    0xd8,  //%%.%%
    0x88,  //@...@
    0x88,  //@...@
    0xd8,  //%%.%%
    0x70,  //.%@%.
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0050 (P) , Width: 4 */
    0x00,  //....
    0xe0,  //@@@+
    0x90,  //@..@
    0xe0,  //@@@+
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0051 (Q) , Width: 5 */
    0x00,  //.....
    0x70,  //.%@%.
    0xd8,  //%%.%%
    0x88,  //@...@
    0x88,  //@...@
    0xd8,  //%%.%%
    0x70,  //.%@%.
    0x10,  //...@.
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0052 (R) , Width: 5 */
    0x00,  //.....
    0xf0,  //@@@%.
    0x90,  //@..@.
    0xe0,  //@@@+.
    0xb0,  //@.%%.
    0x90,  //@..@.
    0x88,  //@..+%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0053 (S) , Width: 4 */
    0x00,  //....
    0x70,  //+@@@
    0x80,  //@...
    0xe0,  //%@%.
    0x30,  //..%@
    0x10,  //...@
    0xe0,  //@@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0054 (T) , Width: 5 */
    0x00,  //.....
    0xf8,  //@@@@@
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0055 (U) , Width: 4 */
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@++@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0056 (V) , Width: 5 */
    0x00,  //.....
    0x88,  //@...@
    0x50,  //+%.%+
    0x50,  //.@.@.
    0x70,  //.@%@.
    0x20,  //.+@+.
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0057 (W) , Width: 7 */
    0x00,  //.......
    0x92,  //@.+@+.@
    0xba,  //%+%%%+%
    0x6c,  //+%@.@%+
    0x6c,  //.@@.@@.
    0x6c,  //.@%.%@.
    0x44,  //.%+.+%.
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+0058 (X) , Width: 5 */
    0x00,  //.....
    0xd8,  //%%.%%
    0x50,  //.@+@.
    0x20,  //.+@+.
    0x20,  //.+@+.
    0x50,  //.@+@.
    0x88,  //%+.+%
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+0059 (Y) , Width: 5 */
    0x00,  //.....
    0xd8,  //%+.+%
    0x50,  //.@+@.
    0x20,  //.+@+.
    0x20,  //..@..
    0x20,  //..@..
    0x20,  //..@..
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+005a (Z) , Width: 5 */
    0x00,  //.....
    0xf8,  //@@@@@
    0x10,  //...@+
    0x20,  //..@+.
    0x60,  //.%%..
    0x40,  //+@...
    0xf8,  //@@@@@
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+005b ([) , Width: 2 */
    0x00,  //..
    0xc0,  //@@
    0x80,  //@.
    0x80,  //@.
    0x80,  //@.
    0x80,  //@.
    0x80,  //@.
    0xc0,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+005c (\) , Width: 3 */
    0x00,  //...
    0x80,  //@..
    0x80,  //%+.
    0x40,  //+%.
    0x40,  //.@.
    0x40,  //.%+
    0x20,  //.+%
    0x20,  //..@
    0x00,  //...
    0x00,  //...


    /*Unicode: U+005d (]) , Width: 2 */
    0x00,  //..
    0xc0,  //@@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0xc0,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+005e (^) , Width: 5 */
    0x00,  //.....
    0x20,  //.+@+.
    0x00,  //++.++
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....


    /*Unicode: U+005f (_) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xf0,  //@@@@
    0x00,  //....


    /*Unicode: U+0060 (`) , Width: 2 */
    0x00,  //..
    0x00,  //++
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0061 (a) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //.@@%
    0x70,  //+@@@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0062 (b) , Width: 4 */
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0xe0,  //@%@+
    0x90,  //@..@
    0x90,  //@..@
    0xe0,  //@%@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0063 (c) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x60,  //+@@
    0x80,  //@..
    0x80,  //@..
    0x60,  //+@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0064 (d) , Width: 4 */
    0x10,  //...@
    0x10,  //...@
    0x10,  //...@
    0x70,  //+@%@
    0x90,  //@..@
    0x90,  //@..@
    0x70,  //+@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0065 (e) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //+@@%
    0xf0,  //@@@@
    0x80,  //@+..
    0x70,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0066 (f) , Width: 3 */
    0x20,  //.+@
    0x40,  //.@.
    0x40,  //.@.
    0xe0,  //@@@
    0x40,  //.@.
    0x40,  //.@.
    0x40,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0067 (g) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //+@%@
    0x90,  //@..@
    0x90,  //@..@
    0x70,  //+@%@
    0x10,  //..+@
    0x60,  //.@@+
    0x00,  //....


    /*Unicode: U+0068 (h) , Width: 4 */
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0xf0,  //@%@%
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0069 (i) , Width: 1 */
    0x00,  //.
    0x80,  //@
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+006a (j) , Width: 2 */
    0x00,  //..
    0x40,  //.@
    0x00,  //..
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0x40,  //.@
    0xc0,  //@%
    0x00,  //..


    /*Unicode: U+006b (k) , Width: 4 */
    0x80,  //@...
    0x80,  //@...
    0x80,  //@...
    0xa0,  //@.@+
    0xc0,  //@@..
    0xc0,  //@@+.
    0xa0,  //@.@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+006c (l) , Width: 1 */
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+006d (m) , Width: 7 */
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......
    0xee,  //@%@+%@+
    0x92,  //@..@..@
    0x92,  //@..@..@
    0x92,  //@..@..@
    0x00,  //.......
    0x00,  //.......
    0x00,  //.......


    /*Unicode: U+006e (n) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xf0,  //@%@%
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+006f (o) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x60,  //+@@+
    0x90,  //@..@
    0x90,  //@..@
    0x60,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0070 (p) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xe0,  //@%@+
    0x90,  //@..@
    0x90,  //@..@
    0xe0,  //@%@+
    0x80,  //@...
    0x80,  //@...
    0x00,  //....


    /*Unicode: U+0071 (q) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x70,  //+@%@
    0x90,  //@..@
    0x90,  //@..@
    0x70,  //+@%@
    0x10,  //...@
    0x10,  //...@
    0x00,  //....


    /*Unicode: U+0072 (r) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //@%@
    0x80,  //@+.
    0x80,  //@..
    0x80,  //@..
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0073 (s) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xe0,  //%@@
    0xc0,  //@@+
    0x20,  //.+@
    0xe0,  //@@%
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0074 (t) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x40,  //.@.
    0xe0,  //@@@
    0x40,  //.@.
    0x40,  //.@.
    0x60,  //.%@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0075 (u) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x90,  //@..@
    0x90,  //@..@
    0x90,  //@..@
    0xf0,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0076 (v) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x90,  //@++@
    0x60,  //+%%+
    0x60,  //.@@.
    0x60,  //.%%.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0077 (w) , Width: 6 */
    0x00,  //......
    0x00,  //......
    0x00,  //......
    0xb4,  //@.@@.@
    0xfc,  //%%@@%%
    0x48,  //+@++@+
    0x48,  //.@..@.
    0x00,  //......
    0x00,  //......
    0x00,  //......


    /*Unicode: U+0078 (x) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xf0,  //%%%%
    0x60,  //.@@.
    0x60,  //.@@.
    0xf0,  //%%%%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0079 (y) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x90,  //@.+@
    0x60,  //+%@+
    0x60,  //.@@.
    0x40,  //.@+.
    0x40,  //.@..
    0x80,  //@+..
    0x00,  //....


    /*Unicode: U+007a (z) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xf0,  //@@@@
    0x20,  //..@+
    0x60,  //.@%.
    0xf0,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+007b ({) , Width: 3 */
    0x00,  //...
    0x60,  //.%@
    0x40,  //.@.
    0x40,  //.@.
    0xc0,  //@%.
    0x40,  //.@.
    0x40,  //.@.
    0x60,  //.%@
    0x00,  //...
    0x00,  //...


    /*Unicode: U+007c (|) , Width: 1 */
    0x00,  //.
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x80,  //@
    0x00,  //.


    /*Unicode: U+007d (}) , Width: 3 */
    0x00,  //...
    0xc0,  //@%.
    0x40,  //.@.
    0x40,  //.@.
    0x60,  //.%@
    0x40,  //.@.
    0x40,  //.@.
    0xc0,  //@%.
    0x00,  //...
    0x00,  //...


    /*Unicode: U+007e (~) , Width: 5 */
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0xe8,  //+@%.%
    0x38,  //+.%@+
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....
    0x00,  //.....



#elif USE_LV_FONT_DEJAVU_10 == 2
    /*Unicode: U+0020 ( ) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0021 (!) , Width: 1 */
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+0022 (") , Width: 3 */
    0x00,  //...
    0xcc,  //@.@
    0xcc,  //@.@
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0023 (#) , Width: 5 */
    0x09, 0x00,  //..%+.
    0x06, 0x00,  //..+%.
    0xbf, 0xc0,  //%@@@@
    0x22, 0x00,  //.%.%.
    0xff, 0x80,  //@@@@%
    0x24, 0x00,  //.%+..
    0x18, 0x00,  //.+%..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0024 ($) , Width: 5 */
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x7f, 0xc0,  //+@@@@
    0xdc, 0x00,  //@+@..
    0x6f, 0x40,  //+%@@+
    0x0c, 0xc0,  //..@.@
    0xff, 0x40,  //@@@@+
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0025 (%) , Width: 7 */
    0x00, 0x00,  //.......
    0xb8, 0xd0,  //%@%.@+.
    0xdd, 0xc0,  //@+@+@..
    0xbb, 0x40,  //%@%@+..
    0x07, 0xb8,  //..+@%@%
    0x0d, 0xdc,  //..@+@+@
    0x1c, 0xb8,  //.+@.%@%
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0026 (&) , Width: 5 */
    0x00, 0x00,  //.....
    0x2f, 0x00,  //.%@@.
    0x30, 0x00,  //.@...
    0x38, 0x00,  //.@%..
    0xae, 0xc0,  //%%@%@
    0xdf, 0x00,  //@+@@.
    0x7e, 0x80,  //+@%%%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0027 (') , Width: 1 */
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+0028 (() , Width: 2 */
    0x20,  //.%
    0x90,  //%+
    0xc0,  //@.
    0xc0,  //@.
    0xc0,  //@.
    0x90,  //%+
    0x20,  //.%
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0029 ()) , Width: 2 */
    0x80,  //%.
    0x60,  //+%
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x60,  //+%
    0x80,  //%.
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002a (*) , Width: 5 */
    0x00, 0x00,  //.....
    0x8c, 0x80,  //%.@.%
    0x2e, 0x00,  //.%@%.
    0x2e, 0x00,  //.%@%.
    0x8c, 0x80,  //%.@.%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+002b (+) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+002c (,) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+002d (-) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xf0,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002e (.) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+002f (/) , Width: 3 */
    0x00,  //...
    0x0c,  //..@
    0x18,  //.+%
    0x24,  //.%+
    0x30,  //.@.
    0x60,  //+%.
    0x90,  //%+.
    0xc0,  //@..
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0030 (0) , Width: 4 */
    0x00,  //....
    0x3c,  //.@@.
    0xd7,  //@++@
    0xc3,  //@..@
    0xc3,  //@..@
    0xd7,  //@++@
    0x3c,  //.@@.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0031 (1) , Width: 3 */
    0x00,  //...
    0xf0,  //@@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0xfc,  //@@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0032 (2) , Width: 5 */
    0x00, 0x00,  //.....
    0xfd, 0x00,  //@@@+.
    0x03, 0x00,  //...@.
    0x06, 0x00,  //..+%.
    0x1c, 0x00,  //.+@..
    0x70, 0x00,  //+@...
    0xff, 0x00,  //@@@@.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0033 (3) , Width: 4 */
    0x00,  //....
    0xfd,  //@@@+
    0x03,  //...@
    0x03,  //...@
    0x3d,  //.@@+
    0x07,  //..+@
    0xfd,  //@@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0034 (4) , Width: 4 */
    0x00,  //....
    0x0c,  //..@.
    0x2c,  //.%@.
    0x3c,  //.@@.
    0x9c,  //%+@.
    0xff,  //@@@@
    0x0c,  //..@.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0035 (5) , Width: 4 */
    0x00,  //....
    0xff,  //@@@@
    0xc0,  //@...
    0xfd,  //@@@+
    0x07,  //..+@
    0x07,  //..+@
    0xfd,  //@@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0036 (6) , Width: 4 */
    0x00,  //....
    0x2f,  //.%@@
    0xa0,  //%%..
    0xc0,  //@...
    0xee,  //@%@%
    0xc3,  //@..@
    0x3d,  //.@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0037 (7) , Width: 4 */
    0x00,  //....
    0xff,  //@@@@
    0x06,  //..+%
    0x0d,  //..@+
    0x0c,  //..@.
    0x18,  //.+%.
    0x30,  //.@..
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0038 (8) , Width: 4 */
    0x00,  //....
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0xc3,  //@..@
    0xbe,  //%@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0039 (9) , Width: 4 */
    0x00,  //....
    0x7c,  //+@@.
    0xc3,  //@..@
    0xbb,  //%@%@
    0x03,  //...@
    0x0a,  //..%%
    0xf8,  //@@%.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+003a (:) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003b (;) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003c (<) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x01, 0xc0,  //...+@
    0x7e, 0x00,  //+@@%.
    0x7e, 0x00,  //+@@%.
    0x01, 0xc0,  //...+@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+003d (=) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+003e (>) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xd0, 0x00,  //@+...
    0x2f, 0x40,  //.%@@+
    0x2f, 0x40,  //.%@@+
    0xd0, 0x00,  //@+...
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+003f (?) , Width: 3 */
    0x00,  //...
    0xf8,  //@@%
    0x0c,  //..@
    0x20,  //.%.
    0x30,  //.@.
    0x00,  //...
    0x30,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0040 (@) , Width: 7 */
    0x00, 0x00,  //.......
    0x1f, 0xd0,  //.+@@@+.
    0x74, 0x28,  //+@+..%%
    0xca, 0xcc,  //@.%%@.@
    0xcd, 0xdc,  //@.@+@+@
    0xda, 0xe0,  //@.%%@%.
    0x74, 0x40,  //+@+.+..
    0x1f, 0x40,  //.+@@+..
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0041 (A) , Width: 5 */
    0x00, 0x00,  //.....
    0x0c, 0x00,  //..@..
    0x1d, 0x00,  //.+@+.
    0x3b, 0x00,  //.@%@.
    0x33, 0x00,  //.@.@.
    0x7f, 0x40,  //+@@@+
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0042 (B) , Width: 4 */
    0x00,  //....
    0xfd,  //@@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0xfd,  //@@@+
    0xc3,  //@..@
    0xfe,  //@@@%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0043 (C) , Width: 5 */
    0x00, 0x00,  //.....
    0x2f, 0x40,  //.%@@+
    0xa0, 0x80,  //%%..%
    0xc0, 0x00,  //@....
    0xc0, 0x00,  //@....
    0xa0, 0x80,  //%%..%
    0x2f, 0x40,  //.%@@+
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0044 (D) , Width: 5 */
    0x00, 0x00,  //.....
    0xfe, 0x00,  //@@@%.
    0xc2, 0x80,  //@..%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xc2, 0x80,  //@..%%
    0xfe, 0x00,  //@@@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0045 (E) , Width: 4 */
    0x00,  //....
    0xff,  //@@@@
    0xc0,  //@...
    0xc0,  //@...
    0xff,  //@@@@
    0xc0,  //@...
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0046 (F) , Width: 3 */
    0x00,  //...
    0xfc,  //@@@
    0xc0,  //@..
    0xc0,  //@..
    0xfc,  //@@@
    0xc0,  //@..
    0xc0,  //@..
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0047 (G) , Width: 5 */
    0x00, 0x00,  //.....
    0x2f, 0x40,  //.%@@+
    0xa0, 0x80,  //%%..%
    0xc3, 0xc0,  //@..@@
    0xc0, 0xc0,  //@...@
    0xa0, 0xc0,  //%%..@
    0x2f, 0x40,  //.%@@+
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0048 (H) , Width: 4 */
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xff,  //@@@@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0049 (I) , Width: 1 */
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+004a (J) , Width: 2 */
    0x00,  //..
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0xd0,  //@+
    0x00,  //..


    /*Unicode: U+004b (K) , Width: 5 */
    0x00, 0x00,  //.....
    0xc3, 0x40,  //@..@+
    0xdd, 0x00,  //@+@+.
    0xf0, 0x00,  //@@...
    0xf8, 0x00,  //@@+..
    0xce, 0x00,  //@.@+.
    0xc3, 0x40,  //@..@+
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+004c (L) , Width: 4 */
    0x00,  //....
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+004d (M) , Width: 5 */
    0x00, 0x00,  //.....
    0xf3, 0xc0,  //@@.@@
    0xf7, 0xc0,  //@@+@@
    0xee, 0xc0,  //@%@+@
    0xcc, 0xc0,  //@.@.@
    0xcc, 0xc0,  //@.@.@
    0xc0, 0xc0,  //@...@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+004e (N) , Width: 4 */
    0x00,  //....
    0xd3,  //@+.@
    0xf3,  //@@.@
    0xe7,  //@%+@
    0xdf,  //@+@@
    0xcf,  //@.@@
    0xc7,  //@.+@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+004f (O) , Width: 5 */
    0x00, 0x00,  //.....
    0x2e, 0x00,  //.%@%.
    0xa2, 0x80,  //%%.%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xa2, 0x80,  //%%.%%
    0x2e, 0x00,  //.%@%.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0050 (P) , Width: 4 */
    0x00,  //....
    0xfd,  //@@@+
    0xc3,  //@..@
    0xfd,  //@@@+
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0051 (Q) , Width: 5 */
    0x00, 0x00,  //.....
    0x2e, 0x00,  //.%@%.
    0xa2, 0x80,  //%%.%%
    0xc0, 0xc0,  //@...@
    0xc0, 0xc0,  //@...@
    0xa2, 0x80,  //%%.%%
    0x2e, 0x00,  //.%@%.
    0x03, 0x00,  //...@.
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0052 (R) , Width: 5 */
    0x00, 0x00,  //.....
    0xfe, 0x00,  //@@@%.
    0xc3, 0x00,  //@..@.
    0xfd, 0x00,  //@@@+.
    0xca, 0x00,  //@.%%.
    0xc3, 0x00,  //@..@.
    0xc1, 0x80,  //@..+%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0053 (S) , Width: 4 */
    0x00,  //....
    0x7f,  //+@@@
    0xc0,  //@...
    0xb8,  //%@%.
    0x0b,  //..%@
    0x03,  //...@
    0xfd,  //@@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0054 (T) , Width: 5 */
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0055 (U) , Width: 4 */
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xd7,  //@++@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0056 (V) , Width: 5 */
    0x00, 0x00,  //.....
    0xc0, 0xc0,  //@...@
    0x62, 0x40,  //+%.%+
    0x33, 0x00,  //.@.@.
    0x3b, 0x00,  //.@%@.
    0x1d, 0x00,  //.+@+.
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0057 (W) , Width: 7 */
    0x00, 0x00,  //.......
    0xc7, 0x4c,  //@.+@+.@
    0x9a, 0x98,  //%+%%%+%
    0x6c, 0xe4,  //+%@.@%+
    0x3c, 0xf0,  //.@@.@@.
    0x38, 0xb0,  //.@%.%@.
    0x24, 0x60,  //.%+.+%.
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+0058 (X) , Width: 5 */
    0x00, 0x00,  //.....
    0xa2, 0x80,  //%%.%%
    0x37, 0x00,  //.@+@.
    0x1d, 0x00,  //.+@+.
    0x1d, 0x00,  //.+@+.
    0x37, 0x00,  //.@+@.
    0x91, 0x80,  //%+.+%
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+0059 (Y) , Width: 5 */
    0x00, 0x00,  //.....
    0xa2, 0x80,  //%+.+%
    0x37, 0x00,  //.@+@.
    0x1d, 0x00,  //.+@+.
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x0c, 0x00,  //..@..
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+005a (Z) , Width: 5 */
    0x00, 0x00,  //.....
    0xff, 0xc0,  //@@@@@
    0x03, 0x40,  //...@+
    0x0d, 0x00,  //..@+.
    0x28, 0x00,  //.%%..
    0x70, 0x00,  //+@...
    0xff, 0xc0,  //@@@@@
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+005b ([) , Width: 2 */
    0x00,  //..
    0xf0,  //@@
    0xc0,  //@.
    0xc0,  //@.
    0xc0,  //@.
    0xc0,  //@.
    0xc0,  //@.
    0xf0,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+005c (\) , Width: 3 */
    0x00,  //...
    0xc0,  //@..
    0x90,  //%+.
    0x60,  //+%.
    0x30,  //.@.
    0x24,  //.%+
    0x18,  //.+%
    0x0c,  //..@
    0x00,  //...
    0x00,  //...


    /*Unicode: U+005d (]) , Width: 2 */
    0x00,  //..
    0xf0,  //@@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0xf0,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+005e (^) , Width: 5 */
    0x00, 0x00,  //.....
    0x1d, 0x00,  //.+@+.
    0x51, 0x40,  //++.++
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....


    /*Unicode: U+005f (_) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xff,  //@@@@
    0x00,  //....


    /*Unicode: U+0060 (`) , Width: 2 */
    0x00,  //..
    0x50,  //++
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0061 (a) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x3e,  //.@@%
    0x7f,  //+@@@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0062 (b) , Width: 4 */
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xed,  //@%@+
    0xc3,  //@..@
    0xc3,  //@..@
    0xed,  //@%@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0063 (c) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0x7c,  //+@@
    0xc0,  //@..
    0xc0,  //@..
    0x7c,  //+@@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0064 (d) , Width: 4 */
    0x03,  //...@
    0x03,  //...@
    0x03,  //...@
    0x7b,  //+@%@
    0xc3,  //@..@
    0xc3,  //@..@
    0x7b,  //+@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0065 (e) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x7e,  //+@@%
    0xff,  //@@@@
    0xd0,  //@+..
    0x7f,  //+@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0066 (f) , Width: 3 */
    0x1c,  //.+@
    0x30,  //.@.
    0x30,  //.@.
    0xfc,  //@@@
    0x30,  //.@.
    0x30,  //.@.
    0x30,  //.@.
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0067 (g) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x7b,  //+@%@
    0xc3,  //@..@
    0xc3,  //@..@
    0x7b,  //+@%@
    0x07,  //..+@
    0x3d,  //.@@+
    0x00,  //....


    /*Unicode: U+0068 (h) , Width: 4 */
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xee,  //@%@%
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0069 (i) , Width: 1 */
    0x00,  //.
    0xc0,  //@
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+006a (j) , Width: 2 */
    0x00,  //..
    0x30,  //.@
    0x00,  //..
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0x30,  //.@
    0xe0,  //@%
    0x00,  //..


    /*Unicode: U+006b (k) , Width: 4 */
    0xc0,  //@...
    0xc0,  //@...
    0xc0,  //@...
    0xcd,  //@.@+
    0xf4,  //@@..
    0xf4,  //@@+.
    0xcd,  //@.@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+006c (l) , Width: 1 */
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+006d (m) , Width: 7 */
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0xed, 0xb8,  //@%@+%@+
    0xc3, 0x0c,  //@..@..@
    0xc3, 0x0c,  //@..@..@
    0xc3, 0x0c,  //@..@..@
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......
    0x00, 0x00,  //.......


    /*Unicode: U+006e (n) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xee,  //@%@%
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+006f (o) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x7d,  //+@@+
    0xc3,  //@..@
    0xc3,  //@..@
    0x7d,  //+@@+
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0070 (p) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xed,  //@%@+
    0xc3,  //@..@
    0xc3,  //@..@
    0xed,  //@%@+
    0xc0,  //@...
    0xc0,  //@...
    0x00,  //....


    /*Unicode: U+0071 (q) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0x7b,  //+@%@
    0xc3,  //@..@
    0xc3,  //@..@
    0x7b,  //+@%@
    0x03,  //...@
    0x03,  //...@
    0x00,  //....


    /*Unicode: U+0072 (r) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xec,  //@%@
    0xd0,  //@+.
    0xc0,  //@..
    0xc0,  //@..
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0073 (s) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x00,  //...
    0xbc,  //%@@
    0xf4,  //@@+
    0x1c,  //.+@
    0xf8,  //@@%
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0074 (t) , Width: 3 */
    0x00,  //...
    0x00,  //...
    0x30,  //.@.
    0xfc,  //@@@
    0x30,  //.@.
    0x30,  //.@.
    0x2c,  //.%@
    0x00,  //...
    0x00,  //...
    0x00,  //...


    /*Unicode: U+0075 (u) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xc3,  //@..@
    0xc3,  //@..@
    0xc3,  //@..@
    0xbb,  //%@%@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0076 (v) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xd7,  //@++@
    0x69,  //+%%+
    0x3c,  //.@@.
    0x28,  //.%%.
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0077 (w) , Width: 6 */
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0xcf, 0x30,  //@.@@.@
    0xbf, 0xe0,  //%%@@%%
    0x75, 0xd0,  //+@++@+
    0x30, 0xc0,  //.@..@.
    0x00, 0x00,  //......
    0x00, 0x00,  //......
    0x00, 0x00,  //......


    /*Unicode: U+0078 (x) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xaa,  //%%%%
    0x3c,  //.@@.
    0x3c,  //.@@.
    0xaa,  //%%%%
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+0079 (y) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xc7,  //@.+@
    0x6d,  //+%@+
    0x3c,  //.@@.
    0x34,  //.@+.
    0x30,  //.@..
    0xd0,  //@+..
    0x00,  //....


    /*Unicode: U+007a (z) , Width: 4 */
    0x00,  //....
    0x00,  //....
    0x00,  //....
    0xff,  //@@@@
    0x0d,  //..@+
    0x38,  //.@%.
    0xff,  //@@@@
    0x00,  //....
    0x00,  //....
    0x00,  //....


    /*Unicode: U+007b ({) , Width: 3 */
    0x00,  //...
    0x2c,  //.%@
    0x30,  //.@.
    0x30,  //.@.
    0xe0,  //@%.
    0x30,  //.@.
    0x30,  //.@.
    0x2c,  //.%@
    0x00,  //...
    0x00,  //...


    /*Unicode: U+007c (|) , Width: 1 */
    0x00,  //.
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0xc0,  //@
    0x00,  //.


    /*Unicode: U+007d (}) , Width: 3 */
    0x00,  //...
    0xe0,  //@%.
    0x30,  //.@.
    0x30,  //.@.
    0x2c,  //.%@
    0x30,  //.@.
    0x30,  //.@.
    0xe0,  //@%.
    0x00,  //...
    0x00,  //...


    /*Unicode: U+007e (~) , Width: 5 */
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0xb8, 0x80,  //+@%.%
    0x4b, 0x80,  //+.%@+
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....
    0x00, 0x00,  //.....



#elif USE_LV_FONT_DEJAVU_10 == 4
    /*Unicode: U+0020 ( ) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0021 (!) , Width: 1 */
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xd0,  //@
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+0022 (") , Width: 3 */
    0x00, 0x00,  //...
    0xf0, 0xf0,  //@.@
    0xf0, 0xf0,  //@.@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0023 (#) , Width: 5 */
    0x00, 0x86, 0x20,  //..%+.
    0x03, 0x58, 0x00,  //..+%.
    0x9f, 0xff, 0xf0,  //%@@@@
    0x08, 0x08, 0x00,  //.%.%.
    0xff, 0xff, 0x90,  //@@@@%
    0x08, 0x53, 0x00,  //.%+..
    0x26, 0x80, 0x00,  //.+%..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0024 ($) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0xf0, 0x00,  //..@..
    0x7e, 0xff, 0xf0,  //+@@@@
    0xe7, 0xf0, 0x00,  //@+@..
    0x4b, 0xfe, 0x70,  //+%@@+
    0x00, 0xf3, 0xf0,  //..@.@
    0xff, 0xfe, 0x70,  //@@@@+
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0025 (%) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x9f, 0x90, 0xc5, 0x00,  //%@%.@+.
    0xf4, 0xf4, 0xd0, 0x00,  //@+@+@..
    0x9f, 0x9c, 0x50, 0x00,  //%@%@+..
    0x00, 0x4d, 0x9f, 0x90,  //..+@%@%
    0x00, 0xc5, 0xf4, 0xf0,  //..@+@+@
    0x05, 0xd0, 0x9f, 0x90,  //.+@.%@%
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0026 (&) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x08, 0xff, 0x00,  //.%@@.
    0x0f, 0x20, 0x00,  //.@...
    0x0d, 0x80, 0x00,  //.@%..
    0xb9, 0xfa, 0xc0,  //%%@%@
    0xe5, 0xdf, 0x30,  //@+@@.
    0x5e, 0xc9, 0xa0,  //+@%%%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0027 (') , Width: 1 */
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+0028 (() , Width: 2 */
    0x0a,  //.%
    0x85,  //%+
    0xd1,  //@.
    0xf0,  //@.
    0xd1,  //@.
    0x85,  //%+
    0x0a,  //.%
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0029 ()) , Width: 2 */
    0xa0,  //%.
    0x58,  //+%
    0x1d,  //.@
    0x0f,  //.@
    0x1d,  //.@
    0x58,  //+%
    0xa0,  //%.
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002a (*) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x91, 0xf1, 0x90,  //%.@.%
    0x1a, 0xfa, 0x10,  //.%@%.
    0x1a, 0xfa, 0x10,  //.%@%.
    0x91, 0xf1, 0x90,  //%.@.%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002b (+) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002c (,) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+002d (-) , Width: 2 */
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0xff,  //@@
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+002e (.) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+002f (/) , Width: 3 */
    0x00, 0x00,  //...
    0x02, 0xd0,  //..@
    0x07, 0x90,  //.+%
    0x0b, 0x40,  //.%+
    0x0f, 0x00,  //.@.
    0x4b, 0x00,  //+%.
    0x97, 0x00,  //%+.
    0xd2, 0x00,  //@..
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0030 (0) , Width: 4 */
    0x00, 0x00,  //....
    0x3e, 0xe3,  //.@@.
    0xc5, 0x5c,  //@++@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xc5, 0x5c,  //@++@
    0x3e, 0xe3,  //.@@.
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0031 (1) , Width: 3 */
    0x00, 0x00,  //...
    0xff, 0x00,  //@@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0xff, 0xf0,  //@@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0032 (2) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xff, 0xe6, 0x00,  //@@@+.
    0x00, 0x3f, 0x00,  //...@.
    0x00, 0x4b, 0x00,  //..+%.
    0x04, 0xd1, 0x00,  //.+@..
    0x6e, 0x20, 0x00,  //+@...
    0xff, 0xff, 0x00,  //@@@@.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0033 (3) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xe5,  //@@@+
    0x00, 0x3e,  //...@
    0x00, 0x3d,  //...@
    0x0f, 0xf5,  //.@@+
    0x00, 0x4e,  //..+@
    0xff, 0xe7,  //@@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0034 (4) , Width: 4 */
    0x00, 0x00,  //....
    0x02, 0xf0,  //..@.
    0x0a, 0xf0,  //.%@.
    0x2e, 0xf0,  //.@@.
    0xa7, 0xf0,  //%+@.
    0xff, 0xff,  //@@@@
    0x00, 0xf0,  //..@.
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0035 (5) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xff, 0xd4,  //@@@+
    0x00, 0x4e,  //..+@
    0x00, 0x4e,  //..+@
    0xff, 0xd4,  //@@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0036 (6) , Width: 4 */
    0x00, 0x00,  //....
    0x1b, 0xff,  //.%@@
    0xab, 0x10,  //%%..
    0xe3, 0x00,  //@...
    0xfa, 0xf8,  //@%@%
    0xc3, 0x3f,  //@..@
    0x3d, 0xe7,  //.@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0037 (7) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xfe,  //@@@@
    0x00, 0x79,  //..+%
    0x00, 0xc4,  //..@+
    0x02, 0xe0,  //..@.
    0x07, 0x90,  //.+%.
    0x0d, 0x30,  //.@..
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0038 (8) , Width: 4 */
    0x00, 0x00,  //....
    0x6e, 0xe6,  //+@@+
    0xe3, 0x3e,  //@..@
    0xd3, 0x3d,  //@..@
    0x5f, 0xf5,  //+@@+
    0xe3, 0x3e,  //@..@
    0x8f, 0xf8,  //%@@%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0039 (9) , Width: 4 */
    0x00, 0x00,  //....
    0x7e, 0xd3,  //+@@.
    0xf3, 0x3c,  //@..@
    0x8f, 0xaf,  //%@%@
    0x00, 0x3e,  //...@
    0x01, 0xba,  //..%%
    0xff, 0xb1,  //@@%.
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+003a (:) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003b (;) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003c (<) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x27, 0xd0,  //...+@
    0x7c, 0xe9, 0x30,  //+@@%.
    0x7c, 0xe8, 0x30,  //+@@%.
    0x00, 0x27, 0xd0,  //...+@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003d (=) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003e (>) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0xd7, 0x20, 0x00,  //@+...
    0x39, 0xec, 0x70,  //.%@@+
    0x38, 0xec, 0x70,  //.%@@+
    0xd7, 0x20, 0x00,  //@+...
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003f (?) , Width: 3 */
    0x00, 0x00,  //...
    0xff, 0x90,  //@@%
    0x01, 0xd0,  //..@
    0x08, 0x20,  //.%.
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0040 (@) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x04, 0xcf, 0xd7, 0x00,  //.+@@@+.
    0x4e, 0x40, 0x2b, 0x80,  //+@+..%%
    0xd3, 0xab, 0xf1, 0xe0,  //@.%%@.@
    0xf0, 0xf4, 0xf4, 0xd0,  //@.@+@+@
    0xd4, 0xab, 0xeb, 0x20,  //@.%%@%.
    0x5e, 0x40, 0x53, 0x00,  //+@+.+..
    0x05, 0xdf, 0x60, 0x00,  //.+@@+..
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0041 (A) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x01, 0xf1, 0x00,  //..@..
    0x07, 0xf6, 0x00,  //.+@+.
    0x0c, 0x8c, 0x00,  //.@%@.
    0x2e, 0x0e, 0x20,  //.@.@.
    0x7f, 0xff, 0x70,  //+@@@+
    0xd3, 0x03, 0xd0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0042 (B) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xe6,  //@@@+
    0xf0, 0x2e,  //@..@
    0xf0, 0x2d,  //@..@
    0xff, 0xf6,  //@@@+
    0xf0, 0x3e,  //@..@
    0xff, 0xf8,  //@@@%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0043 (C) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x09, 0xee, 0x60,  //.%@@+
    0x9a, 0x10, 0x80,  //%%..%
    0xe1, 0x00, 0x00,  //@....
    0xe1, 0x00, 0x00,  //@....
    0x9a, 0x10, 0x80,  //%%..%
    0x09, 0xee, 0x60,  //.%@@+
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0044 (D) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xff, 0xea, 0x10,  //@@@%.
    0xf0, 0x19, 0xa0,  //@..%%
    0xf0, 0x01, 0xe0,  //@...@
    0xf0, 0x01, 0xe0,  //@...@
    0xf0, 0x19, 0xa0,  //@..%%
    0xff, 0xea, 0x10,  //@@@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0045 (E) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0046 (F) , Width: 3 */
    0x00, 0x00,  //...
    0xff, 0xf0,  //@@@
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0xff, 0xf0,  //@@@
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0047 (G) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x1a, 0xee, 0x60,  //.%@@+
    0xa9, 0x11, 0x80,  //%%..%
    0xe1, 0x0f, 0xf0,  //@..@@
    0xe1, 0x00, 0xf0,  //@...@
    0xa8, 0x01, 0xf0,  //%%..@
    0x1a, 0xee, 0x50,  //.%@@+
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0048 (H) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xff, 0xff,  //@@@@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0049 (I) , Width: 1 */
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+004a (J) , Width: 2 */
    0x00,  //..
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x2e,  //.@
    0xf6,  //@+
    0x00,  //..


    /*Unicode: U+004b (K) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xf0, 0x3e, 0x60,  //@..@+
    0xf4, 0xe5, 0x00,  //@+@+.
    0xff, 0x30, 0x00,  //@@...
    0xfc, 0x80, 0x00,  //@@+..
    0xf1, 0xd8, 0x00,  //@.@+.
    0xf0, 0x1d, 0x70,  //@..@+
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+004c (L) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+004d (M) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xfe, 0x0e, 0xf0,  //@@.@@
    0xfc, 0x7c, 0xf0,  //@@+@@
    0xf8, 0xf8, 0xf0,  //@%@+@
    0xf3, 0xf3, 0xf0,  //@.@.@
    0xf0, 0xd0, 0xf0,  //@.@.@
    0xf0, 0x00, 0xf0,  //@...@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+004e (N) , Width: 4 */
    0x00, 0x00,  //....
    0xf7, 0x0f,  //@+.@
    0xfe, 0x0f,  //@@.@
    0xfb, 0x7f,  //@%+@
    0xf4, 0xef,  //@+@@
    0xf0, 0xdf,  //@.@@
    0xf0, 0x6f,  //@.+@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+004f (O) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x1b, 0xfb, 0x10,  //.%@%.
    0xa8, 0x08, 0xa0,  //%%.%%
    0xe1, 0x01, 0xe0,  //@...@
    0xe0, 0x01, 0xe0,  //@...@
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1b, 0xfb, 0x10,  //.%@%.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0050 (P) , Width: 4 */
    0x00, 0x00,  //....
    0xff, 0xe7,  //@@@+
    0xf0, 0x3f,  //@..@
    0xff, 0xe7,  //@@@+
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0051 (Q) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x1b, 0xfb, 0x10,  //.%@%.
    0xa8, 0x08, 0xa0,  //%%.%%
    0xe1, 0x01, 0xe0,  //@...@
    0xe0, 0x01, 0xe0,  //@...@
    0xa8, 0x08, 0x90,  //%%.%%
    0x1b, 0xfb, 0x00,  //.%@%.
    0x00, 0x3e, 0x10,  //...@.
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0052 (R) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xff, 0xe8, 0x00,  //@@@%.
    0xf0, 0x3f, 0x00,  //@..@.
    0xff, 0xf5, 0x00,  //@@@+.
    0xf0, 0x8a, 0x00,  //@.%%.
    0xf0, 0x0e, 0x30,  //@..@.
    0xf0, 0x06, 0xb0,  //@..+%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0053 (S) , Width: 4 */
    0x00, 0x00,  //....
    0x6e, 0xff,  //+@@@
    0xf3, 0x00,  //@...
    0xbc, 0x81,  //%@%.
    0x03, 0x9d,  //..%@
    0x00, 0x3f,  //...@
    0xff, 0xe6,  //@@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0054 (T) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xf0,  //@@@@@
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0055 (U) , Width: 4 */
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xd4, 0x4d,  //@++@
    0x4e, 0xe4,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0056 (V) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xd3, 0x03, 0xd0,  //@...@
    0x79, 0x09, 0x70,  //+%.%+
    0x2e, 0x0e, 0x20,  //.@.@.
    0x0c, 0x8c, 0x00,  //.@%@.
    0x07, 0xf6, 0x00,  //.+@+.
    0x01, 0xf1, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0057 (W) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0xe2, 0x7f, 0x72, 0xe0,  //@.+@+.@
    0xa5, 0xaa, 0xa5, 0xa0,  //%+%%%+%
    0x69, 0xe3, 0xe9, 0x60,  //+%@.@%+
    0x2e, 0xe0, 0xee, 0x20,  //.@@.@@.
    0x0f, 0xa0, 0xaf, 0x00,  //.@%.%@.
    0x0b, 0x60, 0x7b, 0x00,  //.%+.+%.
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0058 (X) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xa8, 0x08, 0xa0,  //%%.%%
    0x1e, 0x5e, 0x10,  //.@+@.
    0x06, 0xf6, 0x00,  //.+@+.
    0x06, 0xf6, 0x00,  //.+@+.
    0x1e, 0x4e, 0x10,  //.@+@.
    0xa7, 0x07, 0xa0,  //%+.+%
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0059 (Y) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xa8, 0x08, 0xa0,  //%+.+%
    0x1e, 0x5e, 0x10,  //.@+@.
    0x06, 0xf6, 0x00,  //.+@+.
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0xf0, 0x00,  //..@..
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005a (Z) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xe0,  //@@@@@
    0x00, 0x2f, 0x40,  //...@+
    0x00, 0xc7, 0x00,  //..@+.
    0x09, 0xb0, 0x00,  //.%%..
    0x5d, 0x10, 0x00,  //+@...
    0xef, 0xff, 0xf0,  //@@@@@
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005b ([) , Width: 2 */
    0x00,  //..
    0xff,  //@@
    0xf0,  //@.
    0xf0,  //@.
    0xf0,  //@.
    0xf0,  //@.
    0xf0,  //@.
    0xff,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+005c (\) , Width: 3 */
    0x00, 0x00,  //...
    0xd2, 0x00,  //@..
    0x97, 0x00,  //%+.
    0x4b, 0x00,  //+%.
    0x0f, 0x00,  //.@.
    0x0b, 0x40,  //.%+
    0x07, 0x90,  //.+%
    0x02, 0xd0,  //..@
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+005d (]) , Width: 2 */
    0x00,  //..
    0xff,  //@@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0xff,  //@@
    0x00,  //..
    0x00,  //..


    /*Unicode: U+005e (^) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x06, 0xc6, 0x00,  //.+@+.
    0x76, 0x06, 0x70,  //++.++
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005f (_) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xff, 0xff,  //@@@@
    0x00, 0x00,  //....


    /*Unicode: U+0060 (`) , Width: 2 */
    0x00,  //..
    0x55,  //++
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..
    0x00,  //..


    /*Unicode: U+0061 (a) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x0f, 0xf9,  //.@@%
    0x7e, 0xff,  //+@@@
    0xf3, 0x3f,  //@..@
    0x9f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0062 (b) , Width: 4 */
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xfa, 0xf6,  //@%@+
    0xf3, 0x3e,  //@..@
    0xf3, 0x3e,  //@..@
    0xfa, 0xf6,  //@%@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0063 (c) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x6e, 0xf0,  //+@@
    0xe3, 0x00,  //@..
    0xe3, 0x00,  //@..
    0x6e, 0xf0,  //+@@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0064 (d) , Width: 4 */
    0x00, 0x0f,  //...@
    0x00, 0x0f,  //...@
    0x00, 0x0f,  //...@
    0x6f, 0x9f,  //+@%@
    0xe3, 0x3f,  //@..@
    0xe3, 0x3f,  //@..@
    0x6f, 0x9f,  //+@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0065 (e) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x5e, 0xf8,  //+@@%
    0xef, 0xff,  //@@@@
    0xe4, 0x00,  //@+..
    0x4d, 0xff,  //+@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0066 (f) , Width: 3 */
    0x07, 0xf0,  //.+@
    0x0e, 0x10,  //.@.
    0x0f, 0x00,  //.@.
    0xff, 0xf0,  //@@@
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0067 (g) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x6f, 0xaf,  //+@%@
    0xe3, 0x3f,  //@..@
    0xe3, 0x3f,  //@..@
    0x6f, 0xaf,  //+@%@
    0x00, 0x4d,  //..+@
    0x0f, 0xe5,  //.@@+
    0x00, 0x00,  //....


    /*Unicode: U+0068 (h) , Width: 4 */
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf9, 0xf8,  //@%@%
    0xf3, 0x3f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0069 (i) , Width: 1 */
    0x00,  //.
    0xf0,  //@
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+006a (j) , Width: 2 */
    0x00,  //..
    0x0f,  //.@
    0x00,  //..
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x0f,  //.@
    0x1f,  //.@
    0xf8,  //@%
    0x00,  //..


    /*Unicode: U+006b (k) , Width: 4 */
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0xf3, 0xe6,  //@.@+
    0xfe, 0x40,  //@@..
    0xfe, 0x60,  //@@+.
    0xf2, 0xd7,  //@.@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+006c (l) , Width: 1 */
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+006d (m) , Width: 7 */
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0xf9, 0xf7, 0xaf, 0x80,  //@%@+%@+
    0xf3, 0x2f, 0x32, 0xf0,  //@..@..@
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@
    0xf0, 0x0f, 0x00, 0xf0,  //@..@..@
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+006e (n) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xf9, 0xf8,  //@%@%
    0xf3, 0x3f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+006f (o) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x5e, 0xe5,  //+@@+
    0xe3, 0x3e,  //@..@
    0xe3, 0x3e,  //@..@
    0x5e, 0xe5,  //+@@+
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0070 (p) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xfa, 0xf6,  //@%@+
    0xf3, 0x3e,  //@..@
    0xf3, 0x3e,  //@..@
    0xfa, 0xf6,  //@%@+
    0xf0, 0x00,  //@...
    0xf0, 0x00,  //@...
    0x00, 0x00,  //....


    /*Unicode: U+0071 (q) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x6f, 0x9f,  //+@%@
    0xe3, 0x3f,  //@..@
    0xe3, 0x3f,  //@..@
    0x6f, 0x9f,  //+@%@
    0x00, 0x0f,  //...@
    0x00, 0x0f,  //...@
    0x00, 0x00,  //....


    /*Unicode: U+0072 (r) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xf9, 0xf0,  //@%@
    0xf4, 0x00,  //@+.
    0xf0, 0x00,  //@..
    0xf0, 0x00,  //@..
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0073 (s) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0xaf, 0xf0,  //%@@
    0xdc, 0x50,  //@@+
    0x05, 0xf0,  //.+@
    0xff, 0xa0,  //@@%
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0074 (t) , Width: 3 */
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x0f, 0x00,  //.@.
    0xff, 0xf0,  //@@@
    0x0f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0a, 0xf0,  //.%@
    0x00, 0x00,  //...
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+0075 (u) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xf0, 0x0f,  //@..@
    0xf0, 0x0f,  //@..@
    0xf3, 0x3f,  //@..@
    0x8f, 0x9f,  //%@%@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0076 (v) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xc4, 0x4c,  //@++@
    0x6a, 0xa6,  //+%%+
    0x0e, 0xe0,  //.@@.
    0x0a, 0xa0,  //.%%.
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0077 (w) , Width: 6 */
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0xd3, 0xee, 0x3d,  //@.@@.@
    0x8c, 0xcc, 0xc8,  //%%@@%%
    0x4f, 0x77, 0xf4,  //+@++@+
    0x0f, 0x22, 0xf0,  //.@..@.
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00,  //......


    /*Unicode: U+0078 (x) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x9a, 0xa9,  //%%%%
    0x0c, 0xc0,  //.@@.
    0x0d, 0xc0,  //.@@.
    0xa9, 0xa9,  //%%%%
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+0079 (y) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xd3, 0x5c,  //@.+@
    0x79, 0xc5,  //+%@+
    0x1f, 0xd0,  //.@@.
    0x0d, 0x60,  //.@+.
    0x0e, 0x00,  //.@..
    0xf7, 0x00,  //@+..
    0x00, 0x00,  //....


    /*Unicode: U+007a (z) , Width: 4 */
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0xff, 0xfe,  //@@@@
    0x02, 0xe4,  //..@+
    0x2e, 0x80,  //.@%.
    0xef, 0xff,  //@@@@
    0x00, 0x00,  //....
    0x00, 0x00,  //....
    0x00, 0x00,  //....


    /*Unicode: U+007b ({) , Width: 3 */
    0x00, 0x00,  //...
    0x0a, 0xf0,  //.%@
    0x0f, 0x00,  //.@.
    0x1f, 0x00,  //.@.
    0xf8, 0x00,  //@%.
    0x1f, 0x00,  //.@.
    0x0f, 0x00,  //.@.
    0x0a, 0xf0,  //.%@
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+007c (|) , Width: 1 */
    0x00,  //.
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0xf0,  //@
    0x00,  //.


    /*Unicode: U+007d (}) , Width: 3 */
    0x00, 0x00,  //...
    0xfa, 0x00,  //@%.
    0x1f, 0x00,  //.@.
    0x0f, 0x10,  //.@.
    0x08, 0xf0,  //.%@
    0x0f, 0x10,  //.@.
    0x0f, 0x00,  //.@.
    0xfa, 0x00,  //@%.
    0x00, 0x00,  //...
    0x00, 0x00,  //...


    /*Unicode: U+007e (~) , Width: 5 */
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x8e, 0x81, 0x80,  //+@%.%
    0x41, 0x8e, 0x80,  //+.%@+
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00,  //.....



#elif USE_LV_FONT_DEJAVU_10 == 8
    /*Unicode: U+0020 ( ) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0021 (!) , Width: 1 */
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0xfa,  //@
    0xdc,  //@
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+0022 (") , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xff, 0x00, 0xff,  //@.@
    0xff, 0x00, 0xff,  //@.@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0023 (#) , Width: 5 */
    0x00, 0x08, 0x88, 0x66, 0x28,  //..%+.
    0x00, 0x36, 0x5a, 0x8e, 0x02,  //..+%.
    0x96, 0xff, 0xff, 0xff, 0xff,  //%@@@@
    0x00, 0x8a, 0x0c, 0x8c, 0x00,  //.%.%.
    0xff, 0xff, 0xff, 0xff, 0x96,  //@@@@%
    0x00, 0x8c, 0x5a, 0x36, 0x00,  //.%+..
    0x26, 0x6a, 0x84, 0x08, 0x00,  //.+%..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0024 ($) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x78, 0xea, 0xff, 0xff, 0xff,  //+@@@@
    0xee, 0x70, 0xff, 0x08, 0x00,  //@+@..
    0x48, 0xb0, 0xff, 0xee, 0x7e,  //+%@@+
    0x00, 0x00, 0xff, 0x30, 0xf2,  //..@.@
    0xf8, 0xf0, 0xff, 0xe8, 0x78,  //@@@@+
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0025 (%) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x90, 0xf4, 0x90, 0x00, 0xc4, 0x56, 0x00,  //%@%.@+.
    0xf4, 0x42, 0xf4, 0x46, 0xd2, 0x00, 0x00,  //@+@+@..
    0x92, 0xf4, 0x94, 0xc8, 0x54, 0x00, 0x00,  //%@%@+..
    0x00, 0x00, 0x4c, 0xd2, 0x92, 0xf4, 0x90,  //..+@%@%
    0x00, 0x00, 0xce, 0x52, 0xf4, 0x42, 0xf4,  //..@+@+@
    0x00, 0x52, 0xd0, 0x00, 0x90, 0xf4, 0x90,  //.+@.%@%
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0026 (&) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x86, 0xf6, 0xff, 0x00,  //.%@@.
    0x00, 0xf8, 0x2a, 0x00, 0x00,  //.@...
    0x06, 0xde, 0x86, 0x00, 0x00,  //.@%..
    0xb8, 0x9a, 0xf2, 0xa6, 0xc8,  //%%@%@
    0xea, 0x52, 0xde, 0xff, 0x32,  //@+@@.
    0x54, 0xe0, 0xc0, 0x9c, 0xa6,  //+@%%%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0027 (') , Width: 1 */
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+0028 (() , Width: 2 */
    0x0e, 0xa2,  //.%
    0x82, 0x56,  //%+
    0xda, 0x18,  //@.
    0xf8, 0x02,  //@.
    0xda, 0x18,  //@.
    0x82, 0x56,  //%+
    0x0e, 0xa2,  //.%
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+0029 ()) , Width: 2 */
    0xa2, 0x0e,  //%.
    0x56, 0x82,  //+%
    0x18, 0xda,  //.@
    0x04, 0xf8,  //.@
    0x18, 0xda,  //.@
    0x56, 0x82,  //+%
    0xa2, 0x0e,  //%.
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+002a (*) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x9e, 0x1a, 0xff, 0x1a, 0x9e,  //%.@.%
    0x1a, 0xa6, 0xff, 0xa6, 0x1a,  //.%@%.
    0x1a, 0xa6, 0xff, 0xa6, 0x1a,  //.%@%.
    0x9e, 0x1a, 0xff, 0x1a, 0x9e,  //%.@.%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002b (+) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+002c (,) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+002d (-) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+002e (.) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+002f (/) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x2e, 0xda,  //..@
    0x00, 0x76, 0x92,  //.+%
    0x00, 0xbe, 0x4c,  //.%+
    0x0a, 0xf2, 0x0a,  //.@.
    0x4c, 0xbc, 0x00,  //+%.
    0x94, 0x74, 0x00,  //%+.
    0xda, 0x2e, 0x00,  //@..
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0030 (0) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x3a, 0xe0, 0xe0, 0x3a,  //.@@.
    0xc4, 0x54, 0x54, 0xc4,  //@++@
    0xf2, 0x08, 0x08, 0xf2,  //@..@
    0xf2, 0x08, 0x08, 0xf2,  //@..@
    0xc4, 0x54, 0x54, 0xc4,  //@++@
    0x3a, 0xe0, 0xe0, 0x3a,  //.@@.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0031 (1) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0x00,  //@@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0xff, 0xff, 0xff,  //@@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0032 (2) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xe4, 0x66, 0x00,  //@@@+.
    0x00, 0x00, 0x3e, 0xf0, 0x00,  //...@.
    0x00, 0x00, 0x44, 0xba, 0x00,  //..+%.
    0x00, 0x48, 0xda, 0x1e, 0x00,  //.+@..
    0x6c, 0xe0, 0x2a, 0x00, 0x00,  //+@...
    0xff, 0xff, 0xff, 0xff, 0x06,  //@@@@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0033 (3) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xe0, 0x52,  //@@@+
    0x00, 0x00, 0x3e, 0xea,  //...@
    0x00, 0x00, 0x3a, 0xd4,  //...@
    0x00, 0xff, 0xf6, 0x54,  //.@@+
    0x00, 0x00, 0x44, 0xec,  //..+@
    0xff, 0xfc, 0xe6, 0x76,  //@@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0034 (4) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x24, 0xfa, 0x00,  //..@.
    0x00, 0xa4, 0xff, 0x00,  //.%@.
    0x2a, 0xe6, 0xff, 0x00,  //.@@.
    0xaa, 0x74, 0xff, 0x00,  //%+@.
    0xfc, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0xff, 0x00,  //..@.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0035 (5) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xf0, 0xdc, 0x4a,  //@@@+
    0x00, 0x02, 0x4e, 0xe4,  //..+@
    0x00, 0x02, 0x4a, 0xe4,  //..+@
    0xff, 0xfc, 0xda, 0x4c,  //@@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0036 (6) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x16, 0xb2, 0xf4, 0xff,  //.%@@
    0xa6, 0xb6, 0x10, 0x00,  //%%..
    0xec, 0x3a, 0x00, 0x00,  //@...
    0xf2, 0xa4, 0xf2, 0x82,  //@%@%
    0xc2, 0x3a, 0x3a, 0xf0,  //@..@
    0x36, 0xdc, 0xee, 0x78,  //.@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0037 (7) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xea,  //@@@@
    0x00, 0x00, 0x72, 0x98,  //..+%
    0x00, 0x00, 0xca, 0x42,  //..@+
    0x00, 0x22, 0xe6, 0x02,  //..@.
    0x00, 0x7a, 0x94, 0x00,  //.+%.
    0x00, 0xd2, 0x3e, 0x00,  //.@..
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0038 (8) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x60, 0xea, 0xea, 0x60,  //+@@+
    0xee, 0x32, 0x32, 0xee,  //@..@
    0xd4, 0x32, 0x32, 0xd2,  //@..@
    0x52, 0xf8, 0xf8, 0x50,  //+@@+
    0xee, 0x3a, 0x3a, 0xec,  //@..@
    0x86, 0xf0, 0xf0, 0x86,  //%@@%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0039 (9) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x74, 0xee, 0xdc, 0x36,  //+@@.
    0xf2, 0x3a, 0x3a, 0xc2,  //@..@
    0x86, 0xf2, 0xa6, 0xf0,  //%@%@
    0x00, 0x00, 0x3c, 0xec,  //...@
    0x00, 0x10, 0xb8, 0xa6,  //..%%
    0xff, 0xf4, 0xb2, 0x16,  //@@%.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+003a (:) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003b (;) , Width: 1 */
    0x00,  //.
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0x00,  //.


    /*Unicode: U+003c (<) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x24, 0x7a, 0xd2,  //...+@
    0x76, 0xcc, 0xe4, 0x90, 0x36,  //+@@%.
    0x76, 0xce, 0xe4, 0x8e, 0x36,  //+@@%.
    0x00, 0x00, 0x24, 0x7c, 0xd2,  //...+@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003d (=) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003e (>) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xd2, 0x7a, 0x24, 0x00, 0x00,  //@+...
    0x36, 0x90, 0xe6, 0xcc, 0x76,  //.%@@+
    0x36, 0x8e, 0xe4, 0xce, 0x76,  //.%@@+
    0xd2, 0x7c, 0x24, 0x00, 0x00,  //@+...
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+003f (?) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xff, 0xf8, 0x9c,  //@@%
    0x00, 0x1a, 0xdc,  //..@
    0x00, 0x82, 0x22,  //.%.
    0x00, 0xf8, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0040 (@) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x46, 0xcc, 0xf8, 0xde, 0x7a, 0x00,  //.+@@@+.
    0x4a, 0xe6, 0x42, 0x08, 0x2c, 0xbc, 0x86,  //+@+..%%
    0xd2, 0x3e, 0xa8, 0xb8, 0xff, 0x12, 0xec,  //@.%%@.@
    0xf8, 0x08, 0xf6, 0x42, 0xff, 0x46, 0xd4,  //@.@+@+@
    0xd8, 0x40, 0xaa, 0xb8, 0xee, 0xb8, 0x2a,  //@.%%@%.
    0x56, 0xe0, 0x42, 0x08, 0x58, 0x34, 0x00,  //+@+.+..
    0x00, 0x5a, 0xdc, 0xf0, 0x6a, 0x00, 0x00,  //.+@@+..
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0041 (A) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x18, 0xfa, 0x18, 0x00,  //..@..
    0x00, 0x70, 0xfc, 0x6e, 0x00,  //.+@+.
    0x00, 0xc8, 0x8a, 0xc8, 0x00,  //.@%@.
    0x22, 0xe6, 0x06, 0xe6, 0x20,  //.@.@.
    0x7a, 0xff, 0xff, 0xff, 0x78,  //+@@@+
    0xd2, 0x38, 0x00, 0x38, 0xd2,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0042 (B) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xec, 0x6a,  //@@@+
    0xff, 0x00, 0x2e, 0xee,  //@..@
    0xff, 0x00, 0x2e, 0xdc,  //@..@
    0xff, 0xff, 0xfc, 0x64,  //@@@+
    0xff, 0x00, 0x30, 0xee,  //@..@
    0xff, 0xff, 0xf4, 0x8e,  //@@@%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0043 (C) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x0c, 0x9a, 0xe8, 0xea, 0x6e,  //.%@@+
    0x9c, 0xa4, 0x18, 0x0e, 0x88,  //%%..%
    0xea, 0x14, 0x00, 0x00, 0x00,  //@....
    0xea, 0x14, 0x00, 0x00, 0x00,  //@....
    0x9e, 0xa2, 0x16, 0x0e, 0x88,  //%%..%
    0x0e, 0x9c, 0xea, 0xea, 0x6e,  //.%@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0044 (D) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xe6, 0xa4, 0x16,  //@@@%.
    0xff, 0x00, 0x14, 0x98, 0xaa,  //@..%%
    0xff, 0x00, 0x00, 0x12, 0xec,  //@...@
    0xff, 0x00, 0x00, 0x12, 0xec,  //@...@
    0xff, 0x00, 0x14, 0x98, 0xaa,  //@..%%
    0xff, 0xff, 0xe8, 0xa6, 0x16,  //@@@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0045 (E) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0046 (F) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xff, 0xff, 0xff,  //@@@
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0xff, 0xff, 0xff,  //@@@
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0047 (G) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x10, 0xa4, 0xec, 0xe6, 0x6c,  //.%@@+
    0xa2, 0x9c, 0x14, 0x10, 0x8c,  //%%..%
    0xea, 0x12, 0x00, 0xff, 0xff,  //@..@@
    0xec, 0x10, 0x00, 0x00, 0xff,  //@...@
    0xa8, 0x8e, 0x0c, 0x1e, 0xff,  //%%..@
    0x14, 0xaa, 0xee, 0xe4, 0x5c,  //.%@@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0048 (H) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0049 (I) , Width: 1 */
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+004a (J) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xfc,  //.@
    0x2a, 0xe4,  //.@
    0xf2, 0x6a,  //@+
    0x00, 0x00,  //..


    /*Unicode: U+004b (K) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0x00, 0x30, 0xe2, 0x6e,  //@..@+
    0xff, 0x46, 0xe8, 0x50, 0x00,  //@+@+.
    0xff, 0xf2, 0x38, 0x00, 0x00,  //@@...
    0xff, 0xce, 0x80, 0x00, 0x00,  //@@+..
    0xff, 0x12, 0xd0, 0x80, 0x00,  //@.@+.
    0xff, 0x00, 0x12, 0xd0, 0x7e,  //@..@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+004c (L) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+004d (M) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xee, 0x08, 0xee, 0xff,  //@@.@@
    0xff, 0xca, 0x7c, 0xc8, 0xff,  //@@+@@
    0xff, 0x82, 0xf2, 0x80, 0xff,  //@%@+@
    0xff, 0x3a, 0xff, 0x3a, 0xff,  //@.@.@
    0xff, 0x02, 0xde, 0x02, 0xff,  //@.@.@
    0xff, 0x00, 0x00, 0x00, 0xff,  //@...@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+004e (N) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x72, 0x00, 0xff,  //@+.@
    0xff, 0xe6, 0x08, 0xff,  //@@.@
    0xff, 0xb4, 0x74, 0xff,  //@%+@
    0xff, 0x46, 0xe8, 0xff,  //@+@@
    0xff, 0x00, 0xd6, 0xff,  //@.@@
    0xff, 0x00, 0x6a, 0xff,  //@.+@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+004f (O) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x1a, 0xba, 0xf2, 0xba, 0x18,  //.%@%.
    0xac, 0x86, 0x0c, 0x86, 0xaa,  //%%.%%
    0xee, 0x10, 0x00, 0x10, 0xec,  //@...@
    0xee, 0x0e, 0x00, 0x10, 0xec,  //@...@
    0xac, 0x84, 0x0c, 0x84, 0xaa,  //%%.%%
    0x1a, 0xbc, 0xf2, 0xba, 0x1a,  //.%@%.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0050 (P) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xec, 0x7a,  //@@@+
    0xff, 0x00, 0x3e, 0xf0,  //@..@
    0xff, 0xff, 0xee, 0x7e,  //@@@+
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0051 (Q) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x1a, 0xba, 0xf2, 0xbc, 0x1a,  //.%@%.
    0xac, 0x86, 0x0c, 0x86, 0xae,  //%%.%%
    0xee, 0x10, 0x00, 0x10, 0xee,  //@...@
    0xee, 0x0e, 0x00, 0x10, 0xec,  //@...@
    0xac, 0x84, 0x0c, 0x84, 0x98,  //%%.%%
    0x1c, 0xbe, 0xf8, 0xb6, 0x08,  //.%@%.
    0x00, 0x00, 0x3e, 0xe4, 0x14,  //...@.
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0052 (R) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xee, 0x86, 0x00,  //@@@%.
    0xff, 0x00, 0x32, 0xf0, 0x00,  //@..@.
    0xff, 0xff, 0xfc, 0x56, 0x00,  //@@@+.
    0xff, 0x04, 0x8e, 0xaa, 0x00,  //@.%%.
    0xff, 0x00, 0x08, 0xe2, 0x32,  //@..@.
    0xff, 0x00, 0x00, 0x64, 0xba,  //@..+%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0053 (S) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x64, 0xe4, 0xff, 0xff,  //+@@@
    0xf0, 0x36, 0x00, 0x00,  //@...
    0xb8, 0xce, 0x84, 0x1a,  //%@%.
    0x02, 0x3e, 0x96, 0xd0,  //..%@
    0x00, 0x00, 0x34, 0xf0,  //...@
    0xff, 0xff, 0xe8, 0x6c,  //@@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0054 (T) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0055 (U) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xfa, 0x02, 0x02, 0xfa,  //@..@
    0xd6, 0x42, 0x44, 0xd6,  //@++@
    0x4c, 0xe6, 0xe4, 0x4a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0056 (V) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xd2, 0x3a, 0x00, 0x3a, 0xd2,  //@...@
    0x7a, 0x92, 0x00, 0x94, 0x78,  //+%.%+
    0x22, 0xe6, 0x04, 0xe6, 0x20,  //.@.@.
    0x00, 0xc8, 0x88, 0xc8, 0x00,  //.@%@.
    0x00, 0x70, 0xfc, 0x6e, 0x00,  //.+@+.
    0x00, 0x18, 0xfa, 0x18, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0057 (W) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xe0, 0x20, 0x74, 0xfc, 0x74, 0x20, 0xe0,  //@.+@+.@
    0xa6, 0x5c, 0xae, 0xae, 0xae, 0x5c, 0xa4,  //%+%%%+%
    0x6a, 0x98, 0xe8, 0x3a, 0xe8, 0x98, 0x6a,  //+%@.@%+
    0x2e, 0xec, 0xe2, 0x00, 0xe2, 0xec, 0x2e,  //.@@.@@.
    0x02, 0xf0, 0xa8, 0x00, 0xaa, 0xf0, 0x00,  //.@%.%@.
    0x00, 0xb8, 0x6e, 0x00, 0x70, 0xb8, 0x00,  //.%+.+%.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+0058 (X) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xac, 0x84, 0x00, 0x84, 0xac,  //%%.%%
    0x18, 0xea, 0x58, 0xe8, 0x18,  //.@+@.
    0x00, 0x66, 0xff, 0x64, 0x00,  //.+@+.
    0x00, 0x6a, 0xfc, 0x6c, 0x00,  //.+@+.
    0x1a, 0xe6, 0x4c, 0xea, 0x1a,  //.@+@.
    0xae, 0x74, 0x00, 0x7c, 0xae,  //%+.+%
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+0059 (Y) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xac, 0x80, 0x00, 0x80, 0xac,  //%+.+%
    0x18, 0xe8, 0x52, 0xe8, 0x18,  //.@+@.
    0x00, 0x66, 0xff, 0x66, 0x00,  //.+@+.
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0xff, 0x00, 0x00,  //..@..
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005a (Z) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0xff, 0xff, 0xff, 0xff, 0xec,  //@@@@@
    0x00, 0x00, 0x26, 0xf0, 0x48,  //...@+
    0x00, 0x06, 0xce, 0x7e, 0x00,  //..@+.
    0x00, 0x94, 0xb4, 0x00, 0x00,  //.%%..
    0x50, 0xdc, 0x10, 0x00, 0x00,  //+@...
    0xee, 0xff, 0xff, 0xff, 0xff,  //@@@@@
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005b ([) , Width: 2 */
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0xff, 0x00,  //@.
    0xff, 0x00,  //@.
    0xff, 0x00,  //@.
    0xff, 0x00,  //@.
    0xff, 0x00,  //@.
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+005c (\) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xda, 0x2e, 0x00,  //@..
    0x94, 0x74, 0x00,  //%+.
    0x4c, 0xbc, 0x00,  //+%.
    0x0a, 0xf2, 0x0a,  //.@.
    0x00, 0xbe, 0x4c,  //.%+
    0x00, 0x76, 0x92,  //.+%
    0x00, 0x2e, 0xda,  //..@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+005d (]) , Width: 2 */
    0x00, 0x00,  //..
    0xff, 0xff,  //@@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0xff, 0xff,  //@@
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+005e (^) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x68, 0xc4, 0x68, 0x00,  //.+@+.
    0x70, 0x66, 0x00, 0x66, 0x70,  //++.++
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....


    /*Unicode: U+005f (_) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0060 (`) , Width: 2 */
    0x00, 0x00,  //..
    0x5a, 0x5e,  //++
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..
    0x00, 0x00,  //..


    /*Unicode: U+0061 (a) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0xff, 0xf6, 0x92,  //.@@%
    0x7a, 0xec, 0xff, 0xfa,  //+@@@
    0xf2, 0x38, 0x3e, 0xff,  //@..@
    0x96, 0xf0, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0062 (b) , Width: 4 */
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0xa0, 0xf0, 0x64,  //@%@+
    0xff, 0x32, 0x32, 0xea,  //@..@
    0xff, 0x32, 0x32, 0xea,  //@..@
    0xff, 0xa0, 0xf0, 0x66,  //@%@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0063 (c) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x60, 0xec, 0xff,  //+@@
    0xea, 0x36, 0x00,  //@..
    0xea, 0x36, 0x00,  //@..
    0x60, 0xec, 0xff,  //+@@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0064 (d) , Width: 4 */
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0xff,  //...@
    0x64, 0xf0, 0x9e, 0xff,  //+@%@
    0xea, 0x32, 0x32, 0xff,  //@..@
    0xea, 0x32, 0x32, 0xff,  //@..@
    0x66, 0xf0, 0x9e, 0xff,  //+@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0065 (e) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x50, 0xe2, 0xf0, 0x84,  //+@@%
    0xe6, 0xff, 0xff, 0xfa,  //@@@@
    0xe6, 0x4a, 0x02, 0x00,  //@+..
    0x4a, 0xda, 0xfc, 0xff,  //+@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0066 (f) , Width: 3 */
    0x00, 0x72, 0xf4,  //.+@
    0x00, 0xe6, 0x1c,  //.@.
    0x00, 0xfc, 0x00,  //.@.
    0xff, 0xff, 0xff,  //@@@
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xff, 0x00,  //.@.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0067 (g) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x68, 0xf0, 0xa0, 0xff,  //+@%@
    0xea, 0x32, 0x32, 0xff,  //@..@
    0xea, 0x32, 0x32, 0xff,  //@..@
    0x68, 0xf0, 0xa6, 0xf4,  //+@%@
    0x00, 0x00, 0x4e, 0xd2,  //..+@
    0x00, 0xff, 0xec, 0x52,  //.@@+
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0068 (h) , Width: 4 */
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x94, 0xf4, 0x84,  //@%@%
    0xff, 0x38, 0x30, 0xf2,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0069 (i) , Width: 1 */
    0x00,  //.
    0xff,  //@
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+006a (j) , Width: 2 */
    0x00, 0x00,  //..
    0x00, 0xff,  //.@
    0x00, 0x00,  //..
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x00, 0xff,  //.@
    0x1e, 0xf2,  //.@
    0xf4, 0x82,  //@%
    0x00, 0x00,  //..


    /*Unicode: U+006b (k) , Width: 4 */
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x3e, 0xe6, 0x68,  //@.@+
    0xff, 0xea, 0x40, 0x00,  //@@..
    0xff, 0xe2, 0x66, 0x00,  //@@+.
    0xff, 0x20, 0xdc, 0x76,  //@.@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+006c (l) , Width: 1 */
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0x00,  //.
    0x00,  //.
    0x00,  //.


    /*Unicode: U+006d (m) , Width: 7 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0xff, 0x94, 0xf4, 0x70, 0xa2, 0xf4, 0x80,  //@%@+%@+
    0xff, 0x3a, 0x28, 0xfc, 0x38, 0x2e, 0xf2,  //@..@..@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@..@..@
    0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,  //@..@..@
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //.......


    /*Unicode: U+006e (n) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x94, 0xf4, 0x84,  //@%@%
    0xff, 0x38, 0x30, 0xf2,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+006f (o) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0xe8, 0x32, 0x34, 0xe8,  //@..@
    0xe8, 0x32, 0x32, 0xe8,  //@..@
    0x5a, 0xe8, 0xe8, 0x5a,  //+@@+
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0070 (p) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xa0, 0xf0, 0x64,  //@%@+
    0xff, 0x32, 0x32, 0xea,  //@..@
    0xff, 0x32, 0x32, 0xea,  //@..@
    0xff, 0xa0, 0xf0, 0x66,  //@%@+
    0xff, 0x00, 0x00, 0x00,  //@...
    0xff, 0x00, 0x00, 0x00,  //@...
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0071 (q) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x64, 0xf0, 0x9e, 0xff,  //+@%@
    0xea, 0x32, 0x32, 0xff,  //@..@
    0xea, 0x32, 0x32, 0xff,  //@..@
    0x66, 0xf0, 0x9e, 0xff,  //+@%@
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0xff,  //...@
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0072 (r) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xff, 0x90, 0xf8,  //@%@
    0xff, 0x48, 0x00,  //@+.
    0xff, 0x00, 0x00,  //@..
    0xff, 0x00, 0x00,  //@..
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0073 (s) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0xa6, 0xf8, 0xff,  //%@@
    0xd8, 0xce, 0x5e,  //@@+
    0x06, 0x5a, 0xfa,  //.+@
    0xff, 0xf8, 0xa4,  //@@%
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0074 (t) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0xff, 0x00,  //.@.
    0xff, 0xff, 0xff,  //@@@
    0x00, 0xff, 0x00,  //.@.
    0x00, 0xfa, 0x0a,  //.@.
    0x00, 0xac, 0xfa,  //.%@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+0075 (u) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xff, 0x00, 0x00, 0xff,  //@..@
    0xf2, 0x30, 0x3a, 0xff,  //@..@
    0x84, 0xf4, 0x92, 0xff,  //%@%@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0076 (v) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xcc, 0x44, 0x44, 0xcc,  //@++@
    0x6a, 0xa6, 0xa6, 0x6a,  //+%%+
    0x0e, 0xee, 0xee, 0x0e,  //.@@.
    0x00, 0xa4, 0xa4, 0x00,  //.%%.
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0077 (w) , Width: 6 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0xd8, 0x36, 0xee, 0xee, 0x36, 0xd8,  //@.@@.@
    0x8e, 0xc0, 0xc2, 0xc4, 0xc0, 0x8e,  //%%@@%%
    0x42, 0xff, 0x78, 0x78, 0xff, 0x42,  //+@++@+
    0x04, 0xf2, 0x2c, 0x2c, 0xf2, 0x04,  //.@..@.
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  //......


    /*Unicode: U+0078 (x) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x96, 0xac, 0xac, 0x96,  //%%%%
    0x04, 0xc2, 0xc2, 0x04,  //.@@.
    0x0a, 0xd6, 0xcc, 0x06,  //.@@.
    0xa0, 0x9e, 0xa4, 0x9c,  //%%%%
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+0079 (y) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xd0, 0x3c, 0x50, 0xc4,  //@.+@
    0x76, 0x96, 0xc4, 0x50,  //+%@+
    0x1c, 0xf4, 0xda, 0x00,  //.@@.
    0x00, 0xd0, 0x68, 0x00,  //.@+.
    0x04, 0xe4, 0x08, 0x00,  //.@..
    0xfa, 0x78, 0x00, 0x00,  //@+..
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+007a (z) , Width: 4 */
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0xff, 0xff, 0xff, 0xe8,  //@@@@
    0x00, 0x28, 0xe6, 0x46,  //..@+
    0x24, 0xe4, 0x8c, 0x00,  //.@%.
    0xe0, 0xff, 0xff, 0xff,  //@@@@
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....
    0x00, 0x00, 0x00, 0x00,  //....


    /*Unicode: U+007b ({) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0x00, 0xa2, 0xf6,  //.%@
    0x00, 0xf8, 0x0e,  //.@.
    0x14, 0xf6, 0x00,  //.@.
    0xff, 0x8c, 0x00,  //@%.
    0x1e, 0xf4, 0x00,  //.@.
    0x00, 0xf8, 0x0e,  //.@.
    0x00, 0xa4, 0xf8,  //.%@
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+007c (|) , Width: 1 */
    0x00,  //.
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0xff,  //@
    0x00,  //.


    /*Unicode: U+007d (}) , Width: 3 */
    0x00, 0x00, 0x00,  //...
    0xf6, 0xa2, 0x00,  //@%.
    0x10, 0xf8, 0x00,  //.@.
    0x00, 0xf6, 0x14,  //.@.
    0x00, 0x8c, 0xff,  //.%@
    0x00, 0xf4, 0x1e,  //.@.
    0x0e, 0xf8, 0x00,  //.@.
    0xf8, 0xa4, 0x00,  //@%.
    0x00, 0x00, 0x00,  //...
    0x00, 0x00, 0x00,  //...


    /*Unicode: U+007e (~) , Width: 5 */
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x80, 0xec, 0x88, 0x10, 0x82,  //+@%.%
    0x4e, 0x10, 0x8a, 0xec, 0x80,  //+.%@+
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....
    0x00, 0x00, 0x00, 0x00, 0x00,  //.....



#endif
};


/*Store the glyph descriptions*/
static const lv_font_glyph_dsc_t lv_font_dejavu_10_glyph_dsc[] = {
#if USE_LV_FONT_DEJAVU_10 == 1
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 1,   .glyph_index = 10}, /*Unicode: U+0021 (!)*/
    {.w_px = 3,   .glyph_index = 20}, /*Unicode: U+0022 (")*/
    {.w_px = 5,   .glyph_index = 30}, /*Unicode: U+0023 (#)*/
    {.w_px = 5,   .glyph_index = 40}, /*Unicode: U+0024 ($)*/
    {.w_px = 7,   .glyph_index = 50}, /*Unicode: U+0025 (%)*/
    {.w_px = 5,   .glyph_index = 60}, /*Unicode: U+0026 (&)*/
    {.w_px = 1,   .glyph_index = 70}, /*Unicode: U+0027 (')*/
    {.w_px = 2,   .glyph_index = 80}, /*Unicode: U+0028 (()*/
    {.w_px = 2,   .glyph_index = 90}, /*Unicode: U+0029 ())*/
    {.w_px = 5,   .glyph_index = 100},    /*Unicode: U+002a (*)*/
    {.w_px = 5,   .glyph_index = 110},    /*Unicode: U+002b (+)*/
    {.w_px = 1,   .glyph_index = 120},    /*Unicode: U+002c (,)*/
    {.w_px = 2,   .glyph_index = 130},    /*Unicode: U+002d (-)*/
    {.w_px = 1,   .glyph_index = 140},    /*Unicode: U+002e (.)*/
    {.w_px = 3,   .glyph_index = 150},    /*Unicode: U+002f (/)*/
    {.w_px = 4,   .glyph_index = 160},    /*Unicode: U+0030 (0)*/
    {.w_px = 3,   .glyph_index = 170},    /*Unicode: U+0031 (1)*/
    {.w_px = 5,   .glyph_index = 180},    /*Unicode: U+0032 (2)*/
    {.w_px = 4,   .glyph_index = 190},    /*Unicode: U+0033 (3)*/
    {.w_px = 4,   .glyph_index = 200},    /*Unicode: U+0034 (4)*/
    {.w_px = 4,   .glyph_index = 210},    /*Unicode: U+0035 (5)*/
    {.w_px = 4,   .glyph_index = 220},    /*Unicode: U+0036 (6)*/
    {.w_px = 4,   .glyph_index = 230},    /*Unicode: U+0037 (7)*/
    {.w_px = 4,   .glyph_index = 240},    /*Unicode: U+0038 (8)*/
    {.w_px = 4,   .glyph_index = 250},    /*Unicode: U+0039 (9)*/
    {.w_px = 1,   .glyph_index = 260},    /*Unicode: U+003a (:)*/
    {.w_px = 1,   .glyph_index = 270},    /*Unicode: U+003b (;)*/
    {.w_px = 5,   .glyph_index = 280},    /*Unicode: U+003c (<)*/
    {.w_px = 5,   .glyph_index = 290},    /*Unicode: U+003d (=)*/
    {.w_px = 5,   .glyph_index = 300},    /*Unicode: U+003e (>)*/
    {.w_px = 3,   .glyph_index = 310},    /*Unicode: U+003f (?)*/
    {.w_px = 7,   .glyph_index = 320},    /*Unicode: U+0040 (@)*/
    {.w_px = 5,   .glyph_index = 330},    /*Unicode: U+0041 (A)*/
    {.w_px = 4,   .glyph_index = 340},    /*Unicode: U+0042 (B)*/
    {.w_px = 5,   .glyph_index = 350},    /*Unicode: U+0043 (C)*/
    {.w_px = 5,   .glyph_index = 360},    /*Unicode: U+0044 (D)*/
    {.w_px = 4,   .glyph_index = 370},    /*Unicode: U+0045 (E)*/
    {.w_px = 3,   .glyph_index = 380},    /*Unicode: U+0046 (F)*/
    {.w_px = 5,   .glyph_index = 390},    /*Unicode: U+0047 (G)*/
    {.w_px = 4,   .glyph_index = 400},    /*Unicode: U+0048 (H)*/
    {.w_px = 1,   .glyph_index = 410},    /*Unicode: U+0049 (I)*/
    {.w_px = 2,   .glyph_index = 420},    /*Unicode: U+004a (J)*/
    {.w_px = 5,   .glyph_index = 430},    /*Unicode: U+004b (K)*/
    {.w_px = 4,   .glyph_index = 440},    /*Unicode: U+004c (L)*/
    {.w_px = 5,   .glyph_index = 450},    /*Unicode: U+004d (M)*/
    {.w_px = 4,   .glyph_index = 460},    /*Unicode: U+004e (N)*/
    {.w_px = 5,   .glyph_index = 470},    /*Unicode: U+004f (O)*/
    {.w_px = 4,   .glyph_index = 480},    /*Unicode: U+0050 (P)*/
    {.w_px = 5,   .glyph_index = 490},    /*Unicode: U+0051 (Q)*/
    {.w_px = 5,   .glyph_index = 500},    /*Unicode: U+0052 (R)*/
    {.w_px = 4,   .glyph_index = 510},    /*Unicode: U+0053 (S)*/
    {.w_px = 5,   .glyph_index = 520},    /*Unicode: U+0054 (T)*/
    {.w_px = 4,   .glyph_index = 530},    /*Unicode: U+0055 (U)*/
    {.w_px = 5,   .glyph_index = 540},    /*Unicode: U+0056 (V)*/
    {.w_px = 7,   .glyph_index = 550},    /*Unicode: U+0057 (W)*/
    {.w_px = 5,   .glyph_index = 560},    /*Unicode: U+0058 (X)*/
    {.w_px = 5,   .glyph_index = 570},    /*Unicode: U+0059 (Y)*/
    {.w_px = 5,   .glyph_index = 580},    /*Unicode: U+005a (Z)*/
    {.w_px = 2,   .glyph_index = 590},    /*Unicode: U+005b ([)*/
    {.w_px = 3,   .glyph_index = 600},    /*Unicode: U+005c (\)*/
    {.w_px = 2,   .glyph_index = 610},    /*Unicode: U+005d (])*/
    {.w_px = 5,   .glyph_index = 620},    /*Unicode: U+005e (^)*/
    {.w_px = 4,   .glyph_index = 630},    /*Unicode: U+005f (_)*/
    {.w_px = 2,   .glyph_index = 640},    /*Unicode: U+0060 (`)*/
    {.w_px = 4,   .glyph_index = 650},    /*Unicode: U+0061 (a)*/
    {.w_px = 4,   .glyph_index = 660},    /*Unicode: U+0062 (b)*/
    {.w_px = 3,   .glyph_index = 670},    /*Unicode: U+0063 (c)*/
    {.w_px = 4,   .glyph_index = 680},    /*Unicode: U+0064 (d)*/
    {.w_px = 4,   .glyph_index = 690},    /*Unicode: U+0065 (e)*/
    {.w_px = 3,   .glyph_index = 700},    /*Unicode: U+0066 (f)*/
    {.w_px = 4,   .glyph_index = 710},    /*Unicode: U+0067 (g)*/
    {.w_px = 4,   .glyph_index = 720},    /*Unicode: U+0068 (h)*/
    {.w_px = 1,   .glyph_index = 730},    /*Unicode: U+0069 (i)*/
    {.w_px = 2,   .glyph_index = 740},    /*Unicode: U+006a (j)*/
    {.w_px = 4,   .glyph_index = 750},    /*Unicode: U+006b (k)*/
    {.w_px = 1,   .glyph_index = 760},    /*Unicode: U+006c (l)*/
    {.w_px = 7,   .glyph_index = 770},    /*Unicode: U+006d (m)*/
    {.w_px = 4,   .glyph_index = 780},    /*Unicode: U+006e (n)*/
    {.w_px = 4,   .glyph_index = 790},    /*Unicode: U+006f (o)*/
    {.w_px = 4,   .glyph_index = 800},    /*Unicode: U+0070 (p)*/
    {.w_px = 4,   .glyph_index = 810},    /*Unicode: U+0071 (q)*/
    {.w_px = 3,   .glyph_index = 820},    /*Unicode: U+0072 (r)*/
    {.w_px = 3,   .glyph_index = 830},    /*Unicode: U+0073 (s)*/
    {.w_px = 3,   .glyph_index = 840},    /*Unicode: U+0074 (t)*/
    {.w_px = 4,   .glyph_index = 850},    /*Unicode: U+0075 (u)*/
    {.w_px = 4,   .glyph_index = 860},    /*Unicode: U+0076 (v)*/
    {.w_px = 6,   .glyph_index = 870},    /*Unicode: U+0077 (w)*/
    {.w_px = 4,   .glyph_index = 880},    /*Unicode: U+0078 (x)*/
    {.w_px = 4,   .glyph_index = 890},    /*Unicode: U+0079 (y)*/
    {.w_px = 4,   .glyph_index = 900},    /*Unicode: U+007a (z)*/
    {.w_px = 3,   .glyph_index = 910},    /*Unicode: U+007b ({)*/
    {.w_px = 1,   .glyph_index = 920},    /*Unicode: U+007c (|)*/
    {.w_px = 3,   .glyph_index = 930},    /*Unicode: U+007d (})*/
    {.w_px = 5,   .glyph_index = 940},    /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_10 == 2
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 1,   .glyph_index = 10}, /*Unicode: U+0021 (!)*/
    {.w_px = 3,   .glyph_index = 20}, /*Unicode: U+0022 (")*/
    {.w_px = 5,   .glyph_index = 30}, /*Unicode: U+0023 (#)*/
    {.w_px = 5,   .glyph_index = 50}, /*Unicode: U+0024 ($)*/
    {.w_px = 7,   .glyph_index = 70}, /*Unicode: U+0025 (%)*/
    {.w_px = 5,   .glyph_index = 90}, /*Unicode: U+0026 (&)*/
    {.w_px = 1,   .glyph_index = 110},    /*Unicode: U+0027 (')*/
    {.w_px = 2,   .glyph_index = 120},    /*Unicode: U+0028 (()*/
    {.w_px = 2,   .glyph_index = 130},    /*Unicode: U+0029 ())*/
    {.w_px = 5,   .glyph_index = 140},    /*Unicode: U+002a (*)*/
    {.w_px = 5,   .glyph_index = 160},    /*Unicode: U+002b (+)*/
    {.w_px = 1,   .glyph_index = 180},    /*Unicode: U+002c (,)*/
    {.w_px = 2,   .glyph_index = 190},    /*Unicode: U+002d (-)*/
    {.w_px = 1,   .glyph_index = 200},    /*Unicode: U+002e (.)*/
    {.w_px = 3,   .glyph_index = 210},    /*Unicode: U+002f (/)*/
    {.w_px = 4,   .glyph_index = 220},    /*Unicode: U+0030 (0)*/
    {.w_px = 3,   .glyph_index = 230},    /*Unicode: U+0031 (1)*/
    {.w_px = 5,   .glyph_index = 240},    /*Unicode: U+0032 (2)*/
    {.w_px = 4,   .glyph_index = 260},    /*Unicode: U+0033 (3)*/
    {.w_px = 4,   .glyph_index = 270},    /*Unicode: U+0034 (4)*/
    {.w_px = 4,   .glyph_index = 280},    /*Unicode: U+0035 (5)*/
    {.w_px = 4,   .glyph_index = 290},    /*Unicode: U+0036 (6)*/
    {.w_px = 4,   .glyph_index = 300},    /*Unicode: U+0037 (7)*/
    {.w_px = 4,   .glyph_index = 310},    /*Unicode: U+0038 (8)*/
    {.w_px = 4,   .glyph_index = 320},    /*Unicode: U+0039 (9)*/
    {.w_px = 1,   .glyph_index = 330},    /*Unicode: U+003a (:)*/
    {.w_px = 1,   .glyph_index = 340},    /*Unicode: U+003b (;)*/
    {.w_px = 5,   .glyph_index = 350},    /*Unicode: U+003c (<)*/
    {.w_px = 5,   .glyph_index = 370},    /*Unicode: U+003d (=)*/
    {.w_px = 5,   .glyph_index = 390},    /*Unicode: U+003e (>)*/
    {.w_px = 3,   .glyph_index = 410},    /*Unicode: U+003f (?)*/
    {.w_px = 7,   .glyph_index = 420},    /*Unicode: U+0040 (@)*/
    {.w_px = 5,   .glyph_index = 440},    /*Unicode: U+0041 (A)*/
    {.w_px = 4,   .glyph_index = 460},    /*Unicode: U+0042 (B)*/
    {.w_px = 5,   .glyph_index = 470},    /*Unicode: U+0043 (C)*/
    {.w_px = 5,   .glyph_index = 490},    /*Unicode: U+0044 (D)*/
    {.w_px = 4,   .glyph_index = 510},    /*Unicode: U+0045 (E)*/
    {.w_px = 3,   .glyph_index = 520},    /*Unicode: U+0046 (F)*/
    {.w_px = 5,   .glyph_index = 530},    /*Unicode: U+0047 (G)*/
    {.w_px = 4,   .glyph_index = 550},    /*Unicode: U+0048 (H)*/
    {.w_px = 1,   .glyph_index = 560},    /*Unicode: U+0049 (I)*/
    {.w_px = 2,   .glyph_index = 570},    /*Unicode: U+004a (J)*/
    {.w_px = 5,   .glyph_index = 580},    /*Unicode: U+004b (K)*/
    {.w_px = 4,   .glyph_index = 600},    /*Unicode: U+004c (L)*/
    {.w_px = 5,   .glyph_index = 610},    /*Unicode: U+004d (M)*/
    {.w_px = 4,   .glyph_index = 630},    /*Unicode: U+004e (N)*/
    {.w_px = 5,   .glyph_index = 640},    /*Unicode: U+004f (O)*/
    {.w_px = 4,   .glyph_index = 660},    /*Unicode: U+0050 (P)*/
    {.w_px = 5,   .glyph_index = 670},    /*Unicode: U+0051 (Q)*/
    {.w_px = 5,   .glyph_index = 690},    /*Unicode: U+0052 (R)*/
    {.w_px = 4,   .glyph_index = 710},    /*Unicode: U+0053 (S)*/
    {.w_px = 5,   .glyph_index = 720},    /*Unicode: U+0054 (T)*/
    {.w_px = 4,   .glyph_index = 740},    /*Unicode: U+0055 (U)*/
    {.w_px = 5,   .glyph_index = 750},    /*Unicode: U+0056 (V)*/
    {.w_px = 7,   .glyph_index = 770},    /*Unicode: U+0057 (W)*/
    {.w_px = 5,   .glyph_index = 790},    /*Unicode: U+0058 (X)*/
    {.w_px = 5,   .glyph_index = 810},    /*Unicode: U+0059 (Y)*/
    {.w_px = 5,   .glyph_index = 830},    /*Unicode: U+005a (Z)*/
    {.w_px = 2,   .glyph_index = 850},    /*Unicode: U+005b ([)*/
    {.w_px = 3,   .glyph_index = 860},    /*Unicode: U+005c (\)*/
    {.w_px = 2,   .glyph_index = 870},    /*Unicode: U+005d (])*/
    {.w_px = 5,   .glyph_index = 880},    /*Unicode: U+005e (^)*/
    {.w_px = 4,   .glyph_index = 900},    /*Unicode: U+005f (_)*/
    {.w_px = 2,   .glyph_index = 910},    /*Unicode: U+0060 (`)*/
    {.w_px = 4,   .glyph_index = 920},    /*Unicode: U+0061 (a)*/
    {.w_px = 4,   .glyph_index = 930},    /*Unicode: U+0062 (b)*/
    {.w_px = 3,   .glyph_index = 940},    /*Unicode: U+0063 (c)*/
    {.w_px = 4,   .glyph_index = 950},    /*Unicode: U+0064 (d)*/
    {.w_px = 4,   .glyph_index = 960},    /*Unicode: U+0065 (e)*/
    {.w_px = 3,   .glyph_index = 970},    /*Unicode: U+0066 (f)*/
    {.w_px = 4,   .glyph_index = 980},    /*Unicode: U+0067 (g)*/
    {.w_px = 4,   .glyph_index = 990},    /*Unicode: U+0068 (h)*/
    {.w_px = 1,   .glyph_index = 1000},   /*Unicode: U+0069 (i)*/
    {.w_px = 2,   .glyph_index = 1010},   /*Unicode: U+006a (j)*/
    {.w_px = 4,   .glyph_index = 1020},   /*Unicode: U+006b (k)*/
    {.w_px = 1,   .glyph_index = 1030},   /*Unicode: U+006c (l)*/
    {.w_px = 7,   .glyph_index = 1040},   /*Unicode: U+006d (m)*/
    {.w_px = 4,   .glyph_index = 1060},   /*Unicode: U+006e (n)*/
    {.w_px = 4,   .glyph_index = 1070},   /*Unicode: U+006f (o)*/
    {.w_px = 4,   .glyph_index = 1080},   /*Unicode: U+0070 (p)*/
    {.w_px = 4,   .glyph_index = 1090},   /*Unicode: U+0071 (q)*/
    {.w_px = 3,   .glyph_index = 1100},   /*Unicode: U+0072 (r)*/
    {.w_px = 3,   .glyph_index = 1110},   /*Unicode: U+0073 (s)*/
    {.w_px = 3,   .glyph_index = 1120},   /*Unicode: U+0074 (t)*/
    {.w_px = 4,   .glyph_index = 1130},   /*Unicode: U+0075 (u)*/
    {.w_px = 4,   .glyph_index = 1140},   /*Unicode: U+0076 (v)*/
    {.w_px = 6,   .glyph_index = 1150},   /*Unicode: U+0077 (w)*/
    {.w_px = 4,   .glyph_index = 1170},   /*Unicode: U+0078 (x)*/
    {.w_px = 4,   .glyph_index = 1180},   /*Unicode: U+0079 (y)*/
    {.w_px = 4,   .glyph_index = 1190},   /*Unicode: U+007a (z)*/
    {.w_px = 3,   .glyph_index = 1200},   /*Unicode: U+007b ({)*/
    {.w_px = 1,   .glyph_index = 1210},   /*Unicode: U+007c (|)*/
    {.w_px = 3,   .glyph_index = 1220},   /*Unicode: U+007d (})*/
    {.w_px = 5,   .glyph_index = 1230},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_10 == 4
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 1,   .glyph_index = 20}, /*Unicode: U+0021 (!)*/
    {.w_px = 3,   .glyph_index = 30}, /*Unicode: U+0022 (")*/
    {.w_px = 5,   .glyph_index = 50}, /*Unicode: U+0023 (#)*/
    {.w_px = 5,   .glyph_index = 80}, /*Unicode: U+0024 ($)*/
    {.w_px = 7,   .glyph_index = 110},    /*Unicode: U+0025 (%)*/
    {.w_px = 5,   .glyph_index = 150},    /*Unicode: U+0026 (&)*/
    {.w_px = 1,   .glyph_index = 180},    /*Unicode: U+0027 (')*/
    {.w_px = 2,   .glyph_index = 190},    /*Unicode: U+0028 (()*/
    {.w_px = 2,   .glyph_index = 200},    /*Unicode: U+0029 ())*/
    {.w_px = 5,   .glyph_index = 210},    /*Unicode: U+002a (*)*/
    {.w_px = 5,   .glyph_index = 240},    /*Unicode: U+002b (+)*/
    {.w_px = 1,   .glyph_index = 270},    /*Unicode: U+002c (,)*/
    {.w_px = 2,   .glyph_index = 280},    /*Unicode: U+002d (-)*/
    {.w_px = 1,   .glyph_index = 290},    /*Unicode: U+002e (.)*/
    {.w_px = 3,   .glyph_index = 300},    /*Unicode: U+002f (/)*/
    {.w_px = 4,   .glyph_index = 320},    /*Unicode: U+0030 (0)*/
    {.w_px = 3,   .glyph_index = 340},    /*Unicode: U+0031 (1)*/
    {.w_px = 5,   .glyph_index = 360},    /*Unicode: U+0032 (2)*/
    {.w_px = 4,   .glyph_index = 390},    /*Unicode: U+0033 (3)*/
    {.w_px = 4,   .glyph_index = 410},    /*Unicode: U+0034 (4)*/
    {.w_px = 4,   .glyph_index = 430},    /*Unicode: U+0035 (5)*/
    {.w_px = 4,   .glyph_index = 450},    /*Unicode: U+0036 (6)*/
    {.w_px = 4,   .glyph_index = 470},    /*Unicode: U+0037 (7)*/
    {.w_px = 4,   .glyph_index = 490},    /*Unicode: U+0038 (8)*/
    {.w_px = 4,   .glyph_index = 510},    /*Unicode: U+0039 (9)*/
    {.w_px = 1,   .glyph_index = 530},    /*Unicode: U+003a (:)*/
    {.w_px = 1,   .glyph_index = 540},    /*Unicode: U+003b (;)*/
    {.w_px = 5,   .glyph_index = 550},    /*Unicode: U+003c (<)*/
    {.w_px = 5,   .glyph_index = 580},    /*Unicode: U+003d (=)*/
    {.w_px = 5,   .glyph_index = 610},    /*Unicode: U+003e (>)*/
    {.w_px = 3,   .glyph_index = 640},    /*Unicode: U+003f (?)*/
    {.w_px = 7,   .glyph_index = 660},    /*Unicode: U+0040 (@)*/
    {.w_px = 5,   .glyph_index = 700},    /*Unicode: U+0041 (A)*/
    {.w_px = 4,   .glyph_index = 730},    /*Unicode: U+0042 (B)*/
    {.w_px = 5,   .glyph_index = 750},    /*Unicode: U+0043 (C)*/
    {.w_px = 5,   .glyph_index = 780},    /*Unicode: U+0044 (D)*/
    {.w_px = 4,   .glyph_index = 810},    /*Unicode: U+0045 (E)*/
    {.w_px = 3,   .glyph_index = 830},    /*Unicode: U+0046 (F)*/
    {.w_px = 5,   .glyph_index = 850},    /*Unicode: U+0047 (G)*/
    {.w_px = 4,   .glyph_index = 880},    /*Unicode: U+0048 (H)*/
    {.w_px = 1,   .glyph_index = 900},    /*Unicode: U+0049 (I)*/
    {.w_px = 2,   .glyph_index = 910},    /*Unicode: U+004a (J)*/
    {.w_px = 5,   .glyph_index = 920},    /*Unicode: U+004b (K)*/
    {.w_px = 4,   .glyph_index = 950},    /*Unicode: U+004c (L)*/
    {.w_px = 5,   .glyph_index = 970},    /*Unicode: U+004d (M)*/
    {.w_px = 4,   .glyph_index = 1000},   /*Unicode: U+004e (N)*/
    {.w_px = 5,   .glyph_index = 1020},   /*Unicode: U+004f (O)*/
    {.w_px = 4,   .glyph_index = 1050},   /*Unicode: U+0050 (P)*/
    {.w_px = 5,   .glyph_index = 1070},   /*Unicode: U+0051 (Q)*/
    {.w_px = 5,   .glyph_index = 1100},   /*Unicode: U+0052 (R)*/
    {.w_px = 4,   .glyph_index = 1130},   /*Unicode: U+0053 (S)*/
    {.w_px = 5,   .glyph_index = 1150},   /*Unicode: U+0054 (T)*/
    {.w_px = 4,   .glyph_index = 1180},   /*Unicode: U+0055 (U)*/
    {.w_px = 5,   .glyph_index = 1200},   /*Unicode: U+0056 (V)*/
    {.w_px = 7,   .glyph_index = 1230},   /*Unicode: U+0057 (W)*/
    {.w_px = 5,   .glyph_index = 1270},   /*Unicode: U+0058 (X)*/
    {.w_px = 5,   .glyph_index = 1300},   /*Unicode: U+0059 (Y)*/
    {.w_px = 5,   .glyph_index = 1330},   /*Unicode: U+005a (Z)*/
    {.w_px = 2,   .glyph_index = 1360},   /*Unicode: U+005b ([)*/
    {.w_px = 3,   .glyph_index = 1370},   /*Unicode: U+005c (\)*/
    {.w_px = 2,   .glyph_index = 1390},   /*Unicode: U+005d (])*/
    {.w_px = 5,   .glyph_index = 1400},   /*Unicode: U+005e (^)*/
    {.w_px = 4,   .glyph_index = 1430},   /*Unicode: U+005f (_)*/
    {.w_px = 2,   .glyph_index = 1450},   /*Unicode: U+0060 (`)*/
    {.w_px = 4,   .glyph_index = 1460},   /*Unicode: U+0061 (a)*/
    {.w_px = 4,   .glyph_index = 1480},   /*Unicode: U+0062 (b)*/
    {.w_px = 3,   .glyph_index = 1500},   /*Unicode: U+0063 (c)*/
    {.w_px = 4,   .glyph_index = 1520},   /*Unicode: U+0064 (d)*/
    {.w_px = 4,   .glyph_index = 1540},   /*Unicode: U+0065 (e)*/
    {.w_px = 3,   .glyph_index = 1560},   /*Unicode: U+0066 (f)*/
    {.w_px = 4,   .glyph_index = 1580},   /*Unicode: U+0067 (g)*/
    {.w_px = 4,   .glyph_index = 1600},   /*Unicode: U+0068 (h)*/
    {.w_px = 1,   .glyph_index = 1620},   /*Unicode: U+0069 (i)*/
    {.w_px = 2,   .glyph_index = 1630},   /*Unicode: U+006a (j)*/
    {.w_px = 4,   .glyph_index = 1640},   /*Unicode: U+006b (k)*/
    {.w_px = 1,   .glyph_index = 1660},   /*Unicode: U+006c (l)*/
    {.w_px = 7,   .glyph_index = 1670},   /*Unicode: U+006d (m)*/
    {.w_px = 4,   .glyph_index = 1710},   /*Unicode: U+006e (n)*/
    {.w_px = 4,   .glyph_index = 1730},   /*Unicode: U+006f (o)*/
    {.w_px = 4,   .glyph_index = 1750},   /*Unicode: U+0070 (p)*/
    {.w_px = 4,   .glyph_index = 1770},   /*Unicode: U+0071 (q)*/
    {.w_px = 3,   .glyph_index = 1790},   /*Unicode: U+0072 (r)*/
    {.w_px = 3,   .glyph_index = 1810},   /*Unicode: U+0073 (s)*/
    {.w_px = 3,   .glyph_index = 1830},   /*Unicode: U+0074 (t)*/
    {.w_px = 4,   .glyph_index = 1850},   /*Unicode: U+0075 (u)*/
    {.w_px = 4,   .glyph_index = 1870},   /*Unicode: U+0076 (v)*/
    {.w_px = 6,   .glyph_index = 1890},   /*Unicode: U+0077 (w)*/
    {.w_px = 4,   .glyph_index = 1920},   /*Unicode: U+0078 (x)*/
    {.w_px = 4,   .glyph_index = 1940},   /*Unicode: U+0079 (y)*/
    {.w_px = 4,   .glyph_index = 1960},   /*Unicode: U+007a (z)*/
    {.w_px = 3,   .glyph_index = 1980},   /*Unicode: U+007b ({)*/
    {.w_px = 1,   .glyph_index = 2000},   /*Unicode: U+007c (|)*/
    {.w_px = 3,   .glyph_index = 2010},   /*Unicode: U+007d (})*/
    {.w_px = 5,   .glyph_index = 2030},   /*Unicode: U+007e (~)*/

#elif USE_LV_FONT_DEJAVU_10 == 8
    {.w_px = 3,   .glyph_index = 0},  /*Unicode: U+0020 ( )*/
    {.w_px = 1,   .glyph_index = 30}, /*Unicode: U+0021 (!)*/
    {.w_px = 3,   .glyph_index = 40}, /*Unicode: U+0022 (")*/
    {.w_px = 5,   .glyph_index = 70}, /*Unicode: U+0023 (#)*/
    {.w_px = 5,   .glyph_index = 120},    /*Unicode: U+0024 ($)*/
    {.w_px = 7,   .glyph_index = 170},    /*Unicode: U+0025 (%)*/
    {.w_px = 5,   .glyph_index = 240},    /*Unicode: U+0026 (&)*/
    {.w_px = 1,   .glyph_index = 290},    /*Unicode: U+0027 (')*/
    {.w_px = 2,   .glyph_index = 300},    /*Unicode: U+0028 (()*/
    {.w_px = 2,   .glyph_index = 320},    /*Unicode: U+0029 ())*/
    {.w_px = 5,   .glyph_index = 340},    /*Unicode: U+002a (*)*/
    {.w_px = 5,   .glyph_index = 390},    /*Unicode: U+002b (+)*/
    {.w_px = 1,   .glyph_index = 440},    /*Unicode: U+002c (,)*/
    {.w_px = 2,   .glyph_index = 450},    /*Unicode: U+002d (-)*/
    {.w_px = 1,   .glyph_index = 470},    /*Unicode: U+002e (.)*/
    {.w_px = 3,   .glyph_index = 480},    /*Unicode: U+002f (/)*/
    {.w_px = 4,   .glyph_index = 510},    /*Unicode: U+0030 (0)*/
    {.w_px = 3,   .glyph_index = 550},    /*Unicode: U+0031 (1)*/
    {.w_px = 5,   .glyph_index = 580},    /*Unicode: U+0032 (2)*/
    {.w_px = 4,   .glyph_index = 630},    /*Unicode: U+0033 (3)*/
    {.w_px = 4,   .glyph_index = 670},    /*Unicode: U+0034 (4)*/
    {.w_px = 4,   .glyph_index = 710},    /*Unicode: U+0035 (5)*/
    {.w_px = 4,   .glyph_index = 750},    /*Unicode: U+0036 (6)*/
    {.w_px = 4,   .glyph_index = 790},    /*Unicode: U+0037 (7)*/
    {.w_px = 4,   .glyph_index = 830},    /*Unicode: U+0038 (8)*/
    {.w_px = 4,   .glyph_index = 870},    /*Unicode: U+0039 (9)*/
    {.w_px = 1,   .glyph_index = 910},    /*Unicode: U+003a (:)*/
    {.w_px = 1,   .glyph_index = 920},    /*Unicode: U+003b (;)*/
    {.w_px = 5,   .glyph_index = 930},    /*Unicode: U+003c (<)*/
    {.w_px = 5,   .glyph_index = 980},    /*Unicode: U+003d (=)*/
    {.w_px = 5,   .glyph_index = 1030},   /*Unicode: U+003e (>)*/
    {.w_px = 3,   .glyph_index = 1080},   /*Unicode: U+003f (?)*/
    {.w_px = 7,   .glyph_index = 1110},   /*Unicode: U+0040 (@)*/
    {.w_px = 5,   .glyph_index = 1180},   /*Unicode: U+0041 (A)*/
    {.w_px = 4,   .glyph_index = 1230},   /*Unicode: U+0042 (B)*/
    {.w_px = 5,   .glyph_index = 1270},   /*Unicode: U+0043 (C)*/
    {.w_px = 5,   .glyph_index = 1320},   /*Unicode: U+0044 (D)*/
    {.w_px = 4,   .glyph_index = 1370},   /*Unicode: U+0045 (E)*/
    {.w_px = 3,   .glyph_index = 1410},   /*Unicode: U+0046 (F)*/
    {.w_px = 5,   .glyph_index = 1440},   /*Unicode: U+0047 (G)*/
    {.w_px = 4,   .glyph_index = 1490},   /*Unicode: U+0048 (H)*/
    {.w_px = 1,   .glyph_index = 1530},   /*Unicode: U+0049 (I)*/
    {.w_px = 2,   .glyph_index = 1540},   /*Unicode: U+004a (J)*/
    {.w_px = 5,   .glyph_index = 1560},   /*Unicode: U+004b (K)*/
    {.w_px = 4,   .glyph_index = 1610},   /*Unicode: U+004c (L)*/
    {.w_px = 5,   .glyph_index = 1650},   /*Unicode: U+004d (M)*/
    {.w_px = 4,   .glyph_index = 1700},   /*Unicode: U+004e (N)*/
    {.w_px = 5,   .glyph_index = 1740},   /*Unicode: U+004f (O)*/
    {.w_px = 4,   .glyph_index = 1790},   /*Unicode: U+0050 (P)*/
    {.w_px = 5,   .glyph_index = 1830},   /*Unicode: U+0051 (Q)*/
    {.w_px = 5,   .glyph_index = 1880},   /*Unicode: U+0052 (R)*/
    {.w_px = 4,   .glyph_index = 1930},   /*Unicode: U+0053 (S)*/
    {.w_px = 5,   .glyph_index = 1970},   /*Unicode: U+0054 (T)*/
    {.w_px = 4,   .glyph_index = 2020},   /*Unicode: U+0055 (U)*/
    {.w_px = 5,   .glyph_index = 2060},   /*Unicode: U+0056 (V)*/
    {.w_px = 7,   .glyph_index = 2110},   /*Unicode: U+0057 (W)*/
    {.w_px = 5,   .glyph_index = 2180},   /*Unicode: U+0058 (X)*/
    {.w_px = 5,   .glyph_index = 2230},   /*Unicode: U+0059 (Y)*/
    {.w_px = 5,   .glyph_index = 2280},   /*Unicode: U+005a (Z)*/
    {.w_px = 2,   .glyph_index = 2330},   /*Unicode: U+005b ([)*/
    {.w_px = 3,   .glyph_index = 2350},   /*Unicode: U+005c (\)*/
    {.w_px = 2,   .glyph_index = 2380},   /*Unicode: U+005d (])*/
    {.w_px = 5,   .glyph_index = 2400},   /*Unicode: U+005e (^)*/
    {.w_px = 4,   .glyph_index = 2450},   /*Unicode: U+005f (_)*/
    {.w_px = 2,   .glyph_index = 2490},   /*Unicode: U+0060 (`)*/
    {.w_px = 4,   .glyph_index = 2510},   /*Unicode: U+0061 (a)*/
    {.w_px = 4,   .glyph_index = 2550},   /*Unicode: U+0062 (b)*/
    {.w_px = 3,   .glyph_index = 2590},   /*Unicode: U+0063 (c)*/
    {.w_px = 4,   .glyph_index = 2620},   /*Unicode: U+0064 (d)*/
    {.w_px = 4,   .glyph_index = 2660},   /*Unicode: U+0065 (e)*/
    {.w_px = 3,   .glyph_index = 2700},   /*Unicode: U+0066 (f)*/
    {.w_px = 4,   .glyph_index = 2730},   /*Unicode: U+0067 (g)*/
    {.w_px = 4,   .glyph_index = 2770},   /*Unicode: U+0068 (h)*/
    {.w_px = 1,   .glyph_index = 2810},   /*Unicode: U+0069 (i)*/
    {.w_px = 2,   .glyph_index = 2820},   /*Unicode: U+006a (j)*/
    {.w_px = 4,   .glyph_index = 2840},   /*Unicode: U+006b (k)*/
    {.w_px = 1,   .glyph_index = 2880},   /*Unicode: U+006c (l)*/
    {.w_px = 7,   .glyph_index = 2890},   /*Unicode: U+006d (m)*/
    {.w_px = 4,   .glyph_index = 2960},   /*Unicode: U+006e (n)*/
    {.w_px = 4,   .glyph_index = 3000},   /*Unicode: U+006f (o)*/
    {.w_px = 4,   .glyph_index = 3040},   /*Unicode: U+0070 (p)*/
    {.w_px = 4,   .glyph_index = 3080},   /*Unicode: U+0071 (q)*/
    {.w_px = 3,   .glyph_index = 3120},   /*Unicode: U+0072 (r)*/
    {.w_px = 3,   .glyph_index = 3150},   /*Unicode: U+0073 (s)*/
    {.w_px = 3,   .glyph_index = 3180},   /*Unicode: U+0074 (t)*/
    {.w_px = 4,   .glyph_index = 3210},   /*Unicode: U+0075 (u)*/
    {.w_px = 4,   .glyph_index = 3250},   /*Unicode: U+0076 (v)*/
    {.w_px = 6,   .glyph_index = 3290},   /*Unicode: U+0077 (w)*/
    {.w_px = 4,   .glyph_index = 3350},   /*Unicode: U+0078 (x)*/
    {.w_px = 4,   .glyph_index = 3390},   /*Unicode: U+0079 (y)*/
    {.w_px = 4,   .glyph_index = 3430},   /*Unicode: U+007a (z)*/
    {.w_px = 3,   .glyph_index = 3470},   /*Unicode: U+007b ({)*/
    {.w_px = 1,   .glyph_index = 3500},   /*Unicode: U+007c (|)*/
    {.w_px = 3,   .glyph_index = 3510},   /*Unicode: U+007d (})*/
    {.w_px = 5,   .glyph_index = 3540},   /*Unicode: U+007e (~)*/

#endif
};

lv_font_t lv_font_dejavu_10 = {
    .unicode_first = 32,    /*First Unicode letter in this font*/
    .unicode_last = 126,    /*Last Unicode letter in this font*/
    .h_px = 10,             /*Font height in pixels*/
    .glyph_cnt = 95,            /*Number of glyphs in the font*/
    .glyph_bitmap = lv_font_dejavu_10_glyph_bitmap, /*Bitmap of glyphs*/
    .glyph_dsc = lv_font_dejavu_10_glyph_dsc,       /*Description of glyphs*/
    .unicode_list = NULL,   /*Every character in the font from 'unicode_first' to 'unicode_last'*/
    .get_bitmap = lv_font_get_bitmap_continuous,    /*Function pointer to get glyph's bitmap*/
    .get_width = lv_font_get_width_continuous,  /*Function pointer to get glyph's width*/
#if USE_LV_FONT_DEJAVU_10 == 1
    .bpp = 1,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10 == 2
    .bpp = 2,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10 == 4
    .bpp = 4,               /*Bit per pixel*/
#elif USE_LV_FONT_DEJAVU_10 == 8
    .bpp = 8,               /*Bit per pixel*/
#endif
    .monospace = 0,
    .next_page = NULL,      /*Pointer to a font extension*/
};

#endif /*USE_LV_FONT_DEJAVU_10*/
