#include "osdep_service.h"
#include "device_lock.h"
#include "flash_api.h"
#include "lfs.h"

#ifndef CONFIG_USE_FLASHCFG
#define LFS_FLASH_BASE_ADDR 0x200000
#define LFS_DEVICE_SIZE 0x100000
#endif

extern struct lfs_config g_lfs_cfg;
extern lfs_t g_lfs;

/**
 * lfsײflashݽӿ
 * @param  c
 * @param  block  
 * @param  off    ƫƵַ
 * @param  buffer ڴ洢ȡ
 * @param  size   Ҫȡֽ
 * @return
 */
int lfs_diskio_read(const struct lfs_config *c, lfs_block_t block, lfs_off_t off, void *buffer, lfs_size_t size);

/**
 * lfsײflashдݽӿ
 * @param  c
 * @param  block  
 * @param  off    ƫƵַ
 * @param  buffer д
 * @param  size   дݵĴС
 * @return
 */
int lfs_diskio_prog(const struct lfs_config *c, lfs_block_t block, lfs_off_t off, const void *buffer, lfs_size_t size);

/**
 * lfsײflashӿ
 * @param  c
 * @param  block 
 * @return
 */
int lfs_diskio_erase(const struct lfs_config *c, lfs_block_t block);

int lfs_diskio_sync(const struct lfs_config *c);

#ifdef LFS_THREADSAFE
int lfs_diskio_lock(const struct lfs_config *c);
int lfs_diskio_unlock(const struct lfs_config *c);
#endif