/**
  ******************************************************************************
  * @file   rtw_opt_rf_para_rtl8721d.c
  * @author
  * @version V1.0.0
  * @date    2019-03-08
  * @brief   This file provides an option to reduce code size if you are sure of supply voltage or cut version 
  ******************************************************************************
  * @attention
  *
  * This module is a confidential and proprietary property of RealTek and
  * possession or use of this module requires written permission of RealTek.
  *
  * Copyright(c) 2015, Realtek Semiconductor Corporation. All rights reserved.
  ****************************************************************************** 
  */
  #include <basic_types.h>

/* Mask this macro can save 7.2k flash size if you only use C cut, default support both C cut and B cut */
//#define		SUPPORT_B_CUT	

/* Mask this macro can save 2.4k flash size if you only use 3.3v, default support both 1.8v and 3.3v */
#define		SUPPORT_18V	

/* Mask this macro can save 2.4k flash size if you only use 1.8v, default support both 1.8v and 3.3v */
#define		SUPPORT_33V

/******************************************************************************
 *                           power by rate for 1.8v, step is 0.5db
 ******************************************************************************/
const u32 array_mp_8721d_phy_reg_pg_type0[] = {
#if defined(SUPPORT_18V)
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00002800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x24262800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x24262628,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x22222224,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x22242426,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x20202022,
	1, 0, 0, 0x00000e00, 0xffffffff, 0x22222424,
	1, 0, 0, 0x00000e04, 0xffffffff, 0x18182020,
	1, 0, 0, 0x00000e10, 0xffffffff, 0x20202222,
	1, 0, 0, 0x00000e14, 0xffffffff, 0x16161818
#endif
};

/******************************************************************************
 *                           power by rate for 3.3v, step is 0.5db
 ******************************************************************************/
const u32 array_mp_8721d_phy_reg_pg_type1[] = {
#if defined(SUPPORT_33V)
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36404000,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34343638,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36363636,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32323436,
	1, 0, 0, 0x00000e00, 0xffffffff, 0x32343436,
	1, 0, 0, 0x00000e04, 0xffffffff, 0x28283032,
	1, 0, 0, 0x00000e10, 0xffffffff, 0x30323232,
	1, 0, 0, 0x00000e14, 0xffffffff, 0x26262830
#endif
};

u32 arraylength_8721d_phy_reg_pg_type0 = sizeof(array_mp_8721d_phy_reg_pg_type0)  / sizeof(u32);
u32 arraylength_8721d_phy_reg_pg_type1 = sizeof(array_mp_8721d_phy_reg_pg_type1)  / sizeof(u32);
  /******************************************************************************
 *                           data types
 ******************************************************************************/
enum odm_pw_lmt_regulation_type {
	PW_LMT_REGU_NULL = 0,
	PW_LMT_REGU_FCC = 1,
	PW_LMT_REGU_ETSI = 2,
	PW_LMT_REGU_MKK = 3,
	PW_LMT_REGU_WW13 = 4,
	PW_LMT_REGU_IC = 5,
	PW_LMT_REGU_KCC = 6,
	PW_LMT_REGU_ACMA = 7,
	PW_LMT_REGU_CHILE = 8,
	PW_LMT_REGU_UKRAINE = 9,
	PW_LMT_REGU_MEXICO = 10,
	PW_LMT_REGU_CN = 11,
	PW_LMT_REGU_MAX_NUM = 12
};

enum odm_pw_lmt_band_type {
	PW_LMT_BAND_NULL = 0,
	PW_LMT_BAND_2_4G = 1,
	PW_LMT_BAND_5G = 2
};

enum odm_pw_lmt_bandwidth_type {
	PW_LMT_BW_NULL = 0,
	PW_LMT_BW_20M = 1,
	PW_LMT_BW_40M = 2,
	PW_LMT_BW_80M = 3
};

enum odm_pw_lmt_ratesection_type {
	PW_LMT_RS_NULL = 0,
	PW_LMT_RS_CCK = 1,
	PW_LMT_RS_OFDM = 2,
	PW_LMT_RS_HT = 3,
	PW_LMT_RS_VHT = 4
};

enum odm_pw_lmt_rfpath_type {
	PW_LMT_PH_NULL = 0,
	PW_LMT_PH_1T = 1,
	PW_LMT_PH_2T = 2,
	PW_LMT_PH_3T = 3,
	PW_LMT_PH_4T = 4
};


/******************************************************************************
 *                           radioa for only c cut
 ******************************************************************************/
#ifndef SUPPORT_B_CUT
const u32 array_mp_8721d_radioa[] = {
		0x00E, 0x00000025,
		0x00F, 0x00000029,
	0x84000000,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0009C522,
	0x95000000,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0009C522,
	0xA0000000,	0x00000000,
		0x057, 0x0009F522,
	0xB0000000,	0x00000000,
		0x078, 0x000015D5,
		0x082, 0x000115A8,
		0x0C0, 0x00038144,
		0x0AF, 0x00000004,
		0x0A5, 0x000E700C,
		0x0A1, 0x00005604,
		0x000, 0x00010000,
	0x84000000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000040,
		0x03F, 0x00000627,
		0x033, 0x00000041,
		0x03F, 0x0000062A,
		0x033, 0x00000042,
		0x03F, 0x0000062D,
		0x033, 0x00000043,
		0x03F, 0x0000066A,
		0x033, 0x00000044,
		0x03F, 0x0000066D,
		0x033, 0x00000045,
		0x03F, 0x00000CC8,
		0x033, 0x00000046,
		0x03F, 0x00000CCB,
		0x033, 0x00000047,
		0x03F, 0x00000CCE,
		0x033, 0x00000048,
		0x03F, 0x00000EEF,
		0x033, 0x00000049,
		0x03F, 0x00000EF2,
		0x033, 0x0000004A,
		0x03F, 0x00000EF5,
		0x033, 0x00000060,
		0x03F, 0x00000225,
		0x033, 0x00000061,
		0x03F, 0x00000228,
		0x033, 0x00000062,
		0x03F, 0x0000022B,
		0x033, 0x00000063,
		0x03F, 0x00000663,
		0x033, 0x00000064,
		0x03F, 0x00000E28,
		0x033, 0x00000065,
		0x03F, 0x00000E2B,
		0x033, 0x00000066,
		0x03F, 0x00000EE3,
		0x033, 0x00000067,
		0x03F, 0x00000EE6,
		0x033, 0x00000068,
		0x03F, 0x00000EE9,
		0x033, 0x00000069,
		0x03F, 0x00000EEC,
		0x033, 0x0000006A,
		0x03F, 0x00000EEF,
		0x033, 0x00000000,
		0x03F, 0x00000268,
		0x033, 0x00000001,
		0x03F, 0x0000026B,
		0x033, 0x00000002,
		0x03F, 0x0000064B,
		0x033, 0x00000003,
		0x03F, 0x0000064E,
		0x033, 0x00000004,
		0x03F, 0x00000A4E,
		0x033, 0x00000005,
		0x03F, 0x00000ACA,
		0x033, 0x00000006,
		0x03F, 0x00000ACD,
		0x033, 0x00000007,
		0x03F, 0x00000AD0,
		0x033, 0x00000008,
		0x03F, 0x00000EF0,
		0x033, 0x00000009,
		0x03F, 0x00000EF3,
		0x033, 0x0000000A,
		0x03F, 0x00000EF6,
		0x033, 0x00000020,
		0x03F, 0x00000608,
		0x033, 0x00000021,
		0x03F, 0x00000625,
		0x033, 0x00000022,
		0x03F, 0x00000628,
		0x033, 0x00000023,
		0x03F, 0x00000665,
		0x033, 0x00000024,
		0x03F, 0x00000668,
		0x033, 0x00000025,
		0x03F, 0x00000E66,
		0x033, 0x00000026,
		0x03F, 0x00000E69,
		0x033, 0x00000027,
		0x03F, 0x00000E6C,
		0x033, 0x00000028,
		0x03F, 0x00000EE9,
		0x033, 0x00000029,
		0x03F, 0x00000EEC,
		0x033, 0x0000002A,
		0x03F, 0x00000EEF,
		0x0EE, 0x00000000,
	0x95000000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000040,
		0x03F, 0x00000627,
		0x033, 0x00000041,
		0x03F, 0x0000062A,
		0x033, 0x00000042,
		0x03F, 0x0000062D,
		0x033, 0x00000043,
		0x03F, 0x0000066A,
		0x033, 0x00000044,
		0x03F, 0x0000066D,
		0x033, 0x00000045,
		0x03F, 0x00000CC8,
		0x033, 0x00000046,
		0x03F, 0x00000CCB,
		0x033, 0x00000047,
		0x03F, 0x00000CCE,
		0x033, 0x00000048,
		0x03F, 0x00000EEF,
		0x033, 0x00000049,
		0x03F, 0x00000EF2,
		0x033, 0x0000004A,
		0x03F, 0x00000EF5,
		0x033, 0x00000060,
		0x03F, 0x00000225,
		0x033, 0x00000061,
		0x03F, 0x00000228,
		0x033, 0x00000062,
		0x03F, 0x0000022B,
		0x033, 0x00000063,
		0x03F, 0x00000663,
		0x033, 0x00000064,
		0x03F, 0x00000E28,
		0x033, 0x00000065,
		0x03F, 0x00000E2B,
		0x033, 0x00000066,
		0x03F, 0x00000EE3,
		0x033, 0x00000067,
		0x03F, 0x00000EE6,
		0x033, 0x00000068,
		0x03F, 0x00000EE9,
		0x033, 0x00000069,
		0x03F, 0x00000EEC,
		0x033, 0x0000006A,
		0x03F, 0x00000EEF,
		0x033, 0x00000000,
		0x03F, 0x00000268,
		0x033, 0x00000001,
		0x03F, 0x0000026B,
		0x033, 0x00000002,
		0x03F, 0x0000064B,
		0x033, 0x00000003,
		0x03F, 0x0000064E,
		0x033, 0x00000004,
		0x03F, 0x00000A4E,
		0x033, 0x00000005,
		0x03F, 0x00000ACA,
		0x033, 0x00000006,
		0x03F, 0x00000ACD,
		0x033, 0x00000007,
		0x03F, 0x00000AD0,
		0x033, 0x00000008,
		0x03F, 0x00000EF0,
		0x033, 0x00000009,
		0x03F, 0x00000EF3,
		0x033, 0x0000000A,
		0x03F, 0x00000EF6,
		0x033, 0x00000020,
		0x03F, 0x00000608,
		0x033, 0x00000021,
		0x03F, 0x00000625,
		0x033, 0x00000022,
		0x03F, 0x00000628,
		0x033, 0x00000023,
		0x03F, 0x00000665,
		0x033, 0x00000024,
		0x03F, 0x00000668,
		0x033, 0x00000025,
		0x03F, 0x00000E66,
		0x033, 0x00000026,
		0x03F, 0x00000E69,
		0x033, 0x00000027,
		0x03F, 0x00000E6C,
		0x033, 0x00000028,
		0x03F, 0x00000EE9,
		0x033, 0x00000029,
		0x03F, 0x00000EEC,
		0x033, 0x0000002A,
		0x03F, 0x00000EEF,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000040,
		0x03F, 0x00000628,
		0x033, 0x00000041,
		0x03F, 0x0000062B,
		0x033, 0x00000042,
		0x03F, 0x0000062E,
		0x033, 0x00000043,
		0x03F, 0x0000066B,
		0x033, 0x00000044,
		0x03F, 0x0000066E,
		0x033, 0x00000045,
		0x03F, 0x00000CC9,
		0x033, 0x00000046,
		0x03F, 0x00000CCC,
		0x033, 0x00000047,
		0x03F, 0x00000CCF,
		0x033, 0x00000048,
		0x03F, 0x00000EF0,
		0x033, 0x00000049,
		0x03F, 0x00000EF3,
		0x033, 0x0000004A,
		0x03F, 0x00000EF6,
		0x033, 0x00000060,
		0x03F, 0x00000226,
		0x033, 0x00000061,
		0x03F, 0x00000229,
		0x033, 0x00000062,
		0x03F, 0x0000022C,
		0x033, 0x00000063,
		0x03F, 0x00000664,
		0x033, 0x00000064,
		0x03F, 0x00000E29,
		0x033, 0x00000065,
		0x03F, 0x00000E2C,
		0x033, 0x00000066,
		0x03F, 0x00000EE4,
		0x033, 0x00000067,
		0x03F, 0x00000EE7,
		0x033, 0x00000068,
		0x03F, 0x00000EEA,
		0x033, 0x00000069,
		0x03F, 0x00000EED,
		0x033, 0x0000006A,
		0x03F, 0x00000EF0,
		0x033, 0x00000000,
		0x03F, 0x00000267,
		0x033, 0x00000001,
		0x03F, 0x0000026A,
		0x033, 0x00000002,
		0x03F, 0x0000064A,
		0x033, 0x00000003,
		0x03F, 0x0000064D,
		0x033, 0x00000004,
		0x03F, 0x00000A4D,
		0x033, 0x00000005,
		0x03F, 0x00000AC9,
		0x033, 0x00000006,
		0x03F, 0x00000ACC,
		0x033, 0x00000007,
		0x03F, 0x00000ACF,
		0x033, 0x00000008,
		0x03F, 0x00000EEF,
		0x033, 0x00000009,
		0x03F, 0x00000EF2,
		0x033, 0x0000000A,
		0x03F, 0x00000EF5,
		0x033, 0x00000020,
		0x03F, 0x00000607,
		0x033, 0x00000021,
		0x03F, 0x00000624,
		0x033, 0x00000022,
		0x03F, 0x00000627,
		0x033, 0x00000023,
		0x03F, 0x00000664,
		0x033, 0x00000024,
		0x03F, 0x00000667,
		0x033, 0x00000025,
		0x03F, 0x00000E65,
		0x033, 0x00000026,
		0x03F, 0x00000E68,
		0x033, 0x00000027,
		0x03F, 0x00000E6B,
		0x033, 0x00000028,
		0x03F, 0x00000EE8,
		0x033, 0x00000029,
		0x03F, 0x00000EEB,
		0x033, 0x0000002A,
		0x03F, 0x00000EEE,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x84000000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000240,
		0x03F, 0x00000443,
		0x033, 0x00000241,
		0x03F, 0x00000446,
		0x033, 0x00000242,
		0x03F, 0x00000449,
		0x033, 0x00000243,
		0x03F, 0x0000044C,
		0x033, 0x00000244,
		0x03F, 0x00000CA4,
		0x033, 0x00000245,
		0x03F, 0x00000CA7,
		0x033, 0x00000246,
		0x03F, 0x00000EE6,
		0x033, 0x00000247,
		0x03F, 0x00000EE9,
		0x033, 0x00000248,
		0x03F, 0x00000EEC,
		0x033, 0x00000249,
		0x03F, 0x00000EEF,
		0x033, 0x0000024A,
		0x03F, 0x00000EF2,
	0x95000000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000240,
		0x03F, 0x00000443,
		0x033, 0x00000241,
		0x03F, 0x00000446,
		0x033, 0x00000242,
		0x03F, 0x00000449,
		0x033, 0x00000243,
		0x03F, 0x0000044C,
		0x033, 0x00000244,
		0x03F, 0x00000CA4,
		0x033, 0x00000245,
		0x03F, 0x00000CA7,
		0x033, 0x00000246,
		0x03F, 0x00000EE6,
		0x033, 0x00000247,
		0x03F, 0x00000EE9,
		0x033, 0x00000248,
		0x03F, 0x00000EEC,
		0x033, 0x00000249,
		0x03F, 0x00000EEF,
		0x033, 0x0000024A,
		0x03F, 0x00000EF2,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000240,
		0x03F, 0x00000444,
		0x033, 0x00000241,
		0x03F, 0x00000447,
		0x033, 0x00000242,
		0x03F, 0x0000044A,
		0x033, 0x00000243,
		0x03F, 0x0000044D,
		0x033, 0x00000244,
		0x03F, 0x00000CA5,
		0x033, 0x00000245,
		0x03F, 0x00000CA8,
		0x033, 0x00000246,
		0x03F, 0x00000EE7,
		0x033, 0x00000247,
		0x03F, 0x00000EEA,
		0x033, 0x00000248,
		0x03F, 0x00000EED,
		0x033, 0x00000249,
		0x03F, 0x00000EF0,
		0x033, 0x0000024A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
		0x033, 0x000002C0,
		0x03F, 0x0000022C,
		0x033, 0x000002C1,
		0x03F, 0x00000627,
		0x033, 0x000002C2,
		0x03F, 0x0000062A,
		0x033, 0x000002C3,
		0x03F, 0x00000667,
		0x033, 0x000002C4,
		0x03F, 0x00000688,
		0x033, 0x000002C5,
		0x03F, 0x000006E7,
		0x033, 0x000002C6,
		0x03F, 0x00000EE7,
		0x033, 0x000002C7,
		0x03F, 0x00000EEA,
		0x033, 0x000002C8,
		0x03F, 0x00000EED,
		0x033, 0x000002C9,
		0x03F, 0x00000EF0,
		0x033, 0x000002CA,
		0x03F, 0x00000EF3,
	0x84000000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000340,
		0x03F, 0x0000022A,
		0x033, 0x00000341,
		0x03F, 0x00000625,
		0x033, 0x00000342,
		0x03F, 0x00000628,
		0x033, 0x00000343,
		0x03F, 0x00000665,
		0x033, 0x00000344,
		0x03F, 0x00000686,
		0x033, 0x00000345,
		0x03F, 0x000006E5,
		0x033, 0x00000346,
		0x03F, 0x00000EE6,
		0x033, 0x00000347,
		0x03F, 0x00000EE9,
		0x033, 0x00000348,
		0x03F, 0x00000EEC,
		0x033, 0x00000349,
		0x03F, 0x00000EEF,
		0x033, 0x0000034A,
		0x03F, 0x00000EF2,
		0x033, 0x00000200,
		0x03F, 0x00000622,
		0x033, 0x00000201,
		0x03F, 0x00000625,
		0x033, 0x00000202,
		0x03F, 0x00000628,
		0x033, 0x00000203,
		0x03F, 0x00000665,
		0x033, 0x00000204,
		0x03F, 0x00000C49,
		0x033, 0x00000205,
		0x03F, 0x00000C4C,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0x95000000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000340,
		0x03F, 0x0000022A,
		0x033, 0x00000341,
		0x03F, 0x00000625,
		0x033, 0x00000342,
		0x03F, 0x00000628,
		0x033, 0x00000343,
		0x03F, 0x00000665,
		0x033, 0x00000344,
		0x03F, 0x00000686,
		0x033, 0x00000345,
		0x03F, 0x000006E5,
		0x033, 0x00000346,
		0x03F, 0x00000EE6,
		0x033, 0x00000347,
		0x03F, 0x00000EE9,
		0x033, 0x00000348,
		0x03F, 0x00000EEC,
		0x033, 0x00000349,
		0x03F, 0x00000EEF,
		0x033, 0x0000034A,
		0x03F, 0x00000EF2,
		0x033, 0x00000200,
		0x03F, 0x00000622,
		0x033, 0x00000201,
		0x03F, 0x00000625,
		0x033, 0x00000202,
		0x03F, 0x00000628,
		0x033, 0x00000203,
		0x03F, 0x00000665,
		0x033, 0x00000204,
		0x03F, 0x00000C49,
		0x033, 0x00000205,
		0x03F, 0x00000C4C,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0xA0000000,	0x00000000,
		0x033, 0x00000340,
		0x03F, 0x0000022B,
		0x033, 0x00000341,
		0x03F, 0x00000626,
		0x033, 0x00000342,
		0x03F, 0x00000629,
		0x033, 0x00000343,
		0x03F, 0x00000666,
		0x033, 0x00000344,
		0x03F, 0x00000687,
		0x033, 0x00000345,
		0x03F, 0x000006E6,
		0x033, 0x00000346,
		0x03F, 0x00000EE7,
		0x033, 0x00000347,
		0x03F, 0x00000EEA,
		0x033, 0x00000348,
		0x03F, 0x00000EED,
		0x033, 0x00000349,
		0x03F, 0x00000EF0,
		0x033, 0x0000034A,
		0x03F, 0x00000EF3,
		0x033, 0x00000200,
		0x03F, 0x00000623,
		0x033, 0x00000201,
		0x03F, 0x00000626,
		0x033, 0x00000202,
		0x03F, 0x00000629,
		0x033, 0x00000203,
		0x03F, 0x00000666,
		0x033, 0x00000204,
		0x03F, 0x00000C4A,
		0x033, 0x00000205,
		0x03F, 0x00000C4D,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000247,
		0x033, 0x00000281,
		0x03F, 0x00000642,
		0x033, 0x00000282,
		0x03F, 0x00000645,
		0x033, 0x00000283,
		0x03F, 0x00000648,
		0x033, 0x00000284,
		0x03F, 0x00000A4B,
		0x033, 0x00000285,
		0x03F, 0x00000A4E,
		0x033, 0x00000286,
		0x03F, 0x00000EE6,
		0x033, 0x00000287,
		0x03F, 0x00000EE9,
		0x033, 0x00000288,
		0x03F, 0x00000EEC,
		0x033, 0x00000289,
		0x03F, 0x00000EEF,
		0x033, 0x0000028A,
		0x03F, 0x00000EF2,
		0x033, 0x00000300,
		0x03F, 0x0000022A,
		0x033, 0x00000301,
		0x03F, 0x0000022D,
		0x033, 0x00000302,
		0x03F, 0x00000645,
		0x033, 0x00000303,
		0x03F, 0x00000648,
		0x033, 0x00000304,
		0x03F, 0x0000064B,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
		0x0EE, 0x00000000,
		0x0EE, 0x00008000,
		0x033, 0x00000020,
		0x03F, 0x00055077,
		0x033, 0x00000021,
		0x03F, 0x00055077,
		0x033, 0x00000022,
		0x03F, 0x00055077,
		0x033, 0x00000023,
		0x03F, 0x00055077,
		0x033, 0x00000024,
		0x03F, 0x00055077,
		0x033, 0x00000025,
		0x03F, 0x00055077,
		0x033, 0x00000026,
		0x03F, 0x00055077,
		0x033, 0x00000027,
		0x03F, 0x00055077,
		0x033, 0x00000030,
		0x03F, 0x000550F6,
		0x033, 0x00000031,
		0x03F, 0x000550F6,
		0x033, 0x00000032,
		0x03F, 0x000550F6,
		0x033, 0x00000033,
		0x03F, 0x000550F6,
		0x033, 0x00000034,
		0x03F, 0x000550F6,
		0x033, 0x00000035,
		0x03F, 0x000550F6,
		0x033, 0x00000036,
		0x03F, 0x000550F6,
		0x033, 0x00000037,
		0x03F, 0x000550F6,
		0x0EE, 0x00000000,
		0x0EE, 0x00000020,
		0x030, 0x00000021,
		0x030, 0x00001021,
		0x030, 0x00002021,
		0x0EE, 0x00000000,
		0x0EF, 0x00000020,
		0x033, 0x00000008,
		0x03F, 0x00000006,
		0x033, 0x00000009,
		0x03F, 0x00000006,
		0x033, 0x0000000A,
		0x03F, 0x00000006,
		0x033, 0x0000000B,
		0x03F, 0x00000006,
		0x0EF, 0x00000000,
		0x01B, 0x00073A60,
	0x84000000,	0x00000000,	0x40000000,	0x00000000,
		0x0ED, 0x00000004,
		0x033, 0x00000057,
		0x03F, 0x0000098F,
		0x033, 0x00000058,
		0x03F, 0x00002909,
		0x033, 0x00000059,
		0x03F, 0x0000290A,
		0x033, 0x0000005A,
		0x03F, 0x0000290B,
		0x033, 0x0000005B,
		0x03F, 0x0000290D,
		0x033, 0x0000005C,
		0x03F, 0x0000290E,
		0x0ED, 0x00000000,
	0x95000000,	0x00000000,	0x40000000,	0x00000000,
		0x0ED, 0x00000004,
		0x033, 0x00000057,
		0x03F, 0x0000098F,
		0x033, 0x00000058,
		0x03F, 0x00002909,
		0x033, 0x00000059,
		0x03F, 0x0000290A,
		0x033, 0x0000005A,
		0x03F, 0x0000290B,
		0x033, 0x0000005B,
		0x03F, 0x0000290D,
		0x033, 0x0000005C,
		0x03F, 0x0000290E,
		0x0ED, 0x00000000,
	0xA0000000,	0x00000000,
		0x0ED, 0x00000004,
		0x033, 0x00000057,
		0x03F, 0x00002986,
		0x033, 0x00000058,
		0x03F, 0x00002987,
		0x033, 0x00000059,
		0x03F, 0x00002989,
		0x033, 0x0000005A,
		0x03F, 0x0000298A,
		0x033, 0x0000005B,
		0x03F, 0x0000298B,
		0x033, 0x0000005C,
		0x03F, 0x0000298D,
		0x0ED, 0x00000000,
	0xB0000000,	0x00000000,

};
u32 arraylength_8721d_radioa = sizeof(array_mp_8721d_radioa) / sizeof(u32);
#endif

/******************************************************************************
 *                           power by limit for 1.8v
 ******************************************************************************/
const u8 array_mp_8721d_txpwr_lmt_type0[] = {
#if defined(SUPPORT_18V)
	/* regulation, band, bandwidth, rateSection, rfPath, chnl, value */
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	22,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	14,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	14,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	20,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	22,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	22,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	22,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	22,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	22,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	22,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	22,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	20,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	2,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	2,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	2,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	2,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	20,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	20,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	0,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	0,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	0,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	0,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	26,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	24,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	22,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	22,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	22,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	22,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	24,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	22,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	22,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	22,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	22,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	14,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	14,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	4,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	24,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	26,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	4,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	24,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	24,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	4,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	24,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	4,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	18,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	18,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	14,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	17,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	18,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	20,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	20,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	18,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	14,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	16,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	16,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	16,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	15,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	14,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	14,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	18,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	20,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	14,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	14,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	18,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	14,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	20,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	14,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	20,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	14,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	20,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	18,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	10,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	10,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	14,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	18,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	10,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	10,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	18,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	14,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	18,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	18,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	16,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	14,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	18,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	16,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	18,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	10,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	10,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	16,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	10,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	10,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	10,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	18,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	12,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	12,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	16,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	18,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	12,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	12,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	17,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	17,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	18,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	18,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	17,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	17,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	18,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	17,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	17,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	17,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	13,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	18,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	18,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	13,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	17,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	13,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	13,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	17,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	17,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	17,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	14,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	(u8)-63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	(u8)-63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	18,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	14,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	(u8)-63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	16,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	14,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	18,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	(u8)-63
#endif
};

/******************************************************************************
 *                           power by limit for 3.3v
 ******************************************************************************/
const u8 array_mp_8721d_txpwr_lmt_type1[] = {
#if defined(SUPPORT_33V)
	/* regulation, band, bandwidth, rateSection, rfPath, chnl, value */
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	32,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	32,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	32,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	38,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	40,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	40,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	40,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	40,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	39,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	39,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	38,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	15,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	15,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	15,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	28,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	15,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	24,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	35,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	32,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	32,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	32,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	42,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	42,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	42,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	42,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	38,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	36,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	25,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	24,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	24,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	29,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	0,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	0,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	0,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	0,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	18,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	36,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	36,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	36,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	36,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	32,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	32,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	32,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	24,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	24,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	24,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	(u8)-2,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	(u8)-2,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	(u8)-2,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	(u8)-2,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	12,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	32,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	32,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	32,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	32,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	32,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	32,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	32,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	32,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	32,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	27,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	25,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	25,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	25,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	14,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	14,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	14,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	14,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_CN,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	24,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	24,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	24,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	22,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	31,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	32,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	26,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	33,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	32,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	29,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	29,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	24,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	24,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	37,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	24,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	22,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	25,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	22,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	26,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	30,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	25,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	24,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	24,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	25,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	24,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	27,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	22,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	25,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	22,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	26,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	25,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	26,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	25,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	30,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	25,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	63,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	25,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	28,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	30,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	28,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	27,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	(u8)-63,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	27,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	16,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	16,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	63,
	PW_LMT_REGU_IC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	28,
	PW_LMT_REGU_KCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	28,
	PW_LMT_REGU_ACMA,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	16,
	PW_LMT_REGU_CHILE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	25,
	PW_LMT_REGU_UKRAINE,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	16,
	PW_LMT_REGU_MEXICO,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	28,
	PW_LMT_REGU_CN,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	16
#endif
};

u32 arraylength_8721d_txpwr_lmt_type1 = sizeof(array_mp_8721d_txpwr_lmt_type1)  / sizeof(u8);
u32 arraylength_8721d_txpwr_lmt_type0 = sizeof(array_mp_8721d_txpwr_lmt_type0)  / sizeof(u8);

#if 1
const s8 delta_swing_xtal_mp_n_txxtaltrack_8721d[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const s8 delta_swing_xtal_mp_p_txxtaltrack_8721d[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, -4, -8, -8,
	 -8, -10, -10, -10, -10, -10, -16, -16, -16, -16, -16};

const s8 delta_swingidx_mp_5ga_n_txpwrtrk_8721d[][30] = {
	{0, 0, 0, 1, 1, 1, 2, 3, 3, 3, 3, 4, 5, 5, 6, 6,
	 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7},
	{0, 0, 0, 1, 1, 1, 2, 3, 3, 3, 3, 4, 5, 5, 6, 6,
	 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7},
	{0, 0, 0, 1, 1, 1, 2, 3, 3, 3, 3, 4, 5, 5, 6, 6,
	 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7},
};

const s8 delta_swingidx_mp_5ga_p_txpwrtrk_8721d[][30] = {
	{0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8},
	{0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8},
	{0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8},
};

const s8 delta_swingidx_mp_2ga_n_txpwrtrk_8721d[]    = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 6,
	 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
const s8 delta_swingidx_mp_2ga_p_txpwrtrk_8721d[]    = {
	0, 0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6,
	 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8};
const s8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8721d[] = {
	0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 5,
	 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
const s8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8721d[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6,
	 6, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
#endif


