//#include "DW_common.h"

/* --------------------------------------------------------------------
**
** File     : SPI_public.h
** Created  : $Date: 2008/10/30 $
** Abstract : This is the public header file for the SPI
**            low-level-driver
**
** --------------------------------------------------------------------
*/

/****h* drivers.SPI/SPI.api
 * NAME
 *  SPI API overview
 * DESCRIPTION
 *  This section gives an overview of the SPI software driver
 *  Application Programming Interface (API).
 * SEE ALSO
 *  dmac.data, dmac.functions
 ***/

/****h* SPI.api/SPI.data_types
 * NAME
 *  DW_ahb_SPI data types and definitions
 * DESCRIPTION
 *  The data types below are used as function arguments for the DMA
 *  Controller API. Users of this driver must pass the relevant data
 *  types below to the API function that is being used.
 *
 *    - enum spi_command
 *    - struct dw_dmac_channel_config
 *
 * SEE ALSO
 *  SPI.api, dmac.configuration, dmac.command, dmac.status,
 *  SPI.interrupt
 ***/

/****h* SPI.api/dmac.configuration
 * NAME
 *  SPI configuration functions
 * DESCRIPTION
 *  SPI driver are listed
 *  below:
 *
 *
 * SEE ALSO
 *  SPI.api, dmac.data_types, dmac.command, dmac.status,
 *  SPI.interrupt
 ***/

/****h* SPI.api/spi.command
 * NAME
 *  SPI command functions
 * DESCRIPTION
 *  An API command function causes some functional behavior
 *  driver are list below:
 *    
 *    - spi_chip_erase()
 *    - spi_se_erase()
 *    - spi_set_status()
 *    - spi_en_write()
 *    - spi_dis_write()
 *    - spi_set_protect_mem()
 *    - spi_set_write_disable()
 *    - spi_set_write_enable()
 *    //- spi_set_en4k()
 *    //- spi_set_ex4k()
 *    - spi_enter_dp()
 *    - spi_release_dp()
 *    - spi_write_byte()
 *    - spi_read_byte()
 *    - spi_write_word()
 *    - spi_read_word()
 *    - spi_fastread_byte()
 *    - spi_fastread_word()
 *
 * SEE ALSO
 *  dmac.api, dmac.data_types, dmac.configuration, dmac.status,
 *  dmac.interrupt
 ***/

/****h* SPI.api/SPI.status
 * NAME
 *  SPI status functions
 * DESCRIPTION
 *  An API status function returns the status information about
 *  the current state of the SPI controller and/or the driver. 
 *  The driver are listed below:
 *   
 *    - spi_init() 
 *    - spi_get_status()
 *    - spi_read_id()
 *    - spi_read_ect_id()
 *    - spi_read_mf_id()
 *    - spi_wait_busy()
  *  
 * SEE ALSO
 *  dmac.api, dmac.data_types, dmac.configuration, dmac.command,
 *  dmac.interrupt
 ***/


/****d* spi.data/spi_command
 * DESCRIPTION
 *  This data type is used to describe the SPI controller's command
 *  number.  This data type is used by many of the API functions in
 *  the driver.
 */
enum spi_command {
      WRSR          = 0x01,
      PP            = 0x02,
      READ          = 0x03,
      WRDI          = 0x04,
      RDSR          = 0x05,
      WREN          = 0x06,
      FAST_READ     = 0x0b,
      Parallel_mode = 0x55,
      REMS          = 0x90, 
      RDID          = 0x9f,
      EN4K          = 0Xa5,
      RES           = 0xab,
      EX4K          = 0xb5,
      DP            = 0xb9,
      BE            = 0xc7,
      SE            = 0xd8
};
/*****/

/***** spi.data/spi_protect_mem
 * DESCRIPTION
 *  This data type is used to describe the protect memory size
 */
enum spi_protect_mem {
      SEC_NONE      = 0x00,
      SEC_64        = 0x01,
      SEC_63_62     = 0x02,
      SEC_63_60     = 0x03,
      SEC_63_56     = 0x04,
      SEC_63_48     = 0x05,
      SEC_63_32     = 0x06,
      SEC_ALL       = 0x07
};
/*****/



/***** spi.functions/spi_chip_erase() in spi_driver.s
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_chip_erase(struct dw_device *dev);
/*****/

/***** spi.functions/spi_se_erase() 
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 *  addr        -- erase address
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_se_erase(struct dw_device *, unsigned short int );
/*****/
/***** spi.functions/spi_set_status() in spi_driver.s
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 *  data        -- the {1'b, program, BP2, BP1, BP0, WEL, WIP}
 * RETURN VALUE
 *  -DW_EIO     -- if an error occurred
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_set_status(struct dw_device *, int );
/*****/

/***** spi.functions/spi_dis_write() in spi_driver.s
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 *  data        -- the {1'b, program, BP2, BP1, BP0, WEL, WIP}
 * RETURN VALUE
 *  -DW_EIO     -- if an error occurred
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_dis_write(struct dw_device *);
/*****/

/***** spi.functions/spi_enable_write() in spi_driver.s
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 *  data        -- the {1'b, program, BP2, BP1, BP0, WEL, WIP}
 * RETURN VALUE
 *  -DW_EIO     -- if an error occurred
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_enable_write(struct dw_device *dev);
/*****/

/***** spi.functions/spi_set_protect_mem()
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev               -- DMA controller device handle
 *  spi_protect_mem   -- enum data 
 * RETURN VALUE
 *  -DW_EIO     -- if an error occurred
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_set_protect_mem(struct dw_device *, enum spi_protect_mem );
/*****/

/***** spi.functions/spi_enter_dp()
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_enter_dp();
/*****/

/***** spi.functions/spi_set_write_disable()
 * DESCRIPTION
 *  This function is used to disable SPI write. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_set_write_disable(struct dw_device *dev);
/*****/

/***** spi.functions/spi_set_write_enable()
 * DESCRIPTION
 *  This function is used to enable SPI write enable.
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_set_write_enable(struct dw_device *);
/*****/

/***** spi.functions/spi_set_en4k()
 * DESCRIPTION
 *  This function is used to setv SPI EN4K command.
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
//void spi_set_en4k(struct dw_device *dev);

/***** spi.functions/spi_set_ex4k()
 * DESCRIPTION
 *  This function is used to setv SPI EX4K command.
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
//void spi_set_ex4k(struct dw_device *dev);

/***** spi.functions/spi_release_dp()
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * RETURN VALUE
 *  0           -- if successful
 *  -DW_EIO     -- if an error occurred
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_release_dp(struct dw_device *);
/*****/

/***** spi.functions/spi_init() in spi_driver.s
 * DESCRIPTION
 *  This function is used to init SPI controller.
 *  for wirte control signal and sec_prot signals for write data. 
 *
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * RETURN VALUE
 *  none 
 */
//void spi_init(struct dw_device *);
/*****/

/***** spi.functions/spi_get_status() in spi_driver.s
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * RETURN VALUE
 *  int         -- value of status regrister(SR:0x28)
 */
int spi_get_stataus(struct dw_device *dev);
/*****/


/***** spi.functions/spi_read_id()
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * RETURN VALUE
 *  int         -- the ID of SPI
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
int spi_read_id(struct dw_device *dev);
/*****/

/***** spi.functions/spi_read_ect_id()
 * DESCRIPTION
 *  This function is used to read the electronic id. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * RETURN VALUE
 *  int         -- the ID of SPI
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
int spi_read_ect_id(struct dw_device *dev);
/*****/

/***** spi.functions/spi_read_mf_id()
 * DESCRIPTION
 *  This function is used to read the electronic manufacturer
 *  & device ID.
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * RETURN VALUE
 *  int         -- the ID of SPI
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
int spi_read_mf_id(struct dw_device *, int );
/*****/

/***** spi.functions/spi_wait_busy()
 * DESCRIPTION
 *  This function is used to read the SPI controller. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_wait_busy(struct dw_device *);
/*****/

/***** spi.functions/spi_write_byte();
 * DESCRIPTION
 *  This function is used to write data to SPI. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_write_byte(struct dw_device *dev, unsigned short int addr, int wdata);
/*****/

/***** spi.functions/spi_read_byte();
 * DESCRIPTION
 *  This function is used to read data from SPI. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
int spi_read_byte(struct dw_device *, unsigned short int );
/*****/

/***** spi.functions/spi_write_word();
 * DESCRIPTION
 *  This function is used to write data to SPI. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
void spi_write_word(struct dw_device *, unsigned short int , int );
/*****/

/***** spi.functions/spi_read_word();
 * DESCRIPTION
 *  This function is used to read data from SPI. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
int spi_read_word(struct dw_device *dev, unsigned short int addr);
/*****/

/***** spi.functions/spi_fastread_byte();
 * DESCRIPTION
 *  This function is used to read data from SPI. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
int spi_fastread_byte(struct dw_device *, unsigned short int );
/*****/

/***** spi.functions/spi_fastread_word();
 * DESCRIPTION
 *  This function is used to read data from SPI. 
 *  ARGUMENTS
 *  dev         -- DMA controller device handle
 * SEE ALSO
 *  dw_device
 * SOURCE
 */
int spi_fastread_word(struct dw_device *, unsigned short int );

#define bfoSSI_CTRLR0_CFS             ((unsigned int)   12)
#define bfwSSI_CTRLR0_CFS             ((unsigned int)    3)
#define bfoSSI_CTRLR0_SRL             ((unsigned int)   11)
#define bfwSSI_CTRLR0_SRL             ((unsigned int)    1)
#define bfoSSI_CTRLR0_SLV_OE          ((unsigned int)   10)
#define bfwSSI_CTRLR0_SLV_OE          ((unsigned int)    1)
#define bfoSSI_CTRLR0_TMOD            ((unsigned int)    8)
#define bfwSSI_CTRLR0_TMOD            ((unsigned int)    2)
#define bfoSSI_CTRLR0_SCPOL           ((unsigned int)    7)
#define bfwSSI_CTRLR0_SCPOL           ((unsigned int)    1)
#define bfoSSI_CTRLR0_FRF             ((unsigned int)    4)
#define bfwSSI_CTRLR0_FRF             ((unsigned int)    2)
#define bfoSSI_CTRLR0_DFS             ((unsigned int)    0)
#define bfwSSI_CTRLR0_DFS             ((unsigned int)    4)

#define bfoSSI_CTRLR1_NDF             ((unsigned int)    0)
#define bfwSSI_CTRLR1_NDF             ((unsigned int)   16)

#define bfoSSI_SSIENR_SSI_EN          ((unsigned int)    0)
#define bfwSSI_SSIENR_SSI_EN          ((unsigned int)    1)

#define bfoSSI_MWCR_MHS               ((unsigned int)    2)
#define bfwSSI_MWCR_MHS               ((unsigned int)    1)
#define bfoSSI_MWCR_MDD               ((unsigned int)    1)
#define bfwSSI_MWCR_MDD               ((unsigned int)    1)
#define bfoSSI_MWCR_MWMOD             ((unsigned int)    0)
#define bfwSSI_MWCR_MWMOD             ((unsigned int)    1)

#define bfoSSI_SER                    ((unsigned int)    0)
#define bfwSSI_SER                    ((unsigned int)    4)

#define bfoSSI_BAUDR_SCKDV            ((unsigned int)    0)
#define bfwSSI_BAUDR_SCKDV            ((unsigned int)   16)

#define bfoSSI_TXFTLR_TFT             ((unsigned int)    0)
#define bfwSSI_TXFTLR_TFT             ((unsigned int)    3)

#define bfoSSI_RXFTLR_RFT             ((unsigned int)    0)
#define bfwSSI_RXFTLR_RFT             ((unsigned int)    3)

#define bfoSSI_TXFLR_TXTFL            ((unsigned int)    0)
#define bfwSSI_TXFLR_TXTFL            ((unsigned int)    3)

#define bfoSSI_RXFLR_RXTFL            ((unsigned int)    0)
#define bfwSSI_RXFLR_RXTFL            ((unsigned int)    3)

#define bfoSSI_SR_BUSY                ((unsigned int)    0)
#define bfwSSI_SR_BUSY                ((unsigned int)    1)
#define bfoSSI_SR_TFNF                ((unsigned int)    1)
#define bfwSSI_SR_TFNF                ((unsigned int)    1)
#define bfoSSI_SR_TFE                 ((unsigned int)    2)
#define bfwSSI_SR_TFE                 ((unsigned int)    1)
#define bfoSSI_SR_RFNE                ((unsigned int)    3)
#define bfwSSI_SR_RFNE                ((unsigned int)    1)
#define bfoSSI_SR_RFF                 ((unsigned int)    4)
#define bfwSSI_SR_RFF                 ((unsigned int)    1)
#define bfoSSI_SR_TXE                 ((unsigned int)    5)
#define bfwSSI_SR_TXE                 ((unsigned int)    1)
#define bfoSSI_SR_DCOL                ((unsigned int)    6)
#define bfwSSI_SR_DCOL                ((unsigned int)    1)

#define bfoSSI_IMR_TXEIM              ((unsigned int)     0)
#define bfwSSI_IMR_TXEIM              ((unsigned int)     1)
#define bfoSSI_IMR_TXOIM              ((unsigned int)     1)
#define bfwSSI_IMR_TXOIM              ((unsigned int)     1)
#define bfoSSI_IMR_RXUIM              ((unsigned int)     2)
#define bfwSSI_IMR_RXUIM              ((unsigned int)     1)
#define bfoSSI_IMR_RXOIM              ((unsigned int)     3)
#define bfwSSI_IMR_RXOIM              ((unsigned int)     1)
#define bfoSSI_IMR_RXFIM              ((unsigned int)     4)
#define bfwSSI_IMR_RXFIM              ((unsigned int)     1)
#define bfoSSI_IMR_MSTIM              ((unsigned int)     5)
#define bfwSSI_IMR_MSTIM              ((unsigned int)     1)

#define bfoSSI_ISR_TXEIS              ((unsigned int)     0)
#define bfwSSI_ISR_TXEIS              ((unsigned int)     1)
#define bfoSSI_ISR_TXOIS              ((unsigned int)     1)
#define bfwSSI_ISR_TXOIS              ((unsigned int)     1)
#define bfoSSI_ISR_RXUIS              ((unsigned int)     2)
#define bfwSSI_ISR_RXUIS              ((unsigned int)     1)
#define bfoSSI_ISR_RXOIS              ((unsigned int)     3)
#define bfwSSI_ISR_RXOIS              ((unsigned int)     1)
#define bfoSSI_ISR_RXFIS              ((unsigned int)     4)
#define bfwSSI_ISR_RXFIS              ((unsigned int)     1)
#define bfoSSI_ISR_MSTIS              ((unsigned int)     5)
#define bfwSSI_ISR_MSTIS              ((unsigned int)     1)

#define bfoSSI_RISR_TXEIR             ((unsigned int)     0)
#define bfwSSI_RISR_TXEIR             ((unsigned int)     1)
#define bfoSSI_RISR_TXOIR             ((unsigned int)     1)
#define bfwSSI_RISR_TXOIR             ((unsigned int)     1)
#define bfoSSI_RISR_RXUIR             ((unsigned int)     2)
#define bfwSSI_RISR_RXUIR             ((unsigned int)     1)
#define bfoSSI_RISR_RXOIR             ((unsigned int)     3)
#define bfwSSI_RISR_RXOIR             ((unsigned int)     1)
#define bfoSSI_RISR_RXFIR             ((unsigned int)     4)
#define bfwSSI_RISR_RXFIR             ((unsigned int)     1)
#define bfoSSI_RISR_MSTIR             ((unsigned int)     5)
#define bfwSSI_RISR_MSTIR             ((unsigned int)     1)

#define bfoSSI_TXOICR_TXOICR          ((unsigned int)     0)
#define bfwSSI_TXOICR_TXOICR          ((unsigned int)     1)

#define bfoSSI_RXOICR_RXOICR          ((unsigned int)     0)
#define bfwSSI_RXOICR_RXOICR          ((unsigned int)     1)

#define bfoSSI_RXUICR_RXUICR          ((unsigned int)     0)
#define bfwSSI_RXUICR_RXUICR          ((unsigned int)     1)

#define bfoSSI_MSTICR_MSTICR          ((unsigned int)     0)
#define bfwSSI_MSTICR_MSTICR          ((unsigned int)     1)

#define bfoSSI_ICR_ICR                ((unsigned int)     0)
#define bfwSSI_ICR_ICR                ((unsigned int)     1)

#define bfoSSI_DMACR_RDMAE            ((unsigned int)     0)
#define bfwSSI_DMACR_RDMAE            ((unsigned int)     1)
#define bfoSSI_DMACR_TDMAE            ((unsigned int)     1)
#define bfwSSI_DMACR_TDMAE            ((unsigned int)     1)
                                       
#define bfoSSI_DMATDLR_DMATDL         ((unsigned int)     0)
#define bfwSSI_DMATDLR_DMATDL         ((unsigned int)     3)

#define bfoSSI_DMARDLR_DMARDL         ((unsigned int)     0)
#define bfwSSI_DMARDLR_DMARDL         ((unsigned int)     3)

#define bfoSSI_DR0_dr0                ((unsigned int)     0)
#define bfwSSI_DR0_dr0                ((unsigned int)    16)
#define bfoSSI_DR1_dr1                ((unsigned int)     0)
#define bfwSSI_DR1_dr1                ((unsigned int)    16)
#define bfoSSI_DR2_dr2                ((unsigned int)     0)
#define bfwSSI_DR2_dr2                ((unsigned int)    16)
#define bfoSSI_DR3_dr3                ((unsigned int)     0)
#define bfwSSI_DR3_dr3                ((unsigned int)    16)
#define bfoSSI_DR4_dr4                ((unsigned int)     0)
#define bfwSSI_DR4_dr4                ((unsigned int)    16)
#define bfoSSI_DR5_dr5                ((unsigned int)     0)
#define bfwSSI_DR5_dr5                ((unsigned int)    16)
#define bfoSSI_DR6_dr6                ((unsigned int)     0)
#define bfwSSI_DR6_dr6                ((unsigned int)    16)
#define bfoSSI_DR7_dr7                ((unsigned int)     0)
#define bfwSSI_DR7_dr7                ((unsigned int)    16)
#define bfoSSI_DR8_dr8                ((unsigned int)     0)
#define bfwSSI_DR8_dr8                ((unsigned int)    16)
#define bfoSSI_DR9_dr9                ((unsigned int)     0)
#define bfwSSI_DR9_dr9                ((unsigned int)    16)
#define bfoSSI_DR10_dr10              ((unsigned int)     0)
#define bfwSSI_DR10_dr10              ((unsigned int)    16)
#define bfoSSI_DR11_dr11              ((unsigned int)     0)
#define bfwSSI_DR11_dr11              ((unsigned int)    16)
#define bfoSSI_DR12_dr12              ((unsigned int)     0)
#define bfwSSI_DR12_dr12              ((unsigned int)    16)
#define bfoSSI_DR13_dr13              ((unsigned int)     0)
#define bfwSSI_DR13_dr13              ((unsigned int)    16)
#define bfoSSI_DR14_dr14              ((unsigned int)     0)
#define bfwSSI_DR14_dr14              ((unsigned int)    16)
#define bfoSSI_DR15_dr15              ((unsigned int)     0)
#define bfwSSI_DR15_dr15              ((unsigned int)    16)

struct dw_ssi_portmap {
//typedef unsigned int unsigned int;

  /* Channel registers                                    */
  /* The offset address for each of the channel registers */
  /*  is shown for channel 0. For other channel numbers   */
  /*  use the following equation.                         */
  /*                                                      */

  volatile unsigned int ctrlr0;           /* control for ssi (0x000) */
  volatile unsigned int ctrlr1;           /* control for ssi (0x004) */
  volatile unsigned int ssienr;           /* control for ssi (0x008) */
  volatile unsigned int mwcr;             /* control for ssi (0x00c) */
  volatile unsigned int ser;              /* control for ssi (0x010) */
  volatile unsigned int baudr;            /* control for ssi (0x014) */
  volatile unsigned int txftlr;           /* control for ssi (0x018) */
  volatile unsigned int rxftlr;           /* control for ssi (0x01c) */
  volatile unsigned int txflr;            /* control for ssi (0x020) */
  volatile unsigned int rxflr;            /* control for ssi (0x024) */
  volatile unsigned int sr;               /* control for ssi (0x028) */
  volatile unsigned int imr;              /* control for ssi (0x02c) */
  volatile unsigned int isr;              /* control for ssi (0x030) */
  volatile unsigned int risr;             /* control for ssi (0x034) */
  volatile unsigned int txoicr;           /* control for ssi (0x038) */
  volatile unsigned int rxoicr;           /* control for ssi (0x03c) */
  volatile unsigned int rxuicr;           /* control for ssi (0x040) */
  volatile unsigned int msticr;           /* control for ssi (0x044) */
  volatile unsigned int icr;              /* control for ssi (0x048) */
  volatile unsigned int dmacr;            /* control for ssi (0x04c) */
  volatile unsigned int dmatdlr;          /* control for ssi (0x050) */
  volatile unsigned int dmardlr;          /* control for ssi (0x054) */
  volatile unsigned int idr;              /* control for ssi (0x058) */
  volatile unsigned int ssi_comp_version; /* control for ssi (0x05c) */
  volatile unsigned int dr[16];           /* control for ssi (0x060)~(0x9c) */
};

#ifndef DW_COMMON_ERRNO_H
#define DW_COMMON_ERRNO_H

#define DW_EPERM            1   // operation not permitted
#define DW_EIO              5   // I/O error
#define DW_ENXIO            6   // no such device or address
#define DW_ENOMEM           12  // out of memory
#define DW_EACCES           13  // permission denied
#define DW_EBUSY            16  // device or resource busy
#define DW_ENODEV           19  // no such device
#define DW_EINVAL           22  // invalid argument
#define DW_ENOSPC           28  // no space left on device
#define DW_ENOSYS           38  // function not implemented/supported
#define DW_ECHRNG           44  // channel number out of range
#define DW_ENODATA          61  // no data available
#define DW_ETIME            62  // timer expired
#define DW_EPROTO           71  // protocol error


#endif  // DW_COMMON_ERRNO_H


/*****/


