#include "rlx_ep_cpu.h"
#include "rlx_flash_cmd_defs.h"
##the SSI_BASE is pass parameter

        .section ".flash" , "ax"
        .set noreorder
        
        .globl  spi_flash_prog
        .ent    spi_flash_prog
spi_flash_prog:
        #a0: SSI_base
        #v0: return value
        #t0, t1: using   

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t1, 16(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        sw      zero, 0x8(a0)              #disable SSI
        li      t0, 0x73c7                 
        sw      t0, 0x0(a0)                #set CTRLR0: EEPROM
        sw      zero, 0x4(a0)              #set read 1 of data frame
        li      t0, 0x1                    #enable SER               
        sw      t0, 0x10(a0)      
        li      t1, 0x1                       
        sw      t1, 0x8(a0)                #enable SSI

        li      t1, RDSR                   #set read status command of SPI 
        sw      t1, 0x60(a0)
         
        jal     dw_ssi_wait_nobusy       
        nop
        jal     spi_wait_busy
        nop

        or      t0, zero, a0               
        lw      v0, 0x60(a0)               #read read status
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t1, 16(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop

        .end spi_flash_prog   
        
        .globl  spi_get_status
        .ent    spi_get_status
spi_get_status:
        #a: SSI_base
        #v0: return value
        #t0, t1: using   

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t1, 16(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        sw      zero, 0x8(a0)              #disable SSI
        li      t0, 0x73c7                 
        sw      t0, 0x0(a0)                #set CTRLR0: EEPROM
        sw      zero, 0x4(a0)              #set read 1 of data frame
        li      t0, 0x1                    #enable SER               
        sw      t0, 0x10(a0)      
        li      t1, 0x1                       
        sw      t1, 0x8(a0)                #enable SSI

        li      t1, RDSR                   #set read status command of SPI 
        sw      t1, 0x60(a0)
         
        jal     dw_ssi_wait_nobusy       
        nop
        jal     spi_wait_busy
        nop

        or      t0, zero, a0               
        lw      v0, 0x60(a0)               #read read status
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t1, 16(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop

        .end spi_get_status   
######################################################################
        .globl  spi_chip_erase
        .ent    spi_chip_erase
spi_chip_erase:
        #a0: SSI_BASE
        #t0: using    

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSI   
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: Transmit only 
        li      t0, 0x1                 
        sw      t0, 0x10(a0)               #enable SER      
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSI

        li      t0, WREN
        sw      t0, 0x60(a0)               #write enable of SPI
    
        jal     dw_ssi_wait_nobusy
        nop

        li      t0, BE
        sw      t0, 0x60(a0)               #set chip earse command of SPI
        
        jal     dw_ssi_wait_nobusy
        nop
        jal     spi_enable_write           #enable WEL and pass data to set_status
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_chip_erase  
 ######################################################################
        .globl  spi_se_erase
        .ent    spi_se_erase
spi_se_erase:
        #a0: SSI_BASE
        #a1: address
        #t0, t2, t3, t4: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t2, 16(sp)
        sw      t3, 20(sp)
        sw      t4, 24(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1                 
        sw      t0, 0x10(a0)               #enable SER      
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR

        li      t0, WREN
        sw      t0, 0x60(a0)               #enable write of SPI
    
        jal     dw_ssi_wait_nobusy
        nop
   
        sw      zero, 0x10(a0)             #disable SER    
        
        #issue WR
        li      t0, SE
        andi    t2, a1,  0xff              #addr (xx_xx--)   
        srl     a1, a1, 8                  
        andi    t3, a1,  0xff              #addr (xx_--xx) >>8
        srl     a1, a1, 8
        andi    t4, a1,  0xff              #addr (--_xxxx) >>16

        #cmd
        sw      t0, 0x60(a0)               #set sector_erase command of SPI
        #addr
        sw      t4, 0x60(a0)
        sw      t3, 0x60(a0)
        sw      t2, 0x60(a0)
       
        li      t0, 0x1                    #enable SER               
        sw      t0, 0x10(a0)      

        jal     dw_ssi_wait_nobusy
        nop
        jal     spi_wait_busy               
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t2, 16(sp)
        lw      t3, 20(sp)
        lw      t4, 24(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                          #Return
        nop
        .end spi_se_erase   
######################################################################
        .globl  spi_wait_busy
        .ent    spi_wait_busy

spi_wait_busy:
        #a0: SSI_BASE
        #t0: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)
        
        sw      zero, 0x8(a0)              #disable SSIENR
        sw      zero, 0x4(a0)              #set read 1 of data frame
        li      t0, 0x73c7
        sw      t0, 0x0(a0)                #set CTRLR0: EEPROM mode
        li      t0, 0x1
        sw      t0, 0x10(a0)               #enable SER
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR
    
__checkstat2:
        li      t0, RDSR                       
        sw      t0, 0x60(a0)               #set read status command of SPI

        jal     dw_ssi_wait_nobusy
        nop

        lw      t0, 0x60(a0)               #load status of SPI
        nop

        andi    t0, t0, 0x01               #check SPI is not write progress
        bne     t0, zero, __checkstat2   
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_wait_busy   
######################################################################
        .globl  spi_set_status
        .ent    spi_set_status

spi_set_status:
        #a0: SSI_BASE, 
        #a1: set number to status register
        #t0: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1
        sw      t0, 0x10(a0)               #enable SER
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIER

        li      t0, WREN
        sw      t0, 0x60(a0)               #enable write of SPI

        jal     dw_ssi_wait_nobusy
        nop

        sw      zero, 0x10(a0)             #disable SER
      
        li      t0, WRSR                      
        sw      t0, 0x60(a0)               #set write status command of SPI
        sw      a1, 0x60(a0)               #set status value

        li      t0, 0x1
        sw      t0, 0x10(a0)               #enable SER

        jal     dw_ssi_wait_nobusy
        nop
        jal     spi_wait_busy
        nop
        
        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         # Return
        nop
        .end spi_set_status 
######################################################################
        .globl  spi_dis_write
        .ent    spi_dis_write 

spi_dis_write: 
        #a0: SSI_BASE 
        #t0: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1            
        sw      t0, 0x10(a0)               #enable SER 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR

        li      t0, WRDI
        sw      t0, 0x60(a0)               #disable write command of SPI
    
        jal     dw_ssi_wait_nobusy
        nop
        jal     spi_wait_busy
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,12
        jr      ra                         #Return
        nop
        .end spi_dis_write  
######################################################################
        .globl  spi_enable_write
        .ent    spi_enable_write

spi_enable_write:  
        #a0: SSI_BASE  
        #t0: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #diable SSIENR
        li      t0, 0x71c7 
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1          
        sw      t0, 0x10(a0)               #enable SER
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR

        li      t0, WREN
        sw      t0, 0x60(a0)               #enable write command of SPI
    
        jal     dw_ssi_wait_nobusy
        nop
        jal     spi_wait_busy
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_enable_write  
######################################################################
        .globl  spi_set_protect_mem
        .ent    spi_set_protect_mem

spi_set_protect_mem: 
        #a0: SSI_BASE  
        #a1: set protect memory
        #t0, t1, t2, t3: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t1, 16(sp)
        sw      t2, 20(sp)
        sw      t3, 24(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        jal     spi_get_status             #return status value
        nop

        or      t3, zero, v0               #reserve status value

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR 
        li      t0, 0x71c7            
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR
        
        li      t0, WREN
        sw      t0, 0x60(a0)               #enable write command of SPI
    
        jal     dw_ssi_wait_nobusy
        nop
        
        sw      zero, 0x10(a0)             #disable SER    

        li      t0, WRSR
        li      t2, 0xe3                   #remove BP2, BP1, BP0
        and     t3, t3, t2
        sll     t2, a1, 2
        or      t2, t3, t2
        sw      t0, 0x60(a0)               #set write status command of SPI
        sw      t2, 0x60(a0)               #new value
       
        sw      t0, 0x10(a0)               #enable SER       

        jal     dw_ssi_wait_nobusy
        nop
        jal     spi_wait_busy
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t1, 16(sp)
        lw      t2, 20(sp)
        lw      t3, 24(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_set_protect_mem
######################################################################
        .globl  spi_read_id
        .ent    spi_read_id

spi_read_id:
        #a0: SSI_BASE  
        #t0: using
        #v0: return ID value(3-byte) 

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x73c7            
        sw      t0, 0x0(a0)                #set CTRLR0: EEPROM mode
        li      t0, 0x1           
        sw      t0, 0x10(a0)               #enable SER   
        li      t0, 0x2            
        sw      t0, 0x4(a0)                #set read 3 of data frames 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR
        
        li      t0, RDID
        sw      t0, 0x60(a0)               #set read ID command of SPI
    
        jal     dw_ssi_wait_nobusy
        nop

        lw      v0, 0x60(a0)               #read ID(--_xxxx)
        nop 

        andi    v0, v0, 0xff
        sll     v0, v0, 0x8

        lw      t0, 0x60(a0)               #read ID(--_--xx)
        nop

        andi    t0, t0, 0xff
        or      v0, v0, t0
        sll     v0, v0, 0x8
         
        lw      t0, 0x60(a0)               #read ID(--_----)
        nop

        andi    t0, t0, 0xff
        or      v0, v0, t0

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         # Return
        nop
        .end spi_read_id  
######################################################################
        .globl  spi_read_ect_id
        .ent    spi_read_ect_id

spi_read_ect_id:
        ## a0: SSI_BASE
        ## t0, t1, t2, t3: using
        ## v0: return ID value(2-byte)

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t1, 16(sp)
        sw      t2, 20(sp)
        sw      t3, 24(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x73c7            
        sw      t0, 0x0(a0)                #set CTRLR0: EEPROM mode
        li      t0, 0x0                    #to read 1 bytes
        sw      t0, 0x4(a0)      
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR
            
        jal     dw_ssi_wait_nobusy
        nop

        li      t0, 0x0                    #disable slave1            
        sw      t0, 0x10(a0)      

        #cmd + dummy 3write
        li      t0, RES
        sw      t0, 0x60(a0)               #set read electronic ID command of SPI
        sb      t1, 0x60(a0)               #write dummy data
        sb      t2, 0x60(a0)               #write dummy data
        sb      t3, 0x60(a0)               #write dummy data

        li      t0, 1
        sw      t0, 0x10(a0)               #enable SER

        jal     dw_ssi_wait_nobusy
        nop

        #read ID(1-btye)
        lw      v0, 0x60(a0)               #load ID value
        nop 
        andi    v0, v0, 0xff

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t1, 16(sp)
        lw      t2, 20(sp)
        lw      t3, 24(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         # Return
        nop
        .end spi_read_ect_id  
######################################################################
        .globl  spi_read_mf_id
        .ent    spi_read_mf_id

spi_read_mf_id:
        # a0: SSI_BASE
        # a1: formate (1: device->manufacturer, 0: manufacturer->device)
        #     2-byte
        # v0: return ID
        # t0, t1, t2: using 
        
        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t1, 16(sp)
        sw      t2, 20(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x73c7            
        sw      t0, 0x0(a0)                #set CTRLR0: EEPROM mode 
        li      t0, 0x2             
        sw      t0, 0x4(a0)                #to read 3 bytes 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR
            
        jal     dw_ssi_wait_nobusy
        nop

        sw      zero, 0x10(a0)             #disable SER 

        #cmd + dummy 2write +addr
        li      t0, REMS                    
        sw      t0, 0x60(a0)               #set read electronic manuf
        sb      t1, 0x60(a0)               #write dummy data
        sb      t2, 0x60(a0)               #write dummy data               
        sw      a1, 0x60(a0)               #set format                     
  
        li      t0, 0x1           
        sw      t0, 0x10(a0)               #enable SER

        jal     dw_ssi_wait_nobusy
        nop

        #read ID(2-byte)
        lw      v0, 0x60(a0)               #read ID(0x--xx)
        nop
        andi    v0, v0, 0xff
        sll     v0, v0, 0x8
         
        lw      t0, 0x60(a0)               #read ID(0x----)
        nop
        andi    t0, t0, 0xff
        or      v0, v0, t0

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t1, 16(sp)
        lw      t2, 20(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         # Return
        nop
        .end spi_read_mf_id   
######################################################################
        .globl  spi_enter_dp
        .ent    spi_enter_dp

spi_enter_dp:
        # a0: SSI_BASE
        # t0: using 

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only 
        li      t0, 0x1              
        sw      t0, 0x10(a0)               #enable SER       
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR

        li      t0, DP
        sw      t0, 0x60(a0)               #set deep power command of SPI

        jal     dw_ssi_wait_nobusy
        nop

        lw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_enter_dp   
######################################################################
        .globl  spi_release_dp
        .ent    spi_release_dp

spi_release_dp:
        # a0: SSI_BASE
        # t0: using 

        addiu	sp,sp,-48                   
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1              
        sw      t0, 0x10(a0)               #enable SER       
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR

        li      t0, RES
        sw      t0, 0x60(a0)               #set release deep power command of SPI
    
        jal     dw_ssi_wait_nobusy
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_release_dp   
######################################################################
        .globl  spi_write_byte
        .ent    spi_write_byte

spi_write_byte:
        #a0: SSI_BASE
        #a1: addr (3-byte)
        #a2: data (1-byte)
        #t0, t2, t3, t4: using 

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t2, 16(sp)
        sw      t3, 20(sp)
        sw      t4, 24(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSI
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1                        
        sw      t0, 0x10(a0)               #enable SER 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSI

        #issue WREN
        li      t0, WREN 
        sw      t0, 0x60(a0)               #set write command of SPI
    
        jal     dw_ssi_wait_nobusy
        nop

        sw      zero, 0x10(a0)             #disable SER                

        #issue WR
        li      t0, PP                    
        andi    t2, a1, 0xff              #addr (xx_xx--)   
        srl     a1, a1, 8                  
        andi    t3, a1, 0xff              #addr (xx_--xx) >>8
        srl     a1, a1, 8
        andi    t4, a1, 0xff              #addr (--_xxxx) >>16

        andi    a2, a2, 0xff              #data (xx_xx--) 

        #cmd
        sw      t0, 0x60(a0)
        #addr
        sw      t4, 0x60(a0)
        sw      t3, 0x60(a0)
        sw      t2, 0x60(a0)
        #data
        sw      a2, 0x60(a0)

        li      t0, 0x1                    #enable SER            
        sw      t0, 0x10(a0)      
        
        jal     dw_ssi_wait_nobusy
        nop
        jal     spi_wait_busy
        nop

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t2, 16(sp)
        lw      t3, 20(sp)
        lw      t4, 24(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_write_byte   
######################################################################
        .globl  spi_read_byte
        .ent    spi_read_byte

spi_read_byte: 
        #a0: SSI_BASE
        #a1: addr (3-byte) 
        #v0: return data (1-byte)
        #t0, t2, t3, t4: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t2, 16(sp)
        sw      t3, 20(sp)
        sw      t4, 24(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x73c7
        sw      t0, 0x0(a0)                #set CTRLR: transmit only
        li      t0, 0x0            
        sw      t0, 0x4(a0)                #set read 1 of data frames 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR

        jal     dw_ssi_wait_nobusy
        nop

        #issue READ
        li      t0, READ 
    
        #issue WR
        andi    t2, a1,  0xff              #addr (xx_xx--)
        srl     a1, a1, 8
        andi    t3, a1,  0xff              #addr (xx_--xx) >>8
        srl     a1, a1, 8
        andi    t4, a1,  0xff              #addr (--_xxxx) >>16

        sw      zero, 0x10(a0)             #disable SER 

        #cmd(READ) +addr
        sw      t0, 0x60(a0)               #set read data command of SPI
        sw      t4, 0x60(a0)               #set read addr(--_xxxx) >>16
        sw      t3, 0x60(a0)               #set read addr(xx_--xx) >>8
        sw      t2, 0x60(a0)               #set read addr(xx_xx--)
      
        li      t0, 0x1                  
        sw      t0, 0x10(a0)               #enable SER 

        jal     dw_ssi_wait_nobusy
        nop

        #read data
        lw      s0, 0x60(a0)               #read data 1-byte
 
        or      v0, zero, s0

        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t2, 16(sp)
        lw      t3, 20(sp)
        lw      t4, 24(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                        #Return
        nop
        .end spi_read_byte   
#####################################################################
        .globl  spi_fastread_byte
        .ent    spi_fastread_byte

spi_fastread_byte:
        #a0: SSI_BASE
        #a1: addr (3-byte) 
        #v0: return data (1-byte)
        #t0, t1, t2, t3, t4: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 12(sp)
        sw      t1, 16(sp)
        sw      t2, 20(sp)
        sw      t3, 24(sp)
        sw      t4, 28(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x73c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x0            
        sw      t0, 0x4(a0)                #set read 1 of data frames 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR
        
        sw      zero, 0x10(a0)             #disable SER 
    
        #issue WR
        andi    t2, a1, 0xff               #addr (xx_xx--) 
        srl     a1, a1, 8
        andi    t3, a1, 0xff               #addr (xx_--xx) >>8
        srl     a1, a1, 8
        andi    t4, a1, 0xff               #addr (--_xxxx) >>16
byte_raddr:   
        #cmd(fread) + addr + dummy sw
        li      t0, FAST_READ
        sw      t0, 0x60(a0)               #set fast read command of SPI
        sw      t4, 0x60(a0)               #set addr (--_xxxx) >>16
        sw      t3, 0x60(a0)               #set addr (xx_--xx) >>8 
        sw      t2, 0x60(a0)               #set addr (xx_xx--) 
        sw      t1, 0x60(a0)               #set dummy data

        li      t0, 0x1                  
        sw      t0, 0x10(a0)               #enable SER 

        jal     dw_ssi_wait_nobusy
        nop
        
        #jal     spi_wait_busy
        #nop

 
        #read data
        lw      s0, 0x60(a0)               #load data (1-byte)
        jal     dw_ssi_wait_nobusy
        nop

        or      v0, zero, s0               #return value
       
        lw      ra, 8(sp)
        lw      t0, 12(sp)
        lw      t1, 16(sp)
        lw      t2, 20(sp)
        lw      t3, 24(sp)
        lw      t4, 28(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_fastread_byte   
#####################################################################      
        .globl  spi_write_word
        .ent    spi_write_word

spi_write_word:
        #a0: SSI_BASE
        #a1: addr (3-byte) 
        #a2: data (4-byte)
        #t0, t1, t2, t3, t4, t5: using

        addiu	sp,sp,-48
        sw      ra, 16(sp)
        sw      t0, 20(sp)
        sw      t1, 24(sp)
        sw      t2, 28(sp)
        sw      t3, 32(sp)
        sw      t4, 34(sp)
        sw      t5, 40(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1                 
        sw      t0, 0x10(a0)               #enable SER 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR


word_waddr:   
        li      t0, WREN 
        sw      t0, 0x60(a0)               #enable write of SPI
    
        jal     dw_ssi_wait_nobusy
        nop

        sw      zero, 0x10(a0)             #disable SER 

        andi    t2, a1, 0xff               #addr (xx_xx--)
        srl     t5, a1, 8
        andi    t3, t5, 0xff               #addr (xx_--xx) >>8
        srl     t5, a1, 8
        andi    t4, t5, 0xff               #addr (--_xxxx) >>16

        #cmd: PP
        li      t1, PP
        sw      t1, 0x60(a0)               #set write data command of SPI, WEL is disable after write completly.
        #addr
        sw      t4, 0x60(a0)               #set  addr (--_xxxx) >>16
        sw      t3, 0x60(a0)               #set  addr (--_xxxx) >>8 
        sw      t2, 0x60(a0)               #set  addr (--_xxxx)     

        #byte data:
        andi    t5, a2, 0xff               #data (xxxx_xx--) 
        sw      t5, 0x60(a0)               #wirte data(1-byte)
        
        srl     a2, a2, 8                  #data (xxxx_--) 
        andi    t5, a2, 0xff               #data (xxxx_--) 
        sw      t5, 0x60(a0)               #wirte data(2-byte)
        
        srl     a2, a2, 8                  #data (xx--) 
        andi    t5, a2, 0xff               #data (xx--) 
        sw      t5, 0x60(a0)               #wirte data(3-byte)
       
        srl     a2, a2, 8                  #data (--) 
        andi    t5, a2, 0xff               #data (--) 
        sw      t5, 0x60(a0)               #wirte data(4-byte)

        li      t0, 0x1                  
        sw      t0, 0x10(a0)               #enable SER 
       
        jal     dw_ssi_wait_nobusy
        nop
        
        jal     spi_wait_busy
        nop

        lw      ra, 16(sp)
        lw      t0, 20(sp)
        lw      t1, 24(sp)
        lw      t2, 28(sp)
        lw      t3, 32(sp)
        lw      t4, 34(sp)
        lw      t5, 40(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48

        jr      ra                         #Return
        nop
        .end spi_write_word   
######################################################################
        .globl  spi_read_word
        .ent    spi_read_word

spi_read_word:
        #a0: SSI_BASE
        #a1: addr 
        #v0: return data
        #s0,t0, t1, t2, t3, t4: using

        addiu	sp,sp,-48
        sw      ra,  8(sp)
        sw      s0,  16(sp)
        sw      t0, 20(sp)
        sw      t1, 24(sp)
        sw      t2, 28(sp)
        sw      t3, 32(sp)
        sw      t4, 34(sp)
        sw      t5, 40(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)
        
        #to command issue mode
        sw      zero, 0x8(a0)              #disabe SSIENR
        li      t0, 0x73c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x3            
        sw      t0, 0x4(a0)                #set read 4 of data frames 
        li      t0, 0x1
        sw      t0, 0x8(a0)

word_raddr:   
        sw      zero, 0x10(a0)             #disable SER 

        andi    t2, a1, 0xff               #addr (xx_xx--)
        srl     a1, a1, 8
        andi    t3, a1, 0xff               #addr (xx_--xx) >>8
        srl     a1, a1, 8
        andi    t4, a1, 0xff               #addr (--_xxxx) >>16

        #cmd(READ) +addr
        li      t1, READ 
        sw      t1, 0x60(a0)
        sw      t4, 0x60(a0)
        sw      t3, 0x60(a0)
        sw      t2, 0x60(a0)

        li      t0, 0x1                  
        sw      t0, 0x10(a0)               #enable SER 

        jal     dw_ssi_wait_nobusy
        nop

        #read data
        lw      s0, 0x60(a0)               #load data (1-byte)
        jal     dw_ssi_wait_nobusy
        nop

        lw      t4, 0x60(a0)               #load data (2-byte)
        sll     t4, t4, 8
        or      s0, t4, s0
        jal     dw_ssi_wait_nobusy
        nop
      
        lw      t4, 0x60(a0)               #load data (3-byte)
        sll     t4, t4, 16
        or      s0, t4, s0
        jal     dw_ssi_wait_nobusy
        nop
 
        lw      t4, 0x60(a0)               #load data (4-byte)
        sll     t4, t4, 24
        or      s0, t4, s0
        jal     dw_ssi_wait_nobusy
        nop
 
        or      v0, zero, s0 
        
        lw      s0, 16(sp)
        lw      ra, 8(sp)
        lw      t0, 20(sp)
        lw      t1, 24(sp)
        lw      t2, 28(sp)
        lw      t3, 32(sp)
        lw      t4, 34(sp)
        lw      t5, 40(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48

        jr      ra                         #Return
        nop
        .end spi_read_word   
#####################################################################
        .globl  spi_fastread_word
        .ent    spi_fastread_word

spi_fastread_word:
        #a0: SSI_BASE
        #a1: addr (3-byte) 
        #v0: return data (1-byte)
        #t0, t1, t2, t3, t4: using

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 20(sp)
        sw      t1, 24(sp)
        sw      t2, 28(sp)
        sw      t3, 32(sp)
        sw      t4, 34(sp)
        sw      t5, 40(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSIENR
        li      t0, 0x73c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x3            
        sw      t0, 0x4(a0)                #set read 3 of data frames 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSIENR
        
        sw      zero, 0x10(a0)             #disable SER 

    
        #issue WR
        andi    t2, a1, 0xff               #addr (xx_xx--) 
        srl     a1, a1, 8
        andi    t3, a1, 0xff               #addr (xx_--xx) >>8
        srl     a1, a1, 8
        andi    t4, a1, 0xff               #addr (--_xxxx) >>16
word_fraddr:   
        #cmd(fread) + addr + dummy sw
        li      t0, FAST_READ
        sw      t0, 0x60(a0)               #set fast read command of SPI
        sw      t4, 0x60(a0)               #set addr (--_xxxx) >>16
        sw      t3, 0x60(a0)               #set addr (xx_--xx) >>8 
        sw      t2, 0x60(a0)               #set addr (xx_xx--) 
        sw      t1, 0x60(a0)               #set dummy data

        li      t0, 0x1                  
        sw      t0, 0x10(a0)               #enable SER 

        jal     dw_ssi_wait_nobusy
        nop
        
 
        #read data
        lw      s0, 0x60(a0)               #load data (1-byte)
        jal     dw_ssi_wait_nobusy
        nop

        lw      t4, 0x60(a0)               #load data (2-byte)
        sll     t4, t4, 8
        or      s0, t4, s0
        jal     dw_ssi_wait_nobusy
        nop
      
        lw      t4, 0x60(a0)               #load data (3-byte)
        sll     t4, t4, 16
        or      s0, t4, s0
        jal     dw_ssi_wait_nobusy
        nop
 
        lw      t4, 0x60(a0)               #load data (4-byte)
        sll     t4, t4, 24
        or      s0, t4, s0
        jal     dw_ssi_wait_nobusy
        nop
 
        or      v0, zero, s0               #return value
       
        lw      ra, 8(sp)
        lw      t0, 20(sp)
        lw      t1, 24(sp)
        lw      t2, 28(sp)
        lw      t3, 32(sp)
        lw      t4, 36(sp)
        lw      t5, 40(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_fastread_word   
######################################################################
        .globl  dw_ssi_wait_nobusy
        .ent    dw_ssi_wait_nobusy
        #v0,t6, t7 : using 
dw_ssi_wait_nobusy:
        li      t7, SSI_BASE
__checkstat:
        lw      t6, SSI_SR(t7)
        nop
        andi	v0,t6,0x20
        beqz	v0,busy_wait 
        nop
        j	ret_wait
        nop        
busy_wait:
        andi	v0,t6,0x1
        bnez	v0,__checkstat
        nop
        andi	v0,t6,0x4
        beqz	v0,__checkstat
        nop
ret_wait:        
        jr      ra      # Return
        nop
        .end dw_ssi_wait_nobusy   

######################################################################
        .globl  spi_write_bytes
        .ent    spi_write_bytes
spi_write_bytes:
        #a0: SSI_BASE
        #a1: addr (3-byte)
        #a2: data pointer (4-byte)
        #a3: count
        #t0, t2, t3, t4,t5,t6,t7: using 

        addiu	sp,sp,-48
        sw      ra, 8(sp)
        sw      t0, 20(sp)
        sw      t1, 24(sp)
        sw      t2, 28(sp)
        sw      t3, 32(sp)
        sw      t4, 36(sp)
        sw      t5, 40(sp)
        sw      t6, 44(sp)
        sw      t7, 48(sp)

spi_write_bytes_loop:
        #to command issue mode
        sw      zero, 0x8(a0)              #disable SSI
        li      t0, 0x71c7
        sw      t0, 0x0(a0)                #set CTRLR0: transmit only
        li      t0, 0x1                        
        sw      t0, 0x10(a0)               #enable SER 
        li      t0, 0x1
        sw      t0, 0x8(a0)                #enable SSI

        #issue WREN
        li      t0, WREN 
        sw      t0, 0x60(a0)               #set write command of SPI
    
        jal     dw_ssi_wait_nobusy
        nop

        sw      zero, 0x10(a0)             #disable SER                

        #issue WR
        li      t0, PP   
        move    t6,a1                 
        andi    t2, t6, 0xff              #addr (xx_xx--)   
        srl     t6, t6, 8                  
        andi    t3, t6, 0xff              #addr (xx_--xx) >>8
        srl     t6, t6, 8
        andi    t4, t6, 0xff              #addr (--_xxxx) >>16
        
        lb      t5, 0(a2)

        #cmd
        sw      t0, 0x60(a0)

        andi    t5, t5, 0xff              #data (xx_xx--) 

        #addr
        sw      t4, 0x60(a0)
        sw      t3, 0x60(a0)
        sw      t2, 0x60(a0)
        #data
        sw      t5, 0x60(a0)

        li      t0, 0x1                    #enable SER            
        sw      t0, 0x10(a0)      
        
        jal     dw_ssi_wait_nobusy
        nop
        jal     spi_wait_busy
        nop
        
        addi    a3,-1   
        addi    a1,1
        bnez    a3,spi_write_bytes_loop
        addi    a2,1
        //.ent spi_write_bytes_loop
        lw      ra, 8(sp)
        lw      t0, 20(sp)
        lw      t1, 24(sp)
        lw      t2, 28(sp)
        lw      t3, 32(sp)
        lw      t4, 36(sp)
        lw      t5, 40(sp)
        lw      t6, 44(sp)
        lw      t7, 48(sp)
        addiu	sp,sp,48
        jr      ra                         #Return
        nop
        .end spi_write_bytes

######################################################################
        .globl  spi_init
        .ent    spi_init
        #spi flash initial
        #s8 using
spi_init:
        addiu	sp,sp,-32
        sw	ra,28(sp)
        sw	s8,24(sp)
        move	s8,sp
        sw	a0,32(s8)
        lw	v0,32(s8)
        nop
        sw	v0,16(s8)
//        lw	a0,32(s8)
//        jal	spi_dis_write
//        nop
        lw	a0,32(s8)
        move	a1,zero
        jal	spi_set_status
        nop
        move	sp,s8
        lw	ra,28(sp)
        lw	s8,24(sp)
        addiu	sp,sp,32
        jr	ra
        nop
   .end spi_init   

######################################################################
        .globl  dw_ssi_disable
        .ent    dw_ssi_disable
        #disable ssi 
        #s8 ,using
dw_ssi_disable:
        addiu	sp,sp,-16
        sw	s8,8(sp)
        move	s8,sp
        sw	a0,16(s8)
        lw	v0,16(s8)
        nop
        sw	v0,0(s8)
        lw	v0,0(s8)
        nop
        sw	zero,8(v0)
        move	sp,s8
        lw	s8,8(sp)
        addiu	sp,sp,16
        jr	ra
        nop
   .end dw_ssi_disable   

######################################################################
        .globl  dw_ssi_setBaudr
        .ent    dw_ssi_setBaudr
        #s8 , using
dw_ssi_setBaudr:
        addiu	sp,sp,-32
        sw	ra,28(sp)
        sw	s8,24(sp)
        move	s8,sp
        sw	a0,32(s8)
        sw	a1,36(s8)
        lw	v0,32(s8)
        nop
        sw	v0,16(s8)
        lw	a0,32(s8)
        jal	dw_ssi_disable
        nop
        lw	v1,36(s8)
        lui	v0,0xffff
        and	v0,v1,v0
        beqz	v0,dw_ssi_setBaudr_flag1
        nop
        li	v0,44
        sw	v0,20(s8)
        j	dw_ssi_setBaudr_flag2
        nop
dw_ssi_setBaudr_flag1:
        lw	v1,16(s8)
        lw	v0,36(s8)
        nop
        sw	v0,20(v1)
        sw	zero,20(s8)
dw_ssi_setBaudr_flag2:
        lw	v0,20(s8)
        move	sp,s8
        lw	ra,28(sp)
        lw	s8,24(sp)
        addiu	sp,sp,32
        jr	ra
        nop
   .end dw_ssi_setBaudr   

######################################################################
      
