OUTPUT_FORMAT("elf32-bigmips","elf32-bigmips","elf32-littlemips")
OUTPUT_ARCH(mips:5181)
ENTRY(test_entry)
MEMORY
{
	ram    : ORIGIN = 0x80000000, LENGTH = 0x20000
	rom    : ORIGIN = 0xbfc00000, LENGTH = 0xf0000
}
SECTIONS
{
  .boot 0x80000000        :  	{ *.*(.boot) } > ram
  .rlx_gdb_io_entry 0x80000090 : AT(0x80000090) {*.*(.rlx_gdb_io_entry)} > ram
  .text         : 	{ *.*(.text) } > ram
  .data         : 	{ *.*(.data) } > ram 
  .rodata       : 	{ *.*(.rodata) } > ram  
  .sdata       : 	{ *.*(.sdata) } > ram  
  .bss          : 	{ *.*(.bss) }  > ram 
  .sbss          : 	{ *.*(.sbss) }  > ram 
  .scommon       : 	{ *.*(.scommon) } > ram  
  .init         : 	{ *.*(.init) }  > ram 
  .fini       : 	{ *.*(.fini) } > ram  
  .ctors        : 	{ *.*(.ctors) } > ram
  .dtors        : 	{ *.*(.dtors) } > ram
  .jcr             : {  *.*(.jcr) } > ram
  .data.rel.ro : { *(.data.rel.ro.local) *(.data.rel.ro*) } > ram
  .got            : { *(.got.plt) *(.got) } > ram
  .eh_frame    : {*.*(.eh_frame) } > ram
  .text1         : 	{ *.*(.text1) } > ram
  .flash         : 	{ *.*(.flash) } > ram
  
  /* _sp = ALIGN (0x8); . = ALIGN(0x10000); _end = .; PROVIDE (end = .); */
  __heap1 = ALIGN (0x16); . = ALIGN(0x10000); _end = .; PROVIDE (end = .);
  /* Stabs debugging sections.  */
  .stab          0 : { *(.stab) }
  .stabstr       0 : { *(.stabstr) }
  .stab.excl     0 : { *(.stab.excl) }
  .stab.exclstr  0 : { *(.stab.exclstr) }
  .stab.index    0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment       0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }
  .gptab.sdata : { *(.gptab.data) *(.gptab.sdata) }
  .gptab.sbss : { *(.gptab.bss) *(.gptab.sbss) }
  /DISCARD/ : { *(.note.GNU-stack) }
}
