/*********************************************************************
 *
 * Copyright 2009-, Realtek Inc.
 * ALL RIGHTS RESERVED
 *
 *********************************************************************
 *
 * Purpose: To test flash commands. 
 *
 * Support flash type:
 * Macronix 
 * SST   
 *
 * // flash note:
 * //by yuefeng.chen 
 * date : 2009 - 02 - 07 
 *********************************************************************/

#include "rlx_spi_public.h"
#include "DW_common_bitops.h"
#include "rlx_library.h"

// Setting Device manufacturer
#define Macronix
#define SSI_BASE   0xBFB09000
#define FLASH_BASE 0xbd000000
//#define FLASH_SIZE 0x00100000
#define FLASH_SIZE 0x00000100

int errno;
extern unsigned int g_rlx_gdb_param_addr;
/*
void spi_init(struct dw_device * dev)
{
  struct dw_ssi_portmap *ssi_map;
  int info;
  ssi_map = dev;

  //using to init write signal
  spi_dis_write(dev); 

  //using to init sec_prot signal for Program data
  spi_set_status(dev, 0x0); //default value: must before write data

}
void dw_ssi_disable(struct dw_device *dev)
{
   struct dw_ssi_portmap *ssi_map;
   int info;

   ssi_map = dev; 
   ssi_map-> ssienr =0;   
   //printf("SSI_disable.\n"); 
}

int dw_ssi_setBaudr(struct dw_device *dev, unsigned int  baudrate)
{
   struct dw_ssi_portmap *ssi_map;

   ssi_map= dev;

   dw_ssi_disable(dev);  

   if ((baudrate & 0xffff0000))
     return DW_ECHRNG;
   else 
   {
     ssi_map->baudr = baudrate;
     //printf("SSI Baud rate setting= %d \n", ((SYS_FRQ_MHz*1000000)/ ssi_map->baudr));
     return 0; 
   }

}

void dw_ssi_wait_nobusy(struct dw_device *dev)
{
   struct dw_ssi_portmap *ssi_map;

   ssi_map= dev;

   while (1)
   {
     if (DW_BIT_GET_UNSHIFTED(ssi_map->sr, bfoSSI_SR_TXE))
     {
       //printf("SSI: transfer error. \n");
       break;
     }
     else 
     {
       //if ( (!DW_BIT_GET_UNSHIFTED(ssi_map->sr, bfoSSI_SR_BUSY)))      // not busy 
       if ( (!DW_BIT_GET_UNSHIFTED(ssi_map->sr, bfoSSI_SR_BUSY))&&    // not busy 
              DW_BIT_GET_UNSHIFTED(ssi_map->sr, bfoSSI_SR_TFE))     // Trans_FIFO is empty
       {
         break;
       }
     }
   }
}
*/
//#define BUF_SIZE 0x19000
#define BUF_SIZE 0x2800

//set the buffer size ,this size is much related with the program speed of flash
static  char buf_rd[BUF_SIZE];

int main(void)
{
  struct dw_device *dev;
  struct dw_ssi_portmap *ssi_map;
  unsigned short int info;
  unsigned char *addr;
  unsigned short int spi_ID;
  unsigned short int error=0;
  int i,j;
  int fd;
  char buff[] = "This is a test string...";
  struct stat stat1;
  int ret;
  time_t time_buffer;
  char  file_name[128];
  int loc;
  //unsigned int *addr;

  rlx_gdb_set_param_addr(0x80000090);
  dev = SSI_BASE;
  ssi_map = dev;

  spi_init(dev);//serial flash initialization

  dw_ssi_setBaudr(dev, 2);//set baudrate of flash
  
  spi_set_status(dev, 0); //default value

  spi_chip_erase(dev); //erase chip
  
  spi_release_dp(dev); //avoid flash sleep

  i=0;
  rlx_gdb_printf("Please input your file(local) to be burned into SPI flash:");
  
  //get file name from GDB console
  do{
     rlx_gdb_read(0,&file_name[i],1);
     i ++;
  }while(file_name[i-1] != '\n');
  file_name[i-1] = '\0';
  
  //open local file 
  fd = rlx_gdb_open(file_name, O_RDONLY , S_IRUSR);
  if (fd < 0)
    {
        rlx_gdb_printf("ERROR: unable to open the %s,ERROR_Num = %d\n",file_name ,errno);
        return -1;
    }
  
  loc = 0;
  j = SSI_BASE;
  addr = FLASH_BASE;
  //read file and write to flash
  //the BUF_SIZE will greatly influence the program speed 
  do
  {
     i = rlx_gdb_read(fd, buf_rd,  BUF_SIZE);
     if(i > 0)
     {
       spi_write_bytes(SSI_BASE, loc , buf_rd, i);
       rlx_gdb_printf("Write %x bytes ,now address =  %d\n",i,loc+i);
       loc += i;
       //check the data wrote to flash,if you would like to check ,please remove the comment 
       for(j=0;j< i;j++)
       {
        if(buf_rd[j] != (*addr))
         rlx_gdb_printf("Fail : Data read isn't equal to data write to file at offset %d .",j);
         addr ++;
       }
    }
  }while(i > 0);
    
  rlx_gdb_printf("Flash program successful !");
  while(1){};
  return 1;
}


  

