/***************************************************************************
    filename:            : rlx_ep_cpu.h  
    description          : RLX EJTAG PROBE firmware register define
    created              : Dec 16 2006
	version                : 1.0
    copyright            : (C) 2006 by Realsil Co.
    email                : yf_chen@realsil.com.cn
***************************************************************************/
/*===========================================================================

                        EDIT HISTORY FOR MODULE

when        who              what, where, why
--------    -----            ----------------------------------------------------------
===========================================================================*/
/*****************************************************************
    include files
*****************************************************************/


#define K0BASE 		  0x80000000
#define K0SIZE 		  0x20000000
#define K1BASE 		  0xa0000000
#define K1SIZE 		  0x20000000
#define K2BASE 		  0xc0000000
#define	IS_K0SEG(x)	((unsigned)(x)>=K0BASE && (unsigned)(x)<K1BASE)
#define	IS_K1SEG(x)	((unsigned)(x)>=K1BASE && (unsigned)(x)<K2BASE)
#define GEN_VECT 	  0x80000080
#define UTLB_VECT 	0x80000000

//#ifdef LANGUAGE_ASSEMBLY

#define jr j
#define jalr jal

/* aliases for general registers */
#define zero	$0
#define	AT		$1		/* assembler temporaries */
#define	v0		$2		/* value holders */
#define	v1		$3
#define	a0		$4		/* arguments */
#define	a1		$5
#define	a2		$6
#define	a3		$7
#define	t0		$8		/* temporaries */
#define	t1		$9
#define	t2		$10
#define	t3		$11
#define	t4		$12
#define	t5		$13
#define	t6		$14
#define	t7		$15
#define	s0		$16		/* saved registers */
#define	s1		$17
#define	s2		$18
#define	s3		$19
#define	s4		$20
#define	s5		$21
#define	s6		$22
#define	s7		$23
#define	t8		$24		/* temporaries */
#define	t9		$25
#define	k0		$26		/* kernel registers */
#define	k1		$27
#define	gp		$28		/* global pointer */
#define	sp		$29		/* stack pointer */
#define	s8		$30		/* saved register */
#define	fp		$30		/* frame pointer (old usage) */
#define	ra		$31		/* return address */

/* System Control Coprocessor (CP0) registers */
#define C0_SR		       $12		/* Processor Status */
#define C0_CAUSE	     $13		/* Exception Cause */
#define C0_EPC		     $14		/* Exception PC */
#define C0_BADADDR	   $8		/* Bad Address */
#define C0_ENTRYLO     $2
#define C0_ENTRYHI     $9
#define C0_DEPC        $17

#define C0_BADVADDR	   $8		/* Bad Virtual Address */
#define C0_PRID		     $15		/* Processor Rev Indentifier */
#define C0_CCTL		     $20 		/* cache control register */
#define C0_DREG        $16
#define C0_DREG_MIPS   $23
#define DESAVE         $31
//DEFINE LEXRA CP0 registers
#define LXCP0_ESTATUS  $0
#define LXCP0_ECAUSE   $1
#define LXCP0_INTVEC   $2
//DEFINE 

/* Status Register */
#define SR_CUMASK	0xf0000000	/* Coprocessor usable bits */
#define	SR_CU3		0x80000000	/* Coprocessor 3 usable */
#define SR_CU2		0x40000000	/* coprocessor 2 usable */
#define SR_CU1		0x20000000	/* Coprocessor 1 usable */
#define SR_CU0		0x10000000	/* Coprocessor 0 usable */
#define SR_BEV		0x00400000	/* Bootstrap Exception Vector */
#define SR_TS		  0x00200000	/* TLB shutdown */
#define SR_PE		  0x00100000	/* Parity Error */
#define SR_CM		  0x00080000	/* Cache Miss */
#define SR_PZ		  0x00040000	/* Parity Zero */
#define SR_SWC		0x00020000	/* Swap Caches */
#define SR_ISC		0x00010000	/* Isolate Cache */

#define SR_IMASK	0x0000ff00	/* Interrupt Mask */
#define SR_IMASK8	0x00000000	/* Interrupt Mask level=8 */
#define SR_IMASK7	0x00008000	/* Interrupt Mask level=7 */
#define SR_IMASK6	0x0000c000	/* Interrupt Mask level=6 */
#define SR_IMASK5	0x0000e000	/* Interrupt Mask level=5 */
#define SR_IMASK4	0x0000f000	/* Interrupt Mask level=4 */
#define SR_IMASK3	0x0000f800	/* Interrupt Mask level=3 */
#define SR_IMASK2	0x0000fc00	/* Interrupt Mask level=2 */
#define SR_IMASK1	0x0000fe00	/* Interrupt Mask level=1 */
#define SR_IMASK0	0x0000ff00	/* Interrupt Mask level=0 */

#define SR_IBIT8	0x00008000	/*  (Intr5) */
#define SR_IBIT7	0x00004000	/*  (Intr4) */
#define SR_IBIT6	0x00002000	/*  (Intr3) */
#define SR_IBIT5	0x00001000	/*  (Intr2) */
#define SR_IBIT4	0x00000800	/*  (Intr1) */
#define SR_IBIT3	0x00000400	/*  (Intr0) */
#define SR_IBIT2	0x00000200	/*  (Software Interrupt 1) */
#define SR_IBIT1	0x00000100	/*  (Software Interrupt 0) */

#define SR_KUO		0x00000020	/* Kernel/User mode, old */
#define SR_IEO		0x00000010	/* Interrupt Enable, old */
#define SR_KUP		0x00000008	/* Kernel/User mode, previous */
#define SR_IEP		0x00000004	/* Interrupt Enable, previous */
#define SR_KUC		0x00000002	/* Kernel/User mode, current */
#define SR_IEC		0x00000001	/* Interrupt Enable, current */

/* Cause Register */
#define CAUSE_BD		    0x80000000	/* Branch Delay */
#define CAUSE_CEMASK		0x30000000	/* Coprocessor Error */
#define CAUSE_CESHIFT		28		/* Right justify CE  */
#define CAUSE_IPMASK		0x0000ff00	/* Interrupt Pending */
#define CAUSE_IPSHIFT		8		/* Right justify IP  */
#define CAUSE_IP8		    0x00008000	/*  (Intr5) */
#define CAUSE_IP7		    0x00004000	/*  (Intr4) */
#define CAUSE_IP6		    0x00002000	/*  (Intr3) */
#define CAUSE_IP5		    0x00001000	/*  (Intr2) */
#define CAUSE_IP4		    0x00000800	/*  (Intr1) */
#define CAUSE_IP3		    0x00000400	/*  (Intr0) */
#define CAUSE_SW2		    0x00000200	/*  (Software Int 1) */
#define CAUSE_SW1		    0x00000100	/*  (Software Int 0) */
#define CAUSE_EXCMASK		0x0000003c	/* Exception Code */
#define CAUSE_EXCSHIFT	2		/* Right justify EXC */

/* Exception Code */
#define EXC_INT		(0 << 2)	/* External interrupt */
#define EXC_MOD		(1 << 2)	/* TLB modification */
#define EXC_TLBL	(2 << 2)    	/* TLB miss (Load or Ifetch) */
#define EXC_TLBS	(3 << 2)	/* TLB miss (Save) */
#define EXC_ADEL	(4 << 2)    	/* Addr error (Load or Ifetch) */
#define EXC_ADES	(5 << 2)	/* Address error (Save) */
#define EXC_IBE		(6 << 2)	/* Bus error (Ifetch) */
#define EXC_DBE		(7 << 2)	/* Bus error (data load/store) */
#define EXC_SYS		(8 << 2)	/* System call */
#define EXC_BP		(9 << 2)	/* Break point */
#define EXC_RI		(10 << 2)	/* Reserved instruction */
#define EXC_CPU		(11 << 2)	/* Coprocessor unusable */
#define EXC_OVF		(12 << 2)	/* Arithmetic overflow */

#define		CON_BASE	    0xbd010000	      /* configure BASE 	address */
#define		ROM_SIZE	    0x20000000	      /* 1M FLASH */
#define		RAM_SIZE	    0x00300000	      /* 1M RAM,16bits width */
#define		RAM_CON_BASE	0xbd011000	      /* RAM,ROM configure address */

#define 	PBDIR		      0x00ff0000	      /* config all I/O as output */
#define 	PBIMR		      0x00000000	      /* mask all interrupt */
#define 	GIMR		      0x00ff0000	      /* I/O interrupt mask */
#define 	GPIOB		      0xffefffff	      /* config GPIOB used by GPIO */
#define		SYSCFG_ADDR	  0xbd010020	      /* system config address */

#define 	UUID_ADDR 	  0xbfc20000	      /* UUID address */
#define		UUID_VAL	    0x11223344	      /* UUID value */
#define		UUID_CRC	    0x11223344            /* UUID CRC check value */
#define   FILE_FLASH_BASE    0xbfc20002 	      /* compressed  or uncompressed file saved base address */
#define		FILE_RAM_BASE      0x80000000	      /* copy destination address in RAM for decompressed file */
#define 	FLASH_ADDR_WRITE 	 0xbfc20000 //UUID base address
#define 	FLASH_ADDR_FILE_WRITE   0xbfc20100 //file stored base address 
#define 	FILE_RUN_ADDRESS	0x80000000 //address for file to run from

#define		UART1_THR	0xbd0100c0	      /* UART1 SEND BUFFER ,1 byte,the lowest byte */
#define		UART1_RBR	0xbd0100c0	      /* UART1 RECEIVE BUFFER ,1 byte,the lowest byte  */
#define		UART1_DLL	0xbd0100c0	      /* UART1 divisor latch LSB */
#define		UART1_IER	0xbd0100c4	      /* UART1 interrupt enable reg */
#define		UART1_DLM	0xbd0100c4	      /* UART1 divisor latch MSB */
#define		UART1_IIR	0xbd0100c8	      /* UART1 interrupt identification reg */
#define		UART1_FCR	0xbd0100c8	      /* UART1 FIFO control reg */
#define		UART1_LCR	0xbd0100cc	      /* UART1 Line control reg */
#define		UART1_MCR	0xbd0100d0	      /* Modem control reg */
#define		UART1_LSR	0xbd0100d4	      /* UART1 Line status reg */
#define		UART1_MSR	0xbd0100d8	      /* Modem status reg */
#define		UART1_SCR	0xbd0100dc	      /* UART1 scratch reg */
// #define true 1
#define TEMPMEM           0x800b0000
#define RAM_ENTRY	        0x80000000
#define APPLI_FILE_ADDR   0xbfc00000
#define FILE_INFO_ADDR    0xbfc00000
#define FLG_FEXTRA	      0x4
#define FLG_FNAME	        0x8
#define FLG_FHCRC	        0x2
#define FLG_FCOMMENT      0x16
/////////////////////////////////////////////
//offset for break in DSU
#define DSU_BA_OFF 0x0000
#define DSU_BC_OFF 0x0004
#define DSU_BM_OFF 0x0008
#define DSU_BV_OFF 0x000C
//DCR,DBS,IBS,PBS offset
#define DSU_DCR_OFF 0x0000
#define DSU_IBS_OFF 0x0004
#define DSU_DBS_OFF 0x0008
#define DSU_PBS_OFF 0x000C
//offset of register buffer
#define REG_BUF_OFF 0x40
#define DSU_BASE  0xff300000
#define DSU_BUF_BASE 0xff200020
#define DSU_BUF_OFF  0x20
//define some const
#define CMD_OK_FLAG  0x5555
#define CMD_ERR_FLAG  0x3333

//define CCTL register mask (DWBInval and IInval)
#define CCTL_DC_MSK 0xfdff
#define CCTL_DC_VAL 0x0200
#define CCTL_IC_MSK 0xfffd
#define CCTL_IC_VAL 0x0002
#define CCTL_DC_MSK_5280 0xfffe
#define CCTL_DC_VAL_5280 0x0001
#define CCTL_IC_MSK_5280 0xfffd
#define CCTL_IC_VAL_5280 0x0002

#define CCTL_DC_MSK_4180 0xfffe
#define CCTL_DC_VAL_4180 0x0001
#define CCTL_IC_MSK_4180 0xfffd
#define CCTL_IC_VAL_4180 0x0002

//define read/write base address offset
//#define RD_BASE_OFF        0x10
#define RD_START_OFF        0x10
#define RD_NUM_OFF          0x14
#define FLASH_BASE_OFF      0x18

#define FLASH_RD_BASE_OFF   0xff206000
//define flash base address buffer offset
#define FLASH_START_ADDR    0xbfc00000
#define FLASH_END_ADDR	    0xbfd00000
#define FLASH_CMD_ADDR1			0x0aaa
#define FLASH_CMD_ADDR2			0x0554
#define FLASH_CMD_ADDR3			0x0555
#define FLASH_CMD_DATA1			0x55
#define FLASH_CMD_DATA2			0xaa
#define FLASH_CMD_DATA3			0xa0
#define FLASH_CMD_DATA4			0x80
#define FLASH_CMD_DATA5			0x10
#define FLASH_CMD_DATA6			0x30
#define FLASH_CMD_DATA7			0x90
#define FLASH_CMD_RESET			0x00f0
#define FLASH_SEC_ERS_PEN   0xb0

#define FLASH_CMD_SDATA1  	0xaa
#define FLASH_CMD_SDATA2	  0x55
#define FLASH_CMD_SDATA3		0x50
#define FLASH_CMD_SDATA4		0x40
#define FLASH_CMD_SDATA5		0x08
#define FLASH_CMD_SDATA6		0x18
#define FLASH_CMD_SDATA7		0x48
#define FLASH_DATA_POLL_MSK 0xffffffff

//cache instruction operator define
#define INDEX_INVALIDATE_I    0x00
#define INDEX_WRITEBACK_INV_D 0x01
#define INDEX_INVALIDATE_SI   0x02
#define INDEX_WRITEBACK_INV_SD  0x03
#define INDEX_LOAD_TAG_I      0x04
#define INDEX_LOAD_TAG_D      0x05
#define INDEX_LOAD_TAG_SI     0x06
#define INDEX_LOAD_TAG_SD     0x07
#define INDEX_STORE_TAG_I     0x08
#define INDEX_STORE_TAG_D     0x09
#define INDEX_STORE_TAG_SI    0x0A
#define INDEX_STORE_TAG_SD    0x0B
#define CREATE_DIRTY_EXC_D    0x0D
#define CREATE_DIRTY_EXC_SD   0x0F

////
#define HIT_INVALIDATE_I      0x10
#define HIT_INVALIDATE_D      0x11
#define HIT_INVALIDATE_SI     0x12
#define HIT_INVALIDATE_SD     0x13
#define FILL_I                0x14
#define HIT_WIRTEBACK_INV_D   0x15

#define HIT_WRITEBACK_INV_SD  0x17
#define HIT_WRITEBACK_I       0x18
#define HIT_WRITEBACK_D       0x19

#define HIT_WRITEBACK_SD      0x1B
#define HIT_SET_VIRTURE_SI    0x1E
#define HIT_SET_VIRTURE_SD    0x1F
