


/****id* ssi.api/ssi.bfws
 * DESCRIPTION
 *  Used in conjunction with bitops.h to access register bitfields.
 *  They are defined as bit offset/mask pairs for each DMA register
 *  bitfield.
 * EXAMPLE
 *  int_status = BIT_GET(INP(portmap->status_int_l),
 *               SSI_STATUSINT_L_DSTTRAN);
 * NOTES
 *  bfo is the offset of the bitfield with respect to LSB;
 *  bfw is the width of the bitfield
 * SEE ALSO
 *  dw_common_bitops.h
 * SOURCE
 */
#define bfoSSI_CTRLR0_CFS             ((uint32_t)   12)
#define bfwSSI_CTRLR0_CFS             ((uint32_t)    3)
#define bfoSSI_CTRLR0_SRL             ((uint32_t)   11)
#define bfwSSI_CTRLR0_SRL             ((uint32_t)    1)
#define bfoSSI_CTRLR0_SLV_OE          ((uint32_t)   10)
#define bfwSSI_CTRLR0_SLV_OE          ((uint32_t)    1)
#define bfoSSI_CTRLR0_TMOD            ((uint32_t)    8)
#define bfwSSI_CTRLR0_TMOD            ((uint32_t)    2)
#define bfoSSI_CTRLR0_SCPOL           ((uint32_t)    7)
#define bfwSSI_CTRLR0_SCPOL           ((uint32_t)    1)
#define bfoSSI_CTRLR0_FRF             ((uint32_t)    4)
#define bfwSSI_CTRLR0_FRF             ((uint32_t)    2)
#define bfoSSI_CTRLR0_DFS             ((uint32_t)    0)
#define bfwSSI_CTRLR0_DFS             ((uint32_t)    4)

#define bfoSSI_CTRLR1_NDF             ((uint32_t)    0)
#define bfwSSI_CTRLR1_NDF             ((uint32_t)   16)

#define bfoSSI_SSIENR_SSI_EN          ((uint32_t)    0)
#define bfwSSI_SSIENR_SSI_EN          ((uint32_t)    1)

#define bfoSSI_MWCR_MHS               ((uint32_t)    2)
#define bfwSSI_MWCR_MHS               ((uint32_t)    1)
#define bfoSSI_MWCR_MDD               ((uint32_t)    1)
#define bfwSSI_MWCR_MDD               ((uint32_t)    1)
#define bfoSSI_MWCR_MWMOD             ((uint32_t)    0)
#define bfwSSI_MWCR_MWMOD             ((uint32_t)    1)

#define bfoSSI_SER                    ((uint32_t)    0)
#define bfwSSI_SER                    ((uint32_t)    4)

#define bfoSSI_BAUDR_SCKDV            ((uint32_t)    0)
#define bfwSSI_BAUDR_SCKDV            ((uint32_t)   16)

#define bfoSSI_TXFTLR_TFT             ((uint32_t)    0)
#define bfwSSI_TXFTLR_TFT             ((uint32_t)    3)

#define bfoSSI_RXFTLR_RFT             ((uint32_t)    0)
#define bfwSSI_RXFTLR_RFT             ((uint32_t)    3)

#define bfoSSI_TXFLR_TXTFL            ((uint32_t)    0)
#define bfwSSI_TXFLR_TXTFL            ((uint32_t)    3)

#define bfoSSI_RXFLR_RXTFL            ((uint32_t)    0)
#define bfwSSI_RXFLR_RXTFL            ((uint32_t)    3)

#define bfoSSI_SR_BUSY                ((uint32_t)    0)
#define bfwSSI_SR_BUSY                ((uint32_t)    1)
#define bfoSSI_SR_TFNF                ((uint32_t)    1)
#define bfwSSI_SR_TFNF                ((uint32_t)    1)
#define bfoSSI_SR_TFE                 ((uint32_t)    2)
#define bfwSSI_SR_TFE                 ((uint32_t)    1)
#define bfoSSI_SR_RFNE                ((uint32_t)    3)
#define bfwSSI_SR_RFNE                ((uint32_t)    1)
#define bfoSSI_SR_RFF                 ((uint32_t)    4)
#define bfwSSI_SR_RFF                 ((uint32_t)    1)
#define bfoSSI_SR_TXE                 ((uint32_t)    5)
#define bfwSSI_SR_TXE                 ((uint32_t)    1)
#define bfoSSI_SR_DCOL                ((uint32_t)    6)
#define bfwSSI_SR_DCOL                ((uint32_t)    1)

#define bfoSSI_IMR_TXEIM              ((uint32_t)     0)
#define bfwSSI_IMR_TXEIM              ((uint32_t)     1)
#define bfoSSI_IMR_TXOIM              ((uint32_t)     1)
#define bfwSSI_IMR_TXOIM              ((uint32_t)     1)
#define bfoSSI_IMR_RXUIM              ((uint32_t)     2)
#define bfwSSI_IMR_RXUIM              ((uint32_t)     1)
#define bfoSSI_IMR_RXOIM              ((uint32_t)     3)
#define bfwSSI_IMR_RXOIM              ((uint32_t)     1)
#define bfoSSI_IMR_RXFIM              ((uint32_t)     4)
#define bfwSSI_IMR_RXFIM              ((uint32_t)     1)
#define bfoSSI_IMR_MSTIM              ((uint32_t)     5)
#define bfwSSI_IMR_MSTIM              ((uint32_t)     1)

#define bfoSSI_ISR_TXEIS              ((uint32_t)     0)
#define bfwSSI_ISR_TXEIS              ((uint32_t)     1)
#define bfoSSI_ISR_TXOIS              ((uint32_t)     1)
#define bfwSSI_ISR_TXOIS              ((uint32_t)     1)
#define bfoSSI_ISR_RXUIS              ((uint32_t)     2)
#define bfwSSI_ISR_RXUIS              ((uint32_t)     1)
#define bfoSSI_ISR_RXOIS              ((uint32_t)     3)
#define bfwSSI_ISR_RXOIS              ((uint32_t)     1)
#define bfoSSI_ISR_RXFIS              ((uint32_t)     4)
#define bfwSSI_ISR_RXFIS              ((uint32_t)     1)
#define bfoSSI_ISR_MSTIS              ((uint32_t)     5)
#define bfwSSI_ISR_MSTIS              ((uint32_t)     1)

#define bfoSSI_RISR_TXEIR             ((uint32_t)     0)
#define bfwSSI_RISR_TXEIR             ((uint32_t)     1)
#define bfoSSI_RISR_TXOIR             ((uint32_t)     1)
#define bfwSSI_RISR_TXOIR             ((uint32_t)     1)
#define bfoSSI_RISR_RXUIR             ((uint32_t)     2)
#define bfwSSI_RISR_RXUIR             ((uint32_t)     1)
#define bfoSSI_RISR_RXOIR             ((uint32_t)     3)
#define bfwSSI_RISR_RXOIR             ((uint32_t)     1)
#define bfoSSI_RISR_RXFIR             ((uint32_t)     4)
#define bfwSSI_RISR_RXFIR             ((uint32_t)     1)
#define bfoSSI_RISR_MSTIR             ((uint32_t)     5)
#define bfwSSI_RISR_MSTIR             ((uint32_t)     1)

#define bfoSSI_TXOICR_TXOICR          ((uint32_t)     0)
#define bfwSSI_TXOICR_TXOICR          ((uint32_t)     1)

#define bfoSSI_RXOICR_RXOICR          ((uint32_t)     0)
#define bfwSSI_RXOICR_RXOICR          ((uint32_t)     1)

#define bfoSSI_RXUICR_RXUICR          ((uint32_t)     0)
#define bfwSSI_RXUICR_RXUICR          ((uint32_t)     1)

#define bfoSSI_MSTICR_MSTICR          ((uint32_t)     0)
#define bfwSSI_MSTICR_MSTICR          ((uint32_t)     1)

#define bfoSSI_ICR_ICR                ((uint32_t)     0)
#define bfwSSI_ICR_ICR                ((uint32_t)     1)

#define bfoSSI_DMACR_RDMAE            ((uint32_t)     0)
#define bfwSSI_DMACR_RDMAE            ((uint32_t)     1)
#define bfoSSI_DMACR_TDMAE            ((uint32_t)     1)
#define bfwSSI_DMACR_TDMAE            ((uint32_t)     1)
                                       
#define bfoSSI_DMATDLR_DMATDL         ((uint32_t)     0)
#define bfwSSI_DMATDLR_DMATDL         ((uint32_t)     3)

#define bfoSSI_DMARDLR_DMARDL         ((uint32_t)     0)
#define bfwSSI_DMARDLR_DMARDL         ((uint32_t)     3)

#define bfoSSI_DR0_dr0                ((uint32_t)     0)
#define bfwSSI_DR0_dr0                ((uint32_t)    16)
#define bfoSSI_DR1_dr1                ((uint32_t)     0)
#define bfwSSI_DR1_dr1                ((uint32_t)    16)
#define bfoSSI_DR2_dr2                ((uint32_t)     0)
#define bfwSSI_DR2_dr2                ((uint32_t)    16)
#define bfoSSI_DR3_dr3                ((uint32_t)     0)
#define bfwSSI_DR3_dr3                ((uint32_t)    16)
#define bfoSSI_DR4_dr4                ((uint32_t)     0)
#define bfwSSI_DR4_dr4                ((uint32_t)    16)
#define bfoSSI_DR5_dr5                ((uint32_t)     0)
#define bfwSSI_DR5_dr5                ((uint32_t)    16)
#define bfoSSI_DR6_dr6                ((uint32_t)     0)
#define bfwSSI_DR6_dr6                ((uint32_t)    16)
#define bfoSSI_DR7_dr7                ((uint32_t)     0)
#define bfwSSI_DR7_dr7                ((uint32_t)    16)
#define bfoSSI_DR8_dr8                ((uint32_t)     0)
#define bfwSSI_DR8_dr8                ((uint32_t)    16)
#define bfoSSI_DR9_dr9                ((uint32_t)     0)
#define bfwSSI_DR9_dr9                ((uint32_t)    16)
#define bfoSSI_DR10_dr10              ((uint32_t)     0)
#define bfwSSI_DR10_dr10              ((uint32_t)    16)
#define bfoSSI_DR11_dr11              ((uint32_t)     0)
#define bfwSSI_DR11_dr11              ((uint32_t)    16)
#define bfoSSI_DR12_dr12              ((uint32_t)     0)
#define bfwSSI_DR12_dr12              ((uint32_t)    16)
#define bfoSSI_DR13_dr13              ((uint32_t)     0)
#define bfwSSI_DR13_dr13              ((uint32_t)    16)
#define bfoSSI_DR14_dr14              ((uint32_t)     0)
#define bfwSSI_DR14_dr14              ((uint32_t)    16)
#define bfoSSI_DR15_dr15              ((uint32_t)     0)
#define bfwSSI_DR15_dr15              ((uint32_t)    16)


struct dw_ssi_portmap {
//typedef uint32_t unsigned int;

  /* Channel registers                                    */
  /* The offset address for each of the channel registers */
  /*  is shown for channel 0. For other channel numbers   */
  /*  use the following equation.                         */
  /*                                                      */

  volatile uint32_t ctrlr0;           /* control for ssi (0x000) */
  volatile uint32_t ctrlr1;           /* control for ssi (0x004) */
  volatile uint32_t ssienr;           /* control for ssi (0x008) */
  volatile uint32_t mwcr;             /* control for ssi (0x00c) */
  volatile uint32_t ser;              /* control for ssi (0x010) */
  volatile uint32_t baudr;            /* control for ssi (0x014) */
  volatile uint32_t txftlr;           /* control for ssi (0x018) */
  volatile uint32_t rxftlr;           /* control for ssi (0x01c) */
  volatile uint32_t txflr;            /* control for ssi (0x020) */
  volatile uint32_t rxflr;            /* control for ssi (0x024) */
  volatile uint32_t sr;               /* control for ssi (0x028) */
  volatile uint32_t imr;              /* control for ssi (0x02c) */
  volatile uint32_t isr;              /* control for ssi (0x030) */
  volatile uint32_t risr;             /* control for ssi (0x034) */
  volatile uint32_t txoicr;           /* control for ssi (0x038) */
  volatile uint32_t rxoicr;           /* control for ssi (0x03c) */
  volatile uint32_t rxuicr;           /* control for ssi (0x040) */
  volatile uint32_t msticr;           /* control for ssi (0x044) */
  volatile uint32_t icr;              /* control for ssi (0x048) */
  volatile uint32_t dmacr;            /* control for ssi (0x04c) */
  volatile uint32_t dmatdlr;          /* control for ssi (0x050) */
  volatile uint32_t dmardlr;          /* control for ssi (0x054) */
  volatile uint32_t idr;              /* control for ssi (0x058) */
  volatile uint32_t ssi_comp_version; /* control for ssi (0x05c) */
  volatile uint32_t dr[16];           /* control for ssi (0x060)~(0x9c) */
};
/*****/

