#ifndef _SPI_FLASH_H_
#define _SPI_FLASH_H_

/* 20090708 JSW:Support SPI List
//MXIC Single-I/O with 50-MHz SPI
MX25L1605D  //2MB
MX25L3205D  //4MB
MX25L6405D  //8MB
MX25L12805D //16MB

//MXIC Single-I/O with 104-MHz SPI
MX25L1635D   //2MB
MX25L3235D   //4MB
 
//Spansion Single-I/O with 50-MHz SPI
S25FL004A  //0.5MB
S25FL008A  //1MB
S25FL016A  //2MB
S25FL032A  //4MB
s25fl064a  //8MB

//Spansion Single-I/O with 104-MHz SPI
S25FL032P  //4MB
S25FL128p  //16MB

 
//SST Single-I/O with 50-MHz SPI
SST25VF040B
SST25VF016B
SST25VF032B
SST25VF040B

*/



//#include <asm/rtl8196.h> //define in boot's MAKEFILE

//Show Debug message and test_program
#define SPI_DBG 0


/*Erase sector= 4KB or 64KB*/
#define Set_SECTOR_ERASE_4KB
//#define Set_SECTOR_ERASE_64KB  



//#define OS_PRINTF printf    


/* 8196 SPI Flash Controller,NOT compliant with 8198 */
#define SFCR         0xB8001200
#define SFCSR        0xB8001204
#define SFDR         0xB8001208

/*
 * Macro Definition
 */
#define SPI_CS(i)           ((i) << 30)   /* 0: CS0 & CS1   1: CS0   2: CS1   3: NONE */
#define SPI_LENGTH(i)       ((i) << 28)   /* 0 ~ 3 */
#define SPI_READY(i)        ((i) << 27)   /* 0: Busy  1: Ready */

#define SPI_CLK_DIV(i)      ((i) << 29)   /* 0: DIV_2  1: DIV_4  2: DIV_6 ... 7: DIV_16 */
#define SPI_RD_ORDER(i)     ((i) << 28)   /* 0: Little-Endian  1: Big-Endian */
#define SPI_WR_ORDER(i)     ((i) << 27)   /* 0: Little-Endian  1: Big-Endian */
#define SPI_RD_MODE(i)      ((i) << 26)   /* 0: Fast-Mode  1: Normal Mode */
#define SPI_SFSIZE(i)       ((i) << 23)   /* 0 ~ 7. 128KB * (i+1) */
#define SPI_TCS(i)          ((i) << 19)   /* 0 ~ 15 */
#define SPI_RD_OPT(i)       ((i) << 18)   /* 0: No-Optimization  1: Optimized for Sequential Access */


/*
 * Structure Declaration
 */
struct spi_flash_type
{
   unsigned char maker_id;
   unsigned char type_id;
   unsigned char capacity_id;
   unsigned char device_size;        // 2 ^ N (bytes)
   int sector_cnt;
};

struct spi_flash_db
{
   unsigned char maker_id;
   unsigned char type_id;
   signed char size_shift;
};


/*
 * Function Prototypes
 */
void spi_pio_init(void);

void spi_read(unsigned int chip, unsigned int address, unsigned int *data_out);
void spi_write(unsigned int chip, unsigned int address, unsigned int data_in);

void spi_erase_chip(unsigned int chip);

void spi_probe(void);
void spi_burn_image(unsigned int chip, unsigned char *image_addr, unsigned int image_size);
void spi_ready(void);



#endif /* _SPI_FLASH_H_ */
