#include "spi_flash.h"
#include "rlx_library.h"
//#include <linux/interrupt.h>
//#include <asm/system.h>
//#include "monitor.h"
//#include "etherboot.h"
//#include "nic.h"
//#include <asm/rtl8196.h>
//#include <asm/mipsregs.h> //wei add
#include "rlx_ep_cpu.h"
#define  Int16 short int 
#define  Int8 unsigned char
#define  FLASH_BASE  0x1200
extern char _bootimg_start, _bootimg_end;
#define mips_io_port_base (0xB8000000) //JSW: for 8196 
#define rtl_inw(offset) (*(volatile unsigned short *)(mips_io_port_base + offset)) 
#define WRITE_MEM32(A,B) (*(volatile unsigned int*)A =(unsigned int) B)

#define LENGTH(i)       SPI_LENGTH(i)
#define CS(i)           SPI_CS(i)
#define RD_ORDER(i)     SPI_RD_ORDER(i)
#define WR_ORDER(i)     SPI_WR_ORDER(i)
#define READY(i)        SPI_READY(i)
#define CLK_DIV(i)      SPI_CLK_DIV(i)
#define RD_MODE(i)      SPI_RD_MODE(i)
#define SFSIZE(i)       SPI_SFSIZE(i)
#define TCS(i)          SPI_TCS(i)
#define RD_OPT(i)       SPI_RD_OPT(i)
#define dprintf printf

unsigned int get_ctimestamp(void);
//void check_spi_clk_div(void);
extern int check_dram_freq_reg(void) ;
//end of SST's SPI
void spi_sector_erase(unsigned int cnt, unsigned int i);
void EWSR(unsigned short cnt);
void WRSR(unsigned short cnt);
void sst_spi_write(unsigned int cnt, unsigned int address, unsigned char data_in);
void halt();
int spi_chip_erase(unsigned int ,unsigned int );

unsigned int chip_size = 0x100000;
unsigned int sector_size = 0x4096;//4KB

int flashread(unsigned long dst, unsigned int src, unsigned long length)
{
  Int16 tmp = 0;
  if (length == 0)
    return 1;
  /* It is the first byte              */
  if (src & 0x01)                          /* FLASH should be 16Bit alignment   */
  {
    /* FLASH 16bit alignment             */
    tmp = rtl_inw(FLASH_BASE + src - 1); /* FLASH 16bit access                */
    tmp = tmp & 0x00ff;
    *(Int8*)(dst) = (Int8)tmp;           /* Byte access SDRAM                 */

    //printf("%X,%X,%X,%X\n",dst,src,length,*(Int8*)(dst));

    dst = dst + 1;                       /* Finish the First Byte             */
    src = src + 1;                       /* Finish the First Byte             */
    length = length - 1;                 /* Finish the First Byte             */
  }

  while (length)
  {
    if (length == 1)
    {
      tmp = rtl_inw(FLASH_BASE + src);
      *(Int8*)(dst) = (Int8)(((tmp >> 8) & 0x00ff));
      //  printf("%X,%X,%X,%X\n",dst,src,length,*(Int8*)(dst));
      break;
    }

    tmp = rtl_inw(FLASH_BASE + src);   // From now on, src 16Bit aligned
    // FLASH 16bit access
    //if(src&0x01)
    //printf("error");
    //if(length<2)
    //printf("error");
    memcpy((Int8*)dst, &tmp, 2);       //use memcpy, avoid SDRAM alignement

    //printf("%X,%X,%X,%X\n",dst,src,length,*(unsigned short*)(dst));

    dst = dst + 2;
    src = src + 2;
    length = length - 2;
  }
  return 1;
}




/*
  * SPI Flash Info
  */
struct spi_flash_type   spi_flash_info[3];

/*
 * JSW :SPI Flash Info  @20080805
 */
const struct spi_flash_db   spi_flash_known[] =
{
  /*  List of supported Single I/O chip    */
  /*  Verified OK*/
  { 0xC2, 0x20,   0}, /* MXIC(50MHZ/Sector4KB): MX25L3235D/MX25L3205D(4MB),MX25L1635D/MX25L1605D(2MB) */
  { 0xBF, 0x25,   0}, /* SST(50MHZ/Sector4KB): SST25VF016B(2MB)/SST25VF032B(4MB) */
  { 0x01, 0x02,   1}, /* Spansion(104MHZ/Sector64KB):S25FL064P(8MB)*/
  { 0x01, 0x20,   0}, /* Spansion(104MHZ/Sector64KB):S25FL128P(16MB)*/

  /*  List of supported Multi I/O chip    */
  /*  Verified OK*/
  { 0xC2, 0x5e,   0}, /* MXIC(104MHZ/Sector4KB):MX25L3235D(4MB) */
  { 0xC2, 0x24,   0}, /* MXIC(104MHZ/Sector4KB):MX25L1635D(2MB) */
  { 0xEF, 0x40,   0}, /* WindBond(80MHZ/Sector4KB):W25Q16(2MB)/W25Q32(4MB)/W25Q64(8MB)*/

  /*  Multi I/O chip    */
  /*  Not Verified yet*/
  { 0xBF, 0x26,   0}, /*  SST*/
  { 0x1C, 0x20,   0}, /*  EON(100MHZ/Sector64KB) :EN25P64(8MB) */
  { 0x1C, 0x31,   0}, /*  EON(100MHZ/Sector4KB) :EN25F32(4MB)/:EN25F16(2MB) */

};


/*
 * SPI Flash APIs
 */

/*
 * This function shall be called when switching from MMIO to PIO mode
 */
void spi_pio_init(void)
{
  spi_ready();
  *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(0) | READY(1);

  spi_ready();
  *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(3) | READY(1);

  spi_ready();
  *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(0) | READY(1);

  spi_ready();
  *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(3) | READY(1);
}

//unsigned short FAST_READ=0; //1:enable,0:disable ,global variable for spi_read command
#define SPI_DUMMY 0xff


//JSW add :Sector Erase
void spi_sector_erase(unsigned int cnt, unsigned int i)
{

  /* WREN Command */
  spi_ready();
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);
  *(volatile unsigned int *) SFDR = 0x06 << 24;
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

  /* SE Command */
  spi_ready();
  *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(1 + cnt) | READY(1);

  /*JSW@20090714 Note:
   Instruction code :
  =======================
  For Old 50MHZ SPI:
  Sector Erase(20h)~
  1.MXIC: 4KB
  2.Spansion : Not support
  3.SST: 4KB

  SE(D8h)~
  1.MXIC: 64KB
  2.Spansion : 64KB
  3.SST:  64KB

  ========================
  For New 104MHZ SPI:
  Sector Erase(20h)~
  1.MXIC: 4KB
  2.Spansion : 4KB
  3.SST:  4KB

  SE(D8h)~
  1.MXIC: 64KB
  2.Spansion : 64KB
  3.SST: 64KB

  */
#ifdef Set_SECTOR_ERASE_64KB
  *(volatile unsigned int *) SFDR = (0xD8 << 24) | (i * 65536);
#endif

#ifdef Set_SECTOR_ERASE_4KB
  *(volatile unsigned int *) SFDR = (0x20 << 24) | (i * 4096);
#endif

  *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(3) | READY(1);

  /* RDSR Command */
  spi_ready();
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);
  *(volatile unsigned int *) SFDR = 0x05 << 24;

  while (1)
  {
    /* RDSR Command */
    if (((*(volatile unsigned int *) SFDR) & 0x01000000) == 0x00000000)
      break;
  }

  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

#if 0
#ifdef Set_SECTOR_ERASE_64KB
  printf("Erase Sector:%d->%d,Addr:0x%x->0x%x\n" , i, \
         i + 1, (0xbd000000 + (i*0x10000)), (0xbd000000 + (((i + 1)*0x10000)) - 1));
#endif

#ifdef Set_SECTOR_ERASE_4KB
  printf("Erase Sector:%d->%d,Addr:0x%x->0x%x\n" , i, \
         i + 1, (0xbd000000 + (i*0x1000)), (0xbd000000 + (((i + 1)*0x1000)) - 1));
#endif
#else
  printf(".");
#endif
}

void spi_ready(void)
{
  while (1)
  {
    if ((*(volatile unsigned int *) SFCSR) & READY(1))
      break;
  }
}

void __delay(int a)
{
int i;
int count;
for(i = 0 ; i< a;i++)
   count ++;  
}

void spi_probe(void)
{
  unsigned int cnt, i;
  unsigned int temp;

  spi_pio_init();//
  __delay(100*100); //:for spi_probe OK
  for (cnt = 0; cnt < 2; cnt++)
  {
    /* Here set the default setting */
    *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);
    *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);

    /*
    *(volatile unsigned int *) SFCR = LENGTH(1) | CS(3) | RD_ORDER(1) | WR_ORDER(1) | READY(1) | CLK_DIV(1);
       *(volatile unsigned int *) SFCR = LENGTH(1) | CS(1+cnt) | RD_ORDER(1) | WR_ORDER(1) | READY(1) |
    CLK_DIV(1);

    */


    /* One More Toggle (May not Necessary) */
    *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);
    /*20081002:   For spi_probe OK, add spi_ready() */
    spi_ready();
    *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);
    spi_ready();


    /* RDID Command */
    *(volatile unsigned int *) SFDR = 0x9F << 24;
    *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(1 + cnt) | READY(1);

    //printf("\n===========(cnt=%d)===========\n",cnt);
    //printf("SFCR(b8001200) =%x\n",*(volatile unsigned int *) SFCR);
    //printf("SFCSR(b8001204) =%x\n",*(volatile unsigned int *) SFCSR);
    temp = *(volatile unsigned int *) SFDR;
    //printf("temp =%x\n",temp);
    //printf("SFDR(b8001208) =%x\n",*(volatile unsigned int *) SFDR);

    spi_flash_info[cnt].maker_id = (temp >> 24) & 0xFF;
    spi_flash_info[cnt].type_id = (temp >> 16) & 0xFF;
    spi_flash_info[cnt].capacity_id = (temp >> 8) & 0xFF;
    spi_ready();

    *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);


    /* Iterate Each Maker ID/Type ID Pair */
    for (i = 0; i < sizeof(spi_flash_known) / sizeof(struct spi_flash_db); i++)
    {

      if ((spi_flash_info[cnt].maker_id == spi_flash_known[i].maker_id) &&
          (spi_flash_info[cnt].type_id == spi_flash_known[i].type_id))
      {
        //printf("\n=============================\n");
        printf("<Probe SPI #%d >\n",cnt+1);
        printf("1.Manufacture ID=0x%x\n2.Device ID=0x%x\n3.CapacityID=0x%x\n",spi_flash_info[cnt].maker_id,spi_flash_info[cnt].type_id,spi_flash_info[cnt].capacity_id);


        switch (spi_flash_info[cnt].capacity_id)
        {

          case 0x8d:
            printf("4.SST SPI (0.5 MByte)!\n");
            chip_size = 0x80000;
            //Modify SST size_shift for convenience of calculation later
            spi_flash_info[cnt].capacity_id -= 122;
            //spi_flash_info[cnt].sector_cnt = 8;
            //spi_flash_info[cnt].device_size = (unsigned char)((signed char)spi_flash_info[cnt].capacity_id );

            //All SST product need to do this first : Free lock-area
            EWSR(cnt);
            WRSR(cnt);
            //RDSR(cnt);
            break;

          case 0x8e:
            printf("4.SST SPI (1 MByte)!\n");
            chip_size = 0x100000;
            //: Modify SST size_shift for convenience of calculation later
            spi_flash_info[cnt].capacity_id -= 122;
            //spi_flash_info[cnt].sector_cnt = 16;
            //spi_flash_info[cnt].device_size = (unsigned char)((signed char)spi_flash_info[cnt].capacity_id );

            //All SST product need to do this first : Free lock-area
            EWSR(cnt);
            WRSR(cnt);
            // RDSR(cnt);
            break;

          case 0x41:
            printf("4.SST SPI (2 MByte)!\n");
            chip_size = 0x200000;
            //: Modify  SST size_shift for convenience of calculation later
            spi_flash_info[cnt].capacity_id -= 44;
            //spi_flash_info[cnt].sector_cnt = 32;

            //All SST product need to do this first : Free lock-area
            EWSR(cnt);
            WRSR(cnt);
            //RDSR(cnt);
            break;


          case 0x4a:
            printf("4.SST SPI (4 MByte)!\n");
            chip_size = 0x400000;
            //: Modify SST size_shift for convenience of calculation later
            spi_flash_info[cnt].capacity_id -= 52;
            //spi_flash_info[cnt].sector_cnt = 64;
            EWSR(cnt);
            WRSR(cnt);
            //RDSR(cnt);
            break;

          case 0x20:
            printf("4.MXIC SPI (4 MByte)!\n");
            chip_size = 0x400000;
            break;

          case 0x18:
            if (spi_flash_info[cnt].maker_id == 0xc2)
            {
              printf("4.MXIC SPI (16 MByte)!\n");
            }
            if (spi_flash_info[cnt].maker_id == 0x01)
            {
              printf("4.Spansion SPI (16 MByte)!\n");
              //This's 104MHZ available SPI,RD_MODE must be enable to fast read mode
            }
            chip_size = 0x1000000;
            //spi_flash_info[cnt].sector_cnt = 256;
            break;

          case 0x17:
            if (spi_flash_info[cnt].maker_id == 0xc2)
            {
              printf("4.MXIC SPI (8 MByte)!\n");
            }
            else if (spi_flash_info[cnt].maker_id == 0xef)
            {
              printf("4.Winbond SPI (8 MByte)!\n");
            }
            else if (spi_flash_info[cnt].maker_id == 0x1c)  //EON
            {
              printf("4.EON SPI (8 MByte)!\n");
            }
            chip_size = 0x800000;
            break;

          case 0x16:
            if (spi_flash_info[cnt].maker_id == 0xc2)
            {
              printf("4.MXIC SPI (4 MByte)!\n");
              chip_size = 0x400000;
            }
            else if (spi_flash_info[cnt].maker_id == 0x01)
            {
              printf("4.Spansion SPI (8 MByte)!\n");
              chip_size = 0x800000;
            }
            else if (spi_flash_info[cnt].maker_id == 0xef)
            {
              printf("4.Winbond SPI (4 MByte)!\n");
              chip_size = 0x400000;
            }
            else if (spi_flash_info[cnt].maker_id == 0x1c)  //EON
            {
              printf("4.EON SPI (4 MByte)!\n");
              chip_size = 0x400000;
            }
            break;

          case 0x15:
            if (spi_flash_info[cnt].maker_id == 0xc2)
            {
              printf("4.MXIC SPI (2 MByte)!\n");
              chip_size = 0x200000;
            }
            else if (spi_flash_info[cnt].maker_id == 0x01)
            {
              printf("4.Spansion SPI (4 MByte)!\n");
              chip_size = 0x400000;
            }
            else if (spi_flash_info[cnt].maker_id == 0xef)
            {
              printf("4.Winbond SPI (2 MByte)!\n");
              chip_size = 0x200000;
            }
            else if (spi_flash_info[cnt].maker_id == 0x1c)
            {
              printf("4.EON SPI (2 MByte)!\n");
              chip_size = 0x200000;
            }

            break;

          case 0x14:
            if (spi_flash_info[cnt].maker_id == 0xc2)
            {
              printf("4.MXIC SPI (1 MByte)!\n");
              chip_size = 0x100000;
              //spi_flash_info[cnt].sector_cnt = 16;
            }
            else
            {
              printf("4.Spansion SPI (2 MByte)!\n");
              chip_size = 0x200000;
              //spi_flash_info[cnt].sector_cnt = 32;
            }
            break;

          case 0x13:
            printf("4.Spansion SPI (1 MByte)!\n");
            chip_size = 0x100000;
            //spi_flash_info[cnt].sector_cnt = 16;

            break;

          case 0x12:
            printf("4.Spansion SPI (0.5 MByte)!\n");
            chip_size = 0x80000;
            //spi_flash_info[cnt].sector_cnt = 8;
            break;

          default :
            printf("4.Unknow type/size!\n");
            chip_size = 0x100000;
            break;
        }

        spi_flash_info[cnt].device_size = (unsigned char)((signed char)spi_flash_info[cnt].capacity_id +
                                          spi_flash_known[i].size_shift);
        printf("5.Device_ID=0x%x (2^n )\n",spi_flash_info[cnt].device_size);
        // printf("5.cnt=%d\n",cnt);
        //printf("5.spi_flash_info[cnt].sector_cnt=%x\n",spi_flash_info[cnt].device_size);



        spi_flash_info[cnt].sector_cnt = (1 << (spi_flash_info[cnt].device_size - 16));
        //printf("5.Total sector-counts = %d\n",spi_flash_info[cnt].sector_cnt );
        printf("6.spi_flash_info[cnt].device_size = %d\n",spi_flash_info[cnt].device_size );



      }
    }

  }

  /* 20070720 :
      Must set 1st SPI size to SFCR , but 2nd SPI is unnecessary.
      *If total size of SPI is over 16MB,then remember 1st SPI must be the bigger size one.
   */

  /*Set SPI Parameter
     SPI_CLK_DIV(0)= DRAM/(2)
     SPI_CLK_DIV(7)= DRAM/(16) default setting for booting out

     20090825 JSW:
     SPI_CLK_DIV(2)= DRAM/(6)
     For most common SPI Flash(Support 50MHZ)
     SDR_166/(6)=28MHZ or DDR_200/(6)=33MHZ is still a safe parameter!

  */
  WRITE_MEM32(SFCR, SPI_SFSIZE(spi_flash_info[0].device_size - 17) \
              | SPI_RD_ORDER(1) | SPI_WR_ORDER(1) | SPI_CLK_DIV(2) \
              //| SPI_RD_ORDER(1) | SPI_WR_ORDER(1) |  \  //Use default/last SPI clock
              | SPI_TCS(15) | SPI_RD_MODE(1) | SPI_RD_OPT(0));
  printf("\n=============================\n");
  //printf("Set SFCR paramemer\n");
  //printf("1.SFCR(0xb8001200) =%x\n",*(volatile unsigned int *) SFCR);


  //printf("\nBefore AND, HW_STRAP_REG(0xb8000008)=%x\n",READ_MEM32(HW_STRAP_REG));
  //printf("111.SFCR(0xb8001200) =%x\n",*(volatile unsigned int *) SFCR);

  unsigned int SFCR_size = *(volatile unsigned int *) SFCR;
  unsigned int  SFSIZE_25_23;

#ifdef DBG
  //printf("\nSFCR_size =%x\n",SFCR_size);
#endif

  SFSIZE_25_23 = ((0x03800000) & (SFCR_size));

#ifdef DBG
  //printf("\nSFSIZE_25_23 =%x\n\n",SFSIZE_25_23);
#endif

#if 1
  switch (SFSIZE_25_23)
  {
      /* :SFCR setting reference table
      SFCR(0xb8001200)=0xfc780000=128KB
      SFCR(0xb8001200)=0xfcf80000=256KB
      SFCR(0xb8001200)=0xfd780000=512KB
      SFCR(0xb8001200)=0xfdf80000=1MB
      SFCR(0xb8001200)=0xfe780000=2MB
      SFCR(0xb8001200)=0xfef80000=4MB
      SFCR(0xb8001200)=0xff780000=8MB
      SFCR(0xb8001200)=0xfff80000=16MB
      */
    case 0x0:
      printf("2.Set SFCR = 128 KByte!(Just for 1st SPI)\n\n");
      break;

    case 0x00800000:
      printf("2.Set SFCR = 256 KByte!(Just for 1st SPI)\n\n");
      break;

    case 0x01000000:
      printf("2.Set SFCR = 0.5 MByte!(Just for 1st SPI)\n\n");
      break;

    case 0x01800000:
      printf("2.Set SFCR = 1 MByte!(Just for 1st SPI)\n\n");
      break;

    case 0x02000000:
      printf("2.Set SFCR = 2 MByte!(Just for 1st SPI)\n\n");
      break;

    case 0x02800000:
      printf("2.Set SFCR = 4 MByte!(Just for 1st SPI)\n\n");
      break;

    case 0x03000000:
      printf("2.Set SFCR = 8 MByte!(Just for 1st SPI)\n\n");
      break;

    case 0x03800000:
      printf("2.Set SFCR = 16 MByte!(Just for 1st SPI)\n\n");
      break;

    default :
      printf("2.Unknow size,can't set SFCR!\n\n");
      break;

  }
#endif
  printf("=============================\n");

}


//#ifdef SUPPORT_SST_SPI

void EWSR(unsigned short cnt)
{
  //printf("\nEWSR\n ");

  spi_ready();
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);
  // Send_Byte(0x50);  /* enable writing to the status register */
  *(volatile unsigned int *) SFDR = 0x50 << 24; //swap

  // CE_High();   /* disable device */
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

}

/* SST WRSR */
void WRSR(unsigned short cnt)
{
  //printf("\nWRSR\n");
  spi_ready();

  // CE_Low();   /* enable device */
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);


  //Send_Byte(0x01);  /* select write to status register */
  *(volatile unsigned int *) SFDR = (0x01 << 24);

  //Send_Byte(byte);  /* data that will change the status of BPx  or BPL (only bits 2,3,4,5,7 can be written) */
  *(volatile unsigned int *) SFDR = (0x0 << 24);  //swap ,still 0

  //CE_High();   /* disable the device */
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

}

void RDSR(unsigned short cnt)
{
  //printf("\nRDSR\n ");
  unsigned char byte ;
  spi_ready();

// CE_Low();   /* enable device */
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);

//Send_Byte(0x05);  /* select write to status register */
  *(volatile unsigned int *) SFDR = (0x05 << 24);

  while (1)
  {
    /* RDSR Command */
    if (((*(volatile unsigned int *) SFDR) & 0x01000000) == 0x00000000)
    {
      break;
    }
  }

  byte = *(volatile unsigned int *) SFDR;
  //printf("\nSTATUS(char)=%x\n", byte);


//CE_High();   /* disable the device */
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

}


#if 1
void sst_spi_write(unsigned int cnt, unsigned int address, unsigned char data_in)
{
  /* RDSR Command */
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);
  *(volatile unsigned int *) SFDR = 0x05 << 24;

  while (1)
  {
    /* RDSR Command */
    if (((*(volatile unsigned int *) SFDR) & 0x01000000) == 0x0)
    {
      break;
    }
  }

  //1.release CS
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

  /* WREN Command */
  spi_ready();                                    //2.waiting release OK
  //3.CS low
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);
  *(volatile unsigned int *) SFDR = 0x06 << 24;   //4.instr code
  //1.release CS
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

  /* BP Command */
  spi_ready();                                    //2.waiting release OK
  //3.CS low
  *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(1 + cnt) | READY(1);

  //JSW: for SST Byte Program,be aware of LENGTH @2007/9/26
  //4.instr code
  *(volatile unsigned int *) SFDR = (0x02 << 24) | (address & 0xFFFFFF);
  //  *(volatile unsigned int *) SFDR = (0x02<<24 ) ;  //4.instr code

  //3.CS low
  *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + cnt) | READY(1);
  *(volatile unsigned int *) SFDR = (data_in << 24);
  //5.CS HIGH
  *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(3) | READY(1);

}

#endif



//#endif
//end of SUPPORT_SST_SPI

// 20070827 auto-test-porgram for SPI and SDRAM

#define MIN(i, j)                ((i) < (j) ? (i) : (j))
#define MAX(i, j)                ((i) > (j) ? (i) : (j))

void halt()
{
halt_loop:
  return 0;
  goto halt_loop;
}

//void auto_memtest(unsigned char *start,unsigned char *end)




int spi_flw_image(unsigned int chip, unsigned int flash_addr_offset , unsigned char *image_addr, unsigned int image_size)
{
#if 0
#ifdef Set_SECTOR_ERASE_4KB
  dprintf("\nSingle Sector : 4KB \n");
#else
  dprintf("\nSingle Sector : 64KB \n");
#endif
#endif
  unsigned int temp;
  unsigned short i, j, k;
  unsigned char *cur_addr;
  unsigned int cur_size;
  unsigned int SST_Single_Byte_Data, SST_Flash_Offset;
  short shift_cnt8;
  unsigned int byte_cnt = 0;

  cur_addr = image_addr;
  cur_size = image_size;

#ifdef Set_SECTOR_ERASE_64KB
  //Sector:64KB
  unsigned short sector_start_cnt = flash_addr_offset / 65535;
  //Sector:64KB
  unsigned short sector_end_cnt = sector_start_cnt + (image_size / 65535);
#endif

#ifdef Set_SECTOR_ERASE_4KB
  //Sector:4KB
  unsigned short sector_start_cnt = flash_addr_offset / 4095;
  //Sector:4KB
  unsigned short sector_end_cnt = sector_start_cnt + (image_size / 4095);
#endif

  /* Iterate Each Sector */
  for (i = sector_start_cnt; i <= sector_end_cnt; i++)
  {
    //unsigned int spi_data;
    spi_pio_init();
    spi_sector_erase(chip, i);

    *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(3) | READY(1);

    /* Iterate Each Page */
#ifdef Set_SECTOR_ERASE_64KB
    for (j = 0; j < 256; j++)                   //64KB(Sector)/256B(PageProgram)=256
#endif
#ifdef Set_SECTOR_ERASE_4KB
      for (j = 0; j < 16; j++)                //4KB(Sector)/256B(PageProgram)=16
#endif
      {
        if (cur_size == 0)
          break;

        spi_ready();
        *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + chip) | READY(1);
        *(volatile unsigned int *) SFDR = 0x05 << 24;

        while (1)
        {

          if (((*(volatile unsigned int *) SFDR) & 0x01000000) == 0x00000000)
          {
            break;
          }
        }
        *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

        /* WREN Command */
        spi_ready();
        *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + chip) | READY(1);
        *(volatile unsigned int *) SFDR = 0x06 << 24;
        *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

        /* PP Command */
        spi_ready();
        *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(1 + chip) | READY(1);
#ifdef Set_SECTOR_ERASE_64KB
        //Sector:64KB
        *(volatile unsigned int *) SFDR_8198 = (0x02 << 24) | (i * 65536) | (j * 256);
#endif

#ifdef Set_SECTOR_ERASE_4KB
        if ((spi_flash_info[0].type_id == 0x25))
          {}
        else
        {
          //Sector:4KB , j:page Program size
          *(volatile unsigned int *) SFDR = (0x02 << 24) | (i * 4096) | (j * 256);
        }
#endif

        for (k = 0; k < 64; k++)                //k:write 4Byte once
        {
          temp = (*(cur_addr)) << 24 | (*(cur_addr + 1)) << 16 | (*(cur_addr + 2)) << 8 | (*(cur_addr + 3));

          spi_ready();
          if (cur_size >= 4)
          {
            *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(1 + chip) | READY(1);
            cur_size -= 4;
          }
          else
          {

            *(volatile unsigned int *) SFCSR = LENGTH(cur_size - 1) | CS(1 + chip) | READY(1);
            cur_size = 0;
          }

          //for SST SPI Type:Single-Byte Burning
          if ((spi_flash_info[0].type_id == 0x25))
          {
            for (shift_cnt8 = 24;shift_cnt8 >= 0;shift_cnt8 -= 8)
            {
              byte_cnt %= 4;
              SST_Single_Byte_Data = (temp >> shift_cnt8) & 0xff;
              SST_Flash_Offset = (i * 4096) + (j * 256) + (k * 4) + byte_cnt;
              //Write 1 byte each time

#if 1
              /* RDSR Command */
              spi_ready();
              *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + chip) | READY(1);
              *(volatile unsigned int *) SFDR = 0x05 << 24;

              while (1)
              {
                if (((*(volatile unsigned int *) SFDR) & 0x01000000) == 0x00000000)
                {
                  break;
                }
              }
#endif

              sst_spi_write(chip, SST_Flash_Offset, SST_Single_Byte_Data);
              byte_cnt += 1;

            }
          }
          else                                //for MXIC and Spansion 4 byte  burning
          {
            *(volatile unsigned int *) SFDR = temp;
          }

          cur_addr += 4;

          if (cur_size == 0)
            break;
        }

        *(volatile unsigned int *) SFCSR = LENGTH(3) | CS(3) | READY(1);

        /* RDSR Command */
        spi_ready();
        *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(1 + chip) | READY(1);
        *(volatile unsigned int *) SFDR = 0x05 << 24;


        while (1)
        {
          unsigned int status = *(volatile unsigned int *) SFDR;

          /* RDSR Command */
          if ((status & 0x01000000) == 0x00000000)
          {
            break;
          }
#if 0                               //JSW@20090714 :Delete for code size
          unsigned int cnt = 0;
          if (cnt > (1000*1000*200))
          {

busy:
#ifdef Set_SECTOR_ERASE_64KB
            printf("\nBusy Loop for RSDR: %d, Address at 0x%08X\n", status, i*65536 + j*256);
#endif

#ifdef Set_SECTOR_ERASE_4KB
            printf("\nBusy Loop for RSDR: %d, Address at 0x%08X\n", status, i*4096 + j*256);
#endif
            goto busy;
          }
          cnt++;
#endif
        }

        *(volatile unsigned int *) SFCSR = LENGTH(0) | CS(3) | READY(1);

      }

    if (cur_size == 0)
      break;
  }                                               /* Iterate Each Sector */
  return 1;

}

int spi_chip_erase(unsigned int chip,unsigned int chip_size)
{

  unsigned short i, j, k;

#ifdef Set_SECTOR_ERASE_64KB
  //Sector:64KB
  unsigned short sector_start_cnt = 0;//flash_addr_offset / 65535;
  //Sector:64KB
  unsigned short sector_end_cnt = sector_start_cnt + (chip_size / 65535);
#endif

#ifdef Set_SECTOR_ERASE_4KB
  //Sector:4KB
  unsigned short sector_start_cnt = 0;//flash_addr_offset / 4095;
  //Sector:4KB
  unsigned short sector_end_cnt = sector_start_cnt + (chip_size / 4095);
#endif

  /* Iterate Each Sector */
  for (i = sector_start_cnt; i <= sector_end_cnt; i++)
  {
    //unsigned int spi_data;
    spi_pio_init();
    spi_sector_erase(chip, i);
  }
  return 1;
}

int main()
{
  char file_name[128] = "e:/proj/EJTAG/issue/RTL8196/spi_flash.bin";//image file name
  unsigned char image_addr[4096];//32k BUFFER
  int i;
  int rd_num;
  unsigned int chip;
  unsigned int flash_addr_offset;
  unsigned int image_size =0x50910;
  int fd;//file handler

  sector_size = 4096;
    
  spi_probe();//probe spi flash
  
  printf("1: Erase the SPI flash chip\n");
  printf("2: Write image file to SPI flash\n");
  printf("Please input your selection: \n");
  rlx_gdb_read(0,file_name,128);
  if(file_name[0] == '1')//Erase flash
  {
    spi_chip_erase(0,chip_size);
    goto loop;
  }

  //i = 0;
  //do
  //{
  printf("\nPlease input your image file path and name: \n");
  rlx_gdb_read(0,file_name,128);
    i = 0;
    do{
    i ++;
  }while(file_name[i - 1] != '\n');
  file_name[i - 1] = '\0';
  
  fd = rlx_gdb_open(file_name,O_RDONLY,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
  if(fd == NULL)
  {
    printf("\nOpen image file failed !\n");
    return 0;
  }
  
  image_size = 0;
  flash_addr_offset = 0;
  chip = 0;
  i = 0;
  do
  {
    rd_num = rlx_gdb_read(fd, image_addr,4096);
    if(rd_num <= 0)
      break;
    else if(rd_num < 4096)
    {
      for(i = 0 ; i< 4096 - rd_num;i++)
       image_addr[i+rd_num] = 0xff;
      spi_flw_image(chip,flash_addr_offset , (unsigned char *)image_addr,4096);
    }
    else
      spi_flw_image(chip,flash_addr_offset , (unsigned char *)image_addr,rd_num);
    image_size += rd_num;
    flash_addr_offset += rd_num;
    if(flash_addr_offset >= 0x4ffff)
    {
      //chip ++;
      i++;
      //flash_addr_offset = 0;
    }
    
  }while(rd_num > 0 );
  
  
  //if(spi_flw_image(chip,flash_addr_offset , (unsigned char *)image_addr,image_size))
  //  return 0;
 loop:
    goto loop; 
  return 1;
}

//end of file
