
#include "rlx_library.h"

#include <fcntl.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/types.h>
#include <errno.h>

#ifndef NULL
#define NULL 0
#endif

#define __MYPID 1

//#define HEAP_START  _end
//#define HEAP_SIZE   0x800000
//#define MEM_SIZE    0x20000000
#define MEM_SIZE    0x100000
//extern caddr_t HEAP_START;    /* Defined in link script */
extern char _end[];


#undef errno
int errno;

extern int outbyte(char ch);
extern unsigned char inbyte();
extern int havebyte();

int*
__errno(void)
{
  return &errno;
}

struct s_mem {
  unsigned int size;
  unsigned int icsize;
  unsigned int dcsize;
};

/* Return the memory size we have */
void
get_mem_info(struct s_mem *p_mem)
{
  p_mem->size = MEM_SIZE;
  p_mem->icsize = 0;
  p_mem->dcsize = 0;
}

//void
//__main()
//{
//  return;
//}

int
read(fd, buf, nbytes)
     int fd;
     void *buf;
     size_t nbytes;
{
  return rlx_gdb_read(fd, (void *)buf, (unsigned int)nbytes);
}

int
write(fd, buf, nbytes)
     int fd;
     const void *buf;
     size_t nbytes;
{
  int i;

      return rlx_gdb_write(fd, (void *)buf, (unsigned int)nbytes);
}

int
_DEFUN (open, (buf, flags, ...),
     const char *buf _AND
     int flags _DOTS)
{
    /*
  errno = EIO;
  return (-1);
  */
  va_list ap;

  va_start(ap, flags);
  return rlx_gdb_open(buf, flags, va_arg(ap, mode_t));
}

int
close(fd)
     int fd;
{
  return rlx_gdb_close(fd);
}

/*
      * sbrk -- changes heap size size. Get nbytes more
      *         RAM. We just increment a pointer in what's
      *         left of memory on the board.
      */
//void *
//sbrk(nbytes)
//     ptrdiff_t nbytes;
//{
//  static caddr_t heap_ptr = (caddr_t)&HEAP_START;
//  static caddr_t heap_top = (caddr_t)&HEAP_START + HEAP_SIZE;
//
//  caddr_t        base;
//
//  if ((heap_top - heap_ptr) >= nbytes) {
//    base = heap_ptr;
//    heap_ptr += nbytes;
//    return (base);
//  } else {
//    errno = ENOMEM;
//    return ((caddr_t)-1);
//  }
//}

void *
sbrk (nbytes)
     ptrdiff_t nbytes;
{
  static char *heap_ptr = _end;
  static char *heap_start = _end;
  char        *base;
  unsigned int avail = 0;
  static struct s_mem mem = {0, 0, 0};

  /* The sizeof (s_mem.size) must be 4 bytes.  The compiler should be
     able to eliminate this check */
  if (sizeof (unsigned int) != 4)
    return (char *)-1;

  if (mem.size == 0)
    get_mem_info(&mem);
  /* NOTE: The value returned from the get_mem_info call is the amount
     of memory, and not the address of the (last byte + 1) */

  if (((size_t)heap_ptr >= (size_t)heap_start) && ((size_t)heap_ptr < (size_t)(heap_start + mem.size))) {
    avail = (size_t)(heap_start + mem.size) - (size_t)heap_ptr;
    base = heap_ptr;
  } /* else will fail since "nbytes" will be greater than zeroed "avail" value */

  if ((nbytes > avail) || (heap_ptr + nbytes < _end))
   base = (char *)-1;
  else
   heap_ptr += nbytes;

  return (void*)base;
}

off_t
lseek(fd,  offset, whence)
     int fd;
     off_t offset;
     int whence;
{
  return (off_t)rlx_gdb_lseek(fd, offset, whence);
}

int
rename(oldpath, newpath)
        const char *oldpath;
        const char *newpath;
{
  return rlx_gdb_rename(oldpath, newpath);
}

int
unlink(path)
        const char *path;
{
  return rlx_gdb_unlink(path);
}

int
stat(pathname, buf)
        const char *pathname;
        struct stat *buf;
{
  return rlx_gdb_stat(pathname, buf);
}

int
fstat(fd, buf)
     int fd;
     struct stat *buf;
{
  return rlx_gdb_fstat(fd, buf);
}

/* A dummy function to satisfy the linker */
clock_t
times(struct tms *buf)
{
  errno = ENOTSUP;
  return -1;
}

int
gettimeofday(tv, tz)
        struct timeval *tv;
        struct timezone *tz;
{
  return rlx_gdb_gettimeofday(tv, tz);
}

int
isatty(fd)
     int fd;
{
  return rlx_gdb_isatty(fd);
}

int
system(command)
        const char *command;
{
  return rlx_gdb_system(command);
}

/*
      * getpid -- only one process, so just return 1.
      */
int
getpid()
{
  return __MYPID;
}

/*
      * kill -- go out via exit...
      */
int
kill(pid, sig)
     int pid;
     int sig;
{
  if(pid == __MYPID)
    _exit(sig);
  return 0;
}

