ENTRY(_boot)

MEMORY
{
	iram  :  o = 0x80000000, l = 16k  /* 128KB  0x80240000*/
        dram  :  o = 0x89000000, l = 128k 
}

SECTIONS
{

  .boot  : {
     *(.boot); 
     _end_boot = .;
   } >  iram 

  /* program address : AT(load address) */

  .text . : {

		__text_begin = .;
		*(.text);
		__text_end = .;
  } > iram

  .rodata  .       : { *(.rodata .rodata.* .gnu.linkonce.r.*) } > dram
  .rodata1 .       : { *(.rodata1)  } > dram


  .data  : {
      __data_begin = .;
     *(.data) *(.sdata) *(.lit4) *(.lit8) . = ALIGN(4); 
      __data_end = .; 
   } > dram


  _gp = ALIGN(16) ;

  .bss  : {
        . = ALIGN(4);
        __bss_start = .;
        *(.sbss) *(.bss) *(.scommon) *(COMMON)
        . = ALIGN(4);
        __bss_end = .;
    } > dram

}
