#include "bsp.h"
#include "flash.h"


INT32U spi_read_id(INT8U *ssimap)
{
    return 0x00;

}

void spi_se_unprotect(INT8U *ssimap, INT32U Address)
{

}


void Flash_erase_all()//Kaiwen
{
    INT32U flash_busy;

    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    REG32(FLASH_BASE_ADDR+FLASH_VALID_CMD)=0x200;//single channel, blocking write
    REG32(FLASH_BASE_ADDR+FLASH_AUTO_LENGTH)=0x30000;//SPI Address byte = 3, read dummy cycle =0
    REG32(FLASH_BASE_ADDR+FLASH_ADDR_LENGTH)=0x01;//SPI Address byte = 1 in user mode
    REG32(FLASH_BASE_ADDR+FLASH_SER)=0x01;//Set SER
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR1)=0x00;//No read any byte back
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR0)=0x000;//Tx mode
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0x01;//Enable SPIC

    REG8(FLASH_BASE_ADDR+FLASH_DR)=FLASH_WREN_COM;//Write Enable
    Check_SPIC_Busy();

    REG8(FLASH_BASE_ADDR+FLASH_DR)=FLASH_CHIP_ERA;//Chip erase
    Check_SPIC_Busy();
    do {
        Flash_RDSR();
        //check flash busy?
        flash_busy=REG32(FLASH_BASE_ADDR+FLASH_DR);
        flash_busy=flash_busy & 0x00000003;
    } while(flash_busy==0x03);
}

void Flash_erase_sector(INT32U Address)
{
    INT32U   flash_busy, DWtmp;

    //Setup SPIC
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    REG32(FLASH_BASE_ADDR+FLASH_VALID_CMD)=0x200;//single channel, blocking write
    REG32(FLASH_BASE_ADDR+FLASH_AUTO_LENGTH)=0x30000;//SPI Address byte = 3, read dummy cycle =0
    REG32(FLASH_BASE_ADDR+FLASH_ADDR_LENGTH)=0x01;//SPI Address byte = 1 in user mode
    REG32(FLASH_BASE_ADDR+FLASH_SER)=0x01;//Set SER
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR1)=0x00;//No read any byte back
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR0)=0x000;//Tx mode
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0x01;//Enable SPIC

    //Write enable
    REG8(FLASH_BASE_ADDR+FLASH_DR)=FLASH_WREN_COM;
    Check_SPIC_Busy();

    DWtmp = Address >> 16;
    DWtmp = DWtmp + (Address & 0x0000ff00);
    DWtmp = DWtmp + ((Address << 16) & 0x00ff0000);
    DWtmp = (DWtmp << 8 )+ FLASH_CHIP_SEC;
    REG32(FLASH_BASE_ADDR+FLASH_DR)=DWtmp;

    Check_SPIC_Busy();

    do {
        Flash_RDSR();
        //check flash busy?
        flash_busy=REG32(FLASH_BASE_ADDR+FLASH_DR);
        flash_busy=flash_busy & 0x00000003;
    } while(flash_busy==0x03);
}

//void Flash_erase_block(INT32U Address)
void spi_blk_erase(INT8U *ssimap, INT32U Address)
{
    INT32U   flash_busy,DWtmp;

    //Setup SPIC
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    REG32(FLASH_BASE_ADDR+FLASH_VALID_CMD)=0x200;//single channel, blocking write
    REG32(FLASH_BASE_ADDR+FLASH_AUTO_LENGTH)=0x30000;//SPI Address byte = 3, read dummy cycle =0
    REG32(FLASH_BASE_ADDR+FLASH_ADDR_LENGTH)=0x01;//SPI Address byte = 1 in user mode
    REG32(FLASH_BASE_ADDR+FLASH_SER)=0x01;//Set SER
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR1)=0x00;//No read any byte back
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR0)=0x000;//Tx mode
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0x01;//Enable SPIC

    //Write enable
    REG8(FLASH_BASE_ADDR+FLASH_DR)=FLASH_WREN_COM;
    Check_SPIC_Busy();

    DWtmp = Address >> 16;
    DWtmp = DWtmp + (Address & 0x0000ff00);
    DWtmp = DWtmp + ((Address << 16) & 0x00ff0000);
    DWtmp = (DWtmp << 8 )+ FLASH_CHIP_BLK;
    REG32(FLASH_BASE_ADDR+FLASH_DR)=DWtmp;

    Check_SPIC_Busy();

    do {
        Flash_RDSR();
        //check flash busy?
        flash_busy=REG32(FLASH_BASE_ADDR+FLASH_DR);
        flash_busy=flash_busy & 0x00000003;
    } while(flash_busy==0x03);
}


void Flash_write_one_channel(INT32U NDF, INT32U Address, INT32U *ReadBuffer)
{

    INT32U   flash_busy;
    INT32U   i;

    //Setup Single IO Auto Write
    for(i=0; i<NDF; i=i+4)
    {
        Set_SPIC_Write_one_channel();

        //write 4byte data
        REG32(FLASH_DATA_ADDR+Address+i)=*(ReadBuffer+i/4);
        //REG32(FLASH_DATA_ADDR+0)=0x12345678;
        Check_SPIC_Busy();

        //Read Flash Status
        do {
            Flash_RDSR();
            //check flash busy?
            flash_busy=REG32(FLASH_BASE_ADDR+FLASH_DR);
            flash_busy=flash_busy & 0x00000003;
        } while(flash_busy==0x03);
    }

}


//void Flash_write_one_channel_User(INT32U NDF, INT32U Address, INT32U *DReadBuffer)
void spi_write(INT8U *ssimap, INT32U Address, INT32U *DReadBuffer, INT32U NDF)
{

    INT32U   flash_busy, DWtmp;
    INT8U     i,*BReadBuffer;


    BReadBuffer=DReadBuffer;
    Set_SPIC_Write_one_channel();

    REG8(FLASH_BASE_ADDR+FLASH_DR)=FLASH_WREN_COM;//Write Enable
    Check_SPIC_Busy();

    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    Set_SPIC_Write_one_channel();
    DWtmp = Address >> 16;
    DWtmp = DWtmp + (Address & 0x0000ff00);
    DWtmp = DWtmp + ((Address << 16) & 0x00ff0000);
    DWtmp = (DWtmp << 8 )+ FLASH_PP_COM;
    REG32(FLASH_BASE_ADDR+FLASH_DR)=DWtmp;//Write Command and Address
    for(i=0; i<NDF/4; i++)
    {
        REG32(FLASH_BASE_ADDR+FLASH_DR)=*(DReadBuffer+i);
    }
    if((NDF%4)==1)
        REG8(FLASH_BASE_ADDR+FLASH_DR)=*(BReadBuffer+NDF-1);
    else if((NDF%4)==2)
    {
        REG8(FLASH_BASE_ADDR+FLASH_DR)=*(BReadBuffer+NDF-2);
        REG8(FLASH_BASE_ADDR+FLASH_DR)=*(BReadBuffer+NDF-1);
    }
    else if((NDF%4)==3)
    {
        REG8(FLASH_BASE_ADDR+FLASH_DR)=*(BReadBuffer+NDF-3);
        REG8(FLASH_BASE_ADDR+FLASH_DR)=*(BReadBuffer+NDF-2);
        REG8(FLASH_BASE_ADDR+FLASH_DR)=*(BReadBuffer+NDF-1);
    }
    else
    {
    }
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=1;//enable SPIC
    Check_SPIC_Busy();

    //Read Flash Status
    do {
        Flash_RDSR();
        //check flash busy?
        flash_busy=REG32(FLASH_BASE_ADDR+FLASH_DR);
        flash_busy=flash_busy & 0x00000003;
    } while(flash_busy==0x03);

}


void Check_SPIC_Busy()
{
    INT32U   spic_busy;

    do {
        spic_busy=REG32(FLASH_BASE_ADDR+FLASH_SR);
    } while(spic_busy!=0x06);
}

void Flash_RDSR()
{
    INT32U   spic_busy;

    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR0)=0x300;//EEPROM mode
    REG32(FLASH_BASE_ADDR+FLASH_SER)=0x01;//Enable spi_slave0
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR1)=0x01;//read one byte back
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0x01;//Enable SPIC

    REG8(FLASH_BASE_ADDR+FLASH_DR)=FLASH_RDSR_COM;//RDSR

    //check spic busy?
    do {
        spic_busy=REG32(FLASH_BASE_ADDR+FLASH_SR);
        spic_busy=spic_busy & 0x00000001;
    } while(spic_busy!=0x00);
}

void Set_SPIC_Read_one_channel()//Kaiwen
{
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR0)=0x0;//SPI mode 0
    REG32(FLASH_BASE_ADDR+FLASH_BAUDR)=0x1;//BAUD Rate = 1/2 ssclk
    REG32(FLASH_BASE_ADDR+FLASH_ADDR_CTRLR2)=0x21;//setup FIFO depth = 16, SO pin at pin 1
    REG32(FLASH_BASE_ADDR+FLASH_AUTO_LENGTH)=0x30000;//SPI Address byte = 3, read dummy cycle =0
    REG32(FLASH_BASE_ADDR+FLASH_VALID_CMD)=0x200;//single channel address/data, blocking write
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0x01;//Enable SPIC
}

void Set_SPIC_Write_one_channel()//Kaiwen
{
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR0)=0x0;//TX mode
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR1)=0x00;//No read data back
    REG32(FLASH_BASE_ADDR+FLASH_AUTO_LENGTH)=0x30000;//SPI Address byte = 3, read dummy cycle =0
    REG32(FLASH_BASE_ADDR+FLASH_ADDR_LENGTH)=0x03;//SPI Address byte =3 in user mode
    REG32(FLASH_BASE_ADDR+FLASH_VALID_CMD)=0x200;//one channel address/data, blocking write
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0x01;//Enable SPIC
}

void WRSR_Flash_one_two_channel()
{
    INT32U   flash_busy;

    //Setup SPIC
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    REG32(FLASH_BASE_ADDR+FLASH_VALID_CMD)=0x200;//single channel, blocking write
    REG32(FLASH_BASE_ADDR+FLASH_AUTO_LENGTH)=0x30000;//SPI Address byte = 3, read dummy cycle =0
    REG32(FLASH_BASE_ADDR+FLASH_ADDR_LENGTH)=0x01;//SPI Address byte = 1 in user mode
    REG32(FLASH_BASE_ADDR+FLASH_SER)=0x01;//Set SER
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR1)=0x00;//No read any byte back
    REG32(FLASH_BASE_ADDR+FLASH_CTRLR0)=0x000;//Tx mode
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0x01;//Enable SPIC

    //Write enable
    REG8(FLASH_BASE_ADDR+FLASH_DR)=FLASH_WREN_COM;
    Check_SPIC_Busy();

    //Write Status
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0;//Disable SPIC
    REG8(FLASH_BASE_ADDR+FLASH_DR)=FLASH_WRSR_COM;
    REG8(FLASH_BASE_ADDR+FLASH_DR)=0x00;//one/two channel Read mode Enable
    REG32(FLASH_BASE_ADDR+FLASH_SSIENR)=0x01;//Enable SPIC
    Check_SPIC_Busy();
    do {
        Flash_RDSR();
        //check flash busy?
        flash_busy=REG32(FLASH_BASE_ADDR+FLASH_DR);
        flash_busy=flash_busy & 0x00000003;
    } while(flash_busy==0x03);

    do {
        Flash_RDSR();
        flash_busy=REG32(FLASH_BASE_ADDR+FLASH_DR);
        flash_busy=flash_busy & 0x00000040;
    } while(flash_busy!=0x00);//one/two channel Read mode OK?
}






