/***************************************************************************
    filename:            : rlx_ep_fw_flash.S  
    description          : RLX EJTAG PROBE flash driver  (for big-endian)
    created              : Feb 17 2009
	version                : Beta
    copyright            : (C) 2009 by Realsil Co.
    email                : yf_chen@realsil.com.cn
    ext.                 : 6134
***************************************************************************/
/*===========================================================================

                        EDIT HISTORY FOR MODULE

when        who              what, where, why
--------    -----            ----------------------------------------------------------
===========================================================================*/
/*****************************************************************
    include files
*****************************************************************/
#include "rlx_ep_cpu.h"
#include "rlx_ep_addr_cmd.h"
//#include "rlx_ep_macro.h"

#define  SSI_BASE       0xb4000000
#define  SPI_WR_BASE    0x0
 
#define USER_2_KERNEL \
       nop;\
       nop;\
       mfc0 t0,$12;\
       nop;\
       li  t1,0x1ffffff0;\
       and t0,t1;\
       mtc0 t0,$12;\
       nop;\
       nop ;
        
#define USER_2_KERNEL_MIPS \
       nop ;\
       nop ;\
       mfc0 t0,$12;\
       nop;\
       li  t1,0xffffffe6;\
       and t0,t1;\
       ori  t1,$0,6;\
       or  t0,t1;\
       mtc0 t0,$12;\
       nop;\
       nop ;
 
//////////////////////////////////////////////////////////////////
//serial flash driver
######################################################################
#disable SPI write
#t2 : SSI_BASE
#t0 : using
#define SPI_DIS_WRITE \  
        sw      zero, SSI_SSIENR(t2);\   
        li      t0, 0x71c7;\
        sw      t0, SSI_CTRLR0(t2) ;\    
        li      t0, 0x1      ;\      
        sw      t0, SSI_SER(t2)   ;\  
        li      t0, 0x1;\
        sw      t0, SSI_SSIENR(t2)    ;\ 
        li      t0, SER_FLASH_CMD_WRDI;\
        sw      t0, SSI_DR(t2)  ;\  
        DW_SSI_WAIT_NOBUSY;\
        SPI_WAIT_BUSY;\
        nop;


######################################################################
#initial SPI
#a1 : for SPI_SET_STATUS
#define SPI_INIT \ 
        SPI_SET_STATUS;\
        nop;


######################################################################
//t2 :SSI_BASE
//t1,t0 : using
#define DW_SSI_WAIT_NOBUSY \
1: ;\
        lw      t0, SSI_SR(t2);\
        nop;\
        andi	t1,t0,0x20;\
        beqz	t1,2f ;\
        nop;\
        j	3f;\
        nop   ;\     
2:;\
        andi	t1,t0,0x1;\
        bnez	t1,1b;\
        nop;\
        andi	t1,t0,0x4;\
        beqz	t1,1b;\
        nop;\
3:;\
        nop ;       


######################################################################
//SPI wait busy
//t2 : SSI_BASE
//t0 ,using
#define SPI_WAIT_BUSY \
        sw      zero, SSI_SSIENR(t2) ;\
        sw      zero, SSI_CTRLR1(t2) ;\
        li      t0, 0x73c7  ;\
        sw      t0, SSI_CTRLR0(t2)   ;\
        li      t0, 0x1;\
        sw      t0, SSI_SER(t2)  ;\
        li      t0, 0x1;\
        sw      t0, SSI_SSIENR(t2);\
4:;\
        li      t0, SER_FLASH_CMD_RDSR;\                       
        sw      t0, SSI_DR(t2);\
        DW_SSI_WAIT_NOBUSY;\
        lw      t0, SSI_DR(t2);\
        nop;\
        andi    t0, t0, 0x01 ;\       
        bne     t0, zero, 4b ;\   
        nop;

######################################################################
//SPI write enable
//t2 : SSI_BASE
//t0 ,using       
#define SPI_ENABLE_WRITE \   
        sw      zero, 0x8(t2) ;\
        li      t0, 0x71c7 ;\
        sw      t0, SSI_CTRLR0(t2) ;\     
        li      t0, 0x1     ;\     
        sw      t0, SSI_SER(t2) ;\    
        li      t0, 0x1;\
        sw      t0, SSI_SSIENR(t2)  ;\    
        li      t0, SER_FLASH_CMD_WREN;\
        sw      t0, SSI_DR(t2)  ;\   
        DW_SSI_WAIT_NOBUSY;\
        SPI_WAIT_BUSY;\
        nop;
        
######################################################################
#disable SSI
#t2 : SSI_BASE        
#define DW_SSI_DISABLE \
        sw	zero,SSI_SSIENR(t2);\
        nop;

######################################################################
#set status of SPI flash
#define SPI_SET_STATUS \
        sw      zero, SSI_SSIENR(t2) ;\  
        li      t0, 0x71c7;\
        sw      t0, SSI_CTRLR0(t2)   ;\  
        li      t0, 0x1;\
        sw      t0, SSI_SER(t2)   ;\ 
        li      t0, 0x1;\
        sw      t0, SSI_SSIENR(t2)    ;\ 
        li      t0, SER_FLASH_CMD_WREN;\
        sw      t0, SSI_DR(t2)  ;\  
        DW_SSI_WAIT_NOBUSY;\
        sw      zero, SSI_SER(t2) ;\ 
        li      t0, SER_FLASH_CMD_WRSR   ;\                   
        sw      t0, SSI_DR(t2)  ;\  
        sw      zero, SSI_DR(t2) ;\   
        li      t0, 0x1;\
        sw      t0, SSI_SER(t2)  ;\  
        DW_SSI_WAIT_NOBUSY;\
        SPI_WAIT_BUSY 
        

######################################################################
#set baudrate of SPI FLASH
#t2 : SSI_BASE
#t7 : baud
#define DW_SSI_SETBAUDR \ 
        DW_SSI_DISABLE;\
        nop;\
        li	t0,0x10;\
        sw	t0,SSI_BAUDR(t2);\
        nop;


////////////////////////////////////
//SPI flash chip erase
//s2 : SSI_BASE
//t0 ,t1,s2,s0 : using      
#define SPI_FLASH_ERS_CHIP \
        nop;\
        li        gp,0x80200000;\
        li        s2,SSI_BASE;\
        sw        zero, SSI_SSIENR(s2)  ;\ 
        SPI_INIT;\
        nop;\  
        li        t0, 0x71c7;\
        sw        t0, SSI_CTRLR0(s2);\ 
        li        t0, 0x1      ;\           
        sw        t0, SSI_SER(s2);\      
        li        t0, 0x1;\
        sw        t0, SSI_SSIENR(s2);\
        li        t0, SER_FLASH_CMD_WREN;\
        sw        t0, SSI_DR(s2);\
        DW_SSI_WAIT_NOBUSY ;\
        li        t0, SER_FLASH_CMD_BE;\
        sw        t0, SSI_DR(s2);\
        DW_SSI_WAIT_NOBUSY;\
        SPI_ENABLE_WRITE ;\
        nop;\
        nop 



/////////////////////////////////////////////////////
  .section ".flash" , "ax"
  .set noreorder
  .set nomips16  
  #.set noat
	.globl  debug_entry
	.ent	debug_entry	
debug_entry:		//
       nop
      
#ifndef MIPS_PROCESSOR        
       USER_2_KERNEL
#else
       USER_2_KERNEL_MIPS  
#endif            

//t2 : spi flash controller base address
//t3 : destintion base address
//t4 : source address
//gp : size
//t5 : data
//t8 : byte counter 
//s0 : transmit fifo size
//s1 : address upper 
//t0,t1,t5,t6,t7,t8:  temporory reg
        nop
        li      t2,SSI_BASE
        li      t3,SPI_WR_BASE
        nop
        
//set baudrate and erase flash chip        
// SPI_FLASH_ERS_CHIP        
        DW_SSI_SETBAUDR
        nop;   
        SPI_INIT
        nop
        sw        zero, SSI_SSIENR(t2)   
        li        t0, 0x71c7
        sw        t0, SSI_CTRLR0(t2) 
        li        t0, 0x1                 
        sw        t0, SSI_SER(t2)      
        li        t0, 0x1
        sw        t0, SSI_SSIENR(t2)
        li        t0, SER_FLASH_CMD_WREN
        sw        t0, SSI_DR(t2)
        DW_SSI_WAIT_NOBUSY 
        li        t0, SER_FLASH_CMD_BE
        sw        t0, SSI_DR(t2)
        DW_SSI_WAIT_NOBUSY
        SPI_ENABLE_WRITE
        
        
flush_over:        
        //lw        s0,SSI_TXFLR(t2)
//        li        s0,0x40 
        addi    s0,-2
        blez    s0,s0_default
        srl     s0,1
        blez    s0,s0_default
        srl     s0,1
        blez    s0,s0_default
        srl     s0,1
        blez    s0,s0_4
        srl     s0,1
        blez    s0,s0_8
        srl     s0,1
        blez    s0,s0_16
        srl     s0,1
        blez    s0,s0_32
        srl     s0,1
        blez    s0,s0_64
        srl     s0,1
        blez    s0,s0_128
        srl     s0,1
        blez    s0,s0_256
        srl     s0,1
        j       s0_512
s0_default: 
        j      0f                          
        ori    s0,zero,1
s0_4:   
        j      0f
        ori    s0,zero,4                          
s0_8:   
        j      0f                          
        ori    s0,zero,8
s0_16:  
        j      0f                          
        ori    s0,zero,16
s0_32:  
        j      0f                          
        ori    s0,zero,32
s0_64:  
        j      0f                          
        ori    s0,zero,64
s0_128: 
        j      0f                          
        ori    s0,zero,128
s0_256:
        j      0f                          
        ori    s0,zero,256
s0_512:
        j      0f                          
        ori    s0,zero,512
s0_1024:
        j      0f          
        ori    s0,zero,1024
        nop                
0:
        move      s1,t4
        //add     t8, s0 
7:
        add     s1,s0        
        sw      zero, SSI_SSIENR(t2)           
        li      t0, 0x71c7
        sw      t0, SSI_CTRLR0(t2)             
        li      t0, 0x1                        
        sw      t0, SSI_SER(t2)             
        li      t0, 0x1
        sw      t0, SSI_SSIENR(t2)             
        li      t0, SER_FLASH_CMD_WREN 
        sw      t0, SSI_DR(t2)            
        DW_SSI_WAIT_NOBUSY
        sw      zero, SSI_SER(t2)                          
        move    t6, t3                 
        andi    t7, t6, 0xff               
        srl     t6, t6, 8                  
        andi    t1, t6, 0xff            
        srl     t6, t6, 8
        li      t0, SER_FLASH_CMD_PP   
        sw      t0, SSI_DR(t2)
        sw      t6, SSI_DR(t2)
        sw      t1, SSI_DR(t2)
        sw      t7, SSI_DR(t2)
        
9:
        lb      t5, 0x0(t4)
        nop 
        addi    t4, t4, 1
        sw      t5, SSI_DR(t2)
        bne     s1, t4, 9b 
        nop
        
        //sw      t5, SSI_DR(t2)
        ori     t0, zero,0x1                             
        sw      t0, SSI_SER(t2)      
        DW_SSI_WAIT_NOBUSY
        SPI_WAIT_BUSY
        add     t3,s0
        //srl     t5,t5,8
        sub     gp,s0
        bgtz    gp,0b //2f fixed
        nop   
2:      
        nop;
debug_spi_fast_wr_end:
        nop;
        j       0b;//back to write again
        nop;
8 :
       nop;
       j          8b
       nop
debug_end :
       nop       
        
     	.set	reorder  
      .end  debug_entry

