/***************************************************************************
    filename:            : rlx_ep_cpu.h  
    description          : RLX EJTAG PROBE firmware register define
    created              : Dec 16 2006
	version                : 1.0
    copyright            : (C) 2006 by Realsil Co.
    email                : yf_chen@realsil.com.cn
***************************************************************************/
/*===========================================================================

                        EDIT HISTORY FOR MODULE

when        who              what, where, why
--------    -----            ----------------------------------------------------------
2006-07     yf_chen
===========================================================================*/
/*****************************************************************
    include files
*****************************************************************/
#ifndef RLX_EP_CPU_H
#define RLX_EP_CPU_H

#define jr                  j
#define jalr                jal

/* aliases for general registers */
#define zero	              $0
#define	AT		              $1		/* assembler temporaries */
#define	v0		              $2		/* value holders */
#define	v1		              $3
#define	a0		              $4		/* arguments */
#define	a1	                $5
#define	a2		              $6
#define	a3		              $7
#define	t0		              $8		/* temporaries */
#define	t1		              $9
#define	t2		              $10
#define	t3		              $11
#define	t4		              $12
#define	t5		              $13
#define	t6		              $14
#define	t7		              $15
#define	s0		              $16		/* saved registers */
#define	s1		              $17
#define	s2		              $18
#define	s3		              $19
#define	s4		              $20
#define	s5		              $21
#define	s6		              $22
#define	s7		              $23
#define	t8		              $24		/* temporaries */
#define	t9		              $25
#define	k0		              $26		/* kernel registers */
#define	k1		              $27
#define	gp		              $28		/* global pointer */
#define	sp		              $29		/* stack pointer */
#define	s8		              $30		/* saved register */
#define	fp		              $30		/* frame pointer (old usage) */
#define	ra		              $31		/* return address */

#ifndef  MIPS_PROCESSOR
#define C0_INDEX            $0
#define C0_ENTRYLO          $2
#define C0_WIRED            $6
#define C0_BADVADDR	        $8		/* Bad Virtual Address */
#define C0_ENTRYHI          $9
/* System Control Coprocessor (CP0) registers */
#define C0_SR		            $12		/* Processor Status */
#define C0_CAUSE	          $13		/* Exception Cause */
#define C0_EPC		          $14		/* Exception PC */
#define C0_PRID		          $15		/* Processor Rev Indentifier */
#define C0_DREG             $16
#define C0_DEPC             $17
#define C0_ERRCTL           $26
#define C0_TAGLO            $28
#define C0_DATALO           $28
#define C0_DATAHI           $29
#define C0_CCTL		          $20 		/* cache control register */
#define DESAVE              $31
//DEFINE LEXRA CP0 registers
#define LXCP0_ESTATUS       $0
#define LXCP0_ECAUSE        $1
#define LXCP0_INTVEC        $2
#define LXCP0_BPCTL         $3
#define LXCP0_WMPCTL        $4
#define LXCP0_WMPSTATUS     $5
#define LXCP0_WMPVADDR      $6
#define LXCP0_WMPEXTRAMASK  $19


///////////////////////////////////////
//FOR mips processor
#else  
// System Control Coprocessor (CP0) registers 
#define C0_ENTRYLO          $2
#define C0_INDEX            $0
#define C0_RANDOM           $1
#define C0_ENTRYLO0         $2
#define C0_ENTRYLO1         $3
#define C0_CONTEXT          $4
#define C0_PAGEMASK         $5
//select 1
#define C0_PAGEGRAIN        $5
#define C0_WIRED            $6
#define C0_HWRENA           $7
#define C0_BADVADDR	        $8		// Bad Virtual Address
#define C0_COUNT            $9
#define C0_ENTRYHI          $10
#define C0_COMPARE          $11
#define C0_SR		            $12		// Processor Status 
//select 1
#define C0_INTCTL           $12		// Processor Status 
//select 2
#define C0_SRSCTL           $12		// Processor Status 
//select 3
#define C0_SRSMAP           $12		// Processor Status 
#define C0_CAUSE	          $13		// Exception Cause 
#define C0_EPC		          $14		// Exception PC 
#define C0_PRID  	          $15
//select 1
#define C0_EBASE            $15		// EBase register
#define C0_CONFIG           $16
//select 1
#define C0_CONFIG1          $16
//select 2
#define C0_CONFIG2          $16
//select 3
#define C0_CONFIG3          $16
#define C0_LLADDR	          $17

#define C0_WATCHLO          $18
//select 0-7
#define C0_WATCHLO          $18
//select 0-7
#define C0_WATCHHI          $19

#define C0_DREG             $23
//select 1
#define C0_TRACE_CTL        $23
#define C0_TRACE_CTL2       $23
//SELECT 3
#define C0_USR_TRACE_DATA   $23
//SELECT 4
#define C0_TRACE_BPC        $23

#define C0_DEPC             $24
#define C0_ERRCTL           $26

#define C0_TAGLO            $28
//select 1
#define C0_DATA_LO          $28
#define C0_ERROREPC         $30
#define DESAVE              $31
//select 1
#define C0_CONFIG           $16
#define C0_CONFIG1          $16
#define C0_CONFIG2          $16
#define C0_CONFIG3          $16
//DEFINE LEXRA CP0 registers
//#define LXCP0_ESTATUS       $0
//#define LXCP0_ECAUSE        $1
//#define LXCP0_INTVEC        $2
#endif

//cache instruction operator define
#define INDEX_INVALIDATE_I    0x00
#define INDEX_WRITEBACK_INV_D 0x01
#define INDEX_INVALIDATE_SI   0x02
#define INDEX_WRITEBACK_INV_SD  0x03
#define INDEX_LOAD_TAG_I      0x04
#define INDEX_LOAD_TAG_D      0x05
#define INDEX_LOAD_TAG_SI     0x06
#define INDEX_LOAD_TAG_SD     0x07
#define INDEX_STORE_TAG_I     0x08
#define INDEX_STORE_TAG_D     0x09
#define INDEX_STORE_TAG_SI    0x0A
#define INDEX_STORE_TAG_SD    0x0B
#define CREATE_DIRTY_EXC_D    0x0D
#define CREATE_DIRTY_EXC_SD   0x0F

////
#define HIT_INVALIDATE_I      0x10
#define HIT_INVALIDATE_D      0x11
#define HIT_INVALIDATE_SI     0x12
#define HIT_INVALIDATE_SD     0x13
#define FILL_I                0x14
#define HIT_WIRTEBACK_INV_D   0x15

#define HIT_WRITEBACK_INV_SD  0x17
#define HIT_WRITEBACK_I       0x18
#define HIT_WRITEBACK_D       0x19

#define HIT_WRITEBACK_SD      0x1B
#define HIT_SET_VIRTURE_SI    0x1E
#define HIT_SET_VIRTURE_SD    0x1F

#define DREG_LSNM             0x10000000 
#endif
//end of file
