/***************************************************************************
    filename:            : rlx_ep_addr_cmd.h  
    description          : RLX PROBE firmware address and command define
    created              : June 19 2007
	version                : 1.0
    copyright            : (C) 2007 by Realsil Co.
    email                : yf_chen@realsil.com.cn
***************************************************************************/
/*===========================================================================

                        EDIT HISTORY FOR MODULE

when        who              what, where, why
--------    -----            ----------------------------------------------------------
2007-06     yf_chen
===========================================================================*/
/*****************************************************************
    include files
*****************************************************************/
#ifndef RLX_EP_ADDR_CMD_H
#define RLX_EP_ADDR_CMD_H

#ifndef RLX_EP_ADDR_CMD_HEADER
#define RLX_EP_ADDR_CMD_HEADER
//define some const for DEBUG command
#define CMD_OK_FLAG         0x5555
#define CMD_ERR_FLAG        0x3333
#define CMD_WR_WORD         0x7777

//offset of register buffer
#define RD_BASE_ADDR_OFF    0x0040 
#define MEM_BASE_ADDR_OFF   0x8000
#define CP0_DREG_BUF_OFF    0x01f0
#define CP0_DEPC_BUF_OFF    0x01f4
#define FLAG_ADDR_OFF		    0x01f8
#define FLAG_ADDR_COM_OFF   0x01fc
#define RD_START_ADDR_OFF   0x0010
#define RD_NUM_ADDR_OFF 	  0x0014
#define FLASH_BASE_BUF_OFF  0x0018
#define DBG_NUM_ADDR_OFF    0x001c
#define DSU_BUF_BASE_OFF	  0x0020
#define REG5_BUF_OFF        0x01e0
#define REG6_BUF_OFF        0x01e4
#define REG7_BUF_OFF        0x01e8
#define REG8_BUF_OFF        0x01ec
///offset of TLB entry 
#define TLB_ENT_BUF_OFF     0x01d0
//Debug service unit address define
#define DSU_BASE            0xff300000
#define DSU_BUF_OFF         0x20


//define data address offset in firmware
#define DSU_DCR_FW_OFF      0x0000
#define DSU_IBS_FW_OFF      0x0004
#define DSU_DBS_FW_OFF      0x0008
#define DSU_PBS_FW_OFF      0x000c

#define DSU_BA_FW_OFF       0x0000
#define DSU_BC_FW_OFF       0x0004
#define DSU_BM_FW_OFF       0x0008
#define DSU_BV_FW_OFF       0x000C
#define DSU_ASID_FW_OFF     0x0010

#define DSU_IBP_OFF			    0x0100
#define DSU_DBP_OFF			    0x0200
#define DSU_PBP_OFF			    0x0300
#define DSU_DCR_OFF         0x0000

/////////////////////////////////////////////
//DSU address offset
#ifndef MIPS_PROCESSOR
//DCR,DBS,IBS,PBS offset
//offset for break in DSU
#define DSU_BA_OFF          0x0000
#define DSU_BC_OFF          0x0004
#define DSU_BM_OFF          0x0008
#define DSU_BV_OFF          0x000C
#define DSU_IBS_OFF         0x0004
#define DSU_DBS_OFF         0x0008
#define DSU_PBS_OFF         0x000C
#else
//define data address in firmware
//offset for break in DSU
//for EJTAG 2.6
#define DSU_BA_OFF          0x0000
#define DSU_BC_OFF          0x0018
#define DSU_BM_OFF          0x0008
#define DSU_BV_OFF          0x0010
#define DSU_ASID_OFF        0x0010
#define DSU_IBS_OFF         0x1000
#define DSU_DBS_OFF         0x2000
#define DSU_PBS_OFF         0x3000
#endif


//define flash base address buffer offset
#define FLASH_START_ADDR    0xbfc00000
#define FLASH_CMD_ADDR1		  0x0aaa
#define FLASH_CMD_ADDR2		  0x0554
#define FLASH_CMD_ADDR3		  0x0555
//#define FLASH_CMD_DATA1		0x55
//#define FLASH_CMD_DATA2		0xaa
//#define FLASH_CMD_DATA3		0xa0
//#define FLASH_CMD_ADDR1		0x0aaa
//#define FLASH_CMD_ADDR2		0x0555
//#define FLASH_CMD_ADDR3		0x0aaa
#define FLASH_CMD_DATA1		  0x55
#define FLASH_CMD_DATA2		  0xaa
#define FLASH_CMD_DATA3		  0xa0

#define FLASH_CMD_DATA4		  0x80
#define FLASH_CMD_DATA5		  0x10
#define FLASH_CMD_DATA6		  0x30
#define FLASH_CMD_DATA7		  0x90
#define FLASH_CMD_RESET		  0x00f0
#define FLASH_SEC_ERS_PEN   0xb0
#define FLASH_DATA_POLL_MSK 0xffffffff

#endif

//#define TIMES      0x00000040 //<0x0010_0000

#define SST     
#define SSI_BASE        0xB4000000
#define SSI_CTRLR0      0x0
#define SSI_CTRLR1      0x4
#define SSI_SSIENR      0x8
#define SSI_MWCR        0xC
#define SSI_SER         0x10
#define SSI_BAUDR       0x14
#define SSI_TXFTLR      0x18
#define SSI_RXFTLR      0x1C
#define SSI_TXFLR       0x20
#define SSI_RXFLR       0x24
#define SSI_SR          0x28
#define SSI_IMR         0x2C
#define SSI_ISR         0x30
#define SSI_RISR        0x34
#define SSI_TXOICR      0x38
#define SSI_RXOICR      0x3C
#define SSI_RXUICR      0x40
#define SSI_MSTICR      0x44
#define SSI_ICR         0x48
#define SSI_DMACR       0x4C
#define SSI_DMATDLR     0x50
#define SSI_DMARDLR     0x54
#define SSI_IDR         0x58
#define SSI_VERSION     0x5C
#define SSI_DR          0x60

//bit define of status register
#define SSI_SR_DCOL     0x40
#define SSI_SR_TXE      0x20
#define SSI_SR_RFF      0x10
#define SSI_SR_RFNE     0x0C
#define SSI_SR_TFE      0x08
#define SSI_SR_TFNF     0x04
#define SSI_SR_BUSY     0x00

#define SSI_BAUDR_VAR   0x10


//#define Macronix

#ifdef Macronix
#define  SER_FLASH_CMD_WRSR           0x01
#define  SER_FLASH_CMD_PP             0x02
#define  SER_FLASH_CMD_READ           0x03
#define  SER_FLASH_CMD_WRDI           0x04
#define  SER_FLASH_CMD_RDSR           0x05
#define  SER_FLASH_CMD_WREN           0x06
#define  SER_FLASH_CMD_FAST_READ      0x0b
#define  SER_FLASH_CMD_Parallel_mode  0x55
#define  SER_FLASH_CMD_REMS           0x90
#define  SER_FLASH_CMD_RDID           0x9f
#define  SER_FLASH_CMD_EN4K           0Xa5
#define  SER_FLASH_CMD_RES            0xab
#define  SER_FLASH_CMD_EX4K           0xb5
#define  SER_FLASH_CMD_DP             0xb9
#define  SER_FLASH_CMD_BE             0xc7
#define  SER_FLASH_CMD_SE             0xd8
#endif

#ifdef SST
#define  SER_FLASH_CMD_WRSR           0x01
#define  SER_FLASH_CMD_PP             0x02
#define  SER_FLASH_CMD_READ           0x03
#define  SER_FLASH_CMD_WRDI           0x04
#define  SER_FLASH_CMD_RDSR           0x05
#define  SER_FLASH_CMD_WREN           0x06
#define  SER_FLASH_CMD_FAST_READ      0x0b
#define  SER_FLASH_CMD_REMS           0x90
#define  SER_FLASH_CMD_RDID           0x9f
#define  SER_FLASH_CMD_EN4K           0Xa5
#define  SER_FLASH_CMD_EX4K           0xb5
#define  SER_FLASH_CMD_RES            0xab
#define  SER_FLASH_CMD_AAI            0xad
#define  SER_FLASH_CMD_DP             0xb9
#define  SER_FLASH_CMD_BE             0xc7
#define  SER_FLASH_CMD_SE             0xd8
#endif
//end of file

#endif 
//end of file

