package org.matheclipse.core.rubi.step02;

public class AlgebraicFunctions extends AbstractRubiTestCase {
  static boolean init = true;

  public AlgebraicFunctions(String name) {
    super(name, false);
  }

  @Override
  protected void setUp() {
    try {
      super.setUp();
      if (init) {
        System.out.println("AlgebraicFunctions");
        init = false;
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  // {33, 31}
  public void test0001() {
    check( //
        "Integrate[(Sqrt[-a] + e*(c + d*x))^(-1), x]", //
        "Log[Sqrt[-a] + c*e + d*e*x]/(d*e)", //
        33,
        31);
  }

  // {33, 32}
  public void test0002() {
    check( //
        "Integrate[(c + d*(a + b*x))^(5/2), x]", //
        "(2*(c + d*(a + b*x))^(7/2))/(7*b*d)", //
        33,
        32);
  }

  // {33, 32}
  public void test0003() {
    check( //
        "Integrate[(c + d*(a + b*x))^(3/2), x]", //
        "(2*(c + d*(a + b*x))^(5/2))/(5*b*d)", //
        33,
        32);
  }

  // {33, 32}
  public void test0004() {
    check( //
        "Integrate[Sqrt[c + d*(a + b*x)], x]", //
        "(2*(c + d*(a + b*x))^(3/2))/(3*b*d)", //
        33,
        32);
  }

  // {33, 32}
  public void test0005() {
    check( //
        "Integrate[1/Sqrt[c + d*(a + b*x)], x]", //
        "(2*Sqrt[c + d*(a + b*x)])/(b*d)", //
        33,
        32);
  }

  // {33, 32}
  public void test0006() {
    check( //
        "Integrate[(c + d*(a + b*x))^(-3/2), x]", //
        "-2/(b*d*Sqrt[c + d*(a + b*x)])", //
        33,
        32);
  }

  // {33, 32}
  public void test0007() {
    check( //
        "Integrate[(c + d*(a + b*x))^(-5/2), x]", //
        "-2/(3*b*d*(c + d*(a + b*x))^(3/2))", //
        33,
        32);
  }

  // {45}
  public void test0008() {
    check( //
        "Integrate[x^3*(a + b*x), x]", //
        "(a*x^4)/4 + (b*x^5)/5", //
        45);
  }

  // {45}
  public void test0009() {
    check( //
        "Integrate[x^2*(a + b*x), x]", //
        "(a*x^3)/3 + (b*x^4)/4", //
        45);
  }

  // {45}
  public void test0010() {
    check( //
        "Integrate[x*(a + b*x), x]", //
        "(a*x^2)/2 + (b*x^3)/3", //
        45);
  }

  // {45}
  public void test0011() {
    check( //
        "Integrate[(a + b*x)/x, x]", //
        "b*x + a*Log[x]", //
        45);
  }

  // {45}
  public void test0012() {
    check( //
        "Integrate[(a + b*x)/x^2, x]", //
        "-(a/x) + b*Log[x]", //
        45);
  }

  // {45}
  public void test0013() {
    check( //
        "Integrate[(a + b*x)/x^4, x]", //
        "-a/(3*x^3) - b/(2*x^2)", //
        45);
  }

  // {45}
  public void test0014() {
    check( //
        "Integrate[(a + b*x)/x^5, x]", //
        "-a/(4*x^4) - b/(3*x^3)", //
        45);
  }

  // {45}
  public void test0015() {
    check( //
        "Integrate[x^3*(a + b*x)^2, x]", //
        "(a^2*x^4)/4 + (2*a*b*x^5)/5 + (b^2*x^6)/6", //
        45);
  }

  // {45}
  public void test0016() {
    check( //
        "Integrate[x^2*(a + b*x)^2, x]", //
        "(a^2*x^3)/3 + (a*b*x^4)/2 + (b^2*x^5)/5", //
        45);
  }

  // {45}
  public void test0017() {
    check( //
        "Integrate[x*(a + b*x)^2, x]", //
        "(a^2*x^2)/2 + (2*a*b*x^3)/3 + (b^2*x^4)/4", //
        45);
  }

  // {45}
  public void test0018() {
    check( //
        "Integrate[(a + b*x)^2/x, x]", //
        "2*a*b*x + (b^2*x^2)/2 + a^2*Log[x]", //
        45);
  }

  // {45}
  public void test0019() {
    check( //
        "Integrate[(a + b*x)^2/x^2, x]", //
        "-(a^2/x) + b^2*x + 2*a*b*Log[x]", //
        45);
  }

  // {45}
  public void test0020() {
    check( //
        "Integrate[(a + b*x)^2/x^3, x]", //
        "-a^2/(2*x^2) - (2*a*b)/x + b^2*Log[x]", //
        45);
  }

  // {45}
  public void test0021() {
    check( //
        "Integrate[(a + b*x)^2/x^5, x]", //
        "-a^2/(4*x^4) - (2*a*b)/(3*x^3) - b^2/(2*x^2)", //
        45);
  }

  // {45}
  public void test0022() {
    check( //
        "Integrate[(a + b*x)^2/x^6, x]", //
        "-a^2/(5*x^5) - (a*b)/(2*x^4) - b^2/(3*x^3)", //
        45);
  }

  // {45}
  public void test0023() {
    check( //
        "Integrate[(a + b*x)^2/x^7, x]", //
        "-a^2/(6*x^6) - (2*a*b)/(5*x^5) - b^2/(4*x^4)", //
        45);
  }

  // {45}
  public void test0024() {
    check( //
        "Integrate[(a + b*x)^2/x^8, x]", //
        "-a^2/(7*x^7) - (a*b)/(3*x^6) - b^2/(5*x^5)", //
        45);
  }

  // {45}
  public void test0025() {
    check( //
        "Integrate[x^4*(a + b*x)^3, x]", //
        "(a^3*x^5)/5 + (a^2*b*x^6)/2 + (3*a*b^2*x^7)/7 + (b^3*x^8)/8", //
        45);
  }

  // {45}
  public void test0026() {
    check( //
        "Integrate[x^3*(a + b*x)^3, x]", //
        "(a^3*x^4)/4 + (3*a^2*b*x^5)/5 + (a*b^2*x^6)/2 + (b^3*x^7)/7", //
        45);
  }

  // {45}
  public void test0027() {
    check( //
        "Integrate[x^2*(a + b*x)^3, x]", //
        "(a^3*x^3)/3 + (3*a^2*b*x^4)/4 + (3*a*b^2*x^5)/5 + (b^3*x^6)/6", //
        45);
  }

  // {45}
  public void test0028() {
    check( //
        "Integrate[x*(a + b*x)^3, x]", //
        "-(a*(a + b*x)^4)/(4*b^2) + (a + b*x)^5/(5*b^2)", //
        45);
  }

  // {45}
  public void test0029() {
    check( //
        "Integrate[(a + b*x)^3/x, x]", //
        "3*a^2*b*x + (3*a*b^2*x^2)/2 + (b^3*x^3)/3 + a^3*Log[x]", //
        45);
  }

  // {45}
  public void test0030() {
    check( //
        "Integrate[(a + b*x)^3/x^2, x]", //
        "-(a^3/x) + 3*a*b^2*x + (b^3*x^2)/2 + 3*a^2*b*Log[x]", //
        45);
  }

  // {45}
  public void test0031() {
    check( //
        "Integrate[(a + b*x)^3/x^3, x]", //
        "-a^3/(2*x^2) - (3*a^2*b)/x + b^3*x + 3*a*b^2*Log[x]", //
        45);
  }

  // {45}
  public void test0032() {
    check( //
        "Integrate[(a + b*x)^3/x^4, x]", //
        "-a^3/(3*x^3) - (3*a^2*b)/(2*x^2) - (3*a*b^2)/x + b^3*Log[x]", //
        45);
  }

  // {47, 37}
  public void test0033() {
    check( //
        "Integrate[(a + b*x)^3/x^6, x]", //
        "-(a + b*x)^4/(5*a*x^5) + (b*(a + b*x)^4)/(20*a^2*x^4)", //
        47,
        37);
  }

  // {45}
  public void test0034() {
    check( //
        "Integrate[(a + b*x)^3/x^7, x]", //
        "-a^3/(6*x^6) - (3*a^2*b)/(5*x^5) - (3*a*b^2)/(4*x^4) - b^3/(3*x^3)", //
        45);
  }

  // {45}
  public void test0035() {
    check( //
        "Integrate[(a + b*x)^3/x^8, x]", //
        "-a^3/(7*x^7) - (a^2*b)/(2*x^6) - (3*a*b^2)/(5*x^5) - b^3/(4*x^4)", //
        45);
  }

  // {45}
  public void test0036() {
    check( //
        "Integrate[x^6*(a + b*x)^5, x]", //
        "(a^5*x^7)/7 + (5*a^4*b*x^8)/8 + (10*a^3*b^2*x^9)/9 + a^2*b^3*x^10 + (5*a*b^4*x^11)/11 + (b^5*x^12)/12", //
        45);
  }

  // {45}
  public void test0037() {
    check( //
        "Integrate[x^5*(a + b*x)^5, x]", //
        "(a^5*x^6)/6 + (5*a^4*b*x^7)/7 + (5*a^3*b^2*x^8)/4 + (10*a^2*b^3*x^9)/9 + (a*b^4*x^10)/2 + (b^5*x^11)/11", //
        45);
  }

  // {45}
  public void test0038() {
    check( //
        "Integrate[x^4*(a + b*x)^5, x]", //
        "(a^5*x^5)/5 + (5*a^4*b*x^6)/6 + (10*a^3*b^2*x^7)/7 + (5*a^2*b^3*x^8)/4 + (5*a*b^4*x^9)/9 + (b^5*x^10)/10", //
        45);
  }

  // {45}
  public void test0039() {
    check( //
        "Integrate[x^3*(a + b*x)^5, x]", //
        "-(a^3*(a + b*x)^6)/(6*b^4) + (3*a^2*(a + b*x)^7)/(7*b^4) - (3*a*(a + b*x)^8)/(8*b^4) + (a + b*x)^9/(9*b^4)", //
        45);
  }

  // {45}
  public void test0040() {
    check( //
        "Integrate[x^2*(a + b*x)^5, x]", //
        "(a^2*(a + b*x)^6)/(6*b^3) - (2*a*(a + b*x)^7)/(7*b^3) + (a + b*x)^8/(8*b^3)", //
        45);
  }

  // {45}
  public void test0041() {
    check( //
        "Integrate[x*(a + b*x)^5, x]", //
        "-(a*(a + b*x)^6)/(6*b^2) + (a + b*x)^7/(7*b^2)", //
        45);
  }

  // {45}
  public void test0042() {
    check( //
        "Integrate[(a + b*x)^5/x, x]", //
        "5*a^4*b*x + 5*a^3*b^2*x^2 + (10*a^2*b^3*x^3)/3 + (5*a*b^4*x^4)/4 + (b^5*x^5)/5 + a^5*Log[x]", //
        45);
  }

  // {45}
  public void test0043() {
    check( //
        "Integrate[(a + b*x)^5/x^2, x]", //
        "-(a^5/x) + 10*a^3*b^2*x + 5*a^2*b^3*x^2 + (5*a*b^4*x^3)/3 + (b^5*x^4)/4 + 5*a^4*b*Log[x]", //
        45);
  }

  // {45}
  public void test0044() {
    check( //
        "Integrate[(a + b*x)^5/x^3, x]", //
        "-a^5/(2*x^2) - (5*a^4*b)/x + 10*a^2*b^3*x + (5*a*b^4*x^2)/2 + (b^5*x^3)/3 + 10*a^3*b^2*Log[x]", //
        45);
  }

  // {45}
  public void test0045() {
    check( //
        "Integrate[(a + b*x)^5/x^4, x]", //
        "-a^5/(3*x^3) - (5*a^4*b)/(2*x^2) - (10*a^3*b^2)/x + 5*a*b^4*x + (b^5*x^2)/2 + 10*a^2*b^3*Log[x]", //
        45);
  }

  // {45}
  public void test0046() {
    check( //
        "Integrate[(a + b*x)^5/x^5, x]", //
        "-a^5/(4*x^4) - (5*a^4*b)/(3*x^3) - (5*a^3*b^2)/x^2 - (10*a^2*b^3)/x + b^5*x + 5*a*b^4*Log[x]", //
        45);
  }

  // {45}
  public void test0047() {
    check( //
        "Integrate[(a + b*x)^5/x^6, x]", //
        "-a^5/(5*x^5) - (5*a^4*b)/(4*x^4) - (10*a^3*b^2)/(3*x^3) - (5*a^2*b^3)/x^2 - (5*a*b^4)/x + b^5*Log[x]", //
        45);
  }

  // {47, 37}
  public void test0048() {
    check( //
        "Integrate[(a + b*x)^5/x^8, x]", //
        "-(a + b*x)^6/(7*a*x^7) + (b*(a + b*x)^6)/(42*a^2*x^6)", //
        47,
        37);
  }

  // {45}
  public void test0049() {
    check( //
        "Integrate[(a + b*x)^5/x^10, x]", //
        "-a^5/(9*x^9) - (5*a^4*b)/(8*x^8) - (10*a^3*b^2)/(7*x^7) - (5*a^2*b^3)/(3*x^6) - (a*b^4)/x^5 - b^5/(4*x^4)", //
        45);
  }

  // {45}
  public void test0050() {
    check( //
        "Integrate[(a + b*x)^5/x^11, x]", //
        "-a^5/(10*x^10) - (5*a^4*b)/(9*x^9) - (5*a^3*b^2)/(4*x^8) - (10*a^2*b^3)/(7*x^7) - (5*a*b^4)/(6*x^6) - b^5/(5*x^5)", //
        45);
  }

  // {45}
  public void test0051() {
    check( //
        "Integrate[(a + b*x)^5/x^12, x]", //
        "-a^5/(11*x^11) - (a^4*b)/(2*x^10) - (10*a^3*b^2)/(9*x^9) - (5*a^2*b^3)/(4*x^8) - (5*a*b^4)/(7*x^7) - b^5/(6*x^6)", //
        45);
  }

  // {45}
  public void test0052() {
    check( //
        "Integrate[(a + b*x)^5/x^13, x]", //
        "-a^5/(12*x^12) - (5*a^4*b)/(11*x^11) - (a^3*b^2)/x^10 - (10*a^2*b^3)/(9*x^9) - (5*a*b^4)/(8*x^8) - b^5/(7*x^7)", //
        45);
  }

  // {45}
  public void test0053() {
    check( //
        "Integrate[(a + b*x)^5/x^14, x]", //
        "-a^5/(13*x^13) - (5*a^4*b)/(12*x^12) - (10*a^3*b^2)/(11*x^11) - (a^2*b^3)/x^10 - (5*a*b^4)/(9*x^9) - b^5/(8*x^8)", //
        45);
  }

  // {45}
  public void test0054() {
    check( //
        "Integrate[x^8*(a + b*x)^7, x]", //
        "(a^7*x^9)/9 + (7*a^6*b*x^10)/10 + (21*a^5*b^2*x^11)/11 + (35*a^4*b^3*x^12)/12 + (35*a^3*b^4*x^13)/13 + (3*a^2*b^5*x^14)/2 + (7*a*b^6*x^15)/15 + (b^7*x^16)/16", //
        45);
  }

  // {45}
  public void test0055() {
    check( //
        "Integrate[x^7*(a + b*x)^7, x]", //
        "(a^7*x^8)/8 + (7*a^6*b*x^9)/9 + (21*a^5*b^2*x^10)/10 + (35*a^4*b^3*x^11)/11 + (35*a^3*b^4*x^12)/12 + (21*a^2*b^5*x^13)/13 + (a*b^6*x^14)/2 + (b^7*x^15)/15", //
        45);
  }

  // {45}
  public void test0056() {
    check( //
        "Integrate[x^6*(a + b*x)^7, x]", //
        "(a^7*x^7)/7 + (7*a^6*b*x^8)/8 + (7*a^5*b^2*x^9)/3 + (7*a^4*b^3*x^10)/2 + (35*a^3*b^4*x^11)/11 + (7*a^2*b^5*x^12)/4 + (7*a*b^6*x^13)/13 + (b^7*x^14)/14", //
        45);
  }

  // {45}
  public void test0057() {
    check( //
        "Integrate[x^5*(a + b*x)^7, x]", //
        "-(a^5*(a + b*x)^8)/(8*b^6) + (5*a^4*(a + b*x)^9)/(9*b^6) - (a^3*(a + b*x)^10)/b^6 + (10*a^2*(a + b*x)^11)/(11*b^6) - (5*a*(a + b*x)^12)/(12*b^6) + (a + b*x)^13/(13*b^6)", //
        45);
  }

  // {45}
  public void test0058() {
    check( //
        "Integrate[x^4*(a + b*x)^7, x]", //
        "(a^4*(a + b*x)^8)/(8*b^5) - (4*a^3*(a + b*x)^9)/(9*b^5) + (3*a^2*(a + b*x)^10)/(5*b^5) - (4*a*(a + b*x)^11)/(11*b^5) + (a + b*x)^12/(12*b^5)", //
        45);
  }

  // {45}
  public void test0059() {
    check( //
        "Integrate[x^3*(a + b*x)^7, x]", //
        "-(a^3*(a + b*x)^8)/(8*b^4) + (a^2*(a + b*x)^9)/(3*b^4) - (3*a*(a + b*x)^10)/(10*b^4) + (a + b*x)^11/(11*b^4)", //
        45);
  }

  // {45}
  public void test0060() {
    check( //
        "Integrate[x^2*(a + b*x)^7, x]", //
        "(a^2*(a + b*x)^8)/(8*b^3) - (2*a*(a + b*x)^9)/(9*b^3) + (a + b*x)^10/(10*b^3)", //
        45);
  }

  // {45}
  public void test0061() {
    check( //
        "Integrate[x*(a + b*x)^7, x]", //
        "-(a*(a + b*x)^8)/(8*b^2) + (a + b*x)^9/(9*b^2)", //
        45);
  }

  // {45}
  public void test0062() {
    check( //
        "Integrate[(a + b*x)^7/x, x]", //
        "7*a^6*b*x + (21*a^5*b^2*x^2)/2 + (35*a^4*b^3*x^3)/3 + (35*a^3*b^4*x^4)/4 + (21*a^2*b^5*x^5)/5 + (7*a*b^6*x^6)/6 + (b^7*x^7)/7 + a^7*Log[x]", //
        45);
  }

  // {45}
  public void test0063() {
    check( //
        "Integrate[(a + b*x)^7/x^2, x]", //
        "-(a^7/x) + 21*a^5*b^2*x + (35*a^4*b^3*x^2)/2 + (35*a^3*b^4*x^3)/3 + (21*a^2*b^5*x^4)/4 + (7*a*b^6*x^5)/5 + (b^7*x^6)/6 + 7*a^6*b*Log[x]", //
        45);
  }

  // {45}
  public void test0064() {
    check( //
        "Integrate[(a + b*x)^7/x^3, x]", //
        "-a^7/(2*x^2) - (7*a^6*b)/x + 35*a^4*b^3*x + (35*a^3*b^4*x^2)/2 + 7*a^2*b^5*x^3 + (7*a*b^6*x^4)/4 + (b^7*x^5)/5 + 21*a^5*b^2*Log[x]", //
        45);
  }

  // {45}
  public void test0065() {
    check( //
        "Integrate[(a + b*x)^7/x^4, x]", //
        "-a^7/(3*x^3) - (7*a^6*b)/(2*x^2) - (21*a^5*b^2)/x + 35*a^3*b^4*x + (21*a^2*b^5*x^2)/2 + (7*a*b^6*x^3)/3 + (b^7*x^4)/4 + 35*a^4*b^3*Log[x]", //
        45);
  }

  // {45}
  public void test0066() {
    check( //
        "Integrate[(a + b*x)^7/x^5, x]", //
        "-a^7/(4*x^4) - (7*a^6*b)/(3*x^3) - (21*a^5*b^2)/(2*x^2) - (35*a^4*b^3)/x + 21*a^2*b^5*x + (7*a*b^6*x^2)/2 + (b^7*x^3)/3 + 35*a^3*b^4*Log[x]", //
        45);
  }

  // {45}
  public void test0067() {
    check( //
        "Integrate[(a + b*x)^7/x^6, x]", //
        "-a^7/(5*x^5) - (7*a^6*b)/(4*x^4) - (7*a^5*b^2)/x^3 - (35*a^4*b^3)/(2*x^2) - (35*a^3*b^4)/x + 7*a*b^6*x + (b^7*x^2)/2 + 21*a^2*b^5*Log[x]", //
        45);
  }

  // {45}
  public void test0068() {
    check( //
        "Integrate[(a + b*x)^7/x^7, x]", //
        "-a^7/(6*x^6) - (7*a^6*b)/(5*x^5) - (21*a^5*b^2)/(4*x^4) - (35*a^4*b^3)/(3*x^3) - (35*a^3*b^4)/(2*x^2) - (21*a^2*b^5)/x + b^7*x + 7*a*b^6*Log[x]", //
        45);
  }

  // {45}
  public void test0069() {
    check( //
        "Integrate[(a + b*x)^7/x^8, x]", //
        "-a^7/(7*x^7) - (7*a^6*b)/(6*x^6) - (21*a^5*b^2)/(5*x^5) - (35*a^4*b^3)/(4*x^4) - (35*a^3*b^4)/(3*x^3) - (21*a^2*b^5)/(2*x^2) - (7*a*b^6)/x + b^7*Log[x]", //
        45);
  }

  // {47, 37}
  public void test0070() {
    check( //
        "Integrate[(a + b*x)^7/x^10, x]", //
        "-(a + b*x)^8/(9*a*x^9) + (b*(a + b*x)^8)/(72*a^2*x^8)", //
        47,
        37);
  }

  // {45}
  public void test0071() {
    check( //
        "Integrate[(a + b*x)^7/x^14, x]", //
        "-a^7/(13*x^13) - (7*a^6*b)/(12*x^12) - (21*a^5*b^2)/(11*x^11) - (7*a^4*b^3)/(2*x^10) - (35*a^3*b^4)/(9*x^9) - (21*a^2*b^5)/(8*x^8) - (a*b^6)/x^7 - b^7/(6*x^6)", //
        45);
  }

  // {45}
  public void test0072() {
    check( //
        "Integrate[(a + b*x)^7/x^15, x]", //
        "-a^7/(14*x^14) - (7*a^6*b)/(13*x^13) - (7*a^5*b^2)/(4*x^12) - (35*a^4*b^3)/(11*x^11) - (7*a^3*b^4)/(2*x^10) - (7*a^2*b^5)/(3*x^9) - (7*a*b^6)/(8*x^8) - b^7/(7*x^7)", //
        45);
  }

  // {45}
  public void test0073() {
    check( //
        "Integrate[(a + b*x)^7/x^16, x]", //
        "-a^7/(15*x^15) - (a^6*b)/(2*x^14) - (21*a^5*b^2)/(13*x^13) - (35*a^4*b^3)/(12*x^12) - (35*a^3*b^4)/(11*x^11) - (21*a^2*b^5)/(10*x^10) - (7*a*b^6)/(9*x^9) - b^7/(8*x^8)", //
        45);
  }

  // {45}
  public void test0074() {
    check( //
        "Integrate[x^11*(a + b*x)^10, x]", //
        "(a^10*x^12)/12 + (10*a^9*b*x^13)/13 + (45*a^8*b^2*x^14)/14 + 8*a^7*b^3*x^15 + (105*a^6*b^4*x^16)/8 + (252*a^5*b^5*x^17)/17 + (35*a^4*b^6*x^18)/3 + (120*a^3*b^7*x^19)/19 + (9*a^2*b^8*x^20)/4 + (10*a*b^9*x^21)/21 + (b^10*x^22)/22", //
        45);
  }

  // {45}
  public void test0075() {
    check( //
        "Integrate[x^10*(a + b*x)^10, x]", //
        "(a^10*x^11)/11 + (5*a^9*b*x^12)/6 + (45*a^8*b^2*x^13)/13 + (60*a^7*b^3*x^14)/7 + 14*a^6*b^4*x^15 + (63*a^5*b^5*x^16)/4 + (210*a^4*b^6*x^17)/17 + (20*a^3*b^7*x^18)/3 + (45*a^2*b^8*x^19)/19 + (a*b^9*x^20)/2 + (b^10*x^21)/21", //
        45);
  }

  // {45}
  public void test0076() {
    check( //
        "Integrate[x^9*(a + b*x)^10, x]", //
        "(a^10*x^10)/10 + (10*a^9*b*x^11)/11 + (15*a^8*b^2*x^12)/4 + (120*a^7*b^3*x^13)/13 + 15*a^6*b^4*x^14 + (84*a^5*b^5*x^15)/5 + (105*a^4*b^6*x^16)/8 + (120*a^3*b^7*x^17)/17 + (5*a^2*b^8*x^18)/2 + (10*a*b^9*x^19)/19 + (b^10*x^20)/20", //
        45);
  }

  // {45}
  public void test0077() {
    check( //
        "Integrate[x^8*(a + b*x)^10, x]", //
        "(a^8*(a + b*x)^11)/(11*b^9) - (2*a^7*(a + b*x)^12)/(3*b^9) + (28*a^6*(a + b*x)^13)/(13*b^9) - (4*a^5*(a + b*x)^14)/b^9 + (14*a^4*(a + b*x)^15)/(3*b^9) - (7*a^3*(a + b*x)^16)/(2*b^9) + (28*a^2*(a + b*x)^17)/(17*b^9) - (4*a*(a + b*x)^18)/(9*b^9) + (a + b*x)^19/(19*b^9)", //
        45);
  }

  // {45}
  public void test0078() {
    check( //
        "Integrate[x^7*(a + b*x)^10, x]", //
        "-(a^7*(a + b*x)^11)/(11*b^8) + (7*a^6*(a + b*x)^12)/(12*b^8) - (21*a^5*(a + b*x)^13)/(13*b^8) + (5*a^4*(a + b*x)^14)/(2*b^8) - (7*a^3*(a + b*x)^15)/(3*b^8) + (21*a^2*(a + b*x)^16)/(16*b^8) - (7*a*(a + b*x)^17)/(17*b^8) + (a + b*x)^18/(18*b^8)", //
        45);
  }

  // {45}
  public void test0079() {
    check( //
        "Integrate[x^6*(a + b*x)^10, x]", //
        "(a^6*(a + b*x)^11)/(11*b^7) - (a^5*(a + b*x)^12)/(2*b^7) + (15*a^4*(a + b*x)^13)/(13*b^7) - (10*a^3*(a + b*x)^14)/(7*b^7) + (a^2*(a + b*x)^15)/b^7 - (3*a*(a + b*x)^16)/(8*b^7) + (a + b*x)^17/(17*b^7)", //
        45);
  }

  // {45}
  public void test0080() {
    check( //
        "Integrate[x^5*(a + b*x)^10, x]", //
        "-(a^5*(a + b*x)^11)/(11*b^6) + (5*a^4*(a + b*x)^12)/(12*b^6) - (10*a^3*(a + b*x)^13)/(13*b^6) + (5*a^2*(a + b*x)^14)/(7*b^6) - (a*(a + b*x)^15)/(3*b^6) + (a + b*x)^16/(16*b^6)", //
        45);
  }

  // {45}
  public void test0081() {
    check( //
        "Integrate[x^4*(a + b*x)^10, x]", //
        "(a^4*(a + b*x)^11)/(11*b^5) - (a^3*(a + b*x)^12)/(3*b^5) + (6*a^2*(a + b*x)^13)/(13*b^5) - (2*a*(a + b*x)^14)/(7*b^5) + (a + b*x)^15/(15*b^5)", //
        45);
  }

  // {45}
  public void test0082() {
    check( //
        "Integrate[x^3*(a + b*x)^10, x]", //
        "-(a^3*(a + b*x)^11)/(11*b^4) + (a^2*(a + b*x)^12)/(4*b^4) - (3*a*(a + b*x)^13)/(13*b^4) + (a + b*x)^14/(14*b^4)", //
        45);
  }

  // {45}
  public void test0083() {
    check( //
        "Integrate[x^2*(a + b*x)^10, x]", //
        "(a^2*(a + b*x)^11)/(11*b^3) - (a*(a + b*x)^12)/(6*b^3) + (a + b*x)^13/(13*b^3)", //
        45);
  }

  // {45}
  public void test0084() {
    check( //
        "Integrate[x*(a + b*x)^10, x]", //
        "-(a*(a + b*x)^11)/(11*b^2) + (a + b*x)^12/(12*b^2)", //
        45);
  }

  // {45}
  public void test0085() {
    check( //
        "Integrate[(a + b*x)^10/x, x]", //
        "10*a^9*b*x + (45*a^8*b^2*x^2)/2 + 40*a^7*b^3*x^3 + (105*a^6*b^4*x^4)/2 + (252*a^5*b^5*x^5)/5 + 35*a^4*b^6*x^6 + (120*a^3*b^7*x^7)/7 + (45*a^2*b^8*x^8)/8 + (10*a*b^9*x^9)/9 + (b^10*x^10)/10 + a^10*Log[x]", //
        45);
  }

  // {45}
  public void test0086() {
    check( //
        "Integrate[(a + b*x)^10/x^2, x]", //
        "-(a^10/x) + 45*a^8*b^2*x + 60*a^7*b^3*x^2 + 70*a^6*b^4*x^3 + 63*a^5*b^5*x^4 + 42*a^4*b^6*x^5 + 20*a^3*b^7*x^6 + (45*a^2*b^8*x^7)/7 + (5*a*b^9*x^8)/4 + (b^10*x^9)/9 + 10*a^9*b*Log[x]", //
        45);
  }

  // {45}
  public void test0087() {
    check( //
        "Integrate[(a + b*x)^10/x^3, x]", //
        "-a^10/(2*x^2) - (10*a^9*b)/x + 120*a^7*b^3*x + 105*a^6*b^4*x^2 + 84*a^5*b^5*x^3 + (105*a^4*b^6*x^4)/2 + 24*a^3*b^7*x^5 + (15*a^2*b^8*x^6)/2 + (10*a*b^9*x^7)/7 + (b^10*x^8)/8 + 45*a^8*b^2*Log[x]", //
        45);
  }

  // {45}
  public void test0088() {
    check( //
        "Integrate[(a + b*x)^10/x^4, x]", //
        "-a^10/(3*x^3) - (5*a^9*b)/x^2 - (45*a^8*b^2)/x + 210*a^6*b^4*x + 126*a^5*b^5*x^2 + 70*a^4*b^6*x^3 + 30*a^3*b^7*x^4 + 9*a^2*b^8*x^5 + (5*a*b^9*x^6)/3 + (b^10*x^7)/7 + 120*a^7*b^3*Log[x]", //
        45);
  }

  // {45}
  public void test0089() {
    check( //
        "Integrate[(a + b*x)^10/x^5, x]", //
        "-a^10/(4*x^4) - (10*a^9*b)/(3*x^3) - (45*a^8*b^2)/(2*x^2) - (120*a^7*b^3)/x + 252*a^5*b^5*x + 105*a^4*b^6*x^2 + 40*a^3*b^7*x^3 + (45*a^2*b^8*x^4)/4 + 2*a*b^9*x^5 + (b^10*x^6)/6 + 210*a^6*b^4*Log[x]", //
        45);
  }

  // {45}
  public void test0090() {
    check( //
        "Integrate[(a + b*x)^10/x^6, x]", //
        "-a^10/(5*x^5) - (5*a^9*b)/(2*x^4) - (15*a^8*b^2)/x^3 - (60*a^7*b^3)/x^2 - (210*a^6*b^4)/x + 210*a^4*b^6*x + 60*a^3*b^7*x^2 + 15*a^2*b^8*x^3 + (5*a*b^9*x^4)/2 + (b^10*x^5)/5 + 252*a^5*b^5*Log[x]", //
        45);
  }

  // {45}
  public void test0091() {
    check( //
        "Integrate[(a + b*x)^10/x^7, x]", //
        "-a^10/(6*x^6) - (2*a^9*b)/x^5 - (45*a^8*b^2)/(4*x^4) - (40*a^7*b^3)/x^3 - (105*a^6*b^4)/x^2 - (252*a^5*b^5)/x + 120*a^3*b^7*x + (45*a^2*b^8*x^2)/2 + (10*a*b^9*x^3)/3 + (b^10*x^4)/4 + 210*a^4*b^6*Log[x]", //
        45);
  }

  // {45}
  public void test0092() {
    check( //
        "Integrate[(a + b*x)^10/x^8, x]", //
        "-a^10/(7*x^7) - (5*a^9*b)/(3*x^6) - (9*a^8*b^2)/x^5 - (30*a^7*b^3)/x^4 - (70*a^6*b^4)/x^3 - (126*a^5*b^5)/x^2 - (210*a^4*b^6)/x + 45*a^2*b^8*x + 5*a*b^9*x^2 + (b^10*x^3)/3 + 120*a^3*b^7*Log[x]", //
        45);
  }

  // {45}
  public void test0093() {
    check( //
        "Integrate[(a + b*x)^10/x^9, x]", //
        "-a^10/(8*x^8) - (10*a^9*b)/(7*x^7) - (15*a^8*b^2)/(2*x^6) - (24*a^7*b^3)/x^5 - (105*a^6*b^4)/(2*x^4) - (84*a^5*b^5)/x^3 - (105*a^4*b^6)/x^2 - (120*a^3*b^7)/x + 10*a*b^9*x + (b^10*x^2)/2 + 45*a^2*b^8*Log[x]", //
        45);
  }

  // {45}
  public void test0094() {
    check( //
        "Integrate[(a + b*x)^10/x^10, x]", //
        "-a^10/(9*x^9) - (5*a^9*b)/(4*x^8) - (45*a^8*b^2)/(7*x^7) - (20*a^7*b^3)/x^6 - (42*a^6*b^4)/x^5 - (63*a^5*b^5)/x^4 - (70*a^4*b^6)/x^3 - (60*a^3*b^7)/x^2 - (45*a^2*b^8)/x + b^10*x + 10*a*b^9*Log[x]", //
        45);
  }

  // {45}
  public void test0095() {
    check( //
        "Integrate[(a + b*x)^10/x^11, x]", //
        "-a^10/(10*x^10) - (10*a^9*b)/(9*x^9) - (45*a^8*b^2)/(8*x^8) - (120*a^7*b^3)/(7*x^7) - (35*a^6*b^4)/x^6 - (252*a^5*b^5)/(5*x^5) - (105*a^4*b^6)/(2*x^4) - (40*a^3*b^7)/x^3 - (45*a^2*b^8)/(2*x^2) - (10*a*b^9)/x + b^10*Log[x]", //
        45);
  }

  // {47, 37}
  public void test0096() {
    check( //
        "Integrate[(a + b*x)^10/x^13, x]", //
        "-(a + b*x)^11/(12*a*x^12) + (b*(a + b*x)^11)/(132*a^2*x^11)", //
        47,
        37);
  }

  // {45}
  public void test0097() {
    check( //
        "Integrate[(a + b*x)^10/x^19, x]", //
        "-a^10/(18*x^18) - (10*a^9*b)/(17*x^17) - (45*a^8*b^2)/(16*x^16) - (8*a^7*b^3)/x^15 - (15*a^6*b^4)/x^14 - (252*a^5*b^5)/(13*x^13) - (35*a^4*b^6)/(2*x^12) - (120*a^3*b^7)/(11*x^11) - (9*a^2*b^8)/(2*x^10) - (10*a*b^9)/(9*x^9) - b^10/(8*x^8)", //
        45);
  }

  // {45}
  public void test0098() {
    check( //
        "Integrate[(a + b*x)^10/x^20, x]", //
        "-a^10/(19*x^19) - (5*a^9*b)/(9*x^18) - (45*a^8*b^2)/(17*x^17) - (15*a^7*b^3)/(2*x^16) - (14*a^6*b^4)/x^15 - (18*a^5*b^5)/x^14 - (210*a^4*b^6)/(13*x^13) - (10*a^3*b^7)/x^12 - (45*a^2*b^8)/(11*x^11) - (a*b^9)/x^10 - b^10/(9*x^9)", //
        45);
  }

  // {45}
  public void test0099() {
    check( //
        "Integrate[x^5/(a + b*x), x]", //
        "(a^4*x)/b^5 - (a^3*x^2)/(2*b^4) + (a^2*x^3)/(3*b^3) - (a*x^4)/(4*b^2) + x^5/(5*b) - (a^5*Log[a + b*x])/b^6", //
        45);
  }

  // {45}
  public void test0100() {
    check( //
        "Integrate[x^4/(a + b*x), x]", //
        "-((a^3*x)/b^4) + (a^2*x^2)/(2*b^3) - (a*x^3)/(3*b^2) + x^4/(4*b) + (a^4*Log[a + b*x])/b^5", //
        45);
  }

  // {45}
  public void test0101() {
    check( //
        "Integrate[x^3/(a + b*x), x]", //
        "(a^2*x)/b^3 - (a*x^2)/(2*b^2) + x^3/(3*b) - (a^3*Log[a + b*x])/b^4", //
        45);
  }

  // {45}
  public void test0102() {
    check( //
        "Integrate[x^2/(a + b*x), x]", //
        "-((a*x)/b^2) + x^2/(2*b) + (a^2*Log[a + b*x])/b^3", //
        45);
  }

  // {45}
  public void test0103() {
    check( //
        "Integrate[x/(a + b*x), x]", //
        "x/b - (a*Log[a + b*x])/b^2", //
        45);
  }

  // {46}
  public void test0104() {
    check( //
        "Integrate[1/(x^2*(a + b*x)), x]", //
        "-(1/(a*x)) - (b*Log[x])/a^2 + (b*Log[a + b*x])/a^2", //
        46);
  }

  // {46}
  public void test0105() {
    check( //
        "Integrate[1/(x^3*(a + b*x)), x]", //
        "-1/(2*a*x^2) + b/(a^2*x) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x])/a^3", //
        46);
  }

  // {46}
  public void test0106() {
    check( //
        "Integrate[1/(x^4*(a + b*x)), x]", //
        "-1/(3*a*x^3) + b/(2*a^2*x^2) - b^2/(a^3*x) - (b^3*Log[x])/a^4 + (b^3*Log[a + b*x])/a^4", //
        46);
  }

  // {46}
  public void test0107() {
    check( //
        "Integrate[1/(x^5*(a + b*x)), x]", //
        "-1/(4*a*x^4) + b/(3*a^2*x^3) - b^2/(2*a^3*x^2) + b^3/(a^4*x) + (b^4*Log[x])/a^5 - (b^4*Log[a + b*x])/a^5", //
        46);
  }

  // {45}
  public void test0108() {
    check( //
        "Integrate[x^6/(a + b*x)^2, x]", //
        "(5*a^4*x)/b^6 - (2*a^3*x^2)/b^5 + (a^2*x^3)/b^4 - (a*x^4)/(2*b^3) + x^5/(5*b^2) - a^6/(b^7*(a + b*x)) - (6*a^5*Log[a + b*x])/b^7", //
        45);
  }

  // {45}
  public void test0109() {
    check( //
        "Integrate[x^5/(a + b*x)^2, x]", //
        "(-4*a^3*x)/b^5 + (3*a^2*x^2)/(2*b^4) - (2*a*x^3)/(3*b^3) + x^4/(4*b^2) + a^5/(b^6*(a + b*x)) + (5*a^4*Log[a + b*x])/b^6", //
        45);
  }

  // {45}
  public void test0110() {
    check( //
        "Integrate[x^4/(a + b*x)^2, x]", //
        "(3*a^2*x)/b^4 - (a*x^2)/b^3 + x^3/(3*b^2) - a^4/(b^5*(a + b*x)) - (4*a^3*Log[a + b*x])/b^5", //
        45);
  }

  // {45}
  public void test0111() {
    check( //
        "Integrate[x^3/(a + b*x)^2, x]", //
        "(-2*a*x)/b^3 + x^2/(2*b^2) + a^3/(b^4*(a + b*x)) + (3*a^2*Log[a + b*x])/b^4", //
        45);
  }

  // {45}
  public void test0112() {
    check( //
        "Integrate[x^2/(a + b*x)^2, x]", //
        "x/b^2 - a^2/(b^3*(a + b*x)) - (2*a*Log[a + b*x])/b^3", //
        45);
  }

  // {45}
  public void test0113() {
    check( //
        "Integrate[x/(a + b*x)^2, x]", //
        "a/(b^2*(a + b*x)) + Log[a + b*x]/b^2", //
        45);
  }

  // {46}
  public void test0114() {
    check( //
        "Integrate[1/(x*(a + b*x)^2), x]", //
        "1/(a*(a + b*x)) + Log[x]/a^2 - Log[a + b*x]/a^2", //
        46);
  }

  // {46}
  public void test0115() {
    check( //
        "Integrate[1/(x^2*(a + b*x)^2), x]", //
        "-(1/(a^2*x)) - b/(a^2*(a + b*x)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x])/a^3", //
        46);
  }

  // {46}
  public void test0116() {
    check( //
        "Integrate[1/(x^3*(a + b*x)^2), x]", //
        "-1/(2*a^2*x^2) + (2*b)/(a^3*x) + b^2/(a^3*(a + b*x)) + (3*b^2*Log[x])/a^4 - (3*b^2*Log[a + b*x])/a^4", //
        46);
  }

  // {46}
  public void test0117() {
    check( //
        "Integrate[1/(x^4*(a + b*x)^2), x]", //
        "-1/(3*a^2*x^3) + b/(a^3*x^2) - (3*b^2)/(a^4*x) - b^3/(a^4*(a + b*x)) - (4*b^3*Log[x])/a^5 + (4*b^3*Log[a + b*x])/a^5", //
        46);
  }

  // {46}
  public void test0118() {
    check( //
        "Integrate[1/(x^5*(a + b*x)^2), x]", //
        "-1/(4*a^2*x^4) + (2*b)/(3*a^3*x^3) - (3*b^2)/(2*a^4*x^2) + (4*b^3)/(a^5*x) + b^4/(a^5*(a + b*x)) + (5*b^4*Log[x])/a^6 - (5*b^4*Log[a + b*x])/a^6", //
        46);
  }

  // {45}
  public void test0119() {
    check( //
        "Integrate[x^7/(a + b*x)^3, x]", //
        "(15*a^4*x)/b^7 - (5*a^3*x^2)/b^6 + (2*a^2*x^3)/b^5 - (3*a*x^4)/(4*b^4) + x^5/(5*b^3) + a^7/(2*b^8*(a + b*x)^2) - (7*a^6)/(b^8*(a + b*x)) - (21*a^5*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0120() {
    check( //
        "Integrate[x^6/(a + b*x)^3, x]", //
        "(-10*a^3*x)/b^6 + (3*a^2*x^2)/b^5 - (a*x^3)/b^4 + x^4/(4*b^3) - a^6/(2*b^7*(a + b*x)^2) + (6*a^5)/(b^7*(a + b*x)) + (15*a^4*Log[a + b*x])/b^7", //
        45);
  }

  // {45}
  public void test0121() {
    check( //
        "Integrate[x^5/(a + b*x)^3, x]", //
        "(6*a^2*x)/b^5 - (3*a*x^2)/(2*b^4) + x^3/(3*b^3) + a^5/(2*b^6*(a + b*x)^2) - (5*a^4)/(b^6*(a + b*x)) - (10*a^3*Log[a + b*x])/b^6", //
        45);
  }

  // {45}
  public void test0122() {
    check( //
        "Integrate[x^4/(a + b*x)^3, x]", //
        "(-3*a*x)/b^4 + x^2/(2*b^3) - a^4/(2*b^5*(a + b*x)^2) + (4*a^3)/(b^5*(a + b*x)) + (6*a^2*Log[a + b*x])/b^5", //
        45);
  }

  // {45}
  public void test0123() {
    check( //
        "Integrate[x^3/(a + b*x)^3, x]", //
        "x/b^3 + a^3/(2*b^4*(a + b*x)^2) - (3*a^2)/(b^4*(a + b*x)) - (3*a*Log[a + b*x])/b^4", //
        45);
  }

  // {45}
  public void test0124() {
    check( //
        "Integrate[x^2/(a + b*x)^3, x]", //
        "-a^2/(2*b^3*(a + b*x)^2) + (2*a)/(b^3*(a + b*x)) + Log[a + b*x]/b^3", //
        45);
  }

  // {46}
  public void test0125() {
    check( //
        "Integrate[1/(x*(a + b*x)^3), x]", //
        "1/(2*a*(a + b*x)^2) + 1/(a^2*(a + b*x)) + Log[x]/a^3 - Log[a + b*x]/a^3", //
        46);
  }

  // {46}
  public void test0126() {
    check( //
        "Integrate[1/(x^2*(a + b*x)^3), x]", //
        "-(1/(a^3*x)) - b/(2*a^2*(a + b*x)^2) - (2*b)/(a^3*(a + b*x)) - (3*b*Log[x])/a^4 + (3*b*Log[a + b*x])/a^4", //
        46);
  }

  // {46}
  public void test0127() {
    check( //
        "Integrate[1/(x^3*(a + b*x)^3), x]", //
        "-1/(2*a^3*x^2) + (3*b)/(a^4*x) + b^2/(2*a^3*(a + b*x)^2) + (3*b^2)/(a^4*(a + b*x)) + (6*b^2*Log[x])/a^5 - (6*b^2*Log[a + b*x])/a^5", //
        46);
  }

  // {46}
  public void test0128() {
    check( //
        "Integrate[1/(x^4*(a + b*x)^3), x]", //
        "-1/(3*a^3*x^3) + (3*b)/(2*a^4*x^2) - (6*b^2)/(a^5*x) - b^3/(2*a^4*(a + b*x)^2) - (4*b^3)/(a^5*(a + b*x)) - (10*b^3*Log[x])/a^6 + (10*b^3*Log[a + b*x])/a^6", //
        46);
  }

  // {46}
  public void test0129() {
    check( //
        "Integrate[1/(x^5*(a + b*x)^3), x]", //
        "-1/(4*a^3*x^4) + b/(a^4*x^3) - (3*b^2)/(a^5*x^2) + (10*b^3)/(a^6*x) + b^4/(2*a^5*(a + b*x)^2) + (5*b^4)/(a^6*(a + b*x)) + (15*b^4*Log[x])/a^7 - (15*b^4*Log[a + b*x])/a^7", //
        46);
  }

  // {45}
  public void test0130() {
    check( //
        "Integrate[x^8/(a + b*x)^4, x]", //
        "(35*a^4*x)/b^8 - (10*a^3*x^2)/b^7 + (10*a^2*x^3)/(3*b^6) - (a*x^4)/b^5 + x^5/(5*b^4) - a^8/(3*b^9*(a + b*x)^3) + (4*a^7)/(b^9*(a + b*x)^2) - (28*a^6)/(b^9*(a + b*x)) - (56*a^5*Log[a + b*x])/b^9", //
        45);
  }

  // {45}
  public void test0131() {
    check( //
        "Integrate[x^7/(a + b*x)^4, x]", //
        "(-20*a^3*x)/b^7 + (5*a^2*x^2)/b^6 - (4*a*x^3)/(3*b^5) + x^4/(4*b^4) + a^7/(3*b^8*(a + b*x)^3) - (7*a^6)/(2*b^8*(a + b*x)^2) + (21*a^5)/(b^8*(a + b*x)) + (35*a^4*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0132() {
    check( //
        "Integrate[x^6/(a + b*x)^4, x]", //
        "(10*a^2*x)/b^6 - (2*a*x^2)/b^5 + x^3/(3*b^4) - a^6/(3*b^7*(a + b*x)^3) + (3*a^5)/(b^7*(a + b*x)^2) - (15*a^4)/(b^7*(a + b*x)) - (20*a^3*Log[a + b*x])/b^7", //
        45);
  }

  // {45}
  public void test0133() {
    check( //
        "Integrate[x^5/(a + b*x)^4, x]", //
        "(-4*a*x)/b^5 + x^2/(2*b^4) + a^5/(3*b^6*(a + b*x)^3) - (5*a^4)/(2*b^6*(a + b*x)^2) + (10*a^3)/(b^6*(a + b*x)) + (10*a^2*Log[a + b*x])/b^6", //
        45);
  }

  // {45}
  public void test0134() {
    check( //
        "Integrate[x^4/(a + b*x)^4, x]", //
        "x/b^4 - a^4/(3*b^5*(a + b*x)^3) + (2*a^3)/(b^5*(a + b*x)^2) - (6*a^2)/(b^5*(a + b*x)) - (4*a*Log[a + b*x])/b^5", //
        45);
  }

  // {45}
  public void test0135() {
    check( //
        "Integrate[x^3/(a + b*x)^4, x]", //
        "a^3/(3*b^4*(a + b*x)^3) - (3*a^2)/(2*b^4*(a + b*x)^2) + (3*a)/(b^4*(a + b*x)) + Log[a + b*x]/b^4", //
        45);
  }

  // {45}
  public void test0136() {
    check( //
        "Integrate[x/(a + b*x)^4, x]", //
        "a/(3*b^2*(a + b*x)^3) - 1/(2*b^2*(a + b*x)^2)", //
        45);
  }

  // {46}
  public void test0137() {
    check( //
        "Integrate[1/(x*(a + b*x)^4), x]", //
        "1/(3*a*(a + b*x)^3) + 1/(2*a^2*(a + b*x)^2) + 1/(a^3*(a + b*x)) + Log[x]/a^4 - Log[a + b*x]/a^4", //
        46);
  }

  // {46}
  public void test0138() {
    check( //
        "Integrate[1/(x^2*(a + b*x)^4), x]", //
        "-(1/(a^4*x)) - b/(3*a^2*(a + b*x)^3) - b/(a^3*(a + b*x)^2) - (3*b)/(a^4*(a + b*x)) - (4*b*Log[x])/a^5 + (4*b*Log[a + b*x])/a^5", //
        46);
  }

  // {46}
  public void test0139() {
    check( //
        "Integrate[1/(x^3*(a + b*x)^4), x]", //
        "-1/(2*a^4*x^2) + (4*b)/(a^5*x) + b^2/(3*a^3*(a + b*x)^3) + (3*b^2)/(2*a^4*(a + b*x)^2) + (6*b^2)/(a^5*(a + b*x)) + (10*b^2*Log[x])/a^6 - (10*b^2*Log[a + b*x])/a^6", //
        46);
  }

  // {46}
  public void test0140() {
    check( //
        "Integrate[1/(x^4*(a + b*x)^4), x]", //
        "-1/(3*a^4*x^3) + (2*b)/(a^5*x^2) - (10*b^2)/(a^6*x) - b^3/(3*a^4*(a + b*x)^3) - (2*b^3)/(a^5*(a + b*x)^2) - (10*b^3)/(a^6*(a + b*x)) - (20*b^3*Log[x])/a^7 + (20*b^3*Log[a + b*x])/a^7", //
        46);
  }

  // {46}
  public void test0141() {
    check( //
        "Integrate[1/(x^5*(a + b*x)^4), x]", //
        "-1/(4*a^4*x^4) + (4*b)/(3*a^5*x^3) - (5*b^2)/(a^6*x^2) + (20*b^3)/(a^7*x) + b^4/(3*a^5*(a + b*x)^3) + (5*b^4)/(2*a^6*(a + b*x)^2) + (15*b^4)/(a^7*(a + b*x)) + (35*b^4*Log[x])/a^8 - (35*b^4*Log[a + b*x])/a^8", //
        46);
  }

  // {45}
  public void test0142() {
    check( //
        "Integrate[x^10/(a + b*x)^7, x]", //
        "(-84*a^3*x)/b^10 + (14*a^2*x^2)/b^9 - (7*a*x^3)/(3*b^8) + x^4/(4*b^7) - a^10/(6*b^11*(a + b*x)^6) + (2*a^9)/(b^11*(a + b*x)^5) - (45*a^8)/(4*b^11*(a + b*x)^4) + (40*a^7)/(b^11*(a + b*x)^3) - (105*a^6)/(b^11*(a + b*x)^2) + (252*a^5)/(b^11*(a + b*x)) + (210*a^4*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0143() {
    check( //
        "Integrate[x^9/(a + b*x)^7, x]", //
        "(28*a^2*x)/b^9 - (7*a*x^2)/(2*b^8) + x^3/(3*b^7) + a^9/(6*b^10*(a + b*x)^6) - (9*a^8)/(5*b^10*(a + b*x)^5) + (9*a^7)/(b^10*(a + b*x)^4) - (28*a^6)/(b^10*(a + b*x)^3) + (63*a^5)/(b^10*(a + b*x)^2) - (126*a^4)/(b^10*(a + b*x)) - (84*a^3*Log[a + b*x])/b^10", //
        45);
  }

  // {45}
  public void test0144() {
    check( //
        "Integrate[x^8/(a + b*x)^7, x]", //
        "(-7*a*x)/b^8 + x^2/(2*b^7) - a^8/(6*b^9*(a + b*x)^6) + (8*a^7)/(5*b^9*(a + b*x)^5) - (7*a^6)/(b^9*(a + b*x)^4) + (56*a^5)/(3*b^9*(a + b*x)^3) - (35*a^4)/(b^9*(a + b*x)^2) + (56*a^3)/(b^9*(a + b*x)) + (28*a^2*Log[a + b*x])/b^9", //
        45);
  }

  // {45}
  public void test0145() {
    check( //
        "Integrate[x^7/(a + b*x)^7, x]", //
        "x/b^7 + a^7/(6*b^8*(a + b*x)^6) - (7*a^6)/(5*b^8*(a + b*x)^5) + (21*a^5)/(4*b^8*(a + b*x)^4) - (35*a^4)/(3*b^8*(a + b*x)^3) + (35*a^3)/(2*b^8*(a + b*x)^2) - (21*a^2)/(b^8*(a + b*x)) - (7*a*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0146() {
    check( //
        "Integrate[x^6/(a + b*x)^7, x]", //
        "-a^6/(6*b^7*(a + b*x)^6) + (6*a^5)/(5*b^7*(a + b*x)^5) - (15*a^4)/(4*b^7*(a + b*x)^4) + (20*a^3)/(3*b^7*(a + b*x)^3) - (15*a^2)/(2*b^7*(a + b*x)^2) + (6*a)/(b^7*(a + b*x)) + Log[a + b*x]/b^7", //
        45);
  }

  // {47, 37}
  public void test0147() {
    check( //
        "Integrate[x^4/(a + b*x)^7, x]", //
        "x^5/(6*a*(a + b*x)^6) + x^5/(30*a^2*(a + b*x)^5)", //
        47,
        37);
  }

  // {45}
  public void test0148() {
    check( //
        "Integrate[x^2/(a + b*x)^7, x]", //
        "-a^2/(6*b^3*(a + b*x)^6) + (2*a)/(5*b^3*(a + b*x)^5) - 1/(4*b^3*(a + b*x)^4)", //
        45);
  }

  // {45}
  public void test0149() {
    check( //
        "Integrate[x/(a + b*x)^7, x]", //
        "a/(6*b^2*(a + b*x)^6) - 1/(5*b^2*(a + b*x)^5)", //
        45);
  }

  // {46}
  public void test0150() {
    check( //
        "Integrate[1/(x*(a + b*x)^7), x]", //
        "1/(6*a*(a + b*x)^6) + 1/(5*a^2*(a + b*x)^5) + 1/(4*a^3*(a + b*x)^4) + 1/(3*a^4*(a + b*x)^3) + 1/(2*a^5*(a + b*x)^2) + 1/(a^6*(a + b*x)) + Log[x]/a^7 - Log[a + b*x]/a^7", //
        46);
  }

  // {46}
  public void test0151() {
    check( //
        "Integrate[1/(x^2*(a + b*x)^7), x]", //
        "-(1/(a^7*x)) - b/(6*a^2*(a + b*x)^6) - (2*b)/(5*a^3*(a + b*x)^5) - (3*b)/(4*a^4*(a + b*x)^4) - (4*b)/(3*a^5*(a + b*x)^3) - (5*b)/(2*a^6*(a + b*x)^2) - (6*b)/(a^7*(a + b*x)) - (7*b*Log[x])/a^8 + (7*b*Log[a + b*x])/a^8", //
        46);
  }

  // {46}
  public void test0152() {
    check( //
        "Integrate[1/(x^3*(a + b*x)^7), x]", //
        "-1/(2*a^7*x^2) + (7*b)/(a^8*x) + b^2/(6*a^3*(a + b*x)^6) + (3*b^2)/(5*a^4*(a + b*x)^5) + (3*b^2)/(2*a^5*(a + b*x)^4) + (10*b^2)/(3*a^6*(a + b*x)^3) + (15*b^2)/(2*a^7*(a + b*x)^2) + (21*b^2)/(a^8*(a + b*x)) + (28*b^2*Log[x])/a^9 - (28*b^2*Log[a + b*x])/a^9", //
        46);
  }

  // {46}
  public void test0153() {
    check( //
        "Integrate[1/(x^4*(a + b*x)^7), x]", //
        "-1/(3*a^7*x^3) + (7*b)/(2*a^8*x^2) - (28*b^2)/(a^9*x) - b^3/(6*a^4*(a + b*x)^6) - (4*b^3)/(5*a^5*(a + b*x)^5) - (5*b^3)/(2*a^6*(a + b*x)^4) - (20*b^3)/(3*a^7*(a + b*x)^3) - (35*b^3)/(2*a^8*(a + b*x)^2) - (56*b^3)/(a^9*(a + b*x)) - (84*b^3*Log[x])/a^10 + (84*b^3*Log[a + b*x])/a^10", //
        46);
  }

  // {45}
  public void test0154() {
    check( //
        "Integrate[x^12/(a + b*x)^10, x]", //
        "(55*a^2*x)/b^12 - (5*a*x^2)/b^11 + x^3/(3*b^10) - a^12/(9*b^13*(a + b*x)^9) + (3*a^11)/(2*b^13*(a + b*x)^8) - (66*a^10)/(7*b^13*(a + b*x)^7) + (110*a^9)/(3*b^13*(a + b*x)^6) - (99*a^8)/(b^13*(a + b*x)^5) + (198*a^7)/(b^13*(a + b*x)^4) - (308*a^6)/(b^13*(a + b*x)^3) + (396*a^5)/(b^13*(a + b*x)^2) - (495*a^4)/(b^13*(a + b*x)) - (220*a^3*Log[a + b*x])/b^13", //
        45);
  }

  // {45}
  public void test0155() {
    check( //
        "Integrate[x^11/(a + b*x)^10, x]", //
        "(-10*a*x)/b^11 + x^2/(2*b^10) + a^11/(9*b^12*(a + b*x)^9) - (11*a^10)/(8*b^12*(a + b*x)^8) + (55*a^9)/(7*b^12*(a + b*x)^7) - (55*a^8)/(2*b^12*(a + b*x)^6) + (66*a^7)/(b^12*(a + b*x)^5) - (231*a^6)/(2*b^12*(a + b*x)^4) + (154*a^5)/(b^12*(a + b*x)^3) - (165*a^4)/(b^12*(a + b*x)^2) + (165*a^3)/(b^12*(a + b*x)) + (55*a^2*Log[a + b*x])/b^12", //
        45);
  }

  // {45}
  public void test0156() {
    check( //
        "Integrate[x^10/(a + b*x)^10, x]", //
        "x/b^10 - a^10/(9*b^11*(a + b*x)^9) + (5*a^9)/(4*b^11*(a + b*x)^8) - (45*a^8)/(7*b^11*(a + b*x)^7) + (20*a^7)/(b^11*(a + b*x)^6) - (42*a^6)/(b^11*(a + b*x)^5) + (63*a^5)/(b^11*(a + b*x)^4) - (70*a^4)/(b^11*(a + b*x)^3) + (60*a^3)/(b^11*(a + b*x)^2) - (45*a^2)/(b^11*(a + b*x)) - (10*a*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0157() {
    check( //
        "Integrate[x^9/(a + b*x)^10, x]", //
        "a^9/(9*b^10*(a + b*x)^9) - (9*a^8)/(8*b^10*(a + b*x)^8) + (36*a^7)/(7*b^10*(a + b*x)^7) - (14*a^6)/(b^10*(a + b*x)^6) + (126*a^5)/(5*b^10*(a + b*x)^5) - (63*a^4)/(2*b^10*(a + b*x)^4) + (28*a^3)/(b^10*(a + b*x)^3) - (18*a^2)/(b^10*(a + b*x)^2) + (9*a)/(b^10*(a + b*x)) + Log[a + b*x]/b^10", //
        45);
  }

  // {47, 37}
  public void test0158() {
    check( //
        "Integrate[x^7/(a + b*x)^10, x]", //
        "x^8/(9*a*(a + b*x)^9) + x^8/(72*a^2*(a + b*x)^8)", //
        47,
        37);
  }

  // {45}
  public void test0159() {
    check( //
        "Integrate[x^4/(a + b*x)^10, x]", //
        "-a^4/(9*b^5*(a + b*x)^9) + a^3/(2*b^5*(a + b*x)^8) - (6*a^2)/(7*b^5*(a + b*x)^7) + (2*a)/(3*b^5*(a + b*x)^6) - 1/(5*b^5*(a + b*x)^5)", //
        45);
  }

  // {45}
  public void test0160() {
    check( //
        "Integrate[x^3/(a + b*x)^10, x]", //
        "a^3/(9*b^4*(a + b*x)^9) - (3*a^2)/(8*b^4*(a + b*x)^8) + (3*a)/(7*b^4*(a + b*x)^7) - 1/(6*b^4*(a + b*x)^6)", //
        45);
  }

  // {45}
  public void test0161() {
    check( //
        "Integrate[x^2/(a + b*x)^10, x]", //
        "-a^2/(9*b^3*(a + b*x)^9) + a/(4*b^3*(a + b*x)^8) - 1/(7*b^3*(a + b*x)^7)", //
        45);
  }

  // {45}
  public void test0162() {
    check( //
        "Integrate[x/(a + b*x)^10, x]", //
        "a/(9*b^2*(a + b*x)^9) - 1/(8*b^2*(a + b*x)^8)", //
        45);
  }

  // {46}
  public void test0163() {
    check( //
        "Integrate[1/(x*(a + b*x)^10), x]", //
        "1/(9*a*(a + b*x)^9) + 1/(8*a^2*(a + b*x)^8) + 1/(7*a^3*(a + b*x)^7) + 1/(6*a^4*(a + b*x)^6) + 1/(5*a^5*(a + b*x)^5) + 1/(4*a^6*(a + b*x)^4) + 1/(3*a^7*(a + b*x)^3) + 1/(2*a^8*(a + b*x)^2) + 1/(a^9*(a + b*x)) + Log[x]/a^10 - Log[a + b*x]/a^10", //
        46);
  }

  // {46}
  public void test0164() {
    check( //
        "Integrate[1/(x^2*(a + b*x)^10), x]", //
        "-(1/(a^10*x)) - b/(9*a^2*(a + b*x)^9) - b/(4*a^3*(a + b*x)^8) - (3*b)/(7*a^4*(a + b*x)^7) - (2*b)/(3*a^5*(a + b*x)^6) - b/(a^6*(a + b*x)^5) - (3*b)/(2*a^7*(a + b*x)^4) - (7*b)/(3*a^8*(a + b*x)^3) - (4*b)/(a^9*(a + b*x)^2) - (9*b)/(a^10*(a + b*x)) - (10*b*Log[x])/a^11 + (10*b*Log[a + b*x])/a^11", //
        46);
  }

  // {46}
  public void test0165() {
    check( //
        "Integrate[1/(x^3*(a + b*x)^10), x]", //
        "-1/(2*a^10*x^2) + (10*b)/(a^11*x) + b^2/(9*a^3*(a + b*x)^9) + (3*b^2)/(8*a^4*(a + b*x)^8) + (6*b^2)/(7*a^5*(a + b*x)^7) + (5*b^2)/(3*a^6*(a + b*x)^6) + (3*b^2)/(a^7*(a + b*x)^5) + (21*b^2)/(4*a^8*(a + b*x)^4) + (28*b^2)/(3*a^9*(a + b*x)^3) + (18*b^2)/(a^10*(a + b*x)^2) + (45*b^2)/(a^11*(a + b*x)) + (55*b^2*Log[x])/a^12 - (55*b^2*Log[a + b*x])/a^12", //
        46);
  }

  // {46}
  public void test0166() {
    check( //
        "Integrate[1/(x^4*(a + b*x)^10), x]", //
        "-1/(3*a^10*x^3) + (5*b)/(a^11*x^2) - (55*b^2)/(a^12*x) - b^3/(9*a^4*(a + b*x)^9) - b^3/(2*a^5*(a + b*x)^8) - (10*b^3)/(7*a^6*(a + b*x)^7) - (10*b^3)/(3*a^7*(a + b*x)^6) - (7*b^3)/(a^8*(a + b*x)^5) - (14*b^3)/(a^9*(a + b*x)^4) - (28*b^3)/(a^10*(a + b*x)^3) - (60*b^3)/(a^11*(a + b*x)^2) - (165*b^3)/(a^12*(a + b*x)) - (220*b^3*Log[x])/a^13 + (220*b^3*Log[a + b*x])/a^13", //
        46);
  }

  // {45}
  public void test0167() {
    check( //
        "Integrate[(a + b*x)^12/x^10, x]", //
        "-a^12/(9*x^9) - (3*a^11*b)/(2*x^8) - (66*a^10*b^2)/(7*x^7) - (110*a^9*b^3)/(3*x^6) - (99*a^8*b^4)/x^5 - (198*a^7*b^5)/x^4 - (308*a^6*b^6)/x^3 - (396*a^5*b^7)/x^2 - (495*a^4*b^8)/x + 66*a^2*b^10*x + 6*a*b^11*x^2 + (b^12*x^3)/3 + 220*a^3*b^9*Log[x]", //
        45);
  }

  // {45}
  public void test0168() {
    check( //
        "Integrate[(a + b*x)^11/x^10, x]", //
        "-a^11/(9*x^9) - (11*a^10*b)/(8*x^8) - (55*a^9*b^2)/(7*x^7) - (55*a^8*b^3)/(2*x^6) - (66*a^7*b^4)/x^5 - (231*a^6*b^5)/(2*x^4) - (154*a^5*b^6)/x^3 - (165*a^4*b^7)/x^2 - (165*a^3*b^8)/x + 11*a*b^10*x + (b^11*x^2)/2 + 55*a^2*b^9*Log[x]", //
        45);
  }

  // {45}
  public void test0169() {
    check( //
        "Integrate[(a + b*x)^10/x^10, x]", //
        "-a^10/(9*x^9) - (5*a^9*b)/(4*x^8) - (45*a^8*b^2)/(7*x^7) - (20*a^7*b^3)/x^6 - (42*a^6*b^4)/x^5 - (63*a^5*b^5)/x^4 - (70*a^4*b^6)/x^3 - (60*a^3*b^7)/x^2 - (45*a^2*b^8)/x + b^10*x + 10*a*b^9*Log[x]", //
        45);
  }

  // {45}
  public void test0170() {
    check( //
        "Integrate[(a + b*x)^9/x^10, x]", //
        "-a^9/(9*x^9) - (9*a^8*b)/(8*x^8) - (36*a^7*b^2)/(7*x^7) - (14*a^6*b^3)/x^6 - (126*a^5*b^4)/(5*x^5) - (63*a^4*b^5)/(2*x^4) - (28*a^3*b^6)/x^3 - (18*a^2*b^7)/x^2 - (9*a*b^8)/x + b^9*Log[x]", //
        45);
  }

  // {47, 37}
  public void test0171() {
    check( //
        "Integrate[(a + b*x)^7/x^10, x]", //
        "-(a + b*x)^8/(9*a*x^9) + (b*(a + b*x)^8)/(72*a^2*x^8)", //
        47,
        37);
  }

  // {45}
  public void test0172() {
    check( //
        "Integrate[(a + b*x)^5/x^10, x]", //
        "-a^5/(9*x^9) - (5*a^4*b)/(8*x^8) - (10*a^3*b^2)/(7*x^7) - (5*a^2*b^3)/(3*x^6) - (a*b^4)/x^5 - b^5/(4*x^4)", //
        45);
  }

  // {45}
  public void test0173() {
    check( //
        "Integrate[(a + b*x)^4/x^10, x]", //
        "-a^4/(9*x^9) - (a^3*b)/(2*x^8) - (6*a^2*b^2)/(7*x^7) - (2*a*b^3)/(3*x^6) - b^4/(5*x^5)", //
        45);
  }

  // {45}
  public void test0174() {
    check( //
        "Integrate[(a + b*x)^3/x^10, x]", //
        "-a^3/(9*x^9) - (3*a^2*b)/(8*x^8) - (3*a*b^2)/(7*x^7) - b^3/(6*x^6)", //
        45);
  }

  // {45}
  public void test0175() {
    check( //
        "Integrate[(a + b*x)^2/x^10, x]", //
        "-a^2/(9*x^9) - (a*b)/(4*x^8) - b^2/(7*x^7)", //
        45);
  }

  // {45}
  public void test0176() {
    check( //
        "Integrate[(a + b*x)/x^10, x]", //
        "-a/(9*x^9) - b/(8*x^8)", //
        45);
  }

  // {46}
  public void test0177() {
    check( //
        "Integrate[1/(x^10*(a + b*x)), x]", //
        "-1/(9*a*x^9) + b/(8*a^2*x^8) - b^2/(7*a^3*x^7) + b^3/(6*a^4*x^6) - b^4/(5*a^5*x^5) + b^5/(4*a^6*x^4) - b^6/(3*a^7*x^3) + b^7/(2*a^8*x^2) - b^8/(a^9*x) - (b^9*Log[x])/a^10 + (b^9*Log[a + b*x])/a^10", //
        46);
  }

  // {46}
  public void test0178() {
    check( //
        "Integrate[1/(x^10*(a + b*x)^2), x]", //
        "-1/(9*a^2*x^9) + b/(4*a^3*x^8) - (3*b^2)/(7*a^4*x^7) + (2*b^3)/(3*a^5*x^6) - b^4/(a^6*x^5) + (3*b^5)/(2*a^7*x^4) - (7*b^6)/(3*a^8*x^3) + (4*b^7)/(a^9*x^2) - (9*b^8)/(a^10*x) - b^9/(a^10*(a + b*x)) - (10*b^9*Log[x])/a^11 + (10*b^9*Log[a + b*x])/a^11", //
        46);
  }

  // {46}
  public void test0179() {
    check( //
        "Integrate[1/(x^10*(a + b*x)^3), x]", //
        "-1/(9*a^3*x^9) + (3*b)/(8*a^4*x^8) - (6*b^2)/(7*a^5*x^7) + (5*b^3)/(3*a^6*x^6) - (3*b^4)/(a^7*x^5) + (21*b^5)/(4*a^8*x^4) - (28*b^6)/(3*a^9*x^3) + (18*b^7)/(a^10*x^2) - (45*b^8)/(a^11*x) - b^9/(2*a^10*(a + b*x)^2) - (10*b^9)/(a^11*(a + b*x)) - (55*b^9*Log[x])/a^12 + (55*b^9*Log[a + b*x])/a^12", //
        46);
  }

  // {46}
  public void test0180() {
    check( //
        "Integrate[1/(x^2*(4 + 6*x)), x]", //
        "-1/(4*x) - (3*Log[x])/8 + (3*Log[2 + 3*x])/8", //
        46);
  }

  // {46}
  public void test0181() {
    check( //
        "Integrate[1/(x^3*(4 + 6*x)), x]", //
        "-1/(8*x^2) + 3/(8*x) + (9*Log[x])/16 - (9*Log[2 + 3*x])/16", //
        46);
  }

  // {46}
  public void test0182() {
    check( //
        "Integrate[1/(x^4*(4 + 6*x)), x]", //
        "-1/(12*x^3) + 3/(16*x^2) - 9/(16*x) - (27*Log[x])/32 + (27*Log[2 + 3*x])/32", //
        46);
  }

  // {46}
  public void test0183() {
    check( //
        "Integrate[1/(x^5*(4 + 6*x)), x]", //
        "-1/(16*x^4) + 1/(8*x^3) - 9/(32*x^2) + 27/(32*x) + (81*Log[x])/64 - (81*Log[2 + 3*x])/64", //
        46);
  }

  // {46}
  public void test0184() {
    check( //
        "Integrate[1/(x*(4 + 6*x)^2), x]", //
        "1/(8*(2 + 3*x)) + Log[x]/16 - Log[2 + 3*x]/16", //
        46);
  }

  // {46}
  public void test0185() {
    check( //
        "Integrate[1/(x^2*(4 + 6*x)^2), x]", //
        "-1/(16*x) - 3/(16*(2 + 3*x)) - (3*Log[x])/16 + (3*Log[2 + 3*x])/16", //
        46);
  }

  // {46}
  public void test0186() {
    check( //
        "Integrate[1/(x^3*(4 + 6*x)^2), x]", //
        "-1/(32*x^2) + 3/(16*x) + 9/(32*(2 + 3*x)) + (27*Log[x])/64 - (27*Log[2 + 3*x])/64", //
        46);
  }

  // {46}
  public void test0187() {
    check( //
        "Integrate[1/(x^4*(4 + 6*x)^2), x]", //
        "-1/(48*x^3) + 3/(32*x^2) - 27/(64*x) - 27/(64*(2 + 3*x)) - (27*Log[x])/32 + (27*Log[2 + 3*x])/32", //
        46);
  }

  // {46}
  public void test0188() {
    check( //
        "Integrate[1/(x^5*(4 + 6*x)^2), x]", //
        "-1/(64*x^4) + 1/(16*x^3) - 27/(128*x^2) + 27/(32*x) + 81/(128*(2 + 3*x)) + (405*Log[x])/256 - (405*Log[2 + 3*x])/256", //
        46);
  }

  // {46}
  public void test0189() {
    check( //
        "Integrate[1/(x*(4 + 6*x)^3), x]", //
        "1/(32*(2 + 3*x)^2) + 1/(32*(2 + 3*x)) + Log[x]/64 - Log[2 + 3*x]/64", //
        46);
  }

  // {46}
  public void test0190() {
    check( //
        "Integrate[1/(x^2*(4 + 6*x)^3), x]", //
        "-1/(64*x) - 3/(64*(2 + 3*x)^2) - 3/(32*(2 + 3*x)) - (9*Log[x])/128 + (9*Log[2 + 3*x])/128", //
        46);
  }

  // {46}
  public void test0191() {
    check( //
        "Integrate[1/(x^3*(4 + 6*x)^3), x]", //
        "-1/(128*x^2) + 9/(128*x) + 9/(128*(2 + 3*x)^2) + 27/(128*(2 + 3*x)) + (27*Log[x])/128 - (27*Log[2 + 3*x])/128", //
        46);
  }

  // {46}
  public void test0192() {
    check( //
        "Integrate[1/(x^4*(4 + 6*x)^3), x]", //
        "-1/(192*x^3) + 9/(256*x^2) - 27/(128*x) - 27/(256*(2 + 3*x)^2) - 27/(64*(2 + 3*x)) - (135*Log[x])/256 + (135*Log[2 + 3*x])/256", //
        46);
  }

  // {46}
  public void test0193() {
    check( //
        "Integrate[1/(x^5*(4 + 6*x)^3), x]", //
        "-1/(256*x^4) + 3/(128*x^3) - 27/(256*x^2) + 135/(256*x) + 81/(512*(2 + 3*x)^2) + 405/(512*(2 + 3*x)) + (1215*Log[x])/1024 - (1215*Log[2 + 3*x])/1024", //
        46);
  }

  // {46}
  public void test0194() {
    check( //
        "Integrate[1/(x^2*(1 + b*x)), x]", //
        "-x^(-1) - b*Log[x] + b*Log[1 + b*x]", //
        46);
  }

  // {46}
  public void test0195() {
    check( //
        "Integrate[1/(x^2*(-1 + b*x)), x]", //
        "x^(-1) - b*Log[x] + b*Log[1 - b*x]", //
        46);
  }

  // {45}
  public void test0196() {
    check( //
        "Integrate[x^3*Sqrt[a + b*x], x]", //
        "(-2*a^3*(a + b*x)^(3/2))/(3*b^4) + (6*a^2*(a + b*x)^(5/2))/(5*b^4) - (6*a*(a + b*x)^(7/2))/(7*b^4) + (2*(a + b*x)^(9/2))/(9*b^4)", //
        45);
  }

  // {45}
  public void test0197() {
    check( //
        "Integrate[x^2*Sqrt[a + b*x], x]", //
        "(2*a^2*(a + b*x)^(3/2))/(3*b^3) - (4*a*(a + b*x)^(5/2))/(5*b^3) + (2*(a + b*x)^(7/2))/(7*b^3)", //
        45);
  }

  // {45}
  public void test0198() {
    check( //
        "Integrate[x*Sqrt[a + b*x], x]", //
        "(-2*a*(a + b*x)^(3/2))/(3*b^2) + (2*(a + b*x)^(5/2))/(5*b^2)", //
        45);
  }

  // {45}
  public void test0199() {
    check( //
        "Integrate[x^3*(a + b*x)^(3/2), x]", //
        "(-2*a^3*(a + b*x)^(5/2))/(5*b^4) + (6*a^2*(a + b*x)^(7/2))/(7*b^4) - (2*a*(a + b*x)^(9/2))/(3*b^4) + (2*(a + b*x)^(11/2))/(11*b^4)", //
        45);
  }

  // {45}
  public void test0200() {
    check( //
        "Integrate[x^2*(a + b*x)^(3/2), x]", //
        "(2*a^2*(a + b*x)^(5/2))/(5*b^3) - (4*a*(a + b*x)^(7/2))/(7*b^3) + (2*(a + b*x)^(9/2))/(9*b^3)", //
        45);
  }

  // {45}
  public void test0201() {
    check( //
        "Integrate[x*(a + b*x)^(3/2), x]", //
        "(-2*a*(a + b*x)^(5/2))/(5*b^2) + (2*(a + b*x)^(7/2))/(7*b^2)", //
        45);
  }

  // {45}
  public void test0202() {
    check( //
        "Integrate[x^3*(a + b*x)^(5/2), x]", //
        "(-2*a^3*(a + b*x)^(7/2))/(7*b^4) + (2*a^2*(a + b*x)^(9/2))/(3*b^4) - (6*a*(a + b*x)^(11/2))/(11*b^4) + (2*(a + b*x)^(13/2))/(13*b^4)", //
        45);
  }

  // {45}
  public void test0203() {
    check( //
        "Integrate[x^2*(a + b*x)^(5/2), x]", //
        "(2*a^2*(a + b*x)^(7/2))/(7*b^3) - (4*a*(a + b*x)^(9/2))/(9*b^3) + (2*(a + b*x)^(11/2))/(11*b^3)", //
        45);
  }

  // {45}
  public void test0204() {
    check( //
        "Integrate[x*(a + b*x)^(5/2), x]", //
        "(-2*a*(a + b*x)^(7/2))/(7*b^2) + (2*(a + b*x)^(9/2))/(9*b^2)", //
        45);
  }

  // {45}
  public void test0205() {
    check( //
        "Integrate[x^7*(a + b*x)^(9/2), x]", //
        "(-2*a^7*(a + b*x)^(11/2))/(11*b^8) + (14*a^6*(a + b*x)^(13/2))/(13*b^8) - (14*a^5*(a + b*x)^(15/2))/(5*b^8) + (70*a^4*(a + b*x)^(17/2))/(17*b^8) - (70*a^3*(a + b*x)^(19/2))/(19*b^8) + (2*a^2*(a + b*x)^(21/2))/b^8 - (14*a*(a + b*x)^(23/2))/(23*b^8) + (2*(a + b*x)^(25/2))/(25*b^8)", //
        45);
  }

  // {45}
  public void test0206() {
    check( //
        "Integrate[x^6*(a + b*x)^(9/2), x]", //
        "(2*a^6*(a + b*x)^(11/2))/(11*b^7) - (12*a^5*(a + b*x)^(13/2))/(13*b^7) + (2*a^4*(a + b*x)^(15/2))/b^7 - (40*a^3*(a + b*x)^(17/2))/(17*b^7) + (30*a^2*(a + b*x)^(19/2))/(19*b^7) - (4*a*(a + b*x)^(21/2))/(7*b^7) + (2*(a + b*x)^(23/2))/(23*b^7)", //
        45);
  }

  // {45}
  public void test0207() {
    check( //
        "Integrate[x^5*(a + b*x)^(9/2), x]", //
        "(-2*a^5*(a + b*x)^(11/2))/(11*b^6) + (10*a^4*(a + b*x)^(13/2))/(13*b^6) - (4*a^3*(a + b*x)^(15/2))/(3*b^6) + (20*a^2*(a + b*x)^(17/2))/(17*b^6) - (10*a*(a + b*x)^(19/2))/(19*b^6) + (2*(a + b*x)^(21/2))/(21*b^6)", //
        45);
  }

  // {45}
  public void test0208() {
    check( //
        "Integrate[x^4*(a + b*x)^(9/2), x]", //
        "(2*a^4*(a + b*x)^(11/2))/(11*b^5) - (8*a^3*(a + b*x)^(13/2))/(13*b^5) + (4*a^2*(a + b*x)^(15/2))/(5*b^5) - (8*a*(a + b*x)^(17/2))/(17*b^5) + (2*(a + b*x)^(19/2))/(19*b^5)", //
        45);
  }

  // {45}
  public void test0209() {
    check( //
        "Integrate[x^3*(a + b*x)^(9/2), x]", //
        "(-2*a^3*(a + b*x)^(11/2))/(11*b^4) + (6*a^2*(a + b*x)^(13/2))/(13*b^4) - (2*a*(a + b*x)^(15/2))/(5*b^4) + (2*(a + b*x)^(17/2))/(17*b^4)", //
        45);
  }

  // {45}
  public void test0210() {
    check( //
        "Integrate[x^2*(a + b*x)^(9/2), x]", //
        "(2*a^2*(a + b*x)^(11/2))/(11*b^3) - (4*a*(a + b*x)^(13/2))/(13*b^3) + (2*(a + b*x)^(15/2))/(15*b^3)", //
        45);
  }

  // {45}
  public void test0211() {
    check( //
        "Integrate[x*(a + b*x)^(9/2), x]", //
        "(-2*a*(a + b*x)^(11/2))/(11*b^2) + (2*(a + b*x)^(13/2))/(13*b^2)", //
        45);
  }

  // {45}
  public void test0212() {
    check( //
        "Integrate[x^4/Sqrt[a + b*x], x]", //
        "(2*a^4*Sqrt[a + b*x])/b^5 - (8*a^3*(a + b*x)^(3/2))/(3*b^5) + (12*a^2*(a + b*x)^(5/2))/(5*b^5) - (8*a*(a + b*x)^(7/2))/(7*b^5) + (2*(a + b*x)^(9/2))/(9*b^5)", //
        45);
  }

  // {45}
  public void test0213() {
    check( //
        "Integrate[x^3/Sqrt[a + b*x], x]", //
        "(-2*a^3*Sqrt[a + b*x])/b^4 + (2*a^2*(a + b*x)^(3/2))/b^4 - (6*a*(a + b*x)^(5/2))/(5*b^4) + (2*(a + b*x)^(7/2))/(7*b^4)", //
        45);
  }

  // {45}
  public void test0214() {
    check( //
        "Integrate[x^2/Sqrt[a + b*x], x]", //
        "(2*a^2*Sqrt[a + b*x])/b^3 - (4*a*(a + b*x)^(3/2))/(3*b^3) + (2*(a + b*x)^(5/2))/(5*b^3)", //
        45);
  }

  // {45}
  public void test0215() {
    check( //
        "Integrate[x/Sqrt[a + b*x], x]", //
        "(-2*a*Sqrt[a + b*x])/b^2 + (2*(a + b*x)^(3/2))/(3*b^2)", //
        45);
  }

  // {65, 214}
  public void test0216() {
    check( //
        "Integrate[1/(x*Sqrt[a + b*x]), x]", //
        "(-2*ArcTanh[Sqrt[a + b*x]/Sqrt[a]])/Sqrt[a]", //
        65,
        214);
  }

  // {45}
  public void test0217() {
    check( //
        "Integrate[x^4/(a + b*x)^(3/2), x]", //
        "(-2*a^4)/(b^5*Sqrt[a + b*x]) - (8*a^3*Sqrt[a + b*x])/b^5 + (4*a^2*(a + b*x)^(3/2))/b^5 - (8*a*(a + b*x)^(5/2))/(5*b^5) + (2*(a + b*x)^(7/2))/(7*b^5)", //
        45);
  }

  // {45}
  public void test0218() {
    check( //
        "Integrate[x^3/(a + b*x)^(3/2), x]", //
        "(2*a^3)/(b^4*Sqrt[a + b*x]) + (6*a^2*Sqrt[a + b*x])/b^4 - (2*a*(a + b*x)^(3/2))/b^4 + (2*(a + b*x)^(5/2))/(5*b^4)", //
        45);
  }

  // {45}
  public void test0219() {
    check( //
        "Integrate[x^2/(a + b*x)^(3/2), x]", //
        "(-2*a^2)/(b^3*Sqrt[a + b*x]) - (4*a*Sqrt[a + b*x])/b^3 + (2*(a + b*x)^(3/2))/(3*b^3)", //
        45);
  }

  // {45}
  public void test0220() {
    check( //
        "Integrate[x/(a + b*x)^(3/2), x]", //
        "(2*a)/(b^2*Sqrt[a + b*x]) + (2*Sqrt[a + b*x])/b^2", //
        45);
  }

  // {45}
  public void test0221() {
    check( //
        "Integrate[x^4/(a + b*x)^(5/2), x]", //
        "(-2*a^4)/(3*b^5*(a + b*x)^(3/2)) + (8*a^3)/(b^5*Sqrt[a + b*x]) + (12*a^2*Sqrt[a + b*x])/b^5 - (8*a*(a + b*x)^(3/2))/(3*b^5) + (2*(a + b*x)^(5/2))/(5*b^5)", //
        45);
  }

  // {45}
  public void test0222() {
    check( //
        "Integrate[x^3/(a + b*x)^(5/2), x]", //
        "(2*a^3)/(3*b^4*(a + b*x)^(3/2)) - (6*a^2)/(b^4*Sqrt[a + b*x]) - (6*a*Sqrt[a + b*x])/b^4 + (2*(a + b*x)^(3/2))/(3*b^4)", //
        45);
  }

  // {45}
  public void test0223() {
    check( //
        "Integrate[x^2/(a + b*x)^(5/2), x]", //
        "(-2*a^2)/(3*b^3*(a + b*x)^(3/2)) + (4*a)/(b^3*Sqrt[a + b*x]) + (2*Sqrt[a + b*x])/b^3", //
        45);
  }

  // {45}
  public void test0224() {
    check( //
        "Integrate[x/(a + b*x)^(5/2), x]", //
        "(2*a)/(3*b^2*(a + b*x)^(3/2)) - 2/(b^2*Sqrt[a + b*x])", //
        45);
  }

  // {65, 211}
  public void test0225() {
    check( //
        "Integrate[1/(x*Sqrt[-a + b*x]), x]", //
        "(2*ArcTan[Sqrt[-a + b*x]/Sqrt[a]])/Sqrt[a]", //
        65,
        211);
  }

  // {12, 75}
  public void test0226() {
    check( //
        "Integrate[(x^(-1 + m)*(2*a*m + b*(-1 + 2*m)*x))/(2*(a + b*x)^(3/2)), x]", //
        "x^m/Sqrt[a + b*x]", //
        12,
        75);
  }

  // {45}
  public void test0227() {
    check( //
        "Integrate[x^3*(a + b*x)^(1/3), x]", //
        "(-3*a^3*(a + b*x)^(4/3))/(4*b^4) + (9*a^2*(a + b*x)^(7/3))/(7*b^4) - (9*a*(a + b*x)^(10/3))/(10*b^4) + (3*(a + b*x)^(13/3))/(13*b^4)", //
        45);
  }

  // {45}
  public void test0228() {
    check( //
        "Integrate[x^2*(a + b*x)^(1/3), x]", //
        "(3*a^2*(a + b*x)^(4/3))/(4*b^3) - (6*a*(a + b*x)^(7/3))/(7*b^3) + (3*(a + b*x)^(10/3))/(10*b^3)", //
        45);
  }

  // {45}
  public void test0229() {
    check( //
        "Integrate[x*(a + b*x)^(1/3), x]", //
        "(-3*a*(a + b*x)^(4/3))/(4*b^2) + (3*(a + b*x)^(7/3))/(7*b^2)", //
        45);
  }

  // {45}
  public void test0230() {
    check( //
        "Integrate[x^3*(a + b*x)^(2/3), x]", //
        "(-3*a^3*(a + b*x)^(5/3))/(5*b^4) + (9*a^2*(a + b*x)^(8/3))/(8*b^4) - (9*a*(a + b*x)^(11/3))/(11*b^4) + (3*(a + b*x)^(14/3))/(14*b^4)", //
        45);
  }

  // {45}
  public void test0231() {
    check( //
        "Integrate[x^2*(a + b*x)^(2/3), x]", //
        "(3*a^2*(a + b*x)^(5/3))/(5*b^3) - (3*a*(a + b*x)^(8/3))/(4*b^3) + (3*(a + b*x)^(11/3))/(11*b^3)", //
        45);
  }

  // {45}
  public void test0232() {
    check( //
        "Integrate[x*(a + b*x)^(2/3), x]", //
        "(-3*a*(a + b*x)^(5/3))/(5*b^2) + (3*(a + b*x)^(8/3))/(8*b^2)", //
        45);
  }

  // {45}
  public void test0233() {
    check( //
        "Integrate[x^3*(a + b*x)^(4/3), x]", //
        "(-3*a^3*(a + b*x)^(7/3))/(7*b^4) + (9*a^2*(a + b*x)^(10/3))/(10*b^4) - (9*a*(a + b*x)^(13/3))/(13*b^4) + (3*(a + b*x)^(16/3))/(16*b^4)", //
        45);
  }

  // {45}
  public void test0234() {
    check( //
        "Integrate[x^2*(a + b*x)^(4/3), x]", //
        "(3*a^2*(a + b*x)^(7/3))/(7*b^3) - (3*a*(a + b*x)^(10/3))/(5*b^3) + (3*(a + b*x)^(13/3))/(13*b^3)", //
        45);
  }

  // {45}
  public void test0235() {
    check( //
        "Integrate[x*(a + b*x)^(4/3), x]", //
        "(-3*a*(a + b*x)^(7/3))/(7*b^2) + (3*(a + b*x)^(10/3))/(10*b^2)", //
        45);
  }

  // {45}
  public void test0236() {
    check( //
        "Integrate[x^3/(a + b*x)^(1/3), x]", //
        "(-3*a^3*(a + b*x)^(2/3))/(2*b^4) + (9*a^2*(a + b*x)^(5/3))/(5*b^4) - (9*a*(a + b*x)^(8/3))/(8*b^4) + (3*(a + b*x)^(11/3))/(11*b^4)", //
        45);
  }

  // {45}
  public void test0237() {
    check( //
        "Integrate[x^2/(a + b*x)^(1/3), x]", //
        "(3*a^2*(a + b*x)^(2/3))/(2*b^3) - (6*a*(a + b*x)^(5/3))/(5*b^3) + (3*(a + b*x)^(8/3))/(8*b^3)", //
        45);
  }

  // {45}
  public void test0238() {
    check( //
        "Integrate[x/(a + b*x)^(1/3), x]", //
        "(-3*a*(a + b*x)^(2/3))/(2*b^2) + (3*(a + b*x)^(5/3))/(5*b^2)", //
        45);
  }

  // {45}
  public void test0239() {
    check( //
        "Integrate[x^3/(-a + b*x)^(1/3), x]", //
        "(3*a^3*(-a + b*x)^(2/3))/(2*b^4) + (9*a^2*(-a + b*x)^(5/3))/(5*b^4) + (9*a*(-a + b*x)^(8/3))/(8*b^4) + (3*(-a + b*x)^(11/3))/(11*b^4)", //
        45);
  }

  // {45}
  public void test0240() {
    check( //
        "Integrate[x^2/(-a + b*x)^(1/3), x]", //
        "(3*a^2*(-a + b*x)^(2/3))/(2*b^3) + (6*a*(-a + b*x)^(5/3))/(5*b^3) + (3*(-a + b*x)^(8/3))/(8*b^3)", //
        45);
  }

  // {45}
  public void test0241() {
    check( //
        "Integrate[x/(-a + b*x)^(1/3), x]", //
        "(3*a*(-a + b*x)^(2/3))/(2*b^2) + (3*(-a + b*x)^(5/3))/(5*b^2)", //
        45);
  }

  // {45}
  public void test0242() {
    check( //
        "Integrate[x^3/(a + b*x)^(2/3), x]", //
        "(-3*a^3*(a + b*x)^(1/3))/b^4 + (9*a^2*(a + b*x)^(4/3))/(4*b^4) - (9*a*(a + b*x)^(7/3))/(7*b^4) + (3*(a + b*x)^(10/3))/(10*b^4)", //
        45);
  }

  // {45}
  public void test0243() {
    check( //
        "Integrate[x^2/(a + b*x)^(2/3), x]", //
        "(3*a^2*(a + b*x)^(1/3))/b^3 - (3*a*(a + b*x)^(4/3))/(2*b^3) + (3*(a + b*x)^(7/3))/(7*b^3)", //
        45);
  }

  // {45}
  public void test0244() {
    check( //
        "Integrate[x/(a + b*x)^(2/3), x]", //
        "(-3*a*(a + b*x)^(1/3))/b^2 + (3*(a + b*x)^(4/3))/(4*b^2)", //
        45);
  }

  // {45}
  public void test0245() {
    check( //
        "Integrate[x^3/(a + b*x)^(4/3), x]", //
        "(3*a^3)/(b^4*(a + b*x)^(1/3)) + (9*a^2*(a + b*x)^(2/3))/(2*b^4) - (9*a*(a + b*x)^(5/3))/(5*b^4) + (3*(a + b*x)^(8/3))/(8*b^4)", //
        45);
  }

  // {45}
  public void test0246() {
    check( //
        "Integrate[x^2/(a + b*x)^(4/3), x]", //
        "(-3*a^2)/(b^3*(a + b*x)^(1/3)) - (3*a*(a + b*x)^(2/3))/b^3 + (3*(a + b*x)^(5/3))/(5*b^3)", //
        45);
  }

  // {45}
  public void test0247() {
    check( //
        "Integrate[x/(a + b*x)^(4/3), x]", //
        "(3*a)/(b^2*(a + b*x)^(1/3)) + (3*(a + b*x)^(2/3))/(2*b^2)", //
        45);
  }

  // {45}
  public void test0248() {
    check( //
        "Integrate[x^m*(a + b*x), x]", //
        "(a*x^(1 + m))/(1 + m) + (b*x^(2 + m))/(2 + m)", //
        45);
  }

  // {45}
  public void test0249() {
    check( //
        "Integrate[x^(5/2)*(a + b*x), x]", //
        "(2*a*x^(7/2))/7 + (2*b*x^(9/2))/9", //
        45);
  }

  // {45}
  public void test0250() {
    check( //
        "Integrate[x^(3/2)*(a + b*x), x]", //
        "(2*a*x^(5/2))/5 + (2*b*x^(7/2))/7", //
        45);
  }

  // {45}
  public void test0251() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x), x]", //
        "(2*a*x^(3/2))/3 + (2*b*x^(5/2))/5", //
        45);
  }

  // {45}
  public void test0252() {
    check( //
        "Integrate[(a + b*x)/Sqrt[x], x]", //
        "2*a*Sqrt[x] + (2*b*x^(3/2))/3", //
        45);
  }

  // {45}
  public void test0253() {
    check( //
        "Integrate[(a + b*x)/x^(3/2), x]", //
        "(-2*a)/Sqrt[x] + 2*b*Sqrt[x]", //
        45);
  }

  // {45}
  public void test0254() {
    check( //
        "Integrate[(a + b*x)/x^(5/2), x]", //
        "(-2*a)/(3*x^(3/2)) - (2*b)/Sqrt[x]", //
        45);
  }

  // {45}
  public void test0255() {
    check( //
        "Integrate[x^m*(a + b*x)^2, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(2 + m))/(2 + m) + (b^2*x^(3 + m))/(3 + m)", //
        45);
  }

  // {45}
  public void test0256() {
    check( //
        "Integrate[x^(5/2)*(a + b*x)^2, x]", //
        "(2*a^2*x^(7/2))/7 + (4*a*b*x^(9/2))/9 + (2*b^2*x^(11/2))/11", //
        45);
  }

  // {45}
  public void test0257() {
    check( //
        "Integrate[x^(3/2)*(a + b*x)^2, x]", //
        "(2*a^2*x^(5/2))/5 + (4*a*b*x^(7/2))/7 + (2*b^2*x^(9/2))/9", //
        45);
  }

  // {45}
  public void test0258() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x)^2, x]", //
        "(2*a^2*x^(3/2))/3 + (4*a*b*x^(5/2))/5 + (2*b^2*x^(7/2))/7", //
        45);
  }

  // {45}
  public void test0259() {
    check( //
        "Integrate[(a + b*x)^2/Sqrt[x], x]", //
        "2*a^2*Sqrt[x] + (4*a*b*x^(3/2))/3 + (2*b^2*x^(5/2))/5", //
        45);
  }

  // {45}
  public void test0260() {
    check( //
        "Integrate[(a + b*x)^2/x^(3/2), x]", //
        "(-2*a^2)/Sqrt[x] + 4*a*b*Sqrt[x] + (2*b^2*x^(3/2))/3", //
        45);
  }

  // {45}
  public void test0261() {
    check( //
        "Integrate[(a + b*x)^2/x^(5/2), x]", //
        "(-2*a^2)/(3*x^(3/2)) - (4*a*b)/Sqrt[x] + 2*b^2*Sqrt[x]", //
        45);
  }

  // {45}
  public void test0262() {
    check( //
        "Integrate[x^m*(a + b*x)^3, x]", //
        "(a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(2 + m))/(2 + m) + (3*a*b^2*x^(3 + m))/(3 + m) + (b^3*x^(4 + m))/(4 + m)", //
        45);
  }

  // {45}
  public void test0263() {
    check( //
        "Integrate[x^(5/2)*(a + b*x)^3, x]", //
        "(2*a^3*x^(7/2))/7 + (2*a^2*b*x^(9/2))/3 + (6*a*b^2*x^(11/2))/11 + (2*b^3*x^(13/2))/13", //
        45);
  }

  // {45}
  public void test0264() {
    check( //
        "Integrate[x^(3/2)*(a + b*x)^3, x]", //
        "(2*a^3*x^(5/2))/5 + (6*a^2*b*x^(7/2))/7 + (2*a*b^2*x^(9/2))/3 + (2*b^3*x^(11/2))/11", //
        45);
  }

  // {45}
  public void test0265() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x)^3, x]", //
        "(2*a^3*x^(3/2))/3 + (6*a^2*b*x^(5/2))/5 + (6*a*b^2*x^(7/2))/7 + (2*b^3*x^(9/2))/9", //
        45);
  }

  // {45}
  public void test0266() {
    check( //
        "Integrate[(a + b*x)^3/Sqrt[x], x]", //
        "2*a^3*Sqrt[x] + 2*a^2*b*x^(3/2) + (6*a*b^2*x^(5/2))/5 + (2*b^3*x^(7/2))/7", //
        45);
  }

  // {45}
  public void test0267() {
    check( //
        "Integrate[(a + b*x)^3/x^(3/2), x]", //
        "(-2*a^3)/Sqrt[x] + 6*a^2*b*Sqrt[x] + 2*a*b^2*x^(3/2) + (2*b^3*x^(5/2))/5", //
        45);
  }

  // {45}
  public void test0268() {
    check( //
        "Integrate[(a + b*x)^3/x^(5/2), x]", //
        "(-2*a^3)/(3*x^(3/2)) - (6*a^2*b)/Sqrt[x] + 6*a*b^2*Sqrt[x] + (2*b^3*x^(3/2))/3", //
        45);
  }

  // {65, 211}
  public void test0269() {
    check( //
        "Integrate[1/(Sqrt[x]*(a + b*x)), x]", //
        "(2*ArcTan[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(Sqrt[a]*Sqrt[b])", //
        65,
        211);
  }

  // {65, 214}
  public void test0270() {
    check( //
        "Integrate[1/(Sqrt[x]*(-a + b*x)), x]", //
        "(-2*ArcTanh[(Sqrt[b]*Sqrt[x])/Sqrt[a]])/(Sqrt[a]*Sqrt[b])", //
        65,
        214);
  }

  // {47, 37}
  public void test0271() {
    check( //
        "Integrate[Sqrt[a + b*x]/x^(7/2), x]", //
        "(-2*(a + b*x)^(3/2))/(5*a*x^(5/2)) + (4*b*(a + b*x)^(3/2))/(15*a^2*x^(3/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0272() {
    check( //
        "Integrate[Sqrt[a - b*x]/x^(7/2), x]", //
        "(-2*(a - b*x)^(3/2))/(5*a*x^(5/2)) - (4*b*(a - b*x)^(3/2))/(15*a^2*x^(3/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0273() {
    check( //
        "Integrate[Sqrt[2 + b*x]/x^(7/2), x]", //
        "-(2 + b*x)^(3/2)/(5*x^(5/2)) + (b*(2 + b*x)^(3/2))/(15*x^(3/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0274() {
    check( //
        "Integrate[Sqrt[2 - b*x]/x^(7/2), x]", //
        "-(2 - b*x)^(3/2)/(5*x^(5/2)) - (b*(2 - b*x)^(3/2))/(15*x^(3/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0275() {
    check( //
        "Integrate[1/(x^(5/2)*Sqrt[a + b*x]), x]", //
        "(-2*Sqrt[a + b*x])/(3*a*x^(3/2)) + (4*b*Sqrt[a + b*x])/(3*a^2*Sqrt[x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0276() {
    check( //
        "Integrate[1/(x^(3/2)*(a + b*x)^(3/2)), x]", //
        "2/(a*Sqrt[x]*Sqrt[a + b*x]) - (4*Sqrt[a + b*x])/(a^2*Sqrt[x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0277() {
    check( //
        "Integrate[1/(Sqrt[x]*(a + b*x)^(5/2)), x]", //
        "(2*Sqrt[x])/(3*a*(a + b*x)^(3/2)) + (4*Sqrt[x])/(3*a^2*Sqrt[a + b*x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0278() {
    check( //
        "Integrate[1/(x^(5/2)*Sqrt[a - b*x]), x]", //
        "(-2*Sqrt[a - b*x])/(3*a*x^(3/2)) - (4*b*Sqrt[a - b*x])/(3*a^2*Sqrt[x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0279() {
    check( //
        "Integrate[1/(x^(3/2)*(a - b*x)^(3/2)), x]", //
        "2/(a*Sqrt[x]*Sqrt[a - b*x]) - (4*Sqrt[a - b*x])/(a^2*Sqrt[x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0280() {
    check( //
        "Integrate[1/(Sqrt[x]*(a - b*x)^(5/2)), x]", //
        "(2*Sqrt[x])/(3*a*(a - b*x)^(3/2)) + (4*Sqrt[x])/(3*a^2*Sqrt[a - b*x])", //
        47,
        37);
  }

  // {56, 221}
  public void test0281() {
    check( //
        "Integrate[1/(Sqrt[x]*Sqrt[2 + b*x]), x]", //
        "(2*ArcSinh[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]", //
        56,
        221);
  }

  // {47, 37}
  public void test0282() {
    check( //
        "Integrate[1/(x^(5/2)*Sqrt[2 + b*x]), x]", //
        "-Sqrt[2 + b*x]/(3*x^(3/2)) + (b*Sqrt[2 + b*x])/(3*Sqrt[x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0283() {
    check( //
        "Integrate[1/(x^(3/2)*(2 + b*x)^(3/2)), x]", //
        "1/(Sqrt[x]*Sqrt[2 + b*x]) - Sqrt[2 + b*x]/Sqrt[x]", //
        47,
        37);
  }

  // {47, 37}
  public void test0284() {
    check( //
        "Integrate[1/(Sqrt[x]*(2 + b*x)^(5/2)), x]", //
        "Sqrt[x]/(3*(2 + b*x)^(3/2)) + Sqrt[x]/(3*Sqrt[2 + b*x])", //
        47,
        37);
  }

  // {56, 222}
  public void test0285() {
    check( //
        "Integrate[1/(Sqrt[x]*Sqrt[2 - b*x]), x]", //
        "(2*ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[2]])/Sqrt[b]", //
        56,
        222);
  }

  // {47, 37}
  public void test0286() {
    check( //
        "Integrate[1/(x^(5/2)*Sqrt[2 - b*x]), x]", //
        "-Sqrt[2 - b*x]/(3*x^(3/2)) - (b*Sqrt[2 - b*x])/(3*Sqrt[x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0287() {
    check( //
        "Integrate[1/(x^(3/2)*(2 - b*x)^(3/2)), x]", //
        "1/(Sqrt[x]*Sqrt[2 - b*x]) - Sqrt[2 - b*x]/Sqrt[x]", //
        47,
        37);
  }

  // {47, 37}
  public void test0288() {
    check( //
        "Integrate[1/(Sqrt[x]*(2 - b*x)^(5/2)), x]", //
        "Sqrt[x]/(3*(2 - b*x)^(3/2)) + Sqrt[x]/(3*Sqrt[2 - b*x])", //
        47,
        37);
  }

  // {56, 222}
  public void test0289() {
    check( //
        "Integrate[1/(Sqrt[x]*Sqrt[1 - b*x]), x]", //
        "(2*ArcSin[Sqrt[b]*Sqrt[x]])/Sqrt[b]", //
        56,
        222);
  }

  // {45}
  public void test0290() {
    check( //
        "Integrate[x^(5/3)*(a + b*x), x]", //
        "(3*a*x^(8/3))/8 + (3*b*x^(11/3))/11", //
        45);
  }

  // {45}
  public void test0291() {
    check( //
        "Integrate[x^(4/3)*(a + b*x), x]", //
        "(3*a*x^(7/3))/7 + (3*b*x^(10/3))/10", //
        45);
  }

  // {45}
  public void test0292() {
    check( //
        "Integrate[x^(2/3)*(a + b*x), x]", //
        "(3*a*x^(5/3))/5 + (3*b*x^(8/3))/8", //
        45);
  }

  // {45}
  public void test0293() {
    check( //
        "Integrate[x^(1/3)*(a + b*x), x]", //
        "(3*a*x^(4/3))/4 + (3*b*x^(7/3))/7", //
        45);
  }

  // {45}
  public void test0294() {
    check( //
        "Integrate[(a + b*x)/x^(1/3), x]", //
        "(3*a*x^(2/3))/2 + (3*b*x^(5/3))/5", //
        45);
  }

  // {45}
  public void test0295() {
    check( //
        "Integrate[(a + b*x)/x^(2/3), x]", //
        "3*a*x^(1/3) + (3*b*x^(4/3))/4", //
        45);
  }

  // {45}
  public void test0296() {
    check( //
        "Integrate[(a + b*x)/x^(4/3), x]", //
        "(-3*a)/x^(1/3) + (3*b*x^(2/3))/2", //
        45);
  }

  // {45}
  public void test0297() {
    check( //
        "Integrate[(a + b*x)/x^(5/3), x]", //
        "(-3*a)/(2*x^(2/3)) + 3*b*x^(1/3)", //
        45);
  }

  // {45}
  public void test0298() {
    check( //
        "Integrate[x^(5/3)*(a + b*x)^2, x]", //
        "(3*a^2*x^(8/3))/8 + (6*a*b*x^(11/3))/11 + (3*b^2*x^(14/3))/14", //
        45);
  }

  // {45}
  public void test0299() {
    check( //
        "Integrate[x^(4/3)*(a + b*x)^2, x]", //
        "(3*a^2*x^(7/3))/7 + (3*a*b*x^(10/3))/5 + (3*b^2*x^(13/3))/13", //
        45);
  }

  // {45}
  public void test0300() {
    check( //
        "Integrate[x^(2/3)*(a + b*x)^2, x]", //
        "(3*a^2*x^(5/3))/5 + (3*a*b*x^(8/3))/4 + (3*b^2*x^(11/3))/11", //
        45);
  }

  // {45}
  public void test0301() {
    check( //
        "Integrate[x^(1/3)*(a + b*x)^2, x]", //
        "(3*a^2*x^(4/3))/4 + (6*a*b*x^(7/3))/7 + (3*b^2*x^(10/3))/10", //
        45);
  }

  // {45}
  public void test0302() {
    check( //
        "Integrate[(a + b*x)^2/x^(1/3), x]", //
        "(3*a^2*x^(2/3))/2 + (6*a*b*x^(5/3))/5 + (3*b^2*x^(8/3))/8", //
        45);
  }

  // {45}
  public void test0303() {
    check( //
        "Integrate[(a + b*x)^2/x^(2/3), x]", //
        "3*a^2*x^(1/3) + (3*a*b*x^(4/3))/2 + (3*b^2*x^(7/3))/7", //
        45);
  }

  // {45}
  public void test0304() {
    check( //
        "Integrate[(a + b*x)^2/x^(4/3), x]", //
        "(-3*a^2)/x^(1/3) + 3*a*b*x^(2/3) + (3*b^2*x^(5/3))/5", //
        45);
  }

  // {45}
  public void test0305() {
    check( //
        "Integrate[(a + b*x)^2/x^(5/3), x]", //
        "(-3*a^2)/(2*x^(2/3)) + 6*a*b*x^(1/3) + (3*b^2*x^(4/3))/4", //
        45);
  }

  // {45}
  public void test0306() {
    check( //
        "Integrate[x^(5/3)*(a + b*x)^3, x]", //
        "(3*a^3*x^(8/3))/8 + (9*a^2*b*x^(11/3))/11 + (9*a*b^2*x^(14/3))/14 + (3*b^3*x^(17/3))/17", //
        45);
  }

  // {45}
  public void test0307() {
    check( //
        "Integrate[x^(4/3)*(a + b*x)^3, x]", //
        "(3*a^3*x^(7/3))/7 + (9*a^2*b*x^(10/3))/10 + (9*a*b^2*x^(13/3))/13 + (3*b^3*x^(16/3))/16", //
        45);
  }

  // {45}
  public void test0308() {
    check( //
        "Integrate[x^(2/3)*(a + b*x)^3, x]", //
        "(3*a^3*x^(5/3))/5 + (9*a^2*b*x^(8/3))/8 + (9*a*b^2*x^(11/3))/11 + (3*b^3*x^(14/3))/14", //
        45);
  }

  // {45}
  public void test0309() {
    check( //
        "Integrate[x^(1/3)*(a + b*x)^3, x]", //
        "(3*a^3*x^(4/3))/4 + (9*a^2*b*x^(7/3))/7 + (9*a*b^2*x^(10/3))/10 + (3*b^3*x^(13/3))/13", //
        45);
  }

  // {45}
  public void test0310() {
    check( //
        "Integrate[(a + b*x)^3/x^(1/3), x]", //
        "(3*a^3*x^(2/3))/2 + (9*a^2*b*x^(5/3))/5 + (9*a*b^2*x^(8/3))/8 + (3*b^3*x^(11/3))/11", //
        45);
  }

  // {45}
  public void test0311() {
    check( //
        "Integrate[(a + b*x)^3/x^(2/3), x]", //
        "3*a^3*x^(1/3) + (9*a^2*b*x^(4/3))/4 + (9*a*b^2*x^(7/3))/7 + (3*b^3*x^(10/3))/10", //
        45);
  }

  // {45}
  public void test0312() {
    check( //
        "Integrate[(a + b*x)^3/x^(4/3), x]", //
        "(-3*a^3)/x^(1/3) + (9*a^2*b*x^(2/3))/2 + (9*a*b^2*x^(5/3))/5 + (3*b^3*x^(8/3))/8", //
        45);
  }

  // {45}
  public void test0313() {
    check( //
        "Integrate[(a + b*x)^3/x^(5/3), x]", //
        "(-3*a^3)/(2*x^(2/3)) + 9*a^2*b*x^(1/3) + (9*a*b^2*x^(4/3))/4 + (3*b^3*x^(7/3))/7", //
        45);
  }

  // {45}
  public void test0314() {
    check( //
        "Integrate[x^m*(a + b*x)^10, x]", //
        "(a^10*x^(1 + m))/(1 + m) + (10*a^9*b*x^(2 + m))/(2 + m) + (45*a^8*b^2*x^(3 + m))/(3 + m) + (120*a^7*b^3*x^(4 + m))/(4 + m) + (210*a^6*b^4*x^(5 + m))/(5 + m) + (252*a^5*b^5*x^(6 + m))/(6 + m) + (210*a^4*b^6*x^(7 + m))/(7 + m) + (120*a^3*b^7*x^(8 + m))/(8 + m) + (45*a^2*b^8*x^(9 + m))/(9 + m) + (10*a*b^9*x^(10 + m))/(10 + m) + (b^10*x^(11 + m))/(11 + m)", //
        45);
  }

  // {45}
  public void test0315() {
    check( //
        "Integrate[x^m*(a + b*x)^7, x]", //
        "(a^7*x^(1 + m))/(1 + m) + (7*a^6*b*x^(2 + m))/(2 + m) + (21*a^5*b^2*x^(3 + m))/(3 + m) + (35*a^4*b^3*x^(4 + m))/(4 + m) + (35*a^3*b^4*x^(5 + m))/(5 + m) + (21*a^2*b^5*x^(6 + m))/(6 + m) + (7*a*b^6*x^(7 + m))/(7 + m) + (b^7*x^(8 + m))/(8 + m)", //
        45);
  }

  // {45}
  public void test0316() {
    check( //
        "Integrate[x^m*(a + b*x)^3, x]", //
        "(a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(2 + m))/(2 + m) + (3*a*b^2*x^(3 + m))/(3 + m) + (b^3*x^(4 + m))/(4 + m)", //
        45);
  }

  // {45}
  public void test0317() {
    check( //
        "Integrate[x^m*(a + b*x)^2, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(2 + m))/(2 + m) + (b^2*x^(3 + m))/(3 + m)", //
        45);
  }

  // {45}
  public void test0318() {
    check( //
        "Integrate[x^m*(a + b*x), x]", //
        "(a*x^(1 + m))/(1 + m) + (b*x^(2 + m))/(2 + m)", //
        45);
  }

  // {69, 67}
  public void test0319() {
    check( //
        "Integrate[x^m*(a + b*x)^(5/2), x]", //
        "(2*x^m*(a + b*x)^(7/2)*Hypergeometric2F1[7/2, -m, 9/2, 1 + (b*x)/a])/(7*b*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0320() {
    check( //
        "Integrate[x^m*(a + b*x)^(3/2), x]", //
        "(2*x^m*(a + b*x)^(5/2)*Hypergeometric2F1[5/2, -m, 7/2, 1 + (b*x)/a])/(5*b*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0321() {
    check( //
        "Integrate[x^m*Sqrt[a + b*x], x]", //
        "(2*x^m*(a + b*x)^(3/2)*Hypergeometric2F1[3/2, -m, 5/2, 1 + (b*x)/a])/(3*b*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0322() {
    check( //
        "Integrate[x^m/Sqrt[a + b*x], x]", //
        "(2*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, 1 + (b*x)/a])/(b*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0323() {
    check( //
        "Integrate[x^m/(a + b*x)^(3/2), x]", //
        "(-2*x^m*Hypergeometric2F1[-1/2, -m, 1/2, 1 + (b*x)/a])/(b*(-((b*x)/a))^m*Sqrt[a + b*x])", //
        69,
        67);
  }

  // {69, 67}
  public void test0324() {
    check( //
        "Integrate[x^m/(a + b*x)^(5/2), x]", //
        "(-2*x^m*Hypergeometric2F1[-3/2, -m, -1/2, 1 + (b*x)/a])/(3*b*(-((b*x)/a))^m*(a + b*x)^(3/2))", //
        69,
        67);
  }

  // {69, 67}
  public void test0325() {
    check( //
        "Integrate[x^(2 + m)/Sqrt[a + b*x], x]", //
        "(2*a^2*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -2 - m, 3/2, 1 + (b*x)/a])/(b^3*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0326() {
    check( //
        "Integrate[x^(1 + m)/Sqrt[a + b*x], x]", //
        "(-2*a*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -1 - m, 3/2, 1 + (b*x)/a])/(b^2*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0327() {
    check( //
        "Integrate[x^m/Sqrt[a + b*x], x]", //
        "(2*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, 1 + (b*x)/a])/(b*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0328() {
    check( //
        "Integrate[x^(-1 + m)/Sqrt[a + b*x], x]", //
        "(-2*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, 1 - m, 3/2, 1 + (b*x)/a])/(a*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0329() {
    check( //
        "Integrate[x^(-2 + m)/Sqrt[a + b*x], x]", //
        "(2*b*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, 2 - m, 3/2, 1 + (b*x)/a])/(a^2*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0330() {
    check( //
        "Integrate[x^(-3 + m)/Sqrt[a + b*x], x]", //
        "(-2*b^2*x^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, 3 - m, 3/2, 1 + (b*x)/a])/(a^3*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {69, 67}
  public void test0331() {
    check( //
        "Integrate[(-x)^m/Sqrt[a + b*x], x]", //
        "(2*(-x)^m*Sqrt[a + b*x]*Hypergeometric2F1[1/2, -m, 3/2, 1 + (b*x)/a])/(b*(-((b*x)/a))^m)", //
        69,
        67);
  }

  // {68, 66}
  public void test0332() {
    check( //
        "Integrate[x^m*(a + b*x)^n, x]", //
        "(x^(1 + m)*(a + b*x)^n*Hypergeometric2F1[1 + m, -n, 2 + m, -((b*x)/a)])/((1 + m)*(1 + (b*x)/a)^n)", //
        68,
        66);
  }

  // {68, 66}
  public void test0333() {
    check( //
        "Integrate[(c*x)^m*(a + b*x)^n, x]", //
        "((c*x)^(1 + m)*(a + b*x)^n*Hypergeometric2F1[1 + m, -n, 2 + m, -((b*x)/a)])/(c*(1 + m)*(1 + (b*x)/a)^n)", //
        68,
        66);
  }

  // {45}
  public void test0334() {
    check( //
        "Integrate[x^3*(a + b*x)^n, x]", //
        "-((a^3*(a + b*x)^(1 + n))/(b^4*(1 + n))) + (3*a^2*(a + b*x)^(2 + n))/(b^4*(2 + n)) - (3*a*(a + b*x)^(3 + n))/(b^4*(3 + n)) + (a + b*x)^(4 + n)/(b^4*(4 + n))", //
        45);
  }

  // {45}
  public void test0335() {
    check( //
        "Integrate[x^2*(a + b*x)^n, x]", //
        "(a^2*(a + b*x)^(1 + n))/(b^3*(1 + n)) - (2*a*(a + b*x)^(2 + n))/(b^3*(2 + n)) + (a + b*x)^(3 + n)/(b^3*(3 + n))", //
        45);
  }

  // {45}
  public void test0336() {
    check( //
        "Integrate[x*(a + b*x)^n, x]", //
        "-((a*(a + b*x)^(1 + n))/(b^2*(1 + n))) + (a + b*x)^(2 + n)/(b^2*(2 + n))", //
        45);
  }

  // {47, 37}
  public void test0337() {
    check( //
        "Integrate[x^(-3 + n)/(a + b*x)^n, x]", //
        "-((x^(-2 + n)*(a + b*x)^(1 - n))/(a*(2 - n))) + (b*x^(-1 + n)*(a + b*x)^(1 - n))/(a^2*(1 - n)*(2 - n))", //
        47,
        37);
  }

  // {68, 66}
  public void test0338() {
    check( //
        "Integrate[x^(-1 + n)/(a + b*x)^n, x]", //
        "(x^n*(1 + (b*x)/a)^n*Hypergeometric2F1[n, n, 1 + n, -((b*x)/a)])/(n*(a + b*x)^n)", //
        68,
        66);
  }

  // {68, 66}
  public void test0339() {
    check( //
        "Integrate[x^n/(a + b*x)^n, x]", //
        "(x^(1 + n)*(1 + (b*x)/a)^n*Hypergeometric2F1[n, 1 + n, 2 + n, -((b*x)/a)])/((1 + n)*(a + b*x)^n)", //
        68,
        66);
  }

  // {68, 66}
  public void test0340() {
    check( //
        "Integrate[x^(1 + n)/(a + b*x)^n, x]", //
        "(x^(2 + n)*(1 + (b*x)/a)^n*Hypergeometric2F1[n, 2 + n, 3 + n, -((b*x)/a)])/((2 + n)*(a + b*x)^n)", //
        68,
        66);
  }

  // {68, 66}
  public void test0341() {
    check( //
        "Integrate[x^(3/2)*(a + b*x)^n, x]", //
        "(2*x^(5/2)*(a + b*x)^n*Hypergeometric2F1[5/2, -n, 7/2, -((b*x)/a)])/(5*(1 + (b*x)/a)^n)", //
        68,
        66);
  }

  // {68, 66}
  public void test0342() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x)^n, x]", //
        "(2*x^(3/2)*(a + b*x)^n*Hypergeometric2F1[3/2, -n, 5/2, -((b*x)/a)])/(3*(1 + (b*x)/a)^n)", //
        68,
        66);
  }

  // {68, 66}
  public void test0343() {
    check( //
        "Integrate[(a + b*x)^n/Sqrt[x], x]", //
        "(2*Sqrt[x]*(a + b*x)^n*Hypergeometric2F1[1/2, -n, 3/2, -((b*x)/a)])/(1 + (b*x)/a)^n", //
        68,
        66);
  }

  // {68, 66}
  public void test0344() {
    check( //
        "Integrate[(a + b*x)^n/x^(3/2), x]", //
        "(-2*(a + b*x)^n*Hypergeometric2F1[-1/2, -n, 1/2, -((b*x)/a)])/(Sqrt[x]*(1 + (b*x)/a)^n)", //
        68,
        66);
  }

  // {68, 66}
  public void test0345() {
    check( //
        "Integrate[(a + b*x)^n/x^(5/2), x]", //
        "(-2*(a + b*x)^n*Hypergeometric2F1[-3/2, -n, -1/2, -((b*x)/a)])/(3*x^(3/2)*(1 + (b*x)/a)^n)", //
        68,
        66);
  }

  // {68, 66}
  public void test0346() {
    check( //
        "Integrate[(b*x)^m*(c + d*x)^n, x]", //
        "((b*x)^(1 + m)*(c + d*x)^n*Hypergeometric2F1[1 + m, -n, 2 + m, -((d*x)/c)])/(b*(1 + m)*(1 + (d*x)/c)^n)", //
        68,
        66);
  }

  // {47, 37}
  public void test0347() {
    check( //
        "Integrate[x^(-3 - n)*(a + b*x)^n, x]", //
        "-((x^(-2 - n)*(a + b*x)^(1 + n))/(a*(2 + n))) + (b*x^(-1 - n)*(a + b*x)^(1 + n))/(a^2*(1 + n)*(2 + n))", //
        47,
        37);
  }

  // {47, 37}
  public void test0348() {
    check( //
        "Integrate[x^(2*n - 3*(1 + n))*(a + b*x)^n, x]", //
        "-((x^(-2 - n)*(a + b*x)^(1 + n))/(a*(2 + n))) + (b*x^(-1 - n)*(a + b*x)^(1 + n))/(a^2*(1 + n)*(2 + n))", //
        47,
        37);
  }

  // {15}
  public void test0349() {
    check( //
        "Integrate[(Sqrt[c*x^2]*(a + b*x))/x, x]", //
        "a*Sqrt[c*x^2] + (b*x*Sqrt[c*x^2])/2", //
        15);
  }

  // {15, 37}
  public void test0350() {
    check( //
        "Integrate[(Sqrt[c*x^2]*(a + b*x))/x^4, x]", //
        "-(Sqrt[c*x^2]*(a + b*x)^2)/(2*a*x^3)", //
        15,
        37);
  }

  // {15}
  public void test0351() {
    check( //
        "Integrate[((c*x^2)^(3/2)*(a + b*x))/x^3, x]", //
        "a*c*Sqrt[c*x^2] + (b*c*x*Sqrt[c*x^2])/2", //
        15);
  }

  // {15}
  public void test0352() {
    check( //
        "Integrate[(x*(a + b*x))/Sqrt[c*x^2], x]", //
        "(a*x^2)/Sqrt[c*x^2] + (b*x^3)/(2*Sqrt[c*x^2])", //
        15);
  }

  // {15, 37}
  public void test0353() {
    check( //
        "Integrate[(a + b*x)/(x^2*Sqrt[c*x^2]), x]", //
        "-(a + b*x)^2/(2*a*x*Sqrt[c*x^2])", //
        15,
        37);
  }

  // {15}
  public void test0354() {
    check( //
        "Integrate[(x^3*(a + b*x))/(c*x^2)^(3/2), x]", //
        "(a*x^2)/(c*Sqrt[c*x^2]) + (b*x^3)/(2*c*Sqrt[c*x^2])", //
        15);
  }

  // {15, 37}
  public void test0355() {
    check( //
        "Integrate[(a + b*x)/(c*x^2)^(3/2), x]", //
        "-(a + b*x)^2/(2*a*c*x*Sqrt[c*x^2])", //
        15,
        37);
  }

  // {15, 37}
  public void test0356() {
    check( //
        "Integrate[(x^2*(a + b*x))/(c*x^2)^(5/2), x]", //
        "-(a + b*x)^2/(2*a*c^2*x*Sqrt[c*x^2])", //
        15,
        37);
  }

  // {15, 32}
  public void test0357() {
    check( //
        "Integrate[(Sqrt[c*x^2]*(a + b*x)^2)/x, x]", //
        "(Sqrt[c*x^2]*(a + b*x)^3)/(3*b*x)", //
        15,
        32);
  }

  // {15, 32}
  public void test0358() {
    check( //
        "Integrate[((c*x^2)^(3/2)*(a + b*x)^2)/x^3, x]", //
        "(c*Sqrt[c*x^2]*(a + b*x)^3)/(3*b*x)", //
        15,
        32);
  }

  // {15, 32}
  public void test0359() {
    check( //
        "Integrate[((c*x^2)^(5/2)*(a + b*x)^2)/x^5, x]", //
        "(c^2*Sqrt[c*x^2]*(a + b*x)^3)/(3*b*x)", //
        15,
        32);
  }

  // {15, 32}
  public void test0360() {
    check( //
        "Integrate[(x*(a + b*x)^2)/Sqrt[c*x^2], x]", //
        "(x*(a + b*x)^3)/(3*b*Sqrt[c*x^2])", //
        15,
        32);
  }

  // {15, 37}
  public void test0361() {
    check( //
        "Integrate[(a + b*x)^2/(x^3*Sqrt[c*x^2]), x]", //
        "-(a + b*x)^3/(3*a*x^2*Sqrt[c*x^2])", //
        15,
        37);
  }

  // {15, 32}
  public void test0362() {
    check( //
        "Integrate[(x^3*(a + b*x)^2)/(c*x^2)^(3/2), x]", //
        "(x*(a + b*x)^3)/(3*b*c*Sqrt[c*x^2])", //
        15,
        32);
  }

  // {15, 37}
  public void test0363() {
    check( //
        "Integrate[(a + b*x)^2/(x*(c*x^2)^(3/2)), x]", //
        "-(a + b*x)^3/(3*a*c*x^2*Sqrt[c*x^2])", //
        15,
        37);
  }

  // {15, 37}
  public void test0364() {
    check( //
        "Integrate[(x*(a + b*x)^2)/(c*x^2)^(5/2), x]", //
        "-(a + b*x)^3/(3*a*c^2*x^2*Sqrt[c*x^2])", //
        15,
        37);
  }

  // {15, 31}
  public void test0365() {
    check( //
        "Integrate[Sqrt[c*x^2]/(x*(a + b*x)), x]", //
        "(Sqrt[c*x^2]*Log[a + b*x])/(b*x)", //
        15,
        31);
  }

  // {15, 31}
  public void test0366() {
    check( //
        "Integrate[(c*x^2)^(3/2)/(x^3*(a + b*x)), x]", //
        "(c*Sqrt[c*x^2]*Log[a + b*x])/(b*x)", //
        15,
        31);
  }

  // {15, 31}
  public void test0367() {
    check( //
        "Integrate[(c*x^2)^(5/2)/(x^5*(a + b*x)), x]", //
        "(c^2*Sqrt[c*x^2]*Log[a + b*x])/(b*x)", //
        15,
        31);
  }

  // {15, 31}
  public void test0368() {
    check( //
        "Integrate[x/(Sqrt[c*x^2]*(a + b*x)), x]", //
        "(x*Log[a + b*x])/(b*Sqrt[c*x^2])", //
        15,
        31);
  }

  // {15, 31}
  public void test0369() {
    check( //
        "Integrate[x^3/((c*x^2)^(3/2)*(a + b*x)), x]", //
        "(x*Log[a + b*x])/(b*c*Sqrt[c*x^2])", //
        15,
        31);
  }

  // {15, 32}
  public void test0370() {
    check( //
        "Integrate[Sqrt[c*x^2]/(x*(a + b*x)^2), x]", //
        "-(Sqrt[c*x^2]/(b*x*(a + b*x)))", //
        15,
        32);
  }

  // {15, 32}
  public void test0371() {
    check( //
        "Integrate[(c*x^2)^(3/2)/(x^3*(a + b*x)^2), x]", //
        "-((c*Sqrt[c*x^2])/(b*x*(a + b*x)))", //
        15,
        32);
  }

  // {15, 32}
  public void test0372() {
    check( //
        "Integrate[x/(Sqrt[c*x^2]*(a + b*x)^2), x]", //
        "-(x/(b*Sqrt[c*x^2]*(a + b*x)))", //
        15,
        32);
  }

  // {15, 32}
  public void test0373() {
    check( //
        "Integrate[x^3/((c*x^2)^(3/2)*(a + b*x)^2), x]", //
        "-(x/(b*c*Sqrt[c*x^2]*(a + b*x)))", //
        15,
        32);
  }

  // {15, 32}
  public void test0374() {
    check( //
        "Integrate[(Sqrt[c*x^2]*(a + b*x)^n)/x, x]", //
        "(Sqrt[c*x^2]*(a + b*x)^(1 + n))/(b*(1 + n)*x)", //
        15,
        32);
  }

  // {15, 67}
  public void test0375() {
    check( //
        "Integrate[(Sqrt[c*x^2]*(a + b*x)^n)/x^2, x]", //
        "-((Sqrt[c*x^2]*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + (b*x)/a])/(a*(1 + n)*x))", //
        15,
        67);
  }

  // {15, 67}
  public void test0376() {
    check( //
        "Integrate[(Sqrt[c*x^2]*(a + b*x)^n)/x^3, x]", //
        "(b*Sqrt[c*x^2]*(a + b*x)^(1 + n)*Hypergeometric2F1[2, 1 + n, 2 + n, 1 + (b*x)/a])/(a^2*(1 + n)*x)", //
        15,
        67);
  }

  // {15, 67}
  public void test0377() {
    check( //
        "Integrate[(Sqrt[c*x^2]*(a + b*x)^n)/x^4, x]", //
        "-((b^2*Sqrt[c*x^2]*(a + b*x)^(1 + n)*Hypergeometric2F1[3, 1 + n, 2 + n, 1 + (b*x)/a])/(a^3*(1 + n)*x))", //
        15,
        67);
  }

  // {15, 32}
  public void test0378() {
    check( //
        "Integrate[((c*x^2)^(3/2)*(a + b*x)^n)/x^3, x]", //
        "(c*Sqrt[c*x^2]*(a + b*x)^(1 + n))/(b*(1 + n)*x)", //
        15,
        32);
  }

  // {15, 67}
  public void test0379() {
    check( //
        "Integrate[((c*x^2)^(3/2)*(a + b*x)^n)/x^4, x]", //
        "-((c*Sqrt[c*x^2]*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + (b*x)/a])/(a*(1 + n)*x))", //
        15,
        67);
  }

  // {15, 67}
  public void test0380() {
    check( //
        "Integrate[((c*x^2)^(3/2)*(a + b*x)^n)/x^5, x]", //
        "(b*c*Sqrt[c*x^2]*(a + b*x)^(1 + n)*Hypergeometric2F1[2, 1 + n, 2 + n, 1 + (b*x)/a])/(a^2*(1 + n)*x)", //
        15,
        67);
  }

  // {15, 67}
  public void test0381() {
    check( //
        "Integrate[((c*x^2)^(3/2)*(a + b*x)^n)/x^6, x]", //
        "-((b^2*c*Sqrt[c*x^2]*(a + b*x)^(1 + n)*Hypergeometric2F1[3, 1 + n, 2 + n, 1 + (b*x)/a])/(a^3*(1 + n)*x))", //
        15,
        67);
  }

  // {15, 32}
  public void test0382() {
    check( //
        "Integrate[((c*x^2)^(5/2)*(a + b*x)^n)/x^5, x]", //
        "(c^2*Sqrt[c*x^2]*(a + b*x)^(1 + n))/(b*(1 + n)*x)", //
        15,
        32);
  }

  // {15, 67}
  public void test0383() {
    check( //
        "Integrate[((c*x^2)^(5/2)*(a + b*x)^n)/x^6, x]", //
        "-((c^2*Sqrt[c*x^2]*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + (b*x)/a])/(a*(1 + n)*x))", //
        15,
        67);
  }

  // {15, 67}
  public void test0384() {
    check( //
        "Integrate[((c*x^2)^(5/2)*(a + b*x)^n)/x^7, x]", //
        "(b*c^2*Sqrt[c*x^2]*(a + b*x)^(1 + n)*Hypergeometric2F1[2, 1 + n, 2 + n, 1 + (b*x)/a])/(a^2*(1 + n)*x)", //
        15,
        67);
  }

  // {15, 32}
  public void test0385() {
    check( //
        "Integrate[(x*(a + b*x)^n)/Sqrt[c*x^2], x]", //
        "(x*(a + b*x)^(1 + n))/(b*(1 + n)*Sqrt[c*x^2])", //
        15,
        32);
  }

  // {15, 67}
  public void test0386() {
    check( //
        "Integrate[(a + b*x)^n/Sqrt[c*x^2], x]", //
        "-((x*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + (b*x)/a])/(a*(1 + n)*Sqrt[c*x^2]))", //
        15,
        67);
  }

  // {15, 67}
  public void test0387() {
    check( //
        "Integrate[(a + b*x)^n/(x*Sqrt[c*x^2]), x]", //
        "(b*x*(a + b*x)^(1 + n)*Hypergeometric2F1[2, 1 + n, 2 + n, 1 + (b*x)/a])/(a^2*(1 + n)*Sqrt[c*x^2])", //
        15,
        67);
  }

  // {15, 67}
  public void test0388() {
    check( //
        "Integrate[(a + b*x)^n/(x^2*Sqrt[c*x^2]), x]", //
        "-((b^2*x*(a + b*x)^(1 + n)*Hypergeometric2F1[3, 1 + n, 2 + n, 1 + (b*x)/a])/(a^3*(1 + n)*Sqrt[c*x^2]))", //
        15,
        67);
  }

  // {15, 32}
  public void test0389() {
    check( //
        "Integrate[(x^3*(a + b*x)^n)/(c*x^2)^(3/2), x]", //
        "(x*(a + b*x)^(1 + n))/(b*c*(1 + n)*Sqrt[c*x^2])", //
        15,
        32);
  }

  // {15, 67}
  public void test0390() {
    check( //
        "Integrate[(x^2*(a + b*x)^n)/(c*x^2)^(3/2), x]", //
        "-((x*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + (b*x)/a])/(a*c*(1 + n)*Sqrt[c*x^2]))", //
        15,
        67);
  }

  // {15, 67}
  public void test0391() {
    check( //
        "Integrate[(x*(a + b*x)^n)/(c*x^2)^(3/2), x]", //
        "(b*x*(a + b*x)^(1 + n)*Hypergeometric2F1[2, 1 + n, 2 + n, 1 + (b*x)/a])/(a^2*c*(1 + n)*Sqrt[c*x^2])", //
        15,
        67);
  }

  // {15, 67}
  public void test0392() {
    check( //
        "Integrate[(a + b*x)^n/(c*x^2)^(3/2), x]", //
        "-((b^2*x*(a + b*x)^(1 + n)*Hypergeometric2F1[3, 1 + n, 2 + n, 1 + (b*x)/a])/(a^3*c*(1 + n)*Sqrt[c*x^2]))", //
        15,
        67);
  }

  // {15, 67}
  public void test0393() {
    check( //
        "Integrate[(a + b*x)^n/(x*(c*x^2)^(3/2)), x]", //
        "(b^3*x*(a + b*x)^(1 + n)*Hypergeometric2F1[4, 1 + n, 2 + n, 1 + (b*x)/a])/(a^4*c*(1 + n)*Sqrt[c*x^2])", //
        15,
        67);
  }

  // {15, 32}
  public void test0394() {
    check( //
        "Integrate[(x^5*(a + b*x)^n)/(c*x^2)^(5/2), x]", //
        "(x*(a + b*x)^(1 + n))/(b*c^2*(1 + n)*Sqrt[c*x^2])", //
        15,
        32);
  }

  // {15, 67}
  public void test0395() {
    check( //
        "Integrate[(x^4*(a + b*x)^n)/(c*x^2)^(5/2), x]", //
        "-((x*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + (b*x)/a])/(a*c^2*(1 + n)*Sqrt[c*x^2]))", //
        15,
        67);
  }

  // {15, 67}
  public void test0396() {
    check( //
        "Integrate[(x^3*(a + b*x)^n)/(c*x^2)^(5/2), x]", //
        "(b*x*(a + b*x)^(1 + n)*Hypergeometric2F1[2, 1 + n, 2 + n, 1 + (b*x)/a])/(a^2*c^2*(1 + n)*Sqrt[c*x^2])", //
        15,
        67);
  }

  // {15, 67}
  public void test0397() {
    check( //
        "Integrate[(x^2*(a + b*x)^n)/(c*x^2)^(5/2), x]", //
        "-((b^2*x*(a + b*x)^(1 + n)*Hypergeometric2F1[3, 1 + n, 2 + n, 1 + (b*x)/a])/(a^3*c^2*(1 + n)*Sqrt[c*x^2]))", //
        15,
        67);
  }

  // {15, 67}
  public void test0398() {
    check( //
        "Integrate[(x*(a + b*x)^n)/(c*x^2)^(5/2), x]", //
        "(b^3*x*(a + b*x)^(1 + n)*Hypergeometric2F1[4, 1 + n, 2 + n, 1 + (b*x)/a])/(a^4*c^2*(1 + n)*Sqrt[c*x^2])", //
        15,
        67);
  }

  // {15, 37}
  public void test0399() {
    check( //
        "Integrate[x^3*(c*x^2)^p*(a + b*x)^(-5 - 2*p), x]", //
        "(x^4*(c*x^2)^p)/(2*a*(2 + p)*(a + b*x)^(2*(2 + p)))", //
        15,
        37);
  }

  // {15, 37}
  public void test0400() {
    check( //
        "Integrate[x^2*(c*x^2)^p*(a + b*x)^(-4 - 2*p), x]", //
        "(x^3*(c*x^2)^p*(a + b*x)^(-3 - 2*p))/(a*(3 + 2*p))", //
        15,
        37);
  }

  // {15, 37}
  public void test0401() {
    check( //
        "Integrate[x*(c*x^2)^p*(a + b*x)^(-3 - 2*p), x]", //
        "(x^2*(c*x^2)^p)/(2*a*(1 + p)*(a + b*x)^(2*(1 + p)))", //
        15,
        37);
  }

  // {15, 37}
  public void test0402() {
    check( //
        "Integrate[(c*x^2)^p*(a + b*x)^(-2 - 2*p), x]", //
        "(x*(c*x^2)^p*(a + b*x)^(-1 - 2*p))/(a*(1 + 2*p))", //
        15,
        37);
  }

  // {15, 37}
  public void test0403() {
    check( //
        "Integrate[((c*x^2)^p*(a + b*x)^(-1 - 2*p))/x, x]", //
        "(c*x^2)^p/(2*a*p*(a + b*x)^(2*p))", //
        15,
        37);
  }

  // {15, 37}
  public void test0404() {
    check( //
        "Integrate[(c*x^2)^p/(x^2*(a + b*x)^(2*p)), x]", //
        "-(((c*x^2)^p*(a + b*x)^(1 - 2*p))/(a*(1 - 2*p)*x))", //
        15,
        37);
  }

  // {15, 37}
  public void test0405() {
    check( //
        "Integrate[((c*x^2)^p*(a + b*x)^(1 - 2*p))/x^3, x]", //
        "-((c*x^2)^p*(a + b*x)^(2 - 2*p))/(2*a*(1 - p)*x^2)", //
        15,
        37);
  }

  // {15, 37}
  public void test0406() {
    check( //
        "Integrate[((c*x^2)^p*(a + b*x)^(2 - 2*p))/x^4, x]", //
        "-(((c*x^2)^p*(a + b*x)^(3 - 2*p))/(a*(3 - 2*p)*x^3))", //
        15,
        37);
  }

  // {15, 37}
  public void test0407() {
    check( //
        "Integrate[x^m*(c*x^2)^p*(a + b*x)^(-2 - m - 2*p), x]", //
        "(x^(1 + m)*(c*x^2)^p*(a + b*x)^(-1 - m - 2*p))/(a*(1 + m + 2*p))", //
        15,
        37);
  }

  // {21, 32}
  public void test0408() {
    check( //
        "Integrate[(a + b*x)^5/((a*d)/b + d*x)^3, x]", //
        "(b^2*(a + b*x)^3)/(3*d^3)", //
        21,
        32);
  }

  // {21}
  public void test0409() {
    check( //
        "Integrate[(a + b*x)^4/((a*d)/b + d*x)^3, x]", //
        "(a*b^3*x)/d^3 + (b^4*x^2)/(2*d^3)", //
        21);
  }

  // {21, 8}
  public void test0410() {
    check( //
        "Integrate[(a + b*x)^3/((a*d)/b + d*x)^3, x]", //
        "(b^3*x)/d^3", //
        21,
        8);
  }

  // {21, 31}
  public void test0411() {
    check( //
        "Integrate[(a + b*x)^2/((a*d)/b + d*x)^3, x]", //
        "(b^2*Log[a + b*x])/d^3", //
        21,
        31);
  }

  // {21, 32}
  public void test0412() {
    check( //
        "Integrate[(a + b*x)/((a*d)/b + d*x)^3, x]", //
        "-(b^2/(d^3*(a + b*x)))", //
        21,
        32);
  }

  // {21, 32}
  public void test0413() {
    check( //
        "Integrate[1/((a + b*x)*((a*d)/b + d*x)^3), x]", //
        "-b^2/(3*d^3*(a + b*x)^3)", //
        21,
        32);
  }

  // {21, 32}
  public void test0414() {
    check( //
        "Integrate[1/((a + b*x)^2*((a*d)/b + d*x)^3), x]", //
        "-b^2/(4*d^3*(a + b*x)^4)", //
        21,
        32);
  }

  // {21, 32}
  public void test0415() {
    check( //
        "Integrate[1/((a + b*x)^3*((a*d)/b + d*x)^3), x]", //
        "-b^2/(5*d^3*(a + b*x)^5)", //
        21,
        32);
  }

  // {21, 32}
  public void test0416() {
    check( //
        "Integrate[((b*c)/d + b*x)^5/(c + d*x)^3, x]", //
        "(b^5*(c + d*x)^3)/(3*d^6)", //
        21,
        32);
  }

  // {21}
  public void test0417() {
    check( //
        "Integrate[((b*c)/d + b*x)^4/(c + d*x)^3, x]", //
        "(b^4*c*x)/d^4 + (b^4*x^2)/(2*d^3)", //
        21);
  }

  // {21, 8}
  public void test0418() {
    check( //
        "Integrate[((b*c)/d + b*x)^3/(c + d*x)^3, x]", //
        "(b^3*x)/d^3", //
        21,
        8);
  }

  // {21, 31}
  public void test0419() {
    check( //
        "Integrate[((b*c)/d + b*x)^2/(c + d*x)^3, x]", //
        "(b^2*Log[c + d*x])/d^3", //
        21,
        31);
  }

  // {21, 32}
  public void test0420() {
    check( //
        "Integrate[((b*c)/d + b*x)/(c + d*x)^3, x]", //
        "-(b/(d^2*(c + d*x)))", //
        21,
        32);
  }

  // {21, 32}
  public void test0421() {
    check( //
        "Integrate[1/(((b*c)/d + b*x)*(c + d*x)^3), x]", //
        "-1/(3*b*(c + d*x)^3)", //
        21,
        32);
  }

  // {21, 32}
  public void test0422() {
    check( //
        "Integrate[1/(((b*c)/d + b*x)^2*(c + d*x)^3), x]", //
        "-d/(4*b^2*(c + d*x)^4)", //
        21,
        32);
  }

  // {21, 32}
  public void test0423() {
    check( //
        "Integrate[1/(((b*c)/d + b*x)^3*(c + d*x)^3), x]", //
        "-d^2/(5*b^3*(c + d*x)^5)", //
        21,
        32);
  }

  // {21, 32}
  public void test0424() {
    check( //
        "Integrate[(a + b*x)^5*(a*c + b*c*x)^n, x]", //
        "(a*c + b*c*x)^(6 + n)/(b*c^6*(6 + n))", //
        21,
        32);
  }

  // {21, 32}
  public void test0425() {
    check( //
        "Integrate[(a + b*x)^5*(a*c + b*c*x)^3, x]", //
        "(c^3*(a + b*x)^9)/(9*b)", //
        21,
        32);
  }

  // {21, 32}
  public void test0426() {
    check( //
        "Integrate[(a + b*x)^5*(a*c + b*c*x)^2, x]", //
        "(c^2*(a + b*x)^8)/(8*b)", //
        21,
        32);
  }

  // {21, 32}
  public void test0427() {
    check( //
        "Integrate[(a + b*x)^5*(a*c + b*c*x), x]", //
        "(c*(a + b*x)^7)/(7*b)", //
        21,
        32);
  }

  // {21, 32}
  public void test0428() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x), x]", //
        "(a + b*x)^5/(5*b*c)", //
        21,
        32);
  }

  // {21, 32}
  public void test0429() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^2, x]", //
        "(a + b*x)^4/(4*b*c^2)", //
        21,
        32);
  }

  // {21, 32}
  public void test0430() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^3, x]", //
        "(a + b*x)^3/(3*b*c^3)", //
        21,
        32);
  }

  // {21}
  public void test0431() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^4, x]", //
        "(a*x)/c^4 + (b*x^2)/(2*c^4)", //
        21);
  }

  // {21, 8}
  public void test0432() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^5, x]", //
        "x/c^5", //
        21,
        8);
  }

  // {21, 31}
  public void test0433() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^6, x]", //
        "Log[a + b*x]/(b*c^6)", //
        21,
        31);
  }

  // {21, 32}
  public void test0434() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^7, x]", //
        "-(1/(b*c^7*(a + b*x)))", //
        21,
        32);
  }

  // {21, 32}
  public void test0435() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^8, x]", //
        "-1/(2*b*c^8*(a + b*x)^2)", //
        21,
        32);
  }

  // {23, 31}
  public void test0436() {
    check( //
        "Integrate[1/(Sqrt[-2 - 3*x]*Sqrt[2 + 3*x]), x]", //
        "(Sqrt[2 + 3*x]*Log[2 + 3*x])/(3*Sqrt[-2 - 3*x])", //
        23,
        31);
  }

  // {45}
  public void test0437() {
    check( //
        "Integrate[(a + b*x)*(a*c - b*c*x)^3, x]", //
        "-(a*c^3*(a - b*x)^4)/(2*b) + (c^3*(a - b*x)^5)/(5*b)", //
        45);
  }

  // {45}
  public void test0438() {
    check( //
        "Integrate[(a + b*x)*(a*c - b*c*x)^2, x]", //
        "(-2*a*c^2*(a - b*x)^3)/(3*b) + (c^2*(a - b*x)^4)/(4*b)", //
        45);
  }

  // {41}
  public void test0439() {
    check( //
        "Integrate[(a + b*x)*(a*c - b*c*x), x]", //
        "a^2*c*x - (b^2*c*x^3)/3", //
        41);
  }

  // {45}
  public void test0440() {
    check( //
        "Integrate[(a + b*x)/(a*c - b*c*x), x]", //
        "-(x/c) - (2*a*Log[a - b*x])/(b*c)", //
        45);
  }

  // {45}
  public void test0441() {
    check( //
        "Integrate[(a + b*x)/(a*c - b*c*x)^2, x]", //
        "(2*a)/(b*c^2*(a - b*x)) + Log[a - b*x]/(b*c^2)", //
        45);
  }

  // {45}
  public void test0442() {
    check( //
        "Integrate[(a + b*x)/(a*c - b*c*x)^4, x]", //
        "(2*a)/(3*b*c^4*(a - b*x)^3) - 1/(2*b*c^4*(a - b*x)^2)", //
        45);
  }

  // {45}
  public void test0443() {
    check( //
        "Integrate[(a + b*x)/(a*c - b*c*x)^5, x]", //
        "a/(2*b*c^5*(a - b*x)^4) - 1/(3*b*c^5*(a - b*x)^3)", //
        45);
  }

  // {45}
  public void test0444() {
    check( //
        "Integrate[(a + b*x)/(a*c - b*c*x)^6, x]", //
        "(2*a)/(5*b*c^6*(a - b*x)^5) - 1/(4*b*c^6*(a - b*x)^4)", //
        45);
  }

  // {45}
  public void test0445() {
    check( //
        "Integrate[(a + b*x)^2*(a*c - b*c*x)^3, x]", //
        "-((a^2*c^3*(a - b*x)^4)/b) + (4*a*c^3*(a - b*x)^5)/(5*b) - (c^3*(a - b*x)^6)/(6*b)", //
        45);
  }

  // {45}
  public void test0446() {
    check( //
        "Integrate[(a + b*x)^2*(a*c - b*c*x), x]", //
        "(2*a*c*(a + b*x)^3)/(3*b) - (c*(a + b*x)^4)/(4*b)", //
        45);
  }

  // {45}
  public void test0447() {
    check( //
        "Integrate[(a + b*x)^2/(a*c - b*c*x), x]", //
        "(-2*a*x)/c - (a + b*x)^2/(2*b*c) - (4*a^2*Log[a - b*x])/(b*c)", //
        45);
  }

  // {45}
  public void test0448() {
    check( //
        "Integrate[(a + b*x)^2/(a*c - b*c*x)^2, x]", //
        "x/c^2 + (4*a^2)/(b*c^2*(a - b*x)) + (4*a*Log[a - b*x])/(b*c^2)", //
        45);
  }

  // {45}
  public void test0449() {
    check( //
        "Integrate[(a + b*x)^2/(a*c - b*c*x)^3, x]", //
        "(2*a^2)/(b*c^3*(a - b*x)^2) - (4*a)/(b*c^3*(a - b*x)) - Log[a - b*x]/(b*c^3)", //
        45);
  }

  // {45}
  public void test0450() {
    check( //
        "Integrate[(a + b*x)^2/(a*c - b*c*x)^5, x]", //
        "a^2/(b*c^5*(a - b*x)^4) - (4*a)/(3*b*c^5*(a - b*x)^3) + 1/(2*b*c^5*(a - b*x)^2)", //
        45);
  }

  // {45}
  public void test0451() {
    check( //
        "Integrate[(a + b*x)^2/(a*c - b*c*x)^6, x]", //
        "(4*a^2)/(5*b*c^6*(a - b*x)^5) - a/(b*c^6*(a - b*x)^4) + 1/(3*b*c^6*(a - b*x)^3)", //
        45);
  }

  // {45}
  public void test0452() {
    check( //
        "Integrate[(a + b*x)^2/(a*c - b*c*x)^7, x]", //
        "(2*a^2)/(3*b*c^7*(a - b*x)^6) - (4*a)/(5*b*c^7*(a - b*x)^5) + 1/(4*b*c^7*(a - b*x)^4)", //
        45);
  }

  // {45}
  public void test0453() {
    check( //
        "Integrate[(a*c - b*c*x)^3/(a + b*x), x]", //
        "-4*a^2*c^3*x + (a*c^3*(a - b*x)^2)/b + (c^3*(a - b*x)^3)/(3*b) + (8*a^3*c^3*Log[a + b*x])/b", //
        45);
  }

  // {45}
  public void test0454() {
    check( //
        "Integrate[(a*c - b*c*x)^2/(a + b*x), x]", //
        "-2*a*c^2*x + (c^2*(a - b*x)^2)/(2*b) + (4*a^2*c^2*Log[a + b*x])/b", //
        45);
  }

  // {45}
  public void test0455() {
    check( //
        "Integrate[(a*c - b*c*x)/(a + b*x), x]", //
        "-(c*x) + (2*a*c*Log[a + b*x])/b", //
        45);
  }

  // {35, 214}
  public void test0456() {
    check( //
        "Integrate[1/((a + b*x)*(a*c - b*c*x)), x]", //
        "ArcTanh[(b*x)/a]/(a*b*c)", //
        35,
        214);
  }

  // {45}
  public void test0457() {
    check( //
        "Integrate[(a*c - b*c*x)^3/(a + b*x)^2, x]", //
        "5*a*c^3*x - (b*c^3*x^2)/2 - (8*a^3*c^3)/(b*(a + b*x)) - (12*a^2*c^3*Log[a + b*x])/b", //
        45);
  }

  // {45}
  public void test0458() {
    check( //
        "Integrate[(a*c - b*c*x)^2/(a + b*x)^2, x]", //
        "c^2*x - (4*a^2*c^2)/(b*(a + b*x)) - (4*a*c^2*Log[a + b*x])/b", //
        45);
  }

  // {45}
  public void test0459() {
    check( //
        "Integrate[(a*c - b*c*x)/(a + b*x)^2, x]", //
        "(-2*a*c)/(b*(a + b*x)) - (c*Log[a + b*x])/b", //
        45);
  }

  // {47, 37}
  public void test0460() {
    check( //
        "Integrate[Sqrt[1 + x]/(1 - x)^(7/2), x]", //
        "(1 + x)^(3/2)/(5*(1 - x)^(5/2)) + (1 + x)^(3/2)/(15*(1 - x)^(3/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0461() {
    check( //
        "Integrate[(1 + x)^(3/2)/(1 - x)^(9/2), x]", //
        "(1 + x)^(5/2)/(7*(1 - x)^(7/2)) + (1 + x)^(5/2)/(35*(1 - x)^(5/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0462() {
    check( //
        "Integrate[(1 + x)^(5/2)/(1 - x)^(11/2), x]", //
        "(1 + x)^(7/2)/(9*(1 - x)^(9/2)) + (1 + x)^(7/2)/(63*(1 - x)^(7/2))", //
        47,
        37);
  }

  // {41, 222}
  public void test0463() {
    check( //
        "Integrate[1/(Sqrt[1 - x]*Sqrt[1 + x]), x]", //
        "ArcSin[x]", //
        41,
        222);
  }

  // {47, 37}
  public void test0464() {
    check( //
        "Integrate[1/((1 - x)^(5/2)*Sqrt[1 + x]), x]", //
        "Sqrt[1 + x]/(3*(1 - x)^(3/2)) + Sqrt[1 + x]/(3*Sqrt[1 - x])", //
        47,
        37);
  }

  // {47, 39}
  public void test0465() {
    check( //
        "Integrate[1/((1 - x)^(5/2)*(1 + x)^(3/2)), x]", //
        "1/(3*(1 - x)^(3/2)*Sqrt[1 + x]) + (2*x)/(3*Sqrt[1 - x]*Sqrt[1 + x])", //
        47,
        39);
  }

  // {47, 37}
  public void test0466() {
    check( //
        "Integrate[1/(Sqrt[1 - x]*(1 + x)^(5/2)), x]", //
        "-Sqrt[1 - x]/(3*(1 + x)^(3/2)) - Sqrt[1 - x]/(3*Sqrt[1 + x])", //
        47,
        37);
  }

  // {40, 39}
  public void test0467() {
    check( //
        "Integrate[1/((1 - x)^(5/2)*(1 + x)^(5/2)), x]", //
        "x/(3*(1 - x)^(3/2)*(1 + x)^(3/2)) + (2*x)/(3*Sqrt[1 - x]*Sqrt[1 + x])", //
        40,
        39);
  }

  // {40, 39}
  public void test0468() {
    check( //
        "Integrate[1/((a + a*x)^(5/2)*(c - c*x)^(5/2)), x]", //
        "x/(3*a*c*(a + a*x)^(3/2)*(c - c*x)^(3/2)) + (2*x)/(3*a^2*c^2*Sqrt[a + a*x]*Sqrt[c - c*x])", //
        40,
        39);
  }

  // {40, 39}
  public void test0469() {
    check( //
        "Integrate[1/((a + b*x)^(5/2)*(a*c - b*c*x)^(5/2)), x]", //
        "x/(3*a^2*c*(a + b*x)^(3/2)*(a*c - b*c*x)^(3/2)) + (2*x)/(3*a^4*c^2*Sqrt[a + b*x]*Sqrt[a*c - b*c*x])", //
        40,
        39);
  }

  // {41, 222}
  public void test0470() {
    check( //
        "Integrate[1/(Sqrt[3 - 6*x]*Sqrt[2 + 4*x]), x]", //
        "ArcSin[2*x]/(2*Sqrt[6])", //
        41,
        222);
  }

  // {40, 39}
  public void test0471() {
    check( //
        "Integrate[1/((3 - 6*x)^(5/2)*(2 + 4*x)^(5/2)), x]", //
        "x/(108*Sqrt[6]*(1 - 2*x)^(3/2)*(1 + 2*x)^(3/2)) + x/(54*Sqrt[6]*Sqrt[1 - 2*x]*Sqrt[1 + 2*x])", //
        40,
        39);
  }

  // {47, 37}
  public void test0472() {
    check( //
        "Integrate[1/((3 - x)^(3/2)*(-2 + x)^(3/2)), x]", //
        "2/(Sqrt[3 - x]*Sqrt[-2 + x]) - (4*Sqrt[3 - x])/Sqrt[-2 + x]", //
        47,
        37);
  }

  // {47, 37}
  public void test0473() {
    check( //
        "Integrate[1/((a - I*a*x)^(11/4)*(a + I*a*x)^(1/4)), x]", //
        "(((-2*I)/7)*(a + I*a*x)^(3/4))/(a^2*(a - I*a*x)^(7/4)) - (((4*I)/21)*(a + I*a*x)^(3/4))/(a^3*(a - I*a*x)^(3/4))", //
        47,
        37);
  }

  // {47, 37}
  public void test0474() {
    check( //
        "Integrate[1/((a - I*a*x)^(9/4)*(a + I*a*x)^(3/4)), x]", //
        "(((-2*I)/5)*(a + I*a*x)^(1/4))/(a^2*(a - I*a*x)^(5/4)) - (((4*I)/5)*(a + I*a*x)^(1/4))/(a^3*(a - I*a*x)^(1/4))", //
        47,
        37);
  }

  // {47, 37}
  public void test0475() {
    check( //
        "Integrate[1/((a - I*a*x)^(5/4)*(a + I*a*x)^(7/4)), x]", //
        "(-2*I)/(a^2*(a - I*a*x)^(1/4)*(a + I*a*x)^(3/4)) + (((4*I)/3)*(a - I*a*x)^(3/4))/(a^3*(a + I*a*x)^(3/4))", //
        47,
        37);
  }

  // {47, 37}
  public void test0476() {
    check( //
        "Integrate[1/((a - I*a*x)^(7/4)*(a + I*a*x)^(5/4)), x]", //
        "((-2*I)/3)/(a^2*(a - I*a*x)^(3/4)*(a + I*a*x)^(1/4)) + (((4*I)/3)*(a - I*a*x)^(1/4))/(a^3*(a + I*a*x)^(1/4))", //
        47,
        37);
  }

  // {47, 37}
  public void test0477() {
    check( //
        "Integrate[1/((a - I*a*x)^(3/4)*(a + I*a*x)^(9/4)), x]", //
        "(((2*I)/5)*(a - I*a*x)^(1/4))/(a^2*(a + I*a*x)^(5/4)) + (((4*I)/5)*(a - I*a*x)^(1/4))/(a^3*(a + I*a*x)^(1/4))", //
        47,
        37);
  }

  // {45}
  public void test0478() {
    check( //
        "Integrate[(a + b*x)^2*(a*c - b*c*x)^n, x]", //
        "(-4*a^2*(a*c - b*c*x)^(1 + n))/(b*c*(1 + n)) + (4*a*(a*c - b*c*x)^(2 + n))/(b*c^2*(2 + n)) - (a*c - b*c*x)^(3 + n)/(b*c^3*(3 + n))", //
        45);
  }

  // {45}
  public void test0479() {
    check( //
        "Integrate[(a + b*x)*(a*c - b*c*x)^n, x]", //
        "(-2*a*(a*c - b*c*x)^(1 + n))/(b*c*(1 + n)) + (a*c - b*c*x)^(2 + n)/(b*c^2*(2 + n))", //
        45);
  }

  // {41, 251}
  public void test0480() {
    check( //
        "Integrate[(3 - 6*x)^m*(2 + 4*x)^m, x]", //
        "6^m*x*Hypergeometric2F1[1/2, -m, 3/2, 4*x^2]", //
        41,
        251);
  }

  // {45}
  public void test0481() {
    check( //
        "Integrate[(a + b*x)^4*(c + d*x), x]", //
        "((b*c - a*d)*(a + b*x)^5)/(5*b^2) + (d*(a + b*x)^6)/(6*b^2)", //
        45);
  }

  // {45}
  public void test0482() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x), x]", //
        "((b*c - a*d)*(a + b*x)^4)/(4*b^2) + (d*(a + b*x)^5)/(5*b^2)", //
        45);
  }

  // {45}
  public void test0483() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x), x]", //
        "((b*c - a*d)*(a + b*x)^3)/(3*b^2) + (d*(a + b*x)^4)/(4*b^2)", //
        45);
  }

  // {45}
  public void test0484() {
    check( //
        "Integrate[(a + b*x)*(c + d*x), x]", //
        "a*c*x + ((b*c + a*d)*x^2)/2 + (b*d*x^3)/3", //
        45);
  }

  // {45}
  public void test0485() {
    check( //
        "Integrate[(c + d*x)/(a + b*x), x]", //
        "(d*x)/b + ((b*c - a*d)*Log[a + b*x])/b^2", //
        45);
  }

  // {45}
  public void test0486() {
    check( //
        "Integrate[(c + d*x)/(a + b*x)^2, x]", //
        "-((b*c - a*d)/(b^2*(a + b*x))) + (d*Log[a + b*x])/b^2", //
        45);
  }

  // {45}
  public void test0487() {
    check( //
        "Integrate[(c + d*x)/(a + b*x)^4, x]", //
        "-(b*c - a*d)/(3*b^2*(a + b*x)^3) - d/(2*b^2*(a + b*x)^2)", //
        45);
  }

  // {45}
  public void test0488() {
    check( //
        "Integrate[(c + d*x)/(a + b*x)^5, x]", //
        "-(b*c - a*d)/(4*b^2*(a + b*x)^4) - d/(3*b^2*(a + b*x)^3)", //
        45);
  }

  // {45}
  public void test0489() {
    check( //
        "Integrate[(a + b*x)^4*(c + d*x)^2, x]", //
        "((b*c - a*d)^2*(a + b*x)^5)/(5*b^3) + (d*(b*c - a*d)*(a + b*x)^6)/(3*b^3) + (d^2*(a + b*x)^7)/(7*b^3)", //
        45);
  }

  // {45}
  public void test0490() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^2, x]", //
        "((b*c - a*d)^2*(a + b*x)^4)/(4*b^3) + (2*d*(b*c - a*d)*(a + b*x)^5)/(5*b^3) + (d^2*(a + b*x)^6)/(6*b^3)", //
        45);
  }

  // {45}
  public void test0491() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^2, x]", //
        "((b*c - a*d)^2*(a + b*x)^3)/(3*b^3) + (d*(b*c - a*d)*(a + b*x)^4)/(2*b^3) + (d^2*(a + b*x)^5)/(5*b^3)", //
        45);
  }

  // {45}
  public void test0492() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^2, x]", //
        "-((b*c - a*d)*(c + d*x)^3)/(3*d^2) + (b*(c + d*x)^4)/(4*d^2)", //
        45);
  }

  // {45}
  public void test0493() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*x), x]", //
        "(d*(b*c - a*d)*x)/b^2 + (c + d*x)^2/(2*b) + ((b*c - a*d)^2*Log[a + b*x])/b^3", //
        45);
  }

  // {45}
  public void test0494() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*x)^2, x]", //
        "(d^2*x)/b^2 - (b*c - a*d)^2/(b^3*(a + b*x)) + (2*d*(b*c - a*d)*Log[a + b*x])/b^3", //
        45);
  }

  // {45}
  public void test0495() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*x)^3, x]", //
        "-(b*c - a*d)^2/(2*b^3*(a + b*x)^2) - (2*d*(b*c - a*d))/(b^3*(a + b*x)) + (d^2*Log[a + b*x])/b^3", //
        45);
  }

  // {45}
  public void test0496() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*x)^5, x]", //
        "-(b*c - a*d)^2/(4*b^3*(a + b*x)^4) - (2*d*(b*c - a*d))/(3*b^3*(a + b*x)^3) - d^2/(2*b^3*(a + b*x)^2)", //
        45);
  }

  // {45}
  public void test0497() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*x)^6, x]", //
        "-(b*c - a*d)^2/(5*b^3*(a + b*x)^5) - (d*(b*c - a*d))/(2*b^3*(a + b*x)^4) - d^2/(3*b^3*(a + b*x)^3)", //
        45);
  }

  // {45}
  public void test0498() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*x)^7, x]", //
        "-(b*c - a*d)^2/(6*b^3*(a + b*x)^6) - (2*d*(b*c - a*d))/(5*b^3*(a + b*x)^5) - d^2/(4*b^3*(a + b*x)^4)", //
        45);
  }

  // {45}
  public void test0499() {
    check( //
        "Integrate[(a + b*x)^5*(c + d*x)^3, x]", //
        "((b*c - a*d)^3*(a + b*x)^6)/(6*b^4) + (3*d*(b*c - a*d)^2*(a + b*x)^7)/(7*b^4) + (3*d^2*(b*c - a*d)*(a + b*x)^8)/(8*b^4) + (d^3*(a + b*x)^9)/(9*b^4)", //
        45);
  }

  // {45}
  public void test0500() {
    check( //
        "Integrate[(a + b*x)^4*(c + d*x)^3, x]", //
        "((b*c - a*d)^3*(a + b*x)^5)/(5*b^4) + (d*(b*c - a*d)^2*(a + b*x)^6)/(2*b^4) + (3*d^2*(b*c - a*d)*(a + b*x)^7)/(7*b^4) + (d^3*(a + b*x)^8)/(8*b^4)", //
        45);
  }

  // {45}
  public void test0501() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^3, x]", //
        "((b*c - a*d)^3*(a + b*x)^4)/(4*b^4) + (3*d*(b*c - a*d)^2*(a + b*x)^5)/(5*b^4) + (d^2*(b*c - a*d)*(a + b*x)^6)/(2*b^4) + (d^3*(a + b*x)^7)/(7*b^4)", //
        45);
  }

  // {45}
  public void test0502() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^3, x]", //
        "((b*c - a*d)^2*(c + d*x)^4)/(4*d^3) - (2*b*(b*c - a*d)*(c + d*x)^5)/(5*d^3) + (b^2*(c + d*x)^6)/(6*d^3)", //
        45);
  }

  // {45}
  public void test0503() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^3, x]", //
        "-((b*c - a*d)*(c + d*x)^4)/(4*d^2) + (b*(c + d*x)^5)/(5*d^2)", //
        45);
  }

  // {45}
  public void test0504() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x), x]", //
        "(d*(b*c - a*d)^2*x)/b^3 + ((b*c - a*d)*(c + d*x)^2)/(2*b^2) + (c + d*x)^3/(3*b) + ((b*c - a*d)^3*Log[a + b*x])/b^4", //
        45);
  }

  // {45}
  public void test0505() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^2, x]", //
        "(d^2*(3*b*c - 2*a*d)*x)/b^3 + (d^3*x^2)/(2*b^2) - (b*c - a*d)^3/(b^4*(a + b*x)) + (3*d*(b*c - a*d)^2*Log[a + b*x])/b^4", //
        45);
  }

  // {45}
  public void test0506() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^3, x]", //
        "(d^3*x)/b^3 - (b*c - a*d)^3/(2*b^4*(a + b*x)^2) - (3*d*(b*c - a*d)^2)/(b^4*(a + b*x)) + (3*d^2*(b*c - a*d)*Log[a + b*x])/b^4", //
        45);
  }

  // {45}
  public void test0507() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^4, x]", //
        "-(b*c - a*d)^3/(3*b^4*(a + b*x)^3) - (3*d*(b*c - a*d)^2)/(2*b^4*(a + b*x)^2) - (3*d^2*(b*c - a*d))/(b^4*(a + b*x)) + (d^3*Log[a + b*x])/b^4", //
        45);
  }

  // {47, 37}
  public void test0508() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^6, x]", //
        "-(c + d*x)^4/(5*(b*c - a*d)*(a + b*x)^5) + (d*(c + d*x)^4)/(20*(b*c - a*d)^2*(a + b*x)^4)", //
        47,
        37);
  }

  // {45}
  public void test0509() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^7, x]", //
        "-(b*c - a*d)^3/(6*b^4*(a + b*x)^6) - (3*d*(b*c - a*d)^2)/(5*b^4*(a + b*x)^5) - (3*d^2*(b*c - a*d))/(4*b^4*(a + b*x)^4) - d^3/(3*b^4*(a + b*x)^3)", //
        45);
  }

  // {45}
  public void test0510() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^8, x]", //
        "-(b*c - a*d)^3/(7*b^4*(a + b*x)^7) - (d*(b*c - a*d)^2)/(2*b^4*(a + b*x)^6) - (3*d^2*(b*c - a*d))/(5*b^4*(a + b*x)^5) - d^3/(4*b^4*(a + b*x)^4)", //
        45);
  }

  // {45}
  public void test0511() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^9, x]", //
        "-(b*c - a*d)^3/(8*b^4*(a + b*x)^8) - (3*d*(b*c - a*d)^2)/(7*b^4*(a + b*x)^7) - (d^2*(b*c - a*d))/(2*b^4*(a + b*x)^6) - d^3/(5*b^4*(a + b*x)^5)", //
        45);
  }

  // {45}
  public void test0512() {
    check( //
        "Integrate[(a + b*x)^9*(c + d*x)^7, x]", //
        "((b*c - a*d)^7*(a + b*x)^10)/(10*b^8) + (7*d*(b*c - a*d)^6*(a + b*x)^11)/(11*b^8) + (7*d^2*(b*c - a*d)^5*(a + b*x)^12)/(4*b^8) + (35*d^3*(b*c - a*d)^4*(a + b*x)^13)/(13*b^8) + (5*d^4*(b*c - a*d)^3*(a + b*x)^14)/(2*b^8) + (7*d^5*(b*c - a*d)^2*(a + b*x)^15)/(5*b^8) + (7*d^6*(b*c - a*d)*(a + b*x)^16)/(16*b^8) + (d^7*(a + b*x)^17)/(17*b^8)", //
        45);
  }

  // {45}
  public void test0513() {
    check( //
        "Integrate[(a + b*x)^8*(c + d*x)^7, x]", //
        "((b*c - a*d)^7*(a + b*x)^9)/(9*b^8) + (7*d*(b*c - a*d)^6*(a + b*x)^10)/(10*b^8) + (21*d^2*(b*c - a*d)^5*(a + b*x)^11)/(11*b^8) + (35*d^3*(b*c - a*d)^4*(a + b*x)^12)/(12*b^8) + (35*d^4*(b*c - a*d)^3*(a + b*x)^13)/(13*b^8) + (3*d^5*(b*c - a*d)^2*(a + b*x)^14)/(2*b^8) + (7*d^6*(b*c - a*d)*(a + b*x)^15)/(15*b^8) + (d^7*(a + b*x)^16)/(16*b^8)", //
        45);
  }

  // {45}
  public void test0514() {
    check( //
        "Integrate[(a + b*x)^7*(c + d*x)^7, x]", //
        "((b*c - a*d)^7*(a + b*x)^8)/(8*b^8) + (7*d*(b*c - a*d)^6*(a + b*x)^9)/(9*b^8) + (21*d^2*(b*c - a*d)^5*(a + b*x)^10)/(10*b^8) + (35*d^3*(b*c - a*d)^4*(a + b*x)^11)/(11*b^8) + (35*d^4*(b*c - a*d)^3*(a + b*x)^12)/(12*b^8) + (21*d^5*(b*c - a*d)^2*(a + b*x)^13)/(13*b^8) + (d^6*(b*c - a*d)*(a + b*x)^14)/(2*b^8) + (d^7*(a + b*x)^15)/(15*b^8)", //
        45);
  }

  // {45}
  public void test0515() {
    check( //
        "Integrate[(a + b*x)^6*(c + d*x)^7, x]", //
        "((b*c - a*d)^6*(c + d*x)^8)/(8*d^7) - (2*b*(b*c - a*d)^5*(c + d*x)^9)/(3*d^7) + (3*b^2*(b*c - a*d)^4*(c + d*x)^10)/(2*d^7) - (20*b^3*(b*c - a*d)^3*(c + d*x)^11)/(11*d^7) + (5*b^4*(b*c - a*d)^2*(c + d*x)^12)/(4*d^7) - (6*b^5*(b*c - a*d)*(c + d*x)^13)/(13*d^7) + (b^6*(c + d*x)^14)/(14*d^7)", //
        45);
  }

  // {45}
  public void test0516() {
    check( //
        "Integrate[(a + b*x)^5*(c + d*x)^7, x]", //
        "-((b*c - a*d)^5*(c + d*x)^8)/(8*d^6) + (5*b*(b*c - a*d)^4*(c + d*x)^9)/(9*d^6) - (b^2*(b*c - a*d)^3*(c + d*x)^10)/d^6 + (10*b^3*(b*c - a*d)^2*(c + d*x)^11)/(11*d^6) - (5*b^4*(b*c - a*d)*(c + d*x)^12)/(12*d^6) + (b^5*(c + d*x)^13)/(13*d^6)", //
        45);
  }

  // {45}
  public void test0517() {
    check( //
        "Integrate[(a + b*x)^4*(c + d*x)^7, x]", //
        "((b*c - a*d)^4*(c + d*x)^8)/(8*d^5) - (4*b*(b*c - a*d)^3*(c + d*x)^9)/(9*d^5) + (3*b^2*(b*c - a*d)^2*(c + d*x)^10)/(5*d^5) - (4*b^3*(b*c - a*d)*(c + d*x)^11)/(11*d^5) + (b^4*(c + d*x)^12)/(12*d^5)", //
        45);
  }

  // {45}
  public void test0518() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^7, x]", //
        "-((b*c - a*d)^3*(c + d*x)^8)/(8*d^4) + (b*(b*c - a*d)^2*(c + d*x)^9)/(3*d^4) - (3*b^2*(b*c - a*d)*(c + d*x)^10)/(10*d^4) + (b^3*(c + d*x)^11)/(11*d^4)", //
        45);
  }

  // {45}
  public void test0519() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^7, x]", //
        "((b*c - a*d)^2*(c + d*x)^8)/(8*d^3) - (2*b*(b*c - a*d)*(c + d*x)^9)/(9*d^3) + (b^2*(c + d*x)^10)/(10*d^3)", //
        45);
  }

  // {45}
  public void test0520() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^7, x]", //
        "-((b*c - a*d)*(c + d*x)^8)/(8*d^2) + (b*(c + d*x)^9)/(9*d^2)", //
        45);
  }

  // {45}
  public void test0521() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x), x]", //
        "(d*(b*c - a*d)^6*x)/b^7 + ((b*c - a*d)^5*(c + d*x)^2)/(2*b^6) + ((b*c - a*d)^4*(c + d*x)^3)/(3*b^5) + ((b*c - a*d)^3*(c + d*x)^4)/(4*b^4) + ((b*c - a*d)^2*(c + d*x)^5)/(5*b^3) + ((b*c - a*d)*(c + d*x)^6)/(6*b^2) + (c + d*x)^7/(7*b) + ((b*c - a*d)^7*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0522() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^2, x]", //
        "(21*d^2*(b*c - a*d)^5*x)/b^7 - (b*c - a*d)^7/(b^8*(a + b*x)) + (35*d^3*(b*c - a*d)^4*(a + b*x)^2)/(2*b^8) + (35*d^4*(b*c - a*d)^3*(a + b*x)^3)/(3*b^8) + (21*d^5*(b*c - a*d)^2*(a + b*x)^4)/(4*b^8) + (7*d^6*(b*c - a*d)*(a + b*x)^5)/(5*b^8) + (d^7*(a + b*x)^6)/(6*b^8) + (7*d*(b*c - a*d)^6*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0523() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^3, x]", //
        "(35*d^3*(b*c - a*d)^4*x)/b^7 - (b*c - a*d)^7/(2*b^8*(a + b*x)^2) - (7*d*(b*c - a*d)^6)/(b^8*(a + b*x)) + (35*d^4*(b*c - a*d)^3*(a + b*x)^2)/(2*b^8) + (7*d^5*(b*c - a*d)^2*(a + b*x)^3)/b^8 + (7*d^6*(b*c - a*d)*(a + b*x)^4)/(4*b^8) + (d^7*(a + b*x)^5)/(5*b^8) + (21*d^2*(b*c - a*d)^5*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0524() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^4, x]", //
        "(35*d^4*(b*c - a*d)^3*x)/b^7 - (b*c - a*d)^7/(3*b^8*(a + b*x)^3) - (7*d*(b*c - a*d)^6)/(2*b^8*(a + b*x)^2) - (21*d^2*(b*c - a*d)^5)/(b^8*(a + b*x)) + (21*d^5*(b*c - a*d)^2*(a + b*x)^2)/(2*b^8) + (7*d^6*(b*c - a*d)*(a + b*x)^3)/(3*b^8) + (d^7*(a + b*x)^4)/(4*b^8) + (35*d^3*(b*c - a*d)^4*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0525() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^5, x]", //
        "(21*d^5*(b*c - a*d)^2*x)/b^7 - (b*c - a*d)^7/(4*b^8*(a + b*x)^4) - (7*d*(b*c - a*d)^6)/(3*b^8*(a + b*x)^3) - (21*d^2*(b*c - a*d)^5)/(2*b^8*(a + b*x)^2) - (35*d^3*(b*c - a*d)^4)/(b^8*(a + b*x)) + (7*d^6*(b*c - a*d)*(a + b*x)^2)/(2*b^8) + (d^7*(a + b*x)^3)/(3*b^8) + (35*d^4*(b*c - a*d)^3*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0526() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^6, x]", //
        "(d^6*(7*b*c - 6*a*d)*x)/b^7 + (d^7*x^2)/(2*b^6) - (b*c - a*d)^7/(5*b^8*(a + b*x)^5) - (7*d*(b*c - a*d)^6)/(4*b^8*(a + b*x)^4) - (7*d^2*(b*c - a*d)^5)/(b^8*(a + b*x)^3) - (35*d^3*(b*c - a*d)^4)/(2*b^8*(a + b*x)^2) - (35*d^4*(b*c - a*d)^3)/(b^8*(a + b*x)) + (21*d^5*(b*c - a*d)^2*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0527() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^7, x]", //
        "(d^7*x)/b^7 - (b*c - a*d)^7/(6*b^8*(a + b*x)^6) - (7*d*(b*c - a*d)^6)/(5*b^8*(a + b*x)^5) - (21*d^2*(b*c - a*d)^5)/(4*b^8*(a + b*x)^4) - (35*d^3*(b*c - a*d)^4)/(3*b^8*(a + b*x)^3) - (35*d^4*(b*c - a*d)^3)/(2*b^8*(a + b*x)^2) - (21*d^5*(b*c - a*d)^2)/(b^8*(a + b*x)) + (7*d^6*(b*c - a*d)*Log[a + b*x])/b^8", //
        45);
  }

  // {45}
  public void test0528() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^8, x]", //
        "-(b*c - a*d)^7/(7*b^8*(a + b*x)^7) - (7*d*(b*c - a*d)^6)/(6*b^8*(a + b*x)^6) - (21*d^2*(b*c - a*d)^5)/(5*b^8*(a + b*x)^5) - (35*d^3*(b*c - a*d)^4)/(4*b^8*(a + b*x)^4) - (35*d^4*(b*c - a*d)^3)/(3*b^8*(a + b*x)^3) - (21*d^5*(b*c - a*d)^2)/(2*b^8*(a + b*x)^2) - (7*d^6*(b*c - a*d))/(b^8*(a + b*x)) + (d^7*Log[a + b*x])/b^8", //
        45);
  }

  // {47, 37}
  public void test0529() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^10, x]", //
        "-(c + d*x)^8/(9*(b*c - a*d)*(a + b*x)^9) + (d*(c + d*x)^8)/(72*(b*c - a*d)^2*(a + b*x)^8)", //
        47,
        37);
  }

  // {45}
  public void test0530() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^14, x]", //
        "-(b*c - a*d)^7/(13*b^8*(a + b*x)^13) - (7*d*(b*c - a*d)^6)/(12*b^8*(a + b*x)^12) - (21*d^2*(b*c - a*d)^5)/(11*b^8*(a + b*x)^11) - (7*d^3*(b*c - a*d)^4)/(2*b^8*(a + b*x)^10) - (35*d^4*(b*c - a*d)^3)/(9*b^8*(a + b*x)^9) - (21*d^5*(b*c - a*d)^2)/(8*b^8*(a + b*x)^8) - (d^6*(b*c - a*d))/(b^8*(a + b*x)^7) - d^7/(6*b^8*(a + b*x)^6)", //
        45);
  }

  // {45}
  public void test0531() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^15, x]", //
        "-(b*c - a*d)^7/(14*b^8*(a + b*x)^14) - (7*d*(b*c - a*d)^6)/(13*b^8*(a + b*x)^13) - (7*d^2*(b*c - a*d)^5)/(4*b^8*(a + b*x)^12) - (35*d^3*(b*c - a*d)^4)/(11*b^8*(a + b*x)^11) - (7*d^4*(b*c - a*d)^3)/(2*b^8*(a + b*x)^10) - (7*d^5*(b*c - a*d)^2)/(3*b^8*(a + b*x)^9) - (7*d^6*(b*c - a*d))/(8*b^8*(a + b*x)^8) - d^7/(7*b^8*(a + b*x)^7)", //
        45);
  }

  // {45}
  public void test0532() {
    check( //
        "Integrate[(c + d*x)^7/(a + b*x)^16, x]", //
        "-(b*c - a*d)^7/(15*b^8*(a + b*x)^15) - (d*(b*c - a*d)^6)/(2*b^8*(a + b*x)^14) - (21*d^2*(b*c - a*d)^5)/(13*b^8*(a + b*x)^13) - (35*d^3*(b*c - a*d)^4)/(12*b^8*(a + b*x)^12) - (35*d^4*(b*c - a*d)^3)/(11*b^8*(a + b*x)^11) - (21*d^5*(b*c - a*d)^2)/(10*b^8*(a + b*x)^10) - (7*d^6*(b*c - a*d))/(9*b^8*(a + b*x)^9) - d^7/(8*b^8*(a + b*x)^8)", //
        45);
  }

  // {45}
  public void test0533() {
    check( //
        "Integrate[(a + b*x)^12*(c + d*x)^10, x]", //
        "((b*c - a*d)^10*(a + b*x)^13)/(13*b^11) + (5*d*(b*c - a*d)^9*(a + b*x)^14)/(7*b^11) + (3*d^2*(b*c - a*d)^8*(a + b*x)^15)/b^11 + (15*d^3*(b*c - a*d)^7*(a + b*x)^16)/(2*b^11) + (210*d^4*(b*c - a*d)^6*(a + b*x)^17)/(17*b^11) + (14*d^5*(b*c - a*d)^5*(a + b*x)^18)/b^11 + (210*d^6*(b*c - a*d)^4*(a + b*x)^19)/(19*b^11) + (6*d^7*(b*c - a*d)^3*(a + b*x)^20)/b^11 + (15*d^8*(b*c - a*d)^2*(a + b*x)^21)/(7*b^11) + (5*d^9*(b*c - a*d)*(a + b*x)^22)/(11*b^11) + (d^10*(a + b*x)^23)/(23*b^11)", //
        45);
  }

  // {45}
  public void test0534() {
    check( //
        "Integrate[(a + b*x)^11*(c + d*x)^10, x]", //
        "((b*c - a*d)^10*(a + b*x)^12)/(12*b^11) + (10*d*(b*c - a*d)^9*(a + b*x)^13)/(13*b^11) + (45*d^2*(b*c - a*d)^8*(a + b*x)^14)/(14*b^11) + (8*d^3*(b*c - a*d)^7*(a + b*x)^15)/b^11 + (105*d^4*(b*c - a*d)^6*(a + b*x)^16)/(8*b^11) + (252*d^5*(b*c - a*d)^5*(a + b*x)^17)/(17*b^11) + (35*d^6*(b*c - a*d)^4*(a + b*x)^18)/(3*b^11) + (120*d^7*(b*c - a*d)^3*(a + b*x)^19)/(19*b^11) + (9*d^8*(b*c - a*d)^2*(a + b*x)^20)/(4*b^11) + (10*d^9*(b*c - a*d)*(a + b*x)^21)/(21*b^11) + (d^10*(a + b*x)^22)/(22*b^11)", //
        45);
  }

  // {45}
  public void test0535() {
    check( //
        "Integrate[(a + b*x)^10*(c + d*x)^10, x]", //
        "((b*c - a*d)^10*(a + b*x)^11)/(11*b^11) + (5*d*(b*c - a*d)^9*(a + b*x)^12)/(6*b^11) + (45*d^2*(b*c - a*d)^8*(a + b*x)^13)/(13*b^11) + (60*d^3*(b*c - a*d)^7*(a + b*x)^14)/(7*b^11) + (14*d^4*(b*c - a*d)^6*(a + b*x)^15)/b^11 + (63*d^5*(b*c - a*d)^5*(a + b*x)^16)/(4*b^11) + (210*d^6*(b*c - a*d)^4*(a + b*x)^17)/(17*b^11) + (20*d^7*(b*c - a*d)^3*(a + b*x)^18)/(3*b^11) + (45*d^8*(b*c - a*d)^2*(a + b*x)^19)/(19*b^11) + (d^9*(b*c - a*d)*(a + b*x)^20)/(2*b^11) + (d^10*(a + b*x)^21)/(21*b^11)", //
        45);
  }

  // {45}
  public void test0536() {
    check( //
        "Integrate[(a + b*x)^9*(c + d*x)^10, x]", //
        "-((b*c - a*d)^9*(c + d*x)^11)/(11*d^10) + (3*b*(b*c - a*d)^8*(c + d*x)^12)/(4*d^10) - (36*b^2*(b*c - a*d)^7*(c + d*x)^13)/(13*d^10) + (6*b^3*(b*c - a*d)^6*(c + d*x)^14)/d^10 - (42*b^4*(b*c - a*d)^5*(c + d*x)^15)/(5*d^10) + (63*b^5*(b*c - a*d)^4*(c + d*x)^16)/(8*d^10) - (84*b^6*(b*c - a*d)^3*(c + d*x)^17)/(17*d^10) + (2*b^7*(b*c - a*d)^2*(c + d*x)^18)/d^10 - (9*b^8*(b*c - a*d)*(c + d*x)^19)/(19*d^10) + (b^9*(c + d*x)^20)/(20*d^10)", //
        45);
  }

  // {45}
  public void test0537() {
    check( //
        "Integrate[(a + b*x)^8*(c + d*x)^10, x]", //
        "((b*c - a*d)^8*(c + d*x)^11)/(11*d^9) - (2*b*(b*c - a*d)^7*(c + d*x)^12)/(3*d^9) + (28*b^2*(b*c - a*d)^6*(c + d*x)^13)/(13*d^9) - (4*b^3*(b*c - a*d)^5*(c + d*x)^14)/d^9 + (14*b^4*(b*c - a*d)^4*(c + d*x)^15)/(3*d^9) - (7*b^5*(b*c - a*d)^3*(c + d*x)^16)/(2*d^9) + (28*b^6*(b*c - a*d)^2*(c + d*x)^17)/(17*d^9) - (4*b^7*(b*c - a*d)*(c + d*x)^18)/(9*d^9) + (b^8*(c + d*x)^19)/(19*d^9)", //
        45);
  }

  // {45}
  public void test0538() {
    check( //
        "Integrate[(a + b*x)^7*(c + d*x)^10, x]", //
        "-((b*c - a*d)^7*(c + d*x)^11)/(11*d^8) + (7*b*(b*c - a*d)^6*(c + d*x)^12)/(12*d^8) - (21*b^2*(b*c - a*d)^5*(c + d*x)^13)/(13*d^8) + (5*b^3*(b*c - a*d)^4*(c + d*x)^14)/(2*d^8) - (7*b^4*(b*c - a*d)^3*(c + d*x)^15)/(3*d^8) + (21*b^5*(b*c - a*d)^2*(c + d*x)^16)/(16*d^8) - (7*b^6*(b*c - a*d)*(c + d*x)^17)/(17*d^8) + (b^7*(c + d*x)^18)/(18*d^8)", //
        45);
  }

  // {45}
  public void test0539() {
    check( //
        "Integrate[(a + b*x)^6*(c + d*x)^10, x]", //
        "((b*c - a*d)^6*(c + d*x)^11)/(11*d^7) - (b*(b*c - a*d)^5*(c + d*x)^12)/(2*d^7) + (15*b^2*(b*c - a*d)^4*(c + d*x)^13)/(13*d^7) - (10*b^3*(b*c - a*d)^3*(c + d*x)^14)/(7*d^7) + (b^4*(b*c - a*d)^2*(c + d*x)^15)/d^7 - (3*b^5*(b*c - a*d)*(c + d*x)^16)/(8*d^7) + (b^6*(c + d*x)^17)/(17*d^7)", //
        45);
  }

  // {45}
  public void test0540() {
    check( //
        "Integrate[(a + b*x)^5*(c + d*x)^10, x]", //
        "-((b*c - a*d)^5*(c + d*x)^11)/(11*d^6) + (5*b*(b*c - a*d)^4*(c + d*x)^12)/(12*d^6) - (10*b^2*(b*c - a*d)^3*(c + d*x)^13)/(13*d^6) + (5*b^3*(b*c - a*d)^2*(c + d*x)^14)/(7*d^6) - (b^4*(b*c - a*d)*(c + d*x)^15)/(3*d^6) + (b^5*(c + d*x)^16)/(16*d^6)", //
        45);
  }

  // {45}
  public void test0541() {
    check( //
        "Integrate[(a + b*x)^4*(c + d*x)^10, x]", //
        "((b*c - a*d)^4*(c + d*x)^11)/(11*d^5) - (b*(b*c - a*d)^3*(c + d*x)^12)/(3*d^5) + (6*b^2*(b*c - a*d)^2*(c + d*x)^13)/(13*d^5) - (2*b^3*(b*c - a*d)*(c + d*x)^14)/(7*d^5) + (b^4*(c + d*x)^15)/(15*d^5)", //
        45);
  }

  // {45}
  public void test0542() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^10, x]", //
        "-((b*c - a*d)^3*(c + d*x)^11)/(11*d^4) + (b*(b*c - a*d)^2*(c + d*x)^12)/(4*d^4) - (3*b^2*(b*c - a*d)*(c + d*x)^13)/(13*d^4) + (b^3*(c + d*x)^14)/(14*d^4)", //
        45);
  }

  // {45}
  public void test0543() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^10, x]", //
        "((b*c - a*d)^2*(c + d*x)^11)/(11*d^3) - (b*(b*c - a*d)*(c + d*x)^12)/(6*d^3) + (b^2*(c + d*x)^13)/(13*d^3)", //
        45);
  }

  // {45}
  public void test0544() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^10, x]", //
        "-((b*c - a*d)*(c + d*x)^11)/(11*d^2) + (b*(c + d*x)^12)/(12*d^2)", //
        45);
  }

  // {45}
  public void test0545() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x), x]", //
        "(d*(b*c - a*d)^9*x)/b^10 + ((b*c - a*d)^8*(c + d*x)^2)/(2*b^9) + ((b*c - a*d)^7*(c + d*x)^3)/(3*b^8) + ((b*c - a*d)^6*(c + d*x)^4)/(4*b^7) + ((b*c - a*d)^5*(c + d*x)^5)/(5*b^6) + ((b*c - a*d)^4*(c + d*x)^6)/(6*b^5) + ((b*c - a*d)^3*(c + d*x)^7)/(7*b^4) + ((b*c - a*d)^2*(c + d*x)^8)/(8*b^3) + ((b*c - a*d)*(c + d*x)^9)/(9*b^2) + (c + d*x)^10/(10*b) + ((b*c - a*d)^10*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0546() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^2, x]", //
        "(45*d^2*(b*c - a*d)^8*x)/b^10 - (b*c - a*d)^10/(b^11*(a + b*x)) + (60*d^3*(b*c - a*d)^7*(a + b*x)^2)/b^11 + (70*d^4*(b*c - a*d)^6*(a + b*x)^3)/b^11 + (63*d^5*(b*c - a*d)^5*(a + b*x)^4)/b^11 + (42*d^6*(b*c - a*d)^4*(a + b*x)^5)/b^11 + (20*d^7*(b*c - a*d)^3*(a + b*x)^6)/b^11 + (45*d^8*(b*c - a*d)^2*(a + b*x)^7)/(7*b^11) + (5*d^9*(b*c - a*d)*(a + b*x)^8)/(4*b^11) + (d^10*(a + b*x)^9)/(9*b^11) + (10*d*(b*c - a*d)^9*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0547() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^3, x]", //
        "(120*d^3*(b*c - a*d)^7*x)/b^10 - (b*c - a*d)^10/(2*b^11*(a + b*x)^2) - (10*d*(b*c - a*d)^9)/(b^11*(a + b*x)) + (105*d^4*(b*c - a*d)^6*(a + b*x)^2)/b^11 + (84*d^5*(b*c - a*d)^5*(a + b*x)^3)/b^11 + (105*d^6*(b*c - a*d)^4*(a + b*x)^4)/(2*b^11) + (24*d^7*(b*c - a*d)^3*(a + b*x)^5)/b^11 + (15*d^8*(b*c - a*d)^2*(a + b*x)^6)/(2*b^11) + (10*d^9*(b*c - a*d)*(a + b*x)^7)/(7*b^11) + (d^10*(a + b*x)^8)/(8*b^11) + (45*d^2*(b*c - a*d)^8*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0548() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^4, x]", //
        "(210*d^4*(b*c - a*d)^6*x)/b^10 - (b*c - a*d)^10/(3*b^11*(a + b*x)^3) - (5*d*(b*c - a*d)^9)/(b^11*(a + b*x)^2) - (45*d^2*(b*c - a*d)^8)/(b^11*(a + b*x)) + (126*d^5*(b*c - a*d)^5*(a + b*x)^2)/b^11 + (70*d^6*(b*c - a*d)^4*(a + b*x)^3)/b^11 + (30*d^7*(b*c - a*d)^3*(a + b*x)^4)/b^11 + (9*d^8*(b*c - a*d)^2*(a + b*x)^5)/b^11 + (5*d^9*(b*c - a*d)*(a + b*x)^6)/(3*b^11) + (d^10*(a + b*x)^7)/(7*b^11) + (120*d^3*(b*c - a*d)^7*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0549() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^5, x]", //
        "(252*d^5*(b*c - a*d)^5*x)/b^10 - (b*c - a*d)^10/(4*b^11*(a + b*x)^4) - (10*d*(b*c - a*d)^9)/(3*b^11*(a + b*x)^3) - (45*d^2*(b*c - a*d)^8)/(2*b^11*(a + b*x)^2) - (120*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)) + (105*d^6*(b*c - a*d)^4*(a + b*x)^2)/b^11 + (40*d^7*(b*c - a*d)^3*(a + b*x)^3)/b^11 + (45*d^8*(b*c - a*d)^2*(a + b*x)^4)/(4*b^11) + (2*d^9*(b*c - a*d)*(a + b*x)^5)/b^11 + (d^10*(a + b*x)^6)/(6*b^11) + (210*d^4*(b*c - a*d)^6*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0550() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^6, x]", //
        "(210*d^6*(b*c - a*d)^4*x)/b^10 - (b*c - a*d)^10/(5*b^11*(a + b*x)^5) - (5*d*(b*c - a*d)^9)/(2*b^11*(a + b*x)^4) - (15*d^2*(b*c - a*d)^8)/(b^11*(a + b*x)^3) - (60*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^2) - (210*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)) + (60*d^7*(b*c - a*d)^3*(a + b*x)^2)/b^11 + (15*d^8*(b*c - a*d)^2*(a + b*x)^3)/b^11 + (5*d^9*(b*c - a*d)*(a + b*x)^4)/(2*b^11) + (d^10*(a + b*x)^5)/(5*b^11) + (252*d^5*(b*c - a*d)^5*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0551() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^7, x]", //
        "(120*d^7*(b*c - a*d)^3*x)/b^10 - (b*c - a*d)^10/(6*b^11*(a + b*x)^6) - (2*d*(b*c - a*d)^9)/(b^11*(a + b*x)^5) - (45*d^2*(b*c - a*d)^8)/(4*b^11*(a + b*x)^4) - (40*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^3) - (105*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^2) - (252*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)) + (45*d^8*(b*c - a*d)^2*(a + b*x)^2)/(2*b^11) + (10*d^9*(b*c - a*d)*(a + b*x)^3)/(3*b^11) + (d^10*(a + b*x)^4)/(4*b^11) + (210*d^6*(b*c - a*d)^4*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0552() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^8, x]", //
        "(45*d^8*(b*c - a*d)^2*x)/b^10 - (b*c - a*d)^10/(7*b^11*(a + b*x)^7) - (5*d*(b*c - a*d)^9)/(3*b^11*(a + b*x)^6) - (9*d^2*(b*c - a*d)^8)/(b^11*(a + b*x)^5) - (30*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^4) - (70*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^3) - (126*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)^2) - (210*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)) + (5*d^9*(b*c - a*d)*(a + b*x)^2)/b^11 + (d^10*(a + b*x)^3)/(3*b^11) + (120*d^7*(b*c - a*d)^3*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0553() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^9, x]", //
        "(d^9*(10*b*c - 9*a*d)*x)/b^10 + (d^10*x^2)/(2*b^9) - (b*c - a*d)^10/(8*b^11*(a + b*x)^8) - (10*d*(b*c - a*d)^9)/(7*b^11*(a + b*x)^7) - (15*d^2*(b*c - a*d)^8)/(2*b^11*(a + b*x)^6) - (24*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^5) - (105*d^4*(b*c - a*d)^6)/(2*b^11*(a + b*x)^4) - (84*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)^3) - (105*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)^2) - (120*d^7*(b*c - a*d)^3)/(b^11*(a + b*x)) + (45*d^8*(b*c - a*d)^2*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0554() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^10, x]", //
        "(d^10*x)/b^10 - (b*c - a*d)^10/(9*b^11*(a + b*x)^9) - (5*d*(b*c - a*d)^9)/(4*b^11*(a + b*x)^8) - (45*d^2*(b*c - a*d)^8)/(7*b^11*(a + b*x)^7) - (20*d^3*(b*c - a*d)^7)/(b^11*(a + b*x)^6) - (42*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^5) - (63*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)^4) - (70*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)^3) - (60*d^7*(b*c - a*d)^3)/(b^11*(a + b*x)^2) - (45*d^8*(b*c - a*d)^2)/(b^11*(a + b*x)) + (10*d^9*(b*c - a*d)*Log[a + b*x])/b^11", //
        45);
  }

  // {45}
  public void test0555() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^11, x]", //
        "-(b*c - a*d)^10/(10*b^11*(a + b*x)^10) - (10*d*(b*c - a*d)^9)/(9*b^11*(a + b*x)^9) - (45*d^2*(b*c - a*d)^8)/(8*b^11*(a + b*x)^8) - (120*d^3*(b*c - a*d)^7)/(7*b^11*(a + b*x)^7) - (35*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^6) - (252*d^5*(b*c - a*d)^5)/(5*b^11*(a + b*x)^5) - (105*d^6*(b*c - a*d)^4)/(2*b^11*(a + b*x)^4) - (40*d^7*(b*c - a*d)^3)/(b^11*(a + b*x)^3) - (45*d^8*(b*c - a*d)^2)/(2*b^11*(a + b*x)^2) - (10*d^9*(b*c - a*d))/(b^11*(a + b*x)) + (d^10*Log[a + b*x])/b^11", //
        45);
  }

  // {47, 37}
  public void test0556() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^13, x]", //
        "-(c + d*x)^11/(12*(b*c - a*d)*(a + b*x)^12) + (d*(c + d*x)^11)/(132*(b*c - a*d)^2*(a + b*x)^11)", //
        47,
        37);
  }

  // {45}
  public void test0557() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^20, x]", //
        "-(b*c - a*d)^10/(19*b^11*(a + b*x)^19) - (5*d*(b*c - a*d)^9)/(9*b^11*(a + b*x)^18) - (45*d^2*(b*c - a*d)^8)/(17*b^11*(a + b*x)^17) - (15*d^3*(b*c - a*d)^7)/(2*b^11*(a + b*x)^16) - (14*d^4*(b*c - a*d)^6)/(b^11*(a + b*x)^15) - (18*d^5*(b*c - a*d)^5)/(b^11*(a + b*x)^14) - (210*d^6*(b*c - a*d)^4)/(13*b^11*(a + b*x)^13) - (10*d^7*(b*c - a*d)^3)/(b^11*(a + b*x)^12) - (45*d^8*(b*c - a*d)^2)/(11*b^11*(a + b*x)^11) - (d^9*(b*c - a*d))/(b^11*(a + b*x)^10) - d^10/(9*b^11*(a + b*x)^9)", //
        45);
  }

  // {45}
  public void test0558() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^21, x]", //
        "-(b*c - a*d)^10/(20*b^11*(a + b*x)^20) - (10*d*(b*c - a*d)^9)/(19*b^11*(a + b*x)^19) - (5*d^2*(b*c - a*d)^8)/(2*b^11*(a + b*x)^18) - (120*d^3*(b*c - a*d)^7)/(17*b^11*(a + b*x)^17) - (105*d^4*(b*c - a*d)^6)/(8*b^11*(a + b*x)^16) - (84*d^5*(b*c - a*d)^5)/(5*b^11*(a + b*x)^15) - (15*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)^14) - (120*d^7*(b*c - a*d)^3)/(13*b^11*(a + b*x)^13) - (15*d^8*(b*c - a*d)^2)/(4*b^11*(a + b*x)^12) - (10*d^9*(b*c - a*d))/(11*b^11*(a + b*x)^11) - d^10/(10*b^11*(a + b*x)^10)", //
        45);
  }

  // {45}
  public void test0559() {
    check( //
        "Integrate[(c + d*x)^10/(a + b*x)^22, x]", //
        "-(b*c - a*d)^10/(21*b^11*(a + b*x)^21) - (d*(b*c - a*d)^9)/(2*b^11*(a + b*x)^20) - (45*d^2*(b*c - a*d)^8)/(19*b^11*(a + b*x)^19) - (20*d^3*(b*c - a*d)^7)/(3*b^11*(a + b*x)^18) - (210*d^4*(b*c - a*d)^6)/(17*b^11*(a + b*x)^17) - (63*d^5*(b*c - a*d)^5)/(4*b^11*(a + b*x)^16) - (14*d^6*(b*c - a*d)^4)/(b^11*(a + b*x)^15) - (60*d^7*(b*c - a*d)^3)/(7*b^11*(a + b*x)^14) - (45*d^8*(b*c - a*d)^2)/(13*b^11*(a + b*x)^13) - (5*d^9*(b*c - a*d))/(6*b^11*(a + b*x)^12) - d^10/(11*b^11*(a + b*x)^11)", //
        45);
  }

  // {45}
  public void test0560() {
    check( //
        "Integrate[(a + b*x)^5/(c + d*x), x]", //
        "(b*(b*c - a*d)^4*x)/d^5 - ((b*c - a*d)^3*(a + b*x)^2)/(2*d^4) + ((b*c - a*d)^2*(a + b*x)^3)/(3*d^3) - ((b*c - a*d)*(a + b*x)^4)/(4*d^2) + (a + b*x)^5/(5*d) - ((b*c - a*d)^5*Log[c + d*x])/d^6", //
        45);
  }

  // {45}
  public void test0561() {
    check( //
        "Integrate[(a + b*x)^4/(c + d*x), x]", //
        "-((b*(b*c - a*d)^3*x)/d^4) + ((b*c - a*d)^2*(a + b*x)^2)/(2*d^3) - ((b*c - a*d)*(a + b*x)^3)/(3*d^2) + (a + b*x)^4/(4*d) + ((b*c - a*d)^4*Log[c + d*x])/d^5", //
        45);
  }

  // {45}
  public void test0562() {
    check( //
        "Integrate[(a + b*x)^3/(c + d*x), x]", //
        "(b*(b*c - a*d)^2*x)/d^3 - ((b*c - a*d)*(a + b*x)^2)/(2*d^2) + (a + b*x)^3/(3*d) - ((b*c - a*d)^3*Log[c + d*x])/d^4", //
        45);
  }

  // {45}
  public void test0563() {
    check( //
        "Integrate[(a + b*x)^2/(c + d*x), x]", //
        "-((b*(b*c - a*d)*x)/d^2) + (a + b*x)^2/(2*d) + ((b*c - a*d)^2*Log[c + d*x])/d^3", //
        45);
  }

  // {45}
  public void test0564() {
    check( //
        "Integrate[(a + b*x)/(c + d*x), x]", //
        "(b*x)/d - ((b*c - a*d)*Log[c + d*x])/d^2", //
        45);
  }

  // {46}
  public void test0565() {
    check( //
        "Integrate[1/((a + b*x)^2*(c + d*x)), x]", //
        "-(1/((b*c - a*d)*(a + b*x))) - (d*Log[a + b*x])/(b*c - a*d)^2 + (d*Log[c + d*x])/(b*c - a*d)^2", //
        46);
  }

  // {46}
  public void test0566() {
    check( //
        "Integrate[1/((a + b*x)^3*(c + d*x)), x]", //
        "-1/(2*(b*c - a*d)*(a + b*x)^2) + d/((b*c - a*d)^2*(a + b*x)) + (d^2*Log[a + b*x])/(b*c - a*d)^3 - (d^2*Log[c + d*x])/(b*c - a*d)^3", //
        46);
  }

  // {45}
  public void test0567() {
    check( //
        "Integrate[(a + b*x)^5/(c + d*x)^2, x]", //
        "(-10*b^2*(b*c - a*d)^3*x)/d^5 + (b*c - a*d)^5/(d^6*(c + d*x)) + (5*b^3*(b*c - a*d)^2*(c + d*x)^2)/d^6 - (5*b^4*(b*c - a*d)*(c + d*x)^3)/(3*d^6) + (b^5*(c + d*x)^4)/(4*d^6) + (5*b*(b*c - a*d)^4*Log[c + d*x])/d^6", //
        45);
  }

  // {45}
  public void test0568() {
    check( //
        "Integrate[(a + b*x)^4/(c + d*x)^2, x]", //
        "(6*b^2*(b*c - a*d)^2*x)/d^4 - (b*c - a*d)^4/(d^5*(c + d*x)) - (2*b^3*(b*c - a*d)*(c + d*x)^2)/d^5 + (b^4*(c + d*x)^3)/(3*d^5) - (4*b*(b*c - a*d)^3*Log[c + d*x])/d^5", //
        45);
  }

  // {45}
  public void test0569() {
    check( //
        "Integrate[(a + b*x)^3/(c + d*x)^2, x]", //
        "-((b^2*(2*b*c - 3*a*d)*x)/d^3) + (b^3*x^2)/(2*d^2) + (b*c - a*d)^3/(d^4*(c + d*x)) + (3*b*(b*c - a*d)^2*Log[c + d*x])/d^4", //
        45);
  }

  // {45}
  public void test0570() {
    check( //
        "Integrate[(a + b*x)^2/(c + d*x)^2, x]", //
        "(b^2*x)/d^2 - (b*c - a*d)^2/(d^3*(c + d*x)) - (2*b*(b*c - a*d)*Log[c + d*x])/d^3", //
        45);
  }

  // {45}
  public void test0571() {
    check( //
        "Integrate[(a + b*x)/(c + d*x)^2, x]", //
        "(b*c - a*d)/(d^2*(c + d*x)) + (b*Log[c + d*x])/d^2", //
        45);
  }

  // {46}
  public void test0572() {
    check( //
        "Integrate[1/((a + b*x)*(c + d*x)^2), x]", //
        "1/((b*c - a*d)*(c + d*x)) + (b*Log[a + b*x])/(b*c - a*d)^2 - (b*Log[c + d*x])/(b*c - a*d)^2", //
        46);
  }

  // {46}
  public void test0573() {
    check( //
        "Integrate[1/((a + b*x)^2*(c + d*x)^2), x]", //
        "-(b/((b*c - a*d)^2*(a + b*x))) - d/((b*c - a*d)^2*(c + d*x)) - (2*b*d*Log[a + b*x])/(b*c - a*d)^3 + (2*b*d*Log[c + d*x])/(b*c - a*d)^3", //
        46);
  }

  // {46}
  public void test0574() {
    check( //
        "Integrate[1/((a + b*x)^3*(c + d*x)^2), x]", //
        "-b/(2*(b*c - a*d)^2*(a + b*x)^2) + (2*b*d)/((b*c - a*d)^3*(a + b*x)) + d^2/((b*c - a*d)^3*(c + d*x)) + (3*b*d^2*Log[a + b*x])/(b*c - a*d)^4 - (3*b*d^2*Log[c + d*x])/(b*c - a*d)^4", //
        46);
  }

  // {45}
  public void test0575() {
    check( //
        "Integrate[(a + b*x)^6/(c + d*x)^3, x]", //
        "(-20*b^3*(b*c - a*d)^3*x)/d^6 - (b*c - a*d)^6/(2*d^7*(c + d*x)^2) + (6*b*(b*c - a*d)^5)/(d^7*(c + d*x)) + (15*b^4*(b*c - a*d)^2*(c + d*x)^2)/(2*d^7) - (2*b^5*(b*c - a*d)*(c + d*x)^3)/d^7 + (b^6*(c + d*x)^4)/(4*d^7) + (15*b^2*(b*c - a*d)^4*Log[c + d*x])/d^7", //
        45);
  }

  // {45}
  public void test0576() {
    check( //
        "Integrate[(a + b*x)^5/(c + d*x)^3, x]", //
        "(10*b^3*(b*c - a*d)^2*x)/d^5 + (b*c - a*d)^5/(2*d^6*(c + d*x)^2) - (5*b*(b*c - a*d)^4)/(d^6*(c + d*x)) - (5*b^4*(b*c - a*d)*(c + d*x)^2)/(2*d^6) + (b^5*(c + d*x)^3)/(3*d^6) - (10*b^2*(b*c - a*d)^3*Log[c + d*x])/d^6", //
        45);
  }

  // {45}
  public void test0577() {
    check( //
        "Integrate[(a + b*x)^4/(c + d*x)^3, x]", //
        "-((b^3*(3*b*c - 4*a*d)*x)/d^4) + (b^4*x^2)/(2*d^3) - (b*c - a*d)^4/(2*d^5*(c + d*x)^2) + (4*b*(b*c - a*d)^3)/(d^5*(c + d*x)) + (6*b^2*(b*c - a*d)^2*Log[c + d*x])/d^5", //
        45);
  }

  // {45}
  public void test0578() {
    check( //
        "Integrate[(a + b*x)^3/(c + d*x)^3, x]", //
        "(b^3*x)/d^3 + (b*c - a*d)^3/(2*d^4*(c + d*x)^2) - (3*b*(b*c - a*d)^2)/(d^4*(c + d*x)) - (3*b^2*(b*c - a*d)*Log[c + d*x])/d^4", //
        45);
  }

  // {45}
  public void test0579() {
    check( //
        "Integrate[(a + b*x)^2/(c + d*x)^3, x]", //
        "-(b*c - a*d)^2/(2*d^3*(c + d*x)^2) + (2*b*(b*c - a*d))/(d^3*(c + d*x)) + (b^2*Log[c + d*x])/d^3", //
        45);
  }

  // {46}
  public void test0580() {
    check( //
        "Integrate[1/((a + b*x)*(c + d*x)^3), x]", //
        "1/(2*(b*c - a*d)*(c + d*x)^2) + b/((b*c - a*d)^2*(c + d*x)) + (b^2*Log[a + b*x])/(b*c - a*d)^3 - (b^2*Log[c + d*x])/(b*c - a*d)^3", //
        46);
  }

  // {46}
  public void test0581() {
    check( //
        "Integrate[1/((a + b*x)^2*(c + d*x)^3), x]", //
        "-(b^2/((b*c - a*d)^3*(a + b*x))) - d/(2*(b*c - a*d)^2*(c + d*x)^2) - (2*b*d)/((b*c - a*d)^3*(c + d*x)) - (3*b^2*d*Log[a + b*x])/(b*c - a*d)^4 + (3*b^2*d*Log[c + d*x])/(b*c - a*d)^4", //
        46);
  }

  // {46}
  public void test0582() {
    check( //
        "Integrate[1/((a + b*x)^3*(c + d*x)^3), x]", //
        "-b^2/(2*(b*c - a*d)^3*(a + b*x)^2) + (3*b^2*d)/((b*c - a*d)^4*(a + b*x)) + d^2/(2*(b*c - a*d)^3*(c + d*x)^2) + (3*b*d^2)/((b*c - a*d)^4*(c + d*x)) + (6*b^2*d^2*Log[a + b*x])/(b*c - a*d)^5 - (6*b^2*d^2*Log[c + d*x])/(b*c - a*d)^5", //
        46);
  }

  // {45}
  public void test0583() {
    check( //
        "Integrate[(a + b*x)^9/(c + d*x)^8, x]", //
        "-((b^8*(8*b*c - 9*a*d)*x)/d^9) + (b^9*x^2)/(2*d^8) + (b*c - a*d)^9/(7*d^10*(c + d*x)^7) - (3*b*(b*c - a*d)^8)/(2*d^10*(c + d*x)^6) + (36*b^2*(b*c - a*d)^7)/(5*d^10*(c + d*x)^5) - (21*b^3*(b*c - a*d)^6)/(d^10*(c + d*x)^4) + (42*b^4*(b*c - a*d)^5)/(d^10*(c + d*x)^3) - (63*b^5*(b*c - a*d)^4)/(d^10*(c + d*x)^2) + (84*b^6*(b*c - a*d)^3)/(d^10*(c + d*x)) + (36*b^7*(b*c - a*d)^2*Log[c + d*x])/d^10", //
        45);
  }

  // {45}
  public void test0584() {
    check( //
        "Integrate[(a + b*x)^8/(c + d*x)^8, x]", //
        "(b^8*x)/d^8 - (b*c - a*d)^8/(7*d^9*(c + d*x)^7) + (4*b*(b*c - a*d)^7)/(3*d^9*(c + d*x)^6) - (28*b^2*(b*c - a*d)^6)/(5*d^9*(c + d*x)^5) + (14*b^3*(b*c - a*d)^5)/(d^9*(c + d*x)^4) - (70*b^4*(b*c - a*d)^4)/(3*d^9*(c + d*x)^3) + (28*b^5*(b*c - a*d)^3)/(d^9*(c + d*x)^2) - (28*b^6*(b*c - a*d)^2)/(d^9*(c + d*x)) - (8*b^7*(b*c - a*d)*Log[c + d*x])/d^9", //
        45);
  }

  // {45}
  public void test0585() {
    check( //
        "Integrate[(a + b*x)^7/(c + d*x)^8, x]", //
        "(b*c - a*d)^7/(7*d^8*(c + d*x)^7) - (7*b*(b*c - a*d)^6)/(6*d^8*(c + d*x)^6) + (21*b^2*(b*c - a*d)^5)/(5*d^8*(c + d*x)^5) - (35*b^3*(b*c - a*d)^4)/(4*d^8*(c + d*x)^4) + (35*b^4*(b*c - a*d)^3)/(3*d^8*(c + d*x)^3) - (21*b^5*(b*c - a*d)^2)/(2*d^8*(c + d*x)^2) + (7*b^6*(b*c - a*d))/(d^8*(c + d*x)) + (b^7*Log[c + d*x])/d^8", //
        45);
  }

  // {47, 37}
  public void test0586() {
    check( //
        "Integrate[(a + b*x)^5/(c + d*x)^8, x]", //
        "(a + b*x)^6/(7*(b*c - a*d)*(c + d*x)^7) + (b*(a + b*x)^6)/(42*(b*c - a*d)^2*(c + d*x)^6)", //
        47,
        37);
  }

  // {45}
  public void test0587() {
    check( //
        "Integrate[(a + b*x)^3/(c + d*x)^8, x]", //
        "(b*c - a*d)^3/(7*d^4*(c + d*x)^7) - (b*(b*c - a*d)^2)/(2*d^4*(c + d*x)^6) + (3*b^2*(b*c - a*d))/(5*d^4*(c + d*x)^5) - b^3/(4*d^4*(c + d*x)^4)", //
        45);
  }

  // {45}
  public void test0588() {
    check( //
        "Integrate[(a + b*x)^2/(c + d*x)^8, x]", //
        "-(b*c - a*d)^2/(7*d^3*(c + d*x)^7) + (b*(b*c - a*d))/(3*d^3*(c + d*x)^6) - b^2/(5*d^3*(c + d*x)^5)", //
        45);
  }

  // {45}
  public void test0589() {
    check( //
        "Integrate[(a + b*x)/(c + d*x)^8, x]", //
        "(b*c - a*d)/(7*d^2*(c + d*x)^7) - b/(6*d^2*(c + d*x)^6)", //
        45);
  }

  // {46}
  public void test0590() {
    check( //
        "Integrate[1/((a + b*x)*(c + d*x)^8), x]", //
        "1/(7*(b*c - a*d)*(c + d*x)^7) + b/(6*(b*c - a*d)^2*(c + d*x)^6) + b^2/(5*(b*c - a*d)^3*(c + d*x)^5) + b^3/(4*(b*c - a*d)^4*(c + d*x)^4) + b^4/(3*(b*c - a*d)^5*(c + d*x)^3) + b^5/(2*(b*c - a*d)^6*(c + d*x)^2) + b^6/((b*c - a*d)^7*(c + d*x)) + (b^7*Log[a + b*x])/(b*c - a*d)^8 - (b^7*Log[c + d*x])/(b*c - a*d)^8", //
        46);
  }

  // {46}
  public void test0591() {
    check( //
        "Integrate[1/((a + b*x)^2*(c + d*x)^8), x]", //
        "-(b^7/((b*c - a*d)^8*(a + b*x))) - d/(7*(b*c - a*d)^2*(c + d*x)^7) - (b*d)/(3*(b*c - a*d)^3*(c + d*x)^6) - (3*b^2*d)/(5*(b*c - a*d)^4*(c + d*x)^5) - (b^3*d)/((b*c - a*d)^5*(c + d*x)^4) - (5*b^4*d)/(3*(b*c - a*d)^6*(c + d*x)^3) - (3*b^5*d)/((b*c - a*d)^7*(c + d*x)^2) - (7*b^6*d)/((b*c - a*d)^8*(c + d*x)) - (8*b^7*d*Log[a + b*x])/(b*c - a*d)^9 + (8*b^7*d*Log[c + d*x])/(b*c - a*d)^9", //
        46);
  }

  // {46}
  public void test0592() {
    check( //
        "Integrate[1/((a + b*x)^3*(c + d*x)^8), x]", //
        "-b^7/(2*(b*c - a*d)^8*(a + b*x)^2) + (8*b^7*d)/((b*c - a*d)^9*(a + b*x)) + d^2/(7*(b*c - a*d)^3*(c + d*x)^7) + (b*d^2)/(2*(b*c - a*d)^4*(c + d*x)^6) + (6*b^2*d^2)/(5*(b*c - a*d)^5*(c + d*x)^5) + (5*b^3*d^2)/(2*(b*c - a*d)^6*(c + d*x)^4) + (5*b^4*d^2)/((b*c - a*d)^7*(c + d*x)^3) + (21*b^5*d^2)/(2*(b*c - a*d)^8*(c + d*x)^2) + (28*b^6*d^2)/((b*c - a*d)^9*(c + d*x)) + (36*b^7*d^2*Log[a + b*x])/(b*c - a*d)^10 - (36*b^7*d^2*Log[c + d*x])/(b*c - a*d)^10", //
        46);
  }

  // {45}
  public void test0593() {
    check( //
        "Integrate[(a + b*x)^5*Sqrt[c + d*x], x]", //
        "(-2*(b*c - a*d)^5*(c + d*x)^(3/2))/(3*d^6) + (2*b*(b*c - a*d)^4*(c + d*x)^(5/2))/d^6 - (20*b^2*(b*c - a*d)^3*(c + d*x)^(7/2))/(7*d^6) + (20*b^3*(b*c - a*d)^2*(c + d*x)^(9/2))/(9*d^6) - (10*b^4*(b*c - a*d)*(c + d*x)^(11/2))/(11*d^6) + (2*b^5*(c + d*x)^(13/2))/(13*d^6)", //
        45);
  }

  // {45}
  public void test0594() {
    check( //
        "Integrate[(a + b*x)^4*Sqrt[c + d*x], x]", //
        "(2*(b*c - a*d)^4*(c + d*x)^(3/2))/(3*d^5) - (8*b*(b*c - a*d)^3*(c + d*x)^(5/2))/(5*d^5) + (12*b^2*(b*c - a*d)^2*(c + d*x)^(7/2))/(7*d^5) - (8*b^3*(b*c - a*d)*(c + d*x)^(9/2))/(9*d^5) + (2*b^4*(c + d*x)^(11/2))/(11*d^5)", //
        45);
  }

  // {45}
  public void test0595() {
    check( //
        "Integrate[(a + b*x)^3*Sqrt[c + d*x], x]", //
        "(-2*(b*c - a*d)^3*(c + d*x)^(3/2))/(3*d^4) + (6*b*(b*c - a*d)^2*(c + d*x)^(5/2))/(5*d^4) - (6*b^2*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^4) + (2*b^3*(c + d*x)^(9/2))/(9*d^4)", //
        45);
  }

  // {45}
  public void test0596() {
    check( //
        "Integrate[(a + b*x)^2*Sqrt[c + d*x], x]", //
        "(2*(b*c - a*d)^2*(c + d*x)^(3/2))/(3*d^3) - (4*b*(b*c - a*d)*(c + d*x)^(5/2))/(5*d^3) + (2*b^2*(c + d*x)^(7/2))/(7*d^3)", //
        45);
  }

  // {45}
  public void test0597() {
    check( //
        "Integrate[(a + b*x)*Sqrt[c + d*x], x]", //
        "(-2*(b*c - a*d)*(c + d*x)^(3/2))/(3*d^2) + (2*b*(c + d*x)^(5/2))/(5*d^2)", //
        45);
  }

  // {45}
  public void test0598() {
    check( //
        "Integrate[(a + b*x)^5*(c + d*x)^(3/2), x]", //
        "(-2*(b*c - a*d)^5*(c + d*x)^(5/2))/(5*d^6) + (10*b*(b*c - a*d)^4*(c + d*x)^(7/2))/(7*d^6) - (20*b^2*(b*c - a*d)^3*(c + d*x)^(9/2))/(9*d^6) + (20*b^3*(b*c - a*d)^2*(c + d*x)^(11/2))/(11*d^6) - (10*b^4*(b*c - a*d)*(c + d*x)^(13/2))/(13*d^6) + (2*b^5*(c + d*x)^(15/2))/(15*d^6)", //
        45);
  }

  // {45}
  public void test0599() {
    check( //
        "Integrate[(a + b*x)^4*(c + d*x)^(3/2), x]", //
        "(2*(b*c - a*d)^4*(c + d*x)^(5/2))/(5*d^5) - (8*b*(b*c - a*d)^3*(c + d*x)^(7/2))/(7*d^5) + (4*b^2*(b*c - a*d)^2*(c + d*x)^(9/2))/(3*d^5) - (8*b^3*(b*c - a*d)*(c + d*x)^(11/2))/(11*d^5) + (2*b^4*(c + d*x)^(13/2))/(13*d^5)", //
        45);
  }

  // {45}
  public void test0600() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^(3/2), x]", //
        "(-2*(b*c - a*d)^3*(c + d*x)^(5/2))/(5*d^4) + (6*b*(b*c - a*d)^2*(c + d*x)^(7/2))/(7*d^4) - (2*b^2*(b*c - a*d)*(c + d*x)^(9/2))/(3*d^4) + (2*b^3*(c + d*x)^(11/2))/(11*d^4)", //
        45);
  }

  // {45}
  public void test0601() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^(3/2), x]", //
        "(2*(b*c - a*d)^2*(c + d*x)^(5/2))/(5*d^3) - (4*b*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^3) + (2*b^2*(c + d*x)^(9/2))/(9*d^3)", //
        45);
  }

  // {45}
  public void test0602() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^(3/2), x]", //
        "(-2*(b*c - a*d)*(c + d*x)^(5/2))/(5*d^2) + (2*b*(c + d*x)^(7/2))/(7*d^2)", //
        45);
  }

  // {45}
  public void test0603() {
    check( //
        "Integrate[(a + b*x)^5*(c + d*x)^(5/2), x]", //
        "(-2*(b*c - a*d)^5*(c + d*x)^(7/2))/(7*d^6) + (10*b*(b*c - a*d)^4*(c + d*x)^(9/2))/(9*d^6) - (20*b^2*(b*c - a*d)^3*(c + d*x)^(11/2))/(11*d^6) + (20*b^3*(b*c - a*d)^2*(c + d*x)^(13/2))/(13*d^6) - (2*b^4*(b*c - a*d)*(c + d*x)^(15/2))/(3*d^6) + (2*b^5*(c + d*x)^(17/2))/(17*d^6)", //
        45);
  }

  // {45}
  public void test0604() {
    check( //
        "Integrate[(a + b*x)^4*(c + d*x)^(5/2), x]", //
        "(2*(b*c - a*d)^4*(c + d*x)^(7/2))/(7*d^5) - (8*b*(b*c - a*d)^3*(c + d*x)^(9/2))/(9*d^5) + (12*b^2*(b*c - a*d)^2*(c + d*x)^(11/2))/(11*d^5) - (8*b^3*(b*c - a*d)*(c + d*x)^(13/2))/(13*d^5) + (2*b^4*(c + d*x)^(15/2))/(15*d^5)", //
        45);
  }

  // {45}
  public void test0605() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^(5/2), x]", //
        "(-2*(b*c - a*d)^3*(c + d*x)^(7/2))/(7*d^4) + (2*b*(b*c - a*d)^2*(c + d*x)^(9/2))/(3*d^4) - (6*b^2*(b*c - a*d)*(c + d*x)^(11/2))/(11*d^4) + (2*b^3*(c + d*x)^(13/2))/(13*d^4)", //
        45);
  }

  // {45}
  public void test0606() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^(5/2), x]", //
        "(2*(b*c - a*d)^2*(c + d*x)^(7/2))/(7*d^3) - (4*b*(b*c - a*d)*(c + d*x)^(9/2))/(9*d^3) + (2*b^2*(c + d*x)^(11/2))/(11*d^3)", //
        45);
  }

  // {45}
  public void test0607() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^(5/2), x]", //
        "(-2*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^2) + (2*b*(c + d*x)^(9/2))/(9*d^2)", //
        45);
  }

  // {45}
  public void test0608() {
    check( //
        "Integrate[(a + b*x)^5/Sqrt[c + d*x], x]", //
        "(-2*(b*c - a*d)^5*Sqrt[c + d*x])/d^6 + (10*b*(b*c - a*d)^4*(c + d*x)^(3/2))/(3*d^6) - (4*b^2*(b*c - a*d)^3*(c + d*x)^(5/2))/d^6 + (20*b^3*(b*c - a*d)^2*(c + d*x)^(7/2))/(7*d^6) - (10*b^4*(b*c - a*d)*(c + d*x)^(9/2))/(9*d^6) + (2*b^5*(c + d*x)^(11/2))/(11*d^6)", //
        45);
  }

  // {45}
  public void test0609() {
    check( //
        "Integrate[(a + b*x)^4/Sqrt[c + d*x], x]", //
        "(2*(b*c - a*d)^4*Sqrt[c + d*x])/d^5 - (8*b*(b*c - a*d)^3*(c + d*x)^(3/2))/(3*d^5) + (12*b^2*(b*c - a*d)^2*(c + d*x)^(5/2))/(5*d^5) - (8*b^3*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^5) + (2*b^4*(c + d*x)^(9/2))/(9*d^5)", //
        45);
  }

  // {45}
  public void test0610() {
    check( //
        "Integrate[(a + b*x)^3/Sqrt[c + d*x], x]", //
        "(-2*(b*c - a*d)^3*Sqrt[c + d*x])/d^4 + (2*b*(b*c - a*d)^2*(c + d*x)^(3/2))/d^4 - (6*b^2*(b*c - a*d)*(c + d*x)^(5/2))/(5*d^4) + (2*b^3*(c + d*x)^(7/2))/(7*d^4)", //
        45);
  }

  // {45}
  public void test0611() {
    check( //
        "Integrate[(a + b*x)^2/Sqrt[c + d*x], x]", //
        "(2*(b*c - a*d)^2*Sqrt[c + d*x])/d^3 - (4*b*(b*c - a*d)*(c + d*x)^(3/2))/(3*d^3) + (2*b^2*(c + d*x)^(5/2))/(5*d^3)", //
        45);
  }

  // {45}
  public void test0612() {
    check( //
        "Integrate[(a + b*x)/Sqrt[c + d*x], x]", //
        "(-2*(b*c - a*d)*Sqrt[c + d*x])/d^2 + (2*b*(c + d*x)^(3/2))/(3*d^2)", //
        45);
  }

  // {65, 214}
  public void test0613() {
    check( //
        "Integrate[1/((a + b*x)*Sqrt[c + d*x]), x]", //
        "(-2*ArcTanh[(Sqrt[b]*Sqrt[c + d*x])/Sqrt[b*c - a*d]])/(Sqrt[b]*Sqrt[b*c - a*d])", //
        65,
        214);
  }

  // {45}
  public void test0614() {
    check( //
        "Integrate[(a + b*x)^5/(c + d*x)^(3/2), x]", //
        "(2*(b*c - a*d)^5)/(d^6*Sqrt[c + d*x]) + (10*b*(b*c - a*d)^4*Sqrt[c + d*x])/d^6 - (20*b^2*(b*c - a*d)^3*(c + d*x)^(3/2))/(3*d^6) + (4*b^3*(b*c - a*d)^2*(c + d*x)^(5/2))/d^6 - (10*b^4*(b*c - a*d)*(c + d*x)^(7/2))/(7*d^6) + (2*b^5*(c + d*x)^(9/2))/(9*d^6)", //
        45);
  }

  // {45}
  public void test0615() {
    check( //
        "Integrate[(a + b*x)^4/(c + d*x)^(3/2), x]", //
        "(-2*(b*c - a*d)^4)/(d^5*Sqrt[c + d*x]) - (8*b*(b*c - a*d)^3*Sqrt[c + d*x])/d^5 + (4*b^2*(b*c - a*d)^2*(c + d*x)^(3/2))/d^5 - (8*b^3*(b*c - a*d)*(c + d*x)^(5/2))/(5*d^5) + (2*b^4*(c + d*x)^(7/2))/(7*d^5)", //
        45);
  }

  // {45}
  public void test0616() {
    check( //
        "Integrate[(a + b*x)^3/(c + d*x)^(3/2), x]", //
        "(2*(b*c - a*d)^3)/(d^4*Sqrt[c + d*x]) + (6*b*(b*c - a*d)^2*Sqrt[c + d*x])/d^4 - (2*b^2*(b*c - a*d)*(c + d*x)^(3/2))/d^4 + (2*b^3*(c + d*x)^(5/2))/(5*d^4)", //
        45);
  }

  // {45}
  public void test0617() {
    check( //
        "Integrate[(a + b*x)^2/(c + d*x)^(3/2), x]", //
        "(-2*(b*c - a*d)^2)/(d^3*Sqrt[c + d*x]) - (4*b*(b*c - a*d)*Sqrt[c + d*x])/d^3 + (2*b^2*(c + d*x)^(3/2))/(3*d^3)", //
        45);
  }

  // {45}
  public void test0618() {
    check( //
        "Integrate[(a + b*x)/(c + d*x)^(3/2), x]", //
        "(2*(b*c - a*d))/(d^2*Sqrt[c + d*x]) + (2*b*Sqrt[c + d*x])/d^2", //
        45);
  }

  // {45}
  public void test0619() {
    check( //
        "Integrate[(a + b*x)^5/(c + d*x)^(5/2), x]", //
        "(2*(b*c - a*d)^5)/(3*d^6*(c + d*x)^(3/2)) - (10*b*(b*c - a*d)^4)/(d^6*Sqrt[c + d*x]) - (20*b^2*(b*c - a*d)^3*Sqrt[c + d*x])/d^6 + (20*b^3*(b*c - a*d)^2*(c + d*x)^(3/2))/(3*d^6) - (2*b^4*(b*c - a*d)*(c + d*x)^(5/2))/d^6 + (2*b^5*(c + d*x)^(7/2))/(7*d^6)", //
        45);
  }

  // {45}
  public void test0620() {
    check( //
        "Integrate[(a + b*x)^4/(c + d*x)^(5/2), x]", //
        "(-2*(b*c - a*d)^4)/(3*d^5*(c + d*x)^(3/2)) + (8*b*(b*c - a*d)^3)/(d^5*Sqrt[c + d*x]) + (12*b^2*(b*c - a*d)^2*Sqrt[c + d*x])/d^5 - (8*b^3*(b*c - a*d)*(c + d*x)^(3/2))/(3*d^5) + (2*b^4*(c + d*x)^(5/2))/(5*d^5)", //
        45);
  }

  // {45}
  public void test0621() {
    check( //
        "Integrate[(a + b*x)^3/(c + d*x)^(5/2), x]", //
        "(2*(b*c - a*d)^3)/(3*d^4*(c + d*x)^(3/2)) - (6*b*(b*c - a*d)^2)/(d^4*Sqrt[c + d*x]) - (6*b^2*(b*c - a*d)*Sqrt[c + d*x])/d^4 + (2*b^3*(c + d*x)^(3/2))/(3*d^4)", //
        45);
  }

  // {45}
  public void test0622() {
    check( //
        "Integrate[(a + b*x)^2/(c + d*x)^(5/2), x]", //
        "(-2*(b*c - a*d)^2)/(3*d^3*(c + d*x)^(3/2)) + (4*b*(b*c - a*d))/(d^3*Sqrt[c + d*x]) + (2*b^2*Sqrt[c + d*x])/d^3", //
        45);
  }

  // {45}
  public void test0623() {
    check( //
        "Integrate[(a + b*x)/(c + d*x)^(5/2), x]", //
        "(2*(b*c - a*d))/(3*d^2*(c + d*x)^(3/2)) - (2*b)/(d^2*Sqrt[c + d*x])", //
        45);
  }

  // {21, 32}
  public void test0624() {
    check( //
        "Integrate[(a + b*x)^5*(a*c + b*c*x)^(3/2), x]", //
        "(2*(a*c + b*c*x)^(15/2))/(15*b*c^6)", //
        21,
        32);
  }

  // {21, 32}
  public void test0625() {
    check( //
        "Integrate[(a + b*x)^5*Sqrt[a*c + b*c*x], x]", //
        "(2*(a*c + b*c*x)^(13/2))/(13*b*c^6)", //
        21,
        32);
  }

  // {21, 32}
  public void test0626() {
    check( //
        "Integrate[(a + b*x)^5/Sqrt[a*c + b*c*x], x]", //
        "(2*(a*c + b*c*x)^(11/2))/(11*b*c^6)", //
        21,
        32);
  }

  // {21, 32}
  public void test0627() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^(3/2), x]", //
        "(2*(a*c + b*c*x)^(9/2))/(9*b*c^6)", //
        21,
        32);
  }

  // {21, 32}
  public void test0628() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^(5/2), x]", //
        "(2*(a*c + b*c*x)^(7/2))/(7*b*c^6)", //
        21,
        32);
  }

  // {21, 32}
  public void test0629() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^(7/2), x]", //
        "(2*(a*c + b*c*x)^(5/2))/(5*b*c^6)", //
        21,
        32);
  }

  // {21, 32}
  public void test0630() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^(9/2), x]", //
        "(2*(a*c + b*c*x)^(3/2))/(3*b*c^6)", //
        21,
        32);
  }

  // {21, 32}
  public void test0631() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^(11/2), x]", //
        "(2*Sqrt[a*c + b*c*x])/(b*c^6)", //
        21,
        32);
  }

  // {21, 32}
  public void test0632() {
    check( //
        "Integrate[(a + b*x)^5/(a*c + b*c*x)^(13/2), x]", //
        "-2/(b*c^6*Sqrt[a*c + b*c*x])", //
        21,
        32);
  }

  // {65, 213}
  public void test0633() {
    check( //
        "Integrate[1/((-2 + x)*Sqrt[2 + x]), x]", //
        "-ArcTanh[Sqrt[2 + x]/2]", //
        65,
        213);
  }

  // {65, 209}
  public void test0634() {
    check( //
        "Integrate[1/((2 + 3*x)*Sqrt[1 + 5*x]), x]", //
        "(2*ArcTan[Sqrt[3/7]*Sqrt[1 + 5*x]])/Sqrt[21]", //
        65,
        209);
  }

  // {45}
  public void test0635() {
    check( //
        "Integrate[(3 - 2*x)^(1/3)*(7 + x), x]", //
        "(-51*(3 - 2*x)^(4/3))/16 + (3*(3 - 2*x)^(7/3))/28", //
        45);
  }

  // {45}
  public void test0636() {
    check( //
        "Integrate[(1 - x)^(1/3)*(1 + x)^2, x]", //
        "-3*(1 - x)^(4/3) + (12*(1 - x)^(7/3))/7 - (3*(1 - x)^(10/3))/10", //
        45);
  }

  // {47, 37}
  public void test0637() {
    check( //
        "Integrate[Sqrt[c + d*x]/(a + b*x)^(7/2), x]", //
        "(-2*(c + d*x)^(3/2))/(5*(b*c - a*d)*(a + b*x)^(5/2)) + (4*d*(c + d*x)^(3/2))/(15*(b*c - a*d)^2*(a + b*x)^(3/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0638() {
    check( //
        "Integrate[(c + d*x)^(3/2)/(a + b*x)^(9/2), x]", //
        "(-2*(c + d*x)^(5/2))/(7*(b*c - a*d)*(a + b*x)^(7/2)) + (4*d*(c + d*x)^(5/2))/(35*(b*c - a*d)^2*(a + b*x)^(5/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0639() {
    check( //
        "Integrate[(c + d*x)^(5/2)/(a + b*x)^(11/2), x]", //
        "(-2*(c + d*x)^(7/2))/(9*(b*c - a*d)*(a + b*x)^(9/2)) + (4*d*(c + d*x)^(7/2))/(63*(b*c - a*d)^2*(a + b*x)^(7/2))", //
        47,
        37);
  }

  // {47, 37}
  public void test0640() {
    check( //
        "Integrate[1/((a + b*x)^(5/2)*Sqrt[c + d*x]), x]", //
        "(-2*Sqrt[c + d*x])/(3*(b*c - a*d)*(a + b*x)^(3/2)) + (4*d*Sqrt[c + d*x])/(3*(b*c - a*d)^2*Sqrt[a + b*x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0641() {
    check( //
        "Integrate[1/((a + b*x)^(3/2)*(c + d*x)^(3/2)), x]", //
        "-2/((b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x]) - (4*d*Sqrt[a + b*x])/((b*c - a*d)^2*Sqrt[c + d*x])", //
        47,
        37);
  }

  // {47, 37}
  public void test0642() {
    check( //
        "Integrate[1/(Sqrt[a + b*x]*(c + d*x)^(5/2)), x]", //
        "(2*Sqrt[a + b*x])/(3*(b*c - a*d)*(c + d*x)^(3/2)) + (4*b*Sqrt[a + b*x])/(3*(b*c - a*d)^2*Sqrt[c + d*x])", //
        47,
        37);
  }

  // {65, 221}
  public void test0643() {
    check( //
        "Integrate[1/(Sqrt[a + b*x]*Sqrt[4 + a + b*x]), x]", //
        "(2*ArcSinh[Sqrt[a + b*x]/2])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0644() {
    check( //
        "Integrate[1/(Sqrt[2 + b*x]*Sqrt[6 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[2 + b*x]/2])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0645() {
    check( //
        "Integrate[1/(Sqrt[1 + b*x]*Sqrt[5 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[1 + b*x]/2])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0646() {
    check( //
        "Integrate[1/(Sqrt[b*x]*Sqrt[4 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[b*x]/2])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0647() {
    check( //
        "Integrate[1/(Sqrt[-1 + b*x]*Sqrt[3 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[-1 + b*x]/2])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0648() {
    check( //
        "Integrate[1/(Sqrt[-3 + b*x]*Sqrt[1 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[-3 + b*x]/2])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0649() {
    check( //
        "Integrate[1/(Sqrt[2 + b*x]*Sqrt[3 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[2 + b*x]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0650() {
    check( //
        "Integrate[1/(Sqrt[1 + b*x]*Sqrt[2 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[1 + b*x]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0651() {
    check( //
        "Integrate[1/(Sqrt[b*x]*Sqrt[2 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[b*x]/Sqrt[2]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0652() {
    check( //
        "Integrate[1/(Sqrt[-1 + b*x]*Sqrt[2 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[-1 + b*x]/Sqrt[3]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0653() {
    check( //
        "Integrate[1/(Sqrt[-3 + b*x]*Sqrt[2 + b*x]), x]", //
        "(2*ArcSinh[Sqrt[-3 + b*x]/Sqrt[5]])/b", //
        65,
        221);
  }

  // {41, 222}
  public void test0654() {
    check( //
        "Integrate[1/(Sqrt[2 - b*x]*Sqrt[2 + b*x]), x]", //
        "ArcSin[(b*x)/2]/b", //
        41,
        222);
  }

  // {23, 31}
  public void test0655() {
    check( //
        "Integrate[1/(Sqrt[-2 - b*x]*Sqrt[2 + b*x]), x]", //
        "(Sqrt[2 + b*x]*Log[2 + b*x])/(b*Sqrt[-2 - b*x])", //
        23,
        31);
  }

  // {65, 221}
  public void test0656() {
    check( //
        "Integrate[1/(Sqrt[2 - b*x]*Sqrt[3 - b*x]), x]", //
        "(-2*ArcSinh[Sqrt[2 - b*x]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0657() {
    check( //
        "Integrate[1/(Sqrt[1 - b*x]*Sqrt[2 - b*x]), x]", //
        "(-2*ArcSinh[Sqrt[1 - b*x]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0658() {
    check( //
        "Integrate[1/(Sqrt[-(b*x)]*Sqrt[2 - b*x]), x]", //
        "(-2*ArcSinh[Sqrt[-(b*x)]/Sqrt[2]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0659() {
    check( //
        "Integrate[1/(Sqrt[-1 - b*x]*Sqrt[2 - b*x]), x]", //
        "(-2*ArcSinh[Sqrt[-1 - b*x]/Sqrt[3]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0660() {
    check( //
        "Integrate[1/(Sqrt[-3 - b*x]*Sqrt[2 - b*x]), x]", //
        "(-2*ArcSinh[Sqrt[-3 - b*x]/Sqrt[5]])/b", //
        65,
        221);
  }

  // {65, 221}
  public void test0661() {
    check( //
        "Integrate[1/(Sqrt[(-b + b*c)/d + b*x]*Sqrt[c + d*x]), x]", //
        "(2*ArcSinh[(Sqrt[d]*Sqrt[-((b*(1 - c))/d) + b*x])/Sqrt[b]])/(Sqrt[b]*Sqrt[d])", //
        65,
        221);
  }

  // {56, 221}
  public void test0662() {
    check( //
        "Integrate[1/(Sqrt[x]*Sqrt[-3 + 2*x]), x]", //
        "Sqrt[2]*ArcSinh[Sqrt[-3 + 2*x]/Sqrt[3]]", //
        56,
        221);
  }

  // {56, 221}
  public void test0663() {
    check( //
        "Integrate[1/(Sqrt[-3 + 2*x]*Sqrt[2 + 3*x]), x]", //
        "Sqrt[2/3]*ArcSinh[Sqrt[3/13]*Sqrt[-3 + 2*x]]", //
        56,
        221);
  }

  // {65, 222}
  public void test0664() {
    check( //
        "Integrate[1/(Sqrt[(b - b*c)/d + b*x]*Sqrt[c - d*x]), x]", //
        "(2*ArcSin[(Sqrt[d]*Sqrt[(b*(1 - c))/d + b*x])/Sqrt[b]])/(Sqrt[b]*Sqrt[d])", //
        65,
        222);
  }

  // {56, 222}
  public void test0665() {
    check( //
        "Integrate[1/(Sqrt[3 - 2*x]*Sqrt[x]), x]", //
        "Sqrt[2]*ArcSin[Sqrt[2/3]*Sqrt[x]]", //
        56,
        222);
  }

  // {56, 222}
  public void test0666() {
    check( //
        "Integrate[1/(Sqrt[3 - 2*x]*Sqrt[3 + 5*x]), x]", //
        "Sqrt[2/5]*ArcSin[Sqrt[2/21]*Sqrt[3 + 5*x]]", //
        56,
        222);
  }

  // {65, 225}
  public void test0667() {
    check( //
        "Integrate[1/(Sqrt[a + b*x]*(c + d*x)^(2/3)), x]", //
        "(-2*3^(3/4)*Sqrt[2 - Sqrt[3]]*((b*c - a*d)^(1/3) - b^(1/3)*(c + d*x)^(1/3))*Sqrt[((b*c - a*d)^(2/3) + b^(1/3)*(b*c - a*d)^(1/3)*(c + d*x)^(1/3) + b^(2/3)*(c + d*x)^(2/3))/((1 - Sqrt[3])*(b*c - a*d)^(1/3) - b^(1/3)*(c + d*x)^(1/3))^2]*EllipticF[ArcSin[((1 + Sqrt[3])*(b*c - a*d)^(1/3) - b^(1/3)*(c + d*x)^(1/3))/((1 - Sqrt[3])*(b*c - a*d)^(1/3) - b^(1/3)*(c + d*x)^(1/3))], -7 + 4*Sqrt[3]])/(b^(1/3)*d*Sqrt[a + b*x]*Sqrt[-(((b*c - a*d)^(1/3)*((b*c - a*d)^(1/3) - b^(1/3)*(c + d*x)^(1/3)))/((1 - Sqrt[3])*(b*c - a*d)^(1/3) - b^(1/3)*(c + d*x)^(1/3))^2)])", //
        65,
        225);
  }

  // {52, 61}
  public void test0668() {
    check( //
        "Integrate[(c + d*x)^(1/3)/(a + b*x)^(1/3), x]", //
        "((a + b*x)^(2/3)*(c + d*x)^(1/3))/b - ((b*c - a*d)*ArcTan[1/Sqrt[3] + (2*d^(1/3)*(a + b*x)^(1/3))/(Sqrt[3]*b^(1/3)*(c + d*x)^(1/3))])/(Sqrt[3]*b^(4/3)*d^(2/3)) - ((b*c - a*d)*Log[c + d*x])/(6*b^(4/3)*d^(2/3)) - ((b*c - a*d)*Log[-1 + (d^(1/3)*(a + b*x)^(1/3))/(b^(1/3)*(c + d*x)^(1/3))])/(2*b^(4/3)*d^(2/3))", //
        52,
        61);
  }

  // {49, 61}
  public void test0669() {
    check( //
        "Integrate[(c + d*x)^(1/3)/(a + b*x)^(4/3), x]", //
        "(-3*(c + d*x)^(1/3))/(b*(a + b*x)^(1/3)) - (Sqrt[3]*d^(1/3)*ArcTan[1/Sqrt[3] + (2*d^(1/3)*(a + b*x)^(1/3))/(Sqrt[3]*b^(1/3)*(c + d*x)^(1/3))])/b^(4/3) - (d^(1/3)*Log[c + d*x])/(2*b^(4/3)) - (3*d^(1/3)*Log[-1 + (d^(1/3)*(a + b*x)^(1/3))/(b^(1/3)*(c + d*x)^(1/3))])/(2*b^(4/3))", //
        49,
        61);
  }

  // {47, 37}
  public void test0670() {
    check( //
        "Integrate[(c + d*x)^(1/3)/(a + b*x)^(10/3), x]", //
        "(-3*(c + d*x)^(4/3))/(7*(b*c - a*d)*(a + b*x)^(7/3)) + (9*d*(c + d*x)^(4/3))/(28*(b*c - a*d)^2*(a + b*x)^(4/3))", //
        47,
        37);
  }

  // {52, 61}
  public void test0671() {
    check( //
        "Integrate[(a + b*x)^(1/3)/(c + d*x)^(1/3), x]", //
        "((a + b*x)^(1/3)*(c + d*x)^(2/3))/d + ((b*c - a*d)*ArcTan[1/Sqrt[3] + (2*b^(1/3)*(c + d*x)^(1/3))/(Sqrt[3]*d^(1/3)*(a + b*x)^(1/3))])/(Sqrt[3]*b^(2/3)*d^(4/3)) + ((b*c - a*d)*Log[a + b*x])/(6*b^(2/3)*d^(4/3)) + ((b*c - a*d)*Log[-1 + (b^(1/3)*(c + d*x)^(1/3))/(d^(1/3)*(a + b*x)^(1/3))])/(2*b^(2/3)*d^(4/3))", //
        52,
        61);
  }

  // {47, 37}
  public void test0672() {
    check( //
        "Integrate[1/((a + b*x)^(8/3)*(c + d*x)^(1/3)), x]", //
        "(-3*(c + d*x)^(2/3))/(5*(b*c - a*d)*(a + b*x)^(5/3)) + (9*d*(c + d*x)^(2/3))/(10*(b*c - a*d)^2*(a + b*x)^(2/3))", //
        47,
        37);
  }

  // {52, 61}
  public void test0673() {
    check( //
        "Integrate[(a + b*x)^(2/3)/(c + d*x)^(2/3), x]", //
        "((a + b*x)^(2/3)*(c + d*x)^(1/3))/d + (2*(b*c - a*d)*ArcTan[1/Sqrt[3] + (2*d^(1/3)*(a + b*x)^(1/3))/(Sqrt[3]*b^(1/3)*(c + d*x)^(1/3))])/(Sqrt[3]*b^(1/3)*d^(5/3)) + ((b*c - a*d)*Log[c + d*x])/(3*b^(1/3)*d^(5/3)) + ((b*c - a*d)*Log[-1 + (d^(1/3)*(a + b*x)^(1/3))/(b^(1/3)*(c + d*x)^(1/3))])/(b^(1/3)*d^(5/3))", //
        52,
        61);
  }

  // {47, 37}
  public void test0674() {
    check( //
        "Integrate[1/((a + b*x)^(7/3)*(c + d*x)^(2/3)), x]", //
        "(-3*(c + d*x)^(1/3))/(4*(b*c - a*d)*(a + b*x)^(4/3)) + (9*d*(c + d*x)^(1/3))/(4*(b*c - a*d)^2*(a + b*x)^(1/3))", //
        47,
        37);
  }

  // {49, 61}
  public void test0675() {
    check( //
        "Integrate[(a + b*x)^(1/3)/(c + d*x)^(4/3), x]", //
        "(-3*(a + b*x)^(1/3))/(d*(c + d*x)^(1/3)) - (Sqrt[3]*b^(1/3)*ArcTan[1/Sqrt[3] + (2*b^(1/3)*(c + d*x)^(1/3))/(Sqrt[3]*d^(1/3)*(a + b*x)^(1/3))])/d^(4/3) - (b^(1/3)*Log[a + b*x])/(2*d^(4/3)) - (3*b^(1/3)*Log[-1 + (b^(1/3)*(c + d*x)^(1/3))/(d^(1/3)*(a + b*x)^(1/3))])/(2*d^(4/3))", //
        49,
        61);
  }

  // {47, 37}
  public void test0676() {
    check( //
        "Integrate[1/((a + b*x)^(5/3)*(c + d*x)^(4/3)), x]", //
        "-3/(2*(b*c - a*d)*(a + b*x)^(2/3)*(c + d*x)^(1/3)) - (9*d*(a + b*x)^(1/3))/(2*(b*c - a*d)^2*(c + d*x)^(1/3))", //
        47,
        37);
  }

  // {52, 61}
  public void test0677() {
    check( //
        "Integrate[(-1 + x)^(1/3)/(1 + x)^(1/3), x]", //
        "(-1 + x)^(1/3)*(1 + x)^(2/3) + (2*ArcTan[1/Sqrt[3] + (2*(1 + x)^(1/3))/(Sqrt[3]*(-1 + x)^(1/3))])/Sqrt[3] + Log[-1 + x]/3 + Log[-1 + (1 + x)^(1/3)/(-1 + x)^(1/3)]", //
        52,
        61);
  }

  // {47, 37}
  public void test0678() {
    check( //
        "Integrate[(c + d*x)^(5/4)/(a + b*x)^(17/4), x]", //
        "(-4*(c + d*x)^(9/4))/(13*(b*c - a*d)*(a + b*x)^(13/4)) + (16*d*(c + d*x)^(9/4))/(117*(b*c - a*d)^2*(a + b*x)^(9/4))", //
        47,
        37);
  }

  // {47, 37}
  public void test0679() {
    check( //
        "Integrate[1/((a + b*x)^(11/4)*(c + d*x)^(1/4)), x]", //
        "(-4*(c + d*x)^(3/4))/(7*(b*c - a*d)*(a + b*x)^(7/4)) + (16*d*(c + d*x)^(3/4))/(21*(b*c - a*d)^2*(a + b*x)^(3/4))", //
        47,
        37);
  }

  // {47, 37}
  public void test0680() {
    check( //
        "Integrate[1/((a + b*x)^(9/4)*(c + d*x)^(3/4)), x]", //
        "(-4*(c + d*x)^(1/4))/(5*(b*c - a*d)*(a + b*x)^(5/4)) + (16*d*(c + d*x)^(1/4))/(5*(b*c - a*d)^2*(a + b*x)^(1/4))", //
        47,
        37);
  }

  // {47, 37}
  public void test0681() {
    check( //
        "Integrate[1/((a + b*x)^(7/4)*(c + d*x)^(5/4)), x]", //
        "-4/(3*(b*c - a*d)*(a + b*x)^(3/4)*(c + d*x)^(1/4)) - (16*d*(a + b*x)^(1/4))/(3*(b*c - a*d)^2*(c + d*x)^(1/4))", //
        47,
        37);
  }

  // {72, 71}
  public void test0682() {
    check( //
        "Integrate[(a + b*x)^(3/2)/(c + d*x)^(1/5), x]", //
        "(2*(a + b*x)^(5/2)*((b*(c + d*x))/(b*c - a*d))^(1/5)*Hypergeometric2F1[1/5, 5/2, 7/2, -((d*(a + b*x))/(b*c - a*d))])/(5*b*(c + d*x)^(1/5))", //
        72,
        71);
  }

  // {72, 71}
  public void test0683() {
    check( //
        "Integrate[Sqrt[a + b*x]/(c + d*x)^(1/5), x]", //
        "(2*(a + b*x)^(3/2)*((b*(c + d*x))/(b*c - a*d))^(1/5)*Hypergeometric2F1[1/5, 3/2, 5/2, -((d*(a + b*x))/(b*c - a*d))])/(3*b*(c + d*x)^(1/5))", //
        72,
        71);
  }

  // {72, 71}
  public void test0684() {
    check( //
        "Integrate[1/(Sqrt[a + b*x]*(c + d*x)^(1/5)), x]", //
        "(2*Sqrt[a + b*x]*((b*(c + d*x))/(b*c - a*d))^(1/5)*Hypergeometric2F1[1/5, 1/2, 3/2, -((d*(a + b*x))/(b*c - a*d))])/(b*(c + d*x)^(1/5))", //
        72,
        71);
  }

  // {72, 71}
  public void test0685() {
    check( //
        "Integrate[1/((a + b*x)^(3/2)*(c + d*x)^(1/5)), x]", //
        "(-2*((b*(c + d*x))/(b*c - a*d))^(1/5)*Hypergeometric2F1[-1/2, 1/5, 1/2, -((d*(a + b*x))/(b*c - a*d))])/(b*Sqrt[a + b*x]*(c + d*x)^(1/5))", //
        72,
        71);
  }

  // {72, 71}
  public void test0686() {
    check( //
        "Integrate[1/((a + b*x)^(5/2)*(c + d*x)^(1/5)), x]", //
        "(-2*((b*(c + d*x))/(b*c - a*d))^(1/5)*Hypergeometric2F1[-3/2, 1/5, -1/2, -((d*(a + b*x))/(b*c - a*d))])/(3*b*(a + b*x)^(3/2)*(c + d*x)^(1/5))", //
        72,
        71);
  }

  // {65, 231}
  public void test0687() {
    check( //
        "Integrate[1/(Sqrt[a + b*x]*(c + d*x)^(5/6)), x]", //
        "(3^(3/4)*(c + d*x)^(1/6)*((b*c - a*d)^(1/3) - b^(1/3)*(c + d*x)^(1/3))*Sqrt[((b*c - a*d)^(2/3) + b^(1/3)*(b*c - a*d)^(1/3)*(c + d*x)^(1/3) + b^(2/3)*(c + d*x)^(2/3))/((b*c - a*d)^(1/3) - (1 + Sqrt[3])*b^(1/3)*(c + d*x)^(1/3))^2]*EllipticF[ArcCos[((b*c - a*d)^(1/3) - (1 - Sqrt[3])*b^(1/3)*(c + d*x)^(1/3))/((b*c - a*d)^(1/3) - (1 + Sqrt[3])*b^(1/3)*(c + d*x)^(1/3))], (2 + Sqrt[3])/4])/(d*(b*c - a*d)^(1/3)*Sqrt[a + b*x]*Sqrt[-((b^(1/3)*(c + d*x)^(1/3)*((b*c - a*d)^(1/3) - b^(1/3)*(c + d*x)^(1/3)))/((b*c - a*d)^(1/3) - (1 + Sqrt[3])*b^(1/3)*(c + d*x)^(1/3))^2)])", //
        65,
        231);
  }

  // {72, 71}
  public void test0688() {
    check( //
        "Integrate[(a + b*x)^(1/6)*(c + d*x)^(13/6), x]", //
        "(6*(b*c - a*d)^2*(a + b*x)^(7/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-13/6, 7/6, 13/6, -((d*(a + b*x))/(b*c - a*d))])/(7*b^3*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0689() {
    check( //
        "Integrate[(a + b*x)^(1/6)*(c + d*x)^(7/6), x]", //
        "(6*(b*c - a*d)*(a + b*x)^(7/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-7/6, 7/6, 13/6, -((d*(a + b*x))/(b*c - a*d))])/(7*b^2*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0690() {
    check( //
        "Integrate[(a + b*x)^(1/6)*(c + d*x)^(1/6), x]", //
        "(6*(a + b*x)^(7/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-1/6, 7/6, 13/6, -((d*(a + b*x))/(b*c - a*d))])/(7*b*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0691() {
    check( //
        "Integrate[(a + b*x)^(1/6)/(c + d*x)^(5/6), x]", //
        "(6*(a + b*x)^(7/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[5/6, 7/6, 13/6, -((d*(a + b*x))/(b*c - a*d))])/(7*b*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0692() {
    check( //
        "Integrate[(a + b*x)^(1/6)/(c + d*x)^(11/6), x]", //
        "(6*(a + b*x)^(7/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[7/6, 11/6, 13/6, -((d*(a + b*x))/(b*c - a*d))])/(7*(b*c - a*d)*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0693() {
    check( //
        "Integrate[(a + b*x)^(1/6)/(c + d*x)^(17/6), x]", //
        "(6*b*(a + b*x)^(7/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[7/6, 17/6, 13/6, -((d*(a + b*x))/(b*c - a*d))])/(7*(b*c - a*d)^2*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {47, 37}
  public void test0694() {
    check( //
        "Integrate[(a + b*x)^(1/6)/(c + d*x)^(19/6), x]", //
        "(6*(a + b*x)^(7/6))/(13*(b*c - a*d)*(c + d*x)^(13/6)) + (36*b*(a + b*x)^(7/6))/(91*(b*c - a*d)^2*(c + d*x)^(7/6))", //
        47,
        37);
  }

  // {47, 37}
  public void test0695() {
    check( //
        "Integrate[(a + b*x)^(5/6)/(c + d*x)^(23/6), x]", //
        "(6*(a + b*x)^(11/6))/(17*(b*c - a*d)*(c + d*x)^(17/6)) + (36*b*(a + b*x)^(11/6))/(187*(b*c - a*d)^2*(c + d*x)^(11/6))", //
        47,
        37);
  }

  // {72, 71}
  public void test0696() {
    check( //
        "Integrate[(a + b*x)^(5/6)*(c + d*x)^(11/6), x]", //
        "(6*(b*c - a*d)*(a + b*x)^(11/6)*(c + d*x)^(5/6)*Hypergeometric2F1[-11/6, 11/6, 17/6, -((d*(a + b*x))/(b*c - a*d))])/(11*b^2*((b*(c + d*x))/(b*c - a*d))^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0697() {
    check( //
        "Integrate[(a + b*x)^(5/6)*(c + d*x)^(5/6), x]", //
        "(6*(a + b*x)^(11/6)*(c + d*x)^(5/6)*Hypergeometric2F1[-5/6, 11/6, 17/6, -((d*(a + b*x))/(b*c - a*d))])/(11*b*((b*(c + d*x))/(b*c - a*d))^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0698() {
    check( //
        "Integrate[(a + b*x)^(5/6)/(c + d*x)^(1/6), x]", //
        "(6*(a + b*x)^(11/6)*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[1/6, 11/6, 17/6, -((d*(a + b*x))/(b*c - a*d))])/(11*b*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0699() {
    check( //
        "Integrate[(a + b*x)^(5/6)/(c + d*x)^(7/6), x]", //
        "(6*(a + b*x)^(11/6)*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[7/6, 11/6, 17/6, -((d*(a + b*x))/(b*c - a*d))])/(11*(b*c - a*d)*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0700() {
    check( //
        "Integrate[(a + b*x)^(5/6)/(c + d*x)^(13/6), x]", //
        "(6*b*(a + b*x)^(11/6)*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[11/6, 13/6, 17/6, -((d*(a + b*x))/(b*c - a*d))])/(11*(b*c - a*d)^2*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0701() {
    check( //
        "Integrate[(a + b*x)^(5/6)/(c + d*x)^(19/6), x]", //
        "(6*b^2*(a + b*x)^(11/6)*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[11/6, 19/6, 17/6, -((d*(a + b*x))/(b*c - a*d))])/(11*(b*c - a*d)^3*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0702() {
    check( //
        "Integrate[(a + b*x)^(7/6)*(c + d*x)^(13/6), x]", //
        "(6*(b*c - a*d)^2*(a + b*x)^(13/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-13/6, 13/6, 19/6, -((d*(a + b*x))/(b*c - a*d))])/(13*b^3*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0703() {
    check( //
        "Integrate[(a + b*x)^(7/6)*(c + d*x)^(7/6), x]", //
        "(6*(b*c - a*d)*(a + b*x)^(13/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-7/6, 13/6, 19/6, -((d*(a + b*x))/(b*c - a*d))])/(13*b^2*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0704() {
    check( //
        "Integrate[(a + b*x)^(7/6)*(c + d*x)^(1/6), x]", //
        "(6*(a + b*x)^(13/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-1/6, 13/6, 19/6, -((d*(a + b*x))/(b*c - a*d))])/(13*b*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0705() {
    check( //
        "Integrate[(a + b*x)^(7/6)/(c + d*x)^(5/6), x]", //
        "(6*(a + b*x)^(13/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[5/6, 13/6, 19/6, -((d*(a + b*x))/(b*c - a*d))])/(13*b*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0706() {
    check( //
        "Integrate[(a + b*x)^(7/6)/(c + d*x)^(11/6), x]", //
        "(6*(a + b*x)^(13/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[11/6, 13/6, 19/6, -((d*(a + b*x))/(b*c - a*d))])/(13*(b*c - a*d)*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0707() {
    check( //
        "Integrate[(a + b*x)^(7/6)/(c + d*x)^(17/6), x]", //
        "(6*b*(a + b*x)^(13/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[13/6, 17/6, 19/6, -((d*(a + b*x))/(b*c - a*d))])/(13*(b*c - a*d)^2*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {47, 37}
  public void test0708() {
    check( //
        "Integrate[(a + b*x)^(7/6)/(c + d*x)^(25/6), x]", //
        "(6*(a + b*x)^(13/6))/(19*(b*c - a*d)*(c + d*x)^(19/6)) + (36*b*(a + b*x)^(13/6))/(247*(b*c - a*d)^2*(c + d*x)^(13/6))", //
        47,
        37);
  }

  // {47, 37}
  public void test0709() {
    check( //
        "Integrate[1/((a + b*x)^(1/6)*(c + d*x)^(17/6)), x]", //
        "(6*(a + b*x)^(5/6))/(11*(b*c - a*d)*(c + d*x)^(11/6)) + (36*b*(a + b*x)^(5/6))/(55*(b*c - a*d)^2*(c + d*x)^(5/6))", //
        47,
        37);
  }

  // {72, 71}
  public void test0710() {
    check( //
        "Integrate[(c + d*x)^(11/6)/(a + b*x)^(1/6), x]", //
        "(6*(b*c - a*d)*(a + b*x)^(5/6)*(c + d*x)^(5/6)*Hypergeometric2F1[-11/6, 5/6, 11/6, -((d*(a + b*x))/(b*c - a*d))])/(5*b^2*((b*(c + d*x))/(b*c - a*d))^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0711() {
    check( //
        "Integrate[(c + d*x)^(5/6)/(a + b*x)^(1/6), x]", //
        "(6*(a + b*x)^(5/6)*(c + d*x)^(5/6)*Hypergeometric2F1[-5/6, 5/6, 11/6, -((d*(a + b*x))/(b*c - a*d))])/(5*b*((b*(c + d*x))/(b*c - a*d))^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0712() {
    check( //
        "Integrate[1/((a + b*x)^(1/6)*(c + d*x)^(1/6)), x]", //
        "(6*(a + b*x)^(5/6)*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[1/6, 5/6, 11/6, -((d*(a + b*x))/(b*c - a*d))])/(5*b*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0713() {
    check( //
        "Integrate[1/((a + b*x)^(1/6)*(c + d*x)^(7/6)), x]", //
        "(6*(a + b*x)^(5/6)*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[5/6, 7/6, 11/6, -((d*(a + b*x))/(b*c - a*d))])/(5*(b*c - a*d)*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0714() {
    check( //
        "Integrate[1/((a + b*x)^(1/6)*(c + d*x)^(13/6)), x]", //
        "(6*b*(a + b*x)^(5/6)*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[5/6, 13/6, 11/6, -((d*(a + b*x))/(b*c - a*d))])/(5*(b*c - a*d)^2*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0715() {
    check( //
        "Integrate[1/((a + b*x)^(1/6)*(c + d*x)^(19/6)), x]", //
        "(6*b^2*(a + b*x)^(5/6)*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[5/6, 19/6, 11/6, -((d*(a + b*x))/(b*c - a*d))])/(5*(b*c - a*d)^3*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0716() {
    check( //
        "Integrate[(c + d*x)^(13/6)/(a + b*x)^(5/6), x]", //
        "(6*(b*c - a*d)^2*(a + b*x)^(1/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-13/6, 1/6, 7/6, -((d*(a + b*x))/(b*c - a*d))])/(b^3*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0717() {
    check( //
        "Integrate[(c + d*x)^(7/6)/(a + b*x)^(5/6), x]", //
        "(6*(b*c - a*d)*(a + b*x)^(1/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-7/6, 1/6, 7/6, -((d*(a + b*x))/(b*c - a*d))])/(b^2*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0718() {
    check( //
        "Integrate[(c + d*x)^(1/6)/(a + b*x)^(5/6), x]", //
        "(6*(a + b*x)^(1/6)*(c + d*x)^(1/6)*Hypergeometric2F1[-1/6, 1/6, 7/6, -((d*(a + b*x))/(b*c - a*d))])/(b*((b*(c + d*x))/(b*c - a*d))^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0719() {
    check( //
        "Integrate[1/((a + b*x)^(5/6)*(c + d*x)^(5/6)), x]", //
        "(6*(a + b*x)^(1/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[1/6, 5/6, 7/6, -((d*(a + b*x))/(b*c - a*d))])/(b*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0720() {
    check( //
        "Integrate[1/((a + b*x)^(5/6)*(c + d*x)^(11/6)), x]", //
        "(6*(a + b*x)^(1/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[1/6, 11/6, 7/6, -((d*(a + b*x))/(b*c - a*d))])/((b*c - a*d)*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0721() {
    check( //
        "Integrate[1/((a + b*x)^(5/6)*(c + d*x)^(17/6)), x]", //
        "(6*b*(a + b*x)^(1/6)*((b*(c + d*x))/(b*c - a*d))^(5/6)*Hypergeometric2F1[1/6, 17/6, 7/6, -((d*(a + b*x))/(b*c - a*d))])/((b*c - a*d)^2*(c + d*x)^(5/6))", //
        72,
        71);
  }

  // {47, 37}
  public void test0722() {
    check( //
        "Integrate[1/((a + b*x)^(5/6)*(c + d*x)^(13/6)), x]", //
        "(6*(a + b*x)^(1/6))/(7*(b*c - a*d)*(c + d*x)^(7/6)) + (36*b*(a + b*x)^(1/6))/(7*(b*c - a*d)^2*(c + d*x)^(1/6))", //
        47,
        37);
  }

  // {47, 37}
  public void test0723() {
    check( //
        "Integrate[1/((a + b*x)^(7/6)*(c + d*x)^(11/6)), x]", //
        "-6/((b*c - a*d)*(a + b*x)^(1/6)*(c + d*x)^(5/6)) - (36*d*(a + b*x)^(5/6))/(5*(b*c - a*d)^2*(c + d*x)^(5/6))", //
        47,
        37);
  }

  // {72, 71}
  public void test0724() {
    check( //
        "Integrate[(c + d*x)^(11/6)/(a + b*x)^(7/6), x]", //
        "(-6*(b*c - a*d)*(c + d*x)^(5/6)*Hypergeometric2F1[-11/6, -1/6, 5/6, -((d*(a + b*x))/(b*c - a*d))])/(b^2*(a + b*x)^(1/6)*((b*(c + d*x))/(b*c - a*d))^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0725() {
    check( //
        "Integrate[(c + d*x)^(5/6)/(a + b*x)^(7/6), x]", //
        "(-6*(c + d*x)^(5/6)*Hypergeometric2F1[-5/6, -1/6, 5/6, -((d*(a + b*x))/(b*c - a*d))])/(b*(a + b*x)^(1/6)*((b*(c + d*x))/(b*c - a*d))^(5/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0726() {
    check( //
        "Integrate[1/((a + b*x)^(7/6)*(c + d*x)^(1/6)), x]", //
        "(-6*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[-1/6, 1/6, 5/6, -((d*(a + b*x))/(b*c - a*d))])/(b*(a + b*x)^(1/6)*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0727() {
    check( //
        "Integrate[1/((a + b*x)^(7/6)*(c + d*x)^(7/6)), x]", //
        "(-6*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[-1/6, 7/6, 5/6, -((d*(a + b*x))/(b*c - a*d))])/((b*c - a*d)*(a + b*x)^(1/6)*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0728() {
    check( //
        "Integrate[1/((a + b*x)^(7/6)*(c + d*x)^(13/6)), x]", //
        "(-6*b*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[-1/6, 13/6, 5/6, -((d*(a + b*x))/(b*c - a*d))])/((b*c - a*d)^2*(a + b*x)^(1/6)*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {72, 71}
  public void test0729() {
    check( //
        "Integrate[1/((a + b*x)^(7/6)*(c + d*x)^(19/6)), x]", //
        "(-6*b^2*((b*(c + d*x))/(b*c - a*d))^(1/6)*Hypergeometric2F1[-1/6, 19/6, 5/6, -((d*(a + b*x))/(b*c - a*d))])/((b*c - a*d)^3*(a + b*x)^(1/6)*(c + d*x)^(1/6))", //
        72,
        71);
  }

  // {45}
  public void test0730() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^3, x]", //
        "((b*c - a*d)^3*(a + b*x)^(1 + m))/(b^4*(1 + m)) + (3*d*(b*c - a*d)^2*(a + b*x)^(2 + m))/(b^4*(2 + m)) + (3*d^2*(b*c - a*d)*(a + b*x)^(3 + m))/(b^4*(3 + m)) + (d^3*(a + b*x)^(4 + m))/(b^4*(4 + m))", //
        45);
  }

  // {45}
  public void test0731() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^2, x]", //
        "((b*c - a*d)^2*(a + b*x)^(1 + m))/(b^3*(1 + m)) + (2*d*(b*c - a*d)*(a + b*x)^(2 + m))/(b^3*(2 + m)) + (d^2*(a + b*x)^(3 + m))/(b^3*(3 + m))", //
        45);
  }

  // {45}
  public void test0732() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x), x]", //
        "((b*c - a*d)*(a + b*x)^(1 + m))/(b^2*(1 + m)) + (d*(a + b*x)^(2 + m))/(b^2*(2 + m))", //
        45);
  }

  // {45}
  public void test0733() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^n, x]", //
        "-(((b*c - a*d)^3*(c + d*x)^(1 + n))/(d^4*(1 + n))) + (3*b*(b*c - a*d)^2*(c + d*x)^(2 + n))/(d^4*(2 + n)) - (3*b^2*(b*c - a*d)*(c + d*x)^(3 + n))/(d^4*(3 + n)) + (b^3*(c + d*x)^(4 + n))/(d^4*(4 + n))", //
        45);
  }

  // {45}
  public void test0734() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^n, x]", //
        "((b*c - a*d)^2*(c + d*x)^(1 + n))/(d^3*(1 + n)) - (2*b*(b*c - a*d)*(c + d*x)^(2 + n))/(d^3*(2 + n)) + (b^2*(c + d*x)^(3 + n))/(d^3*(3 + n))", //
        45);
  }

  // {45}
  public void test0735() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^n, x]", //
        "-(((b*c - a*d)*(c + d*x)^(1 + n))/(d^2*(1 + n))) + (b*(c + d*x)^(2 + n))/(d^2*(2 + n))", //
        45);
  }

  // {47, 37}
  public void test0736() {
    check( //
        "Integrate[(a + b*x)^(-3 + n)/(c + d*x)^n, x]", //
        "-(((a + b*x)^(-2 + n)*(c + d*x)^(1 - n))/((b*c - a*d)*(2 - n))) + (d*(a + b*x)^(-1 + n)*(c + d*x)^(1 - n))/((b*c - a*d)^2*(1 - n)*(2 - n))", //
        47,
        37);
  }

  // {72, 71}
  public void test0737() {
    check( //
        "Integrate[(a + b*x)^(-1 + n)/(c + d*x)^n, x]", //
        "((a + b*x)^n*((b*(c + d*x))/(b*c - a*d))^n*Hypergeometric2F1[n, n, 1 + n, -((d*(a + b*x))/(b*c - a*d))])/(b*n*(c + d*x)^n)", //
        72,
        71);
  }

  // {72, 71}
  public void test0738() {
    check( //
        "Integrate[(a + b*x)^n/(c + d*x)^n, x]", //
        "((a + b*x)^(1 + n)*((b*(c + d*x))/(b*c - a*d))^n*Hypergeometric2F1[n, 1 + n, 2 + n, -((d*(a + b*x))/(b*c - a*d))])/(b*(1 + n)*(c + d*x)^n)", //
        72,
        71);
  }

  // {72, 71}
  public void test0739() {
    check( //
        "Integrate[(a + b*x)^(1 + n)/(c + d*x)^n, x]", //
        "((a + b*x)^(2 + n)*((b*(c + d*x))/(b*c - a*d))^n*Hypergeometric2F1[n, 2 + n, 3 + n, -((d*(a + b*x))/(b*c - a*d))])/(b*(2 + n)*(c + d*x)^n)", //
        72,
        71);
  }

  // {72, 71}
  public void test0740() {
    check( //
        "Integrate[(a + b*x)^(2 + n)/(c + d*x)^n, x]", //
        "((a + b*x)^(3 + n)*((b*(c + d*x))/(b*c - a*d))^n*Hypergeometric2F1[n, 3 + n, 4 + n, -((d*(a + b*x))/(b*c - a*d))])/(b*(3 + n)*(c + d*x)^n)", //
        72,
        71);
  }

  // {72, 71}
  public void test0741() {
    check( //
        "Integrate[(c + d*x)^n/(a + b*x)^n, x]", //
        "((-((d*(a + b*x))/(b*c - a*d)))^n*(c + d*x)^(1 + n)*Hypergeometric2F1[n, 1 + n, 2 + n, (b*(c + d*x))/(b*c - a*d)])/(d*(1 + n)*(a + b*x)^n)", //
        72,
        71);
  }

  // {72, 71}
  public void test0742() {
    check( //
        "Integrate[(a + b*x)^(-1 - n)*(c + d*x)^n, x]", //
        "-(((c + d*x)^n*Hypergeometric2F1[-n, -n, 1 - n, -((d*(a + b*x))/(b*c - a*d))])/(b*n*(a + b*x)^n*((b*(c + d*x))/(b*c - a*d))^n))", //
        72,
        71);
  }

  // {47, 37}
  public void test0743() {
    check( //
        "Integrate[(a + b*x)^(-3 - n)*(c + d*x)^n, x]", //
        "-(((a + b*x)^(-2 - n)*(c + d*x)^(1 + n))/((b*c - a*d)*(2 + n))) + (d*(a + b*x)^(-1 - n)*(c + d*x)^(1 + n))/((b*c - a*d)^2*(1 + n)*(2 + n))", //
        47,
        37);
  }

  // {72, 71}
  public void test0744() {
    check( //
        "Integrate[(a + b*x)^n/(c + d*x)^n, x]", //
        "((a + b*x)^(1 + n)*((b*(c + d*x))/(b*c - a*d))^n*Hypergeometric2F1[n, 1 + n, 2 + n, -((d*(a + b*x))/(b*c - a*d))])/(b*(1 + n)*(c + d*x)^n)", //
        72,
        71);
  }

  // {72, 71}
  public void test0745() {
    check( //
        "Integrate[(a + b*x)^n*(c + d*x)^(-1 - n), x]", //
        "-(((a + b*x)^n*Hypergeometric2F1[-n, -n, 1 - n, (b*(c + d*x))/(b*c - a*d)])/(d*n*(-((d*(a + b*x))/(b*c - a*d)))^n*(c + d*x)^n))", //
        72,
        71);
  }

  // {47, 37}
  public void test0746() {
    check( //
        "Integrate[(a + b*x)^n*(c + d*x)^(-3 - n), x]", //
        "((a + b*x)^(1 + n)*(c + d*x)^(-2 - n))/((b*c - a*d)*(2 + n)) + (b*(a + b*x)^(1 + n)*(c + d*x)^(-1 - n))/((b*c - a*d)^2*(1 + n)*(2 + n))", //
        47,
        37);
  }

  // {72, 71}
  public void test0747() {
    check( //
        "Integrate[(a + b*x)^(-2 + n)*(c + d*x)^(1 - n), x]", //
        "-(((b*c - a*d)*(a + b*x)^(-1 + n)*((b*(c + d*x))/(b*c - a*d))^n*Hypergeometric2F1[-1 + n, -1 + n, n, -((d*(a + b*x))/(b*c - a*d))])/(b^2*(1 - n)*(c + d*x)^n))", //
        72,
        71);
  }

  // {72, 71}
  public void test0748() {
    check( //
        "Integrate[(a + b*x)^(1 + n)*(c + d*x)^(-1 - n), x]", //
        "((b*c - a*d)*(a + b*x)^n*Hypergeometric2F1[-1 - n, -n, 1 - n, (b*(c + d*x))/(b*c - a*d)])/(d^2*n*(-((d*(a + b*x))/(b*c - a*d)))^n*(c + d*x)^n)", //
        72,
        71);
  }

  // {7, 70}
  public void test0749() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^(1 + 2*n - 2*(1 + n)), x]", //
        "((a + b*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((d*(a + b*x))/(b*c - a*d))])/((b*c - a*d)*(1 + m))", //
        7,
        70);
  }

  // {47, 37}
  public void test0750() {
    check( //
        "Integrate[(a + b*x)^m*(a*c*(1 + m) + b*c*(2 + m)*x)^(-3 - m), x]", //
        "-(((a + b*x)^(1 + m)*(a*c*(1 + m) + b*c*(2 + m)*x)^(-2 - m))/(a*b*c*(2 + m))) + ((a + b*x)^(1 + m)*(a*c*(1 + m) + b*c*(2 + m)*x)^(-1 - m))/(a^2*b*c^2*(1 + m)*(2 + m))", //
        47,
        37);
  }

  // {47, 37}
  public void test0751() {
    check( //
        "Integrate[(a + b*x)^(-1 - (b*c)/(b*c - a*d))*(c + d*x)^(-1 + (a*d)/(b*c - a*d)), x]", //
        "-((c + d*x)^((a*d)/(b*c - a*d))/(b*c*(a + b*x)^((b*c)/(b*c - a*d)))) + (c + d*x)^((a*d)/(b*c - a*d))/(a*b*c*(a + b*x)^((a*d)/(b*c - a*d)))", //
        47,
        37);
  }

  // {47, 37}
  public void test0752() {
    check( //
        "Integrate[(a + b*x)^((-2*b*c + a*d)/(b*c - a*d))*(c + d*x)^((b*c - 2*a*d)/(-(b*c) + a*d)), x]", //
        "-((c + d*x)^((a*d)/(b*c - a*d))/(b*c*(a + b*x)^((b*c)/(b*c - a*d)))) + (c + d*x)^((a*d)/(b*c - a*d))/(a*b*c*(a + b*x)^((a*d)/(b*c - a*d)))", //
        47,
        37);
  }

  // {192, 71}
  public void test0753() {
    check( //
        "Integrate[((d*(a + b*x))/(-(b*c) + a*d))^m*(c + d*x)^n, x]", //
        "((c + d*x)^(1 + n)*Hypergeometric2F1[-m, 1 + n, 2 + n, (b*(c + d*x))/(b*c - a*d)])/(d*(1 + n))", //
        192,
        71);
  }

  // {76}
  public void test0754() {
    check( //
        "Integrate[x^2*(a + b*x)*(a*c - b*c*x)^3, x]", //
        "(a^4*c^3*x^3)/3 - (a^3*b*c^3*x^4)/2 + (a*b^3*c^3*x^6)/3 - (b^4*c^3*x^7)/7", //
        76);
  }

  // {76}
  public void test0755() {
    check( //
        "Integrate[x*(a + b*x)*(a*c - b*c*x)^3, x]", //
        "(a^4*c^3*x^2)/2 - (2*a^3*b*c^3*x^3)/3 + (2*a*b^3*c^3*x^5)/5 - (b^4*c^3*x^6)/6", //
        76);
  }

  // {45}
  public void test0756() {
    check( //
        "Integrate[(a + b*x)*(a*c - b*c*x)^3, x]", //
        "-(a*c^3*(a - b*x)^4)/(2*b) + (c^3*(a - b*x)^5)/(5*b)", //
        45);
  }

  // {76}
  public void test0757() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^3)/x, x]", //
        "-2*a^3*b*c^3*x + (2*a*b^3*c^3*x^3)/3 - (b^4*c^3*x^4)/4 + a^4*c^3*Log[x]", //
        76);
  }

  // {76}
  public void test0758() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^3)/x^2, x]", //
        "-((a^4*c^3)/x) + a*b^3*c^3*x^2 - (b^4*c^3*x^3)/3 - 2*a^3*b*c^3*Log[x]", //
        76);
  }

  // {76}
  public void test0759() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^3)/x^4, x]", //
        "-(a^4*c^3)/(3*x^3) + (a^3*b*c^3)/x^2 - b^4*c^3*x + 2*a*b^3*c^3*Log[x]", //
        76);
  }

  // {76}
  public void test0760() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^3)/x^5, x]", //
        "-(a^4*c^3)/(4*x^4) + (2*a^3*b*c^3)/(3*x^3) - (2*a*b^3*c^3)/x - b^4*c^3*Log[x]", //
        76);
  }

  // {76}
  public void test0761() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^3)/x^6, x]", //
        "-(a^4*c^3)/(5*x^5) + (a^3*b*c^3)/(2*x^4) - (a*b^3*c^3)/x^2 + (b^4*c^3)/x", //
        76);
  }

  // {76}
  public void test0762() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^3)/x^7, x]", //
        "-(a^4*c^3)/(6*x^6) + (2*a^3*b*c^3)/(5*x^5) - (2*a*b^3*c^3)/(3*x^3) + (b^4*c^3)/(2*x^2)", //
        76);
  }

  // {76}
  public void test0763() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^3)/x^8, x]", //
        "-(a^4*c^3)/(7*x^7) + (a^3*b*c^3)/(3*x^6) - (a*b^3*c^3)/(2*x^4) + (b^4*c^3)/(3*x^3)", //
        76);
  }

  // {76}
  public void test0764() {
    check( //
        "Integrate[x^4*(a + b*x)*(a*c - b*c*x)^4, x]", //
        "(a^5*c^4*x^5)/5 - (a^4*b*c^4*x^6)/2 + (2*a^3*b^2*c^4*x^7)/7 + (a^2*b^3*c^4*x^8)/4 - (a*b^4*c^4*x^9)/3 + (b^5*c^4*x^10)/10", //
        76);
  }

  // {76}
  public void test0765() {
    check( //
        "Integrate[x^3*(a + b*x)*(a*c - b*c*x)^4, x]", //
        "(a^5*c^4*x^4)/4 - (3*a^4*b*c^4*x^5)/5 + (a^3*b^2*c^4*x^6)/3 + (2*a^2*b^3*c^4*x^7)/7 - (3*a*b^4*c^4*x^8)/8 + (b^5*c^4*x^9)/9", //
        76);
  }

  // {76}
  public void test0766() {
    check( //
        "Integrate[x^2*(a + b*x)*(a*c - b*c*x)^4, x]", //
        "(-2*a^3*c^4*(a - b*x)^5)/(5*b^3) + (5*a^2*c^4*(a - b*x)^6)/(6*b^3) - (4*a*c^4*(a - b*x)^7)/(7*b^3) + (c^4*(a - b*x)^8)/(8*b^3)", //
        76);
  }

  // {76}
  public void test0767() {
    check( //
        "Integrate[x*(a + b*x)*(a*c - b*c*x)^4, x]", //
        "(-2*a^2*c^4*(a - b*x)^5)/(5*b^2) + (a*c^4*(a - b*x)^6)/(2*b^2) - (c^4*(a - b*x)^7)/(7*b^2)", //
        76);
  }

  // {45}
  public void test0768() {
    check( //
        "Integrate[(a + b*x)*(a*c - b*c*x)^4, x]", //
        "(-2*a*c^4*(a - b*x)^5)/(5*b) + (c^4*(a - b*x)^6)/(6*b)", //
        45);
  }

  // {76}
  public void test0769() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x, x]", //
        "-3*a^4*b*c^4*x + a^3*b^2*c^4*x^2 + (2*a^2*b^3*c^4*x^3)/3 - (3*a*b^4*c^4*x^4)/4 + (b^5*c^4*x^5)/5 + a^5*c^4*Log[x]", //
        76);
  }

  // {76}
  public void test0770() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x^2, x]", //
        "-((a^5*c^4)/x) + 2*a^3*b^2*c^4*x + a^2*b^3*c^4*x^2 - a*b^4*c^4*x^3 + (b^5*c^4*x^4)/4 - 3*a^4*b*c^4*Log[x]", //
        76);
  }

  // {76}
  public void test0771() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x^3, x]", //
        "-(a^5*c^4)/(2*x^2) + (3*a^4*b*c^4)/x + 2*a^2*b^3*c^4*x - (3*a*b^4*c^4*x^2)/2 + (b^5*c^4*x^3)/3 + 2*a^3*b^2*c^4*Log[x]", //
        76);
  }

  // {76}
  public void test0772() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x^4, x]", //
        "-(a^5*c^4)/(3*x^3) + (3*a^4*b*c^4)/(2*x^2) - (2*a^3*b^2*c^4)/x - 3*a*b^4*c^4*x + (b^5*c^4*x^2)/2 + 2*a^2*b^3*c^4*Log[x]", //
        76);
  }

  // {76}
  public void test0773() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x^5, x]", //
        "-(a^5*c^4)/(4*x^4) + (a^4*b*c^4)/x^3 - (a^3*b^2*c^4)/x^2 - (2*a^2*b^3*c^4)/x + b^5*c^4*x - 3*a*b^4*c^4*Log[x]", //
        76);
  }

  // {76}
  public void test0774() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x^6, x]", //
        "-(a^5*c^4)/(5*x^5) + (3*a^4*b*c^4)/(4*x^4) - (2*a^3*b^2*c^4)/(3*x^3) - (a^2*b^3*c^4)/x^2 + (3*a*b^4*c^4)/x + b^5*c^4*Log[x]", //
        76);
  }

  // {79, 37}
  public void test0775() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x^7, x]", //
        "-(c^4*(a - b*x)^5)/(6*x^6) - (7*b*c^4*(a - b*x)^5)/(30*a*x^5)", //
        79,
        37);
  }

  // {76}
  public void test0776() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x^8, x]", //
        "-(a^5*c^4)/(7*x^7) + (a^4*b*c^4)/(2*x^6) - (2*a^3*b^2*c^4)/(5*x^5) - (a^2*b^3*c^4)/(2*x^4) + (a*b^4*c^4)/x^3 - (b^5*c^4)/(2*x^2)", //
        76);
  }

  // {76}
  public void test0777() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^4)/x^9, x]", //
        "-(a^5*c^4)/(8*x^8) + (3*a^4*b*c^4)/(7*x^7) - (a^3*b^2*c^4)/(3*x^6) - (2*a^2*b^3*c^4)/(5*x^5) + (3*a*b^4*c^4)/(4*x^4) - (b^5*c^4)/(3*x^3)", //
        76);
  }

  // {76}
  public void test0778() {
    check( //
        "Integrate[x^4*(a + b*x)*(a*c - b*c*x)^5, x]", //
        "(a^6*c^5*x^5)/5 - (2*a^5*b*c^5*x^6)/3 + (5*a^4*b^2*c^5*x^7)/7 - (5*a^2*b^4*c^5*x^9)/9 + (2*a*b^5*c^5*x^10)/5 - (b^6*c^5*x^11)/11", //
        76);
  }

  // {76}
  public void test0779() {
    check( //
        "Integrate[x^3*(a + b*x)*(a*c - b*c*x)^5, x]", //
        "(a^6*c^5*x^4)/4 - (4*a^5*b*c^5*x^5)/5 + (5*a^4*b^2*c^5*x^6)/6 - (5*a^2*b^4*c^5*x^8)/8 + (4*a*b^5*c^5*x^9)/9 - (b^6*c^5*x^10)/10", //
        76);
  }

  // {76}
  public void test0780() {
    check( //
        "Integrate[x^2*(a + b*x)*(a*c - b*c*x)^5, x]", //
        "-(a^3*c^5*(a - b*x)^6)/(3*b^3) + (5*a^2*c^5*(a - b*x)^7)/(7*b^3) - (a*c^5*(a - b*x)^8)/(2*b^3) + (c^5*(a - b*x)^9)/(9*b^3)", //
        76);
  }

  // {76}
  public void test0781() {
    check( //
        "Integrate[x*(a + b*x)*(a*c - b*c*x)^5, x]", //
        "-(a^2*c^5*(a - b*x)^6)/(3*b^2) + (3*a*c^5*(a - b*x)^7)/(7*b^2) - (c^5*(a - b*x)^8)/(8*b^2)", //
        76);
  }

  // {45}
  public void test0782() {
    check( //
        "Integrate[(a + b*x)*(a*c - b*c*x)^5, x]", //
        "-(a*c^5*(a - b*x)^6)/(3*b) + (c^5*(a - b*x)^7)/(7*b)", //
        45);
  }

  // {76}
  public void test0783() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x, x]", //
        "-4*a^5*b*c^5*x + (5*a^4*b^2*c^5*x^2)/2 - (5*a^2*b^4*c^5*x^4)/4 + (4*a*b^5*c^5*x^5)/5 - (b^6*c^5*x^6)/6 + a^6*c^5*Log[x]", //
        76);
  }

  // {76}
  public void test0784() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^2, x]", //
        "-((a^6*c^5)/x) + 5*a^4*b^2*c^5*x - (5*a^2*b^4*c^5*x^3)/3 + a*b^5*c^5*x^4 - (b^6*c^5*x^5)/5 - 4*a^5*b*c^5*Log[x]", //
        76);
  }

  // {76}
  public void test0785() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^3, x]", //
        "-(a^6*c^5)/(2*x^2) + (4*a^5*b*c^5)/x - (5*a^2*b^4*c^5*x^2)/2 + (4*a*b^5*c^5*x^3)/3 - (b^6*c^5*x^4)/4 + 5*a^4*b^2*c^5*Log[x]", //
        76);
  }

  // {76}
  public void test0786() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^5, x]", //
        "-(a^6*c^5)/(4*x^4) + (4*a^5*b*c^5)/(3*x^3) - (5*a^4*b^2*c^5)/(2*x^2) + 4*a*b^5*c^5*x - (b^6*c^5*x^2)/2 - 5*a^2*b^4*c^5*Log[x]", //
        76);
  }

  // {76}
  public void test0787() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^6, x]", //
        "-(a^6*c^5)/(5*x^5) + (a^5*b*c^5)/x^4 - (5*a^4*b^2*c^5)/(3*x^3) + (5*a^2*b^4*c^5)/x - b^6*c^5*x + 4*a*b^5*c^5*Log[x]", //
        76);
  }

  // {76}
  public void test0788() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^7, x]", //
        "-(a^6*c^5)/(6*x^6) + (4*a^5*b*c^5)/(5*x^5) - (5*a^4*b^2*c^5)/(4*x^4) + (5*a^2*b^4*c^5)/(2*x^2) - (4*a*b^5*c^5)/x - b^6*c^5*Log[x]", //
        76);
  }

  // {79, 37}
  public void test0789() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^8, x]", //
        "-(c^5*(a - b*x)^6)/(7*x^7) - (4*b*c^5*(a - b*x)^6)/(21*a*x^6)", //
        79,
        37);
  }

  // {76}
  public void test0790() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^10, x]", //
        "-(a^6*c^5)/(9*x^9) + (a^5*b*c^5)/(2*x^8) - (5*a^4*b^2*c^5)/(7*x^7) + (a^2*b^4*c^5)/x^5 - (a*b^5*c^5)/x^4 + (b^6*c^5)/(3*x^3)", //
        76);
  }

  // {76}
  public void test0791() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^11, x]", //
        "-(a^6*c^5)/(10*x^10) + (4*a^5*b*c^5)/(9*x^9) - (5*a^4*b^2*c^5)/(8*x^8) + (5*a^2*b^4*c^5)/(6*x^6) - (4*a*b^5*c^5)/(5*x^5) + (b^6*c^5)/(4*x^4)", //
        76);
  }

  // {76}
  public void test0792() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^5)/x^12, x]", //
        "-(a^6*c^5)/(11*x^11) + (2*a^5*b*c^5)/(5*x^10) - (5*a^4*b^2*c^5)/(9*x^9) + (5*a^2*b^4*c^5)/(7*x^7) - (2*a*b^5*c^5)/(3*x^6) + (b^6*c^5)/(5*x^5)", //
        76);
  }

  // {76}
  public void test0793() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^6)/x^8, x]", //
        "-(a^7*c^6)/(7*x^7) + (5*a^6*b*c^6)/(6*x^6) - (9*a^5*b^2*c^6)/(5*x^5) + (5*a^4*b^3*c^6)/(4*x^4) + (5*a^3*b^4*c^6)/(3*x^3) - (9*a^2*b^5*c^6)/(2*x^2) + (5*a*b^6*c^6)/x + b^7*c^6*Log[x]", //
        76);
  }

  // {79, 37}
  public void test0794() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^6)/x^9, x]", //
        "-(c^6*(a - b*x)^7)/(8*x^8) - (9*b*c^6*(a - b*x)^7)/(56*a*x^7)", //
        79,
        37);
  }

  // {76}
  public void test0795() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^6)/x^12, x]", //
        "-(a^7*c^6)/(11*x^11) + (a^6*b*c^6)/(2*x^10) - (a^5*b^2*c^6)/x^9 + (5*a^4*b^3*c^6)/(8*x^8) + (5*a^3*b^4*c^6)/(7*x^7) - (3*a^2*b^5*c^6)/(2*x^6) + (a*b^6*c^6)/x^5 - (b^7*c^6)/(4*x^4)", //
        76);
  }

  // {76}
  public void test0796() {
    check( //
        "Integrate[((a + b*x)*(a*c - b*c*x)^6)/x^13, x]", //
        "-(a^7*c^6)/(12*x^12) + (5*a^6*b*c^6)/(11*x^11) - (9*a^5*b^2*c^6)/(10*x^10) + (5*a^4*b^3*c^6)/(9*x^9) + (5*a^3*b^4*c^6)/(8*x^8) - (9*a^2*b^5*c^6)/(7*x^7) + (5*a*b^6*c^6)/(6*x^6) - (b^7*c^6)/(5*x^5)", //
        76);
  }

  // {77}
  public void test0797() {
    check( //
        "Integrate[x^4*(a + b*x)*(A + B*x), x]", //
        "(a*A*x^5)/5 + ((A*b + a*B)*x^6)/6 + (b*B*x^7)/7", //
        77);
  }

  // {77}
  public void test0798() {
    check( //
        "Integrate[x^3*(a + b*x)*(A + B*x), x]", //
        "(a*A*x^4)/4 + ((A*b + a*B)*x^5)/5 + (b*B*x^6)/6", //
        77);
  }

  // {77}
  public void test0799() {
    check( //
        "Integrate[x^2*(a + b*x)*(A + B*x), x]", //
        "(a*A*x^3)/3 + ((A*b + a*B)*x^4)/4 + (b*B*x^5)/5", //
        77);
  }

  // {77}
  public void test0800() {
    check( //
        "Integrate[x*(a + b*x)*(A + B*x), x]", //
        "(a*A*x^2)/2 + ((A*b + a*B)*x^3)/3 + (b*B*x^4)/4", //
        77);
  }

  // {45}
  public void test0801() {
    check( //
        "Integrate[(a + b*x)*(A + B*x), x]", //
        "a*A*x + ((A*b + a*B)*x^2)/2 + (b*B*x^3)/3", //
        45);
  }

  // {77}
  public void test0802() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x, x]", //
        "(A*b + a*B)*x + (b*B*x^2)/2 + a*A*Log[x]", //
        77);
  }

  // {77}
  public void test0803() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x^2, x]", //
        "-((a*A)/x) + b*B*x + (A*b + a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0804() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x^3, x]", //
        "-(a*A)/(2*x^2) - (A*b + a*B)/x + b*B*Log[x]", //
        77);
  }

  // {77}
  public void test0805() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x^4, x]", //
        "-(a*A)/(3*x^3) - (A*b + a*B)/(2*x^2) - (b*B)/x", //
        77);
  }

  // {77}
  public void test0806() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x^5, x]", //
        "-(a*A)/(4*x^4) - (A*b + a*B)/(3*x^3) - (b*B)/(2*x^2)", //
        77);
  }

  // {77}
  public void test0807() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x^6, x]", //
        "-(a*A)/(5*x^5) - (A*b + a*B)/(4*x^4) - (b*B)/(3*x^3)", //
        77);
  }

  // {77}
  public void test0808() {
    check( //
        "Integrate[x^4*(a + b*x)^2*(A + B*x), x]", //
        "(a^2*A*x^5)/5 + (a*(2*A*b + a*B)*x^6)/6 + (b*(A*b + 2*a*B)*x^7)/7 + (b^2*B*x^8)/8", //
        77);
  }

  // {77}
  public void test0809() {
    check( //
        "Integrate[x^3*(a + b*x)^2*(A + B*x), x]", //
        "(a^2*A*x^4)/4 + (a*(2*A*b + a*B)*x^5)/5 + (b*(A*b + 2*a*B)*x^6)/6 + (b^2*B*x^7)/7", //
        77);
  }

  // {77}
  public void test0810() {
    check( //
        "Integrate[x^2*(a + b*x)^2*(A + B*x), x]", //
        "(a^2*A*x^3)/3 + (a*(2*A*b + a*B)*x^4)/4 + (b*(A*b + 2*a*B)*x^5)/5 + (b^2*B*x^6)/6", //
        77);
  }

  // {77}
  public void test0811() {
    check( //
        "Integrate[x*(a + b*x)^2*(A + B*x), x]", //
        "(a^2*A*x^2)/2 + (a*(2*A*b + a*B)*x^3)/3 + (b*(A*b + 2*a*B)*x^4)/4 + (b^2*B*x^5)/5", //
        77);
  }

  // {45}
  public void test0812() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x), x]", //
        "((A*b - a*B)*(a + b*x)^3)/(3*b^2) + (B*(a + b*x)^4)/(4*b^2)", //
        45);
  }

  // {77}
  public void test0813() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^2, x]", //
        "-((a^2*A)/x) + b*(A*b + 2*a*B)*x + (b^2*B*x^2)/2 + a*(2*A*b + a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0814() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^3, x]", //
        "-(a^2*A)/(2*x^2) - (a*(2*A*b + a*B))/x + b^2*B*x + b*(A*b + 2*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0815() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^4, x]", //
        "-(a^2*A)/(3*x^3) - (a*(2*A*b + a*B))/(2*x^2) - (b*(A*b + 2*a*B))/x + b^2*B*Log[x]", //
        77);
  }

  // {79, 37}
  public void test0816() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^5, x]", //
        "-(A*(a + b*x)^3)/(4*a*x^4) + ((A*b - 4*a*B)*(a + b*x)^3)/(12*a^2*x^3)", //
        79,
        37);
  }

  // {77}
  public void test0817() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^6, x]", //
        "-(a^2*A)/(5*x^5) - (a*(2*A*b + a*B))/(4*x^4) - (b*(A*b + 2*a*B))/(3*x^3) - (b^2*B)/(2*x^2)", //
        77);
  }

  // {77}
  public void test0818() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^7, x]", //
        "-(a^2*A)/(6*x^6) - (a*(2*A*b + a*B))/(5*x^5) - (b*(A*b + 2*a*B))/(4*x^4) - (b^2*B)/(3*x^3)", //
        77);
  }

  // {77}
  public void test0819() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^8, x]", //
        "-(a^2*A)/(7*x^7) - (a*(2*A*b + a*B))/(6*x^6) - (b*(A*b + 2*a*B))/(5*x^5) - (b^2*B)/(4*x^4)", //
        77);
  }

  // {77}
  public void test0820() {
    check( //
        "Integrate[x^4*(a + b*x)^3*(A + B*x), x]", //
        "(a^3*A*x^5)/5 + (a^2*(3*A*b + a*B)*x^6)/6 + (3*a*b*(A*b + a*B)*x^7)/7 + (b^2*(A*b + 3*a*B)*x^8)/8 + (b^3*B*x^9)/9", //
        77);
  }

  // {77}
  public void test0821() {
    check( //
        "Integrate[x^3*(a + b*x)^3*(A + B*x), x]", //
        "(a^3*A*x^4)/4 + (a^2*(3*A*b + a*B)*x^5)/5 + (a*b*(A*b + a*B)*x^6)/2 + (b^2*(A*b + 3*a*B)*x^7)/7 + (b^3*B*x^8)/8", //
        77);
  }

  // {77}
  public void test0822() {
    check( //
        "Integrate[x^2*(a + b*x)^3*(A + B*x), x]", //
        "(a^3*A*x^3)/3 + (a^2*(3*A*b + a*B)*x^4)/4 + (3*a*b*(A*b + a*B)*x^5)/5 + (b^2*(A*b + 3*a*B)*x^6)/6 + (b^3*B*x^7)/7", //
        77);
  }

  // {77}
  public void test0823() {
    check( //
        "Integrate[x*(a + b*x)^3*(A + B*x), x]", //
        "-(a*(A*b - a*B)*(a + b*x)^4)/(4*b^3) + ((A*b - 2*a*B)*(a + b*x)^5)/(5*b^3) + (B*(a + b*x)^6)/(6*b^3)", //
        77);
  }

  // {45}
  public void test0824() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x), x]", //
        "((A*b - a*B)*(a + b*x)^4)/(4*b^2) + (B*(a + b*x)^5)/(5*b^2)", //
        45);
  }

  // {77}
  public void test0825() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^2, x]", //
        "-((a^3*A)/x) + 3*a*b*(A*b + a*B)*x + (b^2*(A*b + 3*a*B)*x^2)/2 + (b^3*B*x^3)/3 + a^2*(3*A*b + a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0826() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^3, x]", //
        "-(a^3*A)/(2*x^2) - (a^2*(3*A*b + a*B))/x + b^2*(A*b + 3*a*B)*x + (b^3*B*x^2)/2 + 3*a*b*(A*b + a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0827() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^4, x]", //
        "-(a^3*A)/(3*x^3) - (a^2*(3*A*b + a*B))/(2*x^2) - (3*a*b*(A*b + a*B))/x + b^3*B*x + b^2*(A*b + 3*a*B)*Log[x]", //
        77);
  }

  // {79, 37}
  public void test0828() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^6, x]", //
        "-(A*(a + b*x)^4)/(5*a*x^5) + ((A*b - 5*a*B)*(a + b*x)^4)/(20*a^2*x^4)", //
        79,
        37);
  }

  // {77}
  public void test0829() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^7, x]", //
        "-(a^3*A)/(6*x^6) - (a^2*(3*A*b + a*B))/(5*x^5) - (3*a*b*(A*b + a*B))/(4*x^4) - (b^2*(A*b + 3*a*B))/(3*x^3) - (b^3*B)/(2*x^2)", //
        77);
  }

  // {77}
  public void test0830() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^8, x]", //
        "-(a^3*A)/(7*x^7) - (a^2*(3*A*b + a*B))/(6*x^6) - (3*a*b*(A*b + a*B))/(5*x^5) - (b^2*(A*b + 3*a*B))/(4*x^4) - (b^3*B)/(3*x^3)", //
        77);
  }

  // {77}
  public void test0831() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^9, x]", //
        "-(a^3*A)/(8*x^8) - (a^2*(3*A*b + a*B))/(7*x^7) - (a*b*(A*b + a*B))/(2*x^6) - (b^2*(A*b + 3*a*B))/(5*x^5) - (b^3*B)/(4*x^4)", //
        77);
  }

  // {77}
  public void test0832() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^10, x]", //
        "-(a^3*A)/(9*x^9) - (a^2*(3*A*b + a*B))/(8*x^8) - (3*a*b*(A*b + a*B))/(7*x^7) - (b^2*(A*b + 3*a*B))/(6*x^6) - (b^3*B)/(5*x^5)", //
        77);
  }

  // {77}
  public void test0833() {
    check( //
        "Integrate[x^5*(a + b*x)^5*(A + B*x), x]", //
        "(a^5*A*x^6)/6 + (a^4*(5*A*b + a*B)*x^7)/7 + (5*a^3*b*(2*A*b + a*B)*x^8)/8 + (10*a^2*b^2*(A*b + a*B)*x^9)/9 + (a*b^3*(A*b + 2*a*B)*x^10)/2 + (b^4*(A*b + 5*a*B)*x^11)/11 + (b^5*B*x^12)/12", //
        77);
  }

  // {77}
  public void test0834() {
    check( //
        "Integrate[x^4*(a + b*x)^5*(A + B*x), x]", //
        "(a^5*A*x^5)/5 + (a^4*(5*A*b + a*B)*x^6)/6 + (5*a^3*b*(2*A*b + a*B)*x^7)/7 + (5*a^2*b^2*(A*b + a*B)*x^8)/4 + (5*a*b^3*(A*b + 2*a*B)*x^9)/9 + (b^4*(A*b + 5*a*B)*x^10)/10 + (b^5*B*x^11)/11", //
        77);
  }

  // {77}
  public void test0835() {
    check( //
        "Integrate[x^3*(a + b*x)^5*(A + B*x), x]", //
        "-(a^3*(A*b - a*B)*(a + b*x)^6)/(6*b^5) + (a^2*(3*A*b - 4*a*B)*(a + b*x)^7)/(7*b^5) - (3*a*(A*b - 2*a*B)*(a + b*x)^8)/(8*b^5) + ((A*b - 4*a*B)*(a + b*x)^9)/(9*b^5) + (B*(a + b*x)^10)/(10*b^5)", //
        77);
  }

  // {77}
  public void test0836() {
    check( //
        "Integrate[x^2*(a + b*x)^5*(A + B*x), x]", //
        "(a^2*(A*b - a*B)*(a + b*x)^6)/(6*b^4) - (a*(2*A*b - 3*a*B)*(a + b*x)^7)/(7*b^4) + ((A*b - 3*a*B)*(a + b*x)^8)/(8*b^4) + (B*(a + b*x)^9)/(9*b^4)", //
        77);
  }

  // {77}
  public void test0837() {
    check( //
        "Integrate[x*(a + b*x)^5*(A + B*x), x]", //
        "-(a*(A*b - a*B)*(a + b*x)^6)/(6*b^3) + ((A*b - 2*a*B)*(a + b*x)^7)/(7*b^3) + (B*(a + b*x)^8)/(8*b^3)", //
        77);
  }

  // {45}
  public void test0838() {
    check( //
        "Integrate[(a + b*x)^5*(A + B*x), x]", //
        "((A*b - a*B)*(a + b*x)^6)/(6*b^2) + (B*(a + b*x)^7)/(7*b^2)", //
        45);
  }

  // {77}
  public void test0839() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^2, x]", //
        "-((a^5*A)/x) + 5*a^3*b*(2*A*b + a*B)*x + 5*a^2*b^2*(A*b + a*B)*x^2 + (5*a*b^3*(A*b + 2*a*B)*x^3)/3 + (b^4*(A*b + 5*a*B)*x^4)/4 + (b^5*B*x^5)/5 + a^4*(5*A*b + a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0840() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^3, x]", //
        "-(a^5*A)/(2*x^2) - (a^4*(5*A*b + a*B))/x + 10*a^2*b^2*(A*b + a*B)*x + (5*a*b^3*(A*b + 2*a*B)*x^2)/2 + (b^4*(A*b + 5*a*B)*x^3)/3 + (b^5*B*x^4)/4 + 5*a^3*b*(2*A*b + a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0841() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^4, x]", //
        "-(a^5*A)/(3*x^3) - (a^4*(5*A*b + a*B))/(2*x^2) - (5*a^3*b*(2*A*b + a*B))/x + 5*a*b^3*(A*b + 2*a*B)*x + (b^4*(A*b + 5*a*B)*x^2)/2 + (b^5*B*x^3)/3 + 10*a^2*b^2*(A*b + a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0842() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^5, x]", //
        "-(a^5*A)/(4*x^4) - (a^4*(5*A*b + a*B))/(3*x^3) - (5*a^3*b*(2*A*b + a*B))/(2*x^2) - (10*a^2*b^2*(A*b + a*B))/x + b^4*(A*b + 5*a*B)*x + (b^5*B*x^2)/2 + 5*a*b^3*(A*b + 2*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0843() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^6, x]", //
        "-(a^5*A)/(5*x^5) - (a^4*(5*A*b + a*B))/(4*x^4) - (5*a^3*b*(2*A*b + a*B))/(3*x^3) - (5*a^2*b^2*(A*b + a*B))/x^2 - (5*a*b^3*(A*b + 2*a*B))/x + b^5*B*x + b^4*(A*b + 5*a*B)*Log[x]", //
        77);
  }

  // {79, 37}
  public void test0844() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^8, x]", //
        "-(A*(a + b*x)^6)/(7*a*x^7) + ((A*b - 7*a*B)*(a + b*x)^6)/(42*a^2*x^6)", //
        79,
        37);
  }

  // {77}
  public void test0845() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^10, x]", //
        "-(a^5*A)/(9*x^9) - (a^4*(5*A*b + a*B))/(8*x^8) - (5*a^3*b*(2*A*b + a*B))/(7*x^7) - (5*a^2*b^2*(A*b + a*B))/(3*x^6) - (a*b^3*(A*b + 2*a*B))/x^5 - (b^4*(A*b + 5*a*B))/(4*x^4) - (b^5*B)/(3*x^3)", //
        77);
  }

  // {77}
  public void test0846() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^11, x]", //
        "-(a^5*A)/(10*x^10) - (a^4*(5*A*b + a*B))/(9*x^9) - (5*a^3*b*(2*A*b + a*B))/(8*x^8) - (10*a^2*b^2*(A*b + a*B))/(7*x^7) - (5*a*b^3*(A*b + 2*a*B))/(6*x^6) - (b^4*(A*b + 5*a*B))/(5*x^5) - (b^5*B)/(4*x^4)", //
        77);
  }

  // {77}
  public void test0847() {
    check( //
        "Integrate[((a + b*x)^5*(A + B*x))/x^12, x]", //
        "-(a^5*A)/(11*x^11) - (a^4*(5*A*b + a*B))/(10*x^10) - (5*a^3*b*(2*A*b + a*B))/(9*x^9) - (5*a^2*b^2*(A*b + a*B))/(4*x^8) - (5*a*b^3*(A*b + 2*a*B))/(7*x^7) - (b^4*(A*b + 5*a*B))/(6*x^6) - (b^5*B)/(5*x^5)", //
        77);
  }

  // {77}
  public void test0848() {
    check( //
        "Integrate[x^10*(a + b*x)^10*(A + B*x), x]", //
        "(a^10*A*x^11)/11 + (a^9*(10*A*b + a*B)*x^12)/12 + (5*a^8*b*(9*A*b + 2*a*B)*x^13)/13 + (15*a^7*b^2*(8*A*b + 3*a*B)*x^14)/14 + 2*a^6*b^3*(7*A*b + 4*a*B)*x^15 + (21*a^5*b^4*(6*A*b + 5*a*B)*x^16)/8 + (42*a^4*b^5*(5*A*b + 6*a*B)*x^17)/17 + (5*a^3*b^6*(4*A*b + 7*a*B)*x^18)/3 + (15*a^2*b^7*(3*A*b + 8*a*B)*x^19)/19 + (a*b^8*(2*A*b + 9*a*B)*x^20)/4 + (b^9*(A*b + 10*a*B)*x^21)/21 + (b^10*B*x^22)/22", //
        77);
  }

  // {77}
  public void test0849() {
    check( //
        "Integrate[x^9*(a + b*x)^10*(A + B*x), x]", //
        "(a^10*A*x^10)/10 + (a^9*(10*A*b + a*B)*x^11)/11 + (5*a^8*b*(9*A*b + 2*a*B)*x^12)/12 + (15*a^7*b^2*(8*A*b + 3*a*B)*x^13)/13 + (15*a^6*b^3*(7*A*b + 4*a*B)*x^14)/7 + (14*a^5*b^4*(6*A*b + 5*a*B)*x^15)/5 + (21*a^4*b^5*(5*A*b + 6*a*B)*x^16)/8 + (30*a^3*b^6*(4*A*b + 7*a*B)*x^17)/17 + (5*a^2*b^7*(3*A*b + 8*a*B)*x^18)/6 + (5*a*b^8*(2*A*b + 9*a*B)*x^19)/19 + (b^9*(A*b + 10*a*B)*x^20)/20 + (b^10*B*x^21)/21", //
        77);
  }

  // {77}
  public void test0850() {
    check( //
        "Integrate[x^8*(a + b*x)^10*(A + B*x), x]", //
        "(a^8*(A*b - a*B)*(a + b*x)^11)/(11*b^10) - (a^7*(8*A*b - 9*a*B)*(a + b*x)^12)/(12*b^10) + (4*a^6*(7*A*b - 9*a*B)*(a + b*x)^13)/(13*b^10) - (2*a^5*(2*A*b - 3*a*B)*(a + b*x)^14)/b^10 + (14*a^4*(5*A*b - 9*a*B)*(a + b*x)^15)/(15*b^10) - (7*a^3*(4*A*b - 9*a*B)*(a + b*x)^16)/(8*b^10) + (28*a^2*(A*b - 3*a*B)*(a + b*x)^17)/(17*b^10) - (2*a*(2*A*b - 9*a*B)*(a + b*x)^18)/(9*b^10) + ((A*b - 9*a*B)*(a + b*x)^19)/(19*b^10) + (B*(a + b*x)^20)/(20*b^10)", //
        77);
  }

  // {77}
  public void test0851() {
    check( //
        "Integrate[x^7*(a + b*x)^10*(A + B*x), x]", //
        "-(a^7*(A*b - a*B)*(a + b*x)^11)/(11*b^9) + (a^6*(7*A*b - 8*a*B)*(a + b*x)^12)/(12*b^9) - (7*a^5*(3*A*b - 4*a*B)*(a + b*x)^13)/(13*b^9) + (a^4*(5*A*b - 8*a*B)*(a + b*x)^14)/(2*b^9) - (7*a^3*(A*b - 2*a*B)*(a + b*x)^15)/(3*b^9) + (7*a^2*(3*A*b - 8*a*B)*(a + b*x)^16)/(16*b^9) - (7*a*(A*b - 4*a*B)*(a + b*x)^17)/(17*b^9) + ((A*b - 8*a*B)*(a + b*x)^18)/(18*b^9) + (B*(a + b*x)^19)/(19*b^9)", //
        77);
  }

  // {77}
  public void test0852() {
    check( //
        "Integrate[x^6*(a + b*x)^10*(A + B*x), x]", //
        "(a^6*(A*b - a*B)*(a + b*x)^11)/(11*b^8) - (a^5*(6*A*b - 7*a*B)*(a + b*x)^12)/(12*b^8) + (3*a^4*(5*A*b - 7*a*B)*(a + b*x)^13)/(13*b^8) - (5*a^3*(4*A*b - 7*a*B)*(a + b*x)^14)/(14*b^8) + (a^2*(3*A*b - 7*a*B)*(a + b*x)^15)/(3*b^8) - (3*a*(2*A*b - 7*a*B)*(a + b*x)^16)/(16*b^8) + ((A*b - 7*a*B)*(a + b*x)^17)/(17*b^8) + (B*(a + b*x)^18)/(18*b^8)", //
        77);
  }

  // {77}
  public void test0853() {
    check( //
        "Integrate[x^5*(a + b*x)^10*(A + B*x), x]", //
        "-(a^5*(A*b - a*B)*(a + b*x)^11)/(11*b^7) + (a^4*(5*A*b - 6*a*B)*(a + b*x)^12)/(12*b^7) - (5*a^3*(2*A*b - 3*a*B)*(a + b*x)^13)/(13*b^7) + (5*a^2*(A*b - 2*a*B)*(a + b*x)^14)/(7*b^7) - (a*(A*b - 3*a*B)*(a + b*x)^15)/(3*b^7) + ((A*b - 6*a*B)*(a + b*x)^16)/(16*b^7) + (B*(a + b*x)^17)/(17*b^7)", //
        77);
  }

  // {77}
  public void test0854() {
    check( //
        "Integrate[x^4*(a + b*x)^10*(A + B*x), x]", //
        "(a^4*(A*b - a*B)*(a + b*x)^11)/(11*b^6) - (a^3*(4*A*b - 5*a*B)*(a + b*x)^12)/(12*b^6) + (2*a^2*(3*A*b - 5*a*B)*(a + b*x)^13)/(13*b^6) - (a*(2*A*b - 5*a*B)*(a + b*x)^14)/(7*b^6) + ((A*b - 5*a*B)*(a + b*x)^15)/(15*b^6) + (B*(a + b*x)^16)/(16*b^6)", //
        77);
  }

  // {77}
  public void test0855() {
    check( //
        "Integrate[x^3*(a + b*x)^10*(A + B*x), x]", //
        "-(a^3*(A*b - a*B)*(a + b*x)^11)/(11*b^5) + (a^2*(3*A*b - 4*a*B)*(a + b*x)^12)/(12*b^5) - (3*a*(A*b - 2*a*B)*(a + b*x)^13)/(13*b^5) + ((A*b - 4*a*B)*(a + b*x)^14)/(14*b^5) + (B*(a + b*x)^15)/(15*b^5)", //
        77);
  }

  // {77}
  public void test0856() {
    check( //
        "Integrate[x^2*(a + b*x)^10*(A + B*x), x]", //
        "(a^2*(A*b - a*B)*(a + b*x)^11)/(11*b^4) - (a*(2*A*b - 3*a*B)*(a + b*x)^12)/(12*b^4) + ((A*b - 3*a*B)*(a + b*x)^13)/(13*b^4) + (B*(a + b*x)^14)/(14*b^4)", //
        77);
  }

  // {77}
  public void test0857() {
    check( //
        "Integrate[x*(a + b*x)^10*(A + B*x), x]", //
        "-(a*(A*b - a*B)*(a + b*x)^11)/(11*b^3) + ((A*b - 2*a*B)*(a + b*x)^12)/(12*b^3) + (B*(a + b*x)^13)/(13*b^3)", //
        77);
  }

  // {45}
  public void test0858() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x), x]", //
        "((A*b - a*B)*(a + b*x)^11)/(11*b^2) + (B*(a + b*x)^12)/(12*b^2)", //
        45);
  }

  // {77}
  public void test0859() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^2, x]", //
        "-((a^10*A)/x) + 5*a^8*b*(9*A*b + 2*a*B)*x + (15*a^7*b^2*(8*A*b + 3*a*B)*x^2)/2 + 10*a^6*b^3*(7*A*b + 4*a*B)*x^3 + (21*a^5*b^4*(6*A*b + 5*a*B)*x^4)/2 + (42*a^4*b^5*(5*A*b + 6*a*B)*x^5)/5 + 5*a^3*b^6*(4*A*b + 7*a*B)*x^6 + (15*a^2*b^7*(3*A*b + 8*a*B)*x^7)/7 + (5*a*b^8*(2*A*b + 9*a*B)*x^8)/8 + (b^9*(A*b + 10*a*B)*x^9)/9 + (b^10*B*x^10)/10 + a^9*(10*A*b + a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0860() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^3, x]", //
        "-(a^10*A)/(2*x^2) - (a^9*(10*A*b + a*B))/x + 15*a^7*b^2*(8*A*b + 3*a*B)*x + 15*a^6*b^3*(7*A*b + 4*a*B)*x^2 + 14*a^5*b^4*(6*A*b + 5*a*B)*x^3 + (21*a^4*b^5*(5*A*b + 6*a*B)*x^4)/2 + 6*a^3*b^6*(4*A*b + 7*a*B)*x^5 + (5*a^2*b^7*(3*A*b + 8*a*B)*x^6)/2 + (5*a*b^8*(2*A*b + 9*a*B)*x^7)/7 + (b^9*(A*b + 10*a*B)*x^8)/8 + (b^10*B*x^9)/9 + 5*a^8*b*(9*A*b + 2*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0861() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^4, x]", //
        "-(a^10*A)/(3*x^3) - (a^9*(10*A*b + a*B))/(2*x^2) - (5*a^8*b*(9*A*b + 2*a*B))/x + 30*a^6*b^3*(7*A*b + 4*a*B)*x + 21*a^5*b^4*(6*A*b + 5*a*B)*x^2 + 14*a^4*b^5*(5*A*b + 6*a*B)*x^3 + (15*a^3*b^6*(4*A*b + 7*a*B)*x^4)/2 + 3*a^2*b^7*(3*A*b + 8*a*B)*x^5 + (5*a*b^8*(2*A*b + 9*a*B)*x^6)/6 + (b^9*(A*b + 10*a*B)*x^7)/7 + (b^10*B*x^8)/8 + 15*a^7*b^2*(8*A*b + 3*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0862() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^5, x]", //
        "-(a^10*A)/(4*x^4) - (a^9*(10*A*b + a*B))/(3*x^3) - (5*a^8*b*(9*A*b + 2*a*B))/(2*x^2) - (15*a^7*b^2*(8*A*b + 3*a*B))/x + 42*a^5*b^4*(6*A*b + 5*a*B)*x + 21*a^4*b^5*(5*A*b + 6*a*B)*x^2 + 10*a^3*b^6*(4*A*b + 7*a*B)*x^3 + (15*a^2*b^7*(3*A*b + 8*a*B)*x^4)/4 + a*b^8*(2*A*b + 9*a*B)*x^5 + (b^9*(A*b + 10*a*B)*x^6)/6 + (b^10*B*x^7)/7 + 30*a^6*b^3*(7*A*b + 4*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0863() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^6, x]", //
        "-(a^10*A)/(5*x^5) - (a^9*(10*A*b + a*B))/(4*x^4) - (5*a^8*b*(9*A*b + 2*a*B))/(3*x^3) - (15*a^7*b^2*(8*A*b + 3*a*B))/(2*x^2) - (30*a^6*b^3*(7*A*b + 4*a*B))/x + 42*a^4*b^5*(5*A*b + 6*a*B)*x + 15*a^3*b^6*(4*A*b + 7*a*B)*x^2 + 5*a^2*b^7*(3*A*b + 8*a*B)*x^3 + (5*a*b^8*(2*A*b + 9*a*B)*x^4)/4 + (b^9*(A*b + 10*a*B)*x^5)/5 + (b^10*B*x^6)/6 + 42*a^5*b^4*(6*A*b + 5*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0864() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^7, x]", //
        "-(a^10*A)/(6*x^6) - (a^9*(10*A*b + a*B))/(5*x^5) - (5*a^8*b*(9*A*b + 2*a*B))/(4*x^4) - (5*a^7*b^2*(8*A*b + 3*a*B))/x^3 - (15*a^6*b^3*(7*A*b + 4*a*B))/x^2 - (42*a^5*b^4*(6*A*b + 5*a*B))/x + 30*a^3*b^6*(4*A*b + 7*a*B)*x + (15*a^2*b^7*(3*A*b + 8*a*B)*x^2)/2 + (5*a*b^8*(2*A*b + 9*a*B)*x^3)/3 + (b^9*(A*b + 10*a*B)*x^4)/4 + (b^10*B*x^5)/5 + 42*a^4*b^5*(5*A*b + 6*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0865() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^8, x]", //
        "-(a^10*A)/(7*x^7) - (a^9*(10*A*b + a*B))/(6*x^6) - (a^8*b*(9*A*b + 2*a*B))/x^5 - (15*a^7*b^2*(8*A*b + 3*a*B))/(4*x^4) - (10*a^6*b^3*(7*A*b + 4*a*B))/x^3 - (21*a^5*b^4*(6*A*b + 5*a*B))/x^2 - (42*a^4*b^5*(5*A*b + 6*a*B))/x + 15*a^2*b^7*(3*A*b + 8*a*B)*x + (5*a*b^8*(2*A*b + 9*a*B)*x^2)/2 + (b^9*(A*b + 10*a*B)*x^3)/3 + (b^10*B*x^4)/4 + 30*a^3*b^6*(4*A*b + 7*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0866() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^9, x]", //
        "-(a^10*A)/(8*x^8) - (a^9*(10*A*b + a*B))/(7*x^7) - (5*a^8*b*(9*A*b + 2*a*B))/(6*x^6) - (3*a^7*b^2*(8*A*b + 3*a*B))/x^5 - (15*a^6*b^3*(7*A*b + 4*a*B))/(2*x^4) - (14*a^5*b^4*(6*A*b + 5*a*B))/x^3 - (21*a^4*b^5*(5*A*b + 6*a*B))/x^2 - (30*a^3*b^6*(4*A*b + 7*a*B))/x + 5*a*b^8*(2*A*b + 9*a*B)*x + (b^9*(A*b + 10*a*B)*x^2)/2 + (b^10*B*x^3)/3 + 15*a^2*b^7*(3*A*b + 8*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0867() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^10, x]", //
        "-(a^10*A)/(9*x^9) - (a^9*(10*A*b + a*B))/(8*x^8) - (5*a^8*b*(9*A*b + 2*a*B))/(7*x^7) - (5*a^7*b^2*(8*A*b + 3*a*B))/(2*x^6) - (6*a^6*b^3*(7*A*b + 4*a*B))/x^5 - (21*a^5*b^4*(6*A*b + 5*a*B))/(2*x^4) - (14*a^4*b^5*(5*A*b + 6*a*B))/x^3 - (15*a^3*b^6*(4*A*b + 7*a*B))/x^2 - (15*a^2*b^7*(3*A*b + 8*a*B))/x + b^9*(A*b + 10*a*B)*x + (b^10*B*x^2)/2 + 5*a*b^8*(2*A*b + 9*a*B)*Log[x]", //
        77);
  }

  // {77}
  public void test0868() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^11, x]", //
        "-(a^10*A)/(10*x^10) - (a^9*(10*A*b + a*B))/(9*x^9) - (5*a^8*b*(9*A*b + 2*a*B))/(8*x^8) - (15*a^7*b^2*(8*A*b + 3*a*B))/(7*x^7) - (5*a^6*b^3*(7*A*b + 4*a*B))/x^6 - (42*a^5*b^4*(6*A*b + 5*a*B))/(5*x^5) - (21*a^4*b^5*(5*A*b + 6*a*B))/(2*x^4) - (10*a^3*b^6*(4*A*b + 7*a*B))/x^3 - (15*a^2*b^7*(3*A*b + 8*a*B))/(2*x^2) - (5*a*b^8*(2*A*b + 9*a*B))/x + b^10*B*x + b^9*(A*b + 10*a*B)*Log[x]", //
        77);
  }

  // {79, 37}
  public void test0869() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^13, x]", //
        "-(A*(a + b*x)^11)/(12*a*x^12) + ((A*b - 12*a*B)*(a + b*x)^11)/(132*a^2*x^11)", //
        79,
        37);
  }

  // {77}
  public void test0870() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^19, x]", //
        "-(a^10*A)/(18*x^18) - (a^9*(10*A*b + a*B))/(17*x^17) - (5*a^8*b*(9*A*b + 2*a*B))/(16*x^16) - (a^7*b^2*(8*A*b + 3*a*B))/x^15 - (15*a^6*b^3*(7*A*b + 4*a*B))/(7*x^14) - (42*a^5*b^4*(6*A*b + 5*a*B))/(13*x^13) - (7*a^4*b^5*(5*A*b + 6*a*B))/(2*x^12) - (30*a^3*b^6*(4*A*b + 7*a*B))/(11*x^11) - (3*a^2*b^7*(3*A*b + 8*a*B))/(2*x^10) - (5*a*b^8*(2*A*b + 9*a*B))/(9*x^9) - (b^9*(A*b + 10*a*B))/(8*x^8) - (b^10*B)/(7*x^7)", //
        77);
  }

  // {77}
  public void test0871() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^20, x]", //
        "-(a^10*A)/(19*x^19) - (a^9*(10*A*b + a*B))/(18*x^18) - (5*a^8*b*(9*A*b + 2*a*B))/(17*x^17) - (15*a^7*b^2*(8*A*b + 3*a*B))/(16*x^16) - (2*a^6*b^3*(7*A*b + 4*a*B))/x^15 - (3*a^5*b^4*(6*A*b + 5*a*B))/x^14 - (42*a^4*b^5*(5*A*b + 6*a*B))/(13*x^13) - (5*a^3*b^6*(4*A*b + 7*a*B))/(2*x^12) - (15*a^2*b^7*(3*A*b + 8*a*B))/(11*x^11) - (a*b^8*(2*A*b + 9*a*B))/(2*x^10) - (b^9*(A*b + 10*a*B))/(9*x^9) - (b^10*B)/(8*x^8)", //
        77);
  }

  // {77}
  public void test0872() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/x^21, x]", //
        "-(a^10*A)/(20*x^20) - (a^9*(10*A*b + a*B))/(19*x^19) - (5*a^8*b*(9*A*b + 2*a*B))/(18*x^18) - (15*a^7*b^2*(8*A*b + 3*a*B))/(17*x^17) - (15*a^6*b^3*(7*A*b + 4*a*B))/(8*x^16) - (14*a^5*b^4*(6*A*b + 5*a*B))/(5*x^15) - (3*a^4*b^5*(5*A*b + 6*a*B))/x^14 - (30*a^3*b^6*(4*A*b + 7*a*B))/(13*x^13) - (5*a^2*b^7*(3*A*b + 8*a*B))/(4*x^12) - (5*a*b^8*(2*A*b + 9*a*B))/(11*x^11) - (b^9*(A*b + 10*a*B))/(10*x^10) - (b^10*B)/(9*x^9)", //
        77);
  }

  // {77}
  public void test0873() {
    check( //
        "Integrate[x^3*(a + b*x)*(c + d*x)^16, x]", //
        "(c^3*(b*c - a*d)*(c + d*x)^17)/(17*d^5) - (c^2*(4*b*c - 3*a*d)*(c + d*x)^18)/(18*d^5) + (3*c*(2*b*c - a*d)*(c + d*x)^19)/(19*d^5) - ((4*b*c - a*d)*(c + d*x)^20)/(20*d^5) + (b*(c + d*x)^21)/(21*d^5)", //
        77);
  }

  // {77}
  public void test0874() {
    check( //
        "Integrate[x^2*(a + b*x)*(c + d*x)^16, x]", //
        "-(c^2*(b*c - a*d)*(c + d*x)^17)/(17*d^4) + (c*(3*b*c - 2*a*d)*(c + d*x)^18)/(18*d^4) - ((3*b*c - a*d)*(c + d*x)^19)/(19*d^4) + (b*(c + d*x)^20)/(20*d^4)", //
        77);
  }

  // {77}
  public void test0875() {
    check( //
        "Integrate[x*(a + b*x)*(c + d*x)^16, x]", //
        "(c*(b*c - a*d)*(c + d*x)^17)/(17*d^3) - ((2*b*c - a*d)*(c + d*x)^18)/(18*d^3) + (b*(c + d*x)^19)/(19*d^3)", //
        77);
  }

  // {45}
  public void test0876() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^16, x]", //
        "-((b*c - a*d)*(c + d*x)^17)/(17*d^2) + (b*(c + d*x)^18)/(18*d^2)", //
        45);
  }

  // {78}
  public void test0877() {
    check( //
        "Integrate[(x^4*(A + B*x))/(a + b*x), x]", //
        "-((a^3*(A*b - a*B)*x)/b^5) + (a^2*(A*b - a*B)*x^2)/(2*b^4) - (a*(A*b - a*B)*x^3)/(3*b^3) + ((A*b - a*B)*x^4)/(4*b^2) + (B*x^5)/(5*b) + (a^4*(A*b - a*B)*Log[a + b*x])/b^6", //
        78);
  }

  // {78}
  public void test0878() {
    check( //
        "Integrate[(x^3*(A + B*x))/(a + b*x), x]", //
        "(a^2*(A*b - a*B)*x)/b^4 - (a*(A*b - a*B)*x^2)/(2*b^3) + ((A*b - a*B)*x^3)/(3*b^2) + (B*x^4)/(4*b) - (a^3*(A*b - a*B)*Log[a + b*x])/b^5", //
        78);
  }

  // {78}
  public void test0879() {
    check( //
        "Integrate[(x^2*(A + B*x))/(a + b*x), x]", //
        "-((a*(A*b - a*B)*x)/b^3) + ((A*b - a*B)*x^2)/(2*b^2) + (B*x^3)/(3*b) + (a^2*(A*b - a*B)*Log[a + b*x])/b^4", //
        78);
  }

  // {78}
  public void test0880() {
    check( //
        "Integrate[(x*(A + B*x))/(a + b*x), x]", //
        "((A*b - a*B)*x)/b^2 + (B*x^2)/(2*b) - (a*(A*b - a*B)*Log[a + b*x])/b^3", //
        78);
  }

  // {45}
  public void test0881() {
    check( //
        "Integrate[(A + B*x)/(a + b*x), x]", //
        "(B*x)/b + ((A*b - a*B)*Log[a + b*x])/b^2", //
        45);
  }

  // {78}
  public void test0882() {
    check( //
        "Integrate[(A + B*x)/(x*(a + b*x)), x]", //
        "(A*Log[x])/a - ((A*b - a*B)*Log[a + b*x])/(a*b)", //
        78);
  }

  // {78}
  public void test0883() {
    check( //
        "Integrate[(A + B*x)/(x^2*(a + b*x)), x]", //
        "-(A/(a*x)) - ((A*b - a*B)*Log[x])/a^2 + ((A*b - a*B)*Log[a + b*x])/a^2", //
        78);
  }

  // {78}
  public void test0884() {
    check( //
        "Integrate[(A + B*x)/(x^3*(a + b*x)), x]", //
        "-A/(2*a*x^2) + (A*b - a*B)/(a^2*x) + (b*(A*b - a*B)*Log[x])/a^3 - (b*(A*b - a*B)*Log[a + b*x])/a^3", //
        78);
  }

  // {78}
  public void test0885() {
    check( //
        "Integrate[(A + B*x)/(x^4*(a + b*x)), x]", //
        "-A/(3*a*x^3) + (A*b - a*B)/(2*a^2*x^2) - (b*(A*b - a*B))/(a^3*x) - (b^2*(A*b - a*B)*Log[x])/a^4 + (b^2*(A*b - a*B)*Log[a + b*x])/a^4", //
        78);
  }

  // {78}
  public void test0886() {
    check( //
        "Integrate[(A + B*x)/(x^5*(a + b*x)), x]", //
        "-A/(4*a*x^4) + (A*b - a*B)/(3*a^2*x^3) - (b*(A*b - a*B))/(2*a^3*x^2) + (b^2*(A*b - a*B))/(a^4*x) + (b^3*(A*b - a*B)*Log[x])/a^5 - (b^3*(A*b - a*B)*Log[a + b*x])/a^5", //
        78);
  }

  // {78}
  public void test0887() {
    check( //
        "Integrate[(x^4*(A + B*x))/(a + b*x)^2, x]", //
        "(a^2*(3*A*b - 4*a*B)*x)/b^5 - (a*(2*A*b - 3*a*B)*x^2)/(2*b^4) + ((A*b - 2*a*B)*x^3)/(3*b^3) + (B*x^4)/(4*b^2) - (a^4*(A*b - a*B))/(b^6*(a + b*x)) - (a^3*(4*A*b - 5*a*B)*Log[a + b*x])/b^6", //
        78);
  }

  // {78}
  public void test0888() {
    check( //
        "Integrate[(x^3*(A + B*x))/(a + b*x)^2, x]", //
        "-((a*(2*A*b - 3*a*B)*x)/b^4) + ((A*b - 2*a*B)*x^2)/(2*b^3) + (B*x^3)/(3*b^2) + (a^3*(A*b - a*B))/(b^5*(a + b*x)) + (a^2*(3*A*b - 4*a*B)*Log[a + b*x])/b^5", //
        78);
  }

  // {78}
  public void test0889() {
    check( //
        "Integrate[(x^2*(A + B*x))/(a + b*x)^2, x]", //
        "((A*b - 2*a*B)*x)/b^3 + (B*x^2)/(2*b^2) - (a^2*(A*b - a*B))/(b^4*(a + b*x)) - (a*(2*A*b - 3*a*B)*Log[a + b*x])/b^4", //
        78);
  }

  // {78}
  public void test0890() {
    check( //
        "Integrate[(x*(A + B*x))/(a + b*x)^2, x]", //
        "(B*x)/b^2 + (a*(A*b - a*B))/(b^3*(a + b*x)) + ((A*b - 2*a*B)*Log[a + b*x])/b^3", //
        78);
  }

  // {45}
  public void test0891() {
    check( //
        "Integrate[(A + B*x)/(a + b*x)^2, x]", //
        "-((A*b - a*B)/(b^2*(a + b*x))) + (B*Log[a + b*x])/b^2", //
        45);
  }

  // {78}
  public void test0892() {
    check( //
        "Integrate[(A + B*x)/(x*(a + b*x)^2), x]", //
        "(A*b - a*B)/(a*b*(a + b*x)) + (A*Log[x])/a^2 - (A*Log[a + b*x])/a^2", //
        78);
  }

  // {78}
  public void test0893() {
    check( //
        "Integrate[(A + B*x)/(x^2*(a + b*x)^2), x]", //
        "-(A/(a^2*x)) - (A*b - a*B)/(a^2*(a + b*x)) - ((2*A*b - a*B)*Log[x])/a^3 + ((2*A*b - a*B)*Log[a + b*x])/a^3", //
        78);
  }

  // {78}
  public void test0894() {
    check( //
        "Integrate[(A + B*x)/(x^3*(a + b*x)^2), x]", //
        "-A/(2*a^2*x^2) + (2*A*b - a*B)/(a^3*x) + (b*(A*b - a*B))/(a^3*(a + b*x)) + (b*(3*A*b - 2*a*B)*Log[x])/a^4 - (b*(3*A*b - 2*a*B)*Log[a + b*x])/a^4", //
        78);
  }

  // {78}
  public void test0895() {
    check( //
        "Integrate[(A + B*x)/(x^4*(a + b*x)^2), x]", //
        "-A/(3*a^2*x^3) + (2*A*b - a*B)/(2*a^3*x^2) - (b*(3*A*b - 2*a*B))/(a^4*x) - (b^2*(A*b - a*B))/(a^4*(a + b*x)) - (b^2*(4*A*b - 3*a*B)*Log[x])/a^5 + (b^2*(4*A*b - 3*a*B)*Log[a + b*x])/a^5", //
        78);
  }

  // {78}
  public void test0896() {
    check( //
        "Integrate[(x^4*(A + B*x))/(a + b*x)^3, x]", //
        "(-3*a*(A*b - 2*a*B)*x)/b^5 + ((A*b - 3*a*B)*x^2)/(2*b^4) + (B*x^3)/(3*b^3) - (a^4*(A*b - a*B))/(2*b^6*(a + b*x)^2) + (a^3*(4*A*b - 5*a*B))/(b^6*(a + b*x)) + (2*a^2*(3*A*b - 5*a*B)*Log[a + b*x])/b^6", //
        78);
  }

  // {78}
  public void test0897() {
    check( //
        "Integrate[(x^3*(A + B*x))/(a + b*x)^3, x]", //
        "((A*b - 3*a*B)*x)/b^4 + (B*x^2)/(2*b^3) + (a^3*(A*b - a*B))/(2*b^5*(a + b*x)^2) - (a^2*(3*A*b - 4*a*B))/(b^5*(a + b*x)) - (3*a*(A*b - 2*a*B)*Log[a + b*x])/b^5", //
        78);
  }

  // {78}
  public void test0898() {
    check( //
        "Integrate[(x^2*(A + B*x))/(a + b*x)^3, x]", //
        "(B*x)/b^3 - (a^2*(A*b - a*B))/(2*b^4*(a + b*x)^2) + (a*(2*A*b - 3*a*B))/(b^4*(a + b*x)) + ((A*b - 3*a*B)*Log[a + b*x])/b^4", //
        78);
  }

  // {78}
  public void test0899() {
    check( //
        "Integrate[(x*(A + B*x))/(a + b*x)^3, x]", //
        "(a*(A*b - a*B))/(2*b^3*(a + b*x)^2) - (A*b - 2*a*B)/(b^3*(a + b*x)) + (B*Log[a + b*x])/b^3", //
        78);
  }

  // {78}
  public void test0900() {
    check( //
        "Integrate[(A + B*x)/(x*(a + b*x)^3), x]", //
        "(A*b - a*B)/(2*a*b*(a + b*x)^2) + A/(a^2*(a + b*x)) + (A*Log[x])/a^3 - (A*Log[a + b*x])/a^3", //
        78);
  }

  // {78}
  public void test0901() {
    check( //
        "Integrate[(A + B*x)/(x^2*(a + b*x)^3), x]", //
        "-(A/(a^3*x)) - (A*b - a*B)/(2*a^2*(a + b*x)^2) - (2*A*b - a*B)/(a^3*(a + b*x)) - ((3*A*b - a*B)*Log[x])/a^4 + ((3*A*b - a*B)*Log[a + b*x])/a^4", //
        78);
  }

  // {78}
  public void test0902() {
    check( //
        "Integrate[(A + B*x)/(x^3*(a + b*x)^3), x]", //
        "-A/(2*a^3*x^2) + (3*A*b - a*B)/(a^4*x) + (b*(A*b - a*B))/(2*a^3*(a + b*x)^2) + (b*(3*A*b - 2*a*B))/(a^4*(a + b*x)) + (3*b*(2*A*b - a*B)*Log[x])/a^5 - (3*b*(2*A*b - a*B)*Log[a + b*x])/a^5", //
        78);
  }

  // {78}
  public void test0903() {
    check( //
        "Integrate[(A + B*x)/(x^4*(a + b*x)^3), x]", //
        "-A/(3*a^3*x^3) + (3*A*b - a*B)/(2*a^4*x^2) - (3*b*(2*A*b - a*B))/(a^5*x) - (b^2*(A*b - a*B))/(2*a^4*(a + b*x)^2) - (b^2*(4*A*b - 3*a*B))/(a^5*(a + b*x)) - (2*b^2*(5*A*b - 3*a*B)*Log[x])/a^6 + (2*b^2*(5*A*b - 3*a*B)*Log[a + b*x])/a^6", //
        78);
  }

  // {90}
  public void test0904() {
    check( //
        "Integrate[x^3*(a + b*x)^2*(c + d*x)^16, x]", //
        "-(c^3*(b*c - a*d)^2*(c + d*x)^17)/(17*d^6) + (c^2*(5*b*c - 3*a*d)*(b*c - a*d)*(c + d*x)^18)/(18*d^6) - (c*(10*b^2*c^2 - 12*a*b*c*d + 3*a^2*d^2)*(c + d*x)^19)/(19*d^6) + ((10*b^2*c^2 - 8*a*b*c*d + a^2*d^2)*(c + d*x)^20)/(20*d^6) - (b*(5*b*c - 2*a*d)*(c + d*x)^21)/(21*d^6) + (b^2*(c + d*x)^22)/(22*d^6)", //
        90);
  }

  // {90}
  public void test0905() {
    check( //
        "Integrate[x^2*(a + b*x)^2*(c + d*x)^16, x]", //
        "(c^2*(b*c - a*d)^2*(c + d*x)^17)/(17*d^5) - (c*(b*c - a*d)*(2*b*c - a*d)*(c + d*x)^18)/(9*d^5) + ((6*b^2*c^2 - 6*a*b*c*d + a^2*d^2)*(c + d*x)^19)/(19*d^5) - (b*(2*b*c - a*d)*(c + d*x)^20)/(10*d^5) + (b^2*(c + d*x)^21)/(21*d^5)", //
        90);
  }

  // {78}
  public void test0906() {
    check( //
        "Integrate[x*(a + b*x)^2*(c + d*x)^16, x]", //
        "-(c*(b*c - a*d)^2*(c + d*x)^17)/(17*d^4) + ((b*c - a*d)*(3*b*c - a*d)*(c + d*x)^18)/(18*d^4) - (b*(3*b*c - 2*a*d)*(c + d*x)^19)/(19*d^4) + (b^2*(c + d*x)^20)/(20*d^4)", //
        78);
  }

  // {78}
  public void test0907() {
    check( //
        "Integrate[(x^3*(c + d*x))/(a + b*x), x]", //
        "(a^2*(b*c - a*d)*x)/b^4 - (a*(b*c - a*d)*x^2)/(2*b^3) + ((b*c - a*d)*x^3)/(3*b^2) + (d*x^4)/(4*b) - (a^3*(b*c - a*d)*Log[a + b*x])/b^5", //
        78);
  }

  // {78}
  public void test0908() {
    check( //
        "Integrate[(x^2*(c + d*x))/(a + b*x), x]", //
        "-((a*(b*c - a*d)*x)/b^3) + ((b*c - a*d)*x^2)/(2*b^2) + (d*x^3)/(3*b) + (a^2*(b*c - a*d)*Log[a + b*x])/b^4", //
        78);
  }

  // {78}
  public void test0909() {
    check( //
        "Integrate[(x*(c + d*x))/(a + b*x), x]", //
        "((b*c - a*d)*x)/b^2 + (d*x^2)/(2*b) - (a*(b*c - a*d)*Log[a + b*x])/b^3", //
        78);
  }

  // {45}
  public void test0910() {
    check( //
        "Integrate[(c + d*x)/(a + b*x), x]", //
        "(d*x)/b + ((b*c - a*d)*Log[a + b*x])/b^2", //
        45);
  }

  // {78}
  public void test0911() {
    check( //
        "Integrate[(c + d*x)/(x*(a + b*x)), x]", //
        "(c*Log[x])/a - ((b*c - a*d)*Log[a + b*x])/(a*b)", //
        78);
  }

  // {78}
  public void test0912() {
    check( //
        "Integrate[(c + d*x)/(x^2*(a + b*x)), x]", //
        "-(c/(a*x)) - ((b*c - a*d)*Log[x])/a^2 + ((b*c - a*d)*Log[a + b*x])/a^2", //
        78);
  }

  // {78}
  public void test0913() {
    check( //
        "Integrate[(c + d*x)/(x^3*(a + b*x)), x]", //
        "-c/(2*a*x^2) + (b*c - a*d)/(a^2*x) + (b*(b*c - a*d)*Log[x])/a^3 - (b*(b*c - a*d)*Log[a + b*x])/a^3", //
        78);
  }

  // {78}
  public void test0914() {
    check( //
        "Integrate[(c + d*x)/(x^4*(a + b*x)), x]", //
        "-c/(3*a*x^3) + (b*c - a*d)/(2*a^2*x^2) - (b*(b*c - a*d))/(a^3*x) - (b^2*(b*c - a*d)*Log[x])/a^4 + (b^2*(b*c - a*d)*Log[a + b*x])/a^4", //
        78);
  }

  // {90}
  public void test0915() {
    check( //
        "Integrate[(x^3*(c + d*x)^2)/(a + b*x), x]", //
        "(a^2*(b*c - a*d)^2*x)/b^5 - (a*(b*c - a*d)^2*x^2)/(2*b^4) + ((b*c - a*d)^2*x^3)/(3*b^3) + (d*(2*b*c - a*d)*x^4)/(4*b^2) + (d^2*x^5)/(5*b) - (a^3*(b*c - a*d)^2*Log[a + b*x])/b^6", //
        90);
  }

  // {90}
  public void test0916() {
    check( //
        "Integrate[(x^2*(c + d*x)^2)/(a + b*x), x]", //
        "-((a*(b*c - a*d)^2*x)/b^4) + ((b*c - a*d)^2*x^2)/(2*b^3) + (d*(2*b*c - a*d)*x^3)/(3*b^2) + (d^2*x^4)/(4*b) + (a^2*(b*c - a*d)^2*Log[a + b*x])/b^5", //
        90);
  }

  // {78}
  public void test0917() {
    check( //
        "Integrate[(x*(c + d*x)^2)/(a + b*x), x]", //
        "((b*c - a*d)^2*x)/b^3 + (d*(2*b*c - a*d)*x^2)/(2*b^2) + (d^2*x^3)/(3*b) - (a*(b*c - a*d)^2*Log[a + b*x])/b^4", //
        78);
  }

  // {45}
  public void test0918() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*x), x]", //
        "(d*(b*c - a*d)*x)/b^2 + (c + d*x)^2/(2*b) + ((b*c - a*d)^2*Log[a + b*x])/b^3", //
        45);
  }

  // {84}
  public void test0919() {
    check( //
        "Integrate[(c + d*x)^2/(x*(a + b*x)), x]", //
        "(d^2*x)/b + (c^2*Log[x])/a - ((b*c - a*d)^2*Log[a + b*x])/(a*b^2)", //
        84);
  }

  // {90}
  public void test0920() {
    check( //
        "Integrate[(c + d*x)^2/(x^2*(a + b*x)), x]", //
        "-(c^2/(a*x)) - (c*(b*c - 2*a*d)*Log[x])/a^2 + ((b*c - a*d)^2*Log[a + b*x])/(a^2*b)", //
        90);
  }

  // {90}
  public void test0921() {
    check( //
        "Integrate[(c + d*x)^2/(x^3*(a + b*x)), x]", //
        "-c^2/(2*a*x^2) + (c*(b*c - 2*a*d))/(a^2*x) + ((b*c - a*d)^2*Log[x])/a^3 - ((b*c - a*d)^2*Log[a + b*x])/a^3", //
        90);
  }

  // {90}
  public void test0922() {
    check( //
        "Integrate[(c + d*x)^2/(x^4*(a + b*x)), x]", //
        "-c^2/(3*a*x^3) + (c*(b*c - 2*a*d))/(2*a^2*x^2) - (b*c - a*d)^2/(a^3*x) - (b*(b*c - a*d)^2*Log[x])/a^4 + (b*(b*c - a*d)^2*Log[a + b*x])/a^4", //
        90);
  }

  // {90}
  public void test0923() {
    check( //
        "Integrate[(c + d*x)^2/(x^5*(a + b*x)), x]", //
        "-c^2/(4*a*x^4) + (c*(b*c - 2*a*d))/(3*a^2*x^3) - (b*c - a*d)^2/(2*a^3*x^2) + (b*(b*c - a*d)^2)/(a^4*x) + (b^2*(b*c - a*d)^2*Log[x])/a^5 - (b^2*(b*c - a*d)^2*Log[a + b*x])/a^5", //
        90);
  }

  // {90}
  public void test0924() {
    check( //
        "Integrate[(x^3*(c + d*x)^3)/(a + b*x), x]", //
        "(a^2*(b*c - a*d)^3*x)/b^6 - (a*(b*c - a*d)^3*x^2)/(2*b^5) + ((b*c - a*d)^3*x^3)/(3*b^4) + (d*(3*b^2*c^2 - 3*a*b*c*d + a^2*d^2)*x^4)/(4*b^3) + (d^2*(3*b*c - a*d)*x^5)/(5*b^2) + (d^3*x^6)/(6*b) - (a^3*(b*c - a*d)^3*Log[a + b*x])/b^7", //
        90);
  }

  // {90}
  public void test0925() {
    check( //
        "Integrate[(x^2*(c + d*x)^3)/(a + b*x), x]", //
        "-((a*(b*c - a*d)^3*x)/b^5) + ((b*c - a*d)^3*x^2)/(2*b^4) + (d*(3*b^2*c^2 - 3*a*b*c*d + a^2*d^2)*x^3)/(3*b^3) + (d^2*(3*b*c - a*d)*x^4)/(4*b^2) + (d^3*x^5)/(5*b) + (a^2*(b*c - a*d)^3*Log[a + b*x])/b^6", //
        90);
  }

  // {78}
  public void test0926() {
    check( //
        "Integrate[(x*(c + d*x)^3)/(a + b*x), x]", //
        "((b*c - a*d)^3*x)/b^4 + (d*(3*b^2*c^2 - 3*a*b*c*d + a^2*d^2)*x^2)/(2*b^3) + (d^2*(3*b*c - a*d)*x^3)/(3*b^2) + (d^3*x^4)/(4*b) - (a*(b*c - a*d)^3*Log[a + b*x])/b^5", //
        78);
  }

  // {45}
  public void test0927() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x), x]", //
        "(d*(b*c - a*d)^2*x)/b^3 + ((b*c - a*d)*(c + d*x)^2)/(2*b^2) + (c + d*x)^3/(3*b) + ((b*c - a*d)^3*Log[a + b*x])/b^4", //
        45);
  }

  // {84}
  public void test0928() {
    check( //
        "Integrate[(c + d*x)^3/(x*(a + b*x)), x]", //
        "(d^2*(3*b*c - a*d)*x)/b^2 + (d^3*x^2)/(2*b) + (c^3*Log[x])/a - ((b*c - a*d)^3*Log[a + b*x])/(a*b^3)", //
        84);
  }

  // {90}
  public void test0929() {
    check( //
        "Integrate[(c + d*x)^3/(x^2*(a + b*x)), x]", //
        "-(c^3/(a*x)) + (d^3*x)/b - (c^2*(b*c - 3*a*d)*Log[x])/a^2 + ((b*c - a*d)^3*Log[a + b*x])/(a^2*b^2)", //
        90);
  }

  // {90}
  public void test0930() {
    check( //
        "Integrate[(c + d*x)^3/(x^3*(a + b*x)), x]", //
        "-c^3/(2*a*x^2) + (c^2*(b*c - 3*a*d))/(a^2*x) + (c*(b^2*c^2 - 3*a*b*c*d + 3*a^2*d^2)*Log[x])/a^3 - ((b*c - a*d)^3*Log[a + b*x])/(a^3*b)", //
        90);
  }

  // {90}
  public void test0931() {
    check( //
        "Integrate[(c + d*x)^3/(x^4*(a + b*x)), x]", //
        "-c^3/(3*a*x^3) + (c^2*(b*c - 3*a*d))/(2*a^2*x^2) - (c*(b^2*c^2 - 3*a*b*c*d + 3*a^2*d^2))/(a^3*x) - ((b*c - a*d)^3*Log[x])/a^4 + ((b*c - a*d)^3*Log[a + b*x])/a^4", //
        90);
  }

  // {90}
  public void test0932() {
    check( //
        "Integrate[(c + d*x)^3/(x^5*(a + b*x)), x]", //
        "-c^3/(4*a*x^4) + (c^2*(b*c - 3*a*d))/(3*a^2*x^3) - (c*(b^2*c^2 - 3*a*b*c*d + 3*a^2*d^2))/(2*a^3*x^2) + (b*c - a*d)^3/(a^4*x) + (b*(b*c - a*d)^3*Log[x])/a^5 - (b*(b*c - a*d)^3*Log[a + b*x])/a^5", //
        90);
  }

  // {90}
  public void test0933() {
    check( //
        "Integrate[(c + d*x)^3/(x^6*(a + b*x)), x]", //
        "-c^3/(5*a*x^5) + (c^2*(b*c - 3*a*d))/(4*a^2*x^4) - (c*(b^2*c^2 - 3*a*b*c*d + 3*a^2*d^2))/(3*a^3*x^3) + (b*c - a*d)^3/(2*a^4*x^2) - (b*(b*c - a*d)^3)/(a^5*x) - (b^2*(b*c - a*d)^3*Log[x])/a^6 + (b^2*(b*c - a*d)^3*Log[a + b*x])/a^6", //
        90);
  }

  // {84}
  public void test0934() {
    check( //
        "Integrate[x^5/((a + b*x)*(c + d*x)), x]", //
        "-(((b*c + a*d)*(b^2*c^2 + a^2*d^2)*x)/(b^4*d^4)) + ((b^2*c^2 + a*b*c*d + a^2*d^2)*x^2)/(2*b^3*d^3) - ((b*c + a*d)*x^3)/(3*b^2*d^2) + x^4/(4*b*d) - (a^5*Log[a + b*x])/(b^5*(b*c - a*d)) + (c^5*Log[c + d*x])/(d^5*(b*c - a*d))", //
        84);
  }

  // {84}
  public void test0935() {
    check( //
        "Integrate[x^4/((a + b*x)*(c + d*x)), x]", //
        "((b^2*c^2 + a*b*c*d + a^2*d^2)*x)/(b^3*d^3) - ((b*c + a*d)*x^2)/(2*b^2*d^2) + x^3/(3*b*d) + (a^4*Log[a + b*x])/(b^4*(b*c - a*d)) - (c^4*Log[c + d*x])/(d^4*(b*c - a*d))", //
        84);
  }

  // {84}
  public void test0936() {
    check( //
        "Integrate[x^3/((a + b*x)*(c + d*x)), x]", //
        "-(((b*c + a*d)*x)/(b^2*d^2)) + x^2/(2*b*d) - (a^3*Log[a + b*x])/(b^3*(b*c - a*d)) + (c^3*Log[c + d*x])/(d^3*(b*c - a*d))", //
        84);
  }

  // {84}
  public void test0937() {
    check( //
        "Integrate[x^2/((a + b*x)*(c + d*x)), x]", //
        "x/(b*d) + (a^2*Log[a + b*x])/(b^2*(b*c - a*d)) - (c^2*Log[c + d*x])/(d^2*(b*c - a*d))", //
        84);
  }

  // {78}
  public void test0938() {
    check( //
        "Integrate[x/((a + b*x)*(c + d*x)), x]", //
        "-((a*Log[a + b*x])/(b*(b*c - a*d))) + (c*Log[c + d*x])/(d*(b*c - a*d))", //
        78);
  }

  // {84}
  public void test0939() {
    check( //
        "Integrate[1/(x*(a + b*x)*(c + d*x)), x]", //
        "Log[x]/(a*c) - (b*Log[a + b*x])/(a*(b*c - a*d)) + (d*Log[c + d*x])/(c*(b*c - a*d))", //
        84);
  }

  // {84}
  public void test0940() {
    check( //
        "Integrate[1/(x^2*(a + b*x)*(c + d*x)), x]", //
        "-(1/(a*c*x)) - ((b*c + a*d)*Log[x])/(a^2*c^2) + (b^2*Log[a + b*x])/(a^2*(b*c - a*d)) - (d^2*Log[c + d*x])/(c^2*(b*c - a*d))", //
        84);
  }

  // {84}
  public void test0941() {
    check( //
        "Integrate[1/(x^3*(a + b*x)*(c + d*x)), x]", //
        "-1/(2*a*c*x^2) + (b*c + a*d)/(a^2*c^2*x) + ((b^2*c^2 + a*b*c*d + a^2*d^2)*Log[x])/(a^3*c^3) - (b^3*Log[a + b*x])/(a^3*(b*c - a*d)) + (d^3*Log[c + d*x])/(c^3*(b*c - a*d))", //
        84);
  }

  // {84}
  public void test0942() {
    check( //
        "Integrate[1/(x^4*(a + b*x)*(c + d*x)), x]", //
        "-1/(3*a*c*x^3) + (b*c + a*d)/(2*a^2*c^2*x^2) - (b^2*c^2 + a*b*c*d + a^2*d^2)/(a^3*c^3*x) - ((b*c + a*d)*(b^2*c^2 + a^2*d^2)*Log[x])/(a^4*c^4) + (b^4*Log[a + b*x])/(a^4*(b*c - a*d)) - (d^4*Log[c + d*x])/(c^4*(b*c - a*d))", //
        84);
  }

  // {90}
  public void test0943() {
    fSeconds = 20;
    check( //
        "Integrate[x^5/((a + b*x)*(c + d*x)^2), x]", //
        "((3*b^2*c^2 + 2*a*b*c*d + a^2*d^2)*x)/(b^3*d^4) - ((2*b*c + a*d)*x^2)/(2*b^2*d^3) + x^3/(3*b*d^2) - c^5/(d^5*(b*c - a*d)*(c + d*x)) - (a^5*Log[a + b*x])/(b^4*(b*c - a*d)^2) - (c^4*(4*b*c - 5*a*d)*Log[c + d*x])/(d^5*(b*c - a*d)^2)", //
        90);
  }

  // {90}
  public void test0944() {
    check( //
        "Integrate[x^4/((a + b*x)*(c + d*x)^2), x]", //
        "-(((2*b*c + a*d)*x)/(b^2*d^3)) + x^2/(2*b*d^2) + c^4/(d^4*(b*c - a*d)*(c + d*x)) + (a^4*Log[a + b*x])/(b^3*(b*c - a*d)^2) + (c^3*(3*b*c - 4*a*d)*Log[c + d*x])/(d^4*(b*c - a*d)^2)", //
        90);
  }

  // {90}
  public void test0945() {
    check( //
        "Integrate[x^3/((a + b*x)*(c + d*x)^2), x]", //
        "x/(b*d^2) - c^3/(d^3*(b*c - a*d)*(c + d*x)) - (a^3*Log[a + b*x])/(b^2*(b*c - a*d)^2) - (c^2*(2*b*c - 3*a*d)*Log[c + d*x])/(d^3*(b*c - a*d)^2)", //
        90);
  }

  // {90}
  public void test0946() {
    fSeconds = 20;
    check( //
        "Integrate[x^2/((a + b*x)*(c + d*x)^2), x]", //
        "c^2/(d^2*(b*c - a*d)*(c + d*x)) + (a^2*Log[a + b*x])/(b*(b*c - a*d)^2) + (c*(b*c - 2*a*d)*Log[c + d*x])/(d^2*(b*c - a*d)^2)", //
        90);
  }

  // {78}
  public void test0947() {
    fSeconds = 20;
    check( //
        "Integrate[x/((a + b*x)*(c + d*x)^2), x]", //
        "-(c/(d*(b*c - a*d)*(c + d*x))) - (a*Log[a + b*x])/(b*c - a*d)^2 + (a*Log[c + d*x])/(b*c - a*d)^2", //
        78);
  }

  // {46}
  public void test0948() {
    fSeconds = 20;
    check( //
        "Integrate[1/((a + b*x)*(c + d*x)^2), x]", //
        "1/((b*c - a*d)*(c + d*x)) + (b*Log[a + b*x])/(b*c - a*d)^2 - (b*Log[c + d*x])/(b*c - a*d)^2", //
        46);
  }

  // {84}
  public void test0949() {
    fSeconds = 20;
    check( //
        "Integrate[1/(x*(a + b*x)*(c + d*x)^2), x]", //
        "-(d/(c*(b*c - a*d)*(c + d*x))) + Log[x]/(a*c^2) - (b^2*Log[a + b*x])/(a*(b*c - a*d)^2) + (d*(2*b*c - a*d)*Log[c + d*x])/(c^2*(b*c - a*d)^2)", //
        84);
  }

  // {90}
  public void test0950() {
    fSeconds = 20;
    check( //
        "Integrate[1/(x^2*(a + b*x)*(c + d*x)^2), x]", //
        "-(1/(a*c^2*x)) + d^2/(c^2*(b*c - a*d)*(c + d*x)) - ((b*c + 2*a*d)*Log[x])/(a^2*c^3) + (b^3*Log[a + b*x])/(a^2*(b*c - a*d)^2) - (d^2*(3*b*c - 2*a*d)*Log[c + d*x])/(c^3*(b*c - a*d)^2)", //
        90);
  }

  // {90}
  public void test0951() {
    fSeconds = 20;
    check( //
        "Integrate[1/(x^3*(a + b*x)*(c + d*x)^2), x]", //
        "-1/(2*a*c^2*x^2) + (b*c + 2*a*d)/(a^2*c^3*x) - d^3/(c^3*(b*c - a*d)*(c + d*x)) + ((b^2*c^2 + 2*a*b*c*d + 3*a^2*d^2)*Log[x])/(a^3*c^4) - (b^4*Log[a + b*x])/(a^3*(b*c - a*d)^2) + (d^3*(4*b*c - 3*a*d)*Log[c + d*x])/(c^4*(b*c - a*d)^2)", //
        90);
  }

  // {90}
  public void test0952() {
    fSeconds = 20;
    check( //
        "Integrate[x^5/((a + b*x)*(c + d*x)^3), x]", //
        "-(((3*b*c + a*d)*x)/(b^2*d^4)) + x^2/(2*b*d^3) - c^5/(2*d^5*(b*c - a*d)*(c + d*x)^2) + (c^4*(4*b*c - 5*a*d))/(d^5*(b*c - a*d)^2*(c + d*x)) - (a^5*Log[a + b*x])/(b^3*(b*c - a*d)^3) + (c^3*(6*b^2*c^2 - 15*a*b*c*d + 10*a^2*d^2)*Log[c + d*x])/(d^5*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0953() {
    fSeconds = 20;
    check( //
        "Integrate[x^4/((a + b*x)*(c + d*x)^3), x]", //
        "x/(b*d^3) + c^4/(2*d^4*(b*c - a*d)*(c + d*x)^2) - (c^3*(3*b*c - 4*a*d))/(d^4*(b*c - a*d)^2*(c + d*x)) + (a^4*Log[a + b*x])/(b^2*(b*c - a*d)^3) - (c^2*(3*b^2*c^2 - 8*a*b*c*d + 6*a^2*d^2)*Log[c + d*x])/(d^4*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0954() {
    fSeconds = 20;
    check( //
        "Integrate[x^3/((a + b*x)*(c + d*x)^3), x]", //
        "-c^3/(2*d^3*(b*c - a*d)*(c + d*x)^2) + (c^2*(2*b*c - 3*a*d))/(d^3*(b*c - a*d)^2*(c + d*x)) - (a^3*Log[a + b*x])/(b*(b*c - a*d)^3) + (c*(b^2*c^2 - 3*a*b*c*d + 3*a^2*d^2)*Log[c + d*x])/(d^3*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0955() {
    fSeconds = 20;
    check( //
        "Integrate[x^2/((a + b*x)*(c + d*x)^3), x]", //
        "c^2/(2*d^2*(b*c - a*d)*(c + d*x)^2) - (c*(b*c - 2*a*d))/(d^2*(b*c - a*d)^2*(c + d*x)) + (a^2*Log[a + b*x])/(b*c - a*d)^3 - (a^2*Log[c + d*x])/(b*c - a*d)^3", //
        90);
  }

  // {78}
  public void test0956() {
    fSeconds = 20;
    check( //
        "Integrate[x/((a + b*x)*(c + d*x)^3), x]", //
        "-c/(2*d*(b*c - a*d)*(c + d*x)^2) - a/((b*c - a*d)^2*(c + d*x)) - (a*b*Log[a + b*x])/(b*c - a*d)^3 + (a*b*Log[c + d*x])/(b*c - a*d)^3", //
        78);
  }

  // {46}
  public void test0957() {
    fSeconds = 20;
    check( //
        "Integrate[1/((a + b*x)*(c + d*x)^3), x]", //
        "1/(2*(b*c - a*d)*(c + d*x)^2) + b/((b*c - a*d)^2*(c + d*x)) + (b^2*Log[a + b*x])/(b*c - a*d)^3 - (b^2*Log[c + d*x])/(b*c - a*d)^3", //
        46);
  }

  // {84}
  public void test0958() {
    fSeconds = 20;
    check( //
        "Integrate[1/(x*(a + b*x)*(c + d*x)^3), x]", //
        "-d/(2*c*(b*c - a*d)*(c + d*x)^2) - (d*(2*b*c - a*d))/(c^2*(b*c - a*d)^2*(c + d*x)) + Log[x]/(a*c^3) - (b^3*Log[a + b*x])/(a*(b*c - a*d)^3) + (d*(3*b^2*c^2 - 3*a*b*c*d + a^2*d^2)*Log[c + d*x])/(c^3*(b*c - a*d)^3)", //
        84);
  }

  // {90}
  public void test0959() {
    fSeconds = 20;
    check( //
        "Integrate[1/(x^2*(a + b*x)*(c + d*x)^3), x]", //
        "-(1/(a*c^3*x)) + d^2/(2*c^2*(b*c - a*d)*(c + d*x)^2) + (d^2*(3*b*c - 2*a*d))/(c^3*(b*c - a*d)^2*(c + d*x)) - ((b*c + 3*a*d)*Log[x])/(a^2*c^4) + (b^4*Log[a + b*x])/(a^2*(b*c - a*d)^3) - (d^2*(6*b^2*c^2 - 8*a*b*c*d + 3*a^2*d^2)*Log[c + d*x])/(c^4*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0960() {
    fSeconds = 20;
    check( //
        "Integrate[(x^4*(c + d*x)^2)/(a + b*x)^2, x]", //
        "(a^2*(3*b*c - 5*a*d)*(b*c - a*d)*x)/b^6 - (a*(b*c - 2*a*d)*(b*c - a*d)*x^2)/b^5 + ((b*c - 3*a*d)*(b*c - a*d)*x^3)/(3*b^4) + (d*(b*c - a*d)*x^4)/(2*b^3) + (d^2*x^5)/(5*b^2) - (a^4*(b*c - a*d)^2)/(b^7*(a + b*x)) - (2*a^3*(2*b*c - 3*a*d)*(b*c - a*d)*Log[a + b*x])/b^7", //
        90);
  }

  // {90}
  public void test0961() {
    fSeconds = 20;
    check( //
        "Integrate[(x^3*(c + d*x)^2)/(a + b*x)^2, x]", //
        "(-2*a*(b*c - 2*a*d)*(b*c - a*d)*x)/b^5 + ((b*c - 3*a*d)*(b*c - a*d)*x^2)/(2*b^4) + (2*d*(b*c - a*d)*x^3)/(3*b^3) + (d^2*x^4)/(4*b^2) + (a^3*(b*c - a*d)^2)/(b^6*(a + b*x)) + (a^2*(3*b*c - 5*a*d)*(b*c - a*d)*Log[a + b*x])/b^6", //
        90);
  }

  // {90}
  public void test0962() {
    fSeconds = 20;
    check( //
        "Integrate[(x^2*(c + d*x)^2)/(a + b*x)^2, x]", //
        "((b*c - 3*a*d)*(b*c - a*d)*x)/b^4 + (d*(b*c - a*d)*x^2)/b^3 + (d^2*x^3)/(3*b^2) - (a^2*(b*c - a*d)^2)/(b^5*(a + b*x)) - (2*a*(b*c - 2*a*d)*(b*c - a*d)*Log[a + b*x])/b^5", //
        90);
  }

  // {78}
  public void test0963() {
    fSeconds = 20;
    check( //
        "Integrate[(x*(c + d*x)^2)/(a + b*x)^2, x]", //
        "(2*d*(b*c - a*d)*x)/b^3 + (d^2*x^2)/(2*b^2) + (a*(b*c - a*d)^2)/(b^4*(a + b*x)) + ((b*c - 3*a*d)*(b*c - a*d)*Log[a + b*x])/b^4", //
        78);
  }

  // {45}
  public void test0964() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*x)^2, x]", //
        "(d^2*x)/b^2 - (b*c - a*d)^2/(b^3*(a + b*x)) + (2*d*(b*c - a*d)*Log[a + b*x])/b^3", //
        45);
  }

  // {90}
  public void test0965() {
    check( //
        "Integrate[(c + d*x)^2/(x*(a + b*x)^2), x]", //
        "(b*c - a*d)^2/(a*b^2*(a + b*x)) + (c^2*Log[x])/a^2 - (c^2/a^2 - d^2/b^2)*Log[a + b*x]", //
        90);
  }

  // {90}
  public void test0966() {
    check( //
        "Integrate[(c + d*x)^2/(x^2*(a + b*x)^2), x]", //
        "-(c^2/(a^2*x)) - (b*c - a*d)^2/(a^2*b*(a + b*x)) - (2*c*(b*c - a*d)*Log[x])/a^3 + (2*c*(b*c - a*d)*Log[a + b*x])/a^3", //
        90);
  }

  // {90}
  public void test0967() {
    check( //
        "Integrate[(c + d*x)^2/(x^3*(a + b*x)^2), x]", //
        "-c^2/(2*a^2*x^2) + (2*c*(b*c - a*d))/(a^3*x) + (b*c - a*d)^2/(a^3*(a + b*x)) + ((b*c - a*d)*(3*b*c - a*d)*Log[x])/a^4 - ((b*c - a*d)*(3*b*c - a*d)*Log[a + b*x])/a^4", //
        90);
  }

  // {90}
  public void test0968() {
    check( //
        "Integrate[(c + d*x)^2/(x^4*(a + b*x)^2), x]", //
        "-c^2/(3*a^2*x^3) + (c*(b*c - a*d))/(a^3*x^2) - ((b*c - a*d)*(3*b*c - a*d))/(a^4*x) - (b*(b*c - a*d)^2)/(a^4*(a + b*x)) - (2*b*(b*c - a*d)*(2*b*c - a*d)*Log[x])/a^5 + (2*b*(b*c - a*d)*(2*b*c - a*d)*Log[a + b*x])/a^5", //
        90);
  }

  // {90}
  public void test0969() {
    check( //
        "Integrate[(c + d*x)^2/(x^5*(a + b*x)^2), x]", //
        "-c^2/(4*a^2*x^4) + (2*c*(b*c - a*d))/(3*a^3*x^3) - ((b*c - a*d)*(3*b*c - a*d))/(2*a^4*x^2) + (2*b*(b*c - a*d)*(2*b*c - a*d))/(a^5*x) + (b^2*(b*c - a*d)^2)/(a^5*(a + b*x)) + (b^2*(5*b*c - 3*a*d)*(b*c - a*d)*Log[x])/a^6 - (b^2*(5*b*c - 3*a*d)*(b*c - a*d)*Log[a + b*x])/a^6", //
        90);
  }

  // {90}
  public void test0970() {
    fSeconds = 20;
    check( //
        "Integrate[(x^4*(c + d*x)^3)/(a + b*x)^2, x]", //
        "(3*a^2*(b*c - 2*a*d)*(b*c - a*d)^2*x)/b^7 - (a*(2*b*c - 5*a*d)*(b*c - a*d)^2*x^2)/(2*b^6) + ((b*c - 4*a*d)*(b*c - a*d)^2*x^3)/(3*b^5) + (3*d*(b*c - a*d)^2*x^4)/(4*b^4) + (d^2*(3*b*c - 2*a*d)*x^5)/(5*b^3) + (d^3*x^6)/(6*b^2) - (a^4*(b*c - a*d)^3)/(b^8*(a + b*x)) - (a^3*(4*b*c - 7*a*d)*(b*c - a*d)^2*Log[a + b*x])/b^8", //
        90);
  }

  // {90}
  public void test0971() {
    check( //
        "Integrate[(x^3*(c + d*x)^3)/(a + b*x)^2, x]", //
        "-((a*(2*b*c - 5*a*d)*(b*c - a*d)^2*x)/b^6) + ((b*c - 4*a*d)*(b*c - a*d)^2*x^2)/(2*b^5) + (d*(b*c - a*d)^2*x^3)/b^4 + (d^2*(3*b*c - 2*a*d)*x^4)/(4*b^3) + (d^3*x^5)/(5*b^2) + (a^3*(b*c - a*d)^3)/(b^7*(a + b*x)) + (3*a^2*(b*c - 2*a*d)*(b*c - a*d)^2*Log[a + b*x])/b^7", //
        90);
  }

  // {90}
  public void test0972() {
    check( //
        "Integrate[(x^2*(c + d*x)^3)/(a + b*x)^2, x]", //
        "((b*c - 4*a*d)*(b*c - a*d)^2*x)/b^5 + (3*d*(b*c - a*d)^2*x^2)/(2*b^4) + (d^2*(3*b*c - 2*a*d)*x^3)/(3*b^3) + (d^3*x^4)/(4*b^2) - (a^2*(b*c - a*d)^3)/(b^6*(a + b*x)) - (a*(2*b*c - 5*a*d)*(b*c - a*d)^2*Log[a + b*x])/b^6", //
        90);
  }

  // {78}
  public void test0973() {
    check( //
        "Integrate[(x*(c + d*x)^3)/(a + b*x)^2, x]", //
        "(3*d*(b*c - a*d)^2*x)/b^4 + (d^2*(3*b*c - 2*a*d)*x^2)/(2*b^3) + (d^3*x^3)/(3*b^2) + (a*(b*c - a*d)^3)/(b^5*(a + b*x)) + ((b*c - 4*a*d)*(b*c - a*d)^2*Log[a + b*x])/b^5", //
        78);
  }

  // {45}
  public void test0974() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^2, x]", //
        "(d^2*(3*b*c - 2*a*d)*x)/b^3 + (d^3*x^2)/(2*b^2) - (b*c - a*d)^3/(b^4*(a + b*x)) + (3*d*(b*c - a*d)^2*Log[a + b*x])/b^4", //
        45);
  }

  // {90}
  public void test0975() {
    check( //
        "Integrate[(c + d*x)^3/(x*(a + b*x)^2), x]", //
        "(d^3*x)/b^2 + (b*c - a*d)^3/(a*b^3*(a + b*x)) + (c^3*Log[x])/a^2 - ((b*c - a*d)^2*(b*c + 2*a*d)*Log[a + b*x])/(a^2*b^3)", //
        90);
  }

  // {90}
  public void test0976() {
    check( //
        "Integrate[(c + d*x)^3/(x^2*(a + b*x)^2), x]", //
        "-(c^3/(a^2*x)) - (b*c - a*d)^3/(a^2*b^2*(a + b*x)) - (c^2*(2*b*c - 3*a*d)*Log[x])/a^3 + ((b*c - a*d)^2*(2*b*c + a*d)*Log[a + b*x])/(a^3*b^2)", //
        90);
  }

  // {90}
  public void test0977() {
    check( //
        "Integrate[(c + d*x)^3/(x^3*(a + b*x)^2), x]", //
        "-c^3/(2*a^2*x^2) + (c^2*(2*b*c - 3*a*d))/(a^3*x) + (b*c - a*d)^3/(a^3*b*(a + b*x)) + (3*c*(b*c - a*d)^2*Log[x])/a^4 - (3*c*(b*c - a*d)^2*Log[a + b*x])/a^4", //
        90);
  }

  // {90}
  public void test0978() {
    check( //
        "Integrate[(c + d*x)^3/(x^4*(a + b*x)^2), x]", //
        "-c^3/(3*a^2*x^3) + (c^2*(2*b*c - 3*a*d))/(2*a^3*x^2) - (3*c*(b*c - a*d)^2)/(a^4*x) - (b*c - a*d)^3/(a^4*(a + b*x)) - ((b*c - a*d)^2*(4*b*c - a*d)*Log[x])/a^5 + ((b*c - a*d)^2*(4*b*c - a*d)*Log[a + b*x])/a^5", //
        90);
  }

  // {90}
  public void test0979() {
    check( //
        "Integrate[(c + d*x)^3/(x^5*(a + b*x)^2), x]", //
        "-c^3/(4*a^2*x^4) + (c^2*(2*b*c - 3*a*d))/(3*a^3*x^3) - (3*c*(b*c - a*d)^2)/(2*a^4*x^2) + ((b*c - a*d)^2*(4*b*c - a*d))/(a^5*x) + (b*(b*c - a*d)^3)/(a^5*(a + b*x)) + (b*(5*b*c - 2*a*d)*(b*c - a*d)^2*Log[x])/a^6 - (b*(5*b*c - 2*a*d)*(b*c - a*d)^2*Log[a + b*x])/a^6", //
        90);
  }

  // {90}
  public void test0980() {
    check( //
        "Integrate[(c + d*x)^3/(x^6*(a + b*x)^2), x]", //
        "-c^3/(5*a^2*x^5) + (c^2*(2*b*c - 3*a*d))/(4*a^3*x^4) - (c*(b*c - a*d)^2)/(a^4*x^3) + ((b*c - a*d)^2*(4*b*c - a*d))/(2*a^5*x^2) - (b*(5*b*c - 2*a*d)*(b*c - a*d)^2)/(a^6*x) - (b^2*(b*c - a*d)^3)/(a^6*(a + b*x)) - (3*b^2*(b*c - a*d)^2*(2*b*c - a*d)*Log[x])/a^7 + (3*b^2*(b*c - a*d)^2*(2*b*c - a*d)*Log[a + b*x])/a^7", //
        90);
  }

  // {90}
  public void test0981() {
    check( //
        "Integrate[x^6/((a + b*x)^2*(c + d*x)^2), x]", //
        "((3*b^2*c^2 + 4*a*b*c*d + 3*a^2*d^2)*x)/(b^4*d^4) - ((b*c + a*d)*x^2)/(b^3*d^3) + x^3/(3*b^2*d^2) - a^6/(b^5*(b*c - a*d)^2*(a + b*x)) - c^6/(d^5*(b*c - a*d)^2*(c + d*x)) - (2*a^5*(3*b*c - 2*a*d)*Log[a + b*x])/(b^5*(b*c - a*d)^3) - (2*c^5*(2*b*c - 3*a*d)*Log[c + d*x])/(d^5*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0982() {
    check( //
        "Integrate[x^5/((a + b*x)^2*(c + d*x)^2), x]", //
        "(-2*(b*c + a*d)*x)/(b^3*d^3) + x^2/(2*b^2*d^2) + a^5/(b^4*(b*c - a*d)^2*(a + b*x)) + c^5/(d^4*(b*c - a*d)^2*(c + d*x)) + (a^4*(5*b*c - 3*a*d)*Log[a + b*x])/(b^4*(b*c - a*d)^3) + (c^4*(3*b*c - 5*a*d)*Log[c + d*x])/(d^4*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0983() {
    check( //
        "Integrate[x^4/((a + b*x)^2*(c + d*x)^2), x]", //
        "x/(b^2*d^2) - a^4/(b^3*(b*c - a*d)^2*(a + b*x)) - c^4/(d^3*(b*c - a*d)^2*(c + d*x)) - (2*a^3*(2*b*c - a*d)*Log[a + b*x])/(b^3*(b*c - a*d)^3) - (2*c^3*(b*c - 2*a*d)*Log[c + d*x])/(d^3*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0984() {
    check( //
        "Integrate[x^3/((a + b*x)^2*(c + d*x)^2), x]", //
        "a^3/(b^2*(b*c - a*d)^2*(a + b*x)) + c^3/(d^2*(b*c - a*d)^2*(c + d*x)) + (a^2*(3*b*c - a*d)*Log[a + b*x])/(b^2*(b*c - a*d)^3) + (c^2*(b*c - 3*a*d)*Log[c + d*x])/(d^2*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0985() {
    check( //
        "Integrate[x^2/((a + b*x)^2*(c + d*x)^2), x]", //
        "-(a^2/(b*(b*c - a*d)^2*(a + b*x))) - c^2/(d*(b*c - a*d)^2*(c + d*x)) - (2*a*c*Log[a + b*x])/(b*c - a*d)^3 + (2*a*c*Log[c + d*x])/(b*c - a*d)^3", //
        90);
  }

  // {78}
  public void test0986() {
    check( //
        "Integrate[x/((a + b*x)^2*(c + d*x)^2), x]", //
        "a/((b*c - a*d)^2*(a + b*x)) + c/((b*c - a*d)^2*(c + d*x)) + ((b*c + a*d)*Log[a + b*x])/(b*c - a*d)^3 - ((b*c + a*d)*Log[c + d*x])/(b*c - a*d)^3", //
        78);
  }

  // {46}
  public void test0987() {
    check( //
        "Integrate[1/((a + b*x)^2*(c + d*x)^2), x]", //
        "-(b/((b*c - a*d)^2*(a + b*x))) - d/((b*c - a*d)^2*(c + d*x)) - (2*b*d*Log[a + b*x])/(b*c - a*d)^3 + (2*b*d*Log[c + d*x])/(b*c - a*d)^3", //
        46);
  }

  // {90}
  public void test0988() {
    check( //
        "Integrate[1/(x*(a + b*x)^2*(c + d*x)^2), x]", //
        "b^2/(a*(b*c - a*d)^2*(a + b*x)) + d^2/(c*(b*c - a*d)^2*(c + d*x)) + Log[x]/(a^2*c^2) - (b^2*(b*c - 3*a*d)*Log[a + b*x])/(a^2*(b*c - a*d)^3) - (d^2*(3*b*c - a*d)*Log[c + d*x])/(c^2*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0989() {
    check( //
        "Integrate[1/(x^2*(a + b*x)^2*(c + d*x)^2), x]", //
        "-(1/(a^2*c^2*x)) - b^3/(a^2*(b*c - a*d)^2*(a + b*x)) - d^3/(c^2*(b*c - a*d)^2*(c + d*x)) - (2*(b*c + a*d)*Log[x])/(a^3*c^3) + (2*b^3*(b*c - 2*a*d)*Log[a + b*x])/(a^3*(b*c - a*d)^3) + (2*d^3*(2*b*c - a*d)*Log[c + d*x])/(c^3*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0990() {
    check( //
        "Integrate[1/(x^3*(a + b*x)^2*(c + d*x)^2), x]", //
        "-1/(2*a^2*c^2*x^2) + (2*(b*c + a*d))/(a^3*c^3*x) + b^4/(a^3*(b*c - a*d)^2*(a + b*x)) + d^4/(c^3*(b*c - a*d)^2*(c + d*x)) + ((3*b^2*c^2 + 4*a*b*c*d + 3*a^2*d^2)*Log[x])/(a^4*c^4) - (b^4*(3*b*c - 5*a*d)*Log[a + b*x])/(a^4*(b*c - a*d)^3) - (d^4*(5*b*c - 3*a*d)*Log[c + d*x])/(c^4*(b*c - a*d)^3)", //
        90);
  }

  // {90}
  public void test0991() {
    check( //
        "Integrate[x^7/((a + b*x)^2*(c + d*x)^3), x]", //
        "(3*(2*b^2*c^2 + 2*a*b*c*d + a^2*d^2)*x)/(b^4*d^5) - ((3*b*c + 2*a*d)*x^2)/(2*b^3*d^4) + x^3/(3*b^2*d^3) + a^7/(b^5*(b*c - a*d)^3*(a + b*x)) + c^7/(2*d^6*(b*c - a*d)^2*(c + d*x)^2) - (c^6*(5*b*c - 7*a*d))/(d^6*(b*c - a*d)^3*(c + d*x)) + (a^6*(7*b*c - 4*a*d)*Log[a + b*x])/(b^5*(b*c - a*d)^4) - (c^5*(10*b^2*c^2 - 28*a*b*c*d + 21*a^2*d^2)*Log[c + d*x])/(d^6*(b*c - a*d)^4)", //
        90);
  }

  // {90}
  public void test0992() {
    check( //
        "Integrate[x^6/((a + b*x)^2*(c + d*x)^3), x]", //
        "-(((3*b*c + 2*a*d)*x)/(b^3*d^4)) + x^2/(2*b^2*d^3) - a^6/(b^4*(b*c - a*d)^3*(a + b*x)) - c^6/(2*d^5*(b*c - a*d)^2*(c + d*x)^2) + (2*c^5*(2*b*c - 3*a*d))/(d^5*(b*c - a*d)^3*(c + d*x)) - (3*a^5*(2*b*c - a*d)*Log[a + b*x])/(b^4*(b*c - a*d)^4) + (3*c^4*(2*b^2*c^2 - 6*a*b*c*d + 5*a^2*d^2)*Log[c + d*x])/(d^5*(b*c - a*d)^4)", //
        90);
  }

  // {90}
  public void test0993() {
    check( //
        "Integrate[x^5/((a + b*x)^2*(c + d*x)^3), x]", //
        "x/(b^2*d^3) + a^5/(b^3*(b*c - a*d)^3*(a + b*x)) + c^5/(2*d^4*(b*c - a*d)^2*(c + d*x)^2) - (c^4*(3*b*c - 5*a*d))/(d^4*(b*c - a*d)^3*(c + d*x)) + (a^4*(5*b*c - 2*a*d)*Log[a + b*x])/(b^3*(b*c - a*d)^4) - (c^3*(3*b^2*c^2 - 10*a*b*c*d + 10*a^2*d^2)*Log[c + d*x])/(d^4*(b*c - a*d)^4)", //
        90);
  }

  // {90}
  public void test0994() {
    check( //
        "Integrate[x^4/((a + b*x)^2*(c + d*x)^3), x]", //
        "-(a^4/(b^2*(b*c - a*d)^3*(a + b*x))) - c^4/(2*d^3*(b*c - a*d)^2*(c + d*x)^2) + (2*c^3*(b*c - 2*a*d))/(d^3*(b*c - a*d)^3*(c + d*x)) - (a^3*(4*b*c - a*d)*Log[a + b*x])/(b^2*(b*c - a*d)^4) + (c^2*(b^2*c^2 - 4*a*b*c*d + 6*a^2*d^2)*Log[c + d*x])/(d^3*(b*c - a*d)^4)", //
        90);
  }

  // {90}
  public void test0995() {
    check( //
        "Integrate[x^3/((a + b*x)^2*(c + d*x)^3), x]", //
        "a^3/(b*(b*c - a*d)^3*(a + b*x)) + c^3/(2*d^2*(b*c - a*d)^2*(c + d*x)^2) - (c^2*(b*c - 3*a*d))/(d^2*(b*c - a*d)^3*(c + d*x)) + (3*a^2*c*Log[a + b*x])/(b*c - a*d)^4 - (3*a^2*c*Log[c + d*x])/(b*c - a*d)^4", //
        90);
  }

  // {90}
  public void test0996() {
    check( //
        "Integrate[x^2/((a + b*x)^2*(c + d*x)^3), x]", //
        "-(a^2/((b*c - a*d)^3*(a + b*x))) - c^2/(2*d*(b*c - a*d)^2*(c + d*x)^2) - (2*a*c)/((b*c - a*d)^3*(c + d*x)) - (a*(2*b*c + a*d)*Log[a + b*x])/(b*c - a*d)^4 + (a*(2*b*c + a*d)*Log[c + d*x])/(b*c - a*d)^4", //
        90);
  }

  // {78}
  public void test0997() {
    check( //
        "Integrate[x/((a + b*x)^2*(c + d*x)^3), x]", //
        "(a*b)/((b*c - a*d)^3*(a + b*x)) + c/(2*(b*c - a*d)^2*(c + d*x)^2) + (b*c + a*d)/((b*c - a*d)^3*(c + d*x)) + (b*(b*c + 2*a*d)*Log[a + b*x])/(b*c - a*d)^4 - (b*(b*c + 2*a*d)*Log[c + d*x])/(b*c - a*d)^4", //
        78);
  }

  // {46}
  public void test0998() {
    check( //
        "Integrate[1/((a + b*x)^2*(c + d*x)^3), x]", //
        "-(b^2/((b*c - a*d)^3*(a + b*x))) - d/(2*(b*c - a*d)^2*(c + d*x)^2) - (2*b*d)/((b*c - a*d)^3*(c + d*x)) - (3*b^2*d*Log[a + b*x])/(b*c - a*d)^4 + (3*b^2*d*Log[c + d*x])/(b*c - a*d)^4", //
        46);
  }

  // {90}
  public void test0999() {
    check( //
        "Integrate[1/(x*(a + b*x)^2*(c + d*x)^3), x]", //
        "b^3/(a*(b*c - a*d)^3*(a + b*x)) + d^2/(2*c*(b*c - a*d)^2*(c + d*x)^2) + (d^2*(3*b*c - a*d))/(c^2*(b*c - a*d)^3*(c + d*x)) + Log[x]/(a^2*c^3) - (b^3*(b*c - 4*a*d)*Log[a + b*x])/(a^2*(b*c - a*d)^4) - (d^2*(6*b^2*c^2 - 4*a*b*c*d + a^2*d^2)*Log[c + d*x])/(c^3*(b*c - a*d)^4)", //
        90);
  }

  // {90}
  public void test1000() {
    check( //
        "Integrate[1/(x^2*(a + b*x)^2*(c + d*x)^3), x]", //
        "-(1/(a^2*c^3*x)) - b^4/(a^2*(b*c - a*d)^3*(a + b*x)) - d^3/(2*c^2*(b*c - a*d)^2*(c + d*x)^2) - (2*d^3*(2*b*c - a*d))/(c^3*(b*c - a*d)^3*(c + d*x)) - ((2*b*c + 3*a*d)*Log[x])/(a^3*c^4) + (b^4*(2*b*c - 5*a*d)*Log[a + b*x])/(a^3*(b*c - a*d)^4) + (d^3*(10*b^2*c^2 - 10*a*b*c*d + 3*a^2*d^2)*Log[c + d*x])/(c^4*(b*c - a*d)^4)", //
        90);
  }

  // {90}
  public void test1001() {
    check( //
        "Integrate[1/(x^3*(a + b*x)^2*(c + d*x)^3), x]", //
        "-1/(2*a^2*c^3*x^2) + (2*b*c + 3*a*d)/(a^3*c^4*x) + b^5/(a^3*(b*c - a*d)^3*(a + b*x)) + d^4/(2*c^3*(b*c - a*d)^2*(c + d*x)^2) + (d^4*(5*b*c - 3*a*d))/(c^4*(b*c - a*d)^3*(c + d*x)) + (3*(b^2*c^2 + 2*a*b*c*d + 2*a^2*d^2)*Log[x])/(a^4*c^5) - (3*b^5*(b*c - 2*a*d)*Log[a + b*x])/(a^4*(b*c - a*d)^4) - (3*d^4*(5*b^2*c^2 - 6*a*b*c*d + 2*a^2*d^2)*Log[c + d*x])/(c^5*(b*c - a*d)^4)", //
        90);
  }

  // {90}
  public void test1002() {
    check( //
        "Integrate[(x^3*(c + d*x)^3)/(a + b*x)^3, x]", //
        "((b*c - a*d)*(b^2*c^2 - 8*a*b*c*d + 10*a^2*d^2)*x)/b^6 + (3*d*(b*c - 2*a*d)*(b*c - a*d)*x^2)/(2*b^5) + (d^2*(b*c - a*d)*x^3)/b^4 + (d^3*x^4)/(4*b^3) + (a^3*(b*c - a*d)^3)/(2*b^7*(a + b*x)^2) - (3*a^2*(b*c - 2*a*d)*(b*c - a*d)^2)/(b^7*(a + b*x)) - (3*a*(b*c - a*d)*(b^2*c^2 - 5*a*b*c*d + 5*a^2*d^2)*Log[a + b*x])/b^7", //
        90);
  }

  // {90}
  public void test1003() {
    check( //
        "Integrate[(x^2*(c + d*x)^3)/(a + b*x)^3, x]", //
        "(3*d*(b*c - 2*a*d)*(b*c - a*d)*x)/b^5 + (3*d^2*(b*c - a*d)*x^2)/(2*b^4) + (d^3*x^3)/(3*b^3) - (a^2*(b*c - a*d)^3)/(2*b^6*(a + b*x)^2) + (a*(2*b*c - 5*a*d)*(b*c - a*d)^2)/(b^6*(a + b*x)) + ((b*c - a*d)*(b^2*c^2 - 8*a*b*c*d + 10*a^2*d^2)*Log[a + b*x])/b^6", //
        90);
  }

  // {78}
  public void test1004() {
    check( //
        "Integrate[(x*(c + d*x)^3)/(a + b*x)^3, x]", //
        "(3*d^2*(b*c - a*d)*x)/b^4 + (d^3*x^2)/(2*b^3) + (a*(b*c - a*d)^3)/(2*b^5*(a + b*x)^2) - ((b*c - 4*a*d)*(b*c - a*d)^2)/(b^5*(a + b*x)) + (3*d*(b*c - 2*a*d)*(b*c - a*d)*Log[a + b*x])/b^5", //
        78);
  }

  // {45}
  public void test1005() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*x)^3, x]", //
        "(d^3*x)/b^3 - (b*c - a*d)^3/(2*b^4*(a + b*x)^2) - (3*d*(b*c - a*d)^2)/(b^4*(a + b*x)) + (3*d^2*(b*c - a*d)*Log[a + b*x])/b^4", //
        45);
  }

  // {90}
  public void test1006() {
    check( //
        "Integrate[(c + d*x)^3/(x*(a + b*x)^3), x]", //
        "(b*c - a*d)^3/(2*a*b^3*(a + b*x)^2) + ((b*c - a*d)^2*(b*c + 2*a*d))/(a^2*b^3*(a + b*x)) + (c^3*Log[x])/a^3 - (c^3/a^3 - d^3/b^3)*Log[a + b*x]", //
        90);
  }

  // {90}
  public void test1007() {
    check( //
        "Integrate[(c + d*x)^3/(x^2*(a + b*x)^3), x]", //
        "-(c^3/(a^3*x)) - (b*c - a*d)^3/(2*a^2*b^2*(a + b*x)^2) - ((b*c - a*d)^2*(2*b*c + a*d))/(a^3*b^2*(a + b*x)) - (3*c^2*(b*c - a*d)*Log[x])/a^4 + (3*c^2*(b*c - a*d)*Log[a + b*x])/a^4", //
        90);
  }

  // {90}
  public void test1008() {
    check( //
        "Integrate[(c + d*x)^3/(x^3*(a + b*x)^3), x]", //
        "-c^3/(2*a^3*x^2) + (3*c^2*(b*c - a*d))/(a^4*x) + (b*c - a*d)^3/(2*a^3*b*(a + b*x)^2) + (3*c*(b*c - a*d)^2)/(a^4*(a + b*x)) + (3*c*(b*c - a*d)*(2*b*c - a*d)*Log[x])/a^5 - (3*c*(b*c - a*d)*(2*b*c - a*d)*Log[a + b*x])/a^5", //
        90);
  }

  // {90}
  public void test1009() {
    check( //
        "Integrate[(c + d*x)^3/(x^4*(a + b*x)^3), x]", //
        "-c^3/(3*a^3*x^3) + (3*c^2*(b*c - a*d))/(2*a^4*x^2) - (3*c*(b*c - a*d)*(2*b*c - a*d))/(a^5*x) - (b*c - a*d)^3/(2*a^4*(a + b*x)^2) - ((b*c - a*d)^2*(4*b*c - a*d))/(a^5*(a + b*x)) - ((b*c - a*d)*(10*b^2*c^2 - 8*a*b*c*d + a^2*d^2)*Log[x])/a^6 + ((b*c - a*d)*(10*b^2*c^2 - 8*a*b*c*d + a^2*d^2)*Log[a + b*x])/a^6", //
        90);
  }

  // {90}
  public void test1010() {
    check( //
        "Integrate[x^7/((a + b*x)^3*(c + d*x)^3), x]", //
        "(-3*(b*c + a*d)*x)/(b^4*d^4) + x^2/(2*b^3*d^3) + a^7/(2*b^5*(b*c - a*d)^3*(a + b*x)^2) - (a^6*(7*b*c - 4*a*d))/(b^5*(b*c - a*d)^4*(a + b*x)) - c^7/(2*d^5*(b*c - a*d)^3*(c + d*x)^2) + (c^6*(4*b*c - 7*a*d))/(d^5*(b*c - a*d)^4*(c + d*x)) - (3*a^5*(7*b^2*c^2 - 7*a*b*c*d + 2*a^2*d^2)*Log[a + b*x])/(b^5*(b*c - a*d)^5) + (3*c^5*(2*b^2*c^2 - 7*a*b*c*d + 7*a^2*d^2)*Log[c + d*x])/(d^5*(b*c - a*d)^5)", //
        90);
  }

  // {90}
  public void test1011() {
    check( //
        "Integrate[x^6/((a + b*x)^3*(c + d*x)^3), x]", //
        "x/(b^3*d^3) - a^6/(2*b^4*(b*c - a*d)^3*(a + b*x)^2) + (3*a^5*(2*b*c - a*d))/(b^4*(b*c - a*d)^4*(a + b*x)) + c^6/(2*d^4*(b*c - a*d)^3*(c + d*x)^2) - (3*c^5*(b*c - 2*a*d))/(d^4*(b*c - a*d)^4*(c + d*x)) + (3*a^4*(5*b^2*c^2 - 4*a*b*c*d + a^2*d^2)*Log[a + b*x])/(b^4*(b*c - a*d)^5) - (3*c^4*(b^2*c^2 - 4*a*b*c*d + 5*a^2*d^2)*Log[c + d*x])/(d^4*(b*c - a*d)^5)", //
        90);
  }

  // {90}
  public void test1012() {
    check( //
        "Integrate[x^5/((a + b*x)^3*(c + d*x)^3), x]", //
        "a^5/(2*b^3*(b*c - a*d)^3*(a + b*x)^2) - (a^4*(5*b*c - 2*a*d))/(b^3*(b*c - a*d)^4*(a + b*x)) - c^5/(2*d^3*(b*c - a*d)^3*(c + d*x)^2) + (c^4*(2*b*c - 5*a*d))/(d^3*(b*c - a*d)^4*(c + d*x)) - (a^3*(10*b^2*c^2 - 5*a*b*c*d + a^2*d^2)*Log[a + b*x])/(b^3*(b*c - a*d)^5) + (c^3*(b^2*c^2 - 5*a*b*c*d + 10*a^2*d^2)*Log[c + d*x])/(d^3*(b*c - a*d)^5)", //
        90);
  }

  // {90}
  public void test1013() {
    check( //
        "Integrate[x^4/((a + b*x)^3*(c + d*x)^3), x]", //
        "-a^4/(2*b^2*(b*c - a*d)^3*(a + b*x)^2) + (a^3*(4*b*c - a*d))/(b^2*(b*c - a*d)^4*(a + b*x)) + c^4/(2*d^2*(b*c - a*d)^3*(c + d*x)^2) - (c^3*(b*c - 4*a*d))/(d^2*(b*c - a*d)^4*(c + d*x)) + (6*a^2*c^2*Log[a + b*x])/(b*c - a*d)^5 - (6*a^2*c^2*Log[c + d*x])/(b*c - a*d)^5", //
        90);
  }

  // {90}
  public void test1014() {
    check( //
        "Integrate[x^3/((a + b*x)^3*(c + d*x)^3), x]", //
        "a^3/(2*b*(b*c - a*d)^3*(a + b*x)^2) - (3*a^2*c)/((b*c - a*d)^4*(a + b*x)) - c^3/(2*d*(b*c - a*d)^3*(c + d*x)^2) - (3*a*c^2)/((b*c - a*d)^4*(c + d*x)) - (3*a*c*(b*c + a*d)*Log[a + b*x])/(b*c - a*d)^5 + (3*a*c*(b*c + a*d)*Log[c + d*x])/(b*c - a*d)^5", //
        90);
  }

  // {90}
  public void test1015() {
    check( //
        "Integrate[x^2/((a + b*x)^3*(c + d*x)^3), x]", //
        "-a^2/(2*(b*c - a*d)^3*(a + b*x)^2) + (a*(2*b*c + a*d))/((b*c - a*d)^4*(a + b*x)) + c^2/(2*(b*c - a*d)^3*(c + d*x)^2) + (c*(b*c + 2*a*d))/((b*c - a*d)^4*(c + d*x)) + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*Log[a + b*x])/(b*c - a*d)^5 - ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*Log[c + d*x])/(b*c - a*d)^5", //
        90);
  }

  // {78}
  public void test1016() {
    check( //
        "Integrate[x/((a + b*x)^3*(c + d*x)^3), x]", //
        "(a*b)/(2*(b*c - a*d)^3*(a + b*x)^2) - (b*(b*c + 2*a*d))/((b*c - a*d)^4*(a + b*x)) - (c*d)/(2*(b*c - a*d)^3*(c + d*x)^2) - (d*(2*b*c + a*d))/((b*c - a*d)^4*(c + d*x)) - (3*b*d*(b*c + a*d)*Log[a + b*x])/(b*c - a*d)^5 + (3*b*d*(b*c + a*d)*Log[c + d*x])/(b*c - a*d)^5", //
        78);
  }

  // {46}
  public void test1017() {
    check( //
        "Integrate[1/((a + b*x)^3*(c + d*x)^3), x]", //
        "-b^2/(2*(b*c - a*d)^3*(a + b*x)^2) + (3*b^2*d)/((b*c - a*d)^4*(a + b*x)) + d^2/(2*(b*c - a*d)^3*(c + d*x)^2) + (3*b*d^2)/((b*c - a*d)^4*(c + d*x)) + (6*b^2*d^2*Log[a + b*x])/(b*c - a*d)^5 - (6*b^2*d^2*Log[c + d*x])/(b*c - a*d)^5", //
        46);
  }

  // {90}
  public void test1018() {
    check( //
        "Integrate[1/(x*(a + b*x)^3*(c + d*x)^3), x]", //
        "b^3/(2*a*(b*c - a*d)^3*(a + b*x)^2) + (b^3*(b*c - 4*a*d))/(a^2*(b*c - a*d)^4*(a + b*x)) - d^3/(2*c*(b*c - a*d)^3*(c + d*x)^2) - (d^3*(4*b*c - a*d))/(c^2*(b*c - a*d)^4*(c + d*x)) + Log[x]/(a^3*c^3) - (b^3*(b^2*c^2 - 5*a*b*c*d + 10*a^2*d^2)*Log[a + b*x])/(a^3*(b*c - a*d)^5) + (d^3*(10*b^2*c^2 - 5*a*b*c*d + a^2*d^2)*Log[c + d*x])/(c^3*(b*c - a*d)^5)", //
        90);
  }

  // {90}
  public void test1019() {
    check( //
        "Integrate[1/(x^2*(a + b*x)^3*(c + d*x)^3), x]", //
        "-(1/(a^3*c^3*x)) - b^4/(2*a^2*(b*c - a*d)^3*(a + b*x)^2) - (b^4*(2*b*c - 5*a*d))/(a^3*(b*c - a*d)^4*(a + b*x)) + d^4/(2*c^2*(b*c - a*d)^3*(c + d*x)^2) + (d^4*(5*b*c - 2*a*d))/(c^3*(b*c - a*d)^4*(c + d*x)) - (3*(b*c + a*d)*Log[x])/(a^4*c^4) + (3*b^4*(b^2*c^2 - 4*a*b*c*d + 5*a^2*d^2)*Log[a + b*x])/(a^4*(b*c - a*d)^5) - (3*d^4*(5*b^2*c^2 - 4*a*b*c*d + a^2*d^2)*Log[c + d*x])/(c^4*(b*c - a*d)^5)", //
        90);
  }

  // {77}
  public void test1020() {
    check( //
        "Integrate[x^(7/2)*(a + b*x)*(A + B*x), x]", //
        "(2*a*A*x^(9/2))/9 + (2*(A*b + a*B)*x^(11/2))/11 + (2*b*B*x^(13/2))/13", //
        77);
  }

  // {77}
  public void test1021() {
    check( //
        "Integrate[x^(5/2)*(a + b*x)*(A + B*x), x]", //
        "(2*a*A*x^(7/2))/7 + (2*(A*b + a*B)*x^(9/2))/9 + (2*b*B*x^(11/2))/11", //
        77);
  }

  // {77}
  public void test1022() {
    check( //
        "Integrate[x^(3/2)*(a + b*x)*(A + B*x), x]", //
        "(2*a*A*x^(5/2))/5 + (2*(A*b + a*B)*x^(7/2))/7 + (2*b*B*x^(9/2))/9", //
        77);
  }

  // {77}
  public void test1023() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x)*(A + B*x), x]", //
        "(2*a*A*x^(3/2))/3 + (2*(A*b + a*B)*x^(5/2))/5 + (2*b*B*x^(7/2))/7", //
        77);
  }

  // {77}
  public void test1024() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/Sqrt[x], x]", //
        "2*a*A*Sqrt[x] + (2*(A*b + a*B)*x^(3/2))/3 + (2*b*B*x^(5/2))/5", //
        77);
  }

  // {77}
  public void test1025() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x^(3/2), x]", //
        "(-2*a*A)/Sqrt[x] + 2*(A*b + a*B)*Sqrt[x] + (2*b*B*x^(3/2))/3", //
        77);
  }

  // {77}
  public void test1026() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x^(5/2), x]", //
        "(-2*a*A)/(3*x^(3/2)) - (2*(A*b + a*B))/Sqrt[x] + 2*b*B*Sqrt[x]", //
        77);
  }

  // {77}
  public void test1027() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/x^(7/2), x]", //
        "(-2*a*A)/(5*x^(5/2)) - (2*(A*b + a*B))/(3*x^(3/2)) - (2*b*B)/Sqrt[x]", //
        77);
  }

  // {77}
  public void test1028() {
    check( //
        "Integrate[x^(7/2)*(a + b*x)^2*(A + B*x), x]", //
        "(2*a^2*A*x^(9/2))/9 + (2*a*(2*A*b + a*B)*x^(11/2))/11 + (2*b*(A*b + 2*a*B)*x^(13/2))/13 + (2*b^2*B*x^(15/2))/15", //
        77);
  }

  // {77}
  public void test1029() {
    check( //
        "Integrate[x^(5/2)*(a + b*x)^2*(A + B*x), x]", //
        "(2*a^2*A*x^(7/2))/7 + (2*a*(2*A*b + a*B)*x^(9/2))/9 + (2*b*(A*b + 2*a*B)*x^(11/2))/11 + (2*b^2*B*x^(13/2))/13", //
        77);
  }

  // {77}
  public void test1030() {
    check( //
        "Integrate[x^(3/2)*(a + b*x)^2*(A + B*x), x]", //
        "(2*a^2*A*x^(5/2))/5 + (2*a*(2*A*b + a*B)*x^(7/2))/7 + (2*b*(A*b + 2*a*B)*x^(9/2))/9 + (2*b^2*B*x^(11/2))/11", //
        77);
  }

  // {77}
  public void test1031() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x)^2*(A + B*x), x]", //
        "(2*a^2*A*x^(3/2))/3 + (2*a*(2*A*b + a*B)*x^(5/2))/5 + (2*b*(A*b + 2*a*B)*x^(7/2))/7 + (2*b^2*B*x^(9/2))/9", //
        77);
  }

  // {77}
  public void test1032() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/Sqrt[x], x]", //
        "2*a^2*A*Sqrt[x] + (2*a*(2*A*b + a*B)*x^(3/2))/3 + (2*b*(A*b + 2*a*B)*x^(5/2))/5 + (2*b^2*B*x^(7/2))/7", //
        77);
  }

  // {77}
  public void test1033() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^(3/2), x]", //
        "(-2*a^2*A)/Sqrt[x] + 2*a*(2*A*b + a*B)*Sqrt[x] + (2*b*(A*b + 2*a*B)*x^(3/2))/3 + (2*b^2*B*x^(5/2))/5", //
        77);
  }

  // {77}
  public void test1034() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^(5/2), x]", //
        "(-2*a^2*A)/(3*x^(3/2)) - (2*a*(2*A*b + a*B))/Sqrt[x] + 2*b*(A*b + 2*a*B)*Sqrt[x] + (2*b^2*B*x^(3/2))/3", //
        77);
  }

  // {77}
  public void test1035() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/x^(7/2), x]", //
        "(-2*a^2*A)/(5*x^(5/2)) - (2*a*(2*A*b + a*B))/(3*x^(3/2)) - (2*b*(A*b + 2*a*B))/Sqrt[x] + 2*b^2*B*Sqrt[x]", //
        77);
  }

  // {77}
  public void test1036() {
    check( //
        "Integrate[x^(7/2)*(a + b*x)^3*(A + B*x), x]", //
        "(2*a^3*A*x^(9/2))/9 + (2*a^2*(3*A*b + a*B)*x^(11/2))/11 + (6*a*b*(A*b + a*B)*x^(13/2))/13 + (2*b^2*(A*b + 3*a*B)*x^(15/2))/15 + (2*b^3*B*x^(17/2))/17", //
        77);
  }

  // {77}
  public void test1037() {
    check( //
        "Integrate[x^(5/2)*(a + b*x)^3*(A + B*x), x]", //
        "(2*a^3*A*x^(7/2))/7 + (2*a^2*(3*A*b + a*B)*x^(9/2))/9 + (6*a*b*(A*b + a*B)*x^(11/2))/11 + (2*b^2*(A*b + 3*a*B)*x^(13/2))/13 + (2*b^3*B*x^(15/2))/15", //
        77);
  }

  // {77}
  public void test1038() {
    check( //
        "Integrate[x^(3/2)*(a + b*x)^3*(A + B*x), x]", //
        "(2*a^3*A*x^(5/2))/5 + (2*a^2*(3*A*b + a*B)*x^(7/2))/7 + (2*a*b*(A*b + a*B)*x^(9/2))/3 + (2*b^2*(A*b + 3*a*B)*x^(11/2))/11 + (2*b^3*B*x^(13/2))/13", //
        77);
  }

  // {77}
  public void test1039() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x)^3*(A + B*x), x]", //
        "(2*a^3*A*x^(3/2))/3 + (2*a^2*(3*A*b + a*B)*x^(5/2))/5 + (6*a*b*(A*b + a*B)*x^(7/2))/7 + (2*b^2*(A*b + 3*a*B)*x^(9/2))/9 + (2*b^3*B*x^(11/2))/11", //
        77);
  }

  // {77}
  public void test1040() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/Sqrt[x], x]", //
        "2*a^3*A*Sqrt[x] + (2*a^2*(3*A*b + a*B)*x^(3/2))/3 + (6*a*b*(A*b + a*B)*x^(5/2))/5 + (2*b^2*(A*b + 3*a*B)*x^(7/2))/7 + (2*b^3*B*x^(9/2))/9", //
        77);
  }

  // {77}
  public void test1041() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^(3/2), x]", //
        "(-2*a^3*A)/Sqrt[x] + 2*a^2*(3*A*b + a*B)*Sqrt[x] + 2*a*b*(A*b + a*B)*x^(3/2) + (2*b^2*(A*b + 3*a*B)*x^(5/2))/5 + (2*b^3*B*x^(7/2))/7", //
        77);
  }

  // {77}
  public void test1042() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^(5/2), x]", //
        "(-2*a^3*A)/(3*x^(3/2)) - (2*a^2*(3*A*b + a*B))/Sqrt[x] + 6*a*b*(A*b + a*B)*Sqrt[x] + (2*b^2*(A*b + 3*a*B)*x^(3/2))/3 + (2*b^3*B*x^(5/2))/5", //
        77);
  }

  // {77}
  public void test1043() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/x^(7/2), x]", //
        "(-2*a^3*A)/(5*x^(5/2)) - (2*a^2*(3*A*b + a*B))/(3*x^(3/2)) - (6*a*b*(A*b + a*B))/Sqrt[x] + 2*b^2*(A*b + 3*a*B)*Sqrt[x] + (2*b^3*B*x^(3/2))/3", //
        77);
  }

  // {77}
  public void test1044() {
    check( //
        "Integrate[x^m*(a + b*x)^4*(A + B*x), x]", //
        "(a^4*A*x^(1 + m))/(1 + m) + (a^3*(4*A*b + a*B)*x^(2 + m))/(2 + m) + (2*a^2*b*(3*A*b + 2*a*B)*x^(3 + m))/(3 + m) + (2*a*b^2*(2*A*b + 3*a*B)*x^(4 + m))/(4 + m) + (b^3*(A*b + 4*a*B)*x^(5 + m))/(5 + m) + (b^4*B*x^(6 + m))/(6 + m)", //
        77);
  }

  // {77}
  public void test1045() {
    check( //
        "Integrate[x^m*(a + b*x)^3*(A + B*x), x]", //
        "(a^3*A*x^(1 + m))/(1 + m) + (a^2*(3*A*b + a*B)*x^(2 + m))/(2 + m) + (3*a*b*(A*b + a*B)*x^(3 + m))/(3 + m) + (b^2*(A*b + 3*a*B)*x^(4 + m))/(4 + m) + (b^3*B*x^(5 + m))/(5 + m)", //
        77);
  }

  // {77}
  public void test1046() {
    check( //
        "Integrate[x^m*(a + b*x)^2*(A + B*x), x]", //
        "(a^2*A*x^(1 + m))/(1 + m) + (a*(2*A*b + a*B)*x^(2 + m))/(2 + m) + (b*(A*b + 2*a*B)*x^(3 + m))/(3 + m) + (b^2*B*x^(4 + m))/(4 + m)", //
        77);
  }

  // {77}
  public void test1047() {
    check( //
        "Integrate[x^m*(a + b*x)*(A + B*x), x]", //
        "(a*A*x^(1 + m))/(1 + m) + ((A*b + a*B)*x^(2 + m))/(2 + m) + (b*B*x^(3 + m))/(3 + m)", //
        77);
  }

  // {81, 66}
  public void test1048() {
    check( //
        "Integrate[(x^m*(A + B*x))/(a + b*x), x]", //
        "(B*x^(1 + m))/(b*(1 + m)) + ((A*b - a*B)*x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((b*x)/a)])/(a*b*(1 + m))", //
        81,
        66);
  }

  // {79, 66}
  public void test1049() {
    check( //
        "Integrate[(x^m*(A + B*x))/(a + b*x)^2, x]", //
        "((A*b - a*B)*x^(1 + m))/(a*b*(a + b*x)) - ((A*b*m - a*B*(1 + m))*x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((b*x)/a)])/(a^2*b*(1 + m))", //
        79,
        66);
  }

  // {79, 66}
  public void test1050() {
    check( //
        "Integrate[(x^m*(A + B*x))/(a + b*x)^3, x]", //
        "((A*b - a*B)*x^(1 + m))/(2*a*b*(a + b*x)^2) + ((A*b*(1 - m) + a*B*(1 + m))*x^(1 + m)*Hypergeometric2F1[2, 1 + m, 2 + m, -((b*x)/a)])/(2*a^3*b*(1 + m))", //
        79,
        66);
  }

  // {90}
  public void test1051() {
    check( //
        "Integrate[x^m*(a + b*x)^2*(c + d*x)^5, x]", //
        "(a^2*c^5*x^(1 + m))/(1 + m) + (a*c^4*(2*b*c + 5*a*d)*x^(2 + m))/(2 + m) + (c^3*(b^2*c^2 + 10*a*b*c*d + 10*a^2*d^2)*x^(3 + m))/(3 + m) + (5*c^2*d*(b^2*c^2 + 4*a*b*c*d + 2*a^2*d^2)*x^(4 + m))/(4 + m) + (5*c*d^2*(2*b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(5 + m))/(5 + m) + (d^3*(10*b^2*c^2 + 10*a*b*c*d + a^2*d^2)*x^(6 + m))/(6 + m) + (b*d^4*(5*b*c + 2*a*d)*x^(7 + m))/(7 + m) + (b^2*d^5*x^(8 + m))/(8 + m)", //
        90);
  }

  // {81, 66}
  public void test1052() {
    check( //
        "Integrate[(x^m*(c + d*x))/(a + b*x), x]", //
        "(d*x^(1 + m))/(b*(1 + m)) + ((b*c - a*d)*x^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((b*x)/a)])/(a*b*(1 + m))", //
        81,
        66);
  }

  // {90}
  public void test1053() {
    check( //
        "Integrate[(e*x)^m*(2 - 2*a*x)^3*(1 + a*x)^4, x]", //
        "(8*(e*x)^(1 + m))/(e*(1 + m)) + (8*a*(e*x)^(2 + m))/(e^2*(2 + m)) - (24*a^2*(e*x)^(3 + m))/(e^3*(3 + m)) - (24*a^3*(e*x)^(4 + m))/(e^4*(4 + m)) + (24*a^4*(e*x)^(5 + m))/(e^5*(5 + m)) + (24*a^5*(e*x)^(6 + m))/(e^6*(6 + m)) - (8*a^6*(e*x)^(7 + m))/(e^7*(7 + m)) - (8*a^7*(e*x)^(8 + m))/(e^8*(8 + m))", //
        90);
  }

  // {90}
  public void test1054() {
    check( //
        "Integrate[(e*x)^m*(2 - 2*a*x)^2*(1 + a*x)^3, x]", //
        "(4*(e*x)^(1 + m))/(e*(1 + m)) + (4*a*(e*x)^(2 + m))/(e^2*(2 + m)) - (8*a^2*(e*x)^(3 + m))/(e^3*(3 + m)) - (8*a^3*(e*x)^(4 + m))/(e^4*(4 + m)) + (4*a^4*(e*x)^(5 + m))/(e^5*(5 + m)) + (4*a^5*(e*x)^(6 + m))/(e^6*(6 + m))", //
        90);
  }

  // {76}
  public void test1055() {
    check( //
        "Integrate[(e*x)^m*(2 - 2*a*x)*(1 + a*x)^2, x]", //
        "(2*(e*x)^(1 + m))/(e*(1 + m)) + (2*a*(e*x)^(2 + m))/(e^2*(2 + m)) - (2*a^2*(e*x)^(3 + m))/(e^3*(3 + m)) - (2*a^3*(e*x)^(4 + m))/(e^4*(4 + m))", //
        76);
  }

  // {90}
  public void test1056() {
    check( //
        "Integrate[(e*x)^m*(a + b*x)^4*(a*d - b*d*x)^3, x]", //
        "(a^7*d^3*(e*x)^(1 + m))/(e*(1 + m)) + (a^6*b*d^3*(e*x)^(2 + m))/(e^2*(2 + m)) - (3*a^5*b^2*d^3*(e*x)^(3 + m))/(e^3*(3 + m)) - (3*a^4*b^3*d^3*(e*x)^(4 + m))/(e^4*(4 + m)) + (3*a^3*b^4*d^3*(e*x)^(5 + m))/(e^5*(5 + m)) + (3*a^2*b^5*d^3*(e*x)^(6 + m))/(e^6*(6 + m)) - (a*b^6*d^3*(e*x)^(7 + m))/(e^7*(7 + m)) - (b^7*d^3*(e*x)^(8 + m))/(e^8*(8 + m))", //
        90);
  }

  // {90}
  public void test1057() {
    check( //
        "Integrate[(e*x)^m*(a + b*x)^3*(a*d - b*d*x)^2, x]", //
        "(a^5*d^2*(e*x)^(1 + m))/(e*(1 + m)) + (a^4*b*d^2*(e*x)^(2 + m))/(e^2*(2 + m)) - (2*a^3*b^2*d^2*(e*x)^(3 + m))/(e^3*(3 + m)) - (2*a^2*b^3*d^2*(e*x)^(4 + m))/(e^4*(4 + m)) + (a*b^4*d^2*(e*x)^(5 + m))/(e^5*(5 + m)) + (b^5*d^2*(e*x)^(6 + m))/(e^6*(6 + m))", //
        90);
  }

  // {76}
  public void test1058() {
    check( //
        "Integrate[(e*x)^m*(a + b*x)^2*(a*d - b*d*x), x]", //
        "(a^3*d*(e*x)^(1 + m))/(e*(1 + m)) + (a^2*b*d*(e*x)^(2 + m))/(e^2*(2 + m)) - (a*b^2*d*(e*x)^(3 + m))/(e^3*(3 + m)) - (b^3*d*(e*x)^(4 + m))/(e^4*(4 + m))", //
        76);
  }

  // {76}
  public void test1059() {
    check( //
        "Integrate[(e*x)^m*(a + b*x)*(a*c - b*c*x)^4, x]", //
        "(a^5*c^4*(e*x)^(1 + m))/(e*(1 + m)) - (3*a^4*b*c^4*(e*x)^(2 + m))/(e^2*(2 + m)) + (2*a^3*b^2*c^4*(e*x)^(3 + m))/(e^3*(3 + m)) + (2*a^2*b^3*c^4*(e*x)^(4 + m))/(e^4*(4 + m)) - (3*a*b^4*c^4*(e*x)^(5 + m))/(e^5*(5 + m)) + (b^5*c^4*(e*x)^(6 + m))/(e^6*(6 + m))", //
        76);
  }

  // {76}
  public void test1060() {
    check( //
        "Integrate[(e*x)^m*(a + b*x)*(a*c - b*c*x)^3, x]", //
        "(a^4*c^3*(e*x)^(1 + m))/(e*(1 + m)) - (2*a^3*b*c^3*(e*x)^(2 + m))/(e^2*(2 + m)) + (2*a*b^3*c^3*(e*x)^(4 + m))/(e^4*(4 + m)) - (b^4*c^3*(e*x)^(5 + m))/(e^5*(5 + m))", //
        76);
  }

  // {76}
  public void test1061() {
    check( //
        "Integrate[(e*x)^m*(a + b*x)*(a*c - b*c*x)^2, x]", //
        "(a^3*c^2*(e*x)^(1 + m))/(e*(1 + m)) - (a^2*b*c^2*(e*x)^(2 + m))/(e^2*(2 + m)) - (a*b^2*c^2*(e*x)^(3 + m))/(e^3*(3 + m)) + (b^3*c^2*(e*x)^(4 + m))/(e^4*(4 + m))", //
        76);
  }

  // {81, 66}
  public void test1062() {
    check( //
        "Integrate[((e*x)^m*(a + b*x))/(a*c - b*c*x), x]", //
        "-((e*x)^(1 + m)/(c*e*(1 + m))) + (2*(e*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, (b*x)/a])/(c*e*(1 + m))", //
        81,
        66);
  }

  // {79, 66}
  public void test1063() {
    check( //
        "Integrate[((e*x)^m*(a + b*x))/(a*c - b*c*x)^2, x]", //
        "(2*(e*x)^(1 + m))/(c^2*e*(a - b*x)) - ((1 + 2*m)*(e*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, (b*x)/a])/(a*c^2*e*(1 + m))", //
        79,
        66);
  }

  // {12, 371}
  public void test1064() {
    check( //
        "Integrate[(b^2*x^m)/(b + a*x^2)^2, x]", //
        "(x^(1 + m)*Hypergeometric2F1[2, (1 + m)/2, (3 + m)/2, -((a*x^2)/b)])/(1 + m)", //
        12,
        371);
  }

  // {74, 371}
  public void test1065() {
    check( //
        "Integrate[x^m/((1 - (Sqrt[a]*x)/Sqrt[-b])^2*(1 + (Sqrt[a]*x)/Sqrt[-b])^2), x]", //
        "(x^(1 + m)*Hypergeometric2F1[2, (1 + m)/2, (3 + m)/2, -((a*x^2)/b)])/(1 + m)", //
        74,
        371);
  }

  // {78}
  public void test1066() {
    check( //
        "Integrate[x^4*Sqrt[a + b*x]*(A + B*x), x]", //
        "(2*a^4*(A*b - a*B)*(a + b*x)^(3/2))/(3*b^6) - (2*a^3*(4*A*b - 5*a*B)*(a + b*x)^(5/2))/(5*b^6) + (4*a^2*(3*A*b - 5*a*B)*(a + b*x)^(7/2))/(7*b^6) - (4*a*(2*A*b - 5*a*B)*(a + b*x)^(9/2))/(9*b^6) + (2*(A*b - 5*a*B)*(a + b*x)^(11/2))/(11*b^6) + (2*B*(a + b*x)^(13/2))/(13*b^6)", //
        78);
  }

  // {78}
  public void test1067() {
    check( //
        "Integrate[x^3*Sqrt[a + b*x]*(A + B*x), x]", //
        "(-2*a^3*(A*b - a*B)*(a + b*x)^(3/2))/(3*b^5) + (2*a^2*(3*A*b - 4*a*B)*(a + b*x)^(5/2))/(5*b^5) - (6*a*(A*b - 2*a*B)*(a + b*x)^(7/2))/(7*b^5) + (2*(A*b - 4*a*B)*(a + b*x)^(9/2))/(9*b^5) + (2*B*(a + b*x)^(11/2))/(11*b^5)", //
        78);
  }

  // {78}
  public void test1068() {
    check( //
        "Integrate[x^2*Sqrt[a + b*x]*(A + B*x), x]", //
        "(2*a^2*(A*b - a*B)*(a + b*x)^(3/2))/(3*b^4) - (2*a*(2*A*b - 3*a*B)*(a + b*x)^(5/2))/(5*b^4) + (2*(A*b - 3*a*B)*(a + b*x)^(7/2))/(7*b^4) + (2*B*(a + b*x)^(9/2))/(9*b^4)", //
        78);
  }

  // {78}
  public void test1069() {
    check( //
        "Integrate[x*Sqrt[a + b*x]*(A + B*x), x]", //
        "(-2*a*(A*b - a*B)*(a + b*x)^(3/2))/(3*b^3) + (2*(A*b - 2*a*B)*(a + b*x)^(5/2))/(5*b^3) + (2*B*(a + b*x)^(7/2))/(7*b^3)", //
        78);
  }

  // {45}
  public void test1070() {
    check( //
        "Integrate[Sqrt[a + b*x]*(A + B*x), x]", //
        "(2*(A*b - a*B)*(a + b*x)^(3/2))/(3*b^2) + (2*B*(a + b*x)^(5/2))/(5*b^2)", //
        45);
  }

  // {78}
  public void test1071() {
    check( //
        "Integrate[x^4*(a + b*x)^(3/2)*(A + B*x), x]", //
        "(2*a^4*(A*b - a*B)*(a + b*x)^(5/2))/(5*b^6) - (2*a^3*(4*A*b - 5*a*B)*(a + b*x)^(7/2))/(7*b^6) + (4*a^2*(3*A*b - 5*a*B)*(a + b*x)^(9/2))/(9*b^6) - (4*a*(2*A*b - 5*a*B)*(a + b*x)^(11/2))/(11*b^6) + (2*(A*b - 5*a*B)*(a + b*x)^(13/2))/(13*b^6) + (2*B*(a + b*x)^(15/2))/(15*b^6)", //
        78);
  }

  // {78}
  public void test1072() {
    check( //
        "Integrate[x^3*(a + b*x)^(3/2)*(A + B*x), x]", //
        "(-2*a^3*(A*b - a*B)*(a + b*x)^(5/2))/(5*b^5) + (2*a^2*(3*A*b - 4*a*B)*(a + b*x)^(7/2))/(7*b^5) - (2*a*(A*b - 2*a*B)*(a + b*x)^(9/2))/(3*b^5) + (2*(A*b - 4*a*B)*(a + b*x)^(11/2))/(11*b^5) + (2*B*(a + b*x)^(13/2))/(13*b^5)", //
        78);
  }

  // {78}
  public void test1073() {
    check( //
        "Integrate[x^2*(a + b*x)^(3/2)*(A + B*x), x]", //
        "(2*a^2*(A*b - a*B)*(a + b*x)^(5/2))/(5*b^4) - (2*a*(2*A*b - 3*a*B)*(a + b*x)^(7/2))/(7*b^4) + (2*(A*b - 3*a*B)*(a + b*x)^(9/2))/(9*b^4) + (2*B*(a + b*x)^(11/2))/(11*b^4)", //
        78);
  }

  // {78}
  public void test1074() {
    check( //
        "Integrate[x*(a + b*x)^(3/2)*(A + B*x), x]", //
        "(-2*a*(A*b - a*B)*(a + b*x)^(5/2))/(5*b^3) + (2*(A*b - 2*a*B)*(a + b*x)^(7/2))/(7*b^3) + (2*B*(a + b*x)^(9/2))/(9*b^3)", //
        78);
  }

  // {45}
  public void test1075() {
    check( //
        "Integrate[(a + b*x)^(3/2)*(A + B*x), x]", //
        "(2*(A*b - a*B)*(a + b*x)^(5/2))/(5*b^2) + (2*B*(a + b*x)^(7/2))/(7*b^2)", //
        45);
  }

  // {78}
  public void test1076() {
    check( //
        "Integrate[x^4*(a + b*x)^(5/2)*(A + B*x), x]", //
        "(2*a^4*(A*b - a*B)*(a + b*x)^(7/2))/(7*b^6) - (2*a^3*(4*A*b - 5*a*B)*(a + b*x)^(9/2))/(9*b^6) + (4*a^2*(3*A*b - 5*a*B)*(a + b*x)^(11/2))/(11*b^6) - (4*a*(2*A*b - 5*a*B)*(a + b*x)^(13/2))/(13*b^6) + (2*(A*b - 5*a*B)*(a + b*x)^(15/2))/(15*b^6) + (2*B*(a + b*x)^(17/2))/(17*b^6)", //
        78);
  }

  // {78}
  public void test1077() {
    check( //
        "Integrate[x^3*(a + b*x)^(5/2)*(A + B*x), x]", //
        "(-2*a^3*(A*b - a*B)*(a + b*x)^(7/2))/(7*b^5) + (2*a^2*(3*A*b - 4*a*B)*(a + b*x)^(9/2))/(9*b^5) - (6*a*(A*b - 2*a*B)*(a + b*x)^(11/2))/(11*b^5) + (2*(A*b - 4*a*B)*(a + b*x)^(13/2))/(13*b^5) + (2*B*(a + b*x)^(15/2))/(15*b^5)", //
        78);
  }

  // {78}
  public void test1078() {
    check( //
        "Integrate[x^2*(a + b*x)^(5/2)*(A + B*x), x]", //
        "(2*a^2*(A*b - a*B)*(a + b*x)^(7/2))/(7*b^4) - (2*a*(2*A*b - 3*a*B)*(a + b*x)^(9/2))/(9*b^4) + (2*(A*b - 3*a*B)*(a + b*x)^(11/2))/(11*b^4) + (2*B*(a + b*x)^(13/2))/(13*b^4)", //
        78);
  }

  // {78}
  public void test1079() {
    check( //
        "Integrate[x*(a + b*x)^(5/2)*(A + B*x), x]", //
        "(-2*a*(A*b - a*B)*(a + b*x)^(7/2))/(7*b^3) + (2*(A*b - 2*a*B)*(a + b*x)^(9/2))/(9*b^3) + (2*B*(a + b*x)^(11/2))/(11*b^3)", //
        78);
  }

  // {45}
  public void test1080() {
    check( //
        "Integrate[(a + b*x)^(5/2)*(A + B*x), x]", //
        "(2*(A*b - a*B)*(a + b*x)^(7/2))/(7*b^2) + (2*B*(a + b*x)^(9/2))/(9*b^2)", //
        45);
  }

  // {78}
  public void test1081() {
    check( //
        "Integrate[(x^4*(A + B*x))/Sqrt[a + b*x], x]", //
        "(2*a^4*(A*b - a*B)*Sqrt[a + b*x])/b^6 - (2*a^3*(4*A*b - 5*a*B)*(a + b*x)^(3/2))/(3*b^6) + (4*a^2*(3*A*b - 5*a*B)*(a + b*x)^(5/2))/(5*b^6) - (4*a*(2*A*b - 5*a*B)*(a + b*x)^(7/2))/(7*b^6) + (2*(A*b - 5*a*B)*(a + b*x)^(9/2))/(9*b^6) + (2*B*(a + b*x)^(11/2))/(11*b^6)", //
        78);
  }

  // {78}
  public void test1082() {
    check( //
        "Integrate[(x^3*(A + B*x))/Sqrt[a + b*x], x]", //
        "(-2*a^3*(A*b - a*B)*Sqrt[a + b*x])/b^5 + (2*a^2*(3*A*b - 4*a*B)*(a + b*x)^(3/2))/(3*b^5) - (6*a*(A*b - 2*a*B)*(a + b*x)^(5/2))/(5*b^5) + (2*(A*b - 4*a*B)*(a + b*x)^(7/2))/(7*b^5) + (2*B*(a + b*x)^(9/2))/(9*b^5)", //
        78);
  }

  // {78}
  public void test1083() {
    check( //
        "Integrate[(x^2*(A + B*x))/Sqrt[a + b*x], x]", //
        "(2*a^2*(A*b - a*B)*Sqrt[a + b*x])/b^4 - (2*a*(2*A*b - 3*a*B)*(a + b*x)^(3/2))/(3*b^4) + (2*(A*b - 3*a*B)*(a + b*x)^(5/2))/(5*b^4) + (2*B*(a + b*x)^(7/2))/(7*b^4)", //
        78);
  }

  // {78}
  public void test1084() {
    check( //
        "Integrate[(x*(A + B*x))/Sqrt[a + b*x], x]", //
        "(-2*a*(A*b - a*B)*Sqrt[a + b*x])/b^3 + (2*(A*b - 2*a*B)*(a + b*x)^(3/2))/(3*b^3) + (2*B*(a + b*x)^(5/2))/(5*b^3)", //
        78);
  }

  // {45}
  public void test1085() {
    check( //
        "Integrate[(A + B*x)/Sqrt[a + b*x], x]", //
        "(2*(A*b - a*B)*Sqrt[a + b*x])/b^2 + (2*B*(a + b*x)^(3/2))/(3*b^2)", //
        45);
  }

  // {78}
  public void test1086() {
    check( //
        "Integrate[(x^4*(A + B*x))/(a + b*x)^(3/2), x]", //
        "(-2*a^4*(A*b - a*B))/(b^6*Sqrt[a + b*x]) - (2*a^3*(4*A*b - 5*a*B)*Sqrt[a + b*x])/b^6 + (4*a^2*(3*A*b - 5*a*B)*(a + b*x)^(3/2))/(3*b^6) - (4*a*(2*A*b - 5*a*B)*(a + b*x)^(5/2))/(5*b^6) + (2*(A*b - 5*a*B)*(a + b*x)^(7/2))/(7*b^6) + (2*B*(a + b*x)^(9/2))/(9*b^6)", //
        78);
  }

  // {78}
  public void test1087() {
    check( //
        "Integrate[(x^3*(A + B*x))/(a + b*x)^(3/2), x]", //
        "(2*a^3*(A*b - a*B))/(b^5*Sqrt[a + b*x]) + (2*a^2*(3*A*b - 4*a*B)*Sqrt[a + b*x])/b^5 - (2*a*(A*b - 2*a*B)*(a + b*x)^(3/2))/b^5 + (2*(A*b - 4*a*B)*(a + b*x)^(5/2))/(5*b^5) + (2*B*(a + b*x)^(7/2))/(7*b^5)", //
        78);
  }

  // {78}
  public void test1088() {
    check( //
        "Integrate[(x^2*(A + B*x))/(a + b*x)^(3/2), x]", //
        "(-2*a^2*(A*b - a*B))/(b^4*Sqrt[a + b*x]) - (2*a*(2*A*b - 3*a*B)*Sqrt[a + b*x])/b^4 + (2*(A*b - 3*a*B)*(a + b*x)^(3/2))/(3*b^4) + (2*B*(a + b*x)^(5/2))/(5*b^4)", //
        78);
  }

  // {78}
  public void test1089() {
    check( //
        "Integrate[(x*(A + B*x))/(a + b*x)^(3/2), x]", //
        "(2*a*(A*b - a*B))/(b^3*Sqrt[a + b*x]) + (2*(A*b - 2*a*B)*Sqrt[a + b*x])/b^3 + (2*B*(a + b*x)^(3/2))/(3*b^3)", //
        78);
  }

  // {45}
  public void test1090() {
    check( //
        "Integrate[(A + B*x)/(a + b*x)^(3/2), x]", //
        "(-2*(A*b - a*B))/(b^2*Sqrt[a + b*x]) + (2*B*Sqrt[a + b*x])/b^2", //
        45);
  }

  // {78}
  public void test1091() {
    check( //
        "Integrate[(x^4*(A + B*x))/(a + b*x)^(5/2), x]", //
        "(-2*a^4*(A*b - a*B))/(3*b^6*(a + b*x)^(3/2)) + (2*a^3*(4*A*b - 5*a*B))/(b^6*Sqrt[a + b*x]) + (4*a^2*(3*A*b - 5*a*B)*Sqrt[a + b*x])/b^6 - (4*a*(2*A*b - 5*a*B)*(a + b*x)^(3/2))/(3*b^6) + (2*(A*b - 5*a*B)*(a + b*x)^(5/2))/(5*b^6) + (2*B*(a + b*x)^(7/2))/(7*b^6)", //
        78);
  }

  // {78}
  public void test1092() {
    check( //
        "Integrate[(x^3*(A + B*x))/(a + b*x)^(5/2), x]", //
        "(2*a^3*(A*b - a*B))/(3*b^5*(a + b*x)^(3/2)) - (2*a^2*(3*A*b - 4*a*B))/(b^5*Sqrt[a + b*x]) - (6*a*(A*b - 2*a*B)*Sqrt[a + b*x])/b^5 + (2*(A*b - 4*a*B)*(a + b*x)^(3/2))/(3*b^5) + (2*B*(a + b*x)^(5/2))/(5*b^5)", //
        78);
  }

  // {78}
  public void test1093() {
    check( //
        "Integrate[(x^2*(A + B*x))/(a + b*x)^(5/2), x]", //
        "(-2*a^2*(A*b - a*B))/(3*b^4*(a + b*x)^(3/2)) + (2*a*(2*A*b - 3*a*B))/(b^4*Sqrt[a + b*x]) + (2*(A*b - 3*a*B)*Sqrt[a + b*x])/b^4 + (2*B*(a + b*x)^(3/2))/(3*b^4)", //
        78);
  }

  // {78}
  public void test1094() {
    check( //
        "Integrate[(x*(A + B*x))/(a + b*x)^(5/2), x]", //
        "(2*a*(A*b - a*B))/(3*b^3*(a + b*x)^(3/2)) - (2*(A*b - 2*a*B))/(b^3*Sqrt[a + b*x]) + (2*B*Sqrt[a + b*x])/b^3", //
        78);
  }

  // {45}
  public void test1095() {
    check( //
        "Integrate[(A + B*x)/(a + b*x)^(5/2), x]", //
        "(-2*(A*b - a*B))/(3*b^2*(a + b*x)^(3/2)) - (2*B)/(b^2*Sqrt[a + b*x])", //
        45);
  }

  // {129, 497}
  public void test1096() {
    check( //
        "Integrate[1/(x^(1/3)*Sqrt[c + d*x]*(4*c + d*x)), x]", //
        "-(ArcTan[(Sqrt[3]*c^(1/6)*(c^(1/3) + 2^(1/3)*d^(1/3)*x^(1/3)))/Sqrt[c + d*x]]/(2^(2/3)*Sqrt[3]*c^(5/6)*d^(2/3))) + ArcTan[Sqrt[c + d*x]/(Sqrt[3]*Sqrt[c])]/(2^(2/3)*Sqrt[3]*c^(5/6)*d^(2/3)) - ArcTanh[(c^(1/6)*(c^(1/3) - 2^(1/3)*d^(1/3)*x^(1/3)))/Sqrt[c + d*x]]/(2^(2/3)*c^(5/6)*d^(2/3)) + ArcTanh[Sqrt[c + d*x]/Sqrt[c]]/(3*2^(2/3)*c^(5/6)*d^(2/3))", //
        129,
        497);
  }

  // {79, 37}
  public void test1097() {
    check( //
        "Integrate[(Sqrt[a + b*x]*(A + B*x))/x^(7/2), x]", //
        "(-2*A*(a + b*x)^(3/2))/(5*a*x^(5/2)) + (2*(2*A*b - 5*a*B)*(a + b*x)^(3/2))/(15*a^2*x^(3/2))", //
        79,
        37);
  }

  // {79, 37}
  public void test1098() {
    check( //
        "Integrate[((a + b*x)^(3/2)*(A + B*x))/x^(9/2), x]", //
        "(-2*A*(a + b*x)^(5/2))/(7*a*x^(7/2)) + (2*(2*A*b - 7*a*B)*(a + b*x)^(5/2))/(35*a^2*x^(5/2))", //
        79,
        37);
  }

  // {79, 37}
  public void test1099() {
    check( //
        "Integrate[((a + b*x)^(5/2)*(A + B*x))/x^(11/2), x]", //
        "(-2*A*(a + b*x)^(7/2))/(9*a*x^(9/2)) + (2*(2*A*b - 9*a*B)*(a + b*x)^(7/2))/(63*a^2*x^(7/2))", //
        79,
        37);
  }

  // {79, 37}
  public void test1100() {
    check( //
        "Integrate[(A + B*x)/(x^(5/2)*Sqrt[a + b*x]), x]", //
        "(-2*A*Sqrt[a + b*x])/(3*a*x^(3/2)) + (2*(2*A*b - 3*a*B)*Sqrt[a + b*x])/(3*a^2*Sqrt[x])", //
        79,
        37);
  }

  // {79, 37}
  public void test1101() {
    check( //
        "Integrate[(A + B*x)/(x^(3/2)*(a + b*x)^(3/2)), x]", //
        "(-2*A)/(a*Sqrt[x]*Sqrt[a + b*x]) - (2*(2*A*b - a*B)*Sqrt[x])/(a^2*Sqrt[a + b*x])", //
        79,
        37);
  }

  // {79, 37}
  public void test1102() {
    check( //
        "Integrate[(A + B*x)/(Sqrt[x]*(a + b*x)^(5/2)), x]", //
        "(2*(A*b - a*B)*Sqrt[x])/(3*a*b*(a + b*x)^(3/2)) + (2*(2*A*b + a*B)*Sqrt[x])/(3*a^2*b*Sqrt[a + b*x])", //
        79,
        37);
  }

  // {95, 214}
  public void test1103() {
    check( //
        "Integrate[1/(x*Sqrt[a + b*x]*Sqrt[c + d*x]), x]", //
        "(-2*ArcTanh[(Sqrt[c]*Sqrt[a + b*x])/(Sqrt[a]*Sqrt[c + d*x])])/(Sqrt[a]*Sqrt[c])", //
        95,
        214);
  }

  // {79, 37}
  public void test1104() {
    check( //
        "Integrate[x/(Sqrt[a + b*x]*(c + d*x)^(5/2)), x]", //
        "(-2*c*Sqrt[a + b*x])/(3*d*(b*c - a*d)*(c + d*x)^(3/2)) + (2*(b*c - 3*a*d)*Sqrt[a + b*x])/(3*d*(b*c - a*d)^2*Sqrt[c + d*x])", //
        79,
        37);
  }

  // {47, 37}
  public void test1105() {
    check( //
        "Integrate[1/(Sqrt[a + b*x]*(c + d*x)^(5/2)), x]", //
        "(2*Sqrt[a + b*x])/(3*(b*c - a*d)*(c + d*x)^(3/2)) + (4*b*Sqrt[a + b*x])/(3*(b*c - a*d)^2*Sqrt[c + d*x])", //
        47,
        37);
  }

  // {16, 37}
  public void test1106() {
    check( //
        "Integrate[1/(x*Sqrt[c*x]*Sqrt[a + b*x]), x]", //
        "(-2*Sqrt[a + b*x])/(a*Sqrt[c*x])", //
        16,
        37);
  }

  // {94, 214}
  public void test1107() {
    check( //
        "Integrate[1/(x*Sqrt[a + b*x]*Sqrt[a*c - b*c*x]), x]", //
        "-(ArcTanh[(Sqrt[a + b*x]*Sqrt[a*c - b*c*x])/(a*Sqrt[c])]/(a*Sqrt[c]))", //
        94,
        214);
  }

  // {95, 214}
  public void test1108() {
    check( //
        "Integrate[1/(x*Sqrt[1 - a - b*x]*Sqrt[1 + a + b*x]), x]", //
        "(-2*ArcTanh[(Sqrt[1 - a]*Sqrt[1 + a + b*x])/(Sqrt[1 + a]*Sqrt[1 - a - b*x])])/Sqrt[1 - a^2]", //
        95,
        214);
  }

  // {79, 37}
  public void test1109() {
    check( //
        "Integrate[x/((a + b*x)^(3/2)*(c + d*x)^(3/2)), x]", //
        "(-2*c)/(d*(b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x]) + (2*(b*c + a*d)*Sqrt[c + d*x])/(d*(b*c - a*d)^2*Sqrt[a + b*x])", //
        79,
        37);
  }

  // {47, 37}
  public void test1110() {
    check( //
        "Integrate[1/((a + b*x)^(3/2)*(c + d*x)^(3/2)), x]", //
        "-2/((b*c - a*d)*Sqrt[a + b*x]*Sqrt[c + d*x]) - (4*d*Sqrt[a + b*x])/((b*c - a*d)^2*Sqrt[c + d*x])", //
        47,
        37);
  }

  // {23, 30}
  public void test1111() {
    check( //
        "Integrate[(x^2*Sqrt[a + b*x])/Sqrt[-a - b*x], x]", //
        "(x^3*Sqrt[a + b*x])/(3*Sqrt[-a - b*x])", //
        23,
        30);
  }

  // {23, 30}
  public void test1112() {
    check( //
        "Integrate[(x*Sqrt[a + b*x])/Sqrt[-a - b*x], x]", //
        "(x^2*Sqrt[a + b*x])/(2*Sqrt[-a - b*x])", //
        23,
        30);
  }

  // {23, 8}
  public void test1113() {
    check( //
        "Integrate[Sqrt[a + b*x]/Sqrt[-a - b*x], x]", //
        "(x*Sqrt[a + b*x])/Sqrt[-a - b*x]", //
        23,
        8);
  }

  // {23, 29}
  public void test1114() {
    check( //
        "Integrate[Sqrt[a + b*x]/(x*Sqrt[-a - b*x]), x]", //
        "(Sqrt[a + b*x]*Log[x])/Sqrt[-a - b*x]", //
        23,
        29);
  }

  // {23, 30}
  public void test1115() {
    check( //
        "Integrate[Sqrt[a + b*x]/(x^2*Sqrt[-a - b*x]), x]", //
        "-(Sqrt[a + b*x]/(x*Sqrt[-a - b*x]))", //
        23,
        30);
  }

  // {23, 30}
  public void test1116() {
    check( //
        "Integrate[Sqrt[a + b*x]/(x^3*Sqrt[-a - b*x]), x]", //
        "-Sqrt[a + b*x]/(2*x^2*Sqrt[-a - b*x])", //
        23,
        30);
  }

  // {23, 30}
  public void test1117() {
    check( //
        "Integrate[Sqrt[a + b*x]/(x^m*Sqrt[-a - b*x]), x]", //
        "(x^(1 - m)*Sqrt[a + b*x])/((1 - m)*Sqrt[-a - b*x])", //
        23,
        30);
  }

  // {23, 30}
  public void test1118() {
    check( //
        "Integrate[(x^2*(a + b*x)^n)/(-a - b*x)^n, x]", //
        "(x^3*(a + b*x)^n)/(3*(-a - b*x)^n)", //
        23,
        30);
  }

  // {23, 30}
  public void test1119() {
    check( //
        "Integrate[(x*(a + b*x)^n)/(-a - b*x)^n, x]", //
        "(x^2*(a + b*x)^n)/(2*(-a - b*x)^n)", //
        23,
        30);
  }

  // {23, 8}
  public void test1120() {
    check( //
        "Integrate[(a + b*x)^n/(-a - b*x)^n, x]", //
        "(x*(a + b*x)^n)/(-a - b*x)^n", //
        23,
        8);
  }

  // {23, 29}
  public void test1121() {
    check( //
        "Integrate[(a + b*x)^n/(x*(-a - b*x)^n), x]", //
        "((a + b*x)^n*Log[x])/(-a - b*x)^n", //
        23,
        29);
  }

  // {23, 30}
  public void test1122() {
    check( //
        "Integrate[(a + b*x)^n/(x^2*(-a - b*x)^n), x]", //
        "-((a + b*x)^n/(x*(-a - b*x)^n))", //
        23,
        30);
  }

  // {23, 30}
  public void test1123() {
    check( //
        "Integrate[(a + b*x)^n/(x^3*(-a - b*x)^n), x]", //
        "-(a + b*x)^n/(2*x^2*(-a - b*x)^n)", //
        23,
        30);
  }

  // {23, 30}
  public void test1124() {
    check( //
        "Integrate[(a + b*x)^n/(x^m*(-a - b*x)^n), x]", //
        "(x^(1 - m)*(a + b*x)^n)/((1 - m)*(-a - b*x)^n)", //
        23,
        30);
  }

  // {92, 54}
  public void test1125() {
    check( //
        "Integrate[x^2/(Sqrt[-1 + x]*Sqrt[1 + x]), x]", //
        "(Sqrt[-1 + x]*x*Sqrt[1 + x])/2 + ArcCosh[x]/2", //
        92,
        54);
  }

  // {94, 209}
  public void test1126() {
    check( //
        "Integrate[1/(Sqrt[-1 + x]*x*Sqrt[1 + x]), x]", //
        "ArcTan[Sqrt[-1 + x]*Sqrt[1 + x]]", //
        94,
        209);
  }

  // {38, 54}
  public void test1127() {
    check( //
        "Integrate[Sqrt[-1 + x]*Sqrt[1 + x], x]", //
        "(Sqrt[-1 + x]*x*Sqrt[1 + x])/2 - ArcCosh[x]/2", //
        38,
        54);
  }

  // {99, 54}
  public void test1128() {
    check( //
        "Integrate[(Sqrt[-1 + x]*Sqrt[1 + x])/x^2, x]", //
        "-((Sqrt[-1 + x]*Sqrt[1 + x])/x) + ArcCosh[x]", //
        99,
        54);
  }

  // {56, 221}
  public void test1129() {
    check( //
        "Integrate[1/(Sqrt[1 + 2*x]*Sqrt[3 + 2*x]), x]", //
        "ArcSinh[Sqrt[1 + 2*x]/Sqrt[2]]", //
        56,
        221);
  }

  // {95, 209}
  public void test1130() {
    check( //
        "Integrate[1/(x*Sqrt[-2 + 3*x]*Sqrt[3 + 5*x]), x]", //
        "Sqrt[2/3]*ArcTan[(Sqrt[3/2]*Sqrt[-2 + 3*x])/Sqrt[3 + 5*x]]", //
        95,
        209);
  }

  // {65, 221}
  public void test1131() {
    check( //
        "Integrate[1/(Sqrt[-1 + a + b*x]*Sqrt[1 + a + b*x]), x]", //
        "(2*ArcSinh[Sqrt[-1 + a + b*x]/Sqrt[2]])/b", //
        65,
        221);
  }

  // {118, 117}
  public void test1132() {
    check( //
        "Integrate[1/(Sqrt[x]*Sqrt[a - b*x]*Sqrt[a + b*x]), x]", //
        "(2*Sqrt[a]*Sqrt[1 - (b*x)/a]*Sqrt[1 + (b*x)/a]*EllipticF[ArcSin[(Sqrt[b]*Sqrt[x])/Sqrt[a]], -1])/(Sqrt[b]*Sqrt[a - b*x]*Sqrt[a + b*x])", //
        118,
        117);
  }

  // {118, 117}
  public void test1133() {
    check( //
        "Integrate[1/(Sqrt[-x]*Sqrt[a - b*x]*Sqrt[a + b*x]), x]", //
        "(-2*Sqrt[a]*Sqrt[1 - (b*x)/a]*Sqrt[1 + (b*x)/a]*EllipticF[ArcSin[(Sqrt[b]*Sqrt[-x])/Sqrt[a]], -1])/(Sqrt[b]*Sqrt[a - b*x]*Sqrt[a + b*x])", //
        118,
        117);
  }

  // {118, 117}
  public void test1134() {
    check( //
        "Integrate[1/(Sqrt[e*x]*Sqrt[a - b*x]*Sqrt[a + b*x]), x]", //
        "(2*Sqrt[a]*Sqrt[1 - (b*x)/a]*Sqrt[1 + (b*x)/a]*EllipticF[ArcSin[(Sqrt[b]*Sqrt[e*x])/(Sqrt[a]*Sqrt[e])], -1])/(Sqrt[b]*Sqrt[e]*Sqrt[a - b*x]*Sqrt[a + b*x])", //
        118,
        117);
  }

  // {728, 116}
  public void test1135() {
    check( //
        "Integrate[1/(Sqrt[1 + x]*Sqrt[x - x^2]), x]", //
        "2*EllipticF[ArcSin[Sqrt[x]], -1]", //
        728,
        116);
  }

  // {728, 111}
  public void test1136() {
    check( //
        "Integrate[Sqrt[1 + x]/Sqrt[x - x^2], x]", //
        "2*EllipticE[ArcSin[Sqrt[x]], -1]", //
        728,
        111);
  }

  // {112, 111}
  public void test1137() {
    check( //
        "Integrate[Sqrt[1 - x]/(Sqrt[x]*Sqrt[1 + x]), x]", //
        "(-2*Sqrt[-x]*EllipticE[ArcSin[Sqrt[-x]], -1])/Sqrt[x]", //
        112,
        111);
  }

  // {118, 116}
  public void test1138() {
    check( //
        "Integrate[1/(Sqrt[2 - 3*x]*Sqrt[x]*Sqrt[d + e*x]), x]", //
        "(2*Sqrt[1 + (e*x)/d]*EllipticF[ArcSin[Sqrt[3/2]*Sqrt[x]], (-2*e)/(3*d)])/(Sqrt[3]*Sqrt[d + e*x])", //
        118,
        116);
  }

  // {113, 111}
  public void test1139() {
    check( //
        "Integrate[Sqrt[d + e*x]/(Sqrt[2 - 3*x]*Sqrt[x]), x]", //
        "(2*Sqrt[d + e*x]*EllipticE[ArcSin[Sqrt[3/2]*Sqrt[x]], (-2*e)/(3*d)])/(Sqrt[3]*Sqrt[1 + (e*x)/d])", //
        113,
        111);
  }

  // {78}
  public void test1140() {
    check( //
        "Integrate[x^2*(a + b*x)^n*(c + d*x), x]", //
        "(a^2*(b*c - a*d)*(a + b*x)^(1 + n))/(b^4*(1 + n)) - (a*(2*b*c - 3*a*d)*(a + b*x)^(2 + n))/(b^4*(2 + n)) + ((b*c - 3*a*d)*(a + b*x)^(3 + n))/(b^4*(3 + n)) + (d*(a + b*x)^(4 + n))/(b^4*(4 + n))", //
        78);
  }

  // {78}
  public void test1141() {
    check( //
        "Integrate[x*(a + b*x)^n*(c + d*x), x]", //
        "-((a*(b*c - a*d)*(a + b*x)^(1 + n))/(b^3*(1 + n))) + ((b*c - 2*a*d)*(a + b*x)^(2 + n))/(b^3*(2 + n)) + (d*(a + b*x)^(3 + n))/(b^3*(3 + n))", //
        78);
  }

  // {45}
  public void test1142() {
    check( //
        "Integrate[(a + b*x)^n*(c + d*x), x]", //
        "((b*c - a*d)*(a + b*x)^(1 + n))/(b^2*(1 + n)) + (d*(a + b*x)^(2 + n))/(b^2*(2 + n))", //
        45);
  }

  // {81, 67}
  public void test1143() {
    check( //
        "Integrate[((a + b*x)^n*(c + d*x))/x, x]", //
        "(d*(a + b*x)^(1 + n))/(b*(1 + n)) - (c*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + (b*x)/a])/(a*(1 + n))", //
        81,
        67);
  }

  // {79, 67}
  public void test1144() {
    check( //
        "Integrate[((a + b*x)^n*(c + d*x))/x^2, x]", //
        "-((c*(a + b*x)^(1 + n))/(a*x)) - ((a*d + b*c*n)*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + (b*x)/a])/(a^2*(1 + n))", //
        79,
        67);
  }

  // {90}
  public void test1145() {
    check( //
        "Integrate[x^2*(a + b*x)^n*(c + d*x)^2, x]", //
        "(a^2*(b*c - a*d)^2*(a + b*x)^(1 + n))/(b^5*(1 + n)) - (2*a*(b*c - 2*a*d)*(b*c - a*d)*(a + b*x)^(2 + n))/(b^5*(2 + n)) + ((b^2*c^2 - 6*a*b*c*d + 6*a^2*d^2)*(a + b*x)^(3 + n))/(b^5*(3 + n)) + (2*d*(b*c - 2*a*d)*(a + b*x)^(4 + n))/(b^5*(4 + n)) + (d^2*(a + b*x)^(5 + n))/(b^5*(5 + n))", //
        90);
  }

  // {78}
  public void test1146() {
    check( //
        "Integrate[x*(a + b*x)^n*(c + d*x)^2, x]", //
        "-((a*(b*c - a*d)^2*(a + b*x)^(1 + n))/(b^4*(1 + n))) + ((b*c - 3*a*d)*(b*c - a*d)*(a + b*x)^(2 + n))/(b^4*(2 + n)) + (d*(2*b*c - 3*a*d)*(a + b*x)^(3 + n))/(b^4*(3 + n)) + (d^2*(a + b*x)^(4 + n))/(b^4*(4 + n))", //
        78);
  }

  // {45}
  public void test1147() {
    check( //
        "Integrate[(a + b*x)^n*(c + d*x)^2, x]", //
        "((b*c - a*d)^2*(a + b*x)^(1 + n))/(b^3*(1 + n)) + (2*d*(b*c - a*d)*(a + b*x)^(2 + n))/(b^3*(2 + n)) + (d^2*(a + b*x)^(3 + n))/(b^3*(3 + n))", //
        45);
  }

  // {90}
  public void test1148() {
    check( //
        "Integrate[x^2*(a + b*x)^n*(c + d*x)^3, x]", //
        "(a^2*(b*c - a*d)^3*(a + b*x)^(1 + n))/(b^6*(1 + n)) - (a*(2*b*c - 5*a*d)*(b*c - a*d)^2*(a + b*x)^(2 + n))/(b^6*(2 + n)) + ((b*c - a*d)*(b^2*c^2 - 8*a*b*c*d + 10*a^2*d^2)*(a + b*x)^(3 + n))/(b^6*(3 + n)) + (d*(3*b^2*c^2 - 12*a*b*c*d + 10*a^2*d^2)*(a + b*x)^(4 + n))/(b^6*(4 + n)) + (d^2*(3*b*c - 5*a*d)*(a + b*x)^(5 + n))/(b^6*(5 + n)) + (d^3*(a + b*x)^(6 + n))/(b^6*(6 + n))", //
        90);
  }

  // {78}
  public void test1149() {
    check( //
        "Integrate[x*(a + b*x)^n*(c + d*x)^3, x]", //
        "-((a*(b*c - a*d)^3*(a + b*x)^(1 + n))/(b^5*(1 + n))) + ((b*c - 4*a*d)*(b*c - a*d)^2*(a + b*x)^(2 + n))/(b^5*(2 + n)) + (3*d*(b*c - 2*a*d)*(b*c - a*d)*(a + b*x)^(3 + n))/(b^5*(3 + n)) + (d^2*(3*b*c - 4*a*d)*(a + b*x)^(4 + n))/(b^5*(4 + n)) + (d^3*(a + b*x)^(5 + n))/(b^5*(5 + n))", //
        78);
  }

  // {45}
  public void test1150() {
    check( //
        "Integrate[(a + b*x)^n*(c + d*x)^3, x]", //
        "((b*c - a*d)^3*(a + b*x)^(1 + n))/(b^4*(1 + n)) + (3*d*(b*c - a*d)^2*(a + b*x)^(2 + n))/(b^4*(2 + n)) + (3*d^2*(b*c - a*d)*(a + b*x)^(3 + n))/(b^4*(3 + n)) + (d^3*(a + b*x)^(4 + n))/(b^4*(4 + n))", //
        45);
  }

  // {81, 70}
  public void test1151() {
    check( //
        "Integrate[(x*(a + b*x)^n)/(c + d*x), x]", //
        "(a + b*x)^(1 + n)/(b*d*(1 + n)) - (c*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, -((d*(a + b*x))/(b*c - a*d))])/(d*(b*c - a*d)*(1 + n))", //
        81,
        70);
  }

  // {79, 70}
  public void test1152() {
    check( //
        "Integrate[(x*(a + b*x)^n)/(c + d*x)^2, x]", //
        "-((c*(a + b*x)^(1 + n))/(d*(b*c - a*d)*(c + d*x))) - ((a*d - b*c*(1 + n))*(a + b*x)^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, -((d*(a + b*x))/(b*c - a*d))])/(d*(b*c - a*d)^2*(1 + n))", //
        79,
        70);
  }

  // {140, 138}
  public void test1153() {
    check( //
        "Integrate[((b*x)^m*(c + d*x)^n)/(e + f*x), x]", //
        "((b*x)^(1 + m)*(c + d*x)^n*AppellF1[1 + m, -n, 1, 2 + m, -((d*x)/c), -((f*x)/e)])/(b*e*(1 + m)*(1 + (d*x)/c)^n)", //
        140,
        138);
  }

  // {140, 138}
  public void test1154() {
    check( //
        "Integrate[((b*x)^m*(c + d*x)^n)/(e + f*x)^2, x]", //
        "((b*x)^(1 + m)*(c + d*x)^n*AppellF1[1 + m, -n, 2, 2 + m, -((d*x)/c), -((f*x)/e)])/(b*e^2*(1 + m)*(1 + (d*x)/c)^n)", //
        140,
        138);
  }

  // {142, 141}
  public void test1155() {
    check( //
        "Integrate[((a + b*x)^n*(c + d*x)^p)/x, x]", //
        "-(((a + b*x)^(1 + n)*(c + d*x)^p*AppellF1[1 + n, -p, 1, 2 + n, -((d*(a + b*x))/(b*c - a*d)), (a + b*x)/a])/(a*(1 + n)*((b*(c + d*x))/(b*c - a*d))^p))", //
        142,
        141);
  }

  // {142, 141}
  public void test1156() {
    check( //
        "Integrate[((a + b*x)^n*(c + d*x)^p)/x^2, x]", //
        "(b*(a + b*x)^(1 + n)*(c + d*x)^p*AppellF1[1 + n, -p, 2, 2 + n, -((d*(a + b*x))/(b*c - a*d)), (a + b*x)/a])/(a^2*(1 + n)*((b*(c + d*x))/(b*c - a*d))^p)", //
        142,
        141);
  }

  // {140, 138}
  public void test1157() {
    check( //
        "Integrate[(b*x)^m*(Pi + d*x)^n*(e + f*x)^p, x]", //
        "(Pi^n*(b*x)^(1 + m)*(e + f*x)^p*AppellF1[1 + m, -n, -p, 2 + m, -((d*x)/Pi), -((f*x)/e)])/(b*(1 + m)*(1 + (f*x)/e)^p)", //
        140,
        138);
  }

  // {140, 138}
  public void test1158() {
    check( //
        "Integrate[(b*x)^(5/2)*(Pi + d*x)^n*(e + f*x)^p, x]", //
        "(2*Pi^n*(b*x)^(7/2)*(e + f*x)^p*AppellF1[7/2, -n, -p, 9/2, -((d*x)/Pi), -((f*x)/e)])/(7*b*(1 + (f*x)/e)^p)", //
        140,
        138);
  }

  // {72, 71}
  public void test1159() {
    check( //
        "Integrate[(a + b*x)^n/(c + d*x)^n, x]", //
        "((a + b*x)^(1 + n)*((b*(c + d*x))/(b*c - a*d))^n*Hypergeometric2F1[n, 1 + n, 2 + n, -((d*(a + b*x))/(b*c - a*d))])/(b*(1 + n)*(c + d*x)^n)", //
        72,
        71);
  }

  // {98, 133}
  public void test1160() {
    check( //
        "Integrate[(a + b*x)^n/(x^3*(c + d*x)^n), x]", //
        "-((a + b*x)^(1 + n)*(c + d*x)^(1 - n))/(2*a*c*x^2) - ((b*c - a*d)*(a*d*(1 + n) + b*(c - c*n))*(a + b*x)^(1 + n)*(c + d*x)^(-1 - n)*Hypergeometric2F1[2, 1 + n, 2 + n, (c*(a + b*x))/(a*(c + d*x))])/(2*a^3*c*(1 + n))", //
        98,
        133);
  }

  // {81, 71}
  public void test1161() {
    check( //
        "Integrate[((1 - x)^n*x)/(1 + x)^n, x]", //
        "-((1 - x)^(1 + n)*(1 + x)^(1 - n))/2 + (n*(1 - x)^(1 + n)*Hypergeometric2F1[n, 1 + n, 2 + n, (1 - x)/2])/(2^n*(1 + n))", //
        81,
        71);
  }

  // {98, 133}
  public void test1162() {
    check( //
        "Integrate[(1 - x)^n/(x^3*(1 + x)^n), x]", //
        "-((1 - x)^(1 + n)*(1 + x)^(1 - n))/(2*x^2) + (2*n*(1 - x)^(1 + n)*(1 + x)^(-1 - n)*Hypergeometric2F1[2, 1 + n, 2 + n, (1 - x)/(1 + x)])/(1 + n)", //
        98,
        133);
  }

  // {126, 371}
  public void test1163() {
    check( //
        "Integrate[x^m*(1 - a*x)^n*(1 + a*x)^n, x]", //
        "(x^(1 + m)*Hypergeometric2F1[(1 + m)/2, -n, (3 + m)/2, a^2*x^2])/(1 + m)", //
        126,
        371);
  }

  // {126, 371}
  public void test1164() {
    check( //
        "Integrate[x^m*(1 - a*x)^n*(2 + 2*a*x)^n, x]", //
        "(2^n*x^(1 + m)*Hypergeometric2F1[(1 + m)/2, -n, (3 + m)/2, a^2*x^2])/(1 + m)", //
        126,
        371);
  }

  // {126, 371}
  public void test1165() {
    check( //
        "Integrate[x^m*(2 - a*x)^n*(2 + a*x)^n, x]", //
        "(4^n*x^(1 + m)*Hypergeometric2F1[(1 + m)/2, -n, (3 + m)/2, (a^2*x^2)/4])/(1 + m)", //
        126,
        371);
  }

  // {126, 371}
  public void test1166() {
    check( //
        "Integrate[x^m*(1 - (a*x)/2)^n*(2 + a*x)^n, x]", //
        "(2^n*x^(1 + m)*Hypergeometric2F1[(1 + m)/2, -n, (3 + m)/2, (a^2*x^2)/4])/(1 + m)", //
        126,
        371);
  }

  // {126, 371}
  public void test1167() {
    check( //
        "Integrate[x^m*(3 - 2*a*x)^n*(6 + 4*a*x)^n, x]", //
        "(18^n*x^(1 + m)*Hypergeometric2F1[(1 + m)/2, -n, (3 + m)/2, (4*a^2*x^2)/9])/(1 + m)", //
        126,
        371);
  }

  // {126, 371}
  public void test1168() {
    check( //
        "Integrate[(b*x)^(-2 - 2*m)*(1 - a*x)^m*(1 + a*x)^m, x]", //
        "-(((b*x)^(-1 - 2*m)*Hypergeometric2F1[(-1 - 2*m)/2, -m, (1 - 2*m)/2, a^2*x^2])/(b*(1 + 2*m)))", //
        126,
        371);
  }

  // {98, 133}
  public void test1169() {
    check( //
        "Integrate[(a + b*x)^(1 + n)/(x^4*(a - b*x)^n), x]", //
        "-((a - b*x)^(1 - n)*(a + b*x)^(2 + n))/(3*a^2*x^3) - (4*b^3*(1 + 2*n)*(a - b*x)^(1 - n)*(a + b*x)^(-1 + n)*Hypergeometric2F1[3, 1 - n, 2 - n, (a - b*x)/(a + b*x)])/(3*a^2*(1 - n))", //
        98,
        133);
  }

  // {78}
  public void test1170() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*(d + e*x)^4, x]", //
        "((b*d - a*e)*(B*d - A*e)*(d + e*x)^5)/(5*e^3) - ((2*b*B*d - A*b*e - a*B*e)*(d + e*x)^6)/(6*e^3) + (b*B*(d + e*x)^7)/(7*e^3)", //
        78);
  }

  // {78}
  public void test1171() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*(d + e*x)^3, x]", //
        "((b*d - a*e)*(B*d - A*e)*(d + e*x)^4)/(4*e^3) - ((2*b*B*d - A*b*e - a*B*e)*(d + e*x)^5)/(5*e^3) + (b*B*(d + e*x)^6)/(6*e^3)", //
        78);
  }

  // {78}
  public void test1172() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*(d + e*x)^2, x]", //
        "((b*d - a*e)*(B*d - A*e)*(d + e*x)^3)/(3*e^3) - ((2*b*B*d - A*b*e - a*B*e)*(d + e*x)^4)/(4*e^3) + (b*B*(d + e*x)^5)/(5*e^3)", //
        78);
  }

  // {78}
  public void test1173() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*(d + e*x), x]", //
        "a*A*d*x + ((A*b*d + a*B*d + a*A*e)*x^2)/2 + ((b*B*d + A*b*e + a*B*e)*x^3)/3 + (b*B*e*x^4)/4", //
        78);
  }

  // {45}
  public void test1174() {
    check( //
        "Integrate[(a + b*x)*(A + B*x), x]", //
        "a*A*x + ((A*b + a*B)*x^2)/2 + (b*B*x^3)/3", //
        45);
  }

  // {78}
  public void test1175() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x), x]", //
        "-((b*(B*d - A*e)*x)/e^2) + (B*(a + b*x)^2)/(2*b*e) + ((b*d - a*e)*(B*d - A*e)*Log[d + e*x])/e^3", //
        78);
  }

  // {78}
  public void test1176() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x)^2, x]", //
        "(b*B*x)/e^2 - ((b*d - a*e)*(B*d - A*e))/(e^3*(d + e*x)) - ((2*b*B*d - A*b*e - a*B*e)*Log[d + e*x])/e^3", //
        78);
  }

  // {78}
  public void test1177() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x)^3, x]", //
        "-((b*d - a*e)*(B*d - A*e))/(2*e^3*(d + e*x)^2) + (2*b*B*d - A*b*e - a*B*e)/(e^3*(d + e*x)) + (b*B*Log[d + e*x])/e^3", //
        78);
  }

  // {78}
  public void test1178() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x)^4, x]", //
        "-((b*d - a*e)*(B*d - A*e))/(3*e^3*(d + e*x)^3) + (2*b*B*d - A*b*e - a*B*e)/(2*e^3*(d + e*x)^2) - (b*B)/(e^3*(d + e*x))", //
        78);
  }

  // {78}
  public void test1179() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x)^5, x]", //
        "-((b*d - a*e)*(B*d - A*e))/(4*e^3*(d + e*x)^4) + (2*b*B*d - A*b*e - a*B*e)/(3*e^3*(d + e*x)^3) - (b*B)/(2*e^3*(d + e*x)^2)", //
        78);
  }

  // {78}
  public void test1180() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x)^6, x]", //
        "-((b*d - a*e)*(B*d - A*e))/(5*e^3*(d + e*x)^5) + (2*b*B*d - A*b*e - a*B*e)/(4*e^3*(d + e*x)^4) - (b*B)/(3*e^3*(d + e*x)^3)", //
        78);
  }

  // {78}
  public void test1181() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*(d + e*x)^4, x]", //
        "-((b*d - a*e)^2*(B*d - A*e)*(d + e*x)^5)/(5*e^4) + ((b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*(d + e*x)^6)/(6*e^4) - (b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^7)/(7*e^4) + (b^2*B*(d + e*x)^8)/(8*e^4)", //
        78);
  }

  // {78}
  public void test1182() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*(d + e*x)^3, x]", //
        "-((b*d - a*e)^2*(B*d - A*e)*(d + e*x)^4)/(4*e^4) + ((b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*(d + e*x)^5)/(5*e^4) - (b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^6)/(6*e^4) + (b^2*B*(d + e*x)^7)/(7*e^4)", //
        78);
  }

  // {78}
  public void test1183() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*(d + e*x)^2, x]", //
        "((A*b - a*B)*(b*d - a*e)^2*(a + b*x)^3)/(3*b^4) + ((b*d - a*e)*(b*B*d + 2*A*b*e - 3*a*B*e)*(a + b*x)^4)/(4*b^4) + (e*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^5)/(5*b^4) + (B*e^2*(a + b*x)^6)/(6*b^4)", //
        78);
  }

  // {78}
  public void test1184() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*(d + e*x), x]", //
        "((A*b - a*B)*(b*d - a*e)*(a + b*x)^3)/(3*b^3) + ((b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^4)/(4*b^3) + (B*e*(a + b*x)^5)/(5*b^3)", //
        78);
  }

  // {45}
  public void test1185() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x), x]", //
        "((A*b - a*B)*(a + b*x)^3)/(3*b^2) + (B*(a + b*x)^4)/(4*b^2)", //
        45);
  }

  // {78}
  public void test1186() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x), x]", //
        "(b*(b*d - a*e)*(B*d - A*e)*x)/e^3 - ((B*d - A*e)*(a + b*x)^2)/(2*e^2) + (B*(a + b*x)^3)/(3*b*e) - ((b*d - a*e)^2*(B*d - A*e)*Log[d + e*x])/e^4", //
        78);
  }

  // {78}
  public void test1187() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^2, x]", //
        "-((b*(2*b*B*d - A*b*e - 2*a*B*e)*x)/e^3) + (b^2*B*x^2)/(2*e^2) + ((b*d - a*e)^2*(B*d - A*e))/(e^4*(d + e*x)) + ((b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*Log[d + e*x])/e^4", //
        78);
  }

  // {78}
  public void test1188() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^3, x]", //
        "(b^2*B*x)/e^3 + ((b*d - a*e)^2*(B*d - A*e))/(2*e^4*(d + e*x)^2) - ((b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e))/(e^4*(d + e*x)) - (b*(3*b*B*d - A*b*e - 2*a*B*e)*Log[d + e*x])/e^4", //
        78);
  }

  // {79, 37}
  public void test1189() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^5, x]", //
        "-((B*d - A*e)*(a + b*x)^3)/(4*e*(b*d - a*e)*(d + e*x)^4) + ((3*b*B*d + A*b*e - 4*a*B*e)*(a + b*x)^3)/(12*e*(b*d - a*e)^2*(d + e*x)^3)", //
        79,
        37);
  }

  // {78}
  public void test1190() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^6, x]", //
        "((b*d - a*e)^2*(B*d - A*e))/(5*e^4*(d + e*x)^5) - ((b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e))/(4*e^4*(d + e*x)^4) + (b*(3*b*B*d - A*b*e - 2*a*B*e))/(3*e^4*(d + e*x)^3) - (b^2*B)/(2*e^4*(d + e*x)^2)", //
        78);
  }

  // {78}
  public void test1191() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^7, x]", //
        "((b*d - a*e)^2*(B*d - A*e))/(6*e^4*(d + e*x)^6) - ((b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e))/(5*e^4*(d + e*x)^5) + (b*(3*b*B*d - A*b*e - 2*a*B*e))/(4*e^4*(d + e*x)^4) - (b^2*B)/(3*e^4*(d + e*x)^3)", //
        78);
  }

  // {78}
  public void test1192() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^8, x]", //
        "((b*d - a*e)^2*(B*d - A*e))/(7*e^4*(d + e*x)^7) - ((b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e))/(6*e^4*(d + e*x)^6) + (b*(3*b*B*d - A*b*e - 2*a*B*e))/(5*e^4*(d + e*x)^5) - (b^2*B)/(4*e^4*(d + e*x)^4)", //
        78);
  }

  // {78}
  public void test1193() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x)^5, x]", //
        "((b*d - a*e)^3*(B*d - A*e)*(d + e*x)^6)/(6*e^5) - ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*(d + e*x)^7)/(7*e^5) + (3*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^8)/(8*e^5) - (b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^9)/(9*e^5) + (b^3*B*(d + e*x)^10)/(10*e^5)", //
        78);
  }

  // {78}
  public void test1194() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x)^4, x]", //
        "((b*d - a*e)^3*(B*d - A*e)*(d + e*x)^5)/(5*e^5) - ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*(d + e*x)^6)/(6*e^5) + (3*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^7)/(7*e^5) - (b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^8)/(8*e^5) + (b^3*B*(d + e*x)^9)/(9*e^5)", //
        78);
  }

  // {78}
  public void test1195() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x)^3, x]", //
        "((A*b - a*B)*(b*d - a*e)^3*(a + b*x)^4)/(4*b^5) + ((b*d - a*e)^2*(b*B*d + 3*A*b*e - 4*a*B*e)*(a + b*x)^5)/(5*b^5) + (e*(b*d - a*e)*(b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^6)/(2*b^5) + (e^2*(3*b*B*d + A*b*e - 4*a*B*e)*(a + b*x)^7)/(7*b^5) + (B*e^3*(a + b*x)^8)/(8*b^5)", //
        78);
  }

  // {78}
  public void test1196() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x)^2, x]", //
        "((A*b - a*B)*(b*d - a*e)^2*(a + b*x)^4)/(4*b^4) + ((b*d - a*e)*(b*B*d + 2*A*b*e - 3*a*B*e)*(a + b*x)^5)/(5*b^4) + (e*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^6)/(6*b^4) + (B*e^2*(a + b*x)^7)/(7*b^4)", //
        78);
  }

  // {78}
  public void test1197() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x), x]", //
        "((A*b - a*B)*(b*d - a*e)*(a + b*x)^4)/(4*b^3) + ((b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^5)/(5*b^3) + (B*e*(a + b*x)^6)/(6*b^3)", //
        78);
  }

  // {45}
  public void test1198() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x), x]", //
        "((A*b - a*B)*(a + b*x)^4)/(4*b^2) + (B*(a + b*x)^5)/(5*b^2)", //
        45);
  }

  // {78}
  public void test1199() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x), x]", //
        "-((b*(b*d - a*e)^2*(B*d - A*e)*x)/e^4) + ((b*d - a*e)*(B*d - A*e)*(a + b*x)^2)/(2*e^3) - ((B*d - A*e)*(a + b*x)^3)/(3*e^2) + (B*(a + b*x)^4)/(4*b*e) + ((b*d - a*e)^3*(B*d - A*e)*Log[d + e*x])/e^5", //
        78);
  }

  // {78}
  public void test1200() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^2, x]", //
        "(3*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*x)/e^4 - ((b*d - a*e)^3*(B*d - A*e))/(e^5*(d + e*x)) - (b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^2)/(2*e^5) + (b^3*B*(d + e*x)^3)/(3*e^5) - ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*Log[d + e*x])/e^5", //
        78);
  }

  // {78}
  public void test1201() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^3, x]", //
        "-((b^2*(3*b*B*d - A*b*e - 3*a*B*e)*x)/e^4) + (b^3*B*x^2)/(2*e^3) - ((b*d - a*e)^3*(B*d - A*e))/(2*e^5*(d + e*x)^2) + ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e))/(e^5*(d + e*x)) + (3*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*Log[d + e*x])/e^5", //
        78);
  }

  // {78}
  public void test1202() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^4, x]", //
        "(b^3*B*x)/e^4 - ((b*d - a*e)^3*(B*d - A*e))/(3*e^5*(d + e*x)^3) + ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e))/(2*e^5*(d + e*x)^2) - (3*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e))/(e^5*(d + e*x)) - (b^2*(4*b*B*d - A*b*e - 3*a*B*e)*Log[d + e*x])/e^5", //
        78);
  }

  // {79, 37}
  public void test1203() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^6, x]", //
        "-((B*d - A*e)*(a + b*x)^4)/(5*e*(b*d - a*e)*(d + e*x)^5) + ((4*b*B*d + A*b*e - 5*a*B*e)*(a + b*x)^4)/(20*e*(b*d - a*e)^2*(d + e*x)^4)", //
        79,
        37);
  }

  // {78}
  public void test1204() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^8, x]", //
        "-((b*d - a*e)^3*(B*d - A*e))/(7*e^5*(d + e*x)^7) + ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e))/(6*e^5*(d + e*x)^6) - (3*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e))/(5*e^5*(d + e*x)^5) + (b^2*(4*b*B*d - A*b*e - 3*a*B*e))/(4*e^5*(d + e*x)^4) - (b^3*B)/(3*e^5*(d + e*x)^3)", //
        78);
  }

  // {78}
  public void test1205() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^9, x]", //
        "-((b*d - a*e)^3*(B*d - A*e))/(8*e^5*(d + e*x)^8) + ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e))/(7*e^5*(d + e*x)^7) - (b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e))/(2*e^5*(d + e*x)^6) + (b^2*(4*b*B*d - A*b*e - 3*a*B*e))/(5*e^5*(d + e*x)^5) - (b^3*B)/(4*e^5*(d + e*x)^4)", //
        78);
  }

  // {78}
  public void test1206() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^10, x]", //
        "-((b*d - a*e)^3*(B*d - A*e))/(9*e^5*(d + e*x)^9) + ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e))/(8*e^5*(d + e*x)^8) - (3*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e))/(7*e^5*(d + e*x)^7) + (b^2*(4*b*B*d - A*b*e - 3*a*B*e))/(6*e^5*(d + e*x)^6) - (b^3*B)/(5*e^5*(d + e*x)^5)", //
        78);
  }

  // {78}
  public void test1207() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x)*(d + e*x)^8, x]", //
        "-((b*d - a*e)^6*(B*d - A*e)*(d + e*x)^9)/(9*e^8) + ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e)*(d + e*x)^10)/(10*e^8) - (3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e)*(d + e*x)^11)/(11*e^8) + (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e)*(d + e*x)^12)/(12*e^8) - (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e)*(d + e*x)^13)/(13*e^8) + (3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e)*(d + e*x)^14)/(14*e^8) - (b^5*(7*b*B*d - A*b*e - 6*a*B*e)*(d + e*x)^15)/(15*e^8) + (b^6*B*(d + e*x)^16)/(16*e^8)", //
        78);
  }

  // {78}
  public void test1208() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x)*(d + e*x)^7, x]", //
        "-((b*d - a*e)^6*(B*d - A*e)*(d + e*x)^8)/(8*e^8) + ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e)*(d + e*x)^9)/(9*e^8) - (3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e)*(d + e*x)^10)/(10*e^8) + (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e)*(d + e*x)^11)/(11*e^8) - (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e)*(d + e*x)^12)/(12*e^8) + (3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e)*(d + e*x)^13)/(13*e^8) - (b^5*(7*b*B*d - A*b*e - 6*a*B*e)*(d + e*x)^14)/(14*e^8) + (b^6*B*(d + e*x)^15)/(15*e^8)", //
        78);
  }

  // {78}
  public void test1209() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x)*(d + e*x)^6, x]", //
        "((A*b - a*B)*(b*d - a*e)^6*(a + b*x)^7)/(7*b^8) + ((b*d - a*e)^5*(b*B*d + 6*A*b*e - 7*a*B*e)*(a + b*x)^8)/(8*b^8) + (e*(b*d - a*e)^4*(2*b*B*d + 5*A*b*e - 7*a*B*e)*(a + b*x)^9)/(3*b^8) + (e^2*(b*d - a*e)^3*(3*b*B*d + 4*A*b*e - 7*a*B*e)*(a + b*x)^10)/(2*b^8) + (5*e^3*(b*d - a*e)^2*(4*b*B*d + 3*A*b*e - 7*a*B*e)*(a + b*x)^11)/(11*b^8) + (e^4*(b*d - a*e)*(5*b*B*d + 2*A*b*e - 7*a*B*e)*(a + b*x)^12)/(4*b^8) + (e^5*(6*b*B*d + A*b*e - 7*a*B*e)*(a + b*x)^13)/(13*b^8) + (B*e^6*(a + b*x)^14)/(14*b^8)", //
        78);
  }

  // {78}
  public void test1210() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x)*(d + e*x)^5, x]", //
        "((A*b - a*B)*(b*d - a*e)^5*(a + b*x)^7)/(7*b^7) + ((b*d - a*e)^4*(b*B*d + 5*A*b*e - 6*a*B*e)*(a + b*x)^8)/(8*b^7) + (5*e*(b*d - a*e)^3*(b*B*d + 2*A*b*e - 3*a*B*e)*(a + b*x)^9)/(9*b^7) + (e^2*(b*d - a*e)^2*(b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^10)/b^7 + (5*e^3*(b*d - a*e)*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^11)/(11*b^7) + (e^4*(5*b*B*d + A*b*e - 6*a*B*e)*(a + b*x)^12)/(12*b^7) + (B*e^5*(a + b*x)^13)/(13*b^7)", //
        78);
  }

  // {78}
  public void test1211() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x)*(d + e*x)^4, x]", //
        "((A*b - a*B)*(b*d - a*e)^4*(a + b*x)^7)/(7*b^6) + ((b*d - a*e)^3*(b*B*d + 4*A*b*e - 5*a*B*e)*(a + b*x)^8)/(8*b^6) + (2*e*(b*d - a*e)^2*(2*b*B*d + 3*A*b*e - 5*a*B*e)*(a + b*x)^9)/(9*b^6) + (e^2*(b*d - a*e)*(3*b*B*d + 2*A*b*e - 5*a*B*e)*(a + b*x)^10)/(5*b^6) + (e^3*(4*b*B*d + A*b*e - 5*a*B*e)*(a + b*x)^11)/(11*b^6) + (B*e^4*(a + b*x)^12)/(12*b^6)", //
        78);
  }

  // {78}
  public void test1212() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x)*(d + e*x)^3, x]", //
        "((A*b - a*B)*(b*d - a*e)^3*(a + b*x)^7)/(7*b^5) + ((b*d - a*e)^2*(b*B*d + 3*A*b*e - 4*a*B*e)*(a + b*x)^8)/(8*b^5) + (e*(b*d - a*e)*(b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^9)/(3*b^5) + (e^2*(3*b*B*d + A*b*e - 4*a*B*e)*(a + b*x)^10)/(10*b^5) + (B*e^3*(a + b*x)^11)/(11*b^5)", //
        78);
  }

  // {78}
  public void test1213() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x)*(d + e*x)^2, x]", //
        "((A*b - a*B)*(b*d - a*e)^2*(a + b*x)^7)/(7*b^4) + ((b*d - a*e)*(b*B*d + 2*A*b*e - 3*a*B*e)*(a + b*x)^8)/(8*b^4) + (e*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^9)/(9*b^4) + (B*e^2*(a + b*x)^10)/(10*b^4)", //
        78);
  }

  // {78}
  public void test1214() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x)*(d + e*x), x]", //
        "((A*b - a*B)*(b*d - a*e)*(a + b*x)^7)/(7*b^3) + ((b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^8)/(8*b^3) + (B*e*(a + b*x)^9)/(9*b^3)", //
        78);
  }

  // {45}
  public void test1215() {
    check( //
        "Integrate[(a + b*x)^6*(A + B*x), x]", //
        "((A*b - a*B)*(a + b*x)^7)/(7*b^2) + (B*(a + b*x)^8)/(8*b^2)", //
        45);
  }

  // {78}
  public void test1216() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x), x]", //
        "(b*(b*d - a*e)^5*(B*d - A*e)*x)/e^7 - ((b*d - a*e)^4*(B*d - A*e)*(a + b*x)^2)/(2*e^6) + ((b*d - a*e)^3*(B*d - A*e)*(a + b*x)^3)/(3*e^5) - ((b*d - a*e)^2*(B*d - A*e)*(a + b*x)^4)/(4*e^4) + ((b*d - a*e)*(B*d - A*e)*(a + b*x)^5)/(5*e^3) - ((B*d - A*e)*(a + b*x)^6)/(6*e^2) + (B*(a + b*x)^7)/(7*b*e) - ((b*d - a*e)^6*(B*d - A*e)*Log[d + e*x])/e^8", //
        78);
  }

  // {78}
  public void test1217() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^2, x]", //
        "(-3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e)*x)/e^7 + ((b*d - a*e)^6*(B*d - A*e))/(e^8*(d + e*x)) + (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e)*(d + e*x)^2)/(2*e^8) - (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e)*(d + e*x)^3)/(3*e^8) + (3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e)*(d + e*x)^4)/(4*e^8) - (b^5*(7*b*B*d - A*b*e - 6*a*B*e)*(d + e*x)^5)/(5*e^8) + (b^6*B*(d + e*x)^6)/(6*e^8) + ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e)*Log[d + e*x])/e^8", //
        78);
  }

  // {78}
  public void test1218() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^3, x]", //
        "(5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e)*x)/e^7 + ((b*d - a*e)^6*(B*d - A*e))/(2*e^8*(d + e*x)^2) - ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e))/(e^8*(d + e*x)) - (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e)*(d + e*x)^2)/(2*e^8) + (b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e)*(d + e*x)^3)/e^8 - (b^5*(7*b*B*d - A*b*e - 6*a*B*e)*(d + e*x)^4)/(4*e^8) + (b^6*B*(d + e*x)^5)/(5*e^8) - (3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e)*Log[d + e*x])/e^8", //
        78);
  }

  // {78}
  public void test1219() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^4, x]", //
        "(-5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e)*x)/e^7 + ((b*d - a*e)^6*(B*d - A*e))/(3*e^8*(d + e*x)^3) - ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e))/(2*e^8*(d + e*x)^2) + (3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e))/(e^8*(d + e*x)) + (3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e)*(d + e*x)^2)/(2*e^8) - (b^5*(7*b*B*d - A*b*e - 6*a*B*e)*(d + e*x)^3)/(3*e^8) + (b^6*B*(d + e*x)^4)/(4*e^8) + (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e)*Log[d + e*x])/e^8", //
        78);
  }

  // {78}
  public void test1220() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^5, x]", //
        "(3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e)*x)/e^7 + ((b*d - a*e)^6*(B*d - A*e))/(4*e^8*(d + e*x)^4) - ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e))/(3*e^8*(d + e*x)^3) + (3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e))/(2*e^8*(d + e*x)^2) - (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e))/(e^8*(d + e*x)) - (b^5*(7*b*B*d - A*b*e - 6*a*B*e)*(d + e*x)^2)/(2*e^8) + (b^6*B*(d + e*x)^3)/(3*e^8) - (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e)*Log[d + e*x])/e^8", //
        78);
  }

  // {78}
  public void test1221() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^6, x]", //
        "-((b^5*(6*b*B*d - A*b*e - 6*a*B*e)*x)/e^7) + (b^6*B*x^2)/(2*e^6) + ((b*d - a*e)^6*(B*d - A*e))/(5*e^8*(d + e*x)^5) - ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e))/(4*e^8*(d + e*x)^4) + (b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e))/(e^8*(d + e*x)^3) - (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e))/(2*e^8*(d + e*x)^2) + (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e))/(e^8*(d + e*x)) + (3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e)*Log[d + e*x])/e^8", //
        78);
  }

  // {78}
  public void test1222() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^7, x]", //
        "(b^6*B*x)/e^7 + ((b*d - a*e)^6*(B*d - A*e))/(6*e^8*(d + e*x)^6) - ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e))/(5*e^8*(d + e*x)^5) + (3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e))/(4*e^8*(d + e*x)^4) - (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e))/(3*e^8*(d + e*x)^3) + (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e))/(2*e^8*(d + e*x)^2) - (3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e))/(e^8*(d + e*x)) - (b^5*(7*b*B*d - A*b*e - 6*a*B*e)*Log[d + e*x])/e^8", //
        78);
  }

  // {79, 37}
  public void test1223() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^9, x]", //
        "-((B*d - A*e)*(a + b*x)^7)/(8*e*(b*d - a*e)*(d + e*x)^8) + ((7*b*B*d + A*b*e - 8*a*B*e)*(a + b*x)^7)/(56*e*(b*d - a*e)^2*(d + e*x)^7)", //
        79,
        37);
  }

  // {78}
  public void test1224() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^13, x]", //
        "((b*d - a*e)^6*(B*d - A*e))/(12*e^8*(d + e*x)^12) - ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e))/(11*e^8*(d + e*x)^11) + (3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e))/(10*e^8*(d + e*x)^10) - (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e))/(9*e^8*(d + e*x)^9) + (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e))/(8*e^8*(d + e*x)^8) - (3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e))/(7*e^8*(d + e*x)^7) + (b^5*(7*b*B*d - A*b*e - 6*a*B*e))/(6*e^8*(d + e*x)^6) - (b^6*B)/(5*e^8*(d + e*x)^5)", //
        78);
  }

  // {78}
  public void test1225() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^14, x]", //
        "((b*d - a*e)^6*(B*d - A*e))/(13*e^8*(d + e*x)^13) - ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e))/(12*e^8*(d + e*x)^12) + (3*b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e))/(11*e^8*(d + e*x)^11) - (b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e))/(2*e^8*(d + e*x)^10) + (5*b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e))/(9*e^8*(d + e*x)^9) - (3*b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e))/(8*e^8*(d + e*x)^8) + (b^5*(7*b*B*d - A*b*e - 6*a*B*e))/(7*e^8*(d + e*x)^7) - (b^6*B)/(6*e^8*(d + e*x)^6)", //
        78);
  }

  // {78}
  public void test1226() {
    check( //
        "Integrate[((a + b*x)^6*(A + B*x))/(d + e*x)^15, x]", //
        "((b*d - a*e)^6*(B*d - A*e))/(14*e^8*(d + e*x)^14) - ((b*d - a*e)^5*(7*b*B*d - 6*A*b*e - a*B*e))/(13*e^8*(d + e*x)^13) + (b*(b*d - a*e)^4*(7*b*B*d - 5*A*b*e - 2*a*B*e))/(4*e^8*(d + e*x)^12) - (5*b^2*(b*d - a*e)^3*(7*b*B*d - 4*A*b*e - 3*a*B*e))/(11*e^8*(d + e*x)^11) + (b^3*(b*d - a*e)^2*(7*b*B*d - 3*A*b*e - 4*a*B*e))/(2*e^8*(d + e*x)^10) - (b^4*(b*d - a*e)*(7*b*B*d - 2*A*b*e - 5*a*B*e))/(3*e^8*(d + e*x)^9) + (b^5*(7*b*B*d - A*b*e - 6*a*B*e))/(8*e^8*(d + e*x)^8) - (b^6*B)/(7*e^8*(d + e*x)^7)", //
        78);
  }

  // {78}
  public void test1227() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^13, x]", //
        "-((b*d - a*e)^10*(B*d - A*e)*(d + e*x)^14)/(14*e^12) + ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e)*(d + e*x)^15)/(15*e^12) - (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e)*(d + e*x)^16)/(16*e^12) + (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e)*(d + e*x)^17)/(17*e^12) - (5*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e)*(d + e*x)^18)/(3*e^12) + (42*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e)*(d + e*x)^19)/(19*e^12) - (21*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*(d + e*x)^20)/(10*e^12) + (10*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*(d + e*x)^21)/(7*e^12) - (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^22)/(22*e^12) + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^23)/(23*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^24)/(24*e^12) + (b^10*B*(d + e*x)^25)/(25*e^12)", //
        78);
  }

  // {78}
  public void test1228() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^12, x]", //
        "-((b*d - a*e)^10*(B*d - A*e)*(d + e*x)^13)/(13*e^12) + ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e)*(d + e*x)^14)/(14*e^12) - (b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e)*(d + e*x)^15)/(3*e^12) + (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e)*(d + e*x)^16)/(16*e^12) - (30*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e)*(d + e*x)^17)/(17*e^12) + (7*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e)*(d + e*x)^18)/(3*e^12) - (42*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*(d + e*x)^19)/(19*e^12) + (3*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*(d + e*x)^20)/(2*e^12) - (5*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^21)/(7*e^12) + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^22)/(22*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^23)/(23*e^12) + (b^10*B*(d + e*x)^24)/(24*e^12)", //
        78);
  }

  // {78}
  public void test1229() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^11, x]", //
        "-((b*d - a*e)^10*(B*d - A*e)*(d + e*x)^12)/(12*e^12) + ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e)*(d + e*x)^13)/(13*e^12) - (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e)*(d + e*x)^14)/(14*e^12) + (b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e)*(d + e*x)^15)/e^12 - (15*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e)*(d + e*x)^16)/(8*e^12) + (42*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e)*(d + e*x)^17)/(17*e^12) - (7*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*(d + e*x)^18)/(3*e^12) + (30*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*(d + e*x)^19)/(19*e^12) - (3*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^20)/(4*e^12) + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^21)/(21*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^22)/(22*e^12) + (b^10*B*(d + e*x)^23)/(23*e^12)", //
        78);
  }

  // {78}
  public void test1230() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^10, x]", //
        "((A*b - a*B)*(b*d - a*e)^10*(a + b*x)^11)/(11*b^12) + ((b*d - a*e)^9*(b*B*d + 10*A*b*e - 11*a*B*e)*(a + b*x)^12)/(12*b^12) + (5*e*(b*d - a*e)^8*(2*b*B*d + 9*A*b*e - 11*a*B*e)*(a + b*x)^13)/(13*b^12) + (15*e^2*(b*d - a*e)^7*(3*b*B*d + 8*A*b*e - 11*a*B*e)*(a + b*x)^14)/(14*b^12) + (2*e^3*(b*d - a*e)^6*(4*b*B*d + 7*A*b*e - 11*a*B*e)*(a + b*x)^15)/b^12 + (21*e^4*(b*d - a*e)^5*(5*b*B*d + 6*A*b*e - 11*a*B*e)*(a + b*x)^16)/(8*b^12) + (42*e^5*(b*d - a*e)^4*(6*b*B*d + 5*A*b*e - 11*a*B*e)*(a + b*x)^17)/(17*b^12) + (5*e^6*(b*d - a*e)^3*(7*b*B*d + 4*A*b*e - 11*a*B*e)*(a + b*x)^18)/(3*b^12) + (15*e^7*(b*d - a*e)^2*(8*b*B*d + 3*A*b*e - 11*a*B*e)*(a + b*x)^19)/(19*b^12) + (e^8*(b*d - a*e)*(9*b*B*d + 2*A*b*e - 11*a*B*e)*(a + b*x)^20)/(4*b^12) + (e^9*(10*b*B*d + A*b*e - 11*a*B*e)*(a + b*x)^21)/(21*b^12) + (B*e^10*(a + b*x)^22)/(22*b^12)", //
        78);
  }

  // {78}
  public void test1231() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^9, x]", //
        "((A*b - a*B)*(b*d - a*e)^9*(a + b*x)^11)/(11*b^11) + ((b*d - a*e)^8*(b*B*d + 9*A*b*e - 10*a*B*e)*(a + b*x)^12)/(12*b^11) + (9*e*(b*d - a*e)^7*(b*B*d + 4*A*b*e - 5*a*B*e)*(a + b*x)^13)/(13*b^11) + (6*e^2*(b*d - a*e)^6*(3*b*B*d + 7*A*b*e - 10*a*B*e)*(a + b*x)^14)/(7*b^11) + (14*e^3*(b*d - a*e)^5*(2*b*B*d + 3*A*b*e - 5*a*B*e)*(a + b*x)^15)/(5*b^11) + (63*e^4*(b*d - a*e)^4*(b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^16)/(8*b^11) + (42*e^5*(b*d - a*e)^3*(3*b*B*d + 2*A*b*e - 5*a*B*e)*(a + b*x)^17)/(17*b^11) + (2*e^6*(b*d - a*e)^2*(7*b*B*d + 3*A*b*e - 10*a*B*e)*(a + b*x)^18)/(3*b^11) + (9*e^7*(b*d - a*e)*(4*b*B*d + A*b*e - 5*a*B*e)*(a + b*x)^19)/(19*b^11) + (e^8*(9*b*B*d + A*b*e - 10*a*B*e)*(a + b*x)^20)/(20*b^11) + (B*e^9*(a + b*x)^21)/(21*b^11)", //
        78);
  }

  // {78}
  public void test1232() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^8, x]", //
        "((A*b - a*B)*(b*d - a*e)^8*(a + b*x)^11)/(11*b^10) + ((b*d - a*e)^7*(b*B*d + 8*A*b*e - 9*a*B*e)*(a + b*x)^12)/(12*b^10) + (4*e*(b*d - a*e)^6*(2*b*B*d + 7*A*b*e - 9*a*B*e)*(a + b*x)^13)/(13*b^10) + (2*e^2*(b*d - a*e)^5*(b*B*d + 2*A*b*e - 3*a*B*e)*(a + b*x)^14)/b^10 + (14*e^3*(b*d - a*e)^4*(4*b*B*d + 5*A*b*e - 9*a*B*e)*(a + b*x)^15)/(15*b^10) + (7*e^4*(b*d - a*e)^3*(5*b*B*d + 4*A*b*e - 9*a*B*e)*(a + b*x)^16)/(8*b^10) + (28*e^5*(b*d - a*e)^2*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^17)/(17*b^10) + (2*e^6*(b*d - a*e)*(7*b*B*d + 2*A*b*e - 9*a*B*e)*(a + b*x)^18)/(9*b^10) + (e^7*(8*b*B*d + A*b*e - 9*a*B*e)*(a + b*x)^19)/(19*b^10) + (B*e^8*(a + b*x)^20)/(20*b^10)", //
        78);
  }

  // {78}
  public void test1233() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^7, x]", //
        "((A*b - a*B)*(b*d - a*e)^7*(a + b*x)^11)/(11*b^9) + ((b*d - a*e)^6*(b*B*d + 7*A*b*e - 8*a*B*e)*(a + b*x)^12)/(12*b^9) + (7*e*(b*d - a*e)^5*(b*B*d + 3*A*b*e - 4*a*B*e)*(a + b*x)^13)/(13*b^9) + (e^2*(b*d - a*e)^4*(3*b*B*d + 5*A*b*e - 8*a*B*e)*(a + b*x)^14)/(2*b^9) + (7*e^3*(b*d - a*e)^3*(b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^15)/(3*b^9) + (7*e^4*(b*d - a*e)^2*(5*b*B*d + 3*A*b*e - 8*a*B*e)*(a + b*x)^16)/(16*b^9) + (7*e^5*(b*d - a*e)*(3*b*B*d + A*b*e - 4*a*B*e)*(a + b*x)^17)/(17*b^9) + (e^6*(7*b*B*d + A*b*e - 8*a*B*e)*(a + b*x)^18)/(18*b^9) + (B*e^7*(a + b*x)^19)/(19*b^9)", //
        78);
  }

  // {78}
  public void test1234() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^6, x]", //
        "((A*b - a*B)*(b*d - a*e)^6*(a + b*x)^11)/(11*b^8) + ((b*d - a*e)^5*(b*B*d + 6*A*b*e - 7*a*B*e)*(a + b*x)^12)/(12*b^8) + (3*e*(b*d - a*e)^4*(2*b*B*d + 5*A*b*e - 7*a*B*e)*(a + b*x)^13)/(13*b^8) + (5*e^2*(b*d - a*e)^3*(3*b*B*d + 4*A*b*e - 7*a*B*e)*(a + b*x)^14)/(14*b^8) + (e^3*(b*d - a*e)^2*(4*b*B*d + 3*A*b*e - 7*a*B*e)*(a + b*x)^15)/(3*b^8) + (3*e^4*(b*d - a*e)*(5*b*B*d + 2*A*b*e - 7*a*B*e)*(a + b*x)^16)/(16*b^8) + (e^5*(6*b*B*d + A*b*e - 7*a*B*e)*(a + b*x)^17)/(17*b^8) + (B*e^6*(a + b*x)^18)/(18*b^8)", //
        78);
  }

  // {78}
  public void test1235() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^5, x]", //
        "((A*b - a*B)*(b*d - a*e)^5*(a + b*x)^11)/(11*b^7) + ((b*d - a*e)^4*(b*B*d + 5*A*b*e - 6*a*B*e)*(a + b*x)^12)/(12*b^7) + (5*e*(b*d - a*e)^3*(b*B*d + 2*A*b*e - 3*a*B*e)*(a + b*x)^13)/(13*b^7) + (5*e^2*(b*d - a*e)^2*(b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^14)/(7*b^7) + (e^3*(b*d - a*e)*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^15)/(3*b^7) + (e^4*(5*b*B*d + A*b*e - 6*a*B*e)*(a + b*x)^16)/(16*b^7) + (B*e^5*(a + b*x)^17)/(17*b^7)", //
        78);
  }

  // {78}
  public void test1236() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^4, x]", //
        "((A*b - a*B)*(b*d - a*e)^4*(a + b*x)^11)/(11*b^6) + ((b*d - a*e)^3*(b*B*d + 4*A*b*e - 5*a*B*e)*(a + b*x)^12)/(12*b^6) + (2*e*(b*d - a*e)^2*(2*b*B*d + 3*A*b*e - 5*a*B*e)*(a + b*x)^13)/(13*b^6) + (e^2*(b*d - a*e)*(3*b*B*d + 2*A*b*e - 5*a*B*e)*(a + b*x)^14)/(7*b^6) + (e^3*(4*b*B*d + A*b*e - 5*a*B*e)*(a + b*x)^15)/(15*b^6) + (B*e^4*(a + b*x)^16)/(16*b^6)", //
        78);
  }

  // {78}
  public void test1237() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^3, x]", //
        "((A*b - a*B)*(b*d - a*e)^3*(a + b*x)^11)/(11*b^5) + ((b*d - a*e)^2*(b*B*d + 3*A*b*e - 4*a*B*e)*(a + b*x)^12)/(12*b^5) + (3*e*(b*d - a*e)*(b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^13)/(13*b^5) + (e^2*(3*b*B*d + A*b*e - 4*a*B*e)*(a + b*x)^14)/(14*b^5) + (B*e^3*(a + b*x)^15)/(15*b^5)", //
        78);
  }

  // {78}
  public void test1238() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x)^2, x]", //
        "((A*b - a*B)*(b*d - a*e)^2*(a + b*x)^11)/(11*b^4) + ((b*d - a*e)*(b*B*d + 2*A*b*e - 3*a*B*e)*(a + b*x)^12)/(12*b^4) + (e*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^13)/(13*b^4) + (B*e^2*(a + b*x)^14)/(14*b^4)", //
        78);
  }

  // {78}
  public void test1239() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x)*(d + e*x), x]", //
        "((A*b - a*B)*(b*d - a*e)*(a + b*x)^11)/(11*b^3) + ((b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^12)/(12*b^3) + (B*e*(a + b*x)^13)/(13*b^3)", //
        78);
  }

  // {45}
  public void test1240() {
    check( //
        "Integrate[(a + b*x)^10*(A + B*x), x]", //
        "((A*b - a*B)*(a + b*x)^11)/(11*b^2) + (B*(a + b*x)^12)/(12*b^2)", //
        45);
  }

  // {78}
  public void test1241() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x), x]", //
        "(b*(b*d - a*e)^9*(B*d - A*e)*x)/e^11 - ((b*d - a*e)^8*(B*d - A*e)*(a + b*x)^2)/(2*e^10) + ((b*d - a*e)^7*(B*d - A*e)*(a + b*x)^3)/(3*e^9) - ((b*d - a*e)^6*(B*d - A*e)*(a + b*x)^4)/(4*e^8) + ((b*d - a*e)^5*(B*d - A*e)*(a + b*x)^5)/(5*e^7) - ((b*d - a*e)^4*(B*d - A*e)*(a + b*x)^6)/(6*e^6) + ((b*d - a*e)^3*(B*d - A*e)*(a + b*x)^7)/(7*e^5) - ((b*d - a*e)^2*(B*d - A*e)*(a + b*x)^8)/(8*e^4) + ((b*d - a*e)*(B*d - A*e)*(a + b*x)^9)/(9*e^3) - ((B*d - A*e)*(a + b*x)^10)/(10*e^2) + (B*(a + b*x)^11)/(11*b*e) - ((b*d - a*e)^10*(B*d - A*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1242() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^2, x]", //
        "(-5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e)*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(e^12*(d + e*x)) + (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e)*(d + e*x)^2)/(2*e^12) - (10*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e)*(d + e*x)^3)/e^12 + (21*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e)*(d + e*x)^4)/(2*e^12) - (42*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*(d + e*x)^5)/(5*e^12) + (5*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*(d + e*x)^6)/e^12 - (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^7)/(7*e^12) + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^8)/(8*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^9)/(9*e^12) + (b^10*B*(d + e*x)^10)/(10*e^12) + ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1243() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^3, x]", //
        "(15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e)*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(2*e^12*(d + e*x)^2) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(e^12*(d + e*x)) - (15*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e)*(d + e*x)^2)/e^12 + (14*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e)*(d + e*x)^3)/e^12 - (21*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*(d + e*x)^4)/(2*e^12) + (6*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*(d + e*x)^5)/e^12 - (5*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^6)/(2*e^12) + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^7)/(7*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^8)/(8*e^12) + (b^10*B*(d + e*x)^9)/(9*e^12) - (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1244() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^4, x]", //
        "(-30*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e)*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(3*e^12*(d + e*x)^3) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(2*e^12*(d + e*x)^2) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(e^12*(d + e*x)) + (21*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e)*(d + e*x)^2)/e^12 - (14*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*(d + e*x)^3)/e^12 + (15*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*(d + e*x)^4)/(2*e^12) - (3*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^5)/e^12 + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^6)/(6*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^7)/(7*e^12) + (b^10*B*(d + e*x)^8)/(8*e^12) + (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1245() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^5, x]", //
        "(42*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e)*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(4*e^12*(d + e*x)^4) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(3*e^12*(d + e*x)^3) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(2*e^12*(d + e*x)^2) - (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(e^12*(d + e*x)) - (21*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*(d + e*x)^2)/e^12 + (10*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*(d + e*x)^3)/e^12 - (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^4)/(4*e^12) + (b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^5)/e^12 - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^6)/(6*e^12) + (b^10*B*(d + e*x)^7)/(7*e^12) - (30*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1246() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^6, x]", //
        "(-42*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(5*e^12*(d + e*x)^5) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(4*e^12*(d + e*x)^4) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(3*e^12*(d + e*x)^3) - (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(2*e^12*(d + e*x)^2) + (30*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(e^12*(d + e*x)) + (15*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*(d + e*x)^2)/e^12 - (5*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^3)/e^12 + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^4)/(4*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^5)/(5*e^12) + (b^10*B*(d + e*x)^6)/(6*e^12) + (42*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1247() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^7, x]", //
        "(30*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(6*e^12*(d + e*x)^6) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(5*e^12*(d + e*x)^5) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(4*e^12*(d + e*x)^4) - (5*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(e^12*(d + e*x)^3) + (15*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(e^12*(d + e*x)^2) - (42*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e))/(e^12*(d + e*x)) - (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*(d + e*x)^2)/(2*e^12) + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^3)/(3*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^4)/(4*e^12) + (b^10*B*(d + e*x)^5)/(5*e^12) - (42*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1248() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^8, x]", //
        "(-15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(7*e^12*(d + e*x)^7) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(6*e^12*(d + e*x)^6) + (b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(e^12*(d + e*x)^5) - (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(4*e^12*(d + e*x)^4) + (10*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(e^12*(d + e*x)^3) - (21*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e))/(e^12*(d + e*x)^2) + (42*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e))/(e^12*(d + e*x)) + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*(d + e*x)^2)/(2*e^12) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^3)/(3*e^12) + (b^10*B*(d + e*x)^4)/(4*e^12) + (30*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1249() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^9, x]", //
        "(5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(8*e^12*(d + e*x)^8) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(7*e^12*(d + e*x)^7) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(6*e^12*(d + e*x)^6) - (3*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(e^12*(d + e*x)^5) + (15*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(2*e^12*(d + e*x)^4) - (14*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e))/(e^12*(d + e*x)^3) + (21*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e))/(e^12*(d + e*x)^2) - (30*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e))/(e^12*(d + e*x)) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*(d + e*x)^2)/(2*e^12) + (b^10*B*(d + e*x)^3)/(3*e^12) - (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1250() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^10, x]", //
        "-((b^9*(10*b*B*d - A*b*e - 10*a*B*e)*x)/e^11) + (b^10*B*x^2)/(2*e^10) + ((b*d - a*e)^10*(B*d - A*e))/(9*e^12*(d + e*x)^9) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(8*e^12*(d + e*x)^8) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(7*e^12*(d + e*x)^7) - (5*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(2*e^12*(d + e*x)^6) + (6*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(e^12*(d + e*x)^5) - (21*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e))/(2*e^12*(d + e*x)^4) + (14*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e))/(e^12*(d + e*x)^3) - (15*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e))/(e^12*(d + e*x)^2) + (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e))/(e^12*(d + e*x)) + (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {78}
  public void test1251() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^11, x]", //
        "(b^10*B*x)/e^11 + ((b*d - a*e)^10*(B*d - A*e))/(10*e^12*(d + e*x)^10) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(9*e^12*(d + e*x)^9) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(8*e^12*(d + e*x)^8) - (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(7*e^12*(d + e*x)^7) + (5*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(e^12*(d + e*x)^6) - (42*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e))/(5*e^12*(d + e*x)^5) + (21*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e))/(2*e^12*(d + e*x)^4) - (10*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e))/(e^12*(d + e*x)^3) + (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e))/(2*e^12*(d + e*x)^2) - (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e))/(e^12*(d + e*x)) - (b^9*(11*b*B*d - A*b*e - 10*a*B*e)*Log[d + e*x])/e^12", //
        78);
  }

  // {79, 37}
  public void test1252() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^13, x]", //
        "-((B*d - A*e)*(a + b*x)^11)/(12*e*(b*d - a*e)*(d + e*x)^12) + ((11*b*B*d + A*b*e - 12*a*B*e)*(a + b*x)^11)/(132*e*(b*d - a*e)^2*(d + e*x)^11)", //
        79,
        37);
  }

  // {78}
  public void test1253() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^20, x]", //
        "((b*d - a*e)^10*(B*d - A*e))/(19*e^12*(d + e*x)^19) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(18*e^12*(d + e*x)^18) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(17*e^12*(d + e*x)^17) - (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(16*e^12*(d + e*x)^16) + (2*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(e^12*(d + e*x)^15) - (3*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e))/(e^12*(d + e*x)^14) + (42*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e))/(13*e^12*(d + e*x)^13) - (5*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e))/(2*e^12*(d + e*x)^12) + (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e))/(11*e^12*(d + e*x)^11) - (b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e))/(2*e^12*(d + e*x)^10) + (b^9*(11*b*B*d - A*b*e - 10*a*B*e))/(9*e^12*(d + e*x)^9) - (b^10*B)/(8*e^12*(d + e*x)^8)", //
        78);
  }

  // {78}
  public void test1254() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^21, x]", //
        "((b*d - a*e)^10*(B*d - A*e))/(20*e^12*(d + e*x)^20) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(19*e^12*(d + e*x)^19) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(18*e^12*(d + e*x)^18) - (15*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(17*e^12*(d + e*x)^17) + (15*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(8*e^12*(d + e*x)^16) - (14*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e))/(5*e^12*(d + e*x)^15) + (3*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e))/(e^12*(d + e*x)^14) - (30*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e))/(13*e^12*(d + e*x)^13) + (5*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e))/(4*e^12*(d + e*x)^12) - (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e))/(11*e^12*(d + e*x)^11) + (b^9*(11*b*B*d - A*b*e - 10*a*B*e))/(10*e^12*(d + e*x)^10) - (b^10*B)/(9*e^12*(d + e*x)^9)", //
        78);
  }

  // {78}
  public void test1255() {
    check( //
        "Integrate[((a + b*x)^10*(A + B*x))/(d + e*x)^22, x]", //
        "((b*d - a*e)^10*(B*d - A*e))/(21*e^12*(d + e*x)^21) - ((b*d - a*e)^9*(11*b*B*d - 10*A*b*e - a*B*e))/(20*e^12*(d + e*x)^20) + (5*b*(b*d - a*e)^8*(11*b*B*d - 9*A*b*e - 2*a*B*e))/(19*e^12*(d + e*x)^19) - (5*b^2*(b*d - a*e)^7*(11*b*B*d - 8*A*b*e - 3*a*B*e))/(6*e^12*(d + e*x)^18) + (30*b^3*(b*d - a*e)^6*(11*b*B*d - 7*A*b*e - 4*a*B*e))/(17*e^12*(d + e*x)^17) - (21*b^4*(b*d - a*e)^5*(11*b*B*d - 6*A*b*e - 5*a*B*e))/(8*e^12*(d + e*x)^16) + (14*b^5*(b*d - a*e)^4*(11*b*B*d - 5*A*b*e - 6*a*B*e))/(5*e^12*(d + e*x)^15) - (15*b^6*(b*d - a*e)^3*(11*b*B*d - 4*A*b*e - 7*a*B*e))/(7*e^12*(d + e*x)^14) + (15*b^7*(b*d - a*e)^2*(11*b*B*d - 3*A*b*e - 8*a*B*e))/(13*e^12*(d + e*x)^13) - (5*b^8*(b*d - a*e)*(11*b*B*d - 2*A*b*e - 9*a*B*e))/(12*e^12*(d + e*x)^12) + (b^9*(11*b*B*d - A*b*e - 10*a*B*e))/(11*e^12*(d + e*x)^11) - (b^10*B)/(10*e^12*(d + e*x)^10)", //
        78);
  }

  // {78}
  public void test1256() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^5)/(a + b*x), x]", //
        "((A*b - a*B)*e*(b*d - a*e)^4*x)/b^6 + ((A*b - a*B)*(b*d - a*e)^3*(d + e*x)^2)/(2*b^5) + ((A*b - a*B)*(b*d - a*e)^2*(d + e*x)^3)/(3*b^4) + ((A*b - a*B)*(b*d - a*e)*(d + e*x)^4)/(4*b^3) + ((A*b - a*B)*(d + e*x)^5)/(5*b^2) + (B*(d + e*x)^6)/(6*b*e) + ((A*b - a*B)*(b*d - a*e)^5*Log[a + b*x])/b^7", //
        78);
  }

  // {78}
  public void test1257() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^4)/(a + b*x), x]", //
        "((A*b - a*B)*e*(b*d - a*e)^3*x)/b^5 + ((A*b - a*B)*(b*d - a*e)^2*(d + e*x)^2)/(2*b^4) + ((A*b - a*B)*(b*d - a*e)*(d + e*x)^3)/(3*b^3) + ((A*b - a*B)*(d + e*x)^4)/(4*b^2) + (B*(d + e*x)^5)/(5*b*e) + ((A*b - a*B)*(b*d - a*e)^4*Log[a + b*x])/b^6", //
        78);
  }

  // {78}
  public void test1258() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^3)/(a + b*x), x]", //
        "((A*b - a*B)*e*(b*d - a*e)^2*x)/b^4 + ((A*b - a*B)*(b*d - a*e)*(d + e*x)^2)/(2*b^3) + ((A*b - a*B)*(d + e*x)^3)/(3*b^2) + (B*(d + e*x)^4)/(4*b*e) + ((A*b - a*B)*(b*d - a*e)^3*Log[a + b*x])/b^5", //
        78);
  }

  // {78}
  public void test1259() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^2)/(a + b*x), x]", //
        "((A*b - a*B)*e*(b*d - a*e)*x)/b^3 + ((A*b - a*B)*(d + e*x)^2)/(2*b^2) + (B*(d + e*x)^3)/(3*b*e) + ((A*b - a*B)*(b*d - a*e)^2*Log[a + b*x])/b^4", //
        78);
  }

  // {78}
  public void test1260() {
    check( //
        "Integrate[((A + B*x)*(d + e*x))/(a + b*x), x]", //
        "(B*(b*d - a*e)*x)/b^2 + (e*(A + B*x)^2)/(2*b*B) + ((A*b - a*B)*(b*d - a*e)*Log[a + b*x])/b^3", //
        78);
  }

  // {45}
  public void test1261() {
    check( //
        "Integrate[(A + B*x)/(a + b*x), x]", //
        "(B*x)/b + ((A*b - a*B)*Log[a + b*x])/b^2", //
        45);
  }

  // {78}
  public void test1262() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)*(d + e*x)), x]", //
        "((A*b - a*B)*Log[a + b*x])/(b*(b*d - a*e)) + ((B*d - A*e)*Log[d + e*x])/(e*(b*d - a*e))", //
        78);
  }

  // {78}
  public void test1263() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)*(d + e*x)^2), x]", //
        "-((B*d - A*e)/(e*(b*d - a*e)*(d + e*x))) + ((A*b - a*B)*Log[a + b*x])/(b*d - a*e)^2 - ((A*b - a*B)*Log[d + e*x])/(b*d - a*e)^2", //
        78);
  }

  // {78}
  public void test1264() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)*(d + e*x)^3), x]", //
        "-(B*d - A*e)/(2*e*(b*d - a*e)*(d + e*x)^2) + (A*b - a*B)/((b*d - a*e)^2*(d + e*x)) + (b*(A*b - a*B)*Log[a + b*x])/(b*d - a*e)^3 - (b*(A*b - a*B)*Log[d + e*x])/(b*d - a*e)^3", //
        78);
  }

  // {78}
  public void test1265() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)*(d + e*x)^4), x]", //
        "-(B*d - A*e)/(3*e*(b*d - a*e)*(d + e*x)^3) + (A*b - a*B)/(2*(b*d - a*e)^2*(d + e*x)^2) + (b*(A*b - a*B))/((b*d - a*e)^3*(d + e*x)) + (b^2*(A*b - a*B)*Log[a + b*x])/(b*d - a*e)^4 - (b^2*(A*b - a*B)*Log[d + e*x])/(b*d - a*e)^4", //
        78);
  }

  // {78}
  public void test1266() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)*(d + e*x)^5), x]", //
        "-(B*d - A*e)/(4*e*(b*d - a*e)*(d + e*x)^4) + (A*b - a*B)/(3*(b*d - a*e)^2*(d + e*x)^3) + (b*(A*b - a*B))/(2*(b*d - a*e)^3*(d + e*x)^2) + (b^2*(A*b - a*B))/((b*d - a*e)^4*(d + e*x)) + (b^3*(A*b - a*B)*Log[a + b*x])/(b*d - a*e)^5 - (b^3*(A*b - a*B)*Log[d + e*x])/(b*d - a*e)^5", //
        78);
  }

  // {78}
  public void test1267() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^5)/(a + b*x)^2, x]", //
        "(5*e*(b*d - a*e)^3*(b*B*d + 2*A*b*e - 3*a*B*e)*x)/b^6 - ((A*b - a*B)*(b*d - a*e)^5)/(b^7*(a + b*x)) + (5*e^2*(b*d - a*e)^2*(b*B*d + A*b*e - 2*a*B*e)*(a + b*x)^2)/b^7 + (5*e^3*(b*d - a*e)*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^3)/(3*b^7) + (e^4*(5*b*B*d + A*b*e - 6*a*B*e)*(a + b*x)^4)/(4*b^7) + (B*e^5*(a + b*x)^5)/(5*b^7) + ((b*d - a*e)^4*(b*B*d + 5*A*b*e - 6*a*B*e)*Log[a + b*x])/b^7", //
        78);
  }

  // {78}
  public void test1268() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^4)/(a + b*x)^2, x]", //
        "(2*e*(b*d - a*e)^2*(2*b*B*d + 3*A*b*e - 5*a*B*e)*x)/b^5 - ((A*b - a*B)*(b*d - a*e)^4)/(b^6*(a + b*x)) + (e^2*(b*d - a*e)*(3*b*B*d + 2*A*b*e - 5*a*B*e)*(a + b*x)^2)/b^6 + (e^3*(4*b*B*d + A*b*e - 5*a*B*e)*(a + b*x)^3)/(3*b^6) + (B*e^4*(a + b*x)^4)/(4*b^6) + ((b*d - a*e)^3*(b*B*d + 4*A*b*e - 5*a*B*e)*Log[a + b*x])/b^6", //
        78);
  }

  // {78}
  public void test1269() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^3)/(a + b*x)^2, x]", //
        "(3*e*(b*d - a*e)*(b*B*d + A*b*e - 2*a*B*e)*x)/b^4 - ((A*b - a*B)*(b*d - a*e)^3)/(b^5*(a + b*x)) + (e^2*(3*b*B*d + A*b*e - 4*a*B*e)*(a + b*x)^2)/(2*b^5) + (B*e^3*(a + b*x)^3)/(3*b^5) + ((b*d - a*e)^2*(b*B*d + 3*A*b*e - 4*a*B*e)*Log[a + b*x])/b^5", //
        78);
  }

  // {78}
  public void test1270() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^2)/(a + b*x)^2, x]", //
        "(e*(2*b*B*d + A*b*e - 2*a*B*e)*x)/b^3 + (B*e^2*x^2)/(2*b^2) - ((A*b - a*B)*(b*d - a*e)^2)/(b^4*(a + b*x)) + ((b*d - a*e)*(b*B*d + 2*A*b*e - 3*a*B*e)*Log[a + b*x])/b^4", //
        78);
  }

  // {78}
  public void test1271() {
    check( //
        "Integrate[((A + B*x)*(d + e*x))/(a + b*x)^2, x]", //
        "(B*e*x)/b^2 - ((A*b - a*B)*(b*d - a*e))/(b^3*(a + b*x)) + ((b*B*d + A*b*e - 2*a*B*e)*Log[a + b*x])/b^3", //
        78);
  }

  // {45}
  public void test1272() {
    check( //
        "Integrate[(A + B*x)/(a + b*x)^2, x]", //
        "-((A*b - a*B)/(b^2*(a + b*x))) + (B*Log[a + b*x])/b^2", //
        45);
  }

  // {78}
  public void test1273() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^2*(d + e*x)), x]", //
        "-((A*b - a*B)/(b*(b*d - a*e)*(a + b*x))) + ((B*d - A*e)*Log[a + b*x])/(b*d - a*e)^2 - ((B*d - A*e)*Log[d + e*x])/(b*d - a*e)^2", //
        78);
  }

  // {78}
  public void test1274() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^2*(d + e*x)^2), x]", //
        "-((A*b - a*B)/((b*d - a*e)^2*(a + b*x))) + (B*d - A*e)/((b*d - a*e)^2*(d + e*x)) + ((b*B*d - 2*A*b*e + a*B*e)*Log[a + b*x])/(b*d - a*e)^3 - ((b*B*d - 2*A*b*e + a*B*e)*Log[d + e*x])/(b*d - a*e)^3", //
        78);
  }

  // {78}
  public void test1275() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^2*(d + e*x)^3), x]", //
        "-((b*(A*b - a*B))/((b*d - a*e)^3*(a + b*x))) + (B*d - A*e)/(2*(b*d - a*e)^2*(d + e*x)^2) + (b*B*d - 2*A*b*e + a*B*e)/((b*d - a*e)^3*(d + e*x)) + (b*(b*B*d - 3*A*b*e + 2*a*B*e)*Log[a + b*x])/(b*d - a*e)^4 - (b*(b*B*d - 3*A*b*e + 2*a*B*e)*Log[d + e*x])/(b*d - a*e)^4", //
        78);
  }

  // {78}
  public void test1276() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^2*(d + e*x)^4), x]", //
        "-((b^2*(A*b - a*B))/((b*d - a*e)^4*(a + b*x))) + (B*d - A*e)/(3*(b*d - a*e)^2*(d + e*x)^3) + (b*B*d - 2*A*b*e + a*B*e)/(2*(b*d - a*e)^3*(d + e*x)^2) + (b*(b*B*d - 3*A*b*e + 2*a*B*e))/((b*d - a*e)^4*(d + e*x)) + (b^2*(b*B*d - 4*A*b*e + 3*a*B*e)*Log[a + b*x])/(b*d - a*e)^5 - (b^2*(b*B*d - 4*A*b*e + 3*a*B*e)*Log[d + e*x])/(b*d - a*e)^5", //
        78);
  }

  // {78}
  public void test1277() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^2*(d + e*x)^5), x]", //
        "-((b^3*(A*b - a*B))/((b*d - a*e)^5*(a + b*x))) + (B*d - A*e)/(4*(b*d - a*e)^2*(d + e*x)^4) + (b*B*d - 2*A*b*e + a*B*e)/(3*(b*d - a*e)^3*(d + e*x)^3) + (b*(b*B*d - 3*A*b*e + 2*a*B*e))/(2*(b*d - a*e)^4*(d + e*x)^2) + (b^2*(b*B*d - 4*A*b*e + 3*a*B*e))/((b*d - a*e)^5*(d + e*x)) + (b^3*(b*B*d - 5*A*b*e + 4*a*B*e)*Log[a + b*x])/(b*d - a*e)^6 - (b^3*(b*B*d - 5*A*b*e + 4*a*B*e)*Log[d + e*x])/(b*d - a*e)^6", //
        78);
  }

  // {78}
  public void test1278() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^5)/(a + b*x)^3, x]", //
        "(10*e^2*(b*d - a*e)^2*(b*B*d + A*b*e - 2*a*B*e)*x)/b^6 - ((A*b - a*B)*(b*d - a*e)^5)/(2*b^7*(a + b*x)^2) - ((b*d - a*e)^4*(b*B*d + 5*A*b*e - 6*a*B*e))/(b^7*(a + b*x)) + (5*e^3*(b*d - a*e)*(2*b*B*d + A*b*e - 3*a*B*e)*(a + b*x)^2)/(2*b^7) + (e^4*(5*b*B*d + A*b*e - 6*a*B*e)*(a + b*x)^3)/(3*b^7) + (B*e^5*(a + b*x)^4)/(4*b^7) + (5*e*(b*d - a*e)^3*(b*B*d + 2*A*b*e - 3*a*B*e)*Log[a + b*x])/b^7", //
        78);
  }

  // {78}
  public void test1279() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^4)/(a + b*x)^3, x]", //
        "(2*e^2*(b*d - a*e)*(3*b*B*d + 2*A*b*e - 5*a*B*e)*x)/b^5 - ((A*b - a*B)*(b*d - a*e)^4)/(2*b^6*(a + b*x)^2) - ((b*d - a*e)^3*(b*B*d + 4*A*b*e - 5*a*B*e))/(b^6*(a + b*x)) + (e^3*(4*b*B*d + A*b*e - 5*a*B*e)*(a + b*x)^2)/(2*b^6) + (B*e^4*(a + b*x)^3)/(3*b^6) + (2*e*(b*d - a*e)^2*(2*b*B*d + 3*A*b*e - 5*a*B*e)*Log[a + b*x])/b^6", //
        78);
  }

  // {78}
  public void test1280() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^3)/(a + b*x)^3, x]", //
        "(e^2*(3*b*B*d + A*b*e - 3*a*B*e)*x)/b^4 + (B*e^3*x^2)/(2*b^3) - ((A*b - a*B)*(b*d - a*e)^3)/(2*b^5*(a + b*x)^2) - ((b*d - a*e)^2*(b*B*d + 3*A*b*e - 4*a*B*e))/(b^5*(a + b*x)) + (3*e*(b*d - a*e)*(b*B*d + A*b*e - 2*a*B*e)*Log[a + b*x])/b^5", //
        78);
  }

  // {78}
  public void test1281() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^2)/(a + b*x)^3, x]", //
        "(B*e^2*x)/b^3 - ((A*b - a*B)*(b*d - a*e)^2)/(2*b^4*(a + b*x)^2) - ((b*d - a*e)*(b*B*d + 2*A*b*e - 3*a*B*e))/(b^4*(a + b*x)) + (e*(2*b*B*d + A*b*e - 3*a*B*e)*Log[a + b*x])/b^4", //
        78);
  }

  // {78}
  public void test1282() {
    check( //
        "Integrate[((A + B*x)*(d + e*x))/(a + b*x)^3, x]", //
        "-((A*b - a*B)*(b*d - a*e))/(2*b^3*(a + b*x)^2) - (b*B*d + A*b*e - 2*a*B*e)/(b^3*(a + b*x)) + (B*e*Log[a + b*x])/b^3", //
        78);
  }

  // {78}
  public void test1283() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^3*(d + e*x)), x]", //
        "-(A*b - a*B)/(2*b*(b*d - a*e)*(a + b*x)^2) - (B*d - A*e)/((b*d - a*e)^2*(a + b*x)) - (e*(B*d - A*e)*Log[a + b*x])/(b*d - a*e)^3 + (e*(B*d - A*e)*Log[d + e*x])/(b*d - a*e)^3", //
        78);
  }

  // {78}
  public void test1284() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^3*(d + e*x)^2), x]", //
        "-(A*b - a*B)/(2*(b*d - a*e)^2*(a + b*x)^2) - (b*B*d - 2*A*b*e + a*B*e)/((b*d - a*e)^3*(a + b*x)) - (e*(B*d - A*e))/((b*d - a*e)^3*(d + e*x)) - (e*(2*b*B*d - 3*A*b*e + a*B*e)*Log[a + b*x])/(b*d - a*e)^4 + (e*(2*b*B*d - 3*A*b*e + a*B*e)*Log[d + e*x])/(b*d - a*e)^4", //
        78);
  }

  // {78}
  public void test1285() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^3*(d + e*x)^3), x]", //
        "-(b*(A*b - a*B))/(2*(b*d - a*e)^3*(a + b*x)^2) - (b*(b*B*d - 3*A*b*e + 2*a*B*e))/((b*d - a*e)^4*(a + b*x)) - (e*(B*d - A*e))/(2*(b*d - a*e)^3*(d + e*x)^2) - (e*(2*b*B*d - 3*A*b*e + a*B*e))/((b*d - a*e)^4*(d + e*x)) - (3*b*e*(b*B*d - 2*A*b*e + a*B*e)*Log[a + b*x])/(b*d - a*e)^5 + (3*b*e*(b*B*d - 2*A*b*e + a*B*e)*Log[d + e*x])/(b*d - a*e)^5", //
        78);
  }

  // {78}
  public void test1286() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^3*(d + e*x)^4), x]", //
        "-(b^2*(A*b - a*B))/(2*(b*d - a*e)^4*(a + b*x)^2) - (b^2*(b*B*d - 4*A*b*e + 3*a*B*e))/((b*d - a*e)^5*(a + b*x)) - (e*(B*d - A*e))/(3*(b*d - a*e)^3*(d + e*x)^3) - (e*(2*b*B*d - 3*A*b*e + a*B*e))/(2*(b*d - a*e)^4*(d + e*x)^2) - (3*b*e*(b*B*d - 2*A*b*e + a*B*e))/((b*d - a*e)^5*(d + e*x)) - (2*b^2*e*(2*b*B*d - 5*A*b*e + 3*a*B*e)*Log[a + b*x])/(b*d - a*e)^6 + (2*b^2*e*(2*b*B*d - 5*A*b*e + 3*a*B*e)*Log[d + e*x])/(b*d - a*e)^6", //
        78);
  }

  // {78}
  public void test1287() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^8*(3 + 5*x), x]", //
        "(-7*(2 + 3*x)^9)/243 + (37*(2 + 3*x)^10)/270 - (10*(2 + 3*x)^11)/297", //
        78);
  }

  // {78}
  public void test1288() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^7*(3 + 5*x), x]", //
        "(-7*(2 + 3*x)^8)/216 + (37*(2 + 3*x)^9)/243 - (2 + 3*x)^10/27", //
        78);
  }

  // {78}
  public void test1289() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^6*(3 + 5*x), x]", //
        "-(2 + 3*x)^7/27 + (37*(2 + 3*x)^8)/216 - (10*(2 + 3*x)^9)/243", //
        78);
  }

  // {78}
  public void test1290() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^5*(3 + 5*x), x]", //
        "(-7*(2 + 3*x)^6)/162 + (37*(2 + 3*x)^7)/189 - (5*(2 + 3*x)^8)/108", //
        78);
  }

  // {78}
  public void test1291() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^4*(3 + 5*x), x]", //
        "(-7*(2 + 3*x)^5)/135 + (37*(2 + 3*x)^6)/162 - (10*(2 + 3*x)^7)/189", //
        78);
  }

  // {78}
  public void test1292() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^3*(3 + 5*x), x]", //
        "(-7*(2 + 3*x)^4)/108 + (37*(2 + 3*x)^5)/135 - (5*(2 + 3*x)^6)/81", //
        78);
  }

  // {78}
  public void test1293() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^2*(3 + 5*x), x]", //
        "12*x + 16*x^2 - (25*x^3)/3 - (129*x^4)/4 - 18*x^5", //
        78);
  }

  // {78}
  public void test1294() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)*(3 + 5*x), x]", //
        "6*x + (7*x^2)/2 - (23*x^3)/3 - (15*x^4)/2", //
        78);
  }

  // {45}
  public void test1295() {
    check( //
        "Integrate[(1 - 2*x)*(3 + 5*x), x]", //
        "3*x - x^2/2 - (10*x^3)/3", //
        45);
  }

  // {78}
  public void test1296() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x))/(2 + 3*x), x]", //
        "(17*x)/9 - (5*x^2)/3 - (7*Log[2 + 3*x])/27", //
        78);
  }

  // {78}
  public void test1297() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x))/(2 + 3*x)^2, x]", //
        "(-10*x)/9 + 7/(27*(2 + 3*x)) + (37*Log[2 + 3*x])/27", //
        78);
  }

  // {78}
  public void test1298() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x))/(2 + 3*x)^3, x]", //
        "7/(54*(2 + 3*x)^2) - 37/(27*(2 + 3*x)) - (10*Log[2 + 3*x])/27", //
        78);
  }

  // {78}
  public void test1299() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x))/(2 + 3*x)^4, x]", //
        "7/(81*(2 + 3*x)^3) - 37/(54*(2 + 3*x)^2) + 10/(27*(2 + 3*x))", //
        78);
  }

  // {78}
  public void test1300() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x))/(2 + 3*x)^5, x]", //
        "7/(108*(2 + 3*x)^4) - 37/(81*(2 + 3*x)^3) + 5/(27*(2 + 3*x)^2)", //
        78);
  }

  // {78}
  public void test1301() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x))/(2 + 3*x)^6, x]", //
        "7/(135*(2 + 3*x)^5) - 37/(108*(2 + 3*x)^4) + 10/(81*(2 + 3*x)^3)", //
        78);
  }

  // {78}
  public void test1302() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^8*(3 + 5*x)^2, x]", //
        "(7*(2 + 3*x)^9)/729 - (4*(2 + 3*x)^10)/45 + (65*(2 + 3*x)^11)/297 - (25*(2 + 3*x)^12)/486", //
        78);
  }

  // {78}
  public void test1303() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^7*(3 + 5*x)^2, x]", //
        "(7*(2 + 3*x)^8)/648 - (8*(2 + 3*x)^9)/81 + (13*(2 + 3*x)^10)/54 - (50*(2 + 3*x)^11)/891", //
        78);
  }

  // {78}
  public void test1304() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^6*(3 + 5*x)^2, x]", //
        "(2 + 3*x)^7/81 - (2 + 3*x)^8/9 + (65*(2 + 3*x)^9)/243 - (5*(2 + 3*x)^10)/81", //
        78);
  }

  // {78}
  public void test1305() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^5*(3 + 5*x)^2, x]", //
        "(7*(2 + 3*x)^6)/486 - (8*(2 + 3*x)^7)/63 + (65*(2 + 3*x)^8)/216 - (50*(2 + 3*x)^9)/729", //
        78);
  }

  // {78}
  public void test1306() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^4*(3 + 5*x)^2, x]", //
        "(7*(2 + 3*x)^5)/405 - (4*(2 + 3*x)^6)/27 + (65*(2 + 3*x)^7)/189 - (25*(2 + 3*x)^8)/324", //
        78);
  }

  // {78}
  public void test1307() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^3*(3 + 5*x)^2, x]", //
        "72*x + 210*x^2 + (638*x^3)/3 - (769*x^4)/4 - (3366*x^5)/5 - (1215*x^6)/2 - (1350*x^7)/7", //
        78);
  }

  // {78}
  public void test1308() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^2*(3 + 5*x)^2, x]", //
        "36*x + 78*x^2 + (85*x^3)/3 - 128*x^4 - 183*x^5 - 75*x^6", //
        78);
  }

  // {78}
  public void test1309() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)*(3 + 5*x)^2, x]", //
        "18*x + (51*x^2)/2 - (34*x^3)/3 - (205*x^4)/4 - 30*x^5", //
        78);
  }

  // {45}
  public void test1310() {
    check( //
        "Integrate[(1 - 2*x)*(3 + 5*x)^2, x]", //
        "9*x + 6*x^2 - (35*x^3)/3 - (25*x^4)/2", //
        45);
  }

  // {78}
  public void test1311() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^2)/(2 + 3*x), x]", //
        "(118*x)/27 - (5*x^2)/18 - (50*x^3)/9 + (7*Log[2 + 3*x])/81", //
        78);
  }

  // {78}
  public void test1312() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^2)/(2 + 3*x)^2, x]", //
        "(95*x)/27 - (25*x^2)/9 - 7/(81*(2 + 3*x)) - (8*Log[2 + 3*x])/9", //
        78);
  }

  // {78}
  public void test1313() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^2)/(2 + 3*x)^3, x]", //
        "(-50*x)/27 - 7/(162*(2 + 3*x)^2) + 8/(9*(2 + 3*x)) + (65*Log[2 + 3*x])/27", //
        78);
  }

  // {78}
  public void test1314() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^2)/(2 + 3*x)^4, x]", //
        "-7/(243*(2 + 3*x)^3) + 4/(9*(2 + 3*x)^2) - 65/(27*(2 + 3*x)) - (50*Log[2 + 3*x])/81", //
        78);
  }

  // {79, 37}
  public void test1315() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^2)/(2 + 3*x)^5, x]", //
        "(7*(3 + 5*x)^3)/(12*(2 + 3*x)^4) + (3*(3 + 5*x)^3)/(4*(2 + 3*x)^3)", //
        79,
        37);
  }

  // {78}
  public void test1316() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^2)/(2 + 3*x)^6, x]", //
        "-7/(405*(2 + 3*x)^5) + 2/(9*(2 + 3*x)^4) - 65/(81*(2 + 3*x)^3) + 25/(81*(2 + 3*x)^2)", //
        78);
  }

  // {78}
  public void test1317() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^2)/(2 + 3*x)^7, x]", //
        "-7/(486*(2 + 3*x)^6) + 8/(45*(2 + 3*x)^5) - 65/(108*(2 + 3*x)^4) + 50/(243*(2 + 3*x)^3)", //
        78);
  }

  // {78}
  public void test1318() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^2)/(2 + 3*x)^8, x]", //
        "-1/(81*(2 + 3*x)^7) + 4/(27*(2 + 3*x)^6) - 13/(27*(2 + 3*x)^5) + 25/(162*(2 + 3*x)^4)", //
        78);
  }

  // {78}
  public void test1319() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^8*(3 + 5*x)^3, x]", //
        "(-7*(2 + 3*x)^9)/2187 + (107*(2 + 3*x)^10)/2430 - (185*(2 + 3*x)^11)/891 + (1025*(2 + 3*x)^12)/2916 - (250*(2 + 3*x)^13)/3159", //
        78);
  }

  // {78}
  public void test1320() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^7*(3 + 5*x)^3, x]", //
        "(-7*(2 + 3*x)^8)/1944 + (107*(2 + 3*x)^9)/2187 - (37*(2 + 3*x)^10)/162 + (1025*(2 + 3*x)^11)/2673 - (125*(2 + 3*x)^12)/1458", //
        78);
  }

  // {78}
  public void test1321() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^6*(3 + 5*x)^3, x]", //
        "-(2 + 3*x)^7/243 + (107*(2 + 3*x)^8)/1944 - (185*(2 + 3*x)^9)/729 + (205*(2 + 3*x)^10)/486 - (250*(2 + 3*x)^11)/2673", //
        78);
  }

  // {78}
  public void test1322() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^5*(3 + 5*x)^3, x]", //
        "(-7*(2 + 3*x)^6)/1458 + (107*(2 + 3*x)^7)/1701 - (185*(2 + 3*x)^8)/648 + (1025*(2 + 3*x)^9)/2187 - (25*(2 + 3*x)^10)/243", //
        78);
  }

  // {78}
  public void test1323() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^4*(3 + 5*x)^3, x]", //
        "(-7*(2 + 3*x)^5)/1215 + (107*(2 + 3*x)^6)/1458 - (185*(2 + 3*x)^7)/567 + (1025*(2 + 3*x)^8)/1944 - (250*(2 + 3*x)^9)/2187", //
        78);
  }

  // {78}
  public void test1324() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^3*(3 + 5*x)^3, x]", //
        "216*x + 810*x^2 + 1338*x^3 + (883*x^4)/4 - (13943*x^5)/5 - (9255*x^6)/2 - (22275*x^7)/7 - (3375*x^8)/4", //
        78);
  }

  // {78}
  public void test1325() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^2*(3 + 5*x)^3, x]", //
        "108*x + 324*x^2 + 345*x^3 - (1111*x^4)/4 - 1061*x^5 - (1975*x^6)/2 - (2250*x^7)/7", //
        78);
  }

  // {78}
  public void test1326() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)*(3 + 5*x)^3, x]", //
        "(11*(3 + 5*x)^4)/500 + (31*(3 + 5*x)^5)/625 - (3 + 5*x)^6/125", //
        78);
  }

  // {45}
  public void test1327() {
    check( //
        "Integrate[(1 - 2*x)*(3 + 5*x)^3, x]", //
        "(11*(3 + 5*x)^4)/100 - (2*(3 + 5*x)^5)/125", //
        45);
  }

  // {78}
  public void test1328() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^3)/(2 + 3*x), x]", //
        "(1097*x)/81 + (545*x^2)/54 - (475*x^3)/27 - (125*x^4)/6 - (7*Log[2 + 3*x])/243", //
        78);
  }

  // {78}
  public void test1329() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^3)/(2 + 3*x)^2, x]", //
        "(55*x)/9 + (25*x^2)/54 - (250*x^3)/27 + 7/(243*(2 + 3*x)) + (107*Log[2 + 3*x])/243", //
        78);
  }

  // {78}
  public void test1330() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^3)/(2 + 3*x)^3, x]", //
        "(175*x)/27 - (125*x^2)/27 + 7/(486*(2 + 3*x)^2) - 107/(243*(2 + 3*x)) - (185*Log[2 + 3*x])/81", //
        78);
  }

  // {78}
  public void test1331() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^3)/(2 + 3*x)^4, x]", //
        "(-250*x)/81 + 7/(729*(2 + 3*x)^3) - 107/(486*(2 + 3*x)^2) + 185/(81*(2 + 3*x)) + (1025*Log[2 + 3*x])/243", //
        78);
  }

  // {78}
  public void test1332() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^3)/(2 + 3*x)^5, x]", //
        "7/(972*(2 + 3*x)^4) - 107/(729*(2 + 3*x)^3) + 185/(162*(2 + 3*x)^2) - 1025/(243*(2 + 3*x)) - (250*Log[2 + 3*x])/243", //
        78);
  }

  // {79, 37}
  public void test1333() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^3)/(2 + 3*x)^6, x]", //
        "(7*(3 + 5*x)^4)/(15*(2 + 3*x)^5) + (5*(3 + 5*x)^4)/(12*(2 + 3*x)^4)", //
        79,
        37);
  }

  // {78}
  public void test1334() {
    check( //
        "Integrate[((1 - 2*x)*(3 + 5*x)^3)/(2 + 3*x)^8, x]", //
        "1/(243*(2 + 3*x)^7) - 107/(1458*(2 + 3*x)^6) + 37/(81*(2 + 3*x)^5) - 1025/(972*(2 + 3*x)^4) + 250/(729*(2 + 3*x)^3)", //
        78);
  }

  // {78}
  public void test1335() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^6)/(3 + 5*x), x]", //
        "(1666663*x)/78125 + (1777779*x^2)/31250 + (152469*x^3)/3125 - (152469*x^4)/2500 - (106677*x^5)/625 - (7047*x^6)/50 - (1458*x^7)/35 + (11*Log[3 + 5*x])/390625", //
        78);
  }

  // {78}
  public void test1336() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^5)/(3 + 5*x), x]", //
        "(166663*x)/15625 + (127779*x^2)/6250 + (2469*x^3)/625 - (17469*x^4)/500 - (5427*x^5)/125 - (81*x^6)/5 + (11*Log[3 + 5*x])/78125", //
        78);
  }

  // {78}
  public void test1337() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^4)/(3 + 5*x), x]", //
        "(16663*x)/3125 + (7779*x^2)/1250 - (531*x^3)/125 - (1269*x^4)/100 - (162*x^5)/25 + (11*Log[3 + 5*x])/15625", //
        78);
  }

  // {78}
  public void test1338() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^3)/(3 + 5*x), x]", //
        "(1663*x)/625 + (279*x^2)/250 - (81*x^3)/25 - (27*x^4)/10 + (11*Log[3 + 5*x])/3125", //
        78);
  }

  // {78}
  public void test1339() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^2)/(3 + 5*x), x]", //
        "(163*x)/125 - (21*x^2)/50 - (6*x^3)/5 + (11*Log[3 + 5*x])/625", //
        78);
  }

  // {78}
  public void test1340() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x))/(3 + 5*x), x]", //
        "(13*x)/25 - (3*x^2)/5 + (11*Log[3 + 5*x])/125", //
        78);
  }

  // {45}
  public void test1341() {
    check( //
        "Integrate[(1 - 2*x)/(3 + 5*x), x]", //
        "(-2*x)/5 + (11*Log[3 + 5*x])/25", //
        45);
  }

  // {78}
  public void test1342() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)*(3 + 5*x)), x]", //
        "(-7*Log[2 + 3*x])/3 + (11*Log[3 + 5*x])/5", //
        78);
  }

  // {78}
  public void test1343() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^2*(3 + 5*x)), x]", //
        "7/(3*(2 + 3*x)) - 11*Log[2 + 3*x] + 11*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1344() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^3*(3 + 5*x)), x]", //
        "7/(6*(2 + 3*x)^2) + 11/(2 + 3*x) - 55*Log[2 + 3*x] + 55*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1345() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^4*(3 + 5*x)), x]", //
        "7/(9*(2 + 3*x)^3) + 11/(2*(2 + 3*x)^2) + 55/(2 + 3*x) - 275*Log[2 + 3*x] + 275*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1346() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^5*(3 + 5*x)), x]", //
        "7/(12*(2 + 3*x)^4) + 11/(3*(2 + 3*x)^3) + 55/(2*(2 + 3*x)^2) + 275/(2 + 3*x) - 1375*Log[2 + 3*x] + 1375*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1347() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^6*(3 + 5*x)), x]", //
        "7/(15*(2 + 3*x)^5) + 11/(4*(2 + 3*x)^4) + 55/(3*(2 + 3*x)^3) + 275/(2*(2 + 3*x)^2) + 1375/(2 + 3*x) - 6875*Log[2 + 3*x] + 6875*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1348() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^7*(3 + 5*x)), x]", //
        "7/(18*(2 + 3*x)^6) + 11/(5*(2 + 3*x)^5) + 55/(4*(2 + 3*x)^4) + 275/(3*(2 + 3*x)^3) + 1375/(2*(2 + 3*x)^2) + 6875/(2 + 3*x) - 34375*Log[2 + 3*x] + 34375*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1349() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^7)/(3 + 5*x)^2, x]", //
        "(5555478*x)/390625 + (5740767*x^2)/156250 + (92592*x^3)/3125 - (513783*x^4)/12500 - (336798*x^5)/3125 - (21627*x^6)/250 - (4374*x^7)/175 - 11/(1953125*(3 + 5*x)) + (229*Log[3 + 5*x])/1953125", //
        78);
  }

  // {78}
  public void test1350() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^6)/(3 + 5*x)^2, x]", //
        "(555489*x)/78125 + (40743*x^2)/3125 + (5553*x^3)/3125 - (14094*x^4)/625 - (16767*x^5)/625 - (243*x^6)/25 - 11/(390625*(3 + 5*x)) + (196*Log[3 + 5*x])/390625", //
        78);
  }

  // {78}
  public void test1351() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^5)/(3 + 5*x)^2, x]", //
        "(444*x)/125 + (24093*x^2)/6250 - (1854*x^3)/625 - (3969*x^4)/500 - (486*x^5)/125 - 11/(78125*(3 + 5*x)) + (163*Log[3 + 5*x])/78125", //
        78);
  }

  // {78}
  public void test1352() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^4)/(3 + 5*x)^2, x]", //
        "(5511*x)/3125 + (378*x^2)/625 - (261*x^3)/125 - (81*x^4)/50 - 11/(15625*(3 + 5*x)) + (26*Log[3 + 5*x])/3125", //
        78);
  }

  // {78}
  public void test1353() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^3)/(3 + 5*x)^2, x]", //
        "(522*x)/625 - (81*x^2)/250 - (18*x^3)/25 - 11/(3125*(3 + 5*x)) + (97*Log[3 + 5*x])/3125", //
        78);
  }

  // {78}
  public void test1354() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^2)/(3 + 5*x)^2, x]", //
        "(33*x)/125 - (9*x^2)/25 - 11/(625*(3 + 5*x)) + (64*Log[3 + 5*x])/625", //
        78);
  }

  // {78}
  public void test1355() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x))/(3 + 5*x)^2, x]", //
        "(-6*x)/25 - 11/(125*(3 + 5*x)) + (31*Log[3 + 5*x])/125", //
        78);
  }

  // {45}
  public void test1356() {
    check( //
        "Integrate[(1 - 2*x)/(3 + 5*x)^2, x]", //
        "-11/(25*(3 + 5*x)) - (2*Log[3 + 5*x])/25", //
        45);
  }

  // {78}
  public void test1357() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)*(3 + 5*x)^2), x]", //
        "-11/(5*(3 + 5*x)) + 7*Log[2 + 3*x] - 7*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1358() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^2*(3 + 5*x)^2), x]", //
        "-7/(2 + 3*x) - 11/(3 + 5*x) + 68*Log[2 + 3*x] - 68*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1359() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^3*(3 + 5*x)^2), x]", //
        "-7/(2*(2 + 3*x)^2) - 68/(2 + 3*x) - 55/(3 + 5*x) + 505*Log[2 + 3*x] - 505*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1360() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^4*(3 + 5*x)^2), x]", //
        "-7/(3*(2 + 3*x)^3) - 34/(2 + 3*x)^2 - 505/(2 + 3*x) - 275/(3 + 5*x) + 3350*Log[2 + 3*x] - 3350*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1361() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^5*(3 + 5*x)^2), x]", //
        "-7/(4*(2 + 3*x)^4) - 68/(3*(2 + 3*x)^3) - 505/(2*(2 + 3*x)^2) - 3350/(2 + 3*x) - 1375/(3 + 5*x) + 20875*Log[2 + 3*x] - 20875*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1362() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^6*(3 + 5*x)^2), x]", //
        "-7/(5*(2 + 3*x)^5) - 17/(2 + 3*x)^4 - 505/(3*(2 + 3*x)^3) - 1675/(2 + 3*x)^2 - 20875/(2 + 3*x) - 6875/(3 + 5*x) + 125000*Log[2 + 3*x] - 125000*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1363() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^7*(3 + 5*x)^2), x]", //
        "-7/(6*(2 + 3*x)^6) - 68/(5*(2 + 3*x)^5) - 505/(4*(2 + 3*x)^4) - 3350/(3*(2 + 3*x)^3) - 20875/(2*(2 + 3*x)^2) - 125000/(2 + 3*x) - 34375/(3 + 5*x) + 728125*Log[2 + 3*x] - 728125*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1364() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^7)/(3 + 5*x)^3, x]", //
        "(1851147*x)/390625 + (129654*x^2)/15625 + (2052*x^3)/3125 - (181521*x^4)/12500 - (51759*x^5)/3125 - (729*x^6)/125 - 11/(3906250*(3 + 5*x)^2) - 229/(1953125*(3 + 5*x)) + (2037*Log[3 + 5*x])/1953125", //
        78);
  }

  // {78}
  public void test1365() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^6)/(3 + 5*x)^3, x]", //
        "(36936*x)/15625 + (297*x^2)/125 - (6399*x^3)/3125 - (12393*x^4)/2500 - (1458*x^5)/625 - 11/(781250*(3 + 5*x)^2) - 196/(390625*(3 + 5*x)) + (1449*Log[3 + 5*x])/390625", //
        78);
  }

  // {78}
  public void test1366() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^5)/(3 + 5*x)^3, x]", //
        "(3636*x)/3125 + (1971*x^2)/6250 - (837*x^3)/625 - (243*x^4)/250 - 11/(156250*(3 + 5*x)^2) - 163/(78125*(3 + 5*x)) + (192*Log[3 + 5*x])/15625", //
        78);
  }

  // {78}
  public void test1367() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^4)/(3 + 5*x)^3, x]", //
        "(1647*x)/3125 - (297*x^2)/1250 - (54*x^3)/125 - 11/(31250*(3 + 5*x)^2) - 26/(3125*(3 + 5*x)) + (114*Log[3 + 5*x])/3125", //
        78);
  }

  // {78}
  public void test1368() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^3)/(3 + 5*x)^3, x]", //
        "(81*x)/625 - (27*x^2)/125 - 11/(6250*(3 + 5*x)^2) - 97/(3125*(3 + 5*x)) + (279*Log[3 + 5*x])/3125", //
        78);
  }

  // {78}
  public void test1369() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^2)/(3 + 5*x)^3, x]", //
        "(-18*x)/125 - 11/(1250*(3 + 5*x)^2) - 64/(625*(3 + 5*x)) + (87*Log[3 + 5*x])/625", //
        78);
  }

  // {78}
  public void test1370() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x))/(3 + 5*x)^3, x]", //
        "-11/(250*(3 + 5*x)^2) - 31/(125*(3 + 5*x)) - (6*Log[3 + 5*x])/125", //
        78);
  }

  // {78}
  public void test1371() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)*(3 + 5*x)^3), x]", //
        "-11/(10*(3 + 5*x)^2) + 7/(3 + 5*x) - 21*Log[2 + 3*x] + 21*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1372() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^2*(3 + 5*x)^3), x]", //
        "21/(2 + 3*x) - 11/(2*(3 + 5*x)^2) + 68/(3 + 5*x) - 309*Log[2 + 3*x] + 309*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1373() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^3*(3 + 5*x)^3), x]", //
        "21/(2*(2 + 3*x)^2) + 309/(2 + 3*x) - 55/(2*(3 + 5*x)^2) + 505/(3 + 5*x) - 3060*Log[2 + 3*x] + 3060*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1374() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^4*(3 + 5*x)^3), x]", //
        "7/(2 + 3*x)^3 + 309/(2*(2 + 3*x)^2) + 3060/(2 + 3*x) - 275/(2*(3 + 5*x)^2) + 3350/(3 + 5*x) - 25350*Log[2 + 3*x] + 25350*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1375() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^5*(3 + 5*x)^3), x]", //
        "21/(4*(2 + 3*x)^4) + 103/(2 + 3*x)^3 + 1530/(2 + 3*x)^2 + 25350/(2 + 3*x) - 1375/(2*(3 + 5*x)^2) + 20875/(3 + 5*x) - 189375*Log[2 + 3*x] + 189375*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1376() {
    check( //
        "Integrate[(1 - 2*x)/((2 + 3*x)^6*(3 + 5*x)^3), x]", //
        "21/(5*(2 + 3*x)^5) + 309/(4*(2 + 3*x)^4) + 1020/(2 + 3*x)^3 + 12675/(2 + 3*x)^2 + 189375/(2 + 3*x) - 6875/(2*(3 + 5*x)^2) + 125000/(3 + 5*x) - 1321875*Log[2 + 3*x] + 1321875*Log[3 + 5*x]", //
        78);
  }

  // {78}
  public void test1377() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^8*(3 + 5*x), x]", //
        "(-49*(2 + 3*x)^9)/729 + (91*(2 + 3*x)^10)/270 - (16*(2 + 3*x)^11)/99 + (5*(2 + 3*x)^12)/243", //
        78);
  }

  // {78}
  public void test1378() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^7*(3 + 5*x), x]", //
        "(-49*(2 + 3*x)^8)/648 + (91*(2 + 3*x)^9)/243 - (8*(2 + 3*x)^10)/45 + (20*(2 + 3*x)^11)/891", //
        78);
  }

  // {78}
  public void test1379() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^6*(3 + 5*x), x]", //
        "(-7*(2 + 3*x)^7)/81 + (91*(2 + 3*x)^8)/216 - (16*(2 + 3*x)^9)/81 + (2*(2 + 3*x)^10)/81", //
        78);
  }

  // {78}
  public void test1380() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^5*(3 + 5*x), x]", //
        "(-49*(2 + 3*x)^6)/486 + (13*(2 + 3*x)^7)/27 - (2*(2 + 3*x)^8)/9 + (20*(2 + 3*x)^9)/729", //
        78);
  }

  // {78}
  public void test1381() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^4*(3 + 5*x), x]", //
        "(-49*(2 + 3*x)^5)/405 + (91*(2 + 3*x)^6)/162 - (16*(2 + 3*x)^7)/63 + (5*(2 + 3*x)^8)/162", //
        78);
  }

  // {78}
  public void test1382() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^3*(3 + 5*x), x]", //
        "24*x + 26*x^2 - (154*x^3)/3 - (425*x^4)/4 + (99*x^5)/5 + 144*x^6 + (540*x^7)/7", //
        78);
  }

  // {78}
  public void test1383() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^2*(3 + 5*x), x]", //
        "12*x + 4*x^2 - (89*x^3)/3 - (79*x^4)/4 + (168*x^5)/5 + 30*x^6", //
        78);
  }

  // {78}
  public void test1384() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)*(3 + 5*x), x]", //
        "6*x - (5*x^2)/2 - (37*x^3)/3 + 4*x^4 + 12*x^5", //
        78);
  }

  // {45}
  public void test1385() {
    check( //
        "Integrate[(1 - 2*x)^2*(3 + 5*x), x]", //
        "3*x - (7*x^2)/2 - (8*x^3)/3 + 5*x^4", //
        45);
  }

  // {78}
  public void test1386() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x))/(2 + 3*x), x]", //
        "(65*x)/27 - (32*x^2)/9 + (20*x^3)/9 - (49*Log[2 + 3*x])/81", //
        78);
  }

  // {78}
  public void test1387() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x))/(2 + 3*x)^2, x]", //
        "(-104*x)/27 + (10*x^2)/9 + 49/(81*(2 + 3*x)) + (91*Log[2 + 3*x])/27", //
        78);
  }

  // {78}
  public void test1388() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x))/(2 + 3*x)^3, x]", //
        "(20*x)/27 + 49/(162*(2 + 3*x)^2) - 91/(27*(2 + 3*x)) - (16*Log[2 + 3*x])/9", //
        78);
  }

  // {78}
  public void test1389() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x))/(2 + 3*x)^4, x]", //
        "49/(243*(2 + 3*x)^3) - 91/(54*(2 + 3*x)^2) + 16/(9*(2 + 3*x)) + (20*Log[2 + 3*x])/81", //
        78);
  }

  // {79, 37}
  public void test1390() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x))/(2 + 3*x)^5, x]", //
        "(1 - 2*x)^3/(84*(2 + 3*x)^4) - (23*(1 - 2*x)^3)/(294*(2 + 3*x)^3)", //
        79,
        37);
  }

  // {78}
  public void test1391() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x))/(2 + 3*x)^6, x]", //
        "49/(405*(2 + 3*x)^5) - 91/(108*(2 + 3*x)^4) + 16/(27*(2 + 3*x)^3) - 10/(81*(2 + 3*x)^2)", //
        78);
  }

  // {78}
  public void test1392() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x))/(2 + 3*x)^7, x]", //
        "49/(486*(2 + 3*x)^6) - 91/(135*(2 + 3*x)^5) + 4/(9*(2 + 3*x)^4) - 20/(243*(2 + 3*x)^3)", //
        78);
  }

  // {78}
  public void test1393() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x))/(2 + 3*x)^8, x]", //
        "7/(81*(2 + 3*x)^7) - 91/(162*(2 + 3*x)^6) + 16/(45*(2 + 3*x)^5) - 5/(81*(2 + 3*x)^4)", //
        78);
  }

  // {90}
  public void test1394() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^8*(3 + 5*x)^2, x]", //
        "(49*(2 + 3*x)^9)/2187 - (259*(2 + 3*x)^10)/1215 + (503*(2 + 3*x)^11)/891 - (185*(2 + 3*x)^12)/729 + (100*(2 + 3*x)^13)/3159", //
        90);
  }

  // {90}
  public void test1395() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^7*(3 + 5*x)^2, x]", //
        "(49*(2 + 3*x)^8)/1944 - (518*(2 + 3*x)^9)/2187 + (503*(2 + 3*x)^10)/810 - (740*(2 + 3*x)^11)/2673 + (25*(2 + 3*x)^12)/729", //
        90);
  }

  // {90}
  public void test1396() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^6*(3 + 5*x)^2, x]", //
        "(7*(2 + 3*x)^7)/243 - (259*(2 + 3*x)^8)/972 + (503*(2 + 3*x)^9)/729 - (74*(2 + 3*x)^10)/243 + (100*(2 + 3*x)^11)/2673", //
        90);
  }

  // {90}
  public void test1397() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^5*(3 + 5*x)^2, x]", //
        "(49*(2 + 3*x)^6)/1458 - (74*(2 + 3*x)^7)/243 + (503*(2 + 3*x)^8)/648 - (740*(2 + 3*x)^9)/2187 + (10*(2 + 3*x)^10)/243", //
        90);
  }

  // {90}
  public void test1398() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^4*(3 + 5*x)^2, x]", //
        "(49*(2 + 3*x)^5)/1215 - (259*(2 + 3*x)^6)/729 + (503*(2 + 3*x)^7)/567 - (185*(2 + 3*x)^8)/486 + (100*(2 + 3*x)^9)/2187", //
        90);
  }

  // {90}
  public void test1399() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^3*(3 + 5*x)^2, x]", //
        "72*x + 138*x^2 - (202*x^3)/3 - (2045*x^4)/4 - (1828*x^5)/5 + (1029*x^6)/2 + (5940*x^7)/7 + (675*x^8)/2", //
        90);
  }

  // {90}
  public void test1400() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^2*(3 + 5*x)^2, x]", //
        "36*x + 42*x^2 - (227*x^3)/3 - (341*x^4)/2 + (109*x^5)/5 + 230*x^6 + (900*x^7)/7", //
        90);
  }

  // {78}
  public void test1401() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)*(3 + 5*x)^2, x]", //
        "18*x + (15*x^2)/2 - (136*x^3)/3 - (137*x^4)/4 + 52*x^5 + 50*x^6", //
        78);
  }

  // {45}
  public void test1402() {
    check( //
        "Integrate[(1 - 2*x)^2*(3 + 5*x)^2, x]", //
        "9*x - 3*x^2 - (59*x^3)/3 + 5*x^4 + 20*x^5", //
        45);
  }

  // {90}
  public void test1403() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^2)/(2 + 3*x), x]", //
        "(340*x)/81 - (251*x^2)/54 - (140*x^3)/27 + (25*x^4)/3 + (49*Log[2 + 3*x])/243", //
        90);
  }

  // {90}
  public void test1404() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^2)/(2 + 3*x)^2, x]", //
        "(143*x)/27 - (170*x^2)/27 + (100*x^3)/27 - 49/(243*(2 + 3*x)) - (518*Log[2 + 3*x])/243", //
        90);
  }

  // {90}
  public void test1405() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^2)/(2 + 3*x)^3, x]", //
        "(-20*x)/3 + (50*x^2)/27 - 49/(486*(2 + 3*x)^2) + 518/(243*(2 + 3*x)) + (503*Log[2 + 3*x])/81", //
        90);
  }

  // {90}
  public void test1406() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^2)/(2 + 3*x)^4, x]", //
        "(100*x)/81 - 49/(729*(2 + 3*x)^3) + 259/(243*(2 + 3*x)^2) - 503/(81*(2 + 3*x)) - (740*Log[2 + 3*x])/243", //
        90);
  }

  // {90}
  public void test1407() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^2)/(2 + 3*x)^5, x]", //
        "-49/(972*(2 + 3*x)^4) + 518/(729*(2 + 3*x)^3) - 503/(162*(2 + 3*x)^2) + 740/(243*(2 + 3*x)) + (100*Log[2 + 3*x])/243", //
        90);
  }

  // {90}
  public void test1408() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^2)/(2 + 3*x)^6, x]", //
        "-49/(1215*(2 + 3*x)^5) + 259/(486*(2 + 3*x)^4) - 503/(243*(2 + 3*x)^3) + 370/(243*(2 + 3*x)^2) - 100/(243*(2 + 3*x))", //
        90);
  }

  // {90}
  public void test1409() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^2)/(2 + 3*x)^7, x]", //
        "-49/(1458*(2 + 3*x)^6) + 518/(1215*(2 + 3*x)^5) - 503/(324*(2 + 3*x)^4) + 740/(729*(2 + 3*x)^3) - 50/(243*(2 + 3*x)^2)", //
        90);
  }

  // {90}
  public void test1410() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^2)/(2 + 3*x)^8, x]", //
        "-7/(243*(2 + 3*x)^7) + 259/(729*(2 + 3*x)^6) - 503/(405*(2 + 3*x)^5) + 185/(243*(2 + 3*x)^4) - 100/(729*(2 + 3*x)^3)", //
        90);
  }

  // {90}
  public void test1411() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^10*(3 + 5*x)^3, x]", //
        "(-49*(2 + 3*x)^11)/8019 + (763*(2 + 3*x)^12)/8748 - (4099*(2 + 3*x)^13)/9477 + (8285*(2 + 3*x)^14)/10206 - (760*(2 + 3*x)^15)/2187 + (125*(2 + 3*x)^16)/2916", //
        90);
  }

  // {90}
  public void test1412() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^9*(3 + 5*x)^3, x]", //
        "(-49*(2 + 3*x)^10)/7290 + (763*(2 + 3*x)^11)/8019 - (4099*(2 + 3*x)^12)/8748 + (8285*(2 + 3*x)^13)/9477 - (1900*(2 + 3*x)^14)/5103 + (100*(2 + 3*x)^15)/2187", //
        90);
  }

  // {90}
  public void test1413() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^8*(3 + 5*x)^3, x]", //
        "(-49*(2 + 3*x)^9)/6561 + (763*(2 + 3*x)^10)/7290 - (4099*(2 + 3*x)^11)/8019 + (8285*(2 + 3*x)^12)/8748 - (3800*(2 + 3*x)^13)/9477 + (250*(2 + 3*x)^14)/5103", //
        90);
  }

  // {90}
  public void test1414() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^7*(3 + 5*x)^3, x]", //
        "(-49*(2 + 3*x)^8)/5832 + (763*(2 + 3*x)^9)/6561 - (4099*(2 + 3*x)^10)/7290 + (8285*(2 + 3*x)^11)/8019 - (950*(2 + 3*x)^12)/2187 + (500*(2 + 3*x)^13)/9477", //
        90);
  }

  // {90}
  public void test1415() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^6*(3 + 5*x)^3, x]", //
        "(-7*(2 + 3*x)^7)/729 + (763*(2 + 3*x)^8)/5832 - (4099*(2 + 3*x)^9)/6561 + (1657*(2 + 3*x)^10)/1458 - (3800*(2 + 3*x)^11)/8019 + (125*(2 + 3*x)^12)/2187", //
        90);
  }

  // {90}
  public void test1416() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^5*(3 + 5*x)^3, x]", //
        "(-49*(2 + 3*x)^6)/4374 + (109*(2 + 3*x)^7)/729 - (4099*(2 + 3*x)^8)/5832 + (8285*(2 + 3*x)^9)/6561 - (380*(2 + 3*x)^10)/729 + (500*(2 + 3*x)^11)/8019", //
        90);
  }

  // {90}
  public void test1417() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^4*(3 + 5*x)^3, x]", //
        "(-49*(2 + 3*x)^5)/3645 + (763*(2 + 3*x)^6)/4374 - (4099*(2 + 3*x)^7)/5103 + (8285*(2 + 3*x)^8)/5832 - (3800*(2 + 3*x)^9)/6561 + (50*(2 + 3*x)^10)/729", //
        90);
  }

  // {90}
  public void test1418() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^3*(3 + 5*x)^3, x]", //
        "216*x + 594*x^2 + 258*x^3 - (7145*x^4)/4 - (15709*x^5)/5 + (121*x^6)/6 + (33255*x^7)/7 + 4725*x^8 + 1500*x^9", //
        90);
  }

  // {90}
  public void test1419() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)^2*(3 + 5*x)^3, x]", //
        "108*x + 216*x^2 - 87*x^3 - (3181*x^4)/4 - (3083*x^5)/5 + (4685*x^6)/6 + (9600*x^7)/7 + (1125*x^8)/2", //
        90);
  }

  // {78}
  public void test1420() {
    check( //
        "Integrate[(1 - 2*x)^2*(2 + 3*x)*(3 + 5*x)^3, x]", //
        "54*x + (135*x^2)/2 - 111*x^3 - (1091*x^4)/4 + 19*x^5 + (1100*x^6)/3 + (1500*x^7)/7", //
        78);
  }

  // {45}
  public void test1421() {
    check( //
        "Integrate[(1 - 2*x)^2*(3 + 5*x)^3, x]", //
        "(121*(3 + 5*x)^4)/500 - (44*(3 + 5*x)^5)/625 + (2*(3 + 5*x)^6)/375", //
        45);
  }

  // {90}
  public void test1422() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^3)/(2 + 3*x), x]", //
        "(3305*x)/243 - (559*x^2)/162 - (2515*x^3)/81 + (50*x^4)/9 + (100*x^5)/3 - (49*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1423() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^3)/(2 + 3*x)^2, x]", //
        "(1271*x)/243 - (305*x^2)/54 - (800*x^3)/81 + (125*x^4)/9 + 49/(729*(2 + 3*x)) + (763*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1424() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^3)/(2 + 3*x)^3, x]", //
        "(895*x)/81 - (100*x^2)/9 + (500*x^3)/81 + 49/(1458*(2 + 3*x)^2) - 763/(729*(2 + 3*x)) - (4099*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1425() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^3)/(2 + 3*x)^4, x]", //
        "(-2800*x)/243 + (250*x^2)/81 + 49/(2187*(2 + 3*x)^3) - 763/(1458*(2 + 3*x)^2) + 4099/(729*(2 + 3*x)) + (8285*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1426() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^3)/(2 + 3*x)^5, x]", //
        "(500*x)/243 + 49/(2916*(2 + 3*x)^4) - 763/(2187*(2 + 3*x)^3) + 4099/(1458*(2 + 3*x)^2) - 8285/(729*(2 + 3*x)) - (3800*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1427() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^3)/(2 + 3*x)^6, x]", //
        "49/(3645*(2 + 3*x)^5) - 763/(2916*(2 + 3*x)^4) + 4099/(2187*(2 + 3*x)^3) - 8285/(1458*(2 + 3*x)^2) + 3800/(729*(2 + 3*x)) + (500*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1428() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^3)/(2 + 3*x)^7, x]", //
        "49/(4374*(2 + 3*x)^6) - 763/(3645*(2 + 3*x)^5) + 4099/(2916*(2 + 3*x)^4) - 8285/(2187*(2 + 3*x)^3) + 1900/(729*(2 + 3*x)^2) - 500/(729*(2 + 3*x))", //
        90);
  }

  // {90}
  public void test1429() {
    check( //
        "Integrate[((1 - 2*x)^2*(3 + 5*x)^3)/(2 + 3*x)^8, x]", //
        "7/(729*(2 + 3*x)^7) - 763/(4374*(2 + 3*x)^6) + 4099/(3645*(2 + 3*x)^5) - 8285/(2916*(2 + 3*x)^4) + 3800/(2187*(2 + 3*x)^3) - 250/(729*(2 + 3*x)^2)", //
        90);
  }

  // {90}
  public void test1430() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^7)/(3 + 5*x), x]", //
        "(83333293*x)/1953125 + (80555569*x^2)/781250 + (1327159*x^3)/78125 - (20577159*x^4)/62500 - (7315947*x^5)/15625 + (130383*x^6)/1250 + (672867*x^7)/875 + (16767*x^8)/25 + (972*x^9)/5 + (121*Log[3 + 5*x])/9765625", //
        90);
  }

  // {90}
  public void test1431() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^6)/(3 + 5*x), x]", //
        "(8333293*x)/390625 + (5555569*x^2)/156250 - (422841*x^3)/15625 - (1677159*x^4)/12500 - (228447*x^5)/3125 + (35883*x^6)/250 + (34992*x^7)/175 + (729*x^8)/10 + (121*Log[3 + 5*x])/1953125", //
        90);
  }

  // {90}
  public void test1432() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^5)/(3 + 5*x), x]", //
        "(833293*x)/78125 + (305569*x^2)/31250 - (72841*x^3)/3125 - (102159*x^4)/2500 + (7803*x^5)/625 + (1404*x^6)/25 + (972*x^7)/35 + (121*Log[3 + 5*x])/390625", //
        90);
  }

  // {90}
  public void test1433() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^4)/(3 + 5*x), x]", //
        "(83293*x)/15625 + (5569*x^2)/6250 - (7841*x^3)/625 - (3159*x^4)/500 + (1728*x^5)/125 + (54*x^6)/5 + (121*Log[3 + 5*x])/78125", //
        90);
  }

  // {90}
  public void test1434() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^3)/(3 + 5*x), x]", //
        "(8293*x)/3125 - (1931*x^2)/1250 - (591*x^3)/125 + (54*x^4)/25 + (108*x^5)/25 + (121*Log[3 + 5*x])/15625", //
        90);
  }

  // {90}
  public void test1435() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^2)/(3 + 5*x), x]", //
        "(793*x)/625 - (431*x^2)/250 - (16*x^3)/25 + (9*x^4)/5 + (121*Log[3 + 5*x])/3125", //
        90);
  }

  // {78}
  public void test1436() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x))/(3 + 5*x), x]", //
        "(43*x)/125 - (28*x^2)/25 + (4*x^3)/5 + (121*Log[3 + 5*x])/625", //
        78);
  }

  // {45}
  public void test1437() {
    check( //
        "Integrate[(1 - 2*x)^2/(3 + 5*x), x]", //
        "(-32*x)/25 + (2*x^2)/5 + (121*Log[3 + 5*x])/125", //
        45);
  }

  // {84}
  public void test1438() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)*(3 + 5*x)), x]", //
        "(4*x)/15 - (49*Log[2 + 3*x])/9 + (121*Log[3 + 5*x])/25", //
        84);
  }

  // {90}
  public void test1439() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^2*(3 + 5*x)), x]", //
        "49/(9*(2 + 3*x)) - (217*Log[2 + 3*x])/9 + (121*Log[3 + 5*x])/5", //
        90);
  }

  // {90}
  public void test1440() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^3*(3 + 5*x)), x]", //
        "49/(18*(2 + 3*x)^2) + 217/(9*(2 + 3*x)) - 121*Log[2 + 3*x] + 121*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1441() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^4*(3 + 5*x)), x]", //
        "49/(27*(2 + 3*x)^3) + 217/(18*(2 + 3*x)^2) + 121/(2 + 3*x) - 605*Log[2 + 3*x] + 605*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1442() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^5*(3 + 5*x)), x]", //
        "49/(36*(2 + 3*x)^4) + 217/(27*(2 + 3*x)^3) + 121/(2*(2 + 3*x)^2) + 605/(2 + 3*x) - 3025*Log[2 + 3*x] + 3025*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1443() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^6*(3 + 5*x)), x]", //
        "49/(45*(2 + 3*x)^5) + 217/(36*(2 + 3*x)^4) + 121/(3*(2 + 3*x)^3) + 605/(2*(2 + 3*x)^2) + 3025/(2 + 3*x) - 15125*Log[2 + 3*x] + 15125*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1444() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^7*(3 + 5*x)), x]", //
        "49/(54*(2 + 3*x)^6) + 217/(45*(2 + 3*x)^5) + 121/(4*(2 + 3*x)^4) + 605/(3*(2 + 3*x)^3) + 3025/(2*(2 + 3*x)^2) + 15125/(2 + 3*x) - 75625*Log[2 + 3*x] + 75625*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1445() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^8*(3 + 5*x)), x]", //
        "7/(9*(2 + 3*x)^7) + 217/(54*(2 + 3*x)^6) + 121/(5*(2 + 3*x)^5) + 605/(4*(2 + 3*x)^4) + 3025/(3*(2 + 3*x)^3) + 15125/(2*(2 + 3*x)^2) + 75625/(2 + 3*x) - 378125*Log[2 + 3*x] + 378125*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1446() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^7)/(3 + 5*x)^2, x]", //
        "(27776932*x)/1953125 + (17592879*x^2)/781250 - (1512378*x^3)/78125 - (213867*x^4)/2500 - (656424*x^5)/15625 + (116397*x^6)/1250 + (107892*x^7)/875 + (2187*x^8)/50 - 121/(9765625*(3 + 5*x)) + (2497*Log[3 + 5*x])/9765625", //
        90);
  }

  // {90}
  public void test1447() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^6)/(3 + 5*x)^2, x]", //
        "(2777053*x)/390625 + (463086*x^2)/78125 - (48771*x^3)/3125 - (157599*x^4)/6250 + (28917*x^5)/3125 + (4374*x^6)/125 + (2916*x^7)/175 - 121/(1953125*(3 + 5*x)) + (2134*Log[3 + 5*x])/1953125", //
        90);
  }

  // {90}
  public void test1448() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^5)/(3 + 5*x)^2, x]", //
        "(277174*x)/78125 + (1893*x^2)/6250 - (25332*x^3)/3125 - (8721*x^4)/2500 + (5508*x^5)/625 + (162*x^6)/25 - 121/(390625*(3 + 5*x)) + (1771*Log[3 + 5*x])/390625", //
        90);
  }

  // {90}
  public void test1449() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^4)/(3 + 5*x)^2, x]", //
        "(5459*x)/3125 - (3621*x^2)/3125 - (1809*x^3)/625 + (189*x^4)/125 + (324*x^5)/125 - 121/(78125*(3 + 5*x)) + (1408*Log[3 + 5*x])/78125", //
        90);
  }

  // {90}
  public void test1450() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^3)/(3 + 5*x)^2, x]", //
        "(2416*x)/3125 - (1449*x^2)/1250 - (36*x^3)/125 + (27*x^4)/25 - 121/(15625*(3 + 5*x)) + (209*Log[3 + 5*x])/3125", //
        90);
  }

  // {90}
  public void test1451() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^2)/(3 + 5*x)^2, x]", //
        "(37*x)/625 - (78*x^2)/125 + (12*x^3)/25 - 121/(3125*(3 + 5*x)) + (682*Log[3 + 5*x])/3125", //
        90);
  }

  // {78}
  public void test1452() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x))/(3 + 5*x)^2, x]", //
        "(-92*x)/125 + (6*x^2)/25 - 121/(625*(3 + 5*x)) + (319*Log[3 + 5*x])/625", //
        78);
  }

  // {45}
  public void test1453() {
    check( //
        "Integrate[(1 - 2*x)^2/(3 + 5*x)^2, x]", //
        "(4*x)/25 - 121/(125*(3 + 5*x)) - (44*Log[3 + 5*x])/125", //
        45);
  }

  // {90}
  public void test1454() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)*(3 + 5*x)^2), x]", //
        "-121/(25*(3 + 5*x)) + (49*Log[2 + 3*x])/3 - (407*Log[3 + 5*x])/25", //
        90);
  }

  // {90}
  public void test1455() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^2*(3 + 5*x)^2), x]", //
        "-49/(3*(2 + 3*x)) - 121/(5*(3 + 5*x)) + 154*Log[2 + 3*x] - 154*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1456() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^3*(3 + 5*x)^2), x]", //
        "-49/(6*(2 + 3*x)^2) - 154/(2 + 3*x) - 121/(3 + 5*x) + 1133*Log[2 + 3*x] - 1133*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1457() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^4*(3 + 5*x)^2), x]", //
        "-49/(9*(2 + 3*x)^3) - 77/(2 + 3*x)^2 - 1133/(2 + 3*x) - 605/(3 + 5*x) + 7480*Log[2 + 3*x] - 7480*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1458() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^5*(3 + 5*x)^2), x]", //
        "-49/(12*(2 + 3*x)^4) - 154/(3*(2 + 3*x)^3) - 1133/(2*(2 + 3*x)^2) - 7480/(2 + 3*x) - 3025/(3 + 5*x) + 46475*Log[2 + 3*x] - 46475*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1459() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^6*(3 + 5*x)^2), x]", //
        "-49/(15*(2 + 3*x)^5) - 77/(2*(2 + 3*x)^4) - 1133/(3*(2 + 3*x)^3) - 3740/(2 + 3*x)^2 - 46475/(2 + 3*x) - 15125/(3 + 5*x) + 277750*Log[2 + 3*x] - 277750*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1460() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^7*(3 + 5*x)^2), x]", //
        "-49/(18*(2 + 3*x)^6) - 154/(5*(2 + 3*x)^5) - 1133/(4*(2 + 3*x)^4) - 7480/(3*(2 + 3*x)^3) - 46475/(2*(2 + 3*x)^2) - 277750/(2 + 3*x) - 75625/(3 + 5*x) + 1615625*Log[2 + 3*x] - 1615625*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1461() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^8*(3 + 5*x)^2), x]", //
        "-7/(3*(2 + 3*x)^7) - 77/(3*(2 + 3*x)^6) - 1133/(5*(2 + 3*x)^5) - 1870/(2 + 3*x)^4 - 46475/(3*(2 + 3*x)^3) - 138875/(2 + 3*x)^2 - 1615625/(2 + 3*x) - 378125/(3 + 5*x) + 9212500*Log[2 + 3*x] - 9212500*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1462() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^8)/(3 + 5*x)^3, x]", //
        "(92582457*x)/9765625 + (55559043*x^2)/3906250 - (5350194*x^3)/390625 - (1700919*x^4)/31250 - (74601*x^5)/3125 + (376407*x^6)/6250 + (332424*x^7)/4375 + (6561*x^8)/250 - 121/(97656250*(3 + 5*x)^2) - 572/(9765625*(3 + 5*x)) + (5888*Log[3 + 5*x])/9765625", //
        90);
  }

  // {90}
  public void test1463() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^7)/(3 + 5*x)^3, x]", //
        "(9251661*x)/1953125 + (1390203*x^2)/390625 - (162612*x^3)/15625 - (193833*x^4)/12500 + (104247*x^5)/15625 + (13608*x^6)/625 + (8748*x^7)/875 - 121/(19531250*(3 + 5*x)^2) - 2497/(9765625*(3 + 5*x)) + (21949*Log[3 + 5*x])/9765625", //
        90);
  }

  // {90}
  public void test1464() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^6)/(3 + 5*x)^3, x]", //
        "(920502*x)/390625 + (189*x^2)/15625 - (16299*x^3)/3125 - (23571*x^4)/12500 + (17496*x^5)/3125 + (486*x^6)/125 - 121/(3906250*(3 + 5*x)^2) - 2134/(1953125*(3 + 5*x)) + (15547*Log[3 + 5*x])/1953125", //
        90);
  }

  // {90}
  public void test1465() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^5)/(3 + 5*x)^3, x]", //
        "(17796*x)/15625 - (5301*x^2)/6250 - (5499*x^3)/3125 + (648*x^4)/625 + (972*x^5)/625 - 121/(781250*(3 + 5*x)^2) - 1771/(390625*(3 + 5*x)) + (10234*Log[3 + 5*x])/390625", //
        90);
  }

  // {90}
  public void test1466() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^4)/(3 + 5*x)^3, x]", //
        "(1419*x)/3125 - (4779*x^2)/6250 - (72*x^3)/625 + (81*x^4)/125 - 121/(156250*(3 + 5*x)^2) - 1408/(78125*(3 + 5*x)) + (1202*Log[3 + 5*x])/15625", //
        90);
  }

  // {90}
  public void test1467() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^3)/(3 + 5*x)^3, x]", //
        "(-153*x)/3125 - (216*x^2)/625 + (36*x^3)/125 - 121/(31250*(3 + 5*x)^2) - 209/(3125*(3 + 5*x)) + (23*Log[3 + 5*x])/125", //
        90);
  }

  // {90}
  public void test1468() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x)^2)/(3 + 5*x)^3, x]", //
        "(-264*x)/625 + (18*x^2)/125 - 121/(6250*(3 + 5*x)^2) - 682/(3125*(3 + 5*x)) + (829*Log[3 + 5*x])/3125", //
        90);
  }

  // {78}
  public void test1469() {
    check( //
        "Integrate[((1 - 2*x)^2*(2 + 3*x))/(3 + 5*x)^3, x]", //
        "(12*x)/125 - 121/(1250*(3 + 5*x)^2) - 319/(625*(3 + 5*x)) - (128*Log[3 + 5*x])/625", //
        78);
  }

  // {45}
  public void test1470() {
    check( //
        "Integrate[(1 - 2*x)^2/(3 + 5*x)^3, x]", //
        "-121/(250*(3 + 5*x)^2) + 44/(125*(3 + 5*x)) + (4*Log[3 + 5*x])/125", //
        45);
  }

  // {90}
  public void test1471() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)*(3 + 5*x)^3), x]", //
        "-121/(50*(3 + 5*x)^2) + 407/(25*(3 + 5*x)) - 49*Log[2 + 3*x] + 49*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1472() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^2*(3 + 5*x)^3), x]", //
        "49/(2 + 3*x) - 121/(10*(3 + 5*x)^2) + 154/(3 + 5*x) - 707*Log[2 + 3*x] + 707*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1473() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^3*(3 + 5*x)^3), x]", //
        "49/(2*(2 + 3*x)^2) + 707/(2 + 3*x) - 121/(2*(3 + 5*x)^2) + 1133/(3 + 5*x) - 6934*Log[2 + 3*x] + 6934*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1474() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^4*(3 + 5*x)^3), x]", //
        "49/(3*(2 + 3*x)^3) + 707/(2*(2 + 3*x)^2) + 6934/(2 + 3*x) - 605/(2*(3 + 5*x)^2) + 7480/(3 + 5*x) - 57110*Log[2 + 3*x] + 57110*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1475() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^5*(3 + 5*x)^3), x]", //
        "49/(4*(2 + 3*x)^4) + 707/(3*(2 + 3*x)^3) + 3467/(2 + 3*x)^2 + 57110/(2 + 3*x) - 3025/(2*(3 + 5*x)^2) + 46475/(3 + 5*x) - 424975*Log[2 + 3*x] + 424975*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1476() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^6*(3 + 5*x)^3), x]", //
        "49/(5*(2 + 3*x)^5) + 707/(4*(2 + 3*x)^4) + 6934/(3*(2 + 3*x)^3) + 28555/(2 + 3*x)^2 + 424975/(2 + 3*x) - 15125/(2*(3 + 5*x)^2) + 277750/(3 + 5*x) - 2958125*Log[2 + 3*x] + 2958125*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1477() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^7*(3 + 5*x)^3), x]", //
        "49/(6*(2 + 3*x)^6) + 707/(5*(2 + 3*x)^5) + 3467/(2*(2 + 3*x)^4) + 57110/(3*(2 + 3*x)^3) + 424975/(2*(2 + 3*x)^2) + 2958125/(2 + 3*x) - 75625/(2*(3 + 5*x)^2) + 1615625/(3 + 5*x) - 19637500*Log[2 + 3*x] + 19637500*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1478() {
    check( //
        "Integrate[(1 - 2*x)^2/((2 + 3*x)^8*(3 + 5*x)^3), x]", //
        "7/(2 + 3*x)^7 + 707/(6*(2 + 3*x)^6) + 6934/(5*(2 + 3*x)^5) + 28555/(2*(2 + 3*x)^4) + 424975/(3*(2 + 3*x)^3) + 2958125/(2*(2 + 3*x)^2) + 19637500/(2 + 3*x) - 378125/(2*(3 + 5*x)^2) + 9212500/(3 + 5*x) - 125825000*Log[2 + 3*x] + 125825000*Log[3 + 5*x]", //
        90);
  }

  // {78}
  public void test1479() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^8*(3 + 5*x), x]", //
        "(-343*(2 + 3*x)^9)/2187 + (2009*(2 + 3*x)^10)/2430 - (518*(2 + 3*x)^11)/891 + (107*(2 + 3*x)^12)/729 - (40*(2 + 3*x)^13)/3159", //
        78);
  }

  // {78}
  public void test1480() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^7*(3 + 5*x), x]", //
        "(-343*(2 + 3*x)^8)/1944 + (2009*(2 + 3*x)^9)/2187 - (259*(2 + 3*x)^10)/405 + (428*(2 + 3*x)^11)/2673 - (10*(2 + 3*x)^12)/729", //
        78);
  }

  // {78}
  public void test1481() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^6*(3 + 5*x), x]", //
        "(-49*(2 + 3*x)^7)/243 + (2009*(2 + 3*x)^8)/1944 - (518*(2 + 3*x)^9)/729 + (214*(2 + 3*x)^10)/1215 - (40*(2 + 3*x)^11)/2673", //
        78);
  }

  // {78}
  public void test1482() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^5*(3 + 5*x), x]", //
        "(-343*(2 + 3*x)^6)/1458 + (287*(2 + 3*x)^7)/243 - (259*(2 + 3*x)^8)/324 + (428*(2 + 3*x)^9)/2187 - (4*(2 + 3*x)^10)/243", //
        78);
  }

  // {78}
  public void test1483() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^4*(3 + 5*x), x]", //
        "(-343*(2 + 3*x)^5)/1215 + (2009*(2 + 3*x)^6)/1458 - (74*(2 + 3*x)^7)/81 + (107*(2 + 3*x)^8)/486 - (40*(2 + 3*x)^9)/2187", //
        78);
  }

  // {78}
  public void test1484() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^3*(3 + 5*x), x]", //
        "24*x + 2*x^2 - 86*x^3 - (117*x^4)/4 + (949*x^5)/5 + 111*x^6 - (1188*x^7)/7 - 135*x^8", //
        78);
  }

  // {78}
  public void test1485() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^2*(3 + 5*x), x]", //
        "12*x - 8*x^2 - 35*x^3 + (99*x^4)/4 + (326*x^5)/5 - 26*x^6 - (360*x^7)/7", //
        78);
  }

  // {78}
  public void test1486() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)*(3 + 5*x), x]", //
        "(-77*(1 - 2*x)^4)/32 + (17*(1 - 2*x)^5)/10 - (5*(1 - 2*x)^6)/16", //
        78);
  }

  // {45}
  public void test1487() {
    check( //
        "Integrate[(1 - 2*x)^3*(3 + 5*x), x]", //
        "(-11*(1 - 2*x)^4)/16 + (1 - 2*x)^5/4", //
        45);
  }

  // {78}
  public void test1488() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x))/(2 + 3*x), x]", //
        "(293*x)/81 - (161*x^2)/27 + (188*x^3)/27 - (10*x^4)/3 - (343*Log[2 + 3*x])/243", //
        78);
  }

  // {78}
  public void test1489() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x))/(2 + 3*x)^2, x]", //
        "(-286*x)/27 + (134*x^2)/27 - (40*x^3)/27 + 343/(243*(2 + 3*x)) + (2009*Log[2 + 3*x])/243", //
        78);
  }

  // {78}
  public void test1490() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x))/(2 + 3*x)^3, x]", //
        "(116*x)/27 - (20*x^2)/27 + 343/(486*(2 + 3*x)^2) - 2009/(243*(2 + 3*x)) - (518*Log[2 + 3*x])/81", //
        78);
  }

  // {78}
  public void test1491() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x))/(2 + 3*x)^4, x]", //
        "(-40*x)/81 + 343/(729*(2 + 3*x)^3) - 2009/(486*(2 + 3*x)^2) + 518/(81*(2 + 3*x)) + (428*Log[2 + 3*x])/243", //
        78);
  }

  // {78}
  public void test1492() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x))/(2 + 3*x)^5, x]", //
        "343/(972*(2 + 3*x)^4) - 2009/(729*(2 + 3*x)^3) + 259/(81*(2 + 3*x)^2) - 428/(243*(2 + 3*x)) - (40*Log[2 + 3*x])/243", //
        78);
  }

  // {79, 37}
  public void test1493() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x))/(2 + 3*x)^6, x]", //
        "(1 - 2*x)^4/(105*(2 + 3*x)^5) - (173*(1 - 2*x)^4)/(2940*(2 + 3*x)^4)", //
        79,
        37);
  }

  // {78}
  public void test1494() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x))/(2 + 3*x)^8, x]", //
        "49/(243*(2 + 3*x)^7) - 2009/(1458*(2 + 3*x)^6) + 518/(405*(2 + 3*x)^5) - 107/(243*(2 + 3*x)^4) + 40/(729*(2 + 3*x)^3)", //
        78);
  }

  // {90}
  public void test1495() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^8*(3 + 5*x)^2, x]", //
        "(343*(2 + 3*x)^9)/6561 - (1862*(2 + 3*x)^10)/3645 + (11599*(2 + 3*x)^11)/8019 - (4099*(2 + 3*x)^12)/4374 + (2180*(2 + 3*x)^13)/9477 - (100*(2 + 3*x)^14)/5103", //
        90);
  }

  // {90}
  public void test1496() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^7*(3 + 5*x)^2, x]", //
        "(343*(2 + 3*x)^8)/5832 - (3724*(2 + 3*x)^9)/6561 + (11599*(2 + 3*x)^10)/7290 - (8198*(2 + 3*x)^11)/8019 + (545*(2 + 3*x)^12)/2187 - (200*(2 + 3*x)^13)/9477", //
        90);
  }

  // {90}
  public void test1497() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^6*(3 + 5*x)^2, x]", //
        "(49*(2 + 3*x)^7)/729 - (931*(2 + 3*x)^8)/1458 + (11599*(2 + 3*x)^9)/6561 - (4099*(2 + 3*x)^10)/3645 + (2180*(2 + 3*x)^11)/8019 - (50*(2 + 3*x)^12)/2187", //
        90);
  }

  // {90}
  public void test1498() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^5*(3 + 5*x)^2, x]", //
        "(343*(2 + 3*x)^6)/4374 - (532*(2 + 3*x)^7)/729 + (11599*(2 + 3*x)^8)/5832 - (8198*(2 + 3*x)^9)/6561 + (218*(2 + 3*x)^10)/729 - (200*(2 + 3*x)^11)/8019", //
        90);
  }

  // {90}
  public void test1499() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^4*(3 + 5*x)^2, x]", //
        "(343*(2 + 3*x)^5)/3645 - (1862*(2 + 3*x)^6)/2187 + (1657*(2 + 3*x)^7)/729 - (4099*(2 + 3*x)^8)/2916 + (2180*(2 + 3*x)^9)/6561 - (20*(2 + 3*x)^10)/729", //
        90);
  }

  // {90}
  public void test1500() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^3*(3 + 5*x)^2, x]", //
        "72*x + 66*x^2 - (754*x^3)/3 - (1641*x^4)/4 + (2262*x^5)/5 + (6743*x^6)/6 - (234*x^7)/7 - (2295*x^8)/2 - 600*x^9", //
        90);
  }

  // {90}
  public void test1501() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^2*(3 + 5*x)^2, x]", //
        "36*x + 6*x^2 - (395*x^3)/3 - 57*x^4 + (1473*x^5)/5 + (581*x^6)/3 - (1860*x^7)/7 - 225*x^8", //
        90);
  }

  // {78}
  public void test1502() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)*(3 + 5*x)^2, x]", //
        "18*x - (21*x^2)/2 - (166*x^3)/3 + (135*x^4)/4 + (534*x^5)/5 - (110*x^6)/3 - (600*x^7)/7", //
        78);
  }

  // {45}
  public void test1503() {
    check( //
        "Integrate[(1 - 2*x)^3*(3 + 5*x)^2, x]", //
        "(-121*(1 - 2*x)^4)/32 + (11*(1 - 2*x)^5)/4 - (25*(1 - 2*x)^6)/48", //
        45);
  }

  // {90}
  public void test1504() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^2)/(2 + 3*x), x]", //
        "(922*x)/243 - (1433*x^2)/162 + (82*x^3)/81 + (145*x^4)/9 - (40*x^5)/3 + (343*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1505() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^2)/(2 + 3*x)^2, x]", //
        "(2323*x)/243 - (313*x^2)/27 + (980*x^3)/81 - (50*x^4)/9 - 343/(729*(2 + 3*x)) - (3724*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1506() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^2)/(2 + 3*x)^3, x]", //
        "(-1546*x)/81 + (230*x^2)/27 - (200*x^3)/81 - 343/(1458*(2 + 3*x)^2) + 3724/(729*(2 + 3*x)) + (11599*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1507() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^2)/(2 + 3*x)^4, x]", //
        "(1780*x)/243 - (100*x^2)/81 - 343/(2187*(2 + 3*x)^3) + 1862/(729*(2 + 3*x)^2) - 11599/(729*(2 + 3*x)) - (8198*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1508() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^2)/(2 + 3*x)^5, x]", //
        "(-200*x)/243 - 343/(2916*(2 + 3*x)^4) + 3724/(2187*(2 + 3*x)^3) - 11599/(1458*(2 + 3*x)^2) + 8198/(729*(2 + 3*x)) + (2180*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1509() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^2)/(2 + 3*x)^6, x]", //
        "-343/(3645*(2 + 3*x)^5) + 931/(729*(2 + 3*x)^4) - 11599/(2187*(2 + 3*x)^3) + 4099/(729*(2 + 3*x)^2) - 2180/(729*(2 + 3*x)) - (200*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1510() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^2)/(2 + 3*x)^7, x]", //
        "-343/(4374*(2 + 3*x)^6) + 3724/(3645*(2 + 3*x)^5) - 11599/(2916*(2 + 3*x)^4) + 8198/(2187*(2 + 3*x)^3) - 1090/(729*(2 + 3*x)^2) + 200/(729*(2 + 3*x))", //
        90);
  }

  // {90}
  public void test1511() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^2)/(2 + 3*x)^8, x]", //
        "-49/(729*(2 + 3*x)^7) + 1862/(2187*(2 + 3*x)^6) - 11599/(3645*(2 + 3*x)^5) + 4099/(1458*(2 + 3*x)^4) - 2180/(2187*(2 + 3*x)^3) + 100/(729*(2 + 3*x)^2)", //
        90);
  }

  // {90}
  public void test1512() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^7*(3 + 5*x)^3, x]", //
        "(-343*(2 + 3*x)^8)/17496 + (1813*(2 + 3*x)^9)/6561 - (10073*(2 + 3*x)^10)/7290 + (66193*(2 + 3*x)^11)/24057 - (7195*(2 + 3*x)^12)/4374 + (3700*(2 + 3*x)^13)/9477 - (500*(2 + 3*x)^14)/15309", //
        90);
  }

  // {90}
  public void test1513() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^6*(3 + 5*x)^3, x]", //
        "(-49*(2 + 3*x)^7)/2187 + (1813*(2 + 3*x)^8)/5832 - (10073*(2 + 3*x)^9)/6561 + (66193*(2 + 3*x)^10)/21870 - (14390*(2 + 3*x)^11)/8019 + (925*(2 + 3*x)^12)/2187 - (1000*(2 + 3*x)^13)/28431", //
        90);
  }

  // {90}
  public void test1514() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^5*(3 + 5*x)^3, x]", //
        "(-343*(2 + 3*x)^6)/13122 + (259*(2 + 3*x)^7)/729 - (10073*(2 + 3*x)^8)/5832 + (66193*(2 + 3*x)^9)/19683 - (1439*(2 + 3*x)^10)/729 + (3700*(2 + 3*x)^11)/8019 - (250*(2 + 3*x)^12)/6561", //
        90);
  }

  // {90}
  public void test1515() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^4*(3 + 5*x)^3, x]", //
        "432*x + 1080*x^2 - 312*x^3 - 5548*x^4 - (28917*x^5)/5 + (19607*x^6)/2 + 22949*x^7 + (41619*x^8)/8 - 23370*x^9 - 24030*x^10 - (81000*x^11)/11", //
        90);
  }

  // {90}
  public void test1516() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^3*(3 + 5*x)^3, x]", //
        "216*x + 378*x^2 - 534*x^3 - (8693*x^4)/4 - (1419*x^5)/5 + (10513*x^6)/2 + (33013*x^7)/7 - (14355*x^8)/4 - 6900*x^9 - 2700*x^10", //
        90);
  }

  // {90}
  public void test1517() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)^2*(3 + 5*x)^3, x]", //
        "108*x + 108*x^2 - 375*x^3 - (2659*x^4)/4 + (3279*x^5)/5 + (3617*x^6)/2 + (230*x^7)/7 - (3675*x^8)/2 - 1000*x^9", //
        90);
  }

  // {78}
  public void test1518() {
    check( //
        "Integrate[(1 - 2*x)^3*(2 + 3*x)*(3 + 5*x)^3, x]", //
        "54*x + (27*x^2)/2 - 201*x^3 - (425*x^4)/4 + (2277*x^5)/5 + 335*x^6 - (2900*x^7)/7 - 375*x^8", //
        78);
  }

  // {45}
  public void test1519() {
    check( //
        "Integrate[(1 - 2*x)^3*(3 + 5*x)^3, x]", //
        "27*x - (27*x^2)/2 - 87*x^3 + (179*x^4)/4 + 174*x^5 - 50*x^6 - (1000*x^7)/7", //
        45);
  }

  // {90}
  public void test1520() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^3)/(2 + 3*x), x]", //
        "(10013*x)/729 - (8287*x^2)/486 - (6427*x^3)/243 + (2815*x^4)/54 + (220*x^5)/9 - (500*x^6)/9 - (343*Log[2 + 3*x])/2187", //
        90);
  }

  // {90}
  public void test1521() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^3)/(2 + 3*x)^2, x]", //
        "(2287*x)/729 - (5287*x^2)/486 - (190*x^3)/81 + (775*x^4)/27 - (200*x^5)/9 + 343/(2187*(2 + 3*x)) + (1813*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1522() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^3)/(2 + 3*x)^3, x]", //
        "(16253*x)/729 - (1795*x^2)/81 + (1700*x^3)/81 - (250*x^4)/27 + 343/(4374*(2 + 3*x)^2) - 1813/(729*(2 + 3*x)) - (10073*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1523() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^3)/(2 + 3*x)^4, x]", //
        "(-24970*x)/729 + (3550*x^2)/243 - (1000*x^3)/243 + 343/(6561*(2 + 3*x)^3) - 1813/(1458*(2 + 3*x)^2) + 10073/(729*(2 + 3*x)) + (66193*Log[2 + 3*x])/2187", //
        90);
  }

  // {90}
  public void test1524() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^3)/(2 + 3*x)^5, x]", //
        "(9100*x)/729 - (500*x^2)/243 + 343/(8748*(2 + 3*x)^4) - 1813/(2187*(2 + 3*x)^3) + 10073/(1458*(2 + 3*x)^2) - 66193/(2187*(2 + 3*x)) - (14390*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1525() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^3)/(2 + 3*x)^6, x]", //
        "(-1000*x)/729 + 343/(10935*(2 + 3*x)^5) - 1813/(2916*(2 + 3*x)^4) + 10073/(2187*(2 + 3*x)^3) - 66193/(4374*(2 + 3*x)^2) + 14390/(729*(2 + 3*x)) + (3700*Log[2 + 3*x])/729", //
        90);
  }

  // {90}
  public void test1526() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^3)/(2 + 3*x)^7, x]", //
        "343/(13122*(2 + 3*x)^6) - 1813/(3645*(2 + 3*x)^5) + 10073/(2916*(2 + 3*x)^4) - 66193/(6561*(2 + 3*x)^3) + 7195/(729*(2 + 3*x)^2) - 3700/(729*(2 + 3*x)) - (1000*Log[2 + 3*x])/2187", //
        90);
  }

  // {90}
  public void test1527() {
    check( //
        "Integrate[((1 - 2*x)^3*(3 + 5*x)^3)/(2 + 3*x)^8, x]", //
        "49/(2187*(2 + 3*x)^7) - 1813/(4374*(2 + 3*x)^6) + 10073/(3645*(2 + 3*x)^5) - 66193/(8748*(2 + 3*x)^4) + 14390/(2187*(2 + 3*x)^3) - 1850/(729*(2 + 3*x)^2) + 1000/(2187*(2 + 3*x))", //
        90);
  }

  // {90}
  public void test1528() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^6)/(3 + 5*x), x]", //
        "(41666223*x)/1953125 + (11111259*x^2)/781250 - (17453753*x^3)/234375 - (5848749*x^4)/62500 + (2212083*x^5)/15625 + (331713*x^6)/1250 - (40338*x^7)/875 - (13851*x^8)/50 - (648*x^9)/5 + (1331*Log[3 + 5*x])/9765625", //
        90);
  }

  // {90}
  public void test1529() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^5)/(3 + 5*x), x]", //
        "(4166223*x)/390625 - (138741*x^2)/156250 - (1703753*x^3)/46875 - (73749*x^4)/12500 + (243333*x^5)/3125 + (4419*x^6)/125 - (11988*x^7)/175 - (243*x^8)/5 + (1331*Log[3 + 5*x])/1953125", //
        90);
  }

  // {90}
  public void test1530() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^4)/(3 + 5*x), x]", //
        "(416223*x)/78125 - (138741*x^2)/31250 - (128753*x^3)/9375 + (31251*x^4)/2500 + (14958*x^5)/625 - (306*x^6)/25 - (648*x^7)/35 + (1331*Log[3 + 5*x])/390625", //
        90);
  }

  // {90}
  public void test1531() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^3)/(3 + 5*x), x]", //
        "(41223*x)/15625 - (26241*x^2)/6250 - (5003*x^3)/1875 + (2313*x^4)/250 + (108*x^5)/125 - (36*x^6)/5 + (1331*Log[3 + 5*x])/78125", //
        90);
  }

  // {90}
  public void test1532() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^2)/(3 + 5*x), x]", //
        "(3723*x)/3125 - (3741*x^2)/1250 + (622*x^3)/375 + (69*x^4)/25 - (72*x^5)/25 + (1331*Log[3 + 5*x])/15625", //
        90);
  }

  // {78}
  public void test1533() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x))/(3 + 5*x), x]", //
        "(-27*x)/625 - (183*x^2)/125 + (172*x^3)/75 - (6*x^4)/5 + (1331*Log[3 + 5*x])/3125", //
        78);
  }

  // {45}
  public void test1534() {
    check( //
        "Integrate[(1 - 2*x)^3/(3 + 5*x), x]", //
        "(-402*x)/125 + (42*x^2)/25 - (8*x^3)/15 + (1331*Log[3 + 5*x])/625", //
        45);
  }

  // {84}
  public void test1535() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)*(3 + 5*x)), x]", //
        "(332*x)/225 - (4*x^2)/15 - (343*Log[2 + 3*x])/27 + (1331*Log[3 + 5*x])/125", //
        84);
  }

  // {90}
  public void test1536() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^2*(3 + 5*x)), x]", //
        "(-8*x)/45 + 343/(27*(2 + 3*x)) - (1421*Log[2 + 3*x])/27 + (1331*Log[3 + 5*x])/25", //
        90);
  }

  // {90}
  public void test1537() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^3*(3 + 5*x)), x]", //
        "343/(54*(2 + 3*x)^2) + 1421/(27*(2 + 3*x)) - (7189*Log[2 + 3*x])/27 + (1331*Log[3 + 5*x])/5", //
        90);
  }

  // {90}
  public void test1538() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^4*(3 + 5*x)), x]", //
        "343/(81*(2 + 3*x)^3) + 1421/(54*(2 + 3*x)^2) + 7189/(27*(2 + 3*x)) - 1331*Log[2 + 3*x] + 1331*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1539() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^5*(3 + 5*x)), x]", //
        "343/(108*(2 + 3*x)^4) + 1421/(81*(2 + 3*x)^3) + 7189/(54*(2 + 3*x)^2) + 1331/(2 + 3*x) - 6655*Log[2 + 3*x] + 6655*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1540() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^6*(3 + 5*x)), x]", //
        "343/(135*(2 + 3*x)^5) + 1421/(108*(2 + 3*x)^4) + 7189/(81*(2 + 3*x)^3) + 1331/(2*(2 + 3*x)^2) + 6655/(2 + 3*x) - 33275*Log[2 + 3*x] + 33275*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1541() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^7*(3 + 5*x)), x]", //
        "343/(162*(2 + 3*x)^6) + 1421/(135*(2 + 3*x)^5) + 7189/(108*(2 + 3*x)^4) + 1331/(3*(2 + 3*x)^3) + 6655/(2*(2 + 3*x)^2) + 33275/(2 + 3*x) - 166375*Log[2 + 3*x] + 166375*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1542() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^8*(3 + 5*x)), x]", //
        "49/(27*(2 + 3*x)^7) + 1421/(162*(2 + 3*x)^6) + 7189/(135*(2 + 3*x)^5) + 1331/(4*(2 + 3*x)^4) + 6655/(3*(2 + 3*x)^3) + 33275/(2*(2 + 3*x)^2) + 166375/(2 + 3*x) - 831875*Log[2 + 3*x] + 831875*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1543() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^6)/(3 + 5*x)^2, x]", //
        "(13880997*x)/1953125 - (461623*x^2)/390625 - (1836723*x^3)/78125 - (5643*x^4)/3125 + (774981*x^5)/15625 + (12231*x^6)/625 - (37908*x^7)/875 - (729*x^8)/25 - 1331/(9765625*(3 + 5*x)) + (23232*Log[3 + 5*x])/9765625", //
        90);
  }

  // {90}
  public void test1544() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^5)/(3 + 5*x)^2, x]", //
        "(1382328*x)/390625 - (507023*x^2)/156250 - (26594*x^3)/3125 + (108387*x^4)/12500 + (44982*x^5)/3125 - (1026*x^6)/125 - (1944*x^7)/175 - 1331/(1953125*(3 + 5*x)) + (19239*Log[3 + 5*x])/1953125", //
        90);
  }

  // {90}
  public void test1545() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^4)/(3 + 5*x)^2, x]", //
        "(133659*x)/78125 - (1816*x^2)/625 - (4217*x^3)/3125 + (7317*x^4)/1250 + (108*x^5)/625 - (108*x^6)/25 - 1331/(390625*(3 + 5*x)) + (15246*Log[3 + 5*x])/390625", //
        90);
  }

  // {90}
  public void test1546() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^3)/(3 + 5*x)^2, x]", //
        "(1998*x)/3125 - (12077*x^2)/6250 + (786*x^3)/625 + (189*x^4)/125 - (216*x^5)/125 - 1331/(78125*(3 + 5*x)) + (11253*Log[3 + 5*x])/78125", //
        90);
  }

  // {90}
  public void test1547() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^2)/(3 + 5*x)^2, x]", //
        "(-1179*x)/3125 - (427*x^2)/625 + (164*x^3)/125 - (18*x^4)/25 - 1331/(15625*(3 + 5*x)) + (1452*Log[3 + 5*x])/3125", //
        90);
  }

  // {78}
  public void test1548() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x))/(3 + 5*x)^2, x]", //
        "(-1098*x)/625 + (122*x^2)/125 - (8*x^3)/25 - 1331/(3125*(3 + 5*x)) + (3267*Log[3 + 5*x])/3125", //
        78);
  }

  // {45}
  public void test1549() {
    check( //
        "Integrate[(1 - 2*x)^3/(3 + 5*x)^2, x]", //
        "(108*x)/125 - (4*x^2)/25 - 1331/(625*(3 + 5*x)) - (726*Log[3 + 5*x])/625", //
        45);
  }

  // {90}
  public void test1550() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)*(3 + 5*x)^2), x]", //
        "(-8*x)/75 - 1331/(125*(3 + 5*x)) + (343*Log[2 + 3*x])/9 - (4719*Log[3 + 5*x])/125", //
        90);
  }

  // {90}
  public void test1551() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^2*(3 + 5*x)^2), x]", //
        "-343/(9*(2 + 3*x)) - 1331/(25*(3 + 5*x)) + (3136*Log[2 + 3*x])/9 - (8712*Log[3 + 5*x])/25", //
        90);
  }

  // {90}
  public void test1552() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^3*(3 + 5*x)^2), x]", //
        "-343/(18*(2 + 3*x)^2) - 3136/(9*(2 + 3*x)) - 1331/(5*(3 + 5*x)) + 2541*Log[2 + 3*x] - 2541*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1553() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^4*(3 + 5*x)^2), x]", //
        "-343/(27*(2 + 3*x)^3) - 1568/(9*(2 + 3*x)^2) - 2541/(2 + 3*x) - 1331/(3 + 5*x) + 16698*Log[2 + 3*x] - 16698*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1554() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^5*(3 + 5*x)^2), x]", //
        "-343/(36*(2 + 3*x)^4) - 3136/(27*(2 + 3*x)^3) - 2541/(2*(2 + 3*x)^2) - 16698/(2 + 3*x) - 6655/(3 + 5*x) + 103455*Log[2 + 3*x] - 103455*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1555() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^6*(3 + 5*x)^2), x]", //
        "-343/(45*(2 + 3*x)^5) - 784/(9*(2 + 3*x)^4) - 847/(2 + 3*x)^3 - 8349/(2 + 3*x)^2 - 103455/(2 + 3*x) - 33275/(3 + 5*x) + 617100*Log[2 + 3*x] - 617100*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1556() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^7*(3 + 5*x)^2), x]", //
        "-343/(54*(2 + 3*x)^6) - 3136/(45*(2 + 3*x)^5) - 2541/(4*(2 + 3*x)^4) - 5566/(2 + 3*x)^3 - 103455/(2*(2 + 3*x)^2) - 617100/(2 + 3*x) - 166375/(3 + 5*x) + 3584625*Log[2 + 3*x] - 3584625*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1557() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^8*(3 + 5*x)^2), x]", //
        "-49/(9*(2 + 3*x)^7) - 1568/(27*(2 + 3*x)^6) - 2541/(5*(2 + 3*x)^5) - 8349/(2*(2 + 3*x)^4) - 34485/(2 + 3*x)^3 - 308550/(2 + 3*x)^2 - 3584625/(2 + 3*x) - 831875/(3 + 5*x) + 20418750*Log[2 + 3*x] - 20418750*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1558() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^7)/(3 + 5*x)^3, x]", //
        "(46214407*x)/9765625 - (2300646*x^2)/1953125 - (5918904*x^3)/390625 + (6507*x^4)/62500 + (491913*x^5)/15625 + (33291*x^6)/3125 - (119556*x^7)/4375 - (2187*x^8)/125 - 1331/(97656250*(3 + 5*x)^2) - 1089/(1953125*(3 + 5*x)) + (47289*Log[3 + 5*x])/9765625", //
        90);
  }

  // {90}
  public void test1559() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^6)/(3 + 5*x)^3, x]", //
        "(4571416*x)/1953125 - (915777*x^2)/390625 - (81747*x^3)/15625 + (74223*x^4)/12500 + (134622*x^5)/15625 - (3402*x^6)/625 - (5832*x^7)/875 - 1331/(19531250*(3 + 5*x)^2) - 23232/(9765625*(3 + 5*x)) + (166749*Log[3 + 5*x])/9765625", //
        90);
  }

  // {90}
  public void test1560() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^5)/(3 + 5*x)^3, x]", //
        "(424432*x)/390625 - (62097*x^2)/31250 - (393*x^3)/625 + (22977*x^4)/6250 - (324*x^5)/3125 - (324*x^6)/125 - 1331/(3906250*(3 + 5*x)^2) - 19239/(1953125*(3 + 5*x)) + (109032*Log[3 + 5*x])/1953125", //
        90);
  }

  // {90}
  public void test1561() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^4)/(3 + 5*x)^3, x]", //
        "(4691*x)/15625 - (7617*x^2)/6250 + (2826*x^3)/3125 + (513*x^4)/625 - (648*x^5)/625 - 1331/(781250*(3 + 5*x)^2) - 15246/(390625*(3 + 5*x)) + (63294*Log[3 + 5*x])/390625", //
        90);
  }

  // {90}
  public void test1562() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^3)/(3 + 5*x)^3, x]", //
        "(-1303*x)/3125 - (927*x^2)/3125 + (468*x^3)/625 - (54*x^4)/125 - 1331/(156250*(3 + 5*x)^2) - 11253/(78125*(3 + 5*x)) + (5907*Log[3 + 5*x])/15625", //
        90);
  }

  // {90}
  public void test1563() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x)^2)/(3 + 5*x)^3, x]", //
        "(-2978*x)/3125 + (354*x^2)/625 - (24*x^3)/125 - 1331/(31250*(3 + 5*x)^2) - 1452/(3125*(3 + 5*x)) + (1551*Log[3 + 5*x])/3125", //
        90);
  }

  // {78}
  public void test1564() {
    check( //
        "Integrate[((1 - 2*x)^3*(2 + 3*x))/(3 + 5*x)^3, x]", //
        "(316*x)/625 - (12*x^2)/125 - 1331/(6250*(3 + 5*x)^2) - 3267/(3125*(3 + 5*x)) - (2046*Log[3 + 5*x])/3125", //
        78);
  }

  // {45}
  public void test1565() {
    check( //
        "Integrate[(1 - 2*x)^3/(3 + 5*x)^3, x]", //
        "(-8*x)/125 - 1331/(1250*(3 + 5*x)^2) + 726/(625*(3 + 5*x)) + (132*Log[3 + 5*x])/625", //
        45);
  }

  // {90}
  public void test1566() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)*(3 + 5*x)^3), x]", //
        "-1331/(250*(3 + 5*x)^2) + 4719/(125*(3 + 5*x)) - (343*Log[2 + 3*x])/3 + (14289*Log[3 + 5*x])/125", //
        90);
  }

  // {90}
  public void test1567() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^2*(3 + 5*x)^3), x]", //
        "343/(3*(2 + 3*x)) - 1331/(50*(3 + 5*x)^2) + 8712/(25*(3 + 5*x)) - 1617*Log[2 + 3*x] + 1617*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1568() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^3*(3 + 5*x)^3), x]", //
        "343/(6*(2 + 3*x)^2) + 1617/(2 + 3*x) - 1331/(10*(3 + 5*x)^2) + 2541/(3 + 5*x) - 15708*Log[2 + 3*x] + 15708*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1569() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^4*(3 + 5*x)^3), x]", //
        "343/(9*(2 + 3*x)^3) + 1617/(2*(2 + 3*x)^2) + 15708/(2 + 3*x) - 1331/(2*(3 + 5*x)^2) + 16698/(3 + 5*x) - 128634*Log[2 + 3*x] + 128634*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1570() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^5*(3 + 5*x)^3), x]", //
        "343/(12*(2 + 3*x)^4) + 539/(2 + 3*x)^3 + 7854/(2 + 3*x)^2 + 128634/(2 + 3*x) - 6655/(2*(3 + 5*x)^2) + 103455/(3 + 5*x) - 953535*Log[2 + 3*x] + 953535*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1571() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^6*(3 + 5*x)^3), x]", //
        "343/(15*(2 + 3*x)^5) + 1617/(4*(2 + 3*x)^4) + 5236/(2 + 3*x)^3 + 64317/(2 + 3*x)^2 + 953535/(2 + 3*x) - 33275/(2*(3 + 5*x)^2) + 617100/(3 + 5*x) - 6618975*Log[2 + 3*x] + 6618975*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1572() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^7*(3 + 5*x)^3), x]", //
        "343/(18*(2 + 3*x)^6) + 1617/(5*(2 + 3*x)^5) + 3927/(2 + 3*x)^4 + 42878/(2 + 3*x)^3 + 953535/(2*(2 + 3*x)^2) + 6618975/(2 + 3*x) - 166375/(2*(3 + 5*x)^2) + 3584625/(3 + 5*x) - 43848750*Log[2 + 3*x] + 43848750*Log[3 + 5*x]", //
        90);
  }

  // {90}
  public void test1573() {
    check( //
        "Integrate[(1 - 2*x)^3/((2 + 3*x)^8*(3 + 5*x)^3), x]", //
        "49/(3*(2 + 3*x)^7) + 539/(2*(2 + 3*x)^6) + 15708/(5*(2 + 3*x)^5) + 64317/(2*(2 + 3*x)^4) + 317845/(2 + 3*x)^3 + 6618975/(2*(2 + 3*x)^2) + 43848750/(2 + 3*x) - 831875/(2*(3 + 5*x)^2) + 20418750/(3 + 5*x) - 280500000*Log[2 + 3*x] + 280500000*Log[3 + 5*x]", //
        90);
  }

  // {78}
  public void test1574() {
    check( //
        "Integrate[((2 + 3*x)^8*(3 + 5*x))/(1 - 2*x), x]", //
        "(-63019595*x)/512 - (60332619*x^2)/512 - (17391129*x^3)/128 - (37722699*x^4)/256 - (21272139*x^5)/160 - (2929689*x^6)/32 - (353565*x^7)/8 - (422091*x^8)/32 - (3645*x^9)/2 - (63412811*Log[1 - 2*x])/1024", //
        78);
  }

  // {78}
  public void test1575() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x))/(1 - 2*x), x]", //
        "(-8960669*x)/256 - (8362653*x^2)/256 - (2257119*x^3)/64 - (4352157*x^4)/128 - (2053917*x^5)/80 - (218943*x^6)/16 - (126117*x^7)/28 - (10935*x^8)/16 - (9058973*Log[1 - 2*x])/512", //
        78);
  }

  // {78}
  public void test1576() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x))/(1 - 2*x), x]", //
        "(-1269563*x)/128 - (1138491*x^2)/128 - (279657*x^3)/32 - (458811*x^4)/64 - (169371*x^5)/40 - (12393*x^6)/8 - (3645*x^7)/14 - (1294139*Log[1 - 2*x])/256", //
        78);
  }

  // {78}
  public void test1577() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x))/(1 - 2*x), x]", //
        "(-178733*x)/64 - (150573*x^2)/64 - (32271*x^3)/16 - (42093*x^4)/32 - (10773*x^5)/20 - (405*x^6)/4 - (184877*Log[1 - 2*x])/128", //
        78);
  }

  // {78}
  public void test1578() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x))/(1 - 2*x), x]", //
        "(-24875*x)/32 - (18987*x^2)/32 - (3321*x^3)/8 - (3051*x^4)/16 - (81*x^5)/2 - (26411*Log[1 - 2*x])/64", //
        78);
  }

  // {78}
  public void test1579() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x))/(1 - 2*x), x]", //
        "(-3389*x)/16 - (2205*x^2)/16 - (279*x^3)/4 - (135*x^4)/8 - (3773*Log[1 - 2*x])/32", //
        78);
  }

  // {78}
  public void test1580() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x))/(1 - 2*x), x]", //
        "(-443*x)/8 - (219*x^2)/8 - (15*x^3)/2 - (539*Log[1 - 2*x])/16", //
        78);
  }

  // {78}
  public void test1581() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x))/(1 - 2*x), x]", //
        "(-53*x)/4 - (15*x^2)/4 - (77*Log[1 - 2*x])/8", //
        78);
  }

  // {45}
  public void test1582() {
    check( //
        "Integrate[(3 + 5*x)/(1 - 2*x), x]", //
        "(-5*x)/2 - (11*Log[1 - 2*x])/4", //
        45);
  }

  // {78}
  public void test1583() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)*(2 + 3*x)), x]", //
        "(-11*Log[1 - 2*x])/14 - Log[2 + 3*x]/21", //
        78);
  }

  // {78}
  public void test1584() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)*(2 + 3*x)^2), x]", //
        "1/(21*(2 + 3*x)) - (11*Log[1 - 2*x])/49 + (11*Log[2 + 3*x])/49", //
        78);
  }

  // {78}
  public void test1585() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)*(2 + 3*x)^3), x]", //
        "1/(42*(2 + 3*x)^2) - 11/(49*(2 + 3*x)) - (22*Log[1 - 2*x])/343 + (22*Log[2 + 3*x])/343", //
        78);
  }

  // {78}
  public void test1586() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)*(2 + 3*x)^4), x]", //
        "1/(63*(2 + 3*x)^3) - 11/(98*(2 + 3*x)^2) - 22/(343*(2 + 3*x)) - (44*Log[1 - 2*x])/2401 + (44*Log[2 + 3*x])/2401", //
        78);
  }

  // {78}
  public void test1587() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)*(2 + 3*x)^5), x]", //
        "1/(84*(2 + 3*x)^4) - 11/(147*(2 + 3*x)^3) - 11/(343*(2 + 3*x)^2) - 44/(2401*(2 + 3*x)) - (88*Log[1 - 2*x])/16807 + (88*Log[2 + 3*x])/16807", //
        78);
  }

  // {78}
  public void test1588() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)*(2 + 3*x)^6), x]", //
        "1/(105*(2 + 3*x)^5) - 11/(196*(2 + 3*x)^4) - 22/(1029*(2 + 3*x)^3) - 22/(2401*(2 + 3*x)^2) - 88/(16807*(2 + 3*x)) - (176*Log[1 - 2*x])/117649 + (176*Log[2 + 3*x])/117649", //
        78);
  }

  // {78}
  public void test1589() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)*(2 + 3*x)^7), x]", //
        "1/(126*(2 + 3*x)^6) - 11/(245*(2 + 3*x)^5) - 11/(686*(2 + 3*x)^4) - 44/(7203*(2 + 3*x)^3) - 44/(16807*(2 + 3*x)^2) - 176/(117649*(2 + 3*x)) - (352*Log[1 - 2*x])/823543 + (352*Log[2 + 3*x])/823543", //
        78);
  }

  // {78}
  public void test1590() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)*(2 + 3*x)^8), x]", //
        "1/(147*(2 + 3*x)^7) - 11/(294*(2 + 3*x)^6) - 22/(1715*(2 + 3*x)^5) - 11/(2401*(2 + 3*x)^4) - 88/(50421*(2 + 3*x)^3) - 88/(117649*(2 + 3*x)^2) - 352/(823543*(2 + 3*x)) - (704*Log[1 - 2*x])/5764801 + (704*Log[2 + 3*x])/5764801", //
        78);
  }

  // {90}
  public void test1591() {
    check( //
        "Integrate[((2 + 3*x)^8*(3 + 5*x)^2)/(1 - 2*x), x]", //
        "(-695181625*x)/1024 - (677093689*x^2)/1024 - (204901139*x^3)/256 - (487203129*x^4)/512 - (316246329*x^5)/320 - (53031699*x^6)/64 - (8399295*x^7)/16 - (14907321*x^8)/64 - (256365*x^9)/4 - (32805*x^10)/4 - (697540921*Log[1 - 2*x])/2048", //
        90);
  }

  // {90}
  public void test1592() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x)^2)/(1 - 2*x), x]", //
        "(-99058879*x)/512 - (94979263*x^2)/512 - (27480469*x^3)/128 - (59969727*x^4)/256 - (34084287*x^5)/160 - (4736853*x^6)/32 - (4040847*x^7)/56 - (696195*x^8)/32 - (6075*x^9)/2 - (99648703*Log[1 - 2*x])/1024", //
        90);
  }

  // {90}
  public void test1593() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x)^2)/(1 - 2*x), x]", //
        "(-14088073*x)/256 - (13178761*x^2)/256 - (3575427*x^3)/64 - (6947721*x^4)/128 - (3310281*x^5)/80 - (356643*x^6)/16 - (207765*x^7)/28 - (18225*x^8)/16 - (14235529*Log[1 - 2*x])/512", //
        90);
  }

  // {90}
  public void test1594() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^2)/(1 - 2*x), x]", //
        "(-1996783*x)/128 - (1797103*x^2)/128 - (444581*x^3)/32 - (736623*x^4)/64 - (275103*x^5)/40 - (20385*x^6)/8 - (6075*x^7)/14 - (2033647*Log[1 - 2*x])/256", //
        90);
  }

  // {90}
  public void test1595() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^2)/(1 - 2*x), x]", //
        "(-281305*x)/64 - (238297*x^2)/64 - (51571*x^3)/16 - (68121*x^4)/32 - (3537*x^5)/4 - (675*x^6)/4 - (290521*Log[1 - 2*x])/128", //
        90);
  }

  // {90}
  public void test1596() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^2)/(1 - 2*x), x]", //
        "(-39199*x)/32 - (30175*x^2)/32 - (5349*x^3)/8 - (4995*x^4)/16 - (135*x^5)/2 - (41503*Log[1 - 2*x])/64", //
        90);
  }

  // {90}
  public void test1597() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^2)/(1 - 2*x), x]", //
        "(-5353*x)/16 - (3529*x^2)/16 - (455*x^3)/4 - (225*x^4)/8 - (5929*Log[1 - 2*x])/32", //
        90);
  }

  // {78}
  public void test1598() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^2)/(1 - 2*x), x]", //
        "(-703*x)/8 - (355*x^2)/8 - (25*x^3)/2 - (847*Log[1 - 2*x])/16", //
        78);
  }

  // {45}
  public void test1599() {
    check( //
        "Integrate[(3 + 5*x)^2/(1 - 2*x), x]", //
        "(-85*x)/4 - (25*x^2)/4 - (121*Log[1 - 2*x])/8", //
        45);
  }

  // {84}
  public void test1600() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)*(2 + 3*x)), x]", //
        "(-25*x)/6 - (121*Log[1 - 2*x])/28 + Log[2 + 3*x]/63", //
        84);
  }

  // {90}
  public void test1601() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)*(2 + 3*x)^2), x]", //
        "-1/(63*(2 + 3*x)) - (121*Log[1 - 2*x])/98 - (68*Log[2 + 3*x])/441", //
        90);
  }

  // {90}
  public void test1602() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)*(2 + 3*x)^3), x]", //
        "-1/(126*(2 + 3*x)^2) + 68/(441*(2 + 3*x)) - (121*Log[1 - 2*x])/343 + (121*Log[2 + 3*x])/343", //
        90);
  }

  // {90}
  public void test1603() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)*(2 + 3*x)^4), x]", //
        "-1/(189*(2 + 3*x)^3) + 34/(441*(2 + 3*x)^2) - 121/(343*(2 + 3*x)) - (242*Log[1 - 2*x])/2401 + (242*Log[2 + 3*x])/2401", //
        90);
  }

  // {90}
  public void test1604() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)*(2 + 3*x)^5), x]", //
        "-1/(252*(2 + 3*x)^4) + 68/(1323*(2 + 3*x)^3) - 121/(686*(2 + 3*x)^2) - 242/(2401*(2 + 3*x)) - (484*Log[1 - 2*x])/16807 + (484*Log[2 + 3*x])/16807", //
        90);
  }

  // {90}
  public void test1605() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)*(2 + 3*x)^6), x]", //
        "-1/(315*(2 + 3*x)^5) + 17/(441*(2 + 3*x)^4) - 121/(1029*(2 + 3*x)^3) - 121/(2401*(2 + 3*x)^2) - 484/(16807*(2 + 3*x)) - (968*Log[1 - 2*x])/117649 + (968*Log[2 + 3*x])/117649", //
        90);
  }

  // {90}
  public void test1606() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)*(2 + 3*x)^7), x]", //
        "-1/(378*(2 + 3*x)^6) + 68/(2205*(2 + 3*x)^5) - 121/(1372*(2 + 3*x)^4) - 242/(7203*(2 + 3*x)^3) - 242/(16807*(2 + 3*x)^2) - 968/(117649*(2 + 3*x)) - (1936*Log[1 - 2*x])/823543 + (1936*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1607() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)*(2 + 3*x)^8), x]", //
        "-1/(441*(2 + 3*x)^7) + 34/(1323*(2 + 3*x)^6) - 121/(1715*(2 + 3*x)^5) - 121/(4802*(2 + 3*x)^4) - 484/(50421*(2 + 3*x)^3) - 484/(117649*(2 + 3*x)^2) - 1936/(823543*(2 + 3*x)) - (3872*Log[1 - 2*x])/5764801 + (3872*Log[2 + 3*x])/5764801", //
        90);
  }

  // {90}
  public void test1608() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x)^3)/(1 - 2*x), x]", //
        "(-1092596789*x)/1024 - (1065169973*x^2)/1024 - (969544757*x^3)/768 - (772025397*x^4)/512 - (504354357*x^5)/320 - (85228263*x^6)/64 - (95297877*x^7)/112 - (24381405*x^8)/64 - (423225*x^9)/4 - (54675*x^10)/4 - (1096135733*Log[1 - 2*x])/2048", //
        90);
  }

  // {90}
  public void test1609() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x)^3)/(1 - 2*x), x]", //
        "(-155706083*x)/512 - (149512931*x^2)/512 - (130251491*x^3)/384 - (95317731*x^4)/256 - (54600291*x^5)/160 - (7656993*x^6)/32 - (6596235*x^7)/56 - (1148175*x^8)/32 - (10125*x^9)/2 - (156590819*Log[1 - 2*x])/1024", //
        90);
  }

  // {90}
  public void test1610() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^3)/(1 - 2*x), x]", //
        "(-22148933*x)/256 - (20766533*x^2)/256 - (16987973*x^3)/192 - (11088453*x^4)/128 - (5333733*x^5)/80 - (580815*x^6)/16 - (342225*x^7)/28 - (30375*x^8)/16 - (22370117*Log[1 - 2*x])/512", //
        90);
  }

  // {90}
  public void test1611() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^3)/(1 - 2*x), x]", //
        "(-3140435*x)/128 - (2836307*x^2)/128 - (2119763*x^3)/96 - (1182291*x^4)/64 - (89343*x^5)/8 - (33525*x^6)/8 - (10125*x^7)/14 - (3195731*Log[1 - 2*x])/256", //
        90);
  }

  // {90}
  public void test1612() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^3)/(1 - 2*x), x]", //
        "(-442709*x)/64 - (377045*x^2)/64 - (247157*x^3)/48 - (110205*x^4)/32 - (5805*x^5)/4 - (1125*x^6)/4 - (456533*Log[1 - 2*x])/128", //
        90);
  }

  // {90}
  public void test1613() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^3)/(1 - 2*x), x]", //
        "(-61763*x)/32 - (47939*x^2)/32 - (25835*x^3)/24 - (8175*x^4)/16 - (225*x^5)/2 - (65219*Log[1 - 2*x])/64", //
        90);
  }

  // {78}
  public void test1614() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^3)/(1 - 2*x), x]", //
        "(-8453*x)/16 - (5645*x^2)/16 - (2225*x^3)/12 - (375*x^4)/8 - (9317*Log[1 - 2*x])/32", //
        78);
  }

  // {45}
  public void test1615() {
    check( //
        "Integrate[(3 + 5*x)^3/(1 - 2*x), x]", //
        "(-1115*x)/8 - (575*x^2)/8 - (125*x^3)/6 - (1331*Log[1 - 2*x])/16", //
        45);
  }

  // {84}
  public void test1616() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)*(2 + 3*x)), x]", //
        "(-1225*x)/36 - (125*x^2)/12 - (1331*Log[1 - 2*x])/56 - Log[2 + 3*x]/189", //
        84);
  }

  // {90}
  public void test1617() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)*(2 + 3*x)^2), x]", //
        "(-125*x)/18 + 1/(189*(2 + 3*x)) - (1331*Log[1 - 2*x])/196 + (103*Log[2 + 3*x])/1323", //
        90);
  }

  // {90}
  public void test1618() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)*(2 + 3*x)^3), x]", //
        "1/(378*(2 + 3*x)^2) - 103/(1323*(2 + 3*x)) - (1331*Log[1 - 2*x])/686 - (3469*Log[2 + 3*x])/9261", //
        90);
  }

  // {90}
  public void test1619() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)*(2 + 3*x)^4), x]", //
        "1/(567*(2 + 3*x)^3) - 103/(2646*(2 + 3*x)^2) + 3469/(9261*(2 + 3*x)) - (1331*Log[1 - 2*x])/2401 + (1331*Log[2 + 3*x])/2401", //
        90);
  }

  // {90}
  public void test1620() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)*(2 + 3*x)^5), x]", //
        "1/(756*(2 + 3*x)^4) - 103/(3969*(2 + 3*x)^3) + 3469/(18522*(2 + 3*x)^2) - 1331/(2401*(2 + 3*x)) - (2662*Log[1 - 2*x])/16807 + (2662*Log[2 + 3*x])/16807", //
        90);
  }

  // {90}
  public void test1621() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)*(2 + 3*x)^6), x]", //
        "1/(945*(2 + 3*x)^5) - 103/(5292*(2 + 3*x)^4) + 3469/(27783*(2 + 3*x)^3) - 1331/(4802*(2 + 3*x)^2) - 2662/(16807*(2 + 3*x)) - (5324*Log[1 - 2*x])/117649 + (5324*Log[2 + 3*x])/117649", //
        90);
  }

  // {90}
  public void test1622() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)*(2 + 3*x)^7), x]", //
        "1/(1134*(2 + 3*x)^6) - 103/(6615*(2 + 3*x)^5) + 3469/(37044*(2 + 3*x)^4) - 1331/(7203*(2 + 3*x)^3) - 1331/(16807*(2 + 3*x)^2) - 5324/(117649*(2 + 3*x)) - (10648*Log[1 - 2*x])/823543 + (10648*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1623() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)*(2 + 3*x)^8), x]", //
        "1/(1323*(2 + 3*x)^7) - 103/(7938*(2 + 3*x)^6) + 3469/(46305*(2 + 3*x)^5) - 1331/(9604*(2 + 3*x)^4) - 2662/(50421*(2 + 3*x)^3) - 2662/(117649*(2 + 3*x)^2) - 10648/(823543*(2 + 3*x)) - (21296*Log[1 - 2*x])/5764801 + (21296*Log[2 + 3*x])/5764801", //
        90);
  }

  // {84}
  public void test1624() {
    check( //
        "Integrate[(a + b*x)^3/((c + d*x)*(e + f*x)), x]", //
        "-((b^2*(b*d*e + b*c*f - 3*a*d*f)*x)/(d^2*f^2)) + (b^3*x^2)/(2*d*f) - ((b*c - a*d)^3*Log[c + d*x])/(d^3*(d*e - c*f)) + ((b*e - a*f)^3*Log[e + f*x])/(f^3*(d*e - c*f))", //
        84);
  }

  // {84}
  public void test1625() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)*(3 + 5*x)), x]", //
        "(-40089855591*x)/10000000 - (7136193339*x^2)/2000000 - (345533877*x^3)/100000 - (111146499*x^4)/40000 - (8018271*x^5)/5000 - (114453*x^6)/200 - (6561*x^7)/70 - (5764801*Log[1 - 2*x])/2816 + Log[3 + 5*x]/4296875", //
        84);
  }

  // {84}
  public void test1626() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)*(3 + 5*x)), x]", //
        "(-1127138733*x)/1000000 - (187738857*x^2)/200000 - (7889751*x^3)/10000 - (2006937*x^4)/4000 - (99873*x^5)/500 - (729*x^6)/20 - (823543*Log[1 - 2*x])/1408 + Log[3 + 5*x]/859375", //
        84);
  }

  // {84}
  public void test1627() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)*(3 + 5*x)), x]", //
        "(-31289679*x)/100000 - (4693491*x^2)/20000 - (159813*x^3)/1000 - (28431*x^4)/400 - (729*x^5)/50 - (117649*Log[1 - 2*x])/704 + Log[3 + 5*x]/171875", //
        84);
  }

  // {84}
  public void test1628() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)*(3 + 5*x)), x]", //
        "(-848277*x)/10000 - (107433*x^2)/2000 - (2619*x^3)/100 - (243*x^4)/40 - (16807*Log[1 - 2*x])/352 + Log[3 + 5*x]/34375", //
        84);
  }

  // {84}
  public void test1629() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)*(3 + 5*x)), x]", //
        "(-21951*x)/1000 - (2079*x^2)/200 - (27*x^3)/10 - (2401*Log[1 - 2*x])/176 + Log[3 + 5*x]/6875", //
        84);
  }

  // {84}
  public void test1630() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)*(3 + 5*x)), x]", //
        "(-513*x)/100 - (27*x^2)/20 - (343*Log[1 - 2*x])/88 + Log[3 + 5*x]/1375", //
        84);
  }

  // {84}
  public void test1631() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)*(3 + 5*x)), x]", //
        "(-9*x)/10 - (49*Log[1 - 2*x])/44 + Log[3 + 5*x]/275", //
        84);
  }

  // {78}
  public void test1632() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)*(3 + 5*x)), x]", //
        "(-7*Log[1 - 2*x])/22 + Log[3 + 5*x]/55", //
        78);
  }

  // {84}
  public void test1633() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)*(3 + 5*x)), x]", //
        "(-2*Log[1 - 2*x])/77 - (3*Log[2 + 3*x])/7 + (5*Log[3 + 5*x])/11", //
        84);
  }

  // {84}
  public void test1634() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^2*(3 + 5*x)), x]", //
        "3/(7*(2 + 3*x)) - (4*Log[1 - 2*x])/539 - (111*Log[2 + 3*x])/49 + (25*Log[3 + 5*x])/11", //
        84);
  }

  // {84}
  public void test1635() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^3*(3 + 5*x)), x]", //
        "3/(14*(2 + 3*x)^2) + 111/(49*(2 + 3*x)) - (8*Log[1 - 2*x])/3773 - (3897*Log[2 + 3*x])/343 + (125*Log[3 + 5*x])/11", //
        84);
  }

  // {84}
  public void test1636() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^4*(3 + 5*x)), x]", //
        "1/(7*(2 + 3*x)^3) + 111/(98*(2 + 3*x)^2) + 3897/(343*(2 + 3*x)) - (16*Log[1 - 2*x])/26411 - (136419*Log[2 + 3*x])/2401 + (625*Log[3 + 5*x])/11", //
        84);
  }

  // {84}
  public void test1637() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^5*(3 + 5*x)), x]", //
        "3/(28*(2 + 3*x)^4) + 37/(49*(2 + 3*x)^3) + 3897/(686*(2 + 3*x)^2) + 136419/(2401*(2 + 3*x)) - (32*Log[1 - 2*x])/184877 - (4774713*Log[2 + 3*x])/16807 + (3125*Log[3 + 5*x])/11", //
        84);
  }

  // {84}
  public void test1638() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^6*(3 + 5*x)), x]", //
        "3/(35*(2 + 3*x)^5) + 111/(196*(2 + 3*x)^4) + 1299/(343*(2 + 3*x)^3) + 136419/(4802*(2 + 3*x)^2) + 4774713/(16807*(2 + 3*x)) - (64*Log[1 - 2*x])/1294139 - (167115051*Log[2 + 3*x])/117649 + (15625*Log[3 + 5*x])/11", //
        84);
  }

  // {84}
  public void test1639() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^7*(3 + 5*x)), x]", //
        "1/(14*(2 + 3*x)^6) + 111/(245*(2 + 3*x)^5) + 3897/(1372*(2 + 3*x)^4) + 45473/(2401*(2 + 3*x)^3) + 4774713/(33614*(2 + 3*x)^2) + 167115051/(117649*(2 + 3*x)) - (128*Log[1 - 2*x])/9058973 - (5849026977*Log[2 + 3*x])/823543 + (78125*Log[3 + 5*x])/11", //
        84);
  }

  // {90}
  public void test1640() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "(-3579885909*x)/5000000 - (118543581*x^2)/200000 - (24660207*x^3)/50000 - (6194313*x^4)/20000 - (303993*x^5)/2500 - (2187*x^6)/100 - 1/(4296875*(3 + 5*x)) - (5764801*Log[1 - 2*x])/15488 + (266*Log[3 + 5*x])/47265625", //
        90);
  }

  // {90}
  public void test1641() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "(-19846971*x)/100000 - (14750667*x^2)/100000 - (495477*x^3)/5000 - (86751*x^4)/2000 - (2187*x^5)/250 - 1/(859375*(3 + 5*x)) - (823543*Log[1 - 2*x])/7744 + (233*Log[3 + 5*x])/9453125", //
        90);
  }

  // {90}
  public void test1642() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "(-2682909*x)/50000 - (335097*x^2)/10000 - (8019*x^3)/500 - (729*x^4)/200 - 1/(171875*(3 + 5*x)) - (117649*Log[1 - 2*x])/3872 + (8*Log[3 + 5*x])/75625", //
        90);
  }

  // {90}
  public void test1643() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "(-69039*x)/5000 - (6399*x^2)/1000 - (81*x^3)/50 - 1/(34375*(3 + 5*x)) - (16807*Log[1 - 2*x])/1936 + (167*Log[3 + 5*x])/378125", //
        90);
  }

  // {90}
  public void test1644() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "(-1593*x)/500 - (81*x^2)/100 - 1/(6875*(3 + 5*x)) - (2401*Log[1 - 2*x])/968 + (134*Log[3 + 5*x])/75625", //
        90);
  }

  // {90}
  public void test1645() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "(-27*x)/50 - 1/(1375*(3 + 5*x)) - (343*Log[1 - 2*x])/484 + (101*Log[3 + 5*x])/15125", //
        90);
  }

  // {90}
  public void test1646() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "-1/(275*(3 + 5*x)) - (49*Log[1 - 2*x])/242 + (68*Log[3 + 5*x])/3025", //
        90);
  }

  // {78}
  public void test1647() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "-1/(55*(3 + 5*x)) - (7*Log[1 - 2*x])/121 + (7*Log[3 + 5*x])/121", //
        78);
  }

  // {46}
  public void test1648() {
    check( //
        "Integrate[1/((1 - 2*x)*(3 + 5*x)^2), x]", //
        "-1/(11*(3 + 5*x)) - (2*Log[1 - 2*x])/121 + (2*Log[3 + 5*x])/121", //
        46);
  }

  // {84}
  public void test1649() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)*(3 + 5*x)^2), x]", //
        "-5/(11*(3 + 5*x)) - (4*Log[1 - 2*x])/847 + (9*Log[2 + 3*x])/7 - (155*Log[3 + 5*x])/121", //
        84);
  }

  // {90}
  public void test1650() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^2*(3 + 5*x)^2), x]", //
        "-9/(7*(2 + 3*x)) - 25/(11*(3 + 5*x)) - (8*Log[1 - 2*x])/5929 + (648*Log[2 + 3*x])/49 - (1600*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1651() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^3*(3 + 5*x)^2), x]", //
        "-9/(14*(2 + 3*x)^2) - 648/(49*(2 + 3*x)) - 125/(11*(3 + 5*x)) - (16*Log[1 - 2*x])/41503 + (34371*Log[2 + 3*x])/343 - (12125*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1652() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^4*(3 + 5*x)^2), x]", //
        "-3/(7*(2 + 3*x)^3) - 324/(49*(2 + 3*x)^2) - 34371/(343*(2 + 3*x)) - 625/(11*(3 + 5*x)) - (32*Log[1 - 2*x])/290521 + (1612242*Log[2 + 3*x])/2401 - (81250*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1653() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^5*(3 + 5*x)^2), x]", //
        "-9/(28*(2 + 3*x)^4) - 216/(49*(2 + 3*x)^3) - 34371/(686*(2 + 3*x)^2) - 1612242/(2401*(2 + 3*x)) - 3125/(11*(3 + 5*x)) - (64*Log[1 - 2*x])/2033647 + (70752609*Log[2 + 3*x])/16807 - (509375*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1654() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^6*(3 + 5*x)^2), x]", //
        "-9/(35*(2 + 3*x)^5) - 162/(49*(2 + 3*x)^4) - 11457/(343*(2 + 3*x)^3) - 806121/(2401*(2 + 3*x)^2) - 70752609/(16807*(2 + 3*x)) - 15625/(11*(3 + 5*x)) - (128*Log[1 - 2*x])/14235529 + (2977686468*Log[2 + 3*x])/117649 - (3062500*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1655() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "(-62934003*x)/500000 - (9268263*x^2)/100000 - (1535517*x^3)/25000 - (264627*x^4)/10000 - (6561*x^5)/1250 - 1/(8593750*(3 + 5*x)^2) - 266/(47265625*(3 + 5*x)) - (5764801*Log[1 - 2*x])/85184 + (31024*Log[3 + 5*x])/519921875", //
        90);
  }

  // {90}
  public void test1656() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "(-339309*x)/10000 - (1044657*x^2)/50000 - (24543*x^3)/2500 - (2187*x^4)/1000 - 1/(1718750*(3 + 5*x)^2) - 233/(9453125*(3 + 5*x)) - (823543*Log[1 - 2*x])/42592 + (4667*Log[3 + 5*x])/20796875", //
        90);
  }

  // {90}
  public void test1657() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "(-216999*x)/25000 - (19683*x^2)/5000 - (243*x^3)/250 - 1/(343750*(3 + 5*x)^2) - 8/(75625*(3 + 5*x)) - (117649*Log[1 - 2*x])/21296 + (3347*Log[3 + 5*x])/4159375", //
        90);
  }

  // {90}
  public void test1658() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "(-4941*x)/2500 - (243*x^2)/500 - 1/(68750*(3 + 5*x)^2) - 167/(378125*(3 + 5*x)) - (16807*Log[1 - 2*x])/10648 + (11224*Log[3 + 5*x])/4159375", //
        90);
  }

  // {90}
  public void test1659() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "(-81*x)/250 - 1/(13750*(3 + 5*x)^2) - 134/(75625*(3 + 5*x)) - (2401*Log[1 - 2*x])/5324 + (6802*Log[3 + 5*x])/831875", //
        90);
  }

  // {90}
  public void test1660() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "-1/(2750*(3 + 5*x)^2) - 101/(15125*(3 + 5*x)) - (343*Log[1 - 2*x])/2662 + (3469*Log[3 + 5*x])/166375", //
        90);
  }

  // {90}
  public void test1661() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "-1/(550*(3 + 5*x)^2) - 68/(3025*(3 + 5*x)) - (49*Log[1 - 2*x])/1331 + (49*Log[3 + 5*x])/1331", //
        90);
  }

  // {78}
  public void test1662() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "-1/(110*(3 + 5*x)^2) - 7/(121*(3 + 5*x)) - (14*Log[1 - 2*x])/1331 + (14*Log[3 + 5*x])/1331", //
        78);
  }

  // {46}
  public void test1663() {
    check( //
        "Integrate[1/((1 - 2*x)*(3 + 5*x)^3), x]", //
        "-1/(22*(3 + 5*x)^2) - 2/(121*(3 + 5*x)) - (4*Log[1 - 2*x])/1331 + (4*Log[3 + 5*x])/1331", //
        46);
  }

  // {84}
  public void test1664() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)*(3 + 5*x)^3), x]", //
        "-5/(22*(3 + 5*x)^2) + 155/(121*(3 + 5*x)) - (8*Log[1 - 2*x])/9317 - (27*Log[2 + 3*x])/7 + (5135*Log[3 + 5*x])/1331", //
        84);
  }

  // {90}
  public void test1665() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^2*(3 + 5*x)^3), x]", //
        "27/(7*(2 + 3*x)) - 25/(22*(3 + 5*x)^2) + 1600/(121*(3 + 5*x)) - (16*Log[1 - 2*x])/65219 - (2889*Log[2 + 3*x])/49 + (78475*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1666() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^3*(3 + 5*x)^3), x]", //
        "27/(14*(2 + 3*x)^2) + 2889/(49*(2 + 3*x)) - 125/(22*(3 + 5*x)^2) + 12125/(121*(3 + 5*x)) - (32*Log[1 - 2*x])/456533 - (204228*Log[2 + 3*x])/343 + (792500*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1667() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^4*(3 + 5*x)^3), x]", //
        "9/(7*(2 + 3*x)^3) + 2889/(98*(2 + 3*x)^2) + 204228/(343*(2 + 3*x)) - 625/(22*(3 + 5*x)^2) + 81250/(121*(3 + 5*x)) - (64*Log[1 - 2*x])/3195731 - (11984706*Log[2 + 3*x])/2401 + (6643750*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1668() {
    check( //
        "Integrate[1/((1 - 2*x)*(2 + 3*x)^5*(3 + 5*x)^3), x]", //
        "27/(28*(2 + 3*x)^4) + 963/(49*(2 + 3*x)^3) + 102114/(343*(2 + 3*x)^2) + 11984706/(2401*(2 + 3*x)) - 3125/(22*(3 + 5*x)^2) + 509375/(121*(3 + 5*x)) - (128*Log[1 - 2*x])/22370117 - (631722537*Log[2 + 3*x])/16807 + (50028125*Log[3 + 5*x])/1331", //
        90);
  }

  // {84}
  public void test1669() {
    check( //
        "Integrate[(c + d*x)^4/((a - b*x)*(a + b*x)), x]", //
        "-((d^2*(6*b^2*c^2 + a^2*d^2)*x)/b^4) - (2*c*d^3*x^2)/b^2 - (d^4*x^3)/(3*b^2) - ((b*c + a*d)^4*Log[a - b*x])/(2*a*b^5) + ((b*c - a*d)^4*Log[a + b*x])/(2*a*b^5)", //
        84);
  }

  // {84}
  public void test1670() {
    check( //
        "Integrate[(c + d*x)^3/((a - b*x)*(a + b*x)), x]", //
        "(-3*c*d^2*x)/b^2 - (d^3*x^2)/(2*b^2) - ((b*c + a*d)^3*Log[a - b*x])/(2*a*b^4) + ((b*c - a*d)^3*Log[a + b*x])/(2*a*b^4)", //
        84);
  }

  // {84}
  public void test1671() {
    check( //
        "Integrate[(c + d*x)^2/((a - b*x)*(a + b*x)), x]", //
        "-((d^2*x)/b^2) - ((b*c + a*d)^2*Log[a - b*x])/(2*a*b^3) + ((b*c - a*d)^2*Log[a + b*x])/(2*a*b^3)", //
        84);
  }

  // {78}
  public void test1672() {
    check( //
        "Integrate[(c + d*x)/((a - b*x)*(a + b*x)), x]", //
        "-((b*c + a*d)*Log[a - b*x])/(2*a*b^2) + ((b*c - a*d)*Log[a + b*x])/(2*a*b^2)", //
        78);
  }

  // {35, 214}
  public void test1673() {
    check( //
        "Integrate[1/((a - b*x)*(a + b*x)), x]", //
        "ArcTanh[(b*x)/a]/(a*b)", //
        35,
        214);
  }

  // {84}
  public void test1674() {
    check( //
        "Integrate[1/((a - b*x)*(a + b*x)*(c + d*x)), x]", //
        "-Log[a - b*x]/(2*a*(b*c + a*d)) + Log[a + b*x]/(2*a*(b*c - a*d)) - (d*Log[c + d*x])/(b^2*c^2 - a^2*d^2)", //
        84);
  }

  // {84}
  public void test1675() {
    check( //
        "Integrate[1/((a - b*x)*(a + b*x)*(c + d*x)^2), x]", //
        "d/((b^2*c^2 - a^2*d^2)*(c + d*x)) - (b*Log[a - b*x])/(2*a*(b*c + a*d)^2) + (b*Log[a + b*x])/(2*a*(b*c - a*d)^2) - (2*b^2*c*d*Log[c + d*x])/(b^2*c^2 - a^2*d^2)^2", //
        84);
  }

  // {84}
  public void test1676() {
    check( //
        "Integrate[1/((a - b*x)*(a + b*x)*(c + d*x)^3), x]", //
        "d/(2*(b^2*c^2 - a^2*d^2)*(c + d*x)^2) + (2*b^2*c*d)/((b^2*c^2 - a^2*d^2)^2*(c + d*x)) - (b^2*Log[a - b*x])/(2*a*(b*c + a*d)^3) + (b^2*Log[a + b*x])/(2*a*(b*c - a*d)^3) - (b^2*d*(3*b^2*c^2 + a^2*d^2)*Log[c + d*x])/(b^2*c^2 - a^2*d^2)^3", //
        84);
  }

  // {78}
  public void test1677() {
    check( //
        "Integrate[((2 + 3*x)^8*(3 + 5*x))/(1 - 2*x)^2, x]", //
        "63412811/(1024*(1 - 2*x)) + (91609881*x)/256 + (122887143*x^2)/512 + (5892813*x^3)/32 + (32991057*x^4)/256 + (5859459*x^5)/80 + (976617*x^6)/32 + (56862*x^7)/7 + (32805*x^8)/32 + (246239357*Log[1 - 2*x])/1024", //
        78);
  }

  // {78}
  public void test1678() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x))/(1 - 2*x)^2, x]", //
        "9058973/(512*(1 - 2*x)) + (22333965*x)/256 + (873207*x^2)/16 + (2399985*x^3)/64 + (1423899*x^4)/64 + (793881*x^5)/80 + (11421*x^6)/4 + (10935*x^7)/28 + (15647317*Log[1 - 2*x])/256", //
        78);
  }

  // {78}
  public void test1679() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x))/(1 - 2*x)^2, x]", //
        "1294139/(256*(1 - 2*x)) + (661617*x)/32 + (1507977*x^2)/128 + (111501*x^3)/16 + (210195*x^4)/64 + (5103*x^5)/5 + (1215*x^6)/8 + (3916031*Log[1 - 2*x])/256", //
        78);
  }

  // {78}
  public void test1680() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x))/(1 - 2*x)^2, x]", //
        "184877/(128*(1 - 2*x)) + (301467*x)/64 + (75447*x^2)/32 + (18027*x^3)/16 + (2997*x^4)/8 + (243*x^5)/4 + (60025*Log[1 - 2*x])/16", //
        78);
  }

  // {78}
  public void test1681() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x))/(1 - 2*x)^2, x]", //
        "26411/(64*(1 - 2*x)) + (16203*x)/16 + (13419*x^2)/32 + 144*x^3 + (405*x^4)/16 + (57281*Log[1 - 2*x])/64", //
        78);
  }

  // {78}
  public void test1682() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x))/(1 - 2*x)^2, x]", //
        "3773/(32*(1 - 2*x)) + (3177*x)/16 + (243*x^2)/4 + (45*x^3)/4 + (3283*Log[1 - 2*x])/16", //
        78);
  }

  // {78}
  public void test1683() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x))/(1 - 2*x)^2, x]", //
        "539/(16*(1 - 2*x)) + 33*x + (45*x^2)/8 + (707*Log[1 - 2*x])/16", //
        78);
  }

  // {78}
  public void test1684() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x))/(1 - 2*x)^2, x]", //
        "77/(8*(1 - 2*x)) + (15*x)/4 + (17*Log[1 - 2*x])/2", //
        78);
  }

  // {45}
  public void test1685() {
    check( //
        "Integrate[(3 + 5*x)/(1 - 2*x)^2, x]", //
        "11/(4*(1 - 2*x)) + (5*Log[1 - 2*x])/4", //
        45);
  }

  // {78}
  public void test1686() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^2*(2 + 3*x)), x]", //
        "11/(14*(1 - 2*x)) + Log[1 - 2*x]/49 - Log[2 + 3*x]/49", //
        78);
  }

  // {78}
  public void test1687() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^2*(2 + 3*x)^2), x]", //
        "11/(49*(1 - 2*x)) + 1/(49*(2 + 3*x)) - (31*Log[1 - 2*x])/343 + (31*Log[2 + 3*x])/343", //
        78);
  }

  // {78}
  public void test1688() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^2*(2 + 3*x)^3), x]", //
        "22/(343*(1 - 2*x)) + 1/(98*(2 + 3*x)^2) - 31/(343*(2 + 3*x)) - (128*Log[1 - 2*x])/2401 + (128*Log[2 + 3*x])/2401", //
        78);
  }

  // {78}
  public void test1689() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^2*(2 + 3*x)^4), x]", //
        "44/(2401*(1 - 2*x)) + 1/(147*(2 + 3*x)^3) - 31/(686*(2 + 3*x)^2) - 128/(2401*(2 + 3*x)) - (388*Log[1 - 2*x])/16807 + (388*Log[2 + 3*x])/16807", //
        78);
  }

  // {78}
  public void test1690() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^2*(2 + 3*x)^5), x]", //
        "88/(16807*(1 - 2*x)) + 1/(196*(2 + 3*x)^4) - 31/(1029*(2 + 3*x)^3) - 64/(2401*(2 + 3*x)^2) - 388/(16807*(2 + 3*x)) - (1040*Log[1 - 2*x])/117649 + (1040*Log[2 + 3*x])/117649", //
        78);
  }

  // {78}
  public void test1691() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^2*(2 + 3*x)^6), x]", //
        "176/(117649*(1 - 2*x)) + 1/(245*(2 + 3*x)^5) - 31/(1372*(2 + 3*x)^4) - 128/(7203*(2 + 3*x)^3) - 194/(16807*(2 + 3*x)^2) - 1040/(117649*(2 + 3*x)) - (2608*Log[1 - 2*x])/823543 + (2608*Log[2 + 3*x])/823543", //
        78);
  }

  // {78}
  public void test1692() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^2*(2 + 3*x)^7), x]", //
        "352/(823543*(1 - 2*x)) + 1/(294*(2 + 3*x)^6) - 31/(1715*(2 + 3*x)^5) - 32/(2401*(2 + 3*x)^4) - 388/(50421*(2 + 3*x)^3) - 520/(117649*(2 + 3*x)^2) - 2608/(823543*(2 + 3*x)) - (128*Log[1 - 2*x])/117649 + (128*Log[2 + 3*x])/117649", //
        78);
  }

  // {90}
  public void test1693() {
    check( //
        "Integrate[((2 + 3*x)^8*(3 + 5*x)^2)/(1 - 2*x)^2, x]", //
        "697540921/(2048*(1 - 2*x)) + (2330515357*x)/1024 + (413355417*x^2)/256 + (346239417*x^3)/256 + (275757561*x^4)/256 + (235268793*x^5)/320 + 396738*x^6 + (17378631*x^7)/112 + (1235655*x^8)/32 + (18225*x^9)/4 + (1512848491*Log[1 - 2*x])/1024", //
        90);
  }

  // {90}
  public void test1694() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x)^2)/(1 - 2*x)^2, x]", //
        "99648703/(1024*(1 - 2*x)) + (9077405*x)/16 + (195497697*x^2)/512 + (18842715*x^3)/64 + (53086563*x^4)/256 + (4750569*x^5)/40 + (1597239*x^6)/32 + (375435*x^7)/28 + (54675*x^8)/32 + (389535839*Log[1 - 2*x])/1024", //
        90);
  }

  // {90}
  public void test1695() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x)^2)/(1 - 2*x)^2, x]", //
        "14235529/(512*(1 - 2*x)) + (35458963*x)/256 + (11140101*x^2)/128 + (3851307*x^3)/64 + (575775*x^4)/16 + (1295919*x^5)/80 + (37665*x^6)/8 + (18225*x^7)/28 + (12386759*Log[1 - 2*x])/128", //
        90);
  }

  // {90}
  public void test1696() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^2)/(1 - 2*x)^2, x]", //
        "2033647/(256*(1 - 2*x)) + (2104901*x)/64 + (2412699*x^2)/128 + (89913*x^3)/8 + (342333*x^4)/64 + (6723*x^5)/4 + (2025*x^6)/8 + (6206585*Log[1 - 2*x])/256", //
        90);
  }

  // {90}
  public void test1697() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^2)/(1 - 2*x)^2, x]", //
        "290521/(128*(1 - 2*x)) + (480841*x)/64 + (15159*x^2)/4 + (29277*x^3)/16 + (9855*x^4)/16 + (405*x^5)/4 + (381073*Log[1 - 2*x])/64", //
        90);
  }

  // {90}
  public void test1698() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^2)/(1 - 2*x)^2, x]", //
        "41503/(64*(1 - 2*x)) + (12973*x)/8 + (21717*x^2)/32 + (945*x^3)/4 + (675*x^4)/16 + (91091*Log[1 - 2*x])/64", //
        90);
  }

  // {90}
  public void test1699() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^2)/(1 - 2*x)^2, x]", //
        "5929/(32*(1 - 2*x)) + (5119*x)/16 + (795*x^2)/8 + (75*x^3)/4 + (1309*Log[1 - 2*x])/4", //
        90);
  }

  // {78}
  public void test1700() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^2)/(1 - 2*x)^2, x]", //
        "847/(16*(1 - 2*x)) + (215*x)/4 + (75*x^2)/8 + (1133*Log[1 - 2*x])/16", //
        78);
  }

  // {45}
  public void test1701() {
    check( //
        "Integrate[(3 + 5*x)^2/(1 - 2*x)^2, x]", //
        "121/(8*(1 - 2*x)) + (25*x)/4 + (55*Log[1 - 2*x])/4", //
        45);
  }

  // {90}
  public void test1702() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^2*(2 + 3*x)), x]", //
        "121/(28*(1 - 2*x)) + (407*Log[1 - 2*x])/196 + Log[2 + 3*x]/147", //
        90);
  }

  // {90}
  public void test1703() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^2*(2 + 3*x)^2), x]", //
        "121/(98*(1 - 2*x)) - 1/(147*(2 + 3*x)) + (22*Log[1 - 2*x])/343 - (22*Log[2 + 3*x])/343", //
        90);
  }

  // {90}
  public void test1704() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^2*(2 + 3*x)^3), x]", //
        "121/(343*(1 - 2*x)) - 1/(294*(2 + 3*x)^2) + 22/(343*(2 + 3*x)) - (319*Log[1 - 2*x])/2401 + (319*Log[2 + 3*x])/2401", //
        90);
  }

  // {90}
  public void test1705() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^2*(2 + 3*x)^4), x]", //
        "242/(2401*(1 - 2*x)) - 1/(441*(2 + 3*x)^3) + 11/(343*(2 + 3*x)^2) - 319/(2401*(2 + 3*x)) - (1364*Log[1 - 2*x])/16807 + (1364*Log[2 + 3*x])/16807", //
        90);
  }

  // {90}
  public void test1706() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^2*(2 + 3*x)^5), x]", //
        "484/(16807*(1 - 2*x)) - 1/(588*(2 + 3*x)^4) + 22/(1029*(2 + 3*x)^3) - 319/(4802*(2 + 3*x)^2) - 1364/(16807*(2 + 3*x)) - (4180*Log[1 - 2*x])/117649 + (4180*Log[2 + 3*x])/117649", //
        90);
  }

  // {90}
  public void test1707() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^2*(2 + 3*x)^6), x]", //
        "968/(117649*(1 - 2*x)) - 1/(735*(2 + 3*x)^5) + 11/(686*(2 + 3*x)^4) - 319/(7203*(2 + 3*x)^3) - 682/(16807*(2 + 3*x)^2) - 4180/(117649*(2 + 3*x)) - (11264*Log[1 - 2*x])/823543 + (11264*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1708() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^2*(2 + 3*x)^7), x]", //
        "1936/(823543*(1 - 2*x)) - 1/(882*(2 + 3*x)^6) + 22/(1715*(2 + 3*x)^5) - 319/(9604*(2 + 3*x)^4) - 1364/(50421*(2 + 3*x)^3) - 2090/(117649*(2 + 3*x)^2) - 11264/(823543*(2 + 3*x)) - (4048*Log[1 - 2*x])/823543 + (4048*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1709() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^2*(2 + 3*x)^8), x]", //
        "3872/(5764801*(1 - 2*x)) - 1/(1029*(2 + 3*x)^7) + 11/(1029*(2 + 3*x)^6) - 319/(12005*(2 + 3*x)^5) - 341/(16807*(2 + 3*x)^4) - 4180/(352947*(2 + 3*x)^3) - 5632/(823543*(2 + 3*x)^2) - 4048/(823543*(2 + 3*x)) - (68288*Log[1 - 2*x])/40353607 + (68288*Log[2 + 3*x])/40353607", //
        90);
  }

  // {90}
  public void test1710() {
    check( //
        "Integrate[((2 + 3*x)^8*(3 + 5*x)^3)/(1 - 2*x)^2, x]", //
        "7672950131/(4096*(1 - 2*x)) + (7277894263*x)/512 + (21573106793*x^2)/2048 + (2416569641*x^3)/256 + (8502681987*x^4)/1024 + (260574273*x^5)/40 + (544462047*x^6)/128 + (242570133*x^7)/112 + (101721015*x^8)/128 + (370575*x^9)/2 + (164025*x^10)/8 + (36770371407*Log[1 - 2*x])/4096", //
        90);
  }

  // {90}
  public void test1711() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x)^3)/(1 - 2*x)^2, x]", //
        "1096135733/(2048*(1 - 2*x)) + (3690540955*x)/1024 + (1312685491*x^2)/512 + (551942075*x^3)/256 + (220950207*x^4)/128 + (379446471*x^5)/320 + (20626947*x^6)/32 + (28463805*x^7)/112 + (127575*x^8)/2 + (30375*x^9)/4 + (298946109*Log[1 - 2*x])/128", //
        90);
  }

  // {90}
  public void test1712() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x)^3)/(1 - 2*x)^2, x]", //
        "156590819/(1024*(1 - 2*x)) + (230244479*x)/256 + (310976027*x^2)/512 + (7530189*x^3)/16 + (85406805*x^4)/256 + (15403257*x^5)/80 + (2611845*x^6)/32 + (309825*x^7)/14 + (91125*x^8)/32 + (616195041*Log[1 - 2*x])/1024", //
        90);
  }

  // {90}
  public void test1713() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^3)/(1 - 2*x)^2, x]", //
        "22370117/(512*(1 - 2*x)) + (56291737*x)/256 + (8881301*x^2)/64 + (6179077*x^3)/64 + (3724389*x^4)/64 + (423009*x^5)/16 + (15525*x^6)/2 + (30375*x^7)/28 + (39220335*Log[1 - 2*x])/256", //
        90);
  }

  // {90}
  public void test1714() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^3)/(1 - 2*x)^2, x]", //
        "3195731/(256*(1 - 2*x)) + (209243*x)/4 + (3859469*x^2)/128 + (289951*x^3)/16 + (557415*x^4)/64 + (5535*x^5)/2 + (3375*x^6)/8 + (9836211*Log[1 - 2*x])/256", //
        90);
  }

  // {90}
  public void test1715() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^3)/(1 - 2*x)^2, x]", //
        "456533/(128*(1 - 2*x)) + (766807*x)/64 + (194881*x^2)/32 + (47535*x^3)/16 + (2025*x^4)/2 + (675*x^5)/4 + (302379*Log[1 - 2*x])/32", //
        90);
  }

  // {90}
  public void test1716() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^3)/(1 - 2*x)^2, x]", //
        "65219/(64*(1 - 2*x)) + (41537*x)/16 + (35135*x^2)/32 + (775*x^3)/2 + (1125*x^4)/16 + (144837*Log[1 - 2*x])/64", //
        90);
  }

  // {78}
  public void test1717() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^3)/(1 - 2*x)^2, x]", //
        "9317/(32*(1 - 2*x)) + (8245*x)/16 + (325*x^2)/2 + (125*x^3)/4 + (8349*Log[1 - 2*x])/16", //
        78);
  }

  // {45}
  public void test1718() {
    check( //
        "Integrate[(3 + 5*x)^3/(1 - 2*x)^2, x]", //
        "1331/(16*(1 - 2*x)) + (175*x)/2 + (125*x^2)/8 + (1815*Log[1 - 2*x])/16", //
        45);
  }

  // {90}
  public void test1719() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^2*(2 + 3*x)), x]", //
        "1331/(56*(1 - 2*x)) + (125*x)/12 + (1089*Log[1 - 2*x])/49 - Log[2 + 3*x]/441", //
        90);
  }

  // {90}
  public void test1720() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^2*(2 + 3*x)^2), x]", //
        "1331/(196*(1 - 2*x)) + 1/(441*(2 + 3*x)) + (4719*Log[1 - 2*x])/1372 + (101*Log[2 + 3*x])/3087", //
        90);
  }

  // {90}
  public void test1721() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^2*(2 + 3*x)^3), x]", //
        "1331/(686*(1 - 2*x)) + 1/(882*(2 + 3*x)^2) - 101/(3087*(2 + 3*x)) + (363*Log[1 - 2*x])/2401 - (363*Log[2 + 3*x])/2401", //
        90);
  }

  // {90}
  public void test1722() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^2*(2 + 3*x)^4), x]", //
        "1331/(2401*(1 - 2*x)) + 1/(1323*(2 + 3*x)^3) - 101/(6174*(2 + 3*x)^2) + 363/(2401*(2 + 3*x)) - (3267*Log[1 - 2*x])/16807 + (3267*Log[2 + 3*x])/16807", //
        90);
  }

  // {90}
  public void test1723() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^2*(2 + 3*x)^5), x]", //
        "2662/(16807*(1 - 2*x)) + 1/(1764*(2 + 3*x)^4) - 101/(9261*(2 + 3*x)^3) + 363/(4802*(2 + 3*x)^2) - 3267/(16807*(2 + 3*x)) - (14520*Log[1 - 2*x])/117649 + (14520*Log[2 + 3*x])/117649", //
        90);
  }

  // {90}
  public void test1724() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^2*(2 + 3*x)^6), x]", //
        "5324/(117649*(1 - 2*x)) + 1/(2205*(2 + 3*x)^5) - 101/(12348*(2 + 3*x)^4) + 121/(2401*(2 + 3*x)^3) - 3267/(33614*(2 + 3*x)^2) - 14520/(117649*(2 + 3*x)) - (45012*Log[1 - 2*x])/823543 + (45012*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1725() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^2*(2 + 3*x)^7), x]", //
        "10648/(823543*(1 - 2*x)) + 1/(2646*(2 + 3*x)^6) - 101/(15435*(2 + 3*x)^5) + 363/(9604*(2 + 3*x)^4) - 1089/(16807*(2 + 3*x)^3) - 7260/(117649*(2 + 3*x)^2) - 45012/(823543*(2 + 3*x)) - (17424*Log[1 - 2*x])/823543 + (17424*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1726() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^2*(2 + 3*x)^8), x]", //
        "21296/(5764801*(1 - 2*x)) + 1/(3087*(2 + 3*x)^7) - 101/(18522*(2 + 3*x)^6) + 363/(12005*(2 + 3*x)^5) - 3267/(67228*(2 + 3*x)^4) - 4840/(117649*(2 + 3*x)^3) - 22506/(823543*(2 + 3*x)^2) - 17424/(823543*(2 + 3*x)) - (307824*Log[1 - 2*x])/40353607 + (307824*Log[2 + 3*x])/40353607", //
        90);
  }

  // {90}
  public void test1727() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "5764801/(2816*(1 - 2*x)) + (2041906293*x)/250000 + (1839811401*x^2)/400000 + (26773659*x^3)/10000 + (9899091*x^4)/8000 + (94041*x^5)/250 + (2187*x^6)/40 + (188591347*Log[1 - 2*x])/30976 + Log[3 + 5*x]/9453125", //
        90);
  }

  // {90}
  public void test1728() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "823543/(1408*(1 - 2*x)) + (370109547*x)/200000 + (18237069*x^2)/20000 + (853659*x^3)/2000 + (13851*x^4)/100 + (2187*x^5)/100 + (5764801*Log[1 - 2*x])/3872 + Log[3 + 5*x]/1890625", //
        90);
  }

  // {90}
  public void test1729() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "117649/(704*(1 - 2*x)) + (3946293*x)/10000 + (639819*x^2)/4000 + (2673*x^3)/50 + (729*x^4)/80 + (2739541*Log[1 - 2*x])/7744 + Log[3 + 5*x]/378125", //
        90);
  }

  // {90}
  public void test1730() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "16807/(352*(1 - 2*x)) + (152793*x)/2000 + (567*x^2)/25 + (81*x^3)/20 + (156065*Log[1 - 2*x])/1936 + Log[3 + 5*x]/75625", //
        90);
  }

  // {90}
  public void test1731() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "2401/(176*(1 - 2*x)) + (621*x)/50 + (81*x^2)/40 + (33271*Log[1 - 2*x])/1936 + Log[3 + 5*x]/15125", //
        90);
  }

  // {90}
  public void test1732() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "343/(88*(1 - 2*x)) + (27*x)/20 + (392*Log[1 - 2*x])/121 + Log[3 + 5*x]/3025", //
        90);
  }

  // {90}
  public void test1733() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "49/(44*(1 - 2*x)) + (217*Log[1 - 2*x])/484 + Log[3 + 5*x]/605", //
        90);
  }

  // {78}
  public void test1734() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "7/(22*(1 - 2*x)) - Log[1 - 2*x]/121 + Log[3 + 5*x]/121", //
        78);
  }

  // {46}
  public void test1735() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(3 + 5*x)), x]", //
        "1/(11*(1 - 2*x)) - (5*Log[1 - 2*x])/121 + (5*Log[3 + 5*x])/121", //
        46);
  }

  // {84}
  public void test1736() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)*(3 + 5*x)), x]", //
        "2/(77*(1 - 2*x)) - (136*Log[1 - 2*x])/5929 - (9*Log[2 + 3*x])/49 + (25*Log[3 + 5*x])/121", //
        84);
  }

  // {90}
  public void test1737() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^2*(3 + 5*x)), x]", //
        "4/(539*(1 - 2*x)) + 9/(49*(2 + 3*x)) - (404*Log[1 - 2*x])/41503 - (351*Log[2 + 3*x])/343 + (125*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1738() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^3*(3 + 5*x)), x]", //
        "8/(3773*(1 - 2*x)) + 9/(98*(2 + 3*x)^2) + 351/(343*(2 + 3*x)) - (1072*Log[1 - 2*x])/290521 - (12393*Log[2 + 3*x])/2401 + (625*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1739() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^4*(3 + 5*x)), x]", //
        "16/(26411*(1 - 2*x)) + 3/(49*(2 + 3*x)^3) + 351/(686*(2 + 3*x)^2) + 12393/(2401*(2 + 3*x)) - (2672*Log[1 - 2*x])/2033647 - (434043*Log[2 + 3*x])/16807 + (3125*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1740() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^5*(3 + 5*x)), x]", //
        "32/(184877*(1 - 2*x)) + 9/(196*(2 + 3*x)^4) + 117/(343*(2 + 3*x)^3) + 12393/(4802*(2 + 3*x)^2) + 434043/(16807*(2 + 3*x)) - (6400*Log[1 - 2*x])/14235529 - (15192225*Log[2 + 3*x])/117649 + (15625*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1741() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^6*(3 + 5*x)), x]", //
        "64/(1294139*(1 - 2*x)) + 9/(245*(2 + 3*x)^5) + 351/(1372*(2 + 3*x)^4) + 4131/(2401*(2 + 3*x)^3) + 434043/(33614*(2 + 3*x)^2) + 15192225/(117649*(2 + 3*x)) - (14912*Log[1 - 2*x])/99648703 - (531729603*Log[2 + 3*x])/823543 + (78125*Log[3 + 5*x])/121", //
        90);
  }

  // {90}
  public void test1742() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "5764801/(15488*(1 - 2*x)) + (231915717*x)/200000 + (14171517*x^2)/25000 + (2626101*x^3)/10000 + (168399*x^4)/2000 + (6561*x^5)/500 - 1/(9453125*(3 + 5*x)) + (79883671*Log[1 - 2*x])/85184 + (268*Log[3 + 5*x])/103984375", //
        90);
  }

  // {90}
  public void test1743() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "823543/(7744*(1 - 2*x)) + (6156243*x)/25000 + (1974861*x^2)/20000 + (16281*x^3)/500 + (2187*x^4)/400 - 1/(1890625*(3 + 5*x)) + (18941489*Log[1 - 2*x])/85184 + (47*Log[3 + 5*x])/4159375", //
        90);
  }

  // {90}
  public void test1744() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "117649/(3872*(1 - 2*x)) + (473607*x)/10000 + (13851*x^2)/1000 + (243*x^3)/100 - 1/(378125*(3 + 5*x)) + (67228*Log[1 - 2*x])/1331 + (202*Log[3 + 5*x])/4159375", //
        90);
  }

  // {90}
  public void test1745() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "16807/(1936*(1 - 2*x)) + (3807*x)/500 + (243*x^2)/200 - 1/(75625*(3 + 5*x)) + (228095*Log[1 - 2*x])/21296 + (169*Log[3 + 5*x])/831875", //
        90);
  }

  // {90}
  public void test1746() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "2401/(968*(1 - 2*x)) + (81*x)/100 - 1/(15125*(3 + 5*x)) + (10633*Log[1 - 2*x])/5324 + (136*Log[3 + 5*x])/166375", //
        90);
  }

  // {90}
  public void test1747() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "343/(484*(1 - 2*x)) - 1/(3025*(3 + 5*x)) + (1421*Log[1 - 2*x])/5324 + (103*Log[3 + 5*x])/33275", //
        90);
  }

  // {90}
  public void test1748() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "49/(242*(1 - 2*x)) - 1/(605*(3 + 5*x)) - (14*Log[1 - 2*x])/1331 + (14*Log[3 + 5*x])/1331", //
        90);
  }

  // {78}
  public void test1749() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "7/(121*(1 - 2*x)) - 1/(121*(3 + 5*x)) - (37*Log[1 - 2*x])/1331 + (37*Log[3 + 5*x])/1331", //
        78);
  }

  // {46}
  public void test1750() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(3 + 5*x)^2), x]", //
        "2/(121*(1 - 2*x)) - 5/(121*(3 + 5*x)) - (20*Log[1 - 2*x])/1331 + (20*Log[3 + 5*x])/1331", //
        46);
  }

  // {90}
  public void test1751() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)*(3 + 5*x)^2), x]", //
        "4/(847*(1 - 2*x)) - 25/(121*(3 + 5*x)) - (412*Log[1 - 2*x])/65219 + (27*Log[2 + 3*x])/49 - (725*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1752() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^2*(3 + 5*x)^2), x]", //
        "8/(5929*(1 - 2*x)) - 27/(49*(2 + 3*x)) - 125/(121*(3 + 5*x)) - (1088*Log[1 - 2*x])/456533 + (1998*Log[2 + 3*x])/343 - (7750*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1753() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^3*(3 + 5*x)^2), x]", //
        "16/(41503*(1 - 2*x)) - 27/(98*(2 + 3*x)^2) - 1998/(343*(2 + 3*x)) - 625/(121*(3 + 5*x)) - (2704*Log[1 - 2*x])/3195731 + (107109*Log[2 + 3*x])/2401 - (59375*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1754() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^4*(3 + 5*x)^2), x]", //
        "32/(290521*(1 - 2*x)) - 9/(49*(2 + 3*x)^3) - 999/(343*(2 + 3*x)^2) - 107109/(2401*(2 + 3*x)) - 3125/(121*(3 + 5*x)) - (6464*Log[1 - 2*x])/22370117 + (5050944*Log[2 + 3*x])/16807 - (400000*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1755() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^5*(3 + 5*x)^2), x]", //
        "64/(2033647*(1 - 2*x)) - 27/(196*(2 + 3*x)^4) - 666/(343*(2 + 3*x)^3) - 107109/(4802*(2 + 3*x)^2) - 5050944/(16807*(2 + 3*x)) - 15625/(121*(3 + 5*x)) - (15040*Log[1 - 2*x])/156590819 + (222359715*Log[2 + 3*x])/117649 - (2515625*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1756() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "5764801/(85184*(1 - 2*x)) + (7680987*x)/50000 + (6093711*x^2)/100000 + (12393*x^3)/625 + (6561*x^4)/2000 - 1/(18906250*(3 + 5*x)^2) - 268/(103984375*(3 + 5*x)) + (130943337*Log[1 - 2*x])/937024 + (6312*Log[3 + 5*x])/228765625", //
        90);
  }

  // {90}
  public void test1757() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "823543/(42592*(1 - 2*x)) + (1467477*x)/50000 + (21141*x^2)/2500 + (729*x^3)/500 - 1/(3781250*(3 + 5*x)^2) - 47/(4159375*(3 + 5*x)) + (7411887*Log[1 - 2*x])/234256 + (4761*Log[3 + 5*x])/45753125", //
        90);
  }

  // {90}
  public void test1758() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "117649/(21296*(1 - 2*x)) + (2916*x)/625 + (729*x^2)/1000 - 1/(756250*(3 + 5*x)^2) - 202/(4159375*(3 + 5*x)) + (1563051*Log[1 - 2*x])/234256 + (17139*Log[3 + 5*x])/45753125", //
        90);
  }

  // {90}
  public void test1759() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "16807/(10648*(1 - 2*x)) + (243*x)/500 - 1/(151250*(3 + 5*x)^2) - 169/(831875*(3 + 5*x)) + (36015*Log[1 - 2*x])/29282 + (11562*Log[3 + 5*x])/9150625", //
        90);
  }

  // {90}
  public void test1760() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "2401/(5324*(1 - 2*x)) - 1/(30250*(3 + 5*x)^2) - 136/(166375*(3 + 5*x)) + (9261*Log[1 - 2*x])/58564 + (7074*Log[3 + 5*x])/1830125", //
        90);
  }

  // {90}
  public void test1761() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "343/(2662*(1 - 2*x)) - 1/(6050*(3 + 5*x)^2) - 103/(33275*(3 + 5*x)) - (147*Log[1 - 2*x])/14641 + (147*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1762() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "49/(1331*(1 - 2*x)) - 1/(1210*(3 + 5*x)^2) - 14/(1331*(3 + 5*x)) - (273*Log[1 - 2*x])/14641 + (273*Log[3 + 5*x])/14641", //
        90);
  }

  // {78}
  public void test1763() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "14/(1331*(1 - 2*x)) - 1/(242*(3 + 5*x)^2) - 37/(1331*(3 + 5*x)) - (144*Log[1 - 2*x])/14641 + (144*Log[3 + 5*x])/14641", //
        78);
  }

  // {46}
  public void test1764() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(3 + 5*x)^3), x]", //
        "4/(1331*(1 - 2*x)) - 5/(242*(3 + 5*x)^2) - 20/(1331*(3 + 5*x)) - (60*Log[1 - 2*x])/14641 + (60*Log[3 + 5*x])/14641", //
        46);
  }

  // {90}
  public void test1765() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)*(3 + 5*x)^3), x]", //
        "8/(9317*(1 - 2*x)) - 25/(242*(3 + 5*x)^2) + 725/(1331*(3 + 5*x)) - (1104*Log[1 - 2*x])/717409 - (81*Log[2 + 3*x])/49 + (24225*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1766() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^2*(3 + 5*x)^3), x]", //
        "16/(65219*(1 - 2*x)) + 81/(49*(2 + 3*x)) - 125/(242*(3 + 5*x)^2) + 7750/(1331*(3 + 5*x)) - (2736*Log[1 - 2*x])/5021863 - (8829*Log[2 + 3*x])/343 + (376875*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1767() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^3*(3 + 5*x)^3), x]", //
        "32/(456533*(1 - 2*x)) + 81/(98*(2 + 3*x)^2) + 8829/(343*(2 + 3*x)) - 625/(242*(3 + 5*x)^2) + 59375/(1331*(3 + 5*x)) - (6528*Log[1 - 2*x])/35153041 - (630342*Log[2 + 3*x])/2401 + (3843750*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1768() {
    check( //
        "Integrate[1/((1 - 2*x)^2*(2 + 3*x)^4*(3 + 5*x)^3), x]", //
        "64/(3195731*(1 - 2*x)) + 27/(49*(2 + 3*x)^3) + 8829/(686*(2 + 3*x)^2) + 630342/(2401*(2 + 3*x)) - 3125/(242*(3 + 5*x)^2) + 400000/(1331*(3 + 5*x)) - (15168*Log[1 - 2*x])/246071287 - (37214802*Log[2 + 3*x])/16807 + (32418750*Log[3 + 5*x])/14641", //
        90);
  }

  // {78}
  public void test1769() {
    check( //
        "Integrate[((2 + 3*x)^8*(3 + 5*x))/(1 - 2*x)^3, x]", //
        "63412811/(2048*(1 - 2*x)^2) - 246239357/(1024*(1 - 2*x)) - (120864213*x)/256 - (118841283*x^2)/512 - (16042509*x^3)/128 - (7568235*x^4)/128 - (213597*x^5)/10 - (162567*x^6)/32 - (32805*x^7)/56 - (106237047*Log[1 - 2*x])/256", //
        78);
  }

  // {78}
  public void test1770() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x))/(1 - 2*x)^3, x]", //
        "9058973/(1024*(1 - 2*x)^2) - 15647317/(256*(1 - 2*x)) - (24960933*x)/256 - (10989621*x^2)/256 - (631611*x^3)/32 - (235467*x^4)/32 - (147987*x^5)/80 - (3645*x^6)/16 - (23647449*Log[1 - 2*x])/256", //
        78);
  }

  // {78}
  public void test1771() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x))/(1 - 2*x)^3, x]", //
        "1294139/(512*(1 - 2*x)^2) - 3916031/(256*(1 - 2*x)) - (2431647*x)/128 - (461835*x^2)/64 - (10611*x^3)/4 - (44469*x^4)/64 - (729*x^5)/8 - (5078115*Log[1 - 2*x])/256", //
        78);
  }

  // {78}
  public void test1772() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x))/(1 - 2*x)^3, x]", //
        "184877/(256*(1 - 2*x)^2) - 60025/(16*(1 - 2*x)) - (109089*x)/32 - (16821*x^2)/16 - (4401*x^3)/16 - (1215*x^4)/32 - (519645*Log[1 - 2*x])/128", //
        78);
  }

  // {78}
  public void test1773() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x))/(1 - 2*x)^3, x]", //
        "26411/(128*(1 - 2*x)^2) - 57281/(64*(1 - 2*x)) - 540*x - (3861*x^2)/32 - (135*x^3)/8 - (24843*Log[1 - 2*x])/32", //
        78);
  }

  // {78}
  public void test1774() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x))/(1 - 2*x)^3, x]", //
        "3773/(64*(1 - 2*x)^2) - 3283/(16*(1 - 2*x)) - (1107*x)/16 - (135*x^2)/16 - (1071*Log[1 - 2*x])/8", //
        78);
  }

  // {78}
  public void test1775() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x))/(1 - 2*x)^3, x]", //
        "539/(32*(1 - 2*x)^2) - 707/(16*(1 - 2*x)) - (45*x)/8 - (309*Log[1 - 2*x])/16", //
        78);
  }

  // {78}
  public void test1776() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x))/(1 - 2*x)^3, x]", //
        "77/(16*(1 - 2*x)^2) - 17/(2*(1 - 2*x)) - (15*Log[1 - 2*x])/8", //
        78);
  }

  // {78}
  public void test1777() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^3*(2 + 3*x)), x]", //
        "11/(28*(1 - 2*x)^2) - 1/(49*(1 - 2*x)) + (3*Log[1 - 2*x])/343 - (3*Log[2 + 3*x])/343", //
        78);
  }

  // {78}
  public void test1778() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^3*(2 + 3*x)^2), x]", //
        "11/(98*(1 - 2*x)^2) + 31/(343*(1 - 2*x)) + 3/(343*(2 + 3*x)) - (87*Log[1 - 2*x])/2401 + (87*Log[2 + 3*x])/2401", //
        78);
  }

  // {78}
  public void test1779() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^3*(2 + 3*x)^3), x]", //
        "11/(343*(1 - 2*x)^2) + 128/(2401*(1 - 2*x)) + 3/(686*(2 + 3*x)^2) - 87/(2401*(2 + 3*x)) - (558*Log[1 - 2*x])/16807 + (558*Log[2 + 3*x])/16807", //
        78);
  }

  // {78}
  public void test1780() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^3*(2 + 3*x)^4), x]", //
        "22/(2401*(1 - 2*x)^2) + 388/(16807*(1 - 2*x)) + 1/(343*(2 + 3*x)^3) - 87/(4802*(2 + 3*x)^2) - 558/(16807*(2 + 3*x)) - (2280*Log[1 - 2*x])/117649 + (2280*Log[2 + 3*x])/117649", //
        78);
  }

  // {78}
  public void test1781() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^3*(2 + 3*x)^5), x]", //
        "44/(16807*(1 - 2*x)^2) + 1040/(117649*(1 - 2*x)) + 3/(1372*(2 + 3*x)^4) - 29/(2401*(2 + 3*x)^3) - 279/(16807*(2 + 3*x)^2) - 2280/(117649*(2 + 3*x)) - (7680*Log[1 - 2*x])/823543 + (7680*Log[2 + 3*x])/823543", //
        78);
  }

  // {78}
  public void test1782() {
    check( //
        "Integrate[(3 + 5*x)/((1 - 2*x)^3*(2 + 3*x)^6), x]", //
        "88/(117649*(1 - 2*x)^2) + 2608/(823543*(1 - 2*x)) + 3/(1715*(2 + 3*x)^5) - 87/(9604*(2 + 3*x)^4) - 186/(16807*(2 + 3*x)^3) - 1140/(117649*(2 + 3*x)^2) - 7680/(823543*(2 + 3*x)) - (3312*Log[1 - 2*x])/823543 + (3312*Log[2 + 3*x])/823543", //
        78);
  }

  // {90}
  public void test1783() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x)^2)/(1 - 2*x)^3, x]", //
        "99648703/(2048*(1 - 2*x)^2) - 389535839/(1024*(1 - 2*x)) - (48280011*x)/64 - (190742391*x^2)/512 - (25895367*x^3)/128 - (12299769*x^4)/128 - (2798631*x^5)/80 - (268515*x^6)/32 - (54675*x^7)/56 - (84589631*Log[1 - 2*x])/128", //
        90);
  }

  // {90}
  public void test1784() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x)^2)/(1 - 2*x)^3, x]", //
        "14235529/(1024*(1 - 2*x)^2) - 12386759/(128*(1 - 2*x)) - (39980457*x)/256 - (17700255*x^2)/256 - (1024389*x^3)/32 - (770067*x^4)/64 - (48843*x^5)/16 - (6075*x^6)/16 - (18859855*Log[1 - 2*x])/128", //
        90);
  }

  // {90}
  public void test1785() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^2)/(1 - 2*x)^3, x]", //
        "2033647/(512*(1 - 2*x)^2) - 6206585/(256*(1 - 2*x)) - (3907293*x)/128 - (747297*x^2)/64 - (69273*x^3)/16 - (73305*x^4)/64 - (1215*x^5)/8 - (8117095*Log[1 - 2*x])/256", //
        90);
  }

  // {90}
  public void test1786() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^2)/(1 - 2*x)^3, x]", //
        "290521/(256*(1 - 2*x)^2) - 381073/(64*(1 - 2*x)) - (176055*x)/32 - (54783*x^2)/32 - (7245*x^3)/16 - (2025*x^4)/32 - (832951*Log[1 - 2*x])/128", //
        90);
  }

  // {90}
  public void test1787() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^2)/(1 - 2*x)^3, x]", //
        "41503/(128*(1 - 2*x)^2) - 91091/(64*(1 - 2*x)) - (14031*x)/16 - (6345*x^2)/32 - (225*x^3)/8 - (39977*Log[1 - 2*x])/32", //
        90);
  }

  // {90}
  public void test1788() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^2)/(1 - 2*x)^3, x]", //
        "5929/(64*(1 - 2*x)^2) - 1309/(4*(1 - 2*x)) - (1815*x)/16 - (225*x^2)/16 - (3467*Log[1 - 2*x])/16", //
        90);
  }

  // {78}
  public void test1789() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^2)/(1 - 2*x)^3, x]", //
        "847/(32*(1 - 2*x)^2) - 1133/(16*(1 - 2*x)) - (75*x)/8 - (505*Log[1 - 2*x])/16", //
        78);
  }

  // {45}
  public void test1790() {
    check( //
        "Integrate[(3 + 5*x)^2/(1 - 2*x)^3, x]", //
        "121/(16*(1 - 2*x)^2) - 55/(4*(1 - 2*x)) - (25*Log[1 - 2*x])/8", //
        45);
  }

  // {90}
  public void test1791() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^3*(2 + 3*x)), x]", //
        "121/(56*(1 - 2*x)^2) - 407/(196*(1 - 2*x)) - Log[1 - 2*x]/343 + Log[2 + 3*x]/343", //
        90);
  }

  // {90}
  public void test1792() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^3*(2 + 3*x)^2), x]", //
        "121/(196*(1 - 2*x)^2) - 22/(343*(1 - 2*x)) - 1/(343*(2 + 3*x)) + (64*Log[1 - 2*x])/2401 - (64*Log[2 + 3*x])/2401", //
        90);
  }

  // {90}
  public void test1793() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^3*(2 + 3*x)^3), x]", //
        "121/(686*(1 - 2*x)^2) + 319/(2401*(1 - 2*x)) - 1/(686*(2 + 3*x)^2) + 64/(2401*(2 + 3*x)) - (829*Log[1 - 2*x])/16807 + (829*Log[2 + 3*x])/16807", //
        90);
  }

  // {90}
  public void test1794() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^3*(2 + 3*x)^4), x]", //
        "121/(2401*(1 - 2*x)^2) + 1364/(16807*(1 - 2*x)) - 1/(1029*(2 + 3*x)^3) + 32/(2401*(2 + 3*x)^2) - 829/(16807*(2 + 3*x)) - (5750*Log[1 - 2*x])/117649 + (5750*Log[2 + 3*x])/117649", //
        90);
  }

  // {90}
  public void test1795() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^3*(2 + 3*x)^5), x]", //
        "242/(16807*(1 - 2*x)^2) + 4180/(117649*(1 - 2*x)) - 1/(1372*(2 + 3*x)^4) + 64/(7203*(2 + 3*x)^3) - 829/(33614*(2 + 3*x)^2) - 5750/(117649*(2 + 3*x)) - (24040*Log[1 - 2*x])/823543 + (24040*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1796() {
    check( //
        "Integrate[(3 + 5*x)^2/((1 - 2*x)^3*(2 + 3*x)^6), x]", //
        "484/(117649*(1 - 2*x)^2) + 11264/(823543*(1 - 2*x)) - 1/(1715*(2 + 3*x)^5) + 16/(2401*(2 + 3*x)^4) - 829/(50421*(2 + 3*x)^3) - 2875/(117649*(2 + 3*x)^2) - 24040/(823543*(2 + 3*x)) - (11696*Log[1 - 2*x])/823543 + (11696*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1797() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x)^3)/(1 - 2*x)^3, x]", //
        "156590819/(2048*(1 - 2*x)^2) - 616195041/(1024*(1 - 2*x)) - (308539921*x)/256 - (306103815*x^2)/512 - (41793093*x^3)/128 - (19986237*x^4)/128 - (229149*x^5)/4 - (443475*x^6)/32 - (91125*x^7)/56 - (33674025*Log[1 - 2*x])/32", //
        90);
  }

  // {90}
  public void test1798() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^3)/(1 - 2*x)^3, x]", //
        "22370117/(1024*(1 - 2*x)^2) - 39220335/(256*(1 - 2*x)) - (64029233*x)/256 - (28504029*x^2)/256 - (1661133*x^3)/32 - (629505*x^4)/32 - (80595*x^5)/16 - (10125*x^6)/16 - (60160485*Log[1 - 2*x])/256", //
        90);
  }

  // {90}
  public void test1799() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^3)/(1 - 2*x)^3, x]", //
        "3195731/(512*(1 - 2*x)^2) - 9836211/(256*(1 - 2*x)) - (6277415*x)/128 - (1208973*x^2)/64 - 7065*x^3 - (120825*x^4)/64 - (2025*x^5)/8 - (12973191*Log[1 - 2*x])/256", //
        90);
  }

  // {90}
  public void test1800() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^3)/(1 - 2*x)^3, x]", //
        "456533/(256*(1 - 2*x)^2) - 302379/(32*(1 - 2*x)) - (284071*x)/32 - (44595*x^2)/16 - (11925*x^3)/16 - (3375*x^4)/32 - (1334949*Log[1 - 2*x])/128", //
        90);
  }

  // {90}
  public void test1801() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^3)/(1 - 2*x)^3, x]", //
        "65219/(128*(1 - 2*x)^2) - 144837/(64*(1 - 2*x)) - (5695*x)/4 - (10425*x^2)/32 - (375*x^3)/8 - (64317*Log[1 - 2*x])/32", //
        90);
  }

  // {78}
  public void test1802() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^3)/(1 - 2*x)^3, x]", //
        "9317/(64*(1 - 2*x)^2) - 8349/(16*(1 - 2*x)) - (2975*x)/16 - (375*x^2)/16 - (2805*Log[1 - 2*x])/8", //
        78);
  }

  // {45}
  public void test1803() {
    check( //
        "Integrate[(3 + 5*x)^3/(1 - 2*x)^3, x]", //
        "1331/(32*(1 - 2*x)^2) - 1815/(16*(1 - 2*x)) - (125*x)/8 - (825*Log[1 - 2*x])/16", //
        45);
  }

  // {90}
  public void test1804() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^3*(2 + 3*x)), x]", //
        "1331/(112*(1 - 2*x)^2) - 1089/(49*(1 - 2*x)) - (14289*Log[1 - 2*x])/2744 - Log[2 + 3*x]/1029", //
        90);
  }

  // {90}
  public void test1805() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^3*(2 + 3*x)^2), x]", //
        "1331/(392*(1 - 2*x)^2) - 4719/(1372*(1 - 2*x)) + 1/(1029*(2 + 3*x)) - (33*Log[1 - 2*x])/2401 + (33*Log[2 + 3*x])/2401", //
        90);
  }

  // {90}
  public void test1806() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^3*(2 + 3*x)^3), x]", //
        "1331/(1372*(1 - 2*x)^2) - 363/(2401*(1 - 2*x)) + 1/(2058*(2 + 3*x)^2) - 33/(2401*(2 + 3*x)) + (1023*Log[1 - 2*x])/16807 - (1023*Log[2 + 3*x])/16807", //
        90);
  }

  // {90}
  public void test1807() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^3*(2 + 3*x)^4), x]", //
        "1331/(4802*(1 - 2*x)^2) + 3267/(16807*(1 - 2*x)) + 1/(3087*(2 + 3*x)^3) - 33/(4802*(2 + 3*x)^2) + 1023/(16807*(2 + 3*x)) - (7755*Log[1 - 2*x])/117649 + (7755*Log[2 + 3*x])/117649", //
        90);
  }

  // {90}
  public void test1808() {
    check( //
        "Integrate[(3 + 5*x)^3/((1 - 2*x)^3*(2 + 3*x)^5), x]", //
        "1331/(16807*(1 - 2*x)^2) + 14520/(117649*(1 - 2*x)) + 1/(4116*(2 + 3*x)^4) - 11/(2401*(2 + 3*x)^3) + 1023/(33614*(2 + 3*x)^2) - 7755/(117649*(2 + 3*x)) - (59070*Log[1 - 2*x])/823543 + (59070*Log[2 + 3*x])/823543", //
        90);
  }

  // {90}
  public void test1809() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "5764801/(5632*(1 - 2*x)^2) - 188591347/(30976*(1 - 2*x)) - (2941619571*x)/400000 - (110180817*x^2)/40000 - (124416*x^3)/125 - (408969*x^4)/1600 - (6561*x^5)/200 - (2644396573*Log[1 - 2*x])/340736 + Log[3 + 5*x]/20796875", //
        90);
  }

  // {90}
  public void test1810() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "823543/(2816*(1 - 2*x)^2) - 5764801/(3872*(1 - 2*x)) - (26161299*x)/20000 - (792423*x^2)/2000 - (40581*x^3)/400 - (2187*x^4)/160 - (269063263*Log[1 - 2*x])/170368 + Log[3 + 5*x]/4159375", //
        90);
  }

  // {90}
  public void test1811() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "117649/(1408*(1 - 2*x)^2) - 2739541/(7744*(1 - 2*x)) - (102303*x)/500 - (35721*x^2)/800 - (243*x^3)/40 - (12761315*Log[1 - 2*x])/42592 + Log[3 + 5*x]/831875", //
        90);
  }

  // {90}
  public void test1812() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "16807/(704*(1 - 2*x)^2) - 156065/(1936*(1 - 2*x)) - (10287*x)/400 - (243*x^2)/80 - (543655*Log[1 - 2*x])/10648 + Log[3 + 5*x]/166375", //
        90);
  }

  // {90}
  public void test1813() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "2401/(352*(1 - 2*x)^2) - 33271/(1936*(1 - 2*x)) - (81*x)/40 - (153811*Log[1 - 2*x])/21296 + Log[3 + 5*x]/33275", //
        90);
  }

  // {90}
  public void test1814() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "343/(176*(1 - 2*x)^2) - 392/(121*(1 - 2*x)) - (7189*Log[1 - 2*x])/10648 + Log[3 + 5*x]/6655", //
        90);
  }

  // {90}
  public void test1815() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "49/(88*(1 - 2*x)^2) - 217/(484*(1 - 2*x)) - Log[1 - 2*x]/1331 + Log[3 + 5*x]/1331", //
        90);
  }

  // {78}
  public void test1816() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "7/(44*(1 - 2*x)^2) + 1/(121*(1 - 2*x)) - (5*Log[1 - 2*x])/1331 + (5*Log[3 + 5*x])/1331", //
        78);
  }

  // {46}
  public void test1817() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(3 + 5*x)), x]", //
        "1/(22*(1 - 2*x)^2) + 5/(121*(1 - 2*x)) - (25*Log[1 - 2*x])/1331 + (25*Log[3 + 5*x])/1331", //
        46);
  }

  // {84}
  public void test1818() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)*(3 + 5*x)), x]", //
        "1/(77*(1 - 2*x)^2) + 136/(5929*(1 - 2*x)) - (6938*Log[1 - 2*x])/456533 - (27*Log[2 + 3*x])/343 + (125*Log[3 + 5*x])/1331", //
        84);
  }

  // {90}
  public void test1819() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^2*(3 + 5*x)), x]", //
        "2/(539*(1 - 2*x)^2) + 404/(41503*(1 - 2*x)) + 27/(343*(2 + 3*x)) - (27208*Log[1 - 2*x])/3195731 - (1107*Log[2 + 3*x])/2401 + (625*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1820() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^3*(3 + 5*x)), x]", //
        "4/(3773*(1 - 2*x)^2) + 1072/(290521*(1 - 2*x)) + 27/(686*(2 + 3*x)^2) + 1107/(2401*(2 + 3*x)) - (89792*Log[1 - 2*x])/22370117 - (39393*Log[2 + 3*x])/16807 + (3125*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1821() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^4*(3 + 5*x)), x]", //
        "8/(26411*(1 - 2*x)^2) + 2672/(2033647*(1 - 2*x)) + 9/(343*(2 + 3*x)^3) + 1107/(4802*(2 + 3*x)^2) + 39393/(16807*(2 + 3*x)) - (267760*Log[1 - 2*x])/156590819 - (1380915*Log[2 + 3*x])/117649 + (15625*Log[3 + 5*x])/1331", //
        90);
  }

  // {90}
  public void test1822() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "5764801/(30976*(1 - 2*x)^2) - 79883671/(85184*(1 - 2*x)) - (81001863*x)/100000 - (4863159*x^2)/20000 - (123201*x^3)/2000 - (6561*x^4)/800 - 1/(20796875*(3 + 5*x)) - (1845559863*Log[1 - 2*x])/1874048 + (54*Log[3 + 5*x])/45753125", //
        90);
  }

  // {90}
  public void test1823() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "823543/(15488*(1 - 2*x)^2) - 18941489/(85184*(1 - 2*x)) - (1258983*x)/10000 - (108621*x^2)/4000 - (729*x^3)/200 - 1/(4159375*(3 + 5*x)) - (87177909*Log[1 - 2*x])/468512 + (237*Log[3 + 5*x])/45753125", //
        90);
  }

  // {90}
  public void test1824() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "117649/(7744*(1 - 2*x)^2) - 67228/(1331*(1 - 2*x)) - (31347*x)/2000 - (729*x^2)/400 - 1/(831875*(3 + 5*x)) - (7383075*Log[1 - 2*x])/234256 + (204*Log[3 + 5*x])/9150625", //
        90);
  }

  // {90}
  public void test1825() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "16807/(3872*(1 - 2*x)^2) - 228095/(21296*(1 - 2*x)) - (243*x)/200 - 1/(166375*(3 + 5*x)) - (1034145*Log[1 - 2*x])/234256 + (171*Log[3 + 5*x])/1830125", //
        90);
  }

  // {90}
  public void test1826() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "2401/(1936*(1 - 2*x)^2) - 10633/(5324*(1 - 2*x)) - 1/(33275*(3 + 5*x)) - (47481*Log[1 - 2*x])/117128 + (138*Log[3 + 5*x])/366025", //
        90);
  }

  // {90}
  public void test1827() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "343/(968*(1 - 2*x)^2) - 1421/(5324*(1 - 2*x)) - 1/(6655*(3 + 5*x)) - (21*Log[1 - 2*x])/14641 + (21*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1828() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "49/(484*(1 - 2*x)^2) + 14/(1331*(1 - 2*x)) - 1/(1331*(3 + 5*x)) - (72*Log[1 - 2*x])/14641 + (72*Log[3 + 5*x])/14641", //
        90);
  }

  // {78}
  public void test1829() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "7/(242*(1 - 2*x)^2) + 37/(1331*(1 - 2*x)) - 5/(1331*(3 + 5*x)) - (195*Log[1 - 2*x])/14641 + (195*Log[3 + 5*x])/14641", //
        78);
  }

  // {46}
  public void test1830() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(3 + 5*x)^2), x]", //
        "1/(121*(1 - 2*x)^2) + 20/(1331*(1 - 2*x)) - 25/(1331*(3 + 5*x)) - (150*Log[1 - 2*x])/14641 + (150*Log[3 + 5*x])/14641", //
        46);
  }

  // {90}
  public void test1831() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)*(3 + 5*x)^2), x]", //
        "2/(847*(1 - 2*x)^2) + 412/(65219*(1 - 2*x)) - 125/(1331*(3 + 5*x)) - (28296*Log[1 - 2*x])/5021863 + (81*Log[2 + 3*x])/343 - (3375*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1832() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^2*(3 + 5*x)^2), x]", //
        "4/(5929*(1 - 2*x)^2) + 1088/(456533*(1 - 2*x)) - 81/(343*(2 + 3*x)) - 625/(1331*(3 + 5*x)) - (92496*Log[1 - 2*x])/35153041 + (6156*Log[2 + 3*x])/2401 - (37500*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1833() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^3*(3 + 5*x)^2), x]", //
        "8/(41503*(1 - 2*x)^2) + 2704/(3195731*(1 - 2*x)) - 81/(686*(2 + 3*x)^2) - 6156/(2401*(2 + 3*x)) - 3125/(1331*(3 + 5*x)) - (274224*Log[1 - 2*x])/246071287 + (333639*Log[2 + 3*x])/16807 - (290625*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1834() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^4*(3 + 5*x)^2), x]", //
        "16/(290521*(1 - 2*x)^2) + 6464/(22370117*(1 - 2*x)) - 27/(343*(2 + 3*x)^3) - 3078/(2401*(2 + 3*x)^2) - 333639/(16807*(2 + 3*x)) - 15625/(1331*(3 + 5*x)) - (761760*Log[1 - 2*x])/1722499009 + (15820110*Log[2 + 3*x])/117649 - (1968750*Log[3 + 5*x])/14641", //
        90);
  }

  // {90}
  public void test1835() {
    check( //
        "Integrate[(2 + 3*x)^9/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "40353607/(340736*(1 - 2*x)^2) - 17294403/(29282*(1 - 2*x)) - (50150097*x)/100000 - (7459857*x^2)/50000 - (373977*x^3)/10000 - (19683*x^4)/4000 - 1/(207968750*(3 + 5*x)^2) - 303/(1143828125*(3 + 5*x)) - (12657032367*Log[1 - 2*x])/20614528 + (8202*Log[3 + 5*x])/2516421875", //
        90);
  }

  // {90}
  public void test1836() {
    check( //
        "Integrate[(2 + 3*x)^8/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "5764801/(170368*(1 - 2*x)^2) - 130943337/(937024*(1 - 2*x)) - (242028*x)/3125 - (330237*x^2)/20000 - (2187*x^3)/1000 - 1/(41593750*(3 + 5*x)^2) - 54/(45753125*(3 + 5*x)) - (595421589*Log[1 - 2*x])/5153632 + (1284*Log[3 + 5*x])/100656875", //
        90);
  }

  // {90}
  public void test1837() {
    check( //
        "Integrate[(2 + 3*x)^7/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "823543/(85184*(1 - 2*x)^2) - 7411887/(234256*(1 - 2*x)) - (95499*x)/10000 - (2187*x^2)/2000 - 1/(8318750*(3 + 5*x)^2) - 237/(45753125*(3 + 5*x)) - (25059237*Log[1 - 2*x])/1288408 + (24279*Log[3 + 5*x])/503284375", //
        90);
  }

  // {90}
  public void test1838() {
    check( //
        "Integrate[(2 + 3*x)^6/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "117649/(42592*(1 - 2*x)^2) - 1563051/(234256*(1 - 2*x)) - (729*x)/1000 - 1/(1663750*(3 + 5*x)^2) - 204/(9150625*(3 + 5*x)) - (6950895*Log[1 - 2*x])/2576816 + (17547*Log[3 + 5*x])/100656875", //
        90);
  }

  // {90}
  public void test1839() {
    check( //
        "Integrate[(2 + 3*x)^5/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "16807/(21296*(1 - 2*x)^2) - 36015/(29282*(1 - 2*x)) - 1/(332750*(3 + 5*x)^2) - 171/(1830125*(3 + 5*x)) - (313845*Log[1 - 2*x])/1288408 + (11904*Log[3 + 5*x])/20131375", //
        90);
  }

  // {90}
  public void test1840() {
    check( //
        "Integrate[(2 + 3*x)^4/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "2401/(10648*(1 - 2*x)^2) - 9261/(58564*(1 - 2*x)) - 1/(66550*(3 + 5*x)^2) - 138/(366025*(3 + 5*x)) - (294*Log[1 - 2*x])/161051 + (294*Log[3 + 5*x])/161051", //
        90);
  }

  // {90}
  public void test1841() {
    check( //
        "Integrate[(2 + 3*x)^3/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "343/(5324*(1 - 2*x)^2) + 147/(14641*(1 - 2*x)) - 1/(13310*(3 + 5*x)^2) - 21/(14641*(3 + 5*x)) - (777*Log[1 - 2*x])/161051 + (777*Log[3 + 5*x])/161051", //
        90);
  }

  // {90}
  public void test1842() {
    check( //
        "Integrate[(2 + 3*x)^2/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "49/(2662*(1 - 2*x)^2) + 273/(14641*(1 - 2*x)) - 1/(2662*(3 + 5*x)^2) - 72/(14641*(3 + 5*x)) - (1509*Log[1 - 2*x])/161051 + (1509*Log[3 + 5*x])/161051", //
        90);
  }

  // {78}
  public void test1843() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "7/(1331*(1 - 2*x)^2) + 144/(14641*(1 - 2*x)) - 5/(2662*(3 + 5*x)^2) - 195/(14641*(3 + 5*x)) - (1110*Log[1 - 2*x])/161051 + (1110*Log[3 + 5*x])/161051", //
        78);
  }

  // {46}
  public void test1844() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(3 + 5*x)^3), x]", //
        "2/(1331*(1 - 2*x)^2) + 60/(14641*(1 - 2*x)) - 25/(2662*(3 + 5*x)^2) - 150/(14641*(3 + 5*x)) - (600*Log[1 - 2*x])/161051 + (600*Log[3 + 5*x])/161051", //
        46);
  }

  // {90}
  public void test1845() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)*(3 + 5*x)^3), x]", //
        "4/(9317*(1 - 2*x)^2) + 1104/(717409*(1 - 2*x)) - 125/(2662*(3 + 5*x)^2) + 3375/(14641*(3 + 5*x)) - (95232*Log[1 - 2*x])/55240493 - (243*Log[2 + 3*x])/343 + (114375*Log[3 + 5*x])/161051", //
        90);
  }

  // {90}
  public void test1846() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^2*(3 + 5*x)^3), x]", //
        "8/(65219*(1 - 2*x)^2) + 2736/(5021863*(1 - 2*x)) + 243/(343*(2 + 3*x)) - 625/(2662*(3 + 5*x)^2) + 37500/(14641*(3 + 5*x)) - (280752*Log[1 - 2*x])/386683451 - (26973*Log[2 + 3*x])/2401 + (1809375*Log[3 + 5*x])/161051", //
        90);
  }

  // {90}
  public void test1847() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^3*(3 + 5*x)^3), x]", //
        "16/(456533*(1 - 2*x)^2) + 6528/(35153041*(1 - 2*x)) + 243/(686*(2 + 3*x)^2) + 26973/(2401*(2 + 3*x)) - 3125/(2662*(3 + 5*x)^2) + 290625/(14641*(3 + 5*x)) - (776928*Log[1 - 2*x])/2706784157 - (1944972*Log[2 + 3*x])/16807 + (18637500*Log[3 + 5*x])/161051", //
        90);
  }

  // {90}
  public void test1848() {
    check( //
        "Integrate[1/((1 - 2*x)^3*(2 + 3*x)^4*(3 + 5*x)^3), x]", //
        "32/(3195731*(1 - 2*x)^2) + 15168/(246071287*(1 - 2*x)) + 81/(343*(2 + 3*x)^3) + 26973/(4802*(2 + 3*x)^2) + 1944972/(16807*(2 + 3*x)) - 15625/(2662*(3 + 5*x)^2) + 1968750/(14641*(3 + 5*x)) - (2054400*Log[1 - 2*x])/18947489099 - (115534350*Log[2 + 3*x])/117649 + (158156250*Log[3 + 5*x])/161051", //
        90);
  }

  // {90}
  public void test1849() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^3*(e + f*x)^3, x]", //
        "((b*c - a*d)^3*(b*e - a*f)^3*(a + b*x)^4)/(4*b^7) + (3*(b*c - a*d)^2*(b*e - a*f)^2*(b*d*e + b*c*f - 2*a*d*f)*(a + b*x)^5)/(5*b^7) + ((b*c - a*d)*(b*e - a*f)*(5*a^2*d^2*f^2 - 5*a*b*d*f*(d*e + c*f) + b^2*(d^2*e^2 + 3*c*d*e*f + c^2*f^2))*(a + b*x)^6)/(2*b^7) + ((b*d*e + b*c*f - 2*a*d*f)*(10*a^2*d^2*f^2 - 10*a*b*d*f*(d*e + c*f) + b^2*(d^2*e^2 + 8*c*d*e*f + c^2*f^2))*(a + b*x)^7)/(7*b^7) + (3*d*f*(5*a^2*d^2*f^2 - 5*a*b*d*f*(d*e + c*f) + b^2*(d^2*e^2 + 3*c*d*e*f + c^2*f^2))*(a + b*x)^8)/(8*b^7) + (d^2*f^2*(b*d*e + b*c*f - 2*a*d*f)*(a + b*x)^9)/(3*b^7) + (d^3*f^3*(a + b*x)^10)/(10*b^7)", //
        90);
  }

  // {90}
  public void test1850() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^2*(e + f*x)^2, x]", //
        "((b*c - a*d)^2*(b*e - a*f)^2*(a + b*x)^3)/(3*b^5) + ((b*c - a*d)*(b*e - a*f)*(b*d*e + b*c*f - 2*a*d*f)*(a + b*x)^4)/(2*b^5) + ((6*a^2*d^2*f^2 - 6*a*b*d*f*(d*e + c*f) + b^2*(d^2*e^2 + 4*c*d*e*f + c^2*f^2))*(a + b*x)^5)/(5*b^5) + (d*f*(b*d*e + b*c*f - 2*a*d*f)*(a + b*x)^6)/(3*b^5) + (d^2*f^2*(a + b*x)^7)/(7*b^5)", //
        90);
  }

  // {78}
  public void test1851() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)*(e + f*x), x]", //
        "a*c*e*x + ((b*c*e + a*d*e + a*c*f)*x^2)/2 + ((b*d*e + b*c*f + a*d*f)*x^3)/3 + (b*d*f*x^4)/4", //
        78);
  }

  // {84}
  public void test1852() {
    check( //
        "Integrate[1/((a + b*x)*(c + d*x)*(e + f*x)), x]", //
        "(b*Log[a + b*x])/((b*c - a*d)*(b*e - a*f)) - (d*Log[c + d*x])/((b*c - a*d)*(d*e - c*f)) + (f*Log[e + f*x])/((b*e - a*f)*(d*e - c*f))", //
        84);
  }

  // {90}
  public void test1853() {
    check( //
        "Integrate[1/((a + b*x)^2*(c + d*x)^2*(e + f*x)^2), x]", //
        "-(b^3/((b*c - a*d)^2*(b*e - a*f)^2*(a + b*x))) - d^3/((b*c - a*d)^2*(d*e - c*f)^2*(c + d*x)) - f^3/((b*e - a*f)^2*(d*e - c*f)^2*(e + f*x)) - (2*b^3*(b*d*e + b*c*f - 2*a*d*f)*Log[a + b*x])/((b*c - a*d)^3*(b*e - a*f)^3) + (2*d^3*(b*d*e - 2*b*c*f + a*d*f)*Log[c + d*x])/((b*c - a*d)^3*(d*e - c*f)^3) + (2*f^3*(2*b*d*e - b*c*f - a*d*f)*Log[e + f*x])/((b*e - a*f)^3*(d*e - c*f)^3)", //
        90);
  }

  // {90}
  public void test1854() {
    check( //
        "Integrate[1/((a + b*x)^3*(c + d*x)^3*(e + f*x)^3), x]", //
        "-b^5/(2*(b*c - a*d)^3*(b*e - a*f)^3*(a + b*x)^2) + (3*b^5*(b*d*e + b*c*f - 2*a*d*f))/((b*c - a*d)^4*(b*e - a*f)^4*(a + b*x)) + d^5/(2*(b*c - a*d)^3*(d*e - c*f)^3*(c + d*x)^2) + (3*d^5*(b*d*e - 2*b*c*f + a*d*f))/((b*c - a*d)^4*(d*e - c*f)^4*(c + d*x)) - f^5/(2*(b*e - a*f)^3*(d*e - c*f)^3*(e + f*x)^2) - (3*f^5*(2*b*d*e - b*c*f - a*d*f))/((b*e - a*f)^4*(d*e - c*f)^4*(e + f*x)) + (3*b^5*(7*a^2*d^2*f^2 - 7*a*b*d*f*(d*e + c*f) + b^2*(2*d^2*e^2 + 3*c*d*e*f + 2*c^2*f^2))*Log[a + b*x])/((b*c - a*d)^5*(b*e - a*f)^5) - (3*d^5*(2*a^2*d^2*f^2 + a*b*d*f*(3*d*e - 7*c*f) + b^2*(2*d^2*e^2 - 7*c*d*e*f + 7*c^2*f^2))*Log[c + d*x])/((b*c - a*d)^5*(d*e - c*f)^5) + (3*f^5*(2*a^2*d^2*f^2 - a*b*d*f*(7*d*e - 3*c*f) + b^2*(7*d^2*e^2 - 7*c*d*e*f + 2*c^2*f^2))*Log[e + f*x])/((b*e - a*f)^5*(d*e - c*f)^5)", //
        90);
  }

  // {78}
  public void test1855() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*(d + e*x)^(7/2), x]", //
        "(2*(b*d - a*e)*(B*d - A*e)*(d + e*x)^(9/2))/(9*e^3) - (2*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(11/2))/(11*e^3) + (2*b*B*(d + e*x)^(13/2))/(13*e^3)", //
        78);
  }

  // {78}
  public void test1856() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*(d + e*x)^(5/2), x]", //
        "(2*(b*d - a*e)*(B*d - A*e)*(d + e*x)^(7/2))/(7*e^3) - (2*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(9/2))/(9*e^3) + (2*b*B*(d + e*x)^(11/2))/(11*e^3)", //
        78);
  }

  // {78}
  public void test1857() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*(d + e*x)^(3/2), x]", //
        "(2*(b*d - a*e)*(B*d - A*e)*(d + e*x)^(5/2))/(5*e^3) - (2*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(7/2))/(7*e^3) + (2*b*B*(d + e*x)^(9/2))/(9*e^3)", //
        78);
  }

  // {78}
  public void test1858() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*Sqrt[d + e*x], x]", //
        "(2*(b*d - a*e)*(B*d - A*e)*(d + e*x)^(3/2))/(3*e^3) - (2*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(5/2))/(5*e^3) + (2*b*B*(d + e*x)^(7/2))/(7*e^3)", //
        78);
  }

  // {78}
  public void test1859() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/Sqrt[d + e*x], x]", //
        "(2*(b*d - a*e)*(B*d - A*e)*Sqrt[d + e*x])/e^3 - (2*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(3/2))/(3*e^3) + (2*b*B*(d + e*x)^(5/2))/(5*e^3)", //
        78);
  }

  // {78}
  public void test1860() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x)^(3/2), x]", //
        "(-2*(b*d - a*e)*(B*d - A*e))/(e^3*Sqrt[d + e*x]) - (2*(2*b*B*d - A*b*e - a*B*e)*Sqrt[d + e*x])/e^3 + (2*b*B*(d + e*x)^(3/2))/(3*e^3)", //
        78);
  }

  // {78}
  public void test1861() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x)^(5/2), x]", //
        "(-2*(b*d - a*e)*(B*d - A*e))/(3*e^3*(d + e*x)^(3/2)) + (2*(2*b*B*d - A*b*e - a*B*e))/(e^3*Sqrt[d + e*x]) + (2*b*B*Sqrt[d + e*x])/e^3", //
        78);
  }

  // {78}
  public void test1862() {
    check( //
        "Integrate[((a + b*x)*(A + B*x))/(d + e*x)^(7/2), x]", //
        "(-2*(b*d - a*e)*(B*d - A*e))/(5*e^3*(d + e*x)^(5/2)) + (2*(2*b*B*d - A*b*e - a*B*e))/(3*e^3*(d + e*x)^(3/2)) - (2*b*B)/(e^3*Sqrt[d + e*x])", //
        78);
  }

  // {78}
  public void test1863() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*(d + e*x)^(7/2), x]", //
        "(-2*(b*d - a*e)^2*(B*d - A*e)*(d + e*x)^(9/2))/(9*e^4) + (2*(b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*(d + e*x)^(11/2))/(11*e^4) - (2*b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^(13/2))/(13*e^4) + (2*b^2*B*(d + e*x)^(15/2))/(15*e^4)", //
        78);
  }

  // {78}
  public void test1864() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*(d + e*x)^(5/2), x]", //
        "(-2*(b*d - a*e)^2*(B*d - A*e)*(d + e*x)^(7/2))/(7*e^4) + (2*(b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*(d + e*x)^(9/2))/(9*e^4) - (2*b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^(11/2))/(11*e^4) + (2*b^2*B*(d + e*x)^(13/2))/(13*e^4)", //
        78);
  }

  // {78}
  public void test1865() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*(d + e*x)^(3/2), x]", //
        "(-2*(b*d - a*e)^2*(B*d - A*e)*(d + e*x)^(5/2))/(5*e^4) + (2*(b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*(d + e*x)^(7/2))/(7*e^4) - (2*b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^(9/2))/(9*e^4) + (2*b^2*B*(d + e*x)^(11/2))/(11*e^4)", //
        78);
  }

  // {78}
  public void test1866() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*Sqrt[d + e*x], x]", //
        "(-2*(b*d - a*e)^2*(B*d - A*e)*(d + e*x)^(3/2))/(3*e^4) + (2*(b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*(d + e*x)^(5/2))/(5*e^4) - (2*b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^(7/2))/(7*e^4) + (2*b^2*B*(d + e*x)^(9/2))/(9*e^4)", //
        78);
  }

  // {78}
  public void test1867() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/Sqrt[d + e*x], x]", //
        "(-2*(b*d - a*e)^2*(B*d - A*e)*Sqrt[d + e*x])/e^4 + (2*(b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*(d + e*x)^(3/2))/(3*e^4) - (2*b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^(5/2))/(5*e^4) + (2*b^2*B*(d + e*x)^(7/2))/(7*e^4)", //
        78);
  }

  // {78}
  public void test1868() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^(3/2), x]", //
        "(2*(b*d - a*e)^2*(B*d - A*e))/(e^4*Sqrt[d + e*x]) + (2*(b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*Sqrt[d + e*x])/e^4 - (2*b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^(3/2))/(3*e^4) + (2*b^2*B*(d + e*x)^(5/2))/(5*e^4)", //
        78);
  }

  // {78}
  public void test1869() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^(5/2), x]", //
        "(2*(b*d - a*e)^2*(B*d - A*e))/(3*e^4*(d + e*x)^(3/2)) - (2*(b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e))/(e^4*Sqrt[d + e*x]) - (2*b*(3*b*B*d - A*b*e - 2*a*B*e)*Sqrt[d + e*x])/e^4 + (2*b^2*B*(d + e*x)^(3/2))/(3*e^4)", //
        78);
  }

  // {78}
  public void test1870() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x))/(d + e*x)^(7/2), x]", //
        "(2*(b*d - a*e)^2*(B*d - A*e))/(5*e^4*(d + e*x)^(5/2)) - (2*(b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e))/(3*e^4*(d + e*x)^(3/2)) + (2*b*(3*b*B*d - A*b*e - 2*a*B*e))/(e^4*Sqrt[d + e*x]) + (2*b^2*B*Sqrt[d + e*x])/e^4", //
        78);
  }

  // {78}
  public void test1871() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x)^(7/2), x]", //
        "(2*(b*d - a*e)^3*(B*d - A*e)*(d + e*x)^(9/2))/(9*e^5) - (2*(b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*(d + e*x)^(11/2))/(11*e^5) + (6*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(13/2))/(13*e^5) - (2*b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^(15/2))/(15*e^5) + (2*b^3*B*(d + e*x)^(17/2))/(17*e^5)", //
        78);
  }

  // {78}
  public void test1872() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x)^(5/2), x]", //
        "(2*(b*d - a*e)^3*(B*d - A*e)*(d + e*x)^(7/2))/(7*e^5) - (2*(b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*(d + e*x)^(9/2))/(9*e^5) + (6*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(11/2))/(11*e^5) - (2*b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^(13/2))/(13*e^5) + (2*b^3*B*(d + e*x)^(15/2))/(15*e^5)", //
        78);
  }

  // {78}
  public void test1873() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x)^(3/2), x]", //
        "(2*(b*d - a*e)^3*(B*d - A*e)*(d + e*x)^(5/2))/(5*e^5) - (2*(b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*(d + e*x)^(7/2))/(7*e^5) + (2*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(9/2))/(3*e^5) - (2*b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^(11/2))/(11*e^5) + (2*b^3*B*(d + e*x)^(13/2))/(13*e^5)", //
        78);
  }

  // {78}
  public void test1874() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*Sqrt[d + e*x], x]", //
        "(2*(b*d - a*e)^3*(B*d - A*e)*(d + e*x)^(3/2))/(3*e^5) - (2*(b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*(d + e*x)^(5/2))/(5*e^5) + (6*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(7/2))/(7*e^5) - (2*b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^(9/2))/(9*e^5) + (2*b^3*B*(d + e*x)^(11/2))/(11*e^5)", //
        78);
  }

  // {78}
  public void test1875() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/Sqrt[d + e*x], x]", //
        "(2*(b*d - a*e)^3*(B*d - A*e)*Sqrt[d + e*x])/e^5 - (2*(b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*(d + e*x)^(3/2))/(3*e^5) + (6*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(5/2))/(5*e^5) - (2*b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^(7/2))/(7*e^5) + (2*b^3*B*(d + e*x)^(9/2))/(9*e^5)", //
        78);
  }

  // {78}
  public void test1876() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^(3/2), x]", //
        "(-2*(b*d - a*e)^3*(B*d - A*e))/(e^5*Sqrt[d + e*x]) - (2*(b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*Sqrt[d + e*x])/e^5 + (2*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(3/2))/e^5 - (2*b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^(5/2))/(5*e^5) + (2*b^3*B*(d + e*x)^(7/2))/(7*e^5)", //
        78);
  }

  // {78}
  public void test1877() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^(5/2), x]", //
        "(-2*(b*d - a*e)^3*(B*d - A*e))/(3*e^5*(d + e*x)^(3/2)) + (2*(b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e))/(e^5*Sqrt[d + e*x]) + (6*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*Sqrt[d + e*x])/e^5 - (2*b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^(3/2))/(3*e^5) + (2*b^3*B*(d + e*x)^(5/2))/(5*e^5)", //
        78);
  }

  // {78}
  public void test1878() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x))/(d + e*x)^(7/2), x]", //
        "(-2*(b*d - a*e)^3*(B*d - A*e))/(5*e^5*(d + e*x)^(5/2)) + (2*(b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e))/(3*e^5*(d + e*x)^(3/2)) - (6*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e))/(e^5*Sqrt[d + e*x]) - (2*b^2*(4*b*B*d - A*b*e - 3*a*B*e)*Sqrt[d + e*x])/e^5 + (2*b^3*B*(d + e*x)^(3/2))/(3*e^5)", //
        78);
  }

  // {78}
  public void test1879() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^6*(3 + 5*x), x]", //
        "(-1294139*(1 - 2*x)^(3/2))/384 + (3916031*(1 - 2*x)^(5/2))/640 - (725445*(1 - 2*x)^(7/2))/128 + (406455*(1 - 2*x)^(9/2))/128 - (1580985*(1 - 2*x)^(11/2))/1408 + (409941*(1 - 2*x)^(13/2))/1664 - (19683*(1 - 2*x)^(15/2))/640 + (3645*(1 - 2*x)^(17/2))/2176", //
        78);
  }

  // {78}
  public void test1880() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^5*(3 + 5*x), x]", //
        "(-184877*(1 - 2*x)^(3/2))/192 + (12005*(1 - 2*x)^(5/2))/8 - (74235*(1 - 2*x)^(7/2))/64 + (4165*(1 - 2*x)^(9/2))/8 - (97335*(1 - 2*x)^(11/2))/704 + (81*(1 - 2*x)^(13/2))/4 - (81*(1 - 2*x)^(15/2))/64", //
        78);
  }

  // {78}
  public void test1881() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^4*(3 + 5*x), x]", //
        "(-26411*(1 - 2*x)^(3/2))/96 + (57281*(1 - 2*x)^(5/2))/160 - (3549*(1 - 2*x)^(7/2))/16 + (1197*(1 - 2*x)^(9/2))/16 - (4671*(1 - 2*x)^(11/2))/352 + (405*(1 - 2*x)^(13/2))/416", //
        78);
  }

  // {78}
  public void test1882() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^3*(3 + 5*x), x]", //
        "(-3773*(1 - 2*x)^(3/2))/48 + (3283*(1 - 2*x)^(5/2))/40 - (153*(1 - 2*x)^(7/2))/4 + (69*(1 - 2*x)^(9/2))/8 - (135*(1 - 2*x)^(11/2))/176", //
        78);
  }

  // {78}
  public void test1883() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^2*(3 + 5*x), x]", //
        "(-539*(1 - 2*x)^(3/2))/24 + (707*(1 - 2*x)^(5/2))/40 - (309*(1 - 2*x)^(7/2))/56 + (5*(1 - 2*x)^(9/2))/8", //
        78);
  }

  // {78}
  public void test1884() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)*(3 + 5*x), x]", //
        "(-77*(1 - 2*x)^(3/2))/12 + (17*(1 - 2*x)^(5/2))/5 - (15*(1 - 2*x)^(7/2))/28", //
        78);
  }

  // {45}
  public void test1885() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(3 + 5*x), x]", //
        "(-11*(1 - 2*x)^(3/2))/6 + (1 - 2*x)^(5/2)/2", //
        45);
  }

  // {90}
  public void test1886() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^4*(3 + 5*x)^2, x]", //
        "(-290521*(1 - 2*x)^(3/2))/192 + (381073*(1 - 2*x)^(5/2))/160 - (118993*(1 - 2*x)^(7/2))/64 + (40453*(1 - 2*x)^(9/2))/48 - (159111*(1 - 2*x)^(11/2))/704 + (13905*(1 - 2*x)^(13/2))/416 - (135*(1 - 2*x)^(15/2))/64", //
        90);
  }

  // {90}
  public void test1887() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^3*(3 + 5*x)^2, x]", //
        "(-41503*(1 - 2*x)^(3/2))/96 + (91091*(1 - 2*x)^(5/2))/160 - (5711*(1 - 2*x)^(7/2))/16 + (1949*(1 - 2*x)^(9/2))/16 - (7695*(1 - 2*x)^(11/2))/352 + (675*(1 - 2*x)^(13/2))/416", //
        90);
  }

  // {90}
  public void test1888() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^2*(3 + 5*x)^2, x]", //
        "(-5929*(1 - 2*x)^(3/2))/48 + (1309*(1 - 2*x)^(5/2))/10 - (3467*(1 - 2*x)^(7/2))/56 + (85*(1 - 2*x)^(9/2))/6 - (225*(1 - 2*x)^(11/2))/176", //
        90);
  }

  // {78}
  public void test1889() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)*(3 + 5*x)^2, x]", //
        "(-847*(1 - 2*x)^(3/2))/24 + (1133*(1 - 2*x)^(5/2))/40 - (505*(1 - 2*x)^(7/2))/56 + (25*(1 - 2*x)^(9/2))/24", //
        78);
  }

  // {45}
  public void test1890() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(3 + 5*x)^2, x]", //
        "(-121*(1 - 2*x)^(3/2))/12 + (11*(1 - 2*x)^(5/2))/2 - (25*(1 - 2*x)^(7/2))/28", //
        45);
  }

  // {90}
  public void test1891() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^4*(3 + 5*x)^3, x]", //
        "(-3195731*(1 - 2*x)^(3/2))/384 + (9836211*(1 - 2*x)^(5/2))/640 - (1853313*(1 - 2*x)^(7/2))/128 + (9504551*(1 - 2*x)^(9/2))/1152 - (4177401*(1 - 2*x)^(11/2))/1408 + (1101465*(1 - 2*x)^(13/2))/1664 - (10755*(1 - 2*x)^(15/2))/128 + (10125*(1 - 2*x)^(17/2))/2176", //
        90);
  }

  // {90}
  public void test1892() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^3*(3 + 5*x)^3, x]", //
        "(-456533*(1 - 2*x)^(3/2))/192 + (302379*(1 - 2*x)^(5/2))/80 - (190707*(1 - 2*x)^(7/2))/64 + (98209*(1 - 2*x)^(9/2))/72 - (260055*(1 - 2*x)^(11/2))/704 + (11475*(1 - 2*x)^(13/2))/208 - (225*(1 - 2*x)^(15/2))/64", //
        90);
  }

  // {90}
  public void test1893() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)^2*(3 + 5*x)^3, x]", //
        "(-65219*(1 - 2*x)^(3/2))/96 + (144837*(1 - 2*x)^(5/2))/160 - (64317*(1 - 2*x)^(7/2))/112 + (28555*(1 - 2*x)^(9/2))/144 - (12675*(1 - 2*x)^(11/2))/352 + (1125*(1 - 2*x)^(13/2))/416", //
        90);
  }

  // {78}
  public void test1894() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(2 + 3*x)*(3 + 5*x)^3, x]", //
        "(-9317*(1 - 2*x)^(3/2))/48 + (8349*(1 - 2*x)^(5/2))/40 - (2805*(1 - 2*x)^(7/2))/28 + (1675*(1 - 2*x)^(9/2))/72 - (375*(1 - 2*x)^(11/2))/176", //
        78);
  }

  // {45}
  public void test1895() {
    check( //
        "Integrate[Sqrt[1 - 2*x]*(3 + 5*x)^3, x]", //
        "(-1331*(1 - 2*x)^(3/2))/24 + (363*(1 - 2*x)^(5/2))/8 - (825*(1 - 2*x)^(7/2))/56 + (125*(1 - 2*x)^(9/2))/72", //
        45);
  }

  // {78}
  public void test1896() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^6*(3 + 5*x), x]", //
        "(-1294139*(1 - 2*x)^(5/2))/640 + (559433*(1 - 2*x)^(7/2))/128 - (564235*(1 - 2*x)^(9/2))/128 + (3658095*(1 - 2*x)^(11/2))/1408 - (1580985*(1 - 2*x)^(13/2))/1664 + (136647*(1 - 2*x)^(15/2))/640 - (59049*(1 - 2*x)^(17/2))/2176 + (3645*(1 - 2*x)^(19/2))/2432", //
        78);
  }

  // {78}
  public void test1897() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^5*(3 + 5*x), x]", //
        "(-184877*(1 - 2*x)^(5/2))/320 + (8575*(1 - 2*x)^(7/2))/8 - (173215*(1 - 2*x)^(9/2))/192 + (37485*(1 - 2*x)^(11/2))/88 - (97335*(1 - 2*x)^(13/2))/832 + (351*(1 - 2*x)^(15/2))/20 - (1215*(1 - 2*x)^(17/2))/1088", //
        78);
  }

  // {78}
  public void test1898() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^4*(3 + 5*x), x]", //
        "(-26411*(1 - 2*x)^(5/2))/160 + (8183*(1 - 2*x)^(7/2))/32 - (8281*(1 - 2*x)^(9/2))/48 + (10773*(1 - 2*x)^(11/2))/176 - (4671*(1 - 2*x)^(13/2))/416 + (27*(1 - 2*x)^(15/2))/32", //
        78);
  }

  // {78}
  public void test1899() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^3*(3 + 5*x), x]", //
        "(-3773*(1 - 2*x)^(5/2))/80 + (469*(1 - 2*x)^(7/2))/8 - (119*(1 - 2*x)^(9/2))/4 + (621*(1 - 2*x)^(11/2))/88 - (135*(1 - 2*x)^(13/2))/208", //
        78);
  }

  // {78}
  public void test1900() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^2*(3 + 5*x), x]", //
        "(-539*(1 - 2*x)^(5/2))/40 + (101*(1 - 2*x)^(7/2))/8 - (103*(1 - 2*x)^(9/2))/24 + (45*(1 - 2*x)^(11/2))/88", //
        78);
  }

  // {78}
  public void test1901() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)*(3 + 5*x), x]", //
        "(-77*(1 - 2*x)^(5/2))/20 + (17*(1 - 2*x)^(7/2))/7 - (5*(1 - 2*x)^(9/2))/12", //
        78);
  }

  // {45}
  public void test1902() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(3 + 5*x), x]", //
        "(-11*(1 - 2*x)^(5/2))/10 + (5*(1 - 2*x)^(7/2))/14", //
        45);
  }

  // {90}
  public void test1903() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^4*(3 + 5*x)^2, x]", //
        "(-290521*(1 - 2*x)^(5/2))/320 + (54439*(1 - 2*x)^(7/2))/32 - (832951*(1 - 2*x)^(9/2))/576 + (121359*(1 - 2*x)^(11/2))/176 - (159111*(1 - 2*x)^(13/2))/832 + (927*(1 - 2*x)^(15/2))/32 - (2025*(1 - 2*x)^(17/2))/1088", //
        90);
  }

  // {90}
  public void test1904() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^3*(3 + 5*x)^2, x]", //
        "(-41503*(1 - 2*x)^(5/2))/160 + (13013*(1 - 2*x)^(7/2))/32 - (39977*(1 - 2*x)^(9/2))/144 + (17541*(1 - 2*x)^(11/2))/176 - (7695*(1 - 2*x)^(13/2))/416 + (45*(1 - 2*x)^(15/2))/32", //
        90);
  }

  // {90}
  public void test1905() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^2*(3 + 5*x)^2, x]", //
        "(-5929*(1 - 2*x)^(5/2))/80 + (187*(1 - 2*x)^(7/2))/2 - (3467*(1 - 2*x)^(9/2))/72 + (255*(1 - 2*x)^(11/2))/22 - (225*(1 - 2*x)^(13/2))/208", //
        90);
  }

  // {78}
  public void test1906() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)*(3 + 5*x)^2, x]", //
        "(-847*(1 - 2*x)^(5/2))/40 + (1133*(1 - 2*x)^(7/2))/56 - (505*(1 - 2*x)^(9/2))/72 + (75*(1 - 2*x)^(11/2))/88", //
        78);
  }

  // {45}
  public void test1907() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(3 + 5*x)^2, x]", //
        "(-121*(1 - 2*x)^(5/2))/20 + (55*(1 - 2*x)^(7/2))/14 - (25*(1 - 2*x)^(9/2))/36", //
        45);
  }

  // {90}
  public void test1908() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^4*(3 + 5*x)^3, x]", //
        "(-3195731*(1 - 2*x)^(5/2))/640 + (1405173*(1 - 2*x)^(7/2))/128 - (4324397*(1 - 2*x)^(9/2))/384 + (9504551*(1 - 2*x)^(11/2))/1408 - (4177401*(1 - 2*x)^(13/2))/1664 + (73431*(1 - 2*x)^(15/2))/128 - (161325*(1 - 2*x)^(17/2))/2176 + (10125*(1 - 2*x)^(19/2))/2432", //
        90);
  }

  // {90}
  public void test1909() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^3*(3 + 5*x)^3, x]", //
        "(-456533*(1 - 2*x)^(5/2))/320 + (43197*(1 - 2*x)^(7/2))/16 - (444983*(1 - 2*x)^(9/2))/192 + (98209*(1 - 2*x)^(11/2))/88 - (260055*(1 - 2*x)^(13/2))/832 + (765*(1 - 2*x)^(15/2))/16 - (3375*(1 - 2*x)^(17/2))/1088", //
        90);
  }

  // {90}
  public void test1910() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)^2*(3 + 5*x)^3, x]", //
        "(-65219*(1 - 2*x)^(5/2))/160 + (20691*(1 - 2*x)^(7/2))/32 - (21439*(1 - 2*x)^(9/2))/48 + (28555*(1 - 2*x)^(11/2))/176 - (975*(1 - 2*x)^(13/2))/32 + (75*(1 - 2*x)^(15/2))/32", //
        90);
  }

  // {78}
  public void test1911() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(2 + 3*x)*(3 + 5*x)^3, x]", //
        "(-9317*(1 - 2*x)^(5/2))/80 + (8349*(1 - 2*x)^(7/2))/56 - (935*(1 - 2*x)^(9/2))/12 + (1675*(1 - 2*x)^(11/2))/88 - (375*(1 - 2*x)^(13/2))/208", //
        78);
  }

  // {45}
  public void test1912() {
    check( //
        "Integrate[(1 - 2*x)^(3/2)*(3 + 5*x)^3, x]", //
        "(-1331*(1 - 2*x)^(5/2))/40 + (1815*(1 - 2*x)^(7/2))/56 - (275*(1 - 2*x)^(9/2))/24 + (125*(1 - 2*x)^(11/2))/88", //
        45);
  }

  // {78}
  public void test1913() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^6*(3 + 5*x), x]", //
        "(-184877*(1 - 2*x)^(7/2))/128 + (3916031*(1 - 2*x)^(9/2))/1152 - (5078115*(1 - 2*x)^(11/2))/1408 + (3658095*(1 - 2*x)^(13/2))/1664 - (105399*(1 - 2*x)^(15/2))/128 + (409941*(1 - 2*x)^(17/2))/2176 - (59049*(1 - 2*x)^(19/2))/2432 + (1215*(1 - 2*x)^(21/2))/896", //
        78);
  }

  // {78}
  public void test1914() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^5*(3 + 5*x), x]", //
        "(-26411*(1 - 2*x)^(7/2))/64 + (60025*(1 - 2*x)^(9/2))/72 - (519645*(1 - 2*x)^(11/2))/704 + (37485*(1 - 2*x)^(13/2))/104 - (6489*(1 - 2*x)^(15/2))/64 + (1053*(1 - 2*x)^(17/2))/68 - (1215*(1 - 2*x)^(19/2))/1216", //
        78);
  }

  // {78}
  public void test1915() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^4*(3 + 5*x), x]", //
        "(-3773*(1 - 2*x)^(7/2))/32 + (57281*(1 - 2*x)^(9/2))/288 - (24843*(1 - 2*x)^(11/2))/176 + (10773*(1 - 2*x)^(13/2))/208 - (1557*(1 - 2*x)^(15/2))/160 + (405*(1 - 2*x)^(17/2))/544", //
        78);
  }

  // {78}
  public void test1916() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^3*(3 + 5*x), x]", //
        "(-539*(1 - 2*x)^(7/2))/16 + (3283*(1 - 2*x)^(9/2))/72 - (1071*(1 - 2*x)^(11/2))/44 + (621*(1 - 2*x)^(13/2))/104 - (9*(1 - 2*x)^(15/2))/16", //
        78);
  }

  // {78}
  public void test1917() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^2*(3 + 5*x), x]", //
        "(-77*(1 - 2*x)^(7/2))/8 + (707*(1 - 2*x)^(9/2))/72 - (309*(1 - 2*x)^(11/2))/88 + (45*(1 - 2*x)^(13/2))/104", //
        78);
  }

  // {78}
  public void test1918() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)*(3 + 5*x), x]", //
        "(-11*(1 - 2*x)^(7/2))/4 + (17*(1 - 2*x)^(9/2))/9 - (15*(1 - 2*x)^(11/2))/44", //
        78);
  }

  // {45}
  public void test1919() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(3 + 5*x), x]", //
        "(-11*(1 - 2*x)^(7/2))/14 + (5*(1 - 2*x)^(9/2))/18", //
        45);
  }

  // {90}
  public void test1920() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^4*(3 + 5*x)^2, x]", //
        "(-41503*(1 - 2*x)^(7/2))/64 + (381073*(1 - 2*x)^(9/2))/288 - (832951*(1 - 2*x)^(11/2))/704 + (121359*(1 - 2*x)^(13/2))/208 - (53037*(1 - 2*x)^(15/2))/320 + (13905*(1 - 2*x)^(17/2))/544 - (2025*(1 - 2*x)^(19/2))/1216", //
        90);
  }

  // {90}
  public void test1921() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^3*(3 + 5*x)^2, x]", //
        "(-5929*(1 - 2*x)^(7/2))/32 + (91091*(1 - 2*x)^(9/2))/288 - (39977*(1 - 2*x)^(11/2))/176 + (17541*(1 - 2*x)^(13/2))/208 - (513*(1 - 2*x)^(15/2))/32 + (675*(1 - 2*x)^(17/2))/544", //
        90);
  }

  // {90}
  public void test1922() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^2*(3 + 5*x)^2, x]", //
        "(-847*(1 - 2*x)^(7/2))/16 + (1309*(1 - 2*x)^(9/2))/18 - (3467*(1 - 2*x)^(11/2))/88 + (255*(1 - 2*x)^(13/2))/26 - (15*(1 - 2*x)^(15/2))/16", //
        90);
  }

  // {78}
  public void test1923() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)*(3 + 5*x)^2, x]", //
        "(-121*(1 - 2*x)^(7/2))/8 + (1133*(1 - 2*x)^(9/2))/72 - (505*(1 - 2*x)^(11/2))/88 + (75*(1 - 2*x)^(13/2))/104", //
        78);
  }

  // {45}
  public void test1924() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(3 + 5*x)^2, x]", //
        "(-121*(1 - 2*x)^(7/2))/28 + (55*(1 - 2*x)^(9/2))/18 - (25*(1 - 2*x)^(11/2))/44", //
        45);
  }

  // {90}
  public void test1925() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^4*(3 + 5*x)^3, x]", //
        "(-456533*(1 - 2*x)^(7/2))/128 + (3278737*(1 - 2*x)^(9/2))/384 - (1179381*(1 - 2*x)^(11/2))/128 + (9504551*(1 - 2*x)^(13/2))/1664 - (1392467*(1 - 2*x)^(15/2))/640 + (1101465*(1 - 2*x)^(17/2))/2176 - (161325*(1 - 2*x)^(19/2))/2432 + (3375*(1 - 2*x)^(21/2))/896", //
        90);
  }

  // {90}
  public void test1926() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^3*(3 + 5*x)^3, x]", //
        "(-65219*(1 - 2*x)^(7/2))/64 + (100793*(1 - 2*x)^(9/2))/48 - (121359*(1 - 2*x)^(11/2))/64 + (98209*(1 - 2*x)^(13/2))/104 - (17337*(1 - 2*x)^(15/2))/64 + (675*(1 - 2*x)^(17/2))/16 - (3375*(1 - 2*x)^(19/2))/1216", //
        90);
  }

  // {90}
  public void test1927() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)^2*(3 + 5*x)^3, x]", //
        "(-9317*(1 - 2*x)^(7/2))/32 + (16093*(1 - 2*x)^(9/2))/32 - (5847*(1 - 2*x)^(11/2))/16 + (28555*(1 - 2*x)^(13/2))/208 - (845*(1 - 2*x)^(15/2))/32 + (1125*(1 - 2*x)^(17/2))/544", //
        90);
  }

  // {78}
  public void test1928() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(2 + 3*x)*(3 + 5*x)^3, x]", //
        "(-1331*(1 - 2*x)^(7/2))/16 + (2783*(1 - 2*x)^(9/2))/24 - (255*(1 - 2*x)^(11/2))/4 + (1675*(1 - 2*x)^(13/2))/104 - (25*(1 - 2*x)^(15/2))/16", //
        78);
  }

  // {45}
  public void test1929() {
    check( //
        "Integrate[(1 - 2*x)^(5/2)*(3 + 5*x)^3, x]", //
        "(-1331*(1 - 2*x)^(7/2))/56 + (605*(1 - 2*x)^(9/2))/24 - (75*(1 - 2*x)^(11/2))/8 + (125*(1 - 2*x)^(13/2))/104", //
        45);
  }

  // {78}
  public void test1930() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x))/Sqrt[1 - 2*x], x]", //
        "(-184877*Sqrt[1 - 2*x])/64 + (60025*(1 - 2*x)^(3/2))/24 - (103929*(1 - 2*x)^(5/2))/64 + (5355*(1 - 2*x)^(7/2))/8 - (10815*(1 - 2*x)^(9/2))/64 + (1053*(1 - 2*x)^(11/2))/44 - (1215*(1 - 2*x)^(13/2))/832", //
        78);
  }

  // {78}
  public void test1931() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x))/Sqrt[1 - 2*x], x]", //
        "(-26411*Sqrt[1 - 2*x])/32 + (57281*(1 - 2*x)^(3/2))/96 - (24843*(1 - 2*x)^(5/2))/80 + (1539*(1 - 2*x)^(7/2))/16 - (519*(1 - 2*x)^(9/2))/32 + (405*(1 - 2*x)^(11/2))/352", //
        78);
  }

  // {78}
  public void test1932() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x))/Sqrt[1 - 2*x], x]", //
        "(-3773*Sqrt[1 - 2*x])/16 + (3283*(1 - 2*x)^(3/2))/24 - (1071*(1 - 2*x)^(5/2))/20 + (621*(1 - 2*x)^(7/2))/56 - (15*(1 - 2*x)^(9/2))/16", //
        78);
  }

  // {78}
  public void test1933() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x))/Sqrt[1 - 2*x], x]", //
        "(-539*Sqrt[1 - 2*x])/8 + (707*(1 - 2*x)^(3/2))/24 - (309*(1 - 2*x)^(5/2))/40 + (45*(1 - 2*x)^(7/2))/56", //
        78);
  }

  // {78}
  public void test1934() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x))/Sqrt[1 - 2*x], x]", //
        "(-77*Sqrt[1 - 2*x])/4 + (17*(1 - 2*x)^(3/2))/3 - (3*(1 - 2*x)^(5/2))/4", //
        78);
  }

  // {45}
  public void test1935() {
    check( //
        "Integrate[(3 + 5*x)/Sqrt[1 - 2*x], x]", //
        "(-11*Sqrt[1 - 2*x])/2 + (5*(1 - 2*x)^(3/2))/6", //
        45);
  }

  // {90}
  public void test1936() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^2)/Sqrt[1 - 2*x], x]", //
        "(-2033647*Sqrt[1 - 2*x])/128 + (6206585*(1 - 2*x)^(3/2))/384 - (1623419*(1 - 2*x)^(5/2))/128 + (842415*(1 - 2*x)^(7/2))/128 - (285565*(1 - 2*x)^(9/2))/128 + (672003*(1 - 2*x)^(11/2))/1408 - (97605*(1 - 2*x)^(13/2))/1664 + (405*(1 - 2*x)^(15/2))/128", //
        90);
  }

  // {90}
  public void test1937() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^2)/Sqrt[1 - 2*x], x]", //
        "(-290521*Sqrt[1 - 2*x])/64 + (381073*(1 - 2*x)^(3/2))/96 - (832951*(1 - 2*x)^(5/2))/320 + (17337*(1 - 2*x)^(7/2))/16 - (17679*(1 - 2*x)^(9/2))/64 + (13905*(1 - 2*x)^(11/2))/352 - (2025*(1 - 2*x)^(13/2))/832", //
        90);
  }

  // {90}
  public void test1938() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^2)/Sqrt[1 - 2*x], x]", //
        "(-41503*Sqrt[1 - 2*x])/32 + (91091*(1 - 2*x)^(3/2))/96 - (39977*(1 - 2*x)^(5/2))/80 + (17541*(1 - 2*x)^(7/2))/112 - (855*(1 - 2*x)^(9/2))/32 + (675*(1 - 2*x)^(11/2))/352", //
        90);
  }

  // {90}
  public void test1939() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^2)/Sqrt[1 - 2*x], x]", //
        "(-5929*Sqrt[1 - 2*x])/16 + (1309*(1 - 2*x)^(3/2))/6 - (3467*(1 - 2*x)^(5/2))/40 + (255*(1 - 2*x)^(7/2))/14 - (25*(1 - 2*x)^(9/2))/16", //
        90);
  }

  // {78}
  public void test1940() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^2)/Sqrt[1 - 2*x], x]", //
        "(-847*Sqrt[1 - 2*x])/8 + (1133*(1 - 2*x)^(3/2))/24 - (101*(1 - 2*x)^(5/2))/8 + (75*(1 - 2*x)^(7/2))/56", //
        78);
  }

  // {45}
  public void test1941() {
    check( //
        "Integrate[(3 + 5*x)^2/Sqrt[1 - 2*x], x]", //
        "(-121*Sqrt[1 - 2*x])/4 + (55*(1 - 2*x)^(3/2))/6 - (5*(1 - 2*x)^(5/2))/4", //
        45);
  }

  // {90}
  public void test1942() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^3)/Sqrt[1 - 2*x], x]", //
        "(-3195731*Sqrt[1 - 2*x])/128 + (3278737*(1 - 2*x)^(3/2))/128 - (12973191*(1 - 2*x)^(5/2))/640 + (1357793*(1 - 2*x)^(7/2))/128 - (1392467*(1 - 2*x)^(9/2))/384 + (1101465*(1 - 2*x)^(11/2))/1408 - (161325*(1 - 2*x)^(13/2))/1664 + (675*(1 - 2*x)^(15/2))/128", //
        90);
  }

  // {90}
  public void test1943() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^3)/Sqrt[1 - 2*x], x]", //
        "(-456533*Sqrt[1 - 2*x])/64 + (100793*(1 - 2*x)^(3/2))/16 - (1334949*(1 - 2*x)^(5/2))/320 + (98209*(1 - 2*x)^(7/2))/56 - (28895*(1 - 2*x)^(9/2))/64 + (11475*(1 - 2*x)^(11/2))/176 - (3375*(1 - 2*x)^(13/2))/832", //
        90);
  }

  // {90}
  public void test1944() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^3)/Sqrt[1 - 2*x], x]", //
        "(-65219*Sqrt[1 - 2*x])/32 + (48279*(1 - 2*x)^(3/2))/32 - (64317*(1 - 2*x)^(5/2))/80 + (28555*(1 - 2*x)^(7/2))/112 - (4225*(1 - 2*x)^(9/2))/96 + (1125*(1 - 2*x)^(11/2))/352", //
        90);
  }

  // {78}
  public void test1945() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^3)/Sqrt[1 - 2*x], x]", //
        "(-9317*Sqrt[1 - 2*x])/16 + (2783*(1 - 2*x)^(3/2))/8 - (561*(1 - 2*x)^(5/2))/4 + (1675*(1 - 2*x)^(7/2))/56 - (125*(1 - 2*x)^(9/2))/48", //
        78);
  }

  // {45}
  public void test1946() {
    check( //
        "Integrate[(3 + 5*x)^3/Sqrt[1 - 2*x], x]", //
        "(-1331*Sqrt[1 - 2*x])/8 + (605*(1 - 2*x)^(3/2))/8 - (165*(1 - 2*x)^(5/2))/8 + (125*(1 - 2*x)^(7/2))/56", //
        45);
  }

  // {65, 212}
  public void test1947() {
    check( //
        "Integrate[1/(Sqrt[1 - 2*x]*(3 + 5*x)), x]", //
        "(-2*ArcTanh[Sqrt[5/11]*Sqrt[1 - 2*x]])/Sqrt[55]", //
        65,
        212);
  }

  // {78}
  public void test1948() {
    check( //
        "Integrate[((2 + 3*x)^7*(3 + 5*x))/(1 - 2*x)^(3/2), x]", //
        "9058973/(256*Sqrt[1 - 2*x]) + (15647317*Sqrt[1 - 2*x])/128 - (7882483*(1 - 2*x)^(3/2))/128 + (4084101*(1 - 2*x)^(5/2))/128 - (787185*(1 - 2*x)^(7/2))/64 + (422919*(1 - 2*x)^(9/2))/128 - (821583*(1 - 2*x)^(11/2))/1408 + (101331*(1 - 2*x)^(13/2))/1664 - (729*(1 - 2*x)^(15/2))/256", //
        78);
  }

  // {78}
  public void test1949() {
    check( //
        "Integrate[((2 + 3*x)^6*(3 + 5*x))/(1 - 2*x)^(3/2), x]", //
        "1294139/(128*Sqrt[1 - 2*x]) + (3916031*Sqrt[1 - 2*x])/128 - (1692705*(1 - 2*x)^(3/2))/128 + (731619*(1 - 2*x)^(5/2))/128 - (225855*(1 - 2*x)^(7/2))/128 + (45549*(1 - 2*x)^(9/2))/128 - (59049*(1 - 2*x)^(11/2))/1408 + (3645*(1 - 2*x)^(13/2))/1664", //
        78);
  }

  // {78}
  public void test1950() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x))/(1 - 2*x)^(3/2), x]", //
        "184877/(64*Sqrt[1 - 2*x]) + (60025*Sqrt[1 - 2*x])/8 - (173215*(1 - 2*x)^(3/2))/64 + (7497*(1 - 2*x)^(5/2))/8 - (13905*(1 - 2*x)^(7/2))/64 + (117*(1 - 2*x)^(9/2))/4 - (1215*(1 - 2*x)^(11/2))/704", //
        78);
  }

  // {78}
  public void test1951() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x))/(1 - 2*x)^(3/2), x]", //
        "26411/(32*Sqrt[1 - 2*x]) + (57281*Sqrt[1 - 2*x])/32 - (8281*(1 - 2*x)^(3/2))/16 + (10773*(1 - 2*x)^(5/2))/80 - (4671*(1 - 2*x)^(7/2))/224 + (45*(1 - 2*x)^(9/2))/32", //
        78);
  }

  // {78}
  public void test1952() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x))/(1 - 2*x)^(3/2), x]", //
        "3773/(16*Sqrt[1 - 2*x]) + (3283*Sqrt[1 - 2*x])/8 - (357*(1 - 2*x)^(3/2))/4 + (621*(1 - 2*x)^(5/2))/40 - (135*(1 - 2*x)^(7/2))/112", //
        78);
  }

  // {78}
  public void test1953() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x))/(1 - 2*x)^(3/2), x]", //
        "539/(8*Sqrt[1 - 2*x]) + (707*Sqrt[1 - 2*x])/8 - (103*(1 - 2*x)^(3/2))/8 + (9*(1 - 2*x)^(5/2))/8", //
        78);
  }

  // {78}
  public void test1954() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x))/(1 - 2*x)^(3/2), x]", //
        "77/(4*Sqrt[1 - 2*x]) + 17*Sqrt[1 - 2*x] - (5*(1 - 2*x)^(3/2))/4", //
        78);
  }

  // {45}
  public void test1955() {
    check( //
        "Integrate[(3 + 5*x)/(1 - 2*x)^(3/2), x]", //
        "11/(2*Sqrt[1 - 2*x]) + (5*Sqrt[1 - 2*x])/2", //
        45);
  }

  // {90}
  public void test1956() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^2)/(1 - 2*x)^(3/2), x]", //
        "2033647/(128*Sqrt[1 - 2*x]) + (6206585*Sqrt[1 - 2*x])/128 - (8117095*(1 - 2*x)^(3/2))/384 + (1179381*(1 - 2*x)^(5/2))/128 - (367155*(1 - 2*x)^(7/2))/128 + (74667*(1 - 2*x)^(9/2))/128 - (97605*(1 - 2*x)^(11/2))/1408 + (6075*(1 - 2*x)^(13/2))/1664", //
        90);
  }

  // {90}
  public void test1957() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^2)/(1 - 2*x)^(3/2), x]", //
        "290521/(64*Sqrt[1 - 2*x]) + (381073*Sqrt[1 - 2*x])/32 - (832951*(1 - 2*x)^(3/2))/192 + (121359*(1 - 2*x)^(5/2))/80 - (159111*(1 - 2*x)^(7/2))/448 + (1545*(1 - 2*x)^(9/2))/32 - (2025*(1 - 2*x)^(11/2))/704", //
        90);
  }

  // {90}
  public void test1958() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^2)/(1 - 2*x)^(3/2), x]", //
        "41503/(32*Sqrt[1 - 2*x]) + (91091*Sqrt[1 - 2*x])/32 - (39977*(1 - 2*x)^(3/2))/48 + (17541*(1 - 2*x)^(5/2))/80 - (7695*(1 - 2*x)^(7/2))/224 + (75*(1 - 2*x)^(9/2))/32", //
        90);
  }

  // {90}
  public void test1959() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^2)/(1 - 2*x)^(3/2), x]", //
        "5929/(16*Sqrt[1 - 2*x]) + (1309*Sqrt[1 - 2*x])/2 - (3467*(1 - 2*x)^(3/2))/24 + (51*(1 - 2*x)^(5/2))/2 - (225*(1 - 2*x)^(7/2))/112", //
        90);
  }

  // {78}
  public void test1960() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^2)/(1 - 2*x)^(3/2), x]", //
        "847/(8*Sqrt[1 - 2*x]) + (1133*Sqrt[1 - 2*x])/8 - (505*(1 - 2*x)^(3/2))/24 + (15*(1 - 2*x)^(5/2))/8", //
        78);
  }

  // {45}
  public void test1961() {
    check( //
        "Integrate[(3 + 5*x)^2/(1 - 2*x)^(3/2), x]", //
        "121/(4*Sqrt[1 - 2*x]) + (55*Sqrt[1 - 2*x])/2 - (25*(1 - 2*x)^(3/2))/12", //
        45);
  }

  // {90}
  public void test1962() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^3)/(1 - 2*x)^(3/2), x]", //
        "3195731/(128*Sqrt[1 - 2*x]) + (9836211*Sqrt[1 - 2*x])/128 - (4324397*(1 - 2*x)^(3/2))/128 + (9504551*(1 - 2*x)^(5/2))/640 - (4177401*(1 - 2*x)^(7/2))/896 + (122385*(1 - 2*x)^(9/2))/128 - (161325*(1 - 2*x)^(11/2))/1408 + (10125*(1 - 2*x)^(13/2))/1664", //
        90);
  }

  // {90}
  public void test1963() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^3)/(1 - 2*x)^(3/2), x]", //
        "456533/(64*Sqrt[1 - 2*x]) + (302379*Sqrt[1 - 2*x])/16 - (444983*(1 - 2*x)^(3/2))/64 + (98209*(1 - 2*x)^(5/2))/40 - (260055*(1 - 2*x)^(7/2))/448 + (1275*(1 - 2*x)^(9/2))/16 - (3375*(1 - 2*x)^(11/2))/704", //
        90);
  }

  // {90}
  public void test1964() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^3)/(1 - 2*x)^(3/2), x]", //
        "65219/(32*Sqrt[1 - 2*x]) + (144837*Sqrt[1 - 2*x])/32 - (21439*(1 - 2*x)^(3/2))/16 + (5711*(1 - 2*x)^(5/2))/16 - (12675*(1 - 2*x)^(7/2))/224 + (125*(1 - 2*x)^(9/2))/32", //
        90);
  }

  // {78}
  public void test1965() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^3)/(1 - 2*x)^(3/2), x]", //
        "9317/(16*Sqrt[1 - 2*x]) + (8349*Sqrt[1 - 2*x])/8 - (935*(1 - 2*x)^(3/2))/4 + (335*(1 - 2*x)^(5/2))/8 - (375*(1 - 2*x)^(7/2))/112", //
        78);
  }

  // {45}
  public void test1966() {
    check( //
        "Integrate[(3 + 5*x)^3/(1 - 2*x)^(3/2), x]", //
        "1331/(8*Sqrt[1 - 2*x]) + (1815*Sqrt[1 - 2*x])/8 - (275*(1 - 2*x)^(3/2))/8 + (25*(1 - 2*x)^(5/2))/8", //
        45);
  }

  // {78}
  public void test1967() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x))/(1 - 2*x)^(5/2), x]", //
        "184877/(192*(1 - 2*x)^(3/2)) - 60025/(8*Sqrt[1 - 2*x]) - (519645*Sqrt[1 - 2*x])/64 + (12495*(1 - 2*x)^(3/2))/8 - (19467*(1 - 2*x)^(5/2))/64 + (1053*(1 - 2*x)^(7/2))/28 - (135*(1 - 2*x)^(9/2))/64", //
        78);
  }

  // {78}
  public void test1968() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x))/(1 - 2*x)^(5/2), x]", //
        "26411/(96*(1 - 2*x)^(3/2)) - 57281/(32*Sqrt[1 - 2*x]) - (24843*Sqrt[1 - 2*x])/16 + (3591*(1 - 2*x)^(3/2))/16 - (4671*(1 - 2*x)^(5/2))/160 + (405*(1 - 2*x)^(7/2))/224", //
        78);
  }

  // {78}
  public void test1969() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x))/(1 - 2*x)^(5/2), x]", //
        "3773/(48*(1 - 2*x)^(3/2)) - 3283/(8*Sqrt[1 - 2*x]) - (1071*Sqrt[1 - 2*x])/4 + (207*(1 - 2*x)^(3/2))/8 - (27*(1 - 2*x)^(5/2))/16", //
        78);
  }

  // {78}
  public void test1970() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x))/(1 - 2*x)^(5/2), x]", //
        "539/(24*(1 - 2*x)^(3/2)) - 707/(8*Sqrt[1 - 2*x]) - (309*Sqrt[1 - 2*x])/8 + (15*(1 - 2*x)^(3/2))/8", //
        78);
  }

  // {78}
  public void test1971() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x))/(1 - 2*x)^(5/2), x]", //
        "77/(12*(1 - 2*x)^(3/2)) - 17/Sqrt[1 - 2*x] - (15*Sqrt[1 - 2*x])/4", //
        78);
  }

  // {45}
  public void test1972() {
    check( //
        "Integrate[(3 + 5*x)/(1 - 2*x)^(5/2), x]", //
        "11/(6*(1 - 2*x)^(3/2)) - 5/(2*Sqrt[1 - 2*x])", //
        45);
  }

  // {90}
  public void test1973() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^2)/(1 - 2*x)^(5/2), x]", //
        "2033647/(384*(1 - 2*x)^(3/2)) - 6206585/(128*Sqrt[1 - 2*x]) - (8117095*Sqrt[1 - 2*x])/128 + (1965635*(1 - 2*x)^(3/2))/128 - (514017*(1 - 2*x)^(5/2))/128 + (672003*(1 - 2*x)^(7/2))/896 - (10845*(1 - 2*x)^(9/2))/128 + (6075*(1 - 2*x)^(11/2))/1408", //
        90);
  }

  // {90}
  public void test1974() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^2)/(1 - 2*x)^(5/2), x]", //
        "290521/(192*(1 - 2*x)^(3/2)) - 381073/(32*Sqrt[1 - 2*x]) - (832951*Sqrt[1 - 2*x])/64 + (40453*(1 - 2*x)^(3/2))/16 - (159111*(1 - 2*x)^(5/2))/320 + (13905*(1 - 2*x)^(7/2))/224 - (225*(1 - 2*x)^(9/2))/64", //
        90);
  }

  // {90}
  public void test1975() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^2)/(1 - 2*x)^(5/2), x]", //
        "41503/(96*(1 - 2*x)^(3/2)) - 91091/(32*Sqrt[1 - 2*x]) - (39977*Sqrt[1 - 2*x])/16 + (5847*(1 - 2*x)^(3/2))/16 - (1539*(1 - 2*x)^(5/2))/32 + (675*(1 - 2*x)^(7/2))/224", //
        90);
  }

  // {90}
  public void test1976() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^2)/(1 - 2*x)^(5/2), x]", //
        "5929/(48*(1 - 2*x)^(3/2)) - 1309/(2*Sqrt[1 - 2*x]) - (3467*Sqrt[1 - 2*x])/8 + (85*(1 - 2*x)^(3/2))/2 - (45*(1 - 2*x)^(5/2))/16", //
        90);
  }

  // {78}
  public void test1977() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^2)/(1 - 2*x)^(5/2), x]", //
        "847/(24*(1 - 2*x)^(3/2)) - 1133/(8*Sqrt[1 - 2*x]) - (505*Sqrt[1 - 2*x])/8 + (25*(1 - 2*x)^(3/2))/8", //
        78);
  }

  // {45}
  public void test1978() {
    check( //
        "Integrate[(3 + 5*x)^2/(1 - 2*x)^(5/2), x]", //
        "121/(12*(1 - 2*x)^(3/2)) - 55/(2*Sqrt[1 - 2*x]) - (25*Sqrt[1 - 2*x])/4", //
        45);
  }

  // {90}
  public void test1979() {
    check( //
        "Integrate[((2 + 3*x)^5*(3 + 5*x)^3)/(1 - 2*x)^(5/2), x]", //
        "22370117/(768*(1 - 2*x)^(3/2)) - 39220335/(128*Sqrt[1 - 2*x]) - (60160485*Sqrt[1 - 2*x])/128 + (52725715*(1 - 2*x)^(3/2))/384 - (2887773*(1 - 2*x)^(5/2))/64 + (10121229*(1 - 2*x)^(7/2))/896 - (246315*(1 - 2*x)^(9/2))/128 + (277425*(1 - 2*x)^(11/2))/1408 - (30375*(1 - 2*x)^(13/2))/3328", //
        90);
  }

  // {90}
  public void test1980() {
    check( //
        "Integrate[((2 + 3*x)^4*(3 + 5*x)^3)/(1 - 2*x)^(5/2), x]", //
        "3195731/(384*(1 - 2*x)^(3/2)) - 9836211/(128*Sqrt[1 - 2*x]) - (12973191*Sqrt[1 - 2*x])/128 + (9504551*(1 - 2*x)^(3/2))/384 - (4177401*(1 - 2*x)^(5/2))/640 + (1101465*(1 - 2*x)^(7/2))/896 - (17925*(1 - 2*x)^(9/2))/128 + (10125*(1 - 2*x)^(11/2))/1408", //
        90);
  }

  // {90}
  public void test1981() {
    check( //
        "Integrate[((2 + 3*x)^3*(3 + 5*x)^3)/(1 - 2*x)^(5/2), x]", //
        "456533/(192*(1 - 2*x)^(3/2)) - 302379/(16*Sqrt[1 - 2*x]) - (1334949*Sqrt[1 - 2*x])/64 + (98209*(1 - 2*x)^(3/2))/24 - (52011*(1 - 2*x)^(5/2))/64 + (11475*(1 - 2*x)^(7/2))/112 - (375*(1 - 2*x)^(9/2))/64", //
        90);
  }

  // {90}
  public void test1982() {
    check( //
        "Integrate[((2 + 3*x)^2*(3 + 5*x)^3)/(1 - 2*x)^(5/2), x]", //
        "65219/(96*(1 - 2*x)^(3/2)) - 144837/(32*Sqrt[1 - 2*x]) - (64317*Sqrt[1 - 2*x])/16 + (28555*(1 - 2*x)^(3/2))/48 - (2535*(1 - 2*x)^(5/2))/32 + (1125*(1 - 2*x)^(7/2))/224", //
        90);
  }

  // {78}
  public void test1983() {
    check( //
        "Integrate[((2 + 3*x)*(3 + 5*x)^3)/(1 - 2*x)^(5/2), x]", //
        "9317/(48*(1 - 2*x)^(3/2)) - 8349/(8*Sqrt[1 - 2*x]) - (2805*Sqrt[1 - 2*x])/4 + (1675*(1 - 2*x)^(3/2))/24 - (75*(1 - 2*x)^(5/2))/16", //
        78);
  }

  // {45}
  public void test1984() {
    check( //
        "Integrate[(3 + 5*x)^3/(1 - 2*x)^(5/2), x]", //
        "1331/(24*(1 - 2*x)^(3/2)) - 1815/(8*Sqrt[1 - 2*x]) - (825*Sqrt[1 - 2*x])/8 + (125*(1 - 2*x)^(3/2))/24", //
        45);
  }

  // {79, 37}
  public void test1985() {
    check( //
        "Integrate[(Sqrt[a + b*x]*(A + B*x))/(d + e*x)^(7/2), x]", //
        "(-2*(B*d - A*e)*(a + b*x)^(3/2))/(5*e*(b*d - a*e)*(d + e*x)^(5/2)) + (2*(3*b*B*d + 2*A*b*e - 5*a*B*e)*(a + b*x)^(3/2))/(15*e*(b*d - a*e)^2*(d + e*x)^(3/2))", //
        79,
        37);
  }

  // {79, 37}
  public void test1986() {
    check( //
        "Integrate[((a + b*x)^(3/2)*(A + B*x))/(d + e*x)^(9/2), x]", //
        "(-2*(B*d - A*e)*(a + b*x)^(5/2))/(7*e*(b*d - a*e)*(d + e*x)^(7/2)) + (2*(5*b*B*d + 2*A*b*e - 7*a*B*e)*(a + b*x)^(5/2))/(35*e*(b*d - a*e)^2*(d + e*x)^(5/2))", //
        79,
        37);
  }

  // {79, 37}
  public void test1987() {
    check( //
        "Integrate[((a + b*x)^(5/2)*(A + B*x))/(d + e*x)^(11/2), x]", //
        "(-2*(B*d - A*e)*(a + b*x)^(7/2))/(9*e*(b*d - a*e)*(d + e*x)^(9/2)) + (2*(7*b*B*d + 2*A*b*e - 9*a*B*e)*(a + b*x)^(7/2))/(63*e*(b*d - a*e)^2*(d + e*x)^(7/2))", //
        79,
        37);
  }

  // {79, 37}
  public void test1988() {
    check( //
        "Integrate[(A + B*x)/(Sqrt[a + b*x]*(d + e*x)^(5/2)), x]", //
        "(-2*(B*d - A*e)*Sqrt[a + b*x])/(3*e*(b*d - a*e)*(d + e*x)^(3/2)) + (2*(b*B*d + 2*A*b*e - 3*a*B*e)*Sqrt[a + b*x])/(3*e*(b*d - a*e)^2*Sqrt[d + e*x])", //
        79,
        37);
  }

  // {79, 37}
  public void test1989() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^(3/2)*(d + e*x)^(3/2)), x]", //
        "(-2*(B*d - A*e))/(e*(b*d - a*e)*Sqrt[a + b*x]*Sqrt[d + e*x]) + (2*(b*B*d - 2*A*b*e + a*B*e)*Sqrt[d + e*x])/(e*(b*d - a*e)^2*Sqrt[a + b*x])", //
        79,
        37);
  }

  // {79, 37}
  public void test1990() {
    check( //
        "Integrate[(A + B*x)/((a + b*x)^(5/2)*Sqrt[d + e*x]), x]", //
        "(-2*(A*b - a*B)*Sqrt[d + e*x])/(3*b*(b*d - a*e)*(a + b*x)^(3/2)) - (2*(3*b*B*d - 2*A*b*e - a*B*e)*Sqrt[d + e*x])/(3*b*(b*d - a*e)^2*Sqrt[a + b*x])", //
        79,
        37);
  }

  // {56, 222}
  public void test1991() {
    check( //
        "Integrate[1/(Sqrt[1 - 2*x]*Sqrt[3 + 5*x]), x]", //
        "Sqrt[2/5]*ArcSin[Sqrt[2/11]*Sqrt[3 + 5*x]]", //
        56,
        222);
  }

  // {95, 210}
  public void test1992() {
    check( //
        "Integrate[1/(Sqrt[1 - 2*x]*(2 + 3*x)*Sqrt[3 + 5*x]), x]", //
        "(-2*ArcTan[Sqrt[1 - 2*x]/(Sqrt[7]*Sqrt[3 + 5*x])])/Sqrt[7]", //
        95,
        210);
  }

  // {79, 37}
  public void test1993() {
    check( //
        "Integrate[(2 + 3*x)/(Sqrt[1 - 2*x]*(3 + 5*x)^(5/2)), x]", //
        "(-2*Sqrt[1 - 2*x])/(165*(3 + 5*x)^(3/2)) - (206*Sqrt[1 - 2*x])/(1815*Sqrt[3 + 5*x])", //
        79,
        37);
  }

  // {47, 37}
  public void test1994() {
    check( //
        "Integrate[1/(Sqrt[1 - 2*x]*(3 + 5*x)^(5/2)), x]", //
        "(-2*Sqrt[1 - 2*x])/(33*(3 + 5*x)^(3/2)) - (8*Sqrt[1 - 2*x])/(363*Sqrt[3 + 5*x])", //
        47,
        37);
  }

  // {94, 211}
  public void test1995() {
    check( //
        "Integrate[1/(Sqrt[a + b*x]*(e + f*x)*Sqrt[2*b*e - a*f + b*f*x]), x]", //
        "ArcTan[(Sqrt[f]*Sqrt[a + b*x]*Sqrt[2*b*e - a*f + b*f*x])/(b*e - a*f)]/(Sqrt[f]*(b*e - a*f))", //
        94,
        211);
  }

  // {79, 37}
  public void test1996() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)^(3/2)*(3 + 5*x)^(3/2)), x]", //
        "-2/(55*Sqrt[1 - 2*x]*Sqrt[3 + 5*x]) + (74*Sqrt[3 + 5*x])/(605*Sqrt[1 - 2*x])", //
        79,
        37);
  }

  // {47, 37}
  public void test1997() {
    check( //
        "Integrate[1/((1 - 2*x)^(3/2)*(3 + 5*x)^(3/2)), x]", //
        "2/(11*Sqrt[1 - 2*x]*Sqrt[3 + 5*x]) - (20*Sqrt[1 - 2*x])/(121*Sqrt[3 + 5*x])", //
        47,
        37);
  }

  // {79, 37}
  public void test1998() {
    check( //
        "Integrate[(2 + 3*x)/((1 - 2*x)^(5/2)*Sqrt[3 + 5*x]), x]", //
        "(7*Sqrt[3 + 5*x])/(33*(1 - 2*x)^(3/2)) - (29*Sqrt[3 + 5*x])/(363*Sqrt[1 - 2*x])", //
        79,
        37);
  }

  // {47, 37}
  public void test1999() {
    check( //
        "Integrate[1/((1 - 2*x)^(5/2)*Sqrt[3 + 5*x]), x]", //
        "(2*Sqrt[3 + 5*x])/(33*(1 - 2*x)^(3/2)) + (20*Sqrt[3 + 5*x])/(363*Sqrt[1 - 2*x])", //
        47,
        37);
  }

  // {122, 120}
  public void test2000() {
    check( //
        "Integrate[1/(Sqrt[a + b*x]*Sqrt[c + d*x]*Sqrt[e + (b*(-1 + e)*x)/a]), x]", //
        "(2*Sqrt[a]*Sqrt[(b*(c + d*x))/(b*c - a*d)]*EllipticF[ArcSin[(Sqrt[1 - e]*Sqrt[a + b*x])/Sqrt[a]], -((a*d)/((b*c - a*d)*(1 - e)))])/(b*Sqrt[1 - e]*Sqrt[c + d*x])", //
        122,
        120);
  }

  // {115, 114}
  public void test2001() {
    check( //
        "Integrate[Sqrt[c + d*x]/(Sqrt[a + b*x]*Sqrt[e + (b*(-1 + e)*x)/a]), x]", //
        "(2*Sqrt[a]*Sqrt[c + d*x]*EllipticE[ArcSin[(Sqrt[1 - e]*Sqrt[a + b*x])/Sqrt[a]], -((a*d)/((b*c - a*d)*(1 - e)))])/(b*Sqrt[1 - e]*Sqrt[(b*(c + d*x))/(b*c - a*d)])", //
        115,
        114);
  }

  // {115, 114}
  public void test2002() {
    check( //
        "Integrate[Sqrt[a + b*x]/(Sqrt[c + (b*(-1 + c)*x)/a]*Sqrt[e + (b*(-1 + e)*x)/a]), x]", //
        "(-2*a*Sqrt[c - e]*Sqrt[a + b*x]*Sqrt[-(((1 - c)*(a*e - b*(1 - e)*x))/(a*(c - e)))]*EllipticE[ArcSin[(Sqrt[1 - e]*Sqrt[c - (b*(1 - c)*x)/a])/Sqrt[c - e]], (c - e)/(1 - e)])/(b*(1 - c)*Sqrt[1 - e]*Sqrt[((1 - c)*(a + b*x))/a]*Sqrt[e - (b*(1 - e)*x)/a])", //
        115,
        114);
  }

  // {115, 114}
  public void test2003() {
    check( //
        "Integrate[Sqrt[e + f*x]/(Sqrt[a + b*x]*Sqrt[c + d*x]), x]", //
        "(2*Sqrt[-(b*c) + a*d]*Sqrt[(b*(c + d*x))/(b*c - a*d)]*Sqrt[e + f*x]*EllipticE[ArcSin[(Sqrt[d]*Sqrt[a + b*x])/Sqrt[-(b*c) + a*d]], ((b*c - a*d)*f)/(d*(b*e - a*f))])/(b*Sqrt[d]*Sqrt[c + d*x]*Sqrt[(b*(e + f*x))/(b*e - a*f)])", //
        115,
        114);
  }

  // {115, 114}
  public void test2004() {
    check( //
        "Integrate[Sqrt[e + f*x]/(Sqrt[a + b*x]*Sqrt[c + d*x]), x]", //
        "(2*Sqrt[-(b*c) + a*d]*Sqrt[(b*(c + d*x))/(b*c - a*d)]*Sqrt[e + f*x]*EllipticE[ArcSin[(Sqrt[d]*Sqrt[a + b*x])/Sqrt[-(b*c) + a*d]], ((b*c - a*d)*f)/(d*(b*e - a*f))])/(b*Sqrt[d]*Sqrt[c + d*x]*Sqrt[(b*(e + f*x))/(b*e - a*f)])", //
        115,
        114);
  }

  // {115, 114}
  public void test2005() {
    check( //
        "Integrate[Sqrt[1 - 2*x]/(Sqrt[2 + 3*x]*Sqrt[3 + 5*x]), x]", //
        "(2*Sqrt[7/5]*Sqrt[-3 - 5*x]*EllipticE[ArcSin[Sqrt[5]*Sqrt[2 + 3*x]], 2/35])/(3*Sqrt[3 + 5*x])", //
        115,
        114);
  }

  // {122, 119}
  public void test2006() {
    check( //
        "Integrate[1/(Sqrt[-2 - x]*Sqrt[-3 + x]*Sqrt[-1 + x]), x]", //
        "(-2*Sqrt[2 + x]*EllipticF[ArcSin[1/Sqrt[2/3 + x/3]], 5/3])/(Sqrt[3]*Sqrt[-2 - x])", //
        122,
        119);
  }

  // {122, 119}
  public void test2007() {
    check( //
        "Integrate[1/(Sqrt[-1 - x]*Sqrt[-3 + x]*Sqrt[-2 + x]), x]", //
        "(-2*Sqrt[1 + x]*EllipticF[ArcSin[1/Sqrt[1/3 + x/3]], 4/3])/(Sqrt[3]*Sqrt[-1 - x])", //
        122,
        119);
  }

  // {703, 227}
  public void test2008() {
    check( //
        "Integrate[1/(Sqrt[4 - x]*Sqrt[-15 + 8*x - x^2]), x]", //
        "-2*EllipticF[ArcSin[Sqrt[4 - x]], -1]", //
        703,
        227);
  }

  // {732, 430}
  public void test2009() {
    check( //
        "Integrate[1/(Sqrt[-1 + x]*Sqrt[-12 + 8*x - x^2]), x]", //
        "(-2*EllipticF[ArcSin[Sqrt[6 - x]/2], 4/5])/Sqrt[5]", //
        732,
        430);
  }

  // {52, 61}
  public void test2010() {
    check( //
        "Integrate[(a + b*x)^(1/3)/(c + d*x)^(1/3), x]", //
        "((a + b*x)^(1/3)*(c + d*x)^(2/3))/d + ((b*c - a*d)*ArcTan[1/Sqrt[3] + (2*b^(1/3)*(c + d*x)^(1/3))/(Sqrt[3]*d^(1/3)*(a + b*x)^(1/3))])/(Sqrt[3]*b^(2/3)*d^(4/3)) + ((b*c - a*d)*Log[a + b*x])/(6*b^(2/3)*d^(4/3)) + ((b*c - a*d)*Log[-1 + (b^(1/3)*(c + d*x)^(1/3))/(d^(1/3)*(a + b*x)^(1/3))])/(2*b^(2/3)*d^(4/3))", //
        52,
        61);
  }

  // {96, 93}
  public void test2011() {
    check( //
        "Integrate[(a + b*x)^(1/3)/((c + d*x)^(1/3)*(e + f*x)^2), x]", //
        "((a + b*x)^(1/3)*(c + d*x)^(2/3))/((d*e - c*f)*(e + f*x)) + ((b*c - a*d)*ArcTan[1/Sqrt[3] + (2*(b*e - a*f)^(1/3)*(c + d*x)^(1/3))/(Sqrt[3]*(d*e - c*f)^(1/3)*(a + b*x)^(1/3))])/(Sqrt[3]*(b*e - a*f)^(2/3)*(d*e - c*f)^(4/3)) - ((b*c - a*d)*Log[e + f*x])/(6*(b*e - a*f)^(2/3)*(d*e - c*f)^(4/3)) + ((b*c - a*d)*Log[-(a + b*x)^(1/3) + ((b*e - a*f)^(1/3)*(c + d*x)^(1/3))/(d*e - c*f)^(1/3)])/(2*(b*e - a*f)^(2/3)*(d*e - c*f)^(4/3))", //
        96,
        93);
  }

  // {81, 61}
  public void test2012() {
    check( //
        "Integrate[(e + f*x)/((a + b*x)^(1/3)*(c + d*x)^(2/3)), x]", //
        "(f*(a + b*x)^(2/3)*(c + d*x)^(1/3))/(b*d) - ((3*b*d*e - 2*b*c*f - a*d*f)*ArcTan[1/Sqrt[3] + (2*d^(1/3)*(a + b*x)^(1/3))/(Sqrt[3]*b^(1/3)*(c + d*x)^(1/3))])/(Sqrt[3]*b^(4/3)*d^(5/3)) - ((3*b*d*e - 2*b*c*f - a*d*f)*Log[c + d*x])/(6*b^(4/3)*d^(5/3)) - ((3*b*d*e - 2*b*c*f - a*d*f)*Log[-1 + (d^(1/3)*(a + b*x)^(1/3))/(b^(1/3)*(c + d*x)^(1/3))])/(2*b^(4/3)*d^(5/3))", //
        81,
        61);
  }

  // {98, 93}
  public void test2013() {
    check( //
        "Integrate[1/((a + b*x)^(1/3)*(c + d*x)^(2/3)*(e + f*x)^2), x]", //
        "-((f*(a + b*x)^(2/3)*(c + d*x)^(1/3))/((b*e - a*f)*(d*e - c*f)*(e + f*x))) - ((3*b*d*e - b*c*f - 2*a*d*f)*ArcTan[1/Sqrt[3] + (2*(d*e - c*f)^(1/3)*(a + b*x)^(1/3))/(Sqrt[3]*(b*e - a*f)^(1/3)*(c + d*x)^(1/3))])/(Sqrt[3]*(b*e - a*f)^(4/3)*(d*e - c*f)^(5/3)) + ((3*b*d*e - b*c*f - 2*a*d*f)*Log[e + f*x])/(6*(b*e - a*f)^(4/3)*(d*e - c*f)^(5/3)) - ((3*b*d*e - b*c*f - 2*a*d*f)*Log[((d*e - c*f)^(1/3)*(a + b*x)^(1/3))/(b*e - a*f)^(1/3) - (c + d*x)^(1/3)])/(2*(b*e - a*f)^(4/3)*(d*e - c*f)^(5/3))", //
        98,
        93);
  }

  // {142, 141}
  public void test2014() {
    check( //
        "Integrate[1/((a + b*x)*(c + d*x)^(1/3)*(b*c + a*d + 2*b*d*x)^(4/3)), x]", //
        "(3*(c + d*x)^(2/3)*(-((b*c + a*d + 2*b*d*x)/(b*c - a*d)))^(1/3)*AppellF1[2/3, 4/3, 1, 5/3, (2*b*(c + d*x))/(b*c - a*d), (b*(c + d*x))/(b*c - a*d)])/(2*(b*c - a*d)^2*(b*c + a*d + 2*b*d*x)^(1/3))", //
        142,
        141);
  }

  // {142, 141}
  public void test2015() {
    check( //
        "Integrate[1/((a + b*x)^2*(c + d*x)^(1/3)*(b*c + a*d + 2*b*d*x)^(4/3)), x]", //
        "(-3*d*(c + d*x)^(2/3)*(-((b*c + a*d + 2*b*d*x)/(b*c - a*d)))^(1/3)*AppellF1[2/3, 4/3, 2, 5/3, (2*b*(c + d*x))/(b*c - a*d), (b*(c + d*x))/(b*c - a*d)])/(2*(b*c - a*d)^3*(b*c + a*d + 2*b*d*x)^(1/3))", //
        142,
        141);
  }

  // {142, 141}
  public void test2016() {
    check( //
        "Integrate[1/((a + b*x)^3*(c + d*x)^(1/3)*(b*c + a*d + 2*b*d*x)^(4/3)), x]", //
        "(3*d^2*(c + d*x)^(2/3)*(-((b*c + a*d + 2*b*d*x)/(b*c - a*d)))^(1/3)*AppellF1[2/3, 4/3, 3, 5/3, (2*b*(c + d*x))/(b*c - a*d), (b*(c + d*x))/(b*c - a*d)])/(2*(b*c - a*d)^4*(b*c + a*d + 2*b*d*x)^(1/3))", //
        142,
        141);
  }

  // {80, 37}
  public void test2017() {
    check( //
        "Integrate[((a + b*x)*(c + d*x)^(-3 + n))/(e + f*x)^n, x]", //
        "((b*c - a*d)*(c + d*x)^(-2 + n)*(e + f*x)^(1 - n))/(d*(d*e - c*f)*(2 - n)) + ((a*d*f + b*c*f*(1 - n) - b*d*e*(2 - n))*(c + d*x)^(-1 + n)*(e + f*x)^(1 - n))/(d*(d*e - c*f)^2*(1 - n)*(2 - n))", //
        80,
        37);
  }

  // {80, 37}
  public void test2018() {
    check( //
        "Integrate[((c + d*x)*(e + f*x)^(-3 + n))/(a + b*x)^n, x]", //
        "-(((d*e - c*f)*(a + b*x)^(1 - n)*(e + f*x)^(-2 + n))/(f*(b*e - a*f)*(2 - n))) + ((b*c*f - a*d*f*(2 - n) + b*d*(e - e*n))*(a + b*x)^(1 - n)*(e + f*x)^(-1 + n))/(f*(b*e - a*f)^2*(1 - n)*(2 - n))", //
        80,
        37);
  }

  // {72, 71}
  public void test2019() {
    check( //
        "Integrate[(a + b*x)^m/(c + d*x)^m, x]", //
        "((a + b*x)^(1 + m)*((b*(c + d*x))/(b*c - a*d))^m*Hypergeometric2F1[m, 1 + m, 2 + m, -((d*(a + b*x))/(b*c - a*d))])/(b*(1 + m)*(c + d*x)^m)", //
        72,
        71);
  }

  // {98, 133}
  public void test2020() {
    check( //
        "Integrate[(a + b*x)^m/((c + d*x)^m*(e + f*x)^3), x]", //
        "-(f*(a + b*x)^(1 + m)*(c + d*x)^(1 - m))/(2*(b*e - a*f)*(d*e - c*f)*(e + f*x)^2) + ((b*c - a*d)*(2*b*d*e - b*c*f*(1 - m) - a*d*f*(1 + m))*(a + b*x)^(1 + m)*(c + d*x)^(-1 - m)*Hypergeometric2F1[2, 1 + m, 2 + m, ((d*e - c*f)*(a + b*x))/((b*e - a*f)*(c + d*x))])/(2*(b*e - a*f)^3*(d*e - c*f)*(1 + m))", //
        98,
        133);
  }

  // {72, 71}
  public void test2021() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^(-1 - m), x]", //
        "-(((a + b*x)^m*Hypergeometric2F1[-m, -m, 1 - m, (b*(c + d*x))/(b*c - a*d)])/(d*m*(-((d*(a + b*x))/(b*c - a*d)))^m*(c + d*x)^m))", //
        72,
        71);
  }

  // {98, 133}
  public void test2022() {
    check( //
        "Integrate[((a + b*x)^m*(c + d*x)^(-1 - m))/(e + f*x)^2, x]", //
        "(d*(a + b*x)^(1 + m))/((b*c - a*d)*(d*e - c*f)*m*(c + d*x)^m*(e + f*x)) + ((a*d*f*(1 + m) - b*(d*e + c*f*m))*(a + b*x)^(1 + m)*(c + d*x)^(-1 - m)*Hypergeometric2F1[2, 1 + m, 2 + m, ((d*e - c*f)*(a + b*x))/((b*e - a*f)*(c + d*x))])/((b*e - a*f)^2*(d*e - c*f)*m*(1 + m))", //
        98,
        133);
  }

  // {98, 133}
  public void test2023() {
    check( //
        "Integrate[((a + b*x)^m*(c + d*x)^(-2 - m))/(e + f*x), x]", //
        "(d*(a + b*x)^(1 + m)*(c + d*x)^(-1 - m))/((b*c - a*d)*(d*e - c*f)*(1 + m)) + (f*(a + b*x)^m*Hypergeometric2F1[1, -m, 1 - m, ((b*e - a*f)*(c + d*x))/((d*e - c*f)*(a + b*x))])/((d*e - c*f)^2*m*(c + d*x)^m)", //
        98,
        133);
  }

  // {80, 37}
  public void test2024() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^(-3 - m)*(e + f*x), x]", //
        "((d*e - c*f)*(a + b*x)^(1 + m)*(c + d*x)^(-2 - m))/(d*(b*c - a*d)*(2 + m)) + ((b*d*e + b*c*f*(1 + m) - a*d*f*(2 + m))*(a + b*x)^(1 + m)*(c + d*x)^(-1 - m))/(d*(b*c - a*d)^2*(1 + m)*(2 + m))", //
        80,
        37);
  }

  // {47, 37}
  public void test2025() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^(-3 - m), x]", //
        "((a + b*x)^(1 + m)*(c + d*x)^(-2 - m))/((b*c - a*d)*(2 + m)) + (b*(a + b*x)^(1 + m)*(c + d*x)^(-1 - m))/((b*c - a*d)^2*(1 + m)*(2 + m))", //
        47,
        37);
  }

  // {72, 71}
  public void test2026() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^(1 - m), x]", //
        "((b*c - a*d)*(a + b*x)^(1 + m)*((b*(c + d*x))/(b*c - a*d))^m*Hypergeometric2F1[-1 + m, 1 + m, 2 + m, -((d*(a + b*x))/(b*c - a*d))])/(b^2*(1 + m)*(c + d*x)^m)", //
        72,
        71);
  }

  // {98, 133}
  public void test2027() {
    check( //
        "Integrate[((a + b*x)^m*(c + d*x)^(1 - m))/(e + f*x)^4, x]", //
        "-(f*(a + b*x)^(1 + m)*(c + d*x)^(2 - m))/(3*(b*e - a*f)*(d*e - c*f)*(e + f*x)^3) + ((b*c - a*d)^2*(3*b*d*e - b*c*f*(2 - m) - a*d*f*(1 + m))*(a + b*x)^(1 + m)*(c + d*x)^(-1 - m)*Hypergeometric2F1[3, 1 + m, 2 + m, ((d*e - c*f)*(a + b*x))/((b*e - a*f)*(c + d*x))])/(3*(b*e - a*f)^4*(d*e - c*f)*(1 + m))", //
        98,
        133);
  }

  // {72, 71}
  public void test2028() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^(2 - m), x]", //
        "((b*c - a*d)^2*(a + b*x)^(1 + m)*((b*(c + d*x))/(b*c - a*d))^m*Hypergeometric2F1[-2 + m, 1 + m, 2 + m, -((d*(a + b*x))/(b*c - a*d))])/(b^3*(1 + m)*(c + d*x)^m)", //
        72,
        71);
  }

  // {98, 133}
  public void test2029() {
    check( //
        "Integrate[((a + b*x)^m*(c + d*x)^(2 - m))/(e + f*x)^5, x]", //
        "-(f*(a + b*x)^(1 + m)*(c + d*x)^(3 - m))/(4*(b*e - a*f)*(d*e - c*f)*(e + f*x)^4) + ((b*c - a*d)^3*(4*b*d*e - b*c*f*(3 - m) - a*d*f*(1 + m))*(a + b*x)^(1 + m)*(c + d*x)^(-1 - m)*Hypergeometric2F1[4, 1 + m, 2 + m, ((d*e - c*f)*(a + b*x))/((b*e - a*f)*(c + d*x))])/(4*(b*e - a*f)^5*(d*e - c*f)*(1 + m))", //
        98,
        133);
  }

  // {98, 134}
  public void test2030() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^(-m - n)*(e + f*x)^(-3 + n), x]", //
        "-((f*(a + b*x)^(1 + m)*(c + d*x)^(1 - m - n)*(e + f*x)^(-2 + n))/((b*e - a*f)*(d*e - c*f)*(2 - n))) - ((a*d*f*(1 + m) - b*d*e*(2 - n) + b*c*f*(1 - m - n))*(a + b*x)^(1 + m)*(c + d*x)^(-m - n)*(((b*e - a*f)*(c + d*x))/((b*c - a*d)*(e + f*x)))^(m + n)*(e + f*x)^(-1 + n)*Hypergeometric2F1[1 + m, m + n, 2 + m, -(((d*e - c*f)*(a + b*x))/((b*c - a*d)*(e + f*x)))])/((b*e - a*f)^2*(d*e - c*f)*(1 + m)*(2 - n))", //
        98,
        134);
  }

  // {98, 134}
  public void test2031() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)^n*(e + f*x)^(-3 - m - n), x]", //
        "-((f*(a + b*x)^(1 + m)*(c + d*x)^(1 + n)*(e + f*x)^(-2 - m - n))/((b*e - a*f)*(d*e - c*f)*(2 + m + n))) - ((a*d*f*(1 + m) + b*c*f*(1 + n) - b*d*e*(2 + m + n))*(a + b*x)^(1 + m)*(c + d*x)^n*(e + f*x)^(-1 - m - n)*Hypergeometric2F1[1 + m, -n, 2 + m, -(((d*e - c*f)*(a + b*x))/((b*c - a*d)*(e + f*x)))])/((b*e - a*f)^2*(d*e - c*f)*(1 + m)*(2 + m + n)*(((b*e - a*f)*(c + d*x))/((b*c - a*d)*(e + f*x)))^n)", //
        98,
        134);
  }

  // {142, 141}
  public void test2032() {
    check( //
        "Integrate[((a + b*x)^m*(c + d*x)^n)/(e + f*x), x]", //
        "((a + b*x)^(1 + m)*(c + d*x)^n*AppellF1[1 + m, -n, 1, 2 + m, -((d*(a + b*x))/(b*c - a*d)), -((f*(a + b*x))/(b*e - a*f))])/((b*e - a*f)*(1 + m)*((b*(c + d*x))/(b*c - a*d))^n)", //
        142,
        141);
  }

  // {142, 141}
  public void test2033() {
    check( //
        "Integrate[((a + b*x)^m*(c + d*x)^n)/(e + f*x)^2, x]", //
        "(b*(a + b*x)^(1 + m)*(c + d*x)^n*AppellF1[1 + m, -n, 2, 2 + m, -((d*(a + b*x))/(b*c - a*d)), -((f*(a + b*x))/(b*e - a*f))])/((b*e - a*f)^2*(1 + m)*((b*(c + d*x))/(b*c - a*d))^n)", //
        142,
        141);
  }

  // {142, 141}
  public void test2034() {
    check( //
        "Integrate[((a + b*x)^m*(c + d*x)^n)/(e + f*x)^3, x]", //
        "(b^2*(a + b*x)^(1 + m)*(c + d*x)^n*AppellF1[1 + m, -n, 3, 2 + m, -((d*(a + b*x))/(b*c - a*d)), -((f*(a + b*x))/(b*e - a*f))])/((b*e - a*f)^3*(1 + m)*((b*(c + d*x))/(b*c - a*d))^n)", //
        142,
        141);
  }

  // {142, 141}
  public void test2035() {
    check( //
        "Integrate[(a + b*x)^(4/3)/(Sqrt[c + d*x]*(e + f*x)), x]", //
        "(3*(a + b*x)^(7/3)*Sqrt[(b*(c + d*x))/(b*c - a*d)]*AppellF1[7/3, 1/2, 1, 10/3, -((d*(a + b*x))/(b*c - a*d)), -((f*(a + b*x))/(b*e - a*f))])/(7*(b*e - a*f)*Sqrt[c + d*x])", //
        142,
        141);
  }

  // {142, 141}
  public void test2036() {
    check( //
        "Integrate[(Sqrt[a + b*x]*(c + d*x)^(1/3))/(e + f*x), x]", //
        "(2*(a + b*x)^(3/2)*(c + d*x)^(1/3)*AppellF1[3/2, -1/3, 1, 5/2, -((d*(a + b*x))/(b*c - a*d)), -((f*(a + b*x))/(b*e - a*f))])/(3*(b*e - a*f)*((b*(c + d*x))/(b*c - a*d))^(1/3))", //
        142,
        141);
  }

  // {142, 141}
  public void test2037() {
    check( //
        "Integrate[((a + b*x)^(1/3)*Sqrt[c + d*x])/(e + f*x), x]", //
        "(3*(a + b*x)^(4/3)*Sqrt[c + d*x]*AppellF1[4/3, -1/2, 1, 7/3, -((d*(a + b*x))/(b*c - a*d)), -((f*(a + b*x))/(b*e - a*f))])/(4*(b*e - a*f)*Sqrt[(b*(c + d*x))/(b*c - a*d)])", //
        142,
        141);
  }

  // {78}
  public void test2038() {
    check( //
        "Integrate[(a + b*x)^4*(A + B*x)*(d + e*x)^m, x]", //
        "-(((b*d - a*e)^4*(B*d - A*e)*(d + e*x)^(1 + m))/(e^6*(1 + m))) + ((b*d - a*e)^3*(5*b*B*d - 4*A*b*e - a*B*e)*(d + e*x)^(2 + m))/(e^6*(2 + m)) - (2*b*(b*d - a*e)^2*(5*b*B*d - 3*A*b*e - 2*a*B*e)*(d + e*x)^(3 + m))/(e^6*(3 + m)) + (2*b^2*(b*d - a*e)*(5*b*B*d - 2*A*b*e - 3*a*B*e)*(d + e*x)^(4 + m))/(e^6*(4 + m)) - (b^3*(5*b*B*d - A*b*e - 4*a*B*e)*(d + e*x)^(5 + m))/(e^6*(5 + m)) + (b^4*B*(d + e*x)^(6 + m))/(e^6*(6 + m))", //
        78);
  }

  // {78}
  public void test2039() {
    check( //
        "Integrate[(a + b*x)^3*(A + B*x)*(d + e*x)^m, x]", //
        "((b*d - a*e)^3*(B*d - A*e)*(d + e*x)^(1 + m))/(e^5*(1 + m)) - ((b*d - a*e)^2*(4*b*B*d - 3*A*b*e - a*B*e)*(d + e*x)^(2 + m))/(e^5*(2 + m)) + (3*b*(b*d - a*e)*(2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(3 + m))/(e^5*(3 + m)) - (b^2*(4*b*B*d - A*b*e - 3*a*B*e)*(d + e*x)^(4 + m))/(e^5*(4 + m)) + (b^3*B*(d + e*x)^(5 + m))/(e^5*(5 + m))", //
        78);
  }

  // {78}
  public void test2040() {
    check( //
        "Integrate[(a + b*x)^2*(A + B*x)*(d + e*x)^m, x]", //
        "-(((b*d - a*e)^2*(B*d - A*e)*(d + e*x)^(1 + m))/(e^4*(1 + m))) + ((b*d - a*e)*(3*b*B*d - 2*A*b*e - a*B*e)*(d + e*x)^(2 + m))/(e^4*(2 + m)) - (b*(3*b*B*d - A*b*e - 2*a*B*e)*(d + e*x)^(3 + m))/(e^4*(3 + m)) + (b^2*B*(d + e*x)^(4 + m))/(e^4*(4 + m))", //
        78);
  }

  // {78}
  public void test2041() {
    check( //
        "Integrate[(a + b*x)*(A + B*x)*(d + e*x)^m, x]", //
        "((b*d - a*e)*(B*d - A*e)*(d + e*x)^(1 + m))/(e^3*(1 + m)) - ((2*b*B*d - A*b*e - a*B*e)*(d + e*x)^(2 + m))/(e^3*(2 + m)) + (b*B*(d + e*x)^(3 + m))/(e^3*(3 + m))", //
        78);
  }

  // {45}
  public void test2042() {
    check( //
        "Integrate[(A + B*x)*(d + e*x)^m, x]", //
        "-(((B*d - A*e)*(d + e*x)^(1 + m))/(e^2*(1 + m))) + (B*(d + e*x)^(2 + m))/(e^2*(2 + m))", //
        45);
  }

  // {81, 70}
  public void test2043() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^m)/(a + b*x), x]", //
        "(B*(d + e*x)^(1 + m))/(b*e*(1 + m)) - ((A*b - a*B)*(d + e*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, (b*(d + e*x))/(b*d - a*e)])/(b*(b*d - a*e)*(1 + m))", //
        81,
        70);
  }

  // {79, 70}
  public void test2044() {
    check( //
        "Integrate[((A + B*x)*(d + e*x)^m)/(a + b*x)^2, x]", //
        "-(((A*b - a*B)*(d + e*x)^(1 + m))/(b*(b*d - a*e)*(a + b*x))) + ((a*B*e*(1 + m) - b*(B*d + A*e*m))*(d + e*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, (b*(d + e*x))/(b*d - a*e)])/(b*(b*d - a*e)^2*(1 + m))", //
        79,
        70);
  }

  // {78}
  public void test2045() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^m*(3 + 5*x)^3, x]", //
        "(-7*(2 + 3*x)^(1 + m))/(243*(1 + m)) + (107*(2 + 3*x)^(2 + m))/(243*(2 + m)) - (185*(2 + 3*x)^(3 + m))/(81*(3 + m)) + (1025*(2 + 3*x)^(4 + m))/(243*(4 + m)) - (250*(2 + 3*x)^(5 + m))/(243*(5 + m))", //
        78);
  }

  // {78}
  public void test2046() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^m*(3 + 5*x)^2, x]", //
        "(7*(2 + 3*x)^(1 + m))/(81*(1 + m)) - (8*(2 + 3*x)^(2 + m))/(9*(2 + m)) + (65*(2 + 3*x)^(3 + m))/(27*(3 + m)) - (50*(2 + 3*x)^(4 + m))/(81*(4 + m))", //
        78);
  }

  // {78}
  public void test2047() {
    check( //
        "Integrate[(1 - 2*x)*(2 + 3*x)^m*(3 + 5*x), x]", //
        "(-7*(2 + 3*x)^(1 + m))/(27*(1 + m)) + (37*(2 + 3*x)^(2 + m))/(27*(2 + m)) - (10*(2 + 3*x)^(3 + m))/(27*(3 + m))", //
        78);
  }

  // {81, 70}
  public void test2048() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^m)/(3 + 5*x), x]", //
        "(-2*(2 + 3*x)^(1 + m))/(15*(1 + m)) - (11*(2 + 3*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, 5*(2 + 3*x)])/(5*(1 + m))", //
        81,
        70);
  }

  // {79, 70}
  public void test2049() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^m)/(3 + 5*x)^2, x]", //
        "(-11*(2 + 3*x)^(1 + m))/(5*(3 + 5*x)) + ((2 - 33*m)*(2 + 3*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, 5*(2 + 3*x)])/(5*(1 + m))", //
        79,
        70);
  }

  // {79, 70}
  public void test2050() {
    check( //
        "Integrate[((1 - 2*x)*(2 + 3*x)^m)/(3 + 5*x)^3, x]", //
        "(-11*(2 + 3*x)^(1 + m))/(10*(3 + 5*x)^2) - (3*(37 - 33*m)*(2 + 3*x)^(1 + m)*Hypergeometric2F1[2, 1 + m, 2 + m, 5*(2 + 3*x)])/(10*(1 + m))", //
        79,
        70);
  }

  // {81, 70}
  public void test2051() {
    check( //
        "Integrate[((2 + 3*x)^m*(3 + 5*x))/(1 - 2*x), x]", //
        "(-5*(2 + 3*x)^(1 + m))/(6*(1 + m)) + (11*(2 + 3*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, (2*(2 + 3*x))/7])/(14*(1 + m))", //
        81,
        70);
  }

  // {147}
  public void test2052() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)*(e + f*x)*(g + h*x), x]", //
        "a*c*e*g*x + ((b*c*e*g + a*(d*e*g + c*f*g + c*e*h))*x^2)/2 + ((b*(d*e*g + c*f*g + c*e*h) + a*(d*f*g + d*e*h + c*f*h))*x^3)/3 + ((a*d*f*h + b*(d*f*g + d*e*h + c*f*h))*x^4)/4 + (b*d*f*h*x^5)/5", //
        147);
  }

  // {147}
  public void test2053() {
    check( //
        "Integrate[((a + b*x)*(c + d*x)*(e + f*x))/(g + h*x), x]", //
        "((b*(d*g - c*h)*(f*g - e*h) - a*h*(d*f*g - d*e*h - c*f*h))*x)/h^3 + ((a*d*f*h - b*(d*f*g - d*e*h - c*f*h))*x^2)/(2*h^2) + (b*d*f*x^3)/(3*h) - ((b*g - a*h)*(d*g - c*h)*(f*g - e*h)*Log[g + h*x])/h^4", //
        147);
  }

  // {147}
  public void test2054() {
    check( //
        "Integrate[((a + b*x)*(c + d*x))/((e + f*x)*(g + h*x)), x]", //
        "(b*d*x)/(f*h) + ((b*e - a*f)*(d*e - c*f)*Log[e + f*x])/(f^2*(f*g - e*h)) - ((b*g - a*h)*(d*g - c*h)*Log[g + h*x])/(h^2*(f*g - e*h))", //
        147);
  }

  // {153}
  public void test2055() {
    check( //
        "Integrate[(a + b*x)/((c + d*x)*(e + f*x)*(g + h*x)), x]", //
        "-(((b*c - a*d)*Log[c + d*x])/((d*e - c*f)*(d*g - c*h))) + ((b*e - a*f)*Log[e + f*x])/((d*e - c*f)*(f*g - e*h)) - ((b*g - a*h)*Log[g + h*x])/((d*g - c*h)*(f*g - e*h))", //
        153);
  }

  // {186}
  public void test2056() {
    check( //
        "Integrate[1/((a + b*x)*(c + d*x)*(e + f*x)*(g + h*x)), x]", //
        "(b^2*Log[a + b*x])/((b*c - a*d)*(b*e - a*f)*(b*g - a*h)) - (d^2*Log[c + d*x])/((b*c - a*d)*(d*e - c*f)*(d*g - c*h)) + (f^2*Log[e + f*x])/((b*e - a*f)*(d*e - c*f)*(f*g - e*h)) - (h^2*Log[g + h*x])/((b*g - a*h)*(d*g - c*h)*(f*g - e*h))", //
        186);
  }

  // {153}
  public void test2057() {
    check( //
        "Integrate[x/((1 + x)*(2 + x)*(3 + x)), x]", //
        "-Log[1 + x]/2 + 2*Log[2 + x] - (3*Log[3 + x])/2", //
        153);
  }

  // {115, 114}
  public void test2058() {
    check( //
        "Integrate[Sqrt[2 - 3*x]/(Sqrt[-5 + 2*x]*Sqrt[1 + 4*x]), x]", //
        "(Sqrt[11/2]*Sqrt[5 - 2*x]*EllipticE[ArcSin[Sqrt[1 + 4*x]/Sqrt[11]], 3])/(2*Sqrt[-5 + 2*x])", //
        115,
        114);
  }

  // {122, 120}
  public void test2059() {
    check( //
        "Integrate[1/(Sqrt[2 - 3*x]*Sqrt[-5 + 2*x]*Sqrt[1 + 4*x]), x]", //
        "(Sqrt[2/33]*Sqrt[5 - 2*x]*EllipticF[ArcSin[Sqrt[3/11]*Sqrt[1 + 4*x]], 1/3])/Sqrt[-5 + 2*x]", //
        122,
        120);
  }

  // {171, 551}
  public void test2060() {
    check( //
        "Integrate[Sqrt[2 - 3*x]/(Sqrt[-5 + 2*x]*Sqrt[1 + 4*x]*Sqrt[7 + 5*x]), x]", //
        "(62*(2 - 3*x)*Sqrt[(5 - 2*x)/(2 - 3*x)]*Sqrt[-((1 + 4*x)/(2 - 3*x))]*EllipticPi[-69/55, ArcSin[(Sqrt[11/23]*Sqrt[7 + 5*x])/Sqrt[2 - 3*x]], -23/39])/(5*Sqrt[429]*Sqrt[-5 + 2*x]*Sqrt[1 + 4*x])", //
        171,
        551);
  }

  // {171, 551}
  public void test2061() {
    check( //
        "Integrate[Sqrt[7 + 5*x]/(Sqrt[2 - 3*x]*Sqrt[-5 + 2*x]*Sqrt[1 + 4*x]), x]", //
        "(23*Sqrt[(2 - 3*x)/(7 + 5*x)]*Sqrt[(5 - 2*x)/(7 + 5*x)]*(7 + 5*x)*EllipticPi[55/124, ArcSin[(Sqrt[31/11]*Sqrt[1 + 4*x])/Sqrt[7 + 5*x]], 39/62])/(2*Sqrt[682]*Sqrt[2 - 3*x]*Sqrt[-5 + 2*x])", //
        171,
        551);
  }

  // {176, 429}
  public void test2062() {
    check( //
        "Integrate[1/(Sqrt[2 - 3*x]*Sqrt[-5 + 2*x]*Sqrt[1 + 4*x]*Sqrt[7 + 5*x]), x]", //
        "(2*Sqrt[7 + 5*x]*EllipticF[ArcTan[Sqrt[1 + 4*x]/(Sqrt[2]*Sqrt[2 - 3*x])], -39/23])/(Sqrt[253]*Sqrt[-5 + 2*x]*Sqrt[(7 + 5*x)/(5 - 2*x)])", //
        176,
        429);
  }

  // {171, 551}
  public void test2063() {
    check( //
        "Integrate[Sqrt[a + b*x]/(Sqrt[c + d*x]*Sqrt[e + f*x]*Sqrt[g + h*x]), x]", //
        "(2*Sqrt[-(d*g) + c*h]*(a + b*x)*Sqrt[((b*g - a*h)*(c + d*x))/((d*g - c*h)*(a + b*x))]*Sqrt[((b*g - a*h)*(e + f*x))/((f*g - e*h)*(a + b*x))]*EllipticPi[-((b*(d*g - c*h))/((b*c - a*d)*h)), ArcSin[(Sqrt[b*c - a*d]*Sqrt[g + h*x])/(Sqrt[-(d*g) + c*h]*Sqrt[a + b*x])], ((b*e - a*f)*(d*g - c*h))/((b*c - a*d)*(f*g - e*h))])/(Sqrt[b*c - a*d]*h*Sqrt[c + d*x]*Sqrt[e + f*x])", //
        171,
        551);
  }

  // {147}
  public void test2064() {
    check( //
        "Integrate[(a + b*x)^m*(c + d*x)*(e + f*x)*(g + h*x), x]", //
        "((b*c - a*d)*(b*e - a*f)*(b*g - a*h)*(a + b*x)^(1 + m))/(b^4*(1 + m)) + ((3*a^2*d*f*h + b^2*(d*e*g + c*f*g + c*e*h) - 2*a*b*(d*f*g + d*e*h + c*f*h))*(a + b*x)^(2 + m))/(b^4*(2 + m)) - ((3*a*d*f*h - b*(d*f*g + d*e*h + c*f*h))*(a + b*x)^(3 + m))/(b^4*(3 + m)) + (d*f*h*(a + b*x)^(4 + m))/(b^4*(4 + m))", //
        147);
  }

  // {152, 70}
  public void test2065() {
    check( //
        "Integrate[((a + b*x)^m*(c + d*x)*(e + f*x))/(g + h*x), x]", //
        "-(((a + b*x)^(1 + m)*(a*d*f*h + b*(d*f*g - d*e*h - c*f*h)*(2 + m) - b*d*f*h*(1 + m)*x))/(b^2*h^2*(1 + m)*(2 + m))) + ((d*g - c*h)*(f*g - e*h)*(a + b*x)^(1 + m)*Hypergeometric2F1[1, 1 + m, 2 + m, -((h*(a + b*x))/(b*g - a*h))])/(h^2*(b*g - a*h)*(1 + m))", //
        152,
        70);
  }

  // {1634}
  public void test2066() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x + C*x^2 + D*x^3))/Sqrt[c + d*x], x]", //
        "(-2*(b*c - a*d)^3*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D)*Sqrt[c + d*x])/d^7 - (2*(b*c - a*d)^2*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(5*c^2*C*d - 4*B*c*d^2 + 3*A*d^3 - 6*c^3*D))*(c + d*x)^(3/2))/(3*d^7) - (2*(b*c - a*d)*(a^2*d^2*(C*d - 3*c*D) - a*b*d*(8*c*C*d - 3*B*d^2 - 15*c^2*D) + b^2*(10*c^2*C*d - 6*B*c*d^2 + 3*A*d^3 - 15*c^3*D))*(c + d*x)^(5/2))/(5*d^7) + (2*(a^3*d^3*D + 3*a^2*b*d^2*(C*d - 4*c*D) - 3*a*b^2*d*(4*c*C*d - B*d^2 - 10*c^2*D) + b^3*(10*c^2*C*d - 4*B*c*d^2 + A*d^3 - 20*c^3*D))*(c + d*x)^(7/2))/(7*d^7) + (2*b*(3*a^2*d^2*D + 3*a*b*d*(C*d - 5*c*D) - b^2*(5*c*C*d - B*d^2 - 15*c^2*D))*(c + d*x)^(9/2))/(9*d^7) + (2*b^2*(b*C*d - 6*b*c*D + 3*a*d*D)*(c + d*x)^(11/2))/(11*d^7) + (2*b^3*D*(c + d*x)^(13/2))/(13*d^7)", //
        1634);
  }

  // {1634}
  public void test2067() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x + C*x^2 + D*x^3))/Sqrt[c + d*x], x]", //
        "(2*(b*c - a*d)^2*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D)*Sqrt[c + d*x])/d^6 + (2*(b*c - a*d)*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(4*c^2*C*d - 3*B*c*d^2 + 2*A*d^3 - 5*c^3*D))*(c + d*x)^(3/2))/(3*d^6) + (2*(a^2*d^2*(C*d - 3*c*D) - 2*a*b*d*(3*c*C*d - B*d^2 - 6*c^2*D) + b^2*(6*c^2*C*d - 3*B*c*d^2 + A*d^3 - 10*c^3*D))*(c + d*x)^(5/2))/(5*d^6) + (2*(a^2*d^2*D + 2*a*b*d*(C*d - 4*c*D) - b^2*(4*c*C*d - B*d^2 - 10*c^2*D))*(c + d*x)^(7/2))/(7*d^6) + (2*b*(b*C*d - 5*b*c*D + 2*a*d*D)*(c + d*x)^(9/2))/(9*d^6) + (2*b^2*D*(c + d*x)^(11/2))/(11*d^6)", //
        1634);
  }

  // {1634}
  public void test2068() {
    check( //
        "Integrate[((a + b*x)*(A + B*x + C*x^2 + D*x^3))/Sqrt[c + d*x], x]", //
        "(-2*(b*c - a*d)*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D)*Sqrt[c + d*x])/d^5 - (2*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(3*c^2*C*d - 2*B*c*d^2 + A*d^3 - 4*c^3*D))*(c + d*x)^(3/2))/(3*d^5) + (2*(a*d*(C*d - 3*c*D) - b*(3*c*C*d - B*d^2 - 6*c^2*D))*(c + d*x)^(5/2))/(5*d^5) + (2*(b*C*d - 4*b*c*D + a*d*D)*(c + d*x)^(7/2))/(7*d^5) + (2*b*D*(c + d*x)^(9/2))/(9*d^5)", //
        1634);
  }

  // {1864}
  public void test2069() {
    check( //
        "Integrate[(A + B*x + C*x^2 + D*x^3)/Sqrt[c + d*x], x]", //
        "(2*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D)*Sqrt[c + d*x])/d^4 - (2*(2*c*C*d - B*d^2 - 3*c^2*D)*(c + d*x)^(3/2))/(3*d^4) + (2*(C*d - 3*c*D)*(c + d*x)^(5/2))/(5*d^4) + (2*D*(c + d*x)^(7/2))/(7*d^4)", //
        1864);
  }

  // {1634}
  public void test2070() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x + C*x^2 + D*x^3))/(c + d*x)^(3/2), x]", //
        "(2*(b*c - a*d)^3*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D))/(d^7*Sqrt[c + d*x]) - (2*(b*c - a*d)^2*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(5*c^2*C*d - 4*B*c*d^2 + 3*A*d^3 - 6*c^3*D))*Sqrt[c + d*x])/d^7 - (2*(b*c - a*d)*(a^2*d^2*(C*d - 3*c*D) - a*b*d*(8*c*C*d - 3*B*d^2 - 15*c^2*D) + b^2*(10*c^2*C*d - 6*B*c*d^2 + 3*A*d^3 - 15*c^3*D))*(c + d*x)^(3/2))/(3*d^7) + (2*(a^3*d^3*D + 3*a^2*b*d^2*(C*d - 4*c*D) - 3*a*b^2*d*(4*c*C*d - B*d^2 - 10*c^2*D) + b^3*(10*c^2*C*d - 4*B*c*d^2 + A*d^3 - 20*c^3*D))*(c + d*x)^(5/2))/(5*d^7) + (2*b*(3*a^2*d^2*D + 3*a*b*d*(C*d - 5*c*D) - b^2*(5*c*C*d - B*d^2 - 15*c^2*D))*(c + d*x)^(7/2))/(7*d^7) + (2*b^2*(b*C*d - 6*b*c*D + 3*a*d*D)*(c + d*x)^(9/2))/(9*d^7) + (2*b^3*D*(c + d*x)^(11/2))/(11*d^7)", //
        1634);
  }

  // {1634}
  public void test2071() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x + C*x^2 + D*x^3))/(c + d*x)^(3/2), x]", //
        "(-2*(b*c - a*d)^2*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D))/(d^6*Sqrt[c + d*x]) + (2*(b*c - a*d)*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(4*c^2*C*d - 3*B*c*d^2 + 2*A*d^3 - 5*c^3*D))*Sqrt[c + d*x])/d^6 + (2*(a^2*d^2*(C*d - 3*c*D) - 2*a*b*d*(3*c*C*d - B*d^2 - 6*c^2*D) + b^2*(6*c^2*C*d - 3*B*c*d^2 + A*d^3 - 10*c^3*D))*(c + d*x)^(3/2))/(3*d^6) + (2*(a^2*d^2*D + 2*a*b*d*(C*d - 4*c*D) - b^2*(4*c*C*d - B*d^2 - 10*c^2*D))*(c + d*x)^(5/2))/(5*d^6) + (2*b*(b*C*d - 5*b*c*D + 2*a*d*D)*(c + d*x)^(7/2))/(7*d^6) + (2*b^2*D*(c + d*x)^(9/2))/(9*d^6)", //
        1634);
  }

  // {1634}
  public void test2072() {
    check( //
        "Integrate[((a + b*x)*(A + B*x + C*x^2 + D*x^3))/(c + d*x)^(3/2), x]", //
        "(2*(b*c - a*d)*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D))/(d^5*Sqrt[c + d*x]) - (2*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(3*c^2*C*d - 2*B*c*d^2 + A*d^3 - 4*c^3*D))*Sqrt[c + d*x])/d^5 + (2*(a*d*(C*d - 3*c*D) - b*(3*c*C*d - B*d^2 - 6*c^2*D))*(c + d*x)^(3/2))/(3*d^5) + (2*(b*C*d - 4*b*c*D + a*d*D)*(c + d*x)^(5/2))/(5*d^5) + (2*b*D*(c + d*x)^(7/2))/(7*d^5)", //
        1634);
  }

  // {1864}
  public void test2073() {
    check( //
        "Integrate[(A + B*x + C*x^2 + D*x^3)/(c + d*x)^(3/2), x]", //
        "(-2*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D))/(d^4*Sqrt[c + d*x]) - (2*(2*c*C*d - B*d^2 - 3*c^2*D)*Sqrt[c + d*x])/d^4 + (2*(C*d - 3*c*D)*(c + d*x)^(3/2))/(3*d^4) + (2*D*(c + d*x)^(5/2))/(5*d^4)", //
        1864);
  }

  // {1634}
  public void test2074() {
    check( //
        "Integrate[((a + b*x)^3*(A + B*x + C*x^2 + D*x^3))/(c + d*x)^(5/2), x]", //
        "(2*(b*c - a*d)^3*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D))/(3*d^7*(c + d*x)^(3/2)) + (2*(b*c - a*d)^2*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(5*c^2*C*d - 4*B*c*d^2 + 3*A*d^3 - 6*c^3*D)))/(d^7*Sqrt[c + d*x]) - (2*(b*c - a*d)*(a^2*d^2*(C*d - 3*c*D) - a*b*d*(8*c*C*d - 3*B*d^2 - 15*c^2*D) + b^2*(10*c^2*C*d - 6*B*c*d^2 + 3*A*d^3 - 15*c^3*D))*Sqrt[c + d*x])/d^7 + (2*(a^3*d^3*D + 3*a^2*b*d^2*(C*d - 4*c*D) - 3*a*b^2*d*(4*c*C*d - B*d^2 - 10*c^2*D) + b^3*(10*c^2*C*d - 4*B*c*d^2 + A*d^3 - 20*c^3*D))*(c + d*x)^(3/2))/(3*d^7) + (2*b*(3*a^2*d^2*D + 3*a*b*d*(C*d - 5*c*D) - b^2*(5*c*C*d - B*d^2 - 15*c^2*D))*(c + d*x)^(5/2))/(5*d^7) + (2*b^2*(b*C*d - 6*b*c*D + 3*a*d*D)*(c + d*x)^(7/2))/(7*d^7) + (2*b^3*D*(c + d*x)^(9/2))/(9*d^7)", //
        1634);
  }

  // {1634}
  public void test2075() {
    check( //
        "Integrate[((a + b*x)^2*(A + B*x + C*x^2 + D*x^3))/(c + d*x)^(5/2), x]", //
        "(-2*(b*c - a*d)^2*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D))/(3*d^6*(c + d*x)^(3/2)) - (2*(b*c - a*d)*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(4*c^2*C*d - 3*B*c*d^2 + 2*A*d^3 - 5*c^3*D)))/(d^6*Sqrt[c + d*x]) + (2*(a^2*d^2*(C*d - 3*c*D) - 2*a*b*d*(3*c*C*d - B*d^2 - 6*c^2*D) + b^2*(6*c^2*C*d - 3*B*c*d^2 + A*d^3 - 10*c^3*D))*Sqrt[c + d*x])/d^6 + (2*(a^2*d^2*D + 2*a*b*d*(C*d - 4*c*D) - b^2*(4*c*C*d - B*d^2 - 10*c^2*D))*(c + d*x)^(3/2))/(3*d^6) + (2*b*(b*C*d - 5*b*c*D + 2*a*d*D)*(c + d*x)^(5/2))/(5*d^6) + (2*b^2*D*(c + d*x)^(7/2))/(7*d^6)", //
        1634);
  }

  // {1634}
  public void test2076() {
    check( //
        "Integrate[((a + b*x)*(A + B*x + C*x^2 + D*x^3))/(c + d*x)^(5/2), x]", //
        "(2*(b*c - a*d)*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D))/(3*d^5*(c + d*x)^(3/2)) + (2*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(3*c^2*C*d - 2*B*c*d^2 + A*d^3 - 4*c^3*D)))/(d^5*Sqrt[c + d*x]) + (2*(a*d*(C*d - 3*c*D) - b*(3*c*C*d - B*d^2 - 6*c^2*D))*Sqrt[c + d*x])/d^5 + (2*(b*C*d - 4*b*c*D + a*d*D)*(c + d*x)^(3/2))/(3*d^5) + (2*b*D*(c + d*x)^(5/2))/(5*d^5)", //
        1634);
  }

  // {1864}
  public void test2077() {
    check( //
        "Integrate[(A + B*x + C*x^2 + D*x^3)/(c + d*x)^(5/2), x]", //
        "(-2*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D))/(3*d^4*(c + d*x)^(3/2)) + (2*(2*c*C*d - B*d^2 - 3*c^2*D))/(d^4*Sqrt[c + d*x]) + (2*(C*d - 3*c*D)*Sqrt[c + d*x])/d^4 + (2*D*(c + d*x)^(3/2))/(3*d^4)", //
        1864);
  }

  // {1634}
  public void test2078() {
    check( //
        "Integrate[(a + b*x)^3*(c + d*x)^n*(A + B*x + C*x^2 + D*x^3), x]", //
        "-(((b*c - a*d)^3*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D)*(c + d*x)^(1 + n))/(d^7*(1 + n))) - ((b*c - a*d)^2*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(5*c^2*C*d - 4*B*c*d^2 + 3*A*d^3 - 6*c^3*D))*(c + d*x)^(2 + n))/(d^7*(2 + n)) - ((b*c - a*d)*(a^2*d^2*(C*d - 3*c*D) - a*b*d*(8*c*C*d - 3*B*d^2 - 15*c^2*D) + b^2*(10*c^2*C*d - 6*B*c*d^2 + 3*A*d^3 - 15*c^3*D))*(c + d*x)^(3 + n))/(d^7*(3 + n)) + ((a^3*d^3*D + 3*a^2*b*d^2*(C*d - 4*c*D) - 3*a*b^2*d*(4*c*C*d - B*d^2 - 10*c^2*D) + b^3*(10*c^2*C*d - 4*B*c*d^2 + A*d^3 - 20*c^3*D))*(c + d*x)^(4 + n))/(d^7*(4 + n)) + (b*(3*a^2*d^2*D + 3*a*b*d*(C*d - 5*c*D) - b^2*(5*c*C*d - B*d^2 - 15*c^2*D))*(c + d*x)^(5 + n))/(d^7*(5 + n)) + (b^2*(b*C*d - 6*b*c*D + 3*a*d*D)*(c + d*x)^(6 + n))/(d^7*(6 + n)) + (b^3*D*(c + d*x)^(7 + n))/(d^7*(7 + n))", //
        1634);
  }

  // {1634}
  public void test2079() {
    check( //
        "Integrate[(a + b*x)^2*(c + d*x)^n*(A + B*x + C*x^2 + D*x^3), x]", //
        "((b*c - a*d)^2*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D)*(c + d*x)^(1 + n))/(d^6*(1 + n)) + ((b*c - a*d)*(a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(4*c^2*C*d - 3*B*c*d^2 + 2*A*d^3 - 5*c^3*D))*(c + d*x)^(2 + n))/(d^6*(2 + n)) + ((a^2*d^2*(C*d - 3*c*D) - 2*a*b*d*(3*c*C*d - B*d^2 - 6*c^2*D) + b^2*(6*c^2*C*d - 3*B*c*d^2 + A*d^3 - 10*c^3*D))*(c + d*x)^(3 + n))/(d^6*(3 + n)) + ((a^2*d^2*D + 2*a*b*d*(C*d - 4*c*D) - b^2*(4*c*C*d - B*d^2 - 10*c^2*D))*(c + d*x)^(4 + n))/(d^6*(4 + n)) + (b*(b*C*d - 5*b*c*D + 2*a*d*D)*(c + d*x)^(5 + n))/(d^6*(5 + n)) + (b^2*D*(c + d*x)^(6 + n))/(d^6*(6 + n))", //
        1634);
  }

  // {1634}
  public void test2080() {
    check( //
        "Integrate[(a + b*x)*(c + d*x)^n*(A + B*x + C*x^2 + D*x^3), x]", //
        "-(((b*c - a*d)*(c^2*C*d - B*c*d^2 + A*d^3 - c^3*D)*(c + d*x)^(1 + n))/(d^5*(1 + n))) - ((a*d*(2*c*C*d - B*d^2 - 3*c^2*D) - b*(3*c^2*C*d - 2*B*c*d^2 + A*d^3 - 4*c^3*D))*(c + d*x)^(2 + n))/(d^5*(2 + n)) + ((a*d*(C*d - 3*c*D) - b*(3*c*C*d - B*d^2 - 6*c^2*D))*(c + d*x)^(3 + n))/(d^5*(3 + n)) + ((b*C*d - 4*b*c*D + a*d*D)*(c + d*x)^(4 + n))/(d^5*(4 + n)) + (b*D*(c + d*x)^(5 + n))/(d^5*(5 + n))", //
        1634);
  }

  // {1864}
  public void test2081() {
    check( //
        "Integrate[(c + d*x)^n*(A + B*x + C*x^2 + D*x^3), x]", //
        "((c^2*C*d - B*c*d^2 + A*d^3 - c^3*D)*(c + d*x)^(1 + n))/(d^4*(1 + n)) - ((2*c*C*d - B*d^2 - 3*c^2*D)*(c + d*x)^(2 + n))/(d^4*(2 + n)) + ((C*d - 3*c*D)*(c + d*x)^(3 + n))/(d^4*(3 + n)) + (D*(c + d*x)^(4 + n))/(d^4*(4 + n))", //
        1864);
  }

  // {14}
  public void test2082() {
    check( //
        "Integrate[x^4*(a + b*x^2), x]", //
        "(a*x^5)/5 + (b*x^7)/7", //
        14);
  }

  // {14}
  public void test2083() {
    check( //
        "Integrate[x^3*(a + b*x^2), x]", //
        "(a*x^4)/4 + (b*x^6)/6", //
        14);
  }

  // {14}
  public void test2084() {
    check( //
        "Integrate[x^2*(a + b*x^2), x]", //
        "(a*x^3)/3 + (b*x^5)/5", //
        14);
  }

  // {14}
  public void test2085() {
    check( //
        "Integrate[x*(a + b*x^2), x]", //
        "(a*x^2)/2 + (b*x^4)/4", //
        14);
  }

  // {14}
  public void test2086() {
    check( //
        "Integrate[(a + b*x^2)/x, x]", //
        "(b*x^2)/2 + a*Log[x]", //
        14);
  }

  // {14}
  public void test2087() {
    check( //
        "Integrate[(a + b*x^2)/x^2, x]", //
        "-(a/x) + b*x", //
        14);
  }

  // {14}
  public void test2088() {
    check( //
        "Integrate[(a + b*x^2)/x^3, x]", //
        "-a/(2*x^2) + b*Log[x]", //
        14);
  }

  // {14}
  public void test2089() {
    check( //
        "Integrate[(a + b*x^2)/x^4, x]", //
        "-a/(3*x^3) - b/x", //
        14);
  }

  // {14}
  public void test2090() {
    check( //
        "Integrate[(a + b*x^2)/x^5, x]", //
        "-a/(4*x^4) - b/(2*x^2)", //
        14);
  }

  // {14}
  public void test2091() {
    check( //
        "Integrate[(a + b*x^2)/x^6, x]", //
        "-a/(5*x^5) - b/(3*x^3)", //
        14);
  }

  // {14}
  public void test2092() {
    check( //
        "Integrate[(a + b*x^2)/x^7, x]", //
        "-a/(6*x^6) - b/(4*x^4)", //
        14);
  }

  // {276}
  public void test2093() {
    check( //
        "Integrate[x^4*(a + b*x^2)^2, x]", //
        "(a^2*x^5)/5 + (2*a*b*x^7)/7 + (b^2*x^9)/9", //
        276);
  }

  // {276}
  public void test2094() {
    check( //
        "Integrate[x^2*(a + b*x^2)^2, x]", //
        "(a^2*x^3)/3 + (2*a*b*x^5)/5 + (b^2*x^7)/7", //
        276);
  }

  // {200}
  public void test2095() {
    check( //
        "Integrate[(a + b*x^2)^2, x]", //
        "a^2*x + (2*a*b*x^3)/3 + (b^2*x^5)/5", //
        200);
  }

  // {276}
  public void test2096() {
    check( //
        "Integrate[(a + b*x^2)^2/x^2, x]", //
        "-(a^2/x) + 2*a*b*x + (b^2*x^3)/3", //
        276);
  }

  // {276}
  public void test2097() {
    check( //
        "Integrate[(a + b*x^2)^2/x^4, x]", //
        "-a^2/(3*x^3) - (2*a*b)/x + b^2*x", //
        276);
  }

  // {276}
  public void test2098() {
    check( //
        "Integrate[(a + b*x^2)^2/x^6, x]", //
        "-a^2/(5*x^5) - (2*a*b)/(3*x^3) - b^2/x", //
        276);
  }

  // {276}
  public void test2099() {
    check( //
        "Integrate[(a + b*x^2)^2/x^8, x]", //
        "-a^2/(7*x^7) - (2*a*b)/(5*x^5) - b^2/(3*x^3)", //
        276);
  }

  // {276}
  public void test2100() {
    check( //
        "Integrate[(a + b*x^2)^2/x^10, x]", //
        "-a^2/(9*x^9) - (2*a*b)/(7*x^7) - b^2/(5*x^5)", //
        276);
  }

  // {276}
  public void test2101() {
    check( //
        "Integrate[x^6*(a + b*x^2)^3, x]", //
        "(a^3*x^7)/7 + (a^2*b*x^9)/3 + (3*a*b^2*x^11)/11 + (b^3*x^13)/13", //
        276);
  }

  // {276}
  public void test2102() {
    check( //
        "Integrate[x^4*(a + b*x^2)^3, x]", //
        "(a^3*x^5)/5 + (3*a^2*b*x^7)/7 + (a*b^2*x^9)/3 + (b^3*x^11)/11", //
        276);
  }

  // {276}
  public void test2103() {
    check( //
        "Integrate[x^2*(a + b*x^2)^3, x]", //
        "(a^3*x^3)/3 + (3*a^2*b*x^5)/5 + (3*a*b^2*x^7)/7 + (b^3*x^9)/9", //
        276);
  }

  // {200}
  public void test2104() {
    check( //
        "Integrate[(a + b*x^2)^3, x]", //
        "a^3*x + a^2*b*x^3 + (3*a*b^2*x^5)/5 + (b^3*x^7)/7", //
        200);
  }

  // {276}
  public void test2105() {
    check( //
        "Integrate[(a + b*x^2)^3/x^2, x]", //
        "-(a^3/x) + 3*a^2*b*x + a*b^2*x^3 + (b^3*x^5)/5", //
        276);
  }

  // {276}
  public void test2106() {
    check( //
        "Integrate[(a + b*x^2)^3/x^4, x]", //
        "-a^3/(3*x^3) - (3*a^2*b)/x + 3*a*b^2*x + (b^3*x^3)/3", //
        276);
  }

  // {276}
  public void test2107() {
    check( //
        "Integrate[(a + b*x^2)^3/x^6, x]", //
        "-a^3/(5*x^5) - (a^2*b)/x^3 - (3*a*b^2)/x + b^3*x", //
        276);
  }

  // {276}
  public void test2108() {
    check( //
        "Integrate[(a + b*x^2)^3/x^8, x]", //
        "-a^3/(7*x^7) - (3*a^2*b)/(5*x^5) - (a*b^2)/x^3 - b^3/x", //
        276);
  }

  // {276}
  public void test2109() {
    check( //
        "Integrate[(a + b*x^2)^3/x^10, x]", //
        "-a^3/(9*x^9) - (3*a^2*b)/(7*x^7) - (3*a*b^2)/(5*x^5) - b^3/(3*x^3)", //
        276);
  }

  // {276}
  public void test2110() {
    check( //
        "Integrate[(a + b*x^2)^3/x^12, x]", //
        "-a^3/(11*x^11) - (a^2*b)/(3*x^9) - (3*a*b^2)/(7*x^7) - b^3/(5*x^5)", //
        276);
  }

  // {276}
  public void test2111() {
    check( //
        "Integrate[x^8*(a + b*x^2)^5, x]", //
        "(a^5*x^9)/9 + (5*a^4*b*x^11)/11 + (10*a^3*b^2*x^13)/13 + (2*a^2*b^3*x^15)/3 + (5*a*b^4*x^17)/17 + (b^5*x^19)/19", //
        276);
  }

  // {276}
  public void test2112() {
    check( //
        "Integrate[x^6*(a + b*x^2)^5, x]", //
        "(a^5*x^7)/7 + (5*a^4*b*x^9)/9 + (10*a^3*b^2*x^11)/11 + (10*a^2*b^3*x^13)/13 + (a*b^4*x^15)/3 + (b^5*x^17)/17", //
        276);
  }

  // {276}
  public void test2113() {
    check( //
        "Integrate[x^4*(a + b*x^2)^5, x]", //
        "(a^5*x^5)/5 + (5*a^4*b*x^7)/7 + (10*a^3*b^2*x^9)/9 + (10*a^2*b^3*x^11)/11 + (5*a*b^4*x^13)/13 + (b^5*x^15)/15", //
        276);
  }

  // {276}
  public void test2114() {
    check( //
        "Integrate[x^2*(a + b*x^2)^5, x]", //
        "(a^5*x^3)/3 + a^4*b*x^5 + (10*a^3*b^2*x^7)/7 + (10*a^2*b^3*x^9)/9 + (5*a*b^4*x^11)/11 + (b^5*x^13)/13", //
        276);
  }

  // {200}
  public void test2115() {
    check( //
        "Integrate[(a + b*x^2)^5, x]", //
        "a^5*x + (5*a^4*b*x^3)/3 + 2*a^3*b^2*x^5 + (10*a^2*b^3*x^7)/7 + (5*a*b^4*x^9)/9 + (b^5*x^11)/11", //
        200);
  }

  // {276}
  public void test2116() {
    check( //
        "Integrate[(a + b*x^2)^5/x^2, x]", //
        "-(a^5/x) + 5*a^4*b*x + (10*a^3*b^2*x^3)/3 + 2*a^2*b^3*x^5 + (5*a*b^4*x^7)/7 + (b^5*x^9)/9", //
        276);
  }

  // {276}
  public void test2117() {
    check( //
        "Integrate[(a + b*x^2)^5/x^4, x]", //
        "-a^5/(3*x^3) - (5*a^4*b)/x + 10*a^3*b^2*x + (10*a^2*b^3*x^3)/3 + a*b^4*x^5 + (b^5*x^7)/7", //
        276);
  }

  // {276}
  public void test2118() {
    check( //
        "Integrate[(a + b*x^2)^5/x^6, x]", //
        "-a^5/(5*x^5) - (5*a^4*b)/(3*x^3) - (10*a^3*b^2)/x + 10*a^2*b^3*x + (5*a*b^4*x^3)/3 + (b^5*x^5)/5", //
        276);
  }

  // {276}
  public void test2119() {
    check( //
        "Integrate[(a + b*x^2)^5/x^8, x]", //
        "-a^5/(7*x^7) - (a^4*b)/x^5 - (10*a^3*b^2)/(3*x^3) - (10*a^2*b^3)/x + 5*a*b^4*x + (b^5*x^3)/3", //
        276);
  }

  // {276}
  public void test2120() {
    check( //
        "Integrate[(a + b*x^2)^5/x^10, x]", //
        "-a^5/(9*x^9) - (5*a^4*b)/(7*x^7) - (2*a^3*b^2)/x^5 - (10*a^2*b^3)/(3*x^3) - (5*a*b^4)/x + b^5*x", //
        276);
  }

  // {276}
  public void test2121() {
    check( //
        "Integrate[(a + b*x^2)^5/x^12, x]", //
        "-a^5/(11*x^11) - (5*a^4*b)/(9*x^9) - (10*a^3*b^2)/(7*x^7) - (2*a^2*b^3)/x^5 - (5*a*b^4)/(3*x^3) - b^5/x", //
        276);
  }

  // {276}
  public void test2122() {
    check( //
        "Integrate[(a + b*x^2)^5/x^14, x]", //
        "-a^5/(13*x^13) - (5*a^4*b)/(11*x^11) - (10*a^3*b^2)/(9*x^9) - (10*a^2*b^3)/(7*x^7) - (a*b^4)/x^5 - b^5/(3*x^3)", //
        276);
  }

  // {276}
  public void test2123() {
    check( //
        "Integrate[(a + b*x^2)^5/x^16, x]", //
        "-a^5/(15*x^15) - (5*a^4*b)/(13*x^13) - (10*a^3*b^2)/(11*x^11) - (10*a^2*b^3)/(9*x^9) - (5*a*b^4)/(7*x^7) - b^5/(5*x^5)", //
        276);
  }

  // {276}
  public void test2124() {
    check( //
        "Integrate[(a + b*x^2)^5/x^18, x]", //
        "-a^5/(17*x^17) - (a^4*b)/(3*x^15) - (10*a^3*b^2)/(13*x^13) - (10*a^2*b^3)/(11*x^11) - (5*a*b^4)/(9*x^9) - b^5/(7*x^7)", //
        276);
  }

  // {276}
  public void test2125() {
    check( //
        "Integrate[(a + b*x^2)^5/x^20, x]", //
        "-a^5/(19*x^19) - (5*a^4*b)/(17*x^17) - (2*a^3*b^2)/(3*x^15) - (10*a^2*b^3)/(13*x^13) - (5*a*b^4)/(11*x^11) - b^5/(9*x^9)", //
        276);
  }

  // {276}
  public void test2126() {
    check( //
        "Integrate[x^8*(a + b*x^2)^8, x]", //
        "(a^8*x^9)/9 + (8*a^7*b*x^11)/11 + (28*a^6*b^2*x^13)/13 + (56*a^5*b^3*x^15)/15 + (70*a^4*b^4*x^17)/17 + (56*a^3*b^5*x^19)/19 + (4*a^2*b^6*x^21)/3 + (8*a*b^7*x^23)/23 + (b^8*x^25)/25", //
        276);
  }

  // {276}
  public void test2127() {
    check( //
        "Integrate[x^6*(a + b*x^2)^8, x]", //
        "(a^8*x^7)/7 + (8*a^7*b*x^9)/9 + (28*a^6*b^2*x^11)/11 + (56*a^5*b^3*x^13)/13 + (14*a^4*b^4*x^15)/3 + (56*a^3*b^5*x^17)/17 + (28*a^2*b^6*x^19)/19 + (8*a*b^7*x^21)/21 + (b^8*x^23)/23", //
        276);
  }

  // {276}
  public void test2128() {
    check( //
        "Integrate[x^4*(a + b*x^2)^8, x]", //
        "(a^8*x^5)/5 + (8*a^7*b*x^7)/7 + (28*a^6*b^2*x^9)/9 + (56*a^5*b^3*x^11)/11 + (70*a^4*b^4*x^13)/13 + (56*a^3*b^5*x^15)/15 + (28*a^2*b^6*x^17)/17 + (8*a*b^7*x^19)/19 + (b^8*x^21)/21", //
        276);
  }

  // {276}
  public void test2129() {
    check( //
        "Integrate[x^2*(a + b*x^2)^8, x]", //
        "(a^8*x^3)/3 + (8*a^7*b*x^5)/5 + 4*a^6*b^2*x^7 + (56*a^5*b^3*x^9)/9 + (70*a^4*b^4*x^11)/11 + (56*a^3*b^5*x^13)/13 + (28*a^2*b^6*x^15)/15 + (8*a*b^7*x^17)/17 + (b^8*x^19)/19", //
        276);
  }

  // {200}
  public void test2130() {
    check( //
        "Integrate[(a + b*x^2)^8, x]", //
        "a^8*x + (8*a^7*b*x^3)/3 + (28*a^6*b^2*x^5)/5 + 8*a^5*b^3*x^7 + (70*a^4*b^4*x^9)/9 + (56*a^3*b^5*x^11)/11 + (28*a^2*b^6*x^13)/13 + (8*a*b^7*x^15)/15 + (b^8*x^17)/17", //
        200);
  }

  // {276}
  public void test2131() {
    check( //
        "Integrate[(a + b*x^2)^8/x^2, x]", //
        "-(a^8/x) + 8*a^7*b*x + (28*a^6*b^2*x^3)/3 + (56*a^5*b^3*x^5)/5 + 10*a^4*b^4*x^7 + (56*a^3*b^5*x^9)/9 + (28*a^2*b^6*x^11)/11 + (8*a*b^7*x^13)/13 + (b^8*x^15)/15", //
        276);
  }

  // {276}
  public void test2132() {
    check( //
        "Integrate[(a + b*x^2)^8/x^4, x]", //
        "-a^8/(3*x^3) - (8*a^7*b)/x + 28*a^6*b^2*x + (56*a^5*b^3*x^3)/3 + 14*a^4*b^4*x^5 + 8*a^3*b^5*x^7 + (28*a^2*b^6*x^9)/9 + (8*a*b^7*x^11)/11 + (b^8*x^13)/13", //
        276);
  }

  // {276}
  public void test2133() {
    check( //
        "Integrate[(a + b*x^2)^8/x^6, x]", //
        "-a^8/(5*x^5) - (8*a^7*b)/(3*x^3) - (28*a^6*b^2)/x + 56*a^5*b^3*x + (70*a^4*b^4*x^3)/3 + (56*a^3*b^5*x^5)/5 + 4*a^2*b^6*x^7 + (8*a*b^7*x^9)/9 + (b^8*x^11)/11", //
        276);
  }

  // {276}
  public void test2134() {
    check( //
        "Integrate[(a + b*x^2)^8/x^8, x]", //
        "-a^8/(7*x^7) - (8*a^7*b)/(5*x^5) - (28*a^6*b^2)/(3*x^3) - (56*a^5*b^3)/x + 70*a^4*b^4*x + (56*a^3*b^5*x^3)/3 + (28*a^2*b^6*x^5)/5 + (8*a*b^7*x^7)/7 + (b^8*x^9)/9", //
        276);
  }

  // {276}
  public void test2135() {
    check( //
        "Integrate[(a + b*x^2)^8/x^10, x]", //
        "-a^8/(9*x^9) - (8*a^7*b)/(7*x^7) - (28*a^6*b^2)/(5*x^5) - (56*a^5*b^3)/(3*x^3) - (70*a^4*b^4)/x + 56*a^3*b^5*x + (28*a^2*b^6*x^3)/3 + (8*a*b^7*x^5)/5 + (b^8*x^7)/7", //
        276);
  }

  // {276}
  public void test2136() {
    check( //
        "Integrate[(a + b*x^2)^8/x^12, x]", //
        "-a^8/(11*x^11) - (8*a^7*b)/(9*x^9) - (4*a^6*b^2)/x^7 - (56*a^5*b^3)/(5*x^5) - (70*a^4*b^4)/(3*x^3) - (56*a^3*b^5)/x + 28*a^2*b^6*x + (8*a*b^7*x^3)/3 + (b^8*x^5)/5", //
        276);
  }

  // {276}
  public void test2137() {
    check( //
        "Integrate[(a + b*x^2)^8/x^14, x]", //
        "-a^8/(13*x^13) - (8*a^7*b)/(11*x^11) - (28*a^6*b^2)/(9*x^9) - (8*a^5*b^3)/x^7 - (14*a^4*b^4)/x^5 - (56*a^3*b^5)/(3*x^3) - (28*a^2*b^6)/x + 8*a*b^7*x + (b^8*x^3)/3", //
        276);
  }

  // {276}
  public void test2138() {
    check( //
        "Integrate[(a + b*x^2)^8/x^16, x]", //
        "-a^8/(15*x^15) - (8*a^7*b)/(13*x^13) - (28*a^6*b^2)/(11*x^11) - (56*a^5*b^3)/(9*x^9) - (10*a^4*b^4)/x^7 - (56*a^3*b^5)/(5*x^5) - (28*a^2*b^6)/(3*x^3) - (8*a*b^7)/x + b^8*x", //
        276);
  }

  // {276}
  public void test2139() {
    check( //
        "Integrate[(a + b*x^2)^8/x^18, x]", //
        "-a^8/(17*x^17) - (8*a^7*b)/(15*x^15) - (28*a^6*b^2)/(13*x^13) - (56*a^5*b^3)/(11*x^11) - (70*a^4*b^4)/(9*x^9) - (8*a^3*b^5)/x^7 - (28*a^2*b^6)/(5*x^5) - (8*a*b^7)/(3*x^3) - b^8/x", //
        276);
  }

  // {276}
  public void test2140() {
    check( //
        "Integrate[(a + b*x^2)^8/x^20, x]", //
        "-a^8/(19*x^19) - (8*a^7*b)/(17*x^17) - (28*a^6*b^2)/(15*x^15) - (56*a^5*b^3)/(13*x^13) - (70*a^4*b^4)/(11*x^11) - (56*a^3*b^5)/(9*x^9) - (4*a^2*b^6)/x^7 - (8*a*b^7)/(5*x^5) - b^8/(3*x^3)", //
        276);
  }

  // {327, 211}
  public void test2141() {
    check( //
        "Integrate[x^2/(a + b*x^2), x]", //
        "x/b - (Sqrt[a]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(3/2)", //
        327,
        211);
  }

  // {331, 211}
  public void test2142() {
    check( //
        "Integrate[1/(x^2*(a + b*x^2)), x]", //
        "-(1/(a*x)) - (Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(3/2)", //
        331,
        211);
  }

  // {294, 211}
  public void test2143() {
    check( //
        "Integrate[x^2/(a + b*x^2)^2, x]", //
        "-x/(2*b*(a + b*x^2)) + ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(2*Sqrt[a]*b^(3/2))", //
        294,
        211);
  }

  // {205, 211}
  public void test2144() {
    check( //
        "Integrate[(a + b*x^2)^(-2), x]", //
        "x/(2*a*(a + b*x^2)) + ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(2*a^(3/2)*Sqrt[b])", //
        205,
        211);
  }

  // {327, 214}
  public void test2145() {
    check( //
        "Integrate[x^2/(a - b*x^2), x]", //
        "-(x/b) + (Sqrt[a]*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/b^(3/2)", //
        327,
        214);
  }

  // {331, 214}
  public void test2146() {
    check( //
        "Integrate[1/(x^2*(a - b*x^2)), x]", //
        "-(1/(a*x)) + (Sqrt[b]*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/a^(3/2)", //
        331,
        214);
  }

  // {294, 214}
  public void test2147() {
    check( //
        "Integrate[x^2/(a - b*x^2)^2, x]", //
        "x/(2*b*(a - b*x^2)) - ArcTanh[(Sqrt[b]*x)/Sqrt[a]]/(2*Sqrt[a]*b^(3/2))", //
        294,
        214);
  }

  // {205, 214}
  public void test2148() {
    check( //
        "Integrate[(a - b*x^2)^(-2), x]", //
        "x/(2*a*(a - b*x^2)) + ArcTanh[(Sqrt[b]*x)/Sqrt[a]]/(2*a^(3/2)*Sqrt[b])", //
        205,
        214);
  }

  // {14}
  public void test2149() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2), x]", //
        "(2*a*x^(9/2))/9 + (2*b*x^(13/2))/13", //
        14);
  }

  // {14}
  public void test2150() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2), x]", //
        "(2*a*x^(7/2))/7 + (2*b*x^(11/2))/11", //
        14);
  }

  // {14}
  public void test2151() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2), x]", //
        "(2*a*x^(5/2))/5 + (2*b*x^(9/2))/9", //
        14);
  }

  // {14}
  public void test2152() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2), x]", //
        "(2*a*x^(3/2))/3 + (2*b*x^(7/2))/7", //
        14);
  }

  // {14}
  public void test2153() {
    check( //
        "Integrate[(a + b*x^2)/Sqrt[x], x]", //
        "2*a*Sqrt[x] + (2*b*x^(5/2))/5", //
        14);
  }

  // {14}
  public void test2154() {
    check( //
        "Integrate[(a + b*x^2)/x^(3/2), x]", //
        "(-2*a)/Sqrt[x] + (2*b*x^(3/2))/3", //
        14);
  }

  // {14}
  public void test2155() {
    check( //
        "Integrate[(a + b*x^2)/x^(5/2), x]", //
        "(-2*a)/(3*x^(3/2)) + 2*b*Sqrt[x]", //
        14);
  }

  // {14}
  public void test2156() {
    check( //
        "Integrate[(a + b*x^2)/x^(7/2), x]", //
        "(-2*a)/(5*x^(5/2)) - (2*b)/Sqrt[x]", //
        14);
  }

  // {276}
  public void test2157() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2)^2, x]", //
        "(2*a^2*x^(9/2))/9 + (4*a*b*x^(13/2))/13 + (2*b^2*x^(17/2))/17", //
        276);
  }

  // {276}
  public void test2158() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2)^2, x]", //
        "(2*a^2*x^(7/2))/7 + (4*a*b*x^(11/2))/11 + (2*b^2*x^(15/2))/15", //
        276);
  }

  // {276}
  public void test2159() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2)^2, x]", //
        "(2*a^2*x^(5/2))/5 + (4*a*b*x^(9/2))/9 + (2*b^2*x^(13/2))/13", //
        276);
  }

  // {276}
  public void test2160() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2)^2, x]", //
        "(2*a^2*x^(3/2))/3 + (4*a*b*x^(7/2))/7 + (2*b^2*x^(11/2))/11", //
        276);
  }

  // {276}
  public void test2161() {
    check( //
        "Integrate[(a + b*x^2)^2/Sqrt[x], x]", //
        "2*a^2*Sqrt[x] + (4*a*b*x^(5/2))/5 + (2*b^2*x^(9/2))/9", //
        276);
  }

  // {276}
  public void test2162() {
    check( //
        "Integrate[(a + b*x^2)^2/x^(3/2), x]", //
        "(-2*a^2)/Sqrt[x] + (4*a*b*x^(3/2))/3 + (2*b^2*x^(7/2))/7", //
        276);
  }

  // {276}
  public void test2163() {
    check( //
        "Integrate[(a + b*x^2)^2/x^(5/2), x]", //
        "(-2*a^2)/(3*x^(3/2)) + 4*a*b*Sqrt[x] + (2*b^2*x^(5/2))/5", //
        276);
  }

  // {276}
  public void test2164() {
    check( //
        "Integrate[(a + b*x^2)^2/x^(7/2), x]", //
        "(-2*a^2)/(5*x^(5/2)) - (4*a*b)/Sqrt[x] + (2*b^2*x^(3/2))/3", //
        276);
  }

  // {276}
  public void test2165() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2)^3, x]", //
        "(2*a^3*x^(9/2))/9 + (6*a^2*b*x^(13/2))/13 + (6*a*b^2*x^(17/2))/17 + (2*b^3*x^(21/2))/21", //
        276);
  }

  // {276}
  public void test2166() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2)^3, x]", //
        "(2*a^3*x^(7/2))/7 + (6*a^2*b*x^(11/2))/11 + (2*a*b^2*x^(15/2))/5 + (2*b^3*x^(19/2))/19", //
        276);
  }

  // {276}
  public void test2167() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2)^3, x]", //
        "(2*a^3*x^(5/2))/5 + (2*a^2*b*x^(9/2))/3 + (6*a*b^2*x^(13/2))/13 + (2*b^3*x^(17/2))/17", //
        276);
  }

  // {276}
  public void test2168() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2)^3, x]", //
        "(2*a^3*x^(3/2))/3 + (6*a^2*b*x^(7/2))/7 + (6*a*b^2*x^(11/2))/11 + (2*b^3*x^(15/2))/15", //
        276);
  }

  // {276}
  public void test2169() {
    check( //
        "Integrate[(a + b*x^2)^3/Sqrt[x], x]", //
        "2*a^3*Sqrt[x] + (6*a^2*b*x^(5/2))/5 + (2*a*b^2*x^(9/2))/3 + (2*b^3*x^(13/2))/13", //
        276);
  }

  // {276}
  public void test2170() {
    check( //
        "Integrate[(a + b*x^2)^3/x^(3/2), x]", //
        "(-2*a^3)/Sqrt[x] + 2*a^2*b*x^(3/2) + (6*a*b^2*x^(7/2))/7 + (2*b^3*x^(11/2))/11", //
        276);
  }

  // {276}
  public void test2171() {
    check( //
        "Integrate[(a + b*x^2)^3/x^(5/2), x]", //
        "(-2*a^3)/(3*x^(3/2)) + 6*a^2*b*Sqrt[x] + (6*a*b^2*x^(5/2))/5 + (2*b^3*x^(9/2))/9", //
        276);
  }

  // {276}
  public void test2172() {
    check( //
        "Integrate[(a + b*x^2)^3/x^(7/2), x]", //
        "(-2*a^3)/(5*x^(5/2)) - (6*a^2*b)/Sqrt[x] + 2*a*b^2*x^(3/2) + (2*b^3*x^(7/2))/7", //
        276);
  }

  // {276}
  public void test2173() {
    check( //
        "Integrate[x^m*(a + b*x^2)^5, x]", //
        "(a^5*x^(1 + m))/(1 + m) + (5*a^4*b*x^(3 + m))/(3 + m) + (10*a^3*b^2*x^(5 + m))/(5 + m) + (10*a^2*b^3*x^(7 + m))/(7 + m) + (5*a*b^4*x^(9 + m))/(9 + m) + (b^5*x^(11 + m))/(11 + m)", //
        276);
  }

  // {276}
  public void test2174() {
    check( //
        "Integrate[x^m*(a + b*x^2)^4, x]", //
        "(a^4*x^(1 + m))/(1 + m) + (4*a^3*b*x^(3 + m))/(3 + m) + (6*a^2*b^2*x^(5 + m))/(5 + m) + (4*a*b^3*x^(7 + m))/(7 + m) + (b^4*x^(9 + m))/(9 + m)", //
        276);
  }

  // {276}
  public void test2175() {
    check( //
        "Integrate[x^m*(a + b*x^2)^3, x]", //
        "(a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(3 + m))/(3 + m) + (3*a*b^2*x^(5 + m))/(5 + m) + (b^3*x^(7 + m))/(7 + m)", //
        276);
  }

  // {276}
  public void test2176() {
    check( //
        "Integrate[x^m*(a + b*x^2)^2, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(3 + m))/(3 + m) + (b^2*x^(5 + m))/(5 + m)", //
        276);
  }

  // {14}
  public void test2177() {
    check( //
        "Integrate[x^m*(a + b*x^2), x]", //
        "(a*x^(1 + m))/(1 + m) + (b*x^(3 + m))/(3 + m)", //
        14);
  }

  // {277, 270}
  public void test2178() {
    check( //
        "Integrate[Sqrt[a + b*x^2]/x^6, x]", //
        "-(a + b*x^2)^(3/2)/(5*a*x^5) + (2*b*(a + b*x^2)^(3/2))/(15*a^2*x^3)", //
        277,
        270);
  }

  // {277, 270}
  public void test2179() {
    check( //
        "Integrate[(a + b*x^2)^(3/2)/x^8, x]", //
        "-(a + b*x^2)^(5/2)/(7*a*x^7) + (2*b*(a + b*x^2)^(5/2))/(35*a^2*x^5)", //
        277,
        270);
  }

  // {277, 270}
  public void test2180() {
    check( //
        "Integrate[(a + b*x^2)^(5/2)/x^10, x]", //
        "-(a + b*x^2)^(7/2)/(9*a*x^9) + (2*b*(a + b*x^2)^(7/2))/(63*a^2*x^7)", //
        277,
        270);
  }

  // {277, 270}
  public void test2181() {
    check( //
        "Integrate[(a + b*x^2)^(9/2)/x^14, x]", //
        "-(a + b*x^2)^(11/2)/(13*a*x^13) + (2*b*(a + b*x^2)^(11/2))/(143*a^2*x^11)", //
        277,
        270);
  }

  // {201, 221}
  public void test2182() {
    check( //
        "Integrate[Sqrt[9 + 4*x^2], x]", //
        "(x*Sqrt[9 + 4*x^2])/2 + (9*ArcSinh[(2*x)/3])/4", //
        201,
        221);
  }

  // {283, 221}
  public void test2183() {
    check( //
        "Integrate[Sqrt[9 + 4*x^2]/x^2, x]", //
        "-(Sqrt[9 + 4*x^2]/x) + 2*ArcSinh[(2*x)/3]", //
        283,
        221);
  }

  // {201, 222}
  public void test2184() {
    check( //
        "Integrate[Sqrt[9 - 4*x^2], x]", //
        "(x*Sqrt[9 - 4*x^2])/2 + (9*ArcSin[(2*x)/3])/4", //
        201,
        222);
  }

  // {283, 222}
  public void test2185() {
    check( //
        "Integrate[Sqrt[9 - 4*x^2]/x^2, x]", //
        "-(Sqrt[9 - 4*x^2]/x) - 2*ArcSin[(2*x)/3]", //
        283,
        222);
  }

  // {223, 212}
  public void test2186() {
    check( //
        "Integrate[1/Sqrt[a + b*x^2], x]", //
        "ArcTanh[(Sqrt[b]*x)/Sqrt[a + b*x^2]]/Sqrt[b]", //
        223,
        212);
  }

  // {277, 270}
  public void test2187() {
    check( //
        "Integrate[1/(x^4*Sqrt[a + b*x^2]), x]", //
        "-Sqrt[a + b*x^2]/(3*a*x^3) + (2*b*Sqrt[a + b*x^2])/(3*a^2*x)", //
        277,
        270);
  }

  // {277, 197}
  public void test2188() {
    check( //
        "Integrate[1/(x^2*(a + b*x^2)^(3/2)), x]", //
        "-(1/(a*x*Sqrt[a + b*x^2])) - (2*b*x)/(a^2*Sqrt[a + b*x^2])", //
        277,
        197);
  }

  // {198, 197}
  public void test2189() {
    check( //
        "Integrate[(a + b*x^2)^(-5/2), x]", //
        "x/(3*a*(a + b*x^2)^(3/2)) + (2*x)/(3*a^2*Sqrt[a + b*x^2])", //
        198,
        197);
  }

  // {277, 270}
  public void test2190() {
    check( //
        "Integrate[x^4/(a + b*x^2)^(9/2), x]", //
        "x^5/(5*a*(a + b*x^2)^(7/2)) + (2*b*x^7)/(35*a^2*(a + b*x^2)^(7/2))", //
        277,
        270);
  }

  // {327, 221}
  public void test2191() {
    check( //
        "Integrate[x^2/Sqrt[9 + 4*x^2], x]", //
        "(x*Sqrt[9 + 4*x^2])/8 - (9*ArcSinh[(2*x)/3])/16", //
        327,
        221);
  }

  // {277, 270}
  public void test2192() {
    check( //
        "Integrate[1/(x^4*Sqrt[9 + 4*x^2]), x]", //
        "-Sqrt[9 + 4*x^2]/(27*x^3) + (8*Sqrt[9 + 4*x^2])/(243*x)", //
        277,
        270);
  }

  // {327, 222}
  public void test2193() {
    check( //
        "Integrate[x^2/Sqrt[9 - 4*x^2], x]", //
        "-(x*Sqrt[9 - 4*x^2])/8 + (9*ArcSin[(2*x)/3])/16", //
        327,
        222);
  }

  // {277, 270}
  public void test2194() {
    check( //
        "Integrate[1/(x^4*Sqrt[9 - 4*x^2]), x]", //
        "-Sqrt[9 - 4*x^2]/(27*x^3) - (8*Sqrt[9 - 4*x^2])/(243*x)", //
        277,
        270);
  }

  // {223, 212}
  public void test2195() {
    check( //
        "Integrate[1/Sqrt[-9 + 4*x^2], x]", //
        "ArcTanh[(2*x)/Sqrt[-9 + 4*x^2]]/2", //
        223,
        212);
  }

  // {277, 270}
  public void test2196() {
    check( //
        "Integrate[1/(x^4*Sqrt[-9 + 4*x^2]), x]", //
        "Sqrt[-9 + 4*x^2]/(27*x^3) + (8*Sqrt[-9 + 4*x^2])/(243*x)", //
        277,
        270);
  }

  // {223, 209}
  public void test2197() {
    check( //
        "Integrate[1/Sqrt[-9 - 4*x^2], x]", //
        "ArcTan[(2*x)/Sqrt[-9 - 4*x^2]]/2", //
        223,
        209);
  }

  // {277, 270}
  public void test2198() {
    check( //
        "Integrate[1/(x^4*Sqrt[-9 - 4*x^2]), x]", //
        "Sqrt[-9 - 4*x^2]/(27*x^3) - (8*Sqrt[-9 - 4*x^2])/(243*x)", //
        277,
        270);
  }

  // {223, 212}
  public void test2199() {
    check( //
        "Integrate[1/Sqrt[-9 + b*x^2], x]", //
        "ArcTanh[(Sqrt[b]*x)/Sqrt[-9 + b*x^2]]/Sqrt[b]", //
        223,
        212);
  }

  // {223, 209}
  public void test2200() {
    check( //
        "Integrate[1/Sqrt[-9 - b*x^2], x]", //
        "ArcTan[(Sqrt[b]*x)/Sqrt[-9 - b*x^2]]/Sqrt[b]", //
        223,
        209);
  }

  // {223, 212}
  public void test2201() {
    check( //
        "Integrate[1/Sqrt[-Pi + b*x^2], x]", //
        "ArcTanh[(Sqrt[b]*x)/Sqrt[-Pi + b*x^2]]/Sqrt[b]", //
        223,
        212);
  }

  // {223, 209}
  public void test2202() {
    check( //
        "Integrate[1/Sqrt[-Pi - b*x^2], x]", //
        "ArcTan[(Sqrt[b]*x)/Sqrt[-Pi - b*x^2]]/Sqrt[b]", //
        223,
        209);
  }

  // {223, 212}
  public void test2203() {
    check( //
        "Integrate[1/Sqrt[a + b*x^2], x]", //
        "ArcTanh[(Sqrt[b]*x)/Sqrt[a + b*x^2]]/Sqrt[b]", //
        223,
        212);
  }

  // {223, 209}
  public void test2204() {
    check( //
        "Integrate[1/Sqrt[a - b*x^2], x]", //
        "ArcTan[(Sqrt[b]*x)/Sqrt[a - b*x^2]]/Sqrt[b]", //
        223,
        209);
  }

  // {223, 212}
  public void test2205() {
    check( //
        "Integrate[1/Sqrt[-a + b*x^2], x]", //
        "ArcTanh[(Sqrt[b]*x)/Sqrt[-a + b*x^2]]/Sqrt[b]", //
        223,
        212);
  }

  // {223, 209}
  public void test2206() {
    check( //
        "Integrate[1/Sqrt[-a - b*x^2], x]", //
        "ArcTan[(Sqrt[b]*x)/Sqrt[-a - b*x^2]]/Sqrt[b]", //
        223,
        209);
  }

  // {223, 209}
  public void test2207() {
    check( //
        "Integrate[1/Sqrt[a^2 - x^2], x]", //
        "ArcTan[x/Sqrt[a^2 - x^2]]", //
        223,
        209);
  }

  // {335, 226}
  public void test2208() {
    check( //
        "Integrate[1/(Sqrt[c*x]*Sqrt[a + b*x^2]), x]", //
        "((Sqrt[a] + Sqrt[b]*x)*Sqrt[(a + b*x^2)/(Sqrt[a] + Sqrt[b]*x)^2]*EllipticF[2*ArcTan[(b^(1/4)*Sqrt[c*x])/(a^(1/4)*Sqrt[c])], 1/2])/(a^(1/4)*b^(1/4)*Sqrt[c]*Sqrt[a + b*x^2])", //
        335,
        226);
  }

  // {335, 227}
  public void test2209() {
    check( //
        "Integrate[1/(Sqrt[x]*Sqrt[1 - a^2*x^2]), x]", //
        "(2*EllipticF[ArcSin[Sqrt[a]*Sqrt[x]], -1])/Sqrt[a]", //
        335,
        227);
  }

  // {335, 226}
  public void test2210() {
    check( //
        "Integrate[1/(Sqrt[x]*Sqrt[1 + a*x^2]), x]", //
        "((1 + Sqrt[a]*x)*Sqrt[(1 + a*x^2)/(1 + Sqrt[a]*x)^2]*EllipticF[2*ArcTan[a^(1/4)*Sqrt[x]], 1/2])/(a^(1/4)*Sqrt[1 + a*x^2])", //
        335,
        226);
  }

  // {242, 225}
  public void test2211() {
    check( //
        "Integrate[(a + b*x^2)^(-2/3), x]", //
        "-((3^(3/4)*Sqrt[2 - Sqrt[3]]*(a^(1/3) - (a + b*x^2)^(1/3))*Sqrt[(a^(2/3) + a^(1/3)*(a + b*x^2)^(1/3) + (a + b*x^2)^(2/3))/((1 - Sqrt[3])*a^(1/3) - (a + b*x^2)^(1/3))^2]*EllipticF[ArcSin[((1 + Sqrt[3])*a^(1/3) - (a + b*x^2)^(1/3))/((1 - Sqrt[3])*a^(1/3) - (a + b*x^2)^(1/3))], -7 + 4*Sqrt[3]])/(b*x*Sqrt[-((a^(1/3)*(a^(1/3) - (a + b*x^2)^(1/3)))/((1 - Sqrt[3])*a^(1/3) - (a + b*x^2)^(1/3))^2)]))", //
        242,
        225);
  }

  // {279, 270}
  public void test2212() {
    check( //
        "Integrate[(a + b*x^2)^(1/3)/(c*x)^(17/3), x]", //
        "(-3*(a + b*x^2)^(4/3))/(8*a*c*(c*x)^(14/3)) + (9*(a + b*x^2)^(7/3))/(56*a^2*c*(c*x)^(14/3))", //
        279,
        270);
  }

  // {372, 371}
  public void test2213() {
    check( //
        "Integrate[(c*x)^(2/3)*(a + b*x^2)^(1/3), x]", //
        "(3*(c*x)^(5/3)*(a + b*x^2)^(1/3)*Hypergeometric2F1[-1/3, 5/6, 11/6, -((b*x^2)/a)])/(5*c*(1 + (b*x^2)/a)^(1/3))", //
        372,
        371);
  }

  // {372, 371}
  public void test2214() {
    check( //
        "Integrate[(a + b*x^2)^(1/3)/(c*x)^(1/3), x]", //
        "(3*(c*x)^(2/3)*(a + b*x^2)^(1/3)*Hypergeometric2F1[-1/3, 1/3, 4/3, -((b*x^2)/a)])/(2*c*(1 + (b*x^2)/a)^(1/3))", //
        372,
        371);
  }

  // {372, 371}
  public void test2215() {
    check( //
        "Integrate[(a + b*x^2)^(1/3)/(c*x)^(4/3), x]", //
        "(-3*(a + b*x^2)^(1/3)*Hypergeometric2F1[-1/3, -1/6, 5/6, -((b*x^2)/a)])/(c*(c*x)^(1/3)*(1 + (b*x^2)/a)^(1/3))", //
        372,
        371);
  }

  // {279, 270}
  public void test2216() {
    check( //
        "Integrate[(a + b*x^2)^(4/3)/(c*x)^(23/3), x]", //
        "(-3*(a + b*x^2)^(7/3))/(14*a*c*(c*x)^(20/3)) + (9*(a + b*x^2)^(10/3))/(140*a^2*c*(c*x)^(20/3))", //
        279,
        270);
  }

  // {372, 371}
  public void test2217() {
    check( //
        "Integrate[(c*x)^(2/3)*(a + b*x^2)^(4/3), x]", //
        "(3*a*(c*x)^(5/3)*(a + b*x^2)^(1/3)*Hypergeometric2F1[-4/3, 5/6, 11/6, -((b*x^2)/a)])/(5*c*(1 + (b*x^2)/a)^(1/3))", //
        372,
        371);
  }

  // {372, 371}
  public void test2218() {
    check( //
        "Integrate[(a + b*x^2)^(4/3)/(c*x)^(1/3), x]", //
        "(3*a*(c*x)^(2/3)*(a + b*x^2)^(1/3)*Hypergeometric2F1[-4/3, 1/3, 4/3, -((b*x^2)/a)])/(2*c*(1 + (b*x^2)/a)^(1/3))", //
        372,
        371);
  }

  // {372, 371}
  public void test2219() {
    check( //
        "Integrate[(a + b*x^2)^(4/3)/(c*x)^(4/3), x]", //
        "(-3*a*(a + b*x^2)^(1/3)*Hypergeometric2F1[-4/3, -1/6, 5/6, -((b*x^2)/a)])/(c*(c*x)^(1/3)*(1 + (b*x^2)/a)^(1/3))", //
        372,
        371);
  }

  // {279, 270}
  public void test2220() {
    check( //
        "Integrate[1/((c*x)^(11/3)*(a + b*x^2)^(2/3)), x]", //
        "(-3*(a + b*x^2)^(1/3))/(2*a*c*(c*x)^(8/3)) + (9*(a + b*x^2)^(4/3))/(8*a^2*c*(c*x)^(8/3))", //
        279,
        270);
  }

  // {372, 371}
  public void test2221() {
    check( //
        "Integrate[(c*x)^(2/3)/(a + b*x^2)^(2/3), x]", //
        "(3*(c*x)^(5/3)*(1 + (b*x^2)/a)^(2/3)*Hypergeometric2F1[2/3, 5/6, 11/6, -((b*x^2)/a)])/(5*c*(a + b*x^2)^(2/3))", //
        372,
        371);
  }

  // {372, 371}
  public void test2222() {
    check( //
        "Integrate[1/((c*x)^(1/3)*(a + b*x^2)^(2/3)), x]", //
        "(3*(c*x)^(2/3)*(1 + (b*x^2)/a)^(2/3)*Hypergeometric2F1[1/3, 2/3, 4/3, -((b*x^2)/a)])/(2*c*(a + b*x^2)^(2/3))", //
        372,
        371);
  }

  // {372, 371}
  public void test2223() {
    check( //
        "Integrate[1/((c*x)^(4/3)*(a + b*x^2)^(2/3)), x]", //
        "(-3*(1 + (b*x^2)/a)^(2/3)*Hypergeometric2F1[-1/6, 2/3, 5/6, -((b*x^2)/a)])/(c*(c*x)^(1/3)*(a + b*x^2)^(2/3))", //
        372,
        371);
  }

  // {235, 234}
  public void test2224() {
    check( //
        "Integrate[(a - b*x^2)^(-1/4), x]", //
        "(2*Sqrt[a]*(1 - (b*x^2)/a)^(1/4)*EllipticE[ArcSin[(Sqrt[b]*x)/Sqrt[a]]/2, 2])/(Sqrt[b]*(a - b*x^2)^(1/4))", //
        235,
        234);
  }

  // {239, 237}
  public void test2225() {
    check( //
        "Integrate[(a + b*x^2)^(-3/4), x]", //
        "(2*Sqrt[a]*(1 + (b*x^2)/a)^(3/4)*EllipticF[ArcTan[(Sqrt[b]*x)/Sqrt[a]]/2, 2])/(Sqrt[b]*(a + b*x^2)^(3/4))", //
        239,
        237);
  }

  // {239, 238}
  public void test2226() {
    check( //
        "Integrate[(a - b*x^2)^(-3/4), x]", //
        "(2*Sqrt[a]*(1 - (b*x^2)/a)^(3/4)*EllipticF[ArcSin[(Sqrt[b]*x)/Sqrt[a]]/2, 2])/(Sqrt[b]*(a - b*x^2)^(3/4))", //
        239,
        238);
  }

  // {203, 202}
  public void test2227() {
    check( //
        "Integrate[(a + b*x^2)^(-5/4), x]", //
        "(2*(1 + (b*x^2)/a)^(1/4)*EllipticE[ArcTan[(Sqrt[b]*x)/Sqrt[a]]/2, 2])/(Sqrt[a]*Sqrt[b]*(a + b*x^2)^(1/4))", //
        203,
        202);
  }

  // {233, 202}
  public void test2228() {
    check( //
        "Integrate[(2 + 3*x^2)^(-1/4), x]", //
        "(2*x)/(2 + 3*x^2)^(1/4) - (2*2^(1/4)*EllipticE[ArcTan[Sqrt[3/2]*x]/2, 2])/Sqrt[3]", //
        233,
        202);
  }

  // {327, 234}
  public void test2229() {
    check( //
        "Integrate[x^2/(2 - 3*x^2)^(1/4), x]", //
        "(-2*x*(2 - 3*x^2)^(3/4))/15 + (8*2^(1/4)*EllipticE[ArcSin[Sqrt[3/2]*x]/2, 2])/(15*Sqrt[3])", //
        327,
        234);
  }

  // {331, 234}
  public void test2230() {
    check( //
        "Integrate[1/(x^2*(2 - 3*x^2)^(1/4)), x]", //
        "-(2 - 3*x^2)^(3/4)/(2*x) - (Sqrt[3]*EllipticE[ArcSin[Sqrt[3/2]*x]/2, 2])/2^(3/4)", //
        331,
        234);
  }

  // {327, 237}
  public void test2231() {
    check( //
        "Integrate[x^2/(2 + 3*x^2)^(3/4), x]", //
        "(2*x*(2 + 3*x^2)^(1/4))/9 - (4*2^(3/4)*EllipticF[ArcTan[Sqrt[3/2]*x]/2, 2])/(9*Sqrt[3])", //
        327,
        237);
  }

  // {331, 237}
  public void test2232() {
    check( //
        "Integrate[1/(x^2*(2 + 3*x^2)^(3/4)), x]", //
        "-(2 + 3*x^2)^(1/4)/(2*x) - (Sqrt[3]*EllipticF[ArcTan[Sqrt[3/2]*x]/2, 2])/(2*2^(1/4))", //
        331,
        237);
  }

  // {327, 238}
  public void test2233() {
    check( //
        "Integrate[x^2/(2 - 3*x^2)^(3/4), x]", //
        "(-2*x*(2 - 3*x^2)^(1/4))/9 + (4*2^(3/4)*EllipticF[ArcSin[Sqrt[3/2]*x]/2, 2])/(9*Sqrt[3])", //
        327,
        238);
  }

  // {331, 238}
  public void test2234() {
    check( //
        "Integrate[1/(x^2*(2 - 3*x^2)^(3/4)), x]", //
        "-(2 - 3*x^2)^(1/4)/(2*x) + (Sqrt[3]*EllipticF[ArcSin[Sqrt[3/2]*x]/2, 2])/(2*2^(1/4))", //
        331,
        238);
  }

  // {240, 226}
  public void test2235() {
    check( //
        "Integrate[(-2 + 3*x^2)^(-3/4), x]", //
        "(Sqrt[x^2/(Sqrt[2] + Sqrt[-2 + 3*x^2])^2]*(Sqrt[2] + Sqrt[-2 + 3*x^2])*EllipticF[2*ArcTan[(-2 + 3*x^2)^(1/4)/2^(1/4)], 1/2])/(2^(1/4)*Sqrt[3]*x)", //
        240,
        226);
  }

  // {240, 226}
  public void test2236() {
    check( //
        "Integrate[(-2 - 3*x^2)^(-3/4), x]", //
        "-((Sqrt[-(x^2/(Sqrt[2] + Sqrt[-2 - 3*x^2])^2)]*(Sqrt[2] + Sqrt[-2 - 3*x^2])*EllipticF[2*ArcTan[(-2 - 3*x^2)^(1/4)/2^(1/4)], 1/2])/(2^(1/4)*Sqrt[3]*x))", //
        240,
        226);
  }

  // {279, 270}
  public void test2237() {
    check( //
        "Integrate[(a + b*x^2)^(1/4)/(c*x)^(11/2), x]", //
        "(-2*(a + b*x^2)^(5/4))/(5*a*c*(c*x)^(9/2)) + (8*(a + b*x^2)^(9/4))/(45*a^2*c*(c*x)^(9/2))", //
        279,
        270);
  }

  // {279, 270}
  public void test2238() {
    check( //
        "Integrate[(a - b*x^2)^(1/4)/(c*x)^(11/2), x]", //
        "(-2*(a - b*x^2)^(5/4))/(5*a*c*(c*x)^(9/2)) + (8*(a - b*x^2)^(9/4))/(45*a^2*c*(c*x)^(9/2))", //
        279,
        270);
  }

  // {279, 270}
  public void test2239() {
    check( //
        "Integrate[1/((c*x)^(9/2)*(a + b*x^2)^(1/4)), x]", //
        "(-2*(a + b*x^2)^(3/4))/(3*a*c*(c*x)^(7/2)) + (8*(a + b*x^2)^(7/4))/(21*a^2*c*(c*x)^(7/2))", //
        279,
        270);
  }

  // {279, 270}
  public void test2240() {
    check( //
        "Integrate[1/((c*x)^(9/2)*(a - b*x^2)^(1/4)), x]", //
        "(-2*(a - b*x^2)^(3/4))/(3*a*c*(c*x)^(7/2)) + (8*(a - b*x^2)^(7/4))/(21*a^2*c*(c*x)^(7/2))", //
        279,
        270);
  }

  // {279, 270}
  public void test2241() {
    check( //
        "Integrate[1/((c*x)^(7/2)*(a + b*x^2)^(3/4)), x]", //
        "(-2*(a + b*x^2)^(1/4))/(a*c*(c*x)^(5/2)) + (8*(a + b*x^2)^(5/4))/(5*a^2*c*(c*x)^(5/2))", //
        279,
        270);
  }

  // {279, 270}
  public void test2242() {
    check( //
        "Integrate[1/((c*x)^(7/2)*(a - b*x^2)^(3/4)), x]", //
        "(-2*(a - b*x^2)^(1/4))/(a*c*(c*x)^(5/2)) + (8*(a - b*x^2)^(5/4))/(5*a^2*c*(c*x)^(5/2))", //
        279,
        270);
  }

  // {279, 270}
  public void test2243() {
    check( //
        "Integrate[1/((c*x)^(5/2)*(a + b*x^2)^(5/4)), x]", //
        "2/(a*c*(c*x)^(3/2)*(a + b*x^2)^(1/4)) - (8*(a + b*x^2)^(3/4))/(3*a^2*c*(c*x)^(3/2))", //
        279,
        270);
  }

  // {372, 371}
  public void test2244() {
    check( //
        "Integrate[(c*x)^(5/4)/(a + b*x^2)^(1/4), x]", //
        "(4*(c*x)^(9/4)*(1 + (b*x^2)/a)^(1/4)*Hypergeometric2F1[1/4, 9/8, 17/8, -((b*x^2)/a)])/(9*c*(a + b*x^2)^(1/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2245() {
    check( //
        "Integrate[(c*x)^(3/4)/(a + b*x^2)^(1/4), x]", //
        "(4*(c*x)^(7/4)*(1 + (b*x^2)/a)^(1/4)*Hypergeometric2F1[1/4, 7/8, 15/8, -((b*x^2)/a)])/(7*c*(a + b*x^2)^(1/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2246() {
    check( //
        "Integrate[(c*x)^(1/4)/(a + b*x^2)^(1/4), x]", //
        "(4*(c*x)^(5/4)*(1 + (b*x^2)/a)^(1/4)*Hypergeometric2F1[1/4, 5/8, 13/8, -((b*x^2)/a)])/(5*c*(a + b*x^2)^(1/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2247() {
    check( //
        "Integrate[1/((c*x)^(1/4)*(a + b*x^2)^(1/4)), x]", //
        "(4*(c*x)^(3/4)*(1 + (b*x^2)/a)^(1/4)*Hypergeometric2F1[1/4, 3/8, 11/8, -((b*x^2)/a)])/(3*c*(a + b*x^2)^(1/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2248() {
    check( //
        "Integrate[1/((c*x)^(3/4)*(a + b*x^2)^(1/4)), x]", //
        "(4*(c*x)^(1/4)*(1 + (b*x^2)/a)^(1/4)*Hypergeometric2F1[1/8, 1/4, 9/8, -((b*x^2)/a)])/(c*(a + b*x^2)^(1/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2249() {
    check( //
        "Integrate[1/((c*x)^(5/4)*(a + b*x^2)^(1/4)), x]", //
        "(-4*(1 + (b*x^2)/a)^(1/4)*Hypergeometric2F1[-1/8, 1/4, 7/8, -((b*x^2)/a)])/(c*(c*x)^(1/4)*(a + b*x^2)^(1/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2250() {
    check( //
        "Integrate[(c*x)^(5/4)/(a + b*x^2)^(7/4), x]", //
        "(4*(c*x)^(9/4)*(1 + (b*x^2)/a)^(3/4)*Hypergeometric2F1[9/8, 7/4, 17/8, -((b*x^2)/a)])/(9*a*c*(a + b*x^2)^(3/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2251() {
    check( //
        "Integrate[(c*x)^(3/4)/(a + b*x^2)^(7/4), x]", //
        "(4*(c*x)^(7/4)*(1 + (b*x^2)/a)^(3/4)*Hypergeometric2F1[7/8, 7/4, 15/8, -((b*x^2)/a)])/(7*a*c*(a + b*x^2)^(3/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2252() {
    check( //
        "Integrate[(c*x)^(1/4)/(a + b*x^2)^(7/4), x]", //
        "(4*(c*x)^(5/4)*(1 + (b*x^2)/a)^(3/4)*Hypergeometric2F1[5/8, 7/4, 13/8, -((b*x^2)/a)])/(5*a*c*(a + b*x^2)^(3/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2253() {
    check( //
        "Integrate[1/((c*x)^(1/4)*(a + b*x^2)^(7/4)), x]", //
        "(4*(c*x)^(3/4)*(1 + (b*x^2)/a)^(3/4)*Hypergeometric2F1[3/8, 7/4, 11/8, -((b*x^2)/a)])/(3*a*c*(a + b*x^2)^(3/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2254() {
    check( //
        "Integrate[1/((c*x)^(3/4)*(a + b*x^2)^(7/4)), x]", //
        "(4*(c*x)^(1/4)*(1 + (b*x^2)/a)^(3/4)*Hypergeometric2F1[1/8, 7/4, 9/8, -((b*x^2)/a)])/(a*c*(a + b*x^2)^(3/4))", //
        372,
        371);
  }

  // {372, 371}
  public void test2255() {
    check( //
        "Integrate[1/((c*x)^(5/4)*(a + b*x^2)^(7/4)), x]", //
        "(-4*(1 + (b*x^2)/a)^(3/4)*Hypergeometric2F1[-1/8, 7/4, 7/8, -((b*x^2)/a)])/(a*c*(c*x)^(1/4)*(a + b*x^2)^(3/4))", //
        372,
        371);
  }

  // {272, 67}
  public void test2256() {
    check( //
        "Integrate[(a + b*x^2)^p/x, x]", //
        "-((a + b*x^2)^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*x^2)/a])/(2*a*(1 + p))", //
        272,
        67);
  }

  // {272, 67}
  public void test2257() {
    check( //
        "Integrate[(a + b*x^2)^p/x^3, x]", //
        "(b*(a + b*x^2)^(1 + p)*Hypergeometric2F1[2, 1 + p, 2 + p, 1 + (b*x^2)/a])/(2*a^2*(1 + p))", //
        272,
        67);
  }

  // {372, 371}
  public void test2258() {
    check( //
        "Integrate[(c*x)^m*(a + b*x^2)^p, x]", //
        "((c*x)^(1 + m)*(a + b*x^2)^p*Hypergeometric2F1[(1 + m)/2, -p, (3 + m)/2, -((b*x^2)/a)])/(c*(1 + m)*(1 + (b*x^2)/a)^p)", //
        372,
        371);
  }

  // {277, 270}
  public void test2259() {
    check( //
        "Integrate[x^(-5 - 2*p)*(a + b*x^2)^p, x]", //
        "(b*(a + b*x^2)^(1 + p))/(2*a^2*(1 + p)*(2 + p)*x^(2*(1 + p))) - (a + b*x^2)^(1 + p)/(2*a*(2 + p)*x^(2*(2 + p)))", //
        277,
        270);
  }

  // {380}
  public void test2260() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^4, x]", //
        "a*c^4*x + (c^3*(b*c + 4*a*d)*x^3)/3 + (2*c^2*d*(2*b*c + 3*a*d)*x^5)/5 + (2*c*d^2*(3*b*c + 2*a*d)*x^7)/7 + (d^3*(4*b*c + a*d)*x^9)/9 + (b*d^4*x^11)/11", //
        380);
  }

  // {380}
  public void test2261() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^3, x]", //
        "a*c^3*x + (c^2*(b*c + 3*a*d)*x^3)/3 + (3*c*d*(b*c + a*d)*x^5)/5 + (d^2*(3*b*c + a*d)*x^7)/7 + (b*d^3*x^9)/9", //
        380);
  }

  // {380}
  public void test2262() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^2, x]", //
        "a*c^2*x + (c*(b*c + 2*a*d)*x^3)/3 + (d*(2*b*c + a*d)*x^5)/5 + (b*d^2*x^7)/7", //
        380);
  }

  // {380}
  public void test2263() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2), x]", //
        "a*c*x + ((b*c + a*d)*x^3)/3 + (b*d*x^5)/5", //
        380);
  }

  // {396, 211}
  public void test2264() {
    check( //
        "Integrate[(a + b*x^2)/(c + d*x^2), x]", //
        "(b*x)/d - ((b*c - a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(Sqrt[c]*d^(3/2))", //
        396,
        211);
  }

  // {393, 211}
  public void test2265() {
    check( //
        "Integrate[(a + b*x^2)/(c + d*x^2)^2, x]", //
        "-((b*c - a*d)*x)/(2*c*d*(c + d*x^2)) + ((b*c + a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*c^(3/2)*d^(3/2))", //
        393,
        211);
  }

  // {380}
  public void test2266() {
    check( //
        "Integrate[(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "a^2*c^3*x + (a*c^2*(2*b*c + 3*a*d)*x^3)/3 + (c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^5)/5 + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^7)/7 + (b*d^2*(3*b*c + 2*a*d)*x^9)/9 + (b^2*d^3*x^11)/11", //
        380);
  }

  // {380}
  public void test2267() {
    check( //
        "Integrate[(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "a^2*c^2*x + (2*a*c*(b*c + a*d)*x^3)/3 + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^5)/5 + (2*b*d*(b*c + a*d)*x^7)/7 + (b^2*d^2*x^9)/9", //
        380);
  }

  // {380}
  public void test2268() {
    check( //
        "Integrate[(a + b*x^2)^2*(c + d*x^2), x]", //
        "a^2*c*x + (a*(2*b*c + a*d)*x^3)/3 + (b*(b*c + 2*a*d)*x^5)/5 + (b^2*d*x^7)/7", //
        380);
  }

  // {380}
  public void test2269() {
    check( //
        "Integrate[(a + b*x^2)^3*(c + d*x^2)^3, x]", //
        "a^3*c^3*x + a^2*c^2*(b*c + a*d)*x^3 + (3*a*c*(b^2*c^2 + 3*a*b*c*d + a^2*d^2)*x^5)/5 + ((b*c + a*d)*(b^2*c^2 + 8*a*b*c*d + a^2*d^2)*x^7)/7 + (b*d*(b^2*c^2 + 3*a*b*c*d + a^2*d^2)*x^9)/3 + (3*b^2*d^2*(b*c + a*d)*x^11)/11 + (b^3*d^3*x^13)/13", //
        380);
  }

  // {380}
  public void test2270() {
    check( //
        "Integrate[(a + b*x^2)^3*(c + d*x^2)^2, x]", //
        "a^3*c^2*x + (a^2*c*(3*b*c + 2*a*d)*x^3)/3 + (a*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^5)/5 + (b*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^7)/7 + (b^2*d*(2*b*c + 3*a*d)*x^9)/9 + (b^3*d^2*x^11)/11", //
        380);
  }

  // {380}
  public void test2271() {
    check( //
        "Integrate[(a + b*x^2)^3*(c + d*x^2), x]", //
        "a^3*c*x + (a^2*(3*b*c + a*d)*x^3)/3 + (3*a*b*(b*c + a*d)*x^5)/5 + (b^2*(b*c + 3*a*d)*x^7)/7 + (b^3*d*x^9)/9", //
        380);
  }

  // {396, 211}
  public void test2272() {
    check( //
        "Integrate[(c + d*x^2)/(a + b*x^2), x]", //
        "(d*x)/b + ((b*c - a*d)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(Sqrt[a]*b^(3/2))", //
        396,
        211);
  }

  // {393, 211}
  public void test2273() {
    check( //
        "Integrate[(c + d*x^2)/(a + b*x^2)^2, x]", //
        "((b*c - a*d)*x)/(2*a*b*(a + b*x^2)) + ((b*c + a*d)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(2*a^(3/2)*b^(3/2))", //
        393,
        211);
  }

  // {223, 212}
  public void test2274() {
    check( //
        "Integrate[1/Sqrt[a + b*x^2], x]", //
        "ArcTanh[(Sqrt[b]*x)/Sqrt[a + b*x^2]]/Sqrt[b]", //
        223,
        212);
  }

  // {385, 214}
  public void test2275() {
    check( //
        "Integrate[1/(Sqrt[a + b*x^2]*(c + d*x^2)), x]", //
        "ArcTanh[(Sqrt[b*c - a*d]*x)/(Sqrt[c]*Sqrt[a + b*x^2])]/(Sqrt[c]*Sqrt[b*c - a*d])", //
        385,
        214);
  }

  // {386, 197}
  public void test2276() {
    check( //
        "Integrate[(c + d*x^2)/(a + b*x^2)^(5/2), x]", //
        "(2*c*x)/(3*a^2*Sqrt[a + b*x^2]) + (x*(c + d*x^2))/(3*a*(a + b*x^2)^(3/2))", //
        386,
        197);
  }

  // {198, 197}
  public void test2277() {
    check( //
        "Integrate[(a + b*x^2)^(-5/2), x]", //
        "x/(3*a*(a + b*x^2)^(3/2)) + (2*x)/(3*a^2*Sqrt[a + b*x^2])", //
        198,
        197);
  }

  // {198, 197}
  public void test2278() {
    check( //
        "Integrate[(c + d*x^2)^(-5/2), x]", //
        "x/(3*c*(c + d*x^2)^(3/2)) + (2*x)/(3*c^2*Sqrt[c + d*x^2])", //
        198,
        197);
  }

  // {21, 197}
  public void test2279() {
    check( //
        "Integrate[1/(((b*c)/d + b*x^2)*Sqrt[c + d*x^2]), x]", //
        "(d*x)/(b*c*Sqrt[c + d*x^2])", //
        21,
        197);
  }

  // {385, 209}
  public void test2280() {
    check( //
        "Integrate[1/(Sqrt[1 - x^2]*(1 + x^2)), x]", //
        "ArcTan[(Sqrt[2]*x)/Sqrt[1 - x^2]]/Sqrt[2]", //
        385,
        209);
  }

  // {385, 211}
  public void test2281() {
    check( //
        "Integrate[1/((a + b*x^2)*Sqrt[c + d*x^2]), x]", //
        "ArcTan[(Sqrt[b*c - a*d]*x)/(Sqrt[a]*Sqrt[c + d*x^2])]/(Sqrt[a]*Sqrt[b*c - a*d])", //
        385,
        211);
  }

  // {393, 221}
  public void test2282() {
    check( //
        "Integrate[(-1 + x^2)/(1 + x^2)^(3/2), x]", //
        "(-2*x)/Sqrt[1 + x^2] + ArcSinh[x]", //
        393,
        221);
  }

  // {424, 391}
  public void test2283() {
    check( //
        "Integrate[(3*a + b*x^2)^2/(a - b*x^2)^(7/3), x]", //
        "(9*x)/(2*(a - b*x^2)^(1/3)) + (3*x*(3*a + b*x^2))/(2*(a - b*x^2)^(4/3))", //
        424,
        391);
  }

  // {22}
  public void test2284() {
    check( //
        "Integrate[Sqrt[2 + 4*x^2]*Sqrt[3 + 6*x^2], x]", //
        "Sqrt[6]*x + 2*Sqrt[2/3]*x^3", //
        22);
  }

  // {438, 435}
  public void test2285() {
    check( //
        "Integrate[Sqrt[1 - x^2]/Sqrt[-1 + 2*x^2], x]", //
        "(Sqrt[1 - 2*x^2]*EllipticE[ArcSin[Sqrt[2]*x], 1/2])/(Sqrt[2]*Sqrt[-1 + 2*x^2])", //
        438,
        435);
  }

  // {254, 227}
  public void test2286() {
    check( //
        "Integrate[1/(Sqrt[1 - x^2]*Sqrt[2 + 2*x^2]), x]", //
        "EllipticF[ArcSin[x], -1]/Sqrt[2]", //
        254,
        227);
  }

  // {22, 212}
  public void test2287() {
    check( //
        "Integrate[1/(Sqrt[2 - 2*x^2]*Sqrt[1 - x^2]), x]", //
        "ArcTanh[x]/Sqrt[2]", //
        22,
        212);
  }

  // {22, 209}
  public void test2288() {
    check( //
        "Integrate[1/(Sqrt[1 + x^2]*Sqrt[2 + 2*x^2]), x]", //
        "ArcTan[x]/Sqrt[2]", //
        22,
        209);
  }

  // {254, 227}
  public void test2289() {
    check( //
        "Integrate[1/(Sqrt[2 - 2*x^2]*Sqrt[1 + x^2]), x]", //
        "EllipticF[ArcSin[x], -1]/Sqrt[2]", //
        254,
        227);
  }

  // {432, 430}
  public void test2290() {
    check( //
        "Integrate[1/(Sqrt[-1 + x^2]*Sqrt[2 + 5*x^2]), x]", //
        "(Sqrt[1 - x^2]*EllipticF[ArcSin[x], -5/2])/(Sqrt[2]*Sqrt[-1 + x^2])", //
        432,
        430);
  }

  // {432, 430}
  public void test2291() {
    check( //
        "Integrate[1/(Sqrt[-1 + x^2]*Sqrt[2 + 4*x^2]), x]", //
        "(Sqrt[1 - x^2]*EllipticF[ArcSin[x], -2])/(Sqrt[2]*Sqrt[-1 + x^2])", //
        432,
        430);
  }

  // {432, 430}
  public void test2292() {
    check( //
        "Integrate[1/(Sqrt[-1 + x^2]*Sqrt[2 + 3*x^2]), x]", //
        "(Sqrt[1 - x^2]*EllipticF[ArcSin[x], -3/2])/(Sqrt[2]*Sqrt[-1 + x^2])", //
        432,
        430);
  }

  // {259, 228}
  public void test2293() {
    check( //
        "Integrate[1/(Sqrt[-1 + x^2]*Sqrt[2 + 2*x^2]), x]", //
        "EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2]/2", //
        259,
        228);
  }

  // {432, 430}
  public void test2294() {
    check( //
        "Integrate[1/(Sqrt[-1 + x^2]*Sqrt[2 + x^2]), x]", //
        "(Sqrt[1 - x^2]*EllipticF[ArcSin[x], -1/2])/(Sqrt[2]*Sqrt[-1 + x^2])", //
        432,
        430);
  }

  // {23, 213}
  public void test2295() {
    check( //
        "Integrate[1/(Sqrt[2 - 2*x^2]*Sqrt[-1 + x^2]), x]", //
        "-((Sqrt[-1 + x^2]*ArcTanh[x])/(Sqrt[2]*Sqrt[1 - x^2]))", //
        23,
        213);
  }

  // {432, 430}
  public void test2296() {
    check( //
        "Integrate[1/(Sqrt[2 - 3*x^2]*Sqrt[-1 + x^2]), x]", //
        "(Sqrt[1 - x^2]*EllipticF[ArcSin[x], 3/2])/(Sqrt[2]*Sqrt[-1 + x^2])", //
        432,
        430);
  }

  // {432, 430}
  public void test2297() {
    check( //
        "Integrate[1/(Sqrt[2 - 4*x^2]*Sqrt[-1 + x^2]), x]", //
        "(Sqrt[1 - x^2]*EllipticF[ArcSin[x], 2])/(Sqrt[2]*Sqrt[-1 + x^2])", //
        432,
        430);
  }

  // {432, 430}
  public void test2298() {
    check( //
        "Integrate[1/(Sqrt[2 - 5*x^2]*Sqrt[-1 + x^2]), x]", //
        "(Sqrt[1 - x^2]*EllipticF[ArcSin[x], 5/2])/(Sqrt[2]*Sqrt[-1 + x^2])", //
        432,
        430);
  }

  // {23, 209}
  public void test2299() {
    check( //
        "Integrate[1/(Sqrt[-1 - x^2]*Sqrt[2 + 2*x^2]), x]", //
        "(Sqrt[1 + x^2]*ArcTan[x])/(Sqrt[2]*Sqrt[-1 - x^2])", //
        23,
        209);
  }

  // {432, 430}
  public void test2300() {
    check( //
        "Integrate[1/(Sqrt[-1 - x^2]*Sqrt[2 - x^2]), x]", //
        "(Sqrt[1 + x^2]*EllipticF[ArcSin[x/Sqrt[2]], -2])/Sqrt[-1 - x^2]", //
        432,
        430);
  }

  // {432, 430}
  public void test2301() {
    check( //
        "Integrate[1/(Sqrt[2 - 3*x^2]*Sqrt[-1 - x^2]), x]", //
        "(Sqrt[1 + x^2]*EllipticF[ArcSin[Sqrt[3/2]*x], -2/3])/(Sqrt[3]*Sqrt[-1 - x^2])", //
        432,
        430);
  }

  // {432, 430}
  public void test2302() {
    check( //
        "Integrate[1/(Sqrt[2 - 4*x^2]*Sqrt[-1 - x^2]), x]", //
        "(Sqrt[1 + x^2]*EllipticF[ArcSin[Sqrt[2]*x], -1/2])/(2*Sqrt[-1 - x^2])", //
        432,
        430);
  }

  // {432, 430}
  public void test2303() {
    check( //
        "Integrate[1/(Sqrt[2 - 5*x^2]*Sqrt[-1 - x^2]), x]", //
        "(Sqrt[1 + x^2]*EllipticF[ArcSin[Sqrt[5/2]*x], -2/5])/(Sqrt[5]*Sqrt[-1 - x^2])", //
        432,
        430);
  }

  // {432, 430}
  public void test2304() {
    check( //
        "Integrate[1/(Sqrt[4 - x^2]*Sqrt[c + d*x^2]), x]", //
        "(Sqrt[1 + (d*x^2)/c]*EllipticF[ArcSin[x/2], (-4*d)/c])/Sqrt[c + d*x^2]", //
        432,
        430);
  }

  // {432, 430}
  public void test2305() {
    check( //
        "Integrate[1/(Sqrt[-1 + x^2]*Sqrt[7 - 4*Sqrt[3] + x^2]), x]", //
        "(Sqrt[1 - x^2]*EllipticF[ArcSin[x], -7 - 4*Sqrt[3]])/(Sqrt[7 - 4*Sqrt[3]]*Sqrt[-1 + x^2])", //
        432,
        430);
  }

  // {252, 251}
  public void test2306() {
    check( //
        "Integrate[(a + b*x^2)^p, x]", //
        "(x*(a + b*x^2)^p*Hypergeometric2F1[1/2, -p, 3/2, -((b*x^2)/a)])/(1 + (b*x^2)/a)^p", //
        252,
        251);
  }

  // {441, 440}
  public void test2307() {
    check( //
        "Integrate[(a + b*x^2)^p/(c + d*x^2), x]", //
        "(x*(a + b*x^2)^p*AppellF1[1/2, -p, 1, 3/2, -((b*x^2)/a), -((d*x^2)/c)])/(c*(1 + (b*x^2)/a)^p)", //
        441,
        440);
  }

  // {441, 440}
  public void test2308() {
    check( //
        "Integrate[(a + b*x^2)^p/(c + d*x^2)^2, x]", //
        "(x*(a + b*x^2)^p*AppellF1[1/2, -p, 2, 3/2, -((b*x^2)/a), -((d*x^2)/c)])/(c^2*(1 + (b*x^2)/a)^p)", //
        441,
        440);
  }

  // {441, 440}
  public void test2309() {
    check( //
        "Integrate[(a + b*x^2)^p/(c + d*x^2)^3, x]", //
        "(x*(a + b*x^2)^p*AppellF1[1/2, -p, 3, 3/2, -((b*x^2)/a), -((d*x^2)/c)])/(c^3*(1 + (b*x^2)/a)^p)", //
        441,
        440);
  }

  // {459}
  public void test2310() {
    check( //
        "Integrate[x^2*(a + b*x^2)*(A + B*x^2), x]", //
        "(a*A*x^3)/3 + ((A*b + a*B)*x^5)/5 + (b*B*x^7)/7", //
        459);
  }

  // {380}
  public void test2311() {
    check( //
        "Integrate[(a + b*x^2)*(A + B*x^2), x]", //
        "a*A*x + ((A*b + a*B)*x^3)/3 + (b*B*x^5)/5", //
        380);
  }

  // {459}
  public void test2312() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x^2))/x^2, x]", //
        "-((a*A)/x) + (A*b + a*B)*x + (b*B*x^3)/3", //
        459);
  }

  // {459}
  public void test2313() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x^2))/x^4, x]", //
        "-(a*A)/(3*x^3) - (A*b + a*B)/x + b*B*x", //
        459);
  }

  // {459}
  public void test2314() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x^2))/x^6, x]", //
        "-(a*A)/(5*x^5) - (A*b + a*B)/(3*x^3) - (b*B)/x", //
        459);
  }

  // {459}
  public void test2315() {
    check( //
        "Integrate[x^2*(a + b*x^2)^2*(A + B*x^2), x]", //
        "(a^2*A*x^3)/3 + (a*(2*A*b + a*B)*x^5)/5 + (b*(A*b + 2*a*B)*x^7)/7 + (b^2*B*x^9)/9", //
        459);
  }

  // {380}
  public void test2316() {
    check( //
        "Integrate[(a + b*x^2)^2*(A + B*x^2), x]", //
        "a^2*A*x + (a*(2*A*b + a*B)*x^3)/3 + (b*(A*b + 2*a*B)*x^5)/5 + (b^2*B*x^7)/7", //
        380);
  }

  // {459}
  public void test2317() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x^2))/x^2, x]", //
        "-((a^2*A)/x) + a*(2*A*b + a*B)*x + (b*(A*b + 2*a*B)*x^3)/3 + (b^2*B*x^5)/5", //
        459);
  }

  // {459}
  public void test2318() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x^2))/x^4, x]", //
        "-(a^2*A)/(3*x^3) - (a*(2*A*b + a*B))/x + b*(A*b + 2*a*B)*x + (b^2*B*x^3)/3", //
        459);
  }

  // {459}
  public void test2319() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x^2))/x^6, x]", //
        "-(a^2*A)/(5*x^5) - (a*(2*A*b + a*B))/(3*x^3) - (b*(A*b + 2*a*B))/x + b^2*B*x", //
        459);
  }

  // {459}
  public void test2320() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x^2))/x^8, x]", //
        "-(a^2*A)/(7*x^7) - (a*(2*A*b + a*B))/(5*x^5) - (b*(A*b + 2*a*B))/(3*x^3) - (b^2*B)/x", //
        459);
  }

  // {459}
  public void test2321() {
    check( //
        "Integrate[x^8*(a + b*x^2)^5*(A + B*x^2), x]", //
        "(a^5*A*x^9)/9 + (a^4*(5*A*b + a*B)*x^11)/11 + (5*a^3*b*(2*A*b + a*B)*x^13)/13 + (2*a^2*b^2*(A*b + a*B)*x^15)/3 + (5*a*b^3*(A*b + 2*a*B)*x^17)/17 + (b^4*(A*b + 5*a*B)*x^19)/19 + (b^5*B*x^21)/21", //
        459);
  }

  // {459}
  public void test2322() {
    check( //
        "Integrate[x^6*(a + b*x^2)^5*(A + B*x^2), x]", //
        "(a^5*A*x^7)/7 + (a^4*(5*A*b + a*B)*x^9)/9 + (5*a^3*b*(2*A*b + a*B)*x^11)/11 + (10*a^2*b^2*(A*b + a*B)*x^13)/13 + (a*b^3*(A*b + 2*a*B)*x^15)/3 + (b^4*(A*b + 5*a*B)*x^17)/17 + (b^5*B*x^19)/19", //
        459);
  }

  // {459}
  public void test2323() {
    check( //
        "Integrate[x^4*(a + b*x^2)^5*(A + B*x^2), x]", //
        "(a^5*A*x^5)/5 + (a^4*(5*A*b + a*B)*x^7)/7 + (5*a^3*b*(2*A*b + a*B)*x^9)/9 + (10*a^2*b^2*(A*b + a*B)*x^11)/11 + (5*a*b^3*(A*b + 2*a*B)*x^13)/13 + (b^4*(A*b + 5*a*B)*x^15)/15 + (b^5*B*x^17)/17", //
        459);
  }

  // {459}
  public void test2324() {
    check( //
        "Integrate[x^2*(a + b*x^2)^5*(A + B*x^2), x]", //
        "(a^5*A*x^3)/3 + (a^4*(5*A*b + a*B)*x^5)/5 + (5*a^3*b*(2*A*b + a*B)*x^7)/7 + (10*a^2*b^2*(A*b + a*B)*x^9)/9 + (5*a*b^3*(A*b + 2*a*B)*x^11)/11 + (b^4*(A*b + 5*a*B)*x^13)/13 + (b^5*B*x^15)/15", //
        459);
  }

  // {380}
  public void test2325() {
    check( //
        "Integrate[(a + b*x^2)^5*(A + B*x^2), x]", //
        "a^5*A*x + (a^4*(5*A*b + a*B)*x^3)/3 + a^3*b*(2*A*b + a*B)*x^5 + (10*a^2*b^2*(A*b + a*B)*x^7)/7 + (5*a*b^3*(A*b + 2*a*B)*x^9)/9 + (b^4*(A*b + 5*a*B)*x^11)/11 + (b^5*B*x^13)/13", //
        380);
  }

  // {459}
  public void test2326() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^2, x]", //
        "-((a^5*A)/x) + a^4*(5*A*b + a*B)*x + (5*a^3*b*(2*A*b + a*B)*x^3)/3 + 2*a^2*b^2*(A*b + a*B)*x^5 + (5*a*b^3*(A*b + 2*a*B)*x^7)/7 + (b^4*(A*b + 5*a*B)*x^9)/9 + (b^5*B*x^11)/11", //
        459);
  }

  // {459}
  public void test2327() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^4, x]", //
        "-(a^5*A)/(3*x^3) - (a^4*(5*A*b + a*B))/x + 5*a^3*b*(2*A*b + a*B)*x + (10*a^2*b^2*(A*b + a*B)*x^3)/3 + a*b^3*(A*b + 2*a*B)*x^5 + (b^4*(A*b + 5*a*B)*x^7)/7 + (b^5*B*x^9)/9", //
        459);
  }

  // {459}
  public void test2328() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^6, x]", //
        "-(a^5*A)/(5*x^5) - (a^4*(5*A*b + a*B))/(3*x^3) - (5*a^3*b*(2*A*b + a*B))/x + 10*a^2*b^2*(A*b + a*B)*x + (5*a*b^3*(A*b + 2*a*B)*x^3)/3 + (b^4*(A*b + 5*a*B)*x^5)/5 + (b^5*B*x^7)/7", //
        459);
  }

  // {459}
  public void test2329() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^8, x]", //
        "-(a^5*A)/(7*x^7) - (a^4*(5*A*b + a*B))/(5*x^5) - (5*a^3*b*(2*A*b + a*B))/(3*x^3) - (10*a^2*b^2*(A*b + a*B))/x + 5*a*b^3*(A*b + 2*a*B)*x + (b^4*(A*b + 5*a*B)*x^3)/3 + (b^5*B*x^5)/5", //
        459);
  }

  // {459}
  public void test2330() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^10, x]", //
        "-(a^5*A)/(9*x^9) - (a^4*(5*A*b + a*B))/(7*x^7) - (a^3*b*(2*A*b + a*B))/x^5 - (10*a^2*b^2*(A*b + a*B))/(3*x^3) - (5*a*b^3*(A*b + 2*a*B))/x + b^4*(A*b + 5*a*B)*x + (b^5*B*x^3)/3", //
        459);
  }

  // {459}
  public void test2331() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^12, x]", //
        "-(a^5*A)/(11*x^11) - (a^4*(5*A*b + a*B))/(9*x^9) - (5*a^3*b*(2*A*b + a*B))/(7*x^7) - (2*a^2*b^2*(A*b + a*B))/x^5 - (5*a*b^3*(A*b + 2*a*B))/(3*x^3) - (b^4*(A*b + 5*a*B))/x + b^5*B*x", //
        459);
  }

  // {459}
  public void test2332() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^14, x]", //
        "-(a^5*A)/(13*x^13) - (a^4*(5*A*b + a*B))/(11*x^11) - (5*a^3*b*(2*A*b + a*B))/(9*x^9) - (10*a^2*b^2*(A*b + a*B))/(7*x^7) - (a*b^3*(A*b + 2*a*B))/x^5 - (b^4*(A*b + 5*a*B))/(3*x^3) - (b^5*B)/x", //
        459);
  }

  // {459}
  public void test2333() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^16, x]", //
        "-(a^5*A)/(15*x^15) - (a^4*(5*A*b + a*B))/(13*x^13) - (5*a^3*b*(2*A*b + a*B))/(11*x^11) - (10*a^2*b^2*(A*b + a*B))/(9*x^9) - (5*a*b^3*(A*b + 2*a*B))/(7*x^7) - (b^4*(A*b + 5*a*B))/(5*x^5) - (b^5*B)/(3*x^3)", //
        459);
  }

  // {459}
  public void test2334() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^18, x]", //
        "-(a^5*A)/(17*x^17) - (a^4*(5*A*b + a*B))/(15*x^15) - (5*a^3*b*(2*A*b + a*B))/(13*x^13) - (10*a^2*b^2*(A*b + a*B))/(11*x^11) - (5*a*b^3*(A*b + 2*a*B))/(9*x^9) - (b^4*(A*b + 5*a*B))/(7*x^7) - (b^5*B)/(5*x^5)", //
        459);
  }

  // {459}
  public void test2335() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^20, x]", //
        "-(a^5*A)/(19*x^19) - (a^4*(5*A*b + a*B))/(17*x^17) - (a^3*b*(2*A*b + a*B))/(3*x^15) - (10*a^2*b^2*(A*b + a*B))/(13*x^13) - (5*a*b^3*(A*b + 2*a*B))/(11*x^11) - (b^4*(A*b + 5*a*B))/(9*x^9) - (b^5*B)/(7*x^7)", //
        459);
  }

  // {459}
  public void test2336() {
    check( //
        "Integrate[((a + b*x^2)^5*(A + B*x^2))/x^22, x]", //
        "-(a^5*A)/(21*x^21) - (a^4*(5*A*b + a*B))/(19*x^19) - (5*a^3*b*(2*A*b + a*B))/(17*x^17) - (2*a^2*b^2*(A*b + a*B))/(3*x^15) - (5*a*b^3*(A*b + 2*a*B))/(13*x^13) - (b^4*(A*b + 5*a*B))/(11*x^11) - (b^5*B)/(9*x^9)", //
        459);
  }

  // {396, 211}
  public void test2337() {
    check( //
        "Integrate[(A + B*x^2)/(a + b*x^2), x]", //
        "(B*x)/b + ((A*b - a*B)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(Sqrt[a]*b^(3/2))", //
        396,
        211);
  }

  // {464, 211}
  public void test2338() {
    check( //
        "Integrate[(A + B*x^2)/(x^2*(a + b*x^2)), x]", //
        "-(A/(a*x)) - ((A*b - a*B)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(a^(3/2)*Sqrt[b])", //
        464,
        211);
  }

  // {393, 211}
  public void test2339() {
    check( //
        "Integrate[(A + B*x^2)/(a + b*x^2)^2, x]", //
        "((A*b - a*B)*x)/(2*a*b*(a + b*x^2)) + ((A*b + a*B)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(2*a^(3/2)*b^(3/2))", //
        393,
        211);
  }

  // {455, 37}
  public void test2340() {
    check( //
        "Integrate[(x*(A + B*x^2))/(a + b*x^2)^3, x]", //
        "-(A + B*x^2)^2/(4*(A*b - a*B)*(a + b*x^2)^2)", //
        455,
        37);
  }

  // {396, 209}
  public void test2341() {
    check( //
        "Integrate[(a + b*x^2)/(1 + x^2), x]", //
        "b*x + (a - b)*ArcTan[x]", //
        396,
        209);
  }

  // {396, 212}
  public void test2342() {
    check( //
        "Integrate[(a + b*x^2)/(1 - x^2), x]", //
        "-(b*x) + (a + b)*ArcTanh[x]", //
        396,
        212);
  }

  // {393, 209}
  public void test2343() {
    check( //
        "Integrate[(3 + 2*x^2)/(1 + x^2)^2, x]", //
        "x/(2*(1 + x^2)) + (5*ArcTan[x])/2", //
        393,
        209);
  }

  // {393, 209}
  public void test2344() {
    check( //
        "Integrate[(-2 + x^2)/(1 + x^2)^2, x]", //
        "(-3*x)/(2*(1 + x^2)) - ArcTan[x]/2", //
        393,
        209);
  }

  // {393, 209}
  public void test2345() {
    check( //
        "Integrate[(3 + x^2)/(1 + x^2)^2, x]", //
        "x/(1 + x^2) + 2*ArcTan[x]", //
        393,
        209);
  }

  // {396, 214}
  public void test2346() {
    check( //
        "Integrate[(A + B*x^2)/(a - b*x^2), x]", //
        "-((B*x)/b) + ((A*b + a*B)*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(Sqrt[a]*b^(3/2))", //
        396,
        214);
  }

  // {457, 75}
  public void test2347() {
    check( //
        "Integrate[(1 + 2*x^2)/(x^5*(1 + x^2)^3), x]", //
        "-1/(4*x^4*(1 + x^2)^2)", //
        457,
        75);
  }

  // {21, 8}
  public void test2348() {
    check( //
        "Integrate[(1 - x^2)^2/(-1 + x^2)^2, x]", //
        "x", //
        21,
        8);
  }

  // {21, 30}
  public void test2349() {
    check( //
        "Integrate[(x^3*(a*c + b*c*x^2))/(a + b*x^2), x]", //
        "(c*x^4)/4", //
        21,
        30);
  }

  // {21, 30}
  public void test2350() {
    check( //
        "Integrate[(x^2*(a*c + b*c*x^2))/(a + b*x^2), x]", //
        "(c*x^3)/3", //
        21,
        30);
  }

  // {21, 30}
  public void test2351() {
    check( //
        "Integrate[(x*(a*c + b*c*x^2))/(a + b*x^2), x]", //
        "(c*x^2)/2", //
        21,
        30);
  }

  // {21, 8}
  public void test2352() {
    check( //
        "Integrate[(a*c + b*c*x^2)/(a + b*x^2), x]", //
        "c*x", //
        21,
        8);
  }

  // {21, 29}
  public void test2353() {
    check( //
        "Integrate[(a*c + b*c*x^2)/(x*(a + b*x^2)), x]", //
        "c*Log[x]", //
        21,
        29);
  }

  // {21, 30}
  public void test2354() {
    check( //
        "Integrate[(a*c + b*c*x^2)/(x^2*(a + b*x^2)), x]", //
        "-(c/x)", //
        21,
        30);
  }

  // {21, 30}
  public void test2355() {
    check( //
        "Integrate[(a*c + b*c*x^2)/(x^3*(a + b*x^2)), x]", //
        "-c/(2*x^2)", //
        21,
        30);
  }

  // {21, 266}
  public void test2356() {
    check( //
        "Integrate[(x*(a*c + b*c*x^2))/(a + b*x^2)^2, x]", //
        "(c*Log[a + b*x^2])/(2*b)", //
        21,
        266);
  }

  // {21, 211}
  public void test2357() {
    check( //
        "Integrate[(a*c + b*c*x^2)/(a + b*x^2)^2, x]", //
        "(c*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(Sqrt[a]*Sqrt[b])", //
        21,
        211);
  }

  // {21, 267}
  public void test2358() {
    check( //
        "Integrate[(x*(a*c + b*c*x^2))/(a + b*x^2)^3, x]", //
        "-c/(2*b*(a + b*x^2))", //
        21,
        267);
  }

  // {459}
  public void test2359() {
    check( //
        "Integrate[x^4*(a + b*x^2)^2*(c + d*x^2), x]", //
        "(a^2*c*x^5)/5 + (a*(2*b*c + a*d)*x^7)/7 + (b*(b*c + 2*a*d)*x^9)/9 + (b^2*d*x^11)/11", //
        459);
  }

  // {459}
  public void test2360() {
    check( //
        "Integrate[x^2*(a + b*x^2)^2*(c + d*x^2), x]", //
        "(a^2*c*x^3)/3 + (a*(2*b*c + a*d)*x^5)/5 + (b*(b*c + 2*a*d)*x^7)/7 + (b^2*d*x^9)/9", //
        459);
  }

  // {380}
  public void test2361() {
    check( //
        "Integrate[(a + b*x^2)^2*(c + d*x^2), x]", //
        "a^2*c*x + (a*(2*b*c + a*d)*x^3)/3 + (b*(b*c + 2*a*d)*x^5)/5 + (b^2*d*x^7)/7", //
        380);
  }

  // {459}
  public void test2362() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2))/x^2, x]", //
        "-((a^2*c)/x) + a*(2*b*c + a*d)*x + (b*(b*c + 2*a*d)*x^3)/3 + (b^2*d*x^5)/5", //
        459);
  }

  // {459}
  public void test2363() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2))/x^4, x]", //
        "-(a^2*c)/(3*x^3) - (a*(2*b*c + a*d))/x + b*(b*c + 2*a*d)*x + (b^2*d*x^3)/3", //
        459);
  }

  // {459}
  public void test2364() {
    check( //
        "Integrate[x^4*(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "(a^2*c^2*x^5)/5 + (2*a*c*(b*c + a*d)*x^7)/7 + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^9)/9 + (2*b*d*(b*c + a*d)*x^11)/11 + (b^2*d^2*x^13)/13", //
        459);
  }

  // {459}
  public void test2365() {
    check( //
        "Integrate[x^2*(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "(a^2*c^2*x^3)/3 + (2*a*c*(b*c + a*d)*x^5)/5 + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^7)/7 + (2*b*d*(b*c + a*d)*x^9)/9 + (b^2*d^2*x^11)/11", //
        459);
  }

  // {380}
  public void test2366() {
    check( //
        "Integrate[(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "a^2*c^2*x + (2*a*c*(b*c + a*d)*x^3)/3 + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^5)/5 + (2*b*d*(b*c + a*d)*x^7)/7 + (b^2*d^2*x^9)/9", //
        380);
  }

  // {459}
  public void test2367() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^2)/x^2, x]", //
        "-((a^2*c^2)/x) + 2*a*c*(b*c + a*d)*x + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^3)/3 + (2*b*d*(b*c + a*d)*x^5)/5 + (b^2*d^2*x^7)/7", //
        459);
  }

  // {459}
  public void test2368() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^2)/x^4, x]", //
        "-(a^2*c^2)/(3*x^3) - (2*a*c*(b*c + a*d))/x + (b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x + (2*b*d*(b*c + a*d)*x^3)/3 + (b^2*d^2*x^5)/5", //
        459);
  }

  // {459}
  public void test2369() {
    check( //
        "Integrate[x^4*(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "(a^2*c^3*x^5)/5 + (a*c^2*(2*b*c + 3*a*d)*x^7)/7 + (c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^9)/9 + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^11)/11 + (b*d^2*(3*b*c + 2*a*d)*x^13)/13 + (b^2*d^3*x^15)/15", //
        459);
  }

  // {459}
  public void test2370() {
    check( //
        "Integrate[x^2*(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "(a^2*c^3*x^3)/3 + (a*c^2*(2*b*c + 3*a*d)*x^5)/5 + (c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^7)/7 + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^9)/9 + (b*d^2*(3*b*c + 2*a*d)*x^11)/11 + (b^2*d^3*x^13)/13", //
        459);
  }

  // {380}
  public void test2371() {
    check( //
        "Integrate[(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "a^2*c^3*x + (a*c^2*(2*b*c + 3*a*d)*x^3)/3 + (c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^5)/5 + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^7)/7 + (b*d^2*(3*b*c + 2*a*d)*x^9)/9 + (b^2*d^3*x^11)/11", //
        380);
  }

  // {459}
  public void test2372() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^3)/x^2, x]", //
        "-((a^2*c^3)/x) + a*c^2*(2*b*c + 3*a*d)*x + (c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^3)/3 + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^5)/5 + (b*d^2*(3*b*c + 2*a*d)*x^7)/7 + (b^2*d^3*x^9)/9", //
        459);
  }

  // {459}
  public void test2373() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^3)/x^4, x]", //
        "-(a^2*c^3)/(3*x^3) - (a*c^2*(2*b*c + 3*a*d))/x + c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^3)/3 + (b*d^2*(3*b*c + 2*a*d)*x^5)/5 + (b^2*d^3*x^7)/7", //
        459);
  }

  // {396, 211}
  public void test2374() {
    check( //
        "Integrate[(c + d*x^2)/(a + b*x^2), x]", //
        "(d*x)/b + ((b*c - a*d)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(Sqrt[a]*b^(3/2))", //
        396,
        211);
  }

  // {464, 211}
  public void test2375() {
    check( //
        "Integrate[(c + d*x^2)/(x^2*(a + b*x^2)), x]", //
        "-(c/(a*x)) - ((b*c - a*d)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(a^(3/2)*Sqrt[b])", //
        464,
        211);
  }

  // {393, 211}
  public void test2376() {
    check( //
        "Integrate[(c + d*x^2)/(a + b*x^2)^2, x]", //
        "((b*c - a*d)*x)/(2*a*b*(a + b*x^2)) + ((b*c + a*d)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(2*a^(3/2)*b^(3/2))", //
        393,
        211);
  }

  // {459}
  public void test2377() {
    check( //
        "Integrate[x^m*(a + b*x^2)^3*(A + B*x^2), x]", //
        "(a^3*A*x^(1 + m))/(1 + m) + (a^2*(3*A*b + a*B)*x^(3 + m))/(3 + m) + (3*a*b*(A*b + a*B)*x^(5 + m))/(5 + m) + (b^2*(A*b + 3*a*B)*x^(7 + m))/(7 + m) + (b^3*B*x^(9 + m))/(9 + m)", //
        459);
  }

  // {459}
  public void test2378() {
    check( //
        "Integrate[x^m*(a + b*x^2)^2*(A + B*x^2), x]", //
        "(a^2*A*x^(1 + m))/(1 + m) + (a*(2*A*b + a*B)*x^(3 + m))/(3 + m) + (b*(A*b + 2*a*B)*x^(5 + m))/(5 + m) + (b^2*B*x^(7 + m))/(7 + m)", //
        459);
  }

  // {459}
  public void test2379() {
    check( //
        "Integrate[x^m*(a + b*x^2)*(A + B*x^2), x]", //
        "(a*A*x^(1 + m))/(1 + m) + ((A*b + a*B)*x^(3 + m))/(3 + m) + (b*B*x^(5 + m))/(5 + m)", //
        459);
  }

  // {470, 371}
  public void test2380() {
    check( //
        "Integrate[(x^m*(A + B*x^2))/(a + b*x^2), x]", //
        "(B*x^(1 + m))/(b*(1 + m)) + ((A*b - a*B)*x^(1 + m)*Hypergeometric2F1[1, (1 + m)/2, (3 + m)/2, -((b*x^2)/a)])/(a*b*(1 + m))", //
        470,
        371);
  }

  // {468, 371}
  public void test2381() {
    check( //
        "Integrate[(x^m*(A + B*x^2))/(a + b*x^2)^2, x]", //
        "((A*b - a*B)*x^(1 + m))/(2*a*b*(a + b*x^2)) + ((a*B*(1 + m) + A*(b - b*m))*x^(1 + m)*Hypergeometric2F1[1, (1 + m)/2, (3 + m)/2, -((b*x^2)/a)])/(2*a^2*b*(1 + m))", //
        468,
        371);
  }

  // {468, 371}
  public void test2382() {
    check( //
        "Integrate[(x^m*(A + B*x^2))/(a + b*x^2)^3, x]", //
        "((A*b - a*B)*x^(1 + m))/(4*a*b*(a + b*x^2)^2) + ((A*b*(3 - m) + a*B*(1 + m))*x^(1 + m)*Hypergeometric2F1[2, (1 + m)/2, (3 + m)/2, -((b*x^2)/a)])/(4*a^3*b*(1 + m))", //
        468,
        371);
  }

  // {459}
  public void test2383() {
    check( //
        "Integrate[x^m*(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "(a^2*c^3*x^(1 + m))/(1 + m) + (a*c^2*(2*b*c + 3*a*d)*x^(3 + m))/(3 + m) + (c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(5 + m))/(5 + m) + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(7 + m))/(7 + m) + (b*d^2*(3*b*c + 2*a*d)*x^(9 + m))/(9 + m) + (b^2*d^3*x^(11 + m))/(11 + m)", //
        459);
  }

  // {459}
  public void test2384() {
    check( //
        "Integrate[x^m*(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "(a^2*c^2*x^(1 + m))/(1 + m) + (2*a*c*(b*c + a*d)*x^(3 + m))/(3 + m) + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(5 + m))/(5 + m) + (2*b*d*(b*c + a*d)*x^(7 + m))/(7 + m) + (b^2*d^2*x^(9 + m))/(9 + m)", //
        459);
  }

  // {459}
  public void test2385() {
    check( //
        "Integrate[x^m*(a + b*x^2)^2*(c + d*x^2), x]", //
        "(a^2*c*x^(1 + m))/(1 + m) + (a*(2*b*c + a*d)*x^(3 + m))/(3 + m) + (b*(b*c + 2*a*d)*x^(5 + m))/(5 + m) + (b^2*d*x^(7 + m))/(7 + m)", //
        459);
  }

  // {470, 371}
  public void test2386() {
    check( //
        "Integrate[(x^m*(c + d*x^2))/(a + b*x^2), x]", //
        "(d*x^(1 + m))/(b*(1 + m)) + ((b*c - a*d)*x^(1 + m)*Hypergeometric2F1[1, (1 + m)/2, (3 + m)/2, -((b*x^2)/a)])/(a*b*(1 + m))", //
        470,
        371);
  }

  // {468, 371}
  public void test2387() {
    check( //
        "Integrate[(x^m*(c + d*x^2))/(a + b*x^2)^2, x]", //
        "((b*c - a*d)*x^(1 + m))/(2*a*b*(a + b*x^2)) + ((a*d*(1 + m) + b*(c - c*m))*x^(1 + m)*Hypergeometric2F1[1, (1 + m)/2, (3 + m)/2, -((b*x^2)/a)])/(2*a^2*b*(1 + m))", //
        468,
        371);
  }

  // {459}
  public void test2388() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2)*(A + B*x^2), x]", //
        "(2*a*A*x^(9/2))/9 + (2*(A*b + a*B)*x^(13/2))/13 + (2*b*B*x^(17/2))/17", //
        459);
  }

  // {459}
  public void test2389() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2)*(A + B*x^2), x]", //
        "(2*a*A*x^(7/2))/7 + (2*(A*b + a*B)*x^(11/2))/11 + (2*b*B*x^(15/2))/15", //
        459);
  }

  // {459}
  public void test2390() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2)*(A + B*x^2), x]", //
        "(2*a*A*x^(5/2))/5 + (2*(A*b + a*B)*x^(9/2))/9 + (2*b*B*x^(13/2))/13", //
        459);
  }

  // {459}
  public void test2391() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2)*(A + B*x^2), x]", //
        "(2*a*A*x^(3/2))/3 + (2*(A*b + a*B)*x^(7/2))/7 + (2*b*B*x^(11/2))/11", //
        459);
  }

  // {459}
  public void test2392() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x^2))/Sqrt[x], x]", //
        "2*a*A*Sqrt[x] + (2*(A*b + a*B)*x^(5/2))/5 + (2*b*B*x^(9/2))/9", //
        459);
  }

  // {459}
  public void test2393() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x^2))/x^(3/2), x]", //
        "(-2*a*A)/Sqrt[x] + (2*(A*b + a*B)*x^(3/2))/3 + (2*b*B*x^(7/2))/7", //
        459);
  }

  // {459}
  public void test2394() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x^2))/x^(5/2), x]", //
        "(-2*a*A)/(3*x^(3/2)) + 2*(A*b + a*B)*Sqrt[x] + (2*b*B*x^(5/2))/5", //
        459);
  }

  // {459}
  public void test2395() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x^2))/x^(7/2), x]", //
        "(-2*a*A)/(5*x^(5/2)) - (2*(A*b + a*B))/Sqrt[x] + (2*b*B*x^(3/2))/3", //
        459);
  }

  // {459}
  public void test2396() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2)^2*(A + B*x^2), x]", //
        "(2*a^2*A*x^(9/2))/9 + (2*a*(2*A*b + a*B)*x^(13/2))/13 + (2*b*(A*b + 2*a*B)*x^(17/2))/17 + (2*b^2*B*x^(21/2))/21", //
        459);
  }

  // {459}
  public void test2397() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2)^2*(A + B*x^2), x]", //
        "(2*a^2*A*x^(7/2))/7 + (2*a*(2*A*b + a*B)*x^(11/2))/11 + (2*b*(A*b + 2*a*B)*x^(15/2))/15 + (2*b^2*B*x^(19/2))/19", //
        459);
  }

  // {459}
  public void test2398() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2)^2*(A + B*x^2), x]", //
        "(2*a^2*A*x^(5/2))/5 + (2*a*(2*A*b + a*B)*x^(9/2))/9 + (2*b*(A*b + 2*a*B)*x^(13/2))/13 + (2*b^2*B*x^(17/2))/17", //
        459);
  }

  // {459}
  public void test2399() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2)^2*(A + B*x^2), x]", //
        "(2*a^2*A*x^(3/2))/3 + (2*a*(2*A*b + a*B)*x^(7/2))/7 + (2*b*(A*b + 2*a*B)*x^(11/2))/11 + (2*b^2*B*x^(15/2))/15", //
        459);
  }

  // {459}
  public void test2400() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x^2))/Sqrt[x], x]", //
        "2*a^2*A*Sqrt[x] + (2*a*(2*A*b + a*B)*x^(5/2))/5 + (2*b*(A*b + 2*a*B)*x^(9/2))/9 + (2*b^2*B*x^(13/2))/13", //
        459);
  }

  // {459}
  public void test2401() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x^2))/x^(3/2), x]", //
        "(-2*a^2*A)/Sqrt[x] + (2*a*(2*A*b + a*B)*x^(3/2))/3 + (2*b*(A*b + 2*a*B)*x^(7/2))/7 + (2*b^2*B*x^(11/2))/11", //
        459);
  }

  // {459}
  public void test2402() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x^2))/x^(5/2), x]", //
        "(-2*a^2*A)/(3*x^(3/2)) + 2*a*(2*A*b + a*B)*Sqrt[x] + (2*b*(A*b + 2*a*B)*x^(5/2))/5 + (2*b^2*B*x^(9/2))/9", //
        459);
  }

  // {459}
  public void test2403() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x^2))/x^(7/2), x]", //
        "(-2*a^2*A)/(5*x^(5/2)) - (2*a*(2*A*b + a*B))/Sqrt[x] + (2*b*(A*b + 2*a*B)*x^(3/2))/3 + (2*b^2*B*x^(7/2))/7", //
        459);
  }

  // {459}
  public void test2404() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2)^3*(A + B*x^2), x]", //
        "(2*a^3*A*x^(9/2))/9 + (2*a^2*(3*A*b + a*B)*x^(13/2))/13 + (6*a*b*(A*b + a*B)*x^(17/2))/17 + (2*b^2*(A*b + 3*a*B)*x^(21/2))/21 + (2*b^3*B*x^(25/2))/25", //
        459);
  }

  // {459}
  public void test2405() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2)^3*(A + B*x^2), x]", //
        "(2*a^3*A*x^(7/2))/7 + (2*a^2*(3*A*b + a*B)*x^(11/2))/11 + (2*a*b*(A*b + a*B)*x^(15/2))/5 + (2*b^2*(A*b + 3*a*B)*x^(19/2))/19 + (2*b^3*B*x^(23/2))/23", //
        459);
  }

  // {459}
  public void test2406() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2)^3*(A + B*x^2), x]", //
        "(2*a^3*A*x^(5/2))/5 + (2*a^2*(3*A*b + a*B)*x^(9/2))/9 + (6*a*b*(A*b + a*B)*x^(13/2))/13 + (2*b^2*(A*b + 3*a*B)*x^(17/2))/17 + (2*b^3*B*x^(21/2))/21", //
        459);
  }

  // {459}
  public void test2407() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2)^3*(A + B*x^2), x]", //
        "(2*a^3*A*x^(3/2))/3 + (2*a^2*(3*A*b + a*B)*x^(7/2))/7 + (6*a*b*(A*b + a*B)*x^(11/2))/11 + (2*b^2*(A*b + 3*a*B)*x^(15/2))/15 + (2*b^3*B*x^(19/2))/19", //
        459);
  }

  // {459}
  public void test2408() {
    check( //
        "Integrate[((a + b*x^2)^3*(A + B*x^2))/Sqrt[x], x]", //
        "2*a^3*A*Sqrt[x] + (2*a^2*(3*A*b + a*B)*x^(5/2))/5 + (2*a*b*(A*b + a*B)*x^(9/2))/3 + (2*b^2*(A*b + 3*a*B)*x^(13/2))/13 + (2*b^3*B*x^(17/2))/17", //
        459);
  }

  // {459}
  public void test2409() {
    check( //
        "Integrate[((a + b*x^2)^3*(A + B*x^2))/x^(3/2), x]", //
        "(-2*a^3*A)/Sqrt[x] + (2*a^2*(3*A*b + a*B)*x^(3/2))/3 + (6*a*b*(A*b + a*B)*x^(7/2))/7 + (2*b^2*(A*b + 3*a*B)*x^(11/2))/11 + (2*b^3*B*x^(15/2))/15", //
        459);
  }

  // {459}
  public void test2410() {
    check( //
        "Integrate[((a + b*x^2)^3*(A + B*x^2))/x^(5/2), x]", //
        "(-2*a^3*A)/(3*x^(3/2)) + 2*a^2*(3*A*b + a*B)*Sqrt[x] + (6*a*b*(A*b + a*B)*x^(5/2))/5 + (2*b^2*(A*b + 3*a*B)*x^(9/2))/9 + (2*b^3*B*x^(13/2))/13", //
        459);
  }

  // {459}
  public void test2411() {
    check( //
        "Integrate[((a + b*x^2)^3*(A + B*x^2))/x^(7/2), x]", //
        "(-2*a^3*A)/(5*x^(5/2)) - (2*a^2*(3*A*b + a*B))/Sqrt[x] + 2*a*b*(A*b + a*B)*x^(3/2) + (2*b^2*(A*b + 3*a*B)*x^(7/2))/7 + (2*b^3*B*x^(11/2))/11", //
        459);
  }

  // {459}
  public void test2412() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2)^2*(c + d*x^2), x]", //
        "(2*a^2*c*x^(9/2))/9 + (2*a*(2*b*c + a*d)*x^(13/2))/13 + (2*b*(b*c + 2*a*d)*x^(17/2))/17 + (2*b^2*d*x^(21/2))/21", //
        459);
  }

  // {459}
  public void test2413() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2)^2*(c + d*x^2), x]", //
        "(2*a^2*c*x^(7/2))/7 + (2*a*(2*b*c + a*d)*x^(11/2))/11 + (2*b*(b*c + 2*a*d)*x^(15/2))/15 + (2*b^2*d*x^(19/2))/19", //
        459);
  }

  // {459}
  public void test2414() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2)^2*(c + d*x^2), x]", //
        "(2*a^2*c*x^(5/2))/5 + (2*a*(2*b*c + a*d)*x^(9/2))/9 + (2*b*(b*c + 2*a*d)*x^(13/2))/13 + (2*b^2*d*x^(17/2))/17", //
        459);
  }

  // {459}
  public void test2415() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2)^2*(c + d*x^2), x]", //
        "(2*a^2*c*x^(3/2))/3 + (2*a*(2*b*c + a*d)*x^(7/2))/7 + (2*b*(b*c + 2*a*d)*x^(11/2))/11 + (2*b^2*d*x^(15/2))/15", //
        459);
  }

  // {459}
  public void test2416() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2))/Sqrt[x], x]", //
        "2*a^2*c*Sqrt[x] + (2*a*(2*b*c + a*d)*x^(5/2))/5 + (2*b*(b*c + 2*a*d)*x^(9/2))/9 + (2*b^2*d*x^(13/2))/13", //
        459);
  }

  // {459}
  public void test2417() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2))/x^(3/2), x]", //
        "(-2*a^2*c)/Sqrt[x] + (2*a*(2*b*c + a*d)*x^(3/2))/3 + (2*b*(b*c + 2*a*d)*x^(7/2))/7 + (2*b^2*d*x^(11/2))/11", //
        459);
  }

  // {459}
  public void test2418() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2))/x^(5/2), x]", //
        "(-2*a^2*c)/(3*x^(3/2)) + 2*a*(2*b*c + a*d)*Sqrt[x] + (2*b*(b*c + 2*a*d)*x^(5/2))/5 + (2*b^2*d*x^(9/2))/9", //
        459);
  }

  // {459}
  public void test2419() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2))/x^(7/2), x]", //
        "(-2*a^2*c)/(5*x^(5/2)) - (2*a*(2*b*c + a*d))/Sqrt[x] + (2*b*(b*c + 2*a*d)*x^(3/2))/3 + (2*b^2*d*x^(7/2))/7", //
        459);
  }

  // {459}
  public void test2420() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "(2*a^2*c^2*x^(9/2))/9 + (4*a*c*(b*c + a*d)*x^(13/2))/13 + (2*(b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(17/2))/17 + (4*b*d*(b*c + a*d)*x^(21/2))/21 + (2*b^2*d^2*x^(25/2))/25", //
        459);
  }

  // {459}
  public void test2421() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "(2*a^2*c^2*x^(7/2))/7 + (4*a*c*(b*c + a*d)*x^(11/2))/11 + (2*(b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(15/2))/15 + (4*b*d*(b*c + a*d)*x^(19/2))/19 + (2*b^2*d^2*x^(23/2))/23", //
        459);
  }

  // {459}
  public void test2422() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "(2*a^2*c^2*x^(5/2))/5 + (4*a*c*(b*c + a*d)*x^(9/2))/9 + (2*(b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(13/2))/13 + (4*b*d*(b*c + a*d)*x^(17/2))/17 + (2*b^2*d^2*x^(21/2))/21", //
        459);
  }

  // {459}
  public void test2423() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2)^2*(c + d*x^2)^2, x]", //
        "(2*a^2*c^2*x^(3/2))/3 + (4*a*c*(b*c + a*d)*x^(7/2))/7 + (2*(b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(11/2))/11 + (4*b*d*(b*c + a*d)*x^(15/2))/15 + (2*b^2*d^2*x^(19/2))/19", //
        459);
  }

  // {459}
  public void test2424() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^2)/Sqrt[x], x]", //
        "2*a^2*c^2*Sqrt[x] + (4*a*c*(b*c + a*d)*x^(5/2))/5 + (2*(b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(9/2))/9 + (4*b*d*(b*c + a*d)*x^(13/2))/13 + (2*b^2*d^2*x^(17/2))/17", //
        459);
  }

  // {459}
  public void test2425() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^2)/x^(3/2), x]", //
        "(-2*a^2*c^2)/Sqrt[x] + (4*a*c*(b*c + a*d)*x^(3/2))/3 + (2*(b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(7/2))/7 + (4*b*d*(b*c + a*d)*x^(11/2))/11 + (2*b^2*d^2*x^(15/2))/15", //
        459);
  }

  // {459}
  public void test2426() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^2)/x^(5/2), x]", //
        "(-2*a^2*c^2)/(3*x^(3/2)) + 4*a*c*(b*c + a*d)*Sqrt[x] + (2*(b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(5/2))/5 + (4*b*d*(b*c + a*d)*x^(9/2))/9 + (2*b^2*d^2*x^(13/2))/13", //
        459);
  }

  // {459}
  public void test2427() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^2)/x^(7/2), x]", //
        "(-2*a^2*c^2)/(5*x^(5/2)) - (4*a*c*(b*c + a*d))/Sqrt[x] + (2*(b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^(3/2))/3 + (4*b*d*(b*c + a*d)*x^(7/2))/7 + (2*b^2*d^2*x^(11/2))/11", //
        459);
  }

  // {459}
  public void test2428() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "(2*a^2*c^3*x^(9/2))/9 + (2*a*c^2*(2*b*c + 3*a*d)*x^(13/2))/13 + (2*c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(17/2))/17 + (2*d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(21/2))/21 + (2*b*d^2*(3*b*c + 2*a*d)*x^(25/2))/25 + (2*b^2*d^3*x^(29/2))/29", //
        459);
  }

  // {459}
  public void test2429() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "(2*a^2*c^3*x^(7/2))/7 + (2*a*c^2*(2*b*c + 3*a*d)*x^(11/2))/11 + (2*c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(15/2))/15 + (2*d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(19/2))/19 + (2*b*d^2*(3*b*c + 2*a*d)*x^(23/2))/23 + (2*b^2*d^3*x^(27/2))/27", //
        459);
  }

  // {459}
  public void test2430() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "(2*a^2*c^3*x^(5/2))/5 + (2*a*c^2*(2*b*c + 3*a*d)*x^(9/2))/9 + (2*c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(13/2))/13 + (2*d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(17/2))/17 + (2*b*d^2*(3*b*c + 2*a*d)*x^(21/2))/21 + (2*b^2*d^3*x^(25/2))/25", //
        459);
  }

  // {459}
  public void test2431() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^2)^2*(c + d*x^2)^3, x]", //
        "(2*a^2*c^3*x^(3/2))/3 + (2*a*c^2*(2*b*c + 3*a*d)*x^(7/2))/7 + (2*c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(11/2))/11 + (2*d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(15/2))/15 + (2*b*d^2*(3*b*c + 2*a*d)*x^(19/2))/19 + (2*b^2*d^3*x^(23/2))/23", //
        459);
  }

  // {459}
  public void test2432() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^3)/Sqrt[x], x]", //
        "2*a^2*c^3*Sqrt[x] + (2*a*c^2*(2*b*c + 3*a*d)*x^(5/2))/5 + (2*c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(9/2))/9 + (2*d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(13/2))/13 + (2*b*d^2*(3*b*c + 2*a*d)*x^(17/2))/17 + (2*b^2*d^3*x^(21/2))/21", //
        459);
  }

  // {459}
  public void test2433() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^3)/x^(3/2), x]", //
        "(-2*a^2*c^3)/Sqrt[x] + (2*a*c^2*(2*b*c + 3*a*d)*x^(3/2))/3 + (2*c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(7/2))/7 + (2*d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(11/2))/11 + (2*b*d^2*(3*b*c + 2*a*d)*x^(15/2))/15 + (2*b^2*d^3*x^(19/2))/19", //
        459);
  }

  // {459}
  public void test2434() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^3)/x^(5/2), x]", //
        "(-2*a^2*c^3)/(3*x^(3/2)) + 2*a*c^2*(2*b*c + 3*a*d)*Sqrt[x] + (2*c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(5/2))/5 + (2*d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(9/2))/9 + (2*b*d^2*(3*b*c + 2*a*d)*x^(13/2))/13 + (2*b^2*d^3*x^(17/2))/17", //
        459);
  }

  // {459}
  public void test2435() {
    check( //
        "Integrate[((a + b*x^2)^2*(c + d*x^2)^3)/x^(7/2), x]", //
        "(-2*a^2*c^3)/(5*x^(5/2)) - (2*a*c^2*(2*b*c + 3*a*d))/Sqrt[x] + (2*c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^(3/2))/3 + (2*d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^(7/2))/7 + (2*b*d^2*(3*b*c + 2*a*d)*x^(11/2))/11 + (2*b^2*d^3*x^(15/2))/15", //
        459);
  }

  // {464, 270}
  public void test2436() {
    check( //
        "Integrate[(Sqrt[a + b*x^2]*(A + B*x^2))/x^6, x]", //
        "-(A*(a + b*x^2)^(3/2))/(5*a*x^5) + ((2*A*b - 5*a*B)*(a + b*x^2)^(3/2))/(15*a^2*x^3)", //
        464,
        270);
  }

  // {464, 270}
  public void test2437() {
    check( //
        "Integrate[((a + b*x^2)^(3/2)*(A + B*x^2))/x^8, x]", //
        "-(A*(a + b*x^2)^(5/2))/(7*a*x^7) + ((2*A*b - 7*a*B)*(a + b*x^2)^(5/2))/(35*a^2*x^5)", //
        464,
        270);
  }

  // {464, 270}
  public void test2438() {
    check( //
        "Integrate[((a + b*x^2)^(5/2)*(A + B*x^2))/x^10, x]", //
        "-(A*(a + b*x^2)^(7/2))/(9*a*x^9) + ((2*A*b - 9*a*B)*(a + b*x^2)^(7/2))/(63*a^2*x^7)", //
        464,
        270);
  }

  // {464, 270}
  public void test2439() {
    check( //
        "Integrate[(A + B*x^2)/(x^4*Sqrt[a + b*x^2]), x]", //
        "-(A*Sqrt[a + b*x^2])/(3*a*x^3) + ((2*A*b - 3*a*B)*Sqrt[a + b*x^2])/(3*a^2*x)", //
        464,
        270);
  }

  // {464, 197}
  public void test2440() {
    check( //
        "Integrate[(A + B*x^2)/(x^2*(a + b*x^2)^(3/2)), x]", //
        "-(A/(a*x*Sqrt[a + b*x^2])) - ((2*A*b - a*B)*x)/(a^2*Sqrt[a + b*x^2])", //
        464,
        197);
  }

  // {386, 197}
  public void test2441() {
    check( //
        "Integrate[(A + B*x^2)/(a + b*x^2)^(5/2), x]", //
        "(2*A*x)/(3*a^2*Sqrt[a + b*x^2]) + (x*(A + B*x^2))/(3*a*(a + b*x^2)^(3/2))", //
        386,
        197);
  }

  // {15, 211}
  public void test2442() {
    check( //
        "Integrate[x/(Sqrt[d*x^2]*(a + b*x^2)), x]", //
        "(x*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(Sqrt[a]*Sqrt[b]*Sqrt[d*x^2])", //
        15,
        211);
  }

  // {385, 211}
  public void test2443() {
    check( //
        "Integrate[1/((a + b*x^2)*Sqrt[c + d*x^2]), x]", //
        "ArcTan[(Sqrt[b*c - a*d]*x)/(Sqrt[a]*Sqrt[c + d*x^2])]/(Sqrt[a]*Sqrt[b*c - a*d])", //
        385,
        211);
  }

  // {506, 422}
  public void test2444() {
    check( //
        "Integrate[x^2/(Sqrt[a + b*x^2]*Sqrt[c + d*x^2]), x]", //
        "(x*Sqrt[a + b*x^2])/(b*Sqrt[c + d*x^2]) - (Sqrt[c]*Sqrt[a + b*x^2]*EllipticE[ArcTan[(Sqrt[d]*x)/Sqrt[c]], 1 - (b*c)/(a*d)])/(b*Sqrt[d]*Sqrt[(c*(a + b*x^2))/(a*(c + d*x^2))]*Sqrt[c + d*x^2])", //
        506,
        422);
  }

  // {455, 37}
  public void test2445() {
    check( //
        "Integrate[x/((a + b*x^2)^(3/2)*Sqrt[c + d*x^2]), x]", //
        "-(Sqrt[c + d*x^2]/((b*c - a*d)*Sqrt[a + b*x^2]))", //
        455,
        37);
  }

  // {506, 422}
  public void test2446() {
    check( //
        "Integrate[x^2/(Sqrt[2 + b*x^2]*Sqrt[3 + d*x^2]), x]", //
        "(x*Sqrt[2 + b*x^2])/(b*Sqrt[3 + d*x^2]) - (Sqrt[2]*Sqrt[2 + b*x^2]*EllipticE[ArcTan[(Sqrt[d]*x)/Sqrt[3]], 1 - (3*b)/(2*d)])/(b*Sqrt[d]*Sqrt[(2 + b*x^2)/(3 + d*x^2)]*Sqrt[3 + d*x^2])", //
        506,
        422);
  }

  // {506, 422}
  public void test2447() {
    check( //
        "Integrate[x^2/(Sqrt[4 + x^2]*Sqrt[c + d*x^2]), x]", //
        "(x*Sqrt[c + d*x^2])/(d*Sqrt[4 + x^2]) - (Sqrt[c + d*x^2]*EllipticE[ArcTan[x/2], 1 - (4*d)/c])/(d*Sqrt[4 + x^2]*Sqrt[(c + d*x^2)/(c*(4 + x^2))])", //
        506,
        422);
  }

  // {506, 422}
  public void test2448() {
    check( //
        "Integrate[x^2/(Sqrt[1 + x^2]*Sqrt[2 + 3*x^2]), x]", //
        "(x*Sqrt[2 + 3*x^2])/(3*Sqrt[1 + x^2]) - (Sqrt[2]*Sqrt[2 + 3*x^2]*EllipticE[ArcTan[x], -1/2])/(3*Sqrt[1 + x^2]*Sqrt[(2 + 3*x^2)/(1 + x^2)])", //
        506,
        422);
  }

  // {506, 422}
  public void test2449() {
    check( //
        "Integrate[x^2/(Sqrt[4 + x^2]*Sqrt[2 + 3*x^2]), x]", //
        "(x*Sqrt[2 + 3*x^2])/(3*Sqrt[4 + x^2]) - (Sqrt[2]*Sqrt[2 + 3*x^2]*EllipticE[ArcTan[x/2], -5])/(3*Sqrt[4 + x^2]*Sqrt[(2 + 3*x^2)/(4 + x^2)])", //
        506,
        422);
  }

  // {506, 422}
  public void test2450() {
    check( //
        "Integrate[x^2/(Sqrt[2 + 3*x^2]*Sqrt[1 + 4*x^2]), x]", //
        "(x*Sqrt[2 + 3*x^2])/(3*Sqrt[1 + 4*x^2]) - (Sqrt[2 + 3*x^2]*EllipticE[ArcTan[2*x], 5/8])/(3*Sqrt[2]*Sqrt[(2 + 3*x^2)/(1 + 4*x^2)]*Sqrt[1 + 4*x^2])", //
        506,
        422);
  }

  // {464, 270}
  public void test2451() {
    check( //
        "Integrate[(c + d*x^2)/((e*x)^(7/2)*(a + b*x^2)^(3/4)), x]", //
        "(-2*c*(a + b*x^2)^(1/4))/(5*a*e*(e*x)^(5/2)) + (2*(4*b*c - 5*a*d)*(a + b*x^2)^(1/4))/(5*a^2*e^3*Sqrt[e*x])", //
        464,
        270);
  }

  // {464, 270}
  public void test2452() {
    check( //
        "Integrate[(c + d*x^2)/((e*x)^(5/2)*(a + b*x^2)^(5/4)), x]", //
        "(-2*c)/(3*a*e*(e*x)^(3/2)*(a + b*x^2)^(1/4)) - (2*(4*b*c - 3*a*d)*Sqrt[e*x])/(3*a^2*e^3*(a + b*x^2)^(1/4))", //
        464,
        270);
  }

  // {464, 270}
  public void test2453() {
    check( //
        "Integrate[(c + d*x^2)/((e*x)^(3/2)*(a + b*x^2)^(7/4)), x]", //
        "(-2*c)/(a*e*Sqrt[e*x]*(a + b*x^2)^(3/4)) - (2*(4*b*c - a*d)*(e*x)^(3/2))/(3*a^2*e^3*(a + b*x^2)^(3/4))", //
        464,
        270);
  }

  // {468, 270}
  public void test2454() {
    check( //
        "Integrate[(c + d*x^2)/(Sqrt[e*x]*(a + b*x^2)^(9/4)), x]", //
        "(2*(b*c - a*d)*Sqrt[e*x])/(5*a*b*e*(a + b*x^2)^(5/4)) + (2*(4*b*c + a*d)*Sqrt[e*x])/(5*a^2*b*e*(a + b*x^2)^(1/4))", //
        468,
        270);
  }

  // {535}
  public void test2455() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)*(e + f*x^2)^4, x]", //
        "a*c*e^4*x + (e^3*(b*c*e + a*d*e + 4*a*c*f)*x^3)/3 + (e^2*(2*a*f*(2*d*e + 3*c*f) + b*e*(d*e + 4*c*f))*x^5)/5 + (2*e*f*(a*f*(3*d*e + 2*c*f) + b*e*(2*d*e + 3*c*f))*x^7)/7 + (f^2*(a*f*(4*d*e + c*f) + 2*b*e*(3*d*e + 2*c*f))*x^9)/9 + (f^3*(4*b*d*e + b*c*f + a*d*f)*x^11)/11 + (b*d*f^4*x^13)/13", //
        535);
  }

  // {535}
  public void test2456() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)*(e + f*x^2)^3, x]", //
        "a*c*e^3*x + (e^2*(b*c*e + a*d*e + 3*a*c*f)*x^3)/3 + (e*(3*a*f*(d*e + c*f) + b*e*(d*e + 3*c*f))*x^5)/5 + (f*(3*b*e*(d*e + c*f) + a*f*(3*d*e + c*f))*x^7)/7 + (f^2*(3*b*d*e + b*c*f + a*d*f)*x^9)/9 + (b*d*f^3*x^11)/11", //
        535);
  }

  // {535}
  public void test2457() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)*(e + f*x^2)^2, x]", //
        "a*c*e^2*x + (e*(b*c*e + a*d*e + 2*a*c*f)*x^3)/3 + ((a*f*(2*d*e + c*f) + b*e*(d*e + 2*c*f))*x^5)/5 + (f*(2*b*d*e + b*c*f + a*d*f)*x^7)/7 + (b*d*f^2*x^9)/9", //
        535);
  }

  // {535}
  public void test2458() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)*(e + f*x^2), x]", //
        "a*c*e*x + ((b*c*e + a*d*e + a*c*f)*x^3)/3 + ((b*d*e + b*c*f + a*d*f)*x^5)/5 + (b*d*f*x^7)/7", //
        535);
  }

  // {535}
  public void test2459() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^2*(e + f*x^2)^3, x]", //
        "a*c^2*e^3*x + (c*e^2*(b*c*e + 2*a*d*e + 3*a*c*f)*x^3)/3 + (e*(b*c*e*(2*d*e + 3*c*f) + a*(d^2*e^2 + 6*c*d*e*f + 3*c^2*f^2))*x^5)/5 + ((a*f*(3*d^2*e^2 + 6*c*d*e*f + c^2*f^2) + b*e*(d^2*e^2 + 6*c*d*e*f + 3*c^2*f^2))*x^7)/7 + (f*(a*d*f*(3*d*e + 2*c*f) + b*(3*d^2*e^2 + 6*c*d*e*f + c^2*f^2))*x^9)/9 + (d*f^2*(3*b*d*e + 2*b*c*f + a*d*f)*x^11)/11 + (b*d^2*f^3*x^13)/13", //
        535);
  }

  // {535}
  public void test2460() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^2*(e + f*x^2)^2, x]", //
        "a*c^2*e^2*x + (c*e*(b*c*e + 2*a*(d*e + c*f))*x^3)/3 + ((2*b*c*e*(d*e + c*f) + a*(d^2*e^2 + 4*c*d*e*f + c^2*f^2))*x^5)/5 + ((2*a*d*f*(d*e + c*f) + b*(d^2*e^2 + 4*c*d*e*f + c^2*f^2))*x^7)/7 + (d*f*(a*d*f + 2*b*(d*e + c*f))*x^9)/9 + (b*d^2*f^2*x^11)/11", //
        535);
  }

  // {535}
  public void test2461() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^2*(e + f*x^2), x]", //
        "a*c^2*e*x + (c*(b*c*e + 2*a*d*e + a*c*f)*x^3)/3 + ((b*c*(2*d*e + c*f) + a*d*(d*e + 2*c*f))*x^5)/5 + (d*(b*d*e + 2*b*c*f + a*d*f)*x^7)/7 + (b*d^2*f*x^9)/9", //
        535);
  }

  // {535}
  public void test2462() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^3*(e + f*x^2)^3, x]", //
        "a*c^3*e^3*x + (c^2*e^2*(b*c*e + 3*a*(d*e + c*f))*x^3)/3 + (3*c*e*(b*c*e*(d*e + c*f) + a*(d^2*e^2 + 3*c*d*e*f + c^2*f^2))*x^5)/5 + ((3*b*c*e*(d^2*e^2 + 3*c*d*e*f + c^2*f^2) + a*(d^3*e^3 + 9*c*d^2*e^2*f + 9*c^2*d*e*f^2 + c^3*f^3))*x^7)/7 + ((3*a*d*f*(d^2*e^2 + 3*c*d*e*f + c^2*f^2) + b*(d^3*e^3 + 9*c*d^2*e^2*f + 9*c^2*d*e*f^2 + c^3*f^3))*x^9)/9 + (3*d*f*(a*d*f*(d*e + c*f) + b*(d^2*e^2 + 3*c*d*e*f + c^2*f^2))*x^11)/11 + (d^2*f^2*(a*d*f + 3*b*(d*e + c*f))*x^13)/13 + (b*d^3*f^3*x^15)/15", //
        535);
  }

  // {535}
  public void test2463() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^3*(e + f*x^2)^2, x]", //
        "a*c^3*e^2*x + (c^2*e*(b*c*e + 3*a*d*e + 2*a*c*f)*x^3)/3 + (c*(b*c*e*(3*d*e + 2*c*f) + a*(3*d^2*e^2 + 6*c*d*e*f + c^2*f^2))*x^5)/5 + ((b*c*(3*d^2*e^2 + 6*c*d*e*f + c^2*f^2) + a*d*(d^2*e^2 + 6*c*d*e*f + 3*c^2*f^2))*x^7)/7 + (d*(a*d*f*(2*d*e + 3*c*f) + b*(d^2*e^2 + 6*c*d*e*f + 3*c^2*f^2))*x^9)/9 + (d^2*f*(2*b*d*e + 3*b*c*f + a*d*f)*x^11)/11 + (b*d^3*f^2*x^13)/13", //
        535);
  }

  // {535}
  public void test2464() {
    check( //
        "Integrate[(a + b*x^2)*(c + d*x^2)^3*(e + f*x^2), x]", //
        "a*c^3*e*x + (c^2*(b*c*e + 3*a*d*e + a*c*f)*x^3)/3 + (c*(3*a*d*(d*e + c*f) + b*c*(3*d*e + c*f))*x^5)/5 + (d*(3*b*c*(d*e + c*f) + a*d*(d*e + 3*c*f))*x^7)/7 + (d^2*(b*d*e + 3*b*c*f + a*d*f)*x^9)/9 + (b*d^3*f*x^11)/11", //
        535);
  }

  // {21, 435}
  public void test2465() {
    check( //
        "Integrate[(-b - Sqrt[b^2 - 4*a*c] + 2*c*x^2)/(Sqrt[1 + (2*c*x^2)/(-b - Sqrt[b^2 - 4*a*c])]*Sqrt[1 + (2*c*x^2)/(-b + Sqrt[b^2 - 4*a*c])]), x]", //
        "-((Sqrt[b - Sqrt[b^2 - 4*a*c]]*(b + Sqrt[b^2 - 4*a*c])*EllipticE[ArcSin[(Sqrt[2]*Sqrt[c]*x)/Sqrt[b - Sqrt[b^2 - 4*a*c]]], (b - Sqrt[b^2 - 4*a*c])/(b + Sqrt[b^2 - 4*a*c])])/(Sqrt[2]*Sqrt[c]))", //
        21,
        435);
  }

  // {385, 211}
  public void test2466() {
    check( //
        "Integrate[1/((c + d*x^2)*Sqrt[e + f*x^2]), x]", //
        "ArcTan[(Sqrt[d*e - c*f]*x)/(Sqrt[c]*Sqrt[e + f*x^2])]/(Sqrt[c]*Sqrt[d*e - c*f])", //
        385,
        211);
  }

  // {567, 551}
  public void test2467() {
    check( //
        "Integrate[Sqrt[c + d*x^2]/(Sqrt[a + b*x^2]*Sqrt[e + f*x^2]), x]", //
        "(c*Sqrt[e]*Sqrt[a + b*x^2]*Sqrt[(c*(e + f*x^2))/(e*(c + d*x^2))]*EllipticPi[(d*e)/(d*e - c*f), ArcSin[(Sqrt[d*e - c*f]*x)/(Sqrt[e]*Sqrt[c + d*x^2])], -(((b*c - a*d)*e)/(a*(d*e - c*f)))])/(a*Sqrt[d*e - c*f]*Sqrt[(c*(a + b*x^2))/(a*(c + d*x^2))]*Sqrt[e + f*x^2])", //
        567,
        551);
  }

  // {568, 435}
  public void test2468() {
    check( //
        "Integrate[Sqrt[c + d*x^2]/((a + b*x^2)^(3/2)*Sqrt[e + f*x^2]), x]", //
        "(Sqrt[e]*Sqrt[c + d*x^2]*Sqrt[(a*(e + f*x^2))/(e*(a + b*x^2))]*EllipticE[ArcSin[(Sqrt[b*e - a*f]*x)/(Sqrt[e]*Sqrt[a + b*x^2])], ((b*c - a*d)*e)/(c*(b*e - a*f))])/(a*Sqrt[b*e - a*f]*Sqrt[(a*(c + d*x^2))/(c*(a + b*x^2))]*Sqrt[e + f*x^2])", //
        568,
        435);
  }

  // {567, 551}
  public void test2469() {
    check( //
        "Integrate[Sqrt[a + b*x^2]/(Sqrt[c + d*x^2]*Sqrt[e + f*x^2]), x]", //
        "(a*Sqrt[c + d*x^2]*Sqrt[(a*(e + f*x^2))/(e*(a + b*x^2))]*EllipticPi[(b*c)/(b*c - a*d), ArcSin[(Sqrt[b*c - a*d]*x)/(Sqrt[c]*Sqrt[a + b*x^2])], (c*(b*e - a*f))/((b*c - a*d)*e)])/(Sqrt[c]*Sqrt[b*c - a*d]*Sqrt[(a*(c + d*x^2))/(c*(a + b*x^2))]*Sqrt[e + f*x^2])", //
        567,
        551);
  }

  // {566, 430}
  public void test2470() {
    check( //
        "Integrate[1/(Sqrt[a + b*x^2]*Sqrt[c + d*x^2]*Sqrt[e + f*x^2]), x]", //
        "(Sqrt[e]*Sqrt[c + d*x^2]*Sqrt[(a*(e + f*x^2))/(e*(a + b*x^2))]*EllipticF[ArcSin[(Sqrt[b*e - a*f]*x)/(Sqrt[e]*Sqrt[a + b*x^2])], ((b*c - a*d)*e)/(c*(b*e - a*f))])/(c*Sqrt[b*e - a*f]*Sqrt[(a*(c + d*x^2))/(c*(a + b*x^2))]*Sqrt[e + f*x^2])", //
        566,
        430);
  }

  // {584}
  public void test2471() {
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)^3*(A + B*x^2)*(c + d*x^2), x]", //
        "(a^3*A*c*(e*x)^(1 + m))/(e*(1 + m)) + (a^2*(3*A*b*c + a*B*c + a*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + (a*(3*A*b*(b*c + a*d) + a*B*(3*b*c + a*d))*(e*x)^(5 + m))/(e^5*(5 + m)) + (b*(3*a*B*(b*c + a*d) + A*b*(b*c + 3*a*d))*(e*x)^(7 + m))/(e^7*(7 + m)) + (b^2*(b*B*c + A*b*d + 3*a*B*d)*(e*x)^(9 + m))/(e^9*(9 + m)) + (b^3*B*d*(e*x)^(11 + m))/(e^11*(11 + m))", //
        584);
  }

  // {584}
  public void test2472() {
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)^2*(A + B*x^2)*(c + d*x^2), x]", //
        "(a^2*A*c*(e*x)^(1 + m))/(e*(1 + m)) + (a*(2*A*b*c + a*B*c + a*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + ((a*B*(2*b*c + a*d) + A*b*(b*c + 2*a*d))*(e*x)^(5 + m))/(e^5*(5 + m)) + (b*(b*B*c + A*b*d + 2*a*B*d)*(e*x)^(7 + m))/(e^7*(7 + m)) + (b^2*B*d*(e*x)^(9 + m))/(e^9*(9 + m))", //
        584);
  }

  // {584}
  public void test2473() {
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)*(A + B*x^2)*(c + d*x^2), x]", //
        "(a*A*c*(e*x)^(1 + m))/(e*(1 + m)) + ((A*b*c + a*B*c + a*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + ((b*B*c + A*b*d + a*B*d)*(e*x)^(5 + m))/(e^5*(5 + m)) + (b*B*d*(e*x)^(7 + m))/(e^7*(7 + m))", //
        584);
  }

  // {459}
  public void test2474() {
    check( //
        "Integrate[(e*x)^m*(A + B*x^2)*(c + d*x^2), x]", //
        "(A*c*(e*x)^(1 + m))/(e*(1 + m)) + ((B*c + A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + (B*d*(e*x)^(5 + m))/(e^5*(5 + m))", //
        459);
  }

  // {584}
  public void test2475() {
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)^3*(A + B*x^2)*(c + d*x^2)^2, x]", //
        "(a^3*A*c^2*(e*x)^(1 + m))/(e*(1 + m)) + (a^2*c*(3*A*b*c + a*B*c + 2*a*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + (a*(a*B*c*(3*b*c + 2*a*d) + A*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2))*(e*x)^(5 + m))/(e^5*(5 + m)) + ((a*B*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2) + A*b*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2))*(e*x)^(7 + m))/(e^7*(7 + m)) + (b*(3*a^2*B*d^2 + 3*a*b*d*(2*B*c + A*d) + b^2*c*(B*c + 2*A*d))*(e*x)^(9 + m))/(e^9*(9 + m)) + (b^2*d*(2*b*B*c + A*b*d + 3*a*B*d)*(e*x)^(11 + m))/(e^11*(11 + m)) + (b^3*B*d^2*(e*x)^(13 + m))/(e^13*(13 + m))", //
        584);
  }

  // {584}
  public void test2476() {
    fSeconds = 20;
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)^2*(A + B*x^2)*(c + d*x^2)^2, x]", //
        "(a^2*A*c^2*(e*x)^(1 + m))/(e*(1 + m)) + (a*c*(a*B*c + 2*A*(b*c + a*d))*(e*x)^(3 + m))/(e^3*(3 + m)) + ((2*a*B*c*(b*c + a*d) + A*(b^2*c^2 + 4*a*b*c*d + a^2*d^2))*(e*x)^(5 + m))/(e^5*(5 + m)) + ((a^2*B*d^2 + 2*a*b*d*(2*B*c + A*d) + b^2*c*(B*c + 2*A*d))*(e*x)^(7 + m))/(e^7*(7 + m)) + (b*d*(2*b*B*c + A*b*d + 2*a*B*d)*(e*x)^(9 + m))/(e^9*(9 + m)) + (b^2*B*d^2*(e*x)^(11 + m))/(e^11*(11 + m))", //
        584);
  }

  // {584}
  public void test2477() {
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)*(A + B*x^2)*(c + d*x^2)^2, x]", //
        "(a*A*c^2*(e*x)^(1 + m))/(e*(1 + m)) + (c*(A*b*c + a*B*c + 2*a*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + ((a*d*(2*B*c + A*d) + b*c*(B*c + 2*A*d))*(e*x)^(5 + m))/(e^5*(5 + m)) + (d*(2*b*B*c + A*b*d + a*B*d)*(e*x)^(7 + m))/(e^7*(7 + m)) + (b*B*d^2*(e*x)^(9 + m))/(e^9*(9 + m))", //
        584);
  }

  // {459}
  public void test2478() {
    check( //
        "Integrate[(e*x)^m*(A + B*x^2)*(c + d*x^2)^2, x]", //
        "(A*c^2*(e*x)^(1 + m))/(e*(1 + m)) + (c*(B*c + 2*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + (d*(2*B*c + A*d)*(e*x)^(5 + m))/(e^5*(5 + m)) + (B*d^2*(e*x)^(7 + m))/(e^7*(7 + m))", //
        459);
  }

  // {584}
  public void test2479() {
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)^3*(A + B*x^2)*(c + d*x^2)^3, x]", //
        "(a^3*A*c^3*(e*x)^(1 + m))/(e*(1 + m)) + (a^2*c^2*(a*B*c + 3*A*(b*c + a*d))*(e*x)^(3 + m))/(e^3*(3 + m)) + (3*a*c*(a*B*c*(b*c + a*d) + A*(b^2*c^2 + 3*a*b*c*d + a^2*d^2))*(e*x)^(5 + m))/(e^5*(5 + m)) + ((3*a*B*c*(b^2*c^2 + 3*a*b*c*d + a^2*d^2) + A*(b^3*c^3 + 9*a*b^2*c^2*d + 9*a^2*b*c*d^2 + a^3*d^3))*(e*x)^(7 + m))/(e^7*(7 + m)) + ((a^3*B*d^3 + 9*a*b^2*c*d*(B*c + A*d) + 3*a^2*b*d^2*(3*B*c + A*d) + b^3*c^2*(B*c + 3*A*d))*(e*x)^(9 + m))/(e^9*(9 + m)) + (3*b*d*(a^2*B*d^2 + b^2*c*(B*c + A*d) + a*b*d*(3*B*c + A*d))*(e*x)^(11 + m))/(e^11*(11 + m)) + (b^2*d^2*(3*b*B*c + A*b*d + 3*a*B*d)*(e*x)^(13 + m))/(e^13*(13 + m)) + (b^3*B*d^3*(e*x)^(15 + m))/(e^15*(15 + m))", //
        584);
  }

  // {584}
  public void test2480() {
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)^2*(A + B*x^2)*(c + d*x^2)^3, x]", //
        "(a^2*A*c^3*(e*x)^(1 + m))/(e*(1 + m)) + (a*c^2*(2*A*b*c + a*B*c + 3*a*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + (c*(a*B*c*(2*b*c + 3*a*d) + A*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2))*(e*x)^(5 + m))/(e^5*(5 + m)) + ((6*a*b*c*d*(B*c + A*d) + a^2*d^2*(3*B*c + A*d) + b^2*c^2*(B*c + 3*A*d))*(e*x)^(7 + m))/(e^7*(7 + m)) + (d*(a^2*B*d^2 + 3*b^2*c*(B*c + A*d) + 2*a*b*d*(3*B*c + A*d))*(e*x)^(9 + m))/(e^9*(9 + m)) + (b*d^2*(3*b*B*c + A*b*d + 2*a*B*d)*(e*x)^(11 + m))/(e^11*(11 + m)) + (b^2*B*d^3*(e*x)^(13 + m))/(e^13*(13 + m))", //
        584);
  }

  // {584}
  public void test2481() {
    check( //
        "Integrate[(e*x)^m*(a + b*x^2)*(A + B*x^2)*(c + d*x^2)^3, x]", //
        "(a*A*c^3*(e*x)^(1 + m))/(e*(1 + m)) + (c^2*(A*b*c + a*B*c + 3*a*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + (c*(3*a*d*(B*c + A*d) + b*c*(B*c + 3*A*d))*(e*x)^(5 + m))/(e^5*(5 + m)) + (d*(3*b*c*(B*c + A*d) + a*d*(3*B*c + A*d))*(e*x)^(7 + m))/(e^7*(7 + m)) + (d^2*(3*b*B*c + A*b*d + a*B*d)*(e*x)^(9 + m))/(e^9*(9 + m)) + (b*B*d^3*(e*x)^(11 + m))/(e^11*(11 + m))", //
        584);
  }

  // {459}
  public void test2482() {
    check( //
        "Integrate[(e*x)^m*(A + B*x^2)*(c + d*x^2)^3, x]", //
        "(A*c^3*(e*x)^(1 + m))/(e*(1 + m)) + (c^2*(B*c + 3*A*d)*(e*x)^(3 + m))/(e^3*(3 + m)) + (3*c*d*(B*c + A*d)*(e*x)^(5 + m))/(e^5*(5 + m)) + (d^2*(3*B*c + A*d)*(e*x)^(7 + m))/(e^7*(7 + m)) + (B*d^3*(e*x)^(9 + m))/(e^9*(9 + m))", //
        459);
  }

  // {470, 371}
  public void test2483() {
    check( //
        "Integrate[((e*x)^m*(A + B*x^2))/(c + d*x^2), x]", //
        "(B*(e*x)^(1 + m))/(d*e*(1 + m)) - ((B*c - A*d)*(e*x)^(1 + m)*Hypergeometric2F1[1, (1 + m)/2, (3 + m)/2, -((d*x^2)/c)])/(c*d*e*(1 + m))", //
        470,
        371);
  }

  // {468, 371}
  public void test2484() {
    check( //
        "Integrate[((e*x)^m*(A + B*x^2))/(c + d*x^2)^2, x]", //
        "-((B*c - A*d)*(e*x)^(1 + m))/(2*c*d*e*(c + d*x^2)) + ((A*d*(1 - m) + B*c*(1 + m))*(e*x)^(1 + m)*Hypergeometric2F1[1, (1 + m)/2, (3 + m)/2, -((d*x^2)/c)])/(2*c^2*d*e*(1 + m))", //
        468,
        371);
  }

  // {468, 371}
  public void test2485() {
    check( //
        "Integrate[((e*x)^m*(A + B*x^2))/(c + d*x^2)^3, x]", //
        "-((B*c - A*d)*(e*x)^(1 + m))/(4*c*d*e*(c + d*x^2)^2) + ((A*d*(3 - m) + B*c*(1 + m))*(e*x)^(1 + m)*Hypergeometric2F1[2, (1 + m)/2, (3 + m)/2, -((d*x^2)/c)])/(4*c^3*d*e*(1 + m))", //
        468,
        371);
  }

  // {819, 267}
  public void test2486() {
    check( //
        "Integrate[(x^2*(A + B*x))/(a + b*x^2)^(5/2), x]", //
        "-(x^2*(a*B - A*b*x))/(3*a*b*(a + b*x^2)^(3/2)) - (2*B)/(3*b^2*Sqrt[a + b*x^2])", //
        819,
        267);
  }

  // {792, 197}
  public void test2487() {
    check( //
        "Integrate[(x*(A + B*x))/(a + b*x^2)^(5/2), x]", //
        "-(A + B*x)/(3*b*(a + b*x^2)^(3/2)) + (B*x)/(3*a*b*Sqrt[a + b*x^2])", //
        792,
        197);
  }

  // {653, 197}
  public void test2488() {
    check( //
        "Integrate[(A + B*x)/(a + b*x^2)^(5/2), x]", //
        "-(a*B - A*b*x)/(3*a*b*(a + b*x^2)^(3/2)) + (2*A*x)/(3*a^2*Sqrt[a + b*x^2])", //
        653,
        197);
  }

  // {794, 222}
  public void test2489() {
    check( //
        "Integrate[((1 - x)*x)/Sqrt[1 - x^2], x]", //
        "-((2 - x)*Sqrt[1 - x^2])/2 - ArcSin[x]/2", //
        794,
        222);
  }

  // {396, 213}
  public void test2490() {
    check( //
        "Integrate[(3 + x^2)/(-3 + x^2), x]", //
        "x - 2*Sqrt[3]*ArcTanh[x/Sqrt[3]]", //
        396,
        213);
  }

  // {396, 209}
  public void test2491() {
    check( //
        "Integrate[(-1 + x^2)/(1 + x^2), x]", //
        "x - 2*ArcTan[x]", //
        396,
        209);
  }

  // {12, 371}
  public void test2492() {
    check( //
        "Integrate[(A*(c*x)^m)/(a + b*x^2), x]", //
        "(A*(c*x)^(1 + m)*Hypergeometric2F1[1, (1 + m)/2, (3 + m)/2, -((b*x^2)/a)])/(a*c*(1 + m))", //
        12,
        371);
  }

  // {470, 371}
  public void test2493() {
    check( //
        "Integrate[((c*x)^m*(A + C*x^2))/(a + b*x^2), x]", //
        "(C*(c*x)^(1 + m))/(b*c*(1 + m)) + ((A*b - a*C)*(c*x)^(1 + m)*Hypergeometric2F1[1, (1 + m)/2, (3 + m)/2, -((b*x^2)/a)])/(a*b*c*(1 + m))", //
        470,
        371);
  }

  // {1816}
  public void test2494() {
    check( //
        "Integrate[x^3*(a + b*x^2)*(A + B*x + C*x^2 + D*x^3), x]", //
        "(a*A*x^4)/4 + (a*B*x^5)/5 + ((A*b + a*C)*x^6)/6 + ((b*B + a*D)*x^7)/7 + (b*C*x^8)/8 + (b*D*x^9)/9", //
        1816);
  }

  // {1816}
  public void test2495() {
    check( //
        "Integrate[x^2*(a + b*x^2)*(A + B*x + C*x^2 + D*x^3), x]", //
        "(a*A*x^3)/3 + (a*B*x^4)/4 + ((A*b + a*C)*x^5)/5 + ((b*B + a*D)*x^6)/6 + (b*C*x^7)/7 + (b*D*x^8)/8", //
        1816);
  }

  // {1816}
  public void test2496() {
    check( //
        "Integrate[x*(a + b*x^2)*(A + B*x + C*x^2 + D*x^3), x]", //
        "(a*A*x^2)/2 + (a*B*x^3)/3 + ((A*b + a*C)*x^4)/4 + ((b*B + a*D)*x^5)/5 + (b*C*x^6)/6 + (b*D*x^7)/7", //
        1816);
  }

  // {1824}
  public void test2497() {
    check( //
        "Integrate[(a + b*x^2)*(A + B*x + C*x^2 + D*x^3), x]", //
        "a*A*x + (a*B*x^2)/2 + ((A*b + a*C)*x^3)/3 + ((b*B + a*D)*x^4)/4 + (b*C*x^5)/5 + (b*D*x^6)/6", //
        1824);
  }

  // {1816}
  public void test2498() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x + C*x^2 + D*x^3))/x, x]", //
        "a*B*x + ((A*b + a*C)*x^2)/2 + ((b*B + a*D)*x^3)/3 + (b*C*x^4)/4 + (b*D*x^5)/5 + a*A*Log[x]", //
        1816);
  }

  // {1816}
  public void test2499() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x + C*x^2 + D*x^3))/x^2, x]", //
        "-((a*A)/x) + (A*b + a*C)*x + ((b*B + a*D)*x^2)/2 + (b*C*x^3)/3 + (b*D*x^4)/4 + a*B*Log[x]", //
        1816);
  }

  // {1816}
  public void test2500() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x + C*x^2 + D*x^3))/x^3, x]", //
        "-(a*A)/(2*x^2) - (a*B)/x + (b*B + a*D)*x + (b*C*x^2)/2 + (b*D*x^3)/3 + (A*b + a*C)*Log[x]", //
        1816);
  }

  // {1816}
  public void test2501() {
    check( //
        "Integrate[((a + b*x^2)*(A + B*x + C*x^2 + D*x^3))/x^4, x]", //
        "-(a*A)/(3*x^3) - (a*B)/(2*x^2) - (A*b + a*C)/x + b*C*x + (b*D*x^2)/2 + (b*B + a*D)*Log[x]", //
        1816);
  }

  // {1816}
  public void test2502() {
    check( //
        "Integrate[x^3*(a + b*x^2)^2*(A + B*x + C*x^2 + D*x^3), x]", //
        "(a^2*A*x^4)/4 + (a^2*B*x^5)/5 + (a*(2*A*b + a*C)*x^6)/6 + (a*(2*b*B + a*D)*x^7)/7 + (b*(A*b + 2*a*C)*x^8)/8 + (b*(b*B + 2*a*D)*x^9)/9 + (b^2*C*x^10)/10 + (b^2*D*x^11)/11", //
        1816);
  }

  // {1816}
  public void test2503() {
    check( //
        "Integrate[x^2*(a + b*x^2)^2*(A + B*x + C*x^2 + D*x^3), x]", //
        "(a^2*A*x^3)/3 + (a^2*B*x^4)/4 + (a*(2*A*b + a*C)*x^5)/5 + (a*(2*b*B + a*D)*x^6)/6 + (b*(A*b + 2*a*C)*x^7)/7 + (b*(b*B + 2*a*D)*x^8)/8 + (b^2*C*x^9)/9 + (b^2*D*x^10)/10", //
        1816);
  }

  // {1816}
  public void test2504() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x + C*x^2 + D*x^3))/x^3, x]", //
        "-(a^2*A)/(2*x^2) - (a^2*B)/x + a*(2*b*B + a*D)*x + (b*(A*b + 2*a*C)*x^2)/2 + (b*(b*B + 2*a*D)*x^3)/3 + (b^2*C*x^4)/4 + (b^2*D*x^5)/5 + a*(2*A*b + a*C)*Log[x]", //
        1816);
  }

  // {1816}
  public void test2505() {
    check( //
        "Integrate[((a + b*x^2)^2*(A + B*x + C*x^2 + D*x^3))/x^4, x]", //
        "-(a^2*A)/(3*x^3) - (a^2*B)/(2*x^2) - (a*(2*A*b + a*C))/x + b*(A*b + 2*a*C)*x + (b*(b*B + 2*a*D)*x^2)/2 + (b^2*C*x^3)/3 + (b^2*D*x^4)/4 + a*(2*b*B + a*D)*Log[x]", //
        1816);
  }

  // {1816}
  public void test2506() {
    check( //
        "Integrate[x^3*(a + b*x^2)^3*(A + B*x + C*x^2 + D*x^3), x]", //
        "(a^3*A*x^4)/4 + (a^3*B*x^5)/5 + (a^2*(3*A*b + a*C)*x^6)/6 + (a^2*(3*b*B + a*D)*x^7)/7 + (3*a*b*(A*b + a*C)*x^8)/8 + (a*b*(b*B + a*D)*x^9)/3 + (b^2*(A*b + 3*a*C)*x^10)/10 + (b^2*(b*B + 3*a*D)*x^11)/11 + (b^3*C*x^12)/12 + (b^3*D*x^13)/13", //
        1816);
  }

  // {1816}
  public void test2507() {
    check( //
        "Integrate[x^2*(a + b*x^2)^3*(A + B*x + C*x^2 + D*x^3), x]", //
        "(a^3*A*x^3)/3 + (a^3*B*x^4)/4 + (a^2*(3*A*b + a*C)*x^5)/5 + (a^2*(3*b*B + a*D)*x^6)/6 + (3*a*b*(A*b + a*C)*x^7)/7 + (3*a*b*(b*B + a*D)*x^8)/8 + (b^2*(A*b + 3*a*C)*x^9)/9 + (b^2*(b*B + 3*a*D)*x^10)/10 + (b^3*C*x^11)/11 + (b^3*D*x^12)/12", //
        1816);
  }

  // {1816}
  public void test2508() {
    check( //
        "Integrate[((a + b*x^2)^3*(A + B*x + C*x^2 + D*x^3))/x^3, x]", //
        "-(a^3*A)/(2*x^2) - (a^3*B)/x + a^2*(3*b*B + a*D)*x + (3*a*b*(A*b + a*C)*x^2)/2 + a*b*(b*B + a*D)*x^3 + (b^2*(A*b + 3*a*C)*x^4)/4 + (b^2*(b*B + 3*a*D)*x^5)/5 + (b^3*C*x^6)/6 + (b^3*D*x^7)/7 + a^2*(3*A*b + a*C)*Log[x]", //
        1816);
  }

  // {1816}
  public void test2509() {
    check( //
        "Integrate[((a + b*x^2)^3*(A + B*x + C*x^2 + D*x^3))/x^4, x]", //
        "-(a^3*A)/(3*x^3) - (a^3*B)/(2*x^2) - (a^2*(3*A*b + a*C))/x + 3*a*b*(A*b + a*C)*x + (3*a*b*(b*B + a*D)*x^2)/2 + (b^2*(A*b + 3*a*C)*x^3)/3 + (b^2*(b*B + 3*a*D)*x^4)/4 + (b^3*C*x^5)/5 + (b^3*D*x^6)/6 + a^2*(3*b*B + a*D)*Log[x]", //
        1816);
  }

  // {20, 32}
  public void test2510() {
    check( //
        "Integrate[(b*x)^p*(c*x)^m, x]", //
        "((b*x)^(1 + p)*(c*x)^m)/(b*(1 + m + p))", //
        20,
        32);
  }

  // {15, 30}
  public void test2511() {
    check( //
        "Integrate[x^3*Sqrt[b*x^2], x]", //
        "(x^4*Sqrt[b*x^2])/5", //
        15,
        30);
  }

  // {15, 30}
  public void test2512() {
    check( //
        "Integrate[x^2*Sqrt[b*x^2], x]", //
        "(x^3*Sqrt[b*x^2])/4", //
        15,
        30);
  }

  // {15, 30}
  public void test2513() {
    check( //
        "Integrate[x*Sqrt[b*x^2], x]", //
        "(x^2*Sqrt[b*x^2])/3", //
        15,
        30);
  }

  // {15, 30}
  public void test2514() {
    check( //
        "Integrate[Sqrt[b*x^2], x]", //
        "(x*Sqrt[b*x^2])/2", //
        15,
        30);
  }

  // {15, 8}
  public void test2515() {
    check( //
        "Integrate[Sqrt[b*x^2]/x, x]", //
        "Sqrt[b*x^2]", //
        15,
        8);
  }

  // {15, 29}
  public void test2516() {
    check( //
        "Integrate[Sqrt[b*x^2]/x^2, x]", //
        "(Sqrt[b*x^2]*Log[x])/x", //
        15,
        29);
  }

  // {15, 30}
  public void test2517() {
    check( //
        "Integrate[Sqrt[b*x^2]/x^3, x]", //
        "-(Sqrt[b*x^2]/x^2)", //
        15,
        30);
  }

  // {15, 30}
  public void test2518() {
    check( //
        "Integrate[Sqrt[b*x^2]/x^4, x]", //
        "-Sqrt[b*x^2]/(2*x^3)", //
        15,
        30);
  }

  // {15, 30}
  public void test2519() {
    check( //
        "Integrate[Sqrt[b*x^2]/x^5, x]", //
        "-Sqrt[b*x^2]/(3*x^4)", //
        15,
        30);
  }

  // {15, 30}
  public void test2520() {
    check( //
        "Integrate[(x^2)^(3/2), x]", //
        "(x^3*Sqrt[x^2])/4", //
        15,
        30);
  }

  // {15, 30}
  public void test2521() {
    check( //
        "Integrate[x^2*(b*x^2)^(3/2), x]", //
        "(b*x^5*Sqrt[b*x^2])/6", //
        15,
        30);
  }

  // {15, 30}
  public void test2522() {
    check( //
        "Integrate[x*(b*x^2)^(3/2), x]", //
        "(b*x^4*Sqrt[b*x^2])/5", //
        15,
        30);
  }

  // {15, 30}
  public void test2523() {
    check( //
        "Integrate[(b*x^2)^(3/2), x]", //
        "(b*x^3*Sqrt[b*x^2])/4", //
        15,
        30);
  }

  // {15, 30}
  public void test2524() {
    check( //
        "Integrate[(b*x^2)^(3/2)/x, x]", //
        "(b*x^2*Sqrt[b*x^2])/3", //
        15,
        30);
  }

  // {15, 30}
  public void test2525() {
    check( //
        "Integrate[(b*x^2)^(3/2)/x^2, x]", //
        "(b*x*Sqrt[b*x^2])/2", //
        15,
        30);
  }

  // {15, 8}
  public void test2526() {
    check( //
        "Integrate[(b*x^2)^(3/2)/x^3, x]", //
        "b*Sqrt[b*x^2]", //
        15,
        8);
  }

  // {15, 29}
  public void test2527() {
    check( //
        "Integrate[(b*x^2)^(3/2)/x^4, x]", //
        "(b*Sqrt[b*x^2]*Log[x])/x", //
        15,
        29);
  }

  // {15, 30}
  public void test2528() {
    check( //
        "Integrate[(b*x^2)^(3/2)/x^5, x]", //
        "-((b*Sqrt[b*x^2])/x^2)", //
        15,
        30);
  }

  // {15, 30}
  public void test2529() {
    check( //
        "Integrate[(b*x^2)^(3/2)/x^6, x]", //
        "-(b*Sqrt[b*x^2])/(2*x^3)", //
        15,
        30);
  }

  // {15, 30}
  public void test2530() {
    check( //
        "Integrate[(b*x^2)^(3/2)/x^7, x]", //
        "-(b*Sqrt[b*x^2])/(3*x^4)", //
        15,
        30);
  }

  // {15, 30}
  public void test2531() {
    check( //
        "Integrate[(x^2)^(5/2), x]", //
        "(x^5*Sqrt[x^2])/6", //
        15,
        30);
  }

  // {15, 30}
  public void test2532() {
    check( //
        "Integrate[x*(b*x^2)^(5/2), x]", //
        "(b^2*x^6*Sqrt[b*x^2])/7", //
        15,
        30);
  }

  // {15, 30}
  public void test2533() {
    check( //
        "Integrate[(b*x^2)^(5/2), x]", //
        "(b^2*x^5*Sqrt[b*x^2])/6", //
        15,
        30);
  }

  // {15, 30}
  public void test2534() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x, x]", //
        "(b^2*x^4*Sqrt[b*x^2])/5", //
        15,
        30);
  }

  // {15, 30}
  public void test2535() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x^2, x]", //
        "(b^2*x^3*Sqrt[b*x^2])/4", //
        15,
        30);
  }

  // {15, 30}
  public void test2536() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x^3, x]", //
        "(b^2*x^2*Sqrt[b*x^2])/3", //
        15,
        30);
  }

  // {15, 30}
  public void test2537() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x^4, x]", //
        "(b^2*x*Sqrt[b*x^2])/2", //
        15,
        30);
  }

  // {15, 8}
  public void test2538() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x^5, x]", //
        "b^2*Sqrt[b*x^2]", //
        15,
        8);
  }

  // {15, 29}
  public void test2539() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x^6, x]", //
        "(b^2*Sqrt[b*x^2]*Log[x])/x", //
        15,
        29);
  }

  // {15, 30}
  public void test2540() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x^7, x]", //
        "-((b^2*Sqrt[b*x^2])/x^2)", //
        15,
        30);
  }

  // {15, 30}
  public void test2541() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x^8, x]", //
        "-(b^2*Sqrt[b*x^2])/(2*x^3)", //
        15,
        30);
  }

  // {15, 30}
  public void test2542() {
    check( //
        "Integrate[(b*x^2)^(5/2)/x^9, x]", //
        "-(b^2*Sqrt[b*x^2])/(3*x^4)", //
        15,
        30);
  }

  // {15, 30}
  public void test2543() {
    check( //
        "Integrate[(x^2)^(7/2), x]", //
        "(x^7*Sqrt[x^2])/8", //
        15,
        30);
  }

  // {15, 30}
  public void test2544() {
    check( //
        "Integrate[x^3/Sqrt[b*x^2], x]", //
        "x^4/(3*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 8}
  public void test2545() {
    check( //
        "Integrate[x/Sqrt[b*x^2], x]", //
        "x^2/Sqrt[b*x^2]", //
        15,
        8);
  }

  // {15, 30}
  public void test2546() {
    check( //
        "Integrate[1/(x*Sqrt[b*x^2]), x]", //
        "-(1/Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2547() {
    check( //
        "Integrate[1/(x^3*Sqrt[b*x^2]), x]", //
        "-1/(3*x^2*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2548() {
    check( //
        "Integrate[x^2/Sqrt[b*x^2], x]", //
        "x^3/(2*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 29}
  public void test2549() {
    check( //
        "Integrate[1/Sqrt[b*x^2], x]", //
        "(x*Log[x])/Sqrt[b*x^2]", //
        15,
        29);
  }

  // {15, 30}
  public void test2550() {
    check( //
        "Integrate[1/(x^2*Sqrt[b*x^2]), x]", //
        "-1/(2*x*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2551() {
    check( //
        "Integrate[x^5/(b*x^2)^(3/2), x]", //
        "x^4/(3*b*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 8}
  public void test2552() {
    check( //
        "Integrate[x^3/(b*x^2)^(3/2), x]", //
        "x^2/(b*Sqrt[b*x^2])", //
        15,
        8);
  }

  // {15, 30}
  public void test2553() {
    check( //
        "Integrate[x/(b*x^2)^(3/2), x]", //
        "-(1/(b*Sqrt[b*x^2]))", //
        15,
        30);
  }

  // {15, 30}
  public void test2554() {
    check( //
        "Integrate[1/(x*(b*x^2)^(3/2)), x]", //
        "-1/(3*b*x^2*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2555() {
    check( //
        "Integrate[1/(x^3*(b*x^2)^(3/2)), x]", //
        "-1/(5*b*x^4*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2556() {
    check( //
        "Integrate[x^6/(b*x^2)^(3/2), x]", //
        "x^5/(4*b*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2557() {
    check( //
        "Integrate[x^4/(b*x^2)^(3/2), x]", //
        "x^3/(2*b*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 29}
  public void test2558() {
    check( //
        "Integrate[x^2/(b*x^2)^(3/2), x]", //
        "(x*Log[x])/(b*Sqrt[b*x^2])", //
        15,
        29);
  }

  // {15, 30}
  public void test2559() {
    check( //
        "Integrate[(b*x^2)^(-3/2), x]", //
        "-1/(2*b*x*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2560() {
    check( //
        "Integrate[1/(x^2*(b*x^2)^(3/2)), x]", //
        "-1/(4*b*x^3*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2561() {
    check( //
        "Integrate[x^7/(b*x^2)^(5/2), x]", //
        "x^4/(3*b^2*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 8}
  public void test2562() {
    check( //
        "Integrate[x^5/(b*x^2)^(5/2), x]", //
        "x^2/(b^2*Sqrt[b*x^2])", //
        15,
        8);
  }

  // {15, 30}
  public void test2563() {
    check( //
        "Integrate[x^3/(b*x^2)^(5/2), x]", //
        "-(1/(b^2*Sqrt[b*x^2]))", //
        15,
        30);
  }

  // {15, 30}
  public void test2564() {
    check( //
        "Integrate[x/(b*x^2)^(5/2), x]", //
        "-1/(3*b^2*x^2*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2565() {
    check( //
        "Integrate[1/(x*(b*x^2)^(5/2)), x]", //
        "-1/(5*b^2*x^4*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2566() {
    check( //
        "Integrate[x^6/(b*x^2)^(5/2), x]", //
        "x^3/(2*b^2*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 29}
  public void test2567() {
    check( //
        "Integrate[x^4/(b*x^2)^(5/2), x]", //
        "(x*Log[x])/(b^2*Sqrt[b*x^2])", //
        15,
        29);
  }

  // {15, 30}
  public void test2568() {
    check( //
        "Integrate[x^2/(b*x^2)^(5/2), x]", //
        "-1/(2*b^2*x*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2569() {
    check( //
        "Integrate[(b*x^2)^(-5/2), x]", //
        "-1/(4*b^2*x^3*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2570() {
    check( //
        "Integrate[1/(x^2*(b*x^2)^(5/2)), x]", //
        "-1/(6*b^2*x^5*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2571() {
    check( //
        "Integrate[x^m*(b*x^2)^p, x]", //
        "(x^(1 + m)*(b*x^2)^p)/(1 + m + 2*p)", //
        15,
        30);
  }

  // {15, 29}
  public void test2572() {
    check( //
        "Integrate[x^(-1 - 2*p)*(x^2)^p, x]", //
        "((x^2)^p*Log[x])/x^(2*p)", //
        15,
        29);
  }

  // {15, 30}
  public void test2573() {
    check( //
        "Integrate[x^3*(b*x^2)^p, x]", //
        "(x^4*(b*x^2)^p)/(2*(2 + p))", //
        15,
        30);
  }

  // {15, 30}
  public void test2574() {
    check( //
        "Integrate[x^2*(b*x^2)^p, x]", //
        "(x^3*(b*x^2)^p)/(3 + 2*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test2575() {
    check( //
        "Integrate[x*(b*x^2)^p, x]", //
        "(x^2*(b*x^2)^p)/(2*(1 + p))", //
        15,
        30);
  }

  // {15, 30}
  public void test2576() {
    check( //
        "Integrate[(b*x^2)^p, x]", //
        "(x*(b*x^2)^p)/(1 + 2*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test2577() {
    check( //
        "Integrate[(b*x^2)^p/x, x]", //
        "(b*x^2)^p/(2*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test2578() {
    check( //
        "Integrate[(b*x^2)^p/x^2, x]", //
        "-((b*x^2)^p/((1 - 2*p)*x))", //
        15,
        30);
  }

  // {15, 30}
  public void test2579() {
    check( //
        "Integrate[(b*x^2)^p/x^3, x]", //
        "-(b*x^2)^p/(2*(1 - p)*x^2)", //
        15,
        30);
  }

  // {15, 30}
  public void test2580() {
    check( //
        "Integrate[(b*x^2)^p/x^4, x]", //
        "-((b*x^2)^p/((3 - 2*p)*x^3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2581() {
    check( //
        "Integrate[Sqrt[b*x^3], x]", //
        "(2*x*Sqrt[b*x^3])/5", //
        15,
        30);
  }

  // {15, 30}
  public void test2582() {
    check( //
        "Integrate[Sqrt[b*x^2], x]", //
        "(x*Sqrt[b*x^2])/2", //
        15,
        30);
  }

  // {15, 30}
  public void test2583() {
    check( //
        "Integrate[Sqrt[b/x], x]", //
        "2*Sqrt[b/x]*x", //
        15,
        30);
  }

  // {15, 29}
  public void test2584() {
    check( //
        "Integrate[Sqrt[b/x^2], x]", //
        "Sqrt[b/x^2]*x*Log[x]", //
        15,
        29);
  }

  // {15, 30}
  public void test2585() {
    check( //
        "Integrate[Sqrt[b/x^3], x]", //
        "-2*Sqrt[b/x^3]*x", //
        15,
        30);
  }

  // {15, 30}
  public void test2586() {
    check( //
        "Integrate[(b*x^3)^(3/2), x]", //
        "(2*b*x^4*Sqrt[b*x^3])/11", //
        15,
        30);
  }

  // {15, 30}
  public void test2587() {
    check( //
        "Integrate[(b*x^2)^(3/2), x]", //
        "(b*x^3*Sqrt[b*x^2])/4", //
        15,
        30);
  }

  // {15, 30}
  public void test2588() {
    check( //
        "Integrate[(b/x)^(3/2), x]", //
        "-2*b*Sqrt[b/x]", //
        15,
        30);
  }

  // {15, 30}
  public void test2589() {
    check( //
        "Integrate[(b/x^2)^(3/2), x]", //
        "-(b*Sqrt[b/x^2])/(2*x)", //
        15,
        30);
  }

  // {15, 30}
  public void test2590() {
    check( //
        "Integrate[(b/x^3)^(3/2), x]", //
        "(-2*b*Sqrt[b/x^3])/(7*x^2)", //
        15,
        30);
  }

  // {15, 30}
  public void test2591() {
    check( //
        "Integrate[1/Sqrt[b*x^3], x]", //
        "(-2*x)/Sqrt[b*x^3]", //
        15,
        30);
  }

  // {15, 29}
  public void test2592() {
    check( //
        "Integrate[1/Sqrt[b*x^2], x]", //
        "(x*Log[x])/Sqrt[b*x^2]", //
        15,
        29);
  }

  // {15, 30}
  public void test2593() {
    check( //
        "Integrate[1/Sqrt[b/x], x]", //
        "(2*x)/(3*Sqrt[b/x])", //
        15,
        30);
  }

  // {15, 30}
  public void test2594() {
    check( //
        "Integrate[1/Sqrt[b/x^2], x]", //
        "x/(2*Sqrt[b/x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2595() {
    check( //
        "Integrate[1/Sqrt[b/x^3], x]", //
        "(2*x)/(5*Sqrt[b/x^3])", //
        15,
        30);
  }

  // {15, 30}
  public void test2596() {
    check( //
        "Integrate[(b*x^3)^(-3/2), x]", //
        "-2/(7*b*x^2*Sqrt[b*x^3])", //
        15,
        30);
  }

  // {15, 30}
  public void test2597() {
    check( //
        "Integrate[(b*x^2)^(-3/2), x]", //
        "-1/(2*b*x*Sqrt[b*x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2598() {
    check( //
        "Integrate[(b/x)^(-3/2), x]", //
        "(2*x^2)/(5*b*Sqrt[b/x])", //
        15,
        30);
  }

  // {15, 30}
  public void test2599() {
    check( //
        "Integrate[(b/x^2)^(-3/2), x]", //
        "x^3/(4*b*Sqrt[b/x^2])", //
        15,
        30);
  }

  // {15, 30}
  public void test2600() {
    check( //
        "Integrate[(b/x^3)^(-3/2), x]", //
        "(2*x^4)/(11*b*Sqrt[b/x^3])", //
        15,
        30);
  }

  // {15, 30}
  public void test2601() {
    check( //
        "Integrate[(b*x^n)^(1/3), x]", //
        "(3*x*(b*x^n)^(1/3))/(3 + n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2602() {
    check( //
        "Integrate[(b*x^3)^(1/3), x]", //
        "(x*(b*x^3)^(1/3))/2", //
        15,
        30);
  }

  // {15, 30}
  public void test2603() {
    check( //
        "Integrate[(b*x^2)^(1/3), x]", //
        "(3*x*(b*x^2)^(1/3))/5", //
        15,
        30);
  }

  // {15, 30}
  public void test2604() {
    check( //
        "Integrate[(b/x)^(1/3), x]", //
        "(3*(b/x)^(1/3)*x)/2", //
        15,
        30);
  }

  // {15, 30}
  public void test2605() {
    check( //
        "Integrate[(b/x^2)^(1/3), x]", //
        "3*(b/x^2)^(1/3)*x", //
        15,
        30);
  }

  // {15, 29}
  public void test2606() {
    check( //
        "Integrate[(b/x^3)^(1/3), x]", //
        "(b/x^3)^(1/3)*x*Log[x]", //
        15,
        29);
  }

  // {15, 30}
  public void test2607() {
    check( //
        "Integrate[(b/x^4)^(1/3), x]", //
        "-3*(b/x^4)^(1/3)*x", //
        15,
        30);
  }

  // {15, 30}
  public void test2608() {
    check( //
        "Integrate[(b*x^n)^(2/3), x]", //
        "(3*x*(b*x^n)^(2/3))/(3 + 2*n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2609() {
    check( //
        "Integrate[(b*x^2)^(2/3), x]", //
        "(3*x*(b*x^2)^(2/3))/7", //
        15,
        30);
  }

  // {15, 30}
  public void test2610() {
    check( //
        "Integrate[(b/x)^(2/3), x]", //
        "3*(b/x)^(2/3)*x", //
        15,
        30);
  }

  // {15, 30}
  public void test2611() {
    check( //
        "Integrate[(b/x^2)^(2/3), x]", //
        "-3*(b/x^2)^(2/3)*x", //
        15,
        30);
  }

  // {15, 30}
  public void test2612() {
    check( //
        "Integrate[(b/x^3)^(2/3), x]", //
        "-((b/x^3)^(2/3)*x)", //
        15,
        30);
  }

  // {15, 30}
  public void test2613() {
    check( //
        "Integrate[(b/x^4)^(2/3), x]", //
        "(-3*(b/x^4)^(2/3)*x)/5", //
        15,
        30);
  }

  // {15, 30}
  public void test2614() {
    check( //
        "Integrate[(b*x^n)^(-1/3), x]", //
        "(3*x)/((3 - n)*(b*x^n)^(1/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2615() {
    check( //
        "Integrate[(b*x^4)^(-1/3), x]", //
        "(-3*x)/(b*x^4)^(1/3)", //
        15,
        30);
  }

  // {15, 29}
  public void test2616() {
    check( //
        "Integrate[(b*x^3)^(-1/3), x]", //
        "(x*Log[x])/(b*x^3)^(1/3)", //
        15,
        29);
  }

  // {15, 30}
  public void test2617() {
    check( //
        "Integrate[(b*x^2)^(-1/3), x]", //
        "(3*x)/(b*x^2)^(1/3)", //
        15,
        30);
  }

  // {15, 30}
  public void test2618() {
    check( //
        "Integrate[(b/x)^(-1/3), x]", //
        "(3*x)/(4*(b/x)^(1/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2619() {
    check( //
        "Integrate[(b/x^2)^(-1/3), x]", //
        "(3*x)/(5*(b/x^2)^(1/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2620() {
    check( //
        "Integrate[(b/x^3)^(-1/3), x]", //
        "x/(2*(b/x^3)^(1/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2621() {
    check( //
        "Integrate[(b*x^n)^(-2/3), x]", //
        "(3*x)/((3 - 2*n)*(b*x^n)^(2/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2622() {
    check( //
        "Integrate[(b*x^3)^(-2/3), x]", //
        "-(x/(b*x^3)^(2/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2623() {
    check( //
        "Integrate[(b*x^2)^(-2/3), x]", //
        "(-3*x)/(b*x^2)^(2/3)", //
        15,
        30);
  }

  // {15, 30}
  public void test2624() {
    check( //
        "Integrate[(b/x)^(-2/3), x]", //
        "(3*x)/(5*(b/x)^(2/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2625() {
    check( //
        "Integrate[(b/x^2)^(-2/3), x]", //
        "(3*x)/(7*(b/x^2)^(2/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2626() {
    check( //
        "Integrate[(b/x^3)^(-2/3), x]", //
        "x/(3*(b/x^3)^(2/3))", //
        15,
        30);
  }

  // {15, 30}
  public void test2627() {
    check( //
        "Integrate[x^2*Sqrt[b*x^n], x]", //
        "(2*x^3*Sqrt[b*x^n])/(6 + n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2628() {
    check( //
        "Integrate[x*Sqrt[b*x^n], x]", //
        "(2*x^2*Sqrt[b*x^n])/(4 + n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2629() {
    check( //
        "Integrate[Sqrt[b*x^n], x]", //
        "(2*x*Sqrt[b*x^n])/(2 + n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2630() {
    check( //
        "Integrate[Sqrt[b*x^n]/x, x]", //
        "(2*Sqrt[b*x^n])/n", //
        15,
        30);
  }

  // {15, 30}
  public void test2631() {
    check( //
        "Integrate[Sqrt[b*x^n]/x^2, x]", //
        "(-2*Sqrt[b*x^n])/((2 - n)*x)", //
        15,
        30);
  }

  // {15, 30}
  public void test2632() {
    check( //
        "Integrate[Sqrt[b*x^n]/x^3, x]", //
        "(-2*Sqrt[b*x^n])/((4 - n)*x^2)", //
        15,
        30);
  }

  // {15, 30}
  public void test2633() {
    check( //
        "Integrate[x*(b*x^n)^(3/2), x]", //
        "(2*b*x^(2 + n)*Sqrt[b*x^n])/(4 + 3*n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2634() {
    check( //
        "Integrate[(b*x^n)^(3/2), x]", //
        "(2*b*x^(1 + n)*Sqrt[b*x^n])/(2 + 3*n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2635() {
    check( //
        "Integrate[(b*x^n)^(3/2)/x, x]", //
        "(2*b*x^n*Sqrt[b*x^n])/(3*n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2636() {
    check( //
        "Integrate[(b*x^n)^(3/2)/x^2, x]", //
        "(-2*b*x^(-1 + n)*Sqrt[b*x^n])/(2 - 3*n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2637() {
    check( //
        "Integrate[(b*x^n)^(3/2)/x^3, x]", //
        "(-2*b*x^(-2 + n)*Sqrt[b*x^n])/(4 - 3*n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2638() {
    check( //
        "Integrate[(b*x^n)^(3/2)/x^4, x]", //
        "(-2*b*x^(-3 + n)*Sqrt[b*x^n])/(3*(2 - n))", //
        15,
        30);
  }

  // {15, 30}
  public void test2639() {
    check( //
        "Integrate[x^2/Sqrt[b*x^n], x]", //
        "(2*x^3)/((6 - n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2640() {
    check( //
        "Integrate[x/Sqrt[b*x^n], x]", //
        "(2*x^2)/((4 - n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2641() {
    check( //
        "Integrate[1/Sqrt[b*x^n], x]", //
        "(2*x)/((2 - n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2642() {
    check( //
        "Integrate[1/(x*Sqrt[b*x^n]), x]", //
        "-2/(n*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2643() {
    check( //
        "Integrate[1/(x^2*Sqrt[b*x^n]), x]", //
        "-2/((2 + n)*x*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2644() {
    check( //
        "Integrate[1/(x^3*Sqrt[b*x^n]), x]", //
        "-2/((4 + n)*x^2*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2645() {
    check( //
        "Integrate[x^2/(b*x^n)^(3/2), x]", //
        "(2*x^(3 - n))/(3*b*(2 - n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2646() {
    check( //
        "Integrate[x/(b*x^n)^(3/2), x]", //
        "(2*x^(2 - n))/(b*(4 - 3*n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2647() {
    check( //
        "Integrate[(b*x^n)^(-3/2), x]", //
        "(2*x^(1 - n))/(b*(2 - 3*n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2648() {
    check( //
        "Integrate[1/(x*(b*x^n)^(3/2)), x]", //
        "-2/(3*b*n*x^n*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2649() {
    check( //
        "Integrate[1/(x^2*(b*x^n)^(3/2)), x]", //
        "(-2*x^(-1 - n))/(b*(2 + 3*n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2650() {
    check( //
        "Integrate[1/(x^3*(b*x^n)^(3/2)), x]", //
        "(-2*x^(-2 - n))/(b*(4 + 3*n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2651() {
    check( //
        "Integrate[1/(x^4*(b*x^n)^(3/2)), x]", //
        "(-2*x^(-3 - n))/(3*b*(2 + n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2652() {
    check( //
        "Integrate[x^m/(a*x^n)^(3/2), x]", //
        "(2*x^(1 + m - n))/(a*(2 + 2*m - 3*n)*Sqrt[a*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2653() {
    check( //
        "Integrate[x^m*(b*x^n)^(3/2), x]", //
        "(2*b*x^(1 + m + n)*Sqrt[b*x^n])/(2 + 2*m + 3*n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2654() {
    check( //
        "Integrate[x^m*Sqrt[b*x^n], x]", //
        "(2*x^(1 + m)*Sqrt[b*x^n])/(2 + 2*m + n)", //
        15,
        30);
  }

  // {15, 30}
  public void test2655() {
    check( //
        "Integrate[x^m/Sqrt[b*x^n], x]", //
        "(2*x^(1 + m))/((2 + 2*m - n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 30}
  public void test2656() {
    check( //
        "Integrate[x^m/(b*x^n)^(3/2), x]", //
        "(2*x^(1 + m - n))/(b*(2 + 2*m - 3*n)*Sqrt[b*x^n])", //
        15,
        30);
  }

  // {15, 29}
  public void test2657() {
    check( //
        "Integrate[x^(-1 - (3*n)/2)*(b*x^n)^(3/2), x]", //
        "(b*Sqrt[b*x^n]*Log[x])/x^(n/2)", //
        15,
        29);
  }

  // {15, 29}
  public void test2658() {
    check( //
        "Integrate[x^(-1 - n/2)*Sqrt[b*x^n], x]", //
        "(Sqrt[b*x^n]*Log[x])/x^(n/2)", //
        15,
        29);
  }

  // {15, 29}
  public void test2659() {
    check( //
        "Integrate[x^(-1 + n/2)/Sqrt[b*x^n], x]", //
        "(x^(n/2)*Log[x])/Sqrt[b*x^n]", //
        15,
        29);
  }

  // {15, 29}
  public void test2660() {
    check( //
        "Integrate[x^(-1 + (3*n)/2)/(b*x^n)^(3/2), x]", //
        "(x^(n/2)*Log[x])/(b*Sqrt[b*x^n])", //
        15,
        29);
  }

  // {15, 30}
  public void test2661() {
    check( //
        "Integrate[x^m*(b*x^n)^p, x]", //
        "(x^(1 + m)*(b*x^n)^p)/(1 + m + n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test2662() {
    check( //
        "Integrate[x^2*(b*x^n)^p, x]", //
        "(x^3*(b*x^n)^p)/(3 + n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test2663() {
    check( //
        "Integrate[x*(b*x^n)^p, x]", //
        "(x^2*(b*x^n)^p)/(2 + n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test2664() {
    check( //
        "Integrate[(b*x^n)^p, x]", //
        "(x*(b*x^n)^p)/(1 + n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test2665() {
    check( //
        "Integrate[(b*x^n)^p/x, x]", //
        "(b*x^n)^p/(n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test2666() {
    check( //
        "Integrate[(b*x^n)^p/x^2, x]", //
        "-((b*x^n)^p/((1 - n*p)*x))", //
        15,
        30);
  }

  // {15, 30}
  public void test2667() {
    check( //
        "Integrate[(b*x^n)^p/x^3, x]", //
        "-((b*x^n)^p/((2 - n*p)*x^2))", //
        15,
        30);
  }

  // {15, 30}
  public void test2668() {
    check( //
        "Integrate[x^m/(a*x^n)^n^(-1), x]", //
        "x^(1 + m)/(m*(a*x^n)^n^(-1))", //
        15,
        30);
  }

  // {15, 30}
  public void test2669() {
    check( //
        "Integrate[x^2/(a*x^n)^n^(-1), x]", //
        "x^3/(2*(a*x^n)^n^(-1))", //
        15,
        30);
  }

  // {15, 8}
  public void test2670() {
    check( //
        "Integrate[x/(a*x^n)^n^(-1), x]", //
        "x^2/(a*x^n)^n^(-1)", //
        15,
        8);
  }

  // {15, 29}
  public void test2671() {
    check( //
        "Integrate[(a*x^n)^(-n^(-1)), x]", //
        "(x*Log[x])/(a*x^n)^n^(-1)", //
        15,
        29);
  }

  // {15, 30}
  public void test2672() {
    check( //
        "Integrate[1/(x*(a*x^n)^n^(-1)), x]", //
        "-(a*x^n)^(-n^(-1))", //
        15,
        30);
  }

  // {15, 30}
  public void test2673() {
    check( //
        "Integrate[1/(x^2*(a*x^n)^n^(-1)), x]", //
        "-1/(2*x*(a*x^n)^n^(-1))", //
        15,
        30);
  }

  // {15, 29}
  public void test2674() {
    check( //
        "Integrate[x^m/(a*x^n)^((1 + m)/n), x]", //
        "(x^(1 + m)*Log[x])/(a*x^n)^((1 + m)/n)", //
        15,
        29);
  }

  // {15, 29}
  public void test2675() {
    check( //
        "Integrate[x^(-1 - n*p)*(a*x^n)^p, x]", //
        "((a*x^n)^p*Log[x])/x^(n*p)", //
        15,
        29);
  }

  // {1971, 30}
  public void test2676() {
    check( //
        "Integrate[x^m*(a*(b*x^n)^p)^q, x]", //
        "(x^(1 + m)*(a*(b*x^n)^p)^q)/(1 + m + n*p*q)", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2677() {
    check( //
        "Integrate[x^2*(a*(b*x^n)^p)^q, x]", //
        "(x^3*(a*(b*x^n)^p)^q)/(3 + n*p*q)", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2678() {
    check( //
        "Integrate[x*(a*(b*x^n)^p)^q, x]", //
        "(x^2*(a*(b*x^n)^p)^q)/(2 + n*p*q)", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2679() {
    check( //
        "Integrate[(a*(b*x^n)^p)^q, x]", //
        "(x*(a*(b*x^n)^p)^q)/(1 + n*p*q)", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2680() {
    check( //
        "Integrate[(a*(b*x^n)^p)^q/x, x]", //
        "(a*(b*x^n)^p)^q/(n*p*q)", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2681() {
    check( //
        "Integrate[(a*(b*x^n)^p)^q/x^2, x]", //
        "-((a*(b*x^n)^p)^q/((1 - n*p*q)*x))", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2682() {
    check( //
        "Integrate[(a*(b*x^n)^p)^q/x^3, x]", //
        "-((a*(b*x^n)^p)^q/((2 - n*p*q)*x^2))", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2683() {
    check( //
        "Integrate[x^2/(a*(b*x^m)^n)^(1/(m*n)), x]", //
        "x^3/(2*(a*(b*x^m)^n)^(1/(m*n)))", //
        1971,
        30);
  }

  // {1971, 8}
  public void test2684() {
    check( //
        "Integrate[x/(a*(b*x^m)^n)^(1/(m*n)), x]", //
        "x^2/(a*(b*x^m)^n)^(1/(m*n))", //
        1971,
        8);
  }

  // {1971, 29}
  public void test2685() {
    check( //
        "Integrate[(a*(b*x^m)^n)^(-(1/(m*n))), x]", //
        "(x*Log[x])/(a*(b*x^m)^n)^(1/(m*n))", //
        1971,
        29);
  }

  // {1971, 30}
  public void test2686() {
    check( //
        "Integrate[1/(x*(a*(b*x^m)^n)^(1/(m*n))), x]", //
        "-(a*(b*x^m)^n)^(-(1/(m*n)))", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2687() {
    check( //
        "Integrate[1/(x^2*(a*(b*x^m)^n)^(1/(m*n))), x]", //
        "-1/(2*x*(a*(b*x^m)^n)^(1/(m*n)))", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2688() {
    check( //
        "Integrate[x^(2 - n*p*q)*(a*(b*x^n)^p)^q, x]", //
        "(x^(3 - n*p*q)*(a*(b*x^n)^p)^q)/3", //
        1971,
        30);
  }

  // {1971, 30}
  public void test2689() {
    check( //
        "Integrate[x^(1 - n*p*q)*(a*(b*x^n)^p)^q, x]", //
        "(x^(2 - n*p*q)*(a*(b*x^n)^p)^q)/2", //
        1971,
        30);
  }

  // {1971, 8}
  public void test2690() {
    check( //
        "Integrate[(a*(b*x^n)^p)^q/x^(n*p*q), x]", //
        "x^(1 - n*p*q)*(a*(b*x^n)^p)^q", //
        1971,
        8);
  }

  // {1971, 29}
  public void test2691() {
    check( //
        "Integrate[x^(-1 - n*p*q)*(a*(b*x^n)^p)^q, x]", //
        "((a*(b*x^n)^p)^q*Log[x])/x^(n*p*q)", //
        1971,
        29);
  }

  // {1971, 30}
  public void test2692() {
    check( //
        "Integrate[x^(-2 - n*p*q)*(a*(b*x^n)^p)^q, x]", //
        "-(x^(-1 - n*p*q)*(a*(b*x^n)^p)^q)", //
        1971,
        30);
  }

  // {14}
  public void test2693() {
    check( //
        "Integrate[x^3*(a + b*x^3), x]", //
        "(a*x^4)/4 + (b*x^7)/7", //
        14);
  }

  // {14}
  public void test2694() {
    check( //
        "Integrate[x^2*(a + b*x^3), x]", //
        "(a*x^3)/3 + (b*x^6)/6", //
        14);
  }

  // {14}
  public void test2695() {
    check( //
        "Integrate[x*(a + b*x^3), x]", //
        "(a*x^2)/2 + (b*x^5)/5", //
        14);
  }

  // {14}
  public void test2696() {
    check( //
        "Integrate[(a + b*x^3)/x, x]", //
        "(b*x^3)/3 + a*Log[x]", //
        14);
  }

  // {14}
  public void test2697() {
    check( //
        "Integrate[(a + b*x^3)/x^2, x]", //
        "-(a/x) + (b*x^2)/2", //
        14);
  }

  // {14}
  public void test2698() {
    check( //
        "Integrate[(a + b*x^3)/x^3, x]", //
        "-a/(2*x^2) + b*x", //
        14);
  }

  // {14}
  public void test2699() {
    check( //
        "Integrate[(a + b*x^3)/x^4, x]", //
        "-a/(3*x^3) + b*Log[x]", //
        14);
  }

  // {14}
  public void test2700() {
    check( //
        "Integrate[(a + b*x^3)/x^5, x]", //
        "-a/(4*x^4) - b/x", //
        14);
  }

  // {14}
  public void test2701() {
    check( //
        "Integrate[(a + b*x^3)/x^6, x]", //
        "-a/(5*x^5) - b/(2*x^2)", //
        14);
  }

  // {14}
  public void test2702() {
    check( //
        "Integrate[(a + b*x^3)/x^7, x]", //
        "-a/(6*x^6) - b/(3*x^3)", //
        14);
  }

  // {14}
  public void test2703() {
    check( //
        "Integrate[(a + b*x^3)/x^8, x]", //
        "-a/(7*x^7) - b/(4*x^4)", //
        14);
  }

  // {276}
  public void test2704() {
    check( //
        "Integrate[x^4*(a + b*x^3)^2, x]", //
        "(a^2*x^5)/5 + (a*b*x^8)/4 + (b^2*x^11)/11", //
        276);
  }

  // {276}
  public void test2705() {
    check( //
        "Integrate[x^3*(a + b*x^3)^2, x]", //
        "(a^2*x^4)/4 + (2*a*b*x^7)/7 + (b^2*x^10)/10", //
        276);
  }

  // {276}
  public void test2706() {
    check( //
        "Integrate[x*(a + b*x^3)^2, x]", //
        "(a^2*x^2)/2 + (2*a*b*x^5)/5 + (b^2*x^8)/8", //
        276);
  }

  // {200}
  public void test2707() {
    check( //
        "Integrate[(a + b*x^3)^2, x]", //
        "a^2*x + (a*b*x^4)/2 + (b^2*x^7)/7", //
        200);
  }

  // {276}
  public void test2708() {
    check( //
        "Integrate[(a + b*x^3)^2/x^2, x]", //
        "-(a^2/x) + a*b*x^2 + (b^2*x^5)/5", //
        276);
  }

  // {276}
  public void test2709() {
    check( //
        "Integrate[(a + b*x^3)^2/x^3, x]", //
        "-a^2/(2*x^2) + 2*a*b*x + (b^2*x^4)/4", //
        276);
  }

  // {276}
  public void test2710() {
    check( //
        "Integrate[(a + b*x^3)^2/x^5, x]", //
        "-a^2/(4*x^4) - (2*a*b)/x + (b^2*x^2)/2", //
        276);
  }

  // {276}
  public void test2711() {
    check( //
        "Integrate[(a + b*x^3)^2/x^6, x]", //
        "-a^2/(5*x^5) - (a*b)/x^2 + b^2*x", //
        276);
  }

  // {276}
  public void test2712() {
    check( //
        "Integrate[(a + b*x^3)^2/x^8, x]", //
        "-a^2/(7*x^7) - (a*b)/(2*x^4) - b^2/x", //
        276);
  }

  // {276}
  public void test2713() {
    check( //
        "Integrate[(a + b*x^3)^2/x^9, x]", //
        "-a^2/(8*x^8) - (2*a*b)/(5*x^5) - b^2/(2*x^2)", //
        276);
  }

  // {276}
  public void test2714() {
    check( //
        "Integrate[(a + b*x^3)^2/x^11, x]", //
        "-a^2/(10*x^10) - (2*a*b)/(7*x^7) - b^2/(4*x^4)", //
        276);
  }

  // {276}
  public void test2715() {
    check( //
        "Integrate[(a + b*x^3)^2/x^12, x]", //
        "-a^2/(11*x^11) - (a*b)/(4*x^8) - b^2/(5*x^5)", //
        276);
  }

  // {276}
  public void test2716() {
    check( //
        "Integrate[x^4*(a + b*x^3)^3, x]", //
        "(a^3*x^5)/5 + (3*a^2*b*x^8)/8 + (3*a*b^2*x^11)/11 + (b^3*x^14)/14", //
        276);
  }

  // {276}
  public void test2717() {
    check( //
        "Integrate[x^3*(a + b*x^3)^3, x]", //
        "(a^3*x^4)/4 + (3*a^2*b*x^7)/7 + (3*a*b^2*x^10)/10 + (b^3*x^13)/13", //
        276);
  }

  // {276}
  public void test2718() {
    check( //
        "Integrate[x*(a + b*x^3)^3, x]", //
        "(a^3*x^2)/2 + (3*a^2*b*x^5)/5 + (3*a*b^2*x^8)/8 + (b^3*x^11)/11", //
        276);
  }

  // {200}
  public void test2719() {
    check( //
        "Integrate[(a + b*x^3)^3, x]", //
        "a^3*x + (3*a^2*b*x^4)/4 + (3*a*b^2*x^7)/7 + (b^3*x^10)/10", //
        200);
  }

  // {276}
  public void test2720() {
    check( //
        "Integrate[(a + b*x^3)^3/x^2, x]", //
        "-(a^3/x) + (3*a^2*b*x^2)/2 + (3*a*b^2*x^5)/5 + (b^3*x^8)/8", //
        276);
  }

  // {276}
  public void test2721() {
    check( //
        "Integrate[(a + b*x^3)^3/x^3, x]", //
        "-a^3/(2*x^2) + 3*a^2*b*x + (3*a*b^2*x^4)/4 + (b^3*x^7)/7", //
        276);
  }

  // {276}
  public void test2722() {
    check( //
        "Integrate[(a + b*x^3)^3/x^5, x]", //
        "-a^3/(4*x^4) - (3*a^2*b)/x + (3*a*b^2*x^2)/2 + (b^3*x^5)/5", //
        276);
  }

  // {276}
  public void test2723() {
    check( //
        "Integrate[(a + b*x^3)^3/x^6, x]", //
        "-a^3/(5*x^5) - (3*a^2*b)/(2*x^2) + 3*a*b^2*x + (b^3*x^4)/4", //
        276);
  }

  // {276}
  public void test2724() {
    check( //
        "Integrate[(a + b*x^3)^3/x^8, x]", //
        "-a^3/(7*x^7) - (3*a^2*b)/(4*x^4) - (3*a*b^2)/x + (b^3*x^2)/2", //
        276);
  }

  // {276}
  public void test2725() {
    check( //
        "Integrate[x^4*(a + b*x^3)^5, x]", //
        "(a^5*x^5)/5 + (5*a^4*b*x^8)/8 + (10*a^3*b^2*x^11)/11 + (5*a^2*b^3*x^14)/7 + (5*a*b^4*x^17)/17 + (b^5*x^20)/20", //
        276);
  }

  // {276}
  public void test2726() {
    check( //
        "Integrate[x^3*(a + b*x^3)^5, x]", //
        "(a^5*x^4)/4 + (5*a^4*b*x^7)/7 + a^3*b^2*x^10 + (10*a^2*b^3*x^13)/13 + (5*a*b^4*x^16)/16 + (b^5*x^19)/19", //
        276);
  }

  // {276}
  public void test2727() {
    check( //
        "Integrate[x*(a + b*x^3)^5, x]", //
        "(a^5*x^2)/2 + a^4*b*x^5 + (5*a^3*b^2*x^8)/4 + (10*a^2*b^3*x^11)/11 + (5*a*b^4*x^14)/14 + (b^5*x^17)/17", //
        276);
  }

  // {200}
  public void test2728() {
    check( //
        "Integrate[(a + b*x^3)^5, x]", //
        "a^5*x + (5*a^4*b*x^4)/4 + (10*a^3*b^2*x^7)/7 + a^2*b^3*x^10 + (5*a*b^4*x^13)/13 + (b^5*x^16)/16", //
        200);
  }

  // {276}
  public void test2729() {
    check( //
        "Integrate[(a + b*x^3)^5/x^2, x]", //
        "-(a^5/x) + (5*a^4*b*x^2)/2 + 2*a^3*b^2*x^5 + (5*a^2*b^3*x^8)/4 + (5*a*b^4*x^11)/11 + (b^5*x^14)/14", //
        276);
  }

  // {276}
  public void test2730() {
    check( //
        "Integrate[(a + b*x^3)^5/x^3, x]", //
        "-a^5/(2*x^2) + 5*a^4*b*x + (5*a^3*b^2*x^4)/2 + (10*a^2*b^3*x^7)/7 + (a*b^4*x^10)/2 + (b^5*x^13)/13", //
        276);
  }

  // {276}
  public void test2731() {
    check( //
        "Integrate[(a + b*x^3)^5/x^5, x]", //
        "-a^5/(4*x^4) - (5*a^4*b)/x + 5*a^3*b^2*x^2 + 2*a^2*b^3*x^5 + (5*a*b^4*x^8)/8 + (b^5*x^11)/11", //
        276);
  }

  // {276}
  public void test2732() {
    check( //
        "Integrate[(a + b*x^3)^5/x^6, x]", //
        "-a^5/(5*x^5) - (5*a^4*b)/(2*x^2) + 10*a^3*b^2*x + (5*a^2*b^3*x^4)/2 + (5*a*b^4*x^7)/7 + (b^5*x^10)/10", //
        276);
  }

  // {276}
  public void test2733() {
    check( //
        "Integrate[(a + b*x^3)^5/x^8, x]", //
        "-a^5/(7*x^7) - (5*a^4*b)/(4*x^4) - (10*a^3*b^2)/x + 5*a^2*b^3*x^2 + a*b^4*x^5 + (b^5*x^8)/8", //
        276);
  }

  // {276}
  public void test2734() {
    check( //
        "Integrate[(a + b*x^3)^5/x^9, x]", //
        "-a^5/(8*x^8) - (a^4*b)/x^5 - (5*a^3*b^2)/x^2 + 10*a^2*b^3*x + (5*a*b^4*x^4)/4 + (b^5*x^7)/7", //
        276);
  }

  // {276}
  public void test2735() {
    check( //
        "Integrate[x^4*(a + b*x^3)^8, x]", //
        "(a^8*x^5)/5 + a^7*b*x^8 + (28*a^6*b^2*x^11)/11 + 4*a^5*b^3*x^14 + (70*a^4*b^4*x^17)/17 + (14*a^3*b^5*x^20)/5 + (28*a^2*b^6*x^23)/23 + (4*a*b^7*x^26)/13 + (b^8*x^29)/29", //
        276);
  }

  // {276}
  public void test2736() {
    check( //
        "Integrate[x^3*(a + b*x^3)^8, x]", //
        "(a^8*x^4)/4 + (8*a^7*b*x^7)/7 + (14*a^6*b^2*x^10)/5 + (56*a^5*b^3*x^13)/13 + (35*a^4*b^4*x^16)/8 + (56*a^3*b^5*x^19)/19 + (14*a^2*b^6*x^22)/11 + (8*a*b^7*x^25)/25 + (b^8*x^28)/28", //
        276);
  }

  // {276}
  public void test2737() {
    check( //
        "Integrate[x*(a + b*x^3)^8, x]", //
        "(a^8*x^2)/2 + (8*a^7*b*x^5)/5 + (7*a^6*b^2*x^8)/2 + (56*a^5*b^3*x^11)/11 + 5*a^4*b^4*x^14 + (56*a^3*b^5*x^17)/17 + (7*a^2*b^6*x^20)/5 + (8*a*b^7*x^23)/23 + (b^8*x^26)/26", //
        276);
  }

  // {200}
  public void test2738() {
    check( //
        "Integrate[(a + b*x^3)^8, x]", //
        "a^8*x + 2*a^7*b*x^4 + 4*a^6*b^2*x^7 + (28*a^5*b^3*x^10)/5 + (70*a^4*b^4*x^13)/13 + (7*a^3*b^5*x^16)/2 + (28*a^2*b^6*x^19)/19 + (4*a*b^7*x^22)/11 + (b^8*x^25)/25", //
        200);
  }

  // {276}
  public void test2739() {
    check( //
        "Integrate[(a + b*x^3)^8/x^2, x]", //
        "-(a^8/x) + 4*a^7*b*x^2 + (28*a^6*b^2*x^5)/5 + 7*a^5*b^3*x^8 + (70*a^4*b^4*x^11)/11 + 4*a^3*b^5*x^14 + (28*a^2*b^6*x^17)/17 + (2*a*b^7*x^20)/5 + (b^8*x^23)/23", //
        276);
  }

  // {276}
  public void test2740() {
    check( //
        "Integrate[(a + b*x^3)^8/x^3, x]", //
        "-a^8/(2*x^2) + 8*a^7*b*x + 7*a^6*b^2*x^4 + 8*a^5*b^3*x^7 + 7*a^4*b^4*x^10 + (56*a^3*b^5*x^13)/13 + (7*a^2*b^6*x^16)/4 + (8*a*b^7*x^19)/19 + (b^8*x^22)/22", //
        276);
  }

  // {276}
  public void test2741() {
    check( //
        "Integrate[(a + b*x^3)^8/x^5, x]", //
        "-a^8/(4*x^4) - (8*a^7*b)/x + 14*a^6*b^2*x^2 + (56*a^5*b^3*x^5)/5 + (35*a^4*b^4*x^8)/4 + (56*a^3*b^5*x^11)/11 + 2*a^2*b^6*x^14 + (8*a*b^7*x^17)/17 + (b^8*x^20)/20", //
        276);
  }

  // {276}
  public void test2742() {
    check( //
        "Integrate[(a + b*x^3)^8/x^6, x]", //
        "-a^8/(5*x^5) - (4*a^7*b)/x^2 + 28*a^6*b^2*x + 14*a^5*b^3*x^4 + 10*a^4*b^4*x^7 + (28*a^3*b^5*x^10)/5 + (28*a^2*b^6*x^13)/13 + (a*b^7*x^16)/2 + (b^8*x^19)/19", //
        276);
  }

  // {276}
  public void test2743() {
    check( //
        "Integrate[(a + b*x^3)^8/x^8, x]", //
        "-a^8/(7*x^7) - (2*a^7*b)/x^4 - (28*a^6*b^2)/x + 28*a^5*b^3*x^2 + 14*a^4*b^4*x^5 + 7*a^3*b^5*x^8 + (28*a^2*b^6*x^11)/11 + (4*a*b^7*x^14)/7 + (b^8*x^17)/17", //
        276);
  }

  // {276}
  public void test2744() {
    check( //
        "Integrate[(a + b*x^3)^8/x^9, x]", //
        "-a^8/(8*x^8) - (8*a^7*b)/(5*x^5) - (14*a^6*b^2)/x^2 + 56*a^5*b^3*x + (35*a^4*b^4*x^4)/2 + 8*a^3*b^5*x^7 + (14*a^2*b^6*x^10)/5 + (8*a*b^7*x^13)/13 + (b^8*x^16)/16", //
        276);
  }

  // {201, 224}
  public void test2745() {
    check( //
        "Integrate[Sqrt[a + b*x^3], x]", //
        "(2*x*Sqrt[a + b*x^3])/5 + (2*3^(3/4)*Sqrt[2 + Sqrt[3]]*a*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(5*b^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        201,
        224);
  }

  // {283, 224}
  public void test2746() {
    check( //
        "Integrate[Sqrt[a + b*x^3]/x^3, x]", //
        "-Sqrt[a + b*x^3]/(2*x^2) + (3^(3/4)*Sqrt[2 + Sqrt[3]]*b^(2/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(2*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        283,
        224);
  }

  // {327, 224}
  public void test2747() {
    check( //
        "Integrate[x^3/Sqrt[a + b*x^3], x]", //
        "(2*x*Sqrt[a + b*x^3])/(5*b) - (4*Sqrt[2 + Sqrt[3]]*a*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(5*3^(1/4)*b^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        327,
        224);
  }

  // {331, 224}
  public void test2748() {
    check( //
        "Integrate[1/(x^3*Sqrt[a + b*x^3]), x]", //
        "-Sqrt[a + b*x^3]/(2*a*x^2) - (Sqrt[2 + Sqrt[3]]*b^(2/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(2*3^(1/4)*a*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        331,
        224);
  }

  // {294, 224}
  public void test2749() {
    check( //
        "Integrate[x^3/(a + b*x^3)^(3/2), x]", //
        "(-2*x)/(3*b*Sqrt[a + b*x^3]) + (4*Sqrt[2 + Sqrt[3]]*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*b^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        294,
        224);
  }

  // {205, 224}
  public void test2750() {
    check( //
        "Integrate[(a + b*x^3)^(-3/2), x]", //
        "(2*x)/(3*a*Sqrt[a + b*x^3]) + (2*Sqrt[2 + Sqrt[3]]*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*a*b^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        205,
        224);
  }

  // {327, 224}
  public void test2751() {
    check( //
        "Integrate[x^3/Sqrt[1 + x^3], x]", //
        "(2*x*Sqrt[1 + x^3])/5 - (4*Sqrt[2 + Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(5*3^(1/4)*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])", //
        327,
        224);
  }

  // {331, 224}
  public void test2752() {
    check( //
        "Integrate[1/(x^3*Sqrt[1 + x^3]), x]", //
        "-Sqrt[1 + x^3]/(2*x^2) - (Sqrt[2 + Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(2*3^(1/4)*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])", //
        331,
        224);
  }

  // {327, 224}
  public void test2753() {
    check( //
        "Integrate[x^3/Sqrt[1 - x^3], x]", //
        "(-2*x*Sqrt[1 - x^3])/5 - (4*Sqrt[2 + Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(5*3^(1/4)*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])", //
        327,
        224);
  }

  // {331, 224}
  public void test2754() {
    check( //
        "Integrate[1/(x^3*Sqrt[1 - x^3]), x]", //
        "-Sqrt[1 - x^3]/(2*x^2) - (Sqrt[2 + Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(2*3^(1/4)*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])", //
        331,
        224);
  }

  // {327, 225}
  public void test2755() {
    check( //
        "Integrate[x^3/Sqrt[-1 + x^3], x]", //
        "(2*x*Sqrt[-1 + x^3])/5 - (4*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(5*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])", //
        327,
        225);
  }

  // {331, 225}
  public void test2756() {
    check( //
        "Integrate[1/(x^3*Sqrt[-1 + x^3]), x]", //
        "Sqrt[-1 + x^3]/(2*x^2) - (Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(2*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])", //
        331,
        225);
  }

  // {327, 225}
  public void test2757() {
    check( //
        "Integrate[x^3/Sqrt[-1 - x^3], x]", //
        "(-2*x*Sqrt[-1 - x^3])/5 - (4*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(5*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])", //
        327,
        225);
  }

  // {331, 225}
  public void test2758() {
    check( //
        "Integrate[1/(x^3*Sqrt[-1 - x^3]), x]", //
        "Sqrt[-1 - x^3]/(2*x^2) - (Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(2*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])", //
        331,
        225);
  }

  // {277, 270}
  public void test2759() {
    check( //
        "Integrate[(a + b*x^3)^(1/3)/x^8, x]", //
        "-(a + b*x^3)^(4/3)/(7*a*x^7) + (3*b*(a + b*x^3)^(4/3))/(28*a^2*x^4)", //
        277,
        270);
  }

  // {201, 245}
  public void test2760() {
    check( //
        "Integrate[(a + b*x^3)^(2/3), x]", //
        "(x*(a + b*x^3)^(2/3))/3 + (2*a*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(3*Sqrt[3]*b^(1/3)) - (a*Log[-(b^(1/3)*x) + (a + b*x^3)^(1/3)])/(3*b^(1/3))", //
        201,
        245);
  }

  // {283, 245}
  public void test2761() {
    check( //
        "Integrate[(a + b*x^3)^(2/3)/x^3, x]", //
        "-(a + b*x^3)^(2/3)/(2*x^2) + (b^(2/3)*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/Sqrt[3] - (b^(2/3)*Log[-(b^(1/3)*x) + (a + b*x^3)^(1/3)])/2", //
        283,
        245);
  }

  // {277, 270}
  public void test2762() {
    check( //
        "Integrate[(a + b*x^3)^(2/3)/x^9, x]", //
        "-(a + b*x^3)^(5/3)/(8*a*x^8) + (3*b*(a + b*x^3)^(5/3))/(40*a^2*x^5)", //
        277,
        270);
  }

  // {327, 245}
  public void test2763() {
    check( //
        "Integrate[x^3/(a + b*x^3)^(1/3), x]", //
        "(x*(a + b*x^3)^(2/3))/(3*b) - (a*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(3*Sqrt[3]*b^(4/3)) + (a*Log[-(b^(1/3)*x) + (a + b*x^3)^(1/3)])/(6*b^(4/3))", //
        327,
        245);
  }

  // {277, 270}
  public void test2764() {
    check( //
        "Integrate[1/(x^6*(a + b*x^3)^(1/3)), x]", //
        "-(a + b*x^3)^(2/3)/(5*a*x^5) + (3*b*(a + b*x^3)^(2/3))/(10*a^2*x^2)", //
        277,
        270);
  }

  // {277, 270}
  public void test2765() {
    check( //
        "Integrate[1/(x^5*(a + b*x^3)^(2/3)), x]", //
        "-(a + b*x^3)^(1/3)/(4*a*x^4) + (3*b*(a + b*x^3)^(1/3))/(4*a^2*x)", //
        277,
        270);
  }

  // {276}
  public void test2766() {
    check( //
        "Integrate[x^m*(a + b*x^3)^8, x]", //
        "(a^8*x^(1 + m))/(1 + m) + (8*a^7*b*x^(4 + m))/(4 + m) + (28*a^6*b^2*x^(7 + m))/(7 + m) + (56*a^5*b^3*x^(10 + m))/(10 + m) + (70*a^4*b^4*x^(13 + m))/(13 + m) + (56*a^3*b^5*x^(16 + m))/(16 + m) + (28*a^2*b^6*x^(19 + m))/(19 + m) + (8*a*b^7*x^(22 + m))/(22 + m) + (b^8*x^(25 + m))/(25 + m)", //
        276);
  }

  // {276}
  public void test2767() {
    check( //
        "Integrate[x^m*(a + b*x^3)^5, x]", //
        "(a^5*x^(1 + m))/(1 + m) + (5*a^4*b*x^(4 + m))/(4 + m) + (10*a^3*b^2*x^(7 + m))/(7 + m) + (10*a^2*b^3*x^(10 + m))/(10 + m) + (5*a*b^4*x^(13 + m))/(13 + m) + (b^5*x^(16 + m))/(16 + m)", //
        276);
  }

  // {276}
  public void test2768() {
    check( //
        "Integrate[x^m*(a + b*x^3)^3, x]", //
        "(a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(4 + m))/(4 + m) + (3*a*b^2*x^(7 + m))/(7 + m) + (b^3*x^(10 + m))/(10 + m)", //
        276);
  }

  // {276}
  public void test2769() {
    check( //
        "Integrate[x^m*(a + b*x^3)^2, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(4 + m))/(4 + m) + (b^2*x^(7 + m))/(7 + m)", //
        276);
  }

  // {14}
  public void test2770() {
    check( //
        "Integrate[x^m*(a + b*x^3), x]", //
        "(a*x^(1 + m))/(1 + m) + (b*x^(4 + m))/(4 + m)", //
        14);
  }

  // {372, 371}
  public void test2771() {
    check( //
        "Integrate[x^m*(a + b*x^3)^(3/2), x]", //
        "(a*x^(1 + m)*Sqrt[a + b*x^3]*Hypergeometric2F1[-3/2, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/((1 + m)*Sqrt[1 + (b*x^3)/a])", //
        372,
        371);
  }

  // {372, 371}
  public void test2772() {
    check( //
        "Integrate[x^m*Sqrt[a + b*x^3], x]", //
        "(x^(1 + m)*Sqrt[a + b*x^3]*Hypergeometric2F1[-1/2, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/((1 + m)*Sqrt[1 + (b*x^3)/a])", //
        372,
        371);
  }

  // {372, 371}
  public void test2773() {
    check( //
        "Integrate[x^m/(a + b*x^3)^(3/2), x]", //
        "(x^(1 + m)*Sqrt[1 + (b*x^3)/a]*Hypergeometric2F1[3/2, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(a*(1 + m)*Sqrt[a + b*x^3])", //
        372,
        371);
  }

  // {372, 371}
  public void test2774() {
    check( //
        "Integrate[(c*x)^m*(a + b*x^3)^(4/3), x]", //
        "(a*(c*x)^(1 + m)*(a + b*x^3)^(1/3)*Hypergeometric2F1[-4/3, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(c*(1 + m)*(1 + (b*x^3)/a)^(1/3))", //
        372,
        371);
  }

  // {372, 371}
  public void test2775() {
    check( //
        "Integrate[(c*x)^m*(a + b*x^3)^p, x]", //
        "((c*x)^(1 + m)*(a + b*x^3)^p*Hypergeometric2F1[(1 + m)/3, -p, (4 + m)/3, -((b*x^3)/a)])/(c*(1 + m)*(1 + (b*x^3)/a)^p)", //
        372,
        371);
  }

  // {14}
  public void test2776() {
    check( //
        "Integrate[x^m*(a + b*x^4), x]", //
        "(a*x^(1 + m))/(1 + m) + (b*x^(5 + m))/(5 + m)", //
        14);
  }

  // {14}
  public void test2777() {
    check( //
        "Integrate[x^5*(a + b*x^4), x]", //
        "(a*x^6)/6 + (b*x^10)/10", //
        14);
  }

  // {14}
  public void test2778() {
    check( //
        "Integrate[x^4*(a + b*x^4), x]", //
        "(a*x^5)/5 + (b*x^9)/9", //
        14);
  }

  // {14}
  public void test2779() {
    check( //
        "Integrate[x^3*(a + b*x^4), x]", //
        "(a*x^4)/4 + (b*x^8)/8", //
        14);
  }

  // {14}
  public void test2780() {
    check( //
        "Integrate[x^2*(a + b*x^4), x]", //
        "(a*x^3)/3 + (b*x^7)/7", //
        14);
  }

  // {14}
  public void test2781() {
    check( //
        "Integrate[x*(a + b*x^4), x]", //
        "(a*x^2)/2 + (b*x^6)/6", //
        14);
  }

  // {14}
  public void test2782() {
    check( //
        "Integrate[(a + b*x^4)/x, x]", //
        "(b*x^4)/4 + a*Log[x]", //
        14);
  }

  // {14}
  public void test2783() {
    check( //
        "Integrate[(a + b*x^4)/x^2, x]", //
        "-(a/x) + (b*x^3)/3", //
        14);
  }

  // {14}
  public void test2784() {
    check( //
        "Integrate[(a + b*x^4)/x^3, x]", //
        "-a/(2*x^2) + (b*x^2)/2", //
        14);
  }

  // {14}
  public void test2785() {
    check( //
        "Integrate[(a + b*x^4)/x^4, x]", //
        "-a/(3*x^3) + b*x", //
        14);
  }

  // {14}
  public void test2786() {
    check( //
        "Integrate[(a + b*x^4)/x^5, x]", //
        "-a/(4*x^4) + b*Log[x]", //
        14);
  }

  // {14}
  public void test2787() {
    check( //
        "Integrate[(a + b*x^4)/x^6, x]", //
        "-a/(5*x^5) - b/x", //
        14);
  }

  // {14}
  public void test2788() {
    check( //
        "Integrate[(a + b*x^4)/x^7, x]", //
        "-a/(6*x^6) - b/(2*x^2)", //
        14);
  }

  // {14}
  public void test2789() {
    check( //
        "Integrate[(a + b*x^4)/x^8, x]", //
        "-a/(7*x^7) - b/(3*x^3)", //
        14);
  }

  // {14}
  public void test2790() {
    check( //
        "Integrate[(a + b*x^4)/x^9, x]", //
        "-a/(8*x^8) - b/(4*x^4)", //
        14);
  }

  // {14}
  public void test2791() {
    check( //
        "Integrate[(a + b*x^4)/x^10, x]", //
        "-a/(9*x^9) - b/(5*x^5)", //
        14);
  }

  // {276}
  public void test2792() {
    check( //
        "Integrate[x^m*(a + b*x^4)^2, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(5 + m))/(5 + m) + (b^2*x^(9 + m))/(9 + m)", //
        276);
  }

  // {276}
  public void test2793() {
    check( //
        "Integrate[x^5*(a + b*x^4)^2, x]", //
        "(a^2*x^6)/6 + (a*b*x^10)/5 + (b^2*x^14)/14", //
        276);
  }

  // {276}
  public void test2794() {
    check( //
        "Integrate[x^4*(a + b*x^4)^2, x]", //
        "(a^2*x^5)/5 + (2*a*b*x^9)/9 + (b^2*x^13)/13", //
        276);
  }

  // {276}
  public void test2795() {
    check( //
        "Integrate[x^2*(a + b*x^4)^2, x]", //
        "(a^2*x^3)/3 + (2*a*b*x^7)/7 + (b^2*x^11)/11", //
        276);
  }

  // {276}
  public void test2796() {
    check( //
        "Integrate[x*(a + b*x^4)^2, x]", //
        "(a^2*x^2)/2 + (a*b*x^6)/3 + (b^2*x^10)/10", //
        276);
  }

  // {200}
  public void test2797() {
    check( //
        "Integrate[(a + b*x^4)^2, x]", //
        "a^2*x + (2*a*b*x^5)/5 + (b^2*x^9)/9", //
        200);
  }

  // {276}
  public void test2798() {
    check( //
        "Integrate[(a + b*x^4)^2/x^2, x]", //
        "-(a^2/x) + (2*a*b*x^3)/3 + (b^2*x^7)/7", //
        276);
  }

  // {276}
  public void test2799() {
    check( //
        "Integrate[(a + b*x^4)^2/x^3, x]", //
        "-a^2/(2*x^2) + a*b*x^2 + (b^2*x^6)/6", //
        276);
  }

  // {276}
  public void test2800() {
    check( //
        "Integrate[(a + b*x^4)^2/x^4, x]", //
        "-a^2/(3*x^3) + 2*a*b*x + (b^2*x^5)/5", //
        276);
  }

  // {276}
  public void test2801() {
    check( //
        "Integrate[x^m*(a + b*x^4)^3, x]", //
        "(a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(5 + m))/(5 + m) + (3*a*b^2*x^(9 + m))/(9 + m) + (b^3*x^(13 + m))/(13 + m)", //
        276);
  }

  // {276}
  public void test2802() {
    check( //
        "Integrate[x^5*(a + b*x^4)^3, x]", //
        "(a^3*x^6)/6 + (3*a^2*b*x^10)/10 + (3*a*b^2*x^14)/14 + (b^3*x^18)/18", //
        276);
  }

  // {276}
  public void test2803() {
    check( //
        "Integrate[x^4*(a + b*x^4)^3, x]", //
        "(a^3*x^5)/5 + (a^2*b*x^9)/3 + (3*a*b^2*x^13)/13 + (b^3*x^17)/17", //
        276);
  }

  // {276}
  public void test2804() {
    check( //
        "Integrate[x^2*(a + b*x^4)^3, x]", //
        "(a^3*x^3)/3 + (3*a^2*b*x^7)/7 + (3*a*b^2*x^11)/11 + (b^3*x^15)/15", //
        276);
  }

  // {276}
  public void test2805() {
    check( //
        "Integrate[x*(a + b*x^4)^3, x]", //
        "(a^3*x^2)/2 + (a^2*b*x^6)/2 + (3*a*b^2*x^10)/10 + (b^3*x^14)/14", //
        276);
  }

  // {200}
  public void test2806() {
    check( //
        "Integrate[(a + b*x^4)^3, x]", //
        "a^3*x + (3*a^2*b*x^5)/5 + (a*b^2*x^9)/3 + (b^3*x^13)/13", //
        200);
  }

  // {276}
  public void test2807() {
    check( //
        "Integrate[(a + b*x^4)^3/x^2, x]", //
        "-(a^3/x) + a^2*b*x^3 + (3*a*b^2*x^7)/7 + (b^3*x^11)/11", //
        276);
  }

  // {276}
  public void test2808() {
    check( //
        "Integrate[(a + b*x^4)^3/x^3, x]", //
        "-a^3/(2*x^2) + (3*a^2*b*x^2)/2 + (a*b^2*x^6)/2 + (b^3*x^10)/10", //
        276);
  }

  // {276}
  public void test2809() {
    check( //
        "Integrate[(a + b*x^4)^3/x^4, x]", //
        "-a^3/(3*x^3) + 3*a^2*b*x + (3*a*b^2*x^5)/5 + (b^3*x^9)/9", //
        276);
  }

  // {281, 211}
  public void test2810() {
    check( //
        "Integrate[x/(a + c*x^4), x]", //
        "ArcTan[(Sqrt[c]*x^2)/Sqrt[a]]/(2*Sqrt[a]*Sqrt[c])", //
        281,
        211);
  }

  // {281, 209}
  public void test2811() {
    check( //
        "Integrate[x/(2 + 3*x^4), x]", //
        "ArcTan[Sqrt[3/2]*x^2]/(2*Sqrt[6])", //
        281,
        209);
  }

  // {281, 209}
  public void test2812() {
    check( //
        "Integrate[x/(2*a + 2*b + x^4), x]", //
        "ArcTan[x^2/(Sqrt[2]*Sqrt[a + b])]/(2*Sqrt[2]*Sqrt[a + b])", //
        281,
        209);
  }

  // {281, 209}
  public void test2813() {
    check( //
        "Integrate[x/(2*(a + b) + x^4), x]", //
        "ArcTan[x^2/(Sqrt[2]*Sqrt[a + b])]/(2*Sqrt[2]*Sqrt[a + b])", //
        281,
        209);
  }

  // {14}
  public void test2814() {
    check( //
        "Integrate[x^(5/2)*(a + c*x^4), x]", //
        "(2*a*x^(7/2))/7 + (2*c*x^(15/2))/15", //
        14);
  }

  // {14}
  public void test2815() {
    check( //
        "Integrate[x^(3/2)*(a + c*x^4), x]", //
        "(2*a*x^(5/2))/5 + (2*c*x^(13/2))/13", //
        14);
  }

  // {14}
  public void test2816() {
    check( //
        "Integrate[Sqrt[x]*(a + c*x^4), x]", //
        "(2*a*x^(3/2))/3 + (2*c*x^(11/2))/11", //
        14);
  }

  // {14}
  public void test2817() {
    check( //
        "Integrate[(a + c*x^4)/Sqrt[x], x]", //
        "2*a*Sqrt[x] + (2*c*x^(9/2))/9", //
        14);
  }

  // {14}
  public void test2818() {
    check( //
        "Integrate[(a + c*x^4)/x^(3/2), x]", //
        "(-2*a)/Sqrt[x] + (2*c*x^(7/2))/7", //
        14);
  }

  // {14}
  public void test2819() {
    check( //
        "Integrate[(a + c*x^4)/x^(5/2), x]", //
        "(-2*a)/(3*x^(3/2)) + (2*c*x^(5/2))/5", //
        14);
  }

  // {14}
  public void test2820() {
    check( //
        "Integrate[(a + c*x^4)/x^(7/2), x]", //
        "(-2*a)/(5*x^(5/2)) + (2*c*x^(3/2))/3", //
        14);
  }

  // {276}
  public void test2821() {
    check( //
        "Integrate[x^(5/2)*(a + c*x^4)^2, x]", //
        "(2*a^2*x^(7/2))/7 + (4*a*c*x^(15/2))/15 + (2*c^2*x^(23/2))/23", //
        276);
  }

  // {276}
  public void test2822() {
    check( //
        "Integrate[x^(3/2)*(a + c*x^4)^2, x]", //
        "(2*a^2*x^(5/2))/5 + (4*a*c*x^(13/2))/13 + (2*c^2*x^(21/2))/21", //
        276);
  }

  // {276}
  public void test2823() {
    check( //
        "Integrate[Sqrt[x]*(a + c*x^4)^2, x]", //
        "(2*a^2*x^(3/2))/3 + (4*a*c*x^(11/2))/11 + (2*c^2*x^(19/2))/19", //
        276);
  }

  // {276}
  public void test2824() {
    check( //
        "Integrate[(a + c*x^4)^2/Sqrt[x], x]", //
        "2*a^2*Sqrt[x] + (4*a*c*x^(9/2))/9 + (2*c^2*x^(17/2))/17", //
        276);
  }

  // {276}
  public void test2825() {
    check( //
        "Integrate[(a + c*x^4)^2/x^(3/2), x]", //
        "(-2*a^2)/Sqrt[x] + (4*a*c*x^(7/2))/7 + (2*c^2*x^(15/2))/15", //
        276);
  }

  // {276}
  public void test2826() {
    check( //
        "Integrate[(a + c*x^4)^2/x^(5/2), x]", //
        "(-2*a^2)/(3*x^(3/2)) + (4*a*c*x^(5/2))/5 + (2*c^2*x^(13/2))/13", //
        276);
  }

  // {276}
  public void test2827() {
    check( //
        "Integrate[(a + c*x^4)^2/x^(7/2), x]", //
        "(-2*a^2)/(5*x^(5/2)) + (4*a*c*x^(3/2))/3 + (2*c^2*x^(11/2))/11", //
        276);
  }

  // {276}
  public void test2828() {
    check( //
        "Integrate[x^(5/2)*(a + c*x^4)^3, x]", //
        "(2*a^3*x^(7/2))/7 + (2*a^2*c*x^(15/2))/5 + (6*a*c^2*x^(23/2))/23 + (2*c^3*x^(31/2))/31", //
        276);
  }

  // {276}
  public void test2829() {
    check( //
        "Integrate[x^(3/2)*(a + c*x^4)^3, x]", //
        "(2*a^3*x^(5/2))/5 + (6*a^2*c*x^(13/2))/13 + (2*a*c^2*x^(21/2))/7 + (2*c^3*x^(29/2))/29", //
        276);
  }

  // {276}
  public void test2830() {
    check( //
        "Integrate[Sqrt[x]*(a + c*x^4)^3, x]", //
        "(2*a^3*x^(3/2))/3 + (6*a^2*c*x^(11/2))/11 + (6*a*c^2*x^(19/2))/19 + (2*c^3*x^(27/2))/27", //
        276);
  }

  // {276}
  public void test2831() {
    check( //
        "Integrate[(a + c*x^4)^3/Sqrt[x], x]", //
        "2*a^3*Sqrt[x] + (2*a^2*c*x^(9/2))/3 + (6*a*c^2*x^(17/2))/17 + (2*c^3*x^(25/2))/25", //
        276);
  }

  // {276}
  public void test2832() {
    check( //
        "Integrate[(a + c*x^4)^3/x^(3/2), x]", //
        "(-2*a^3)/Sqrt[x] + (6*a^2*c*x^(7/2))/7 + (2*a*c^2*x^(15/2))/5 + (2*c^3*x^(23/2))/23", //
        276);
  }

  // {276}
  public void test2833() {
    check( //
        "Integrate[(a + c*x^4)^3/x^(5/2), x]", //
        "(-2*a^3)/(3*x^(3/2)) + (6*a^2*c*x^(5/2))/5 + (6*a*c^2*x^(13/2))/13 + (2*c^3*x^(21/2))/21", //
        276);
  }

  // {276}
  public void test2834() {
    check( //
        "Integrate[(a + c*x^4)^3/x^(7/2), x]", //
        "(-2*a^3)/(5*x^(5/2)) + 2*a^2*c*x^(3/2) + (6*a*c^2*x^(11/2))/11 + (2*c^3*x^(19/2))/19", //
        276);
  }

  // {277, 270}
  public void test2835() {
    check( //
        "Integrate[Sqrt[a + c*x^4]/x^11, x]", //
        "-(a + c*x^4)^(3/2)/(10*a*x^10) + (c*(a + c*x^4)^(3/2))/(15*a^2*x^6)", //
        277,
        270);
  }

  // {201, 226}
  public void test2836() {
    check( //
        "Integrate[Sqrt[a + c*x^4], x]", //
        "(x*Sqrt[a + c*x^4])/3 + (a^(3/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(3*c^(1/4)*Sqrt[a + c*x^4])", //
        201,
        226);
  }

  // {283, 226}
  public void test2837() {
    check( //
        "Integrate[Sqrt[a + c*x^4]/x^4, x]", //
        "-Sqrt[a + c*x^4]/(3*x^3) + (c^(3/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(3*a^(1/4)*Sqrt[a + c*x^4])", //
        283,
        226);
  }

  // {277, 270}
  public void test2838() {
    check( //
        "Integrate[(a + c*x^4)^(3/2)/x^15, x]", //
        "-(a + c*x^4)^(5/2)/(14*a*x^14) + (c*(a + c*x^4)^(5/2))/(35*a^2*x^10)", //
        277,
        270);
  }

  // {201, 226}
  public void test2839() {
    check( //
        "Integrate[Sqrt[1 + x^4], x]", //
        "(x*Sqrt[1 + x^4])/3 + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(3*Sqrt[1 + x^4])", //
        201,
        226);
  }

  // {201, 227}
  public void test2840() {
    check( //
        "Integrate[Sqrt[1 - x^4], x]", //
        "(x*Sqrt[1 - x^4])/3 + (2*EllipticF[ArcSin[x], -1])/3", //
        201,
        227);
  }

  // {277, 270}
  public void test2841() {
    check( //
        "Integrate[1/(x^7*Sqrt[a + b*x^4]), x]", //
        "-Sqrt[a + b*x^4]/(6*a*x^6) + (b*Sqrt[a + b*x^4])/(3*a^2*x^2)", //
        277,
        270);
  }

  // {327, 226}
  public void test2842() {
    check( //
        "Integrate[x^4/Sqrt[a + b*x^4], x]", //
        "(x*Sqrt[a + b*x^4])/(3*b) - (a^(3/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(6*b^(5/4)*Sqrt[a + b*x^4])", //
        327,
        226);
  }

  // {331, 226}
  public void test2843() {
    check( //
        "Integrate[1/(x^4*Sqrt[a + b*x^4]), x]", //
        "-Sqrt[a + b*x^4]/(3*a*x^3) - (b^(3/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(6*a^(5/4)*Sqrt[a + b*x^4])", //
        331,
        226);
  }

  // {277, 270}
  public void test2844() {
    check( //
        "Integrate[1/(x^7*Sqrt[a - b*x^4]), x]", //
        "-Sqrt[a - b*x^4]/(6*a*x^6) - (b*Sqrt[a - b*x^4])/(3*a^2*x^2)", //
        277,
        270);
  }

  // {230, 227}
  public void test2845() {
    check( //
        "Integrate[1/Sqrt[a - b*x^4], x]", //
        "(a^(1/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(b^(1/4)*Sqrt[a - b*x^4])", //
        230,
        227);
  }

  // {277, 270}
  public void test2846() {
    check( //
        "Integrate[1/(x^3*(a + b*x^4)^(3/2)), x]", //
        "-1/(2*a*x^2*Sqrt[a + b*x^4]) - (b*x^2)/(a^2*Sqrt[a + b*x^4])", //
        277,
        270);
  }

  // {294, 226}
  public void test2847() {
    check( //
        "Integrate[x^4/(a + b*x^4)^(3/2), x]", //
        "-x/(2*b*Sqrt[a + b*x^4]) + ((Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(4*a^(1/4)*b^(5/4)*Sqrt[a + b*x^4])", //
        294,
        226);
  }

  // {205, 226}
  public void test2848() {
    check( //
        "Integrate[(a + b*x^4)^(-3/2), x]", //
        "x/(2*a*Sqrt[a + b*x^4]) + ((Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(4*a^(5/4)*b^(1/4)*Sqrt[a + b*x^4])", //
        205,
        226);
  }

  // {281, 222}
  public void test2849() {
    check( //
        "Integrate[x/Sqrt[1 - x^4], x]", //
        "ArcSin[x^2]/2", //
        281,
        222);
  }

  // {277, 270}
  public void test2850() {
    check( //
        "Integrate[1/(x^7*Sqrt[1 - x^4]), x]", //
        "-Sqrt[1 - x^4]/(6*x^6) - Sqrt[1 - x^4]/(3*x^2)", //
        277,
        270);
  }

  // {327, 227}
  public void test2851() {
    check( //
        "Integrate[x^4/Sqrt[1 - x^4], x]", //
        "-(x*Sqrt[1 - x^4])/3 + EllipticF[ArcSin[x], -1]/3", //
        327,
        227);
  }

  // {331, 227}
  public void test2852() {
    check( //
        "Integrate[1/(x^4*Sqrt[1 - x^4]), x]", //
        "-Sqrt[1 - x^4]/(3*x^3) + EllipticF[ArcSin[x], -1]/3", //
        331,
        227);
  }

  // {277, 270}
  public void test2853() {
    check( //
        "Integrate[1/(x^3*(1 - x^4)^(3/2)), x]", //
        "-1/(2*x^2*Sqrt[1 - x^4]) + x^2/Sqrt[1 - x^4]", //
        277,
        270);
  }

  // {294, 227}
  public void test2854() {
    check( //
        "Integrate[x^4/(1 - x^4)^(3/2), x]", //
        "x/(2*Sqrt[1 - x^4]) - EllipticF[ArcSin[x], -1]/2", //
        294,
        227);
  }

  // {205, 227}
  public void test2855() {
    check( //
        "Integrate[(1 - x^4)^(-3/2), x]", //
        "x/(2*Sqrt[1 - x^4]) + EllipticF[ArcSin[x], -1]/2", //
        205,
        227);
  }

  // {281, 221}
  public void test2856() {
    check( //
        "Integrate[x/Sqrt[1 + x^4], x]", //
        "ArcSinh[x^2]/2", //
        281,
        221);
  }

  // {277, 270}
  public void test2857() {
    check( //
        "Integrate[1/(x^7*Sqrt[1 + x^4]), x]", //
        "-Sqrt[1 + x^4]/(6*x^6) + Sqrt[1 + x^4]/(3*x^2)", //
        277,
        270);
  }

  // {327, 226}
  public void test2858() {
    check( //
        "Integrate[x^4/Sqrt[1 + x^4], x]", //
        "(x*Sqrt[1 + x^4])/3 - ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(6*Sqrt[1 + x^4])", //
        327,
        226);
  }

  // {331, 226}
  public void test2859() {
    check( //
        "Integrate[1/(x^4*Sqrt[1 + x^4]), x]", //
        "-Sqrt[1 + x^4]/(3*x^3) - ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(6*Sqrt[1 + x^4])", //
        331,
        226);
  }

  // {277, 270}
  public void test2860() {
    check( //
        "Integrate[1/(x^3*(1 + x^4)^(3/2)), x]", //
        "-1/(2*x^2*Sqrt[1 + x^4]) - x^2/Sqrt[1 + x^4]", //
        277,
        270);
  }

  // {294, 226}
  public void test2861() {
    check( //
        "Integrate[x^4/(1 + x^4)^(3/2), x]", //
        "-x/(2*Sqrt[1 + x^4]) + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(4*Sqrt[1 + x^4])", //
        294,
        226);
  }

  // {205, 226}
  public void test2862() {
    check( //
        "Integrate[(1 + x^4)^(-3/2), x]", //
        "x/(2*Sqrt[1 + x^4]) + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(4*Sqrt[1 + x^4])", //
        205,
        226);
  }

  // {281, 222}
  public void test2863() {
    check( //
        "Integrate[x/Sqrt[16 - x^4], x]", //
        "ArcSin[x^2/4]/2", //
        281,
        222);
  }

  // {277, 270}
  public void test2864() {
    check( //
        "Integrate[1/(x^7*Sqrt[16 - x^4]), x]", //
        "-Sqrt[16 - x^4]/(96*x^6) - Sqrt[16 - x^4]/(768*x^2)", //
        277,
        270);
  }

  // {327, 227}
  public void test2865() {
    check( //
        "Integrate[x^4/Sqrt[16 - x^4], x]", //
        "-(x*Sqrt[16 - x^4])/3 + (8*EllipticF[ArcSin[x/2], -1])/3", //
        327,
        227);
  }

  // {331, 227}
  public void test2866() {
    check( //
        "Integrate[1/(x^4*Sqrt[16 - x^4]), x]", //
        "-Sqrt[16 - x^4]/(48*x^3) + EllipticF[ArcSin[x/2], -1]/96", //
        331,
        227);
  }

  // {281, 221}
  public void test2867() {
    check( //
        "Integrate[x/Sqrt[4 + x^4], x]", //
        "ArcSinh[x^2/2]/2", //
        281,
        221);
  }

  // {327, 228}
  public void test2868() {
    check( //
        "Integrate[x^4/Sqrt[-1 + x^4], x]", //
        "(x*Sqrt[-1 + x^4])/3 + (Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(3*Sqrt[2]*Sqrt[-1 + x^4])", //
        327,
        228);
  }

  // {331, 228}
  public void test2869() {
    check( //
        "Integrate[1/(x^4*Sqrt[-1 + x^4]), x]", //
        "Sqrt[-1 + x^4]/(3*x^3) + (Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(3*Sqrt[2]*Sqrt[-1 + x^4])", //
        331,
        228);
  }

  // {277, 270}
  public void test2870() {
    check( //
        "Integrate[(a + b*x^4)^(1/4)/x^10, x]", //
        "-(a + b*x^4)^(5/4)/(9*a*x^9) + (4*b*(a + b*x^4)^(5/4))/(45*a^2*x^5)", //
        277,
        270);
  }

  // {277, 270}
  public void test2871() {
    check( //
        "Integrate[(a + b*x^4)^(3/4)/x^12, x]", //
        "-(a + b*x^4)^(7/4)/(11*a*x^11) + (4*b*(a + b*x^4)^(7/4))/(77*a^2*x^7)", //
        277,
        270);
  }

  // {277, 270}
  public void test2872() {
    check( //
        "Integrate[(a + b*x^4)^(5/4)/x^14, x]", //
        "-(a + b*x^4)^(9/4)/(13*a*x^13) + (4*b*(a + b*x^4)^(9/4))/(117*a^2*x^9)", //
        277,
        270);
  }

  // {277, 270}
  public void test2873() {
    check( //
        "Integrate[1/(x^8*(a + b*x^4)^(1/4)), x]", //
        "-(a + b*x^4)^(3/4)/(7*a*x^7) + (4*b*(a + b*x^4)^(3/4))/(21*a^2*x^3)", //
        277,
        270);
  }

  // {277, 270}
  public void test2874() {
    check( //
        "Integrate[1/(x^6*(a + b*x^4)^(3/4)), x]", //
        "-(a + b*x^4)^(1/4)/(5*a*x^5) + (4*b*(a + b*x^4)^(1/4))/(5*a^2*x)", //
        277,
        270);
  }

  // {277, 197}
  public void test2875() {
    check( //
        "Integrate[1/(x^4*(a + b*x^4)^(5/4)), x]", //
        "-1/(3*a*x^3*(a + b*x^4)^(1/4)) - (4*b*x)/(3*a^2*(a + b*x^4)^(1/4))", //
        277,
        197);
  }

  // {198, 197}
  public void test2876() {
    check( //
        "Integrate[(a + b*x^4)^(-9/4), x]", //
        "x/(5*a*(a + b*x^4)^(5/4)) + (4*x)/(5*a^2*(a + b*x^4)^(1/4))", //
        198,
        197);
  }

  // {277, 270}
  public void test2877() {
    check( //
        "Integrate[(a - b*x^4)^(1/4)/x^10, x]", //
        "-(a - b*x^4)^(5/4)/(9*a*x^9) - (4*b*(a - b*x^4)^(5/4))/(45*a^2*x^5)", //
        277,
        270);
  }

  // {277, 270}
  public void test2878() {
    check( //
        "Integrate[1/(x^8*(a - b*x^4)^(1/4)), x]", //
        "-(a - b*x^4)^(3/4)/(7*a*x^7) - (4*b*(a - b*x^4)^(3/4))/(21*a^2*x^3)", //
        277,
        270);
  }

  // {277, 270}
  public void test2879() {
    check( //
        "Integrate[1/(x^6*(a - b*x^4)^(3/4)), x]", //
        "-(a - b*x^4)^(1/4)/(5*a*x^5) - (4*b*(a - b*x^4)^(1/4))/(5*a^2*x)", //
        277,
        270);
  }

  // {272, 67}
  public void test2880() {
    check( //
        "Integrate[(a + b*x^4)^p/x, x]", //
        "-((a + b*x^4)^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*x^4)/a])/(4*a*(1 + p))", //
        272,
        67);
  }

  // {277, 270}
  public void test2881() {
    check( //
        "Integrate[1/(x^(17/2)*Sqrt[a + b*x^5]), x]", //
        "(-2*Sqrt[a + b*x^5])/(15*a*x^(15/2)) + (4*b*Sqrt[a + b*x^5])/(15*a^2*x^(5/2))", //
        277,
        270);
  }

  // {277, 270}
  public void test2882() {
    check( //
        "Integrate[1/(x^(17/2)*Sqrt[1 + x^5]), x]", //
        "(-2*Sqrt[1 + x^5])/(15*x^(15/2)) + (4*Sqrt[1 + x^5])/(15*x^(5/2))", //
        277,
        270);
  }

  // {281, 211}
  public void test2883() {
    check( //
        "Integrate[x^2/(a + b*x^6), x]", //
        "ArcTan[(Sqrt[b]*x^3)/Sqrt[a]]/(3*Sqrt[a]*Sqrt[b])", //
        281,
        211);
  }

  // {281, 212}
  public void test2884() {
    check( //
        "Integrate[x^2/(1 - x^6), x]", //
        "ArcTanh[x^3]/3", //
        281,
        212);
  }

  // {281, 209}
  public void test2885() {
    check( //
        "Integrate[x^2/(1 + x^6), x]", //
        "ArcTan[x^3]/3", //
        281,
        209);
  }

  // {281, 221}
  public void test2886() {
    check( //
        "Integrate[x^2/Sqrt[2 + x^6], x]", //
        "ArcSinh[x^3/Sqrt[2]]/3", //
        281,
        221);
  }

  // {277, 270}
  public void test2887() {
    check( //
        "Integrate[1/(x^10*Sqrt[2 + x^6]), x]", //
        "-Sqrt[2 + x^6]/(18*x^9) + Sqrt[2 + x^6]/(18*x^3)", //
        277,
        270);
  }

  // {281, 224}
  public void test2888() {
    check( //
        "Integrate[x/Sqrt[2 + x^6], x]", //
        "(Sqrt[2 + Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(2^(1/6)*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])", //
        281,
        224);
  }

  // {327, 231}
  public void test2889() {
    check( //
        "Integrate[x^6/Sqrt[2 + x^6], x]", //
        "(x*Sqrt[2 + x^6])/4 - (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (2 + Sqrt[3])/4])/(4*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])", //
        327,
        231);
  }

  // {331, 231}
  public void test2890() {
    check( //
        "Integrate[1/(x^6*Sqrt[2 + x^6]), x]", //
        "-Sqrt[2 + x^6]/(10*x^5) - (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (2 + Sqrt[3])/4])/(10*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])", //
        331,
        231);
  }

  // {277, 270}
  public void test2891() {
    check( //
        "Integrate[1/(x^4*(2 + x^6)^(3/2)), x]", //
        "-1/(6*x^3*Sqrt[2 + x^6]) - x^3/(6*Sqrt[2 + x^6])", //
        277,
        270);
  }

  // {294, 231}
  public void test2892() {
    check( //
        "Integrate[x^6/(2 + x^6)^(3/2), x]", //
        "-x/(3*Sqrt[2 + x^6]) + (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (2 + Sqrt[3])/4])/(6*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])", //
        294,
        231);
  }

  // {205, 231}
  public void test2893() {
    check( //
        "Integrate[(2 + x^6)^(-3/2), x]", //
        "x/(6*Sqrt[2 + x^6]) + (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (2 + Sqrt[3])/4])/(6*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])", //
        205,
        231);
  }

  // {14}
  public void test2894() {
    check( //
        "Integrate[x^m*(a + b*x^7), x]", //
        "(a*x^(1 + m))/(1 + m) + (b*x^(8 + m))/(8 + m)", //
        14);
  }

  // {14}
  public void test2895() {
    check( //
        "Integrate[x^8*(a + b*x^7), x]", //
        "(a*x^9)/9 + (b*x^16)/16", //
        14);
  }

  // {14}
  public void test2896() {
    check( //
        "Integrate[(a + b*x^7)/x^8, x]", //
        "-a/(7*x^7) + b*Log[x]", //
        14);
  }

  // {276}
  public void test2897() {
    check( //
        "Integrate[x^m*(a + b*x^7)^2, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(8 + m))/(8 + m) + (b^2*x^(15 + m))/(15 + m)", //
        276);
  }

  // {276}
  public void test2898() {
    check( //
        "Integrate[x^8*(a + b*x^7)^2, x]", //
        "(a^2*x^9)/9 + (a*b*x^16)/8 + (b^2*x^23)/23", //
        276);
  }

  // {281, 211}
  public void test2899() {
    check( //
        "Integrate[x^3/(a + b*x^8), x]", //
        "ArcTan[(Sqrt[b]*x^4)/Sqrt[a]]/(4*Sqrt[a]*Sqrt[b])", //
        281,
        211);
  }

  // {281, 212}
  public void test2900() {
    check( //
        "Integrate[x^3/(1 - x^8), x]", //
        "ArcTanh[x^4]/4", //
        281,
        212);
  }

  // {281, 209}
  public void test2901() {
    check( //
        "Integrate[x^3/(1 + x^8), x]", //
        "ArcTan[x^4]/4", //
        281,
        209);
  }

  // {281, 221}
  public void test2902() {
    check( //
        "Integrate[x^3/Sqrt[1 + x^8], x]", //
        "ArcSinh[x^4]/4", //
        281,
        221);
  }

  // {277, 270}
  public void test2903() {
    check( //
        "Integrate[1/(x^13*Sqrt[1 + x^8]), x]", //
        "-Sqrt[1 + x^8]/(12*x^12) + Sqrt[1 + x^8]/(6*x^4)", //
        277,
        270);
  }

  // {281, 226}
  public void test2904() {
    check( //
        "Integrate[x/Sqrt[1 + x^8], x]", //
        "((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(4*Sqrt[1 + x^8])", //
        281,
        226);
  }

  // {331, 371}
  public void test2905() {
    check( //
        "Integrate[1/(x^2*Sqrt[1 + x^8]), x]", //
        "-(Sqrt[1 + x^8]/x) + (3*x^7*Hypergeometric2F1[1/2, 7/8, 15/8, -x^8])/7", //
        331,
        371);
  }

  // {331, 371}
  public void test2906() {
    check( //
        "Integrate[1/(x^4*Sqrt[1 + x^8]), x]", //
        "-Sqrt[1 + x^8]/(3*x^3) + (x^5*Hypergeometric2F1[1/2, 5/8, 13/8, -x^8])/15", //
        331,
        371);
  }

  // {281, 222}
  public void test2907() {
    check( //
        "Integrate[x^4/Sqrt[1 - x^10], x]", //
        "ArcSin[x^5]/5", //
        281,
        222);
  }

  // {281, 209}
  public void test2908() {
    check( //
        "Integrate[x^5/(9 + x^12), x]", //
        "ArcTan[x^6/3]/18", //
        281,
        209);
  }

  // {281, 212}
  public void test2909() {
    check( //
        "Integrate[x^5/(9 - x^12), x]", //
        "ArcTanh[x^6/3]/18", //
        281,
        212);
  }

  // {14}
  public void test2910() {
    check( //
        "Integrate[(a + b/x)*x^6, x]", //
        "(b*x^6)/6 + (a*x^7)/7", //
        14);
  }

  // {14}
  public void test2911() {
    check( //
        "Integrate[(a + b/x)*x^5, x]", //
        "(b*x^5)/5 + (a*x^6)/6", //
        14);
  }

  // {14}
  public void test2912() {
    check( //
        "Integrate[(a + b/x)*x^4, x]", //
        "(b*x^4)/4 + (a*x^5)/5", //
        14);
  }

  // {14}
  public void test2913() {
    check( //
        "Integrate[(a + b/x)*x^3, x]", //
        "(b*x^3)/3 + (a*x^4)/4", //
        14);
  }

  // {14}
  public void test2914() {
    check( //
        "Integrate[(a + b/x)*x^2, x]", //
        "(b*x^2)/2 + (a*x^3)/3", //
        14);
  }

  // {14}
  public void test2915() {
    check( //
        "Integrate[(a + b/x)*x, x]", //
        "b*x + (a*x^2)/2", //
        14);
  }

  // {14}
  public void test2916() {
    check( //
        "Integrate[(a + b/x)/x, x]", //
        "-(b/x) + a*Log[x]", //
        14);
  }

  // {14}
  public void test2917() {
    check( //
        "Integrate[(a + b/x)/x^2, x]", //
        "-b/(2*x^2) - a/x", //
        14);
  }

  // {14}
  public void test2918() {
    check( //
        "Integrate[(a + b/x)/x^3, x]", //
        "-b/(3*x^3) - a/(2*x^2)", //
        14);
  }

  // {14}
  public void test2919() {
    check( //
        "Integrate[(a + b/x)/x^4, x]", //
        "-b/(4*x^4) - a/(3*x^3)", //
        14);
  }

  // {14}
  public void test2920() {
    check( //
        "Integrate[(a + b/x)/x^5, x]", //
        "-b/(5*x^5) - a/(4*x^4)", //
        14);
  }

  // {14}
  public void test2921() {
    check( //
        "Integrate[(a + b/x)/x^6, x]", //
        "-b/(6*x^6) - a/(5*x^5)", //
        14);
  }

  // {269, 32}
  public void test2922() {
    check( //
        "Integrate[(a + b/x)^2*x^2, x]", //
        "(b + a*x)^3/(3*a)", //
        269,
        32);
  }

  // {269, 32}
  public void test2923() {
    check( //
        "Integrate[(a + b/x)^3*x^3, x]", //
        "(b + a*x)^4/(4*a)", //
        269,
        32);
  }

  // {269, 32}
  public void test2924() {
    check( //
        "Integrate[(a + b/x)^8*x^8, x]", //
        "(b + a*x)^9/(9*a)", //
        269,
        32);
  }

  // {269, 31}
  public void test2925() {
    check( //
        "Integrate[1/((a + b/x)*x), x]", //
        "Log[b + a*x]/a", //
        269,
        31);
  }

  // {269, 32}
  public void test2926() {
    check( //
        "Integrate[1/((a + b/x)^3*x^3), x]", //
        "-1/(2*a*(b + a*x)^2)", //
        269,
        32);
  }

  // {14}
  public void test2927() {
    check( //
        "Integrate[(a + b/x)*x^(5/2), x]", //
        "(2*b*x^(5/2))/5 + (2*a*x^(7/2))/7", //
        14);
  }

  // {14}
  public void test2928() {
    check( //
        "Integrate[(a + b/x)*x^(3/2), x]", //
        "(2*b*x^(3/2))/3 + (2*a*x^(5/2))/5", //
        14);
  }

  // {14}
  public void test2929() {
    check( //
        "Integrate[(a + b/x)*Sqrt[x], x]", //
        "2*b*Sqrt[x] + (2*a*x^(3/2))/3", //
        14);
  }

  // {14}
  public void test2930() {
    check( //
        "Integrate[(a + b/x)/Sqrt[x], x]", //
        "(-2*b)/Sqrt[x] + 2*a*Sqrt[x]", //
        14);
  }

  // {14}
  public void test2931() {
    check( //
        "Integrate[(a + b/x)/x^(3/2), x]", //
        "(-2*b)/(3*x^(3/2)) - (2*a)/Sqrt[x]", //
        14);
  }

  // {14}
  public void test2932() {
    check( //
        "Integrate[(a + b/x)/x^(5/2), x]", //
        "(-2*b)/(5*x^(5/2)) - (2*a)/(3*x^(3/2))", //
        14);
  }

  // {277, 270}
  public void test2933() {
    check( //
        "Integrate[Sqrt[a + b/x]*x^(3/2), x]", //
        "(-4*b*(a + b/x)^(3/2)*x^(3/2))/(15*a^2) + (2*(a + b/x)^(3/2)*x^(5/2))/(5*a)", //
        277,
        270);
  }

  // {277, 270}
  public void test2934() {
    check( //
        "Integrate[(a + b/x)^(3/2)*x^(5/2), x]", //
        "(-4*b*(a + b/x)^(5/2)*x^(5/2))/(35*a^2) + (2*(a + b/x)^(5/2)*x^(7/2))/(7*a)", //
        277,
        270);
  }

  // {277, 270}
  public void test2935() {
    check( //
        "Integrate[(a + b/x)^(5/2)*x^(7/2), x]", //
        "(-4*b*(a + b/x)^(7/2)*x^(7/2))/(63*a^2) + (2*(a + b/x)^(7/2)*x^(9/2))/(9*a)", //
        277,
        270);
  }

  // {277, 270}
  public void test2936() {
    check( //
        "Integrate[Sqrt[x]/Sqrt[a + b/x], x]", //
        "(-4*b*Sqrt[a + b/x]*Sqrt[x])/(3*a^2) + (2*Sqrt[a + b/x]*x^(3/2))/(3*a)", //
        277,
        270);
  }

  // {277, 270}
  public void test2937() {
    check( //
        "Integrate[1/((a + b/x)^(3/2)*Sqrt[x]), x]", //
        "(4*b)/(a^2*Sqrt[a + b/x]*Sqrt[x]) + (2*Sqrt[x])/(a*Sqrt[a + b/x])", //
        277,
        270);
  }

  // {277, 270}
  public void test2938() {
    check( //
        "Integrate[1/((a + b/x)^(5/2)*x^(3/2)), x]", //
        "(-4*b)/(3*a^2*(a + b/x)^(3/2)*x^(3/2)) - 2/(a*(a + b/x)^(3/2)*Sqrt[x])", //
        277,
        270);
  }

  // {14}
  public void test2939() {
    check( //
        "Integrate[(a + b/x^2)*x^6, x]", //
        "(b*x^5)/5 + (a*x^7)/7", //
        14);
  }

  // {14}
  public void test2940() {
    check( //
        "Integrate[(a + b/x^2)*x^5, x]", //
        "(b*x^4)/4 + (a*x^6)/6", //
        14);
  }

  // {14}
  public void test2941() {
    check( //
        "Integrate[(a + b/x^2)*x^4, x]", //
        "(b*x^3)/3 + (a*x^5)/5", //
        14);
  }

  // {14}
  public void test2942() {
    check( //
        "Integrate[(a + b/x^2)*x^3, x]", //
        "(b*x^2)/2 + (a*x^4)/4", //
        14);
  }

  // {14}
  public void test2943() {
    check( //
        "Integrate[(a + b/x^2)*x^2, x]", //
        "b*x + (a*x^3)/3", //
        14);
  }

  // {14}
  public void test2944() {
    check( //
        "Integrate[(a + b/x^2)*x, x]", //
        "(a*x^2)/2 + b*Log[x]", //
        14);
  }

  // {14}
  public void test2945() {
    check( //
        "Integrate[(a + b/x^2)/x, x]", //
        "-b/(2*x^2) + a*Log[x]", //
        14);
  }

  // {14}
  public void test2946() {
    check( //
        "Integrate[(a + b/x^2)/x^2, x]", //
        "-b/(3*x^3) - a/x", //
        14);
  }

  // {14}
  public void test2947() {
    check( //
        "Integrate[(a + b/x^2)/x^3, x]", //
        "-b/(4*x^4) - a/(2*x^2)", //
        14);
  }

  // {14}
  public void test2948() {
    check( //
        "Integrate[(a + b/x^2)/x^4, x]", //
        "-b/(5*x^5) - a/(3*x^3)", //
        14);
  }

  // {14}
  public void test2949() {
    check( //
        "Integrate[(a + b/x^2)/x^5, x]", //
        "-b/(6*x^6) - a/(4*x^4)", //
        14);
  }

  // {14}
  public void test2950() {
    check( //
        "Integrate[(a + b/x^2)/x^6, x]", //
        "-b/(7*x^7) - a/(5*x^5)", //
        14);
  }

  // {269, 267}
  public void test2951() {
    check( //
        "Integrate[(a + b/x^2)^2*x^5, x]", //
        "(b + a*x^2)^3/(6*a)", //
        269,
        267);
  }

  // {269, 266}
  public void test2952() {
    check( //
        "Integrate[1/((a + b/x^2)*x), x]", //
        "Log[b + a*x^2]/(2*a)", //
        269,
        266);
  }

  // {269, 211}
  public void test2953() {
    check( //
        "Integrate[1/((a + b/x^2)*x^2), x]", //
        "ArcTan[(Sqrt[a]*x)/Sqrt[b]]/(Sqrt[a]*Sqrt[b])", //
        269,
        211);
  }

  // {269, 267}
  public void test2954() {
    check( //
        "Integrate[1/((a + b/x^2)^3*x^5), x]", //
        "-1/(4*a*(b + a*x^2)^2)", //
        269,
        267);
  }

  // {277, 197}
  public void test2955() {
    check( //
        "Integrate[x^2/Sqrt[a + b/x^2], x]", //
        "(-2*b*Sqrt[a + b/x^2]*x)/(3*a^2) + (Sqrt[a + b/x^2]*x^3)/(3*a)", //
        277,
        197);
  }

  // {342, 221}
  public void test2956() {
    check( //
        "Integrate[1/(Sqrt[2 + b/x^2]*x^2), x]", //
        "-(ArcCsch[(Sqrt[2]*x)/Sqrt[b]]/Sqrt[b])", //
        342,
        221);
  }

  // {342, 222}
  public void test2957() {
    check( //
        "Integrate[1/(Sqrt[2 - b/x^2]*x^2), x]", //
        "-(ArcCsc[(Sqrt[2]*x)/Sqrt[b]]/Sqrt[b])", //
        342,
        222);
  }

  // {198, 197}
  public void test2958() {
    check( //
        "Integrate[(a + b/x^2)^(-3/2), x]", //
        "-(x/(a*Sqrt[a + b/x^2])) + (2*Sqrt[a + b/x^2]*x)/a^2", //
        198,
        197);
  }

  // {277, 270}
  public void test2959() {
    check( //
        "Integrate[1/((a + b/x^2)^(5/2)*x^2), x]", //
        "(-2*b)/(3*a^2*(a + b/x^2)^(3/2)*x^3) - 1/(a*(a + b/x^2)^(3/2)*x)", //
        277,
        270);
  }

  // {346, 371}
  public void test2960() {
    check( //
        "Integrate[(1 + b/x^2)^(3/2)*(c*x)^m, x]", //
        "((c*x)^(1 + m)*Hypergeometric2F1[-3/2, (-1 - m)/2, (1 - m)/2, -(b/x^2)])/(c*(1 + m))", //
        346,
        371);
  }

  // {346, 371}
  public void test2961() {
    check( //
        "Integrate[Sqrt[1 + b/x^2]*(c*x)^m, x]", //
        "((c*x)^(1 + m)*Hypergeometric2F1[-1/2, (-1 - m)/2, (1 - m)/2, -(b/x^2)])/(c*(1 + m))", //
        346,
        371);
  }

  // {346, 371}
  public void test2962() {
    check( //
        "Integrate[(c*x)^m/Sqrt[1 + b/x^2], x]", //
        "((c*x)^(1 + m)*Hypergeometric2F1[1/2, (-1 - m)/2, (1 - m)/2, -(b/x^2)])/(c*(1 + m))", //
        346,
        371);
  }

  // {346, 371}
  public void test2963() {
    check( //
        "Integrate[(c*x)^m/(1 + b/x^2)^(3/2), x]", //
        "((c*x)^(1 + m)*Hypergeometric2F1[3/2, (-1 - m)/2, (1 - m)/2, -(b/x^2)])/(c*(1 + m))", //
        346,
        371);
  }

  // {346, 371}
  public void test2964() {
    check( //
        "Integrate[(1 + b/x^2)^p*(c*x)^m, x]", //
        "((c*x)^(1 + m)*Hypergeometric2F1[(-1 - m)/2, -p, (1 - m)/2, -(b/x^2)])/(c*(1 + m))", //
        346,
        371);
  }

  // {269, 266}
  public void test2965() {
    check( //
        "Integrate[1/((a + b/x^3)*x), x]", //
        "Log[b + a*x^3]/(3*a)", //
        269,
        266);
  }

  // {342, 224}
  public void test2966() {
    check( //
        "Integrate[1/(Sqrt[a + b/x^3]*x^2), x]", //
        "(-2*Sqrt[2 + Sqrt[3]]*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3^(1/4)*b^(1/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])", //
        342,
        224);
  }

  // {342, 226}
  public void test2967() {
    check( //
        "Integrate[1/(Sqrt[a + b/x^4]*x^2), x]", //
        "-(Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(2*a^(1/4)*b^(1/4)*Sqrt[a + b/x^4])", //
        342,
        226);
  }

  // {279, 270}
  public void test2968() {
    check( //
        "Integrate[x/(a + b/x^4)^(3/2), x]", //
        "-x^2/(2*a*Sqrt[a + b/x^4]) + (Sqrt[a + b/x^4]*x^2)/a^2", //
        279,
        270);
  }

  // {277, 270}
  public void test2969() {
    check( //
        "Integrate[1/((a + b/x^4)^(5/2)*x^3), x]", //
        "-b/(3*a^2*(a + b/x^4)^(3/2)*x^6) - 1/(2*a*(a + b/x^4)^(3/2)*x^2)", //
        277,
        270);
  }

  // {14}
  public void test2970() {
    check( //
        "Integrate[(a + b*Sqrt[x])*x^4, x]", //
        "(a*x^5)/5 + (2*b*x^(11/2))/11", //
        14);
  }

  // {14}
  public void test2971() {
    check( //
        "Integrate[(a + b*Sqrt[x])*x^3, x]", //
        "(a*x^4)/4 + (2*b*x^(9/2))/9", //
        14);
  }

  // {14}
  public void test2972() {
    check( //
        "Integrate[(a + b*Sqrt[x])*x^2, x]", //
        "(a*x^3)/3 + (2*b*x^(7/2))/7", //
        14);
  }

  // {14}
  public void test2973() {
    check( //
        "Integrate[(a + b*Sqrt[x])*x, x]", //
        "(a*x^2)/2 + (2*b*x^(5/2))/5", //
        14);
  }

  // {14}
  public void test2974() {
    check( //
        "Integrate[(a + b*Sqrt[x])/x, x]", //
        "2*b*Sqrt[x] + a*Log[x]", //
        14);
  }

  // {14}
  public void test2975() {
    check( //
        "Integrate[(a + b*Sqrt[x])/x^2, x]", //
        "-(a/x) - (2*b)/Sqrt[x]", //
        14);
  }

  // {14}
  public void test2976() {
    check( //
        "Integrate[(a + b*Sqrt[x])/x^3, x]", //
        "-a/(2*x^2) - (2*b)/(3*x^(3/2))", //
        14);
  }

  // {14}
  public void test2977() {
    check( //
        "Integrate[(a + b*Sqrt[x])/x^4, x]", //
        "-a/(3*x^3) - (2*b)/(5*x^(5/2))", //
        14);
  }

  // {196, 37}
  public void test2978() {
    check( //
        "Integrate[(a + b*Sqrt[x])^(-3), x]", //
        "x/(a*(a + b*Sqrt[x])^2)", //
        196,
        37);
  }

  // {14}
  public void test2979() {
    check( //
        "Integrate[(1 + Sqrt[x])/Sqrt[x], x]", //
        "2*Sqrt[x] + x", //
        14);
  }

  // {276}
  public void test2980() {
    check( //
        "Integrate[(a + b*Sqrt[x])^4*x^m, x]", //
        "(a^4*x^(1 + m))/(1 + m) + (8*a^3*b*x^(3/2 + m))/(3 + 2*m) + (6*a^2*b^2*x^(2 + m))/(2 + m) + (8*a*b^3*x^(5/2 + m))/(5 + 2*m) + (b^4*x^(3 + m))/(3 + m)", //
        276);
  }

  // {276}
  public void test2981() {
    check( //
        "Integrate[(a + b*Sqrt[x])^3*x^m, x]", //
        "(a^3*x^(1 + m))/(1 + m) + (6*a^2*b*x^(3/2 + m))/(3 + 2*m) + (3*a*b^2*x^(2 + m))/(2 + m) + (2*b^3*x^(5/2 + m))/(5 + 2*m)", //
        276);
  }

  // {276}
  public void test2982() {
    check( //
        "Integrate[(a + b*Sqrt[x])^2*x^m, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (4*a*b*x^(3/2 + m))/(3 + 2*m) + (b^2*x^(2 + m))/(2 + m)", //
        276);
  }

  // {14}
  public void test2983() {
    check( //
        "Integrate[(a + b*Sqrt[x])*x^m, x]", //
        "(a*x^(1 + m))/(1 + m) + (2*b*x^(3/2 + m))/(3 + 2*m)", //
        14);
  }

  // {348, 66}
  public void test2984() {
    check( //
        "Integrate[x^m/(a + b*Sqrt[x]), x]", //
        "(x^(1 + m)*Hypergeometric2F1[1, 2*(1 + m), 3 + 2*m, -((b*Sqrt[x])/a)])/(a*(1 + m))", //
        348,
        66);
  }

  // {348, 66}
  public void test2985() {
    check( //
        "Integrate[x^m/(a + b*Sqrt[x])^2, x]", //
        "(x^(1 + m)*Hypergeometric2F1[2, 2*(1 + m), 3 + 2*m, -((b*Sqrt[x])/a)])/(a^2*(1 + m))", //
        348,
        66);
  }

  // {272, 67}
  public void test2986() {
    check( //
        "Integrate[(a + b*Sqrt[x])^p/x, x]", //
        "(-2*(a + b*Sqrt[x])^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*Sqrt[x])/a])/(a*(1 + p))", //
        272,
        67);
  }

  // {272, 67}
  public void test2987() {
    check( //
        "Integrate[(a + b*Sqrt[x])^p/x^2, x]", //
        "(-2*b^2*(a + b*Sqrt[x])^(1 + p)*Hypergeometric2F1[3, 1 + p, 2 + p, 1 + (b*Sqrt[x])/a])/(a^3*(1 + p))", //
        272,
        67);
  }

  // {277, 270}
  public void test2988() {
    check( //
        "Integrate[1/(x^3*(a + b*x^(3/2))^(2/3)), x]", //
        "-(a + b*x^(3/2))^(1/3)/(2*a*x^2) + (3*b*(a + b*x^(3/2))^(1/3))/(2*a^2*Sqrt[x])", //
        277,
        270);
  }

  // {14}
  public void test2989() {
    check( //
        "Integrate[(a + b*x^(1/3))*x^4, x]", //
        "(a*x^5)/5 + (3*b*x^(16/3))/16", //
        14);
  }

  // {14}
  public void test2990() {
    check( //
        "Integrate[(a + b*x^(1/3))*x^3, x]", //
        "(a*x^4)/4 + (3*b*x^(13/3))/13", //
        14);
  }

  // {14}
  public void test2991() {
    check( //
        "Integrate[(a + b*x^(1/3))*x^2, x]", //
        "(a*x^3)/3 + (3*b*x^(10/3))/10", //
        14);
  }

  // {14}
  public void test2992() {
    check( //
        "Integrate[(a + b*x^(1/3))*x, x]", //
        "(a*x^2)/2 + (3*b*x^(7/3))/7", //
        14);
  }

  // {14}
  public void test2993() {
    check( //
        "Integrate[(a + b*x^(1/3))/x, x]", //
        "3*b*x^(1/3) + a*Log[x]", //
        14);
  }

  // {14}
  public void test2994() {
    check( //
        "Integrate[(a + b*x^(1/3))/x^2, x]", //
        "-(a/x) - (3*b)/(2*x^(2/3))", //
        14);
  }

  // {14}
  public void test2995() {
    check( //
        "Integrate[(a + b*x^(1/3))/x^3, x]", //
        "-a/(2*x^2) - (3*b)/(5*x^(5/3))", //
        14);
  }

  // {14}
  public void test2996() {
    check( //
        "Integrate[(a + b*x^(1/3))/x^4, x]", //
        "-a/(3*x^3) - (3*b)/(8*x^(8/3))", //
        14);
  }

  // {348, 209}
  public void test2997() {
    check( //
        "Integrate[1/((1 + x^(2/3))*x^(2/3)), x]", //
        "3*ArcTan[x^(1/3)]", //
        348,
        209);
  }

  // {14}
  public void test2998() {
    check( //
        "Integrate[(a + b/x^(1/3))*x^4, x]", //
        "(3*b*x^(14/3))/14 + (a*x^5)/5", //
        14);
  }

  // {14}
  public void test2999() {
    check( //
        "Integrate[(a + b/x^(1/3))*x^3, x]", //
        "(3*b*x^(11/3))/11 + (a*x^4)/4", //
        14);
  }

  // {14}
  public void test3000() {
    check( //
        "Integrate[(a + b/x^(1/3))*x^2, x]", //
        "(3*b*x^(8/3))/8 + (a*x^3)/3", //
        14);
  }

  // {14}
  public void test3001() {
    check( //
        "Integrate[(a + b/x^(1/3))*x, x]", //
        "(3*b*x^(5/3))/5 + (a*x^2)/2", //
        14);
  }

  // {14}
  public void test3002() {
    check( //
        "Integrate[(a + b/x^(1/3))/x, x]", //
        "(-3*b)/x^(1/3) + a*Log[x]", //
        14);
  }

  // {14}
  public void test3003() {
    check( //
        "Integrate[(a + b/x^(1/3))/x^2, x]", //
        "(-3*b)/(4*x^(4/3)) - a/x", //
        14);
  }

  // {14}
  public void test3004() {
    check( //
        "Integrate[(a + b/x^(1/3))/x^3, x]", //
        "(-3*b)/(7*x^(7/3)) - a/(2*x^2)", //
        14);
  }

  // {14}
  public void test3005() {
    check( //
        "Integrate[(a + b/x^(1/3))/x^4, x]", //
        "(-3*b)/(10*x^(10/3)) - a/(3*x^3)", //
        14);
  }

  // {196, 37}
  public void test3006() {
    check( //
        "Integrate[(a + b/x^(1/3))^2, x]", //
        "((a + b/x^(1/3))^3*x)/a", //
        196,
        37);
  }

  // {269, 266}
  public void test3007() {
    check( //
        "Integrate[1/((a + b/x^(1/3))*x), x]", //
        "(3*Log[b + a*x^(1/3)])/a", //
        269,
        266);
  }

  // {14}
  public void test3008() {
    check( //
        "Integrate[x^3*(a + b*x^n), x]", //
        "(a*x^4)/4 + (b*x^(4 + n))/(4 + n)", //
        14);
  }

  // {14}
  public void test3009() {
    check( //
        "Integrate[x^2*(a + b*x^n), x]", //
        "(a*x^3)/3 + (b*x^(3 + n))/(3 + n)", //
        14);
  }

  // {14}
  public void test3010() {
    check( //
        "Integrate[x*(a + b*x^n), x]", //
        "(a*x^2)/2 + (b*x^(2 + n))/(2 + n)", //
        14);
  }

  // {14}
  public void test3011() {
    check( //
        "Integrate[(a + b*x^n)/x, x]", //
        "(b*x^n)/n + a*Log[x]", //
        14);
  }

  // {14}
  public void test3012() {
    check( //
        "Integrate[(a + b*x^n)/x^2, x]", //
        "-(a/x) - (b*x^(-1 + n))/(1 - n)", //
        14);
  }

  // {14}
  public void test3013() {
    check( //
        "Integrate[(a + b*x^n)/x^3, x]", //
        "-a/(2*x^2) - (b*x^(-2 + n))/(2 - n)", //
        14);
  }

  // {276}
  public void test3014() {
    check( //
        "Integrate[x^3*(a + b*x^n)^2, x]", //
        "(a^2*x^4)/4 + (b^2*x^(2*(2 + n)))/(2*(2 + n)) + (2*a*b*x^(4 + n))/(4 + n)", //
        276);
  }

  // {276}
  public void test3015() {
    check( //
        "Integrate[x^2*(a + b*x^n)^2, x]", //
        "(a^2*x^3)/3 + (2*a*b*x^(3 + n))/(3 + n) + (b^2*x^(3 + 2*n))/(3 + 2*n)", //
        276);
  }

  // {276}
  public void test3016() {
    check( //
        "Integrate[x*(a + b*x^n)^2, x]", //
        "(a^2*x^2)/2 + (b^2*x^(2*(1 + n)))/(2*(1 + n)) + (2*a*b*x^(2 + n))/(2 + n)", //
        276);
  }

  // {250}
  public void test3017() {
    check( //
        "Integrate[(a + b*x^n)^2, x]", //
        "a^2*x + (2*a*b*x^(1 + n))/(1 + n) + (b^2*x^(1 + 2*n))/(1 + 2*n)", //
        250);
  }

  // {276}
  public void test3018() {
    check( //
        "Integrate[(a + b*x^n)^2/x^2, x]", //
        "-(a^2/x) - (2*a*b*x^(-1 + n))/(1 - n) - (b^2*x^(-1 + 2*n))/(1 - 2*n)", //
        276);
  }

  // {276}
  public void test3019() {
    check( //
        "Integrate[(a + b*x^n)^2/x^3, x]", //
        "-a^2/(2*x^2) - b^2/(2*(1 - n)*x^(2*(1 - n))) - (2*a*b*x^(-2 + n))/(2 - n)", //
        276);
  }

  // {276}
  public void test3020() {
    check( //
        "Integrate[x^3*(a + b*x^n)^3, x]", //
        "(a^3*x^4)/4 + (3*a*b^2*x^(2*(2 + n)))/(2*(2 + n)) + (3*a^2*b*x^(4 + n))/(4 + n) + (b^3*x^(4 + 3*n))/(4 + 3*n)", //
        276);
  }

  // {276}
  public void test3021() {
    check( //
        "Integrate[x^2*(a + b*x^n)^3, x]", //
        "(a^3*x^3)/3 + (b^3*x^(3*(1 + n)))/(3*(1 + n)) + (3*a^2*b*x^(3 + n))/(3 + n) + (3*a*b^2*x^(3 + 2*n))/(3 + 2*n)", //
        276);
  }

  // {276}
  public void test3022() {
    check( //
        "Integrate[x*(a + b*x^n)^3, x]", //
        "(a^3*x^2)/2 + (3*a*b^2*x^(2*(1 + n)))/(2*(1 + n)) + (3*a^2*b*x^(2 + n))/(2 + n) + (b^3*x^(2 + 3*n))/(2 + 3*n)", //
        276);
  }

  // {250}
  public void test3023() {
    check( //
        "Integrate[(a + b*x^n)^3, x]", //
        "a^3*x + (3*a^2*b*x^(1 + n))/(1 + n) + (3*a*b^2*x^(1 + 2*n))/(1 + 2*n) + (b^3*x^(1 + 3*n))/(1 + 3*n)", //
        250);
  }

  // {276}
  public void test3024() {
    check( //
        "Integrate[(a + b*x^n)^3/x^2, x]", //
        "-(a^3/x) - (3*a^2*b*x^(-1 + n))/(1 - n) - (3*a*b^2*x^(-1 + 2*n))/(1 - 2*n) - (b^3*x^(-1 + 3*n))/(1 - 3*n)", //
        276);
  }

  // {276}
  public void test3025() {
    check( //
        "Integrate[(a + b*x^n)^3/x^3, x]", //
        "-a^3/(2*x^2) - (3*a*b^2)/(2*(1 - n)*x^(2*(1 - n))) - (3*a^2*b*x^(-2 + n))/(2 - n) - (b^3*x^(-2 + 3*n))/(2 - 3*n)", //
        276);
  }

  // {14}
  public void test3026() {
    check( //
        "Integrate[x^(-1 + 4*n)*(a + b*x^n), x]", //
        "(a*x^(4*n))/(4*n) + (b*x^(5*n))/(5*n)", //
        14);
  }

  // {14}
  public void test3027() {
    check( //
        "Integrate[x^(-1 + 3*n)*(a + b*x^n), x]", //
        "(a*x^(3*n))/(3*n) + (b*x^(4*n))/(4*n)", //
        14);
  }

  // {14}
  public void test3028() {
    check( //
        "Integrate[x^(-1 + 2*n)*(a + b*x^n), x]", //
        "(a*x^(2*n))/(2*n) + (b*x^(3*n))/(3*n)", //
        14);
  }

  // {14}
  public void test3029() {
    check( //
        "Integrate[x^(-1 + n)*(a + b*x^n), x]", //
        "(a*x^n)/n + (b*x^(2*n))/(2*n)", //
        14);
  }

  // {14}
  public void test3030() {
    check( //
        "Integrate[(a + b*x^n)/x, x]", //
        "(b*x^n)/n + a*Log[x]", //
        14);
  }

  // {14}
  public void test3031() {
    check( //
        "Integrate[x^(-1 - n)*(a + b*x^n), x]", //
        "-(a/(n*x^n)) + b*Log[x]", //
        14);
  }

  // {14}
  public void test3032() {
    check( //
        "Integrate[x^(-1 - 2*n)*(a + b*x^n), x]", //
        "-a/(2*n*x^(2*n)) - b/(n*x^n)", //
        14);
  }

  // {14}
  public void test3033() {
    check( //
        "Integrate[x^(-1 - 3*n)*(a + b*x^n), x]", //
        "-a/(3*n*x^(3*n)) - b/(2*n*x^(2*n))", //
        14);
  }

  // {14}
  public void test3034() {
    check( //
        "Integrate[x^(-1 - 4*n)*(a + b*x^n), x]", //
        "-a/(4*n*x^(4*n)) - b/(3*n*x^(3*n))", //
        14);
  }

  // {14}
  public void test3035() {
    check( //
        "Integrate[x^(-1 - 5*n)*(a + b*x^n), x]", //
        "-a/(5*n*x^(5*n)) - b/(4*n*x^(4*n))", //
        14);
  }

  // {276}
  public void test3036() {
    check( //
        "Integrate[x^m*(a + b*x^n)^3, x]", //
        "(a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(1 + m + n))/(1 + m + n) + (3*a*b^2*x^(1 + m + 2*n))/(1 + m + 2*n) + (b^3*x^(1 + m + 3*n))/(1 + m + 3*n)", //
        276);
  }

  // {276}
  public void test3037() {
    check( //
        "Integrate[x^m*(a + b*x^n)^2, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(1 + m + n))/(1 + m + n) + (b^2*x^(1 + m + 2*n))/(1 + m + 2*n)", //
        276);
  }

  // {14}
  public void test3038() {
    check( //
        "Integrate[x^m*(a + b*x^n), x]", //
        "(a*x^(1 + m))/(1 + m) + (b*x^(1 + m + n))/(1 + m + n)", //
        14);
  }

  // {277, 270}
  public void test3039() {
    check( //
        "Integrate[x^(-1 - (3*n)/2)/Sqrt[a + b*x^n], x]", //
        "(-2*Sqrt[a + b*x^n])/(3*a*n*x^((3*n)/2)) + (4*b*Sqrt[a + b*x^n])/(3*a^2*n*x^(n/2))", //
        277,
        270);
  }

  // {12, 460}
  public void test3040() {
    check( //
        "Integrate[(x^(-1 + m)*(2*a*m + b*(2*m - n)*x^n))/(2*(a + b*x^n)^(3/2)), x]", //
        "x^m/Sqrt[a + b*x^n]", //
        12,
        460);
  }

  // {352, 245}
  public void test3041() {
    check( //
        "Integrate[x^m/(a + b*x^(3*(1 + m)))^(1/3), x]", //
        "ArcTan[(1 + (2*b^(1/3)*x^(1 + m))/(a + b*x^(3*(1 + m)))^(1/3))/Sqrt[3]]/(Sqrt[3]*b^(1/3)*(1 + m)) - Log[b^(1/3)*x^(1 + m) - (a + b*x^(3*(1 + m)))^(1/3)]/(2*b^(1/3)*(1 + m))", //
        352,
        245);
  }

  // {352, 245}
  public void test3042() {
    check( //
        "Integrate[x^(-1 + n/3)/(a + b*x^n)^(1/3), x]", //
        "(Sqrt[3]*ArcTan[(1 + (2*b^(1/3)*x^(n/3))/(a + b*x^n)^(1/3))/Sqrt[3]])/(b^(1/3)*n) - (3*Log[b^(1/3)*x^(n/3) - (a + b*x^n)^(1/3)])/(2*b^(1/3)*n)", //
        352,
        245);
  }

  // {198, 197}
  public void test3043() {
    check( //
        "Integrate[(a + b*x^n)^(-2 - n^(-1)), x]", //
        "(x*(a + b*x^n)^(-1 - n^(-1)))/(a*(1 + n)) + (n*x)/(a^2*(1 + n)*(a + b*x^n)^n^(-1))", //
        198,
        197);
  }

  // {252, 251}
  public void test3044() {
    check( //
        "Integrate[(a + b*x^n)^(-n^(-1)), x]", //
        "(x*(1 + (b*x^n)/a)^n^(-1)*Hypergeometric2F1[n^(-1), n^(-1), 1 + n^(-1), -((b*x^n)/a)])/(a + b*x^n)^n^(-1)", //
        252,
        251);
  }

  // {252, 251}
  public void test3045() {
    check( //
        "Integrate[(a + b*x^n)^(1 - n^(-1)), x]", //
        "(a*x*(1 + (b*x^n)/a)^n^(-1)*Hypergeometric2F1[-1 + n^(-1), n^(-1), 1 + n^(-1), -((b*x^n)/a)])/(a + b*x^n)^n^(-1)", //
        252,
        251);
  }

  // {252, 251}
  public void test3046() {
    check( //
        "Integrate[(a + b*x^n)^(2 - n^(-1)), x]", //
        "(a^2*x*(1 + (b*x^n)/a)^n^(-1)*Hypergeometric2F1[-2 + n^(-1), n^(-1), 1 + n^(-1), -((b*x^n)/a)])/(a + b*x^n)^n^(-1)", //
        252,
        251);
  }

  // {15, 30}
  public void test3047() {
    check( //
        "Integrate[x^m*(b*x^n)^p, x]", //
        "(x^(1 + m)*(b*x^n)^p)/(1 + m + n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test3048() {
    check( //
        "Integrate[x^2*(b*x^n)^p, x]", //
        "(x^3*(b*x^n)^p)/(3 + n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test3049() {
    check( //
        "Integrate[x*(b*x^n)^p, x]", //
        "(x^2*(b*x^n)^p)/(2 + n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test3050() {
    check( //
        "Integrate[(b*x^n)^p, x]", //
        "(x*(b*x^n)^p)/(1 + n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test3051() {
    check( //
        "Integrate[(b*x^n)^p/x, x]", //
        "(b*x^n)^p/(n*p)", //
        15,
        30);
  }

  // {15, 30}
  public void test3052() {
    check( //
        "Integrate[(b*x^n)^p/x^2, x]", //
        "-((b*x^n)^p/((1 - n*p)*x))", //
        15,
        30);
  }

  // {15, 30}
  public void test3053() {
    check( //
        "Integrate[(b*x^n)^p/x^3, x]", //
        "-((b*x^n)^p/((2 - n*p)*x^2))", //
        15,
        30);
  }

  // {15, 30}
  public void test3054() {
    check( //
        "Integrate[(b*x^n)^p/x^4, x]", //
        "-((b*x^n)^p/((3 - n*p)*x^3))", //
        15,
        30);
  }

  // {198, 197}
  public void test3055() {
    check( //
        "Integrate[(a + b*x^n)^(-((1 + 2*n)/n)), x]", //
        "(n*x)/(a^2*(1 + n)*(a + b*x^n)^n^(-1)) + x/(a*(1 + n)*(a + b*x^n)^((1 + n)/n))", //
        198,
        197);
  }

  // {252, 251}
  public void test3056() {
    check( //
        "Integrate[(a + b*x^n)^(-n^(-1)), x]", //
        "(x*(1 + (b*x^n)/a)^n^(-1)*Hypergeometric2F1[n^(-1), n^(-1), 1 + n^(-1), -((b*x^n)/a)])/(a + b*x^n)^n^(-1)", //
        252,
        251);
  }

  // {252, 251}
  public void test3057() {
    check( //
        "Integrate[(a + b*x^n)^(-((1 - n)/n)), x]", //
        "(x*(1 + (b*x^n)/a)^(-1 + n^(-1))*Hypergeometric2F1[-1 + n^(-1), n^(-1), 1 + n^(-1), -((b*x^n)/a)])/(a + b*x^n)^((1 - n)/n)", //
        252,
        251);
  }

  // {252, 251}
  public void test3058() {
    check( //
        "Integrate[(a + b*x^n)^(-((1 - 2*n)/n)), x]", //
        "x*(a + b*x^n)^(2 - n^(-1))*(1 + (b*x^n)/a)^(-2 + n^(-1))*Hypergeometric2F1[-2 + n^(-1), n^(-1), 1 + n^(-1), -((b*x^n)/a)]", //
        252,
        251);
  }

  // {269, 266}
  public void test3059() {
    check( //
        "Integrate[1/(x*(a + b/x^n)), x]", //
        "Log[b + a*x^n]/(a*n)", //
        269,
        266);
  }

  // {276}
  public void test3060() {
    check( //
        "Integrate[x^m*(a + b*x^(2 + 2*m))^3, x]", //
        "(a^3*x^(1 + m))/(1 + m) + (a^2*b*x^(3*(1 + m)))/(1 + m) + (3*a*b^2*x^(5*(1 + m)))/(5*(1 + m)) + (b^3*x^(7*(1 + m)))/(7*(1 + m))", //
        276);
  }

  // {276}
  public void test3061() {
    check( //
        "Integrate[x^m*(a + b*x^(2 + 2*m))^2, x]", //
        "(a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(3*(1 + m)))/(3*(1 + m)) + (b^2*x^(5*(1 + m)))/(5*(1 + m))", //
        276);
  }

  // {14}
  public void test3062() {
    check( //
        "Integrate[x^m*(a + b*x^(2 + 2*m)), x]", //
        "(a*x^(1 + m))/(1 + m) + (b*x^(3*(1 + m)))/(3*(1 + m))", //
        14);
  }

  // {352, 211}
  public void test3063() {
    check( //
        "Integrate[x^m/(a + b*x^(2 + 2*m)), x]", //
        "ArcTan[(Sqrt[b]*x^(1 + m))/Sqrt[a]]/(Sqrt[a]*Sqrt[b]*(1 + m))", //
        352,
        211);
  }

  // {277, 270}
  public void test3064() {
    check( //
        "Integrate[x^m/(a + b*x^(2 + 2*m))^(5/2), x]", //
        "x^(1 + m)/(a*(1 + m)*(a + b*x^(2*(1 + m)))^(3/2)) + (2*b*x^(3*(1 + m)))/(3*a^2*(1 + m)*(a + b*x^(2*(1 + m)))^(3/2))", //
        277,
        270);
  }

  // {276}
  public void test3065() {
    check( //
        "Integrate[(c*x)^m*(a + b*x^3)^2, x]", //
        "(a^2*(c*x)^(1 + m))/(c*(1 + m)) + (2*a*b*(c*x)^(4 + m))/(c^4*(4 + m)) + (b^2*(c*x)^(7 + m))/(c^7*(7 + m))", //
        276);
  }

  // {276}
  public void test3066() {
    check( //
        "Integrate[(c*x)^m*(a + b*x^2)^2, x]", //
        "(a^2*(c*x)^(1 + m))/(c*(1 + m)) + (2*a*b*(c*x)^(3 + m))/(c^3*(3 + m)) + (b^2*(c*x)^(5 + m))/(c^5*(5 + m))", //
        276);
  }

  // {45}
  public void test3067() {
    check( //
        "Integrate[(c*x)^m*(a + b*x)^2, x]", //
        "(a^2*(c*x)^(1 + m))/(c*(1 + m)) + (2*a*b*(c*x)^(2 + m))/(c^2*(2 + m)) + (b^2*(c*x)^(3 + m))/(c^3*(3 + m))", //
        45);
  }

  // {276}
  public void test3068() {
    check( //
        "Integrate[(a + b/x)^2*(c*x)^m, x]", //
        "-((b^2*c*(c*x)^(-1 + m))/(1 - m)) + (2*a*b*(c*x)^m)/m + (a^2*(c*x)^(1 + m))/(c*(1 + m))", //
        276);
  }

  // {276}
  public void test3069() {
    check( //
        "Integrate[(a + b/x^2)^2*(c*x)^m, x]", //
        "-((b^2*c^3*(c*x)^(-3 + m))/(3 - m)) - (2*a*b*c*(c*x)^(-1 + m))/(1 - m) + (a^2*(c*x)^(1 + m))/(c*(1 + m))", //
        276);
  }

  // {276}
  public void test3070() {
    check( //
        "Integrate[(a + b/x^3)^2*(c*x)^m, x]", //
        "-((b^2*c^5*(c*x)^(-5 + m))/(5 - m)) - (2*a*b*c^2*(c*x)^(-2 + m))/(2 - m) + (a^2*(c*x)^(1 + m))/(c*(1 + m))", //
        276);
  }

  // {274, 266}
  public void test3071() {
    check( //
        "Integrate[(c*x)^(-1 + n)/(a + b*x^n), x]", //
        "((c*x)^n*Log[a + b*x^n])/(b*c*n*x^n)", //
        274,
        266);
  }

  // {279, 270}
  public void test3072() {
    check( //
        "Integrate[(c*x)^(-1 - (3*n)/2)/Sqrt[a + b*x^n], x]", //
        "(-2*Sqrt[a + b*x^n])/(a*c*n*(c*x)^((3*n)/2)) + (4*(a + b*x^n)^(3/2))/(3*a^2*c*n*(c*x)^((3*n)/2))", //
        279,
        270);
  }

  // {372, 371}
  public void test3073() {
    check( //
        "Integrate[(c*x)^(-1 - n*p)*(a + b*x^n)^p, x]", //
        "-(((a + b*x^n)^p*Hypergeometric2F1[-p, -p, 1 - p, -((b*x^n)/a)])/(c*n*p*(c*x)^(n*p)*(1 + (b*x^n)/a)^p))", //
        372,
        371);
  }

  // {279, 270}
  public void test3074() {
    check( //
        "Integrate[(c*x)^(-1 - 2*n - n*p)*(a + b*x^n)^p, x]", //
        "-((a + b*x^n)^(1 + p)/(a*c*n*(1 + p)*(c*x)^(n*(2 + p)))) + (a + b*x^n)^(2 + p)/(a^2*c*n*(1 + p)*(2 + p)*(c*x)^(n*(2 + p)))", //
        279,
        270);
  }

  // {379, 266}
  public void test3075() {
    check( //
        "Integrate[(2 + x)/(1 + (2 + x)^2), x]", //
        "Log[1 + (2 + x)^2]/2", //
        379,
        266);
  }

  // {379, 267}
  public void test3076() {
    check( //
        "Integrate[(2 + x)/(1 + (2 + x)^2)^2, x]", //
        "-1/(2*(1 + (2 + x)^2))", //
        379,
        267);
  }

  // {379, 267}
  public void test3077() {
    check( //
        "Integrate[(2 + x)/(1 + (2 + x)^2)^3, x]", //
        "-1/(4*(1 + (2 + x)^2)^2)", //
        379,
        267);
  }

  // {379, 267}
  public void test3078() {
    check( //
        "Integrate[(c + d*x)*(a + b*(c + d*x)^2)^p, x]", //
        "(a + b*(c + d*x)^2)^(1 + p)/(2*b*d*(1 + p))", //
        379,
        267);
  }

  // {379, 266}
  public void test3079() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*(c + d*x)^3), x]", //
        "Log[a + b*(c + d*x)^3]/(3*b*d)", //
        379,
        266);
  }

  // {379, 267}
  public void test3080() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*(c + d*x)^3)^2, x]", //
        "-1/(3*b*d*(a + b*(c + d*x)^3))", //
        379,
        267);
  }

  // {379, 267}
  public void test3081() {
    check( //
        "Integrate[(c + d*x)^2/(a + b*(c + d*x)^3)^3, x]", //
        "-1/(6*b*d*(a + b*(c + d*x)^3)^2)", //
        379,
        267);
  }

  // {379, 266}
  public void test3082() {
    check( //
        "Integrate[(c*e + d*e*x)^2/(a + b*(c + d*x)^3), x]", //
        "(e^2*Log[a + b*(c + d*x)^3])/(3*b*d)", //
        379,
        266);
  }

  // {379, 267}
  public void test3083() {
    check( //
        "Integrate[(c*e + d*e*x)^2/(a + b*(c + d*x)^3)^2, x]", //
        "-e^2/(3*b*d*(a + b*(c + d*x)^3))", //
        379,
        267);
  }

  // {379, 267}
  public void test3084() {
    check( //
        "Integrate[(c*e + d*e*x)^2/(a + b*(c + d*x)^3)^3, x]", //
        "-e^2/(6*b*d*(a + b*(c + d*x)^3)^2)", //
        379,
        267);
  }

  // {379, 267}
  public void test3085() {
    check( //
        "Integrate[(c + d*x)^3*(a + b*(c + d*x)^4)^p, x]", //
        "(a + b*(c + d*x)^4)^(1 + p)/(4*b*d*(1 + p))", //
        379,
        267);
  }

  // {379, 267}
  public void test3086() {
    check( //
        "Integrate[(c + d*x)^3*(a + b*(c + d*x)^4)^2, x]", //
        "(a + b*(c + d*x)^4)^3/(12*b*d)", //
        379,
        267);
  }

  // {379, 267}
  public void test3087() {
    fSeconds = 20;
    check( //
        "Integrate[(c + d*x)^3*(a + b*(c + d*x)^4)^3, x]", //
        "(a + b*(c + d*x)^4)^4/(16*b*d)", //
        379,
        267);
  }

  // {379, 266}
  public void test3088() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*(c + d*x)^4), x]", //
        "Log[a + b*(c + d*x)^4]/(4*b*d)", //
        379,
        266);
  }

  // {379, 267}
  public void test3089() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*(c + d*x)^4)^2, x]", //
        "-1/(4*b*d*(a + b*(c + d*x)^4))", //
        379,
        267);
  }

  // {379, 267}
  public void test3090() {
    check( //
        "Integrate[(c + d*x)^3/(a + b*(c + d*x)^4)^3, x]", //
        "-1/(8*b*d*(a + b*(c + d*x)^4)^2)", //
        379,
        267);
  }

  // {253, 226}
  public void test3091() {
    check( //
        "Integrate[1/Sqrt[a + b*(c + d*x)^4], x]", //
        "((Sqrt[a] + Sqrt[b]*(c + d*x)^2)*Sqrt[(a + b*(c + d*x)^4)/(Sqrt[a] + Sqrt[b]*(c + d*x)^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*(c + d*x))/a^(1/4)], 1/2])/(2*a^(1/4)*b^(1/4)*d*Sqrt[a + b*(c + d*x)^4])", //
        253,
        226);
  }

  // {260, 32}
  public void test3092() {
    check( //
        "Integrate[Sqrt[a + b*Sqrt[c*x^2]], x]", //
        "(2*x*(a + b*Sqrt[c*x^2])^(3/2))/(3*b*Sqrt[c*x^2])", //
        260,
        32);
  }

  // {375, 267}
  public void test3093() {
    check( //
        "Integrate[x^2*Sqrt[a + b*(c*x^2)^(3/2)], x]", //
        "(2*x^3*(a + b*(c*x^2)^(3/2))^(3/2))/(9*b*(c*x^2)^(3/2))", //
        375,
        267);
  }

  // {260, 209}
  public void test3094() {
    check( //
        "Integrate[(1 + (x^3)^(2/3))^(-1), x]", //
        "(x*ArcTan[(x^3)^(1/3)])/(x^3)^(1/3)", //
        260,
        209);
  }

  // {260, 32}
  public void test3095() {
    check( //
        "Integrate[(a + b*(c*x^n)^n^(-1))^2, x]", //
        "(x*(a + b*(c*x^n)^n^(-1))^3)/(3*b*(c*x^n)^n^(-1))", //
        260,
        32);
  }

  // {260, 32}
  public void test3096() {
    check( //
        "Integrate[(a + b*(c*x^n)^n^(-1))^3, x]", //
        "(x*(a + b*(c*x^n)^n^(-1))^4)/(4*b*(c*x^n)^n^(-1))", //
        260,
        32);
  }

  // {260, 31}
  public void test3097() {
    check( //
        "Integrate[(a + b*(c*x^n)^n^(-1))^(-1), x]", //
        "(x*Log[a + b*(c*x^n)^n^(-1)])/(b*(c*x^n)^n^(-1))", //
        260,
        31);
  }

  // {260, 32}
  public void test3098() {
    check( //
        "Integrate[(a + b*(c*x^n)^n^(-1))^(-3), x]", //
        "-x/(2*b*(c*x^n)^n^(-1)*(a + b*(c*x^n)^n^(-1))^2)", //
        260,
        32);
  }

  // {260, 32}
  public void test3099() {
    check( //
        "Integrate[(a + b*(c*x^n)^n^(-1))^p, x]", //
        "(x*(a + b*(c*x^n)^n^(-1))^(1 + p))/(b*(1 + p)*(c*x^n)^n^(-1))", //
        260,
        32);
  }

  // {375, 67}
  public void test3100() {
    check( //
        "Integrate[(a + b*(c*x^n)^n^(-1))^p/x, x]", //
        "-(((a + b*(c*x^n)^n^(-1))^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*(c*x^n)^n^(-1))/a])/(a*(1 + p)))", //
        375,
        67);
  }

  // {375, 67}
  public void test3101() {
    check( //
        "Integrate[(a + b*(c*x^n)^n^(-1))^p/x^2, x]", //
        "(b*(c*x^n)^n^(-1)*(a + b*(c*x^n)^n^(-1))^(1 + p)*Hypergeometric2F1[2, 1 + p, 2 + p, 1 + (b*(c*x^n)^n^(-1))/a])/(a^2*(1 + p)*x)", //
        375,
        67);
  }

  // {260, 211}
  public void test3102() {
    check( //
        "Integrate[(a + b*(c*x^n)^(2/n))^(-1), x]", //
        "(x*ArcTan[(Sqrt[b]*(c*x^n)^n^(-1))/Sqrt[a]])/(Sqrt[a]*Sqrt[b]*(c*x^n)^n^(-1))", //
        260,
        211);
  }

  // {260, 209}
  public void test3103() {
    check( //
        "Integrate[(1 + 4*Sqrt[x^4])^(-1), x]", //
        "(x*ArcTan[2*(x^4)^(1/4)])/(2*(x^4)^(1/4))", //
        260,
        209);
  }

  // {260, 212}
  public void test3104() {
    check( //
        "Integrate[(1 - 4*Sqrt[x^4])^(-1), x]", //
        "(x*ArcTanh[2*(x^4)^(1/4)])/(2*(x^4)^(1/4))", //
        260,
        212);
  }

  // {260, 209}
  public void test3105() {
    check( //
        "Integrate[(1 + 4*(x^6)^(1/3))^(-1), x]", //
        "(x*ArcTan[2*(x^6)^(1/6)])/(2*(x^6)^(1/6))", //
        260,
        209);
  }

  // {260, 212}
  public void test3106() {
    check( //
        "Integrate[(1 - 4*(x^6)^(1/3))^(-1), x]", //
        "(x*ArcTanh[2*(x^6)^(1/6)])/(2*(x^6)^(1/6))", //
        260,
        212);
  }

  // {260, 209}
  public void test3107() {
    check( //
        "Integrate[(1 + 4*(x^(2*n))^n^(-1))^(-1), x]", //
        "(x*ArcTan[2*(x^(2*n))^(1/(2*n))])/(2*(x^(2*n))^(1/(2*n)))", //
        260,
        209);
  }

  // {260, 212}
  public void test3108() {
    check( //
        "Integrate[(1 - 4*(x^(2*n))^n^(-1))^(-1), x]", //
        "(x*ArcTanh[2*(x^(2*n))^(1/(2*n))])/(2*(x^(2*n))^(1/(2*n)))", //
        260,
        212);
  }

  // {1990, 2039}
  public void test3109() {
    check( //
        "Integrate[Sqrt[Sqrt[x^(-1)] + x^(-1)], x]", //
        "(4*(Sqrt[x^(-1)] + x^(-1))^(3/2))/(3*(x^(-1))^(3/2))", //
        1990,
        2039);
  }

  // {380}
  public void test3110() {
    check( //
        "Integrate[(a + b*x^3)*(c + d*x^3)^4, x]", //
        "a*c^4*x + (c^3*(b*c + 4*a*d)*x^4)/4 + (2*c^2*d*(2*b*c + 3*a*d)*x^7)/7 + (c*d^2*(3*b*c + 2*a*d)*x^10)/5 + (d^3*(4*b*c + a*d)*x^13)/13 + (b*d^4*x^16)/16", //
        380);
  }

  // {380}
  public void test3111() {
    check( //
        "Integrate[(a + b*x^3)*(c + d*x^3)^3, x]", //
        "a*c^3*x + (c^2*(b*c + 3*a*d)*x^4)/4 + (3*c*d*(b*c + a*d)*x^7)/7 + (d^2*(3*b*c + a*d)*x^10)/10 + (b*d^3*x^13)/13", //
        380);
  }

  // {380}
  public void test3112() {
    check( //
        "Integrate[(a + b*x^3)*(c + d*x^3)^2, x]", //
        "a*c^2*x + (c*(b*c + 2*a*d)*x^4)/4 + (d*(2*b*c + a*d)*x^7)/7 + (b*d^2*x^10)/10", //
        380);
  }

  // {380}
  public void test3113() {
    check( //
        "Integrate[(a + b*x^3)*(c + d*x^3), x]", //
        "a*c*x + ((b*c + a*d)*x^4)/4 + (b*d*x^7)/7", //
        380);
  }

  // {380}
  public void test3114() {
    check( //
        "Integrate[(a + b*x^3)^2*(c + d*x^3)^3, x]", //
        "a^2*c^3*x + (a*c^2*(2*b*c + 3*a*d)*x^4)/4 + (c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^7)/7 + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^10)/10 + (b*d^2*(3*b*c + 2*a*d)*x^13)/13 + (b^2*d^3*x^16)/16", //
        380);
  }

  // {380}
  public void test3115() {
    check( //
        "Integrate[(a + b*x^3)^2*(c + d*x^3)^2, x]", //
        "a^2*c^2*x + (a*c*(b*c + a*d)*x^4)/2 + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^7)/7 + (b*d*(b*c + a*d)*x^10)/5 + (b^2*d^2*x^13)/13", //
        380);
  }

  // {380}
  public void test3116() {
    check( //
        "Integrate[(a + b*x^3)^2*(c + d*x^3), x]", //
        "a^2*c*x + (a*(2*b*c + a*d)*x^4)/4 + (b*(b*c + 2*a*d)*x^7)/7 + (b^2*d*x^10)/10", //
        380);
  }

  // {386, 197}
  public void test3117() {
    check( //
        "Integrate[(a + b*x^3)/(c + d*x^3)^(7/3), x]", //
        "(x*(a + b*x^3))/(4*c*(c + d*x^3)^(4/3)) + (3*a*x)/(4*c^2*(c + d*x^3)^(1/3))", //
        386,
        197);
  }

  // {441, 440}
  public void test3118() {
    check( //
        "Integrate[(c + d*x^3)^q/(a + b*x^3), x]", //
        "(x*(c + d*x^3)^q*AppellF1[1/3, 1, -q, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*(1 + (d*x^3)/c)^q)", //
        441,
        440);
  }

  // {441, 440}
  public void test3119() {
    check( //
        "Integrate[(c + d*x^3)^q/(a + b*x^3)^2, x]", //
        "(x*(c + d*x^3)^q*AppellF1[1/3, 2, -q, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*(1 + (d*x^3)/c)^q)", //
        441,
        440);
  }

  // {252, 251}
  public void test3120() {
    check( //
        "Integrate[(a + b*x^3)^m, x]", //
        "(x*(a + b*x^3)^m*Hypergeometric2F1[1/3, -m, 4/3, -((b*x^3)/a)])/(1 + (b*x^3)/a)^m", //
        252,
        251);
  }

  // {441, 440}
  public void test3121() {
    check( //
        "Integrate[(a + b*x^3)^m/(c + d*x^3), x]", //
        "(x*(a + b*x^3)^m*AppellF1[1/3, -m, 1, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(c*(1 + (b*x^3)/a)^m)", //
        441,
        440);
  }

  // {441, 440}
  public void test3122() {
    check( //
        "Integrate[(a + b*x^3)^m/(c + d*x^3)^2, x]", //
        "(x*(a + b*x^3)^m*AppellF1[1/3, -m, 2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(c^2*(1 + (b*x^3)/a)^m)", //
        441,
        440);
  }

  // {441, 440}
  public void test3123() {
    check( //
        "Integrate[(a + b*x^3)^m/(c + d*x^3)^3, x]", //
        "(x*(a + b*x^3)^m*AppellF1[1/3, -m, 3, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(c^3*(1 + (b*x^3)/a)^m)", //
        441,
        440);
  }

  // {380}
  public void test3124() {
    check( //
        "Integrate[(a + b*x^4)*(c + d*x^4)^4, x]", //
        "a*c^4*x + (c^3*(b*c + 4*a*d)*x^5)/5 + (2*c^2*d*(2*b*c + 3*a*d)*x^9)/9 + (2*c*d^2*(3*b*c + 2*a*d)*x^13)/13 + (d^3*(4*b*c + a*d)*x^17)/17 + (b*d^4*x^21)/21", //
        380);
  }

  // {380}
  public void test3125() {
    check( //
        "Integrate[(a + b*x^4)*(c + d*x^4)^3, x]", //
        "a*c^3*x + (c^2*(b*c + 3*a*d)*x^5)/5 + (c*d*(b*c + a*d)*x^9)/3 + (d^2*(3*b*c + a*d)*x^13)/13 + (b*d^3*x^17)/17", //
        380);
  }

  // {380}
  public void test3126() {
    check( //
        "Integrate[(a + b*x^4)*(c + d*x^4)^2, x]", //
        "a*c^2*x + (c*(b*c + 2*a*d)*x^5)/5 + (d*(2*b*c + a*d)*x^9)/9 + (b*d^2*x^13)/13", //
        380);
  }

  // {380}
  public void test3127() {
    check( //
        "Integrate[(a + b*x^4)*(c + d*x^4), x]", //
        "a*c*x + ((b*c + a*d)*x^5)/5 + (b*d*x^9)/9", //
        380);
  }

  // {380}
  public void test3128() {
    check( //
        "Integrate[(a + b*x^4)^2*(c + d*x^4)^4, x]", //
        "a^2*c^4*x + (2*a*c^3*(b*c + 2*a*d)*x^5)/5 + (c^2*(b^2*c^2 + 8*a*b*c*d + 6*a^2*d^2)*x^9)/9 + (4*c*d*(b^2*c^2 + 3*a*b*c*d + a^2*d^2)*x^13)/13 + (d^2*(6*b^2*c^2 + 8*a*b*c*d + a^2*d^2)*x^17)/17 + (2*b*d^3*(2*b*c + a*d)*x^21)/21 + (b^2*d^4*x^25)/25", //
        380);
  }

  // {380}
  public void test3129() {
    check( //
        "Integrate[(a + b*x^4)^2*(c + d*x^4)^3, x]", //
        "a^2*c^3*x + (a*c^2*(2*b*c + 3*a*d)*x^5)/5 + (c*(b^2*c^2 + 6*a*b*c*d + 3*a^2*d^2)*x^9)/9 + (d*(3*b^2*c^2 + 6*a*b*c*d + a^2*d^2)*x^13)/13 + (b*d^2*(3*b*c + 2*a*d)*x^17)/17 + (b^2*d^3*x^21)/21", //
        380);
  }

  // {380}
  public void test3130() {
    check( //
        "Integrate[(a + b*x^4)^2*(c + d*x^4)^2, x]", //
        "a^2*c^2*x + (2*a*c*(b*c + a*d)*x^5)/5 + ((b^2*c^2 + 4*a*b*c*d + a^2*d^2)*x^9)/9 + (2*b*d*(b*c + a*d)*x^13)/13 + (b^2*d^2*x^17)/17", //
        380);
  }

  // {380}
  public void test3131() {
    check( //
        "Integrate[(a + b*x^4)^2*(c + d*x^4), x]", //
        "a^2*c*x + (a*(2*b*c + a*d)*x^5)/5 + (b*(b*c + 2*a*d)*x^9)/9 + (b^2*d*x^13)/13", //
        380);
  }

  // {441, 440}
  public void test3132() {
    check( //
        "Integrate[(c + d*x^4)^q/(a + b*x^4), x]", //
        "(x*(c + d*x^4)^q*AppellF1[1/4, 1, -q, 5/4, -((b*x^4)/a), -((d*x^4)/c)])/(a*(1 + (d*x^4)/c)^q)", //
        441,
        440);
  }

  // {441, 440}
  public void test3133() {
    check( //
        "Integrate[(c + d*x^4)^q/(a + b*x^4)^2, x]", //
        "(x*(c + d*x^4)^q*AppellF1[1/4, 2, -q, 5/4, -((b*x^4)/a), -((d*x^4)/c)])/(a^2*(1 + (d*x^4)/c)^q)", //
        441,
        440);
  }

  // {380}
  public void test3134() {
    check( //
        "Integrate[(a + b*x^n)*(c + d*x^n)^4, x]", //
        "a*c^4*x + (c^3*(b*c + 4*a*d)*x^(1 + n))/(1 + n) + (2*c^2*d*(2*b*c + 3*a*d)*x^(1 + 2*n))/(1 + 2*n) + (2*c*d^2*(3*b*c + 2*a*d)*x^(1 + 3*n))/(1 + 3*n) + (d^3*(4*b*c + a*d)*x^(1 + 4*n))/(1 + 4*n) + (b*d^4*x^(1 + 5*n))/(1 + 5*n)", //
        380);
  }

  // {380}
  public void test3135() {
    check( //
        "Integrate[(a + b*x^n)*(c + d*x^n)^3, x]", //
        "a*c^3*x + (c^2*(b*c + 3*a*d)*x^(1 + n))/(1 + n) + (3*c*d*(b*c + a*d)*x^(1 + 2*n))/(1 + 2*n) + (d^2*(3*b*c + a*d)*x^(1 + 3*n))/(1 + 3*n) + (b*d^3*x^(1 + 4*n))/(1 + 4*n)", //
        380);
  }

  // {380}
  public void test3136() {
    check( //
        "Integrate[(a + b*x^n)*(c + d*x^n)^2, x]", //
        "a*c^2*x + (c*(b*c + 2*a*d)*x^(1 + n))/(1 + n) + (d*(2*b*c + a*d)*x^(1 + 2*n))/(1 + 2*n) + (b*d^2*x^(1 + 3*n))/(1 + 3*n)", //
        380);
  }

  // {380}
  public void test3137() {
    check( //
        "Integrate[(a + b*x^n)*(c + d*x^n), x]", //
        "a*c*x + ((b*c + a*d)*x^(1 + n))/(1 + n) + (b*d*x^(1 + 2*n))/(1 + 2*n)", //
        380);
  }

  // {396, 251}
  public void test3138() {
    check( //
        "Integrate[(a + b*x^n)/(c + d*x^n), x]", //
        "(b*x)/d - ((b*c - a*d)*x*Hypergeometric2F1[1, n^(-1), 1 + n^(-1), -((d*x^n)/c)])/(c*d)", //
        396,
        251);
  }

  // {393, 251}
  public void test3139() {
    check( //
        "Integrate[(a + b*x^n)/(c + d*x^n)^2, x]", //
        "-(((b*c - a*d)*x)/(c*d*n*(c + d*x^n))) + ((b*c - a*d*(1 - n))*x*Hypergeometric2F1[1, n^(-1), 1 + n^(-1), -((d*x^n)/c)])/(c^2*d*n)", //
        393,
        251);
  }

  // {393, 251}
  public void test3140() {
    check( //
        "Integrate[(a + b*x^n)/(c + d*x^n)^3, x]", //
        "-((b*c - a*d)*x)/(2*c*d*n*(c + d*x^n)^2) + ((b*c - a*d*(1 - 2*n))*x*Hypergeometric2F1[2, n^(-1), 1 + n^(-1), -((d*x^n)/c)])/(2*c^3*d*n)", //
        393,
        251);
  }

  // {393, 251}
  public void test3141() {
    check( //
        "Integrate[(a + b*x^n)/(c + d*x^n)^4, x]", //
        "-((b*c - a*d)*x)/(3*c*d*n*(c + d*x^n)^3) + ((b*c - a*d*(1 - 3*n))*x*Hypergeometric2F1[3, n^(-1), 1 + n^(-1), -((d*x^n)/c)])/(3*c^4*d*n)", //
        393,
        251);
  }

  // {380}
  public void test3142() {
    check( //
        "Integrate[(a + b*x^n)^2*(d + e*x^n)^3, x]", //
        "a^2*d^3*x + (a*d^2*(2*b*d + 3*a*e)*x^(1 + n))/(1 + n) + (d*(b^2*d^2 + 6*a*b*d*e + 3*a^2*e^2)*x^(1 + 2*n))/(1 + 2*n) + (e*(3*b^2*d^2 + 6*a*b*d*e + a^2*e^2)*x^(1 + 3*n))/(1 + 3*n) + (b*e^2*(3*b*d + 2*a*e)*x^(1 + 4*n))/(1 + 4*n) + (b^2*e^3*x^(1 + 5*n))/(1 + 5*n)", //
        380);
  }

  // {380}
  public void test3143() {
    check( //
        "Integrate[(a + b*x^n)^2*(d + e*x^n)^2, x]", //
        "a^2*d^2*x + (2*a*d*(b*d + a*e)*x^(1 + n))/(1 + n) + ((b^2*d^2 + 4*a*b*d*e + a^2*e^2)*x^(1 + 2*n))/(1 + 2*n) + (2*b*e*(b*d + a*e)*x^(1 + 3*n))/(1 + 3*n) + (b^2*e^2*x^(1 + 4*n))/(1 + 4*n)", //
        380);
  }

  // {380}
  public void test3144() {
    check( //
        "Integrate[(a + b*x^n)^2*(c + d*x^n), x]", //
        "a^2*c*x + (a*(2*b*c + a*d)*x^(1 + n))/(1 + n) + (b*(b*c + 2*a*d)*x^(1 + 2*n))/(1 + 2*n) + (b^2*d*x^(1 + 3*n))/(1 + 3*n)", //
        380);
  }

  // {396, 251}
  public void test3145() {
    check( //
        "Integrate[(c + d*x^n)/(a + b*x^n), x]", //
        "(d*x)/b + ((b*c - a*d)*x*Hypergeometric2F1[1, n^(-1), 1 + n^(-1), -((b*x^n)/a)])/(a*b)", //
        396,
        251);
  }

  // {393, 251}
  public void test3146() {
    check( //
        "Integrate[(c + d*x^n)/(a + b*x^n)^2, x]", //
        "((b*c - a*d)*x)/(a*b*n*(a + b*x^n)) + ((a*d - b*c*(1 - n))*x*Hypergeometric2F1[1, n^(-1), 1 + n^(-1), -((b*x^n)/a)])/(a^2*b*n)", //
        393,
        251);
  }

  // {252, 251}
  public void test3147() {
    check( //
        "Integrate[(a + b*x^n)^p, x]", //
        "(x*(a + b*x^n)^p*Hypergeometric2F1[n^(-1), -p, 1 + n^(-1), -((b*x^n)/a)])/(1 + (b*x^n)/a)^p", //
        252,
        251);
  }

  // {441, 440}
  public void test3148() {
    check( //
        "Integrate[(a + b*x^n)^p/(c + d*x^n), x]", //
        "(x*(a + b*x^n)^p*AppellF1[n^(-1), -p, 1, 1 + n^(-1), -((b*x^n)/a), -((d*x^n)/c)])/(c*(1 + (b*x^n)/a)^p)", //
        441,
        440);
  }

  // {441, 440}
  public void test3149() {
    check( //
        "Integrate[(a + b*x^n)^p/(c + d*x^n)^2, x]", //
        "(x*(a + b*x^n)^p*AppellF1[n^(-1), -p, 2, 1 + n^(-1), -((b*x^n)/a), -((d*x^n)/c)])/(c^2*(1 + (b*x^n)/a)^p)", //
        441,
        440);
  }

  // {441, 440}
  public void test3150() {
    check( //
        "Integrate[(a + b*x^n)^p/(c + d*x^n)^3, x]", //
        "(x*(a + b*x^n)^p*AppellF1[n^(-1), -p, 3, 1 + n^(-1), -((b*x^n)/a), -((d*x^n)/c)])/(c^3*(1 + (b*x^n)/a)^p)", //
        441,
        440);
  }

  // {386, 197}
  public void test3151() {
    check( //
        "Integrate[(a + b*x^n)*(c + d*x^n)^(-2 - n^(-1)), x]", //
        "(x*(a + b*x^n)*(c + d*x^n)^(-1 - n^(-1)))/(c*(1 + n)) + (a*n*x)/(c^2*(1 + n)*(c + d*x^n)^n^(-1))", //
        386,
        197);
  }

  // {390, 388}
  public void test3152() {
    check( //
        "Integrate[(a + b*x^n)^p*(c + d*x^n)^(-2 - n^(-1) - p), x]", //
        "-((b*x*(a + b*x^n)^(1 + p)*(c + d*x^n)^(-1 - n^(-1) - p))/(a*(b*c - a*d)*n*(1 + p))) + ((1 + (b*c)/((b*c - a*d)*n*(1 + p)))*x*(a + b*x^n)^(1 + p)*((c*(a + b*x^n))/(a*(c + d*x^n)))^(-1 - p)*(c + d*x^n)^(-1 - n^(-1) - p)*Hypergeometric2F1[n^(-1), -1 - p, 1 + n^(-1), -(((b*c - a*d)*x^n)/(a*(c + d*x^n)))])/(a*c)", //
        390,
        388);
  }

  // {198, 197}
  public void test3153() {
    check( //
        "Integrate[(c + d*x^n)^(-2 - n^(-1)), x]", //
        "(x*(c + d*x^n)^(-1 - n^(-1)))/(c*(1 + n)) + (n*x)/(c^2*(1 + n)*(c + d*x^n)^n^(-1))", //
        198,
        197);
  }

  // {390, 387}
  public void test3154() {
    check( //
        "Integrate[(c + d*x^n)^(-1 - n^(-1))/(a + b*x^n), x]", //
        "-((d*x)/(c*(b*c - a*d)*(c + d*x^n)^n^(-1))) + (b*x*Hypergeometric2F1[1, n^(-1), 1 + n^(-1), -(((b*c - a*d)*x^n)/(a*(c + d*x^n)))])/(a*(b*c - a*d)*(c + d*x^n)^n^(-1))", //
        390,
        387);
  }

  // {390, 387}
  public void test3155() {
    check( //
        "Integrate[1/((a + b*x^n)^2*(c + d*x^n)^n^(-1)), x]", //
        "(b*x)/(a*(b*c - a*d)*n*(a + b*x^n)*(c + d*x^n)^((1 - n)/n)) - ((b*c*(1 - n) + a*d*n)*x*Hypergeometric2F1[1, n^(-1), 1 + n^(-1), -(((b*c - a*d)*x^n)/(a*(c + d*x^n)))])/(a^2*(b*c - a*d)*n*(c + d*x^n)^n^(-1))", //
        390,
        387);
  }

  // {390, 387}
  public void test3156() {
    check( //
        "Integrate[(c + d*x^n)^(1 - n^(-1))/(a + b*x^n)^3, x]", //
        "(b*x*(c + d*x^n)^(2 - n^(-1)))/(2*a*(b*c - a*d)*n*(a + b*x^n)^2) - (c*(b*c*(1 - 2*n) + 2*a*d*n)*x*Hypergeometric2F1[2, n^(-1), 1 + n^(-1), -(((b*c - a*d)*x^n)/(a*(c + d*x^n)))])/(2*a^3*(b*c - a*d)*n*(c + d*x^n)^n^(-1))", //
        390,
        387);
  }

  // {390, 387}
  public void test3157() {
    check( //
        "Integrate[(c + d*x^n)^(2 - n^(-1))/(a + b*x^n)^4, x]", //
        "(b*x*(c + d*x^n)^(3 - n^(-1)))/(3*a*(b*c - a*d)*n*(a + b*x^n)^3) - (c^2*(b*c*(1 - 3*n) + 3*a*d*n)*x*Hypergeometric2F1[3, n^(-1), 1 + n^(-1), -(((b*c - a*d)*x^n)/(a*(c + d*x^n)))])/(3*a^4*(b*c - a*d)*n*(c + d*x^n)^n^(-1))", //
        390,
        387);
  }

  // {471, 75}
  public void test3158() {
    check( //
        "Integrate[(x*(a + b*x^2))/(Sqrt[-1 + c*x]*Sqrt[1 + c*x]), x]", //
        "((2*b + 3*a*c^2)*Sqrt[-1 + c*x]*Sqrt[1 + c*x])/(3*c^4) + (b*x^2*Sqrt[-1 + c*x]*Sqrt[1 + c*x])/(3*c^2)", //
        471,
        75);
  }

  // {397, 54}
  public void test3159() {
    check( //
        "Integrate[(a + b*x^2)/(Sqrt[-1 + c*x]*Sqrt[1 + c*x]), x]", //
        "(b*x*Sqrt[-1 + c*x]*Sqrt[1 + c*x])/(2*c^2) + ((b + 2*a*c^2)*ArcCosh[c*x])/(2*c^3)", //
        397,
        54);
  }

  // {465, 54}
  public void test3160() {
    check( //
        "Integrate[(a + b*x^2)/(x^2*Sqrt[-1 + c*x]*Sqrt[1 + c*x]), x]", //
        "(a*Sqrt[-1 + c*x]*Sqrt[1 + c*x])/x + (b*ArcCosh[c*x])/c", //
        465,
        54);
  }

  // {465, 97}
  public void test3161() {
    check( //
        "Integrate[(a + b*x^2)/(x^4*Sqrt[-1 + c*x]*Sqrt[1 + c*x]), x]", //
        "(a*Sqrt[-1 + c*x]*Sqrt[1 + c*x])/(3*x^3) + ((3*b + 2*a*c^2)*Sqrt[-1 + c*x]*Sqrt[1 + c*x])/(3*x)", //
        465,
        97);
  }

  // {471, 75}
  public void test3162() {
    check( //
        "Integrate[(x*(a + b*x^2))/(Sqrt[-c + d*x]*Sqrt[c + d*x]), x]", //
        "((2*b*c^2 + 3*a*d^2)*Sqrt[-c + d*x]*Sqrt[c + d*x])/(3*d^4) + (b*x^2*Sqrt[-c + d*x]*Sqrt[c + d*x])/(3*d^2)", //
        471,
        75);
  }

  // {465, 97}
  public void test3163() {
    check( //
        "Integrate[(a + b*x^2)/(x^4*Sqrt[-c + d*x]*Sqrt[c + d*x]), x]", //
        "(a*Sqrt[-c + d*x]*Sqrt[c + d*x])/(3*c^2*x^3) + ((3*b*c^2 + 2*a*d^2)*Sqrt[-c + d*x]*Sqrt[c + d*x])/(3*c^4*x)", //
        465,
        97);
  }

  // {469, 75}
  public void test3164() {
    check( //
        "Integrate[(x*(a + b*x^2))/((-c + d*x)^(3/2)*(c + d*x)^(3/2)), x]", //
        "-(((a/c^2 + b/d^2)*x^2)/(Sqrt[-c + d*x]*Sqrt[c + d*x])) + ((a/c^2 + (2*b)/d^2)*Sqrt[-c + d*x]*Sqrt[c + d*x])/d^2", //
        469,
        75);
  }

  // {465, 39}
  public void test3165() {
    check( //
        "Integrate[(a + b*x^2)/(x^2*(-c + d*x)^(3/2)*(c + d*x)^(3/2)), x]", //
        "a/(c^2*x*Sqrt[-c + d*x]*Sqrt[c + d*x]) - ((b*c^2 + 2*a*d^2)*x)/(c^4*Sqrt[-c + d*x]*Sqrt[c + d*x])", //
        465,
        39);
  }

  // {459}
  public void test3166() {
    check( //
        "Integrate[x*(a + b*x^3)*(A + B*x^3), x]", //
        "(a*A*x^2)/2 + ((A*b + a*B)*x^5)/5 + (b*B*x^8)/8", //
        459);
  }

  // {380}
  public void test3167() {
    check( //
        "Integrate[(a + b*x^3)*(A + B*x^3), x]", //
        "a*A*x + ((A*b + a*B)*x^4)/4 + (b*B*x^7)/7", //
        380);
  }

  // {459}
  public void test3168() {
    check( //
        "Integrate[((a + b*x^3)*(A + B*x^3))/x^2, x]", //
        "-((a*A)/x) + ((A*b + a*B)*x^2)/2 + (b*B*x^5)/5", //
        459);
  }

  // {459}
  public void test3169() {
    check( //
        "Integrate[((a + b*x^3)*(A + B*x^3))/x^3, x]", //
        "-(a*A)/(2*x^2) + (A*b + a*B)*x + (b*B*x^4)/4", //
        459);
  }

  // {459}
  public void test3170() {
    check( //
        "Integrate[((a + b*x^3)*(A + B*x^3))/x^5, x]", //
        "-(a*A)/(4*x^4) - (A*b + a*B)/x + (b*B*x^2)/2", //
        459);
  }

  // {459}
  public void test3171() {
    check( //
        "Integrate[((a + b*x^3)*(A + B*x^3))/x^6, x]", //
        "-(a*A)/(5*x^5) - (A*b + a*B)/(2*x^2) + b*B*x", //
        459);
  }

  // {459}
  public void test3172() {
    check( //
        "Integrate[x*(a + b*x^3)^2*(A + B*x^3), x]", //
        "(a^2*A*x^2)/2 + (a*(2*A*b + a*B)*x^5)/5 + (b*(A*b + 2*a*B)*x^8)/8 + (b^2*B*x^11)/11", //
        459);
  }

  // {380}
  public void test3173() {
    check( //
        "Integrate[(a + b*x^3)^2*(A + B*x^3), x]", //
        "a^2*A*x + (a*(2*A*b + a*B)*x^4)/4 + (b*(A*b + 2*a*B)*x^7)/7 + (b^2*B*x^10)/10", //
        380);
  }

  // {459}
  public void test3174() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^2, x]", //
        "-((a^2*A)/x) + (a*(2*A*b + a*B)*x^2)/2 + (b*(A*b + 2*a*B)*x^5)/5 + (b^2*B*x^8)/8", //
        459);
  }

  // {459}
  public void test3175() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^3, x]", //
        "-(a^2*A)/(2*x^2) + a*(2*A*b + a*B)*x + (b*(A*b + 2*a*B)*x^4)/4 + (b^2*B*x^7)/7", //
        459);
  }

  // {459}
  public void test3176() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^5, x]", //
        "-(a^2*A)/(4*x^4) - (a*(2*A*b + a*B))/x + (b*(A*b + 2*a*B)*x^2)/2 + (b^2*B*x^5)/5", //
        459);
  }

  // {459}
  public void test3177() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^6, x]", //
        "-(a^2*A)/(5*x^5) - (a*(2*A*b + a*B))/(2*x^2) + b*(A*b + 2*a*B)*x + (b^2*B*x^4)/4", //
        459);
  }

  // {459}
  public void test3178() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^8, x]", //
        "-(a^2*A)/(7*x^7) - (a*(2*A*b + a*B))/(4*x^4) - (b*(A*b + 2*a*B))/x + (b^2*B*x^2)/2", //
        459);
  }

  // {459}
  public void test3179() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^9, x]", //
        "-(a^2*A)/(8*x^8) - (a*(2*A*b + a*B))/(5*x^5) - (b*(A*b + 2*a*B))/(2*x^2) + b^2*B*x", //
        459);
  }

  // {459}
  public void test3180() {
    check( //
        "Integrate[x^9*(a + b*x^3)^5*(A + B*x^3), x]", //
        "(a^5*A*x^10)/10 + (a^4*(5*A*b + a*B)*x^13)/13 + (5*a^3*b*(2*A*b + a*B)*x^16)/16 + (10*a^2*b^2*(A*b + a*B)*x^19)/19 + (5*a*b^3*(A*b + 2*a*B)*x^22)/22 + (b^4*(A*b + 5*a*B)*x^25)/25 + (b^5*B*x^28)/28", //
        459);
  }

  // {459}
  public void test3181() {
    check( //
        "Integrate[x^7*(a + b*x^3)^5*(A + B*x^3), x]", //
        "(a^5*A*x^8)/8 + (a^4*(5*A*b + a*B)*x^11)/11 + (5*a^3*b*(2*A*b + a*B)*x^14)/14 + (10*a^2*b^2*(A*b + a*B)*x^17)/17 + (a*b^3*(A*b + 2*a*B)*x^20)/4 + (b^4*(A*b + 5*a*B)*x^23)/23 + (b^5*B*x^26)/26", //
        459);
  }

  // {459}
  public void test3182() {
    check( //
        "Integrate[x^6*(a + b*x^3)^5*(A + B*x^3), x]", //
        "(a^5*A*x^7)/7 + (a^4*(5*A*b + a*B)*x^10)/10 + (5*a^3*b*(2*A*b + a*B)*x^13)/13 + (5*a^2*b^2*(A*b + a*B)*x^16)/8 + (5*a*b^3*(A*b + 2*a*B)*x^19)/19 + (b^4*(A*b + 5*a*B)*x^22)/22 + (b^5*B*x^25)/25", //
        459);
  }

  // {459}
  public void test3183() {
    check( //
        "Integrate[x^4*(a + b*x^3)^5*(A + B*x^3), x]", //
        "(a^5*A*x^5)/5 + (a^4*(5*A*b + a*B)*x^8)/8 + (5*a^3*b*(2*A*b + a*B)*x^11)/11 + (5*a^2*b^2*(A*b + a*B)*x^14)/7 + (5*a*b^3*(A*b + 2*a*B)*x^17)/17 + (b^4*(A*b + 5*a*B)*x^20)/20 + (b^5*B*x^23)/23", //
        459);
  }

  // {459}
  public void test3184() {
    check( //
        "Integrate[x^3*(a + b*x^3)^5*(A + B*x^3), x]", //
        "(a^5*A*x^4)/4 + (a^4*(5*A*b + a*B)*x^7)/7 + (a^3*b*(2*A*b + a*B)*x^10)/2 + (10*a^2*b^2*(A*b + a*B)*x^13)/13 + (5*a*b^3*(A*b + 2*a*B)*x^16)/16 + (b^4*(A*b + 5*a*B)*x^19)/19 + (b^5*B*x^22)/22", //
        459);
  }

  // {459}
  public void test3185() {
    check( //
        "Integrate[x*(a + b*x^3)^5*(A + B*x^3), x]", //
        "(a^5*A*x^2)/2 + (a^4*(5*A*b + a*B)*x^5)/5 + (5*a^3*b*(2*A*b + a*B)*x^8)/8 + (10*a^2*b^2*(A*b + a*B)*x^11)/11 + (5*a*b^3*(A*b + 2*a*B)*x^14)/14 + (b^4*(A*b + 5*a*B)*x^17)/17 + (b^5*B*x^20)/20", //
        459);
  }

  // {380}
  public void test3186() {
    check( //
        "Integrate[(a + b*x^3)^5*(A + B*x^3), x]", //
        "a^5*A*x + (a^4*(5*A*b + a*B)*x^4)/4 + (5*a^3*b*(2*A*b + a*B)*x^7)/7 + a^2*b^2*(A*b + a*B)*x^10 + (5*a*b^3*(A*b + 2*a*B)*x^13)/13 + (b^4*(A*b + 5*a*B)*x^16)/16 + (b^5*B*x^19)/19", //
        380);
  }

  // {459}
  public void test3187() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^2, x]", //
        "-((a^5*A)/x) + (a^4*(5*A*b + a*B)*x^2)/2 + a^3*b*(2*A*b + a*B)*x^5 + (5*a^2*b^2*(A*b + a*B)*x^8)/4 + (5*a*b^3*(A*b + 2*a*B)*x^11)/11 + (b^4*(A*b + 5*a*B)*x^14)/14 + (b^5*B*x^17)/17", //
        459);
  }

  // {459}
  public void test3188() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^3, x]", //
        "-(a^5*A)/(2*x^2) + a^4*(5*A*b + a*B)*x + (5*a^3*b*(2*A*b + a*B)*x^4)/4 + (10*a^2*b^2*(A*b + a*B)*x^7)/7 + (a*b^3*(A*b + 2*a*B)*x^10)/2 + (b^4*(A*b + 5*a*B)*x^13)/13 + (b^5*B*x^16)/16", //
        459);
  }

  // {459}
  public void test3189() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^5, x]", //
        "-(a^5*A)/(4*x^4) - (a^4*(5*A*b + a*B))/x + (5*a^3*b*(2*A*b + a*B)*x^2)/2 + 2*a^2*b^2*(A*b + a*B)*x^5 + (5*a*b^3*(A*b + 2*a*B)*x^8)/8 + (b^4*(A*b + 5*a*B)*x^11)/11 + (b^5*B*x^14)/14", //
        459);
  }

  // {459}
  public void test3190() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^6, x]", //
        "-(a^5*A)/(5*x^5) - (a^4*(5*A*b + a*B))/(2*x^2) + 5*a^3*b*(2*A*b + a*B)*x + (5*a^2*b^2*(A*b + a*B)*x^4)/2 + (5*a*b^3*(A*b + 2*a*B)*x^7)/7 + (b^4*(A*b + 5*a*B)*x^10)/10 + (b^5*B*x^13)/13", //
        459);
  }

  // {459}
  public void test3191() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^8, x]", //
        "-(a^5*A)/(7*x^7) - (a^4*(5*A*b + a*B))/(4*x^4) - (5*a^3*b*(2*A*b + a*B))/x + 5*a^2*b^2*(A*b + a*B)*x^2 + a*b^3*(A*b + 2*a*B)*x^5 + (b^4*(A*b + 5*a*B)*x^8)/8 + (b^5*B*x^11)/11", //
        459);
  }

  // {459}
  public void test3192() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^9, x]", //
        "-(a^5*A)/(8*x^8) - (a^4*(5*A*b + a*B))/(5*x^5) - (5*a^3*b*(2*A*b + a*B))/(2*x^2) + 10*a^2*b^2*(A*b + a*B)*x + (5*a*b^3*(A*b + 2*a*B)*x^4)/4 + (b^4*(A*b + 5*a*B)*x^7)/7 + (b^5*B*x^10)/10", //
        459);
  }

  // {459}
  public void test3193() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^11, x]", //
        "-(a^5*A)/(10*x^10) - (a^4*(5*A*b + a*B))/(7*x^7) - (5*a^3*b*(2*A*b + a*B))/(4*x^4) - (10*a^2*b^2*(A*b + a*B))/x + (5*a*b^3*(A*b + 2*a*B)*x^2)/2 + (b^4*(A*b + 5*a*B)*x^5)/5 + (b^5*B*x^8)/8", //
        459);
  }

  // {459}
  public void test3194() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^12, x]", //
        "-(a^5*A)/(11*x^11) - (a^4*(5*A*b + a*B))/(8*x^8) - (a^3*b*(2*A*b + a*B))/x^5 - (5*a^2*b^2*(A*b + a*B))/x^2 + 5*a*b^3*(A*b + 2*a*B)*x + (b^4*(A*b + 5*a*B)*x^4)/4 + (b^5*B*x^7)/7", //
        459);
  }

  // {459}
  public void test3195() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^14, x]", //
        "-(a^5*A)/(13*x^13) - (a^4*(5*A*b + a*B))/(10*x^10) - (5*a^3*b*(2*A*b + a*B))/(7*x^7) - (5*a^2*b^2*(A*b + a*B))/(2*x^4) - (5*a*b^3*(A*b + 2*a*B))/x + (b^4*(A*b + 5*a*B)*x^2)/2 + (b^5*B*x^5)/5", //
        459);
  }

  // {459}
  public void test3196() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^15, x]", //
        "-(a^5*A)/(14*x^14) - (a^4*(5*A*b + a*B))/(11*x^11) - (5*a^3*b*(2*A*b + a*B))/(8*x^8) - (2*a^2*b^2*(A*b + a*B))/x^5 - (5*a*b^3*(A*b + 2*a*B))/(2*x^2) + b^4*(A*b + 5*a*B)*x + (b^5*B*x^4)/4", //
        459);
  }

  // {459}
  public void test3197() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^17, x]", //
        "-(a^5*A)/(16*x^16) - (a^4*(5*A*b + a*B))/(13*x^13) - (a^3*b*(2*A*b + a*B))/(2*x^10) - (10*a^2*b^2*(A*b + a*B))/(7*x^7) - (5*a*b^3*(A*b + 2*a*B))/(4*x^4) - (b^4*(A*b + 5*a*B))/x + (b^5*B*x^2)/2", //
        459);
  }

  // {459}
  public void test3198() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^18, x]", //
        "-(a^5*A)/(17*x^17) - (a^4*(5*A*b + a*B))/(14*x^14) - (5*a^3*b*(2*A*b + a*B))/(11*x^11) - (5*a^2*b^2*(A*b + a*B))/(4*x^8) - (a*b^3*(A*b + 2*a*B))/x^5 - (b^4*(A*b + 5*a*B))/(2*x^2) + b^5*B*x", //
        459);
  }

  // {459}
  public void test3199() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^20, x]", //
        "-(a^5*A)/(19*x^19) - (a^4*(5*A*b + a*B))/(16*x^16) - (5*a^3*b*(2*A*b + a*B))/(13*x^13) - (a^2*b^2*(A*b + a*B))/x^10 - (5*a*b^3*(A*b + 2*a*B))/(7*x^7) - (b^4*(A*b + 5*a*B))/(4*x^4) - (b^5*B)/x", //
        459);
  }

  // {459}
  public void test3200() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^21, x]", //
        "-(a^5*A)/(20*x^20) - (a^4*(5*A*b + a*B))/(17*x^17) - (5*a^3*b*(2*A*b + a*B))/(14*x^14) - (10*a^2*b^2*(A*b + a*B))/(11*x^11) - (5*a*b^3*(A*b + 2*a*B))/(8*x^8) - (b^4*(A*b + 5*a*B))/(5*x^5) - (b^5*B)/(2*x^2)", //
        459);
  }

  // {459}
  public void test3201() {
    check( //
        "Integrate[((a + b*x^3)^5*(A + B*x^3))/x^23, x]", //
        "-(a^5*A)/(22*x^22) - (a^4*(5*A*b + a*B))/(19*x^19) - (5*a^3*b*(2*A*b + a*B))/(16*x^16) - (10*a^2*b^2*(A*b + a*B))/(13*x^13) - (a*b^3*(A*b + 2*a*B))/(2*x^10) - (b^4*(A*b + 5*a*B))/(7*x^7) - (b^5*B)/(4*x^4)", //
        459);
  }

  // {455, 37}
  public void test3202() {
    check( //
        "Integrate[(x^2*(A + B*x^3))/(a + b*x^3)^3, x]", //
        "-(A + B*x^3)^2/(6*(A*b - a*B)*(a + b*x^3)^2)", //
        455,
        37);
  }

  // {459}
  public void test3203() {
    check( //
        "Integrate[x^m*(a + b*x^3)^5*(A + B*x^3), x]", //
        "(a^5*A*x^(1 + m))/(1 + m) + (a^4*(5*A*b + a*B)*x^(4 + m))/(4 + m) + (5*a^3*b*(2*A*b + a*B)*x^(7 + m))/(7 + m) + (10*a^2*b^2*(A*b + a*B)*x^(10 + m))/(10 + m) + (5*a*b^3*(A*b + 2*a*B)*x^(13 + m))/(13 + m) + (b^4*(A*b + 5*a*B)*x^(16 + m))/(16 + m) + (b^5*B*x^(19 + m))/(19 + m)", //
        459);
  }

  // {459}
  public void test3204() {
    check( //
        "Integrate[x^m*(a + b*x^3)^2*(A + B*x^3), x]", //
        "(a^2*A*x^(1 + m))/(1 + m) + (a*(2*A*b + a*B)*x^(4 + m))/(4 + m) + (b*(A*b + 2*a*B)*x^(7 + m))/(7 + m) + (b^2*B*x^(10 + m))/(10 + m)", //
        459);
  }

  // {459}
  public void test3205() {
    check( //
        "Integrate[x^m*(a + b*x^3)*(A + B*x^3), x]", //
        "(a*A*x^(1 + m))/(1 + m) + ((A*b + a*B)*x^(4 + m))/(4 + m) + (b*B*x^(7 + m))/(7 + m)", //
        459);
  }

  // {470, 371}
  public void test3206() {
    check( //
        "Integrate[(x^m*(A + B*x^3))/(a + b*x^3), x]", //
        "(B*x^(1 + m))/(b*(1 + m)) + ((A*b - a*B)*x^(1 + m)*Hypergeometric2F1[1, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(a*b*(1 + m))", //
        470,
        371);
  }

  // {468, 371}
  public void test3207() {
    check( //
        "Integrate[(x^m*(A + B*x^3))/(a + b*x^3)^2, x]", //
        "((A*b - a*B)*x^(1 + m))/(3*a*b*(a + b*x^3)) + ((A*b*(2 - m) + a*B*(1 + m))*x^(1 + m)*Hypergeometric2F1[1, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(3*a^2*b*(1 + m))", //
        468,
        371);
  }

  // {468, 371}
  public void test3208() {
    check( //
        "Integrate[(x^m*(A + B*x^3))/(a + b*x^3)^3, x]", //
        "((A*b - a*B)*x^(1 + m))/(6*a*b*(a + b*x^3)^2) + ((A*b*(5 - m) + a*B*(1 + m))*x^(1 + m)*Hypergeometric2F1[2, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(6*a^3*b*(1 + m))", //
        468,
        371);
  }

  // {459}
  public void test3209() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^3)*(A + B*x^3), x]", //
        "(2*a*A*x^(9/2))/9 + (2*(A*b + a*B)*x^(15/2))/15 + (2*b*B*x^(21/2))/21", //
        459);
  }

  // {459}
  public void test3210() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^3)*(A + B*x^3), x]", //
        "(2*a*A*x^(7/2))/7 + (2*(A*b + a*B)*x^(13/2))/13 + (2*b*B*x^(19/2))/19", //
        459);
  }

  // {459}
  public void test3211() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^3)*(A + B*x^3), x]", //
        "(2*a*A*x^(5/2))/5 + (2*(A*b + a*B)*x^(11/2))/11 + (2*b*B*x^(17/2))/17", //
        459);
  }

  // {459}
  public void test3212() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^3)*(A + B*x^3), x]", //
        "(2*a*A*x^(3/2))/3 + (2*(A*b + a*B)*x^(9/2))/9 + (2*b*B*x^(15/2))/15", //
        459);
  }

  // {459}
  public void test3213() {
    check( //
        "Integrate[((a + b*x^3)*(A + B*x^3))/Sqrt[x], x]", //
        "2*a*A*Sqrt[x] + (2*(A*b + a*B)*x^(7/2))/7 + (2*b*B*x^(13/2))/13", //
        459);
  }

  // {459}
  public void test3214() {
    check( //
        "Integrate[((a + b*x^3)*(A + B*x^3))/x^(3/2), x]", //
        "(-2*a*A)/Sqrt[x] + (2*(A*b + a*B)*x^(5/2))/5 + (2*b*B*x^(11/2))/11", //
        459);
  }

  // {459}
  public void test3215() {
    check( //
        "Integrate[((a + b*x^3)*(A + B*x^3))/x^(5/2), x]", //
        "(-2*a*A)/(3*x^(3/2)) + (2*(A*b + a*B)*x^(3/2))/3 + (2*b*B*x^(9/2))/9", //
        459);
  }

  // {459}
  public void test3216() {
    check( //
        "Integrate[((a + b*x^3)*(A + B*x^3))/x^(7/2), x]", //
        "(-2*a*A)/(5*x^(5/2)) + 2*(A*b + a*B)*Sqrt[x] + (2*b*B*x^(7/2))/7", //
        459);
  }

  // {459}
  public void test3217() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^3)^2*(A + B*x^3), x]", //
        "(2*a^2*A*x^(9/2))/9 + (2*a*(2*A*b + a*B)*x^(15/2))/15 + (2*b*(A*b + 2*a*B)*x^(21/2))/21 + (2*b^2*B*x^(27/2))/27", //
        459);
  }

  // {459}
  public void test3218() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^3)^2*(A + B*x^3), x]", //
        "(2*a^2*A*x^(7/2))/7 + (2*a*(2*A*b + a*B)*x^(13/2))/13 + (2*b*(A*b + 2*a*B)*x^(19/2))/19 + (2*b^2*B*x^(25/2))/25", //
        459);
  }

  // {459}
  public void test3219() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^3)^2*(A + B*x^3), x]", //
        "(2*a^2*A*x^(5/2))/5 + (2*a*(2*A*b + a*B)*x^(11/2))/11 + (2*b*(A*b + 2*a*B)*x^(17/2))/17 + (2*b^2*B*x^(23/2))/23", //
        459);
  }

  // {459}
  public void test3220() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^3)^2*(A + B*x^3), x]", //
        "(2*a^2*A*x^(3/2))/3 + (2*a*(2*A*b + a*B)*x^(9/2))/9 + (2*b*(A*b + 2*a*B)*x^(15/2))/15 + (2*b^2*B*x^(21/2))/21", //
        459);
  }

  // {459}
  public void test3221() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/Sqrt[x], x]", //
        "2*a^2*A*Sqrt[x] + (2*a*(2*A*b + a*B)*x^(7/2))/7 + (2*b*(A*b + 2*a*B)*x^(13/2))/13 + (2*b^2*B*x^(19/2))/19", //
        459);
  }

  // {459}
  public void test3222() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^(3/2), x]", //
        "(-2*a^2*A)/Sqrt[x] + (2*a*(2*A*b + a*B)*x^(5/2))/5 + (2*b*(A*b + 2*a*B)*x^(11/2))/11 + (2*b^2*B*x^(17/2))/17", //
        459);
  }

  // {459}
  public void test3223() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^(5/2), x]", //
        "(-2*a^2*A)/(3*x^(3/2)) + (2*a*(2*A*b + a*B)*x^(3/2))/3 + (2*b*(A*b + 2*a*B)*x^(9/2))/9 + (2*b^2*B*x^(15/2))/15", //
        459);
  }

  // {459}
  public void test3224() {
    check( //
        "Integrate[((a + b*x^3)^2*(A + B*x^3))/x^(7/2), x]", //
        "(-2*a^2*A)/(5*x^(5/2)) + 2*a*(2*A*b + a*B)*Sqrt[x] + (2*b*(A*b + 2*a*B)*x^(7/2))/7 + (2*b^2*B*x^(13/2))/13", //
        459);
  }

  // {459}
  public void test3225() {
    check( //
        "Integrate[x^(7/2)*(a + b*x^3)^3*(A + B*x^3), x]", //
        "(2*a^3*A*x^(9/2))/9 + (2*a^2*(3*A*b + a*B)*x^(15/2))/15 + (2*a*b*(A*b + a*B)*x^(21/2))/7 + (2*b^2*(A*b + 3*a*B)*x^(27/2))/27 + (2*b^3*B*x^(33/2))/33", //
        459);
  }

  // {459}
  public void test3226() {
    check( //
        "Integrate[x^(5/2)*(a + b*x^3)^3*(A + B*x^3), x]", //
        "(2*a^3*A*x^(7/2))/7 + (2*a^2*(3*A*b + a*B)*x^(13/2))/13 + (6*a*b*(A*b + a*B)*x^(19/2))/19 + (2*b^2*(A*b + 3*a*B)*x^(25/2))/25 + (2*b^3*B*x^(31/2))/31", //
        459);
  }

  // {459}
  public void test3227() {
    check( //
        "Integrate[x^(3/2)*(a + b*x^3)^3*(A + B*x^3), x]", //
        "(2*a^3*A*x^(5/2))/5 + (2*a^2*(3*A*b + a*B)*x^(11/2))/11 + (6*a*b*(A*b + a*B)*x^(17/2))/17 + (2*b^2*(A*b + 3*a*B)*x^(23/2))/23 + (2*b^3*B*x^(29/2))/29", //
        459);
  }

  // {459}
  public void test3228() {
    check( //
        "Integrate[Sqrt[x]*(a + b*x^3)^3*(A + B*x^3), x]", //
        "(2*a^3*A*x^(3/2))/3 + (2*a^2*(3*A*b + a*B)*x^(9/2))/9 + (2*a*b*(A*b + a*B)*x^(15/2))/5 + (2*b^2*(A*b + 3*a*B)*x^(21/2))/21 + (2*b^3*B*x^(27/2))/27", //
        459);
  }

  // {459}
  public void test3229() {
    check( //
        "Integrate[((a + b*x^3)^3*(A + B*x^3))/Sqrt[x], x]", //
        "2*a^3*A*Sqrt[x] + (2*a^2*(3*A*b + a*B)*x^(7/2))/7 + (6*a*b*(A*b + a*B)*x^(13/2))/13 + (2*b^2*(A*b + 3*a*B)*x^(19/2))/19 + (2*b^3*B*x^(25/2))/25", //
        459);
  }

  // {459}
  public void test3230() {
    check( //
        "Integrate[((a + b*x^3)^3*(A + B*x^3))/x^(3/2), x]", //
        "(-2*a^3*A)/Sqrt[x] + (2*a^2*(3*A*b + a*B)*x^(5/2))/5 + (6*a*b*(A*b + a*B)*x^(11/2))/11 + (2*b^2*(A*b + 3*a*B)*x^(17/2))/17 + (2*b^3*B*x^(23/2))/23", //
        459);
  }

  // {459}
  public void test3231() {
    check( //
        "Integrate[((a + b*x^3)^3*(A + B*x^3))/x^(5/2), x]", //
        "(-2*a^3*A)/(3*x^(3/2)) + (2*a^2*(3*A*b + a*B)*x^(3/2))/3 + (2*a*b*(A*b + a*B)*x^(9/2))/3 + (2*b^2*(A*b + 3*a*B)*x^(15/2))/15 + (2*b^3*B*x^(21/2))/21", //
        459);
  }

  // {459}
  public void test3232() {
    check( //
        "Integrate[((a + b*x^3)^3*(A + B*x^3))/x^(7/2), x]", //
        "(-2*a^3*A)/(5*x^(5/2)) + 2*a^2*(3*A*b + a*B)*Sqrt[x] + (6*a*b*(A*b + a*B)*x^(7/2))/7 + (2*b^2*(A*b + 3*a*B)*x^(13/2))/13 + (2*b^3*B*x^(19/2))/19", //
        459);
  }

  // {396, 224}
  public void test3233() {
    check( //
        "Integrate[(A + B*x^3)/Sqrt[a + b*x^3], x]", //
        "(2*B*x*Sqrt[a + b*x^3])/(5*b) + (2*Sqrt[2 + Sqrt[3]]*(5*A*b - 2*a*B)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(5*3^(1/4)*b^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        396,
        224);
  }

  // {464, 224}
  public void test3234() {
    check( //
        "Integrate[(A + B*x^3)/(x^3*Sqrt[a + b*x^3]), x]", //
        "-(A*Sqrt[a + b*x^3])/(2*a*x^2) - (Sqrt[2 + Sqrt[3]]*(A*b - 4*a*B)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(2*3^(1/4)*a*b^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        464,
        224);
  }

  // {393, 224}
  public void test3235() {
    check( //
        "Integrate[(A + B*x^3)/(a + b*x^3)^(3/2), x]", //
        "(2*(A*b - a*B)*x)/(3*a*b*Sqrt[a + b*x^3]) + (2*Sqrt[2 + Sqrt[3]]*(A*b + 2*a*B)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*a*b^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])", //
        393,
        224);
  }

  // {525, 524}
  public void test3236() {
    check( //
        "Integrate[(x^3*Sqrt[c + d*x^3])/(4*c + d*x^3), x]", //
        "(x^4*Sqrt[c + d*x^3]*AppellF1[4/3, 1, -1/2, 7/3, -(d*x^3)/(4*c), -((d*x^3)/c)])/(16*c*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {441, 440}
  public void test3237() {
    check( //
        "Integrate[Sqrt[c + d*x^3]/(4*c + d*x^3), x]", //
        "(x*Sqrt[c + d*x^3]*AppellF1[1/3, 1, -1/2, 4/3, -(d*x^3)/(4*c), -((d*x^3)/c)])/(4*c*Sqrt[1 + (d*x^3)/c])", //
        441,
        440);
  }

  // {525, 524}
  public void test3238() {
    check( //
        "Integrate[Sqrt[c + d*x^3]/(x^3*(4*c + d*x^3)), x]", //
        "-(Sqrt[c + d*x^3]*AppellF1[-2/3, 1, -1/2, 1/3, -(d*x^3)/(4*c), -((d*x^3)/c)])/(8*c*x^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3239() {
    check( //
        "Integrate[x^3/(Sqrt[c + d*x^3]*(4*c + d*x^3)), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 1, 1/2, 7/3, -(d*x^3)/(4*c), -((d*x^3)/c)])/(16*c*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3240() {
    check( //
        "Integrate[1/(Sqrt[c + d*x^3]*(4*c + d*x^3)), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 1, 1/2, 4/3, -(d*x^3)/(4*c), -((d*x^3)/c)])/(4*c*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3241() {
    check( //
        "Integrate[1/(x^3*Sqrt[c + d*x^3]*(4*c + d*x^3)), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 1, 1/2, 1/3, -(d*x^3)/(4*c), -((d*x^3)/c)])/(8*c*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3242() {
    check( //
        "Integrate[x^3/((8*c - d*x^3)*Sqrt[c + d*x^3]), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 1, 1/2, 7/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(32*c*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3243() {
    check( //
        "Integrate[1/((8*c - d*x^3)*Sqrt[c + d*x^3]), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 1, 1/2, 4/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(8*c*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3244() {
    check( //
        "Integrate[1/(x^3*(8*c - d*x^3)*Sqrt[c + d*x^3]), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 1, 1/2, 1/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(16*c*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3245() {
    check( //
        "Integrate[1/(x^6*(8*c - d*x^3)*Sqrt[c + d*x^3]), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-5/3, 1, 1/2, -2/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(40*c*x^5*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3246() {
    check( //
        "Integrate[x^3/((8*c - d*x^3)*(c + d*x^3)^(3/2)), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 1, 3/2, 7/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(32*c^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3247() {
    check( //
        "Integrate[1/((8*c - d*x^3)*(c + d*x^3)^(3/2)), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 1, 3/2, 4/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(8*c^2*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3248() {
    check( //
        "Integrate[1/(x^3*(8*c - d*x^3)*(c + d*x^3)^(3/2)), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 1, 3/2, 1/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(16*c^2*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3249() {
    check( //
        "Integrate[1/(x^6*(8*c - d*x^3)*(c + d*x^3)^(3/2)), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-5/3, 1, 3/2, -2/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(40*c^2*x^5*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3250() {
    check( //
        "Integrate[(x^3*Sqrt[c + d*x^3])/(a + b*x^3), x]", //
        "(x^4*Sqrt[c + d*x^3]*AppellF1[4/3, 1, -1/2, 7/3, -((b*x^3)/a), -((d*x^3)/c)])/(4*a*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3251() {
    check( //
        "Integrate[(x*Sqrt[c + d*x^3])/(a + b*x^3), x]", //
        "(x^2*Sqrt[c + d*x^3]*AppellF1[2/3, 1, -1/2, 5/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {441, 440}
  public void test3252() {
    check( //
        "Integrate[Sqrt[c + d*x^3]/(a + b*x^3), x]", //
        "(x*Sqrt[c + d*x^3]*AppellF1[1/3, 1, -1/2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*Sqrt[1 + (d*x^3)/c])", //
        441,
        440);
  }

  // {525, 524}
  public void test3253() {
    check( //
        "Integrate[Sqrt[c + d*x^3]/(x^2*(a + b*x^3)), x]", //
        "-((Sqrt[c + d*x^3]*AppellF1[-1/3, 1, -1/2, 2/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*x*Sqrt[1 + (d*x^3)/c]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3254() {
    check( //
        "Integrate[Sqrt[c + d*x^3]/(x^3*(a + b*x^3)), x]", //
        "-(Sqrt[c + d*x^3]*AppellF1[-2/3, 1, -1/2, 1/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a*x^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3255() {
    check( //
        "Integrate[(x^3*(c + d*x^3)^(3/2))/(a + b*x^3), x]", //
        "(c*x^4*Sqrt[c + d*x^3]*AppellF1[4/3, 1, -3/2, 7/3, -((b*x^3)/a), -((d*x^3)/c)])/(4*a*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3256() {
    check( //
        "Integrate[(x*(c + d*x^3)^(3/2))/(a + b*x^3), x]", //
        "(c*x^2*Sqrt[c + d*x^3]*AppellF1[2/3, 1, -3/2, 5/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {441, 440}
  public void test3257() {
    check( //
        "Integrate[(c + d*x^3)^(3/2)/(a + b*x^3), x]", //
        "(c*x*Sqrt[c + d*x^3]*AppellF1[1/3, 1, -3/2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*Sqrt[1 + (d*x^3)/c])", //
        441,
        440);
  }

  // {525, 524}
  public void test3258() {
    check( //
        "Integrate[(c + d*x^3)^(3/2)/(x^2*(a + b*x^3)), x]", //
        "-((c*Sqrt[c + d*x^3]*AppellF1[-1/3, 1, -3/2, 2/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*x*Sqrt[1 + (d*x^3)/c]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3259() {
    check( //
        "Integrate[(c + d*x^3)^(3/2)/(x^3*(a + b*x^3)), x]", //
        "-(c*Sqrt[c + d*x^3]*AppellF1[-2/3, 1, -3/2, 1/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a*x^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3260() {
    check( //
        "Integrate[x^3/((a + b*x^3)*Sqrt[c + d*x^3]), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 1, 1/2, 7/3, -((b*x^3)/a), -((d*x^3)/c)])/(4*a*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3261() {
    check( //
        "Integrate[x/((a + b*x^3)*Sqrt[c + d*x^3]), x]", //
        "(x^2*Sqrt[1 + (d*x^3)/c]*AppellF1[2/3, 1, 1/2, 5/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3262() {
    check( //
        "Integrate[1/((a + b*x^3)*Sqrt[c + d*x^3]), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 1, 1/2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3263() {
    check( //
        "Integrate[1/(x^2*(a + b*x^3)*Sqrt[c + d*x^3]), x]", //
        "-((Sqrt[1 + (d*x^3)/c]*AppellF1[-1/3, 1, 1/2, 2/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*x*Sqrt[c + d*x^3]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3264() {
    check( //
        "Integrate[1/(x^3*(a + b*x^3)*Sqrt[c + d*x^3]), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 1, 1/2, 1/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3265() {
    check( //
        "Integrate[x^3/((a + b*x^3)*(c + d*x^3)^(3/2)), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 1, 3/2, 7/3, -((b*x^3)/a), -((d*x^3)/c)])/(4*a*c*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3266() {
    check( //
        "Integrate[x/((a + b*x^3)*(c + d*x^3)^(3/2)), x]", //
        "(x^2*Sqrt[1 + (d*x^3)/c]*AppellF1[2/3, 1, 3/2, 5/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a*c*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3267() {
    check( //
        "Integrate[1/((a + b*x^3)*(c + d*x^3)^(3/2)), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 1, 3/2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*c*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3268() {
    check( //
        "Integrate[1/(x^2*(a + b*x^3)*(c + d*x^3)^(3/2)), x]", //
        "-((Sqrt[1 + (d*x^3)/c]*AppellF1[-1/3, 1, 3/2, 2/3, -((b*x^3)/a), -((d*x^3)/c)])/(a*c*x*Sqrt[c + d*x^3]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3269() {
    check( //
        "Integrate[1/(x^3*(a + b*x^3)*(c + d*x^3)^(3/2)), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 1, 3/2, 1/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a*c*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3270() {
    check( //
        "Integrate[x^6/((8*c - d*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "(x^7*Sqrt[1 + (d*x^3)/c]*AppellF1[7/3, 2, 1/2, 10/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(448*c^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3271() {
    check( //
        "Integrate[x^3/((8*c - d*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 2, 1/2, 7/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(256*c^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3272() {
    check( //
        "Integrate[1/((8*c - d*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 2, 1/2, 4/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(64*c^2*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3273() {
    check( //
        "Integrate[1/(x^3*(8*c - d*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 2, 1/2, 1/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(128*c^2*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3274() {
    check( //
        "Integrate[1/(x^6*(8*c - d*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-5/3, 2, 1/2, -2/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(320*c^2*x^5*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3275() {
    check( //
        "Integrate[x^3/((8*c - d*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 2, 3/2, 7/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(256*c^3*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3276() {
    check( //
        "Integrate[1/((8*c - d*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 2, 3/2, 4/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(64*c^3*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3277() {
    check( //
        "Integrate[1/(x^3*(8*c - d*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 2, 3/2, 1/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(128*c^3*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3278() {
    check( //
        "Integrate[1/(x^6*(8*c - d*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-5/3, 2, 3/2, -2/3, (d*x^3)/(8*c), -((d*x^3)/c)])/(320*c^3*x^5*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3279() {
    check( //
        "Integrate[(x^3*Sqrt[c + d*x^3])/(a + b*x^3)^2, x]", //
        "(x^4*Sqrt[c + d*x^3]*AppellF1[4/3, 2, -1/2, 7/3, -((b*x^3)/a), -((d*x^3)/c)])/(4*a^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3280() {
    check( //
        "Integrate[(x*Sqrt[c + d*x^3])/(a + b*x^3)^2, x]", //
        "(x^2*Sqrt[c + d*x^3]*AppellF1[2/3, 2, -1/2, 5/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {441, 440}
  public void test3281() {
    check( //
        "Integrate[Sqrt[c + d*x^3]/(a + b*x^3)^2, x]", //
        "(x*Sqrt[c + d*x^3]*AppellF1[1/3, 2, -1/2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*Sqrt[1 + (d*x^3)/c])", //
        441,
        440);
  }

  // {525, 524}
  public void test3282() {
    check( //
        "Integrate[Sqrt[c + d*x^3]/(x^2*(a + b*x^3)^2), x]", //
        "-((Sqrt[c + d*x^3]*AppellF1[-1/3, 2, -1/2, 2/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*x*Sqrt[1 + (d*x^3)/c]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3283() {
    check( //
        "Integrate[Sqrt[c + d*x^3]/(x^3*(a + b*x^3)^2), x]", //
        "-(Sqrt[c + d*x^3]*AppellF1[-2/3, 2, -1/2, 1/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a^2*x^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3284() {
    check( //
        "Integrate[(x^3*(c + d*x^3)^(3/2))/(a + b*x^3)^2, x]", //
        "(c*x^4*Sqrt[c + d*x^3]*AppellF1[4/3, 2, -3/2, 7/3, -((b*x^3)/a), -((d*x^3)/c)])/(4*a^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3285() {
    check( //
        "Integrate[(x*(c + d*x^3)^(3/2))/(a + b*x^3)^2, x]", //
        "(c*x^2*Sqrt[c + d*x^3]*AppellF1[2/3, 2, -3/2, 5/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {441, 440}
  public void test3286() {
    check( //
        "Integrate[(c + d*x^3)^(3/2)/(a + b*x^3)^2, x]", //
        "(c*x*Sqrt[c + d*x^3]*AppellF1[1/3, 2, -3/2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*Sqrt[1 + (d*x^3)/c])", //
        441,
        440);
  }

  // {525, 524}
  public void test3287() {
    check( //
        "Integrate[(c + d*x^3)^(3/2)/(x^2*(a + b*x^3)^2), x]", //
        "-((c*Sqrt[c + d*x^3]*AppellF1[-1/3, 2, -3/2, 2/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*x*Sqrt[1 + (d*x^3)/c]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3288() {
    check( //
        "Integrate[(c + d*x^3)^(3/2)/(x^3*(a + b*x^3)^2), x]", //
        "-(c*Sqrt[c + d*x^3]*AppellF1[-2/3, 2, -3/2, 1/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a^2*x^2*Sqrt[1 + (d*x^3)/c])", //
        525,
        524);
  }

  // {525, 524}
  public void test3289() {
    check( //
        "Integrate[x^3/((a + b*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 2, 1/2, 7/3, -((b*x^3)/a), -((d*x^3)/c)])/(4*a^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3290() {
    check( //
        "Integrate[x/((a + b*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "(x^2*Sqrt[1 + (d*x^3)/c]*AppellF1[2/3, 2, 1/2, 5/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3291() {
    check( //
        "Integrate[1/((a + b*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 2, 1/2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3292() {
    check( //
        "Integrate[1/(x^2*(a + b*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "-((Sqrt[1 + (d*x^3)/c]*AppellF1[-1/3, 2, 1/2, 2/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*x*Sqrt[c + d*x^3]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3293() {
    check( //
        "Integrate[1/(x^3*(a + b*x^3)^2*Sqrt[c + d*x^3]), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 2, 1/2, 1/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a^2*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3294() {
    check( //
        "Integrate[x^3/((a + b*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "(x^4*Sqrt[1 + (d*x^3)/c]*AppellF1[4/3, 2, 3/2, 7/3, -((b*x^3)/a), -((d*x^3)/c)])/(4*a^2*c*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {525, 524}
  public void test3295() {
    check( //
        "Integrate[x/((a + b*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "(x^2*Sqrt[1 + (d*x^3)/c]*AppellF1[2/3, 2, 3/2, 5/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a^2*c*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {441, 440}
  public void test3296() {
    check( //
        "Integrate[1/((a + b*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "(x*Sqrt[1 + (d*x^3)/c]*AppellF1[1/3, 2, 3/2, 4/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*c*Sqrt[c + d*x^3])", //
        441,
        440);
  }

  // {525, 524}
  public void test3297() {
    check( //
        "Integrate[1/(x^2*(a + b*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "-((Sqrt[1 + (d*x^3)/c]*AppellF1[-1/3, 2, 3/2, 2/3, -((b*x^3)/a), -((d*x^3)/c)])/(a^2*c*x*Sqrt[c + d*x^3]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3298() {
    check( //
        "Integrate[1/(x^3*(a + b*x^3)^2*(c + d*x^3)^(3/2)), x]", //
        "-(Sqrt[1 + (d*x^3)/c]*AppellF1[-2/3, 2, 3/2, 1/3, -((b*x^3)/a), -((d*x^3)/c)])/(2*a^2*c*x^2*Sqrt[c + d*x^3])", //
        525,
        524);
  }

  // {464, 270}
  public void test3299() {
    check( //
        "Integrate[(A + B*x^3)/((e*x)^(5/2)*(a + b*x^3)^(3/2)), x]", //
        "(-2*A)/(3*a*e*(e*x)^(3/2)*Sqrt[a + b*x^3]) - (2*(2*A*b - a*B)*(e*x)^(3/2))/(3*a^2*e^4*Sqrt[a + b*x^3])", //
        464,
        270);
  }

  // {468, 270}
  public void test3300() {
    check( //
        "Integrate[(Sqrt[e*x]*(A + B*x^3))/(a + b*x^3)^(5/2), x]", //
        "(2*(A*b - a*B)*(e*x)^(3/2))/(9*a*b*e*(a + b*x^3)^(3/2)) + (2*(2*A*b + a*B)*(e*x)^(3/2))/(9*a^2*b*e*Sqrt[a + b*x^3])", //
        468,
        270);
  }

  // {372, 371}
  public void test3301() {
    check( //
        "Integrate[(e*x)^m/Sqrt[c + d*x^4], x]", //
        "((e*x)^(1 + m)*Sqrt[1 + (d*x^4)/c]*Hypergeometric2F1[1/2, (1 + m)/4, (5 + m)/4, -((d*x^4)/c)])/(e*(1 + m)*Sqrt[c + d*x^4])", //
        372,
        371);
  }

  // {525, 524}
  public void test3302() {
    check( //
        "Integrate[(e*x)^m/((a + b*x^4)*Sqrt[c + d*x^4]), x]", //
        "((e*x)^(1 + m)*Sqrt[1 + (d*x^4)/c]*AppellF1[(1 + m)/4, 1, 1/2, (5 + m)/4, -((b*x^4)/a), -((d*x^4)/c)])/(a*e*(1 + m)*Sqrt[c + d*x^4])", //
        525,
        524);
  }

  // {525, 524}
  public void test3303() {
    check( //
        "Integrate[(e*x)^m/((a + b*x^4)^2*Sqrt[c + d*x^4]), x]", //
        "((e*x)^(1 + m)*Sqrt[1 + (d*x^4)/c]*AppellF1[(1 + m)/4, 2, 1/2, (5 + m)/4, -((b*x^4)/a), -((d*x^4)/c)])/(a^2*e*(1 + m)*Sqrt[c + d*x^4])", //
        525,
        524);
  }

  // {525, 524}
  public void test3304() {
    check( //
        "Integrate[(e*x)^m/((a + b*x^4)^3*Sqrt[c + d*x^4]), x]", //
        "((e*x)^(1 + m)*Sqrt[1 + (d*x^4)/c]*AppellF1[(1 + m)/4, 3, 1/2, (5 + m)/4, -((b*x^4)/a), -((d*x^4)/c)])/(a^3*e*(1 + m)*Sqrt[c + d*x^4])", //
        525,
        524);
  }

  // {372, 371}
  public void test3305() {
    check( //
        "Integrate[(e*x)^m/(c + d*x^4)^(3/2), x]", //
        "((e*x)^(1 + m)*Sqrt[1 + (d*x^4)/c]*Hypergeometric2F1[3/2, (1 + m)/4, (5 + m)/4, -((d*x^4)/c)])/(c*e*(1 + m)*Sqrt[c + d*x^4])", //
        372,
        371);
  }

  // {525, 524}
  public void test3306() {
    check( //
        "Integrate[(e*x)^m/((a + b*x^4)*(c + d*x^4)^(3/2)), x]", //
        "((e*x)^(1 + m)*Sqrt[1 + (d*x^4)/c]*AppellF1[(1 + m)/4, 1, 3/2, (5 + m)/4, -((b*x^4)/a), -((d*x^4)/c)])/(a*c*e*(1 + m)*Sqrt[c + d*x^4])", //
        525,
        524);
  }

  // {525, 524}
  public void test3307() {
    check( //
        "Integrate[(e*x)^m/((a + b*x^4)^2*(c + d*x^4)^(3/2)), x]", //
        "((e*x)^(1 + m)*Sqrt[1 + (d*x^4)/c]*AppellF1[(1 + m)/4, 2, 3/2, (5 + m)/4, -((b*x^4)/a), -((d*x^4)/c)])/(a^2*c*e*(1 + m)*Sqrt[c + d*x^4])", //
        525,
        524);
  }

  // {525, 524}
  public void test3308() {
    check( //
        "Integrate[(e*x)^m/((a + b*x^4)^3*(c + d*x^4)^(3/2)), x]", //
        "((e*x)^(1 + m)*Sqrt[1 + (d*x^4)/c]*AppellF1[(1 + m)/4, 3, 3/2, (5 + m)/4, -((b*x^4)/a), -((d*x^4)/c)])/(a^3*c*e*(1 + m)*Sqrt[c + d*x^4])", //
        525,
        524);
  }

  // {525, 524}
  public void test3309() {
    check( //
        "Integrate[x^4/((a + b*x^6)*Sqrt[c + d*x^6]), x]", //
        "(x^5*Sqrt[1 + (d*x^6)/c]*AppellF1[5/6, 1, 1/2, 11/6, -((b*x^6)/a), -((d*x^6)/c)])/(5*a*Sqrt[c + d*x^6])", //
        525,
        524);
  }

  // {441, 440}
  public void test3310() {
    check( //
        "Integrate[1/((a + b*x^6)*Sqrt[c + d*x^6]), x]", //
        "(x*Sqrt[1 + (d*x^6)/c]*AppellF1[1/6, 1, 1/2, 7/6, -((b*x^6)/a), -((d*x^6)/c)])/(a*Sqrt[c + d*x^6])", //
        441,
        440);
  }

  // {525, 524}
  public void test3311() {
    check( //
        "Integrate[1/(x^2*(a + b*x^6)*Sqrt[c + d*x^6]), x]", //
        "-((Sqrt[1 + (d*x^6)/c]*AppellF1[-1/6, 1, 1/2, 5/6, -((b*x^6)/a), -((d*x^6)/c)])/(a*x*Sqrt[c + d*x^6]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3312() {
    check( //
        "Integrate[x^4/((a + b*x^6)^2*Sqrt[c + d*x^6]), x]", //
        "(x^5*Sqrt[1 + (d*x^6)/c]*AppellF1[5/6, 2, 1/2, 11/6, -((b*x^6)/a), -((d*x^6)/c)])/(5*a^2*Sqrt[c + d*x^6])", //
        525,
        524);
  }

  // {441, 440}
  public void test3313() {
    check( //
        "Integrate[1/((a + b*x^6)^2*Sqrt[c + d*x^6]), x]", //
        "(x*Sqrt[1 + (d*x^6)/c]*AppellF1[1/6, 2, 1/2, 7/6, -((b*x^6)/a), -((d*x^6)/c)])/(a^2*Sqrt[c + d*x^6])", //
        441,
        440);
  }

  // {525, 524}
  public void test3314() {
    check( //
        "Integrate[1/(x^2*(a + b*x^6)^2*Sqrt[c + d*x^6]), x]", //
        "-((Sqrt[1 + (d*x^6)/c]*AppellF1[-1/6, 2, 1/2, 5/6, -((b*x^6)/a), -((d*x^6)/c)])/(a^2*x*Sqrt[c + d*x^6]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3315() {
    check( //
        "Integrate[x^4/((a + b*x^8)*Sqrt[c + d*x^8]), x]", //
        "(x^5*Sqrt[1 + (d*x^8)/c]*AppellF1[5/8, 1, 1/2, 13/8, -((b*x^8)/a), -((d*x^8)/c)])/(5*a*Sqrt[c + d*x^8])", //
        525,
        524);
  }

  // {525, 524}
  public void test3316() {
    check( //
        "Integrate[x^2/((a + b*x^8)*Sqrt[c + d*x^8]), x]", //
        "(x^3*Sqrt[1 + (d*x^8)/c]*AppellF1[3/8, 1, 1/2, 11/8, -((b*x^8)/a), -((d*x^8)/c)])/(3*a*Sqrt[c + d*x^8])", //
        525,
        524);
  }

  // {441, 440}
  public void test3317() {
    check( //
        "Integrate[1/((a + b*x^8)*Sqrt[c + d*x^8]), x]", //
        "(x*Sqrt[1 + (d*x^8)/c]*AppellF1[1/8, 1, 1/2, 9/8, -((b*x^8)/a), -((d*x^8)/c)])/(a*Sqrt[c + d*x^8])", //
        441,
        440);
  }

  // {525, 524}
  public void test3318() {
    check( //
        "Integrate[1/(x^2*(a + b*x^8)*Sqrt[c + d*x^8]), x]", //
        "-((Sqrt[1 + (d*x^8)/c]*AppellF1[-1/8, 1, 1/2, 7/8, -((b*x^8)/a), -((d*x^8)/c)])/(a*x*Sqrt[c + d*x^8]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3319() {
    check( //
        "Integrate[1/(x^4*(a + b*x^8)*Sqrt[c + d*x^8]), x]", //
        "-(Sqrt[1 + (d*x^8)/c]*AppellF1[-3/8, 1, 1/2, 5/8, -((b*x^8)/a), -((d*x^8)/c)])/(3*a*x^3*Sqrt[c + d*x^8])", //
        525,
        524);
  }

  // {525, 524}
  public void test3320() {
    check( //
        "Integrate[x^4/((a + b*x^8)^2*Sqrt[c + d*x^8]), x]", //
        "(x^5*Sqrt[1 + (d*x^8)/c]*AppellF1[5/8, 2, 1/2, 13/8, -((b*x^8)/a), -((d*x^8)/c)])/(5*a^2*Sqrt[c + d*x^8])", //
        525,
        524);
  }

  // {525, 524}
  public void test3321() {
    check( //
        "Integrate[x^2/((a + b*x^8)^2*Sqrt[c + d*x^8]), x]", //
        "(x^3*Sqrt[1 + (d*x^8)/c]*AppellF1[3/8, 2, 1/2, 11/8, -((b*x^8)/a), -((d*x^8)/c)])/(3*a^2*Sqrt[c + d*x^8])", //
        525,
        524);
  }

  // {441, 440}
  public void test3322() {
    check( //
        "Integrate[1/((a + b*x^8)^2*Sqrt[c + d*x^8]), x]", //
        "(x*Sqrt[1 + (d*x^8)/c]*AppellF1[1/8, 2, 1/2, 9/8, -((b*x^8)/a), -((d*x^8)/c)])/(a^2*Sqrt[c + d*x^8])", //
        441,
        440);
  }

  // {525, 524}
  public void test3323() {
    check( //
        "Integrate[1/(x^2*(a + b*x^8)^2*Sqrt[c + d*x^8]), x]", //
        "-((Sqrt[1 + (d*x^8)/c]*AppellF1[-1/8, 2, 1/2, 7/8, -((b*x^8)/a), -((d*x^8)/c)])/(a^2*x*Sqrt[c + d*x^8]))", //
        525,
        524);
  }

  // {525, 524}
  public void test3324() {
    check( //
        "Integrate[1/(x^4*(a + b*x^8)^2*Sqrt[c + d*x^8]), x]", //
        "-(Sqrt[1 + (d*x^8)/c]*AppellF1[-3/8, 2, 1/2, 5/8, -((b*x^8)/a), -((d*x^8)/c)])/(3*a^2*x^3*Sqrt[c + d*x^8])", //
        525,
        524);
  }

  // {464, 270}
  public void test3325() {
    check( //
        "Integrate[(a + b/x^2)*Sqrt[c + d/x^2]*x^4, x]", //
        "((5*b*c - 2*a*d)*(c + d/x^2)^(3/2)*x^3)/(15*c^2) + (a*(c + d/x^2)^(3/2)*x^5)/(5*c)", //
        464,
        270);
  }

  // {464, 270}
  public void test3326() {
    check( //
        "Integrate[(a + b/x^2)*(c + d/x^2)^(3/2)*x^6, x]", //
        "((7*b*c - 2*a*d)*(c + d/x^2)^(5/2)*x^5)/(35*c^2) + (a*(c + d/x^2)^(5/2)*x^7)/(7*c)", //
        464,
        270);
  }

  // {464, 197}
  public void test3327() {
    check( //
        "Integrate[((a + b/x^2)*x^2)/Sqrt[c + d/x^2], x]", //
        "((3*b*c - 2*a*d)*Sqrt[c + d/x^2]*x)/(3*c^2) + (a*Sqrt[c + d/x^2]*x^3)/(3*c)", //
        464,
        197);
  }

  // {278, 271}
  public void test3328() {
    check( //
        "Integrate[(Sqrt[-1 + Sqrt[x]]*Sqrt[1 + Sqrt[x]])/x^(7/2), x]", //
        "(2*(-1 + Sqrt[x])^(3/2)*(1 + Sqrt[x])^(3/2))/(5*x^(5/2)) + (4*(-1 + Sqrt[x])^(3/2)*(1 + Sqrt[x])^(3/2))/(15*x^(3/2))", //
        278,
        271);
  }

  // {336, 54}
  public void test3329() {
    check( //
        "Integrate[1/(Sqrt[-1 + Sqrt[x]]*Sqrt[1 + Sqrt[x]]*Sqrt[x]), x]", //
        "2*ArcCosh[Sqrt[x]]", //
        336,
        54);
  }

  // {278, 271}
  public void test3330() {
    check( //
        "Integrate[1/(Sqrt[-1 + Sqrt[x]]*Sqrt[1 + Sqrt[x]]*x^(5/2)), x]", //
        "(2*Sqrt[-1 + Sqrt[x]]*Sqrt[1 + Sqrt[x]])/(3*x^(3/2)) + (4*Sqrt[-1 + Sqrt[x]]*Sqrt[1 + Sqrt[x]])/(3*Sqrt[x])", //
        278,
        271);
  }

  // {457, 75}
  public void test3331() {
    check( //
        "Integrate[x^27*(b + c*x^2)^13*(b + 2*c*x^2), x]", //
        "(x^28*(b + c*x^2)^14)/28", //
        457,
        75);
  }

  // {457, 75}
  public void test3332() {
    check( //
        "Integrate[x^41*(b + c*x^3)^13*(b + 2*c*x^3), x]", //
        "(x^42*(b + c*x^3)^14)/42", //
        457,
        75);
  }

  // {457, 75}
  public void test3333() {
    check( //
        "Integrate[x^(-1 + 14*n)*(b + c*x^n)^13*(b + 2*c*x^n), x]", //
        "(x^(14*n)*(b + c*x^n)^14)/(14*n)", //
        457,
        75);
  }

  // {457, 75}
  public void test3334() {
    check( //
        "Integrate[(b + 2*c*x^2)/(x^15*(b + c*x^2)^8), x]", //
        "-1/(14*x^14*(b + c*x^2)^7)", //
        457,
        75);
  }

  // {457, 75}
  public void test3335() {
    check( //
        "Integrate[(b + 2*c*x^3)/(x^22*(b + c*x^3)^8), x]", //
        "-1/(21*x^21*(b + c*x^3)^7)", //
        457,
        75);
  }

  // {457, 75}
  public void test3336() {
    check( //
        "Integrate[(x^(-1 - 7*n)*(b + 2*c*x^n))/(b + c*x^n)^8, x]", //
        "-1/(7*n*x^(7*n)*(b + c*x^n)^7)", //
        457,
        75);
  }

  // {470, 371}
  public void test3337() {
    check( //
        "Integrate[((e*x)^m*(A + B*x^n))/(c + d*x^n), x]", //
        "(B*(e*x)^(1 + m))/(d*e*(1 + m)) - ((B*c - A*d)*(e*x)^(1 + m)*Hypergeometric2F1[1, (1 + m)/n, (1 + m + n)/n, -((d*x^n)/c)])/(c*d*e*(1 + m))", //
        470,
        371);
  }

  // {468, 371}
  public void test3338() {
    check( //
        "Integrate[((e*x)^m*(A + B*x^n))/(c + d*x^n)^2, x]", //
        "-(((B*c - A*d)*(e*x)^(1 + m))/(c*d*e*n*(c + d*x^n))) + ((B*c*(1 + m) - A*d*(1 + m - n))*(e*x)^(1 + m)*Hypergeometric2F1[1, (1 + m)/n, (1 + m + n)/n, -((d*x^n)/c)])/(c^2*d*e*(1 + m)*n)", //
        468,
        371);
  }

  // {468, 371}
  public void test3339() {
    check( //
        "Integrate[((e*x)^m*(A + B*x^n))/(c + d*x^n)^3, x]", //
        "-((B*c - A*d)*(e*x)^(1 + m))/(2*c*d*e*n*(c + d*x^n)^2) + ((B*c*(1 + m) - A*d*(1 + m - 2*n))*(e*x)^(1 + m)*Hypergeometric2F1[2, (1 + m)/n, (1 + m + n)/n, -((d*x^n)/c)])/(2*c^3*d*e*(1 + m)*n)", //
        468,
        371);
  }

  // {712}
  public void test3340() {
    check( //
        "Integrate[(c + d*x + e*x^2)/Sqrt[a + b*x], x]", //
        "(2*(b^2*c - a*b*d + a^2*e)*Sqrt[a + b*x])/b^3 + (2*(b*d - 2*a*e)*(a + b*x)^(3/2))/(3*b^3) + (2*e*(a + b*x)^(5/2))/(5*b^3)", //
        712);
  }

  // {712}
  public void test3341() {
    check( //
        "Integrate[(c + d*x + e*x^2)^2/Sqrt[a + b*x], x]", //
        "(2*(b^2*c - a*b*d + a^2*e)^2*Sqrt[a + b*x])/b^5 + (4*(b*d - 2*a*e)*(b^2*c - a*b*d + a^2*e)*(a + b*x)^(3/2))/(3*b^5) - (2*(6*a*b*d*e - 6*a^2*e^2 - b^2*(d^2 + 2*c*e))*(a + b*x)^(5/2))/(5*b^5) + (4*e*(b*d - 2*a*e)*(a + b*x)^(7/2))/(7*b^5) + (2*e^2*(a + b*x)^(9/2))/(9*b^5)", //
        712);
  }

  // {712}
  public void test3342() {
    check( //
        "Integrate[(c + d*x + e*x^2)^3/Sqrt[a + b*x], x]", //
        "(2*(b^2*c - a*b*d + a^2*e)^3*Sqrt[a + b*x])/b^7 + (2*(b*d - 2*a*e)*(b^2*c - a*b*d + a^2*e)^2*(a + b*x)^(3/2))/b^7 - (6*(b^2*c - a*b*d + a^2*e)*(5*a*b*d*e - 5*a^2*e^2 - b^2*(d^2 + c*e))*(a + b*x)^(5/2))/(5*b^7) - (2*(b*d - 2*a*e)*(10*a*b*d*e - 10*a^2*e^2 - b^2*(d^2 + 6*c*e))*(a + b*x)^(7/2))/(7*b^7) - (2*e*(5*a*b*d*e - 5*a^2*e^2 - b^2*(d^2 + c*e))*(a + b*x)^(9/2))/(3*b^7) + (6*e^2*(b*d - 2*a*e)*(a + b*x)^(11/2))/(11*b^7) + (2*e^3*(a + b*x)^(13/2))/(13*b^7)", //
        712);
  }

  // {1864}
  public void test3343() {
    check( //
        "Integrate[(c + d*x + e*x^2 + f*x^3)/Sqrt[a + b*x], x]", //
        "(2*(b^3*c - a*b^2*d + a^2*b*e - a^3*f)*Sqrt[a + b*x])/b^4 + (2*(b^2*d - 2*a*b*e + 3*a^2*f)*(a + b*x)^(3/2))/(3*b^4) + (2*(b*e - 3*a*f)*(a + b*x)^(5/2))/(5*b^4) + (2*f*(a + b*x)^(7/2))/(7*b^4)", //
        1864);
  }

  // {1864}
  public void test3344() {
    check( //
        "Integrate[(c + d*x + e*x^2 + f*x^3)^2/Sqrt[a + b*x], x]", //
        "(2*(b^3*c - a*b^2*d + a^2*b*e - a^3*f)^2*Sqrt[a + b*x])/b^7 + (4*(b^2*d - 2*a*b*e + 3*a^2*f)*(b^3*c - a*b^2*d + a^2*b*e - a^3*f)*(a + b*x)^(3/2))/(3*b^7) + (2*(b^4*(d^2 + 2*c*e) - 20*a^3*b*e*f + 15*a^4*f^2 - 6*a*b^3*(d*e + c*f) + 6*a^2*b^2*(e^2 + 2*d*f))*(a + b*x)^(5/2))/(5*b^7) + (4*(10*a^2*b*e*f - 10*a^3*f^2 + b^3*(d*e + c*f) - 2*a*b^2*(e^2 + 2*d*f))*(a + b*x)^(7/2))/(7*b^7) - (2*(10*a*b*e*f - 15*a^2*f^2 - b^2*(e^2 + 2*d*f))*(a + b*x)^(9/2))/(9*b^7) + (4*f*(b*e - 3*a*f)*(a + b*x)^(11/2))/(11*b^7) + (2*f^2*(a + b*x)^(13/2))/(13*b^7)", //
        1864);
  }

  // {1864}
  public void test3345() {
    check( //
        "Integrate[(c + d*x + e*x^2 + f*x^3)^3/Sqrt[a + b*x], x]", //
        "(2*(b^3*c - a*b^2*d + a^2*b*e - a^3*f)^3*Sqrt[a + b*x])/b^10 + (2*(b^2*d - 2*a*b*e + 3*a^2*f)*(b^3*c - a*b^2*d + a^2*b*e - a^3*f)^2*(a + b*x)^(3/2))/b^10 + (6*(b^3*c - a*b^2*d + a^2*b*e - a^3*f)*(b^4*(d^2 + c*e) - 16*a^3*b*e*f + 12*a^4*f^2 - a*b^3*(5*d*e + 3*c*f) + a^2*b^2*(5*e^2 + 9*d*f))*(a + b*x)^(5/2))/(5*b^10) - (2*(168*a^5*b*e*f^2 - 84*a^6*f^3 - b^6*(d^3 + 6*c*d*e + 3*c^2*f) - 105*a^4*b^2*f*(e^2 + d*f) + 12*a*b^5*(d^2*e + c*e^2 + 2*c*d*f) - 30*a^2*b^4*(d*e^2 + d^2*f + 2*c*e*f) + 20*a^3*b^3*(e^3 + 6*d*e*f + 3*c*f^2))*(a + b*x)^(7/2))/(7*b^10) + (2*(70*a^4*b*e*f^2 - 42*a^5*f^3 - 35*a^3*b^2*f*(e^2 + d*f) + b^5*(d^2*e + c*e^2 + 2*c*d*f) - 5*a*b^4*(d*e^2 + d^2*f + 2*c*e*f) + 5*a^2*b^3*(e^3 + 6*d*e*f + 3*c*f^2))*(a + b*x)^(9/2))/(3*b^10) - (6*(56*a^3*b*e*f^2 - 42*a^4*f^3 - 21*a^2*b^2*f*(e^2 + d*f) - b^4*(d*e^2 + d^2*f + 2*c*e*f) + 2*a*b^3*(e^3 + 6*d*e*f + 3*c*f^2))*(a + b*x)^(11/2))/(11*b^10) + (2*(84*a^2*b*e*f^2 - 84*a^3*f^3 - 21*a*b^2*f*(e^2 + d*f) + b^3*(e^3 + 6*d*e*f + 3*c*f^2))*(a + b*x)^(13/2))/(13*b^10) - (2*f*(8*a*b*e*f - 12*a^2*f^2 - b^2*(e^2 + d*f))*(a + b*x)^(15/2))/(5*b^10) + (6*f^2*(b*e - 3*a*f)*(a + b*x)^(17/2))/(17*b^10) + (2*f^3*(a + b*x)^(19/2))/(19*b^10)", //
        1864);
  }

  // {1600, 31}
  public void test3346() {
    check( //
        "Integrate[(B^2 + B*C*x + C^2*x^2)/(-B^3 + C^3*x^3), x]", //
        "Log[B - C*x]/C", //
        1600,
        31);
  }

  // {1600, 31}
  public void test3347() {
    check( //
        "Integrate[(a^(2/3)*C - a^(1/3)*b^(1/3)*C*x + b^(2/3)*C*x^2)/(a + b*x^3), x]", //
        "(C*Log[a^(1/3) + b^(1/3)*x])/b^(1/3)", //
        1600,
        31);
  }

  // {1600, 31}
  public void test3348() {
    check( //
        "Integrate[(1 + x + x^2)/(1 - x^3), x]", //
        "-Log[1 - x]", //
        1600,
        31);
  }

  // {1864}
  public void test3349() {
    check( //
        "Integrate[(a + b*x^3)^3*(a*c + a*d*x + b*c*x^3 + b*d*x^4), x]", //
        "a^4*c*x + (a^4*d*x^2)/2 + a^3*b*c*x^4 + (4*a^3*b*d*x^5)/5 + (6*a^2*b^2*c*x^7)/7 + (3*a^2*b^2*d*x^8)/4 + (2*a*b^3*c*x^10)/5 + (4*a*b^3*d*x^11)/11 + (b^4*c*x^13)/13 + (b^4*d*x^14)/14", //
        1864);
  }

  // {1864}
  public void test3350() {
    check( //
        "Integrate[(a + b*x^3)^2*(a*c + a*d*x + b*c*x^3 + b*d*x^4), x]", //
        "a^3*c*x + (a^3*d*x^2)/2 + (3*a^2*b*c*x^4)/4 + (3*a^2*b*d*x^5)/5 + (3*a*b^2*c*x^7)/7 + (3*a*b^2*d*x^8)/8 + (b^3*c*x^10)/10 + (b^3*d*x^11)/11", //
        1864);
  }

  // {1864}
  public void test3351() {
    check( //
        "Integrate[(a + b*x^3)*(a*c + a*d*x + b*c*x^3 + b*d*x^4), x]", //
        "a^2*c*x + (a^2*d*x^2)/2 + (a*b*c*x^4)/2 + (2*a*b*d*x^5)/5 + (b^2*c*x^7)/7 + (b^2*d*x^8)/8", //
        1864);
  }

  // {1600}
  public void test3352() {
    check( //
        "Integrate[(a*c + a*d*x + b*c*x^3 + b*d*x^4)/(a + b*x^3), x]", //
        "c*x + (d*x^2)/2", //
        1600);
  }

  // {1864}
  public void test3353() {
    check( //
        "Integrate[(a + b*x)*(e + f*x^4)^2, x]", //
        "a*e^2*x + (b*e^2*x^2)/2 + (2*a*e*f*x^5)/5 + (b*e*f*x^6)/3 + (a*f^2*x^9)/9 + (b*f^2*x^10)/10", //
        1864);
  }

  // {1168}
  public void test3354() {
    check( //
        "Integrate[(a + c*x^2)*(e + f*x^4)^2, x]", //
        "a*e^2*x + (c*e^2*x^3)/3 + (2*a*e*f*x^5)/5 + (2*c*e*f*x^7)/7 + (a*f^2*x^9)/9 + (c*f^2*x^11)/11", //
        1168);
  }

  // {1671}
  public void test3355() {
    check( //
        "Integrate[(a + b*x + c*x^2)*(e + f*x^4)^2, x]", //
        "a*e^2*x + (b*e^2*x^2)/2 + (c*e^2*x^3)/3 + (2*a*e*f*x^5)/5 + (b*e*f*x^6)/3 + (2*c*e*f*x^7)/7 + (a*f^2*x^9)/9 + (b*f^2*x^10)/10 + (c*f^2*x^11)/11", //
        1671);
  }

  // {12, 267}
  public void test3356() {
    check( //
        "Integrate[d*x^3*(e + f*x^4)^2, x]", //
        "(d*(e + f*x^4)^3)/(12*f)", //
        12,
        267);
  }

  // {12, 266}
  public void test3357() {
    check( //
        "Integrate[(d*x^3)/(2 + 3*x^4), x]", //
        "(d*Log[2 + 3*x^4])/12", //
        12,
        266);
  }

  // {1600, 31}
  public void test3358() {
    check( //
        "Integrate[(1 + x + x^2 + x^3)/(1 - x^4), x]", //
        "-Log[1 - x]", //
        1600,
        31);
  }

  // {1600, 32}
  public void test3359() {
    check( //
        "Integrate[(1 - x^4)^3/(1 + x + x^2 + x^3)^3, x]", //
        "-(1 - x)^4/4", //
        1600,
        32);
  }

  // {1600, 32}
  public void test3360() {
    check( //
        "Integrate[(1 - x^4)^2/(1 + x + x^2 + x^3)^2, x]", //
        "-(1 - x)^3/3", //
        1600,
        32);
  }

  // {1600}
  public void test3361() {
    check( //
        "Integrate[(1 - x^4)/(1 + x + x^2 + x^3), x]", //
        "x - x^2/2", //
        1600);
  }

  // {1600, 31}
  public void test3362() {
    check( //
        "Integrate[(1 + x + x^2 + x^3)/(1 - x^4), x]", //
        "-Log[1 - x]", //
        1600,
        31);
  }

  // {1600, 32}
  public void test3363() {
    check( //
        "Integrate[(1 + x + x^2 + x^3)^2/(1 - x^4)^2, x]", //
        "(1 - x)^(-1)", //
        1600,
        32);
  }

  // {1600, 32}
  public void test3364() {
    check( //
        "Integrate[(1 + x + x^2 + x^3)^3/(1 - x^4)^3, x]", //
        "1/(2*(1 - x)^2)", //
        1600,
        32);
  }

  // {1600, 32}
  public void test3365() {
    check( //
        "Integrate[(1 + x + x^2 + x^3)^4/(1 - x^4)^4, x]", //
        "1/(3*(1 - x)^3)", //
        1600,
        32);
  }

  // {1642}
  public void test3366() {
    check( //
        "Integrate[x^2*(c + d*x + e*x^2)*(a + b*x^3), x]", //
        "(a*c*x^3)/3 + (a*d*x^4)/4 + (a*e*x^5)/5 + (b*c*x^6)/6 + (b*d*x^7)/7 + (b*e*x^8)/8", //
        1642);
  }

  // {1642}
  public void test3367() {
    check( //
        "Integrate[x*(c + d*x + e*x^2)*(a + b*x^3), x]", //
        "(a*c*x^2)/2 + (a*d*x^3)/3 + (a*e*x^4)/4 + (b*c*x^5)/5 + (b*d*x^6)/6 + (b*e*x^7)/7", //
        1642);
  }

  // {1671}
  public void test3368() {
    check( //
        "Integrate[(c + d*x + e*x^2)*(a + b*x^3), x]", //
        "a*c*x + (a*d*x^2)/2 + (a*e*x^3)/3 + (b*c*x^4)/4 + (b*d*x^5)/5 + (b*e*x^6)/6", //
        1671);
  }

  // {1642}
  public void test3369() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3))/x, x]", //
        "a*d*x + (a*e*x^2)/2 + (b*c*x^3)/3 + (b*d*x^4)/4 + (b*e*x^5)/5 + a*c*Log[x]", //
        1642);
  }

  // {1642}
  public void test3370() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3))/x^2, x]", //
        "-((a*c)/x) + a*e*x + (b*c*x^2)/2 + (b*d*x^3)/3 + (b*e*x^4)/4 + a*d*Log[x]", //
        1642);
  }

  // {1642}
  public void test3371() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3))/x^3, x]", //
        "-(a*c)/(2*x^2) - (a*d)/x + b*c*x + (b*d*x^2)/2 + (b*e*x^3)/3 + a*e*Log[x]", //
        1642);
  }

  // {1642}
  public void test3372() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^2)/x, x]", //
        "a^2*d*x + (a^2*e*x^2)/2 + (2*a*b*c*x^3)/3 + (a*b*d*x^4)/2 + (2*a*b*e*x^5)/5 + (b^2*c*x^6)/6 + (b^2*d*x^7)/7 + (b^2*e*x^8)/8 + a^2*c*Log[x]", //
        1642);
  }

  // {1642}
  public void test3373() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^2)/x^2, x]", //
        "-((a^2*c)/x) + a^2*e*x + a*b*c*x^2 + (2*a*b*d*x^3)/3 + (a*b*e*x^4)/2 + (b^2*c*x^5)/5 + (b^2*d*x^6)/6 + (b^2*e*x^7)/7 + a^2*d*Log[x]", //
        1642);
  }

  // {1642}
  public void test3374() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^2)/x^3, x]", //
        "-(a^2*c)/(2*x^2) - (a^2*d)/x + 2*a*b*c*x + a*b*d*x^2 + (2*a*b*e*x^3)/3 + (b^2*c*x^4)/4 + (b^2*d*x^5)/5 + (b^2*e*x^6)/6 + a^2*e*Log[x]", //
        1642);
  }

  // {1642}
  public void test3375() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^3)/x, x]", //
        "a^3*d*x + (a^3*e*x^2)/2 + a^2*b*c*x^3 + (3*a^2*b*d*x^4)/4 + (3*a^2*b*e*x^5)/5 + (a*b^2*c*x^6)/2 + (3*a*b^2*d*x^7)/7 + (3*a*b^2*e*x^8)/8 + (b^3*c*x^9)/9 + (b^3*d*x^10)/10 + (b^3*e*x^11)/11 + a^3*c*Log[x]", //
        1642);
  }

  // {1642}
  public void test3376() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^3)/x^2, x]", //
        "-((a^3*c)/x) + a^3*e*x + (3*a^2*b*c*x^2)/2 + a^2*b*d*x^3 + (3*a^2*b*e*x^4)/4 + (3*a*b^2*c*x^5)/5 + (a*b^2*d*x^6)/2 + (3*a*b^2*e*x^7)/7 + (b^3*c*x^8)/8 + (b^3*d*x^9)/9 + (b^3*e*x^10)/10 + a^3*d*Log[x]", //
        1642);
  }

  // {1642}
  public void test3377() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^3)/x^3, x]", //
        "-(a^3*c)/(2*x^2) - (a^3*d)/x + 3*a^2*b*c*x + (3*a^2*b*d*x^2)/2 + a^2*b*e*x^3 + (3*a*b^2*c*x^4)/4 + (3*a*b^2*d*x^5)/5 + (a*b^2*e*x^6)/2 + (b^3*c*x^7)/7 + (b^3*d*x^8)/8 + (b^3*e*x^9)/9 + a^3*e*Log[x]", //
        1642);
  }

  // {1642}
  public void test3378() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^4)/x, x]", //
        "a^4*d*x + (a^4*e*x^2)/2 + (4*a^3*b*c*x^3)/3 + a^3*b*d*x^4 + (4*a^3*b*e*x^5)/5 + a^2*b^2*c*x^6 + (6*a^2*b^2*d*x^7)/7 + (3*a^2*b^2*e*x^8)/4 + (4*a*b^3*c*x^9)/9 + (2*a*b^3*d*x^10)/5 + (4*a*b^3*e*x^11)/11 + (b^4*c*x^12)/12 + (b^4*d*x^13)/13 + (b^4*e*x^14)/14 + a^4*c*Log[x]", //
        1642);
  }

  // {1642}
  public void test3379() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^4)/x^2, x]", //
        "-((a^4*c)/x) + a^4*e*x + 2*a^3*b*c*x^2 + (4*a^3*b*d*x^3)/3 + a^3*b*e*x^4 + (6*a^2*b^2*c*x^5)/5 + a^2*b^2*d*x^6 + (6*a^2*b^2*e*x^7)/7 + (a*b^3*c*x^8)/2 + (4*a*b^3*d*x^9)/9 + (2*a*b^3*e*x^10)/5 + (b^4*c*x^11)/11 + (b^4*d*x^12)/12 + (b^4*e*x^13)/13 + a^4*d*Log[x]", //
        1642);
  }

  // {1642}
  public void test3380() {
    check( //
        "Integrate[((c + d*x + e*x^2)*(a + b*x^3)^4)/x^3, x]", //
        "-(a^4*c)/(2*x^2) - (a^4*d)/x + 4*a^3*b*c*x + 2*a^3*b*d*x^2 + (4*a^3*b*e*x^3)/3 + (3*a^2*b^2*c*x^4)/2 + (6*a^2*b^2*d*x^5)/5 + a^2*b^2*e*x^6 + (4*a*b^3*c*x^7)/7 + (a*b^3*d*x^8)/2 + (4*a*b^3*e*x^9)/9 + (b^4*c*x^10)/10 + (b^4*d*x^11)/11 + (b^4*e*x^12)/12 + a^4*e*Log[x]", //
        1642);
  }

  // {1834}
  public void test3381() {
    check( //
        "Integrate[x^4*(a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "(a*c*x^5)/5 + (a*d*x^6)/6 + (a*e*x^7)/7 + ((b*c + a*f)*x^8)/8 + ((b*d + a*g)*x^9)/9 + ((b*e + a*h)*x^10)/10 + (b*f*x^11)/11 + (b*g*x^12)/12 + (b*h*x^13)/13", //
        1834);
  }

  // {1834}
  public void test3382() {
    check( //
        "Integrate[x^3*(a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "(a*c*x^4)/4 + (a*d*x^5)/5 + (a*e*x^6)/6 + ((b*c + a*f)*x^7)/7 + ((b*d + a*g)*x^8)/8 + ((b*e + a*h)*x^9)/9 + (b*f*x^10)/10 + (b*g*x^11)/11 + (b*h*x^12)/12", //
        1834);
  }

  // {1834}
  public void test3383() {
    check( //
        "Integrate[x^2*(a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "(a*c*x^3)/3 + (a*d*x^4)/4 + (a*e*x^5)/5 + ((b*c + a*f)*x^6)/6 + ((b*d + a*g)*x^7)/7 + ((b*e + a*h)*x^8)/8 + (b*f*x^9)/9 + (b*g*x^10)/10 + (b*h*x^11)/11", //
        1834);
  }

  // {1834}
  public void test3384() {
    check( //
        "Integrate[x*(a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "(a*c*x^2)/2 + (a*d*x^3)/3 + (a*e*x^4)/4 + ((b*c + a*f)*x^5)/5 + ((b*d + a*g)*x^6)/6 + ((b*e + a*h)*x^7)/7 + (b*f*x^8)/8 + (b*g*x^9)/9 + (b*h*x^10)/10", //
        1834);
  }

  // {1864}
  public void test3385() {
    check( //
        "Integrate[(a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "a*c*x + (a*d*x^2)/2 + (a*e*x^3)/3 + ((b*c + a*f)*x^4)/4 + ((b*d + a*g)*x^5)/5 + ((b*e + a*h)*x^6)/6 + (b*f*x^7)/7 + (b*g*x^8)/8 + (b*h*x^9)/9", //
        1864);
  }

  // {1834}
  public void test3386() {
    check( //
        "Integrate[((a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x, x]", //
        "a*d*x + (a*e*x^2)/2 + ((b*c + a*f)*x^3)/3 + ((b*d + a*g)*x^4)/4 + ((b*e + a*h)*x^5)/5 + (b*f*x^6)/6 + (b*g*x^7)/7 + (b*h*x^8)/8 + a*c*Log[x]", //
        1834);
  }

  // {1834}
  public void test3387() {
    check( //
        "Integrate[((a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x^2, x]", //
        "-((a*c)/x) + a*e*x + ((b*c + a*f)*x^2)/2 + ((b*d + a*g)*x^3)/3 + ((b*e + a*h)*x^4)/4 + (b*f*x^5)/5 + (b*g*x^6)/6 + (b*h*x^7)/7 + a*d*Log[x]", //
        1834);
  }

  // {1834}
  public void test3388() {
    check( //
        "Integrate[((a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x^3, x]", //
        "-(a*c)/(2*x^2) - (a*d)/x + (b*c + a*f)*x + ((b*d + a*g)*x^2)/2 + ((b*e + a*h)*x^3)/3 + (b*f*x^4)/4 + (b*g*x^5)/5 + (b*h*x^6)/6 + a*e*Log[x]", //
        1834);
  }

  // {1834}
  public void test3389() {
    check( //
        "Integrate[((a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x^4, x]", //
        "-(a*c)/(3*x^3) - (a*d)/(2*x^2) - (a*e)/x + (b*d + a*g)*x + ((b*e + a*h)*x^2)/2 + (b*f*x^3)/3 + (b*g*x^4)/4 + (b*h*x^5)/5 + (b*c + a*f)*Log[x]", //
        1834);
  }

  // {1834}
  public void test3390() {
    check( //
        "Integrate[((a + b*x^3)*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x^5, x]", //
        "-(a*c)/(4*x^4) - (a*d)/(3*x^3) - (a*e)/(2*x^2) - (b*c + a*f)/x + (b*e + a*h)*x + (b*f*x^2)/2 + (b*g*x^3)/3 + (b*h*x^4)/4 + (b*d + a*g)*Log[x]", //
        1834);
  }

  // {1834}
  public void test3391() {
    check( //
        "Integrate[x^4*(a + b*x^3)^2*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "(a^2*c*x^5)/5 + (a^2*d*x^6)/6 + (a^2*e*x^7)/7 + (a*(2*b*c + a*f)*x^8)/8 + (a*(2*b*d + a*g)*x^9)/9 + (a*(2*b*e + a*h)*x^10)/10 + (b*(b*c + 2*a*f)*x^11)/11 + (b*(b*d + 2*a*g)*x^12)/12 + (b*(b*e + 2*a*h)*x^13)/13 + (b^2*f*x^14)/14 + (b^2*g*x^15)/15 + (b^2*h*x^16)/16", //
        1834);
  }

  // {1834}
  public void test3392() {
    check( //
        "Integrate[x^3*(a + b*x^3)^2*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "(a^2*c*x^4)/4 + (a^2*d*x^5)/5 + (a^2*e*x^6)/6 + (a*(2*b*c + a*f)*x^7)/7 + (a*(2*b*d + a*g)*x^8)/8 + (a*(2*b*e + a*h)*x^9)/9 + (b*(b*c + 2*a*f)*x^10)/10 + (b*(b*d + 2*a*g)*x^11)/11 + (b*(b*e + 2*a*h)*x^12)/12 + (b^2*f*x^13)/13 + (b^2*g*x^14)/14 + (b^2*h*x^15)/15", //
        1834);
  }

  // {1834}
  public void test3393() {
    check( //
        "Integrate[((a + b*x^3)^2*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x^4, x]", //
        "-(a^2*c)/(3*x^3) - (a^2*d)/(2*x^2) - (a^2*e)/x + a*(2*b*d + a*g)*x + (a*(2*b*e + a*h)*x^2)/2 + (b*(b*c + 2*a*f)*x^3)/3 + (b*(b*d + 2*a*g)*x^4)/4 + (b*(b*e + 2*a*h)*x^5)/5 + (b^2*f*x^6)/6 + (b^2*g*x^7)/7 + (b^2*h*x^8)/8 + a*(2*b*c + a*f)*Log[x]", //
        1834);
  }

  // {1834}
  public void test3394() {
    check( //
        "Integrate[((a + b*x^3)^2*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x^5, x]", //
        "-(a^2*c)/(4*x^4) - (a^2*d)/(3*x^3) - (a^2*e)/(2*x^2) - (a*(2*b*c + a*f))/x + a*(2*b*e + a*h)*x + (b*(b*c + 2*a*f)*x^2)/2 + (b*(b*d + 2*a*g)*x^3)/3 + (b*(b*e + 2*a*h)*x^4)/4 + (b^2*f*x^5)/5 + (b^2*g*x^6)/6 + (b^2*h*x^7)/7 + a*(2*b*d + a*g)*Log[x]", //
        1834);
  }

  // {1834}
  public void test3395() {
    check( //
        "Integrate[x^4*(a + b*x^3)^3*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "(a^3*c*x^5)/5 + (a^3*d*x^6)/6 + (a^3*e*x^7)/7 + (a^2*(3*b*c + a*f)*x^8)/8 + (a^2*(3*b*d + a*g)*x^9)/9 + (a^2*(3*b*e + a*h)*x^10)/10 + (3*a*b*(b*c + a*f)*x^11)/11 + (a*b*(b*d + a*g)*x^12)/4 + (3*a*b*(b*e + a*h)*x^13)/13 + (b^2*(b*c + 3*a*f)*x^14)/14 + (b^2*(b*d + 3*a*g)*x^15)/15 + (b^2*(b*e + 3*a*h)*x^16)/16 + (b^3*f*x^17)/17 + (b^3*g*x^18)/18 + (b^3*h*x^19)/19", //
        1834);
  }

  // {1834}
  public void test3396() {
    check( //
        "Integrate[x^3*(a + b*x^3)^3*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5), x]", //
        "(a^3*c*x^4)/4 + (a^3*d*x^5)/5 + (a^3*e*x^6)/6 + (a^2*(3*b*c + a*f)*x^7)/7 + (a^2*(3*b*d + a*g)*x^8)/8 + (a^2*(3*b*e + a*h)*x^9)/9 + (3*a*b*(b*c + a*f)*x^10)/10 + (3*a*b*(b*d + a*g)*x^11)/11 + (a*b*(b*e + a*h)*x^12)/4 + (b^2*(b*c + 3*a*f)*x^13)/13 + (b^2*(b*d + 3*a*g)*x^14)/14 + (b^2*(b*e + 3*a*h)*x^15)/15 + (b^3*f*x^16)/16 + (b^3*g*x^17)/17 + (b^3*h*x^18)/18", //
        1834);
  }

  // {1834}
  public void test3397() {
    check( //
        "Integrate[((a + b*x^3)^3*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x^4, x]", //
        "-(a^3*c)/(3*x^3) - (a^3*d)/(2*x^2) - (a^3*e)/x + a^2*(3*b*d + a*g)*x + (a^2*(3*b*e + a*h)*x^2)/2 + a*b*(b*c + a*f)*x^3 + (3*a*b*(b*d + a*g)*x^4)/4 + (3*a*b*(b*e + a*h)*x^5)/5 + (b^2*(b*c + 3*a*f)*x^6)/6 + (b^2*(b*d + 3*a*g)*x^7)/7 + (b^2*(b*e + 3*a*h)*x^8)/8 + (b^3*f*x^9)/9 + (b^3*g*x^10)/10 + (b^3*h*x^11)/11 + a^2*(3*b*c + a*f)*Log[x]", //
        1834);
  }

  // {1834}
  public void test3398() {
    check( //
        "Integrate[((a + b*x^3)^3*(c + d*x + e*x^2 + f*x^3 + g*x^4 + h*x^5))/x^5, x]", //
        "-(a^3*c)/(4*x^4) - (a^3*d)/(3*x^3) - (a^3*e)/(2*x^2) - (a^2*(3*b*c + a*f))/x + a^2*(3*b*e + a*h)*x + (3*a*b*(b*c + a*f)*x^2)/2 + a*b*(b*d + a*g)*x^3 + (3*a*b*(b*e + a*h)*x^4)/4 + (b^2*(b*c + 3*a*f)*x^5)/5 + (b^2*(b*d + 3*a*g)*x^6)/6 + (b^2*(b*e + 3*a*h)*x^7)/7 + (b^3*f*x^8)/8 + (b^3*g*x^9)/9 + (b^3*h*x^10)/10 + a^2*(3*b*d + a*g)*Log[x]", //
        1834);
  }

  // {1864}
  public void test3399() {
    check( //
        "Integrate[(c + d*x + e*x^2 + f*x^3)*(a + b*x^4), x]", //
        "a*c*x + (a*d*x^2)/2 + (a*e*x^3)/3 + (a*f*x^4)/4 + (b*c*x^5)/5 + (b*d*x^6)/6 + (b*e*x^7)/7 + (b*f*x^8)/8", //
        1864);
  }

  // {1834}
  public void test3400() {
    check( //
        "Integrate[x^3*(c + d*x + e*x^2 + f*x^3)*(a + b*x^4), x]", //
        "(a*c*x^4)/4 + (a*d*x^5)/5 + (a*e*x^6)/6 + (a*f*x^7)/7 + (b*c*x^8)/8 + (b*d*x^9)/9 + (b*e*x^10)/10 + (b*f*x^11)/11", //
        1834);
  }

  // {1600, 31}
  public void test3401() {
    check( //
        "Integrate[(1 + x + x^2 + x^3 + x^4)/(1 - x^5), x]", //
        "-Log[1 - x]", //
        1600,
        31);
  }

  // {1600, 31}
  public void test3402() {
    check( //
        "Integrate[(243 - 162*x + 108*x^2 - 72*x^3 + 48*x^4 - 32*x^5)/(729 - 64*x^6), x]", //
        "Log[3 + 2*x]/2", //
        1600,
        31);
  }

  // {1600, 31}
  public void test3403() {
    check( //
        "Integrate[(243 + 162*x + 108*x^2 + 72*x^3 + 48*x^4 + 32*x^5)/(729 - 64*x^6), x]", //
        "-Log[3 - 2*x]/2", //
        1600,
        31);
  }

  // {1600, 212}
  public void test3404() {
    check( //
        "Integrate[(81 + 36*x^2 + 16*x^4)/(729 - 64*x^6), x]", //
        "ArcTanh[(2*x)/3]/6", //
        1600,
        212);
  }

  // {6873, 1830}
  public void test3405() {
    check( //
        "Integrate[(-(a*h*x^(-1 + n/4)) + b*f*x^(-1 + n/2) + b*g*x^(-1 + n) + b*h*x^(-1 + (5*n)/4))/(a + b*x^n)^(3/2), x]", //
        "(-2*(a*g + 2*a*h*x^(n/4) - b*f*x^(n/2)))/(a*n*Sqrt[a + b*x^n])", //
        6873,
        1830);
  }

  // {14}
  public void test3406() {
    check( //
        "Integrate[x^2*(a*x + b*x^3), x]", //
        "(a*x^4)/4 + (b*x^6)/6", //
        14);
  }

  // {14}
  public void test3407() {
    check( //
        "Integrate[x*(a*x + b*x^3), x]", //
        "(a*x^3)/3 + (b*x^5)/5", //
        14);
  }

  // {14}
  public void test3408() {
    check( //
        "Integrate[(a*x + b*x^3)/x, x]", //
        "a*x + (b*x^3)/3", //
        14);
  }

  // {14}
  public void test3409() {
    check( //
        "Integrate[(a*x + b*x^3)/x^2, x]", //
        "(b*x^2)/2 + a*Log[x]", //
        14);
  }

  // {1598, 267}
  public void test3410() {
    check( //
        "Integrate[(a*x + b*x^3)^2/x, x]", //
        "(a + b*x^2)^3/(6*b)", //
        1598,
        267);
  }

  // {1598, 266}
  public void test3411() {
    check( //
        "Integrate[x^2/(a*x + b*x^3), x]", //
        "Log[a + b*x^2]/(2*b)", //
        1598,
        266);
  }

  // {1598, 211}
  public void test3412() {
    check( //
        "Integrate[x/(a*x + b*x^3), x]", //
        "ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(Sqrt[a]*Sqrt[b])", //
        1598,
        211);
  }

  // {1598, 266}
  public void test3413() {
    check( //
        "Integrate[x^2/(x - x^3), x]", //
        "-Log[1 - x^2]/2", //
        1598,
        266);
  }

  // {1598, 212}
  public void test3414() {
    check( //
        "Integrate[x/(x - x^3), x]", //
        "ArcTanh[x]", //
        1598,
        212);
  }

  // {2040, 2039}
  public void test3415() {
    check( //
        "Integrate[x^(17/2)/(a*x + b*x^3)^(9/2), x]", //
        "x^(17/2)/(7*a*(a*x + b*x^3)^(7/2)) + (2*x^(15/2))/(35*a^2*(a*x + b*x^3)^(5/2))", //
        2040,
        2039);
  }

  // {2040, 2039}
  public void test3416() {
    check( //
        "Integrate[x^(15/2)/(a*x + b*x^3)^(9/2), x]", //
        "-x^(11/2)/(7*b*(a*x + b*x^3)^(7/2)) - (2*x^(5/2))/(35*b^2*(a*x + b*x^3)^(5/2))", //
        2040,
        2039);
  }

  // {2054, 212}
  public void test3417() {
    check( //
        "Integrate[x/Sqrt[a*x + b*x^4], x]", //
        "(2*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x + b*x^4]])/(3*Sqrt[b])", //
        2054,
        212);
  }

  // {2041, 2039}
  public void test3418() {
    check( //
        "Integrate[1/(x^5*Sqrt[a*x + b*x^4]), x]", //
        "(-2*Sqrt[a*x + b*x^4])/(9*a*x^5) + (4*b*Sqrt[a*x + b*x^4])/(9*a^2*x^2)", //
        2041,
        2039);
  }

  // {2041, 2039}
  public void test3419() {
    check( //
        "Integrate[1/(x^(3/2)*Sqrt[b*Sqrt[x] + a*x]), x]", //
        "(-4*Sqrt[b*Sqrt[x] + a*x])/(3*b*x) + (8*a*Sqrt[b*Sqrt[x] + a*x])/(3*b^2*Sqrt[x])", //
        2041,
        2039);
  }

  // {2038, 627}
  public void test3420() {
    check( //
        "Integrate[1/(Sqrt[x]*(b*Sqrt[x] + a*x)^(3/2)), x]", //
        "(-4*(b + 2*a*Sqrt[x]))/(b^2*Sqrt[b*Sqrt[x] + a*x])", //
        2038,
        627);
  }

  // {2027, 2039}
  public void test3421() {
    check( //
        "Integrate[1/Sqrt[b*x^(2/3) + a*x], x]", //
        "(2*Sqrt[b*x^(2/3) + a*x])/a - (4*b*Sqrt[b*x^(2/3) + a*x])/(a^2*x^(1/3))", //
        2027,
        2039);
  }

  // {14}
  public void test3422() {
    check( //
        "Integrate[x^2*(a*x^2 + b*x^3), x]", //
        "(a*x^5)/5 + (b*x^6)/6", //
        14);
  }

  // {14}
  public void test3423() {
    check( //
        "Integrate[x*(a*x^2 + b*x^3), x]", //
        "(a*x^4)/4 + (b*x^5)/5", //
        14);
  }

  // {14}
  public void test3424() {
    check( //
        "Integrate[(a*x^2 + b*x^3)/x, x]", //
        "(a*x^2)/2 + (b*x^3)/3", //
        14);
  }

  // {14}
  public void test3425() {
    check( //
        "Integrate[(a*x^2 + b*x^3)/x^2, x]", //
        "a*x + (b*x^2)/2", //
        14);
  }

  // {1598, 31}
  public void test3426() {
    check( //
        "Integrate[x^2/(a*x^2 + b*x^3), x]", //
        "Log[a + b*x]/b", //
        1598,
        31);
  }

  // {1598, 32}
  public void test3427() {
    check( //
        "Integrate[x^4/(a*x^2 + b*x^3)^2, x]", //
        "-(1/(b*(a + b*x)))", //
        1598,
        32);
  }

  // {2027, 2039}
  public void test3428() {
    check( //
        "Integrate[Sqrt[a*x^2 + b*x^3], x]", //
        "(-4*a*(a*x^2 + b*x^3)^(3/2))/(15*b^2*x^3) + (2*(a*x^2 + b*x^3)^(3/2))/(5*b*x^2)", //
        2027,
        2039);
  }

  // {2041, 2039}
  public void test3429() {
    check( //
        "Integrate[(a*x^2 + b*x^3)^(3/2)/x^2, x]", //
        "(-4*a*(a*x^2 + b*x^3)^(5/2))/(35*b^2*x^5) + (2*(a*x^2 + b*x^3)^(5/2))/(7*b*x^4)", //
        2041,
        2039);
  }

  // {2041, 1602}
  public void test3430() {
    check( //
        "Integrate[x^2/Sqrt[a*x^2 + b*x^3], x]", //
        "(2*Sqrt[a*x^2 + b*x^3])/(3*b) - (4*a*Sqrt[a*x^2 + b*x^3])/(3*b^2*x)", //
        2041,
        1602);
  }

  // {2033, 212}
  public void test3431() {
    check( //
        "Integrate[1/Sqrt[a*x^2 + b*x^3], x]", //
        "(-2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^3]])/Sqrt[a]", //
        2033,
        212);
  }

  // {2040, 1602}
  public void test3432() {
    check( //
        "Integrate[x^4/(a*x^2 + b*x^3)^(3/2), x]", //
        "(-2*x^2)/(b*Sqrt[a*x^2 + b*x^3]) + (4*Sqrt[a*x^2 + b*x^3])/(b^2*x)", //
        2040,
        1602);
  }

  // {2054, 212}
  public void test3433() {
    check( //
        "Integrate[Sqrt[x]/Sqrt[a*x^2 + b*x^3], x]", //
        "(2*ArcTanh[(Sqrt[b]*x^(3/2))/Sqrt[a*x^2 + b*x^3]])/Sqrt[b]", //
        2054,
        212);
  }

  // {2041, 2039}
  public void test3434() {
    check( //
        "Integrate[1/(x^(3/2)*Sqrt[a*x^2 + b*x^3]), x]", //
        "(-2*Sqrt[a*x^2 + b*x^3])/(3*a*x^(5/2)) + (4*b*Sqrt[a*x^2 + b*x^3])/(3*a^2*x^(3/2))", //
        2041,
        2039);
  }

  // {2041, 2039}
  public void test3435() {
    check( //
        "Integrate[x^(-3 - 3*n)*(a*x^2 + b*x^3)^n, x]", //
        "-((x^(-4 - 3*n)*(a*x^2 + b*x^3)^(1 + n))/(a*(2 + n))) + (b*(a*x^2 + b*x^3)^(1 + n))/(a^2*(1 + n)*(2 + n)*x^(3*(1 + n)))", //
        2041,
        2039);
  }

  // {1598, 270}
  public void test3436() {
    check( //
        "Integrate[x^11/(a*x^2 + b*x^5)^3, x]", //
        "x^6/(6*a*(a + b*x^3)^2)", //
        1598,
        270);
  }

  // {2041, 1602}
  public void test3437() {
    check( //
        "Integrate[x^6/Sqrt[a*x^2 + b*x^5], x]", //
        "(-4*a*Sqrt[a*x^2 + b*x^5])/(9*b^2*x) + (2*x^2*Sqrt[a*x^2 + b*x^5])/(9*b)", //
        2041,
        1602);
  }

  // {2033, 212}
  public void test3438() {
    check( //
        "Integrate[1/Sqrt[a*x^2 + b*x^5], x]", //
        "(-2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^5]])/(3*Sqrt[a])", //
        2033,
        212);
  }

  // {2057, 224}
  public void test3439() {
    check( //
        "Integrate[x/Sqrt[a*x^2 + b*x^5], x]", //
        "(2*Sqrt[2 + Sqrt[3]]*x*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3^(1/4)*b^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a*x^2 + b*x^5])", //
        2057,
        224);
  }

  // {2054, 212}
  public void test3440() {
    check( //
        "Integrate[x^(3/2)/Sqrt[a*x^2 + b*x^5], x]", //
        "(2*ArcTanh[(Sqrt[b]*x^(5/2))/Sqrt[a*x^2 + b*x^5]])/(3*Sqrt[b])", //
        2054,
        212);
  }

  // {2041, 2039}
  public void test3441() {
    check( //
        "Integrate[1/(x^(9/2)*Sqrt[a*x^2 + b*x^5]), x]", //
        "(-2*Sqrt[a*x^2 + b*x^5])/(9*a*x^(11/2)) + (4*b*Sqrt[a*x^2 + b*x^5])/(9*a^2*x^(5/2))", //
        2041,
        2039);
  }

  // {2054, 212}
  public void test3442() {
    check( //
        "Integrate[x/Sqrt[a*x^3 + b*x^4], x]", //
        "(2*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a*x^3 + b*x^4]])/Sqrt[b]", //
        2054,
        212);
  }

  // {2041, 2025}
  public void test3443() {
    check( //
        "Integrate[1/(x*Sqrt[a*x^3 + b*x^4]), x]", //
        "(-2*Sqrt[a*x^3 + b*x^4])/(3*a*x^3) + (4*b*Sqrt[a*x^3 + b*x^4])/(3*a^2*x^2)", //
        2041,
        2025);
  }

  // {1607, 267}
  public void test3444() {
    check( //
        "Integrate[(a*x + b*x^14)^12, x]", //
        "(a + b*x^13)^13/(169*b)", //
        1607,
        267);
  }

  // {1598, 267}
  public void test3445() {
    check( //
        "Integrate[x^12*(a*x + b*x^26)^12, x]", //
        "(a + b*x^25)^13/(325*b)", //
        1598,
        267);
  }

  // {1598, 267}
  public void test3446() {
    check( //
        "Integrate[x^24*(a*x + b*x^38)^12, x]", //
        "(a + b*x^37)^13/(481*b)", //
        1598,
        267);
  }

  // {1598, 267}
  public void test3447() {
    check( //
        "Integrate[x^(12*(-1 + m))*(a*x + b*x^(2 + 12*m))^12, x]", //
        "(a + b*x^(1 + 12*m))^13/(13*b*(1 + 12*m))", //
        1598,
        267);
  }

  // {1607, 267}
  public void test3448() {
    check( //
        "Integrate[(a*x + b*x^14)^12, x]", //
        "(a + b*x^13)^13/(169*b)", //
        1607,
        267);
  }

  // {1607, 267}
  public void test3449() {
    check( //
        "Integrate[(a*x^2 + b*x^27)^12, x]", //
        "(a + b*x^25)^13/(325*b)", //
        1607,
        267);
  }

  // {1607, 267}
  public void test3450() {
    check( //
        "Integrate[(a*x^3 + b*x^40)^12, x]", //
        "(a + b*x^37)^13/(481*b)", //
        1607,
        267);
  }

  // {1607, 267}
  public void test3451() {
    check( //
        "Integrate[(a*x^m + b*x^(1 + 13*m))^12, x]", //
        "(a + b*x^(1 + 12*m))^13/(13*b*(1 + 12*m))", //
        1607,
        267);
  }

  // {1607, 267}
  public void test3452() {
    check( //
        "Integrate[(a*x^m + b*x^(1 + 6*m))^5, x]", //
        "(a + b*x^(1 + 5*m))^6/(6*b*(1 + 5*m))", //
        1607,
        267);
  }

  // {1607, 267}
  public void test3453() {
    check( //
        "Integrate[(b*x^(1 - 2*m) + a*x^m)^(-3), x]", //
        "-1/(2*b*(1 - 3*m)*(a + b*x^(1 - 3*m))^2)", //
        1607,
        267);
  }

  // {1607, 266}
  public void test3454() {
    check( //
        "Integrate[(b/x + a*x)^(-1), x]", //
        "Log[b + a*x^2]/(2*a)", //
        1607,
        266);
  }

  // {1607, 266}
  public void test3455() {
    check( //
        "Integrate[(b/x^2 + a*x)^(-1), x]", //
        "Log[b + a*x^3]/(3*a)", //
        1607,
        266);
  }

  // {1607, 266}
  public void test3456() {
    check( //
        "Integrate[(b/x^3 + a*x)^(-1), x]", //
        "Log[b + a*x^4]/(4*a)", //
        1607,
        266);
  }

  // {1607, 270}
  public void test3457() {
    check( //
        "Integrate[(b/x + a*x)^(-3), x]", //
        "x^4/(4*b*(b + a*x^2)^2)", //
        1607,
        270);
  }

  // {1607, 270}
  public void test3458() {
    check( //
        "Integrate[(b/x^3 + a*x^2)^(-3), x]", //
        "x^10/(10*b*(b + a*x^5)^2)", //
        1607,
        270);
  }

  // {1607, 270}
  public void test3459() {
    check( //
        "Integrate[(b/x^5 + a*x^3)^(-3), x]", //
        "x^16/(16*b*(b + a*x^8)^2)", //
        1607,
        270);
  }

  // {1598, 267}
  public void test3460() {
    check( //
        "Integrate[x^p*(a*x^n + b*x^(1 + 13*n + p))^12, x]", //
        "(a + b*x^(1 + 12*n + p))^13/(13*b*(1 + 12*n + p))", //
        1598,
        267);
  }

  // {1598, 267}
  public void test3461() {
    check( //
        "Integrate[x^12*(a*x + b*x^26)^12, x]", //
        "(a + b*x^25)^13/(325*b)", //
        1598,
        267);
  }

  // {1598, 267}
  public void test3462() {
    check( //
        "Integrate[x^12*(a*x^2 + b*x^39)^12, x]", //
        "(a + b*x^37)^13/(481*b)", //
        1598,
        267);
  }

  // {1598, 267}
  public void test3463() {
    check( //
        "Integrate[x^24*(a*x + b*x^38)^12, x]", //
        "(a + b*x^37)^13/(481*b)", //
        1598,
        267);
  }

  // {1607, 266}
  public void test3464() {
    check( //
        "Integrate[(a*x + b*x^n)^(-1), x]", //
        "Log[b + a*x^(1 - n)]/(a*(1 - n))", //
        1607,
        266);
  }

  // {1607, 266}
  public void test3465() {
    check( //
        "Integrate[(a*x + b*x^(1 - n))^(-1), x]", //
        "Log[b + a*x^n]/(a*n)", //
        1607,
        266);
  }

  // {1607, 266}
  public void test3466() {
    check( //
        "Integrate[(2*x + 3*x^(1 - n))^(-1), x]", //
        "Log[3 + 2*x^n]/(2*n)", //
        1607,
        266);
  }

  // {1607, 266}
  public void test3467() {
    check( //
        "Integrate[(-Sqrt[x] + x)^(-1), x]", //
        "2*Log[1 - Sqrt[x]]", //
        1607,
        266);
  }

  // {1607, 266}
  public void test3468() {
    check( //
        "Integrate[(-x^(3/5) + x)^(-1), x]", //
        "(5*Log[1 - x^(2/5)])/2", //
        1607,
        266);
  }

  // {1607, 266}
  public void test3469() {
    check( //
        "Integrate[(x^(-1/3) + x)^(-1), x]", //
        "(3*Log[1 + x^(4/3)])/4", //
        1607,
        266);
  }

  // {2033, 212}
  public void test3470() {
    check( //
        "Integrate[1/Sqrt[a*x^2 + b*x^n], x]", //
        "(2*ArcTanh[(Sqrt[a]*x)/Sqrt[a*x^2 + b*x^n]])/(Sqrt[a]*(2 - n))", //
        2033,
        212);
  }

  // {2004, 2025}
  public void test3471() {
    check( //
        "Integrate[Sqrt[(1 + x)/x^5], x]", //
        "(-2*(x^(-5) + x^(-4))^(3/2)*x^6)/3", //
        2004,
        2025);
  }

  // {2004, 2025}
  public void test3472() {
    check( //
        "Integrate[Sqrt[x^4*(a + b*x^3)], x]", //
        "(2*(a*x^4 + b*x^7)^(3/2))/(9*b*x^6)", //
        2004,
        2025);
  }

  // {2004, 2025}
  public void test3473() {
    check( //
        "Integrate[(x^m*(a + b*x^(1 + m*p)))^p, x]", //
        "(a*x^m + b*x^(1 + m + m*p))^(1 + p)/(b*(1 + p)*(1 + m*p)*x^(m*(1 + p)))", //
        2004,
        2025);
  }

  // {2005, 2039}
  public void test3474() {
    check( //
        "Integrate[x^n*(x^m*(a + b*x^(1 + n + m*p)))^p, x]", //
        "(a*x^m + b*x^(1 + m + n + m*p))^(1 + p)/(b*(1 + p)*(1 + n + m*p)*x^(m*(1 + p)))", //
        2005,
        2039);
  }

  // {2004, 2025}
  public void test3475() {
    check( //
        "Integrate[Sqrt[x^(2*(-1 + n))*(a + b*x^n)], x]", //
        "(2*x^(3*(1 - n))*(a/x^(2*(1 - n)) + b*x^(-2 + 3*n))^(3/2))/(3*b*n)", //
        2004,
        2025);
  }

  // {2004, 2025}
  public void test3476() {
    check( //
        "Integrate[(x^(3*(-1 + n))*(a + b*x^n))^(1/3), x]", //
        "(3*x^(4*(1 - n))*(a/x^(3*(1 - n)) + b*x^(-3 + 4*n))^(4/3))/(4*b*n)", //
        2004,
        2025);
  }

  // {2004, 2025}
  public void test3477() {
    check( //
        "Integrate[(x^(4*(-1 + n))*(a + b*x^n))^(1/4), x]", //
        "(4*x^(5*(1 - n))*(a/x^(4*(1 - n)) + b*x^(-4 + 5*n))^(5/4))/(5*b*n)", //
        2004,
        2025);
  }

  // {2004, 2025}
  public void test3478() {
    check( //
        "Integrate[(x^((-1 + n)*p)*(a + b*x^n))^p^(-1), x]", //
        "(p*x^((1 - n)*(1 + p))*(a/x^((1 - n)*p) + b*x^(n - (1 - n)*p))^(1 + p^(-1)))/(b*n*(1 + p))", //
        2004,
        2025);
  }

  // {2004, 2025}
  public void test3479() {
    check( //
        "Integrate[(x^((-1 + n)/p)*(a + b*x^n))^p, x]", //
        "(x^(((1 - n)*(1 + p))/p)*(b*x^(n - (1 - n)/p) + a/x^((1 - n)/p))^(1 + p))/(b*n*(1 + p))", //
        2004,
        2025);
  }

  // {2005, 2039}
  public void test3480() {
    check( //
        "Integrate[x^(-1 - n*q - p*(1 + q))*(x^n*(a + b*x^p))^q, x]", //
        "-((a*x^n + b*x^(n + p))^(1 + q)/(a*p*(1 + q)*x^((n + p)*(1 + q))))", //
        2005,
        2039);
  }

  // {1159, 2025}
  public void test3481() {
    check( //
        "Integrate[(A + B*x^2)*Sqrt[b*x^2 + c*x^4], x]", //
        "-((2*b*B - 5*A*c)*(b*x^2 + c*x^4)^(3/2))/(15*c^2*x^3) + (B*(b*x^2 + c*x^4)^(3/2))/(5*c*x)", //
        1159,
        2025);
  }

  // {2064, 2039}
  public void test3482() {
    check( //
        "Integrate[((A + B*x^2)*(b*x^2 + c*x^4)^(3/2))/x^2, x]", //
        "-((2*b*B - 7*A*c)*(b*x^2 + c*x^4)^(5/2))/(35*c^2*x^5) + (B*(b*x^2 + c*x^4)^(5/2))/(7*c*x^3)", //
        2064,
        2039);
  }

  // {2064, 1602}
  public void test3483() {
    check( //
        "Integrate[(x^2*(A + B*x^2))/Sqrt[b*x^2 + c*x^4], x]", //
        "-((2*b*B - 3*A*c)*Sqrt[b*x^2 + c*x^4])/(3*c^2*x) + (B*x*Sqrt[b*x^2 + c*x^4])/(3*c)", //
        2064,
        1602);
  }

  // {2059, 650}
  public void test3484() {
    check( //
        "Integrate[(x*(A + B*x^2))/(b*x^2 + c*x^4)^(3/2), x]", //
        "-((A*b - (b*B - 2*A*c)*x^2)/(b^2*Sqrt[b*x^2 + c*x^4]))", //
        2059,
        650);
  }

  // {2062, 1602}
  public void test3485() {
    check( //
        "Integrate[(x^4*(A + B*x^2))/(b*x^2 + c*x^4)^(3/2), x]", //
        "-(((b*B - A*c)*x^3)/(b*c*Sqrt[b*x^2 + c*x^4])) + ((2*b*B - A*c)*Sqrt[b*x^2 + c*x^4])/(b*c^2*x)", //
        2062,
        1602);
  }

  // {2064, 2039}
  public void test3486() {
    check( //
        "Integrate[x^(-1 + n - j*p)*(c + d*x^n)*(a*x^j + b*x^(j + n))^p, x]", //
        "((c - (a*d)/(b*(2 + p)))*(a*x^j + b*x^(j + n))^(1 + p))/(b*n*(1 + p)*x^(j*(1 + p))) + (d*x^(n - j*(1 + p))*(a*x^j + b*x^(j + n))^(1 + p))/(b*n*(2 + p))", //
        2064,
        2039);
  }

  // {1598, 460}
  public void test3487() {
    check( //
        "Integrate[x^m*(a + b*x^n)^p*(a*(1 + m + q)*x^q + b*(1 + m + n*(1 + p) + q)*x^(n + q)), x]", //
        "x^(1 + m + q)*(a + b*x^n)^(1 + p)", //
        1598,
        460);
  }

  // {633, 221}
  public void test3488() {
    check( //
        "Integrate[1/Sqrt[(3*I)*x + 4*x^2], x]", //
        "(I/2)*ArcSin[1 - ((8*I)/3)*x]", //
        633,
        221);
  }

  // {628, 627}
  public void test3489() {
    check( //
        "Integrate[((3*I)*x + 4*x^2)^(-5/2), x]", //
        "(2*(3*I + 8*x))/(27*((3*I)*x + 4*x^2)^(3/2)) + (64*(3*I + 8*x))/(243*Sqrt[(3*I)*x + 4*x^2])", //
        628,
        627);
  }

  // {633, 222}
  public void test3490() {
    check( //
        "Integrate[1/Sqrt[3*x - 4*x^2], x]", //
        "-ArcSin[1 - (8*x)/3]/2", //
        633,
        222);
  }

  // {628, 627}
  public void test3491() {
    check( //
        "Integrate[(3*x - 4*x^2)^(-5/2), x]", //
        "(-2*(3 - 8*x))/(27*(3*x - 4*x^2)^(3/2)) - (64*(3 - 8*x))/(243*Sqrt[3*x - 4*x^2])", //
        628,
        627);
  }

  // {633, 222}
  public void test3492() {
    check( //
        "Integrate[1/Sqrt[b*x - b^2*x^2], x]", //
        "-(ArcSin[1 - 2*b*x]/b)", //
        633,
        222);
  }

  // {634, 212}
  public void test3493() {
    check( //
        "Integrate[1/Sqrt[b*x + b^2*x^2], x]", //
        "(2*ArcTanh[(b*x)/Sqrt[b*x + b^2*x^2]])/b", //
        634,
        212);
  }

  // {633, 222}
  public void test3494() {
    check( //
        "Integrate[1/Sqrt[6*x - x^2], x]", //
        "-ArcSin[1 - x/3]", //
        633,
        222);
  }

  // {634, 212}
  public void test3495() {
    check( //
        "Integrate[1/Sqrt[4*x + x^2], x]", //
        "2*ArcTanh[x/Sqrt[4*x + x^2]]", //
        634,
        212);
  }

  // {634, 212}
  public void test3496() {
    check( //
        "Integrate[1/Sqrt[-2*x + x^2], x]", //
        "2*ArcTanh[x/Sqrt[-2*x + x^2]]", //
        634,
        212);
  }

  // {200}
  public void test3497() {
    check( //
        "Integrate[(a + c*x^2)^4, x]", //
        "a^4*x + (4*a^3*c*x^3)/3 + (6*a^2*c^2*x^5)/5 + (4*a*c^3*x^7)/7 + (c^4*x^9)/9", //
        200);
  }

  // {200}
  public void test3498() {
    check( //
        "Integrate[(a + c*x^2)^3, x]", //
        "a^3*x + a^2*c*x^3 + (3*a*c^2*x^5)/5 + (c^3*x^7)/7", //
        200);
  }

  // {200}
  public void test3499() {
    check( //
        "Integrate[(a + c*x^2)^2, x]", //
        "a^2*x + (2*a*c*x^3)/3 + (c^2*x^5)/5", //
        200);
  }

  // {205, 211}
  public void test3500() {
    check( //
        "Integrate[(a + c*x^2)^(-2), x]", //
        "x/(2*a*(a + c*x^2)) + ArcTan[(Sqrt[c]*x)/Sqrt[a]]/(2*a^(3/2)*Sqrt[c])", //
        205,
        211);
  }

  // {223, 212}
  public void test3501() {
    check( //
        "Integrate[1/Sqrt[a + c*x^2], x]", //
        "ArcTanh[(Sqrt[c]*x)/Sqrt[a + c*x^2]]/Sqrt[c]", //
        223,
        212);
  }

  // {198, 197}
  public void test3502() {
    check( //
        "Integrate[(a + c*x^2)^(-5/2), x]", //
        "x/(3*a*(a + c*x^2)^(3/2)) + (2*x)/(3*a^2*Sqrt[a + c*x^2])", //
        198,
        197);
  }

  // {622, 31}
  public void test3503() {
    check( //
        "Integrate[1/Sqrt[4 + 12*x + 9*x^2], x]", //
        "((2 + 3*x)*Log[2 + 3*x])/(3*Sqrt[4 + 12*x + 9*x^2])", //
        622,
        31);
  }

  // {622, 31}
  public void test3504() {
    check( //
        "Integrate[1/Sqrt[4 - 12*x + 9*x^2], x]", //
        "-((2 - 3*x)*Log[2 - 3*x])/(3*Sqrt[4 - 12*x + 9*x^2])", //
        622,
        31);
  }

  // {622, 31}
  public void test3505() {
    check( //
        "Integrate[1/Sqrt[-4 + 12*x - 9*x^2], x]", //
        "-((2 - 3*x)*Log[2 - 3*x])/(3*Sqrt[-4 + 12*x - 9*x^2])", //
        622,
        31);
  }

  // {622, 31}
  public void test3506() {
    check( //
        "Integrate[1/Sqrt[-4 - 12*x - 9*x^2], x]", //
        "((2 + 3*x)*Log[2 + 3*x])/(3*Sqrt[-4 - 12*x - 9*x^2])", //
        622,
        31);
  }

  // {632, 210}
  public void test3507() {
    check( //
        "Integrate[(2 + 4*x + 3*x^2)^(-1), x]", //
        "ArcTan[(2 + 3*x)/Sqrt[2]]/Sqrt[2]", //
        632,
        210);
  }

  // {632, 210}
  public void test3508() {
    check( //
        "Integrate[(4 - 2*Sqrt[3]*x + x^2)^(-1), x]", //
        "-ArcTan[Sqrt[3] - x]", //
        632,
        210);
  }

  // {632, 212}
  public void test3509() {
    check( //
        "Integrate[(2 + 4*x - 3*x^2)^(-1), x]", //
        "-(ArcTanh[(2 - 3*x)/Sqrt[10]]/Sqrt[10])", //
        632,
        212);
  }

  // {632, 212}
  public void test3510() {
    check( //
        "Integrate[(1 + Pi*x + 2*x^2)^(-1), x]", //
        "(-2*ArcTanh[(Pi + 4*x)/Sqrt[-8 + Pi^2]])/Sqrt[-8 + Pi^2]", //
        632,
        212);
  }

  // {632, 212}
  public void test3511() {
    check( //
        "Integrate[(1 + Pi*x - 2*x^2)^(-1), x]", //
        "(-2*ArcTanh[(Pi - 4*x)/Sqrt[8 + Pi^2]])/Sqrt[8 + Pi^2]", //
        632,
        212);
  }

  // {632, 210}
  public void test3512() {
    check( //
        "Integrate[(1 + Pi*x + 3*x^2)^(-1), x]", //
        "(2*ArcTan[(Pi + 6*x)/Sqrt[12 - Pi^2]])/Sqrt[12 - Pi^2]", //
        632,
        210);
  }

  // {632, 212}
  public void test3513() {
    check( //
        "Integrate[(1 + Pi*x - 3*x^2)^(-1), x]", //
        "(-2*ArcTanh[(Pi - 6*x)/Sqrt[12 + Pi^2]])/Sqrt[12 + Pi^2]", //
        632,
        212);
  }

  // {632, 210}
  public void test3514() {
    check( //
        "Integrate[(a + c*x + b*x^2)^(-1), x]", //
        "(2*ArcTan[(c + 2*b*x)/Sqrt[4*a*b - c^2]])/Sqrt[4*a*b - c^2]", //
        632,
        210);
  }

  // {632, 212}
  public void test3515() {
    check( //
        "Integrate[(b + 2*a*x + b*x^2)^(-1), x]", //
        "-(ArcTanh[(a + b*x)/Sqrt[a^2 - b^2]]/Sqrt[a^2 - b^2])", //
        632,
        212);
  }

  // {632, 212}
  public void test3516() {
    check( //
        "Integrate[(b + 2*a*x - b*x^2)^(-1), x]", //
        "-(ArcTanh[(a - b*x)/Sqrt[a^2 + b^2]]/Sqrt[a^2 + b^2])", //
        632,
        212);
  }

  // {632, 210}
  public void test3517() {
    check( //
        "Integrate[((a/b)^(2/n) + x^2 - 2*(a/b)^n^(-1)*x*Cos[(Pi - 2*k*Pi)/n])^(-1), x]", //
        "-((ArcTan[Cot[(Pi - 2*k*Pi)/n] - (x*Csc[(Pi - 2*k*Pi)/n])/(a/b)^n^(-1)]*Csc[(Pi - 2*k*Pi)/n])/(a/b)^n^(-1))", //
        632,
        210);
  }

  // {632, 210}
  public void test3518() {
    check( //
        "Integrate[(1 + x^2 + 2*x*Cos[1/7])^(-1), x]", //
        "ArcTan[(x + Cos[1/7])*Csc[1/7]]*Csc[1/7]", //
        632,
        210);
  }

  // {632, 210}
  public void test3519() {
    check( //
        "Integrate[(1 + x^2 + 2*x*Cos[Pi/7])^(-1), x]", //
        "ArcTan[(x + Cos[Pi/7])*Csc[Pi/7]]*Csc[Pi/7]", //
        632,
        210);
  }

  // {633, 221}
  public void test3520() {
    check( //
        "Integrate[1/Sqrt[5 - 6*x + 9*x^2], x]", //
        "ArcSinh[(-1 + 3*x)/2]/3", //
        633,
        221);
  }

  // {633, 222}
  public void test3521() {
    check( //
        "Integrate[1/Sqrt[3 - 4*x - 4*x^2], x]", //
        "ArcSin[1/2 + x]/2", //
        633,
        222);
  }

  // {635, 212}
  public void test3522() {
    check( //
        "Integrate[1/Sqrt[-8 + 6*x + 9*x^2], x]", //
        "ArcTanh[(1 + 3*x)/Sqrt[-8 + 6*x + 9*x^2]]/3", //
        635,
        212);
  }

  // {633, 221}
  public void test3523() {
    check( //
        "Integrate[1/Sqrt[2 + 4*x + 3*x^2], x]", //
        "ArcSinh[(2 + 3*x)/Sqrt[2]]/Sqrt[3]", //
        633,
        221);
  }

  // {633, 222}
  public void test3524() {
    check( //
        "Integrate[1/Sqrt[2 + 4*x - 3*x^2], x]", //
        "-(ArcSin[(2 - 3*x)/Sqrt[10]]/Sqrt[3])", //
        633,
        222);
  }

  // {635, 212}
  public void test3525() {
    check( //
        "Integrate[1/Sqrt[2 + 5*x + 3*x^2], x]", //
        "ArcTanh[(5 + 6*x)/(2*Sqrt[3]*Sqrt[2 + 5*x + 3*x^2])]/Sqrt[3]", //
        635,
        212);
  }

  // {633, 222}
  public void test3526() {
    check( //
        "Integrate[1/Sqrt[2 + 5*x - 3*x^2], x]", //
        "-(ArcSin[(5 - 6*x)/7]/Sqrt[3])", //
        633,
        222);
  }

  // {635, 212}
  public void test3527() {
    check( //
        "Integrate[1/Sqrt[-2 + 4*x + 3*x^2], x]", //
        "ArcTanh[(2 + 3*x)/(Sqrt[3]*Sqrt[-2 + 4*x + 3*x^2])]/Sqrt[3]", //
        635,
        212);
  }

  // {635, 210}
  public void test3528() {
    check( //
        "Integrate[1/Sqrt[-2 + 4*x - 3*x^2], x]", //
        "-(ArcTan[(2 - 3*x)/(Sqrt[3]*Sqrt[-2 + 4*x - 3*x^2])]/Sqrt[3])", //
        635,
        210);
  }

  // {635, 212}
  public void test3529() {
    check( //
        "Integrate[1/Sqrt[-2 + 5*x + 3*x^2], x]", //
        "ArcTanh[(5 + 6*x)/(2*Sqrt[3]*Sqrt[-2 + 5*x + 3*x^2])]/Sqrt[3]", //
        635,
        212);
  }

  // {633, 222}
  public void test3530() {
    check( //
        "Integrate[1/Sqrt[-2 + 5*x - 3*x^2], x]", //
        "-(ArcSin[5 - 6*x]/Sqrt[3])", //
        633,
        222);
  }

  // {633, 221}
  public void test3531() {
    check( //
        "Integrate[1/Sqrt[(b^2 + 4*c)/(4*c) + b*x + c*x^2], x]", //
        "ArcSinh[(b + 2*c*x)/(2*Sqrt[c])]/Sqrt[c]", //
        633,
        221);
  }

  // {633, 222}
  public void test3532() {
    check( //
        "Integrate[1/Sqrt[(-b^2 + 4*c)/(4*c) + b*x - c*x^2], x]", //
        "-(ArcSin[(b - 2*c*x)/(2*Sqrt[c])]/Sqrt[c])", //
        633,
        222);
  }

  // {633, 222}
  public void test3533() {
    check( //
        "Integrate[1/Sqrt[(-b^2 + c)/(4*c) + b*x - c*x^2], x]", //
        "-(ArcSin[(b - 2*c*x)/Sqrt[c]]/Sqrt[c])", //
        633,
        222);
  }

  // {628, 627}
  public void test3534() {
    check( //
        "Integrate[(5 - 4*x - x^2)^(-5/2), x]", //
        "(2 + x)/(27*(5 - 4*x - x^2)^(3/2)) + (2*(2 + x))/(243*Sqrt[5 - 4*x - x^2])", //
        628,
        627);
  }

  // {633, 251}
  public void test3535() {
    check( //
        "Integrate[(3 + 4*x + 5*x^2)^p, x]", //
        "5^(-1 - p)*11^p*(2 + 5*x)*Hypergeometric2F1[1/2, -p, 3/2, -(2 + 5*x)^2/11]", //
        633,
        251);
  }

  // {633, 251}
  public void test3536() {
    check( //
        "Integrate[(3 + 4*x + 4*x^2)^p, x]", //
        "2^(-1 + p)*(1 + 2*x)*Hypergeometric2F1[1/2, -p, 3/2, -(1 + 2*x)^2/2]", //
        633,
        251);
  }

  // {633, 251}
  public void test3537() {
    check( //
        "Integrate[(3 + 4*x + 3*x^2)^p, x]", //
        "3^(-1 - p)*5^p*(2 + 3*x)*Hypergeometric2F1[1/2, -p, 3/2, -(2 + 3*x)^2/5]", //
        633,
        251);
  }

  // {633, 251}
  public void test3538() {
    check( //
        "Integrate[(3 + 4*x + 2*x^2)^p, x]", //
        "(1 + x)*Hypergeometric2F1[1/2, -p, 3/2, -2*(1 + x)^2]", //
        633,
        251);
  }

  // {633, 251}
  public void test3539() {
    check( //
        "Integrate[(3 + 4*x - x^2)^p, x]", //
        "-(7^p*(2 - x)*Hypergeometric2F1[1/2, -p, 3/2, (2 - x)^2/7])", //
        633,
        251);
  }

  // {633, 251}
  public void test3540() {
    check( //
        "Integrate[(3 + 4*x - 2*x^2)^p, x]", //
        "-(5^p*(1 - x)*Hypergeometric2F1[1/2, -p, 3/2, (2*(1 - x)^2)/5])", //
        633,
        251);
  }

  // {633, 251}
  public void test3541() {
    check( //
        "Integrate[(3 + 4*x - 3*x^2)^p, x]", //
        "-(3^(-1 - p)*13^p*(2 - 3*x)*Hypergeometric2F1[1/2, -p, 3/2, (2 - 3*x)^2/13])", //
        633,
        251);
  }

  // {633, 251}
  public void test3542() {
    check( //
        "Integrate[(3 + 4*x - 4*x^2)^p, x]", //
        "-(2^(-1 + 2*p)*(1 - 2*x)*Hypergeometric2F1[1/2, -p, 3/2, (1 - 2*x)^2/4])", //
        633,
        251);
  }

  // {633, 251}
  public void test3543() {
    check( //
        "Integrate[(3 + 4*x - 5*x^2)^p, x]", //
        "-(5^(-1 - p)*19^p*(2 - 5*x)*Hypergeometric2F1[1/2, -p, 3/2, (2 - 5*x)^2/19])", //
        633,
        251);
  }

  // {672, 664}
  public void test3544() {
    check( //
        "Integrate[Sqrt[b*x + c*x^2]/x^4, x]", //
        "(-2*(b*x + c*x^2)^(3/2))/(5*b*x^4) + (4*c*(b*x + c*x^2)^(3/2))/(15*b^2*x^3)", //
        672,
        664);
  }

  // {672, 664}
  public void test3545() {
    check( //
        "Integrate[(b*x + c*x^2)^(3/2)/x^6, x]", //
        "(-2*(b*x + c*x^2)^(5/2))/(7*b*x^6) + (4*c*(b*x + c*x^2)^(5/2))/(35*b^2*x^5)", //
        672,
        664);
  }

  // {672, 664}
  public void test3546() {
    check( //
        "Integrate[(a*x + b*x^2)^(5/2)/x^8, x]", //
        "(-2*(a*x + b*x^2)^(7/2))/(9*a*x^8) + (4*b*(a*x + b*x^2)^(7/2))/(63*a^2*x^7)", //
        672,
        664);
  }

  // {634, 212}
  public void test3547() {
    check( //
        "Integrate[1/Sqrt[b*x + c*x^2], x]", //
        "(2*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/Sqrt[c]", //
        634,
        212);
  }

  // {672, 664}
  public void test3548() {
    check( //
        "Integrate[1/(x^2*Sqrt[b*x + c*x^2]), x]", //
        "(-2*Sqrt[b*x + c*x^2])/(3*b*x^2) + (4*c*Sqrt[b*x + c*x^2])/(3*b^2*x)", //
        672,
        664);
  }

  // {672, 627}
  public void test3549() {
    check( //
        "Integrate[1/(x*(b*x + c*x^2)^(3/2)), x]", //
        "-2/(3*b*x*Sqrt[b*x + c*x^2]) + (8*c*(b + 2*c*x))/(3*b^3*Sqrt[b*x + c*x^2])", //
        672,
        627);
  }

  // {666, 627}
  public void test3550() {
    check( //
        "Integrate[x^2/(a*x + b*x^2)^(5/2), x]", //
        "(-2*x)/(3*b*(a*x + b*x^2)^(3/2)) + (2*(a + 2*b*x))/(3*a^2*b*Sqrt[a*x + b*x^2])", //
        666,
        627);
  }

  // {652, 627}
  public void test3551() {
    check( //
        "Integrate[x/(a*x + b*x^2)^(5/2), x]", //
        "(2*x)/(3*a*(a*x + b*x^2)^(3/2)) - (8*(a + 2*b*x))/(3*a^3*Sqrt[a*x + b*x^2])", //
        652,
        627);
  }

  // {628, 627}
  public void test3552() {
    check( //
        "Integrate[(a*x + b*x^2)^(-5/2), x]", //
        "(-2*(a + 2*b*x))/(3*a^2*(a*x + b*x^2)^(3/2)) + (16*b*(a + 2*b*x))/(3*a^4*Sqrt[a*x + b*x^2])", //
        628,
        627);
  }

  // {670, 662}
  public void test3553() {
    check( //
        "Integrate[Sqrt[x]*Sqrt[b*x + c*x^2], x]", //
        "(-4*b*(b*x + c*x^2)^(3/2))/(15*c^2*x^(3/2)) + (2*(b*x + c*x^2)^(3/2))/(5*c*Sqrt[x])", //
        670,
        662);
  }

  // {670, 662}
  public void test3554() {
    check( //
        "Integrate[(b*x + c*x^2)^(3/2)/Sqrt[x], x]", //
        "(-4*b*(b*x + c*x^2)^(5/2))/(35*c^2*x^(5/2)) + (2*(b*x + c*x^2)^(5/2))/(7*c*x^(3/2))", //
        670,
        662);
  }

  // {670, 662}
  public void test3555() {
    check( //
        "Integrate[x^(3/2)/Sqrt[b*x + c*x^2], x]", //
        "(-4*b*Sqrt[b*x + c*x^2])/(3*c^2*Sqrt[x]) + (2*Sqrt[x]*Sqrt[b*x + c*x^2])/(3*c)", //
        670,
        662);
  }

  // {674, 213}
  public void test3556() {
    check( //
        "Integrate[1/(Sqrt[x]*Sqrt[b*x + c*x^2]), x]", //
        "(-2*ArcTanh[Sqrt[b*x + c*x^2]/(Sqrt[b]*Sqrt[x])])/Sqrt[b]", //
        674,
        213);
  }

  // {670, 662}
  public void test3557() {
    check( //
        "Integrate[x^(5/2)/(b*x + c*x^2)^(3/2), x]", //
        "(4*b*Sqrt[x])/(c^2*Sqrt[b*x + c*x^2]) + (2*x^(3/2))/(c*Sqrt[b*x + c*x^2])", //
        670,
        662);
  }

  // {14}
  public void test3558() {
    check( //
        "Integrate[(d*x)^m*(b*x + c*x^2), x]", //
        "(b*(d*x)^(2 + m))/(d^2*(2 + m)) + (c*(d*x)^(3 + m))/(d^3*(3 + m))", //
        14);
  }

  // {661, 66}
  public void test3559() {
    check( //
        "Integrate[(d*x)^m/(b*x + c*x^2), x]", //
        "((d*x)^m*Hypergeometric2F1[1, m, 1 + m, -((c*x)/b)])/(b*m)", //
        661,
        66);
  }

  // {661, 66}
  public void test3560() {
    check( //
        "Integrate[(d*x)^m/(b*x + c*x^2)^2, x]", //
        "-((d*(d*x)^(-1 + m)*Hypergeometric2F1[2, -1 + m, m, -((c*x)/b)])/(b^2*(1 - m)))", //
        661,
        66);
  }

  // {661, 66}
  public void test3561() {
    check( //
        "Integrate[(d*x)^m/(b*x + c*x^2)^3, x]", //
        "-((d^2*(d*x)^(-2 + m)*Hypergeometric2F1[3, -2 + m, -1 + m, -((c*x)/b)])/(b^3*(2 - m)))", //
        661,
        66);
  }

  // {654, 623}
  public void test3562() {
    check( //
        "Integrate[x*Sqrt[a^2 + 2*a*b*x + b^2*x^2], x]", //
        "-(a*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*b^2) + (a^2 + 2*a*b*x + b^2*x^2)^(3/2)/(3*b^2)", //
        654,
        623);
  }

  // {660, 37}
  public void test3563() {
    check( //
        "Integrate[Sqrt[a^2 + 2*a*b*x + b^2*x^2]/x^3, x]", //
        "-((a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(2*a*x^2)", //
        660,
        37);
  }

  // {654, 623}
  public void test3564() {
    check( //
        "Integrate[x*(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x]", //
        "-(a*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))/(4*b^2) + (a^2 + 2*a*b*x + b^2*x^2)^(5/2)/(5*b^2)", //
        654,
        623);
  }

  // {660, 37}
  public void test3565() {
    check( //
        "Integrate[(a^2 + 2*a*b*x + b^2*x^2)^(3/2)/x^5, x]", //
        "-((a + b*x)^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(4*a*x^4)", //
        660,
        37);
  }

  // {659}
  public void test3566() {
    check( //
        "Integrate[x^4*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x]", //
        "(a^4*(a + b*x)^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(6*b^5) - (4*a^3*(a + b*x)^6*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(7*b^5) + (3*a^2*(a + b*x)^7*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(4*b^5) - (4*a*(a + b*x)^8*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(9*b^5) + ((a + b*x)^9*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(10*b^5)", //
        659);
  }

  // {654, 623}
  public void test3567() {
    check( //
        "Integrate[x*(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x]", //
        "-(a*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(5/2))/(6*b^2) + (a^2 + 2*a*b*x + b^2*x^2)^(7/2)/(7*b^2)", //
        654,
        623);
  }

  // {660, 37}
  public void test3568() {
    check( //
        "Integrate[(a^2 + 2*a*b*x + b^2*x^2)^(5/2)/x^7, x]", //
        "-((a + b*x)^5*Sqrt[a^2 + 2*a*b*x + b^2*x^2])/(6*a*x^6)", //
        660,
        37);
  }

  // {622, 31}
  public void test3569() {
    check( //
        "Integrate[1/Sqrt[a^2 + 2*a*b*x + b^2*x^2], x]", //
        "((a + b*x)*Log[a + b*x])/(b*Sqrt[a^2 + 2*a*b*x + b^2*x^2])", //
        622,
        31);
  }

  // {654, 621}
  public void test3570() {
    check( //
        "Integrate[x/(a^2 + 2*a*b*x + b^2*x^2)^(3/2), x]", //
        "-(1/(b^2*Sqrt[a^2 + 2*a*b*x + b^2*x^2])) + a/(2*b^2*(a + b*x)*Sqrt[a^2 + 2*a*b*x + b^2*x^2])", //
        654,
        621);
  }

  // {660, 37}
  public void test3571() {
    check( //
        "Integrate[x^3/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x]", //
        "x^4/(4*a*(a + b*x)^3*Sqrt[a^2 + 2*a*b*x + b^2*x^2])", //
        660,
        37);
  }

  // {654, 621}
  public void test3572() {
    check( //
        "Integrate[x/(a^2 + 2*a*b*x + b^2*x^2)^(5/2), x]", //
        "-1/(3*b^2*(a^2 + 2*a*b*x + b^2*x^2)^(3/2)) + a/(4*b^2*(a + b*x)*(a^2 + 2*a*b*x + b^2*x^2)^(3/2))", //
        654,
        621);
  }

  // {654, 623}
  public void test3573() {
    check( //
        "Integrate[x*(9 + 12*x + 4*x^2)^(5/2), x]", //
        "-((3 + 2*x)*(9 + 12*x + 4*x^2)^(5/2))/8 + (9 + 12*x + 4*x^2)^(7/2)/28", //
        654,
        623);
  }

  // {654, 623}
  public void test3574() {
    check( //
        "Integrate[x*(9 + 12*x + 4*x^2)^(3/2), x]", //
        "(-3*(3 + 2*x)*(9 + 12*x + 4*x^2)^(3/2))/16 + (9 + 12*x + 4*x^2)^(5/2)/20", //
        654,
        623);
  }

  // {654, 623}
  public void test3575() {
    check( //
        "Integrate[x*Sqrt[9 + 12*x + 4*x^2], x]", //
        "(-3*(3 + 2*x)*Sqrt[9 + 12*x + 4*x^2])/8 + (9 + 12*x + 4*x^2)^(3/2)/12", //
        654,
        623);
  }

  // {654, 621}
  public void test3576() {
    check( //
        "Integrate[x/(9 + 12*x + 4*x^2)^(3/2), x]", //
        "-1/(4*Sqrt[9 + 12*x + 4*x^2]) + 3/(8*(3 + 2*x)*Sqrt[9 + 12*x + 4*x^2])", //
        654,
        621);
  }

  // {654, 621}
  public void test3577() {
    check( //
        "Integrate[x/(9 + 12*x + 4*x^2)^(5/2), x]", //
        "-1/(12*(9 + 12*x + 4*x^2)^(3/2)) + 3/(16*(3 + 2*x)*(9 + 12*x + 4*x^2)^(3/2))", //
        654,
        621);
  }

  // {654, 621}
  public void test3578() {
    check( //
        "Integrate[x/(9 + 12*x + 4*x^2)^(7/2), x]", //
        "-1/(20*(9 + 12*x + 4*x^2)^(5/2)) + 1/(8*(3 + 2*x)*(9 + 12*x + 4*x^2)^(5/2))", //
        654,
        621);
  }

  // {712}
  public void test3579() {
    check( //
        "Integrate[(d + e*x)^4*(b*x + c*x^2), x]", //
        "(d*(c*d - b*e)*(d + e*x)^5)/(5*e^3) - ((2*c*d - b*e)*(d + e*x)^6)/(6*e^3) + (c*(d + e*x)^7)/(7*e^3)", //
        712);
  }

  // {712}
  public void test3580() {
    check( //
        "Integrate[(d + e*x)^3*(b*x + c*x^2), x]", //
        "(d*(c*d - b*e)*(d + e*x)^4)/(4*e^3) - ((2*c*d - b*e)*(d + e*x)^5)/(5*e^3) + (c*(d + e*x)^6)/(6*e^3)", //
        712);
  }

  // {712}
  public void test3581() {
    check( //
        "Integrate[(d + e*x)^2*(b*x + c*x^2), x]", //
        "(b*d^2*x^2)/2 + (d*(c*d + 2*b*e)*x^3)/3 + (e*(2*c*d + b*e)*x^4)/4 + (c*e^2*x^5)/5", //
        712);
  }

  // {645}
  public void test3582() {
    check( //
        "Integrate[(d + e*x)*(b*x + c*x^2), x]", //
        "(b*d*x^2)/2 + ((c*d + b*e)*x^3)/3 + (c*e*x^4)/4", //
        645);
  }

  // {712}
  public void test3583() {
    check( //
        "Integrate[(b*x + c*x^2)/(d + e*x), x]", //
        "-(((c*d - b*e)*x)/e^2) + (c*x^2)/(2*e) + (d*(c*d - b*e)*Log[d + e*x])/e^3", //
        712);
  }

  // {712}
  public void test3584() {
    check( //
        "Integrate[(b*x + c*x^2)/(d + e*x)^2, x]", //
        "(c*x)/e^2 - (d*(c*d - b*e))/(e^3*(d + e*x)) - ((2*c*d - b*e)*Log[d + e*x])/e^3", //
        712);
  }

  // {712}
  public void test3585() {
    check( //
        "Integrate[(b*x + c*x^2)/(d + e*x)^3, x]", //
        "-(d*(c*d - b*e))/(2*e^3*(d + e*x)^2) + (2*c*d - b*e)/(e^3*(d + e*x)) + (c*Log[d + e*x])/e^3", //
        712);
  }

  // {712}
  public void test3586() {
    check( //
        "Integrate[(b*x + c*x^2)/(d + e*x)^4, x]", //
        "-(d*(c*d - b*e))/(3*e^3*(d + e*x)^3) + (2*c*d - b*e)/(2*e^3*(d + e*x)^2) - c/(e^3*(d + e*x))", //
        712);
  }

  // {712}
  public void test3587() {
    check( //
        "Integrate[(b*x + c*x^2)/(d + e*x)^5, x]", //
        "-(d*(c*d - b*e))/(4*e^3*(d + e*x)^4) + (2*c*d - b*e)/(3*e^3*(d + e*x)^3) - c/(2*e^3*(d + e*x)^2)", //
        712);
  }

  // {712}
  public void test3588() {
    check( //
        "Integrate[(d + e*x)^4*(b*x + c*x^2)^2, x]", //
        "(d^2*(c*d - b*e)^2*(d + e*x)^5)/(5*e^5) - (d*(c*d - b*e)*(2*c*d - b*e)*(d + e*x)^6)/(3*e^5) + ((6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*(d + e*x)^7)/(7*e^5) - (c*(2*c*d - b*e)*(d + e*x)^8)/(4*e^5) + (c^2*(d + e*x)^9)/(9*e^5)", //
        712);
  }

  // {712}
  public void test3589() {
    check( //
        "Integrate[(d + e*x)^3*(b*x + c*x^2)^2, x]", //
        "(b^2*d^3*x^3)/3 + (b*d^2*(2*c*d + 3*b*e)*x^4)/4 + (d*(c^2*d^2 + 6*b*c*d*e + 3*b^2*e^2)*x^5)/5 + (e*(3*c^2*d^2 + 6*b*c*d*e + b^2*e^2)*x^6)/6 + (c*e^2*(3*c*d + 2*b*e)*x^7)/7 + (c^2*e^3*x^8)/8", //
        712);
  }

  // {712}
  public void test3590() {
    check( //
        "Integrate[(d + e*x)^2*(b*x + c*x^2)^2, x]", //
        "(b^2*d^2*x^3)/3 + (b*d*(c*d + b*e)*x^4)/2 + ((c^2*d^2 + 4*b*c*d*e + b^2*e^2)*x^5)/5 + (c*e*(c*d + b*e)*x^6)/3 + (c^2*e^2*x^7)/7", //
        712);
  }

  // {645}
  public void test3591() {
    check( //
        "Integrate[(d + e*x)*(b*x + c*x^2)^2, x]", //
        "(b^2*d*x^3)/3 + (b*(2*c*d + b*e)*x^4)/4 + (c*(c*d + 2*b*e)*x^5)/5 + (c^2*e*x^6)/6", //
        645);
  }

  // {625}
  public void test3592() {
    check( //
        "Integrate[(b*x + c*x^2)^2, x]", //
        "(b^2*x^3)/3 + (b*c*x^4)/2 + (c^2*x^5)/5", //
        625);
  }

  // {712}
  public void test3593() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x), x]", //
        "-((d*(c*d - b*e)^2*x)/e^4) + ((c*d - b*e)^2*x^2)/(2*e^3) - (c*(c*d - 2*b*e)*x^3)/(3*e^2) + (c^2*x^4)/(4*e) + (d^2*(c*d - b*e)^2*Log[d + e*x])/e^5", //
        712);
  }

  // {712}
  public void test3594() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^2, x]", //
        "((c*d - b*e)*(3*c*d - b*e)*x)/e^4 - (c*(c*d - b*e)*x^2)/e^3 + (c^2*x^3)/(3*e^2) - (d^2*(c*d - b*e)^2)/(e^5*(d + e*x)) - (2*d*(c*d - b*e)*(2*c*d - b*e)*Log[d + e*x])/e^5", //
        712);
  }

  // {712}
  public void test3595() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^3, x]", //
        "-((c*(3*c*d - 2*b*e)*x)/e^4) + (c^2*x^2)/(2*e^3) - (d^2*(c*d - b*e)^2)/(2*e^5*(d + e*x)^2) + (2*d*(c*d - b*e)*(2*c*d - b*e))/(e^5*(d + e*x)) + ((6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*Log[d + e*x])/e^5", //
        712);
  }

  // {712}
  public void test3596() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^4, x]", //
        "(c^2*x)/e^4 - (d^2*(c*d - b*e)^2)/(3*e^5*(d + e*x)^3) + (d*(c*d - b*e)*(2*c*d - b*e))/(e^5*(d + e*x)^2) - (6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)/(e^5*(d + e*x)) - (2*c*(2*c*d - b*e)*Log[d + e*x])/e^5", //
        712);
  }

  // {712}
  public void test3597() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^5, x]", //
        "-(d^2*(c*d - b*e)^2)/(4*e^5*(d + e*x)^4) + (2*d*(c*d - b*e)*(2*c*d - b*e))/(3*e^5*(d + e*x)^3) - (6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)/(2*e^5*(d + e*x)^2) + (2*c*(2*c*d - b*e))/(e^5*(d + e*x)) + (c^2*Log[d + e*x])/e^5", //
        712);
  }

  // {712}
  public void test3598() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^6, x]", //
        "-(d^2*(c*d - b*e)^2)/(5*e^5*(d + e*x)^5) + (d*(c*d - b*e)*(2*c*d - b*e))/(2*e^5*(d + e*x)^4) - (6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)/(3*e^5*(d + e*x)^3) + (c*(2*c*d - b*e))/(e^5*(d + e*x)^2) - c^2/(e^5*(d + e*x))", //
        712);
  }

  // {712}
  public void test3599() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^7, x]", //
        "-(d^2*(c*d - b*e)^2)/(6*e^5*(d + e*x)^6) + (2*d*(c*d - b*e)*(2*c*d - b*e))/(5*e^5*(d + e*x)^5) - (6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)/(4*e^5*(d + e*x)^4) + (2*c*(2*c*d - b*e))/(3*e^5*(d + e*x)^3) - c^2/(2*e^5*(d + e*x)^2)", //
        712);
  }

  // {712}
  public void test3600() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^8, x]", //
        "-(d^2*(c*d - b*e)^2)/(7*e^5*(d + e*x)^7) + (d*(c*d - b*e)*(2*c*d - b*e))/(3*e^5*(d + e*x)^6) - (6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)/(5*e^5*(d + e*x)^5) + (c*(2*c*d - b*e))/(2*e^5*(d + e*x)^4) - c^2/(3*e^5*(d + e*x)^3)", //
        712);
  }

  // {712}
  public void test3601() {
    check( //
        "Integrate[(d + e*x)^4*(b*x + c*x^2)^3, x]", //
        "(b^3*d^4*x^4)/4 + (b^2*d^3*(3*c*d + 4*b*e)*x^5)/5 + (b*d^2*(c^2*d^2 + 4*b*c*d*e + 2*b^2*e^2)*x^6)/2 + (d*(c^3*d^3 + 12*b*c^2*d^2*e + 18*b^2*c*d*e^2 + 4*b^3*e^3)*x^7)/7 + (e*(4*c^3*d^3 + 18*b*c^2*d^2*e + 12*b^2*c*d*e^2 + b^3*e^3)*x^8)/8 + (c*e^2*(2*c^2*d^2 + 4*b*c*d*e + b^2*e^2)*x^9)/3 + (c^2*e^3*(4*c*d + 3*b*e)*x^10)/10 + (c^3*e^4*x^11)/11", //
        712);
  }

  // {712}
  public void test3602() {
    check( //
        "Integrate[(d + e*x)^3*(b*x + c*x^2)^3, x]", //
        "(b^3*d^3*x^4)/4 + (3*b^2*d^2*(c*d + b*e)*x^5)/5 + (b*d*(c^2*d^2 + 3*b*c*d*e + b^2*e^2)*x^6)/2 + ((c*d + b*e)*(c^2*d^2 + 8*b*c*d*e + b^2*e^2)*x^7)/7 + (3*c*e*(c^2*d^2 + 3*b*c*d*e + b^2*e^2)*x^8)/8 + (c^2*e^2*(c*d + b*e)*x^9)/3 + (c^3*e^3*x^10)/10", //
        712);
  }

  // {712}
  public void test3603() {
    check( //
        "Integrate[(d + e*x)^2*(b*x + c*x^2)^3, x]", //
        "(b^3*d^2*x^4)/4 + (b^2*d*(3*c*d + 2*b*e)*x^5)/5 + (b*(3*c^2*d^2 + 6*b*c*d*e + b^2*e^2)*x^6)/6 + (c*(c^2*d^2 + 6*b*c*d*e + 3*b^2*e^2)*x^7)/7 + (c^2*e*(2*c*d + 3*b*e)*x^8)/8 + (c^3*e^2*x^9)/9", //
        712);
  }

  // {645}
  public void test3604() {
    check( //
        "Integrate[(d + e*x)*(b*x + c*x^2)^3, x]", //
        "(b^3*d*x^4)/4 + (b^2*(3*c*d + b*e)*x^5)/5 + (b*c*(c*d + b*e)*x^6)/2 + (c^2*(c*d + 3*b*e)*x^7)/7 + (c^3*e*x^8)/8", //
        645);
  }

  // {625}
  public void test3605() {
    check( //
        "Integrate[(b*x + c*x^2)^3, x]", //
        "(b^3*x^4)/4 + (3*b^2*c*x^5)/5 + (b*c^2*x^6)/2 + (c^3*x^7)/7", //
        625);
  }

  // {712}
  public void test3606() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x), x]", //
        "-((d^2*(c*d - b*e)^3*x)/e^6) + (d*(c*d - b*e)^3*x^2)/(2*e^5) - ((c*d - b*e)^3*x^3)/(3*e^4) + (c*(c^2*d^2 - 3*b*c*d*e + 3*b^2*e^2)*x^4)/(4*e^3) - (c^2*(c*d - 3*b*e)*x^5)/(5*e^2) + (c^3*x^6)/(6*e) + (d^3*(c*d - b*e)^3*Log[d + e*x])/e^7", //
        712);
  }

  // {712}
  public void test3607() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^2, x]", //
        "(d*(5*c*d - 2*b*e)*(c*d - b*e)^2*x)/e^6 - ((c*d - b*e)^2*(4*c*d - b*e)*x^2)/(2*e^5) + (c*(c*d - b*e)^2*x^3)/e^4 - (c^2*(2*c*d - 3*b*e)*x^4)/(4*e^3) + (c^3*x^5)/(5*e^2) - (d^3*(c*d - b*e)^3)/(e^7*(d + e*x)) - (3*d^2*(c*d - b*e)^2*(2*c*d - b*e)*Log[d + e*x])/e^7", //
        712);
  }

  // {712}
  public void test3608() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^3, x]", //
        "-(((c*d - b*e)*(10*c^2*d^2 - 8*b*c*d*e + b^2*e^2)*x)/e^6) + (3*c*(c*d - b*e)*(2*c*d - b*e)*x^2)/(2*e^5) - (c^2*(c*d - b*e)*x^3)/e^4 + (c^3*x^4)/(4*e^3) - (d^3*(c*d - b*e)^3)/(2*e^7*(d + e*x)^2) + (3*d^2*(c*d - b*e)^2*(2*c*d - b*e))/(e^7*(d + e*x)) + (3*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*Log[d + e*x])/e^7", //
        712);
  }

  // {712}
  public void test3609() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^4, x]", //
        "(c*(10*c^2*d^2 - 12*b*c*d*e + 3*b^2*e^2)*x)/e^6 - (c^2*(4*c*d - 3*b*e)*x^2)/(2*e^5) + (c^3*x^3)/(3*e^4) - (d^3*(c*d - b*e)^3)/(3*e^7*(d + e*x)^3) + (3*d^2*(c*d - b*e)^2*(2*c*d - b*e))/(2*e^7*(d + e*x)^2) - (3*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(e^7*(d + e*x)) - ((2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*Log[d + e*x])/e^7", //
        712);
  }

  // {712}
  public void test3610() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^5, x]", //
        "-((c^2*(5*c*d - 3*b*e)*x)/e^6) + (c^3*x^2)/(2*e^5) - (d^3*(c*d - b*e)^3)/(4*e^7*(d + e*x)^4) + (d^2*(c*d - b*e)^2*(2*c*d - b*e))/(e^7*(d + e*x)^3) - (3*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(2*e^7*(d + e*x)^2) + ((2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2))/(e^7*(d + e*x)) + (3*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*Log[d + e*x])/e^7", //
        712);
  }

  // {712}
  public void test3611() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^6, x]", //
        "(c^3*x)/e^6 - (d^3*(c*d - b*e)^3)/(5*e^7*(d + e*x)^5) + (3*d^2*(c*d - b*e)^2*(2*c*d - b*e))/(4*e^7*(d + e*x)^4) - (d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(e^7*(d + e*x)^3) + ((2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2))/(2*e^7*(d + e*x)^2) - (3*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(e^7*(d + e*x)) - (3*c^2*(2*c*d - b*e)*Log[d + e*x])/e^7", //
        712);
  }

  // {712}
  public void test3612() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^7, x]", //
        "-(d^3*(c*d - b*e)^3)/(6*e^7*(d + e*x)^6) + (3*d^2*(c*d - b*e)^2*(2*c*d - b*e))/(5*e^7*(d + e*x)^5) - (3*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(4*e^7*(d + e*x)^4) + ((2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2))/(3*e^7*(d + e*x)^3) - (3*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(2*e^7*(d + e*x)^2) + (3*c^2*(2*c*d - b*e))/(e^7*(d + e*x)) + (c^3*Log[d + e*x])/e^7", //
        712);
  }

  // {712}
  public void test3613() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^8, x]", //
        "-(d^3*(c*d - b*e)^3)/(7*e^7*(d + e*x)^7) + (d^2*(c*d - b*e)^2*(2*c*d - b*e))/(2*e^7*(d + e*x)^6) - (3*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(5*e^7*(d + e*x)^5) + ((2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2))/(4*e^7*(d + e*x)^4) - (c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(e^7*(d + e*x)^3) + (3*c^2*(2*c*d - b*e))/(2*e^7*(d + e*x)^2) - c^3/(e^7*(d + e*x))", //
        712);
  }

  // {712}
  public void test3614() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^9, x]", //
        "-(d^3*(c*d - b*e)^3)/(8*e^7*(d + e*x)^8) + (3*d^2*(c*d - b*e)^2*(2*c*d - b*e))/(7*e^7*(d + e*x)^7) - (d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(2*e^7*(d + e*x)^6) + ((2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2))/(5*e^7*(d + e*x)^5) - (3*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(4*e^7*(d + e*x)^4) + (c^2*(2*c*d - b*e))/(e^7*(d + e*x)^3) - c^3/(2*e^7*(d + e*x)^2)", //
        712);
  }

  // {712}
  public void test3615() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^10, x]", //
        "-(d^3*(c*d - b*e)^3)/(9*e^7*(d + e*x)^9) + (3*d^2*(c*d - b*e)^2*(2*c*d - b*e))/(8*e^7*(d + e*x)^8) - (3*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(7*e^7*(d + e*x)^7) + ((2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2))/(6*e^7*(d + e*x)^6) - (3*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(5*e^7*(d + e*x)^5) + (3*c^2*(2*c*d - b*e))/(4*e^7*(d + e*x)^4) - c^3/(3*e^7*(d + e*x)^3)", //
        712);
  }

  // {712}
  public void test3616() {
    check( //
        "Integrate[(d + e*x)^4/(b*x + c*x^2), x]", //
        "(e^2*(6*c^2*d^2 - 4*b*c*d*e + b^2*e^2)*x)/c^3 + (e^3*(4*c*d - b*e)*x^2)/(2*c^2) + (e^4*x^3)/(3*c) + (d^4*Log[x])/b - ((c*d - b*e)^4*Log[b + c*x])/(b*c^4)", //
        712);
  }

  // {712}
  public void test3617() {
    check( //
        "Integrate[(d + e*x)^3/(b*x + c*x^2), x]", //
        "(e^2*(3*c*d - b*e)*x)/c^2 + (e^3*x^2)/(2*c) + (d^3*Log[x])/b - ((c*d - b*e)^3*Log[b + c*x])/(b*c^3)", //
        712);
  }

  // {712}
  public void test3618() {
    check( //
        "Integrate[(d + e*x)^2/(b*x + c*x^2), x]", //
        "(e^2*x)/c + (d^2*Log[x])/b - ((c*d - b*e)^2*Log[b + c*x])/(b*c^2)", //
        712);
  }

  // {645}
  public void test3619() {
    check( //
        "Integrate[(d + e*x)/(b*x + c*x^2), x]", //
        "(d*Log[x])/b - ((c*d - b*e)*Log[b + c*x])/(b*c)", //
        645);
  }

  // {712}
  public void test3620() {
    check( //
        "Integrate[1/((d + e*x)*(b*x + c*x^2)), x]", //
        "Log[x]/(b*d) - (c*Log[b + c*x])/(b*(c*d - b*e)) + (e*Log[d + e*x])/(d*(c*d - b*e))", //
        712);
  }

  // {712}
  public void test3621() {
    check( //
        "Integrate[1/((d + e*x)^2*(b*x + c*x^2)), x]", //
        "-(e/(d*(c*d - b*e)*(d + e*x))) + Log[x]/(b*d^2) - (c^2*Log[b + c*x])/(b*(c*d - b*e)^2) + (e*(2*c*d - b*e)*Log[d + e*x])/(d^2*(c*d - b*e)^2)", //
        712);
  }

  // {712}
  public void test3622() {
    check( //
        "Integrate[1/((d + e*x)^3*(b*x + c*x^2)), x]", //
        "-e/(2*d*(c*d - b*e)*(d + e*x)^2) - (e*(2*c*d - b*e))/(d^2*(c*d - b*e)^2*(d + e*x)) + Log[x]/(b*d^3) - (c^3*Log[b + c*x])/(b*(c*d - b*e)^3) + (e*(3*c^2*d^2 - 3*b*c*d*e + b^2*e^2)*Log[d + e*x])/(d^3*(c*d - b*e)^3)", //
        712);
  }

  // {712}
  public void test3623() {
    check( //
        "Integrate[(d + e*x)^5/(b*x + c*x^2)^2, x]", //
        "-(d^5/(b^2*x)) + (e^4*(5*c*d - 2*b*e)*x)/c^3 + (e^5*x^2)/(2*c^2) - (c*d - b*e)^5/(b^2*c^4*(b + c*x)) - (d^4*(2*c*d - 5*b*e)*Log[x])/b^3 + ((c*d - b*e)^4*(2*c*d + 3*b*e)*Log[b + c*x])/(b^3*c^4)", //
        712);
  }

  // {712}
  public void test3624() {
    check( //
        "Integrate[(d + e*x)^4/(b*x + c*x^2)^2, x]", //
        "-(d^4/(b^2*x)) + (e^4*x)/c^2 - (c*d - b*e)^4/(b^2*c^3*(b + c*x)) - (2*d^3*(c*d - 2*b*e)*Log[x])/b^3 + (2*(c*d - b*e)^3*(c*d + b*e)*Log[b + c*x])/(b^3*c^3)", //
        712);
  }

  // {712}
  public void test3625() {
    check( //
        "Integrate[(d + e*x)^3/(b*x + c*x^2)^2, x]", //
        "-(d^3/(b^2*x)) - (c*d - b*e)^3/(b^2*c^2*(b + c*x)) - (d^2*(2*c*d - 3*b*e)*Log[x])/b^3 + ((c*d - b*e)^2*(2*c*d + b*e)*Log[b + c*x])/(b^3*c^2)", //
        712);
  }

  // {712}
  public void test3626() {
    check( //
        "Integrate[(d + e*x)^2/(b*x + c*x^2)^2, x]", //
        "-(d^2/(b^2*x)) - (c*d - b*e)^2/(b^2*c*(b + c*x)) - (2*d*(c*d - b*e)*Log[x])/b^3 + (2*d*(c*d - b*e)*Log[b + c*x])/b^3", //
        712);
  }

  // {645}
  public void test3627() {
    check( //
        "Integrate[(d + e*x)/(b*x + c*x^2)^2, x]", //
        "-(d/(b^2*x)) - (c*d - b*e)/(b^2*(b + c*x)) - ((2*c*d - b*e)*Log[x])/b^3 + ((2*c*d - b*e)*Log[b + c*x])/b^3", //
        645);
  }

  // {628, 629}
  public void test3628() {
    check( //
        "Integrate[(b*x + c*x^2)^(-2), x]", //
        "-((b + 2*c*x)/(b^2*(b*x + c*x^2))) - (2*c*Log[x])/b^3 + (2*c*Log[b + c*x])/b^3", //
        628,
        629);
  }

  // {712}
  public void test3629() {
    check( //
        "Integrate[1/((d + e*x)*(b*x + c*x^2)^2), x]", //
        "-(1/(b^2*d*x)) - c^2/(b^2*(c*d - b*e)*(b + c*x)) - ((2*c*d + b*e)*Log[x])/(b^3*d^2) + (c^2*(2*c*d - 3*b*e)*Log[b + c*x])/(b^3*(c*d - b*e)^2) + (e^3*Log[d + e*x])/(d^2*(c*d - b*e)^2)", //
        712);
  }

  // {712}
  public void test3630() {
    check( //
        "Integrate[1/((d + e*x)^2*(b*x + c*x^2)^2), x]", //
        "-(1/(b^2*d^2*x)) - c^3/(b^2*(c*d - b*e)^2*(b + c*x)) - e^3/(d^2*(c*d - b*e)^2*(d + e*x)) - (2*(c*d + b*e)*Log[x])/(b^3*d^3) + (2*c^3*(c*d - 2*b*e)*Log[b + c*x])/(b^3*(c*d - b*e)^3) + (2*e^3*(2*c*d - b*e)*Log[d + e*x])/(d^3*(c*d - b*e)^3)", //
        712);
  }

  // {712}
  public void test3631() {
    check( //
        "Integrate[(d + e*x)^7/(b*x + c*x^2)^3, x]", //
        "-d^7/(2*b^3*x^2) + (d^6*(3*c*d - 7*b*e))/(b^4*x) + (e^6*(7*c*d - 3*b*e)*x)/c^4 + (e^7*x^2)/(2*c^3) + (c*d - b*e)^7/(2*b^3*c^5*(b + c*x)^2) + ((c*d - b*e)^6*(3*c*d + 4*b*e))/(b^4*c^5*(b + c*x)) + (3*d^5*(2*c^2*d^2 - 7*b*c*d*e + 7*b^2*e^2)*Log[x])/b^5 - (3*(c*d - b*e)^5*(2*c^2*d^2 + 3*b*c*d*e + 2*b^2*e^2)*Log[b + c*x])/(b^5*c^5)", //
        712);
  }

  // {712}
  public void test3632() {
    check( //
        "Integrate[(d + e*x)^6/(b*x + c*x^2)^3, x]", //
        "-d^6/(2*b^3*x^2) + (3*d^5*(c*d - 2*b*e))/(b^4*x) + (e^6*x)/c^3 + (c*d - b*e)^6/(2*b^3*c^4*(b + c*x)^2) + (3*(c*d - b*e)^5*(c*d + b*e))/(b^4*c^4*(b + c*x)) + (3*d^4*(2*c^2*d^2 - 6*b*c*d*e + 5*b^2*e^2)*Log[x])/b^5 - (3*(c*d - b*e)^4*(2*c^2*d^2 + 2*b*c*d*e + b^2*e^2)*Log[b + c*x])/(b^5*c^4)", //
        712);
  }

  // {712}
  public void test3633() {
    check( //
        "Integrate[(d + e*x)^5/(b*x + c*x^2)^3, x]", //
        "-d^5/(2*b^3*x^2) + (d^4*(3*c*d - 5*b*e))/(b^4*x) + (c*d - b*e)^5/(2*b^3*c^3*(b + c*x)^2) + ((c*d - b*e)^4*(3*c*d + 2*b*e))/(b^4*c^3*(b + c*x)) + (d^3*(6*c^2*d^2 - 15*b*c*d*e + 10*b^2*e^2)*Log[x])/b^5 - ((c*d - b*e)^3*(6*c^2*d^2 + 3*b*c*d*e + b^2*e^2)*Log[b + c*x])/(b^5*c^3)", //
        712);
  }

  // {712}
  public void test3634() {
    check( //
        "Integrate[(d + e*x)^4/(b*x + c*x^2)^3, x]", //
        "-d^4/(2*b^3*x^2) + (d^3*(3*c*d - 4*b*e))/(b^4*x) + (c*d - b*e)^4/(2*b^3*c^2*(b + c*x)^2) + ((c*d - b*e)^3*(3*c*d + b*e))/(b^4*c^2*(b + c*x)) + (6*d^2*(c*d - b*e)^2*Log[x])/b^5 - (6*d^2*(c*d - b*e)^2*Log[b + c*x])/b^5", //
        712);
  }

  // {712}
  public void test3635() {
    check( //
        "Integrate[(d + e*x)^3/(b*x + c*x^2)^3, x]", //
        "-d^3/(2*b^3*x^2) + (3*d^2*(c*d - b*e))/(b^4*x) + (c*d - b*e)^3/(2*b^3*c*(b + c*x)^2) + (3*d*(c*d - b*e)^2)/(b^4*(b + c*x)) + (3*d*(c*d - b*e)*(2*c*d - b*e)*Log[x])/b^5 - (3*d*(c*d - b*e)*(2*c*d - b*e)*Log[b + c*x])/b^5", //
        712);
  }

  // {712}
  public void test3636() {
    check( //
        "Integrate[(d + e*x)^2/(b*x + c*x^2)^3, x]", //
        "-d^2/(2*b^3*x^2) + (d*(3*c*d - 2*b*e))/(b^4*x) + (c*d - b*e)^2/(2*b^3*(b + c*x)^2) + ((c*d - b*e)*(3*c*d - b*e))/(b^4*(b + c*x)) + ((6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*Log[x])/b^5 - ((6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*Log[b + c*x])/b^5", //
        712);
  }

  // {645}
  public void test3637() {
    check( //
        "Integrate[(d + e*x)/(b*x + c*x^2)^3, x]", //
        "-d/(2*b^3*x^2) + (3*c*d - b*e)/(b^4*x) + (c*(c*d - b*e))/(2*b^3*(b + c*x)^2) + (c*(3*c*d - 2*b*e))/(b^4*(b + c*x)) + (3*c*(2*c*d - b*e)*Log[x])/b^5 - (3*c*(2*c*d - b*e)*Log[b + c*x])/b^5", //
        645);
  }

  // {712}
  public void test3638() {
    check( //
        "Integrate[1/((d + e*x)*(b*x + c*x^2)^3), x]", //
        "-1/(2*b^3*d*x^2) + (3*c*d + b*e)/(b^4*d^2*x) + c^3/(2*b^3*(c*d - b*e)*(b + c*x)^2) + (c^3*(3*c*d - 4*b*e))/(b^4*(c*d - b*e)^2*(b + c*x)) + ((6*c^2*d^2 + 3*b*c*d*e + b^2*e^2)*Log[x])/(b^5*d^3) - (c^3*(6*c^2*d^2 - 15*b*c*d*e + 10*b^2*e^2)*Log[b + c*x])/(b^5*(c*d - b*e)^3) + (e^5*Log[d + e*x])/(d^3*(c*d - b*e)^3)", //
        712);
  }

  // {712}
  public void test3639() {
    check( //
        "Integrate[1/((d + e*x)^2*(b*x + c*x^2)^3), x]", //
        "-1/(2*b^3*d^2*x^2) + (3*c*d + 2*b*e)/(b^4*d^3*x) + c^4/(2*b^3*(c*d - b*e)^2*(b + c*x)^2) + (c^4*(3*c*d - 5*b*e))/(b^4*(c*d - b*e)^3*(b + c*x)) - e^5/(d^3*(c*d - b*e)^3*(d + e*x)) + (3*(2*c^2*d^2 + 2*b*c*d*e + b^2*e^2)*Log[x])/(b^5*d^4) - (3*c^4*(2*c^2*d^2 - 6*b*c*d*e + 5*b^2*e^2)*Log[b + c*x])/(b^5*(c*d - b*e)^4) + (3*e^5*(2*c*d - b*e)*Log[d + e*x])/(d^4*(c*d - b*e)^4)", //
        712);
  }

  // {702, 213}
  public void test3640() {
    check( //
        "Integrate[1/((2 - 2*x)*Sqrt[2*x - x^2]), x]", //
        "ArcTanh[Sqrt[2*x - x^2]]/2", //
        702,
        213);
  }

  // {634, 212}
  public void test3641() {
    check( //
        "Integrate[1/Sqrt[b*x + c*x^2], x]", //
        "(2*ArcTanh[(Sqrt[c]*x)/Sqrt[b*x + c*x^2]])/Sqrt[c]", //
        634,
        212);
  }

  // {738, 212}
  public void test3642() {
    check( //
        "Integrate[1/((d + e*x)*Sqrt[b*x + c*x^2]), x]", //
        "ArcTanh[(b*d + (2*c*d - b*e)*x)/(2*Sqrt[d]*Sqrt[c*d - b*e]*Sqrt[b*x + c*x^2])]/(Sqrt[d]*Sqrt[c*d - b*e])", //
        738,
        212);
  }

  // {736, 650}
  public void test3643() {
    check( //
        "Integrate[(d + e*x)^3/(b*x + c*x^2)^(5/2), x]", //
        "(-2*(d + e*x)^2*(b*d + (2*c*d - b*e)*x))/(3*b^2*(b*x + c*x^2)^(3/2)) + (16*d*(c*d - b*e)*(b*d + (2*c*d - b*e)*x))/(3*b^4*Sqrt[b*x + c*x^2])", //
        736,
        650);
  }

  // {742, 650}
  public void test3644() {
    check( //
        "Integrate[(d + e*x)^2/(b*x + c*x^2)^(5/2), x]", //
        "(-2*(b + 2*c*x)*(d + e*x)^2)/(3*b^2*(b*x + c*x^2)^(3/2)) + (8*(2*c*d - b*e)*(b*d + (2*c*d - b*e)*x))/(3*b^4*Sqrt[b*x + c*x^2])", //
        742,
        650);
  }

  // {652, 627}
  public void test3645() {
    check( //
        "Integrate[(d + e*x)/(b*x + c*x^2)^(5/2), x]", //
        "(-2*(b*d + (2*c*d - b*e)*x))/(3*b^2*(b*x + c*x^2)^(3/2)) + (8*(2*c*d - b*e)*(b + 2*c*x))/(3*b^4*Sqrt[b*x + c*x^2])", //
        652,
        627);
  }

  // {628, 627}
  public void test3646() {
    check( //
        "Integrate[(b*x + c*x^2)^(-5/2), x]", //
        "(-2*(b + 2*c*x))/(3*b^2*(b*x + c*x^2)^(3/2)) + (16*c*(b + 2*c*x))/(3*b^4*Sqrt[b*x + c*x^2])", //
        628,
        627);
  }

  // {712}
  public void test3647() {
    check( //
        "Integrate[(d + e*x)^(7/2)*(b*x + c*x^2), x]", //
        "(2*d*(c*d - b*e)*(d + e*x)^(9/2))/(9*e^3) - (2*(2*c*d - b*e)*(d + e*x)^(11/2))/(11*e^3) + (2*c*(d + e*x)^(13/2))/(13*e^3)", //
        712);
  }

  // {712}
  public void test3648() {
    check( //
        "Integrate[(d + e*x)^(5/2)*(b*x + c*x^2), x]", //
        "(2*d*(c*d - b*e)*(d + e*x)^(7/2))/(7*e^3) - (2*(2*c*d - b*e)*(d + e*x)^(9/2))/(9*e^3) + (2*c*(d + e*x)^(11/2))/(11*e^3)", //
        712);
  }

  // {712}
  public void test3649() {
    check( //
        "Integrate[(d + e*x)^(3/2)*(b*x + c*x^2), x]", //
        "(2*d*(c*d - b*e)*(d + e*x)^(5/2))/(5*e^3) - (2*(2*c*d - b*e)*(d + e*x)^(7/2))/(7*e^3) + (2*c*(d + e*x)^(9/2))/(9*e^3)", //
        712);
  }

  // {712}
  public void test3650() {
    check( //
        "Integrate[Sqrt[d + e*x]*(b*x + c*x^2), x]", //
        "(2*d*(c*d - b*e)*(d + e*x)^(3/2))/(3*e^3) - (2*(2*c*d - b*e)*(d + e*x)^(5/2))/(5*e^3) + (2*c*(d + e*x)^(7/2))/(7*e^3)", //
        712);
  }

  // {712}
  public void test3651() {
    check( //
        "Integrate[(b*x + c*x^2)/Sqrt[d + e*x], x]", //
        "(2*d*(c*d - b*e)*Sqrt[d + e*x])/e^3 - (2*(2*c*d - b*e)*(d + e*x)^(3/2))/(3*e^3) + (2*c*(d + e*x)^(5/2))/(5*e^3)", //
        712);
  }

  // {712}
  public void test3652() {
    check( //
        "Integrate[(b*x + c*x^2)/(d + e*x)^(3/2), x]", //
        "(-2*d*(c*d - b*e))/(e^3*Sqrt[d + e*x]) - (2*(2*c*d - b*e)*Sqrt[d + e*x])/e^3 + (2*c*(d + e*x)^(3/2))/(3*e^3)", //
        712);
  }

  // {712}
  public void test3653() {
    check( //
        "Integrate[(b*x + c*x^2)/(d + e*x)^(5/2), x]", //
        "(-2*d*(c*d - b*e))/(3*e^3*(d + e*x)^(3/2)) + (2*(2*c*d - b*e))/(e^3*Sqrt[d + e*x]) + (2*c*Sqrt[d + e*x])/e^3", //
        712);
  }

  // {712}
  public void test3654() {
    check( //
        "Integrate[(b*x + c*x^2)/(d + e*x)^(7/2), x]", //
        "(-2*d*(c*d - b*e))/(5*e^3*(d + e*x)^(5/2)) + (2*(2*c*d - b*e))/(3*e^3*(d + e*x)^(3/2)) - (2*c)/(e^3*Sqrt[d + e*x])", //
        712);
  }

  // {712}
  public void test3655() {
    check( //
        "Integrate[(d + e*x)^(7/2)*(b*x + c*x^2)^2, x]", //
        "(2*d^2*(c*d - b*e)^2*(d + e*x)^(9/2))/(9*e^5) - (4*d*(c*d - b*e)*(2*c*d - b*e)*(d + e*x)^(11/2))/(11*e^5) + (2*(6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*(d + e*x)^(13/2))/(13*e^5) - (4*c*(2*c*d - b*e)*(d + e*x)^(15/2))/(15*e^5) + (2*c^2*(d + e*x)^(17/2))/(17*e^5)", //
        712);
  }

  // {712}
  public void test3656() {
    check( //
        "Integrate[(d + e*x)^(5/2)*(b*x + c*x^2)^2, x]", //
        "(2*d^2*(c*d - b*e)^2*(d + e*x)^(7/2))/(7*e^5) - (4*d*(c*d - b*e)*(2*c*d - b*e)*(d + e*x)^(9/2))/(9*e^5) + (2*(6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*(d + e*x)^(11/2))/(11*e^5) - (4*c*(2*c*d - b*e)*(d + e*x)^(13/2))/(13*e^5) + (2*c^2*(d + e*x)^(15/2))/(15*e^5)", //
        712);
  }

  // {712}
  public void test3657() {
    check( //
        "Integrate[(d + e*x)^(3/2)*(b*x + c*x^2)^2, x]", //
        "(2*d^2*(c*d - b*e)^2*(d + e*x)^(5/2))/(5*e^5) - (4*d*(c*d - b*e)*(2*c*d - b*e)*(d + e*x)^(7/2))/(7*e^5) + (2*(6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*(d + e*x)^(9/2))/(9*e^5) - (4*c*(2*c*d - b*e)*(d + e*x)^(11/2))/(11*e^5) + (2*c^2*(d + e*x)^(13/2))/(13*e^5)", //
        712);
  }

  // {712}
  public void test3658() {
    check( //
        "Integrate[Sqrt[d + e*x]*(b*x + c*x^2)^2, x]", //
        "(2*d^2*(c*d - b*e)^2*(d + e*x)^(3/2))/(3*e^5) - (4*d*(c*d - b*e)*(2*c*d - b*e)*(d + e*x)^(5/2))/(5*e^5) + (2*(6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*(d + e*x)^(7/2))/(7*e^5) - (4*c*(2*c*d - b*e)*(d + e*x)^(9/2))/(9*e^5) + (2*c^2*(d + e*x)^(11/2))/(11*e^5)", //
        712);
  }

  // {712}
  public void test3659() {
    check( //
        "Integrate[(b*x + c*x^2)^2/Sqrt[d + e*x], x]", //
        "(2*d^2*(c*d - b*e)^2*Sqrt[d + e*x])/e^5 - (4*d*(c*d - b*e)*(2*c*d - b*e)*(d + e*x)^(3/2))/(3*e^5) + (2*(6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*(d + e*x)^(5/2))/(5*e^5) - (4*c*(2*c*d - b*e)*(d + e*x)^(7/2))/(7*e^5) + (2*c^2*(d + e*x)^(9/2))/(9*e^5)", //
        712);
  }

  // {712}
  public void test3660() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^(3/2), x]", //
        "(-2*d^2*(c*d - b*e)^2)/(e^5*Sqrt[d + e*x]) - (4*d*(c*d - b*e)*(2*c*d - b*e)*Sqrt[d + e*x])/e^5 + (2*(6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*(d + e*x)^(3/2))/(3*e^5) - (4*c*(2*c*d - b*e)*(d + e*x)^(5/2))/(5*e^5) + (2*c^2*(d + e*x)^(7/2))/(7*e^5)", //
        712);
  }

  // {712}
  public void test3661() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^(5/2), x]", //
        "(-2*d^2*(c*d - b*e)^2)/(3*e^5*(d + e*x)^(3/2)) + (4*d*(c*d - b*e)*(2*c*d - b*e))/(e^5*Sqrt[d + e*x]) + (2*(6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*Sqrt[d + e*x])/e^5 - (4*c*(2*c*d - b*e)*(d + e*x)^(3/2))/(3*e^5) + (2*c^2*(d + e*x)^(5/2))/(5*e^5)", //
        712);
  }

  // {712}
  public void test3662() {
    check( //
        "Integrate[(b*x + c*x^2)^2/(d + e*x)^(7/2), x]", //
        "(-2*d^2*(c*d - b*e)^2)/(5*e^5*(d + e*x)^(5/2)) + (4*d*(c*d - b*e)*(2*c*d - b*e))/(3*e^5*(d + e*x)^(3/2)) - (2*(6*c^2*d^2 - 6*b*c*d*e + b^2*e^2))/(e^5*Sqrt[d + e*x]) - (4*c*(2*c*d - b*e)*Sqrt[d + e*x])/e^5 + (2*c^2*(d + e*x)^(3/2))/(3*e^5)", //
        712);
  }

  // {712}
  public void test3663() {
    check( //
        "Integrate[(d + e*x)^(7/2)*(b*x + c*x^2)^3, x]", //
        "(2*d^3*(c*d - b*e)^3*(d + e*x)^(9/2))/(9*e^7) - (6*d^2*(c*d - b*e)^2*(2*c*d - b*e)*(d + e*x)^(11/2))/(11*e^7) + (6*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(13/2))/(13*e^7) - (2*(2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*(d + e*x)^(15/2))/(15*e^7) + (6*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(17/2))/(17*e^7) - (6*c^2*(2*c*d - b*e)*(d + e*x)^(19/2))/(19*e^7) + (2*c^3*(d + e*x)^(21/2))/(21*e^7)", //
        712);
  }

  // {712}
  public void test3664() {
    check( //
        "Integrate[(d + e*x)^(5/2)*(b*x + c*x^2)^3, x]", //
        "(2*d^3*(c*d - b*e)^3*(d + e*x)^(7/2))/(7*e^7) - (2*d^2*(c*d - b*e)^2*(2*c*d - b*e)*(d + e*x)^(9/2))/(3*e^7) + (6*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(11/2))/(11*e^7) - (2*(2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*(d + e*x)^(13/2))/(13*e^7) + (2*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(15/2))/(5*e^7) - (6*c^2*(2*c*d - b*e)*(d + e*x)^(17/2))/(17*e^7) + (2*c^3*(d + e*x)^(19/2))/(19*e^7)", //
        712);
  }

  // {712}
  public void test3665() {
    check( //
        "Integrate[(d + e*x)^(3/2)*(b*x + c*x^2)^3, x]", //
        "(2*d^3*(c*d - b*e)^3*(d + e*x)^(5/2))/(5*e^7) - (6*d^2*(c*d - b*e)^2*(2*c*d - b*e)*(d + e*x)^(7/2))/(7*e^7) + (2*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(9/2))/(3*e^7) - (2*(2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*(d + e*x)^(11/2))/(11*e^7) + (6*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(13/2))/(13*e^7) - (2*c^2*(2*c*d - b*e)*(d + e*x)^(15/2))/(5*e^7) + (2*c^3*(d + e*x)^(17/2))/(17*e^7)", //
        712);
  }

  // {712}
  public void test3666() {
    check( //
        "Integrate[Sqrt[d + e*x]*(b*x + c*x^2)^3, x]", //
        "(2*d^3*(c*d - b*e)^3*(d + e*x)^(3/2))/(3*e^7) - (6*d^2*(c*d - b*e)^2*(2*c*d - b*e)*(d + e*x)^(5/2))/(5*e^7) + (6*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(7/2))/(7*e^7) - (2*(2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*(d + e*x)^(9/2))/(9*e^7) + (6*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(11/2))/(11*e^7) - (6*c^2*(2*c*d - b*e)*(d + e*x)^(13/2))/(13*e^7) + (2*c^3*(d + e*x)^(15/2))/(15*e^7)", //
        712);
  }

  // {712}
  public void test3667() {
    check( //
        "Integrate[(b*x + c*x^2)^3/Sqrt[d + e*x], x]", //
        "(2*d^3*(c*d - b*e)^3*Sqrt[d + e*x])/e^7 - (2*d^2*(c*d - b*e)^2*(2*c*d - b*e)*(d + e*x)^(3/2))/e^7 + (6*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(5/2))/(5*e^7) - (2*(2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*(d + e*x)^(7/2))/(7*e^7) + (2*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(9/2))/(3*e^7) - (6*c^2*(2*c*d - b*e)*(d + e*x)^(11/2))/(11*e^7) + (2*c^3*(d + e*x)^(13/2))/(13*e^7)", //
        712);
  }

  // {712}
  public void test3668() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^(3/2), x]", //
        "(-2*d^3*(c*d - b*e)^3)/(e^7*Sqrt[d + e*x]) - (6*d^2*(c*d - b*e)^2*(2*c*d - b*e)*Sqrt[d + e*x])/e^7 + (2*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(3/2))/e^7 - (2*(2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*(d + e*x)^(5/2))/(5*e^7) + (6*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(7/2))/(7*e^7) - (2*c^2*(2*c*d - b*e)*(d + e*x)^(9/2))/(3*e^7) + (2*c^3*(d + e*x)^(11/2))/(11*e^7)", //
        712);
  }

  // {712}
  public void test3669() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^(5/2), x]", //
        "(-2*d^3*(c*d - b*e)^3)/(3*e^7*(d + e*x)^(3/2)) + (6*d^2*(c*d - b*e)^2*(2*c*d - b*e))/(e^7*Sqrt[d + e*x]) + (6*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*Sqrt[d + e*x])/e^7 - (2*(2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*(d + e*x)^(3/2))/(3*e^7) + (6*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(5/2))/(5*e^7) - (6*c^2*(2*c*d - b*e)*(d + e*x)^(7/2))/(7*e^7) + (2*c^3*(d + e*x)^(9/2))/(9*e^7)", //
        712);
  }

  // {712}
  public void test3670() {
    check( //
        "Integrate[(b*x + c*x^2)^3/(d + e*x)^(7/2), x]", //
        "(-2*d^3*(c*d - b*e)^3)/(5*e^7*(d + e*x)^(5/2)) + (2*d^2*(c*d - b*e)^2*(2*c*d - b*e))/(e^7*(d + e*x)^(3/2)) - (6*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2))/(e^7*Sqrt[d + e*x]) - (2*(2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*Sqrt[d + e*x])/e^7 + (2*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(3/2))/e^7 - (6*c^2*(2*c*d - b*e)*(d + e*x)^(5/2))/(5*e^7) + (2*c^3*(d + e*x)^(7/2))/(7*e^7)", //
        712);
  }

  // {728, 111}
  public void test3671() {
    check( //
        "Integrate[Sqrt[1 - x]/Sqrt[-x - x^2], x]", //
        "-2*EllipticE[ArcSin[Sqrt[-x]], -1]", //
        728,
        111);
  }

  // {712}
  public void test3672() {
    check( //
        "Integrate[(d + e*x)^m*(b*x + c*x^2)^3, x]", //
        "(d^3*(c*d - b*e)^3*(d + e*x)^(1 + m))/(e^7*(1 + m)) - (3*d^2*(c*d - b*e)^2*(2*c*d - b*e)*(d + e*x)^(2 + m))/(e^7*(2 + m)) + (3*d*(c*d - b*e)*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(3 + m))/(e^7*(3 + m)) - ((2*c*d - b*e)*(10*c^2*d^2 - 10*b*c*d*e + b^2*e^2)*(d + e*x)^(4 + m))/(e^7*(4 + m)) + (3*c*(5*c^2*d^2 - 5*b*c*d*e + b^2*e^2)*(d + e*x)^(5 + m))/(e^7*(5 + m)) - (3*c^2*(2*c*d - b*e)*(d + e*x)^(6 + m))/(e^7*(6 + m)) + (c^3*(d + e*x)^(7 + m))/(e^7*(7 + m))", //
        712);
  }

  // {712}
  public void test3673() {
    check( //
        "Integrate[(d + e*x)^m*(b*x + c*x^2)^2, x]", //
        "(d^2*(c*d - b*e)^2*(d + e*x)^(1 + m))/(e^5*(1 + m)) - (2*d*(c*d - b*e)*(2*c*d - b*e)*(d + e*x)^(2 + m))/(e^5*(2 + m)) + ((6*c^2*d^2 - 6*b*c*d*e + b^2*e^2)*(d + e*x)^(3 + m))/(e^5*(3 + m)) - (2*c*(2*c*d - b*e)*(d + e*x)^(4 + m))/(e^5*(4 + m)) + (c^2*(d + e*x)^(5 + m))/(e^5*(5 + m))", //
        712);
  }

  // {712}
  public void test3674() {
    check( //
        "Integrate[(d + e*x)^m*(b*x + c*x^2), x]", //
        "(d*(c*d - b*e)*(d + e*x)^(1 + m))/(e^3*(1 + m)) - ((2*c*d - b*e)*(d + e*x)^(2 + m))/(e^3*(2 + m)) + (c*(d + e*x)^(3 + m))/(e^3*(3 + m))", //
        712);
  }

  // {773, 138}
  public void test3675() {
    check( //
        "Integrate[(d + e*x)^m*(b*x + c*x^2)^(3/2), x]", //
        "((d + e*x)^(1 + m)*(b*x + c*x^2)^(3/2)*AppellF1[1 + m, -3/2, -3/2, 2 + m, (d + e*x)/d, (c*(d + e*x))/(c*d - b*e)])/(e*(1 + m)*(-((e*x)/d))^(3/2)*(1 - (c*(d + e*x))/(c*d - b*e))^(3/2))", //
        773,
        138);
  }

  // {773, 138}
  public void test3676() {
    check( //
        "Integrate[(d + e*x)^m*Sqrt[b*x + c*x^2], x]", //
        "((d + e*x)^(1 + m)*Sqrt[b*x + c*x^2]*AppellF1[1 + m, -1/2, -1/2, 2 + m, (d + e*x)/d, (c*(d + e*x))/(c*d - b*e)])/(e*(1 + m)*Sqrt[-((e*x)/d)]*Sqrt[1 - (c*(d + e*x))/(c*d - b*e)])", //
        773,
        138);
  }

  // {773, 138}
  public void test3677() {
    check( //
        "Integrate[(d + e*x)^m/Sqrt[b*x + c*x^2], x]", //
        "(Sqrt[-((e*x)/d)]*(d + e*x)^(1 + m)*Sqrt[1 - (c*(d + e*x))/(c*d - 