/*
 * java-math-library is a Java library focused on number theory, but not necessarily limited to it. It is based on the PSIQS 4.0 factoring project.
 * Copyright (C) 2018 Tilman Neumann (www.tilman-neumann.de)
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program;
 * if not, see <http://www.gnu.org/licenses/>.
 */
package de.tilman_neumann.util;

import java.io.Serializable;

/**
 * A simple utility class combining two values of arbitrary types to one object.
 *
 * @author Tilman Neumann
 * @param <U> type of first value
 * @param <V> type of second value
 */
public class Pair<U, V> implements Serializable {

  private static final long serialVersionUID = 6122478067737520852L;

  private U first;
  private V second;

  public Pair(U u, V v) {
    first = u;
    second = v;
  }

  public U getFirst() {
    return first;
  }

  public V getSecond() {
    return second;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((first == null) ? 0 : first.hashCode());
    result = prime * result + ((second == null) ? 0 : second.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (getClass() != obj.getClass()) return false;
    @SuppressWarnings("unchecked")
    Pair<U, V> other = (Pair<U, V>) obj;
    if (first == null) {
      if (other.first != null) return false;
    } else if (!first.equals(other.first)) return false;
    if (second == null) {
      if (other.second != null) return false;
    } else if (!second.equals(other.second)) return false;
    return true;
  }

  @Override
  public String toString() {
    return "(" + first + ", " + second + ")";
  }
}
