/*
 * java-math-library is a Java library focused on number theory, but not necessarily limited to it. It is based on the PSIQS 4.0 factoring project.
 * Copyright (C) 2018 Tilman Neumann (www.tilman-neumann.de)
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program;
 * if not, see <http://www.gnu.org/licenses/>.
 */
package de.tilman_neumann.jml.base;

import java.math.BigDecimal;

public class BigDecimalConstants {

  public static final BigDecimal F_0 = BigDecimal.ZERO;
  public static final BigDecimal F_0_5 = new BigDecimal("0.5");
  public static final BigDecimal F_1 = BigDecimal.ONE;
  public static final BigDecimal F_2 = BigDecimal.valueOf(2);
  public static final BigDecimal F_2_5 = new BigDecimal("2.5");
  public static final BigDecimal F_3 = BigDecimal.valueOf(3);
  public static final BigDecimal F_4 = BigDecimal.valueOf(4);
  public static final BigDecimal F_5 = BigDecimal.valueOf(5);
  public static final BigDecimal F_8 = BigDecimal.valueOf(8);
  public static final BigDecimal F_10 = BigDecimal.TEN;
  public static final BigDecimal F_12 = BigDecimal.valueOf(12);
}
