## VertexEccentricity

``` 
VertexEccentricity(graph, vertex)
```

> compute the eccentricity of `vertex` in the `graph`. It's the length of the longest shortest path from the `vertex` to every other vertex in the `graph`.

See
* [Wikipedia - Distance (graph_theory)](https://en.wikipedia.org/wiki/Distance_(graph_theory))

### Related terms 
[GraphCenter](GraphCenter.md), [GraphDiameter](GraphDiameter.md), [GraphPeriphery](GraphPeriphery.md), [GraphRadius](GraphRadius.md), [AdjacencyMatrix](AdjacencyMatrix.md), [EdgeList](EdgeList.md),
[EdgeQ](EdgeQ.md), [EulerianGraphQ](EulerianGraphQ.md), [FindEulerianCycle](FindEulerianCycle.md), [FindHamiltonianCycle](FindHamiltonianCycle.md), [FindVertexCover](FindVertexCover.md), [FindShortestPath](FindShortestPath.md), 
[FindShortestTour](FindShortestTour.md), [FindSpanningTree](FindSpanningTree.md), [Graph](Graph.md), [GraphQ](GraphQ.md), [HamiltonianGraphQ](HamiltonianGraphQ.md), [VertexList](VertexList.md), [VertexQ](VertexQ.md) 

### Github

* [Implementation of VertexEccentricity](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/GraphFunctions.java#L1422) 
