## ArcCoth

```
ArcCoth(z)
```

> returns the inverse hyperbolic cotangent of `z`.

See:
* [Wikipedia: Inverse hyperbolic function](https://en.wikipedia.org/wiki/Inverse_hyperbolic_function)

### Examples

``` 
>> ArcCoth(0)    
I*1/2*Pi 
  
>> ArcCoth(0.0)    
I*1.5707963267948966

>> ArcCoth(0.5)  
0.5493061443340549+I*(-1.5707963267948966)
```  

### Github

* [Implementation of ArcCoth](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/ExpTrigsFunctions.java#L467) 
