package org.matheclipse.core.reflection.system.rules;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/**
 * Generated by <code>org.matheclipse.core.preprocessor.RulePreprocessor</code>.
 *
 * <p>See GIT repository at: <a
 * href="https://github.com/axkr/symja_android_library">github.com/axkr/symja_android_library under
 * the tools directory</a>.
 */
public interface SinhRules {
  /**
   *
   *
   * <ul>
   *   <li>index 0 - number of equal rules in <code>RULES</code>
   * </ul>
   */
  public static final int[] SIZES = {20, 9};

  public static final IAST RULES =
      List(
          IInit(Sinh, SIZES),
          // Sinh(Undefined)=Undefined
          ISet(Sinh(Undefined), Undefined),
          // Sinh(0)=0
          ISet(Sinh(C0), C0),
          // Sinh(1/6*Pi*I)=I/2
          ISet(Sinh(Times(CC(0L, 1L, 1L, 6L), Pi)), CC(0L, 1L, 1L, 2L)),
          // Sinh(1/4*Pi*I)=1/2*Sqrt(2)*I
          ISet(Sinh(Times(CC(0L, 1L, 1L, 4L), Pi)), Times(CI, C1DSqrt2)),
          // Sinh(1/3*Pi*I)=1/2*Sqrt(3)*I
          ISet(Sinh(Times(CC(0L, 1L, 1L, 3L), Pi)), Times(CC(0L, 1L, 1L, 2L), CSqrt3)),
          // Sinh(1/2*Pi*I)=I
          ISet(Sinh(Times(CC(0L, 1L, 1L, 2L), Pi)), CI),
          // Sinh(2/3*Pi*I)=1/2*Sqrt(3)*I
          ISet(Sinh(Times(CC(0L, 1L, 2L, 3L), Pi)), Times(CC(0L, 1L, 1L, 2L), CSqrt3)),
          // Sinh(3/4*Pi*I)=1/2*Sqrt(2)*I
          ISet(Sinh(Times(CC(0L, 1L, 3L, 4L), Pi)), Times(CI, C1DSqrt2)),
          // Sinh(5/6*Pi*I)=I/2
          ISet(Sinh(Times(CC(0L, 1L, 5L, 6L), Pi)), CC(0L, 1L, 1L, 2L)),
          // Sinh(Pi*I)=0
          ISet(Sinh(Times(CI, Pi)), C0),
          // Sinh(7/6*Pi*I)=-I/2
          ISet(Sinh(Times(CC(0L, 1L, 7L, 6L), Pi)), CC(0L, 1L, -1L, 2L)),
          // Sinh(5/4*Pi*I)=-1/2*Sqrt(2)*I
          ISet(Sinh(Times(CC(0L, 1L, 5L, 4L), Pi)), Times(CNI, C1DSqrt2)),
          // Sinh(4/3*Pi*I)=-1/2*Sqrt(3)*I
          ISet(Sinh(Times(CC(0L, 1L, 4L, 3L), Pi)), Times(CC(0L, 1L, -1L, 2L), CSqrt3)),
          // Sinh(3/2*Pi*I)=-I
          ISet(Sinh(Times(CC(0L, 1L, 3L, 2L), Pi)), CNI),
          // Sinh(5/3*Pi*I)=-1/2*Sqrt(3)*I
          ISet(Sinh(Times(CC(0L, 1L, 5L, 3L), Pi)), Times(CC(0L, 1L, -1L, 2L), CSqrt3)),
          // Sinh(7/4*Pi*I)=-1/2*Sqrt(2)*I
          ISet(Sinh(Times(CC(0L, 1L, 7L, 4L), Pi)), Times(CNI, C1DSqrt2)),
          // Sinh(11/6*Pi*I)=-I/2
          ISet(Sinh(Times(CC(0L, 1L, 11L, 6L), Pi)), CC(0L, 1L, -1L, 2L)),
          // Sinh(2*Pi*I)=0
          ISet(Sinh(Times(CC(0L, 1L, 2L, 1L), Pi)), C0),
          // Sinh(Pi/2*I+x_):=I*Cosh(x)
          ISetDelayed(Sinh(Plus(Times(CC(0L, 1L, 1L, 2L), Pi), x_)), Times(CI, Cosh(x))),
          // Sinh(Complex(0,n_Integer)*Pi+x_):=(-1)^n*Sinh(x)
          ISetDelayed(
              Sinh(Plus(Times(Pi, Complex(C0, $p(n, Integer))), x_)),
              Times(Power(CN1, n), Sinh(x))),
          // Sinh(ArcSinh(x_)):=x
          ISetDelayed(Sinh(ArcSinh(x_)), x),
          // Sinh(ArcCosh(x_)):=Sqrt(x+1)*Sqrt(-1+x)
          ISetDelayed(Sinh(ArcCosh(x_)), Times(Sqrt(Plus(x, C1)), Sqrt(Plus(CN1, x)))),
          // Sinh(ArcTanh(x_)):=x/Sqrt(1-x^2)
          ISetDelayed(Sinh(ArcTanh(x_)), Times(x, Power(Subtract(C1, Sqr(x)), CN1D2))),
          // Sinh(ArcCoth(x_)):=1/(Sqrt(-1+x)*Sqrt(x+1))
          ISetDelayed(Sinh(ArcCoth(x_)), Power(Times(Sqrt(Plus(CN1, x)), Sqrt(Plus(x, C1))), CN1)),
          // Sinh(ArcSech(x_)):=Sqrt(1/x+1)*Sqrt(-1+1/x)
          ISetDelayed(
              Sinh(ArcSech(x_)),
              Times(Sqrt(Plus(Power(x, CN1), C1)), Sqrt(Plus(CN1, Power(x, CN1))))),
          // Sinh(ArcCsch(x_)):=1/x
          ISetDelayed(Sinh(ArcCsch(x_)), Power(x, CN1)),
          // Sinh(Log(x_)):=-1/(2*x)+x/2
          ISetDelayed(Sinh(Log(x_)), Plus(Times(CN1D2, Power(x, CN1)), Times(C1D2, x))),
          // Sinh(Infinity)=Infinity
          ISet(Sinh(oo), oo),
          // Sinh(ComplexInfinity)=Indeterminate
          ISet(Sinh(CComplexInfinity), Indeterminate));
}
