package org.matheclipse.core.reflection.system.rules;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/**
 * Generated by <code>org.matheclipse.core.preprocessor.RulePreprocessor</code>.
 *
 * <p>See GIT repository at: <a
 * href="https://github.com/axkr/symja_android_library">github.com/axkr/symja_android_library under
 * the tools directory</a>.
 */
public interface ProductLogRules {
  /**
   *
   *
   * <ul>
   *   <li>index 0 - number of equal rules in <code>RULES</code>
   * </ul>
   */
  public static final int[] SIZES = {12, 0};

  public static final IAST RULES =
      List(
          IInit(ProductLog, SIZES),
          // ProductLog(Undefined)=Undefined
          ISet(ProductLog(Undefined), Undefined),
          // ProductLog(0)=0
          ISet(ProductLog(C0), C0),
          // ProductLog((-1)*1/2*Pi)=I*Pi/2
          ISet(ProductLog(CNPiHalf), Times(CC(0L, 1L, 1L, 2L), Pi)),
          // ProductLog(-1/E)=-1
          ISet(ProductLog(Negate(Exp(CN1))), CN1),
          // ProductLog(E)=1
          ISet(ProductLog(E), C1),
          // ProductLog(-1,-Pi/2)=-1/2*Pi*I
          ISet(ProductLog(CN1, CNPiHalf), Times(CC(0L, 1L, -1L, 2L), Pi)),
          // ProductLog(-1,-1/E)=-1
          ISet(ProductLog(CN1, Negate(Exp(CN1))), CN1),
          // ProductLog(Infinity)=Infinity
          ISet(ProductLog(oo), oo),
          // ProductLog(-Infinity)=Infinity
          ISet(ProductLog(Noo), oo),
          // ProductLog(I*Infinity)=Infinity
          ISet(ProductLog(DirectedInfinity(CI)), oo),
          // ProductLog(-I*Infinity)=Infinity
          ISet(ProductLog(DirectedInfinity(CNI)), oo),
          // ProductLog(ComplexInfinity)=Infinity
          ISet(ProductLog(CComplexInfinity), oo));
}
