package org.matheclipse.core.reflection.system.rules;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/**
 * Generated by <code>org.matheclipse.core.preprocessor.RulePreprocessor</code>.
 *
 * <p>See GIT repository at: <a
 * href="https://github.com/axkr/symja_android_library">github.com/axkr/symja_android_library under
 * the tools directory</a>.
 */
public interface PowerRules {
  /**
   *
   *
   * <ul>
   *   <li>index 0 - number of equal rules in <code>RULES</code>
   * </ul>
   */
  public static final int[] SIZES = {5, 17};

  public static final IAST RULES =
      List(
          IInit(Power, SIZES),
          // E^(1/2*I*Pi)=I
          ISet(Exp(Times(CC(0L, 1L, 1L, 2L), Pi)), CI),
          // E^(3/2*I*Pi)=-I
          ISet(Exp(Times(CC(0L, 1L, 3L, 2L), Pi)), CNI),
          // E^(I*Pi*n_):=(-1)^n/;n∈Integers
          ISetDelayed(Exp(Times(CI, Pi, n_)), Condition(Power(CN1, n), Element(n, Integers))),
          // E^(Pi*c_Complex):=Module({r=Re(c),j=Im(c)},If(EvenQ(j),1,-1)/;r==0&&IntegerQ(j))
          ISetDelayed(
              Exp(Times(Pi, $p(c, Complex))),
              Module(
                  List(Set(r, Re(c)), Set(j, Im(c))),
                  Condition(If(EvenQ(j), C1, CN1), And(Equal(r, C0), IntegerQ(j))))),
          // E^(x_+Pi*c_Complex):=Module({r=Re(c),j=Im(c)},If(EvenQ(j),E^x,-E^x)/;r==0&&IntegerQ(j))
          ISetDelayed(
              Exp(Plus(Times(Pi, $p(c, Complex)), x_)),
              Module(
                  List(Set(r, Re(c)), Set(j, Im(c))),
                  Condition(If(EvenQ(j), Exp(x), Negate(Exp(x))), And(Equal(r, C0), IntegerQ(j))))),
          // E^(I*Infinity)=Indeterminate
          ISet(Exp(DirectedInfinity(CI)), Indeterminate),
          // E^(-I*Infinity)=Indeterminate
          ISet(Exp(DirectedInfinity(CNI)), Indeterminate),
          // E^ComplexInfinity=Indeterminate
          ISet(Exp(CComplexInfinity), Indeterminate),
          // E^Log(x_):=x
          ISetDelayed(Exp(Log(x_)), x),
          // E^(a_*Log(x_)):=x^a/;FreeQ(a,x)
          ISetDelayed(Exp(Times(Log(x_), a_)), Condition(Power(x, a), FreeQ(a, x))),
          // Tan(x_)^m_?(IntegerQ(#1)&&#1<0&):=Cot(x)^(-m)
          ISetDelayed(
              Power(Tan(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Cot(x), Negate(m))),
          // Cot(x_)^m_?(IntegerQ(#1)&&#1<0&):=Tan(x)^(-m)
          ISetDelayed(
              Power(Cot(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Tan(x), Negate(m))),
          // Sec(x_)^m_?(IntegerQ(#1)&&#1<0&):=Cos(x)^(-m)
          ISetDelayed(
              Power(Sec(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Cos(x), Negate(m))),
          // Cos(x_)^m_?(IntegerQ(#1)&&#1<0&):=Sec(x)^(-m)
          ISetDelayed(
              Power(Cos(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Sec(x), Negate(m))),
          // Csc(x_)^m_?(IntegerQ(#1)&&#1<0&):=Sin(x)^(-m)
          ISetDelayed(
              Power(Csc(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Sin(x), Negate(m))),
          // Sin(x_)^m_?(IntegerQ(#1)&&#1<0&):=Csc(x)^(-m)
          ISetDelayed(
              Power(Sin(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Csc(x), Negate(m))),
          // Tanh(x_)^m_?(IntegerQ(#1)&&#1<0&):=Coth(x)^(-m)
          ISetDelayed(
              Power(Tanh(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Coth(x), Negate(m))),
          // Coth(x_)^m_?(IntegerQ(#1)&&#1<0&):=Tanh(x)^(-m)
          ISetDelayed(
              Power(Coth(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Tanh(x), Negate(m))),
          // Sech(x_)^m_?(IntegerQ(#1)&&#1<0&):=Cosh(x)^(-m)
          ISetDelayed(
              Power(Sech(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Cosh(x), Negate(m))),
          // Cosh(x_)^m_?(IntegerQ(#1)&&#1<0&):=Sech(x)^(-m)
          ISetDelayed(
              Power(Cosh(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Sech(x), Negate(m))),
          // Csch(x_)^m_?(IntegerQ(#1)&&#1<0&):=Sinh(x)^(-m)
          ISetDelayed(
              Power(Csch(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Sinh(x), Negate(m))),
          // Sinh(x_)^m_?(IntegerQ(#1)&&#1<0&):=Csch(x)^(-m)
          ISetDelayed(
              Power(Sinh(x_), PatternTest(m_, Function(And(IntegerQ(Slot1), Less(Slot1, C0))))),
              Power(Csch(x), Negate(m))));
}
