package org.matheclipse.core.reflection.system.rules;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/**
 * Generated by <code>org.matheclipse.core.preprocessor.RulePreprocessor</code>.
 *
 * <p>See GIT repository at: <a
 * href="https://github.com/axkr/symja_android_library">github.com/axkr/symja_android_library under
 * the tools directory</a>.
 */
public interface LegendrePRules {
  /**
   *
   *
   * <ul>
   *   <li>index 0 - number of equal rules in <code>RULES</code>
   * </ul>
   */
  public static final int[] SIZES = {1, 1};

  public static final IAST RULES =
      List(
          IInit(LegendreP, SIZES),
          // LegendreP(x_,1)=1
          ISet(LegendreP(x_, C1), C1),
          // LegendreP(x_?NumericQ,0):=Sqrt(Pi)/(Gamma(1/2*(1-x))*Gamma(1+x/2))
          ISetDelayed(
              LegendreP(PatternTest(x_, NumericQ), C0),
              Times(
                  Sqrt(Pi),
                  Power(
                      Times(Gamma(Times(C1D2, Subtract(C1, x))), Gamma(Plus(C1, Times(C1D2, x)))),
                      CN1))),
          // LegendreP(x_?IntegerQ,-1):=(-1)^x
          ISetDelayed(LegendreP(PatternTest(x_, IntegerQ), CN1), Power(CN1, x)),
          // LegendreP(-1/2,1-2*z_):=2/Pi*EllipticK(z)
          ISetDelayed(
              LegendreP(CN1D2, Plus(C1, Times(CN2, z_))), Times(C2, Power(Pi, CN1), EllipticK(z))));
}
