package org.matheclipse.core.reflection.system.rules;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/**
 * Generated by <code>org.matheclipse.core.preprocessor.RulePreprocessor</code>.
 *
 * <p>See GIT repository at: <a
 * href="https://github.com/axkr/symja_android_library">github.com/axkr/symja_android_library under
 * the tools directory</a>.
 */
public interface Hypergeometric0F1Rules {
  /**
   *
   *
   * <ul>
   *   <li>index 0 - number of equal rules in <code>RULES</code>
   * </ul>
   */
  public static final int[] SIZES = {0, 4};

  public static final IAST RULES =
      List(
          IInit(Hypergeometric0F1, SIZES),
          // Hypergeometric0F1(1/2,-z_):=Cos(2*Sqrt(z))/;!TrueQ(Negative(z))
          ISetDelayed(
              Hypergeometric0F1(C1D2, Negate(z_)),
              Condition(Cos(Times(C2, Sqrt(z))), Not(TrueQ(Negative(z))))),
          // Hypergeometric0F1(3/2,-z_):=Sin(2*Sqrt(z))/(2*Sqrt(z))/;!TrueQ(Negative(z))
          ISetDelayed(
              Hypergeometric0F1(QQ(3L, 2L), Negate(z_)),
              Condition(
                  Times(Power(Times(C2, Sqrt(z)), CN1), Sin(Times(C2, Sqrt(z)))),
                  Not(TrueQ(Negative(z))))),
          // Hypergeometric0F1(1/2,z_):=Cosh(2*Sqrt(z))
          ISetDelayed(Hypergeometric0F1(C1D2, z_), Cosh(Times(C2, Sqrt(z)))),
          // Hypergeometric0F1(3/2,z_):=Sinh(2*Sqrt(z))/(2*Sqrt(z))
          ISetDelayed(
              Hypergeometric0F1(QQ(3L, 2L), z_),
              Times(Power(Times(C2, Sqrt(z)), CN1), Sinh(Times(C2, Sqrt(z))))));
}
