package org.matheclipse.core.reflection.system.rules;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/**
 * Generated by <code>org.matheclipse.core.preprocessor.RulePreprocessor</code>.
 *
 * <p>See GIT repository at: <a
 * href="https://github.com/axkr/symja_android_library">github.com/axkr/symja_android_library under
 * the tools directory</a>.
 */
public interface GammaRules {
  /**
   *
   *
   * <ul>
   *   <li>index 0 - number of equal rules in <code>RULES</code>
   * </ul>
   */
  public static final int[] SIZES = {12, 4};

  public static final IAST RULES =
      List(
          IInit(Gamma, SIZES),
          // Gamma(Undefined)=Undefined
          ISet(Gamma(Undefined), Undefined),
          // Gamma(-5/2)=(-1)*1/15*8*Sqrt(Pi)
          ISet(Gamma(QQ(-5L, 2L)), Times(QQ(-8L, 15L), Sqrt(Pi))),
          // Gamma(-3/2)=1/3*4*Sqrt(Pi)
          ISet(Gamma(QQ(-3L, 2L)), Times(QQ(4L, 3L), Sqrt(Pi))),
          // Gamma(-1/2)=-2*Sqrt(Pi)
          ISet(Gamma(CN1D2), Times(CN2, Sqrt(Pi))),
          // Gamma(1/2)=Sqrt(Pi)
          ISet(Gamma(C1D2), Sqrt(Pi)),
          // Gamma(3/2)=Sqrt(Pi)/2
          ISet(Gamma(QQ(3L, 2L)), Times(C1D2, Sqrt(Pi))),
          // Gamma(5/2)=1/4*3*Sqrt(Pi)
          ISet(Gamma(QQ(5L, 2L)), Times(QQ(3L, 4L), Sqrt(Pi))),
          // Gamma(Infinity)=Infinity
          ISet(Gamma(oo), oo),
          // Gamma(-Infinity)=Indeterminate
          ISet(Gamma(Noo), Indeterminate),
          // Gamma(I*Infinity)=0
          ISet(Gamma(DirectedInfinity(CI)), C0),
          // Gamma(-I*Infinity)=0
          ISet(Gamma(DirectedInfinity(CNI)), C0),
          // Gamma(ComplexInfinity)=Indeterminate
          ISet(Gamma(CComplexInfinity), Indeterminate),
          // Gamma(Undefined,y_):=Undefined
          ISetDelayed(Gamma(Undefined, y_), Undefined),
          // Gamma(x_,Undefined):=Undefined
          ISetDelayed(Gamma(x_, Undefined), Undefined),
          // Gamma(a_,-1):=E*Subfactorial(-1+a)
          ISetDelayed(Gamma(a_, CN1), Times(E, Subfactorial(Plus(CN1, a)))),
          // Gamma(a_,Infinity):=0
          ISetDelayed(Gamma(a_, oo), C0),
          // Gamma(1/2,z_?NumericQ):=Sqrt(Pi)*Erfc(Sqrt(z))
          ISetDelayed(Gamma(C1D2, PatternTest(z_, NumericQ)), Times(Sqrt(Pi), Erfc(Sqrt(z)))),
          // Gamma(-1/2,z_?NumericQ):=2/(E^z*Sqrt(z))-2*Sqrt(Pi)*Erfc(Sqrt(z))
          ISetDelayed(
              Gamma(CN1D2, PatternTest(z_, NumericQ)),
              Plus(
                  Times(C2, Power(Times(Exp(z), Sqrt(z)), CN1)),
                  Times(CN2, Sqrt(Pi), Erfc(Sqrt(z))))),
          // Gamma(1,z_):=E^(-z)
          ISetDelayed(Gamma(C1, z_), Exp(Negate(z))),
          // Gamma(a_,z_,0):=-Gamma(a)+Gamma(a,z)/;Re(a)>0
          ISetDelayed(
              Gamma(a_, z_, C0),
              Condition(Plus(Negate(Gamma(a)), Gamma(a, z)), Greater(Re(a), C0))),
          // Gamma(a_,z_,Infinity):=Gamma(a,z)
          ISetDelayed(Gamma(a_, z_, oo), Gamma(a, z)),
          // Gamma(a_,Infinity,z_):=-Gamma(a,z)
          ISetDelayed(Gamma(a_, oo, z_), Negate(Gamma(a, z))),
          // Gamma(a_,0,Infinity):=Gamma(a)/;Re(a)>0
          ISetDelayed(Gamma(a_, C0, oo), Condition(Gamma(a), Greater(Re(a), C0))),
          // Gamma(a_,0,z_):=Gamma(a)-Gamma(a,z)/;Re(a)>0
          ISetDelayed(
              Gamma(a_, C0, z_), Condition(Subtract(Gamma(a), Gamma(a, z)), Greater(Re(a), C0))),
          // Gamma(a_,x_,y_):=Gamma(a,x)-Gamma(a,y)
          ISetDelayed(Gamma(a_, x_, y_), Subtract(Gamma(a, x), Gamma(a, y))));
}
