package org.matheclipse.core.reflection.system.rules;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/**
 * Generated by <code>org.matheclipse.core.preprocessor.RulePreprocessor</code>.
 *
 * <p>See GIT repository at: <a
 * href="https://github.com/axkr/symja_android_library">github.com/axkr/symja_android_library under
 * the tools directory</a>.
 */
public interface ArcCothRules {
  /**
   *
   *
   * <ul>
   *   <li>index 0 - number of equal rules in <code>RULES</code>
   * </ul>
   */
  public static final int[] SIZES = {9, 0};

  public static final IAST RULES =
      List(
          IInit(ArcCoth, SIZES),
          // ArcCoth(Undefined)=Undefined
          ISet(ArcCoth(Undefined), Undefined),
          // ArcCoth(0)=I*Pi/2
          ISet(ArcCoth(C0), Times(CC(0L, 1L, 1L, 2L), Pi)),
          // ArcCoth(I/Sqrt(3))=-1/3*Pi*I
          ISet(ArcCoth(Times(CI, C1DSqrt3)), Times(CC(0L, 1L, -1L, 3L), Pi)),
          // ArcCoth(I)=-1/4*Pi*I
          ISet(ArcCoth(CI), Times(CC(0L, 1L, -1L, 4L), Pi)),
          // ArcCoth(I*Sqrt(3))=-1/6*Pi*I
          ISet(ArcCoth(Times(CI, CSqrt3)), Times(CC(0L, 1L, -1L, 6L), Pi)),
          // ArcCoth(1)=Infinity
          ISet(ArcCoth(C1), oo),
          // ArcCoth(Infinity)=0
          ISet(ArcCoth(oo), C0),
          // ArcCoth(I*Infinity)=0
          ISet(ArcCoth(DirectedInfinity(CI)), C0),
          // ArcCoth(ComplexInfinity)=0
          ISet(ArcCoth(CComplexInfinity), C0));
}
