package org.matheclipse.core.reflection.system.rules;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/**
 * Generated by <code>org.matheclipse.core.preprocessor.RulePreprocessor</code>.
 *
 * <p>See GIT repository at: <a
 * href="https://github.com/axkr/symja_android_library">github.com/axkr/symja_android_library under
 * the tools directory</a>.
 */
public interface AbsRules {
  /**
   *
   *
   * <ul>
   *   <li>index 0 - number of equal rules in <code>RULES</code>
   * </ul>
   */
  public static final int[] SIZES = {4, 1};

  public static final IAST RULES =
      List(
          IInit(Abs, SIZES),
          // Abs(Undefined)=Undefined
          ISet(Abs(Undefined), Undefined),
          // Abs(ArcTan(ComplexInfinity))=Pi/2
          ISet(Abs(ArcTan(CComplexInfinity)), CPiHalf),
          // Abs(E)=E
          ISet(Abs(E), E),
          // Abs(Pi)=Pi
          ISet(Abs(Pi), Pi),
          // Abs(Conjugate(x_)):=Abs(x)
          ISetDelayed(Abs(Conjugate(x_)), Abs(x)));
}
