package org.matheclipse.core.data;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/** */
public interface ElementData2 {

  static final IAST[] ELEMENTS = {
    List(
        ZZ(60L),
        $str("Nd"),
        $str("Neodymium"),
        $str("neodymium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(144.24),
        ZZ(1885L),
        ZZ(6890L),
        ZZ(7007L),
        num(1289.15),
        ZZ(1016L),
        ZZ(3347L),
        num(3073.85),
        ZZ(190L),
        num(7.14),
        ZZ(289L),
        num(1.14),
        C0,
        Missing(NotAvailable),
        ZZ(343L),
        ZZ(265L),
        ZZ(185L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(533.1), ZZ(1040L), ZZ(2130L), ZZ(3900L)),
        Missing(NotAvailable),
        num(16.5),
        ZZ(50L),
        num(0.28),
        num(31.8),
        num(16.3),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C4),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f4 6s2"),
        List(C2, C8, ZZ(18L), ZZ(22L), C8, C2)),
    List(
        ZZ(61L),
        $str("Pm"),
        $str("Promethium"),
        $str("promethium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        ZZ(145L),
        ZZ(1942L),
        Missing(NotAvailable),
        ZZ(7260L),
        num(1204.15),
        ZZ(931L),
        ZZ(3273L),
        num(2999.85),
        Missing(NotAvailable),
        num(7.13),
        ZZ(289L),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(185L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(540L), ZZ(1050L), ZZ(2150L), ZZ(3970L)),
        Missing(NotAvailable),
        num(17.9),
        ZZ(18L),
        num(0.28),
        ZZ(33L),
        ZZ(18L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C5),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f5 6s2"),
        List(C2, C8, ZZ(18L), ZZ(23L), C8, C2)),
    List(
        ZZ(62L),
        $str("Sm"),
        $str("Samarium"),
        $str("samarium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(150.36),
        ZZ(1879L),
        ZZ(7160L),
        ZZ(7520L),
        num(1345.15),
        ZZ(1072L),
        ZZ(2067L),
        num(1793.85),
        ZZ(197L),
        num(8.62),
        ZZ(165L),
        num(1.17),
        C0,
        Missing(NotAvailable),
        ZZ(412L),
        ZZ(441L),
        ZZ(185L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(544.5), ZZ(1070L), ZZ(2260L), ZZ(3990L)),
        Missing(NotAvailable),
        num(13.3),
        ZZ(55L),
        num(0.27),
        num(37.8),
        num(19.5),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C6),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f6 6s2"),
        List(C2, C8, ZZ(18L), ZZ(24L), C8, C2)),
    List(
        ZZ(63L),
        $str("Eu"),
        $str("Europium"),
        $str("europium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(151.96),
        ZZ(1896L),
        ZZ(5130L),
        ZZ(5243L),
        num(1095.15),
        ZZ(822L),
        ZZ(1802L),
        num(1528.85),
        ZZ(182L),
        num(9.21),
        ZZ(176L),
        num(1.2),
        C0,
        Missing(NotAvailable),
        ZZ(167L),
        Missing(NotAvailable),
        ZZ(185L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(547.1), ZZ(1085L), ZZ(2404L), ZZ(4120L)),
        Missing(NotAvailable),
        num(13.9),
        ZZ(56L),
        num(0.15),
        num(8.3),
        num(7.9),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C7),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f7 6s2"),
        List(C2, C8, ZZ(18L), ZZ(25L), C8, C2)),
    List(
        ZZ(64L),
        $str("Gd"),
        $str("Gadolinium"),
        $str("gadolinium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(157.25),
        ZZ(1880L),
        ZZ(7400L),
        ZZ(7895L),
        num(1585.15),
        ZZ(1312L),
        ZZ(3546L),
        num(3272.85),
        ZZ(236L),
        num(10.05),
        num(301.3),
        num(1.2),
        C0,
        Missing(NotAvailable),
        ZZ(570L),
        Missing(NotAvailable),
        ZZ(180L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(593.4), ZZ(1170L), ZZ(1990L), ZZ(4250L)),
        Missing(NotAvailable),
        num(10.6),
        ZZ(61L),
        num(0.26),
        num(37.9),
        num(21.8),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C7),
            List(C2, C6, C1),
            List(C2)),
        $str("[Xe] 4f7 5d1 6s2"),
        List(C2, C8, ZZ(18L), ZZ(25L), C9, C2)),
    List(
        ZZ(65L),
        $str("Tb"),
        $str("Terbium"),
        $str("terbium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(158.93),
        ZZ(1842L),
        ZZ(7650L),
        ZZ(8229L),
        num(1630.15),
        ZZ(1357L),
        ZZ(3503L),
        num(3229.85),
        ZZ(182L),
        num(10.15),
        ZZ(293L),
        num(1.2),
        C0,
        Missing(NotAvailable),
        ZZ(863L),
        ZZ(677L),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(565.8), ZZ(1110L), ZZ(2114L), ZZ(3839L)),
        Missing(NotAvailable),
        num(11.1),
        ZZ(65L),
        num(0.26),
        num(38.7),
        num(22.1),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C9),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f9 6s2"),
        List(C2, C8, ZZ(18L), ZZ(27L), C8, C2)),
    List(
        ZZ(66L),
        $str("Dy"),
        $str("Dysprosium"),
        $str("dysprosium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(162.5),
        ZZ(1886L),
        ZZ(8370L),
        ZZ(8550L),
        num(1680.15),
        ZZ(1407L),
        ZZ(2840L),
        num(2566.85),
        ZZ(170L),
        num(11.06),
        ZZ(280L),
        num(1.22),
        C0,
        Missing(NotAvailable),
        ZZ(540L),
        ZZ(500L),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(573.0), ZZ(1130L), ZZ(2200L), ZZ(3990L)),
        Missing(NotAvailable),
        num(10.7),
        ZZ(70L),
        num(0.25),
        num(40.5),
        num(24.7),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C10),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f10 6s2"),
        List(C2, C8, ZZ(18L), ZZ(28L), C8, C2)),
    List(
        ZZ(67L),
        $str("Ho"),
        $str("Holmium"),
        $str("holmium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(164.93),
        ZZ(1878L),
        ZZ(8340L),
        ZZ(8795L),
        num(1743.15),
        ZZ(1470L),
        ZZ(2993L),
        num(2719.85),
        ZZ(165L),
        ZZ(17L),
        ZZ(265L),
        num(1.23),
        C0,
        Missing(NotAvailable),
        ZZ(481L),
        ZZ(746L),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(581.0), ZZ(1140L), ZZ(2204L), ZZ(4100L)),
        Missing(NotAvailable),
        num(16.2),
        ZZ(74L),
        num(0.23),
        num(40.2),
        num(26.3),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(11L)),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f11 6s2"),
        List(C2, C8, ZZ(18L), ZZ(29L), C8, C2)),
    List(
        ZZ(68L),
        $str("Er"),
        $str("Erbium"),
        $str("erbium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(167.26),
        ZZ(1842L),
        ZZ(8860L),
        ZZ(9066L),
        num(1795.15),
        ZZ(1522L),
        ZZ(3503L),
        num(3229.85),
        ZZ(168L),
        num(19.9),
        ZZ(280L),
        num(1.24),
        C0,
        Missing(NotAvailable),
        ZZ(589L),
        ZZ(814L),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(589.3), ZZ(1150L), ZZ(2194L), ZZ(4120L)),
        Missing(NotAvailable),
        num(14.5),
        ZZ(24L),
        num(0.24),
        num(44.4),
        num(28.3),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(12L)),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f12 6s2"),
        List(C2, C8, ZZ(18L), ZZ(30L), C8, C2)),
    List(
        ZZ(69L),
        $str("Tm"),
        $str("Thulium"),
        $str("thulium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(168.93),
        ZZ(1879L),
        ZZ(8560L),
        ZZ(9321L),
        num(1818.15),
        ZZ(1545L),
        ZZ(2223L),
        num(1949.85),
        ZZ(160L),
        num(16.84),
        ZZ(247L),
        num(1.25),
        C0,
        Missing(NotAvailable),
        ZZ(520L),
        ZZ(471L),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(596.7), ZZ(1160L), ZZ(2285L), ZZ(4120L)),
        ZZ(99L),
        num(16.9),
        ZZ(69L),
        num(0.21),
        num(44.5),
        num(30.5),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(13L)),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f13 6s2"),
        List(C2, C8, ZZ(18L), ZZ(31L), C8, C2)),
    List(
        ZZ(70L),
        $str("Yb"),
        $str("Ytterbium"),
        $str("ytterbium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(173.05),
        ZZ(1878L),
        ZZ(6210L),
        ZZ(6965L),
        num(1097.15),
        ZZ(824L),
        ZZ(1469L),
        num(1195.85),
        ZZ(155L),
        num(7.66),
        ZZ(159L),
        num(1.1),
        C0,
        Missing(NotAvailable),
        ZZ(206L),
        ZZ(343L),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(603.4), num(1174.8), ZZ(2417L), ZZ(4203L)),
        Missing(NotAvailable),
        num(38.5),
        ZZ(78L),
        num(0.21),
        num(30.5),
        num(9.9),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f14 6s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), C8, C2)),
    List(
        ZZ(71L),
        $str("Lu"),
        $str("Lutetium"),
        $str("lutetium"),
        $str("d"),
        C3,
        C6,
        $str("Lanthanide"),
        num(174.97),
        ZZ(1906L),
        ZZ(9300L),
        ZZ(9840L),
        num(1936.15),
        ZZ(1663L),
        ZZ(3675L),
        num(3401.85),
        ZZ(154L),
        ZZ(22L),
        ZZ(414L),
        num(1.27),
        C0,
        Missing(NotAvailable),
        ZZ(1160L),
        ZZ(893L),
        ZZ(175L),
        Missing(NotAvailable),
        ZZ(160L),
        List(num(523.5), ZZ(1340L), num(2022.3), ZZ(4370L), ZZ(6445L)),
        ZZ(33L),
        num(16.4),
        ZZ(186L),
        num(0.26),
        num(47.6),
        num(27.2),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C1),
            List(C2)),
        $str("[Xe] 4f14 5d1 6s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), C9, C2)),
    List(
        ZZ(72L),
        $str("Hf"),
        $str("Hafnium"),
        $str("hafnium"),
        $str("d"),
        C4,
        C6,
        $str("TransitionMetal"),
        num(178.49),
        ZZ(1911L),
        ZZ(12000L),
        ZZ(13310L),
        num(2500.15),
        ZZ(2227L),
        ZZ(4876L),
        num(4602.85),
        ZZ(144L),
        num(27.2),
        ZZ(571L),
        num(1.3),
        C0,
        num(5.5),
        ZZ(1760L),
        ZZ(1700L),
        ZZ(155L),
        Missing(NotAvailable),
        ZZ(150L),
        List(num(658.5), ZZ(1440L), ZZ(2250L), ZZ(3216L)),
        Missing(NotAvailable),
        ZZ(23L),
        ZZ(411L),
        num(0.37),
        ZZ(110L),
        ZZ(30L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C2),
            List(C2)),
        $str("[Xe] 4f14 5d2 6s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), C10, C2)),
    List(
        ZZ(73L),
        $str("Ta"),
        $str("Tantalum"),
        $str("tantalum"),
        $str("d"),
        C5,
        C6,
        $str("TransitionMetal"),
        num(180.95),
        ZZ(1802L),
        ZZ(15000L),
        ZZ(16654L),
        num(3269.15),
        ZZ(2996L),
        ZZ(5731L),
        num(5457.85),
        ZZ(140L),
        num(36.57),
        num(732.8),
        num(1.5),
        C0,
        num(6.5),
        ZZ(873L),
        ZZ(800L),
        ZZ(145L),
        Missing(NotAvailable),
        ZZ(138L),
        List(ZZ(761L), ZZ(1500L)),
        ZZ(31L),
        num(57.5),
        ZZ(463L),
        num(0.34),
        ZZ(200L),
        ZZ(69L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C3),
            List(C2)),
        $str("[Xe] 4f14 5d3 6s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(11L), C2)),
    List(
        ZZ(74L),
        $str("W"),
        $str("Tungsten"),
        $str("tungsten"),
        $str("d"),
        C6,
        C6,
        $str("TransitionMetal"),
        num(183.84),
        ZZ(1781L),
        ZZ(17600L),
        ZZ(19250L),
        num(3680.15),
        ZZ(3407L),
        ZZ(5828L),
        num(5554.85),
        ZZ(132L),
        num(52.31),
        num(806.7),
        num(2.36),
        C0,
        num(7.5),
        ZZ(3430L),
        ZZ(2570L),
        ZZ(135L),
        Missing(NotAvailable),
        ZZ(146L),
        List(ZZ(770L), ZZ(1700L)),
        ZZ(79L),
        ZZ(173L),
        Missing(NotAvailable),
        num(0.28),
        ZZ(310L),
        ZZ(161L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C4),
            List(C2)),
        $str("[Xe] 4f14 5d4 6s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(12L), C2)),
    List(
        ZZ(75L),
        $str("Re"),
        $str("Rhenium"),
        $str("rhenium"),
        $str("d"),
        C7,
        C6,
        $str("TransitionMetal"),
        num(186.21),
        ZZ(1908L),
        ZZ(18900L),
        ZZ(21020L),
        num(3453.15),
        ZZ(3180L),
        ZZ(5869L),
        num(5595.85),
        ZZ(137L),
        num(60.43),
        ZZ(704L),
        num(1.9),
        C0,
        C7,
        ZZ(2450L),
        ZZ(1320L),
        ZZ(135L),
        Missing(NotAvailable),
        ZZ(159L),
        List(ZZ(760L), ZZ(1260L), ZZ(2510L), ZZ(3640L)),
        Missing(NotAvailable),
        ZZ(48L),
        ZZ(528L),
        num(0.3),
        ZZ(370L),
        ZZ(178L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C5),
            List(C2)),
        $str("[Xe] 4f14 5d5 6s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(13L), C2)),
    List(
        ZZ(76L),
        $str("Os"),
        $str("Osmium"),
        $str("osmium"),
        $str("d"),
        C8,
        C6,
        $str("TransitionMetal"),
        num(190.23),
        ZZ(1803L),
        ZZ(20000L),
        ZZ(22610L),
        num(3300.15),
        ZZ(3027L),
        ZZ(5285L),
        num(5011.85),
        ZZ(130L),
        num(57.85),
        ZZ(738L),
        num(2.2),
        C0,
        C7,
        C0,
        ZZ(3920L),
        ZZ(130L),
        Missing(NotAvailable),
        ZZ(128L),
        List(ZZ(840L), ZZ(1600L)),
        ZZ(104L),
        num(87.6),
        ZZ(168L),
        num(0.25),
        ZZ(462L),
        ZZ(222L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C6),
            List(C2)),
        $str("[Xe] 4f15 66s "),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(14L), C2)),
    List(
        ZZ(77L),
        $str("Ir"),
        $str("Iridium"),
        $str("iridium"),
        $str("d"),
        C9,
        C6,
        $str("TransitionMetal"),
        num(192.22),
        ZZ(1803L),
        ZZ(19000L),
        ZZ(22560L),
        num(2716.15),
        ZZ(2443L),
        ZZ(4701L),
        num(4427.85),
        ZZ(131L),
        num(41.12),
        num(231.8),
        num(2.2),
        C0,
        num(6.5),
        ZZ(1760L),
        ZZ(1670L),
        ZZ(135L),
        Missing(NotAvailable),
        ZZ(137L),
        List(ZZ(880L), ZZ(1600L)),
        num(150.9),
        ZZ(147L),
        ZZ(78L),
        num(0.26),
        ZZ(320L),
        ZZ(210L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C7),
            List(C2)),
        $str("[Xe] 4f14 5d7 6s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(15L), C2)),
    List(
        ZZ(78L),
        $str("Pt"),
        $str("Platinum"),
        $str("platinum"),
        $str("d"),
        C10,
        C6,
        $str("TransitionMetal"),
        num(195.08),
        ZZ(1735L),
        ZZ(19770L),
        ZZ(21460L),
        num(2045.15),
        ZZ(1772L),
        ZZ(4098L),
        num(3824.85),
        ZZ(133L),
        num(22.17),
        ZZ(469L),
        num(2.28),
        C0,
        num(3.5),
        ZZ(549L),
        ZZ(392L),
        ZZ(135L),
        ZZ(175L),
        ZZ(128L),
        List(ZZ(870L), ZZ(1791L)),
        num(205.04),
        num(71.6),
        Missing(NotAvailable),
        num(0.38),
        ZZ(230L),
        ZZ(61L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C9),
            List(C1)),
        $str("[Xe] 4f14 5d9 6s1"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(17L), C1)),
    List(
        ZZ(79L),
        $str("Au"),
        $str("Gold"),
        $str("gold"),
        $str("d"),
        ZZ(11L),
        C6,
        $str("TransitionMetal"),
        num(196.97),
        ZZ(-6000L),
        ZZ(17310L),
        ZZ(19282L),
        num(1337.73),
        num(1064.58),
        ZZ(3129L),
        num(2855.85),
        ZZ(129L),
        num(12.55),
        ZZ(324L),
        num(2.54),
        C0,
        num(2.5),
        ZZ(216L),
        ZZ(245L),
        ZZ(135L),
        ZZ(166L),
        ZZ(144L),
        List(num(890.1), ZZ(1980L)),
        num(222.75),
        ZZ(318L),
        C8,
        num(0.44),
        ZZ(180L),
        ZZ(27L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C1)),
        $str("[Xe] 4f14 5d10 6s1"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C1)),
    List(
        ZZ(80L),
        $str("Hg"),
        $str("Mercury"),
        $str("mercury"),
        $str("d"),
        ZZ(12L),
        C6,
        $str("TransitionMetal"),
        num(200.59),
        ZZ(-2000L),
        ZZ(13534L),
        num(13533.6),
        num(234.43),
        num(-38.72),
        ZZ(630L),
        num(356.85),
        ZZ(140L),
        num(2.29),
        num(59.11),
        C2,
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(150L),
        ZZ(155L),
        ZZ(149L),
        List(num(1007.1), ZZ(1810L), ZZ(3300L)),
        Missing(NotAvailable),
        num(8.3),
        ZZ(16L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2)),
        $str("[Xe] 4f14 5d10 6s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C2)),
    List(
        ZZ(81L),
        $str("Tl"),
        $str("Thallium"),
        $str("thallium"),
        $str("p"),
        ZZ(13L),
        C6,
        $str("PoorMetal"),
        num(204.38),
        ZZ(1861L),
        ZZ(11220L),
        ZZ(11850L),
        num(577.15),
        ZZ(304L),
        ZZ(1746L),
        num(1472.85),
        ZZ(129L),
        num(4.14),
        ZZ(165L),
        num(1.62),
        C0,
        C1,
        Missing(NotAvailable),
        num(26.4),
        ZZ(190L),
        ZZ(196L),
        ZZ(148L),
        List(num(589.4), ZZ(1971L), ZZ(2878L)),
        ZZ(36L),
        num(46.1),
        ZZ(32L),
        num(0.45),
        ZZ(43L),
        num(2.8),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C1)),
        $str("[Xe] 4f14 5d10 6s2 6p1"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C3)),
    List(
        ZZ(82L),
        $str("Pb"),
        $str("Lead"),
        $str("lead"),
        $str("p"),
        ZZ(14L),
        C6,
        $str("PoorMetal"),
        num(207.2),
        ZZ(-7000L),
        ZZ(10660L),
        ZZ(11342L),
        num(600.75),
        num(327.6),
        ZZ(2022L),
        num(1748.85),
        ZZ(129L),
        num(4.77),
        num(179.5),
        num(2.33),
        C0,
        num(1.5),
        Missing(NotAvailable),
        num(38.3),
        ZZ(180L),
        ZZ(202L),
        ZZ(147L),
        List(num(715.6), num(1450.5), num(3081.5), ZZ(4083L), ZZ(6640L)),
        ZZ(35L),
        num(35.3),
        Missing(NotAvailable),
        num(0.44),
        ZZ(46L),
        num(5.6),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C2)),
        $str("[Xe] 4f14 5d10 6s2 6p2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C4)),
    List(
        ZZ(83L),
        $str("Bi"),
        $str("Bismuth"),
        $str("bismuth"),
        $str("p"),
        ZZ(15L),
        C6,
        $str("PoorMetal"),
        num(208.98),
        ZZ(1753L),
        ZZ(10050L),
        ZZ(9807L),
        num(544.67),
        num(271.52),
        ZZ(1837L),
        num(1563.85),
        ZZ(122L),
        num(11.3),
        ZZ(151L),
        num(2.02),
        C0,
        num(2.5),
        Missing(NotAvailable),
        num(94.2),
        ZZ(160L),
        Missing(NotAvailable),
        ZZ(146L),
        List(ZZ(703L), ZZ(1610L), ZZ(2466L), ZZ(4370L), ZZ(5400L), ZZ(8520L)),
        num(90.92),
        num(7.97),
        Missing(NotAvailable),
        num(0.33),
        ZZ(31L),
        ZZ(12L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C3)),
        $str("[Xe] 4f14 5d10 6s2 6p3"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C5)),
    List(
        ZZ(84L),
        $str("Po"),
        $str("Polonium"),
        $str("polonium"),
        $str("p"),
        ZZ(16L),
        C6,
        $str("PoorMetal"),
        ZZ(209L),
        ZZ(1898L),
        Missing(NotAvailable),
        ZZ(9320L),
        num(527.15),
        ZZ(254L),
        ZZ(1235L),
        num(961.85),
        Missing(NotAvailable),
        ZZ(13L),
        num(102.91),
        C2,
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(190L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(812.1)),
        Missing(NotAvailable),
        num(0.2),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C4)),
        $str("[Xe] 4f14 5d10 6s2 6p4"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C6)),
    List(
        ZZ(85L),
        $str("At"),
        $str("Astatine"),
        $str("astatine"),
        $str("p"),
        ZZ(17L),
        C6,
        $str("Halogen"),
        ZZ(210L),
        ZZ(1940L),
        Missing(NotAvailable),
        ZZ(7000L),
        num(575.15),
        ZZ(302L),
        ZZ(610L),
        num(336.85),
        Missing(NotAvailable),
        C6,
        num(54.39),
        num(2.2),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(Times(num(887.7), num(38.59))),
        Missing(NotAvailable),
        num(1.7),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C5)),
        $str("[Xe] 4f14 5d10 6s2 6p5"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C7)),
    List(
        ZZ(86L),
        $str("Rn"),
        $str("Radon"),
        $str("radon"),
        $str("p"),
        ZZ(18L),
        C6,
        $str("NobleGas"),
        ZZ(222L),
        ZZ(1898L),
        Missing(NotAvailable),
        num(9.73),
        num(202.15),
        ZZ(-71L),
        num(211.3),
        num(-61.85),
        Missing(NotAvailable),
        num(3.25),
        num(18.1),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(120L),
        Missing(NotAvailable),
        ZZ(145L),
        List(ZZ(1037L)),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C6)),
        $str("[Xe] 4f14 5d10 6s2 6p6"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C8)),
    List(
        ZZ(87L),
        $str("Fr"),
        $str("Francium"),
        $str("francium"),
        $str("s"),
        C1,
        C7,
        $str("AlkaliMetal"),
        ZZ(223L),
        ZZ(1939L),
        Missing(NotAvailable),
        ZZ(1870L),
        num(300.15),
        ZZ(27L),
        ZZ(950L),
        num(676.85),
        Missing(NotAvailable),
        C2,
        $str("ca. 65"),
        num(0.7),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(380L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C6),
            List(C1)),
        $str("[Rn] 7s1"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C8, C1)),
    List(
        ZZ(88L),
        $str("Ra"),
        $str("Radium"),
        $str("radium"),
        $str("s"),
        C2,
        C7,
        $str("AlkalineEarthMetal"),
        ZZ(226L),
        ZZ(1898L),
        Missing(NotAvailable),
        ZZ(5500L),
        num(973.15),
        ZZ(700L),
        ZZ(2010L),
        num(1736.85),
        Missing(NotAvailable),
        num(8.5),
        ZZ(113L),
        num(0.9),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(215L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(509.3), num(979.0)),
        Missing(NotAvailable),
        num(18.6),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C8, C2)),
    List(
        ZZ(89L),
        $str("Ac"),
        $str("Actinium"),
        $str("actinium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(227L),
        ZZ(1899L),
        Missing(NotAvailable),
        ZZ(10070L),
        num(1323.15),
        ZZ(1050L),
        ZZ(3471L),
        num(3197.85),
        Missing(NotAvailable),
        ZZ(14L),
        ZZ(400L),
        num(1.1),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(195L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(499L), ZZ(1170L)),
        Missing(NotAvailable),
        ZZ(12L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C6, C1),
            List(C2)),
        $str("[Rn] 6d1 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C9, C2)),
    List(
        ZZ(90L),
        $str("Th"),
        $str("Thorium"),
        $str("thorium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        num(232.04),
        ZZ(1829L),
        Missing(NotAvailable),
        ZZ(11720L),
        num(2028.15),
        ZZ(1755L),
        ZZ(5061L),
        num(4787.85),
        Missing(NotAvailable),
        num(13.81),
        ZZ(514L),
        num(1.3),
        C0,
        C3,
        ZZ(350L),
        ZZ(400L),
        ZZ(180L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(587L), ZZ(1110L), ZZ(1930L), ZZ(2780L)),
        Missing(NotAvailable),
        ZZ(54L),
        ZZ(79L),
        num(0.27),
        ZZ(54L),
        ZZ(31L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10),
            List(C2, C6, C2),
            List(C2)),
        $str("[Rn] 6d2 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(18L), C10, C2)),
    List(
        ZZ(91L),
        $str("Pa"),
        $str("Protactinium"),
        $str("protactinium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        num(231.04),
        ZZ(1913L),
        Missing(NotAvailable),
        ZZ(15370L),
        num(1873.15),
        ZZ(1600L),
        ZZ(4300L),
        num(4026.85),
        Missing(NotAvailable),
        num(12.34),
        ZZ(481L),
        num(1.5),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(180L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(568L)),
        Missing(NotAvailable),
        ZZ(47L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, C2),
            List(C2, C6, C1),
            List(C2)),
        $str("[Rn] 5f2 6d1 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(20L), C9, C2)),
    List(
        ZZ(92L),
        $str("U"),
        $str("Uranium"),
        $str("uranium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        num(238.03),
        ZZ(1789L),
        ZZ(17300L),
        ZZ(18950L),
        num(1405.15),
        ZZ(1132L),
        ZZ(4404L),
        num(4130.85),
        Missing(NotAvailable),
        num(9.14),
        num(417.1),
        num(1.38),
        C0,
        C6,
        ZZ(1960L),
        ZZ(2400L),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(597.6), ZZ(1420L)),
        Missing(NotAvailable),
        num(27.5),
        ZZ(208L),
        num(0.23),
        ZZ(100L),
        ZZ(111L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, C3),
            List(C2, C6, C1),
            List(C2)),
        $str("[Rn] 5f3 6d1 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(21L), C9, C2)),
    List(
        ZZ(93L),
        $str("Np"),
        $str("Neptunium"),
        $str("neptunium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(237L),
        ZZ(1940L),
        Missing(NotAvailable),
        ZZ(20450L),
        num(913.15),
        ZZ(640L),
        ZZ(4273L),
        num(3999.85),
        Missing(NotAvailable),
        num(3.2),
        ZZ(336L),
        num(1.36),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(604.5)),
        Missing(NotAvailable),
        num(6.3),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, C4),
            List(C2, C6, C1),
            List(C2)),
        $str("[Rn] 5f4 6d1 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(22L), C9, C2)),
    List(
        ZZ(94L),
        $str("Pu"),
        $str("Plutonium"),
        $str("plutonium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(244L),
        ZZ(1940L),
        ZZ(16630L),
        ZZ(19840L),
        num(913.15),
        ZZ(640L),
        ZZ(3501L),
        num(3227.85),
        Missing(NotAvailable),
        num(2.82),
        num(333.5),
        num(1.28),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(584.7)),
        Missing(NotAvailable),
        num(6.74),
        ZZ(96L),
        num(0.21),
        ZZ(43L),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, C6),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 5f6 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(24L), C8, C2)),
    List(
        ZZ(95L),
        $str("Am"),
        $str("Americium"),
        $str("americium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(243L),
        ZZ(1944L),
        Missing(NotAvailable),
        ZZ(13690L),
        num(1267.15),
        ZZ(994L),
        ZZ(2880L),
        num(2606.85),
        Missing(NotAvailable),
        num(14.39),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(175L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(578L)),
        Missing(NotAvailable),
        C10,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, C7),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 5f7 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(25L), C8, C2)),
    List(
        ZZ(96L),
        $str("Cm"),
        $str("Curium"),
        $str("curium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(247L),
        ZZ(1944L),
        Missing(NotAvailable),
        ZZ(13510L),
        num(1340.15),
        ZZ(1067L),
        ZZ(3383L),
        num(3109.85),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(581L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, C7),
            List(C2, C6, C1),
            List(C2)),
        $str("[Rn] 5f7 6d1 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(25L), C9, C2)),
    List(
        ZZ(97L),
        $str("Bk"),
        $str("Berkelium"),
        $str("berkelium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(247L),
        ZZ(1949L),
        Missing(NotAvailable),
        ZZ(14790L),
        num(1259.15),
        ZZ(986L),
        ZZ(983L),
        num(709.85),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(601L)),
        Missing(NotAvailable),
        C10,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, C9),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 5f9 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(27L), C8, C2)),
    List(
        ZZ(98L),
        $str("Cf"),
        $str("Californium"),
        $str("californium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(251L),
        ZZ(1950L),
        Missing(NotAvailable),
        ZZ(15100L),
        num(1925.15),
        ZZ(1652L),
        ZZ(1173L),
        num(899.85),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(608L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, C10),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 5f10 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(28L), C8, C2)),
    List(
        ZZ(99L),
        $str("Es"),
        $str("Einsteinium"),
        $str("einsteinium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(252L),
        ZZ(1952L),
        Missing(NotAvailable),
        ZZ(13500L),
        num(1133.15),
        ZZ(860L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(619L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, ZZ(11L)),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 5f11 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(29L), C8, C2)),
    List(
        ZZ(100L),
        $str("Fm"),
        $str("Fermium"),
        $str("fermium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(257L),
        ZZ(1942L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(1800L),
        num(1526.85),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(627L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, ZZ(12L)),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 5f12 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(30L), C8, C2)),
    List(
        ZZ(101L),
        $str("Md"),
        $str("Mendelevium"),
        $str("mendelevium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(258L),
        ZZ(1955L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(1100L),
        num(826.85),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(635L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, ZZ(13L)),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 5f13 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(31L), C8, C2)),
    List(
        ZZ(102L),
        $str("No"),
        $str("Nobelium"),
        $str("nobelium"),
        $str("f"),
        Missing(NotApplicable),
        C7,
        $str("Actinide"),
        ZZ(259L),
        ZZ(1958L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(1100L),
        num(826.85),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(642L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6),
            List(C2)),
        $str("[Rn] 5f14 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(32L), C8, C2)),
    List(
        ZZ(103L),
        $str("Lr"),
        $str("Lawrencium"),
        $str("lawrencium"),
        $str("d"),
        C3,
        C7,
        $str("Actinide"),
        ZZ(262L),
        ZZ(1961L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(1900L),
        num(1626.85),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(1.3),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(470L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6),
            List(C2, C1)),
        $str("[Rn] 5f14 7s2 7p1"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(32L), C8, C3)),
    List(
        ZZ(104L),
        $str("Rf"),
        $str("Rutherfordium"),
        $str("rutherfordium"),
        $str("d"),
        C4,
        C7,
        $str("TransitionMetal"),
        ZZ(267L),
        ZZ(1968L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(580L)),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6),
            List(C2, C1)),
        $str("[Rn] 5f14 6d2 7s2"),
        List(C2, C8, ZZ(18L), ZZ(32L), ZZ(32L), C10, C2)),
    List(
        ZZ(105L),
        $str("Db"),
        $str("Dubnium"),
        $str("dubnium"),
        $str("d"),
        C5,
        C7,
        $str("TransitionMetal"),
        ZZ(268L),
        ZZ(1970L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C10, ZZ(14L)),
            List(C2, C6, C2),
            List(C2, C1)),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(106L),
        $str("Sg"),
        $str("Seaborgium"),
        $str("seaborgium"),
        $str("d"),
        C6,
        C7,
        $str("TransitionMetal"),
        ZZ(269L),
        ZZ(1974L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(107L),
        $str("Bh"),
        $str("Bohrium"),
        $str("bohrium"),
        $str("d"),
        C7,
        C7,
        $str("TransitionMetal"),
        ZZ(270L),
        ZZ(1981L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(108L),
        $str("Hs"),
        $str("Hassium"),
        $str("hassium"),
        $str("d"),
        C8,
        C7,
        $str("TransitionMetal"),
        ZZ(269L),
        ZZ(1984L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(109L),
        $str("Mt"),
        $str("Meitnerium"),
        $str("meitnerium"),
        $str("d"),
        C9,
        C7,
        Missing(Unknown),
        ZZ(278L),
        ZZ(1982L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(110L),
        $str("Ds"),
        $str("Darmstadtium"),
        $str("darmstadtium"),
        $str("d"),
        C10,
        C7,
        Missing(Unknown),
        ZZ(281L),
        ZZ(1994L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(111L),
        $str("Rg"),
        $str("Roentgenium"),
        $str("roentgenium"),
        $str("d"),
        ZZ(11L),
        C7,
        Missing(Unknown),
        ZZ(281L),
        ZZ(1994L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(112L),
        $str("Cn"),
        $str("Copernicium"),
        $str("copernicium"),
        $str("d"),
        ZZ(12L),
        C7,
        $str("TransitionMetal"),
        ZZ(285L),
        ZZ(1996L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(113L),
        $str("Uut"),
        $str("Ununtrium"),
        $str("ununtrium"),
        $str("p"),
        ZZ(13L),
        C7,
        Missing(Unknown),
        ZZ(286L),
        ZZ(2003L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(114L),
        $str("Fl"),
        $str("Flerovium"),
        $str("flerovium"),
        $str("p"),
        ZZ(14L),
        C7,
        Missing(Unknown),
        ZZ(289L),
        ZZ(1999L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(115L),
        $str("Uup"),
        $str("Ununpentium"),
        $str("ununpentium"),
        $str("p"),
        ZZ(15L),
        C7,
        Missing(Unknown),
        ZZ(288L),
        ZZ(2003L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(116L),
        $str("Lv"),
        $str("Livermorium"),
        $str("livermorium"),
        $str("p"),
        ZZ(16L),
        C7,
        Missing(Unknown),
        ZZ(293L),
        ZZ(2000L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(117L),
        $str("Uus"),
        $str("Ununseptium"),
        $str("ununseptium"),
        $str("p"),
        ZZ(17L),
        C7,
        Missing(Unknown),
        ZZ(294L),
        ZZ(2010L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
    List(
        ZZ(118L),
        $str("Uuo"),
        $str("Ununoctium"),
        $str("ununoctium"),
        $str("p"),
        ZZ(18L),
        C7,
        Missing(Unknown),
        ZZ(294L),
        ZZ(2002L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable)),
  };
}
