package org.matheclipse.core.data;

import static org.matheclipse.core.expression.F.*;
import org.matheclipse.core.interfaces.IAST;

/** */
public interface ElementData1 {

  static final IAST[] ELEMENTS = {
    List(
        C1,
        $str("H"),
        $str("Hydrogen"),
        $str("hydrogen"),
        $str("s"),
        C1,
        C1,
        $str("Nonmetal"),
        num(1.01),
        ZZ(1766L),
        Missing(NotApplicable),
        num(0.09),
        num(14.18),
        num(-258.98),
        num(20.28),
        num(-252.87),
        ZZ(14304L),
        num(0.12),
        num(0.9),
        num(2.2),
        C0,
        Missing(NotApplicable),
        Missing(NotApplicable),
        Missing(NotApplicable),
        ZZ(35L),
        ZZ(120L),
        ZZ(38L),
        List(num(1312.0)),
        num(72.77),
        num(0.18),
        Missing(NotApplicable),
        Missing(NotApplicable),
        Missing(NotApplicable),
        Missing(NotApplicable),
        List(List(C1)),
        $str("1s1"),
        List(C1)),
    List(
        C2,
        $str("He"),
        $str("Helium"),
        $str("helium"),
        $str("s"),
        ZZ(18L),
        C1,
        $str("NobleGas"),
        C4,
        ZZ(1868L),
        Missing(NotApplicable),
        num(0.18),
        num(0.95),
        num(-272.2),
        num(4.22),
        num(-268.93),
        ZZ(5193L),
        num(0.01),
        num(0.08),
        Missing(NotApplicable),
        C0,
        Missing(NotApplicable),
        Missing(NotApplicable),
        Missing(NotApplicable),
        ZZ(31L),
        ZZ(140L),
        ZZ(32L),
        List(num(2372.3), num(5250.5)),
        Missing(NotApplicable),
        num(0.15),
        Missing(NotApplicable),
        Missing(NotApplicable),
        Missing(NotApplicable),
        Missing(NotApplicable),
        List(List(C2)),
        $str("1s2"),
        List(C2)),
    List(
        C3,
        $str("Li"),
        $str("Lithium"),
        $str("lithium"),
        $str("s"),
        C1,
        C2,
        $str("AlkaliMetal"),
        num(6.94),
        ZZ(1817L),
        ZZ(512L),
        ZZ(534L),
        num(453.85),
        num(180.7),
        ZZ(1615L),
        num(1341.85),
        ZZ(3582L),
        C3,
        num(147.1),
        num(0.98),
        C0,
        num(0.6),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(145L),
        ZZ(182L),
        ZZ(134L),
        List(num(520.2), num(7298.1), num(11815.0)),
        num(59.62),
        num(84.8),
        num(4.9),
        Missing(NotApplicable),
        ZZ(11L),
        num(4.2),
        List(List(C2), List(C1)),
        $str("1s2 2s1"),
        List(C2, C1)),
    List(
        C4,
        $str("Be"),
        $str("Beryllium"),
        $str("beryllium"),
        $str("s"),
        C2,
        C2,
        $str("AlkalineEarthMetal"),
        num(9.01),
        ZZ(1798L),
        ZZ(1690L),
        ZZ(1850L),
        num(1560.15),
        ZZ(1287L),
        ZZ(2742L),
        num(2468.85),
        ZZ(1825L),
        num(7.9),
        ZZ(297L),
        num(1.57),
        C0,
        num(5.5),
        ZZ(1670L),
        ZZ(600L),
        ZZ(105L),
        Missing(NotAvailable),
        ZZ(90L),
        List(num(899.5), num(1757.1), num(14848.7), num(21006.6)),
        Missing(NotApplicable),
        ZZ(200L),
        ZZ(287L),
        num(0.03),
        ZZ(130L),
        ZZ(132L),
        List(List(C2), List(C2)),
        $str("1s2 2s2"),
        List(C2, C2)),
    List(
        C5,
        $str("B"),
        $str("Boron"),
        $str("boron"),
        $str("p"),
        ZZ(13L),
        C2,
        $str("Metalloid"),
        num(10.8),
        ZZ(1808L),
        ZZ(2080L),
        ZZ(2340L),
        num(2573.15),
        ZZ(2300L),
        ZZ(4200L),
        num(3926.85),
        ZZ(1026L),
        num(50.2),
        ZZ(480L),
        num(2.04),
        C0,
        num(9.5),
        ZZ(49000L),
        Missing(NotAvailable),
        ZZ(85L),
        Missing(NotAvailable),
        ZZ(82L),
        List(num(800.6), num(2427.1), num(3659.7), num(25025.8), num(32826.7)),
        num(26.99),
        num(27.4),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(185L),
        Missing(NotAvailable),
        List(List(C2), List(C2, C1)),
        $str("1s2 2s2 2p1"),
        List(C2, C3)),
    List(
        C6,
        $str("C"),
        $str("Carbon"),
        $str("carbon"),
        $str("p"),
        ZZ(14L),
        C2,
        $str("Nonmetal"),
        num(12.01),
        ZZ(-3500L),
        Missing(NotAvailable),
        ZZ(2267L),
        ZZ(3915L),
        num(3641.85),
        ZZ(3915L),
        num(3641.85),
        ZZ(709L),
        ZZ(117L),
        Missing(NotApplicable),
        num(2.55),
        C0,
        num(1.5),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(70L),
        ZZ(170L),
        ZZ(77L),
        List(num(1086.5), num(2352.6), num(4620.5), num(6222.7), ZZ(37831L), num(47277.0)),
        num(121.78),
        ZZ(140L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(33L),
        Missing(NotAvailable),
        List(List(C2), List(C2, C2)),
        $str("1s2 2s2 2p2"),
        List(C2, C4)),
    List(
        C7,
        $str("N"),
        $str("Nitrogen"),
        $str("nitrogen"),
        $str("p"),
        ZZ(15L),
        C2,
        $str("Nonmetal"),
        num(14.01),
        ZZ(1772L),
        Missing(NotAvailable),
        num(1.25),
        num(63.29),
        num(-209.86),
        num(77.36),
        num(-195.79),
        ZZ(1040L),
        num(0.72),
        num(5.57),
        num(3.04),
        C0,
        Missing(NotApplicable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(65L),
        ZZ(155L),
        ZZ(75L),
        List(
            num(1402.3),
            ZZ(2856L),
            num(4578.1),
            num(7475.0),
            num(9444.9),
            num(53266.6),
            ZZ(64360L)),
        Missing(NotAvailable),
        num(0.03),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C3)),
        $str("1s2 2s2 2p3"),
        List(C2, C5)),
    List(
        C8,
        $str("O"),
        $str("Oxygen"),
        $str("oxygen"),
        $str("p"),
        ZZ(16L),
        C2,
        $str("Nonmetal"),
        ZZ(16L),
        ZZ(1771L),
        Missing(NotAvailable),
        num(1.43),
        num(50.5),
        num(-222.65),
        num(90.2),
        num(-182.95),
        ZZ(918L),
        num(0.44),
        num(6.82),
        num(3.44),
        num(0.46),
        Missing(NotApplicable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(60L),
        ZZ(152L),
        ZZ(73L),
        List(
            num(1313.9),
            num(3388.3),
            num(5300.5),
            num(7469.2),
            num(10989.5),
            num(13326.5),
            ZZ(71330L),
            num(84078.0)),
        ZZ(141L),
        num(0.03),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C4)),
        $str("1s2 2s2 2p4"),
        List(C2, C6)),
    List(
        C9,
        $str("F"),
        $str("Fluorine"),
        $str("fluorine"),
        $str("p"),
        ZZ(17L),
        C2,
        $str("Halogen"),
        ZZ(19L),
        ZZ(1886L),
        Missing(NotAvailable),
        num(1.7),
        num(53.63),
        num(-219.52),
        num(85.03),
        num(-188.12),
        ZZ(824L),
        num(0.51),
        num(6.62),
        num(3.98),
        C0,
        Missing(NotApplicable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(50L),
        ZZ(147L),
        ZZ(71L),
        List(
            num(1681.0),
            num(3374.2),
            num(6050.4),
            num(8407.7),
            num(11022.7),
            num(15164.1),
            ZZ(17868L),
            num(92038.1),
            num(106434.3)),
        num(328.17),
        num(0.03),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C5)),
        $str("1s2 2s2 2p5"),
        List(C2, C7)),
    List(
        C10,
        $str("Ne"),
        $str("Neon"),
        $str("neon"),
        $str("p"),
        ZZ(18L),
        C2,
        $str("NobleGas"),
        num(20.18),
        ZZ(1898L),
        Missing(NotAvailable),
        num(0.9),
        num(24.7),
        num(-248.45),
        num(27.07),
        num(-246.08),
        ZZ(1030L),
        num(0.34),
        num(1.71),
        Missing(NotApplicable),
        C0,
        Missing(NotApplicable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(38L),
        ZZ(154L),
        ZZ(69L),
        List(
            num(2080.7),
            num(3952.3),
            ZZ(6122L),
            ZZ(9371L),
            ZZ(12177L),
            ZZ(15238L),
            num(19999.0),
            num(23069.5),
            num(115379.5),
            ZZ(131432L)),
        Missing(NotAvailable),
        num(0.05),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6)),
        $str("1s2 2s2 2p6"),
        List(C2, C8)),
    List(
        ZZ(11L),
        $str("Na"),
        $str("Sodium"),
        $str("sodium"),
        $str("s"),
        C1,
        C3,
        $str("AlkaliMetal"),
        num(22.99),
        ZZ(1807L),
        ZZ(927L),
        ZZ(971L),
        num(371.15),
        ZZ(98L),
        ZZ(1156L),
        num(882.85),
        ZZ(1228L),
        num(2.6),
        num(97.42),
        num(0.93),
        num(0.02),
        num(0.5),
        Missing(NotAvailable),
        num(0.69),
        ZZ(180L),
        ZZ(227L),
        ZZ(154L),
        List(
            num(495.8),
            ZZ(4562L),
            num(6910.3),
            ZZ(9543L),
            ZZ(13354L),
            ZZ(16613L),
            ZZ(20117L),
            ZZ(25496L),
            ZZ(28932L),
            ZZ(141362L),
            ZZ(159076L)),
        num(52.87),
        ZZ(142L),
        C10,
        Missing(NotApplicable),
        num(6.3),
        num(3.3),
        List(List(C2), List(C2, C6), List(C1)),
        $str("[Ne] 3s1"),
        List(C2, C8, C1)),
    List(
        ZZ(12L),
        $str("Mg"),
        $str("Magnesium"),
        $str("magnesium"),
        $str("s"),
        C2,
        C3,
        $str("AlkalineEarthMetal"),
        num(24.31),
        ZZ(1755L),
        ZZ(1584L),
        ZZ(1738L),
        num(923.15),
        ZZ(650L),
        ZZ(1363L),
        num(1089.85),
        ZZ(1023L),
        num(8.48),
        ZZ(128L),
        num(1.31),
        num(0.02),
        num(2.5),
        Missing(NotAvailable),
        ZZ(260L),
        ZZ(150L),
        ZZ(173L),
        ZZ(130L),
        List(
            num(737.7),
            num(1450.7),
            num(7732.7),
            num(10542.5),
            ZZ(13630L),
            ZZ(18020L),
            ZZ(21711L),
            ZZ(25661L),
            ZZ(31653L),
            ZZ(35458L),
            ZZ(169988L),
            ZZ(189368L)),
        Missing(NotAvailable),
        ZZ(156L),
        ZZ(45L),
        num(0.29),
        ZZ(45L),
        ZZ(17L),
        List(List(C2), List(C2, C6), List(C2)),
        $str("[Ne] 3s2"),
        List(C2, C8, C2)),
    List(
        ZZ(13L),
        $str("Al"),
        $str("Aluminium"),
        $str("aluminium"),
        $str("p"),
        ZZ(13L),
        C3,
        $str("PoorMetal"),
        num(26.98),
        ZZ(1825L),
        ZZ(2375L),
        ZZ(2698L),
        num(933.4),
        num(660.25),
        ZZ(2792L),
        num(2518.85),
        ZZ(897L),
        num(10.71),
        ZZ(294L),
        num(1.61),
        num(0.08),
        C3,
        ZZ(167L),
        ZZ(245L),
        ZZ(125L),
        Missing(NotAvailable),
        ZZ(118L),
        List(
            num(577.5),
            num(1816.7),
            num(2744.8),
            ZZ(11577L),
            ZZ(14842L),
            ZZ(18379L),
            ZZ(23326L),
            ZZ(27465L),
            ZZ(31853L),
            ZZ(38473L),
            ZZ(42647L),
            ZZ(201266L),
            ZZ(222316L)),
        num(41.86),
        ZZ(237L),
        ZZ(70L),
        Missing(NotAvailable),
        ZZ(76L),
        ZZ(26L),
        List(List(C2), List(C2, C6), List(C2, C1)),
        $str("[Ne] 3s2 3p1"),
        List(C2, C8, C3)),
    List(
        ZZ(14L),
        $str("Si"),
        $str("Silicon"),
        $str("silicon"),
        $str("p"),
        ZZ(14L),
        C3,
        $str("Metalloid"),
        num(28.09),
        ZZ(1824L),
        ZZ(2570L),
        num(2329.6),
        num(1683.15),
        ZZ(1410L),
        ZZ(3538L),
        num(3264.85),
        ZZ(705L),
        num(50.21),
        ZZ(359L),
        num(1.9),
        num(0.28),
        num(6.5),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(110L),
        ZZ(210L),
        ZZ(111L),
        List(
            num(786.5),
            num(1577.1),
            num(3231.6),
            num(4355.5),
            ZZ(16091L),
            ZZ(19805L),
            ZZ(23780L),
            ZZ(29287L),
            ZZ(33878L),
            ZZ(38726L),
            ZZ(45962L),
            ZZ(50502L),
            ZZ(235196L),
            ZZ(257923L)),
        num(134.07),
        ZZ(149L),
        ZZ(47L),
        Missing(NotAvailable),
        ZZ(100L),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C2)),
        $str("[Ne] 3s2 3p2"),
        List(C2, C8, C4)),
    List(
        ZZ(15L),
        $str("P"),
        $str("Phosphorus"),
        $str("phosphorus"),
        $str("p"),
        ZZ(15L),
        C3,
        $str("Nonmetal"),
        num(30.97),
        ZZ(1669L),
        Missing(NotAvailable),
        ZZ(1820L),
        num(317.25),
        num(44.1),
        ZZ(553L),
        num(279.85),
        ZZ(769L),
        num(0.66),
        num(12.4),
        num(2.19),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(100L),
        ZZ(180L),
        ZZ(106L),
        List(
            num(1011.8),
            ZZ(1907L),
            num(2914.1),
            num(4963.6),
            num(6273.9),
            ZZ(21267L),
            ZZ(25431L),
            ZZ(29872L),
            ZZ(35905L),
            ZZ(40950L),
            ZZ(46261L),
            ZZ(54110L),
            ZZ(59024L),
            ZZ(271791L),
            ZZ(296195L)),
        num(72.03),
        num(0.24),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(11L),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C3)),
        $str("[Ne] 3s2 3p3"),
        List(C2, C8, C5)),
    List(
        ZZ(16L),
        $str("S"),
        $str("Sulfur"),
        $str("sulfur"),
        $str("p"),
        ZZ(16L),
        C3,
        $str("Nonmetal"),
        num(32.07),
        ZZ(-2000L),
        ZZ(1819L),
        ZZ(2067L),
        num(388.51),
        num(115.36),
        num(717.8),
        num(444.65),
        ZZ(710L),
        num(1.73),
        ZZ(45L),
        num(2.58),
        C0,
        C2,
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(100L),
        ZZ(180L),
        ZZ(102L),
        List(
            num(999.6),
            ZZ(2252L),
            ZZ(3357L),
            ZZ(4556L),
            num(7004.3),
            num(8495.8),
            ZZ(27107L),
            ZZ(31719L),
            ZZ(36621L),
            ZZ(43177L),
            ZZ(48710L),
            ZZ(54460L),
            ZZ(62930L),
            ZZ(68216L),
            ZZ(311048L),
            ZZ(337138L)),
        num(200.41),
        num(0.21),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(7.7),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C4)),
        $str("[Ne] 3s2 3p4"),
        List(C2, C8, C6)),
    List(
        ZZ(17L),
        $str("Cl"),
        $str("Chlorine"),
        $str("chlorine"),
        $str("p"),
        ZZ(17L),
        C3,
        $str("Halogen"),
        num(35.45),
        ZZ(1774L),
        num(1564.9),
        num(3.21),
        num(172.31),
        num(-100.84),
        num(239.11),
        num(-34.04),
        ZZ(479L),
        num(6.41),
        num(20.41),
        num(3.16),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(100L),
        ZZ(175L),
        ZZ(99L),
        List(
            num(1251.2),
            ZZ(2298L),
            ZZ(3822L),
            num(5158.6),
            ZZ(6542L),
            ZZ(9362L),
            ZZ(11018L),
            ZZ(33604L),
            ZZ(38600L),
            ZZ(43961L),
            ZZ(51068L),
            ZZ(57119L),
            ZZ(63363L),
            ZZ(72341L),
            ZZ(78095L),
            ZZ(352994L),
            ZZ(380760L)),
        ZZ(349L),
        num(0.01),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotApplicable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C5)),
        $str("[Ne] 3s2 3p5"),
        List(C2, C8, C7)),
    List(
        ZZ(18L),
        $str("Ar"),
        $str("Argon"),
        $str("argon"),
        $str("p"),
        ZZ(18L),
        C3,
        $str("NobleGas"),
        num(39.95),
        ZZ(1894L),
        Missing(NotAvailable),
        num(1.78),
        num(83.96),
        num(-189.19),
        num(87.3),
        num(-185.85),
        ZZ(520L),
        num(1.18),
        num(6.43),
        Missing(NotApplicable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(71L),
        ZZ(188L),
        ZZ(97L),
        List(
            num(1520.6),
            num(2665.8),
            ZZ(3931L),
            ZZ(5771L),
            ZZ(7238L),
            ZZ(8781L),
            ZZ(11995L),
            ZZ(13842L),
            ZZ(40760L),
            ZZ(46186L),
            ZZ(52002L),
            ZZ(59653L),
            ZZ(66199L),
            ZZ(72918L),
            ZZ(82473L),
            ZZ(88576L),
            ZZ(397605L),
            ZZ(427066L)),
        Missing(NotAvailable),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6)),
        $str("[Ne] 3s2 3p6"),
        List(C2, C8, C8)),
    List(
        ZZ(19L),
        $str("K"),
        $str("Potassium"),
        $str("potassium"),
        $str("s"),
        C1,
        C4,
        $str("AlkaliMetal"),
        num(39.1),
        ZZ(1807L),
        ZZ(828L),
        ZZ(862L),
        num(336.5),
        num(63.35),
        ZZ(1032L),
        num(758.85),
        ZZ(757L),
        num(2.32),
        num(76.9),
        num(0.82),
        num(0.02),
        num(0.4),
        Missing(NotAvailable),
        num(0.36),
        ZZ(220L),
        ZZ(275L),
        ZZ(196L),
        List(
            num(418.8),
            ZZ(3052L),
            ZZ(4420L),
            ZZ(5877L),
            ZZ(7975L),
            ZZ(9590L),
            ZZ(11343L),
            ZZ(14944L),
            num(16963.7),
            ZZ(48610L),
            ZZ(54490L),
            ZZ(60730L),
            ZZ(68950L),
            ZZ(75900L),
            ZZ(83080L),
            ZZ(93400L),
            ZZ(99710L),
            ZZ(444880L),
            ZZ(476063L)),
        num(48.38),
        num(102.5),
        Missing(NotAvailable),
        Missing(NotAvailable),
        num(3.1),
        num(1.3),
        List(List(C2), List(C2, C6), List(C2, C6), List(C1)),
        $str("[Ar] 4s1"),
        List(C2, C8, C8, C1)),
    List(
        ZZ(20L),
        $str("Ca"),
        $str("Calcium"),
        $str("calcium"),
        $str("s"),
        C2,
        C4,
        $str("AlkalineEarthMetal"),
        num(40.08),
        ZZ(1808L),
        ZZ(1378L),
        ZZ(1540L),
        num(1112.15),
        ZZ(839L),
        ZZ(1757L),
        num(1483.85),
        ZZ(647L),
        num(8.54),
        num(154.7),
        C1,
        num(0.04),
        num(1.5),
        Missing(NotAvailable),
        ZZ(167L),
        ZZ(180L),
        Missing(NotAvailable),
        ZZ(174L),
        List(
            num(589.8),
            num(1145.4),
            num(4912.4),
            ZZ(6491L),
            ZZ(8153L),
            ZZ(10496L),
            ZZ(12270L),
            ZZ(14206L),
            ZZ(18191L),
            ZZ(20385L),
            ZZ(57110L),
            ZZ(63410L),
            ZZ(70110L),
            ZZ(78890L),
            ZZ(86310L),
            ZZ(94000L),
            ZZ(104900L),
            ZZ(111711L),
            ZZ(494850L),
            ZZ(527762L)),
        num(2.37),
        ZZ(201L),
        ZZ(20L),
        num(0.31),
        ZZ(17L),
        num(7.4),
        List(List(C2), List(C2, C6), List(C2, C6), List(C2)),
        $str("[Ar] 4s2"),
        List(C2, C8, C8, C2)),
    List(
        ZZ(21L),
        $str("Sc"),
        $str("Scandium"),
        $str("scandium"),
        $str("d"),
        C3,
        C4,
        $str("TransitionMetal"),
        num(44.96),
        ZZ(1879L),
        ZZ(2800L),
        ZZ(2989L),
        num(1812.15),
        ZZ(1539L),
        ZZ(3109L),
        num(2835.85),
        ZZ(568L),
        num(14.1),
        num(332.7),
        num(1.36),
        C0,
        Missing(NotApplicable),
        Missing(NotAvailable),
        ZZ(750L),
        ZZ(160L),
        Missing(NotAvailable),
        ZZ(144L),
        List(
            num(633.1),
            num(1235.0),
            num(2388.6),
            num(7090.6),
            ZZ(8843L),
            ZZ(10679L),
            ZZ(13310L),
            ZZ(15250L),
            ZZ(17370L),
            ZZ(21726L),
            ZZ(24102L),
            ZZ(66320L),
            ZZ(73010L),
            ZZ(80160L),
            ZZ(89490L),
            ZZ(97400L),
            ZZ(105600L),
            ZZ(117000L),
            ZZ(124270L),
            ZZ(547530L),
            ZZ(582163L)),
        ZZ(18L),
        num(15.8),
        num(74.4),
        num(0.28),
        num(56.6),
        num(29.1),
        List(List(C2), List(C2, C6), List(C2, C6, C1), List(C2)),
        $str("[Ar] 3d1 4s2"),
        List(C2, C8, C9, C2)),
    List(
        ZZ(22L),
        $str("Ti"),
        $str("Titanium"),
        $str("titanium"),
        $str("d"),
        C4,
        C4,
        $str("TransitionMetal"),
        num(47.87),
        ZZ(1791L),
        ZZ(4110L),
        ZZ(4540L),
        num(1933.15),
        ZZ(1660L),
        ZZ(3560L),
        num(3286.85),
        ZZ(523L),
        num(14.15),
        ZZ(425L),
        num(1.54),
        num(0.01),
        C6,
        ZZ(970L),
        ZZ(716L),
        ZZ(140L),
        Missing(NotAvailable),
        ZZ(136L),
        List(
            num(658.8),
            num(1309.8),
            num(2652.5),
            num(4174.6),
            ZZ(9581L),
            ZZ(11533L),
            ZZ(13590L),
            ZZ(16440L),
            ZZ(18530L),
            ZZ(20833L),
            ZZ(25575L),
            ZZ(28125L),
            ZZ(76015L),
            ZZ(83280L),
            ZZ(90880L),
            ZZ(100700L),
            ZZ(109100L),
            ZZ(117800L),
            ZZ(129900L),
            ZZ(137530L),
            ZZ(602930L),
            ZZ(639294L)),
        num(8.4),
        num(21.9),
        ZZ(116L),
        num(0.32),
        ZZ(110L),
        ZZ(44L),
        List(List(C2), List(C2, C6), List(C2, C6, C2), List(C2)),
        $str("[Ar] 3d2 4s2"),
        List(C2, C8, C10, C2)),
    List(
        ZZ(23L),
        $str("V"),
        $str("Vanadium"),
        $str("vanadium"),
        $str("d"),
        C5,
        C4,
        $str("TransitionMetal"),
        num(50.94),
        ZZ(1801L),
        ZZ(5500L),
        ZZ(6110L),
        num(2175.15),
        ZZ(1902L),
        ZZ(3680L),
        num(3406.85),
        ZZ(489L),
        num(21.5),
        ZZ(459L),
        num(1.63),
        C0,
        C7,
        ZZ(628L),
        ZZ(628L),
        ZZ(135L),
        Missing(NotAvailable),
        ZZ(125L),
        List(
            num(650.9),
            ZZ(1414L),
            ZZ(2830L),
            ZZ(4507L),
            num(6298.7),
            ZZ(12363L),
            ZZ(14530L),
            ZZ(16730L),
            ZZ(19860L),
            ZZ(22240L),
            ZZ(24670L),
            ZZ(29730L),
            ZZ(32446L),
            ZZ(86450L),
            ZZ(94170L),
            ZZ(102300L),
            ZZ(112700L),
            ZZ(121600L),
            ZZ(130700L),
            ZZ(143400L),
            ZZ(151440L),
            ZZ(661050L),
            ZZ(699144L)),
        ZZ(51L),
        num(30.7),
        ZZ(128L),
        num(0.37),
        ZZ(160L),
        ZZ(47L),
        List(List(C2), List(C2, C6), List(C2, C6, C3), List(C2)),
        $str("[Ar] 3d3 4s2"),
        List(C2, C8, ZZ(11L), C2)),
    List(
        ZZ(24L),
        $str("Cr"),
        $str("Chromium"),
        $str("chromium"),
        $str("d"),
        C6,
        C4,
        $str("TransitionMetal"),
        ZZ(52L),
        C0,
        ZZ(6300L),
        ZZ(7150L),
        num(2130.15),
        ZZ(1857L),
        ZZ(2944L),
        num(2670.85),
        ZZ(449L),
        ZZ(21L),
        num(339.5),
        num(1.66),
        C0,
        num(8.5),
        ZZ(1060L),
        ZZ(1120L),
        ZZ(140L),
        Missing(NotAvailable),
        ZZ(127L),
        List(
            num(652.9),
            num(1590.6),
            ZZ(2987L),
            ZZ(4743L),
            ZZ(6702L),
            num(8744.9),
            ZZ(15455L),
            ZZ(17820L),
            ZZ(20190L),
            ZZ(23580L),
            ZZ(26130L),
            ZZ(28750L),
            ZZ(34230L),
            ZZ(37066L),
            ZZ(97510L),
            ZZ(105800L),
            ZZ(114300L),
            ZZ(125300L),
            ZZ(134700L),
            ZZ(144300L),
            ZZ(157700L),
            ZZ(166090L),
            ZZ(721870L),
            ZZ(761733L)),
        num(65.2),
        num(93.9),
        ZZ(279L),
        num(0.21),
        ZZ(160L),
        ZZ(115L),
        List(List(C2), List(C2, C6), List(C2, C6, C5), List(C1)),
        $str("[Ar] 3d5 4s1"),
        List(C2, C8, ZZ(13L), C1)),
    List(
        ZZ(25L),
        $str("Mn"),
        $str("Manganese"),
        $str("manganese"),
        $str("d"),
        C7,
        C4,
        $str("TransitionMetal"),
        num(54.94),
        ZZ(1770L),
        ZZ(5950L),
        ZZ(7440L),
        num(1519.15),
        ZZ(1246L),
        ZZ(2334L),
        num(2060.85),
        ZZ(479L),
        num(12.91),
        ZZ(221L),
        num(1.55),
        C0,
        C6,
        Missing(NotAvailable),
        ZZ(196L),
        ZZ(140L),
        Missing(NotAvailable),
        ZZ(139L),
        List(
            num(717.3),
            num(1509.0),
            ZZ(3248L),
            ZZ(4940L),
            ZZ(6990L),
            ZZ(9220L),
            ZZ(11500L),
            ZZ(18770L),
            ZZ(21400L),
            ZZ(23960L),
            ZZ(27590L),
            ZZ(30330L),
            ZZ(33150L),
            ZZ(38880L),
            ZZ(41987L),
            ZZ(109480L),
            ZZ(118100L),
            ZZ(127100L),
            ZZ(138600L),
            ZZ(148500L),
            ZZ(158600L),
            ZZ(172500L),
            ZZ(181380L),
            ZZ(785450L),
            ZZ(827067L)),
        Missing(NotAvailable),
        num(7.81),
        ZZ(198L),
        Missing(NotAvailable),
        ZZ(120L),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C5), List(C2)),
        $str("[Ar] 3d5 4s2"),
        List(C2, C8, ZZ(13L), C2)),
    List(
        ZZ(26L),
        $str("Fe"),
        $str("Iron"),
        $str("iron"),
        $str("d"),
        C8,
        C4,
        $str("TransitionMetal"),
        num(55.85),
        ZZ(-5000L),
        ZZ(6980L),
        ZZ(7874L),
        num(1808.15),
        ZZ(1535L),
        ZZ(3134L),
        num(2860.85),
        ZZ(449L),
        num(13.81),
        ZZ(340L),
        num(1.83),
        num(0.06),
        C4,
        ZZ(608L),
        ZZ(490L),
        ZZ(140L),
        Missing(NotAvailable),
        ZZ(125L),
        List(
            num(762.5),
            num(1561.9),
            ZZ(2957L),
            ZZ(5290L),
            ZZ(7240L),
            ZZ(9560L),
            ZZ(12060L),
            ZZ(14580L),
            ZZ(22540L),
            ZZ(25290L),
            ZZ(28000L),
            ZZ(31920L),
            ZZ(34830L),
            ZZ(37840L),
            ZZ(44100L),
            ZZ(47206L),
            ZZ(122200L),
            ZZ(131000L),
            ZZ(140500L),
            ZZ(152600L),
            ZZ(163000L),
            ZZ(173600L),
            ZZ(188100L),
            ZZ(195200L),
            ZZ(851800L),
            ZZ(895161L)),
        num(14.6),
        num(80.4),
        ZZ(211L),
        num(0.29),
        ZZ(170L),
        ZZ(82L),
        List(List(C2), List(C2, C6), List(C2, C6, C6), List(C2)),
        $str("[Ar] 3d6 4s2"),
        List(C2, C8, ZZ(14L), C2)),
    List(
        ZZ(27L),
        $str("Co"),
        $str("Cobalt"),
        $str("cobalt"),
        $str("d"),
        C9,
        C4,
        $str("TransitionMetal"),
        num(58.93),
        ZZ(1732L),
        ZZ(7750L),
        ZZ(8860L),
        num(1768.15),
        ZZ(1495L),
        ZZ(3200L),
        num(2926.85),
        ZZ(421L),
        num(16.06),
        ZZ(377L),
        num(1.88),
        C0,
        C5,
        ZZ(1043L),
        ZZ(700L),
        ZZ(135L),
        ZZ(163L),
        ZZ(121L),
        List(
            num(760.4),
            ZZ(1648L),
            ZZ(3232L),
            ZZ(4950L),
            ZZ(7670L),
            ZZ(9840L),
            ZZ(12440L),
            ZZ(15230L),
            ZZ(17959L),
            ZZ(26570L),
            ZZ(29400L),
            ZZ(32400L),
            ZZ(36600L),
            ZZ(39700L),
            ZZ(42800L),
            ZZ(49396L),
            ZZ(52737L),
            ZZ(134810L),
            ZZ(145170L),
            ZZ(154700L),
            ZZ(167400L),
            ZZ(178100L),
            ZZ(189300L),
            ZZ(204500L),
            ZZ(214100L),
            ZZ(920870L),
            ZZ(966023L)),
        ZZ(64L),
        ZZ(100L),
        ZZ(209L),
        num(0.31),
        ZZ(180L),
        ZZ(75L),
        List(List(C2), List(C2, C6), List(C2, C6, C7), List(C2)),
        $str("[Ar] 3d7 4s2"),
        List(C2, C8, ZZ(15L), C2)),
    List(
        ZZ(28L),
        $str("Ni"),
        $str("Nickel"),
        $str("nickel"),
        $str("d"),
        C10,
        C4,
        $str("TransitionMetal"),
        num(58.69),
        ZZ(1751L),
        ZZ(7810L),
        ZZ(8912L),
        num(1726.15),
        ZZ(1453L),
        ZZ(3186L),
        num(2912.85),
        ZZ(444L),
        num(17.48),
        num(377.5),
        num(1.91),
        C0,
        C4,
        ZZ(638L),
        ZZ(700L),
        ZZ(135L),
        Missing(NotAvailable),
        ZZ(126L),
        List(
            num(737.1),
            num(1753.0),
            ZZ(3395L),
            ZZ(5300L),
            ZZ(7339L),
            ZZ(10400L),
            ZZ(12800L),
            ZZ(15600L),
            ZZ(18600L),
            ZZ(21670L),
            ZZ(30970L),
            ZZ(34000L),
            ZZ(37100L),
            ZZ(41500L),
            ZZ(44800L),
            ZZ(48100L),
            ZZ(55101L),
            ZZ(58570L),
            ZZ(148700L),
            ZZ(159000L),
            ZZ(169400L),
            ZZ(182700L),
            ZZ(194000L),
            ZZ(205600L),
            ZZ(221400L),
            ZZ(231490L),
            ZZ(992718L),
            ZZ(1039668L)),
        num(111.6),
        num(90.9),
        ZZ(200L),
        num(0.31),
        ZZ(180L),
        ZZ(76L),
        List(List(C2), List(C2, C6), List(C2, C6, C8), List(C2)),
        $str("[Ar] 3d8 4s2"),
        List(C2, C8, ZZ(16L), C2)),
    List(
        ZZ(29L),
        $str("Cu"),
        $str("Copper"),
        $str("copper"),
        $str("d"),
        ZZ(11L),
        C4,
        $str("TransitionMetal"),
        num(63.55),
        ZZ(-9000L),
        ZZ(8020L),
        ZZ(8960L),
        num(1357.75),
        num(1084.6),
        ZZ(2835L),
        num(2561.85),
        ZZ(385L),
        num(13.26),
        num(300.4),
        num(1.9),
        C0,
        C3,
        ZZ(369L),
        ZZ(874L),
        ZZ(135L),
        ZZ(140L),
        ZZ(138L),
        List(
            num(745.5),
            num(1957.9),
            ZZ(3555L),
            ZZ(5536L),
            ZZ(7700L),
            ZZ(9900L),
            ZZ(13400L),
            ZZ(16000L),
            ZZ(19200L),
            ZZ(22400L),
            ZZ(25600L),
            ZZ(35600L),
            ZZ(38700L),
            ZZ(42000L),
            ZZ(46700L),
            ZZ(50200L),
            ZZ(53700L),
            ZZ(61100L),
            ZZ(64702L),
            ZZ(163700L),
            ZZ(174100L),
            ZZ(184900L),
            ZZ(198800L),
            ZZ(210500L),
            ZZ(222700L),
            ZZ(239100L),
            ZZ(249660L),
            ZZ(1067358L),
            ZZ(1116105L)),
        num(119.24),
        ZZ(401L),
        ZZ(130L),
        num(0.34),
        ZZ(140L),
        ZZ(48L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C1)),
        $str("[Ar] 3d10 4s1"),
        List(C2, C8, ZZ(18L), C1)),
    List(
        ZZ(30L),
        $str("Zn"),
        $str("Zinc"),
        $str("zinc"),
        $str("d"),
        ZZ(12L),
        C4,
        $str("TransitionMetal"),
        num(65.38),
        ZZ(-1000L),
        ZZ(6570L),
        ZZ(7134L),
        num(692.88),
        num(419.73),
        ZZ(1180L),
        num(906.85),
        ZZ(388L),
        num(7.32),
        num(123.6),
        num(1.65),
        C0,
        num(2.5),
        Missing(NotAvailable),
        ZZ(412L),
        ZZ(135L),
        ZZ(139L),
        ZZ(131L),
        List(
            num(906.4),
            num(1733.3),
            ZZ(3833L),
            ZZ(5731L),
            ZZ(7970L),
            ZZ(10400L),
            ZZ(12900L),
            ZZ(16800L),
            ZZ(19600L),
            ZZ(23000L),
            ZZ(26400L),
            ZZ(29990L),
            ZZ(40490L),
            ZZ(43800L),
            ZZ(47300L),
            ZZ(52300L),
            ZZ(55900L),
            ZZ(59700L),
            ZZ(67300L),
            ZZ(71200L),
            ZZ(179100L)),
        Missing(NotAvailable),
        ZZ(116L),
        ZZ(108L),
        num(0.25),
        ZZ(70L),
        ZZ(43L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2)),
        $str("[Ar] 3d10 4s2"),
        List(C2, C8, ZZ(18L), C2)),
    List(
        ZZ(31L),
        $str("Ga"),
        $str("Gallium"),
        $str("gallium"),
        $str("p"),
        ZZ(13L),
        C4,
        $str("PoorMetal"),
        num(69.72),
        ZZ(1875L),
        ZZ(6095L),
        ZZ(5907L),
        num(302.91),
        num(29.76),
        ZZ(2477L),
        num(2203.85),
        ZZ(371L),
        num(5.59),
        ZZ(254L),
        num(1.81),
        C0,
        num(1.5),
        Missing(NotAvailable),
        ZZ(60L),
        ZZ(130L),
        ZZ(187L),
        ZZ(126L),
        List(num(578.8), num(1979.3), ZZ(2963L), ZZ(6180L)),
        ZZ(41L),
        num(40.6),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(22L),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C1)),
        $str("[Ar] 3d10 4s2 4p1"),
        List(C2, C8, ZZ(18L), C3)),
    List(
        ZZ(32L),
        $str("Ge"),
        $str("Germanium"),
        $str("germanium"),
        $str("p"),
        ZZ(14L),
        C4,
        $str("Metalloid"),
        num(72.63),
        ZZ(1886L),
        ZZ(5600L),
        ZZ(5323L),
        num(1211.45),
        num(938.3),
        ZZ(3106L),
        num(2832.85),
        ZZ(320L),
        num(36.94),
        ZZ(334L),
        num(2.01),
        C0,
        C6,
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(125L),
        Missing(NotAvailable),
        ZZ(122L),
        List(ZZ(762L), num(1537.5), num(3302.1), ZZ(4411L), ZZ(9020L)),
        num(118.94),
        num(60.2),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C2)),
        $str("[Ar] 3d10 4s2 4p2"),
        List(C2, C8, ZZ(18L), C4)),
    List(
        ZZ(33L),
        $str("As"),
        $str("Arsenic"),
        $str("arsenic"),
        $str("p"),
        ZZ(15L),
        C4,
        $str("Metalloid"),
        num(74.92),
        ZZ(1250L),
        ZZ(5220L),
        ZZ(5776L),
        num(1090.15),
        ZZ(817L),
        ZZ(887L),
        num(613.85),
        ZZ(329L),
        num(24.44),
        Missing(NotApplicable),
        num(2.18),
        C0,
        num(3.5),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(115L),
        ZZ(185L),
        ZZ(119L),
        List(num(947.0), ZZ(1798L), ZZ(2735L), ZZ(4837L), ZZ(6043L), ZZ(12310L)),
        num(78.5),
        num(50.2),
        C8,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C3)),
        $str("[Ar] 3d10 4s2 4p3"),
        List(C2, C8, ZZ(18L), C5)),
    List(
        ZZ(34L),
        $str("Se"),
        $str("Selenium"),
        $str("selenium"),
        $str("p"),
        ZZ(16L),
        C4,
        $str("Nonmetal"),
        num(78.96),
        ZZ(1817L),
        ZZ(3990L),
        ZZ(4809L),
        num(494.15),
        ZZ(221L),
        ZZ(958L),
        num(684.85),
        ZZ(321L),
        num(6.69),
        num(95.48),
        num(2.55),
        C0,
        C2,
        Missing(NotAvailable),
        ZZ(736L),
        ZZ(115L),
        ZZ(190L),
        ZZ(116L),
        List(num(941.0), ZZ(2045L), num(2973.7), ZZ(4144L), ZZ(6590L), ZZ(7880L), ZZ(14990L)),
        num(194.97),
        num(0.52),
        C10,
        num(0.33),
        num(8.3),
        num(3.7),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C4)),
        $str("[Ar] 3d10 4s2 4p4"),
        List(C2, C8, ZZ(18L), C6)),
    List(
        ZZ(35L),
        $str("Br"),
        $str("Bromine"),
        $str("bromine"),
        $str("p"),
        ZZ(17L),
        C4,
        $str("Halogen"),
        num(79.9),
        ZZ(1825L),
        num(3102.8),
        ZZ(3122L),
        num(266.05),
        num(-7.1),
        ZZ(332L),
        num(58.85),
        ZZ(474L),
        num(10.57),
        num(29.96),
        num(2.96),
        C0,
        Missing(NotApplicable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(115L),
        ZZ(185L),
        ZZ(114L),
        List(
            num(1139.9),
            ZZ(2103L),
            ZZ(3470L),
            ZZ(4560L),
            ZZ(5760L),
            ZZ(8550L),
            ZZ(9940L),
            ZZ(18600L)),
        num(342.54),
        num(0.12),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C5)),
        $str("[Ar] 3d10 4s2 4p5"),
        List(C2, C8, ZZ(18L), C7)),
    List(
        ZZ(36L),
        $str("Kr"),
        $str("Krypton"),
        $str("krypton"),
        $str("p"),
        ZZ(18L),
        C4,
        $str("NobleGas"),
        num(83.8),
        ZZ(1898L),
        Missing(NotAvailable),
        num(3.73),
        num(115.93),
        num(-157.22),
        num(119.93),
        num(-153.22),
        ZZ(248L),
        num(1.64),
        num(9.08),
        C3,
        C0,
        Missing(NotApplicable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(88L),
        ZZ(202L),
        ZZ(110L),
        List(
            num(1350.8),
            num(2350.4),
            ZZ(3565L),
            ZZ(5070L),
            ZZ(6240L),
            ZZ(7570L),
            ZZ(10710L),
            ZZ(12138L),
            ZZ(22274L),
            ZZ(25880L),
            ZZ(29700L),
            ZZ(33800L),
            ZZ(37700L),
            ZZ(43100L),
            ZZ(47500L),
            ZZ(52200L),
            ZZ(57100L),
            ZZ(61800L),
            ZZ(75800L),
            ZZ(80400L),
            ZZ(85300L),
            ZZ(90400L),
            ZZ(96300L),
            ZZ(101400L),
            ZZ(111100L),
            ZZ(116290L),
            ZZ(282500L),
            ZZ(296200L),
            ZZ(311400L),
            ZZ(326200L)),
        Missing(NotAvailable),
        num(0.01),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6)),
        $str("[Ar] 3d10 4s2 4p6"),
        List(C2, C8, ZZ(18L), C8)),
    List(
        ZZ(37L),
        $str("Rb"),
        $str("Rubidium"),
        $str("rubidium"),
        $str("s"),
        C1,
        C5,
        $str("AlkaliMetal"),
        num(85.47),
        ZZ(1861L),
        ZZ(1460L),
        ZZ(1532L),
        num(312.79),
        num(39.64),
        ZZ(961L),
        num(687.85),
        ZZ(363L),
        num(2.19),
        num(75.77),
        num(0.82),
        C0,
        num(0.3),
        Missing(NotAvailable),
        num(0.22),
        ZZ(235L),
        Missing(NotAvailable),
        ZZ(211L),
        List(
            num(403.0),
            ZZ(2633L),
            ZZ(3860L),
            ZZ(5080L),
            ZZ(6850L),
            ZZ(8140L),
            ZZ(9570L),
            ZZ(13120L),
            ZZ(14500L),
            ZZ(26740L)),
        num(46.89),
        num(58.2),
        num(2.4),
        Missing(NotAvailable),
        num(2.5),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6), List(C1)),
        $str("[Kr] 5s1"),
        List(C2, C8, ZZ(18L), C8, C1)),
    List(
        ZZ(38L),
        $str("Sr"),
        $str("Strontium"),
        $str("strontium"),
        $str("s"),
        C2,
        C5,
        $str("AlkalineEarthMetal"),
        num(87.62),
        ZZ(1787L),
        ZZ(6980L),
        ZZ(2640L),
        num(1042.15),
        ZZ(769L),
        ZZ(1655L),
        num(1381.85),
        ZZ(301L),
        num(7.43),
        num(136.9),
        num(0.95),
        C0,
        num(1.5),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(200L),
        Missing(NotAvailable),
        ZZ(192L),
        List(
            num(549.5),
            num(1064.2),
            ZZ(4138L),
            ZZ(5500L),
            ZZ(6910L),
            ZZ(8760L),
            ZZ(10230L),
            ZZ(11800L),
            ZZ(15600L),
            ZZ(17100L),
            ZZ(31270L)),
        num(5.02),
        num(35.4),
        Missing(NotAvailable),
        num(0.28),
        Missing(NotAvailable),
        num(6.1),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6), List(C2)),
        $str("[Kr] 5s2"),
        List(C2, C8, ZZ(18L), C8, C2)),
    List(
        ZZ(39L),
        $str("Y"),
        $str("Yttrium"),
        $str("yttrium"),
        $str("d"),
        C3,
        C5,
        $str("TransitionMetal"),
        num(88.91),
        ZZ(1794L),
        ZZ(4240L),
        ZZ(4469L),
        num(1799.15),
        ZZ(1526L),
        ZZ(3609L),
        num(3335.85),
        ZZ(298L),
        num(11.42),
        ZZ(365L),
        num(1.22),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(589L),
        ZZ(180L),
        Missing(NotAvailable),
        ZZ(162L),
        List(
            ZZ(600L),
            ZZ(1180L),
            ZZ(1980L),
            ZZ(5847L),
            ZZ(7430L),
            ZZ(8970L),
            ZZ(11190L),
            ZZ(12450L),
            ZZ(14110L),
            ZZ(18400L),
            ZZ(19900L),
            ZZ(36090L)),
        ZZ(30L),
        num(17.2),
        ZZ(64L),
        num(0.24),
        num(41.2),
        num(25.6),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C1), List(C2)),
        $str("[Kr] 4d1 5s2"),
        List(C2, C8, ZZ(18L), C9, C2)),
    List(
        ZZ(40L),
        $str("Zr"),
        $str("Zirconium"),
        $str("zirconium"),
        $str("d"),
        C4,
        C5,
        $str("TransitionMetal"),
        num(91.22),
        ZZ(1789L),
        ZZ(5800L),
        ZZ(6506L),
        num(2125.15),
        ZZ(1852L),
        ZZ(4682L),
        num(4408.85),
        ZZ(278L),
        ZZ(14L),
        ZZ(573L),
        num(1.33),
        C0,
        C5,
        ZZ(903L),
        ZZ(650L),
        ZZ(155L),
        Missing(NotAvailable),
        ZZ(148L),
        List(num(640.1), ZZ(1270L), ZZ(2218L), ZZ(3313L), ZZ(7752L), ZZ(9500L)),
        ZZ(41L),
        num(22.6),
        ZZ(68L),
        num(0.34),
        ZZ(33L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C2), List(C2)),
        $str("[Kr] 4d2 5s2"),
        List(C2, C8, ZZ(18L), C10, C2)),
    List(
        ZZ(41L),
        $str("Nb"),
        $str("Niobium"),
        $str("niobium"),
        $str("d"),
        C5,
        C5,
        $str("TransitionMetal"),
        num(92.91),
        ZZ(1801L),
        Missing(NotAvailable),
        ZZ(8570L),
        num(2741.15),
        ZZ(2468L),
        ZZ(5017L),
        num(4743.85),
        ZZ(265L),
        ZZ(30L),
        num(689.9),
        num(1.6),
        C0,
        C6,
        ZZ(1320L),
        ZZ(736L),
        ZZ(145L),
        Missing(NotAvailable),
        ZZ(137L),
        List(num(652.1), ZZ(1380L), ZZ(2416L), ZZ(3700L), ZZ(4877L), ZZ(9847L), ZZ(12100L)),
        ZZ(86L),
        num(53.7),
        ZZ(105L),
        num(0.4),
        ZZ(170L),
        ZZ(38L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C4), List(C1)),
        $str("[Kr] 4d45s1"),
        List(C2, C8, ZZ(18L), ZZ(12L), C1)),
    List(
        ZZ(42L),
        $str("Mo"),
        $str("Molybdenum"),
        $str("molybdenum"),
        $str("d"),
        C6,
        C5,
        $str("TransitionMetal"),
        num(95.96),
        ZZ(1778L),
        ZZ(9330L),
        ZZ(10220L),
        num(2890.15),
        ZZ(2617L),
        ZZ(4912L),
        num(4638.85),
        ZZ(251L),
        num(37.48),
        ZZ(617L),
        num(2.16),
        C0,
        num(5.5),
        ZZ(1530L),
        ZZ(1500L),
        ZZ(145L),
        Missing(NotAvailable),
        ZZ(145L),
        List(
            num(684.3),
            ZZ(1560L),
            ZZ(2618L),
            ZZ(4480L),
            ZZ(5257L),
            num(6640.8),
            ZZ(12125L),
            ZZ(13860L),
            ZZ(15835L),
            ZZ(17980L),
            ZZ(20190L),
            ZZ(22219L),
            ZZ(26930L),
            ZZ(29196L),
            ZZ(52490L),
            ZZ(55000L),
            ZZ(61400L),
            ZZ(67700L),
            ZZ(74000L),
            ZZ(80400L),
            ZZ(87000L),
            ZZ(93400L),
            ZZ(98420L),
            ZZ(104400L),
            ZZ(121900L),
            ZZ(127700L),
            ZZ(133800L),
            ZZ(139800L),
            ZZ(148100L),
            ZZ(154500L)),
        num(72.3),
        ZZ(138L),
        ZZ(329L),
        num(0.31),
        ZZ(230L),
        ZZ(120L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C5), List(C1)),
        $str("[Kr] 4d5 5s1"),
        List(C2, C8, ZZ(18L), ZZ(13L), C1)),
    List(
        ZZ(43L),
        $str("Tc"),
        $str("Technetium"),
        $str("technetium"),
        $str("d"),
        C7,
        C5,
        $str("TransitionMetal"),
        ZZ(98L),
        ZZ(1937L),
        Missing(NotAvailable),
        ZZ(11500L),
        num(2473.15),
        ZZ(2200L),
        ZZ(5150L),
        num(4876.85),
        Missing(NotAvailable),
        num(33.29),
        num(585.2),
        num(1.9),
        C0,
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(135L),
        Missing(NotAvailable),
        ZZ(156L),
        List(ZZ(702L), ZZ(1470L), ZZ(2850L)),
        Missing(NotAvailable),
        num(50.6),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C5), List(C2)),
        $str("[Kr] 4d5 5s2"),
        List(C2, C8, ZZ(18L), ZZ(13L), C2)),
    List(
        ZZ(44L),
        $str("Ru"),
        $str("Ruthenium"),
        $str("ruthenium"),
        $str("d"),
        C8,
        C5,
        $str("TransitionMetal"),
        num(101.07),
        ZZ(1807L),
        ZZ(10650L),
        ZZ(12370L),
        num(2523.15),
        ZZ(2250L),
        ZZ(4423L),
        num(4149.85),
        ZZ(238L),
        num(38.59),
        num(591.6),
        num(2.2),
        C0,
        num(6.5),
        Missing(NotAvailable),
        ZZ(2160L),
        ZZ(130L),
        Missing(NotAvailable),
        ZZ(126L),
        List(num(710.2), ZZ(1620L), ZZ(2747L)),
        ZZ(101L),
        ZZ(117L),
        ZZ(447L),
        num(0.3),
        ZZ(220L),
        ZZ(173L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C7), List(C1)),
        $str("[Kr] 4d7 5s1"),
        List(C2, C8, ZZ(18L), ZZ(15L), C1)),
    List(
        ZZ(45L),
        $str("Rh"),
        $str("Rhodium"),
        $str("rhodium"),
        $str("d"),
        C9,
        C5,
        $str("TransitionMetal"),
        num(102.91),
        ZZ(1804L),
        ZZ(10700L),
        ZZ(12410L),
        num(2239.15),
        ZZ(1966L),
        ZZ(3968L),
        num(3694.85),
        ZZ(243L),
        num(26.59),
        ZZ(494L),
        num(2.28),
        C0,
        C6,
        ZZ(1246L),
        ZZ(1100L),
        ZZ(135L),
        Missing(NotAvailable),
        ZZ(135L),
        List(num(719.7), ZZ(1740L), ZZ(2997L)),
        num(110.3),
        ZZ(150L),
        ZZ(275L),
        num(0.26),
        ZZ(380L),
        ZZ(150L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C8), List(C1)),
        $str("[Kr] 4d8 5s1"),
        List(C2, C8, ZZ(18L), ZZ(16L), C1)),
    List(
        ZZ(46L),
        $str("Pd"),
        $str("Palladium"),
        $str("palladium"),
        $str("d"),
        C10,
        C5,
        $str("TransitionMetal"),
        num(106.42),
        ZZ(1803L),
        ZZ(10380L),
        ZZ(12020L),
        num(1825.15),
        ZZ(1552L),
        ZZ(3236L),
        num(2962.85),
        ZZ(244L),
        num(16.74),
        ZZ(362L),
        num(2.2),
        C0,
        C5,
        ZZ(461L),
        num(37.3),
        ZZ(140L),
        ZZ(163L),
        ZZ(131L),
        List(num(804.4), ZZ(1870L), ZZ(3177L)),
        num(54.24),
        num(71.8),
        ZZ(121L),
        num(0.39),
        ZZ(180L),
        ZZ(44L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10)),
        $str("[Kr] 4d10"),
        List(C2, C8, ZZ(18L), ZZ(18L))),
    List(
        ZZ(47L),
        $str("Ag"),
        $str("Silver"),
        $str("silver"),
        $str("d"),
        ZZ(11L),
        C5,
        $str("TransitionMetal"),
        num(107.87),
        ZZ(-5000L),
        ZZ(9320L),
        ZZ(10501L),
        num(1234.15),
        ZZ(961L),
        ZZ(2435L),
        num(2161.85),
        ZZ(235L),
        num(11.28),
        ZZ(258L),
        num(1.93),
        C0,
        num(2.5),
        ZZ(251L),
        num(24.5),
        ZZ(160L),
        ZZ(172L),
        ZZ(153L),
        List(num(731.0), ZZ(2070L), ZZ(3361L)),
        num(125.86),
        ZZ(429L),
        ZZ(83L),
        num(0.37),
        ZZ(100L),
        ZZ(30L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C1)),
        $str("[Kr] 4d10 5s1"),
        List(C2, C8, ZZ(18L), ZZ(18L), C1)),
    List(
        ZZ(48L),
        $str("Cd"),
        $str("Cadmium"),
        $str("cadmium"),
        $str("d"),
        ZZ(12L),
        C5,
        $str("TransitionMetal"),
        num(112.41),
        ZZ(1817L),
        ZZ(7996L),
        ZZ(8690L),
        num(594.33),
        num(321.18),
        ZZ(1040L),
        num(766.85),
        ZZ(232L),
        num(6.21),
        num(99.87),
        num(1.69),
        C0,
        C2,
        Missing(NotAvailable),
        ZZ(203L),
        ZZ(155L),
        ZZ(158L),
        ZZ(148L),
        List(num(867.8), num(1631.4), ZZ(3616L)),
        Missing(NotAvailable),
        num(96.6),
        ZZ(50L),
        num(0.3),
        ZZ(42L),
        ZZ(19L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2)),
        $str("[Kr] 4d10 5s2"),
        List(C2, C8, ZZ(18L), ZZ(18L), C2)),
    List(
        ZZ(49L),
        $str("In"),
        $str("Indium"),
        $str("indium"),
        $str("p"),
        ZZ(13L),
        C5,
        $str("PoorMetal"),
        num(114.82),
        ZZ(1863L),
        ZZ(7020L),
        ZZ(7310L),
        num(429.91),
        num(156.76),
        ZZ(2345L),
        num(2071.85),
        ZZ(233L),
        num(3.28),
        num(231.8),
        num(1.78),
        C0,
        C1,
        Missing(NotAvailable),
        num(8.83),
        ZZ(155L),
        ZZ(193L),
        ZZ(144L),
        List(num(558.3), num(1820.7), ZZ(2704L), ZZ(5210L)),
        ZZ(39L),
        num(81.8),
        ZZ(11L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2, C1)),
        $str("[Kr] 4d10 5s2 5p1"),
        List(C2, C8, ZZ(18L), ZZ(18L), C3)),
    List(
        ZZ(50L),
        $str("Sn"),
        $str("Tin"),
        $str("tin"),
        $str("p"),
        ZZ(14L),
        C5,
        $str("PoorMetal"),
        num(118.71),
        ZZ(-3500L),
        ZZ(6990L),
        ZZ(7287L),
        num(505.21),
        num(232.06),
        ZZ(2875L),
        num(2601.85),
        ZZ(228L),
        num(7.03),
        num(296.1),
        num(1.96),
        C0,
        num(1.5),
        Missing(NotAvailable),
        num(5.1),
        ZZ(145L),
        ZZ(217L),
        ZZ(141L),
        List(num(708.6), num(1411.8), num(2943.0), num(3930.3), ZZ(7456L)),
        num(107.3),
        num(66.8),
        ZZ(50L),
        num(0.36),
        ZZ(58L),
        ZZ(18L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2, C2)),
        $str("[Kr] 4d10 5s2 5p2"),
        List(C2, C8, ZZ(18L), ZZ(18L), C4)),
    List(
        ZZ(51L),
        $str("Sb"),
        $str("Antimony"),
        $str("antimony"),
        $str("p"),
        ZZ(15L),
        C5,
        $str("Metalloid"),
        num(121.76),
        ZZ(-3000L),
        ZZ(6530L),
        ZZ(6685L),
        num(904.05),
        num(630.9),
        ZZ(1860L),
        num(1586.85),
        ZZ(207L),
        num(19.79),
        num(193.43),
        num(2.05),
        C0,
        C3,
        Missing(NotAvailable),
        ZZ(294L),
        ZZ(145L),
        Missing(NotAvailable),
        ZZ(138L),
        List(ZZ(834L), num(1594.9), ZZ(2440L), ZZ(4260L), ZZ(5400L), ZZ(10400L)),
        num(101.06),
        num(24.4),
        ZZ(55L),
        Missing(NotAvailable),
        ZZ(42L),
        ZZ(20L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2, C3)),
        $str("[Kr] 4d10 5s2 5p3"),
        List(C2, C8, ZZ(18L), ZZ(18L), C5)),
    List(
        ZZ(52L),
        $str("Te"),
        $str("Tellurium"),
        $str("tellurium"),
        $str("p"),
        ZZ(16L),
        C5,
        $str("Metalloid"),
        num(127.6),
        ZZ(1782L),
        ZZ(5700L),
        ZZ(6232L),
        num(722.8),
        num(449.65),
        ZZ(1261L),
        num(987.85),
        ZZ(202L),
        num(17.49),
        num(114.1),
        num(2.1),
        C0,
        C2,
        Missing(NotAvailable),
        ZZ(18L),
        ZZ(140L),
        ZZ(206L),
        ZZ(135L),
        List(num(869.3), ZZ(1790L), ZZ(2698L), ZZ(3610L), ZZ(5668L), ZZ(6820L), ZZ(13200L)),
        num(190.16),
        C3,
        ZZ(43L),
        Missing(NotAvailable),
        ZZ(65L),
        ZZ(16L),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2, C4)),
        $str("[Kr] 4d10 5s2 5p4"),
        List(C2, C8, ZZ(18L), ZZ(18L), C6)),
    List(
        ZZ(53L),
        $str("I"),
        $str("Iodine"),
        $str("iodine"),
        $str("p"),
        ZZ(17L),
        C5,
        $str("Halogen"),
        num(126.9),
        ZZ(1811L),
        Missing(NotAvailable),
        ZZ(4930L),
        num(386.65),
        num(113.5),
        num(457.4),
        num(184.25),
        ZZ(214L),
        num(15.52),
        num(41.57),
        num(2.66),
        C0,
        Missing(NotApplicable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(140L),
        ZZ(198L),
        ZZ(133L),
        List(num(1008.4), num(1845.9), ZZ(3180L)),
        ZZ(295L),
        num(0.45),
        num(1.7),
        Missing(NotAvailable),
        num(7.7),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2, C5)),
        $str("[Kr] 4d10 5s2 5p5"),
        List(C2, C8, ZZ(18L), ZZ(18L), C7)),
    List(
        ZZ(54L),
        $str("Xe"),
        $str("Xenon"),
        $str("xenon"),
        $str("p"),
        ZZ(18L),
        C5,
        $str("NobleGas"),
        num(131.29),
        ZZ(1898L),
        Missing(NotAvailable),
        num(5.89),
        num(161.45),
        num(-111.7),
        num(165.03),
        num(-108.12),
        ZZ(158L),
        num(2.27),
        num(12.64),
        num(2.6),
        C0,
        Missing(NotApplicable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(108L),
        ZZ(216L),
        ZZ(130L),
        List(num(1170.4), num(2046.4), num(3099.4)),
        Missing(NotAvailable),
        num(0.01),
        ZZ(13L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2, C6)),
        $str("[Kr] 4d10 5s2 5p6"),
        List(C2, C8, ZZ(18L), ZZ(18L), C8)),
    List(
        ZZ(55L),
        $str("Cs"),
        $str("Caesium"),
        $str("caesium"),
        $str("s"),
        C1,
        C6,
        $str("AlkaliMetal"),
        num(132.91),
        ZZ(1860L),
        ZZ(1843L),
        ZZ(1873L),
        num(301.7),
        num(28.55),
        ZZ(944L),
        num(670.85),
        ZZ(242L),
        num(2.09),
        num(63.9),
        num(0.79),
        C0,
        num(0.2),
        Missing(NotAvailable),
        num(0.14),
        ZZ(260L),
        Missing(NotAvailable),
        ZZ(225L),
        List(num(375.7), num(2234.3), ZZ(3400L)),
        num(45.51),
        num(35.9),
        ZZ(37L),
        Missing(NotAvailable),
        num(1.6),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2, C6), List(C1)),
        $str("[Xe] 6s1"),
        List(C2, C8, ZZ(18L), ZZ(18L), C8, C1)),
    List(
        ZZ(56L),
        $str("Ba"),
        $str("Barium"),
        $str("barium"),
        $str("s"),
        C2,
        C6,
        $str("AlkalineEarthMetal"),
        num(137.33),
        ZZ(1772L),
        ZZ(3338L),
        ZZ(3594L),
        num(1002.15),
        ZZ(729L),
        ZZ(2170L),
        num(1896.85),
        ZZ(204L),
        num(7.12),
        num(140.3),
        num(0.89),
        C0,
        C1,
        Missing(NotAvailable),
        Missing(NotAvailable),
        ZZ(215L),
        Missing(NotAvailable),
        ZZ(198L),
        List(num(502.9), num(965.2), ZZ(3600L)),
        num(13.95),
        num(18.4),
        ZZ(34L),
        Missing(NotAvailable),
        num(9.6),
        num(4.9),
        List(List(C2), List(C2, C6), List(C2, C6, C10), List(C2, C6, C10), List(C2, C6), List(C2)),
        $str("[Xe] 6s2"),
        List(C2, C8, ZZ(18L), ZZ(18L), C8, C2)),
    List(
        ZZ(57L),
        $str("La"),
        $str("Lanthanum"),
        $str("lanthanum"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(138.91),
        ZZ(1838L),
        ZZ(5940L),
        ZZ(6145L),
        num(1193.15),
        ZZ(920L),
        ZZ(3737L),
        num(3463.85),
        ZZ(195L),
        num(6.2),
        num(402.1),
        num(1.1),
        C0,
        num(2.5),
        ZZ(491L),
        ZZ(363L),
        ZZ(195L),
        Missing(NotAvailable),
        ZZ(169L),
        List(num(538.1), ZZ(1067L), num(1850.3), ZZ(4819L), ZZ(5940L)),
        ZZ(45L),
        num(13.4),
        ZZ(37L),
        num(0.28),
        num(27.9),
        num(14.3),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10),
            List(C2, C6, C1),
            List(C2)),
        $str("[Xe] 5d16s2"),
        List(C2, C8, ZZ(18L), ZZ(18L), C9, C2)),
    List(
        ZZ(58L),
        $str("Ce"),
        $str("Cerium"),
        $str("cerium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(140.12),
        ZZ(1803L),
        ZZ(6550L),
        ZZ(6770L),
        num(1071.15),
        ZZ(798L),
        ZZ(3716L),
        num(3442.85),
        ZZ(192L),
        num(5.46),
        ZZ(398L),
        num(1.12),
        C0,
        num(2.5),
        ZZ(270L),
        ZZ(412L),
        ZZ(185L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(num(534.4), ZZ(1050L), ZZ(1949L), ZZ(3547L), ZZ(6325L), ZZ(7490L)),
        ZZ(92L),
        num(11.3),
        ZZ(41L),
        num(0.24),
        num(21.5),
        num(13.5),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C1),
            List(C2, C6, C1),
            List(C2)),
        $str("[Xe] 4f1 5d1 6s2"),
        List(C2, C8, ZZ(18L), ZZ(19L), C9, C2)),
    List(
        ZZ(59L),
        $str("Pr"),
        $str("Praseodymium"),
        $str("praseodymium"),
        $str("f"),
        Missing(NotApplicable),
        C6,
        $str("Lanthanide"),
        num(140.91),
        ZZ(1885L),
        ZZ(6500L),
        ZZ(6773L),
        num(1204.15),
        ZZ(931L),
        ZZ(3793L),
        num(3519.85),
        ZZ(193L),
        num(6.89),
        ZZ(331L),
        num(1.13),
        C0,
        Missing(NotAvailable),
        ZZ(400L),
        ZZ(481L),
        ZZ(185L),
        Missing(NotAvailable),
        Missing(NotAvailable),
        List(ZZ(527L), ZZ(1020L), ZZ(2086L), ZZ(3761L), ZZ(5551L)),
        Missing(NotAvailable),
        num(12.5),
        ZZ(46L),
        num(0.28),
        num(28.8),
        num(14.8),
        List(
            List(C2),
            List(C2, C6),
            List(C2, C6, C10),
            List(C2, C6, C10, C3),
            List(C2, C6),
            List(C2)),
        $str("[Xe] 4f3 6s2"),
        List(C2, C8, ZZ(18L), ZZ(21L), C8, C2)),
  };
}
