package org.matheclipse.api;

import java.util.ArrayList;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.parser.trie.Trie;
import org.matheclipse.parser.trie.TrieBuilder;
import org.matheclipse.parser.trie.TrieMatch;

public class STEM {

  public static final Object[] STEMS =
      new Object[] { //
        "abort", F.Abort, //
        "absarg", F.AbsArg, //
        "accumul", F.Accumulate, //
        "addto", F.AddTo, //
        "adjacencymatrix", F.AdjacencyMatrix, //
        "airyai", F.AiryAi, //
        "airyaiprim", F.AiryAiPrime, //
        "airybi", F.AiryBi, //
        "airybiprim", F.AiryBiPrime, //
        "alltru", F.AllTrue, //
        "altern", F.Alternatives, //
        "anglevector", F.AngleVector, //
        "annuiti", F.Annuity, //
        "annuitydu", F.AnnuityDue, //
        "antihermitianmatrixq", F.AntihermitianMatrixQ, //
        "antisymmetricmatrixq", F.AntisymmetricMatrixQ, //
        "anytru", F.AnyTrue, //
        "apart", F.Apart, //
        "append", F.Append, //
        "appendto", F.AppendTo, //
        "appli", F.Apply, //
        "arcco", F.ArcCos, //
        "arccosh", F.ArcCosh, //
        "arccot", F.ArcCot, //
        "arccoth", F.ArcCoth, //
        "arccsc", F.ArcCsc, //
        "arccsch", F.ArcCsch, //
        "arcsec", F.ArcSec, //
        "arcsech", F.ArcSech, //
        "arcsin", F.ArcSin, //
        "arcsinh", F.ArcSinh, //
        "arctan", F.ArcTan, //
        "arctanh", F.ArcTanh, //
        "argmax", F.ArgMax, //
        "argmin", F.ArgMin, //
        "arithmeticgeometricmean", F.ArithmeticGeometricMean, //
        "arrai", F.Array, //
        "arraydepth", F.ArrayDepth, //
        "arraypad", F.ArrayPad, //
        "arrayq", F.ArrayQ, //
        "arrayreshap", F.ArrayReshape, //
        "associ", F.Association, //
        "associationq", F.AssociationQ, //
        "atomq", F.AtomQ, //
        "attribut", F.Attributes, //
        "baseform", F.BaseForm, //
        "begin", F.Begin, //
        "beginpackag", F.BeginPackage, //
        "bellb", F.BellB, //
        "belli", F.BellY, //
        "bernoullib", F.BernoulliB, //
        "bernoullidistribut", F.BernoulliDistribution, //
        "bess", F.BesselI, //
        "besselj", F.BesselJ, //
        "besseljzero", F.BesselJZero, //
        "besselk", F.BesselK, //
        "bess", F.BesselY, //
        "besselyzero", F.BesselYZero, //
        "beta", F.Beta, //
        "binarydeseri", F.BinaryDeserialize, //
        "binaryseri", F.BinarySerialize, //
        "bincount", F.BinCounts, //
        "binomi", F.Binomial, //
        "binomialdistribut", F.BinomialDistribution, //
        "bitlength", F.BitLength, //
        "block", F.Block, //
        "bool", F.Boole, //
        "booleanconvert", F.BooleanConvert, //
        "booleanminim", F.BooleanMinimize, //
        "booleanq", F.BooleanQ, //
        "boolean", F.Booleans, //
        "booleant", F.BooleanTable, //
        "booleanvari", F.BooleanVariables, //
        "braycurtisdist", F.BrayCurtisDistance, //
        "break", F.Break, //
        "bytearrai", F.ByteArray, //
        "bytearrayq", F.ByteArrayQ, //
        "canberradist", F.CanberraDistance, //
        "cancel", F.Cancel, //
        "carmichaellambda", F.CarmichaelLambda, //
        "cartesianproduct", F.CartesianProduct, //
        "case", F.Cases, //
        "catalan", F.Catalan, //
        "catalannumb", F.CatalanNumber, //
        "caten", F.Catenate, //
        "ceil", F.Ceiling, //
        "centralmo", F.CentralMoment, //
        "characteristicpolynomi", F.CharacteristicPolynomial, //
        "chebyshevt", F.ChebyshevT, //
        "chebyshevu", F.ChebyshevU, //
        "check", F.Check, //
        "chessboarddist", F.ChessboardDistance, //
        "chineseremaind", F.ChineseRemainder, //
        "choleskydecomposit", F.CholeskyDecomposition, //
        "chop", F.Chop, //
        "circlepoint", F.CirclePoints, //
        "clear", F.Clear, //
        "clearal", F.ClearAll, //
        "clearattribut", F.ClearAttributes, //
        "clip", F.Clip, //
        "coeffici", F.Coefficient, //
        "coefficientlist", F.CoefficientList, //
        "coefficientrul", F.CoefficientRules, //
        "collect", F.Collect, //
        "complement", F.Complement, //
        "complex", F.Complex, //
        "complex", F.Complexes, //
        "complexexpand", F.ComplexExpand, //
        "complexinfin", F.ComplexInfinity, //
        "complexplot3d", F.ComplexPlot3D, //
        "composelist", F.ComposeList, //
        "composeseri", F.ComposeSeries, //
        "composit", F.Composition, //
        "compoundexpress", F.CompoundExpression, //
        "condit", F.Condition, //
        "conditionalexpress", F.ConditionalExpression, //
        "conjug", F.Conjugate, //
        "conjugatetranspos", F.ConjugateTranspose, //
        "constant", F.Constant, //
        "constantarrai", F.ConstantArray, //
        "containsonli", F.ContainsOnly, //
        "context", F.Context, //
        "continu", F.Continue, //
        "continuedfract", F.ContinuedFraction, //
        "converg", F.Convergents, //
        "coprimeq", F.CoprimeQ, //
        "correl", F.Correlation, //
        "cosh", F.Cosh, //
        "coshintegr", F.CoshIntegral, //
        "cosinedist", F.CosineDistance, //
        "cosintegr", F.CosIntegral, //
        "coth", F.Coth, //
        "count", F.Count, //
        "count", F.Counts, //
        "covari", F.Covariance, //
        "cross", F.Cross, //
        "csch", F.Csch, //
        "cuberoot", F.CubeRoot, //
        "curl", F.Curl, //
        "cyclotom", F.Cyclotomic, //
        "decrement", F.Decrement, //
        "default", F.Default, //
        "defer", F.Defer, //
        "definit", F.Definition, //
        "degre", F.Degree, //
        "delet", F.Delete, //
        "deletecas", F.DeleteCases, //
        "deletedupl", F.DeleteDuplicates, //
        "denomin", F.Denominator, //
        "depth", F.Depth, //
        "deriv", F.Derivative, //
        "designmatrix", F.DesignMatrix, //
        "diagon", F.Diagonal, //
        "diagonalmatrix", F.DiagonalMatrix, //
        "dialoginput", F.DialogInput, //
        "dicedissimilar", F.DiceDissimilarity, //
        "digitcount", F.DigitCount, //
        "digitq", F.DigitQ, //
        "dimens", F.Dimensions, //
        "diracdelta", F.DiracDelta, //
        "directedinfin", F.DirectedInfinity, //
        "discretedelta", F.DiscreteDelta, //
        "discreteuniformdistribut", F.DiscreteUniformDistribution, //
        "discrimin", F.Discriminant, //
        "distribut", F.Distribute, //
        "divid", F.Divide, //
        "dividebi", F.DivideBy, //
        "divis", F.Divisible, //
        "divisor", F.Divisors, //
        "divisorsigma", F.DivisorSigma, //
        "divisorsum", F.DivisorSum, //
        "drop", F.Drop, //
        "dsolv", F.DSolve, //
        "edgelist", F.EdgeList, //
        "edgeq", F.EdgeQ, //
        "effectiveinterest", F.EffectiveInterest, //
        "eigenvalu", F.Eigenvalues, //
        "eigenvector", F.Eigenvectors, //
        "element", F.Element, //
        "elementdata", F.ElementData, //
        "elimin", F.Eliminate, //
        "elliptic", F.EllipticE, //
        "ellipticf", F.EllipticF, //
        "elliptick", F.EllipticK, //
        "ellipticpi", F.EllipticPi, //
        "endpackag", F.EndPackage, //
        "equal", F.Equal, //
        "equival", F.Equivalent, //
        "erfc", F.Erfc, //
        "erfi", F.Erfi, //
        "erlangdistribut", F.ErlangDistribution, //
        "euclideandist", F.EuclideanDistance, //
        "euler", F.EulerE, //
        "eulergamma", F.EulerGamma, //
        "euleriangraphq", F.EulerianGraphQ, //
        "eulerphi", F.EulerPhi, //
        "evalu", F.Evaluate, //
        "evenq", F.EvenQ, //
        "exactnumberq", F.ExactNumberQ, //
        "except", F.Except, //
        "expand", F.Expand, //
        "expandal", F.ExpandAll, //
        "expect", F.Expectation, //
        "expintegral", F.ExpIntegralE, //
        "expintegralei", F.ExpIntegralEi, //
        "expon", F.Exponent, //
        "exponentialdistribut", F.ExponentialDistribution, //
        "export", F.Export, //
        "extendedgcd", F.ExtendedGCD, //
        "extract", F.Extract, //
        "factor", F.Factor, //
        "factori", F.Factorial, //
        "factorial2", F.Factorial2, //
        "factorinteg", F.FactorInteger, //
        "factorsquarefre", F.FactorSquareFree, //
        "factorsquarefreelist", F.FactorSquareFreeList, //
        "factorterm", F.FactorTerms, //
        "fals", S.False, //
        "fibonacci", F.Fibonacci, //
        "findeuleriancycl", F.FindEulerianCycle, //
        "findfit", F.FindFit, //
        "findhamiltoniancycl", F.FindHamiltonianCycle, //
        "findinst", F.FindInstance, //
        "findroot", F.FindRoot, //
        "findshortestpath", F.FindShortestPath, //
        "findshortesttour", F.FindShortestTour, //
        "findspanningtre", F.FindSpanningTree, //
        "findvertexcov", F.FindVertexCover, //
        "first", F.First, //
        "fivenum", F.FiveNum, //
        "fixedpoint", F.FixedPoint, //
        "fixedpointlist", F.FixedPointList, //
        "flat", F.Flat, //
        "flatten", F.Flatten, //
        "flattenat", F.FlattenAt, //
        "floor", F.Floor, //
        "fold", F.Fold, //
        "foldlist", F.FoldList, //
        "fourier", F.Fourier, //
        "fouriermatrix", F.FourierMatrix, //
        "fractionalpart", F.FractionalPart, //
        "frechetdistribut", F.FrechetDistribution, //
        "freeq", F.FreeQ, //
        "frobeniusnumb", F.FrobeniusNumber, //
        "frobeniussolv", F.FrobeniusSolve, //
        "fromcharactercod", F.FromCharacterCode, //
        "fromcontinuedfract", F.FromContinuedFraction, //
        "fromdigit", F.FromDigits, //
        "frompolarcoordin", F.FromPolarCoordinates, //
        "fullform", F.FullForm, //
        "fullsimplifi", F.FullSimplify, //
        "functionexpand", F.FunctionExpand, //
        "gamma", F.Gamma, //
        "gammadistribut", F.GammaDistribution, //
        "gather", F.Gather, //
        "gatherbi", F.GatherBy, //
        "gegenbauerc", F.GegenbauerC, //
        "geodist", F.GeoDistance, //
        "geometricdistribut", F.GeometricDistribution, //
        "geometricmean", F.GeometricMean, //
        "glaisher", F.Glaisher, //
        "goldenratio", F.GoldenRatio, //
        "grad", F.Grad, //
        "graph", F.Graph, //
        "graphcent", F.GraphCenter, //
        "graphdiamet", F.GraphDiameter, //
        "graphperipheri", F.GraphPeriphery, //
        "graphq", F.GraphQ, //
        "graphradiu", F.GraphRadius, //
        "greater", F.Greater, //
        "greaterequ", F.GreaterEqual, //
        "groebnerbasi", F.GroebnerBasis, //
        "gumbeldistribut", F.GumbelDistribution, //
        "hamiltoniangraphq", F.HamiltonianGraphQ, //
        "harmonicmean", F.HarmonicMean, //
        "harmonicnumb", F.HarmonicNumber, //
        "haversin", F.Haversine, //
        "head", F.Head, //
        "heavisidetheta", F.HeavisideTheta, //
        "hermiteh", F.HermiteH, //
        "hermitianmatrixq", F.HermitianMatrixQ, //
        "hilbertmatrix", F.HilbertMatrix, //
        "hold", F.Hold, //
        "holdal", F.HoldAll, //
        "holdfirst", F.HoldFirst, //
        "holdform", F.HoldForm, //
        "holdpattern", F.HoldPattern, //
        "holdrest", F.HoldRest, //
        "hornerform", F.HornerForm, //
        "hurwitzzeta", F.HurwitzZeta, //
        "hypergeometric0f1", F.Hypergeometric0F1, //
        "hypergeometric1f1", F.Hypergeometric1F1, //
        "hypergeometric2f1", F.Hypergeometric2F1, //
        "hypergeometricdistribut", F.HypergeometricDistribution, //
        "hypergeometricpfq", F.HypergeometricPFQ, //
        "ident", F.Identity, //
        "identitymatrix", F.IdentityMatrix, //
        "impli", F.Implies, //
        "import", F.Import, //
        "increment", F.Increment, //
        "indetermin", F.Indeterminate, //
        "inexactnumberq", F.InexactNumberQ, //
        "infin", F.Infinity, //
        "inner", F.Inner, //
        "input", F.Input, //
        "inputstr", F.InputString, //
        "integ", F.Integer, //
        "integerdigit", F.IntegerDigits, //
        "integerexpon", F.IntegerExponent, //
        "integerlength", F.IntegerLength, //
        "integernam", F.IntegerName, //
        "integerpart", F.IntegerPart, //
        "integerpartit", F.IntegerPartitions, //
        "integerq", F.IntegerQ, //
        "integ", F.Integers, //
        "integr", F.Integrate, //
        "interpolatingfunct", F.InterpolatingFunction, //
        "interpolatingpolynomi", F.InterpolatingPolynomial, //
        "interrupt", F.Interrupt, //
        "intersect", F.Intersection, //
        "interv", F.Interval, //
        "invers", F.Inverse, //
        "inversecdf", F.InverseCDF, //
        "inverseerf", F.InverseErf, //
        "inverseerfc", F.InverseErfc, //
        "inversefouri", F.InverseFourier, //
        "inversefunct", F.InverseFunction, //
        "inversehaversin", F.InverseHaversine, //
        "inverselaplacetransform", F.InverseLaplaceTransform, //
        "inverseseri", F.InverseSeries, //
        "jaccarddissimilar", F.JaccardDissimilarity, //
        "jacobiamplitud", F.JacobiAmplitude, //
        "jacobicn", F.JacobiCN, //
        "jacobidn", F.JacobiDN, //
        "jacobimatrix", F.JacobiMatrix, //
        "jacobisn", F.JacobiSN, //
        "jacobisymbol", F.JacobiSymbol, //
        "javaform", F.JavaForm, //
        "join", F.Join, //
        "jsform", F.JSForm, //
        "keysort", F.KeySort, //
        "khinchin", F.Khinchin, //
        "kolmogorovsmirnovtest", F.KolmogorovSmirnovTest, //
        "kroneckerdelta", F.KroneckerDelta, //
        "kurtosi", F.Kurtosis, //
        "laguerrel", F.LaguerreL, //
        "laplacetransform", F.LaplaceTransform, //
        "last", F.Last, //
        "leafcount", F.LeafCount, //
        "leastsquar", F.LeastSquares, //
        "legendrep", F.LegendreP, //
        "legendreq", F.LegendreQ, //
        "length", F.Length, //
        "less", F.Less, //
        "lessequ", F.LessEqual, //
        "letterq", F.LetterQ, //
        "level", F.Level, //
        "levelq", F.LevelQ, //
        "limit", F.Limit, //
        "linearprogram", F.LinearProgramming, //
        "linearrecurr", F.LinearRecurrence, //
        "linearsolv", F.LinearSolve, //
        "list", F.List, //
        "listabl", F.Listable, //
        "listconvolv", F.ListConvolve, //
        "listcorrel", F.ListCorrelate, //
        "listlineplot", F.ListLinePlot, //
        "listplot", F.ListPlot, //
        "listplot3d", F.ListPlot3D, //
        "listq", F.ListQ, //
        "log10", F.Log10, //
        "log2", F.Log2, //
        "loggamma", F.LogGamma, //
        "logintegr", F.LogIntegral, //
        "logisticsigmoid", F.LogisticSigmoid, //
        "lognormaldistribut", F.LogNormalDistribution, //
        "lookup", F.Lookup, //
        "lowertriangular", F.LowerTriangularize, //
        "lucasl", F.LucasL, //
        "ludecomposit", F.LUDecomposition, //
        "machinenumberq", F.MachineNumberQ, //
        "mangoldtlambda", F.MangoldtLambda, //
        "manhattandist", F.ManhattanDistance, //
        "manipul", F.Manipulate, //
        "mapindex", F.MapIndexed, //
        "mapthread", F.MapThread, //
        "matchingdissimilar", F.MatchingDissimilarity, //
        "matchq", F.MatchQ, //
        "mathmlform", F.MathMLForm, //
        "matrixexp", F.MatrixExp, //
        "matrixminimalpolynomi", F.MatrixMinimalPolynomial, //
        "matrixpow", F.MatrixPower, //
        "matrixq", F.MatrixQ, //
        "matrixrank", F.MatrixRank, //
        "maxfilt", F.MaxFilter, //
        "maxim", F.Maximize, //
        "mean", F.Mean, //
        "meanfilt", F.MeanFilter, //
        "median", F.Median, //
        "medianfilt", F.MedianFilter, //
        "memberq", F.MemberQ, //
        "mersenneprimeexpon", F.MersennePrimeExponent, //
        "mersenneprimeexponentq", F.MersennePrimeExponentQ, //
        "messag", F.Message, //
        "messagenam", F.MessageName, //
        "minfilt", F.MinFilter, //
        "minim", F.Minimize, //
        "minu", F.Minus, //
        "missingq", F.MissingQ, //
        "modul", F.Module, //
        "moebiusmu", F.MoebiusMu, //
        "monomiallist", F.MonomialList, //
        "most", F.Most, //
        "multinomi", F.Multinomial, //
        "multiplicativeord", F.MultiplicativeOrder, //
        "nakagamidistribut", F.NakagamiDistribution, //
        "nand", F.Nand, //
        "nest", F.Nest, //
        "nestlist", F.NestList, //
        "nestwhil", F.NestWhile, //
        "nestwhilelist", F.NestWhileList, //
        "nextprim", F.NextPrime, //
        "nholdal", F.NHoldAll, //
        "nholdfirst", F.NHoldFirst, //
        "nholdrest", F.NHoldRest, //
        "nintegr", F.NIntegrate, //
        "nmaxim", F.NMaximize, //
        "nminim", F.NMinimize, //
        "none", F.None, //
        "nonetru", F.NoneTrue, //
        "nonneg", F.NonNegative, //
        "nonposit", F.NonPositive, //
        "norm", F.Norm, //
        "normal", F.Normal, //
        "normaldistribut", F.NormalDistribution, //
        "normal", F.Normalize, //
        "nroot", F.NRoots, //
        "nsolv", F.NSolve, //
        "null", F.Null, //
        "nullspac", F.NullSpace, //
        "numberq", F.NumberQ, //
        "numer", F.Numerator, //
        "numericq", F.NumericQ, //
        "oddq", F.OddQ, //
        "oneident", F.OneIdentity, //
        "oper", F.Operate, //
        "optimizeexpress", F.OptimizeExpression, //
        "option", F.Optional, //
        "order", F.Order, //
        "orderedq", F.OrderedQ, //
        "order", F.Ordering, //
        "orderless", F.Orderless, //
        "orthogon", F.Orthogonalize, //
        "orthogonalmatrixq", F.OrthogonalMatrixQ, //
        "outer", F.Outer, //
        "padleft", F.PadLeft, //
        "padright", F.PadRight, //
        "parametricplot", F.ParametricPlot, //
        "part", F.Part, //
        "partit", F.Partition, //
        "partitionsp", F.PartitionsP, //
        "partitionsq", F.PartitionsQ, //
        "patterntest", F.PatternTest, //
        "perfectnumb", F.PerfectNumber, //
        "perfectnumberq", F.PerfectNumberQ, //
        "permut", F.Permutations, //
        "piecewis", F.Piecewise, //
        "piecewiseexpand", F.PiecewiseExpand, //
        "plot", F.Plot, //
        "plot3d", F.Plot3D, //
        "pochhamm", F.Pochhammer, //
        "poissondistribut", F.PoissonDistribution, //
        "polarplot", F.PolarPlot, //
        "polygamma", F.PolyGamma, //
        "polynomialextendedgcd", F.PolynomialExtendedGCD, //
        "polynomialgcd", F.PolynomialGCD, //
        "polynomiallcm", F.PolynomialLCM, //
        "polynomialq", F.PolynomialQ, //
        "polynomialquoti", F.PolynomialQuotient, //
        "polynomialquotientremaind", F.PolynomialQuotientRemainder, //
        "polynomialremaind", F.PolynomialRemainder, //
        "posit", F.Position, //
        "posit", F.Positive, //
        "possiblezeroq", F.PossibleZeroQ, //
        "power", F.Power, //
        "powerexpand", F.PowerExpand, //
        "powermod", F.PowerMod, //
        "predecr", F.PreDecrement, //
        "preincrement", F.PreIncrement, //
        "prepend", F.Prepend, //
        "prependto", F.PrependTo, //
        "prime", F.Prime, //
        "primeomega", F.PrimeOmega, //
        "primepi", F.PrimePi, //
        "primepowerq", F.PrimePowerQ, //
        "primeq", F.PrimeQ, //
        "primitiverootlist", F.PrimitiveRootList, //
        "probabl", F.Probability, //
        "product", F.Product, //
        "productlog", F.ProductLog, //
        "project", F.Projection, //
        "pseudoinvers", F.PseudoInverse, //
        "qrdecomposit", F.QRDecomposition, //
        "quantil", F.Quantile, //
        "quantiti", F.Quantity, //
        "quantitymagnitud", F.QuantityMagnitude, //
        "quartil", F.Quartiles, //
        "quiet", F.Quiet, //
        "quotient", F.Quotient, //
        "quotientremaind", F.QuotientRemainder, //
        "ramp", F.Ramp, //
        "randomchoic", F.RandomChoice, //
        "randominteg", F.RandomInteger, //
        "randomprim", F.RandomPrime, //
        "randomr", F.RandomReal, //
        "randomsampl", F.RandomSample, //
        "rang", F.Range, //
        "ration", F.Rational, //
        "ration", F.Rationalize, //
        "real", F.Real, //
        "realnumberq", F.RealNumberQ, //
        "real", F.Reals, //
        "reap", F.Reap, //
        "refin", F.Refine, //
        "replac", F.Replace, //
        "replaceal", F.ReplaceAll, //
        "replacelist", F.ReplaceList, //
        "replacepart", F.ReplacePart, //
        "replacerep", F.ReplaceRepeated, //
        "rescal", F.Rescale, //
        "rest", F.Rest, //
        "result", F.Resultant, //
        "return", F.Return, //
        "revers", F.Reverse, //
        "riffl", F.Riffle, //
        "rogerstanimotodissimilar", F.RogersTanimotoDissimilarity, //
        "romannumer", F.RomanNumeral, //
        "root", F.Roots, //
        "rotateleft", F.RotateLeft, //
        "rotateright", F.RotateRight, //
        "rotationmatrix", F.RotationMatrix, //
        "round", F.Round, //
        "rowreduc", F.RowReduce, //
        "rule", F.Rule, //
        "ruledelai", F.RuleDelayed, //
        "russellraodissimilar", F.RussellRaoDissimilarity, //
        "sameq", F.SameQ, //
        "satisfiabilitycount", F.SatisfiabilityCount, //
        "satisfiabilityinst", F.SatisfiabilityInstances, //
        "satisfiableq", F.SatisfiableQ, //
        "scan", F.Scan, //
        "sech", F.Sech, //
        "select", F.Select, //
        "selectfirst", F.SelectFirst, //
        "semanticimport", F.SemanticImport, //
        "semanticimportstr", F.SemanticImportString, //
        "seri", F.Series, //
        "seriescoeffici", F.SeriesCoefficient, //
        "seriesdata", F.SeriesData, //
        "setattribut", F.SetAttributes, //
        "setdelai", F.SetDelayed, //
        "sign", F.Sign, //
        "simplifi", F.Simplify, //
        "sinc", F.Sinc, //
        "singularvaluedecomposit", F.SingularValueDecomposition, //
        "sinh", F.Sinh, //
        "sinhintegr", F.SinhIntegral, //
        "sinintegr", F.SinIntegral, //
        "skew", F.Skewness, //
        "slot", F.Slot, //
        "slotsequ", F.SlotSequence, //
        "sokalsneathdissimilar", F.SokalSneathDissimilarity, //
        "solv", F.Solve, //
        "sort", F.Sort, //
        "sortbi", F.SortBy, //
        "span", F.Span, //
        "sphericalbesselj", F.SphericalBesselJ, //
        "sphericalbess", F.SphericalBesselY, //
        "split", F.Split, //
        "splitbi", F.SplitBy, //
        "sqrt", F.Sqrt, //
        "squaredeuclideandist", F.SquaredEuclideanDistance, //
        "squarefreeq", F.SquareFreeQ, //
        "squarematrixq", F.SquareMatrixQ, //
        "standarddevi", F.StandardDeviation, //
        "stieltjesgamma", F.StieltjesGamma, //
        "stirlings1", F.StirlingS1, //
        "stirlings2", F.StirlingS2, //
        "stringcas", F.StringCases, //
        "stringcontainsq", F.StringContainsQ, //
        "stringjoin", F.StringJoin, //
        "stringlength", F.StringLength, //
        "stringmatchq", F.StringMatchQ, //
        "stringpart", F.StringPart, //
        "stringq", F.StringQ, //
        "stringreplac", F.StringReplace, //
        "stringsplit", F.StringSplit, //
        "struveh", F.StruveH, //
        "struvel", F.StruveL, //
        "studenttdistribut", F.StudentTDistribution, //
        "subdivid", F.Subdivide, //
        "subfactori", F.Subfactorial, //
        "subset", F.Subsets, //
        "subtract", F.Subtract, //
        "subtractfrom", F.SubtractFrom, //
        "surd", F.Surd, //
        "survivalfunct", F.SurvivalFunction, //
        "switch", F.Switch, //
        "symbol", F.Symbol, //
        "symbolnam", F.SymbolName, //
        "symbolq", F.SymbolQ, //
        "symmetricmatrixq", F.SymmetricMatrixQ, //
        "syntaxq", F.SyntaxQ, //
        "systemdialoginput", F.SystemDialogInput, //
        "tabl", F.Table, //
        "take", F.Take, //
        "tanh", F.Tanh, //
        "tautologyq", F.TautologyQ, //
        "texform", F.TeXForm, //
        "thread", F.Thread, //
        "through", F.Through, //
        "time", F.Times, //
        "timesbi", F.TimesBy, //
        "timevalu", F.TimeValue, //
        "time", F.Timing, //
        "tocharactercod", F.ToCharacterCode, //
        "toeplitzmatrix", F.ToeplitzMatrix, //
        "toexpress", F.ToExpression, //
        "togeth", F.Together, //
        "topolarcoordin", F.ToPolarCoordinates, //
        "tostr", F.ToString, //
        "total", F.Total, //
        "trace", F.Trace, //
        "transpos", F.Transpose, //
        "treeform", F.TreeForm, //
        "trigexpand", F.TrigExpand, //
        "trigreduc", F.TrigReduce, //
        "trigtoexp", F.TrigToExp, //
        "true", S.True, //
        "trueq", S.TrueQ, //
        "tupl", F.Tuples, //
        "unequ", F.Unequal, //
        "uniformdistribut", F.UniformDistribution, //
        "union", F.Union, //
        "uniqu", F.Unique, //
        "unitconvert", F.UnitConvert, //
        "unit", F.Unitize, //
        "unitstep", F.UnitStep, //
        "unitvector", F.UnitVector, //
        "unsameq", F.UnsameQ, //
        "unset", F.Unset, //
        "uppercaseq", F.UpperCaseQ, //
        "uppertriangular", F.UpperTriangularize, //
        "valueq", F.ValueQ, //
        "valu", F.Values, //
        "vandermondematrix", F.VandermondeMatrix, //
        "variabl", F.Variables, //
        "varianc", F.Variance, //
        "vectorangl", F.VectorAngle, //
        "vectorq", F.VectorQ, //
        "vertexeccentr", F.VertexEccentricity, //
        "vertexlist", F.VertexList, //
        "vertexq", F.VertexQ, //
        "weibulldistribut", F.WeibullDistribution, //
        "weierstrassp", F.WeierstrassP, //
        "which", F.Which, //
        "while", F.While, //
        "yuledissimilar", F.YuleDissimilarity, //
        "zeta", F.Zeta, //
      };

  public static final Object[] STEMS1 =
      new Object[] { //
        "convert",
        F.UnitConvert,
        "convers",
        F.UnitConvert, //
        "expand",
        F.ExpandAll,
        "expans",
        F.ExpandAll, //
        "deriv",
        F.D,
        "differenti",
        F.D, //
        "horner",
        F.HornerForm, //
        "mathml",
        F.MathMLForm, //
        "simplif",
        F.FullSimplify,
        "simplifi",
        F.FullSimplify, //
        "solver",
        F.Solve, //
        "tex",
        F.TeXForm, //
        "tree",
        F.TreeForm, //
      };

  public static final TrieBuilder<String, IBuiltInSymbol, ArrayList<IBuiltInSymbol>> builder =
      TrieBuilder.create();
  public static final Trie<String, IBuiltInSymbol> STEM_MAP =
      builder.withMatch(TrieMatch.EXACT).build(); // Tries.forStrings();

  static {
    for (int i = 0; i < STEM.STEMS.length; i += 2) {
      STEM_MAP.put((String) STEM.STEMS[i], (IBuiltInSymbol) STEM.STEMS[i + 1]);
    }
    for (int i = 0; i < STEMS1.length; i += 2) {
      STEM_MAP.put((String) STEMS1[i], (IBuiltInSymbol) STEMS1[i + 1]);
    }
  }
}
