## GraphCenter

``` 
GraphCenter(graph)
```

> compute the `graph` center. The center of a `graph` is the set of vertices of graph eccentricity equal to the `graph` radius.
 
See:
* [Wikipedia - Graph center](https://en.wikipedia.org/wiki/Graph_center)
* [Wikipedia - Graph theory](https://en.wikipedia.org/wiki/Graph_theory)
 
### Related terms 
[GraphDiameter](GraphDiameter.md), [GraphPeriphery](GraphPeriphery.md), [GraphRadius](GraphRadius.md), [AdjacencyMatrix](AdjacencyMatrix.md), [EdgeList](EdgeList.md),
[EdgeQ](EdgeQ.md), [EulerianGraphQ](EulerianGraphQ.md), [FindEulerianCycle](FindEulerianCycle.md), [FindHamiltonianCycle](FindHamiltonianCycle.md), [FindVertexCover](FindVertexCover.md), [FindShortestPath](FindShortestPath.md), [FindSpanningTree](FindSpanningTree.md), [Graph](Graph.md), [GraphQ](GraphQ.md), [HamiltonianGraphQ](HamiltonianGraphQ.md), 
[VertexEccentricity](VertexEccentricity.md), [VertexList](VertexList.md), [VertexQ](VertexQ.md) 

### Github

* [Implementation of GraphCenter](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/GraphFunctions.java#L232) 
