## EllipticF

```
EllipticF(z)
```

> returns the incomplete elliptic integral of the first kind. 
   

See
* [Wikipedia - Elliptic integral - Incomplete elliptic integral of the first kind)](https://en.wikipedia.org/wiki/Elliptic_integral#Incomplete_elliptic_integral_of_the_first_kind)
* [Fungrim - Legendre elliptic integrals](http://fungrim.org/topic/Legendre_elliptic_integrals/)

### Examples

```
>> EllipticF(17/2*Pi, m)
17*EllipticK(m)
```


### Github

* [Implementation of EllipticF](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/EllipticIntegrals.java#L230) 
