## LucasL

```
LucasL(n)
```

> gives the `n`th Lucas number.

```
LucasL(n, var)
```

> returns the `n`th Lucas polynomial for variable `var`.

Lucas numbers satisfy a recurrence relation similar to that of the Fibonacci sequence, in which each term is the sum of the preceding two. They are generated by choosing the initial values `LucasL(0) = 2` and `LucasL(1) = 1`.

See
* [Wikipedia - Lucas number](https://en.wikipedia.org/wiki/Lucas_number)
* [Wikipedia - Fibonacci polynomials](https://en.wikipedia.org/wiki/Fibonacci_polynomials)

### Examples

```
>> LucasL(10)
123

>> LucasL(50, x) 
2+625*x^2+32500*x^4+672750*x^6+7400250*x^8+50075025*x^10+227613750*x^12+  
736618125*x^14+1767883500*x^16+3241119750*x^18+4639918800*x^20+5272635000*x^22+  
4814145000*x^24+3562467300*x^26+2148789800*x^28+1059575660*x^30+427248250*x^32+ 
140512125*x^34+37469900*x^36+8021650*x^38+1357510*x^40+177375*x^42+17250*x^44+ 
1175*x^46+50*x^48+x^50
```
### Github
* [Implementation of LucasL](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/NumberTheory.java#L2993) 
