## EllipticPi

```
EllipticPi(n,m)
```

or 

```
EllipticPi(n,m,z)
```

> returns the complete elliptic integral of the third kind. 
   

See
* [Wikipedia - Elliptic integral - Complete elliptic integral of the third kind](https://en.wikipedia.org/wiki/Elliptic_integral#Complete_elliptic_integral_of_the_third_kind)
* [Fungrim - Legendre elliptic integrals](http://fungrim.org/topic/Legendre_elliptic_integrals/)

### Examples

```
>> EllipticPi(n,Pi/2,x)
EllipticPi(n,x) 
```

### Github
* [Implementation of EllipticPi](https://github.com/axkr/symja_android_library/blob/master/symja_android_library/matheclipse-core/src/main/java/org/matheclipse/core/builtin/EllipticIntegrals.java#L452) 
