# Contributing

Follow these guidelines if you'd like to contribute to the Symja project!

---

### Table of Contents

Read through these guidelines before you get started:

1. [Questions & Concerns](#questions-concerns)
2. [Issues & Bugs](#issues-bugs)
3. [Feature Requests](#feature-requests)
4. [Submitting Pull Requests](#submitting-pull-requests) 

### Questions & Concerns

If you have any questions about using or developing for this project, send a question in the [Gitter chat group][5] or directly via [email][1].

### Issues & Bugs

Submit an [issue][2] or [pull request][3] with a fix if you find any bugs in
the project. See [below](#submitting-pull-requests) for instructions on sending
in pull requests.

When submitting an issue or pull request, make sure you're as detailed as possible
and fill in all answers to questions asked in the templates. For example, an issue
that simply states "X/Y/Z isn't working!" will be ignored.

### Feature Requests

Submit an [issue][2] to request a new feature. Features fall into one of two
categories:

1. **Major**: Major changes should be discussed in the [Gitter chat group][5]. We're
always open to suggestions and will get back to you as soon as we can!
2. **Minor**: A minor feature can simply be added via a [pull request][3].

### Submitting Pull Requests

Before you do anything, make sure you check the current list of [pull requests][4]
to ensure you aren't duplicating anyone's work. Then, do the following:

1. Fork the repository and make your changes in a git branch: `git checkout -b my-branch master`
2. Make sure your feature or fix doesn't break the project! Test thoroughly.
3. Commit your changes, and be sure to leave a detailed commit message.
4. Push your branch to your forked repo on Github: `git push origin my-branch`
5. [Submit a pull request][3] and hold tight!
6. If any changes are requested by the project maintainers, make them and follow this process again until the changes are merged.

[1]: mailto:axelclk@gmail.com
[2]: https://github.com/axkr/symja_android_library/issues/new
[3]: https://github.com/axkr/symja_android_library/compare
[4]: https://github.com/axkr/symja_android_library/pulls
[5]: https://gitter.im/symja_android_library/Lobby