/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim;

import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.MaxEval;
import org.hipparchus.optim.MaxIter;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.util.Incrementor;

public abstract class BaseOptimizer<P> {
    protected Incrementor evaluations;
    protected Incrementor iterations;
    private final ConvergenceChecker<P> checker;

    protected BaseOptimizer(ConvergenceChecker<P> checker) {
        this(checker, 0, Integer.MAX_VALUE);
    }

    protected BaseOptimizer(ConvergenceChecker<P> checker, int maxEval, int maxIter) {
        this.checker = checker;
        this.evaluations = new Incrementor(maxEval);
        this.iterations = new Incrementor(maxIter);
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public ConvergenceChecker<P> getConvergenceChecker() {
        return this.checker;
    }

    public P optimize(OptimizationData ... optData) throws MathIllegalStateException {
        this.parseOptimizationData(optData);
        this.evaluations.reset();
        this.iterations.reset();
        return this.doOptimize();
    }

    public P optimize() throws MathIllegalStateException {
        this.evaluations.reset();
        this.iterations.reset();
        return this.doOptimize();
    }

    protected abstract P doOptimize();

    protected void incrementEvaluationCount() throws MathIllegalStateException {
        this.evaluations.increment();
    }

    protected void incrementIterationCount() throws MathIllegalStateException {
        this.iterations.increment();
    }

    protected void parseOptimizationData(OptimizationData ... optData) {
        for (OptimizationData data : optData) {
            if (data instanceof MaxEval) {
                this.evaluations = this.evaluations.withMaximalCount(((MaxEval)data).getMaxEval());
                continue;
            }
            if (!(data instanceof MaxIter)) continue;
            this.iterations = this.iterations.withMaximalCount(((MaxIter)data).getMaxIter());
        }
    }
}

