/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.util;

import java.util.Collection;
import org.logicng.configurations.Configuration;
import org.logicng.configurations.ConfigurationType;
import org.logicng.formulas.Variable;

public final class FormulaRandomizerConfig
extends Configuration {
    final long seed;
    final Collection<Variable> variables;
    final int numVars;
    final double weightConstant;
    final double weightPositiveLiteral;
    final double weightNegativeLiteral;
    final double weightOr;
    final double weightAnd;
    final double weightNot;
    final double weightImpl;
    final double weightEquiv;
    final int maximumOperandsAnd;
    final int maximumOperandsOr;
    final double weightPbc;
    final double weightPbcCoeffPositive;
    final double weightPbcCoeffNegative;
    final double weightPbcTypeLe;
    final double weightPbcTypeLt;
    final double weightPbcTypeGe;
    final double weightPbcTypeGt;
    final double weightPbcTypeEq;
    final int maximumOperandsPbc;
    final int maximumCoefficientPbc;
    final double weightCc;
    final double weightAmo;
    final double weightExo;
    final int maximumOperandsCc;

    public String toString() {
        StringBuilder sb = new StringBuilder("FormulaRandomizerConfig{").append(System.lineSeparator());
        sb.append("seed=").append(this.seed).append(System.lineSeparator());
        sb.append("variables=").append(this.variables).append(System.lineSeparator());
        sb.append("numVars=").append(this.numVars).append(System.lineSeparator());
        sb.append("weightConstant=").append(this.weightConstant).append(System.lineSeparator());
        sb.append("weightPositiveLiteral=").append(this.weightPositiveLiteral).append(System.lineSeparator());
        sb.append("weightNegativeLiteral=").append(this.weightNegativeLiteral).append(System.lineSeparator());
        sb.append("weightOr=").append(this.weightOr).append(System.lineSeparator());
        sb.append("weightAnd=").append(this.weightAnd).append(System.lineSeparator());
        sb.append("weightNot=").append(this.weightNot).append(System.lineSeparator());
        sb.append("weightImpl=").append(this.weightImpl).append(System.lineSeparator());
        sb.append("weightEquiv=").append(this.weightEquiv).append(System.lineSeparator());
        sb.append("maximumOperandsAnd=").append(this.maximumOperandsAnd).append(System.lineSeparator());
        sb.append("maximumOperandsOr=").append(this.maximumOperandsOr).append(System.lineSeparator());
        sb.append("weightPbc=").append(this.weightPbc).append(System.lineSeparator());
        sb.append("weightPbcCoeffPositive=").append(this.weightPbcCoeffPositive).append(System.lineSeparator());
        sb.append("weightPbcCoeffNegative=").append(this.weightPbcCoeffNegative).append(System.lineSeparator());
        sb.append("weightPbcTypeLe=").append(this.weightPbcTypeLe).append(System.lineSeparator());
        sb.append("weightPbcTypeLt=").append(this.weightPbcTypeLt).append(System.lineSeparator());
        sb.append("weightPbcTypeGe=").append(this.weightPbcTypeGe).append(System.lineSeparator());
        sb.append("weightPbcTypeGt=").append(this.weightPbcTypeGt).append(System.lineSeparator());
        sb.append("weightPbcTypeEq=").append(this.weightPbcTypeEq).append(System.lineSeparator());
        sb.append("maximumOperandsPbc=").append(this.maximumOperandsPbc).append(System.lineSeparator());
        sb.append("maximumCoefficientPbc=").append(this.maximumCoefficientPbc).append(System.lineSeparator());
        sb.append("weightCc=").append(this.weightCc).append(System.lineSeparator());
        sb.append("weightAmo=").append(this.weightAmo).append(System.lineSeparator());
        sb.append("weightExo=").append(this.weightExo).append(System.lineSeparator());
        sb.append("maximumOperandsCc=").append(this.maximumOperandsCc).append(System.lineSeparator());
        sb.append('}');
        return sb.toString();
    }

    private FormulaRandomizerConfig(Builder builder) {
        super(ConfigurationType.FORMULA_RANDOMIZER);
        this.seed = builder.seed;
        this.variables = builder.variables;
        this.numVars = builder.numVars;
        this.weightConstant = builder.weightConstant;
        this.weightPositiveLiteral = builder.weightPositiveLiteral;
        this.weightNegativeLiteral = builder.weightNegativeLiteral;
        this.weightOr = builder.weightOr;
        this.weightAnd = builder.weightAnd;
        this.weightNot = builder.weightNot;
        this.weightImpl = builder.weightImpl;
        this.weightEquiv = builder.weightEquiv;
        this.maximumOperandsAnd = builder.maximumOperandsAnd;
        this.maximumOperandsOr = builder.maximumOperandsOr;
        this.weightPbc = builder.weightPbc;
        this.weightPbcCoeffPositive = builder.weightPbcCoeffPositive;
        this.weightPbcCoeffNegative = builder.weightPbcCoeffNegative;
        this.weightPbcTypeLe = builder.weightPbcTypeLe;
        this.weightPbcTypeLt = builder.weightPbcTypeLt;
        this.weightPbcTypeGe = builder.weightPbcTypeGe;
        this.weightPbcTypeGt = builder.weightPbcTypeGt;
        this.weightPbcTypeEq = builder.weightPbcTypeEq;
        this.maximumOperandsPbc = builder.maximumOperandsPbc;
        this.maximumCoefficientPbc = builder.maximumCoefficientPbc;
        this.weightCc = builder.weightCc;
        this.weightAmo = builder.weightAmo;
        this.weightExo = builder.weightExo;
        this.maximumOperandsCc = builder.maximumOperandsCc;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long seed = 0L;
        private Collection<Variable> variables = null;
        private int numVars = 25;
        private double weightConstant = 0.1;
        private double weightPositiveLiteral = 1.0;
        private double weightNegativeLiteral = 1.0;
        private double weightOr = 30.0;
        private double weightAnd = 30.0;
        private double weightNot = 1.0;
        private double weightImpl = 1.0;
        private double weightEquiv = 1.0;
        private int maximumOperandsAnd = 5;
        private int maximumOperandsOr = 5;
        private double weightPbc = 0.0;
        private double weightPbcCoeffPositive = 1.0;
        private double weightPbcCoeffNegative = 0.2;
        private double weightPbcTypeLe = 0.2;
        private double weightPbcTypeLt = 0.2;
        private double weightPbcTypeGe = 0.2;
        private double weightPbcTypeGt = 0.2;
        private double weightPbcTypeEq = 0.2;
        private int maximumOperandsPbc = 5;
        private int maximumCoefficientPbc = 10;
        private double weightCc = 0.0;
        private double weightAmo = 0.0;
        private double weightExo = 0.0;
        private int maximumOperandsCc = 5;

        public FormulaRandomizerConfig build() {
            return new FormulaRandomizerConfig(this);
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder variables(Collection<Variable> variables) {
            this.variables = variables;
            return this;
        }

        public Builder numVars(int numVars) {
            this.numVars = numVars;
            return this;
        }

        public Builder weightConstant(double weightConstant) {
            this.weightConstant = weightConstant;
            return this;
        }

        public Builder weightPositiveLiteral(double weightPositiveLiteral) {
            this.weightPositiveLiteral = weightPositiveLiteral;
            return this;
        }

        public Builder weightNegativeLiteral(double weightNegativeLiteral) {
            this.weightNegativeLiteral = weightNegativeLiteral;
            return this;
        }

        public Builder weightOr(double weightOr) {
            this.weightOr = weightOr;
            return this;
        }

        public Builder weightAnd(double weightAnd) {
            this.weightAnd = weightAnd;
            return this;
        }

        public Builder weightNot(double weightNot) {
            this.weightNot = weightNot;
            return this;
        }

        public Builder weightImpl(double weightImpl) {
            this.weightImpl = weightImpl;
            return this;
        }

        public Builder weightEquiv(double weightEquiv) {
            this.weightEquiv = weightEquiv;
            return this;
        }

        public Builder maximumOperandsAnd(int maximumOperandsAnd) {
            this.maximumOperandsAnd = maximumOperandsAnd;
            return this;
        }

        public Builder maximumOperandsOr(int maximumOperandsOr) {
            this.maximumOperandsOr = maximumOperandsOr;
            return this;
        }

        public Builder weightPbc(double weightPbc) {
            this.weightPbc = weightPbc;
            return this;
        }

        public Builder weightPbcCoeffPositive(double weightPbcCoeffPositive) {
            this.weightPbcCoeffPositive = weightPbcCoeffPositive;
            return this;
        }

        public Builder weightPbcCoeffNegative(double weightPbcCoeffNegative) {
            this.weightPbcCoeffNegative = weightPbcCoeffNegative;
            return this;
        }

        public Builder weightPbcTypeLe(double weightPbcTypeLe) {
            this.weightPbcTypeLe = weightPbcTypeLe;
            return this;
        }

        public Builder weightPbcTypeLt(double weightPbcTypeLt) {
            this.weightPbcTypeLt = weightPbcTypeLt;
            return this;
        }

        public Builder weightPbcTypeGe(double weightPbcTypeGe) {
            this.weightPbcTypeGe = weightPbcTypeGe;
            return this;
        }

        public Builder weightPbcTypeGt(double weightPbcTypeGt) {
            this.weightPbcTypeGt = weightPbcTypeGt;
            return this;
        }

        public Builder weightPbcTypeEq(double weightPbcTypeEq) {
            this.weightPbcTypeEq = weightPbcTypeEq;
            return this;
        }

        public Builder maximumOperandsPbc(int maximumOperandsPbc) {
            this.maximumOperandsPbc = maximumOperandsPbc;
            return this;
        }

        public Builder maximumCoefficientPbc(int maximumCoefficientPbc) {
            this.maximumCoefficientPbc = maximumCoefficientPbc;
            return this;
        }

        public Builder weightCc(double weightCc) {
            this.weightCc = weightCc;
            return this;
        }

        public Builder weightAmo(double weightAmo) {
            this.weightAmo = weightAmo;
            return this;
        }

        public Builder weightExo(double weightExo) {
            this.weightExo = weightExo;
            return this;
        }

        public Builder maximumOperandsCc(int maximumOperandsCc) {
            this.maximumOperandsCc = maximumOperandsCc;
            return this;
        }
    }
}

