/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.util;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logicng.formulas.CType;
import org.logicng.formulas.Constant;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.util.FormulaRandomizerConfig;

public final class FormulaRandomizer {
    private final FormulaFactory f;
    private final FormulaRandomizerConfig config;
    private final Random random;
    private final Variable[] variables;
    private final FormulaTypeProbabilities formulaTypeProbabilities;
    private final CTypeProbabilities cTypeProbabilities;
    private final double phaseProbability;
    private final double coefficientNegativeProbability;

    public FormulaRandomizer(FormulaFactory f, FormulaRandomizerConfig config) {
        this.f = f;
        this.config = config;
        this.random = config.seed != 0L ? new Random(config.seed) : new Random();
        this.variables = FormulaRandomizer.generateVars(f, config);
        this.formulaTypeProbabilities = new FormulaTypeProbabilities(config);
        this.cTypeProbabilities = new CTypeProbabilities(config);
        this.phaseProbability = this.generatePhaseProbability(config);
        this.coefficientNegativeProbability = config.weightPbcCoeffNegative / (config.weightPbcCoeffPositive + config.weightPbcCoeffNegative);
    }

    public Constant constant() {
        return this.f.constant(this.random.nextBoolean());
    }

    public Variable variable() {
        return this.variables[this.random.nextInt(this.variables.length)];
    }

    public Literal literal() {
        return this.f.literal(this.variables[this.random.nextInt(this.variables.length)].name(), this.random.nextDouble() < this.phaseProbability);
    }

    public Formula atom() {
        double n = this.random.nextDouble() * this.formulaTypeProbabilities.exo;
        if (n < this.formulaTypeProbabilities.constant) {
            return this.constant();
        }
        if (n < this.formulaTypeProbabilities.literal) {
            return this.literal();
        }
        if (n < this.formulaTypeProbabilities.pbc) {
            return this.pbc();
        }
        if (n < this.formulaTypeProbabilities.cc) {
            return this.cc();
        }
        if (n < this.formulaTypeProbabilities.amo) {
            return this.amo();
        }
        return this.exo();
    }

    public Formula not(int maxDepth) {
        if (maxDepth == 0) {
            return this.atom();
        }
        Formula not = this.f.not(this.formula(maxDepth - 1));
        if (maxDepth >= 2 && not.type() != FType.NOT) {
            return this.not(maxDepth);
        }
        return not;
    }

    public Formula impl(int maxDepth) {
        if (maxDepth == 0) {
            return this.atom();
        }
        Formula implication = this.f.implication(this.formula(maxDepth - 1), this.formula(maxDepth - 1));
        if (implication.type() != FType.IMPL) {
            return this.impl(maxDepth);
        }
        return implication;
    }

    public Formula equiv(int maxDepth) {
        if (maxDepth == 0) {
            return this.atom();
        }
        Formula equiv = this.f.equivalence(this.formula(maxDepth - 1), this.formula(maxDepth - 1));
        if (equiv.type() != FType.EQUIV) {
            return this.equiv(maxDepth);
        }
        return equiv;
    }

    public Formula and(int maxDepth) {
        if (maxDepth == 0) {
            return this.atom();
        }
        Formula[] operands = new Formula[2 + this.random.nextInt(this.config.maximumOperandsAnd - 2)];
        for (int i = 0; i < operands.length; ++i) {
            operands[i] = this.formula(maxDepth - 1);
        }
        Formula formula = this.f.and(operands);
        if (formula.type() != FType.AND) {
            return this.and(maxDepth);
        }
        return formula;
    }

    public Formula or(int maxDepth) {
        if (maxDepth == 0) {
            return this.atom();
        }
        Formula[] operands = new Formula[2 + this.random.nextInt(this.config.maximumOperandsOr - 2)];
        for (int i = 0; i < operands.length; ++i) {
            operands[i] = this.formula(maxDepth - 1);
        }
        Formula formula = this.f.or(operands);
        if (formula.type() != FType.OR) {
            return this.or(maxDepth);
        }
        return formula;
    }

    public Formula cc() {
        Variable[] variables = this.variables();
        CType type = this.cType();
        int rhsBound = variables.length;
        if (type == CType.GT) {
            rhsBound = variables.length + 1;
        } else if (type == CType.LT) {
            rhsBound = variables.length + 1;
        }
        int rhsOffset = 0;
        if (type == CType.GT) {
            rhsOffset = -1;
        } else if (type == CType.LT) {
            rhsOffset = 1;
        }
        int rhs = rhsOffset + this.random.nextInt(rhsBound);
        Formula cc = this.f.cc(type, rhs, variables);
        if (cc.isConstantFormula()) {
            return this.cc();
        }
        return cc;
    }

    public Formula amo() {
        return this.f.amo(this.variables());
    }

    public Formula exo() {
        return this.f.exo(this.variables());
    }

    public Formula pbc() {
        int rhs;
        int numOps = this.random.nextInt(this.config.maximumOperandsPbc);
        Literal[] literals = new Literal[numOps];
        int[] coefficients = new int[numOps];
        int minSum = 0;
        int maxSum = 0;
        for (int i = 0; i < numOps; ++i) {
            literals[i] = this.literal();
            coefficients[i] = this.random.nextInt(this.config.maximumCoefficientPbc) + 1;
            if (this.random.nextDouble() < this.coefficientNegativeProbability) {
                minSum += coefficients[i];
                coefficients[i] = -coefficients[i];
                continue;
            }
            maxSum += coefficients[i];
        }
        CType type = this.cType();
        Formula pbc = this.f.pbc(type, rhs = this.random.nextInt(maxSum + minSum + 1) - minSum, literals, coefficients);
        if (pbc.isConstantFormula()) {
            return this.pbc();
        }
        return pbc;
    }

    public Formula formula(int maxDepth) {
        if (maxDepth == 0) {
            return this.atom();
        }
        double n = this.random.nextDouble();
        if (n < this.formulaTypeProbabilities.constant) {
            return this.constant();
        }
        if (n < this.formulaTypeProbabilities.literal) {
            return this.literal();
        }
        if (n < this.formulaTypeProbabilities.pbc) {
            return this.pbc();
        }
        if (n < this.formulaTypeProbabilities.cc) {
            return this.cc();
        }
        if (n < this.formulaTypeProbabilities.amo) {
            return this.amo();
        }
        if (n < this.formulaTypeProbabilities.exo) {
            return this.exo();
        }
        if (n < this.formulaTypeProbabilities.or) {
            return this.or(maxDepth);
        }
        if (n < this.formulaTypeProbabilities.and) {
            return this.and(maxDepth);
        }
        if (n < this.formulaTypeProbabilities.not) {
            return this.not(maxDepth);
        }
        if (n < this.formulaTypeProbabilities.impl) {
            return this.impl(maxDepth);
        }
        return this.equiv(maxDepth);
    }

    public List<Formula> constraintSet(int numConstraints, int maxDepth) {
        return Stream.generate(() -> this.formula(maxDepth)).limit(numConstraints).collect(Collectors.toList());
    }

    private Variable[] variables() {
        Variable[] variables = new Variable[this.random.nextInt(this.config.maximumOperandsCc - 1) + 2];
        for (int i = 0; i < variables.length; ++i) {
            variables[i] = this.variable();
        }
        return variables;
    }

    private static Variable[] generateVars(FormulaFactory f, FormulaRandomizerConfig config) {
        if (config.variables != null) {
            return config.variables.toArray(new Variable[0]);
        }
        Variable[] variables = new Variable[config.numVars];
        int decimalPlaces = (int)Math.ceil(Math.log10(config.numVars));
        for (int i = 0; i < variables.length; ++i) {
            variables[i] = f.variable("v" + String.format("%0" + decimalPlaces + "d", i));
        }
        return variables;
    }

    private double generatePhaseProbability(FormulaRandomizerConfig config) {
        return config.weightPositiveLiteral / (config.weightPositiveLiteral + config.weightNegativeLiteral);
    }

    private CType cType() {
        double n = this.random.nextDouble();
        CType type = n < this.cTypeProbabilities.le ? CType.LE : (n < this.cTypeProbabilities.lt ? CType.LT : (n < this.cTypeProbabilities.ge ? CType.GE : (n < this.cTypeProbabilities.gt ? CType.GT : CType.EQ)));
        return type;
    }

    private static class CTypeProbabilities {
        private final double le;
        private final double lt;
        private final double ge;
        private final double gt;
        private final double eq;

        private CTypeProbabilities(FormulaRandomizerConfig config) {
            double total = config.weightPbcTypeLe + config.weightPbcTypeLt + config.weightPbcTypeGe + config.weightPbcTypeGt + config.weightPbcTypeEq;
            this.le = config.weightPbcTypeLe / total;
            this.lt = this.le + config.weightPbcTypeLt / total;
            this.ge = this.lt + config.weightPbcTypeGe / total;
            this.gt = this.ge + config.weightPbcTypeGt / total;
            this.eq = this.gt + config.weightPbcTypeEq / total;
            assert (Math.abs(this.eq - 1.0) < 1.0E-8);
        }
    }

    private static class FormulaTypeProbabilities {
        private final double constant;
        private final double literal;
        private final double pbc;
        private final double cc;
        private final double amo;
        private final double exo;
        private final double or;
        private final double and;
        private final double not;
        private final double impl;
        private final double equiv;

        private FormulaTypeProbabilities(FormulaRandomizerConfig config) {
            double total = config.weightConstant + config.weightPositiveLiteral + config.weightNegativeLiteral + config.weightOr + config.weightAnd + config.weightNot + config.weightImpl + config.weightEquiv + config.weightPbc + config.weightCc + config.weightAmo + config.weightExo;
            this.constant = config.weightConstant / total;
            this.literal = this.constant + (config.weightPositiveLiteral + config.weightNegativeLiteral) / total;
            this.pbc = this.literal + config.weightPbc / total;
            this.cc = this.pbc + config.weightCc / total;
            this.amo = this.cc + config.weightAmo / total;
            this.exo = this.amo + config.weightExo / total;
            this.or = this.exo + config.weightOr / total;
            this.and = this.or + config.weightAnd / total;
            this.not = this.and + config.weightNot / total;
            this.impl = this.not + config.weightImpl / total;
            this.equiv = this.impl + config.weightEquiv / total;
            assert (Math.abs(this.equiv - 1.0) < 1.0E-8);
        }
    }
}

