/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class FormulaHelper {
    private FormulaHelper() {
    }

    public static SortedSet<Variable> variables(Formula ... formulas) {
        TreeSet<Variable> variables = new TreeSet<Variable>();
        for (Formula f : formulas) {
            variables.addAll(f.variables());
        }
        return variables;
    }

    public static SortedSet<Variable> variables(Collection<? extends Formula> formulas) {
        TreeSet<Variable> variables = new TreeSet<Variable>();
        for (Formula formula : formulas) {
            variables.addAll(formula.variables());
        }
        return variables;
    }

    public static SortedSet<Literal> literals(Formula ... formulas) {
        TreeSet<Literal> literals = new TreeSet<Literal>();
        for (Formula f : formulas) {
            literals.addAll(f.literals());
        }
        return literals;
    }

    public static SortedSet<Literal> literals(Collection<? extends Formula> formulas) {
        TreeSet<Literal> literals = new TreeSet<Literal>();
        for (Formula formula : formulas) {
            literals.addAll(formula.literals());
        }
        return literals;
    }

    public static <C extends Collection<Literal>> C negateLiterals(Collection<Literal> literals, Supplier<C> collectionFactory) {
        Collection result = (Collection)collectionFactory.get();
        for (Literal lit : literals) {
            result.add(lit.negate());
        }
        return (C)result;
    }

    public static <C extends Collection<Formula>> C negate(Collection<Formula> formulas, Supplier<C> collectionFactory) {
        Collection result = (Collection)collectionFactory.get();
        for (Formula formula : formulas) {
            result.add(formula.negate());
        }
        return (C)result;
    }

    public static Variable[] literalsAsVariables(Literal[] literals) {
        Variable[] vars = new Variable[literals.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = literals[i].variable();
        }
        return vars;
    }

    public static List<Formula> splitTopLevelAnd(Formula formula) {
        if (formula.type() == FType.AND) {
            ArrayList<Formula> ops = new ArrayList<Formula>();
            for (Formula op : formula) {
                ops.add(op);
            }
            return ops;
        }
        return Collections.singletonList(formula);
    }
}

