/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.logicng.formulas.CType;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;

public final class FormulaCornerCases {
    private final FormulaFactory f;
    private final Variable a;
    private final Variable b;
    private final Variable c;
    private final Literal na;
    private final Literal nb;
    private final Literal nc;

    public FormulaCornerCases(FormulaFactory f) {
        this.f = f;
        this.a = f.variable("a");
        this.b = f.variable("b");
        this.c = f.variable("c");
        this.na = this.a.negate();
        this.nb = this.b.negate();
        this.nc = this.c.negate();
    }

    public SortedSet<Variable> getVariables() {
        return new TreeSet<Variable>(Arrays.asList(this.a, this.b, this.c));
    }

    public List<Formula> cornerCases() {
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        formulas.add(this.f.falsum());
        formulas.add(this.f.not(this.f.falsum()));
        formulas.add(this.f.verum());
        formulas.add(this.f.not(this.f.verum()));
        formulas.add(this.a);
        formulas.add(this.a.negate());
        formulas.add(this.f.not(this.a));
        formulas.add(this.f.not(this.f.not(this.a)));
        formulas.add(this.f.not(this.f.not(this.f.not(this.a))));
        formulas.addAll(this.binaryCornerCases(FType.IMPL, this.a, this.b));
        formulas.addAll(this.binaryCornerCases(FType.EQUIV, this.a, this.b));
        formulas.addAll(this.naryCornerCases(FType.OR, this.a, this.b, this.c));
        formulas.addAll(this.naryCornerCases(FType.AND, this.a, this.b, this.c));
        formulas.addAll(this.pbcCornerCases(this.a, this.b, this.c));
        return formulas;
    }

    private List<Formula> binaryCornerCases(FType type, Variable a, Variable b) {
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        formulas.add(this.f.binaryOperator(type, this.f.verum(), this.f.verum()));
        formulas.add(this.f.binaryOperator(type, this.f.falsum(), this.f.verum()));
        formulas.add(this.f.binaryOperator(type, this.f.verum(), this.f.falsum()));
        formulas.add(this.f.binaryOperator(type, this.f.falsum(), this.f.falsum()));
        formulas.add(this.f.binaryOperator(type, this.f.verum(), a));
        formulas.add(this.f.binaryOperator(type, a, this.f.verum()));
        formulas.add(this.f.binaryOperator(type, this.f.verum(), this.na));
        formulas.add(this.f.binaryOperator(type, this.na, this.f.verum()));
        formulas.add(this.f.binaryOperator(type, this.f.falsum(), a));
        formulas.add(this.f.binaryOperator(type, a, this.f.falsum()));
        formulas.add(this.f.binaryOperator(type, this.f.falsum(), this.na));
        formulas.add(this.f.binaryOperator(type, this.na, this.f.falsum()));
        formulas.add(this.f.binaryOperator(type, a, a));
        formulas.add(this.f.binaryOperator(type, a, this.na));
        formulas.add(this.f.binaryOperator(type, this.na, a));
        formulas.add(this.f.binaryOperator(type, this.na, this.na));
        formulas.add(this.f.binaryOperator(type, a, b));
        formulas.add(this.f.binaryOperator(type, a, this.nb));
        formulas.add(this.f.binaryOperator(type, this.na, b));
        formulas.add(this.f.binaryOperator(type, this.na, this.nb));
        return formulas;
    }

    private List<Formula> naryCornerCases(FType type, Variable a, Variable b, Variable c) {
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        formulas.add(this.f.naryOperator(type, new Variable[0]));
        formulas.add(this.f.naryOperator(type, this.f.falsum()));
        formulas.add(this.f.naryOperator(type, this.f.verum()));
        formulas.add(this.f.naryOperator(type, this.f.falsum(), this.f.verum()));
        formulas.add(this.f.naryOperator(type, a));
        formulas.add(this.f.naryOperator(type, this.na));
        formulas.add(this.f.naryOperator(type, this.f.verum(), a));
        formulas.add(this.f.naryOperator(type, this.f.verum(), this.na));
        formulas.add(this.f.naryOperator(type, this.f.falsum(), this.na));
        formulas.add(this.f.naryOperator(type, this.f.falsum(), this.na));
        formulas.add(this.f.naryOperator(type, a, this.na));
        formulas.add(this.f.naryOperator(type, a, b));
        formulas.add(this.f.naryOperator(type, a, b, c));
        formulas.add(this.f.naryOperator(type, this.na, this.nb, this.nc));
        formulas.add(this.f.naryOperator(type, a, b, c, this.na));
        return formulas;
    }

    private List<Formula> pbcCornerCases(Variable a, Variable b, Variable c) {
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        for (CType type : CType.values()) {
            formulas.addAll(this.pbcCornerCases(type, a, b, c));
        }
        return formulas;
    }

    private List<Formula> pbcCornerCases(CType comparator, Variable a, Variable b, Variable c) {
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[0], new int[0], this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a}, new int[]{-1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a}, new int[]{0}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a}, new int[]{1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{this.na}, new int[]{-1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{this.na}, new int[]{0}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{this.na}, new int[]{1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, b}, new int[]{-1, -1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, b}, new int[]{0, 0}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, b}, new int[]{1, 1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, b}, new int[]{1, -1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, this.nb}, new int[]{-1, -1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, this.nb}, new int[]{0, 0}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, this.nb}, new int[]{1, 1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, this.nb}, new int[]{1, -1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, this.na}, new int[]{-1, -1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, this.na}, new int[]{0, 0}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, this.na}, new int[]{1, 1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, this.na}, new int[]{1, -1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, b, c}, new int[]{-1, -1, -1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, b, c}, new int[]{0, 0, 0}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, b, c}, new int[]{1, 1, 1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{a, b, c}, new int[]{-1, 1, -1}, this.f));
        formulas.addAll(this.pbcCornerCases(comparator, new Literal[]{this.na, this.nb, c}, new int[]{-1, 1, -1}, this.f));
        return formulas;
    }

    private List<Formula> pbcCornerCases(CType comparator, Literal[] literals, int[] coefficients, FormulaFactory f) {
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        for (Integer rhs : Arrays.asList(-1, 0, 1, -3, -4, 3, 4)) {
            formulas.add(f.pbc(comparator, (int)rhs, literals, coefficients));
        }
        return formulas;
    }
}

