/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <T> boolean nullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> Collection<T> nullSafe(Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    public static <T, C extends Collection<T>> C intersection(Collection<T> col1, Collection<T> col2, Supplier<C> collectionFactory) {
        if (col1 == null || col2 == null) {
            return (C)((Collection)collectionFactory.get());
        }
        Collection result = (Collection)collectionFactory.get();
        result.addAll(col1);
        result.retainAll(col2);
        return (C)result;
    }

    public static <T, C extends Collection<T>> C union(Collection<T> col1, Collection<T> col2, Supplier<C> collectionFactory) {
        Collection result = (Collection)collectionFactory.get();
        if (col1 != null) {
            result.addAll(col1);
        }
        if (col2 != null) {
            result.addAll(col2);
        }
        return (C)result;
    }

    public static <T> String mkString(Collection<T> collection, String delimiter) {
        return CollectionHelper.mkString(collection, "", delimiter, "");
    }

    public static <T> String mkString(Collection<T> collection, String prefix, String delimiter, String suffix) {
        StringBuilder sb = new StringBuilder(prefix);
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(delimiter);
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static <T> String mkString(T[] array, String delimiter) {
        return CollectionHelper.mkString(array, "", delimiter, "");
    }

    public static <T> String mkString(T[] array, String prefix, String delimiter, String suffix) {
        StringBuilder sb = new StringBuilder(prefix);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i == array.length - 1) continue;
            sb.append(delimiter);
        }
        sb.append(suffix);
        return sb.toString();
    }
}

