/*
 * Decompiled with CFR 0.152.
 */
package org.logicng.transformations.simplification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.logicng.formulas.FType;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.formulas.NAryOperator;

public final class NegationSimplifier
implements FormulaTransformation {
    @Override
    public Formula apply(Formula formula, boolean cache) {
        Formula nnf = formula.nnf();
        if (nnf.isAtomicFormula()) {
            return nnf;
        }
        MinimizationResult result = this.minimize(nnf, true);
        return this.getSmallestFormula(Arrays.asList(formula, nnf, result.positiveResult), true);
    }

    private MinimizationResult minimize(Formula formula, boolean topLevel) {
        FormulaFactory f = formula.factory();
        switch (formula.type()) {
            case LITERAL: {
                Literal lit = (Literal)formula;
                return new MinimizationResult(lit, lit.negate());
            }
            case OR: 
            case AND: {
                NAryOperator nary = (NAryOperator)formula;
                ArrayList<MinimizationResult> opResults = new ArrayList<MinimizationResult>(nary.numberOfOperands());
                for (Formula op : formula) {
                    opResults.add(this.minimize(op, false));
                }
                ArrayList<Formula> positiveOpResults = new ArrayList<Formula>(opResults.size());
                ArrayList<Formula> negativeOpResults = new ArrayList<Formula>(opResults.size());
                for (MinimizationResult result : opResults) {
                    positiveOpResults.add(result.getPositiveResult());
                    negativeOpResults.add(result.getNegativeResult());
                }
                Formula smallestPositive = this.findSmallestPositive(formula.type(), positiveOpResults, negativeOpResults, topLevel, f);
                Formula smallestNegative = this.findSmallestNegative(formula.type(), negativeOpResults, smallestPositive, topLevel, f);
                return new MinimizationResult(smallestPositive, smallestNegative);
            }
            case FALSE: 
            case TRUE: 
            case NOT: 
            case EQUIV: 
            case IMPL: 
            case PBC: {
                throw new IllegalStateException("Unexpected LogicNG formula type: " + (Object)((Object)formula.type()));
            }
        }
        throw new IllegalArgumentException("Unknown LogicNG formula type: " + (Object)((Object)formula.type()));
    }

    private Formula findSmallestPositive(FType type, List<Formula> positiveOpResults, List<Formula> negativeOpResults, boolean topLevel, FormulaFactory f) {
        Formula allPositive = f.naryOperator(type, positiveOpResults);
        ArrayList<Formula> smallerPositiveOps = new ArrayList<Formula>();
        ArrayList<Formula> smallerNegativeOps = new ArrayList<Formula>();
        for (int i = 0; i < positiveOpResults.size(); ++i) {
            Formula positiveOp = positiveOpResults.get(i);
            Formula negativeOp = negativeOpResults.get(i);
            if (this.formattedLength(positiveOp, false) < this.formattedLength(negativeOp, false)) {
                smallerPositiveOps.add(positiveOp);
                continue;
            }
            smallerNegativeOps.add(negativeOp);
        }
        Formula partialNegative = f.naryOperator(type, f.naryOperator(type, smallerPositiveOps), f.not(f.naryOperator(FType.dual(type), smallerNegativeOps)));
        return this.getSmallestFormula(Arrays.asList(allPositive, partialNegative), topLevel);
    }

    private Formula findSmallestNegative(FType type, List<Formula> negativeOpResults, Formula smallestPositive, boolean topLevel, FormulaFactory f) {
        Formula negation = f.not(smallestPositive);
        Formula flipped = f.naryOperator(FType.dual(type), negativeOpResults);
        return this.getSmallestFormula(Arrays.asList(negation, flipped), topLevel);
    }

    private Formula getSmallestFormula(Collection<Formula> formulas, boolean topLevel) {
        assert (!formulas.isEmpty());
        return formulas.stream().min(Comparator.comparingInt(formula -> this.formattedLength((Formula)formula, topLevel))).get();
    }

    private int formattedLength(Formula formula, boolean topLevel) {
        int length = formula.toString().length();
        if (!topLevel && formula.type() == FType.OR) {
            return length + 2;
        }
        return length;
    }

    private static class MinimizationResult {
        private final Formula positiveResult;
        private final Formula negativeResult;

        public MinimizationResult(Formula positiveResult, Formula negativeResult) {
            this.positiveResult = positiveResult;
            this.negativeResult = negativeResult;
        }

        public Formula getPositiveResult() {
            return this.positiveResult;
        }

        public Formula getNegativeResult() {
            return this.negativeResult;
        }
    }
}

